// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/apigateway/v1/apigateway_service.proto

#include "google/cloud/apigateway/v1/internal/api_gateway_option_defaults.h"
#include "google/cloud/apigateway/v1/api_gateway_connection.h"
#include "google/cloud/apigateway/v1/api_gateway_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace apigateway_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options ApiGatewayServiceDefaultOptions(Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_API_GATEWAY_SERVICE_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_API_GATEWAY_SERVICE_AUTHORITY",
      "apigateway.googleapis.com");
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options.has<apigateway_v1::ApiGatewayServiceRetryPolicyOption>()) {
    options.set<apigateway_v1::ApiGatewayServiceRetryPolicyOption>(
        apigateway_v1::ApiGatewayServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<apigateway_v1::ApiGatewayServiceBackoffPolicyOption>()) {
    options.set<apigateway_v1::ApiGatewayServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<apigateway_v1::ApiGatewayServicePollingPolicyOption>()) {
    options.set<apigateway_v1::ApiGatewayServicePollingPolicyOption>(
        GenericPollingPolicy<
            apigateway_v1::ApiGatewayServiceRetryPolicyOption::Type,
            apigateway_v1::ApiGatewayServiceBackoffPolicyOption::Type>(
            options.get<apigateway_v1::ApiGatewayServiceRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<apigateway_v1::
                       ApiGatewayServiceConnectionIdempotencyPolicyOption>()) {
    options
        .set<apigateway_v1::ApiGatewayServiceConnectionIdempotencyPolicyOption>(
            apigateway_v1::
                MakeDefaultApiGatewayServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apigateway_v1_internal
}  // namespace cloud
}  // namespace google
