// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/index_endpoint_service.proto

#include "google/cloud/aiplatform/v1/internal/index_endpoint_option_defaults.h"
#include "google/cloud/aiplatform/v1/index_endpoint_connection.h"
#include "google/cloud/aiplatform/v1/index_endpoint_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options IndexEndpointServiceDefaultOptions(std::string const& location,
                                           Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_INDEX_ENDPOINT_SERVICE_ENDPOINT",
      "", "GOOGLE_CLOUD_CPP_INDEX_ENDPOINT_SERVICE_AUTHORITY",
      absl::StrCat(location, "-", "aiplatform.googleapis.com"));
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options.has<aiplatform_v1::IndexEndpointServiceRetryPolicyOption>()) {
    options.set<aiplatform_v1::IndexEndpointServiceRetryPolicyOption>(
        aiplatform_v1::IndexEndpointServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<aiplatform_v1::IndexEndpointServiceBackoffPolicyOption>()) {
    options.set<aiplatform_v1::IndexEndpointServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<aiplatform_v1::IndexEndpointServicePollingPolicyOption>()) {
    options.set<aiplatform_v1::IndexEndpointServicePollingPolicyOption>(
        GenericPollingPolicy<
            aiplatform_v1::IndexEndpointServiceRetryPolicyOption::Type,
            aiplatform_v1::IndexEndpointServiceBackoffPolicyOption::Type>(
            options.get<aiplatform_v1::IndexEndpointServiceRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options
           .has<aiplatform_v1::
                    IndexEndpointServiceConnectionIdempotencyPolicyOption>()) {
    options.set<
        aiplatform_v1::IndexEndpointServiceConnectionIdempotencyPolicyOption>(
        aiplatform_v1::
            MakeDefaultIndexEndpointServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
