// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/accessapproval/v1/accessapproval.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ACCESSAPPROVAL_V1_INTERNAL_ACCESS_APPROVAL_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ACCESSAPPROVAL_V1_INTERNAL_ACCESS_APPROVAL_STUB_H

#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/accessapproval/v1/accessapproval.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace accessapproval_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class AccessApprovalStub {
 public:
  virtual ~AccessApprovalStub() = 0;

  virtual StatusOr<
      google::cloud::accessapproval::v1::ListApprovalRequestsResponse>
  ListApprovalRequests(
      grpc::ClientContext& context,
      google::cloud::accessapproval::v1::ListApprovalRequestsMessage const&
          request) = 0;

  virtual StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
  GetApprovalRequest(
      grpc::ClientContext& context,
      google::cloud::accessapproval::v1::GetApprovalRequestMessage const&
          request) = 0;

  virtual StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
  ApproveApprovalRequest(
      grpc::ClientContext& context,
      google::cloud::accessapproval::v1::ApproveApprovalRequestMessage const&
          request) = 0;

  virtual StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
  DismissApprovalRequest(
      grpc::ClientContext& context,
      google::cloud::accessapproval::v1::DismissApprovalRequestMessage const&
          request) = 0;

  virtual StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
  InvalidateApprovalRequest(
      grpc::ClientContext& context,
      google::cloud::accessapproval::v1::InvalidateApprovalRequestMessage const&
          request) = 0;

  virtual StatusOr<google::cloud::accessapproval::v1::AccessApprovalSettings>
  GetAccessApprovalSettings(
      grpc::ClientContext& context,
      google::cloud::accessapproval::v1::GetAccessApprovalSettingsMessage const&
          request) = 0;

  virtual StatusOr<google::cloud::accessapproval::v1::AccessApprovalSettings>
  UpdateAccessApprovalSettings(
      grpc::ClientContext& context,
      google::cloud::accessapproval::v1::
          UpdateAccessApprovalSettingsMessage const& request) = 0;

  virtual Status DeleteAccessApprovalSettings(
      grpc::ClientContext& context,
      google::cloud::accessapproval::v1::
          DeleteAccessApprovalSettingsMessage const& request) = 0;

  virtual StatusOr<
      google::cloud::accessapproval::v1::AccessApprovalServiceAccount>
  GetAccessApprovalServiceAccount(
      grpc::ClientContext& context,
      google::cloud::accessapproval::v1::
          GetAccessApprovalServiceAccountMessage const& request) = 0;
};

class DefaultAccessApprovalStub : public AccessApprovalStub {
 public:
  explicit DefaultAccessApprovalStub(
      std::unique_ptr<
          google::cloud::accessapproval::v1::AccessApproval::StubInterface>
          grpc_stub)
      : grpc_stub_(std::move(grpc_stub)) {}

  StatusOr<google::cloud::accessapproval::v1::ListApprovalRequestsResponse>
  ListApprovalRequests(
      grpc::ClientContext& context,
      google::cloud::accessapproval::v1::ListApprovalRequestsMessage const&
          request) override;

  StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
  GetApprovalRequest(
      grpc::ClientContext& context,
      google::cloud::accessapproval::v1::GetApprovalRequestMessage const&
          request) override;

  StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
  ApproveApprovalRequest(
      grpc::ClientContext& context,
      google::cloud::accessapproval::v1::ApproveApprovalRequestMessage const&
          request) override;

  StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
  DismissApprovalRequest(
      grpc::ClientContext& context,
      google::cloud::accessapproval::v1::DismissApprovalRequestMessage const&
          request) override;

  StatusOr<google::cloud::accessapproval::v1::ApprovalRequest>
  InvalidateApprovalRequest(
      grpc::ClientContext& context,
      google::cloud::accessapproval::v1::InvalidateApprovalRequestMessage const&
          request) override;

  StatusOr<google::cloud::accessapproval::v1::AccessApprovalSettings>
  GetAccessApprovalSettings(
      grpc::ClientContext& context,
      google::cloud::accessapproval::v1::GetAccessApprovalSettingsMessage const&
          request) override;

  StatusOr<google::cloud::accessapproval::v1::AccessApprovalSettings>
  UpdateAccessApprovalSettings(
      grpc::ClientContext& context,
      google::cloud::accessapproval::v1::
          UpdateAccessApprovalSettingsMessage const& request) override;

  Status DeleteAccessApprovalSettings(
      grpc::ClientContext& context,
      google::cloud::accessapproval::v1::
          DeleteAccessApprovalSettingsMessage const& request) override;

  StatusOr<google::cloud::accessapproval::v1::AccessApprovalServiceAccount>
  GetAccessApprovalServiceAccount(
      grpc::ClientContext& context,
      google::cloud::accessapproval::v1::
          GetAccessApprovalServiceAccountMessage const& request) override;

 private:
  std::unique_ptr<
      google::cloud::accessapproval::v1::AccessApproval::StubInterface>
      grpc_stub_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace accessapproval_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ACCESSAPPROVAL_V1_INTERNAL_ACCESS_APPROVAL_STUB_H
