﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/backup/Backup_EXPORTS.h>
#include <aws/backup/model/BackupPlan.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Backup {
namespace Model {
class GetBackupPlanFromJSONResult {
 public:
  AWS_BACKUP_API GetBackupPlanFromJSONResult() = default;
  AWS_BACKUP_API GetBackupPlanFromJSONResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_BACKUP_API GetBackupPlanFromJSONResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Specifies the body of a backup plan. Includes a <code>BackupPlanName</code>
   * and one or more sets of <code>Rules</code>.</p>
   */
  inline const BackupPlan& GetBackupPlan() const { return m_backupPlan; }
  template <typename BackupPlanT = BackupPlan>
  void SetBackupPlan(BackupPlanT&& value) {
    m_backupPlanHasBeenSet = true;
    m_backupPlan = std::forward<BackupPlanT>(value);
  }
  template <typename BackupPlanT = BackupPlan>
  GetBackupPlanFromJSONResult& WithBackupPlan(BackupPlanT&& value) {
    SetBackupPlan(std::forward<BackupPlanT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetBackupPlanFromJSONResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  BackupPlan m_backupPlan;
  bool m_backupPlanHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Backup
}  // namespace Aws
