/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/dataobj.h>
        #include <wx/image.h>
        #include <wx/dataobj.h>
        #include <wx/dataobj.h>
    PyObject* _wxImageDataObject_GetAllFormats(const wxImageDataObject* self, wxDataObject::Direction dir)
    {
        size_t count = self->GetFormatCount(dir);
        wxDataFormat* formats = new wxDataFormat[count];
        self->GetAllFormats(formats, dir);
        wxPyThreadBlocker blocker;
        PyObject* list = PyList_New(count);
        for (size_t i=0; i<count; i++) {
            wxDataFormat* format = new wxDataFormat(formats[i]);
            PyObject* obj = wxPyConstructObject((void*)format, wxT("wxDataFormat"), true);
            PyList_SET_ITEM(list, i, obj); // PyList_SET_ITEM steals a reference
        }
        delete [] formats;
        return list;
    }
    bool _wxImageDataObject_SetData(wxImageDataObject* self, const wxDataFormat* format, wxPyBuffer* buf)
    {
        return self->SetData(*format, buf->m_len, buf->m_ptr);
    }


class sipwxImageDataObject : public ::wxImageDataObject
{
public:
    sipwxImageDataObject(const ::wxImage&);
    virtual ~sipwxImageDataObject();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool SetData(const ::wxDataFormat&, size_t, const void*) SIP_OVERRIDE;
    void GetAllFormats(::wxDataFormat*, ::wxDataObject::Direction) const SIP_OVERRIDE;
    size_t GetFormatCount(::wxDataObject::Direction) const SIP_OVERRIDE;
    ::wxDataFormat GetPreferredFormat(::wxDataObject::Direction) const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxImageDataObject(const sipwxImageDataObject &);
    sipwxImageDataObject &operator = (const sipwxImageDataObject &);

    char sipPyMethods[4];
};

sipwxImageDataObject::sipwxImageDataObject(const ::wxImage& image): ::wxImageDataObject(image), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxImageDataObject::~sipwxImageDataObject()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

bool sipwxImageDataObject::SetData(const ::wxDataFormat& format, size_t len, const void*buf)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_SetData);

    if (!sipMeth)
        return ::wxImageDataObject::SetData(format, len, buf);

    extern bool sipVH__core_86(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxDataFormat&, size_t, const void*);

    return sipVH__core_86(sipGILState, 0, sipPySelf, sipMeth, format, len, buf);
}

void sipwxImageDataObject::GetAllFormats(::wxDataFormat*formats, ::wxDataObject::Direction dir) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetAllFormats);

    if (!sipMeth)
    {
        ::wxImageDataObject::GetAllFormats(formats, dir);
        return;
    }

    extern void sipVH__core_65(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::wxDataFormat*, ::wxDataObject::Direction);

    sipVH__core_65(sipGILState, 0, sipPySelf, sipMeth, formats, dir);
}

size_t sipwxImageDataObject::GetFormatCount(::wxDataObject::Direction dir) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[2]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetFormatCount);

    if (!sipMeth)
        return ::wxImageDataObject::GetFormatCount(dir);

    extern size_t sipVH__core_68(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::wxDataObject::Direction);

    return sipVH__core_68(sipGILState, 0, sipPySelf, sipMeth, dir);
}

::wxDataFormat sipwxImageDataObject::GetPreferredFormat(::wxDataObject::Direction dir) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[3]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetPreferredFormat);

    if (!sipMeth)
        return ::wxImageDataObject::GetPreferredFormat(dir);

    extern ::wxDataFormat sipVH__core_69(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::wxDataObject::Direction);

    return sipVH__core_69(sipGILState, 0, sipPySelf, sipMeth, dir);
}


PyDoc_STRVAR(doc_wxImageDataObject_GetImage, "GetImage() -> Image\n"
"\n"
"Returns the image associated with the data object.");

extern "C" {static PyObject *meth_wxImageDataObject_GetImage(PyObject *, PyObject *);}
static PyObject *meth_wxImageDataObject_GetImage(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxImageDataObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxImageDataObject, &sipCpp))
        {
            ::wxImage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxImage(sipCpp->GetImage());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxImage, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ImageDataObject, sipName_GetImage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxImageDataObject_SetImage, "SetImage(image) -> None\n"
"\n"
"Sets the image stored by the data object.");

extern "C" {static PyObject *meth_wxImageDataObject_SetImage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageDataObject_SetImage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxImage* image;
        ::wxImageDataObject *sipCpp;

        static const char *sipKwdList[] = {
            sipName_image,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxImageDataObject, &sipCpp, sipType_wxImage, &image))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetImage(*image);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ImageDataObject, sipName_SetImage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxImageDataObject_GetAllFormats, "GetAllFormats(dir=DataObject.Get)\n"
"\n"
"Returns a list of wx.DataFormat objects which this data object\n"
"supports transferring in the given direction.");

extern "C" {static PyObject *meth_wxImageDataObject_GetAllFormats(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageDataObject_GetAllFormats(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxDataObject::Direction dir = wxDataObject::Get;
        const ::wxImageDataObject *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dir,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|E", &sipSelf, sipType_wxImageDataObject, &sipCpp, sipType_wxDataObject_Direction, &dir))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxImageDataObject_GetAllFormats(sipCpp, dir);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_ImageDataObject, sipName_GetAllFormats, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxImageDataObject_SetData, "SetData(format, buf) -> bool");

extern "C" {static PyObject *meth_wxImageDataObject_SetData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageDataObject_SetData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxDataFormat* format;
        ::wxPyBuffer* buf;
        int bufState = 0;
        ::wxImageDataObject *sipCpp;

        static const char *sipKwdList[] = {
            sipName_format,
            sipName_buf,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J0", &sipSelf, sipType_wxImageDataObject, &sipCpp, sipType_wxDataFormat, &format, sipType_wxPyBuffer, &buf, &bufState))
        {
            bool sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxImageDataObject_SetData(sipCpp, format, buf);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(buf, sipType_wxPyBuffer, bufState);

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ImageDataObject, sipName_SetData, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxImageDataObject_GetFormatCount, "GetFormatCount(self, dir: DataObject.Direction = wxDataObject.Get) -> int");

extern "C" {static PyObject *meth_wxImageDataObject_GetFormatCount(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageDataObject_GetFormatCount(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxDataObject::Direction dir = ::wxDataObject::Get;
        const ::wxImageDataObject *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dir,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|E", &sipSelf, sipType_wxImageDataObject, &sipCpp, sipType_wxDataObject_Direction, &dir))
        {
            size_t sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxImageDataObject::GetFormatCount(dir) : sipCpp->GetFormatCount(dir));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ImageDataObject, sipName_GetFormatCount, doc_wxImageDataObject_GetFormatCount);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxImageDataObject_GetPreferredFormat, "GetPreferredFormat(self, dir: DataObject.Direction = wxDataObject.Get) -> DataFormat");

extern "C" {static PyObject *meth_wxImageDataObject_GetPreferredFormat(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageDataObject_GetPreferredFormat(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxDataObject::Direction dir = ::wxDataObject::Get;
        const ::wxImageDataObject *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dir,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|E", &sipSelf, sipType_wxImageDataObject, &sipCpp, sipType_wxDataObject_Direction, &dir))
        {
            ::wxDataFormat*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxDataFormat((sipSelfWasArg ? sipCpp->::wxImageDataObject::GetPreferredFormat(dir) : sipCpp->GetPreferredFormat(dir)));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxDataFormat, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ImageDataObject, sipName_GetPreferredFormat, doc_wxImageDataObject_GetPreferredFormat);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *meth_wxImageDataObject_GetDataSize(PyObject *, PyObject *);}
static PyObject *meth_wxImageDataObject_GetDataSize(PyObject *, PyObject *)
{

    sipNoMethod(SIP_NULLPTR, sipName_ImageDataObject, sipName_GetDataSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *meth_wxImageDataObject_GetDataHere(PyObject *, PyObject *);}
static PyObject *meth_wxImageDataObject_GetDataHere(PyObject *, PyObject *)
{

    sipNoMethod(SIP_NULLPTR, sipName_ImageDataObject, sipName_GetDataHere, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxImageDataObject(void *, const sipTypeDef *);}
static void *cast_wxImageDataObject(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxImageDataObject *sipCpp = reinterpret_cast< ::wxImageDataObject *>(sipCppV);

    if (targetType == sipType_wxImageDataObject)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxCustomDataObject)->ctd_cast(static_cast< ::wxCustomDataObject *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxImageDataObject(void *, int);}
static void release_wxImageDataObject(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxImageDataObject *>(sipCppV);
    else
        delete reinterpret_cast< ::wxImageDataObject *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxImageDataObject(Py_ssize_t);}
static void *array_wxImageDataObject(Py_ssize_t sipNrElem)
{
    return new ::wxImageDataObject[sipNrElem];
}


extern "C" {static void array_delete_wxImageDataObject(void *);}
static void array_delete_wxImageDataObject(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxImageDataObject *>(sipCpp);
}


extern "C" {static void dealloc_wxImageDataObject(sipSimpleWrapper *);}
static void dealloc_wxImageDataObject(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxImageDataObject *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxImageDataObject(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxImageDataObject(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxImageDataObject(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxImageDataObject *sipCpp = SIP_NULLPTR;

    {
        const ::wxImage& imagedef = wxNullImage;
        const ::wxImage* image = &imagedef;

        static const char *sipKwdList[] = {
            sipName_image,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J9", sipType_wxImage, &image))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxImageDataObject(*image);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxImageDataObject[] = {{100, 255, 1}};


static PyMethodDef methods_wxImageDataObject[] = {
    {sipName_GetAllFormats, SIP_MLMETH_CAST(meth_wxImageDataObject_GetAllFormats), METH_VARARGS|METH_KEYWORDS, doc_wxImageDataObject_GetAllFormats},
    {sipName_GetDataHere, meth_wxImageDataObject_GetDataHere, METH_VARARGS, SIP_NULLPTR},
    {sipName_GetDataSize, meth_wxImageDataObject_GetDataSize, METH_VARARGS, SIP_NULLPTR},
    {sipName_GetFormatCount, SIP_MLMETH_CAST(meth_wxImageDataObject_GetFormatCount), METH_VARARGS|METH_KEYWORDS, doc_wxImageDataObject_GetFormatCount},
    {sipName_GetImage, meth_wxImageDataObject_GetImage, METH_VARARGS, doc_wxImageDataObject_GetImage},
    {sipName_GetPreferredFormat, SIP_MLMETH_CAST(meth_wxImageDataObject_GetPreferredFormat), METH_VARARGS|METH_KEYWORDS, doc_wxImageDataObject_GetPreferredFormat},
    {sipName_SetData, SIP_MLMETH_CAST(meth_wxImageDataObject_SetData), METH_VARARGS|METH_KEYWORDS, doc_wxImageDataObject_SetData},
    {sipName_SetImage, SIP_MLMETH_CAST(meth_wxImageDataObject_SetImage), METH_VARARGS|METH_KEYWORDS, doc_wxImageDataObject_SetImage}
};

sipVariableDef variables_wxImageDataObject[] = {
    {PropertyVariable, sipName_Image, &methods_wxImageDataObject[4], &methods_wxImageDataObject[7], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_AllFormats, &methods_wxImageDataObject[0], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxImageDataObject, "ImageDataObject(image=NullImage) -> None\n"
"\n"
"wxImageDataObject is a specialization of wxDataObject for image data.");


sipClassTypeDef sipTypeDef__core_wxImageDataObject = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxImageDataObject,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_ImageDataObject,
        {0, 0, 1},
        8, methods_wxImageDataObject,
        0, SIP_NULLPTR,
        2, variables_wxImageDataObject,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxImageDataObject,
    -1,
    -1,
    supers_wxImageDataObject,
    SIP_NULLPTR,
    init_type_wxImageDataObject,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxImageDataObject,
    SIP_NULLPTR,
    array_wxImageDataObject,
    SIP_NULLPTR,
    release_wxImageDataObject,
    cast_wxImageDataObject,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxImageDataObject,
    sizeof (::wxImageDataObject),
};
