// generated by diplomat-tool
import { TimeZone } from "./TimeZone.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * See the [Rust documentation for `TimeZoneIter`](https://docs.rs/icu/latest/icu/time/zone/iana/struct.TimeZoneIter.html) for more information.
 */
const TimeZoneIterator_box_destroy_registry = new FinalizationRegistry((ptr) => {
    wasm.icu4x_TimeZoneIterator_destroy_mv1(ptr);
});

export class TimeZoneIterator {
    // Internal ptr reference:
    #ptr = null;

    // Lifetimes are only to keep dependencies alive.
    // Since JS won't garbage collect until there are no incoming edges.
    #selfEdge = [];
    #aEdge = [];

    #internalConstructor(symbol, ptr, selfEdge, aEdge) {
        if (symbol !== diplomatRuntime.internalConstructor) {
            console.error("TimeZoneIterator is an Opaque type. You cannot call its constructor.");
            return;
        }
        this.#aEdge = aEdge;
        this.#ptr = ptr;
        this.#selfEdge = selfEdge;

        // Are we being borrowed? If not, we can register.
        if (this.#selfEdge.length === 0) {
            TimeZoneIterator_box_destroy_registry.register(this, this.#ptr);
        }

        return this;
    }
    get ffiValue() {
        return this.#ptr;
    }


    /**
     * See the [Rust documentation for `next`](https://docs.rs/icu/latest/icu/time/zone/iana/struct.TimeZoneIter.html#method.next) for more information.
     */
    #iteratorNext() {

        const result = wasm.icu4x_TimeZoneIterator_next_mv1(this.ffiValue);

        try {
            return result === 0 ? null : new TimeZone(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    next(){
        const out = this.#iteratorNext();

        return {
            value: out,
            done: out === null,
        };
    }

    constructor(symbol, ptr, selfEdge, aEdge) {
        return this.#internalConstructor(...arguments)
    }
}