// generated by diplomat-tool
import { IsoDate } from "./IsoDate.mjs"
import { IsoDateTime } from "./IsoDateTime.mjs"
import { Time } from "./Time.mjs"
import { TimeZone } from "./TimeZone.mjs"
import { TimeZoneVariant } from "./TimeZoneVariant.mjs"
import { UtcOffset } from "./UtcOffset.mjs"
import { VariantOffsetsCalculator } from "./VariantOffsetsCalculator.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * See the [Rust documentation for `TimeZoneInfo`](https://docs.rs/icu/latest/icu/time/struct.TimeZoneInfo.html) for more information.
 */
const TimeZoneInfo_box_destroy_registry = new FinalizationRegistry((ptr) => {
    wasm.icu4x_TimeZoneInfo_destroy_mv1(ptr);
});

export class TimeZoneInfo {
    // Internal ptr reference:
    #ptr = null;

    // Lifetimes are only to keep dependencies alive.
    // Since JS won't garbage collect until there are no incoming edges.
    #selfEdge = [];

    #internalConstructor(symbol, ptr, selfEdge) {
        if (symbol !== diplomatRuntime.internalConstructor) {
            console.error("TimeZoneInfo is an Opaque type. You cannot call its constructor.");
            return;
        }
        this.#ptr = ptr;
        this.#selfEdge = selfEdge;

        // Are we being borrowed? If not, we can register.
        if (this.#selfEdge.length === 0) {
            TimeZoneInfo_box_destroy_registry.register(this, this.#ptr);
        }

        return this;
    }
    get ffiValue() {
        return this.#ptr;
    }


    /**
     * Creates a time zone for UTC (Coordinated Universal Time).
     *
     * See the [Rust documentation for `utc`](https://docs.rs/icu/latest/icu/time/struct.TimeZoneInfo.html#method.utc) for more information.
     */
    static utc() {

        const result = wasm.icu4x_TimeZoneInfo_utc_mv1();

        try {
            return new TimeZoneInfo(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    /**
     * Creates a time zone info from parts.
     */
    #defaultConstructor(id, offset, variant) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();


        const result = wasm.icu4x_TimeZoneInfo_from_parts_mv1(id.ffiValue, offset.ffiValue ?? 0, ...diplomatRuntime.optionToArgsForCalling(variant, 4, 4, (arrayBuffer, offset, jsValue) => [diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, jsValue.ffiValue, Int32Array)]));

        try {
            return new TimeZoneInfo(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
            functionCleanupArena.free();

        }
    }

    /**
     * See the [Rust documentation for `id`](https://docs.rs/icu/latest/icu/time/struct.TimeZoneInfo.html#method.id) for more information.
     */
    id() {

        const result = wasm.icu4x_TimeZoneInfo_id_mv1(this.ffiValue);

        try {
            return new TimeZone(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    /**
     * Sets the datetime at which to interpret the time zone
     * for display name lookup.
     *
     * Notes:
     *
     * - If not set, the formatting datetime is used if possible.
     * - The constraints are the same as with `ZoneNameTimestamp` in Rust.
     * - Set to year 1000 or 9999 for a reference far in the past or future.
     *
     * See the [Rust documentation for `at_date_time_iso`](https://docs.rs/icu/latest/icu/time/struct.TimeZoneInfo.html#method.at_date_time_iso) for more information.
     *
     * Additional information: [1](https://docs.rs/icu/latest/icu/time/zone/struct.ZoneNameTimestamp.html)
     */
    atDateTimeIso(date, time) {

        const result = wasm.icu4x_TimeZoneInfo_at_date_time_iso_mv1(this.ffiValue, date.ffiValue, time.ffiValue);

        try {
            return new TimeZoneInfo(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    /**
     * See the [Rust documentation for `zone_name_timestamp`](https://docs.rs/icu/latest/icu/time/struct.TimeZoneInfo.html#method.zone_name_timestamp) for more information.
     */
    zoneNameDateTime() {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 9, 4, true);


        const result = wasm.icu4x_TimeZoneInfo_zone_name_date_time_mv1(diplomatReceive.buffer, this.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return IsoDateTime._fromFFI(diplomatRuntime.internalConstructor, diplomatReceive.buffer);
        }

        finally {
            diplomatReceive.free();
        }
    }

    /**
     * See the [Rust documentation for `with_variant`](https://docs.rs/icu/latest/icu/time/struct.TimeZoneInfo.html#method.with_variant) for more information.
     */
    withVariant(timeVariant) {

        const result = wasm.icu4x_TimeZoneInfo_with_variant_mv1(this.ffiValue, timeVariant.ffiValue);

        try {
            return new TimeZoneInfo(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    /**
     * Infers the zone variant.
     *
     * Requires the offset and local time to be set.
     *
     * See the [Rust documentation for `infer_variant`](https://docs.rs/icu/latest/icu/time/struct.TimeZoneInfo.html#method.infer_variant) for more information.
     *
     * Additional information: [1](https://docs.rs/icu/latest/icu/time/zone/enum.TimeZoneVariant.html)
     */
    inferVariant(offsetCalculator) {

        const result = wasm.icu4x_TimeZoneInfo_infer_variant_mv1(this.ffiValue, offsetCalculator.ffiValue);

        try {
            return result === 1;
        }

        finally {
        }
    }

    /**
     * See the [Rust documentation for `variant`](https://docs.rs/icu/latest/icu/time/struct.TimeZoneInfo.html#method.variant) for more information.
     */
    variant() {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_TimeZoneInfo_variant_mv1(diplomatReceive.buffer, this.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new TimeZoneVariant(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
        }

        finally {
            diplomatReceive.free();
        }
    }

    constructor(id, offset, variant) {
        if (arguments[0] === diplomatRuntime.exposeConstructor) {
            return this.#internalConstructor(...Array.prototype.slice.call(arguments, 1));
        } else if (arguments[0] === diplomatRuntime.internalConstructor) {
            return this.#internalConstructor(...arguments);
        } else {
            return this.#defaultConstructor(...arguments);
        }
    }
}