// generated by diplomat-tool
import { Decimal } from "./Decimal.mjs"
import { DecimalParseError } from "./DecimalParseError.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * See the [Rust documentation for `PluralOperands`](https://docs.rs/icu/latest/icu/plurals/struct.PluralOperands.html) for more information.
 */
const PluralOperands_box_destroy_registry = new FinalizationRegistry((ptr) => {
    wasm.icu4x_PluralOperands_destroy_mv1(ptr);
});

export class PluralOperands {
    // Internal ptr reference:
    #ptr = null;

    // Lifetimes are only to keep dependencies alive.
    // Since JS won't garbage collect until there are no incoming edges.
    #selfEdge = [];

    #internalConstructor(symbol, ptr, selfEdge) {
        if (symbol !== diplomatRuntime.internalConstructor) {
            console.error("PluralOperands is an Opaque type. You cannot call its constructor.");
            return;
        }
        this.#ptr = ptr;
        this.#selfEdge = selfEdge;

        // Are we being borrowed? If not, we can register.
        if (this.#selfEdge.length === 0) {
            PluralOperands_box_destroy_registry.register(this, this.#ptr);
        }

        return this;
    }
    get ffiValue() {
        return this.#ptr;
    }


    /**
     * Construct for a given string representing a number
     *
     * See the [Rust documentation for `from_str`](https://docs.rs/icu/latest/icu/plurals/struct.PluralOperands.html#method.from_str) for more information.
     */
    static fromString(s) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const sSlice = diplomatRuntime.DiplomatBuf.str8(wasm, s);
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_PluralOperands_from_string_mv1(diplomatReceive.buffer, ...sSlice.splat());

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DecimalParseError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DecimalParseError: ' + cause.value, { cause });
            }
            return new PluralOperands(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            functionCleanupArena.free();

            diplomatReceive.free();
        }
    }

    /**
     * Construct for a given integer
     */
    static fromBigInt(i) {

        const result = wasm.icu4x_PluralOperands_from_int64_mv1(i);

        try {
            return new PluralOperands(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    /**
     * Construct from a FixedDecimal
     *
     * Retains at most 18 digits each from the integer and fraction parts.
     */
    static fromFixedDecimal(x) {

        const result = wasm.icu4x_PluralOperands_from_fixed_decimal_mv1(x.ffiValue);

        try {
            return new PluralOperands(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    constructor(symbol, ptr, selfEdge) {
        return this.#internalConstructor(...arguments)
    }
}