// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/servicedirectory/v1/registration_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEDIRECTORY_V1_REGISTRATION_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEDIRECTORY_V1_REGISTRATION_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/servicedirectory/v1/registration_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace servicedirectory_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class RegistrationServiceConnectionIdempotencyPolicy {
 public:
  virtual ~RegistrationServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<RegistrationServiceConnectionIdempotencyPolicy>
  clone() const;

  virtual google::cloud::Idempotency CreateNamespace(
      google::cloud::servicedirectory::v1::CreateNamespaceRequest const&
          request);

  virtual google::cloud::Idempotency ListNamespaces(
      google::cloud::servicedirectory::v1::ListNamespacesRequest request);

  virtual google::cloud::Idempotency GetNamespace(
      google::cloud::servicedirectory::v1::GetNamespaceRequest const& request);

  virtual google::cloud::Idempotency UpdateNamespace(
      google::cloud::servicedirectory::v1::UpdateNamespaceRequest const&
          request);

  virtual google::cloud::Idempotency DeleteNamespace(
      google::cloud::servicedirectory::v1::DeleteNamespaceRequest const&
          request);

  virtual google::cloud::Idempotency CreateService(
      google::cloud::servicedirectory::v1::CreateServiceRequest const& request);

  virtual google::cloud::Idempotency ListServices(
      google::cloud::servicedirectory::v1::ListServicesRequest request);

  virtual google::cloud::Idempotency GetService(
      google::cloud::servicedirectory::v1::GetServiceRequest const& request);

  virtual google::cloud::Idempotency UpdateService(
      google::cloud::servicedirectory::v1::UpdateServiceRequest const& request);

  virtual google::cloud::Idempotency DeleteService(
      google::cloud::servicedirectory::v1::DeleteServiceRequest const& request);

  virtual google::cloud::Idempotency CreateEndpoint(
      google::cloud::servicedirectory::v1::CreateEndpointRequest const&
          request);

  virtual google::cloud::Idempotency ListEndpoints(
      google::cloud::servicedirectory::v1::ListEndpointsRequest request);

  virtual google::cloud::Idempotency GetEndpoint(
      google::cloud::servicedirectory::v1::GetEndpointRequest const& request);

  virtual google::cloud::Idempotency UpdateEndpoint(
      google::cloud::servicedirectory::v1::UpdateEndpointRequest const&
          request);

  virtual google::cloud::Idempotency DeleteEndpoint(
      google::cloud::servicedirectory::v1::DeleteEndpointRequest const&
          request);

  virtual google::cloud::Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request);
};

std::unique_ptr<RegistrationServiceConnectionIdempotencyPolicy>
MakeDefaultRegistrationServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicedirectory_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEDIRECTORY_V1_REGISTRATION_CONNECTION_IDEMPOTENCY_POLICY_H
