// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/oslogin/v1/oslogin.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSLOGIN_V1_MOCKS_MOCK_OS_LOGIN_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSLOGIN_V1_MOCKS_MOCK_OS_LOGIN_CONNECTION_H

#include "google/cloud/oslogin/v1/os_login_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace oslogin_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `OsLoginServiceConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `OsLoginServiceClient`. To do so,
 * construct an object of type `OsLoginServiceClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockOsLoginServiceConnection
    : public oslogin_v1::OsLoginServiceConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      StatusOr<google::cloud::oslogin::common::SshPublicKey>,
      CreateSshPublicKey,
      (google::cloud::oslogin::v1::CreateSshPublicKeyRequest const& request),
      (override));

  MOCK_METHOD(
      Status, DeletePosixAccount,
      (google::cloud::oslogin::v1::DeletePosixAccountRequest const& request),
      (override));

  MOCK_METHOD(
      Status, DeleteSshPublicKey,
      (google::cloud::oslogin::v1::DeleteSshPublicKeyRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::oslogin::v1::LoginProfile>, GetLoginProfile,
      (google::cloud::oslogin::v1::GetLoginProfileRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::oslogin::common::SshPublicKey>, GetSshPublicKey,
      (google::cloud::oslogin::v1::GetSshPublicKeyRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::oslogin::v1::ImportSshPublicKeyResponse>,
      ImportSshPublicKey,
      (google::cloud::oslogin::v1::ImportSshPublicKeyRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::oslogin::common::SshPublicKey>,
      UpdateSshPublicKey,
      (google::cloud::oslogin::v1::UpdateSshPublicKeyRequest const& request),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace oslogin_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSLOGIN_V1_MOCKS_MOCK_OS_LOGIN_CONNECTION_H
