// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkservices/v1/dep.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_INTERNAL_DEP_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_INTERNAL_DEP_STUB_H

#include "google/cloud/completion_queue.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/networkservices/v1/dep.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace networkservices_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DepServiceStub {
 public:
  virtual ~DepServiceStub() = 0;

  virtual StatusOr<
      google::cloud::networkservices::v1::ListLbTrafficExtensionsResponse>
  ListLbTrafficExtensions(
      grpc::ClientContext& context, Options const& options,
      google::cloud::networkservices::v1::ListLbTrafficExtensionsRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>
  GetLbTrafficExtension(
      grpc::ClientContext& context, Options const& options,
      google::cloud::networkservices::v1::GetLbTrafficExtensionRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncCreateLbTrafficExtension(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::networkservices::v1::CreateLbTrafficExtensionRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> CreateLbTrafficExtension(
      grpc::ClientContext& context, Options options,
      google::cloud::networkservices::v1::CreateLbTrafficExtensionRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncUpdateLbTrafficExtension(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::networkservices::v1::UpdateLbTrafficExtensionRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> UpdateLbTrafficExtension(
      grpc::ClientContext& context, Options options,
      google::cloud::networkservices::v1::UpdateLbTrafficExtensionRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncDeleteLbTrafficExtension(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::networkservices::v1::DeleteLbTrafficExtensionRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> DeleteLbTrafficExtension(
      grpc::ClientContext& context, Options options,
      google::cloud::networkservices::v1::DeleteLbTrafficExtensionRequest const&
          request) = 0;

  virtual StatusOr<
      google::cloud::networkservices::v1::ListLbRouteExtensionsResponse>
  ListLbRouteExtensions(
      grpc::ClientContext& context, Options const& options,
      google::cloud::networkservices::v1::ListLbRouteExtensionsRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::networkservices::v1::LbRouteExtension>
  GetLbRouteExtension(
      grpc::ClientContext& context, Options const& options,
      google::cloud::networkservices::v1::GetLbRouteExtensionRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncCreateLbRouteExtension(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::networkservices::v1::CreateLbRouteExtensionRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> CreateLbRouteExtension(
      grpc::ClientContext& context, Options options,
      google::cloud::networkservices::v1::CreateLbRouteExtensionRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncUpdateLbRouteExtension(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> UpdateLbRouteExtension(
      grpc::ClientContext& context, Options options,
      google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncDeleteLbRouteExtension(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> DeleteLbRouteExtension(
      grpc::ClientContext& context, Options options,
      google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) = 0;

  virtual future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) = 0;
};

class DefaultDepServiceStub : public DepServiceStub {
 public:
  DefaultDepServiceStub(
      std::unique_ptr<
          google::cloud::networkservices::v1::DepService::StubInterface>
          grpc_stub,
      std::unique_ptr<google::longrunning::Operations::StubInterface>
          operations)
      : grpc_stub_(std::move(grpc_stub)), operations_(std::move(operations)) {}

  StatusOr<google::cloud::networkservices::v1::ListLbTrafficExtensionsResponse>
  ListLbTrafficExtensions(
      grpc::ClientContext& context, Options const& options,
      google::cloud::networkservices::v1::ListLbTrafficExtensionsRequest const&
          request) override;

  StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>
  GetLbTrafficExtension(
      grpc::ClientContext& context, Options const& options,
      google::cloud::networkservices::v1::GetLbTrafficExtensionRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>>
  AsyncCreateLbTrafficExtension(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::networkservices::v1::CreateLbTrafficExtensionRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateLbTrafficExtension(
      grpc::ClientContext& context, Options options,
      google::cloud::networkservices::v1::CreateLbTrafficExtensionRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>>
  AsyncUpdateLbTrafficExtension(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::networkservices::v1::UpdateLbTrafficExtensionRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> UpdateLbTrafficExtension(
      grpc::ClientContext& context, Options options,
      google::cloud::networkservices::v1::UpdateLbTrafficExtensionRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>>
  AsyncDeleteLbTrafficExtension(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::networkservices::v1::DeleteLbTrafficExtensionRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteLbTrafficExtension(
      grpc::ClientContext& context, Options options,
      google::cloud::networkservices::v1::DeleteLbTrafficExtensionRequest const&
          request) override;

  StatusOr<google::cloud::networkservices::v1::ListLbRouteExtensionsResponse>
  ListLbRouteExtensions(
      grpc::ClientContext& context, Options const& options,
      google::cloud::networkservices::v1::ListLbRouteExtensionsRequest const&
          request) override;

  StatusOr<google::cloud::networkservices::v1::LbRouteExtension>
  GetLbRouteExtension(
      grpc::ClientContext& context, Options const& options,
      google::cloud::networkservices::v1::GetLbRouteExtensionRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateLbRouteExtension(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::networkservices::v1::CreateLbRouteExtensionRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateLbRouteExtension(
      grpc::ClientContext& context, Options options,
      google::cloud::networkservices::v1::CreateLbRouteExtensionRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateLbRouteExtension(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> UpdateLbRouteExtension(
      grpc::ClientContext& context, Options options,
      google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteLbRouteExtension(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteLbRouteExtension(
      grpc::ClientContext& context, Options options,
      google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::unique_ptr<google::cloud::networkservices::v1::DepService::StubInterface>
      grpc_stub_;
  std::unique_ptr<google::longrunning::Operations::StubInterface> operations_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkservices_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_INTERNAL_DEP_STUB_H
