// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/conversation_model.proto

#include "google/cloud/dialogflow_es/conversation_models_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_es {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ConversationModelsClient::ConversationModelsClient(
    std::shared_ptr<ConversationModelsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ConversationModelsClient::~ConversationModelsClient() = default;

future<StatusOr<google::cloud::dialogflow::v2::ConversationModel>>
ConversationModelsClient::CreateConversationModel(
    std::string const& parent,
    google::cloud::dialogflow::v2::ConversationModel const& conversation_model,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::CreateConversationModelRequest request;
  request.set_parent(parent);
  *request.mutable_conversation_model() = conversation_model;
  return connection_->CreateConversationModel(request);
}

StatusOr<google::longrunning::Operation>
ConversationModelsClient::CreateConversationModel(
    NoAwaitTag, std::string const& parent,
    google::cloud::dialogflow::v2::ConversationModel const& conversation_model,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::CreateConversationModelRequest request;
  request.set_parent(parent);
  *request.mutable_conversation_model() = conversation_model;
  return connection_->CreateConversationModel(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationModel>>
ConversationModelsClient::CreateConversationModel(
    google::cloud::dialogflow::v2::CreateConversationModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateConversationModel(request);
}

StatusOr<google::longrunning::Operation>
ConversationModelsClient::CreateConversationModel(
    NoAwaitTag,
    google::cloud::dialogflow::v2::CreateConversationModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateConversationModel(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationModel>>
ConversationModelsClient::CreateConversationModel(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateConversationModel(operation);
}

StatusOr<google::cloud::dialogflow::v2::ConversationModel>
ConversationModelsClient::GetConversationModel(std::string const& name,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::GetConversationModelRequest request;
  request.set_name(name);
  return connection_->GetConversationModel(request);
}

StatusOr<google::cloud::dialogflow::v2::ConversationModel>
ConversationModelsClient::GetConversationModel(
    google::cloud::dialogflow::v2::GetConversationModelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetConversationModel(request);
}

StreamRange<google::cloud::dialogflow::v2::ConversationModel>
ConversationModelsClient::ListConversationModels(std::string const& parent,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::ListConversationModelsRequest request;
  request.set_parent(parent);
  return connection_->ListConversationModels(request);
}

StreamRange<google::cloud::dialogflow::v2::ConversationModel>
ConversationModelsClient::ListConversationModels(
    google::cloud::dialogflow::v2::ListConversationModelsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListConversationModels(std::move(request));
}

future<StatusOr<
    google::cloud::dialogflow::v2::DeleteConversationModelOperationMetadata>>
ConversationModelsClient::DeleteConversationModel(std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::DeleteConversationModelRequest request;
  request.set_name(name);
  return connection_->DeleteConversationModel(request);
}

StatusOr<google::longrunning::Operation>
ConversationModelsClient::DeleteConversationModel(NoAwaitTag,
                                                  std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::DeleteConversationModelRequest request;
  request.set_name(name);
  return connection_->DeleteConversationModel(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::dialogflow::v2::DeleteConversationModelOperationMetadata>>
ConversationModelsClient::DeleteConversationModel(
    google::cloud::dialogflow::v2::DeleteConversationModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteConversationModel(request);
}

StatusOr<google::longrunning::Operation>
ConversationModelsClient::DeleteConversationModel(
    NoAwaitTag,
    google::cloud::dialogflow::v2::DeleteConversationModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteConversationModel(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::dialogflow::v2::DeleteConversationModelOperationMetadata>>
ConversationModelsClient::DeleteConversationModel(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteConversationModel(operation);
}

future<StatusOr<
    google::cloud::dialogflow::v2::DeployConversationModelOperationMetadata>>
ConversationModelsClient::DeployConversationModel(
    google::cloud::dialogflow::v2::DeployConversationModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeployConversationModel(request);
}

StatusOr<google::longrunning::Operation>
ConversationModelsClient::DeployConversationModel(
    NoAwaitTag,
    google::cloud::dialogflow::v2::DeployConversationModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeployConversationModel(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::dialogflow::v2::DeployConversationModelOperationMetadata>>
ConversationModelsClient::DeployConversationModel(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeployConversationModel(operation);
}

future<StatusOr<
    google::cloud::dialogflow::v2::UndeployConversationModelOperationMetadata>>
ConversationModelsClient::UndeployConversationModel(
    google::cloud::dialogflow::v2::UndeployConversationModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UndeployConversationModel(request);
}

StatusOr<google::longrunning::Operation>
ConversationModelsClient::UndeployConversationModel(
    NoAwaitTag,
    google::cloud::dialogflow::v2::UndeployConversationModelRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UndeployConversationModel(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::dialogflow::v2::UndeployConversationModelOperationMetadata>>
ConversationModelsClient::UndeployConversationModel(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UndeployConversationModel(operation);
}

StatusOr<google::cloud::dialogflow::v2::ConversationModelEvaluation>
ConversationModelsClient::GetConversationModelEvaluation(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::GetConversationModelEvaluationRequest request;
  request.set_name(name);
  return connection_->GetConversationModelEvaluation(request);
}

StatusOr<google::cloud::dialogflow::v2::ConversationModelEvaluation>
ConversationModelsClient::GetConversationModelEvaluation(
    google::cloud::dialogflow::v2::GetConversationModelEvaluationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetConversationModelEvaluation(request);
}

StreamRange<google::cloud::dialogflow::v2::ConversationModelEvaluation>
ConversationModelsClient::ListConversationModelEvaluations(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::ListConversationModelEvaluationsRequest
      request;
  request.set_parent(parent);
  return connection_->ListConversationModelEvaluations(request);
}

StreamRange<google::cloud::dialogflow::v2::ConversationModelEvaluation>
ConversationModelsClient::ListConversationModelEvaluations(
    google::cloud::dialogflow::v2::ListConversationModelEvaluationsRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListConversationModelEvaluations(std::move(request));
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationModelEvaluation>>
ConversationModelsClient::CreateConversationModelEvaluation(
    std::string const& parent,
    google::cloud::dialogflow::v2::ConversationModelEvaluation const&
        conversation_model_evaluation,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::CreateConversationModelEvaluationRequest
      request;
  request.set_parent(parent);
  *request.mutable_conversation_model_evaluation() =
      conversation_model_evaluation;
  return connection_->CreateConversationModelEvaluation(request);
}

StatusOr<google::longrunning::Operation>
ConversationModelsClient::CreateConversationModelEvaluation(
    NoAwaitTag, std::string const& parent,
    google::cloud::dialogflow::v2::ConversationModelEvaluation const&
        conversation_model_evaluation,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::CreateConversationModelEvaluationRequest
      request;
  request.set_parent(parent);
  *request.mutable_conversation_model_evaluation() =
      conversation_model_evaluation;
  return connection_->CreateConversationModelEvaluation(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationModelEvaluation>>
ConversationModelsClient::CreateConversationModelEvaluation(
    google::cloud::dialogflow::v2::
        CreateConversationModelEvaluationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateConversationModelEvaluation(request);
}

StatusOr<google::longrunning::Operation>
ConversationModelsClient::CreateConversationModelEvaluation(
    NoAwaitTag,
    google::cloud::dialogflow::v2::
        CreateConversationModelEvaluationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateConversationModelEvaluation(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationModelEvaluation>>
ConversationModelsClient::CreateConversationModelEvaluation(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateConversationModelEvaluation(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es
}  // namespace cloud
}  // namespace google
