// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/environment.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_ENVIRONMENTS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_ENVIRONMENTS_CLIENT_H

#include "google/cloud/dialogflow_cx/environments_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service for managing
/// [Environments][google.cloud.dialogflow.cx.v3.Environment].
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
/// [google.cloud.dialogflow.cx.v3.Environment]:
/// @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L196}
///
class EnvironmentsClient {
 public:
  explicit EnvironmentsClient(
      std::shared_ptr<EnvironmentsConnection> connection, Options opts = {});
  ~EnvironmentsClient();

  ///@{
  /// @name Copy and move support
  EnvironmentsClient(EnvironmentsClient const&) = default;
  EnvironmentsClient& operator=(EnvironmentsClient const&) = default;
  EnvironmentsClient(EnvironmentsClient&&) = default;
  EnvironmentsClient& operator=(EnvironmentsClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(EnvironmentsClient const& a,
                         EnvironmentsClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(EnvironmentsClient const& a,
                         EnvironmentsClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Returns the list of all environments in the specified
  /// [Agent][google.cloud.dialogflow.cx.v3.Agent].
  ///
  /// @param parent  Required. The [Agent][google.cloud.dialogflow.cx.v3.Agent] to list all
  ///  environments for. Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.dialogflow.cx.v3.Environment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.Environment]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L196}
  /// [google.cloud.dialogflow.cx.v3.ListEnvironmentsRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L276}
  ///
  // clang-format on
  StreamRange<google::cloud::dialogflow::cx::v3::Environment> ListEnvironments(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Returns the list of all environments in the specified
  /// [Agent][google.cloud.dialogflow.cx.v3.Agent].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.cx.v3.ListEnvironmentsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.dialogflow.cx.v3.Environment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.Environment]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L196}
  /// [google.cloud.dialogflow.cx.v3.ListEnvironmentsRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L276}
  ///
  // clang-format on
  StreamRange<google::cloud::dialogflow::cx::v3::Environment> ListEnvironments(
      google::cloud::dialogflow::cx::v3::ListEnvironmentsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves the specified
  /// [Environment][google.cloud.dialogflow.cx.v3.Environment].
  ///
  /// @param name  Required. The name of the
  ///  [Environment][google.cloud.dialogflow.cx.v3.Environment]. Format:
  ///  `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/environments/<Environment ID>`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dialogflow.cx.v3.Environment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.Environment]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L196}
  /// [google.cloud.dialogflow.cx.v3.GetEnvironmentRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L311}
  ///
  // clang-format on
  StatusOr<google::cloud::dialogflow::cx::v3::Environment> GetEnvironment(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves the specified
  /// [Environment][google.cloud.dialogflow.cx.v3.Environment].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.cx.v3.GetEnvironmentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dialogflow.cx.v3.Environment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.Environment]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L196}
  /// [google.cloud.dialogflow.cx.v3.GetEnvironmentRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L311}
  ///
  // clang-format on
  StatusOr<google::cloud::dialogflow::cx::v3::Environment> GetEnvironment(
      google::cloud::dialogflow::cx::v3::GetEnvironmentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates an [Environment][google.cloud.dialogflow.cx.v3.Environment] in the
  /// specified [Agent][google.cloud.dialogflow.cx.v3.Agent].
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`: An empty [Struct
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
  /// - `response`: [Environment][google.cloud.dialogflow.cx.v3.Environment]
  ///
  /// @param parent  Required. The [Agent][google.cloud.dialogflow.cx.v3.Agent] to create an
  ///  [Environment][google.cloud.dialogflow.cx.v3.Environment] for. Format:
  ///  `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
  /// @param environment  Required. The environment to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dialogflow.cx.v3.Environment] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.CreateEnvironmentRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L326}
  /// [google.cloud.dialogflow.cx.v3.Environment]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L196}
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::cx::v3::Environment>>
  CreateEnvironment(
      std::string const& parent,
      google::cloud::dialogflow::cx::v3::Environment const& environment,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateEnvironment
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateEnvironment(
      NoAwaitTag, std::string const& parent,
      google::cloud::dialogflow::cx::v3::Environment const& environment,
      Options opts = {});

  // clang-format off
  ///
  /// Creates an [Environment][google.cloud.dialogflow.cx.v3.Environment] in the
  /// specified [Agent][google.cloud.dialogflow.cx.v3.Agent].
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`: An empty [Struct
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
  /// - `response`: [Environment][google.cloud.dialogflow.cx.v3.Environment]
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.cx.v3.CreateEnvironmentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dialogflow.cx.v3.Environment] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.CreateEnvironmentRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L326}
  /// [google.cloud.dialogflow.cx.v3.Environment]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L196}
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::cx::v3::Environment>>
  CreateEnvironment(
      google::cloud::dialogflow::cx::v3::CreateEnvironmentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateEnvironment
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateEnvironment(
      NoAwaitTag,
      google::cloud::dialogflow::cx::v3::CreateEnvironmentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateEnvironment
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::cx::v3::Environment>>
  CreateEnvironment(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Updates the specified
  /// [Environment][google.cloud.dialogflow.cx.v3.Environment].
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`: An empty [Struct
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
  /// - `response`: [Environment][google.cloud.dialogflow.cx.v3.Environment]
  ///
  /// @param environment  Required. The environment to update.
  /// @param update_mask  Required. The mask to control which fields get updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dialogflow.cx.v3.Environment] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.Environment]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L196}
  /// [google.cloud.dialogflow.cx.v3.UpdateEnvironmentRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L343}
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::cx::v3::Environment>>
  UpdateEnvironment(
      google::cloud::dialogflow::cx::v3::Environment const& environment,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateEnvironment
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateEnvironment(
      NoAwaitTag,
      google::cloud::dialogflow::cx::v3::Environment const& environment,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the specified
  /// [Environment][google.cloud.dialogflow.cx.v3.Environment].
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`: An empty [Struct
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
  /// - `response`: [Environment][google.cloud.dialogflow.cx.v3.Environment]
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.cx.v3.UpdateEnvironmentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dialogflow.cx.v3.Environment] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.Environment]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L196}
  /// [google.cloud.dialogflow.cx.v3.UpdateEnvironmentRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L343}
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::cx::v3::Environment>>
  UpdateEnvironment(
      google::cloud::dialogflow::cx::v3::UpdateEnvironmentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateEnvironment
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateEnvironment(
      NoAwaitTag,
      google::cloud::dialogflow::cx::v3::UpdateEnvironmentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateEnvironment
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::cx::v3::Environment>>
  UpdateEnvironment(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified
  /// [Environment][google.cloud.dialogflow.cx.v3.Environment].
  ///
  /// @param name  Required. The name of the
  ///  [Environment][google.cloud.dialogflow.cx.v3.Environment] to delete. Format:
  ///  `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/environments/<Environment ID>`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.DeleteEnvironmentRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L354}
  /// [google.cloud.dialogflow.cx.v3.Environment]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L196}
  ///
  // clang-format on
  Status DeleteEnvironment(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified
  /// [Environment][google.cloud.dialogflow.cx.v3.Environment].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.cx.v3.DeleteEnvironmentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.DeleteEnvironmentRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L354}
  /// [google.cloud.dialogflow.cx.v3.Environment]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L196}
  ///
  // clang-format on
  Status DeleteEnvironment(
      google::cloud::dialogflow::cx::v3::DeleteEnvironmentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Looks up the history of the specified
  /// [Environment][google.cloud.dialogflow.cx.v3.Environment].
  ///
  /// @param name  Required. Resource name of the environment to look up the history for.
  ///  Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/environments/<Environment ID>`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.dialogflow.cx.v3.Environment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.Environment]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L196}
  /// [google.cloud.dialogflow.cx.v3.LookupEnvironmentHistoryRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L369}
  ///
  // clang-format on
  StreamRange<google::cloud::dialogflow::cx::v3::Environment>
  LookupEnvironmentHistory(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Looks up the history of the specified
  /// [Environment][google.cloud.dialogflow.cx.v3.Environment].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.cx.v3.LookupEnvironmentHistoryRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.dialogflow.cx.v3.Environment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.Environment]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L196}
  /// [google.cloud.dialogflow.cx.v3.LookupEnvironmentHistoryRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L369}
  ///
  // clang-format on
  StreamRange<google::cloud::dialogflow::cx::v3::Environment>
  LookupEnvironmentHistory(
      google::cloud::dialogflow::cx::v3::LookupEnvironmentHistoryRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Kicks off a continuous test under the specified
  /// [Environment][google.cloud.dialogflow.cx.v3.Environment].
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`:
  /// [RunContinuousTestMetadata][google.cloud.dialogflow.cx.v3.RunContinuousTestMetadata]
  /// - `response`:
  /// [RunContinuousTestResponse][google.cloud.dialogflow.cx.v3.RunContinuousTestResponse]
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.cx.v3.RunContinuousTestRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dialogflow.cx.v3.RunContinuousTestResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.Environment]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L196}
  /// [google.cloud.dialogflow.cx.v3.RunContinuousTestMetadata]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L462}
  /// [google.cloud.dialogflow.cx.v3.RunContinuousTestRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L441}
  /// [google.cloud.dialogflow.cx.v3.RunContinuousTestResponse]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L454}
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::cx::v3::RunContinuousTestResponse>>
  RunContinuousTest(
      google::cloud::dialogflow::cx::v3::RunContinuousTestRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RunContinuousTest
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RunContinuousTest(
      NoAwaitTag,
      google::cloud::dialogflow::cx::v3::RunContinuousTestRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RunContinuousTest
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::cx::v3::RunContinuousTestResponse>>
  RunContinuousTest(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Fetches a list of continuous test results for a given environment.
  ///
  /// @param parent  Required. The environment to list results for.
  ///  Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/environments/<Environment ID>`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.dialogflow.cx.v3.ContinuousTestResult], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.ContinuousTestResult]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L402}
  /// [google.cloud.dialogflow.cx.v3.ListContinuousTestResultsRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L469}
  ///
  // clang-format on
  StreamRange<google::cloud::dialogflow::cx::v3::ContinuousTestResult>
  ListContinuousTestResults(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Fetches a list of continuous test results for a given environment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.cx.v3.ListContinuousTestResultsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.dialogflow.cx.v3.ContinuousTestResult], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.ContinuousTestResult]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L402}
  /// [google.cloud.dialogflow.cx.v3.ListContinuousTestResultsRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L469}
  ///
  // clang-format on
  StreamRange<google::cloud::dialogflow::cx::v3::ContinuousTestResult>
  ListContinuousTestResults(
      google::cloud::dialogflow::cx::v3::ListContinuousTestResultsRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Deploys a flow to the specified
  /// [Environment][google.cloud.dialogflow.cx.v3.Environment].
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`:
  /// [DeployFlowMetadata][google.cloud.dialogflow.cx.v3.DeployFlowMetadata]
  /// - `response`:
  /// [DeployFlowResponse][google.cloud.dialogflow.cx.v3.DeployFlowResponse]
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.cx.v3.DeployFlowRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dialogflow.cx.v3.DeployFlowResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.cx.v3.DeployFlowMetadata]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L538}
  /// [google.cloud.dialogflow.cx.v3.DeployFlowRequest]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L500}
  /// [google.cloud.dialogflow.cx.v3.DeployFlowResponse]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L524}
  /// [google.cloud.dialogflow.cx.v3.Environment]: @googleapis_reference_link{google/cloud/dialogflow/cx/v3/environment.proto#L196}
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::cx::v3::DeployFlowResponse>>
  DeployFlow(
      google::cloud::dialogflow::cx::v3::DeployFlowRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeployFlow
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeployFlow(
      NoAwaitTag,
      google::cloud::dialogflow::cx::v3::DeployFlowRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeployFlow
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::dialogflow::cx::v3::DeployFlowResponse>>
  DeployFlow(google::longrunning::Operation const& operation,
             Options opts = {});

 private:
  std::shared_ptr<EnvironmentsConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_ENVIRONMENTS_CLIENT_H
