// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/images/v1/images.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_IMAGES_V1_IMAGES_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_IMAGES_V1_IMAGES_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/compute/images/v1/images.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace compute_images_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ImagesConnectionIdempotencyPolicy {
 public:
  virtual ~ImagesConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<ImagesConnectionIdempotencyPolicy> clone() const;

  virtual google::cloud::Idempotency DeleteImage(
      google::cloud::cpp::compute::images::v1::DeleteImageRequest const&
          request);

  virtual google::cloud::Idempotency Deprecate(
      google::cloud::cpp::compute::images::v1::DeprecateRequest const& request);

  virtual google::cloud::Idempotency GetImage(
      google::cloud::cpp::compute::images::v1::GetImageRequest const& request);

  virtual google::cloud::Idempotency GetFromFamily(
      google::cloud::cpp::compute::images::v1::GetFromFamilyRequest const&
          request);

  virtual google::cloud::Idempotency GetIamPolicy(
      google::cloud::cpp::compute::images::v1::GetIamPolicyRequest const&
          request);

  virtual google::cloud::Idempotency InsertImage(
      google::cloud::cpp::compute::images::v1::InsertImageRequest const&
          request);

  virtual google::cloud::Idempotency ListImages(
      google::cloud::cpp::compute::images::v1::ListImagesRequest request);

  virtual google::cloud::Idempotency PatchImage(
      google::cloud::cpp::compute::images::v1::PatchImageRequest const&
          request);

  virtual google::cloud::Idempotency SetIamPolicy(
      google::cloud::cpp::compute::images::v1::SetIamPolicyRequest const&
          request);

  virtual google::cloud::Idempotency SetLabels(
      google::cloud::cpp::compute::images::v1::SetLabelsRequest const& request);

  virtual google::cloud::Idempotency TestIamPermissions(
      google::cloud::cpp::compute::images::v1::TestIamPermissionsRequest const&
          request);
};

std::unique_ptr<ImagesConnectionIdempotencyPolicy>
MakeDefaultImagesConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_images_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_IMAGES_V1_IMAGES_CONNECTION_IDEMPOTENCY_POLICY_H
