// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/billing/v1/cloud_billing.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BILLING_V1_CLOUD_BILLING_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BILLING_V1_CLOUD_BILLING_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/billing/v1/cloud_billing.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace billing_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class CloudBillingConnectionIdempotencyPolicy {
 public:
  virtual ~CloudBillingConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<CloudBillingConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency GetBillingAccount(
      google::cloud::billing::v1::GetBillingAccountRequest const& request);

  virtual google::cloud::Idempotency ListBillingAccounts(
      google::cloud::billing::v1::ListBillingAccountsRequest request);

  virtual google::cloud::Idempotency UpdateBillingAccount(
      google::cloud::billing::v1::UpdateBillingAccountRequest const& request);

  virtual google::cloud::Idempotency CreateBillingAccount(
      google::cloud::billing::v1::CreateBillingAccountRequest const& request);

  virtual google::cloud::Idempotency ListProjectBillingInfo(
      google::cloud::billing::v1::ListProjectBillingInfoRequest request);

  virtual google::cloud::Idempotency GetProjectBillingInfo(
      google::cloud::billing::v1::GetProjectBillingInfoRequest const& request);

  virtual google::cloud::Idempotency UpdateProjectBillingInfo(
      google::cloud::billing::v1::UpdateProjectBillingInfoRequest const&
          request);

  virtual google::cloud::Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request);

  virtual google::cloud::Idempotency MoveBillingAccount(
      google::cloud::billing::v1::MoveBillingAccountRequest const& request);
};

std::unique_ptr<CloudBillingConnectionIdempotencyPolicy>
MakeDefaultCloudBillingConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace billing_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BILLING_V1_CLOUD_BILLING_CONNECTION_IDEMPOTENCY_POLICY_H
