// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/biglake/v1/metastore.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_BIGLAKE_V1_METASTORE_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_BIGLAKE_V1_METASTORE_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/bigquery/biglake/v1/metastore.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_biglake_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class MetastoreServiceConnectionIdempotencyPolicy {
 public:
  virtual ~MetastoreServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<MetastoreServiceConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency CreateCatalog(
      google::cloud::bigquery::biglake::v1::CreateCatalogRequest const&
          request);

  virtual google::cloud::Idempotency DeleteCatalog(
      google::cloud::bigquery::biglake::v1::DeleteCatalogRequest const&
          request);

  virtual google::cloud::Idempotency GetCatalog(
      google::cloud::bigquery::biglake::v1::GetCatalogRequest const& request);

  virtual google::cloud::Idempotency ListCatalogs(
      google::cloud::bigquery::biglake::v1::ListCatalogsRequest request);

  virtual google::cloud::Idempotency CreateDatabase(
      google::cloud::bigquery::biglake::v1::CreateDatabaseRequest const&
          request);

  virtual google::cloud::Idempotency DeleteDatabase(
      google::cloud::bigquery::biglake::v1::DeleteDatabaseRequest const&
          request);

  virtual google::cloud::Idempotency UpdateDatabase(
      google::cloud::bigquery::biglake::v1::UpdateDatabaseRequest const&
          request);

  virtual google::cloud::Idempotency GetDatabase(
      google::cloud::bigquery::biglake::v1::GetDatabaseRequest const& request);

  virtual google::cloud::Idempotency ListDatabases(
      google::cloud::bigquery::biglake::v1::ListDatabasesRequest request);

  virtual google::cloud::Idempotency CreateTable(
      google::cloud::bigquery::biglake::v1::CreateTableRequest const& request);

  virtual google::cloud::Idempotency DeleteTable(
      google::cloud::bigquery::biglake::v1::DeleteTableRequest const& request);

  virtual google::cloud::Idempotency UpdateTable(
      google::cloud::bigquery::biglake::v1::UpdateTableRequest const& request);

  virtual google::cloud::Idempotency RenameTable(
      google::cloud::bigquery::biglake::v1::RenameTableRequest const& request);

  virtual google::cloud::Idempotency GetTable(
      google::cloud::bigquery::biglake::v1::GetTableRequest const& request);

  virtual google::cloud::Idempotency ListTables(
      google::cloud::bigquery::biglake::v1::ListTablesRequest request);
};

std::unique_ptr<MetastoreServiceConnectionIdempotencyPolicy>
MakeDefaultMetastoreServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_biglake_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_BIGLAKE_V1_METASTORE_CONNECTION_IDEMPOTENCY_POLICY_H
