// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/vizier_service.proto

#include "google/cloud/aiplatform/v1/internal/vizier_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

VizierServiceTracingStub::VizierServiceTracingStub(
    std::shared_ptr<VizierServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::aiplatform::v1::Study>
VizierServiceTracingStub::CreateStudy(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::CreateStudyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.aiplatform.v1.VizierService",
                                     "CreateStudy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateStudy(context, options, request));
}

StatusOr<google::cloud::aiplatform::v1::Study>
VizierServiceTracingStub::GetStudy(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::GetStudyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.aiplatform.v1.VizierService",
                                     "GetStudy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetStudy(context, options, request));
}

StatusOr<google::cloud::aiplatform::v1::ListStudiesResponse>
VizierServiceTracingStub::ListStudies(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::ListStudiesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.aiplatform.v1.VizierService",
                                     "ListStudies");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListStudies(context, options, request));
}

Status VizierServiceTracingStub::DeleteStudy(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::DeleteStudyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.aiplatform.v1.VizierService",
                                     "DeleteStudy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteStudy(context, options, request));
}

StatusOr<google::cloud::aiplatform::v1::Study>
VizierServiceTracingStub::LookupStudy(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::LookupStudyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.aiplatform.v1.VizierService",
                                     "LookupStudy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->LookupStudy(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
VizierServiceTracingStub::AsyncSuggestTrials(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::aiplatform::v1::SuggestTrialsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.aiplatform.v1.VizierService",
                                     "SuggestTrials");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncSuggestTrials(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
VizierServiceTracingStub::SuggestTrials(
    grpc::ClientContext& context, Options options,
    google::cloud::aiplatform::v1::SuggestTrialsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.aiplatform.v1.VizierService",
                                     "SuggestTrials");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->SuggestTrials(context, options, request));
}

StatusOr<google::cloud::aiplatform::v1::Trial>
VizierServiceTracingStub::CreateTrial(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::CreateTrialRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.aiplatform.v1.VizierService",
                                     "CreateTrial");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateTrial(context, options, request));
}

StatusOr<google::cloud::aiplatform::v1::Trial>
VizierServiceTracingStub::GetTrial(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::GetTrialRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.aiplatform.v1.VizierService",
                                     "GetTrial");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetTrial(context, options, request));
}

StatusOr<google::cloud::aiplatform::v1::ListTrialsResponse>
VizierServiceTracingStub::ListTrials(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::ListTrialsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.aiplatform.v1.VizierService",
                                     "ListTrials");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListTrials(context, options, request));
}

StatusOr<google::cloud::aiplatform::v1::Trial>
VizierServiceTracingStub::AddTrialMeasurement(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::AddTrialMeasurementRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.aiplatform.v1.VizierService",
                                     "AddTrialMeasurement");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->AddTrialMeasurement(context, options, request));
}

StatusOr<google::cloud::aiplatform::v1::Trial>
VizierServiceTracingStub::CompleteTrial(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::CompleteTrialRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.aiplatform.v1.VizierService",
                                     "CompleteTrial");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CompleteTrial(context, options, request));
}

Status VizierServiceTracingStub::DeleteTrial(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::DeleteTrialRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.aiplatform.v1.VizierService",
                                     "DeleteTrial");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteTrial(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
VizierServiceTracingStub::AsyncCheckTrialEarlyStoppingState(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::aiplatform::v1::CheckTrialEarlyStoppingStateRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.aiplatform.v1.VizierService",
                                     "CheckTrialEarlyStoppingState");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCheckTrialEarlyStoppingState(
      cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
VizierServiceTracingStub::CheckTrialEarlyStoppingState(
    grpc::ClientContext& context, Options options,
    google::cloud::aiplatform::v1::CheckTrialEarlyStoppingStateRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.aiplatform.v1.VizierService",
                                     "CheckTrialEarlyStoppingState");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->CheckTrialEarlyStoppingState(context, options, request));
}

StatusOr<google::cloud::aiplatform::v1::Trial>
VizierServiceTracingStub::StopTrial(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::StopTrialRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.aiplatform.v1.VizierService",
                                     "StopTrial");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->StopTrial(context, options, request));
}

StatusOr<google::cloud::aiplatform::v1::ListOptimalTrialsResponse>
VizierServiceTracingStub::ListOptimalTrials(
    grpc::ClientContext& context, Options const& options,
    google::cloud::aiplatform::v1::ListOptimalTrialsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.aiplatform.v1.VizierService",
                                     "ListOptimalTrials");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListOptimalTrials(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
VizierServiceTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> VizierServiceTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<VizierServiceStub> MakeVizierServiceTracingStub(
    std::shared_ptr<VizierServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<VizierServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
