/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.tests.simpletests;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.cachebench.CacheWrapper;
import org.cachebench.config.Configuration;
import org.cachebench.config.TestCase;
import org.cachebench.config.TestConfig;
import org.cachebench.tests.AbstractCacheTest;
import org.cachebench.tests.StatisticTest;
import org.cachebench.tests.results.StatisticTestResult;

public abstract class SimpleTest
extends AbstractCacheTest
implements StatisticTest {
    protected Log log = LogFactory.getLog(this.getClass());
    protected AtomicLong numberOfBytesPut = new AtomicLong(0L);
    protected int writePercentage = 50;
    protected ExecutorService executor;
    private static final int EXECUTOR_SHUTDOWN_TIMEOUT_POLL_SECS = 60;
    protected Configuration configuration;
    protected final int LOG_FREQUENCY = 5000;
    private StatisticTestResult results;

    private int getWritePercentageFromConfig(String testCaseName, String testName) {
        try {
            TestCase tc = this.configuration.getTestCase(testName);
            TestConfig t = tc.getTest(testCaseName);
            return t.getIntValue("writePercentage");
        }
        catch (Exception e) {
            this.log.warn((Object)"Unable to get write percentage.  Using default (50)", (Throwable)e);
            return 50;
        }
    }

    public void doCumulativeTest(String testName, CacheWrapper cache, String testCaseName, int sampleSize, int numThreads, StatisticTestResult str) throws Exception {
        this.results = str;
        this.doTest(testName, cache, testCaseName, sampleSize, numThreads);
    }

    protected StatisticTestResult performTestWithObjectType(String testCaseName, CacheWrapper cache, Class valueClass, String testName, int sampleSize, int numThreads) throws Exception {
        this.writePercentage = this.getWritePercentageFromConfig(testCaseName, testName);
        this.log.info((Object)("Using write percentage " + this.writePercentage));
        this.log.info((Object)("Number of threads " + numThreads));
        this.executor = Executors.newFixedThreadPool(numThreads);
        StatisticTestResult result = this.results == null ? new StatisticTestResult() : this.results;
        result.setTestName(testCaseName + this.getNodeIndex());
        result.setTestTime(new Date());
        result.setTestType(testName);
        this.log.info((Object)"Performing test");
        this.doGetsAndPuts(cache, valueClass, sampleSize, result.getGetData(), result.getPutData());
        result.setTestPassed(true);
        long elapsedSecondsForAllPuts = TimeUnit.NANOSECONDS.toSeconds((long)result.getPutData().getSum());
        System.out.println("*** sum of time: " + elapsedSecondsForAllPuts);
        System.out.println("*** num puts occured: " + result.getPutData().getN());
        try {
            result.setThroughputTransactionsPerSecond((int)((long)sampleSize / elapsedSecondsForAllPuts));
        }
        catch (ArithmeticException ae) {
            this.log.warn((Object)"Divide by 0 - elapsedSecondsForAllPuts = 0?");
            result.setThroughputTransactionsPerSecond(-999);
        }
        try {
            result.setThroughputBytesPerSecond((int)(this.numberOfBytesPut.longValue() / elapsedSecondsForAllPuts));
        }
        catch (ArithmeticException ae) {
            this.log.warn((Object)"Divide by 0 - elapsedSecondsForAllPuts = 0?");
            result.setThroughputBytesPerSecond(-999);
        }
        result.setNumMembers(cache.getNumMembers());
        result.setNumThreads(numThreads);
        return result;
    }

    private void doGetsAndPuts(final CacheWrapper cache, final Class valueClass, int sampleSize, final DescriptiveStatistics getStats, final DescriptiveStatistics putStats) throws Exception {
        this.log.debug((Object)("Inside doGets for : " + cache));
        String key = "baseKey";
        Random rand = new Random();
        int modDivisor = 100 / this.writePercentage;
        this.numberOfBytesPut.set(0L);
        final AtomicInteger getCount = new AtomicInteger(0);
        final AtomicInteger putCount = new AtomicInteger(0);
        for (int i = 0; i < sampleSize; ++i) {
            Runnable r = rand.nextInt(100) % modDivisor == 0 ? new Runnable(){

                public void run() {
                    int cycleNumber = putCount.getAndIncrement();
                    try {
                        Object value = valueClass == null ? null : (valueClass.getName().equals(String.class.getName()) ? "value" + cycleNumber : (valueClass.getName().equals(Integer.class.getName()) ? Integer.valueOf(cycleNumber) : valueClass.newInstance()));
                        SimpleTest.this.numberOfBytesPut.getAndAdd(SimpleTest.this.calculateSerializedSize(value));
                        List path = SimpleTest.this.generatePath("baseKey", cycleNumber);
                        String attributeKey = path.toString() + "baseKey" + cycleNumber;
                        boolean transactional = SimpleTest.this.configuration.isUseTransactions();
                        long startTime = System.nanoTime();
                        if (transactional) {
                            cache.startTransaction();
                        }
                        cache.put(path, attributeKey, value);
                        if (transactional) {
                            cache.endTransaction(true);
                        }
                        long statValue = System.nanoTime() - startTime;
                        putStats.addValue((double)statValue);
                        SimpleTest.this.logOperation(cycleNumber, "PUTS", statValue);
                    }
                    catch (Exception e) {
                        if (SimpleTest.this.configuration.isUseTransactions()) {
                            cache.endTransaction(false);
                        }
                        SimpleTest.this.log.error((Object)"Operation failed!", (Throwable)e);
                    }
                }
            } : new Runnable(){

                public void run() {
                    int cycleNumber = getCount.getAndIncrement();
                    try {
                        List path = SimpleTest.this.generatePath("baseKey", cycleNumber);
                        String attributeKey = path.toString() + "baseKey" + cycleNumber;
                        boolean transactional = SimpleTest.this.configuration.isUseTransactions();
                        long startTime = System.nanoTime();
                        if (transactional) {
                            cache.startTransaction();
                        }
                        cache.get(path, attributeKey);
                        if (transactional) {
                            cache.endTransaction(true);
                        }
                        long statValue = System.nanoTime() - startTime;
                        getStats.addValue((double)statValue);
                        SimpleTest.this.logOperation(cycleNumber, "GETS", statValue);
                    }
                    catch (Exception e) {
                        if (SimpleTest.this.configuration.isUseTransactions()) {
                            cache.endTransaction(false);
                        }
                        SimpleTest.this.log.error((Object)"Operation failed!", (Throwable)e);
                    }
                }
            };
            this.executor.execute(r);
        }
        this.blockTillTasksComplete();
        this.log.debug((Object)("Leaving doTasks for : " + cache));
    }

    private void logOperation(int i, String s, long statvalue) {
        if ((i + 1) % 5000 == 0) {
            this.log.info((Object)(i + 1 + " " + s + " were performed"));
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Latest " + s + " took " + statvalue));
            }
        }
    }

    private void blockTillTasksComplete() {
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
            try {
                this.executor.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private long calculateSerializedSize(Object value) {
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            oos.close();
            baos.close();
            return baos.size();
        }
        catch (Exception e) {
            this.log.warn((Object)("Unable to calculate serialized size of object " + value), (Throwable)e);
            try {
                if (oos != null) {
                    oos.close();
                }
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception e2) {
                this.log.warn((Object)"Unable to close streams", (Throwable)e2);
            }
            return 0L;
        }
    }

    public String getNodeIndex() {
        try {
            return " - " + Integer.parseInt(System.getProperty("currentIndex"));
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

