/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.cluster;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cachebench.cluster.Message;
import org.cachebench.cluster.Receiver;
import org.cachebench.cluster.Transport;
import org.cachebench.config.ClusterConfig;

public class TcpTransport
implements Transport {
    private static Log log = LogFactory.getLog(TcpTransport.class);
    Receiver receiver = null;
    ClusterConfig config = null;
    int max_receiver_buffer_size = 500000;
    int max_send_buffer_size = 500000;
    List<InetSocketAddress> nodes;
    ConnectionTable connectionTable;
    int startPort = 7800;
    ServerSocket srvSock = null;
    InetAddress bindAddr = null;
    InetSocketAddress localAddr = null;
    List receivers = new ArrayList();
    private ServerSocket server;
    private boolean isStoping;

    public Object getLocalAddress() {
        return this.localAddr;
    }

    public void create(ClusterConfig clusterConfig) throws Exception {
        this.config = clusterConfig;
        this.startPort = this.config.getPortForThisNode();
        String bindAddrStr = this.config.getAddressForThisNode().getHost();
        this.bindAddr = bindAddrStr == null ? InetAddress.getLocalHost() : InetAddress.getByName(bindAddrStr);
        clusterConfig.validateMembers();
        log.trace((Object)("Bind address is:" + this.bindAddr + "; startPort is:" + this.startPort));
        this.nodes = clusterConfig.getMemberAddresses();
        this.connectionTable = new ConnectionTable(this.nodes);
    }

    public void start() throws Exception {
        this.srvSock = this.createServerSocket();
        if (log.isTraceEnabled()) {
            log.trace((Object)("ServerSock created, listening on: " + this.srvSock.getLocalSocketAddress()));
        }
        this.localAddr = new InetSocketAddress(this.srvSock.getInetAddress(), this.srvSock.getLocalPort());
        this.connectionTable.init();
        Thread acceptor = new Thread(){

            public void run() {
                try {
                    while (true) {
                        Socket s = TcpTransport.this.srvSock.accept();
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Accepted client " + s.getRemoteSocketAddress()));
                        }
                        ReceiverThread r = new ReceiverThread(s);
                        r.setDaemon(true);
                        TcpTransport.this.receivers.add(r);
                        r.start();
                    }
                }
                catch (Exception ex) {
                    block4: {
                        if (TcpTransport.this.isStoping) break block4;
                        log.warn((Object)"Exception whilst accepting new threads", (Throwable)ex);
                    }
                    return;
                }
            }
        };
        acceptor.setDaemon(true);
        acceptor.start();
    }

    private ServerSocket createServerSocket() {
        int start_port1 = this.startPort;
        this.server = null;
        while (true) {
            try {
                this.server = new ServerSocket(start_port1, 50, this.bindAddr);
            }
            catch (BindException bindEx) {
                log.trace((Object)("Binding exception, most likely port " + start_port1 + " is in use. Trying next value. Error:" + bindEx.getMessage()));
                ++start_port1;
                continue;
            }
            catch (IOException ioEx) {
                log.trace((Object)("An exception appeared whilst trying to create server socket on port " + start_port1 + ", error:" + ioEx.getMessage()));
            }
            break;
        }
        return this.server;
    }

    public void stop() {
        try {
            this.isStoping = true;
            this.server.close();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Successfully closed server socket " + this.server));
            }
        }
        catch (IOException e) {
            log.warn((Object)("Failed to close servet socket for " + this.server + ", error is " + e.getMessage()));
        }
        this.connectionTable.close();
        for (ReceiverThread thread : this.receivers) {
            thread.stopThread();
        }
    }

    public void destroy() {
    }

    public void setReceiver(Receiver r) {
        this.receiver = r;
    }

    public Map dumpStats() {
        return null;
    }

    public void send(Object payload) throws Exception {
        this.connectionTable.writeMessage(payload);
    }

    public List parseCommaDelimitedList(String s) throws Exception {
        ArrayList<InetSocketAddress> retval = new ArrayList<InetSocketAddress>();
        if (s == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreTokens()) {
            String tmp = tok.nextToken();
            int index = tmp.indexOf(58);
            if (index == -1) {
                throw new Exception("host must be in format <host:port>, was " + tmp);
            }
            String hostname = tmp.substring(0, index);
            int port = Integer.parseInt(tmp.substring(index + 1));
            InetSocketAddress addr = new InetSocketAddress(hostname, port);
            retval.add(addr);
        }
        return retval;
    }

    public boolean isLocal(SocketAddress sa) {
        return this.connectionTable.isLocalConnection(sa);
    }

    class ReceiverThread
    extends Thread {
        Socket sock;
        DataInputStream in;
        SocketAddress remote;

        ReceiverThread(Socket sock) throws Exception {
            this.sock = sock;
            this.in = new DataInputStream(new BufferedInputStream(sock.getInputStream()));
            this.remote = sock.getRemoteSocketAddress();
        }

        public void run() {
            while (this.sock != null) {
                try {
                    Message message = (Message)new ObjectInputStream(this.in).readObject();
                    if (TcpTransport.this.receiver == null) continue;
                    TcpTransport.this.receiver.receive(message.getSource(), message.getPayload());
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
            log.trace((Object)("-- receiver thread for " + this.remote + " terminated"));
        }

        void stopThread() {
            try {
                log.trace((Object)("Closing receiver thread for: " + this.sock));
                this.sock.close();
                this.in.close();
                this.sock = null;
                this.interrupt();
            }
            catch (Exception ex) {
                log.warn((Object)"Exception while closing the thread", (Throwable)ex);
            }
        }
    }

    class Connection {
        Socket sock = null;
        DataOutputStream out;
        InetSocketAddress to;
        final Object mutex = new Object();

        Connection(InetSocketAddress addr) {
            this.to = addr;
        }

        void createSocket() throws IOException {
            log.trace((Object)("creating socket connection to host: '" + this.to.getAddress() + "', port:'" + this.to.getPort() + "'"));
            this.sock = new Socket(this.to.getAddress(), this.to.getPort());
            this.sock.setSendBufferSize(TcpTransport.this.max_send_buffer_size);
            this.sock.setReceiveBufferSize(TcpTransport.this.max_receiver_buffer_size);
            this.out = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
            log.trace((Object)("-- connected to " + this.to + ". Local address is " + this.sock.getLocalSocketAddress()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeMessage(Object msg) throws Exception {
            Object object = this.mutex;
            synchronized (object) {
                if (this.sock == null) {
                    this.createSocket();
                }
                ObjectOutputStream oos = new ObjectOutputStream(this.out);
                Message message = new Message(TcpTransport.this.localAddr, msg);
                oos.writeObject(message);
            }
            this.out.flush();
        }

        void close() {
            try {
                this.out.flush();
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String toString() {
            return "Connection from " + TcpTransport.this.localAddr + " to " + this.to;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConnectionTable {
        List<InetSocketAddress> myNodes;
        final Connection[] connections;

        ConnectionTable(List<InetSocketAddress> nodes) throws Exception {
            this.myNodes = nodes;
            this.connections = new Connection[nodes.size()];
        }

        void init() throws Exception {
            int i = 0;
            log.trace((Object)("Nodes is " + this.myNodes));
            for (InetSocketAddress addr : this.myNodes) {
                if (this.connections[i] == null) {
                    try {
                        this.connections[i] = new Connection(addr);
                        this.connections[i].createSocket();
                    }
                    catch (ConnectException connect_ex) {
                        log.trace((Object)("-- failed to connect to " + addr));
                    }
                }
                ++i;
            }
        }

        void writeMessage(Object msg) throws Exception {
            int recieversCount = 0;
            for (Connection c : this.connections) {
                if (c == null) continue;
                try {
                    c.writeMessage(msg);
                    ++recieversCount;
                }
                catch (Exception e) {
                    log.trace((Object)("failure(" + e.getMessage() + ") sending message to " + c));
                }
            }
            log.trace((Object)("Message successfully sent to " + recieversCount + "/" + this.connections.length));
        }

        void close() {
            for (int i = 0; i < this.connections.length; ++i) {
                Connection c = this.connections[i];
                if (c == null) continue;
                c.close();
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            Iterator<InetSocketAddress> it = this.myNodes.iterator();
            while (it.hasNext()) {
                sb.append(it.next()).append(' ');
            }
            return sb.toString();
        }

        public boolean isLocalConnection(SocketAddress socketAddress) {
            for (Connection conn : this.connections) {
                SocketAddress addr;
                SocketAddress socketAddress2 = addr = conn.sock != null ? conn.sock.getLocalSocketAddress() : null;
                if (addr == null || !addr.equals(socketAddress)) continue;
                return true;
            }
            return false;
        }
    }
}

