# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.computelimit import ComputeLimitMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeLimitMgmtSharedLimitsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeLimitMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_shared_limits_get(self, resource_group):
        response = self.client.shared_limits.get(
            location="str",
            name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_shared_limits_create(self, resource_group):
        response = self.client.shared_limits.create(
            location="str",
            name="str",
            resource={
                "id": "str",
                "name": "str",
                "properties": {
                    "limit": 0,
                    "provisioningState": "str",
                    "resourceName": {"value": "str", "localizedValue": "str"},
                    "unit": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_shared_limits_delete(self, resource_group):
        response = self.client.shared_limits.delete(
            location="str",
            name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_shared_limits_list_by_subscription_location_resource(self, resource_group):
        response = self.client.shared_limits.list_by_subscription_location_resource(
            location="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
