# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse

from .. import models


class AzureAccountsOperations(object):
    """AzureAccountsOperations operations.

    You should not instantiate directly this class, but create a Client instance that will create it for you and attach it as attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config

    def assign_to_app(
            self, app_id, arm_token=None, azure_account_info_object=None, custom_headers=None, raw=False, **operation_config):
        """apps - Assign a LUIS Azure account to an application.

        Assigns an Azure account to the application.

        :param app_id: The application ID.
        :type app_id: str
        :param arm_token: The custom arm token header to use; containing the
         user's ARM token used to validate azure accounts information.
        :type arm_token: str
        :param azure_account_info_object: The Azure account information
         object.
        :type azure_account_info_object:
         ~azure.cognitiveservices.language.luis.authoring.models.AzureAccountInfoObject
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: OperationStatus or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.language.luis.authoring.models.OperationStatus
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.cognitiveservices.language.luis.authoring.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.assign_to_app.metadata['url']
        path_format_arguments = {
            'Endpoint': self._serialize.url("self.config.endpoint", self.config.endpoint, 'str', skip_quote=True),
            'appId': self._serialize.url("app_id", app_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        if arm_token is not None:
            header_parameters['ArmToken'] = self._serialize.header("arm_token", arm_token, 'str')

        # Construct body
        if azure_account_info_object is not None:
            body_content = self._serialize.body(azure_account_info_object, 'AzureAccountInfoObject')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [201]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None
        if response.status_code == 201:
            deserialized = self._deserialize('OperationStatus', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    assign_to_app.metadata = {'url': '/apps/{appId}/azureaccounts'}

    def get_assigned(
            self, app_id, arm_token=None, custom_headers=None, raw=False, **operation_config):
        """apps - Get LUIS Azure accounts assigned to the application.

        Gets the LUIS Azure accounts assigned to the application for the user
        using his ARM token.

        :param app_id: The application ID.
        :type app_id: str
        :param arm_token: The custom arm token header to use; containing the
         user's ARM token used to validate azure accounts information.
        :type arm_token: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype:
         list[~azure.cognitiveservices.language.luis.authoring.models.AzureAccountInfoObject]
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.cognitiveservices.language.luis.authoring.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.get_assigned.metadata['url']
        path_format_arguments = {
            'Endpoint': self._serialize.url("self.config.endpoint", self.config.endpoint, 'str', skip_quote=True),
            'appId': self._serialize.url("app_id", app_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)
        if arm_token is not None:
            header_parameters['ArmToken'] = self._serialize.header("arm_token", arm_token, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('[AzureAccountInfoObject]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_assigned.metadata = {'url': '/apps/{appId}/azureaccounts'}

    def remove_from_app(
            self, app_id, arm_token=None, azure_account_info_object=None, custom_headers=None, raw=False, **operation_config):
        """apps - Removes an assigned LUIS Azure account from an application.

        Removes assigned Azure account from the application.

        :param app_id: The application ID.
        :type app_id: str
        :param arm_token: The custom arm token header to use; containing the
         user's ARM token used to validate azure accounts information.
        :type arm_token: str
        :param azure_account_info_object: The Azure account information
         object.
        :type azure_account_info_object:
         ~azure.cognitiveservices.language.luis.authoring.models.AzureAccountInfoObject
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: OperationStatus or ClientRawResponse if raw=true
        :rtype:
         ~azure.cognitiveservices.language.luis.authoring.models.OperationStatus
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.cognitiveservices.language.luis.authoring.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.remove_from_app.metadata['url']
        path_format_arguments = {
            'Endpoint': self._serialize.url("self.config.endpoint", self.config.endpoint, 'str', skip_quote=True),
            'appId': self._serialize.url("app_id", app_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)
        if arm_token is not None:
            header_parameters['ArmToken'] = self._serialize.header("arm_token", arm_token, 'str')

        # Construct body
        if azure_account_info_object is not None:
            body_content = self._serialize.body(azure_account_info_object, 'AzureAccountInfoObject')
        else:
            body_content = None

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('OperationStatus', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    remove_from_app.metadata = {'url': '/apps/{appId}/azureaccounts'}

    def list_user_luis_accounts(
            self, arm_token=None, custom_headers=None, raw=False, **operation_config):
        """user - Get LUIS Azure accounts.

        Gets the LUIS Azure accounts for the user using his ARM token.

        :param arm_token: The custom arm token header to use; containing the
         user's ARM token used to validate azure accounts information.
        :type arm_token: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: list or ClientRawResponse if raw=true
        :rtype:
         list[~azure.cognitiveservices.language.luis.authoring.models.AzureAccountInfoObject]
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.cognitiveservices.language.luis.authoring.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.list_user_luis_accounts.metadata['url']
        path_format_arguments = {
            'Endpoint': self._serialize.url("self.config.endpoint", self.config.endpoint, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)
        if arm_token is not None:
            header_parameters['ArmToken'] = self._serialize.header("arm_token", arm_token, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('[AzureAccountInfoObject]', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_user_luis_accounts.metadata = {'url': '/azureaccounts'}
