#include <sphinxbase/logmath.h>
#include "acmod.h"
#include <pocketsphinx.h>
#include <sphinxbase/cmd_ln.h>
#include <string.h>
#include <stdlib.h>
#include <vector>

static void process(acmod_t* acmod, const std::vector<int16>& inout_raw_vector, const bool full_utt)
{
    acmod_start_utt(acmod);
    size_t inout_n_samps = inout_raw_vector.size();
    const int16* inout_raw = inout_raw_vector.data();
    const auto ret = acmod_process_raw(
            acmod,
            &inout_raw,
            &inout_n_samps,
            full_utt ? 1 : 0);
    acmod_end_utt(acmod);
}

int main(int argc, char** argv)
{
    logmath_t* lm = nullptr;
    acmod_t* acmod = nullptr;
    cmd_ln_t* config = nullptr;

    lm = logmath_init(1.0001, 0, 0);

    config = ps_config_parse_json(
        NULL,
        "samprate: 18098.744141,"
        "frate: 6068,"
        "svspec: \"0-12/13-25/26-38\"");
    ps_config_set_str(config, "mdef", MODELDIR "/en-us/en-us/mdef");
    ps_config_set_str(config, "mean", MODELDIR "/en-us/en-us/means");
    ps_config_set_str(config, "var", MODELDIR "/en-us/en-us/variances");
    ps_config_set_str(config, "tmat", MODELDIR "/en-us/en-us/transition_matrices");
    ps_config_set_str(config, "sendump", MODELDIR "/en-us/en-us/sendump");
    ps_config_set_str(config, "mixw", NULL);
    ps_config_set_str(config, "lda", NULL);
    ps_config_set_str(config, "senmgau", NULL);

    acmod = acmod_init(config, lm, nullptr, nullptr);

    /* First */
    {
        std::vector<int16> inout_raw_vector = {1285, 1285, 1285, -1, 1285, 1285, 1285, 1285, 1285, 1285, 4883, -1, -1, -1, -1, -1, -1, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 4963, 1285, -1, -1, -1, -1, -1, 1285, 1285, 1285, 1285, 1285, 4869, 4883, 1285, 1285, 1285, 1285, 1285, 4883, 1299, 1285, 1285, 1285, 1285, -1, 1285, 1285, 1285, 1285, 1285, -1, -1, -1, 1285, 4883, 1285, 1285, 1285, 1285, 1285, 25363, 1535, -1, -1, -1, 1285, 1285, 1285, 4883, 1285, 1285, 1285, -31355, -31355, -1, -1, -1, -1, -1, -1, -31233, -31355, -31355, -31355, -31355, 1285, -1, 1285, 1285, 1285, 1285, 1285, -1, -1, -1, -1, -1, -1, -1, -1, 1285, 1285, 1285, 25363, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5119, 1285, 1285, 1285, 1285, 1285, 25363, -1, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 6401, 1285, 1285, 1280, 1285, 1285, -251, -1, -1, -1, -1, -1, -1, -1, -212, -1, -1, -1, 6401, -1, -1, -1, -1, 1535, 1285, 1285, 4883, 1285, 1285, 4883, -13057, 1285, 1285, 1535, 1285, 1285, 1285, 5893, 1285, 1285, -1, -1, 5119, 6401, 1285, 1285, 1285, 1285, 1285, 4869, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1285, 1285, 1285, 6401, -1, -1, -1, -1, 1535, -1, 1285, 4883, -1, -1, -1, 1285, 4883, 1285, 1285, -1, -1, -1, -1, -1, -1, 1285, 1285, 1285, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4963, -251, -1, -1, -1, 1285, 1285, 4869, 4883, 1285, 1285, 1285, -31355, -1, -1, -1, -1, -1, 1285, 1285, 1285, 1285, 1285, 4869, 4883, 1285, 1285, 1285, 1285, 1285, 4883, 1299, 1285, 1285, 1285, 1285, -1, 1285, 1285, 1285, 1285, 1285, 1285, 1285, -1, -1, 1285, 1285, 1285, 1285, 1285, 25363, 1285, 1285, 1285, 1285, 1285, 4889, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 4883, 4883, -1, -1, -1, -1, -1, -1, 1285, 1285, 1285, 1285, 1285, -1, -1, -1, -1, -1, -1, -1, -1, 1285, 1285, 1285, 1285, 1285, 1285, -237, -1, 1285, -1, 1285, 1285, 1285, 1285, 1285, 4883, -1, -1, 1285, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1285, 4883, 1285, 1285, 1285, -31355, -1, -1, -1, -1, -1, 1285, 1285, 1285, 1285, 1285, 1285, -251, -1, -1, -1, -1, -1, -1, -1, -1, 1285, 1285, 6401, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1285, 1285, 1285, -1, -1, -1, -1, -1, -1, -1, 1285, -1, -1, -1, -1, -1, -1, 1285, 1285, 1285, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4883, -1, -1, -1, -1, 1285, 1285, 1285, 4883, 1285, 1285, 1285, -31355, -123, -1, -1, -1, -1, -1, 1285, 1285, 1285, 1285, 1285, 4883, 1285, 1285, 1323, 1285, 1285, 1285, 4883, 1285, 1285, 1285, 1285, -1, 1285, 1285, 1285, 1285, 1285, -1, -1, -1, 1285, 4963, 1285, 1285, 1285, 1285, 1285, 4883, -1, -1, -1, -1, 1285, 4869, 4883, 1285, -251, -1, -1, -1, -1, -1, 1535, 1285, 1285, 1285, -1, -1, -1, -1, -1, -1, -1, 11519, 1535, 4883, -1, -1, -1, -1, 1285, 1285, 4883, 9747, 1285, 1285, 1285, -31355, -1, -1, -1, -1, -1, 1285, 1285, 1285, 1285, 1285, 275, 1299, 1285, 1285, 1285, 1285, 1285, 275, 1285, 1285, 1285, 1285, 1285};
        process(acmod, inout_raw_vector, true);
    }

    /* Second */
    {
        std::vector<int16> inout_raw_vector = {1285, 1285, 1285, 1285, 1285, 1285, -1, -1, 1285, 1285, 1285, 1285, 1285, 25363, 1285, 1285, 1285, 1285, 1285, 4889, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 4883, 4883, -1, -1, -1, -1, -1, -1, 1285, 1285, 1285, 1285, 1285, -1, -1, -1, -1, -1, -1, -1, -1, 1285, 1285, 1285, 1285, 1285, 1285, -237, -1, 1285, -1, 1285, 1285, 1285, 1285, 1285, 4883, -1, -1, 1285, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1285, 4883, 1285, 1285, 1285, -31355, -1, -1, -1, -1, -1, 1285, 1285, 1285, 1285, 1285, 1285, -251, -1, -1, -1, -1, -1, -1, -1, -1, 1285, 1285, 6401, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1285, 1285, 1285, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1285, 1285, 4883, -1, 1285, 1285, -1, 1285, 1285, 1285, 1285, 1285, 4963, 1285, 1285, 1285, 1285, 1285, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4883, -1, -1, -1, -1, 1285, 1285, 1285, 4883, 1285, 1285, 1285, -31355, -123, -1, -1, -1, -1, -1, 1285, 1285, 1285, 1285, 1285, 4883, 1285, 1285, 1323, 1285, 1285, 1285, 4883, 1285, 1285, 1285, 1285, -1, 1285, 1285, 1285, 1285, 1285, -1, -1, -1, 1285, 4889, 1285, 1285, 1285, 1285, 1285};
        process(acmod, inout_raw_vector, true);
    }

    /* Third */
    {
        std::vector<int16> inout_raw_vector = {1029, 1285, 1285, 1285, -1, -1, -1, -1, -1, -1, -1, -1, 1285, 1285, 1285, -237, -1, -1, -1, -1, -1, -1, -1, 1285, 1285, -1, -1, -1, 4883, 1299, 1285, 1285, 1285, 1285, 1285, 4883, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1285, 1285, 1285, 4883, -1, -1, -1, -1, -1, 1285, 1285, 4889, -1, -1, -1, 1535, 4963, 1285, 1285, -1, -1, -1, -1, -1, -1, 1285, 1285, 1285, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4883, -1, -1, -1, -1, 1285, 1285, 1285, 4883, 1285, 1285, 1285, -31355, -123, -1, -1, -1, -1, -1, 1285, 1285, 1285, 1285, 1285, 4883, 1285, 1285, 1323, 1285, 1285, 1285, 4883, 1285, 1285, 1285, 1285, -1, 1285, 1285, 1285, 1285, 1285, 1285, 1285, -1, -1, 1285, 1285, 1285, 1285, 1285, 4883, 1285, 1285, 1285, 1285, 1285, 6401, 1285, 1285, 1285, 1285, 1285, 1535, 1285, 1285, 1285, 1285, 1285, 4869, 4883, -1, -1, -1, -1, -1, -1, 1285, 1285, 1285, 1285, 1285, -1, -1, -1, -1, -1, -1, -1, -1, 1299, 1285, 1285, 1285, 1285, 1285, 4883, -1, 1285, -251, 1285, 1285, 1285, 1285, 1285, 4889, -1, -1, 1285, -251, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1285, 4963, 1285, 1285, 1285, -31355, -1, -1, -1, -1, -1, 1285, 1535, 1285, 1285, 1285, 1285, 1285, -65, -1, -1, -1, -1, -1, -1, -1, 1285, 1285, 275, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1285, 1285, 1285, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1285, 1285, 4869, -1, 1535, 1285, -1, 1285, 1285, 1285, 1285, 1285, 25363, 1285, 1285, 1285, 1285, 1285, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4883, -1, -1, -1, -1, 1285, 1285, 1285, 4963, 1285, 1285, 1285, -31355, -31355, -1, -1, -1, -1, -1, 1285, 1285, 1285, 1285, 1285, 4963, 1285, 1285, 11051, 1285, 1285, 1285, 4883, 1285, 1285, 1285, 1285, -251, 1326, 1285, 1285, 1285, 1285, -251, -1, -1, 1285, 6401, 1285, 1285, 1285, 1285, 1285, 4869, -1, -1, -1, -1, -1, 1285, 1285, 6401, 1285, 1285, 1285, 1285, -31355, 8449, -1, -1, -1, -1, -1, -1, -31355, -31355, -31355, -31355, -31355, 1285, -1, 1285, 1285, 1285, 1285, 1285, -1, -1, -1, -1, -1, -1, -1, -1, 1285, 1285, 1285, 4883, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1299, 1285, 1285, 1285, 1285, 1285, 4883, -1, 1285, -251, 1285, 1285, 1285, 1285, 1285, 4883, 1285, 1285, 1285, 1285, 1285, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 25363, 1535, -1, -1, -1, 1285, 1285, 1285, 4883, 1285, 1285, 1285, -31355, -31355, -31355, 19789, 19789, 19789, 19789, 19789, 19789, 19789, 19789, 19789, -31355, 0, -31355, -31355, 1285, -1, 1285, 1285, 1285, 1285, 1285, 4883, 1285, 1285, 5, 1285, 1285, 1285, 1285, 1285, 1285, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4883, -1, -1, -1, -1, 1285, 1285, 1285, 4963, 1285, 1285, 1285, -31355, -31355, -1, -1, -1, -1, -1, 1285, 1285, 1285, 1285, 1285, 4963, 1285, 1285, 11051, 1285, 1285, 1285, 4883, 1285, 1285, 1285, 1285, -251, 1326, 1285, 1285, 1285, 1285, -251, -1, -1, 1285, 6401, 1285, 1285, 1285, 1285, 1285, 4869, -1, -1, -1, -1, -1, 1285, 1285, 6401, 1285, 1285, 1285, 1285, -31355, -31355, -1, -1, -1, -1, -1, -1, -31355, -31355, -31355, -31355, 1413, 1285, -1, 1285, 1284, 1285, 1285, 1285, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1285, 1285, 1285, 1285, 1285, 6401, 3859, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1285, 1285, 1285, 1285, 1285, 25363, 1285, 1285, 1285, -256, -1, -1, -1, -1, -1, -1, 1285, 22055};
        process(acmod, inout_raw_vector, false);
    }

    acmod_free(acmod);
    cmd_ln_free_r(config);
    logmath_free(lm);
}
