/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.spi;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.DirObjectFactory;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.StateFactory;
import org.apache.harmony.jndi.internal.EnvironmentReader;
import org.apache.harmony.jndi.internal.UrlParser;
import org.apache.harmony.jndi.internal.nls.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryManager
extends NamingManager {
    private DirectoryManager() {
    }

    public static Object getObjectInstance(Object o, Name n, Context c, Hashtable<?, ?> h, Attributes a) throws Exception {
        Object result;
        if (ofb != null) {
            ObjectFactory factory = ofb.createObjectFactory(o, h);
            return DirectoryManager.getObjectInstanceFromGivenFactory(factory, o, n, c, h, a);
        }
        Reference ref = null;
        if (o instanceof Referenceable) {
            ref = ((Referenceable)o).getReference();
        }
        if (o instanceof Reference) {
            ref = (Reference)o;
        }
        if (ref != null) {
            if (ref.getFactoryClassName() != null) {
                return DirectoryManager.getObjectInstanceByFactoryInReference(ref, o, n, c, h, a);
            }
            result = DirectoryManager.getObjectInstanceByUrlRefAddr(n, c, h, ref);
            if (result != null) {
                return result;
            }
        }
        if ((result = DirectoryManager.getObjectInstanceByObjectFactory(o, n, c, h, a)) != null) {
            return result;
        }
        return o;
    }

    private static Object getObjectInstanceFromGivenFactory(ObjectFactory factory, Object o, Name n, Context c, Hashtable<?, ?> h, Attributes a) throws Exception {
        if (factory instanceof DirObjectFactory) {
            return ((DirObjectFactory)factory).getObjectInstance(o, n, c, h, a);
        }
        return factory.getObjectInstance(o, n, c, h);
    }

    private static Object getObjectInstanceByObjectFactory(Object o, Name n, Context c, Hashtable<?, ?> h, Attributes a) throws NamingException, Exception {
        String[] fnames;
        String[] stringArray = fnames = EnvironmentReader.getFactoryNamesFromEnvironmentAndProviderResource(h, c, "java.naming.factory.object");
        int n2 = 0;
        int n3 = stringArray.length;
        while (n2 < n3) {
            block4: {
                String element = stringArray[n2];
                ObjectFactory factory = null;
                try {
                    factory = (ObjectFactory)DirectoryManager.classForName(element).newInstance();
                }
                catch (Exception exception) {
                    break block4;
                }
                Object obj = DirectoryManager.getObjectInstanceFromGivenFactory(factory, o, n, c, h, a);
                if (obj != null) {
                    return obj;
                }
            }
            ++n2;
        }
        return null;
    }

    private static Object getObjectInstanceByUrlRefAddr(Name n, Context c, Hashtable<?, ?> h, Reference ref) throws NamingException {
        String[] pkgPrefixes = EnvironmentReader.getFactoryNamesFromEnvironmentAndProviderResource(h, c, "java.naming.factory.url.pkgs");
        Enumeration<RefAddr> enumeration = ref.getAll();
        while (enumeration.hasMoreElements()) {
            String url;
            Object obj;
            RefAddr addr = enumeration.nextElement();
            if (!(addr instanceof StringRefAddr) || !addr.getType().equalsIgnoreCase("URL") || (obj = DirectoryManager.getObjectInstanceByUrlContextFactory(url = (String)((StringRefAddr)addr).getContent(), n, c, h, pkgPrefixes, UrlParser.getScheme(url))) == null) continue;
            return obj;
        }
        return null;
    }

    private static Object getObjectInstanceByUrlContextFactory(String url, Name n, Context c, Hashtable<?, ?> h, String[] pkgPrefixes, String schema) throws NamingException {
        if (schema == null || schema.length() == 0) {
            return null;
        }
        String[] stringArray = pkgPrefixes;
        int n2 = 0;
        int n3 = stringArray.length;
        while (n2 < n3) {
            block8: {
                String element = stringArray[n2];
                ObjectFactory factory = null;
                try {
                    String clsName = String.valueOf(element) + "." + schema + "." + schema + "URLContextFactory";
                    factory = (ObjectFactory)DirectoryManager.classForName(clsName).newInstance();
                }
                catch (Exception exception) {
                    break block8;
                }
                try {
                    Object obj = factory.getObjectInstance(url, n, c, h);
                    if (obj != null) {
                        return obj;
                    }
                }
                catch (Exception e) {
                    if (e instanceof NamingException) {
                        throw (NamingException)e;
                    }
                    NamingException nex = new NamingException(Messages.getString("jndi.21"));
                    nex.setRootCause(e);
                    throw nex;
                }
            }
            ++n2;
        }
        return null;
    }

    private static Object getObjectInstanceByFactoryInReference(Reference ref, Object o, Name n, Context c, Hashtable<?, ?> h, Attributes a) throws Exception {
        ObjectFactory factory = null;
        try {
            factory = (ObjectFactory)DirectoryManager.classForName(ref.getFactoryClassName()).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (factory == null && ref.getFactoryClassLocation() != null) {
            factory = (ObjectFactory)DirectoryManager.loadFactoryFromLocation(ref.getFactoryClassName(), ref.getFactoryClassLocation());
        }
        if (factory == null) {
            return o;
        }
        return DirectoryManager.getObjectInstanceFromGivenFactory(factory, ref, n, c, h, a);
    }

    private static Object loadFactoryFromLocation(String clsName, String location) throws Exception {
        StringTokenizer st = new StringTokenizer(location, " ");
        URL[] urls = new URL[st.countTokens()];
        int i = 0;
        while (i < urls.length) {
            urls[i] = new URL(st.nextToken());
            ++i;
        }
        URLClassLoader l = new URLClassLoader(urls);
        try {
            return l.loadClass(clsName).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static DirStateFactory.Result getStateToBind(Object o, Name n, Context c, Hashtable<?, ?> h, Attributes a) throws NamingException {
        String[] fnames;
        String[] stringArray = fnames = EnvironmentReader.getFactoryNamesFromEnvironmentAndProviderResource(h, c, "java.naming.factory.state");
        int n2 = 0;
        int n3 = stringArray.length;
        while (n2 < n3) {
            block7: {
                String element = stringArray[n2];
                StateFactory factory = null;
                try {
                    factory = (StateFactory)DirectoryManager.classForName(element).newInstance();
                }
                catch (Exception exception) {
                    break block7;
                }
                if (factory instanceof DirStateFactory) {
                    DirStateFactory.Result r = ((DirStateFactory)factory).getStateToBind(o, n, c, h, a);
                    if (r != null) {
                        return r;
                    }
                } else {
                    Object state = factory.getStateToBind(o, n, c, h);
                    if (state != null) {
                        return new DirStateFactory.Result(state, a);
                    }
                }
            }
            ++n2;
        }
        return new DirStateFactory.Result(o, a);
    }

    public static DirContext getContinuationDirContext(CannotProceedException cpe) throws NamingException {
        Context nextContext = null;
        try {
            nextContext = NamingManager.getContinuationContext(cpe);
        }
        catch (CannotProceedException cannotProceedException) {}
        if (nextContext instanceof DirContext) {
            return (DirContext)nextContext;
        }
        return new Context2DirContextWrapper(nextContext, cpe);
    }

    private static Class<?> classForName(final String className) throws ClassNotFoundException {
        Class cls = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        return Class.forName(className, true, ClassLoader.getSystemClassLoader());
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        return null;
                    }
                }
            }
        });
        if (cls == null) {
            throw new ClassNotFoundException(Messages.getString("jndi.1C", className));
        }
        return cls;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Context2DirContextWrapper
    implements DirContext {
        private Context ctx;
        private CannotProceedException cpe;

        public Context2DirContextWrapper(Context ctx, CannotProceedException cpe) {
            this.ctx = ctx;
            this.cpe = cpe;
        }

        private Context getContext() throws CannotProceedException {
            if (this.ctx != null) {
                return this.ctx;
            }
            this.cpe.fillInStackTrace();
            throw this.cpe;
        }

        private DirContext getDirContext() throws CannotProceedException {
            if (this.ctx instanceof DirContext) {
                return (DirContext)this.ctx;
            }
            this.cpe.fillInStackTrace();
            throw this.cpe;
        }

        @Override
        public NamingEnumeration<Binding> listBindings(String s) throws NamingException {
            return this.getContext().listBindings(s);
        }

        @Override
        public Object removeFromEnvironment(String s) throws NamingException {
            return this.getContext().removeFromEnvironment(s);
        }

        @Override
        public Object lookupLink(String s) throws NamingException {
            return this.getContext().lookupLink(s);
        }

        @Override
        public NamingEnumeration<NameClassPair> list(Name n) throws NamingException {
            return this.getContext().list(n);
        }

        @Override
        public Object lookup(String s) throws NamingException {
            return this.getContext().lookup(s);
        }

        @Override
        public Object addToEnvironment(String s, Object o) throws NamingException {
            return this.getContext().addToEnvironment(s, o);
        }

        public String toString() {
            try {
                return this.getContext().toString();
            }
            catch (CannotProceedException cannotProceedException) {
                return super.toString();
            }
        }

        @Override
        public Context createSubcontext(String s) throws NamingException {
            return this.getContext().createSubcontext(s);
        }

        @Override
        public void rename(Name nOld, Name nNew) throws NamingException {
            this.getContext().rename(nOld, nNew);
        }

        public int hashCode() {
            try {
                return this.getContext().hashCode();
            }
            catch (CannotProceedException cannotProceedException) {
                return super.hashCode();
            }
        }

        @Override
        public void rebind(Name n, Object o) throws NamingException {
            this.getContext().rebind(n, o);
        }

        @Override
        public void rename(String sOld, String sNew) throws NamingException {
            this.getContext().rename(sOld, sNew);
        }

        @Override
        public Context createSubcontext(Name n) throws NamingException {
            return this.getContext().createSubcontext(n);
        }

        @Override
        public NameParser getNameParser(String s) throws NamingException {
            return this.getContext().getNameParser(s);
        }

        @Override
        public void rebind(String s, Object o) throws NamingException {
            this.getContext().rebind(s, o);
        }

        @Override
        public NamingEnumeration<Binding> listBindings(Name n) throws NamingException {
            return this.getContext().listBindings(n);
        }

        @Override
        public NameParser getNameParser(Name n) throws NamingException {
            return this.getContext().getNameParser(n);
        }

        @Override
        public NamingEnumeration<NameClassPair> list(String s) throws NamingException {
            return this.getContext().list(s);
        }

        @Override
        public String getNameInNamespace() throws NamingException {
            return this.getContext().getNameInNamespace();
        }

        @Override
        public void unbind(Name n) throws NamingException {
            this.getContext().unbind(n);
        }

        @Override
        public Name composeName(Name n, Name pfx) throws NamingException {
            return this.getContext().composeName(n, pfx);
        }

        @Override
        public void bind(Name n, Object o) throws NamingException {
            this.getContext().bind(n, o);
        }

        @Override
        public void unbind(String s) throws NamingException {
            this.getContext().unbind(s);
        }

        @Override
        public void close() throws NamingException {
            this.getContext().close();
        }

        @Override
        public Object lookupLink(Name n) throws NamingException {
            return this.getContext().lookupLink(n);
        }

        @Override
        public void destroySubcontext(Name n) throws NamingException {
            this.getContext().destroySubcontext(n);
        }

        @Override
        public String composeName(String s, String pfx) throws NamingException {
            return this.getContext().composeName(s, pfx);
        }

        @Override
        public void bind(String s, Object o) throws NamingException {
            this.getContext().bind(s, o);
        }

        @Override
        public Object lookup(Name n) throws NamingException {
            return this.getContext().lookup(n);
        }

        public boolean equals(Object arg0) {
            try {
                return this.getContext().equals(arg0);
            }
            catch (CannotProceedException cannotProceedException) {
                return super.equals(arg0);
            }
        }

        @Override
        public void destroySubcontext(String s) throws NamingException {
            this.getContext().destroySubcontext(s);
        }

        @Override
        public Hashtable<?, ?> getEnvironment() throws NamingException {
            return this.getContext().getEnvironment();
        }

        @Override
        public void bind(Name name, Object obj, Attributes attributes) throws NamingException {
            this.getDirContext().bind(name, obj, attributes);
        }

        @Override
        public void bind(String s, Object obj, Attributes attributes) throws NamingException {
            this.getDirContext().bind(s, obj, attributes);
        }

        @Override
        public DirContext createSubcontext(Name name, Attributes attributes) throws NamingException {
            return this.getDirContext().createSubcontext(name, attributes);
        }

        @Override
        public DirContext createSubcontext(String s, Attributes attributes) throws NamingException {
            return this.getDirContext().createSubcontext(s, attributes);
        }

        @Override
        public Attributes getAttributes(Name name) throws NamingException {
            return this.getDirContext().getAttributes(name);
        }

        @Override
        public Attributes getAttributes(Name name, String[] as) throws NamingException {
            return this.getDirContext().getAttributes(name, as);
        }

        @Override
        public Attributes getAttributes(String s) throws NamingException {
            return this.getDirContext().getAttributes(s);
        }

        @Override
        public Attributes getAttributes(String s, String[] as) throws NamingException {
            return this.getDirContext().getAttributes(s, as);
        }

        @Override
        public DirContext getSchema(Name name) throws NamingException {
            return this.getDirContext().getSchema(name);
        }

        @Override
        public DirContext getSchema(String s) throws NamingException {
            return this.getDirContext().getSchema(s);
        }

        @Override
        public DirContext getSchemaClassDefinition(Name name) throws NamingException {
            return this.getDirContext().getSchemaClassDefinition(name);
        }

        @Override
        public DirContext getSchemaClassDefinition(String s) throws NamingException {
            return this.getDirContext().getSchemaClassDefinition(s);
        }

        @Override
        public void modifyAttributes(Name name, int i, Attributes attributes) throws NamingException {
            this.getDirContext().modifyAttributes(name, i, attributes);
        }

        @Override
        public void modifyAttributes(Name name, ModificationItem[] modificationItems) throws NamingException {
            this.getDirContext().modifyAttributes(name, modificationItems);
        }

        @Override
        public void modifyAttributes(String s, int i, Attributes attributes) throws NamingException {
            this.getDirContext().modifyAttributes(s, i, attributes);
        }

        @Override
        public void modifyAttributes(String s, ModificationItem[] modificationItems) throws NamingException {
            this.getDirContext().modifyAttributes(s, modificationItems);
        }

        @Override
        public void rebind(Name name, Object obj, Attributes attributes) throws NamingException {
            this.getDirContext().rebind(name, obj, attributes);
        }

        @Override
        public void rebind(String s, Object obj, Attributes attributes) throws NamingException {
            this.getDirContext().rebind(s, obj, attributes);
        }

        @Override
        public NamingEnumeration<SearchResult> search(Name name, Attributes attributes) throws NamingException {
            return this.getDirContext().search(name, attributes);
        }

        @Override
        public NamingEnumeration<SearchResult> search(Name name, Attributes attributes, String[] as) throws NamingException {
            return this.getDirContext().search(name, attributes, as);
        }

        @Override
        public NamingEnumeration<SearchResult> search(Name name, String filter, Object[] objs, SearchControls searchControls) throws NamingException {
            return this.getDirContext().search(name, filter, objs, searchControls);
        }

        @Override
        public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls searchControls) throws NamingException {
            return this.getDirContext().search(name, filter, searchControls);
        }

        @Override
        public NamingEnumeration<SearchResult> search(String name, Attributes attributes) throws NamingException {
            return this.getDirContext().search(name, attributes);
        }

        @Override
        public NamingEnumeration<SearchResult> search(String name, Attributes attributes, String[] as) throws NamingException {
            return this.getDirContext().search(name, attributes, as);
        }

        @Override
        public NamingEnumeration<SearchResult> search(String name, String filter, Object[] objs, SearchControls searchControls) throws NamingException {
            return this.getDirContext().search(name, filter, objs, searchControls);
        }

        @Override
        public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls searchControls) throws NamingException {
            return this.getDirContext().search(name, filter, searchControls);
        }
    }
}

