
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2019 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQt_1.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <Qt>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include "gsiDeclQtCoreTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// namespace Qt

class Qt_Namespace { };


//  Implementation of the enum wrapper class for Qt::DockWidgetAreaSizes
namespace qt_gsi
{

static gsi::Enum<Qt::DockWidgetAreaSizes> decl_Qt_DockWidgetAreaSizes_Enum ("QtCore", "Qt_DockWidgetAreaSizes",
    gsi::enum_const ("NDockWidgetAreas", Qt::NDockWidgetAreas, "@brief Enum constant Qt::NDockWidgetAreas"),
  "@qt\n@brief This class represents the Qt::DockWidgetAreaSizes enum");

static gsi::QFlagsClass<Qt::DockWidgetAreaSizes > decl_Qt_DockWidgetAreaSizes_Enums ("QtCore", "Qt_QFlags_DockWidgetAreaSizes",
  "@qt\n@brief This class represents the QFlags<Qt::DockWidgetAreaSizes> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_DockWidgetAreaSizes_Enum_in_parent (decl_Qt_DockWidgetAreaSizes_Enum.defs ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_DockWidgetAreaSizes_Enum_as_child (decl_Qt_DockWidgetAreaSizes_Enum, "DockWidgetAreaSizes");
static gsi::ClassExt<Qt_Namespace> decl_Qt_DockWidgetAreaSizes_Enums_as_child (decl_Qt_DockWidgetAreaSizes_Enums, "QFlags_DockWidgetAreaSizes");

}


//  Implementation of the enum wrapper class for Qt::DropAction
namespace qt_gsi
{

static gsi::Enum<Qt::DropAction> decl_Qt_DropAction_Enum ("QtCore", "Qt_DropAction",
    gsi::enum_const ("CopyAction", Qt::CopyAction, "@brief Enum constant Qt::CopyAction") +
    gsi::enum_const ("MoveAction", Qt::MoveAction, "@brief Enum constant Qt::MoveAction") +
    gsi::enum_const ("LinkAction", Qt::LinkAction, "@brief Enum constant Qt::LinkAction") +
    gsi::enum_const ("ActionMask", Qt::ActionMask, "@brief Enum constant Qt::ActionMask") +
    gsi::enum_const ("TargetMoveAction", Qt::TargetMoveAction, "@brief Enum constant Qt::TargetMoveAction") +
    gsi::enum_const ("IgnoreAction", Qt::IgnoreAction, "@brief Enum constant Qt::IgnoreAction"),
  "@qt\n@brief This class represents the Qt::DropAction enum");

static gsi::QFlagsClass<Qt::DropAction > decl_Qt_DropAction_Enums ("QtCore", "Qt_QFlags_DropAction",
  "@qt\n@brief This class represents the QFlags<Qt::DropAction> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_DropAction_Enum_in_parent (decl_Qt_DropAction_Enum.defs ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_DropAction_Enum_as_child (decl_Qt_DropAction_Enum, "DropAction");
static gsi::ClassExt<Qt_Namespace> decl_Qt_DropAction_Enums_as_child (decl_Qt_DropAction_Enums, "QFlags_DropAction");

}


//  Implementation of the enum wrapper class for Qt::EventPriority
namespace qt_gsi
{

static gsi::Enum<Qt::EventPriority> decl_Qt_EventPriority_Enum ("QtCore", "Qt_EventPriority",
    gsi::enum_const ("HighEventPriority", Qt::HighEventPriority, "@brief Enum constant Qt::HighEventPriority") +
    gsi::enum_const ("NormalEventPriority", Qt::NormalEventPriority, "@brief Enum constant Qt::NormalEventPriority") +
    gsi::enum_const ("LowEventPriority", Qt::LowEventPriority, "@brief Enum constant Qt::LowEventPriority"),
  "@qt\n@brief This class represents the Qt::EventPriority enum");

static gsi::QFlagsClass<Qt::EventPriority > decl_Qt_EventPriority_Enums ("QtCore", "Qt_QFlags_EventPriority",
  "@qt\n@brief This class represents the QFlags<Qt::EventPriority> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_EventPriority_Enum_in_parent (decl_Qt_EventPriority_Enum.defs ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_EventPriority_Enum_as_child (decl_Qt_EventPriority_Enum, "EventPriority");
static gsi::ClassExt<Qt_Namespace> decl_Qt_EventPriority_Enums_as_child (decl_Qt_EventPriority_Enums, "QFlags_EventPriority");

}


//  Implementation of the enum wrapper class for Qt::FillRule
namespace qt_gsi
{

static gsi::Enum<Qt::FillRule> decl_Qt_FillRule_Enum ("QtCore", "Qt_FillRule",
    gsi::enum_const ("OddEvenFill", Qt::OddEvenFill, "@brief Enum constant Qt::OddEvenFill") +
    gsi::enum_const ("WindingFill", Qt::WindingFill, "@brief Enum constant Qt::WindingFill"),
  "@qt\n@brief This class represents the Qt::FillRule enum");

static gsi::QFlagsClass<Qt::FillRule > decl_Qt_FillRule_Enums ("QtCore", "Qt_QFlags_FillRule",
  "@qt\n@brief This class represents the QFlags<Qt::FillRule> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_FillRule_Enum_in_parent (decl_Qt_FillRule_Enum.defs ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_FillRule_Enum_as_child (decl_Qt_FillRule_Enum, "FillRule");
static gsi::ClassExt<Qt_Namespace> decl_Qt_FillRule_Enums_as_child (decl_Qt_FillRule_Enums, "QFlags_FillRule");

}


//  Implementation of the enum wrapper class for Qt::FocusPolicy
namespace qt_gsi
{

static gsi::Enum<Qt::FocusPolicy> decl_Qt_FocusPolicy_Enum ("QtCore", "Qt_FocusPolicy",
    gsi::enum_const ("NoFocus", Qt::NoFocus, "@brief Enum constant Qt::NoFocus") +
    gsi::enum_const ("TabFocus", Qt::TabFocus, "@brief Enum constant Qt::TabFocus") +
    gsi::enum_const ("ClickFocus", Qt::ClickFocus, "@brief Enum constant Qt::ClickFocus") +
    gsi::enum_const ("StrongFocus", Qt::StrongFocus, "@brief Enum constant Qt::StrongFocus") +
    gsi::enum_const ("WheelFocus", Qt::WheelFocus, "@brief Enum constant Qt::WheelFocus"),
  "@qt\n@brief This class represents the Qt::FocusPolicy enum");

static gsi::QFlagsClass<Qt::FocusPolicy > decl_Qt_FocusPolicy_Enums ("QtCore", "Qt_QFlags_FocusPolicy",
  "@qt\n@brief This class represents the QFlags<Qt::FocusPolicy> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_FocusPolicy_Enum_in_parent (decl_Qt_FocusPolicy_Enum.defs ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_FocusPolicy_Enum_as_child (decl_Qt_FocusPolicy_Enum, "FocusPolicy");
static gsi::ClassExt<Qt_Namespace> decl_Qt_FocusPolicy_Enums_as_child (decl_Qt_FocusPolicy_Enums, "QFlags_FocusPolicy");

}


//  Implementation of the enum wrapper class for Qt::FocusReason
namespace qt_gsi
{

static gsi::Enum<Qt::FocusReason> decl_Qt_FocusReason_Enum ("QtCore", "Qt_FocusReason",
    gsi::enum_const ("MouseFocusReason", Qt::MouseFocusReason, "@brief Enum constant Qt::MouseFocusReason") +
    gsi::enum_const ("TabFocusReason", Qt::TabFocusReason, "@brief Enum constant Qt::TabFocusReason") +
    gsi::enum_const ("BacktabFocusReason", Qt::BacktabFocusReason, "@brief Enum constant Qt::BacktabFocusReason") +
    gsi::enum_const ("ActiveWindowFocusReason", Qt::ActiveWindowFocusReason, "@brief Enum constant Qt::ActiveWindowFocusReason") +
    gsi::enum_const ("PopupFocusReason", Qt::PopupFocusReason, "@brief Enum constant Qt::PopupFocusReason") +
    gsi::enum_const ("ShortcutFocusReason", Qt::ShortcutFocusReason, "@brief Enum constant Qt::ShortcutFocusReason") +
    gsi::enum_const ("MenuBarFocusReason", Qt::MenuBarFocusReason, "@brief Enum constant Qt::MenuBarFocusReason") +
    gsi::enum_const ("OtherFocusReason", Qt::OtherFocusReason, "@brief Enum constant Qt::OtherFocusReason") +
    gsi::enum_const ("NoFocusReason", Qt::NoFocusReason, "@brief Enum constant Qt::NoFocusReason"),
  "@qt\n@brief This class represents the Qt::FocusReason enum");

static gsi::QFlagsClass<Qt::FocusReason > decl_Qt_FocusReason_Enums ("QtCore", "Qt_QFlags_FocusReason",
  "@qt\n@brief This class represents the QFlags<Qt::FocusReason> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_FocusReason_Enum_in_parent (decl_Qt_FocusReason_Enum.defs ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_FocusReason_Enum_as_child (decl_Qt_FocusReason_Enum, "FocusReason");
static gsi::ClassExt<Qt_Namespace> decl_Qt_FocusReason_Enums_as_child (decl_Qt_FocusReason_Enums, "QFlags_FocusReason");

}


//  Implementation of the enum wrapper class for Qt::GestureFlag
namespace qt_gsi
{

static gsi::Enum<Qt::GestureFlag> decl_Qt_GestureFlag_Enum ("QtCore", "Qt_GestureFlag",
    gsi::enum_const ("DontStartGestureOnChildren", Qt::DontStartGestureOnChildren, "@brief Enum constant Qt::DontStartGestureOnChildren") +
    gsi::enum_const ("ReceivePartialGestures", Qt::ReceivePartialGestures, "@brief Enum constant Qt::ReceivePartialGestures"),
  "@qt\n@brief This class represents the Qt::GestureFlag enum");

static gsi::QFlagsClass<Qt::GestureFlag > decl_Qt_GestureFlag_Enums ("QtCore", "Qt_QFlags_GestureFlag",
  "@qt\n@brief This class represents the QFlags<Qt::GestureFlag> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_GestureFlag_Enum_in_parent (decl_Qt_GestureFlag_Enum.defs ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_GestureFlag_Enum_as_child (decl_Qt_GestureFlag_Enum, "GestureFlag");
static gsi::ClassExt<Qt_Namespace> decl_Qt_GestureFlag_Enums_as_child (decl_Qt_GestureFlag_Enums, "QFlags_GestureFlag");

}


//  Implementation of the enum wrapper class for Qt::GestureState
namespace qt_gsi
{

static gsi::Enum<Qt::GestureState> decl_Qt_GestureState_Enum ("QtCore", "Qt_GestureState",
    gsi::enum_const ("NoGesture", Qt::NoGesture, "@brief Enum constant Qt::NoGesture") +
    gsi::enum_const ("GestureStarted", Qt::GestureStarted, "@brief Enum constant Qt::GestureStarted") +
    gsi::enum_const ("GestureUpdated", Qt::GestureUpdated, "@brief Enum constant Qt::GestureUpdated") +
    gsi::enum_const ("GestureFinished", Qt::GestureFinished, "@brief Enum constant Qt::GestureFinished") +
    gsi::enum_const ("GestureCanceled", Qt::GestureCanceled, "@brief Enum constant Qt::GestureCanceled"),
  "@qt\n@brief This class represents the Qt::GestureState enum");

static gsi::QFlagsClass<Qt::GestureState > decl_Qt_GestureState_Enums ("QtCore", "Qt_QFlags_GestureState",
  "@qt\n@brief This class represents the QFlags<Qt::GestureState> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_GestureState_Enum_in_parent (decl_Qt_GestureState_Enum.defs ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_GestureState_Enum_as_child (decl_Qt_GestureState_Enum, "GestureState");
static gsi::ClassExt<Qt_Namespace> decl_Qt_GestureState_Enums_as_child (decl_Qt_GestureState_Enums, "QFlags_GestureState");

}


//  Implementation of the enum wrapper class for Qt::GestureType
namespace qt_gsi
{

static gsi::Enum<Qt::GestureType> decl_Qt_GestureType_Enum ("QtCore", "Qt_GestureType",
    gsi::enum_const ("TapGesture", Qt::TapGesture, "@brief Enum constant Qt::TapGesture") +
    gsi::enum_const ("TapAndHoldGesture", Qt::TapAndHoldGesture, "@brief Enum constant Qt::TapAndHoldGesture") +
    gsi::enum_const ("PanGesture", Qt::PanGesture, "@brief Enum constant Qt::PanGesture") +
    gsi::enum_const ("PinchGesture", Qt::PinchGesture, "@brief Enum constant Qt::PinchGesture") +
    gsi::enum_const ("SwipeGesture", Qt::SwipeGesture, "@brief Enum constant Qt::SwipeGesture") +
    gsi::enum_const ("CustomGesture", Qt::CustomGesture, "@brief Enum constant Qt::CustomGesture") +
    gsi::enum_const ("LastGestureType", Qt::LastGestureType, "@brief Enum constant Qt::LastGestureType"),
  "@qt\n@brief This class represents the Qt::GestureType enum");

static gsi::QFlagsClass<Qt::GestureType > decl_Qt_GestureType_Enums ("QtCore", "Qt_QFlags_GestureType",
  "@qt\n@brief This class represents the QFlags<Qt::GestureType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_GestureType_Enum_in_parent (decl_Qt_GestureType_Enum.defs ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_GestureType_Enum_as_child (decl_Qt_GestureType_Enum, "GestureType");
static gsi::ClassExt<Qt_Namespace> decl_Qt_GestureType_Enums_as_child (decl_Qt_GestureType_Enums, "QFlags_GestureType");

}


//  Implementation of the enum wrapper class for Qt::GlobalColor
namespace qt_gsi
{

static gsi::Enum<Qt::GlobalColor> decl_Qt_GlobalColor_Enum ("QtCore", "Qt_GlobalColor",
    gsi::enum_const ("color0", Qt::color0, "@brief Enum constant Qt::color0") +
    gsi::enum_const ("color1", Qt::color1, "@brief Enum constant Qt::color1") +
    gsi::enum_const ("black", Qt::black, "@brief Enum constant Qt::black") +
    gsi::enum_const ("white", Qt::white, "@brief Enum constant Qt::white") +
    gsi::enum_const ("darkGray", Qt::darkGray, "@brief Enum constant Qt::darkGray") +
    gsi::enum_const ("gray", Qt::gray, "@brief Enum constant Qt::gray") +
    gsi::enum_const ("lightGray", Qt::lightGray, "@brief Enum constant Qt::lightGray") +
    gsi::enum_const ("red", Qt::red, "@brief Enum constant Qt::red") +
    gsi::enum_const ("green", Qt::green, "@brief Enum constant Qt::green") +
    gsi::enum_const ("blue", Qt::blue, "@brief Enum constant Qt::blue") +
    gsi::enum_const ("cyan", Qt::cyan, "@brief Enum constant Qt::cyan") +
    gsi::enum_const ("magenta", Qt::magenta, "@brief Enum constant Qt::magenta") +
    gsi::enum_const ("yellow", Qt::yellow, "@brief Enum constant Qt::yellow") +
    gsi::enum_const ("darkRed", Qt::darkRed, "@brief Enum constant Qt::darkRed") +
    gsi::enum_const ("darkGreen", Qt::darkGreen, "@brief Enum constant Qt::darkGreen") +
    gsi::enum_const ("darkBlue", Qt::darkBlue, "@brief Enum constant Qt::darkBlue") +
    gsi::enum_const ("darkCyan", Qt::darkCyan, "@brief Enum constant Qt::darkCyan") +
    gsi::enum_const ("darkMagenta", Qt::darkMagenta, "@brief Enum constant Qt::darkMagenta") +
    gsi::enum_const ("darkYellow", Qt::darkYellow, "@brief Enum constant Qt::darkYellow") +
    gsi::enum_const ("transparent", Qt::transparent, "@brief Enum constant Qt::transparent"),
  "@qt\n@brief This class represents the Qt::GlobalColor enum");

static gsi::QFlagsClass<Qt::GlobalColor > decl_Qt_GlobalColor_Enums ("QtCore", "Qt_QFlags_GlobalColor",
  "@qt\n@brief This class represents the QFlags<Qt::GlobalColor> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_GlobalColor_Enum_in_parent (decl_Qt_GlobalColor_Enum.defs ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_GlobalColor_Enum_as_child (decl_Qt_GlobalColor_Enum, "GlobalColor");
static gsi::ClassExt<Qt_Namespace> decl_Qt_GlobalColor_Enums_as_child (decl_Qt_GlobalColor_Enums, "QFlags_GlobalColor");

}


//  Implementation of the enum wrapper class for Qt::ImageConversionFlag
namespace qt_gsi
{

static gsi::Enum<Qt::ImageConversionFlag> decl_Qt_ImageConversionFlag_Enum ("QtCore", "Qt_ImageConversionFlag",
    gsi::enum_const ("ColorMode_Mask", Qt::ColorMode_Mask, "@brief Enum constant Qt::ColorMode_Mask") +
    gsi::enum_const ("AutoColor", Qt::AutoColor, "@brief Enum constant Qt::AutoColor") +
    gsi::enum_const ("ColorOnly", Qt::ColorOnly, "@brief Enum constant Qt::ColorOnly") +
    gsi::enum_const ("MonoOnly", Qt::MonoOnly, "@brief Enum constant Qt::MonoOnly") +
    gsi::enum_const ("AlphaDither_Mask", Qt::AlphaDither_Mask, "@brief Enum constant Qt::AlphaDither_Mask") +
    gsi::enum_const ("ThresholdAlphaDither", Qt::ThresholdAlphaDither, "@brief Enum constant Qt::ThresholdAlphaDither") +
    gsi::enum_const ("OrderedAlphaDither", Qt::OrderedAlphaDither, "@brief Enum constant Qt::OrderedAlphaDither") +
    gsi::enum_const ("DiffuseAlphaDither", Qt::DiffuseAlphaDither, "@brief Enum constant Qt::DiffuseAlphaDither") +
    gsi::enum_const ("NoAlpha", Qt::NoAlpha, "@brief Enum constant Qt::NoAlpha") +
    gsi::enum_const ("Dither_Mask", Qt::Dither_Mask, "@brief Enum constant Qt::Dither_Mask") +
    gsi::enum_const ("DiffuseDither", Qt::DiffuseDither, "@brief Enum constant Qt::DiffuseDither") +
    gsi::enum_const ("OrderedDither", Qt::OrderedDither, "@brief Enum constant Qt::OrderedDither") +
    gsi::enum_const ("ThresholdDither", Qt::ThresholdDither, "@brief Enum constant Qt::ThresholdDither") +
    gsi::enum_const ("DitherMode_Mask", Qt::DitherMode_Mask, "@brief Enum constant Qt::DitherMode_Mask") +
    gsi::enum_const ("AutoDither", Qt::AutoDither, "@brief Enum constant Qt::AutoDither") +
    gsi::enum_const ("PreferDither", Qt::PreferDither, "@brief Enum constant Qt::PreferDither") +
    gsi::enum_const ("AvoidDither", Qt::AvoidDither, "@brief Enum constant Qt::AvoidDither") +
    gsi::enum_const ("NoOpaqueDetection", Qt::NoOpaqueDetection, "@brief Enum constant Qt::NoOpaqueDetection"),
  "@qt\n@brief This class represents the Qt::ImageConversionFlag enum");

static gsi::QFlagsClass<Qt::ImageConversionFlag > decl_Qt_ImageConversionFlag_Enums ("QtCore", "Qt_QFlags_ImageConversionFlag",
  "@qt\n@brief This class represents the QFlags<Qt::ImageConversionFlag> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_ImageConversionFlag_Enum_in_parent (decl_Qt_ImageConversionFlag_Enum.defs ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_ImageConversionFlag_Enum_as_child (decl_Qt_ImageConversionFlag_Enum, "ImageConversionFlag");
static gsi::ClassExt<Qt_Namespace> decl_Qt_ImageConversionFlag_Enums_as_child (decl_Qt_ImageConversionFlag_Enums, "QFlags_ImageConversionFlag");

}


//  Implementation of the enum wrapper class for Qt::Initialization
namespace qt_gsi
{

static gsi::Enum<Qt::Initialization> decl_Qt_Initialization_Enum ("QtCore", "Qt_Initialization",
    gsi::enum_const ("Uninitialized", Qt::Uninitialized, "@brief Enum constant Qt::Uninitialized"),
  "@qt\n@brief This class represents the Qt::Initialization enum");

static gsi::QFlagsClass<Qt::Initialization > decl_Qt_Initialization_Enums ("QtCore", "Qt_QFlags_Initialization",
  "@qt\n@brief This class represents the QFlags<Qt::Initialization> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_Initialization_Enum_in_parent (decl_Qt_Initialization_Enum.defs ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_Initialization_Enum_as_child (decl_Qt_Initialization_Enum, "Initialization");
static gsi::ClassExt<Qt_Namespace> decl_Qt_Initialization_Enums_as_child (decl_Qt_Initialization_Enums, "QFlags_Initialization");

}


//  Implementation of the enum wrapper class for Qt::InputMethodHint
namespace qt_gsi
{

static gsi::Enum<Qt::InputMethodHint> decl_Qt_InputMethodHint_Enum ("QtCore", "Qt_InputMethodHint",
    gsi::enum_const ("ImhNone", Qt::ImhNone, "@brief Enum constant Qt::ImhNone") +
    gsi::enum_const ("ImhHiddenText", Qt::ImhHiddenText, "@brief Enum constant Qt::ImhHiddenText") +
    gsi::enum_const ("ImhNoAutoUppercase", Qt::ImhNoAutoUppercase, "@brief Enum constant Qt::ImhNoAutoUppercase") +
    gsi::enum_const ("ImhPreferNumbers", Qt::ImhPreferNumbers, "@brief Enum constant Qt::ImhPreferNumbers") +
    gsi::enum_const ("ImhPreferUppercase", Qt::ImhPreferUppercase, "@brief Enum constant Qt::ImhPreferUppercase") +
    gsi::enum_const ("ImhPreferLowercase", Qt::ImhPreferLowercase, "@brief Enum constant Qt::ImhPreferLowercase") +
    gsi::enum_const ("ImhNoPredictiveText", Qt::ImhNoPredictiveText, "@brief Enum constant Qt::ImhNoPredictiveText") +
    gsi::enum_const ("ImhDigitsOnly", Qt::ImhDigitsOnly, "@brief Enum constant Qt::ImhDigitsOnly") +
    gsi::enum_const ("ImhFormattedNumbersOnly", Qt::ImhFormattedNumbersOnly, "@brief Enum constant Qt::ImhFormattedNumbersOnly") +
    gsi::enum_const ("ImhUppercaseOnly", Qt::ImhUppercaseOnly, "@brief Enum constant Qt::ImhUppercaseOnly") +
    gsi::enum_const ("ImhLowercaseOnly", Qt::ImhLowercaseOnly, "@brief Enum constant Qt::ImhLowercaseOnly") +
    gsi::enum_const ("ImhDialableCharactersOnly", Qt::ImhDialableCharactersOnly, "@brief Enum constant Qt::ImhDialableCharactersOnly") +
    gsi::enum_const ("ImhEmailCharactersOnly", Qt::ImhEmailCharactersOnly, "@brief Enum constant Qt::ImhEmailCharactersOnly") +
    gsi::enum_const ("ImhUrlCharactersOnly", Qt::ImhUrlCharactersOnly, "@brief Enum constant Qt::ImhUrlCharactersOnly") +
    gsi::enum_const ("ImhExclusiveInputMask", Qt::ImhExclusiveInputMask, "@brief Enum constant Qt::ImhExclusiveInputMask"),
  "@qt\n@brief This class represents the Qt::InputMethodHint enum");

static gsi::QFlagsClass<Qt::InputMethodHint > decl_Qt_InputMethodHint_Enums ("QtCore", "Qt_QFlags_InputMethodHint",
  "@qt\n@brief This class represents the QFlags<Qt::InputMethodHint> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_InputMethodHint_Enum_in_parent (decl_Qt_InputMethodHint_Enum.defs ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_InputMethodHint_Enum_as_child (decl_Qt_InputMethodHint_Enum, "InputMethodHint");
static gsi::ClassExt<Qt_Namespace> decl_Qt_InputMethodHint_Enums_as_child (decl_Qt_InputMethodHint_Enums, "QFlags_InputMethodHint");

}


//  Implementation of the enum wrapper class for Qt::InputMethodQuery
namespace qt_gsi
{

static gsi::Enum<Qt::InputMethodQuery> decl_Qt_InputMethodQuery_Enum ("QtCore", "Qt_InputMethodQuery",
    gsi::enum_const ("ImMicroFocus", Qt::ImMicroFocus, "@brief Enum constant Qt::ImMicroFocus") +
    gsi::enum_const ("ImFont", Qt::ImFont, "@brief Enum constant Qt::ImFont") +
    gsi::enum_const ("ImCursorPosition", Qt::ImCursorPosition, "@brief Enum constant Qt::ImCursorPosition") +
    gsi::enum_const ("ImSurroundingText", Qt::ImSurroundingText, "@brief Enum constant Qt::ImSurroundingText") +
    gsi::enum_const ("ImCurrentSelection", Qt::ImCurrentSelection, "@brief Enum constant Qt::ImCurrentSelection") +
    gsi::enum_const ("ImMaximumTextLength", Qt::ImMaximumTextLength, "@brief Enum constant Qt::ImMaximumTextLength") +
    gsi::enum_const ("ImAnchorPosition", Qt::ImAnchorPosition, "@brief Enum constant Qt::ImAnchorPosition"),
  "@qt\n@brief This class represents the Qt::InputMethodQuery enum");

static gsi::QFlagsClass<Qt::InputMethodQuery > decl_Qt_InputMethodQuery_Enums ("QtCore", "Qt_QFlags_InputMethodQuery",
  "@qt\n@brief This class represents the QFlags<Qt::InputMethodQuery> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_InputMethodQuery_Enum_in_parent (decl_Qt_InputMethodQuery_Enum.defs ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_InputMethodQuery_Enum_as_child (decl_Qt_InputMethodQuery_Enum, "InputMethodQuery");
static gsi::ClassExt<Qt_Namespace> decl_Qt_InputMethodQuery_Enums_as_child (decl_Qt_InputMethodQuery_Enums, "QFlags_InputMethodQuery");

}


//  Implementation of the enum wrapper class for Qt::ItemDataRole
namespace qt_gsi
{

static gsi::Enum<Qt::ItemDataRole> decl_Qt_ItemDataRole_Enum ("QtCore", "Qt_ItemDataRole",
    gsi::enum_const ("DisplayRole", Qt::DisplayRole, "@brief Enum constant Qt::DisplayRole") +
    gsi::enum_const ("DecorationRole", Qt::DecorationRole, "@brief Enum constant Qt::DecorationRole") +
    gsi::enum_const ("EditRole", Qt::EditRole, "@brief Enum constant Qt::EditRole") +
    gsi::enum_const ("ToolTipRole", Qt::ToolTipRole, "@brief Enum constant Qt::ToolTipRole") +
    gsi::enum_const ("StatusTipRole", Qt::StatusTipRole, "@brief Enum constant Qt::StatusTipRole") +
    gsi::enum_const ("WhatsThisRole", Qt::WhatsThisRole, "@brief Enum constant Qt::WhatsThisRole") +
    gsi::enum_const ("FontRole", Qt::FontRole, "@brief Enum constant Qt::FontRole") +
    gsi::enum_const ("TextAlignmentRole", Qt::TextAlignmentRole, "@brief Enum constant Qt::TextAlignmentRole") +
    gsi::enum_const ("BackgroundColorRole", Qt::BackgroundColorRole, "@brief Enum constant Qt::BackgroundColorRole") +
    gsi::enum_const ("BackgroundRole", Qt::BackgroundRole, "@brief Enum constant Qt::BackgroundRole") +
    gsi::enum_const ("TextColorRole", Qt::TextColorRole, "@brief Enum constant Qt::TextColorRole") +
    gsi::enum_const ("ForegroundRole", Qt::ForegroundRole, "@brief Enum constant Qt::ForegroundRole") +
    gsi::enum_const ("CheckStateRole", Qt::CheckStateRole, "@brief Enum constant Qt::CheckStateRole") +
    gsi::enum_const ("AccessibleTextRole", Qt::AccessibleTextRole, "@brief Enum constant Qt::AccessibleTextRole") +
    gsi::enum_const ("AccessibleDescriptionRole", Qt::AccessibleDescriptionRole, "@brief Enum constant Qt::AccessibleDescriptionRole") +
    gsi::enum_const ("SizeHintRole", Qt::SizeHintRole, "@brief Enum constant Qt::SizeHintRole") +
    gsi::enum_const ("DisplayPropertyRole", Qt::DisplayPropertyRole, "@brief Enum constant Qt::DisplayPropertyRole") +
    gsi::enum_const ("DecorationPropertyRole", Qt::DecorationPropertyRole, "@brief Enum constant Qt::DecorationPropertyRole") +
    gsi::enum_const ("ToolTipPropertyRole", Qt::ToolTipPropertyRole, "@brief Enum constant Qt::ToolTipPropertyRole") +
    gsi::enum_const ("StatusTipPropertyRole", Qt::StatusTipPropertyRole, "@brief Enum constant Qt::StatusTipPropertyRole") +
    gsi::enum_const ("WhatsThisPropertyRole", Qt::WhatsThisPropertyRole, "@brief Enum constant Qt::WhatsThisPropertyRole") +
    gsi::enum_const ("UserRole", Qt::UserRole, "@brief Enum constant Qt::UserRole"),
  "@qt\n@brief This class represents the Qt::ItemDataRole enum");

static gsi::QFlagsClass<Qt::ItemDataRole > decl_Qt_ItemDataRole_Enums ("QtCore", "Qt_QFlags_ItemDataRole",
  "@qt\n@brief This class represents the QFlags<Qt::ItemDataRole> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_ItemDataRole_Enum_in_parent (decl_Qt_ItemDataRole_Enum.defs ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_ItemDataRole_Enum_as_child (decl_Qt_ItemDataRole_Enum, "ItemDataRole");
static gsi::ClassExt<Qt_Namespace> decl_Qt_ItemDataRole_Enums_as_child (decl_Qt_ItemDataRole_Enums, "QFlags_ItemDataRole");

}


//  Implementation of the enum wrapper class for Qt::ItemFlag
namespace qt_gsi
{

static gsi::Enum<Qt::ItemFlag> decl_Qt_ItemFlag_Enum ("QtCore", "Qt_ItemFlag",
    gsi::enum_const ("NoItemFlags", Qt::NoItemFlags, "@brief Enum constant Qt::NoItemFlags") +
    gsi::enum_const ("ItemIsSelectable", Qt::ItemIsSelectable, "@brief Enum constant Qt::ItemIsSelectable") +
    gsi::enum_const ("ItemIsEditable", Qt::ItemIsEditable, "@brief Enum constant Qt::ItemIsEditable") +
    gsi::enum_const ("ItemIsDragEnabled", Qt::ItemIsDragEnabled, "@brief Enum constant Qt::ItemIsDragEnabled") +
    gsi::enum_const ("ItemIsDropEnabled", Qt::ItemIsDropEnabled, "@brief Enum constant Qt::ItemIsDropEnabled") +
    gsi::enum_const ("ItemIsUserCheckable", Qt::ItemIsUserCheckable, "@brief Enum constant Qt::ItemIsUserCheckable") +
    gsi::enum_const ("ItemIsEnabled", Qt::ItemIsEnabled, "@brief Enum constant Qt::ItemIsEnabled") +
    gsi::enum_const ("ItemIsTristate", Qt::ItemIsTristate, "@brief Enum constant Qt::ItemIsTristate"),
  "@qt\n@brief This class represents the Qt::ItemFlag enum");

static gsi::QFlagsClass<Qt::ItemFlag > decl_Qt_ItemFlag_Enums ("QtCore", "Qt_QFlags_ItemFlag",
  "@qt\n@brief This class represents the QFlags<Qt::ItemFlag> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_ItemFlag_Enum_in_parent (decl_Qt_ItemFlag_Enum.defs ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_ItemFlag_Enum_as_child (decl_Qt_ItemFlag_Enum, "ItemFlag");
static gsi::ClassExt<Qt_Namespace> decl_Qt_ItemFlag_Enums_as_child (decl_Qt_ItemFlag_Enums, "QFlags_ItemFlag");

}


//  Implementation of the enum wrapper class for Qt::ItemSelectionMode
namespace qt_gsi
{

static gsi::Enum<Qt::ItemSelectionMode> decl_Qt_ItemSelectionMode_Enum ("QtCore", "Qt_ItemSelectionMode",
    gsi::enum_const ("ContainsItemShape", Qt::ContainsItemShape, "@brief Enum constant Qt::ContainsItemShape") +
    gsi::enum_const ("IntersectsItemShape", Qt::IntersectsItemShape, "@brief Enum constant Qt::IntersectsItemShape") +
    gsi::enum_const ("ContainsItemBoundingRect", Qt::ContainsItemBoundingRect, "@brief Enum constant Qt::ContainsItemBoundingRect") +
    gsi::enum_const ("IntersectsItemBoundingRect", Qt::IntersectsItemBoundingRect, "@brief Enum constant Qt::IntersectsItemBoundingRect"),
  "@qt\n@brief This class represents the Qt::ItemSelectionMode enum");

static gsi::QFlagsClass<Qt::ItemSelectionMode > decl_Qt_ItemSelectionMode_Enums ("QtCore", "Qt_QFlags_ItemSelectionMode",
  "@qt\n@brief This class represents the QFlags<Qt::ItemSelectionMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_ItemSelectionMode_Enum_in_parent (decl_Qt_ItemSelectionMode_Enum.defs ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_ItemSelectionMode_Enum_as_child (decl_Qt_ItemSelectionMode_Enum, "ItemSelectionMode");
static gsi::ClassExt<Qt_Namespace> decl_Qt_ItemSelectionMode_Enums_as_child (decl_Qt_ItemSelectionMode_Enums, "QFlags_ItemSelectionMode");

}


//  Implementation of the enum wrapper class for Qt::Key
namespace qt_gsi
{

static gsi::Enum<Qt::Key> decl_Qt_Key_Enum ("QtCore", "Qt_Key",
    gsi::enum_const ("Key_Escape", Qt::Key_Escape, "@brief Enum constant Qt::Key_Escape") +
    gsi::enum_const ("Key_Tab", Qt::Key_Tab, "@brief Enum constant Qt::Key_Tab") +
    gsi::enum_const ("Key_Backtab", Qt::Key_Backtab, "@brief Enum constant Qt::Key_Backtab") +
    gsi::enum_const ("Key_Backspace", Qt::Key_Backspace, "@brief Enum constant Qt::Key_Backspace") +
    gsi::enum_const ("Key_Return", Qt::Key_Return, "@brief Enum constant Qt::Key_Return") +
    gsi::enum_const ("Key_Enter", Qt::Key_Enter, "@brief Enum constant Qt::Key_Enter") +
    gsi::enum_const ("Key_Insert", Qt::Key_Insert, "@brief Enum constant Qt::Key_Insert") +
    gsi::enum_const ("Key_Delete", Qt::Key_Delete, "@brief Enum constant Qt::Key_Delete") +
    gsi::enum_const ("Key_Pause", Qt::Key_Pause, "@brief Enum constant Qt::Key_Pause") +
    gsi::enum_const ("Key_Print", Qt::Key_Print, "@brief Enum constant Qt::Key_Print") +
    gsi::enum_const ("Key_SysReq", Qt::Key_SysReq, "@brief Enum constant Qt::Key_SysReq") +
    gsi::enum_const ("Key_Clear", Qt::Key_Clear, "@brief Enum constant Qt::Key_Clear") +
    gsi::enum_const ("Key_Home", Qt::Key_Home, "@brief Enum constant Qt::Key_Home") +
    gsi::enum_const ("Key_End", Qt::Key_End, "@brief Enum constant Qt::Key_End") +
    gsi::enum_const ("Key_Left", Qt::Key_Left, "@brief Enum constant Qt::Key_Left") +
    gsi::enum_const ("Key_Up", Qt::Key_Up, "@brief Enum constant Qt::Key_Up") +
    gsi::enum_const ("Key_Right", Qt::Key_Right, "@brief Enum constant Qt::Key_Right") +
    gsi::enum_const ("Key_Down", Qt::Key_Down, "@brief Enum constant Qt::Key_Down") +
    gsi::enum_const ("Key_PageUp", Qt::Key_PageUp, "@brief Enum constant Qt::Key_PageUp") +
    gsi::enum_const ("Key_PageDown", Qt::Key_PageDown, "@brief Enum constant Qt::Key_PageDown") +
    gsi::enum_const ("Key_Shift", Qt::Key_Shift, "@brief Enum constant Qt::Key_Shift") +
    gsi::enum_const ("Key_Control", Qt::Key_Control, "@brief Enum constant Qt::Key_Control") +
    gsi::enum_const ("Key_Meta", Qt::Key_Meta, "@brief Enum constant Qt::Key_Meta") +
    gsi::enum_const ("Key_Alt", Qt::Key_Alt, "@brief Enum constant Qt::Key_Alt") +
    gsi::enum_const ("Key_CapsLock", Qt::Key_CapsLock, "@brief Enum constant Qt::Key_CapsLock") +
    gsi::enum_const ("Key_NumLock", Qt::Key_NumLock, "@brief Enum constant Qt::Key_NumLock") +
    gsi::enum_const ("Key_ScrollLock", Qt::Key_ScrollLock, "@brief Enum constant Qt::Key_ScrollLock") +
    gsi::enum_const ("Key_F1", Qt::Key_F1, "@brief Enum constant Qt::Key_F1") +
    gsi::enum_const ("Key_F2", Qt::Key_F2, "@brief Enum constant Qt::Key_F2") +
    gsi::enum_const ("Key_F3", Qt::Key_F3, "@brief Enum constant Qt::Key_F3") +
    gsi::enum_const ("Key_F4", Qt::Key_F4, "@brief Enum constant Qt::Key_F4") +
    gsi::enum_const ("Key_F5", Qt::Key_F5, "@brief Enum constant Qt::Key_F5") +
    gsi::enum_const ("Key_F6", Qt::Key_F6, "@brief Enum constant Qt::Key_F6") +
    gsi::enum_const ("Key_F7", Qt::Key_F7, "@brief Enum constant Qt::Key_F7") +
    gsi::enum_const ("Key_F8", Qt::Key_F8, "@brief Enum constant Qt::Key_F8") +
    gsi::enum_const ("Key_F9", Qt::Key_F9, "@brief Enum constant Qt::Key_F9") +
    gsi::enum_const ("Key_F10", Qt::Key_F10, "@brief Enum constant Qt::Key_F10") +
    gsi::enum_const ("Key_F11", Qt::Key_F11, "@brief Enum constant Qt::Key_F11") +
    gsi::enum_const ("Key_F12", Qt::Key_F12, "@brief Enum constant Qt::Key_F12") +
    gsi::enum_const ("Key_F13", Qt::Key_F13, "@brief Enum constant Qt::Key_F13") +
    gsi::enum_const ("Key_F14", Qt::Key_F14, "@brief Enum constant Qt::Key_F14") +
    gsi::enum_const ("Key_F15", Qt::Key_F15, "@brief Enum constant Qt::Key_F15") +
    gsi::enum_const ("Key_F16", Qt::Key_F16, "@brief Enum constant Qt::Key_F16") +
    gsi::enum_const ("Key_F17", Qt::Key_F17, "@brief Enum constant Qt::Key_F17") +
    gsi::enum_const ("Key_F18", Qt::Key_F18, "@brief Enum constant Qt::Key_F18") +
    gsi::enum_const ("Key_F19", Qt::Key_F19, "@brief Enum constant Qt::Key_F19") +
    gsi::enum_const ("Key_F20", Qt::Key_F20, "@brief Enum constant Qt::Key_F20") +
    gsi::enum_const ("Key_F21", Qt::Key_F21, "@brief Enum constant Qt::Key_F21") +
    gsi::enum_const ("Key_F22", Qt::Key_F22, "@brief Enum constant Qt::Key_F22") +
    gsi::enum_const ("Key_F23", Qt::Key_F23, "@brief Enum constant Qt::Key_F23") +
    gsi::enum_const ("Key_F24", Qt::Key_F24, "@brief Enum constant Qt::Key_F24") +
    gsi::enum_const ("Key_F25", Qt::Key_F25, "@brief Enum constant Qt::Key_F25") +
    gsi::enum_const ("Key_F26", Qt::Key_F26, "@brief Enum constant Qt::Key_F26") +
    gsi::enum_const ("Key_F27", Qt::Key_F27, "@brief Enum constant Qt::Key_F27") +
    gsi::enum_const ("Key_F28", Qt::Key_F28, "@brief Enum constant Qt::Key_F28") +
    gsi::enum_const ("Key_F29", Qt::Key_F29, "@brief Enum constant Qt::Key_F29") +
    gsi::enum_const ("Key_F30", Qt::Key_F30, "@brief Enum constant Qt::Key_F30") +
    gsi::enum_const ("Key_F31", Qt::Key_F31, "@brief Enum constant Qt::Key_F31") +
    gsi::enum_const ("Key_F32", Qt::Key_F32, "@brief Enum constant Qt::Key_F32") +
    gsi::enum_const ("Key_F33", Qt::Key_F33, "@brief Enum constant Qt::Key_F33") +
    gsi::enum_const ("Key_F34", Qt::Key_F34, "@brief Enum constant Qt::Key_F34") +
    gsi::enum_const ("Key_F35", Qt::Key_F35, "@brief Enum constant Qt::Key_F35") +
    gsi::enum_const ("Key_Super_L", Qt::Key_Super_L, "@brief Enum constant Qt::Key_Super_L") +
    gsi::enum_const ("Key_Super_R", Qt::Key_Super_R, "@brief Enum constant Qt::Key_Super_R") +
    gsi::enum_const ("Key_Menu", Qt::Key_Menu, "@brief Enum constant Qt::Key_Menu") +
    gsi::enum_const ("Key_Hyper_L", Qt::Key_Hyper_L, "@brief Enum constant Qt::Key_Hyper_L") +
    gsi::enum_const ("Key_Hyper_R", Qt::Key_Hyper_R, "@brief Enum constant Qt::Key_Hyper_R") +
    gsi::enum_const ("Key_Help", Qt::Key_Help, "@brief Enum constant Qt::Key_Help") +
    gsi::enum_const ("Key_Direction_L", Qt::Key_Direction_L, "@brief Enum constant Qt::Key_Direction_L") +
    gsi::enum_const ("Key_Direction_R", Qt::Key_Direction_R, "@brief Enum constant Qt::Key_Direction_R") +
    gsi::enum_const ("Key_Space", Qt::Key_Space, "@brief Enum constant Qt::Key_Space") +
    gsi::enum_const ("Key_Any", Qt::Key_Any, "@brief Enum constant Qt::Key_Any") +
    gsi::enum_const ("Key_Exclam", Qt::Key_Exclam, "@brief Enum constant Qt::Key_Exclam") +
    gsi::enum_const ("Key_QuoteDbl", Qt::Key_QuoteDbl, "@brief Enum constant Qt::Key_QuoteDbl") +
    gsi::enum_const ("Key_NumberSign", Qt::Key_NumberSign, "@brief Enum constant Qt::Key_NumberSign") +
    gsi::enum_const ("Key_Dollar", Qt::Key_Dollar, "@brief Enum constant Qt::Key_Dollar") +
    gsi::enum_const ("Key_Percent", Qt::Key_Percent, "@brief Enum constant Qt::Key_Percent") +
    gsi::enum_const ("Key_Ampersand", Qt::Key_Ampersand, "@brief Enum constant Qt::Key_Ampersand") +
    gsi::enum_const ("Key_Apostrophe", Qt::Key_Apostrophe, "@brief Enum constant Qt::Key_Apostrophe") +
    gsi::enum_const ("Key_ParenLeft", Qt::Key_ParenLeft, "@brief Enum constant Qt::Key_ParenLeft") +
    gsi::enum_const ("Key_ParenRight", Qt::Key_ParenRight, "@brief Enum constant Qt::Key_ParenRight") +
    gsi::enum_const ("Key_Asterisk", Qt::Key_Asterisk, "@brief Enum constant Qt::Key_Asterisk") +
    gsi::enum_const ("Key_Plus", Qt::Key_Plus, "@brief Enum constant Qt::Key_Plus") +
    gsi::enum_const ("Key_Comma", Qt::Key_Comma, "@brief Enum constant Qt::Key_Comma") +
    gsi::enum_const ("Key_Minus", Qt::Key_Minus, "@brief Enum constant Qt::Key_Minus") +
    gsi::enum_const ("Key_Period", Qt::Key_Period, "@brief Enum constant Qt::Key_Period") +
    gsi::enum_const ("Key_Slash", Qt::Key_Slash, "@brief Enum constant Qt::Key_Slash") +
    gsi::enum_const ("Key_0", Qt::Key_0, "@brief Enum constant Qt::Key_0") +
    gsi::enum_const ("Key_1", Qt::Key_1, "@brief Enum constant Qt::Key_1") +
    gsi::enum_const ("Key_2", Qt::Key_2, "@brief Enum constant Qt::Key_2") +
    gsi::enum_const ("Key_3", Qt::Key_3, "@brief Enum constant Qt::Key_3") +
    gsi::enum_const ("Key_4", Qt::Key_4, "@brief Enum constant Qt::Key_4") +
    gsi::enum_const ("Key_5", Qt::Key_5, "@brief Enum constant Qt::Key_5") +
    gsi::enum_const ("Key_6", Qt::Key_6, "@brief Enum constant Qt::Key_6") +
    gsi::enum_const ("Key_7", Qt::Key_7, "@brief Enum constant Qt::Key_7") +
    gsi::enum_const ("Key_8", Qt::Key_8, "@brief Enum constant Qt::Key_8") +
    gsi::enum_const ("Key_9", Qt::Key_9, "@brief Enum constant Qt::Key_9") +
    gsi::enum_const ("Key_Colon", Qt::Key_Colon, "@brief Enum constant Qt::Key_Colon") +
    gsi::enum_const ("Key_Semicolon", Qt::Key_Semicolon, "@brief Enum constant Qt::Key_Semicolon") +
    gsi::enum_const ("Key_Less", Qt::Key_Less, "@brief Enum constant Qt::Key_Less") +
    gsi::enum_const ("Key_Equal", Qt::Key_Equal, "@brief Enum constant Qt::Key_Equal") +
    gsi::enum_const ("Key_Greater", Qt::Key_Greater, "@brief Enum constant Qt::Key_Greater") +
    gsi::enum_const ("Key_Question", Qt::Key_Question, "@brief Enum constant Qt::Key_Question") +
    gsi::enum_const ("Key_At", Qt::Key_At, "@brief Enum constant Qt::Key_At") +
    gsi::enum_const ("Key_A", Qt::Key_A, "@brief Enum constant Qt::Key_A") +
    gsi::enum_const ("Key_B", Qt::Key_B, "@brief Enum constant Qt::Key_B") +
    gsi::enum_const ("Key_C", Qt::Key_C, "@brief Enum constant Qt::Key_C") +
    gsi::enum_const ("Key_D", Qt::Key_D, "@brief Enum constant Qt::Key_D") +
    gsi::enum_const ("Key_E", Qt::Key_E, "@brief Enum constant Qt::Key_E") +
    gsi::enum_const ("Key_F", Qt::Key_F, "@brief Enum constant Qt::Key_F") +
    gsi::enum_const ("Key_G", Qt::Key_G, "@brief Enum constant Qt::Key_G") +
    gsi::enum_const ("Key_H", Qt::Key_H, "@brief Enum constant Qt::Key_H") +
    gsi::enum_const ("Key_I", Qt::Key_I, "@brief Enum constant Qt::Key_I") +
    gsi::enum_const ("Key_J", Qt::Key_J, "@brief Enum constant Qt::Key_J") +
    gsi::enum_const ("Key_K", Qt::Key_K, "@brief Enum constant Qt::Key_K") +
    gsi::enum_const ("Key_L", Qt::Key_L, "@brief Enum constant Qt::Key_L") +
    gsi::enum_const ("Key_M", Qt::Key_M, "@brief Enum constant Qt::Key_M") +
    gsi::enum_const ("Key_N", Qt::Key_N, "@brief Enum constant Qt::Key_N") +
    gsi::enum_const ("Key_O", Qt::Key_O, "@brief Enum constant Qt::Key_O") +
    gsi::enum_const ("Key_P", Qt::Key_P, "@brief Enum constant Qt::Key_P") +
    gsi::enum_const ("Key_Q", Qt::Key_Q, "@brief Enum constant Qt::Key_Q") +
    gsi::enum_const ("Key_R", Qt::Key_R, "@brief Enum constant Qt::Key_R") +
    gsi::enum_const ("Key_S", Qt::Key_S, "@brief Enum constant Qt::Key_S") +
    gsi::enum_const ("Key_T", Qt::Key_T, "@brief Enum constant Qt::Key_T") +
    gsi::enum_const ("Key_U", Qt::Key_U, "@brief Enum constant Qt::Key_U") +
    gsi::enum_const ("Key_V", Qt::Key_V, "@brief Enum constant Qt::Key_V") +
    gsi::enum_const ("Key_W", Qt::Key_W, "@brief Enum constant Qt::Key_W") +
    gsi::enum_const ("Key_X", Qt::Key_X, "@brief Enum constant Qt::Key_X") +
    gsi::enum_const ("Key_Y", Qt::Key_Y, "@brief Enum constant Qt::Key_Y") +
    gsi::enum_const ("Key_Z", Qt::Key_Z, "@brief Enum constant Qt::Key_Z") +
    gsi::enum_const ("Key_BracketLeft", Qt::Key_BracketLeft, "@brief Enum constant Qt::Key_BracketLeft") +
    gsi::enum_const ("Key_Backslash", Qt::Key_Backslash, "@brief Enum constant Qt::Key_Backslash") +
    gsi::enum_const ("Key_BracketRight", Qt::Key_BracketRight, "@brief Enum constant Qt::Key_BracketRight") +
    gsi::enum_const ("Key_AsciiCircum", Qt::Key_AsciiCircum, "@brief Enum constant Qt::Key_AsciiCircum") +
    gsi::enum_const ("Key_Underscore", Qt::Key_Underscore, "@brief Enum constant Qt::Key_Underscore") +
    gsi::enum_const ("Key_QuoteLeft", Qt::Key_QuoteLeft, "@brief Enum constant Qt::Key_QuoteLeft") +
    gsi::enum_const ("Key_BraceLeft", Qt::Key_BraceLeft, "@brief Enum constant Qt::Key_BraceLeft") +
    gsi::enum_const ("Key_Bar", Qt::Key_Bar, "@brief Enum constant Qt::Key_Bar") +
    gsi::enum_const ("Key_BraceRight", Qt::Key_BraceRight, "@brief Enum constant Qt::Key_BraceRight") +
    gsi::enum_const ("Key_AsciiTilde", Qt::Key_AsciiTilde, "@brief Enum constant Qt::Key_AsciiTilde") +
    gsi::enum_const ("Key_nobreakspace", Qt::Key_nobreakspace, "@brief Enum constant Qt::Key_nobreakspace") +
    gsi::enum_const ("Key_exclamdown", Qt::Key_exclamdown, "@brief Enum constant Qt::Key_exclamdown") +
    gsi::enum_const ("Key_cent", Qt::Key_cent, "@brief Enum constant Qt::Key_cent") +
    gsi::enum_const ("Key_sterling", Qt::Key_sterling, "@brief Enum constant Qt::Key_sterling") +
    gsi::enum_const ("Key_currency", Qt::Key_currency, "@brief Enum constant Qt::Key_currency") +
    gsi::enum_const ("Key_yen", Qt::Key_yen, "@brief Enum constant Qt::Key_yen") +
    gsi::enum_const ("Key_brokenbar", Qt::Key_brokenbar, "@brief Enum constant Qt::Key_brokenbar") +
    gsi::enum_const ("Key_section", Qt::Key_section, "@brief Enum constant Qt::Key_section") +
    gsi::enum_const ("Key_diaeresis", Qt::Key_diaeresis, "@brief Enum constant Qt::Key_diaeresis") +
    gsi::enum_const ("Key_copyright", Qt::Key_copyright, "@brief Enum constant Qt::Key_copyright") +
    gsi::enum_const ("Key_ordfeminine", Qt::Key_ordfeminine, "@brief Enum constant Qt::Key_ordfeminine") +
    gsi::enum_const ("Key_guillemotleft", Qt::Key_guillemotleft, "@brief Enum constant Qt::Key_guillemotleft") +
    gsi::enum_const ("Key_notsign", Qt::Key_notsign, "@brief Enum constant Qt::Key_notsign") +
    gsi::enum_const ("Key_hyphen", Qt::Key_hyphen, "@brief Enum constant Qt::Key_hyphen") +
    gsi::enum_const ("Key_registered", Qt::Key_registered, "@brief Enum constant Qt::Key_registered") +
    gsi::enum_const ("Key_macron", Qt::Key_macron, "@brief Enum constant Qt::Key_macron") +
    gsi::enum_const ("Key_degree", Qt::Key_degree, "@brief Enum constant Qt::Key_degree") +
    gsi::enum_const ("Key_plusminus", Qt::Key_plusminus, "@brief Enum constant Qt::Key_plusminus") +
    gsi::enum_const ("Key_twosuperior", Qt::Key_twosuperior, "@brief Enum constant Qt::Key_twosuperior") +
    gsi::enum_const ("Key_threesuperior", Qt::Key_threesuperior, "@brief Enum constant Qt::Key_threesuperior") +
    gsi::enum_const ("Key_acute", Qt::Key_acute, "@brief Enum constant Qt::Key_acute") +
    gsi::enum_const ("Key_mu", Qt::Key_mu, "@brief Enum constant Qt::Key_mu") +
    gsi::enum_const ("Key_paragraph", Qt::Key_paragraph, "@brief Enum constant Qt::Key_paragraph") +
    gsi::enum_const ("Key_periodcentered", Qt::Key_periodcentered, "@brief Enum constant Qt::Key_periodcentered") +
    gsi::enum_const ("Key_cedilla", Qt::Key_cedilla, "@brief Enum constant Qt::Key_cedilla") +
    gsi::enum_const ("Key_onesuperior", Qt::Key_onesuperior, "@brief Enum constant Qt::Key_onesuperior") +
    gsi::enum_const ("Key_masculine", Qt::Key_masculine, "@brief Enum constant Qt::Key_masculine") +
    gsi::enum_const ("Key_guillemotright", Qt::Key_guillemotright, "@brief Enum constant Qt::Key_guillemotright") +
    gsi::enum_const ("Key_onequarter", Qt::Key_onequarter, "@brief Enum constant Qt::Key_onequarter") +
    gsi::enum_const ("Key_onehalf", Qt::Key_onehalf, "@brief Enum constant Qt::Key_onehalf") +
    gsi::enum_const ("Key_threequarters", Qt::Key_threequarters, "@brief Enum constant Qt::Key_threequarters") +
    gsi::enum_const ("Key_questiondown", Qt::Key_questiondown, "@brief Enum constant Qt::Key_questiondown") +
    gsi::enum_const ("Key_Agrave", Qt::Key_Agrave, "@brief Enum constant Qt::Key_Agrave") +
    gsi::enum_const ("Key_Aacute", Qt::Key_Aacute, "@brief Enum constant Qt::Key_Aacute") +
    gsi::enum_const ("Key_Acircumflex", Qt::Key_Acircumflex, "@brief Enum constant Qt::Key_Acircumflex") +
    gsi::enum_const ("Key_Atilde", Qt::Key_Atilde, "@brief Enum constant Qt::Key_Atilde") +
    gsi::enum_const ("Key_Adiaeresis", Qt::Key_Adiaeresis, "@brief Enum constant Qt::Key_Adiaeresis") +
    gsi::enum_const ("Key_Aring", Qt::Key_Aring, "@brief Enum constant Qt::Key_Aring") +
    gsi::enum_const ("Key_AE", Qt::Key_AE, "@brief Enum constant Qt::Key_AE") +
    gsi::enum_const ("Key_Ccedilla", Qt::Key_Ccedilla, "@brief Enum constant Qt::Key_Ccedilla") +
    gsi::enum_const ("Key_Egrave", Qt::Key_Egrave, "@brief Enum constant Qt::Key_Egrave") +
    gsi::enum_const ("Key_Eacute", Qt::Key_Eacute, "@brief Enum constant Qt::Key_Eacute") +
    gsi::enum_const ("Key_Ecircumflex", Qt::Key_Ecircumflex, "@brief Enum constant Qt::Key_Ecircumflex") +
    gsi::enum_const ("Key_Ediaeresis", Qt::Key_Ediaeresis, "@brief Enum constant Qt::Key_Ediaeresis") +
    gsi::enum_const ("Key_Igrave", Qt::Key_Igrave, "@brief Enum constant Qt::Key_Igrave") +
    gsi::enum_const ("Key_Iacute", Qt::Key_Iacute, "@brief Enum constant Qt::Key_Iacute") +
    gsi::enum_const ("Key_Icircumflex", Qt::Key_Icircumflex, "@brief Enum constant Qt::Key_Icircumflex") +
    gsi::enum_const ("Key_Idiaeresis", Qt::Key_Idiaeresis, "@brief Enum constant Qt::Key_Idiaeresis") +
    gsi::enum_const ("Key_ETH", Qt::Key_ETH, "@brief Enum constant Qt::Key_ETH") +
    gsi::enum_const ("Key_Ntilde", Qt::Key_Ntilde, "@brief Enum constant Qt::Key_Ntilde") +
    gsi::enum_const ("Key_Ograve", Qt::Key_Ograve, "@brief Enum constant Qt::Key_Ograve") +
    gsi::enum_const ("Key_Oacute", Qt::Key_Oacute, "@brief Enum constant Qt::Key_Oacute") +
    gsi::enum_const ("Key_Ocircumflex", Qt::Key_Ocircumflex, "@brief Enum constant Qt::Key_Ocircumflex") +
    gsi::enum_const ("Key_Otilde", Qt::Key_Otilde, "@brief Enum constant Qt::Key_Otilde") +
    gsi::enum_const ("Key_Odiaeresis", Qt::Key_Odiaeresis, "@brief Enum constant Qt::Key_Odiaeresis") +
    gsi::enum_const ("Key_multiply", Qt::Key_multiply, "@brief Enum constant Qt::Key_multiply") +
    gsi::enum_const ("Key_Ooblique", Qt::Key_Ooblique, "@brief Enum constant Qt::Key_Ooblique") +
    gsi::enum_const ("Key_Ugrave", Qt::Key_Ugrave, "@brief Enum constant Qt::Key_Ugrave") +
    gsi::enum_const ("Key_Uacute", Qt::Key_Uacute, "@brief Enum constant Qt::Key_Uacute") +
    gsi::enum_const ("Key_Ucircumflex", Qt::Key_Ucircumflex, "@brief Enum constant Qt::Key_Ucircumflex") +
    gsi::enum_const ("Key_Udiaeresis", Qt::Key_Udiaeresis, "@brief Enum constant Qt::Key_Udiaeresis") +
    gsi::enum_const ("Key_Yacute", Qt::Key_Yacute, "@brief Enum constant Qt::Key_Yacute") +
    gsi::enum_const ("Key_THORN", Qt::Key_THORN, "@brief Enum constant Qt::Key_THORN") +
    gsi::enum_const ("Key_ssharp", Qt::Key_ssharp, "@brief Enum constant Qt::Key_ssharp") +
    gsi::enum_const ("Key_division", Qt::Key_division, "@brief Enum constant Qt::Key_division") +
    gsi::enum_const ("Key_ydiaeresis", Qt::Key_ydiaeresis, "@brief Enum constant Qt::Key_ydiaeresis") +
    gsi::enum_const ("Key_AltGr", Qt::Key_AltGr, "@brief Enum constant Qt::Key_AltGr") +
    gsi::enum_const ("Key_Multi_key", Qt::Key_Multi_key, "@brief Enum constant Qt::Key_Multi_key") +
    gsi::enum_const ("Key_Codeinput", Qt::Key_Codeinput, "@brief Enum constant Qt::Key_Codeinput") +
    gsi::enum_const ("Key_SingleCandidate", Qt::Key_SingleCandidate, "@brief Enum constant Qt::Key_SingleCandidate") +
    gsi::enum_const ("Key_MultipleCandidate", Qt::Key_MultipleCandidate, "@brief Enum constant Qt::Key_MultipleCandidate") +
    gsi::enum_const ("Key_PreviousCandidate", Qt::Key_PreviousCandidate, "@brief Enum constant Qt::Key_PreviousCandidate") +
    gsi::enum_const ("Key_Mode_switch", Qt::Key_Mode_switch, "@brief Enum constant Qt::Key_Mode_switch") +
    gsi::enum_const ("Key_Kanji", Qt::Key_Kanji, "@brief Enum constant Qt::Key_Kanji") +
    gsi::enum_const ("Key_Muhenkan", Qt::Key_Muhenkan, "@brief Enum constant Qt::Key_Muhenkan") +
    gsi::enum_const ("Key_Henkan", Qt::Key_Henkan, "@brief Enum constant Qt::Key_Henkan") +
    gsi::enum_const ("Key_Romaji", Qt::Key_Romaji, "@brief Enum constant Qt::Key_Romaji") +
    gsi::enum_const ("Key_Hiragana", Qt::Key_Hiragana, "@brief Enum constant Qt::Key_Hiragana") +
    gsi::enum_const ("Key_Katakana", Qt::Key_Katakana, "@brief Enum constant Qt::Key_Katakana") +
    gsi::enum_const ("Key_Hiragana_Katakana", Qt::Key_Hiragana_Katakana, "@brief Enum constant Qt::Key_Hiragana_Katakana") +
    gsi::enum_const ("Key_Zenkaku", Qt::Key_Zenkaku, "@brief Enum constant Qt::Key_Zenkaku") +
    gsi::enum_const ("Key_Hankaku", Qt::Key_Hankaku, "@brief Enum constant Qt::Key_Hankaku") +
    gsi::enum_const ("Key_Zenkaku_Hankaku", Qt::Key_Zenkaku_Hankaku, "@brief Enum constant Qt::Key_Zenkaku_Hankaku") +
    gsi::enum_const ("Key_Touroku", Qt::Key_Touroku, "@brief Enum constant Qt::Key_Touroku") +
    gsi::enum_const ("Key_Massyo", Qt::Key_Massyo, "@brief Enum constant Qt::Key_Massyo") +
    gsi::enum_const ("Key_Kana_Lock", Qt::Key_Kana_Lock, "@brief Enum constant Qt::Key_Kana_Lock") +
    gsi::enum_const ("Key_Kana_Shift", Qt::Key_Kana_Shift, "@brief Enum constant Qt::Key_Kana_Shift") +
    gsi::enum_const ("Key_Eisu_Shift", Qt::Key_Eisu_Shift, "@brief Enum constant Qt::Key_Eisu_Shift") +
    gsi::enum_const ("Key_Eisu_toggle", Qt::Key_Eisu_toggle, "@brief Enum constant Qt::Key_Eisu_toggle") +
    gsi::enum_const ("Key_Hangul", Qt::Key_Hangul, "@brief Enum constant Qt::Key_Hangul") +
    gsi::enum_const ("Key_Hangul_Start", Qt::Key_Hangul_Start, "@brief Enum constant Qt::Key_Hangul_Start") +
    gsi::enum_const ("Key_Hangul_End", Qt::Key_Hangul_End, "@brief Enum constant Qt::Key_Hangul_End") +
    gsi::enum_const ("Key_Hangul_Hanja", Qt::Key_Hangul_Hanja, "@brief Enum constant Qt::Key_Hangul_Hanja") +
    gsi::enum_const ("Key_Hangul_Jamo", Qt::Key_Hangul_Jamo, "@brief Enum constant Qt::Key_Hangul_Jamo") +
    gsi::enum_const ("Key_Hangul_Romaja", Qt::Key_Hangul_Romaja, "@brief Enum constant Qt::Key_Hangul_Romaja") +
    gsi::enum_const ("Key_Hangul_Jeonja", Qt::Key_Hangul_Jeonja, "@brief Enum constant Qt::Key_Hangul_Jeonja") +
    gsi::enum_const ("Key_Hangul_Banja", Qt::Key_Hangul_Banja, "@brief Enum constant Qt::Key_Hangul_Banja") +
    gsi::enum_const ("Key_Hangul_PreHanja", Qt::Key_Hangul_PreHanja, "@brief Enum constant Qt::Key_Hangul_PreHanja") +
    gsi::enum_const ("Key_Hangul_PostHanja", Qt::Key_Hangul_PostHanja, "@brief Enum constant Qt::Key_Hangul_PostHanja") +
    gsi::enum_const ("Key_Hangul_Special", Qt::Key_Hangul_Special, "@brief Enum constant Qt::Key_Hangul_Special") +
    gsi::enum_const ("Key_Dead_Grave", Qt::Key_Dead_Grave, "@brief Enum constant Qt::Key_Dead_Grave") +
    gsi::enum_const ("Key_Dead_Acute", Qt::Key_Dead_Acute, "@brief Enum constant Qt::Key_Dead_Acute") +
    gsi::enum_const ("Key_Dead_Circumflex", Qt::Key_Dead_Circumflex, "@brief Enum constant Qt::Key_Dead_Circumflex") +
    gsi::enum_const ("Key_Dead_Tilde", Qt::Key_Dead_Tilde, "@brief Enum constant Qt::Key_Dead_Tilde") +
    gsi::enum_const ("Key_Dead_Macron", Qt::Key_Dead_Macron, "@brief Enum constant Qt::Key_Dead_Macron") +
    gsi::enum_const ("Key_Dead_Breve", Qt::Key_Dead_Breve, "@brief Enum constant Qt::Key_Dead_Breve") +
    gsi::enum_const ("Key_Dead_Abovedot", Qt::Key_Dead_Abovedot, "@brief Enum constant Qt::Key_Dead_Abovedot") +
    gsi::enum_const ("Key_Dead_Diaeresis", Qt::Key_Dead_Diaeresis, "@brief Enum constant Qt::Key_Dead_Diaeresis") +
    gsi::enum_const ("Key_Dead_Abovering", Qt::Key_Dead_Abovering, "@brief Enum constant Qt::Key_Dead_Abovering") +
    gsi::enum_const ("Key_Dead_Doubleacute", Qt::Key_Dead_Doubleacute, "@brief Enum constant Qt::Key_Dead_Doubleacute") +
    gsi::enum_const ("Key_Dead_Caron", Qt::Key_Dead_Caron, "@brief Enum constant Qt::Key_Dead_Caron") +
    gsi::enum_const ("Key_Dead_Cedilla", Qt::Key_Dead_Cedilla, "@brief Enum constant Qt::Key_Dead_Cedilla") +
    gsi::enum_const ("Key_Dead_Ogonek", Qt::Key_Dead_Ogonek, "@brief Enum constant Qt::Key_Dead_Ogonek") +
    gsi::enum_const ("Key_Dead_Iota", Qt::Key_Dead_Iota, "@brief Enum constant Qt::Key_Dead_Iota") +
    gsi::enum_const ("Key_Dead_Voiced_Sound", Qt::Key_Dead_Voiced_Sound, "@brief Enum constant Qt::Key_Dead_Voiced_Sound") +
    gsi::enum_const ("Key_Dead_Semivoiced_Sound", Qt::Key_Dead_Semivoiced_Sound, "@brief Enum constant Qt::Key_Dead_Semivoiced_Sound") +
    gsi::enum_const ("Key_Dead_Belowdot", Qt::Key_Dead_Belowdot, "@brief Enum constant Qt::Key_Dead_Belowdot") +
    gsi::enum_const ("Key_Dead_Hook", Qt::Key_Dead_Hook, "@brief Enum constant Qt::Key_Dead_Hook") +
    gsi::enum_const ("Key_Dead_Horn", Qt::Key_Dead_Horn, "@brief Enum constant Qt::Key_Dead_Horn") +
    gsi::enum_const ("Key_Back", Qt::Key_Back, "@brief Enum constant Qt::Key_Back") +
    gsi::enum_const ("Key_Forward", Qt::Key_Forward, "@brief Enum constant Qt::Key_Forward") +
    gsi::enum_const ("Key_Stop", Qt::Key_Stop, "@brief Enum constant Qt::Key_Stop") +
    gsi::enum_const ("Key_Refresh", Qt::Key_Refresh, "@brief Enum constant Qt::Key_Refresh") +
    gsi::enum_const ("Key_VolumeDown", Qt::Key_VolumeDown, "@brief Enum constant Qt::Key_VolumeDown") +
    gsi::enum_const ("Key_VolumeMute", Qt::Key_VolumeMute, "@brief Enum constant Qt::Key_VolumeMute") +
    gsi::enum_const ("Key_VolumeUp", Qt::Key_VolumeUp, "@brief Enum constant Qt::Key_VolumeUp") +
    gsi::enum_const ("Key_BassBoost", Qt::Key_BassBoost, "@brief Enum constant Qt::Key_BassBoost") +
    gsi::enum_const ("Key_BassUp", Qt::Key_BassUp, "@brief Enum constant Qt::Key_BassUp") +
    gsi::enum_const ("Key_BassDown", Qt::Key_BassDown, "@brief Enum constant Qt::Key_BassDown") +
    gsi::enum_const ("Key_TrebleUp", Qt::Key_TrebleUp, "@brief Enum constant Qt::Key_TrebleUp") +
    gsi::enum_const ("Key_TrebleDown", Qt::Key_TrebleDown, "@brief Enum constant Qt::Key_TrebleDown") +
    gsi::enum_const ("Key_MediaPlay", Qt::Key_MediaPlay, "@brief Enum constant Qt::Key_MediaPlay") +
    gsi::enum_const ("Key_MediaStop", Qt::Key_MediaStop, "@brief Enum constant Qt::Key_MediaStop") +
    gsi::enum_const ("Key_MediaPrevious", Qt::Key_MediaPrevious, "@brief Enum constant Qt::Key_MediaPrevious") +
    gsi::enum_const ("Key_MediaNext", Qt::Key_MediaNext, "@brief Enum constant Qt::Key_MediaNext") +
    gsi::enum_const ("Key_MediaRecord", Qt::Key_MediaRecord, "@brief Enum constant Qt::Key_MediaRecord") +
    gsi::enum_const ("Key_HomePage", Qt::Key_HomePage, "@brief Enum constant Qt::Key_HomePage") +
    gsi::enum_const ("Key_Favorites", Qt::Key_Favorites, "@brief Enum constant Qt::Key_Favorites") +
    gsi::enum_const ("Key_Search", Qt::Key_Search, "@brief Enum constant Qt::Key_Search") +
    gsi::enum_const ("Key_Standby", Qt::Key_Standby, "@brief Enum constant Qt::Key_Standby") +
    gsi::enum_const ("Key_OpenUrl", Qt::Key_OpenUrl, "@brief Enum constant Qt::Key_OpenUrl") +
    gsi::enum_const ("Key_LaunchMail", Qt::Key_LaunchMail, "@brief Enum constant Qt::Key_LaunchMail") +
    gsi::enum_const ("Key_LaunchMedia", Qt::Key_LaunchMedia, "@brief Enum constant Qt::Key_LaunchMedia") +
    gsi::enum_const ("Key_Launch0", Qt::Key_Launch0, "@brief Enum constant Qt::Key_Launch0") +
    gsi::enum_const ("Key_Launch1", Qt::Key_Launch1, "@brief Enum constant Qt::Key_Launch1") +
    gsi::enum_const ("Key_Launch2", Qt::Key_Launch2, "@brief Enum constant Qt::Key_Launch2") +
    gsi::enum_const ("Key_Launch3", Qt::Key_Launch3, "@brief Enum constant Qt::Key_Launch3") +
    gsi::enum_const ("Key_Launch4", Qt::Key_Launch4, "@brief Enum constant Qt::Key_Launch4") +
    gsi::enum_const ("Key_Launch5", Qt::Key_Launch5, "@brief Enum constant Qt::Key_Launch5") +
    gsi::enum_const ("Key_Launch6", Qt::Key_Launch6, "@brief Enum constant Qt::Key_Launch6") +
    gsi::enum_const ("Key_Launch7", Qt::Key_Launch7, "@brief Enum constant Qt::Key_Launch7") +
    gsi::enum_const ("Key_Launch8", Qt::Key_Launch8, "@brief Enum constant Qt::Key_Launch8") +
    gsi::enum_const ("Key_Launch9", Qt::Key_Launch9, "@brief Enum constant Qt::Key_Launch9") +
    gsi::enum_const ("Key_LaunchA", Qt::Key_LaunchA, "@brief Enum constant Qt::Key_LaunchA") +
    gsi::enum_const ("Key_LaunchB", Qt::Key_LaunchB, "@brief Enum constant Qt::Key_LaunchB") +
    gsi::enum_const ("Key_LaunchC", Qt::Key_LaunchC, "@brief Enum constant Qt::Key_LaunchC") +
    gsi::enum_const ("Key_LaunchD", Qt::Key_LaunchD, "@brief Enum constant Qt::Key_LaunchD") +
    gsi::enum_const ("Key_LaunchE", Qt::Key_LaunchE, "@brief Enum constant Qt::Key_LaunchE") +
    gsi::enum_const ("Key_LaunchF", Qt::Key_LaunchF, "@brief Enum constant Qt::Key_LaunchF") +
    gsi::enum_const ("Key_MonBrightnessUp", Qt::Key_MonBrightnessUp, "@brief Enum constant Qt::Key_MonBrightnessUp") +
    gsi::enum_const ("Key_MonBrightnessDown", Qt::Key_MonBrightnessDown, "@brief Enum constant Qt::Key_MonBrightnessDown") +
    gsi::enum_const ("Key_KeyboardLightOnOff", Qt::Key_KeyboardLightOnOff, "@brief Enum constant Qt::Key_KeyboardLightOnOff") +
    gsi::enum_const ("Key_KeyboardBrightnessUp", Qt::Key_KeyboardBrightnessUp, "@brief Enum constant Qt::Key_KeyboardBrightnessUp") +
    gsi::enum_const ("Key_KeyboardBrightnessDown", Qt::Key_KeyboardBrightnessDown, "@brief Enum constant Qt::Key_KeyboardBrightnessDown") +
    gsi::enum_const ("Key_PowerOff", Qt::Key_PowerOff, "@brief Enum constant Qt::Key_PowerOff") +
    gsi::enum_const ("Key_WakeUp", Qt::Key_WakeUp, "@brief Enum constant Qt::Key_WakeUp") +
    gsi::enum_const ("Key_Eject", Qt::Key_Eject, "@brief Enum constant Qt::Key_Eject") +
    gsi::enum_const ("Key_ScreenSaver", Qt::Key_ScreenSaver, "@brief Enum constant Qt::Key_ScreenSaver") +
    gsi::enum_const ("Key_WWW", Qt::Key_WWW, "@brief Enum constant Qt::Key_WWW") +
    gsi::enum_const ("Key_Memo", Qt::Key_Memo, "@brief Enum constant Qt::Key_Memo") +
    gsi::enum_const ("Key_LightBulb", Qt::Key_LightBulb, "@brief Enum constant Qt::Key_LightBulb") +
    gsi::enum_const ("Key_Shop", Qt::Key_Shop, "@brief Enum constant Qt::Key_Shop") +
    gsi::enum_const ("Key_History", Qt::Key_History, "@brief Enum constant Qt::Key_History") +
    gsi::enum_const ("Key_AddFavorite", Qt::Key_AddFavorite, "@brief Enum constant Qt::Key_AddFavorite") +
    gsi::enum_const ("Key_HotLinks", Qt::Key_HotLinks, "@brief Enum constant Qt::Key_HotLinks") +
    gsi::enum_const ("Key_BrightnessAdjust", Qt::Key_BrightnessAdjust, "@brief Enum constant Qt::Key_BrightnessAdjust") +
    gsi::enum_const ("Key_Finance", Qt::Key_Finance, "@brief Enum constant Qt::Key_Finance") +
    gsi::enum_const ("Key_Community", Qt::Key_Community, "@brief Enum constant Qt::Key_Community") +
    gsi::enum_const ("Key_AudioRewind", Qt::Key_AudioRewind, "@brief Enum constant Qt::Key_AudioRewind") +
    gsi::enum_const ("Key_BackForward", Qt::Key_BackForward, "@brief Enum constant Qt::Key_BackForward") +
    gsi::enum_const ("Key_ApplicationLeft", Qt::Key_ApplicationLeft, "@brief Enum constant Qt::Key_ApplicationLeft") +
    gsi::enum_const ("Key_ApplicationRight", Qt::Key_ApplicationRight, "@brief Enum constant Qt::Key_ApplicationRight") +
    gsi::enum_const ("Key_Book", Qt::Key_Book, "@brief Enum constant Qt::Key_Book") +
    gsi::enum_const ("Key_CD", Qt::Key_CD, "@brief Enum constant Qt::Key_CD") +
    gsi::enum_const ("Key_Calculator", Qt::Key_Calculator, "@brief Enum constant Qt::Key_Calculator") +
    gsi::enum_const ("Key_ToDoList", Qt::Key_ToDoList, "@brief Enum constant Qt::Key_ToDoList") +
    gsi::enum_const ("Key_ClearGrab", Qt::Key_ClearGrab, "@brief Enum constant Qt::Key_ClearGrab") +
    gsi::enum_const ("Key_Close", Qt::Key_Close, "@brief Enum constant Qt::Key_Close") +
    gsi::enum_const ("Key_Copy", Qt::Key_Copy, "@brief Enum constant Qt::Key_Copy") +
    gsi::enum_const ("Key_Cut", Qt::Key_Cut, "@brief Enum constant Qt::Key_Cut") +
    gsi::enum_const ("Key_Display", Qt::Key_Display, "@brief Enum constant Qt::Key_Display") +
    gsi::enum_const ("Key_DOS", Qt::Key_DOS, "@brief Enum constant Qt::Key_DOS") +
    gsi::enum_const ("Key_Documents", Qt::Key_Documents, "@brief Enum constant Qt::Key_Documents") +
    gsi::enum_const ("Key_Excel", Qt::Key_Excel, "@brief Enum constant Qt::Key_Excel") +
    gsi::enum_const ("Key_Explorer", Qt::Key_Explorer, "@brief Enum constant Qt::Key_Explorer") +
    gsi::enum_const ("Key_Game", Qt::Key_Game, "@brief Enum constant Qt::Key_Game") +
    gsi::enum_const ("Key_Go", Qt::Key_Go, "@brief Enum constant Qt::Key_Go") +
    gsi::enum_const ("Key_iTouch", Qt::Key_iTouch, "@brief Enum constant Qt::Key_iTouch") +
    gsi::enum_const ("Key_LogOff", Qt::Key_LogOff, "@brief Enum constant Qt::Key_LogOff") +
    gsi::enum_const ("Key_Market", Qt::Key_Market, "@brief Enum constant Qt::Key_Market") +
    gsi::enum_const ("Key_Meeting", Qt::Key_Meeting, "@brief Enum constant Qt::Key_Meeting") +
    gsi::enum_const ("Key_MenuKB", Qt::Key_MenuKB, "@brief Enum constant Qt::Key_MenuKB") +
    gsi::enum_const ("Key_MenuPB", Qt::Key_MenuPB, "@brief Enum constant Qt::Key_MenuPB") +
    gsi::enum_const ("Key_MySites", Qt::Key_MySites, "@brief Enum constant Qt::Key_MySites") +
    gsi::enum_const ("Key_News", Qt::Key_News, "@brief Enum constant Qt::Key_News") +
    gsi::enum_const ("Key_OfficeHome", Qt::Key_OfficeHome, "@brief Enum constant Qt::Key_OfficeHome") +
    gsi::enum_const ("Key_Option", Qt::Key_Option, "@brief Enum constant Qt::Key_Option") +
    gsi::enum_const ("Key_Paste", Qt::Key_Paste, "@brief Enum constant Qt::Key_Paste") +
    gsi::enum_const ("Key_Phone", Qt::Key_Phone, "@brief Enum constant Qt::Key_Phone") +
    gsi::enum_const ("Key_Calendar", Qt::Key_Calendar, "@brief Enum constant Qt::Key_Calendar") +
    gsi::enum_const ("Key_Reply", Qt::Key_Reply, "@brief Enum constant Qt::Key_Reply") +
    gsi::enum_const ("Key_Reload", Qt::Key_Reload, "@brief Enum constant Qt::Key_Reload") +
    gsi::enum_const ("Key_RotateWindows", Qt::Key_RotateWindows, "@brief Enum constant Qt::Key_RotateWindows") +
    gsi::enum_const ("Key_RotationPB", Qt::Key_RotationPB, "@brief Enum constant Qt::Key_RotationPB") +
    gsi::enum_const ("Key_RotationKB", Qt::Key_RotationKB, "@brief Enum constant Qt::Key_RotationKB") +
    gsi::enum_const ("Key_Save", Qt::Key_Save, "@brief Enum constant Qt::Key_Save") +
    gsi::enum_const ("Key_Send", Qt::Key_Send, "@brief Enum constant Qt::Key_Send") +
    gsi::enum_const ("Key_Spell", Qt::Key_Spell, "@brief Enum constant Qt::Key_Spell") +
    gsi::enum_const ("Key_SplitScreen", Qt::Key_SplitScreen, "@brief Enum constant Qt::Key_SplitScreen") +
    gsi::enum_const ("Key_Support", Qt::Key_Support, "@brief Enum constant Qt::Key_Support") +
    gsi::enum_const ("Key_TaskPane", Qt::Key_TaskPane, "@brief Enum constant Qt::Key_TaskPane") +
    gsi::enum_const ("Key_Terminal", Qt::Key_Terminal, "@brief Enum constant Qt::Key_Terminal") +
    gsi::enum_const ("Key_Tools", Qt::Key_Tools, "@brief Enum constant Qt::Key_Tools") +
    gsi::enum_const ("Key_Travel", Qt::Key_Travel, "@brief Enum constant Qt::Key_Travel") +
    gsi::enum_const ("Key_Video", Qt::Key_Video, "@brief Enum constant Qt::Key_Video") +
    gsi::enum_const ("Key_Word", Qt::Key_Word, "@brief Enum constant Qt::Key_Word") +
    gsi::enum_const ("Key_Xfer", Qt::Key_Xfer, "@brief Enum constant Qt::Key_Xfer") +
    gsi::enum_const ("Key_ZoomIn", Qt::Key_ZoomIn, "@brief Enum constant Qt::Key_ZoomIn") +
    gsi::enum_const ("Key_ZoomOut", Qt::Key_ZoomOut, "@brief Enum constant Qt::Key_ZoomOut") +
    gsi::enum_const ("Key_Away", Qt::Key_Away, "@brief Enum constant Qt::Key_Away") +
    gsi::enum_const ("Key_Messenger", Qt::Key_Messenger, "@brief Enum constant Qt::Key_Messenger") +
    gsi::enum_const ("Key_WebCam", Qt::Key_WebCam, "@brief Enum constant Qt::Key_WebCam") +
    gsi::enum_const ("Key_MailForward", Qt::Key_MailForward, "@brief Enum constant Qt::Key_MailForward") +
    gsi::enum_const ("Key_Pictures", Qt::Key_Pictures, "@brief Enum constant Qt::Key_Pictures") +
    gsi::enum_const ("Key_Music", Qt::Key_Music, "@brief Enum constant Qt::Key_Music") +
    gsi::enum_const ("Key_Battery", Qt::Key_Battery, "@brief Enum constant Qt::Key_Battery") +
    gsi::enum_const ("Key_Bluetooth", Qt::Key_Bluetooth, "@brief Enum constant Qt::Key_Bluetooth") +
    gsi::enum_const ("Key_WLAN", Qt::Key_WLAN, "@brief Enum constant Qt::Key_WLAN") +
    gsi::enum_const ("Key_UWB", Qt::Key_UWB, "@brief Enum constant Qt::Key_UWB") +
    gsi::enum_const ("Key_AudioForward", Qt::Key_AudioForward, "@brief Enum constant Qt::Key_AudioForward") +
    gsi::enum_const ("Key_AudioRepeat", Qt::Key_AudioRepeat, "@brief Enum constant Qt::Key_AudioRepeat") +
    gsi::enum_const ("Key_AudioRandomPlay", Qt::Key_AudioRandomPlay, "@brief Enum constant Qt::Key_AudioRandomPlay") +
    gsi::enum_const ("Key_Subtitle", Qt::Key_Subtitle, "@brief Enum constant Qt::Key_Subtitle") +
    gsi::enum_const ("Key_AudioCycleTrack", Qt::Key_AudioCycleTrack, "@brief Enum constant Qt::Key_AudioCycleTrack") +
    gsi::enum_const ("Key_Time", Qt::Key_Time, "@brief Enum constant Qt::Key_Time") +
    gsi::enum_const ("Key_Hibernate", Qt::Key_Hibernate, "@brief Enum constant Qt::Key_Hibernate") +
    gsi::enum_const ("Key_View", Qt::Key_View, "@brief Enum constant Qt::Key_View") +
    gsi::enum_const ("Key_TopMenu", Qt::Key_TopMenu, "@brief Enum constant Qt::Key_TopMenu") +
    gsi::enum_const ("Key_PowerDown", Qt::Key_PowerDown, "@brief Enum constant Qt::Key_PowerDown") +
    gsi::enum_const ("Key_Suspend", Qt::Key_Suspend, "@brief Enum constant Qt::Key_Suspend") +
    gsi::enum_const ("Key_ContrastAdjust", Qt::Key_ContrastAdjust, "@brief Enum constant Qt::Key_ContrastAdjust") +
    gsi::enum_const ("Key_MediaLast", Qt::Key_MediaLast, "@brief Enum constant Qt::Key_MediaLast") +
    gsi::enum_const ("Key_Select", Qt::Key_Select, "@brief Enum constant Qt::Key_Select") +
    gsi::enum_const ("Key_Yes", Qt::Key_Yes, "@brief Enum constant Qt::Key_Yes") +
    gsi::enum_const ("Key_No", Qt::Key_No, "@brief Enum constant Qt::Key_No") +
    gsi::enum_const ("Key_Cancel", Qt::Key_Cancel, "@brief Enum constant Qt::Key_Cancel") +
    gsi::enum_const ("Key_Printer", Qt::Key_Printer, "@brief Enum constant Qt::Key_Printer") +
    gsi::enum_const ("Key_Execute", Qt::Key_Execute, "@brief Enum constant Qt::Key_Execute") +
    gsi::enum_const ("Key_Sleep", Qt::Key_Sleep, "@brief Enum constant Qt::Key_Sleep") +
    gsi::enum_const ("Key_Play", Qt::Key_Play, "@brief Enum constant Qt::Key_Play") +
    gsi::enum_const ("Key_Zoom", Qt::Key_Zoom, "@brief Enum constant Qt::Key_Zoom") +
    gsi::enum_const ("Key_Context1", Qt::Key_Context1, "@brief Enum constant Qt::Key_Context1") +
    gsi::enum_const ("Key_Context2", Qt::Key_Context2, "@brief Enum constant Qt::Key_Context2") +
    gsi::enum_const ("Key_Context3", Qt::Key_Context3, "@brief Enum constant Qt::Key_Context3") +
    gsi::enum_const ("Key_Context4", Qt::Key_Context4, "@brief Enum constant Qt::Key_Context4") +
    gsi::enum_const ("Key_Call", Qt::Key_Call, "@brief Enum constant Qt::Key_Call") +
    gsi::enum_const ("Key_Hangup", Qt::Key_Hangup, "@brief Enum constant Qt::Key_Hangup") +
    gsi::enum_const ("Key_Flip", Qt::Key_Flip, "@brief Enum constant Qt::Key_Flip") +
    gsi::enum_const ("Key_unknown", Qt::Key_unknown, "@brief Enum constant Qt::Key_unknown"),
  "@qt\n@brief This class represents the Qt::Key enum");

static gsi::QFlagsClass<Qt::Key > decl_Qt_Key_Enums ("QtCore", "Qt_QFlags_Key",
  "@qt\n@brief This class represents the QFlags<Qt::Key> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_Key_Enum_in_parent (decl_Qt_Key_Enum.defs ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_Key_Enum_as_child (decl_Qt_Key_Enum, "Key");
static gsi::ClassExt<Qt_Namespace> decl_Qt_Key_Enums_as_child (decl_Qt_Key_Enums, "QFlags_Key");

}


//  Implementation of the enum wrapper class for Qt::KeyboardModifier
namespace qt_gsi
{

static gsi::Enum<Qt::KeyboardModifier> decl_Qt_KeyboardModifier_Enum ("QtCore", "Qt_KeyboardModifier",
    gsi::enum_const ("NoModifier", Qt::NoModifier, "@brief Enum constant Qt::NoModifier") +
    gsi::enum_const ("ShiftModifier", Qt::ShiftModifier, "@brief Enum constant Qt::ShiftModifier") +
    gsi::enum_const ("ControlModifier", Qt::ControlModifier, "@brief Enum constant Qt::ControlModifier") +
    gsi::enum_const ("AltModifier", Qt::AltModifier, "@brief Enum constant Qt::AltModifier") +
    gsi::enum_const ("MetaModifier", Qt::MetaModifier, "@brief Enum constant Qt::MetaModifier") +
    gsi::enum_const ("KeypadModifier", Qt::KeypadModifier, "@brief Enum constant Qt::KeypadModifier") +
    gsi::enum_const ("GroupSwitchModifier", Qt::GroupSwitchModifier, "@brief Enum constant Qt::GroupSwitchModifier") +
    gsi::enum_const ("KeyboardModifierMask", Qt::KeyboardModifierMask, "@brief Enum constant Qt::KeyboardModifierMask"),
  "@qt\n@brief This class represents the Qt::KeyboardModifier enum");

static gsi::QFlagsClass<Qt::KeyboardModifier > decl_Qt_KeyboardModifier_Enums ("QtCore", "Qt_QFlags_KeyboardModifier",
  "@qt\n@brief This class represents the QFlags<Qt::KeyboardModifier> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_KeyboardModifier_Enum_in_parent (decl_Qt_KeyboardModifier_Enum.defs ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_KeyboardModifier_Enum_as_child (decl_Qt_KeyboardModifier_Enum, "KeyboardModifier");
static gsi::ClassExt<Qt_Namespace> decl_Qt_KeyboardModifier_Enums_as_child (decl_Qt_KeyboardModifier_Enums, "QFlags_KeyboardModifier");

}


//  Implementation of the enum wrapper class for Qt::LayoutDirection
namespace qt_gsi
{

static gsi::Enum<Qt::LayoutDirection> decl_Qt_LayoutDirection_Enum ("QtCore", "Qt_LayoutDirection",
    gsi::enum_const ("LeftToRight", Qt::LeftToRight, "@brief Enum constant Qt::LeftToRight") +
    gsi::enum_const ("RightToLeft", Qt::RightToLeft, "@brief Enum constant Qt::RightToLeft"),
  "@qt\n@brief This class represents the Qt::LayoutDirection enum");

static gsi::QFlagsClass<Qt::LayoutDirection > decl_Qt_LayoutDirection_Enums ("QtCore", "Qt_QFlags_LayoutDirection",
  "@qt\n@brief This class represents the QFlags<Qt::LayoutDirection> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<Qt_Namespace> inject_Qt_LayoutDirection_Enum_in_parent (decl_Qt_LayoutDirection_Enum.defs ());
static gsi::ClassExt<Qt_Namespace> decl_Qt_LayoutDirection_Enum_as_child (decl_Qt_LayoutDirection_Enum, "LayoutDirection");
static gsi::ClassExt<Qt_Namespace> decl_Qt_LayoutDirection_Enums_as_child (decl_Qt_LayoutDirection_Enums, "QFlags_LayoutDirection");

}

