\name{ghFit}
\alias{ghFit}


\title{GH Distribution Fit}

\description{

    Estimates the distrinbutional parameters for a 
    generalized hyperbolic distribution.

}

\usage{
ghFit(x, alpha = 1, beta = 0, delta = 1, mu = 0, lambda = -1/2, 
    scale = TRUE, doplot = TRUE, span = "auto", trace = TRUE, 
    title = NULL, description = NULL, \dots) 
}

\arguments{
 
  \item{x}{
    a numeric vector. 
  }
  
  \item{alpha}{
    first shape parameter.
  }
  \item{beta}{
    second shape parameter, should in the range \code{(0, alpha).}
  }
  \item{delta}{
    scale parameter, must be zero or positive.
  }
  \item{mu}{
    location parameter, by default 0.
  }
  \item{lambda}{
    defines the sublclass, by default \eqn{-1/2}.
  }

  \item{scale}{
    a logical flag, by default \code{TRUE}. Should the time series
    be scaled by its standard deviation to achieve a more stable
    optimization?
  }
  \item{doplot}{
    a logical flag. Should a plot be displayed?
  }        
  \item{span}{

    x-coordinates for the plot, by default 100 values automatically
    selected and ranging between the 0.001, and 0.999
    quantiles. Alternatively, you can specify the range by an expression
    like \code{span=seq(min, max, times = n)}, where, \code{min} and
    \code{max} are the left and right endpoints of the range, and
    \code{n} gives the number of the intermediate points.
	
  }        
  \item{trace}{
    a logical flag. Should the parameter estimation process be
    traced?
  }
  \item{title}{
    a character string which allows for a project title.
  }     
  \item{description}{
    a character string which allows for a brief description.
  }
  \item{\dots}{
    parameters to be parsed.
  }
}

\value{
  an object from class \code{"fDISTFIT"}.
  Slot \code{fit} is a list, currently with components
  \code{estimate}, \code{minimum} and \code{code}.
}

\details{

  The meanings of the parameters correspond to the first
  parameterization, see \code{\link{gh}} for further details.
  
  The function \code{\link{nlm}} is used to minimize the "negative"
  maximum log-likelihood function. \code{nlm} carries out a minimization
  using a Newton-type algorithm.
       
}

\examples{
set.seed(1953)
s <- rgh(n = 1000, alpha = 1.5, beta = 0.3, delta = 0.5, mu = -1.0) 

ghFit(s, alpha = 1, beta = 0, delta = 1, mu = mean(s), doplot = TRUE, trace = FALSE) 
}

\keyword{distribution}
