/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-
 *
 * Copyright (C) 2009 Richard Hughes <richard@hughsie.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <glib.h>

#include "up-win-native.h"
#include "up-native.h"
#include <windows.h>

G_DEFINE_TYPE (UpWinNative, up_win_native, G_TYPE_OBJECT)

static void
up_win_native_class_init (UpWinNativeClass *klass)
{
}

static void
up_win_native_init (UpWinNative *self)
{
	self->path = "empty";
}

UpWinNative *
up_win_native_new(const gchar * path)
{
	UpWinNative *native;
	native = UP_WIN_NATIVE (g_object_new (UP_TYPE_WIN_NATIVE, NULL));
	native->path = g_strdup(path);
	return native;
}

const gchar *
up_win_native_get_path(UpWinNative * native)
{
	return native->path;
}

/**
 * up_native_get_native_path:
 * @object: the native tracking object
 *
 * This converts a GObject used as the device data into a native path.
 * This would be implemented on a Linux system using:
 *  g_udev_device_get_sysfs_path (G_UDEV_DEVICE (object))
 *
 * Return value: The native path for the device which is unique, e.g. "/sys/class/power/BAT1"
 **/
const gchar *
up_native_get_native_path (GObject *object)
{
	return up_win_native_get_path (UP_WIN_NATIVE (object));
}

/**
 * detect if we are on a desktop system or a laptop
 * heuristic : laptop if SYSTEM_POWER_STATUS.BatteryFlag is not 128
 */
gboolean
up_native_is_laptop(void)
{
	SYSTEM_POWER_STATUS sps;
	GetSystemPowerStatus(&sps);
	return (sps.BatteryFlag & 128) ? FALSE : TRUE;
}
