#define IN_TP_QT_HEADER
#include "TelepathyQt/tls-certificate.h"

namespace Tp
{
namespace Client
{

AuthenticationTLSCertificateInterface::AuthenticationTLSCertificateInterface(const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), QDBusConnection::sessionBus(), parent)
{
}

AuthenticationTLSCertificateInterface::AuthenticationTLSCertificateInterface(const QDBusConnection& connection, const QString& busName, const QString& objectPath, QObject *parent)
    : Tp::AbstractInterface(busName, objectPath, staticInterfaceName(), connection, parent)
{
}

AuthenticationTLSCertificateInterface::AuthenticationTLSCertificateInterface(Tp::DBusProxy *proxy)
    : Tp::AbstractInterface(proxy, staticInterfaceName())
{
}

AuthenticationTLSCertificateInterface::AuthenticationTLSCertificateInterface(const Tp::AbstractInterface& mainInterface)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), mainInterface.parent())
{
}

AuthenticationTLSCertificateInterface::AuthenticationTLSCertificateInterface(const Tp::AbstractInterface& mainInterface, QObject *parent)
    : Tp::AbstractInterface(mainInterface.service(), mainInterface.path(), staticInterfaceName(), mainInterface.connection(), parent)
{
}

void AuthenticationTLSCertificateInterface::invalidate(Tp::DBusProxy *proxy,
        const QString &error, const QString &message)
{
    disconnect(this, SIGNAL(Accepted()), NULL, NULL);
    disconnect(this, SIGNAL(Rejected(const Tp::TLSCertificateRejectionList&)), NULL, NULL);

    Tp::AbstractInterface::invalidate(proxy, error, message);
}
}
}
