/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGTRefElement.h"

#include "JSSVGAnimatedString.h"
#include "SVGTRefElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGTRefElementTableValues[] =
{
    { "href", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTRefElementHref), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTRefElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTRefElementTable = { 4, 3, JSSVGTRefElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGTRefElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTRefElementConstructorTable = { 1, 0, JSSVGTRefElementConstructorTableValues, 0 };
const ClassInfo JSSVGTRefElementConstructor::s_info = { "SVGTRefElementConstructor", &Base::s_info, &JSSVGTRefElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGTRefElementConstructor) };

JSSVGTRefElementConstructor::JSSVGTRefElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGTRefElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGTRefElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGTRefElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTRefElementConstructor, JSDOMWrapper>(exec, &JSSVGTRefElementConstructorTable, jsCast<JSSVGTRefElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGTRefElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGTRefElementConstructor, JSDOMWrapper>(exec, &JSSVGTRefElementConstructorTable, jsCast<JSSVGTRefElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGTRefElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTRefElementPrototypeTable = { 1, 0, JSSVGTRefElementPrototypeTableValues, 0 };
const ClassInfo JSSVGTRefElementPrototype::s_info = { "SVGTRefElementPrototype", &Base::s_info, &JSSVGTRefElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGTRefElementPrototype) };

JSObject* JSSVGTRefElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGTRefElement>(exec, globalObject);
}

const ClassInfo JSSVGTRefElement::s_info = { "SVGTRefElement", &Base::s_info, &JSSVGTRefElementTable, 0 , CREATE_METHOD_TABLE(JSSVGTRefElement) };

JSSVGTRefElement::JSSVGTRefElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGTRefElement> impl)
    : JSSVGTextPositioningElement(structure, globalObject, impl)
{
}

void JSSVGTRefElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGTRefElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGTRefElementPrototype::create(exec->globalData(), globalObject, JSSVGTRefElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGTextPositioningElementPrototype::self(exec, globalObject)));
}

bool JSSVGTRefElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGTRefElement* thisObject = jsCast<JSSVGTRefElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGTRefElement, Base>(exec, &JSSVGTRefElementTable, thisObject, propertyName, slot);
}

bool JSSVGTRefElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGTRefElement* thisObject = jsCast<JSSVGTRefElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGTRefElement, Base>(exec, &JSSVGTRefElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGTRefElementHref(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTRefElement* castedThis = jsCast<JSSVGTRefElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTRefElement* impl = static_cast<SVGTRefElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->hrefAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGTRefElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTRefElement* domObject = jsCast<JSSVGTRefElement*>(asObject(slotBase));
    return JSSVGTRefElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGTRefElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGTRefElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
