/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLHtmlElement.h"

#include "HTMLHtmlElement.h"
#include "HTMLNames.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLHtmlElementTableValues[] =
{
    { "version", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLHtmlElementVersion), (intptr_t)setJSHTMLHtmlElementVersion, NoIntrinsic },
    { "manifest", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLHtmlElementManifest), (intptr_t)setJSHTMLHtmlElementManifest, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLHtmlElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLHtmlElementTable = { 9, 7, JSHTMLHtmlElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLHtmlElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLHtmlElementConstructorTable = { 1, 0, JSHTMLHtmlElementConstructorTableValues, 0 };
const ClassInfo JSHTMLHtmlElementConstructor::s_info = { "HTMLHtmlElementConstructor", &Base::s_info, &JSHTMLHtmlElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLHtmlElementConstructor) };

JSHTMLHtmlElementConstructor::JSHTMLHtmlElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLHtmlElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLHtmlElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLHtmlElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHtmlElementConstructor, JSDOMWrapper>(exec, &JSHTMLHtmlElementConstructorTable, jsCast<JSHTMLHtmlElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLHtmlElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLHtmlElementConstructor, JSDOMWrapper>(exec, &JSHTMLHtmlElementConstructorTable, jsCast<JSHTMLHtmlElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLHtmlElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLHtmlElementPrototypeTable = { 1, 0, JSHTMLHtmlElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLHtmlElementPrototype::s_info = { "HTMLHtmlElementPrototype", &Base::s_info, &JSHTMLHtmlElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLHtmlElementPrototype) };

JSObject* JSHTMLHtmlElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLHtmlElement>(exec, globalObject);
}

const ClassInfo JSHTMLHtmlElement::s_info = { "HTMLHtmlElement", &Base::s_info, &JSHTMLHtmlElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLHtmlElement) };

JSHTMLHtmlElement::JSHTMLHtmlElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLHtmlElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLHtmlElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLHtmlElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLHtmlElementPrototype::create(exec->globalData(), globalObject, JSHTMLHtmlElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLHtmlElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLHtmlElement* thisObject = jsCast<JSHTMLHtmlElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLHtmlElement, Base>(exec, &JSHTMLHtmlElementTable, thisObject, propertyName, slot);
}

bool JSHTMLHtmlElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLHtmlElement* thisObject = jsCast<JSHTMLHtmlElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLHtmlElement, Base>(exec, &JSHTMLHtmlElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLHtmlElementVersion(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLHtmlElement* castedThis = jsCast<JSHTMLHtmlElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLHtmlElement* impl = static_cast<HTMLHtmlElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::versionAttr));
    return result;
}


JSValue jsHTMLHtmlElementManifest(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLHtmlElement* castedThis = jsCast<JSHTMLHtmlElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLHtmlElement* impl = static_cast<HTMLHtmlElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getURLAttribute(WebCore::HTMLNames::manifestAttr));
    return result;
}


JSValue jsHTMLHtmlElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLHtmlElement* domObject = jsCast<JSHTMLHtmlElement*>(asObject(slotBase));
    return JSHTMLHtmlElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLHtmlElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLHtmlElement* thisObject = jsCast<JSHTMLHtmlElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLHtmlElement, Base>(exec, propertyName, value, &JSHTMLHtmlElementTable, thisObject, slot);
}

void setJSHTMLHtmlElementVersion(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLHtmlElement* castedThis = jsCast<JSHTMLHtmlElement*>(thisObject);
    HTMLHtmlElement* impl = static_cast<HTMLHtmlElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::versionAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLHtmlElementManifest(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLHtmlElement* castedThis = jsCast<JSHTMLHtmlElement*>(thisObject);
    HTMLHtmlElement* impl = static_cast<HTMLHtmlElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::manifestAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLHtmlElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLHtmlElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
