/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGEllipseElement.h"

#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGEllipseElement.h"
#include "SVGMatrix.h"
#include "SVGRect.h"
#include "SVGStringList.h"
#include "StylePropertySet.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGEllipseElementTableValues[] =
{
    { "cx", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGEllipseElementCx), (intptr_t)0, NoIntrinsic },
    { "cy", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGEllipseElementCy), (intptr_t)0, NoIntrinsic },
    { "rx", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGEllipseElementRx), (intptr_t)0, NoIntrinsic },
    { "ry", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGEllipseElementRy), (intptr_t)0, NoIntrinsic },
    { "requiredFeatures", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGEllipseElementRequiredFeatures), (intptr_t)0, NoIntrinsic },
    { "requiredExtensions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGEllipseElementRequiredExtensions), (intptr_t)0, NoIntrinsic },
    { "systemLanguage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGEllipseElementSystemLanguage), (intptr_t)0, NoIntrinsic },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGEllipseElementXmllang), (intptr_t)setJSSVGEllipseElementXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGEllipseElementXmlspace), (intptr_t)setJSSVGEllipseElementXmlspace, NoIntrinsic },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGEllipseElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGEllipseElementClassName), (intptr_t)0, NoIntrinsic },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGEllipseElementStyle), (intptr_t)0, NoIntrinsic },
    { "transform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGEllipseElementTransform), (intptr_t)0, NoIntrinsic },
    { "nearestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGEllipseElementNearestViewportElement), (intptr_t)0, NoIntrinsic },
    { "farthestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGEllipseElementFarthestViewportElement), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGEllipseElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGEllipseElementTable = { 36, 31, JSSVGEllipseElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGEllipseElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGEllipseElementConstructorTable = { 1, 0, JSSVGEllipseElementConstructorTableValues, 0 };
const ClassInfo JSSVGEllipseElementConstructor::s_info = { "SVGEllipseElementConstructor", &Base::s_info, &JSSVGEllipseElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGEllipseElementConstructor) };

JSSVGEllipseElementConstructor::JSSVGEllipseElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGEllipseElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGEllipseElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGEllipseElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGEllipseElementConstructor, JSDOMWrapper>(exec, &JSSVGEllipseElementConstructorTable, jsCast<JSSVGEllipseElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGEllipseElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGEllipseElementConstructor, JSDOMWrapper>(exec, &JSSVGEllipseElementConstructorTable, jsCast<JSSVGEllipseElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGEllipseElementPrototypeTableValues[] =
{
    { "hasExtension", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGEllipseElementPrototypeFunctionHasExtension), (intptr_t)1, NoIntrinsic },
    { "getPresentationAttribute", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGEllipseElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1, NoIntrinsic },
    { "getBBox", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGEllipseElementPrototypeFunctionGetBBox), (intptr_t)0, NoIntrinsic },
    { "getCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGEllipseElementPrototypeFunctionGetCTM), (intptr_t)0, NoIntrinsic },
    { "getScreenCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGEllipseElementPrototypeFunctionGetScreenCTM), (intptr_t)0, NoIntrinsic },
    { "getTransformToElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGEllipseElementPrototypeFunctionGetTransformToElement), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGEllipseElementPrototypeTable = { 17, 15, JSSVGEllipseElementPrototypeTableValues, 0 };
const ClassInfo JSSVGEllipseElementPrototype::s_info = { "SVGEllipseElementPrototype", &Base::s_info, &JSSVGEllipseElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGEllipseElementPrototype) };

JSObject* JSSVGEllipseElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGEllipseElement>(exec, globalObject);
}

bool JSSVGEllipseElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGEllipseElementPrototype* thisObject = jsCast<JSSVGEllipseElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGEllipseElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGEllipseElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGEllipseElementPrototype* thisObject = jsCast<JSSVGEllipseElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGEllipseElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGEllipseElement::s_info = { "SVGEllipseElement", &Base::s_info, &JSSVGEllipseElementTable, 0 , CREATE_METHOD_TABLE(JSSVGEllipseElement) };

JSSVGEllipseElement::JSSVGEllipseElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGEllipseElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGEllipseElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGEllipseElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGEllipseElementPrototype::create(exec->globalData(), globalObject, JSSVGEllipseElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGEllipseElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGEllipseElement* thisObject = jsCast<JSSVGEllipseElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGEllipseElement, Base>(exec, &JSSVGEllipseElementTable, thisObject, propertyName, slot);
}

bool JSSVGEllipseElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGEllipseElement* thisObject = jsCast<JSSVGEllipseElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGEllipseElement, Base>(exec, &JSSVGEllipseElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGEllipseElementCx(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->cxAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGEllipseElementCy(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->cyAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGEllipseElementRx(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->rxAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGEllipseElementRy(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->ryAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGEllipseElementRequiredFeatures(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredFeatures())));
    return result;
}


JSValue jsSVGEllipseElementRequiredExtensions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredExtensions())));
    return result;
}


JSValue jsSVGEllipseElementSystemLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->systemLanguage())));
    return result;
}


JSValue jsSVGEllipseElementXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGEllipseElementXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


JSValue jsSVGEllipseElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGEllipseElementClassName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGEllipseElementStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->style()));
    return result;
}


JSValue jsSVGEllipseElementTransform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = impl->transformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGEllipseElementNearestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nearestViewportElement()));
    return result;
}


JSValue jsSVGEllipseElementFarthestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->farthestViewportElement()));
    return result;
}


JSValue jsSVGEllipseElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGEllipseElement* domObject = jsCast<JSSVGEllipseElement*>(asObject(slotBase));
    return JSSVGEllipseElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGEllipseElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGEllipseElement* thisObject = jsCast<JSSVGEllipseElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGEllipseElement, Base>(exec, propertyName, value, &JSSVGEllipseElementTable, thisObject, slot);
}

void setJSSVGEllipseElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(thisObject);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());
    impl->setXmllang(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


void setJSSVGEllipseElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(thisObject);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());
    impl->setXmlspace(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


JSValue JSSVGEllipseElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGEllipseElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGEllipseElementPrototypeFunctionHasExtension(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGEllipseElement::s_info))
        return throwVMTypeError(exec);
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGEllipseElement::s_info);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());
    const String& extension(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasExtension(extension));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGEllipseElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGEllipseElement::s_info))
        return throwVMTypeError(exec);
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGEllipseElement::s_info);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());
    const String& name(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getPresentationAttribute(name)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGEllipseElementPrototypeFunctionGetBBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGEllipseElement::s_info))
        return throwVMTypeError(exec);
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGEllipseElement::s_info);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->getBBox())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGEllipseElementPrototypeFunctionGetCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGEllipseElement::s_info))
        return throwVMTypeError(exec);
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGEllipseElement::s_info);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGEllipseElementPrototypeFunctionGetScreenCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGEllipseElement::s_info))
        return throwVMTypeError(exec);
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGEllipseElement::s_info);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getScreenCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGEllipseElementPrototypeFunctionGetTransformToElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGEllipseElement::s_info))
        return throwVMTypeError(exec);
    JSSVGEllipseElement* castedThis = jsCast<JSSVGEllipseElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGEllipseElement::s_info);
    SVGEllipseElement* impl = static_cast<SVGEllipseElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    SVGElement* element(toSVGElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getTransformToElement(element, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
