/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSImageData.h"

#include "ImageData.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSImageDataTableValues[] =
{
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsImageDataWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsImageDataHeight), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsImageDataConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSImageDataTable = { 9, 7, JSImageDataTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSImageDataConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSImageDataConstructorTable = { 1, 0, JSImageDataConstructorTableValues, 0 };
const ClassInfo JSImageDataConstructor::s_info = { "ImageDataConstructor", &Base::s_info, &JSImageDataConstructorTable, 0, CREATE_METHOD_TABLE(JSImageDataConstructor) };

JSImageDataConstructor::JSImageDataConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSImageDataConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSImageDataPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSImageDataConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSImageDataConstructor, JSDOMWrapper>(exec, &JSImageDataConstructorTable, jsCast<JSImageDataConstructor*>(cell), propertyName, slot);
}

bool JSImageDataConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSImageDataConstructor, JSDOMWrapper>(exec, &JSImageDataConstructorTable, jsCast<JSImageDataConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSImageDataPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSImageDataPrototypeTable = { 1, 0, JSImageDataPrototypeTableValues, 0 };
const ClassInfo JSImageDataPrototype::s_info = { "ImageDataPrototype", &Base::s_info, &JSImageDataPrototypeTable, 0, CREATE_METHOD_TABLE(JSImageDataPrototype) };

JSObject* JSImageDataPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSImageData>(exec, globalObject);
}

const ClassInfo JSImageData::s_info = { "ImageData", &Base::s_info, &JSImageDataTable, 0 , CREATE_METHOD_TABLE(JSImageData) };

JSImageData::JSImageData(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<ImageData> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSImageData::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSImageData::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSImageDataPrototype::create(exec->globalData(), globalObject, JSImageDataPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSImageData::destroy(JSC::JSCell* cell)
{
    JSImageData* thisObject = static_cast<JSImageData*>(cell);
    thisObject->JSImageData::~JSImageData();
}

JSImageData::~JSImageData()
{
    releaseImplIfNotNull();
}

bool JSImageData::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSImageData* thisObject = jsCast<JSImageData*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSImageData, Base>(exec, &JSImageDataTable, thisObject, propertyName, slot);
}

bool JSImageData::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSImageData* thisObject = jsCast<JSImageData*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSImageData, Base>(exec, &JSImageDataTable, thisObject, propertyName, descriptor);
}

JSValue jsImageDataWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSImageData* castedThis = jsCast<JSImageData*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ImageData* impl = static_cast<ImageData*>(castedThis->impl());
    JSValue result = jsNumber(impl->width());
    return result;
}


JSValue jsImageDataHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSImageData* castedThis = jsCast<JSImageData*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ImageData* impl = static_cast<ImageData*>(castedThis->impl());
    JSValue result = jsNumber(impl->height());
    return result;
}


JSValue jsImageDataConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSImageData* domObject = jsCast<JSImageData*>(asObject(slotBase));
    return JSImageData::getConstructor(exec, domObject->globalObject());
}

JSValue JSImageData::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSImageDataConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSImageData* jsImageData)
{
    if (jsImageData->hasCustomProperties())
        return true;
    return false;
}

bool JSImageDataOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSImageData* jsImageData = jsCast<JSImageData*>(handle.get().asCell());
    if (!isObservable(jsImageData))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSImageDataOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSImageData* jsImageData = jsCast<JSImageData*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsImageData->impl(), jsImageData);
    jsImageData->releaseImpl();
}

ImageData* toImageData(JSC::JSValue value)
{
    return value.inherits(&JSImageData::s_info) ? jsCast<JSImageData*>(asObject(value))->impl() : 0;
}

}
