/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGElement.h"

#include "HTMLNames.h"
#include "JSSVGElement.h"
#include "JSSVGSVGElement.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGSVGElement.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGElementTableValues[] =
{
    { "id", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementId), (intptr_t)setJSSVGElementId, NoIntrinsic },
    { "xmlbase", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementXmlbase), (intptr_t)setJSSVGElementXmlbase, NoIntrinsic },
    { "ownerSVGElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementOwnerSVGElement), (intptr_t)0, NoIntrinsic },
    { "viewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementViewportElement), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGElementTable = { 16, 15, JSSVGElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGElementConstructorTable = { 1, 0, JSSVGElementConstructorTableValues, 0 };
const ClassInfo JSSVGElementConstructor::s_info = { "SVGElementConstructor", &Base::s_info, &JSSVGElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGElementConstructor) };

JSSVGElementConstructor::JSSVGElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGElementConstructor, JSDOMWrapper>(exec, &JSSVGElementConstructorTable, jsCast<JSSVGElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGElementConstructor, JSDOMWrapper>(exec, &JSSVGElementConstructorTable, jsCast<JSSVGElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGElementPrototypeTable = { 1, 0, JSSVGElementPrototypeTableValues, 0 };
const ClassInfo JSSVGElementPrototype::s_info = { "SVGElementPrototype", &Base::s_info, &JSSVGElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGElementPrototype) };

JSObject* JSSVGElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGElement>(exec, globalObject);
}

const ClassInfo JSSVGElement::s_info = { "SVGElement", &Base::s_info, &JSSVGElementTable, 0 , CREATE_METHOD_TABLE(JSSVGElement) };

JSSVGElement::JSSVGElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGElement> impl)
    : JSElement(structure, globalObject, impl)
{
}

void JSSVGElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGElementPrototype::create(exec->globalData(), globalObject, JSSVGElementPrototype::createStructure(exec->globalData(), globalObject, JSElementPrototype::self(exec, globalObject)));
}

bool JSSVGElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGElement* thisObject = jsCast<JSSVGElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGElement, Base>(exec, &JSSVGElementTable, thisObject, propertyName, slot);
}

bool JSSVGElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGElement* thisObject = jsCast<JSSVGElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGElement, Base>(exec, &JSSVGElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGElementId(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElement* castedThis = jsCast<JSSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElement* impl = static_cast<SVGElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::idAttr));
    return result;
}


JSValue jsSVGElementXmlbase(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElement* castedThis = jsCast<JSSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElement* impl = static_cast<SVGElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlbase());
    return result;
}


JSValue jsSVGElementOwnerSVGElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElement* castedThis = jsCast<JSSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElement* impl = static_cast<SVGElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->ownerSVGElement()));
    return result;
}


JSValue jsSVGElementViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElement* castedThis = jsCast<JSSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElement* impl = static_cast<SVGElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->viewportElement()));
    return result;
}


JSValue jsSVGElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElement* domObject = jsCast<JSSVGElement*>(asObject(slotBase));
    return JSSVGElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGElement* thisObject = jsCast<JSSVGElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGElement, Base>(exec, propertyName, value, &JSSVGElementTable, thisObject, slot);
}

void setJSSVGElementId(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElement* castedThis = jsCast<JSSVGElement*>(thisObject);
    SVGElement* impl = static_cast<SVGElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::idAttr, valueToStringWithNullCheck(exec, value));
}


void setJSSVGElementXmlbase(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGElement* castedThis = jsCast<JSSVGElement*>(thisObject);
    SVGElement* impl = static_cast<SVGElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setXmlbase(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}


JSValue JSSVGElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

SVGElement* toSVGElement(JSC::JSValue value)
{
    return value.inherits(&JSSVGElement::s_info) ? jsCast<JSSVGElement*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
