/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLParagraphElement.h"

#include "HTMLNames.h"
#include "HTMLParagraphElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLParagraphElementTableValues[] =
{
    { "align", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLParagraphElementAlign), (intptr_t)setJSHTMLParagraphElementAlign, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLParagraphElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLParagraphElementTable = { 5, 3, JSHTMLParagraphElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLParagraphElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLParagraphElementConstructorTable = { 1, 0, JSHTMLParagraphElementConstructorTableValues, 0 };
const ClassInfo JSHTMLParagraphElementConstructor::s_info = { "HTMLParagraphElementConstructor", &Base::s_info, &JSHTMLParagraphElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLParagraphElementConstructor) };

JSHTMLParagraphElementConstructor::JSHTMLParagraphElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLParagraphElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLParagraphElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLParagraphElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLParagraphElementConstructor, JSDOMWrapper>(exec, &JSHTMLParagraphElementConstructorTable, jsCast<JSHTMLParagraphElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLParagraphElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLParagraphElementConstructor, JSDOMWrapper>(exec, &JSHTMLParagraphElementConstructorTable, jsCast<JSHTMLParagraphElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLParagraphElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLParagraphElementPrototypeTable = { 1, 0, JSHTMLParagraphElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLParagraphElementPrototype::s_info = { "HTMLParagraphElementPrototype", &Base::s_info, &JSHTMLParagraphElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLParagraphElementPrototype) };

JSObject* JSHTMLParagraphElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLParagraphElement>(exec, globalObject);
}

const ClassInfo JSHTMLParagraphElement::s_info = { "HTMLParagraphElement", &Base::s_info, &JSHTMLParagraphElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLParagraphElement) };

JSHTMLParagraphElement::JSHTMLParagraphElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLParagraphElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLParagraphElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLParagraphElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLParagraphElementPrototype::create(exec->globalData(), globalObject, JSHTMLParagraphElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLParagraphElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLParagraphElement* thisObject = jsCast<JSHTMLParagraphElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLParagraphElement, Base>(exec, &JSHTMLParagraphElementTable, thisObject, propertyName, slot);
}

bool JSHTMLParagraphElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLParagraphElement* thisObject = jsCast<JSHTMLParagraphElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLParagraphElement, Base>(exec, &JSHTMLParagraphElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLParagraphElementAlign(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLParagraphElement* castedThis = jsCast<JSHTMLParagraphElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLParagraphElement* impl = static_cast<HTMLParagraphElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}


JSValue jsHTMLParagraphElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLParagraphElement* domObject = jsCast<JSHTMLParagraphElement*>(asObject(slotBase));
    return JSHTMLParagraphElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLParagraphElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLParagraphElement* thisObject = jsCast<JSHTMLParagraphElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLParagraphElement, Base>(exec, propertyName, value, &JSHTMLParagraphElementTable, thisObject, slot);
}

void setJSHTMLParagraphElementAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLParagraphElement* castedThis = jsCast<JSHTMLParagraphElement*>(thisObject);
    HTMLParagraphElement* impl = static_cast<HTMLParagraphElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::alignAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLParagraphElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLParagraphElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
