#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


#define MIN(a,b) ((a)<(b) ? (a) : (b))
#define ZSTD_STATIC_LINKING_ONLY
#define ZSTD_DISABLE_DEPRECATE_WARNINGS
#include <zstd.h>
#define ZDICT_STATIC_LINKING_ONLY
#define ZDICT_DISABLE_DEPRECATE_WARNINGS
#include <zdict.h>


/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 107), // ZSTD_CCtx *()(ZSTD_customMem)
/*  1 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // ZSTD_customMem
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION, 107), // ZSTD_CCtx *()(void *, size_t)
/*  4 */ _CFFI_OP(_CFFI_OP_POINTER, 602), // void *
/*  5 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  7 */ _CFFI_OP(_CFFI_OP_FUNCTION, 107), // ZSTD_CCtx *()(void)
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION, 287), // ZSTD_CCtx_params *()(void)
/* 10 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // ZSTD_CDict *()(void const *, size_t, ZSTD_dictLoadMethod_e, ZSTD_dictContentType_e, ZSTD_CCtx_params const *, ZSTD_customMem)
/* 12 */ _CFFI_OP(_CFFI_OP_POINTER, 602), // void const *
/* 13 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 14 */ _CFFI_OP(_CFFI_OP_ENUM, 6), // ZSTD_dictLoadMethod_e
/* 15 */ _CFFI_OP(_CFFI_OP_ENUM, 5), // ZSTD_dictContentType_e
/* 16 */ _CFFI_OP(_CFFI_OP_POINTER, 577), // ZSTD_CCtx_params const *
/* 17 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 19 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // ZSTD_CDict *()(void const *, size_t, ZSTD_dictLoadMethod_e, ZSTD_dictContentType_e, ZSTD_compressionParameters, ZSTD_customMem)
/* 20 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 21 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 22 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 23 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 24 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // ZSTD_compressionParameters
/* 25 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 26 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 27 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // ZSTD_CDict *()(void const *, size_t, int)
/* 28 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 29 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 30 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 32 */ _CFFI_OP(_CFFI_OP_FUNCTION, 120), // ZSTD_CDict const *()(void *, size_t, void const *, size_t, ZSTD_dictLoadMethod_e, ZSTD_dictContentType_e, ZSTD_compressionParameters)
/* 33 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 34 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 35 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 36 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 37 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 38 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 39 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION, 89), // ZSTD_DCtx *()(ZSTD_customMem)
/* 42 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 43 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 44 */ _CFFI_OP(_CFFI_OP_FUNCTION, 89), // ZSTD_DCtx *()(void *, size_t)
/* 45 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 46 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 48 */ _CFFI_OP(_CFFI_OP_FUNCTION, 89), // ZSTD_DCtx *()(void)
/* 49 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 50 */ _CFFI_OP(_CFFI_OP_FUNCTION, 405), // ZSTD_DDict *()(void const *, size_t)
/* 51 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 52 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 53 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 54 */ _CFFI_OP(_CFFI_OP_FUNCTION, 405), // ZSTD_DDict *()(void const *, size_t, ZSTD_dictLoadMethod_e, ZSTD_dictContentType_e, ZSTD_customMem)
/* 55 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 56 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 57 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 58 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 59 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 60 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 61 */ _CFFI_OP(_CFFI_OP_FUNCTION, 321), // ZSTD_DDict const *()(void *, size_t, void const *, size_t, ZSTD_dictLoadMethod_e, ZSTD_dictContentType_e)
/* 62 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 63 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 64 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 65 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 66 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 67 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 68 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 69 */ _CFFI_OP(_CFFI_OP_FUNCTION, 582), // ZSTD_bounds()(ZSTD_cParameter)
/* 70 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // ZSTD_cParameter
/* 71 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION, 582), // ZSTD_bounds()(ZSTD_dParameter)
/* 73 */ _CFFI_OP(_CFFI_OP_ENUM, 3), // ZSTD_dParameter
/* 74 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 75 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // ZSTD_compressionParameters()(ZSTD_compressionParameters, unsigned long long, size_t)
/* 76 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 77 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12), // unsigned long long
/* 78 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 79 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 80 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // ZSTD_compressionParameters()(int, unsigned long long, size_t)
/* 81 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 82 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 83 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 84 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 85 */ _CFFI_OP(_CFFI_OP_FUNCTION, 586), // ZSTD_frameProgression()(ZSTD_CCtx const *)
/* 86 */ _CFFI_OP(_CFFI_OP_POINTER, 576), // ZSTD_CCtx const *
/* 87 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 88 */ _CFFI_OP(_CFFI_OP_FUNCTION, 590), // ZSTD_nextInputType_e()(ZSTD_DCtx *)
/* 89 */ _CFFI_OP(_CFFI_OP_POINTER, 579), // ZSTD_DCtx *
/* 90 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 91 */ _CFFI_OP(_CFFI_OP_FUNCTION, 235), // ZSTD_parameters()(int, unsigned long long, size_t)
/* 92 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 93 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 94 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 95 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 96 */ _CFFI_OP(_CFFI_OP_FUNCTION, 161), // ZSTD_threadPool *()(size_t)
/* 97 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 98 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 99 */ _CFFI_OP(_CFFI_OP_FUNCTION, 597), // char const *()(size_t)
/* 100 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 101 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 102 */ _CFFI_OP(_CFFI_OP_FUNCTION, 597), // char const *()(void)
/* 103 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 104 */ _CFFI_OP(_CFFI_OP_FUNCTION, 30), // int()(void)
/* 105 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 106 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *)
/* 107 */ _CFFI_OP(_CFFI_OP_POINTER, 576), // ZSTD_CCtx *
/* 108 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 109 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_CCtx const *, unsigned long long)
/* 110 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 111 */ _CFFI_OP(_CFFI_OP_NOOP, 86),
/* 112 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 113 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 114 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_CCtx_params const *)
/* 115 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 116 */ _CFFI_OP(_CFFI_OP_NOOP, 16),
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_CDict const *)
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 120 */ _CFFI_OP(_CFFI_OP_POINTER, 578), // ZSTD_CDict const *
/* 121 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 122 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_CDict const *, ZSTD_frameParameters, unsigned long long)
/* 123 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 124 */ _CFFI_OP(_CFFI_OP_NOOP, 120),
/* 125 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // ZSTD_frameParameters
/* 126 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 127 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 128 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_ResetDirective)
/* 129 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 130 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // ZSTD_ResetDirective
/* 131 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 132 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_Sequence *, size_t, void const *, size_t)
/* 133 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 134 */ _CFFI_OP(_CFFI_OP_POINTER, 581), // ZSTD_Sequence *
/* 135 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 136 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 137 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 138 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 139 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_cParameter, int)
/* 140 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 141 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 142 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 143 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 144 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_outBuffer *)
/* 145 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 146 */ _CFFI_OP(_CFFI_OP_POINTER, 591), // ZSTD_outBuffer *
/* 147 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 148 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_outBuffer *, ZSTD_inBuffer *)
/* 149 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 150 */ _CFFI_OP(_CFFI_OP_NOOP, 146),
/* 151 */ _CFFI_OP(_CFFI_OP_POINTER, 588), // ZSTD_inBuffer *
/* 152 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 153 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_outBuffer *, ZSTD_inBuffer *, ZSTD_EndDirective)
/* 154 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 155 */ _CFFI_OP(_CFFI_OP_NOOP, 146),
/* 156 */ _CFFI_OP(_CFFI_OP_NOOP, 151),
/* 157 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // ZSTD_EndDirective
/* 158 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 159 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, ZSTD_threadPool *)
/* 160 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 161 */ _CFFI_OP(_CFFI_OP_POINTER, 595), // ZSTD_threadPool *
/* 162 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 163 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, int)
/* 164 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 165 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 166 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 167 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, int, unsigned long long)
/* 168 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 169 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 170 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 171 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 172 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, unsigned long long)
/* 173 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 174 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 175 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 176 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void *, size_t, ZSTD_Sequence const *, size_t, void const *, size_t)
/* 177 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 178 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 179 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 180 */ _CFFI_OP(_CFFI_OP_POINTER, 581), // ZSTD_Sequence const *
/* 181 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 182 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 183 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 184 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 185 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void *, size_t, size_t *, void const *, size_t, size_t *, ZSTD_EndDirective)
/* 186 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 187 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 188 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 189 */ _CFFI_OP(_CFFI_OP_POINTER, 5), // size_t *
/* 190 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 191 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 192 */ _CFFI_OP(_CFFI_OP_NOOP, 189),
/* 193 */ _CFFI_OP(_CFFI_OP_NOOP, 157),
/* 194 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 195 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void *, size_t, void const *, size_t)
/* 196 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 197 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 198 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 199 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 200 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 201 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 202 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void *, size_t, void const *, size_t, ZSTD_CDict const *)
/* 203 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 204 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 205 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 206 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 207 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 208 */ _CFFI_OP(_CFFI_OP_NOOP, 120),
/* 209 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 210 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void *, size_t, void const *, size_t, ZSTD_CDict const *, ZSTD_frameParameters)
/* 211 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 212 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 213 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 214 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 215 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 216 */ _CFFI_OP(_CFFI_OP_NOOP, 120),
/* 217 */ _CFFI_OP(_CFFI_OP_NOOP, 125),
/* 218 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 219 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void *, size_t, void const *, size_t, int)
/* 220 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 221 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 222 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 223 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 224 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 225 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 226 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 227 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void *, size_t, void const *, size_t, void const *, size_t, ZSTD_parameters)
/* 228 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 229 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 230 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 231 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 232 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 233 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 234 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 235 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // ZSTD_parameters
/* 236 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 237 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void *, size_t, void const *, size_t, void const *, size_t, int)
/* 238 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 239 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 240 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 241 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 242 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 243 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 244 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 245 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 246 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 247 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void const *, size_t)
/* 248 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 249 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 250 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 251 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 252 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void const *, size_t, ZSTD_dictContentType_e)
/* 253 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 254 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 255 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 256 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 257 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 258 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void const *, size_t, ZSTD_dictLoadMethod_e, ZSTD_dictContentType_e)
/* 259 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 260 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 261 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 262 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 263 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 264 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 265 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void const *, size_t, ZSTD_parameters, unsigned long long)
/* 266 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 267 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 268 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 269 */ _CFFI_OP(_CFFI_OP_NOOP, 235),
/* 270 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 271 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 272 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx *, void const *, size_t, int)
/* 273 */ _CFFI_OP(_CFFI_OP_NOOP, 107),
/* 274 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 275 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 276 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 277 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 278 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx const *)
/* 279 */ _CFFI_OP(_CFFI_OP_NOOP, 86),
/* 280 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 281 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx const *, ZSTD_cParameter, int *)
/* 282 */ _CFFI_OP(_CFFI_OP_NOOP, 86),
/* 283 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 284 */ _CFFI_OP(_CFFI_OP_POINTER, 30), // int *
/* 285 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 286 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx_params *)
/* 287 */ _CFFI_OP(_CFFI_OP_POINTER, 577), // ZSTD_CCtx_params *
/* 288 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 289 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx_params *, ZSTD_cParameter, int)
/* 290 */ _CFFI_OP(_CFFI_OP_NOOP, 287),
/* 291 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 292 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 293 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 294 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx_params *, ZSTD_parameters)
/* 295 */ _CFFI_OP(_CFFI_OP_NOOP, 287),
/* 296 */ _CFFI_OP(_CFFI_OP_NOOP, 235),
/* 297 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 298 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx_params *, int)
/* 299 */ _CFFI_OP(_CFFI_OP_NOOP, 287),
/* 300 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 301 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 302 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx_params const *)
/* 303 */ _CFFI_OP(_CFFI_OP_NOOP, 16),
/* 304 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 305 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CCtx_params const *, ZSTD_cParameter, int *)
/* 306 */ _CFFI_OP(_CFFI_OP_NOOP, 16),
/* 307 */ _CFFI_OP(_CFFI_OP_NOOP, 70),
/* 308 */ _CFFI_OP(_CFFI_OP_NOOP, 284),
/* 309 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 310 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CDict *)
/* 311 */ _CFFI_OP(_CFFI_OP_POINTER, 578), // ZSTD_CDict *
/* 312 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 313 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_CDict const *)
/* 314 */ _CFFI_OP(_CFFI_OP_NOOP, 120),
/* 315 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 316 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *)
/* 317 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 318 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 319 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, ZSTD_DDict const *)
/* 320 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 321 */ _CFFI_OP(_CFFI_OP_POINTER, 580), // ZSTD_DDict const *
/* 322 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 323 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, ZSTD_ResetDirective)
/* 324 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 325 */ _CFFI_OP(_CFFI_OP_NOOP, 130),
/* 326 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 327 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, ZSTD_dParameter, int *)
/* 328 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 329 */ _CFFI_OP(_CFFI_OP_NOOP, 73),
/* 330 */ _CFFI_OP(_CFFI_OP_NOOP, 284),
/* 331 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 332 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, ZSTD_dParameter, int)
/* 333 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 334 */ _CFFI_OP(_CFFI_OP_NOOP, 73),
/* 335 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 336 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 337 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, ZSTD_format_e)
/* 338 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 339 */ _CFFI_OP(_CFFI_OP_ENUM, 8), // ZSTD_format_e
/* 340 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 341 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, ZSTD_outBuffer *, ZSTD_inBuffer *)
/* 342 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 343 */ _CFFI_OP(_CFFI_OP_NOOP, 146),
/* 344 */ _CFFI_OP(_CFFI_OP_NOOP, 151),
/* 345 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 346 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, size_t)
/* 347 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 348 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 349 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 350 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, void *, size_t, size_t *, void const *, size_t, size_t *)
/* 351 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 352 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 353 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 354 */ _CFFI_OP(_CFFI_OP_NOOP, 189),
/* 355 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 356 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 357 */ _CFFI_OP(_CFFI_OP_NOOP, 189),
/* 358 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 359 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, void *, size_t, void const *, size_t)
/* 360 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 361 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 362 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 363 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 364 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 365 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 366 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, void *, size_t, void const *, size_t, ZSTD_DDict const *)
/* 367 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 368 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 369 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 370 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 371 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 372 */ _CFFI_OP(_CFFI_OP_NOOP, 321),
/* 373 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 374 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, void *, size_t, void const *, size_t, void const *, size_t)
/* 375 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 376 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 377 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 378 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 379 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 380 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 381 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 382 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 383 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, void const *, size_t)
/* 384 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 385 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 386 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 387 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 388 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, void const *, size_t, ZSTD_dictContentType_e)
/* 389 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 390 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 391 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 392 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 393 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 394 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx *, void const *, size_t, ZSTD_dictLoadMethod_e, ZSTD_dictContentType_e)
/* 395 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 396 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 397 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 398 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 399 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 400 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 401 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DCtx const *)
/* 402 */ _CFFI_OP(_CFFI_OP_POINTER, 579), // ZSTD_DCtx const *
/* 403 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 404 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DDict *)
/* 405 */ _CFFI_OP(_CFFI_OP_POINTER, 580), // ZSTD_DDict *
/* 406 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 407 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_DDict const *)
/* 408 */ _CFFI_OP(_CFFI_OP_NOOP, 321),
/* 409 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 410 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_Sequence *, size_t)
/* 411 */ _CFFI_OP(_CFFI_OP_NOOP, 134),
/* 412 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 413 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 414 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_compressionParameters)
/* 415 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 416 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 417 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_frameHeader *, void const *, size_t)
/* 418 */ _CFFI_OP(_CFFI_OP_POINTER, 585), // ZSTD_frameHeader *
/* 419 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 420 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 421 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 422 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(ZSTD_frameHeader *, void const *, size_t, ZSTD_format_e)
/* 423 */ _CFFI_OP(_CFFI_OP_NOOP, 418),
/* 424 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 425 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 426 */ _CFFI_OP(_CFFI_OP_NOOP, 339),
/* 427 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 428 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(int)
/* 429 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 430 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 431 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(size_t)
/* 432 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 433 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 434 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(size_t, ZSTD_compressionParameters, ZSTD_dictLoadMethod_e)
/* 435 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 436 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 437 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 438 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 439 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(size_t, ZSTD_dictLoadMethod_e)
/* 440 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 441 */ _CFFI_OP(_CFFI_OP_NOOP, 14),
/* 442 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 443 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(size_t, int)
/* 444 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 445 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 446 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 447 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(unsigned long long, unsigned long long)
/* 448 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 449 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 450 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 451 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, size_t, void const *, size_t const *, unsigned int)
/* 452 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 453 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 454 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 455 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 456 */ _CFFI_OP(_CFFI_OP_POINTER, 5), // size_t const *
/* 457 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 458 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 459 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, void const *, size_t const *, unsigned int)
/* 460 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 461 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 462 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 463 */ _CFFI_OP(_CFFI_OP_NOOP, 456),
/* 464 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 465 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 466 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, void const *, size_t const *, unsigned int, ZDICT_cover_params_t *)
/* 467 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 468 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 469 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 470 */ _CFFI_OP(_CFFI_OP_NOOP, 456),
/* 471 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 472 */ _CFFI_OP(_CFFI_OP_POINTER, 480), // ZDICT_cover_params_t *
/* 473 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 474 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, void const *, size_t const *, unsigned int, ZDICT_cover_params_t)
/* 475 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 476 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 477 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 478 */ _CFFI_OP(_CFFI_OP_NOOP, 456),
/* 479 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 480 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // ZDICT_cover_params_t
/* 481 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 482 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, void const *, size_t const *, unsigned int, ZDICT_fastCover_params_t *)
/* 483 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 484 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 485 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 486 */ _CFFI_OP(_CFFI_OP_NOOP, 456),
/* 487 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 488 */ _CFFI_OP(_CFFI_OP_POINTER, 496), // ZDICT_fastCover_params_t *
/* 489 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 490 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, void const *, size_t const *, unsigned int, ZDICT_fastCover_params_t)
/* 491 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 492 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 493 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 494 */ _CFFI_OP(_CFFI_OP_NOOP, 456),
/* 495 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 496 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // ZDICT_fastCover_params_t
/* 497 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 498 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, void const *, size_t const *, unsigned int, ZDICT_legacy_params_t)
/* 499 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 500 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 501 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 502 */ _CFFI_OP(_CFFI_OP_NOOP, 456),
/* 503 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 504 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // ZDICT_legacy_params_t
/* 505 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 506 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, void const *, size_t)
/* 507 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 508 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 509 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 510 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 511 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 512 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, void const *, size_t, int)
/* 513 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 514 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 515 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 516 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 517 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 518 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 519 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, void const *, size_t, unsigned int)
/* 520 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 521 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 522 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 523 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 524 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 525 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 526 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void *, size_t, void const *, size_t, void const *, size_t const *, unsigned int, ZDICT_params_t)
/* 527 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 528 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 529 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 530 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 531 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 532 */ _CFFI_OP(_CFFI_OP_NOOP, 456),
/* 533 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 534 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // ZDICT_params_t
/* 535 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 536 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void const *, size_t)
/* 537 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 538 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 539 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 540 */ _CFFI_OP(_CFFI_OP_FUNCTION, 5), // size_t()(void)
/* 541 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 542 */ _CFFI_OP(_CFFI_OP_FUNCTION, 457), // unsigned int()(ZSTD_CDict const *)
/* 543 */ _CFFI_OP(_CFFI_OP_NOOP, 120),
/* 544 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 545 */ _CFFI_OP(_CFFI_OP_FUNCTION, 457), // unsigned int()(ZSTD_DDict const *)
/* 546 */ _CFFI_OP(_CFFI_OP_NOOP, 321),
/* 547 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 548 */ _CFFI_OP(_CFFI_OP_FUNCTION, 457), // unsigned int()(size_t)
/* 549 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 550 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 551 */ _CFFI_OP(_CFFI_OP_FUNCTION, 457), // unsigned int()(void const *, size_t)
/* 552 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 553 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 554 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 555 */ _CFFI_OP(_CFFI_OP_FUNCTION, 457), // unsigned int()(void)
/* 556 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 557 */ _CFFI_OP(_CFFI_OP_FUNCTION, 77), // unsigned long long()(void const *, size_t)
/* 558 */ _CFFI_OP(_CFFI_OP_NOOP, 12),
/* 559 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 560 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 561 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // void *()(void *, size_t)
/* 562 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 563 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 564 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 565 */ _CFFI_OP(_CFFI_OP_FUNCTION, 602), // void()(ZSTD_DCtx *, ZSTD_DCtx const *)
/* 566 */ _CFFI_OP(_CFFI_OP_NOOP, 89),
/* 567 */ _CFFI_OP(_CFFI_OP_NOOP, 402),
/* 568 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 569 */ _CFFI_OP(_CFFI_OP_FUNCTION, 602), // void()(ZSTD_threadPool *)
/* 570 */ _CFFI_OP(_CFFI_OP_NOOP, 161),
/* 571 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 572 */ _CFFI_OP(_CFFI_OP_FUNCTION, 602), // void()(void *, void *)
/* 573 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 574 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 575 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 576 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 14), // ZSTD_CCtx
/* 577 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 13), // ZSTD_CCtx_params
/* 578 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 15), // ZSTD_CDict
/* 579 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 16), // ZSTD_DCtx
/* 580 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 17), // ZSTD_DDict
/* 581 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // ZSTD_Sequence
/* 582 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // ZSTD_bounds
/* 583 */ _CFFI_OP(_CFFI_OP_ENUM, 4), // ZSTD_dictAttachPref_e
/* 584 */ _CFFI_OP(_CFFI_OP_ENUM, 7), // ZSTD_forceIgnoreChecksum_e
/* 585 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // ZSTD_frameHeader
/* 586 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // ZSTD_frameProgression
/* 587 */ _CFFI_OP(_CFFI_OP_ENUM, 9), // ZSTD_frameType_e
/* 588 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 18), // ZSTD_inBuffer
/* 589 */ _CFFI_OP(_CFFI_OP_ENUM, 10), // ZSTD_literalCompressionMode_e
/* 590 */ _CFFI_OP(_CFFI_OP_ENUM, 11), // ZSTD_nextInputType_e
/* 591 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 19), // ZSTD_outBuffer
/* 592 */ _CFFI_OP(_CFFI_OP_ENUM, 12), // ZSTD_refMultipleDDicts_e
/* 593 */ _CFFI_OP(_CFFI_OP_ENUM, 13), // ZSTD_sequenceFormat_e
/* 594 */ _CFFI_OP(_CFFI_OP_ENUM, 14), // ZSTD_strategy
/* 595 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // ZSTD_threadPool
/* 596 */ _CFFI_OP(_CFFI_OP_ENUM, 15), // ZSTD_useRowMatchFinderMode_e
/* 597 */ _CFFI_OP(_CFFI_OP_POINTER, 598), // char const *
/* 598 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 599 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/* 600 */ _CFFI_OP(_CFFI_OP_POINTER, 561), // void *(*)(void *, size_t)
/* 601 */ _CFFI_OP(_CFFI_OP_POINTER, 572), // void(*)(void *, void *)
/* 602 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZDICT_cover_params_t(ZDICT_cover_params_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->k) | 0);  /* check that 'ZDICT_cover_params_t.k' is an integer */
  (void)((p->d) | 0);  /* check that 'ZDICT_cover_params_t.d' is an integer */
  (void)((p->steps) | 0);  /* check that 'ZDICT_cover_params_t.steps' is an integer */
  (void)((p->nbThreads) | 0);  /* check that 'ZDICT_cover_params_t.nbThreads' is an integer */
  { double *tmp = &p->splitPoint; (void)tmp; }
  (void)((p->shrinkDict) | 0);  /* check that 'ZDICT_cover_params_t.shrinkDict' is an integer */
  (void)((p->shrinkDictMaxRegression) | 0);  /* check that 'ZDICT_cover_params_t.shrinkDictMaxRegression' is an integer */
  { ZDICT_params_t *tmp = &p->zParams; (void)tmp; }
}
struct _cffi_align_typedef_ZDICT_cover_params_t { char x; ZDICT_cover_params_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZDICT_fastCover_params_t(ZDICT_fastCover_params_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->k) | 0);  /* check that 'ZDICT_fastCover_params_t.k' is an integer */
  (void)((p->d) | 0);  /* check that 'ZDICT_fastCover_params_t.d' is an integer */
  (void)((p->f) | 0);  /* check that 'ZDICT_fastCover_params_t.f' is an integer */
  (void)((p->steps) | 0);  /* check that 'ZDICT_fastCover_params_t.steps' is an integer */
  (void)((p->nbThreads) | 0);  /* check that 'ZDICT_fastCover_params_t.nbThreads' is an integer */
  { double *tmp = &p->splitPoint; (void)tmp; }
  (void)((p->accel) | 0);  /* check that 'ZDICT_fastCover_params_t.accel' is an integer */
  (void)((p->shrinkDict) | 0);  /* check that 'ZDICT_fastCover_params_t.shrinkDict' is an integer */
  (void)((p->shrinkDictMaxRegression) | 0);  /* check that 'ZDICT_fastCover_params_t.shrinkDictMaxRegression' is an integer */
  { ZDICT_params_t *tmp = &p->zParams; (void)tmp; }
}
struct _cffi_align_typedef_ZDICT_fastCover_params_t { char x; ZDICT_fastCover_params_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZDICT_legacy_params_t(ZDICT_legacy_params_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->selectivityLevel) | 0);  /* check that 'ZDICT_legacy_params_t.selectivityLevel' is an integer */
  { ZDICT_params_t *tmp = &p->zParams; (void)tmp; }
}
struct _cffi_align_typedef_ZDICT_legacy_params_t { char x; ZDICT_legacy_params_t y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZDICT_params_t(ZDICT_params_t *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->compressionLevel) | 0);  /* check that 'ZDICT_params_t.compressionLevel' is an integer */
  (void)((p->notificationLevel) | 0);  /* check that 'ZDICT_params_t.notificationLevel' is an integer */
  (void)((p->dictID) | 0);  /* check that 'ZDICT_params_t.dictID' is an integer */
}
struct _cffi_align_typedef_ZDICT_params_t { char x; ZDICT_params_t y; };

static int _cffi_const_ZSTD_e_continue(unsigned long long *o)
{
  int n = (ZSTD_e_continue) <= 0;
  *o = (unsigned long long)((ZSTD_e_continue) | 0);  /* check that ZSTD_e_continue is an integer */
  return n;
}

static int _cffi_const_ZSTD_e_flush(unsigned long long *o)
{
  int n = (ZSTD_e_flush) <= 0;
  *o = (unsigned long long)((ZSTD_e_flush) | 0);  /* check that ZSTD_e_flush is an integer */
  return n;
}

static int _cffi_const_ZSTD_e_end(unsigned long long *o)
{
  int n = (ZSTD_e_end) <= 0;
  *o = (unsigned long long)((ZSTD_e_end) | 0);  /* check that ZSTD_e_end is an integer */
  return n;
}

static int _cffi_const_ZSTD_reset_session_only(unsigned long long *o)
{
  int n = (ZSTD_reset_session_only) <= 0;
  *o = (unsigned long long)((ZSTD_reset_session_only) | 0);  /* check that ZSTD_reset_session_only is an integer */
  return n;
}

static int _cffi_const_ZSTD_reset_parameters(unsigned long long *o)
{
  int n = (ZSTD_reset_parameters) <= 0;
  *o = (unsigned long long)((ZSTD_reset_parameters) | 0);  /* check that ZSTD_reset_parameters is an integer */
  return n;
}

static int _cffi_const_ZSTD_reset_session_and_parameters(unsigned long long *o)
{
  int n = (ZSTD_reset_session_and_parameters) <= 0;
  *o = (unsigned long long)((ZSTD_reset_session_and_parameters) | 0);  /* check that ZSTD_reset_session_and_parameters is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZSTD_Sequence(ZSTD_Sequence *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->offset) | 0);  /* check that 'ZSTD_Sequence.offset' is an integer */
  (void)((p->litLength) | 0);  /* check that 'ZSTD_Sequence.litLength' is an integer */
  (void)((p->matchLength) | 0);  /* check that 'ZSTD_Sequence.matchLength' is an integer */
  (void)((p->rep) | 0);  /* check that 'ZSTD_Sequence.rep' is an integer */
}
struct _cffi_align_typedef_ZSTD_Sequence { char x; ZSTD_Sequence y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZSTD_bounds(ZSTD_bounds *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->error) | 0);  /* check that 'ZSTD_bounds.error' is an integer */
  (void)((p->lowerBound) | 0);  /* check that 'ZSTD_bounds.lowerBound' is an integer */
  (void)((p->upperBound) | 0);  /* check that 'ZSTD_bounds.upperBound' is an integer */
}
struct _cffi_align_typedef_ZSTD_bounds { char x; ZSTD_bounds y; };

static int _cffi_const_ZSTD_c_compressionLevel(unsigned long long *o)
{
  int n = (ZSTD_c_compressionLevel) <= 0;
  *o = (unsigned long long)((ZSTD_c_compressionLevel) | 0);  /* check that ZSTD_c_compressionLevel is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_windowLog(unsigned long long *o)
{
  int n = (ZSTD_c_windowLog) <= 0;
  *o = (unsigned long long)((ZSTD_c_windowLog) | 0);  /* check that ZSTD_c_windowLog is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_hashLog(unsigned long long *o)
{
  int n = (ZSTD_c_hashLog) <= 0;
  *o = (unsigned long long)((ZSTD_c_hashLog) | 0);  /* check that ZSTD_c_hashLog is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_chainLog(unsigned long long *o)
{
  int n = (ZSTD_c_chainLog) <= 0;
  *o = (unsigned long long)((ZSTD_c_chainLog) | 0);  /* check that ZSTD_c_chainLog is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_searchLog(unsigned long long *o)
{
  int n = (ZSTD_c_searchLog) <= 0;
  *o = (unsigned long long)((ZSTD_c_searchLog) | 0);  /* check that ZSTD_c_searchLog is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_minMatch(unsigned long long *o)
{
  int n = (ZSTD_c_minMatch) <= 0;
  *o = (unsigned long long)((ZSTD_c_minMatch) | 0);  /* check that ZSTD_c_minMatch is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_targetLength(unsigned long long *o)
{
  int n = (ZSTD_c_targetLength) <= 0;
  *o = (unsigned long long)((ZSTD_c_targetLength) | 0);  /* check that ZSTD_c_targetLength is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_strategy(unsigned long long *o)
{
  int n = (ZSTD_c_strategy) <= 0;
  *o = (unsigned long long)((ZSTD_c_strategy) | 0);  /* check that ZSTD_c_strategy is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_enableLongDistanceMatching(unsigned long long *o)
{
  int n = (ZSTD_c_enableLongDistanceMatching) <= 0;
  *o = (unsigned long long)((ZSTD_c_enableLongDistanceMatching) | 0);  /* check that ZSTD_c_enableLongDistanceMatching is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_ldmHashLog(unsigned long long *o)
{
  int n = (ZSTD_c_ldmHashLog) <= 0;
  *o = (unsigned long long)((ZSTD_c_ldmHashLog) | 0);  /* check that ZSTD_c_ldmHashLog is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_ldmMinMatch(unsigned long long *o)
{
  int n = (ZSTD_c_ldmMinMatch) <= 0;
  *o = (unsigned long long)((ZSTD_c_ldmMinMatch) | 0);  /* check that ZSTD_c_ldmMinMatch is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_ldmBucketSizeLog(unsigned long long *o)
{
  int n = (ZSTD_c_ldmBucketSizeLog) <= 0;
  *o = (unsigned long long)((ZSTD_c_ldmBucketSizeLog) | 0);  /* check that ZSTD_c_ldmBucketSizeLog is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_ldmHashRateLog(unsigned long long *o)
{
  int n = (ZSTD_c_ldmHashRateLog) <= 0;
  *o = (unsigned long long)((ZSTD_c_ldmHashRateLog) | 0);  /* check that ZSTD_c_ldmHashRateLog is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_contentSizeFlag(unsigned long long *o)
{
  int n = (ZSTD_c_contentSizeFlag) <= 0;
  *o = (unsigned long long)((ZSTD_c_contentSizeFlag) | 0);  /* check that ZSTD_c_contentSizeFlag is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_checksumFlag(unsigned long long *o)
{
  int n = (ZSTD_c_checksumFlag) <= 0;
  *o = (unsigned long long)((ZSTD_c_checksumFlag) | 0);  /* check that ZSTD_c_checksumFlag is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_dictIDFlag(unsigned long long *o)
{
  int n = (ZSTD_c_dictIDFlag) <= 0;
  *o = (unsigned long long)((ZSTD_c_dictIDFlag) | 0);  /* check that ZSTD_c_dictIDFlag is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_nbWorkers(unsigned long long *o)
{
  int n = (ZSTD_c_nbWorkers) <= 0;
  *o = (unsigned long long)((ZSTD_c_nbWorkers) | 0);  /* check that ZSTD_c_nbWorkers is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_jobSize(unsigned long long *o)
{
  int n = (ZSTD_c_jobSize) <= 0;
  *o = (unsigned long long)((ZSTD_c_jobSize) | 0);  /* check that ZSTD_c_jobSize is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_overlapLog(unsigned long long *o)
{
  int n = (ZSTD_c_overlapLog) <= 0;
  *o = (unsigned long long)((ZSTD_c_overlapLog) | 0);  /* check that ZSTD_c_overlapLog is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam1(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam1) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam1) | 0);  /* check that ZSTD_c_experimentalParam1 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam2(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam2) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam2) | 0);  /* check that ZSTD_c_experimentalParam2 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam3(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam3) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam3) | 0);  /* check that ZSTD_c_experimentalParam3 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam4(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam4) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam4) | 0);  /* check that ZSTD_c_experimentalParam4 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam5(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam5) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam5) | 0);  /* check that ZSTD_c_experimentalParam5 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam6(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam6) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam6) | 0);  /* check that ZSTD_c_experimentalParam6 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam7(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam7) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam7) | 0);  /* check that ZSTD_c_experimentalParam7 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam8(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam8) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam8) | 0);  /* check that ZSTD_c_experimentalParam8 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam9(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam9) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam9) | 0);  /* check that ZSTD_c_experimentalParam9 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam10(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam10) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam10) | 0);  /* check that ZSTD_c_experimentalParam10 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam11(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam11) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam11) | 0);  /* check that ZSTD_c_experimentalParam11 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam12(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam12) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam12) | 0);  /* check that ZSTD_c_experimentalParam12 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam13(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam13) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam13) | 0);  /* check that ZSTD_c_experimentalParam13 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam14(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam14) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam14) | 0);  /* check that ZSTD_c_experimentalParam14 is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_experimentalParam15(unsigned long long *o)
{
  int n = (ZSTD_c_experimentalParam15) <= 0;
  *o = (unsigned long long)((ZSTD_c_experimentalParam15) | 0);  /* check that ZSTD_c_experimentalParam15 is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZSTD_compressionParameters(ZSTD_compressionParameters *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->windowLog) | 0);  /* check that 'ZSTD_compressionParameters.windowLog' is an integer */
  (void)((p->chainLog) | 0);  /* check that 'ZSTD_compressionParameters.chainLog' is an integer */
  (void)((p->hashLog) | 0);  /* check that 'ZSTD_compressionParameters.hashLog' is an integer */
  (void)((p->searchLog) | 0);  /* check that 'ZSTD_compressionParameters.searchLog' is an integer */
  (void)((p->minMatch) | 0);  /* check that 'ZSTD_compressionParameters.minMatch' is an integer */
  (void)((p->targetLength) | 0);  /* check that 'ZSTD_compressionParameters.targetLength' is an integer */
  { ZSTD_strategy *tmp = &p->strategy; (void)tmp; }
}
struct _cffi_align_typedef_ZSTD_compressionParameters { char x; ZSTD_compressionParameters y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZSTD_customMem(ZSTD_customMem *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void *(* *tmp)(void *, size_t) = &p->customAlloc; (void)tmp; }
  { void(* *tmp)(void *, void *) = &p->customFree; (void)tmp; }
  { void * *tmp = &p->opaque; (void)tmp; }
}
struct _cffi_align_typedef_ZSTD_customMem { char x; ZSTD_customMem y; };

static int _cffi_const_ZSTD_d_windowLogMax(unsigned long long *o)
{
  int n = (ZSTD_d_windowLogMax) <= 0;
  *o = (unsigned long long)((ZSTD_d_windowLogMax) | 0);  /* check that ZSTD_d_windowLogMax is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_experimentalParam1(unsigned long long *o)
{
  int n = (ZSTD_d_experimentalParam1) <= 0;
  *o = (unsigned long long)((ZSTD_d_experimentalParam1) | 0);  /* check that ZSTD_d_experimentalParam1 is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_experimentalParam2(unsigned long long *o)
{
  int n = (ZSTD_d_experimentalParam2) <= 0;
  *o = (unsigned long long)((ZSTD_d_experimentalParam2) | 0);  /* check that ZSTD_d_experimentalParam2 is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_experimentalParam3(unsigned long long *o)
{
  int n = (ZSTD_d_experimentalParam3) <= 0;
  *o = (unsigned long long)((ZSTD_d_experimentalParam3) | 0);  /* check that ZSTD_d_experimentalParam3 is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_experimentalParam4(unsigned long long *o)
{
  int n = (ZSTD_d_experimentalParam4) <= 0;
  *o = (unsigned long long)((ZSTD_d_experimentalParam4) | 0);  /* check that ZSTD_d_experimentalParam4 is an integer */
  return n;
}

static int _cffi_const_ZSTD_dictDefaultAttach(unsigned long long *o)
{
  int n = (ZSTD_dictDefaultAttach) <= 0;
  *o = (unsigned long long)((ZSTD_dictDefaultAttach) | 0);  /* check that ZSTD_dictDefaultAttach is an integer */
  return n;
}

static int _cffi_const_ZSTD_dictForceAttach(unsigned long long *o)
{
  int n = (ZSTD_dictForceAttach) <= 0;
  *o = (unsigned long long)((ZSTD_dictForceAttach) | 0);  /* check that ZSTD_dictForceAttach is an integer */
  return n;
}

static int _cffi_const_ZSTD_dictForceCopy(unsigned long long *o)
{
  int n = (ZSTD_dictForceCopy) <= 0;
  *o = (unsigned long long)((ZSTD_dictForceCopy) | 0);  /* check that ZSTD_dictForceCopy is an integer */
  return n;
}

static int _cffi_const_ZSTD_dictForceLoad(unsigned long long *o)
{
  int n = (ZSTD_dictForceLoad) <= 0;
  *o = (unsigned long long)((ZSTD_dictForceLoad) | 0);  /* check that ZSTD_dictForceLoad is an integer */
  return n;
}

static int _cffi_const_ZSTD_dct_auto(unsigned long long *o)
{
  int n = (ZSTD_dct_auto) <= 0;
  *o = (unsigned long long)((ZSTD_dct_auto) | 0);  /* check that ZSTD_dct_auto is an integer */
  return n;
}

static int _cffi_const_ZSTD_dct_rawContent(unsigned long long *o)
{
  int n = (ZSTD_dct_rawContent) <= 0;
  *o = (unsigned long long)((ZSTD_dct_rawContent) | 0);  /* check that ZSTD_dct_rawContent is an integer */
  return n;
}

static int _cffi_const_ZSTD_dct_fullDict(unsigned long long *o)
{
  int n = (ZSTD_dct_fullDict) <= 0;
  *o = (unsigned long long)((ZSTD_dct_fullDict) | 0);  /* check that ZSTD_dct_fullDict is an integer */
  return n;
}

static int _cffi_const_ZSTD_dlm_byCopy(unsigned long long *o)
{
  int n = (ZSTD_dlm_byCopy) <= 0;
  *o = (unsigned long long)((ZSTD_dlm_byCopy) | 0);  /* check that ZSTD_dlm_byCopy is an integer */
  return n;
}

static int _cffi_const_ZSTD_dlm_byRef(unsigned long long *o)
{
  int n = (ZSTD_dlm_byRef) <= 0;
  *o = (unsigned long long)((ZSTD_dlm_byRef) | 0);  /* check that ZSTD_dlm_byRef is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_validateChecksum(unsigned long long *o)
{
  int n = (ZSTD_d_validateChecksum) <= 0;
  *o = (unsigned long long)((ZSTD_d_validateChecksum) | 0);  /* check that ZSTD_d_validateChecksum is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_ignoreChecksum(unsigned long long *o)
{
  int n = (ZSTD_d_ignoreChecksum) <= 0;
  *o = (unsigned long long)((ZSTD_d_ignoreChecksum) | 0);  /* check that ZSTD_d_ignoreChecksum is an integer */
  return n;
}

static int _cffi_const_ZSTD_f_zstd1(unsigned long long *o)
{
  int n = (ZSTD_f_zstd1) <= 0;
  *o = (unsigned long long)((ZSTD_f_zstd1) | 0);  /* check that ZSTD_f_zstd1 is an integer */
  return n;
}

static int _cffi_const_ZSTD_f_zstd1_magicless(unsigned long long *o)
{
  int n = (ZSTD_f_zstd1_magicless) <= 0;
  *o = (unsigned long long)((ZSTD_f_zstd1_magicless) | 0);  /* check that ZSTD_f_zstd1_magicless is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZSTD_frameHeader(ZSTD_frameHeader *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->frameContentSize) | 0);  /* check that 'ZSTD_frameHeader.frameContentSize' is an integer */
  (void)((p->windowSize) | 0);  /* check that 'ZSTD_frameHeader.windowSize' is an integer */
  (void)((p->blockSizeMax) | 0);  /* check that 'ZSTD_frameHeader.blockSizeMax' is an integer */
  { ZSTD_frameType_e *tmp = &p->frameType; (void)tmp; }
  (void)((p->headerSize) | 0);  /* check that 'ZSTD_frameHeader.headerSize' is an integer */
  (void)((p->dictID) | 0);  /* check that 'ZSTD_frameHeader.dictID' is an integer */
  (void)((p->checksumFlag) | 0);  /* check that 'ZSTD_frameHeader.checksumFlag' is an integer */
}
struct _cffi_align_typedef_ZSTD_frameHeader { char x; ZSTD_frameHeader y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZSTD_frameParameters(ZSTD_frameParameters *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->contentSizeFlag) | 0);  /* check that 'ZSTD_frameParameters.contentSizeFlag' is an integer */
  (void)((p->checksumFlag) | 0);  /* check that 'ZSTD_frameParameters.checksumFlag' is an integer */
  (void)((p->noDictIDFlag) | 0);  /* check that 'ZSTD_frameParameters.noDictIDFlag' is an integer */
}
struct _cffi_align_typedef_ZSTD_frameParameters { char x; ZSTD_frameParameters y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZSTD_frameProgression(ZSTD_frameProgression *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->ingested) | 0);  /* check that 'ZSTD_frameProgression.ingested' is an integer */
  (void)((p->consumed) | 0);  /* check that 'ZSTD_frameProgression.consumed' is an integer */
  (void)((p->produced) | 0);  /* check that 'ZSTD_frameProgression.produced' is an integer */
  (void)((p->flushed) | 0);  /* check that 'ZSTD_frameProgression.flushed' is an integer */
  (void)((p->currentJobID) | 0);  /* check that 'ZSTD_frameProgression.currentJobID' is an integer */
  (void)((p->nbActiveWorkers) | 0);  /* check that 'ZSTD_frameProgression.nbActiveWorkers' is an integer */
}
struct _cffi_align_typedef_ZSTD_frameProgression { char x; ZSTD_frameProgression y; };

static int _cffi_const_ZSTD_frame(unsigned long long *o)
{
  int n = (ZSTD_frame) <= 0;
  *o = (unsigned long long)((ZSTD_frame) | 0);  /* check that ZSTD_frame is an integer */
  return n;
}

static int _cffi_const_ZSTD_skippableFrame(unsigned long long *o)
{
  int n = (ZSTD_skippableFrame) <= 0;
  *o = (unsigned long long)((ZSTD_skippableFrame) | 0);  /* check that ZSTD_skippableFrame is an integer */
  return n;
}

static int _cffi_const_ZSTD_lcm_auto(unsigned long long *o)
{
  int n = (ZSTD_lcm_auto) <= 0;
  *o = (unsigned long long)((ZSTD_lcm_auto) | 0);  /* check that ZSTD_lcm_auto is an integer */
  return n;
}

static int _cffi_const_ZSTD_lcm_huffman(unsigned long long *o)
{
  int n = (ZSTD_lcm_huffman) <= 0;
  *o = (unsigned long long)((ZSTD_lcm_huffman) | 0);  /* check that ZSTD_lcm_huffman is an integer */
  return n;
}

static int _cffi_const_ZSTD_lcm_uncompressed(unsigned long long *o)
{
  int n = (ZSTD_lcm_uncompressed) <= 0;
  *o = (unsigned long long)((ZSTD_lcm_uncompressed) | 0);  /* check that ZSTD_lcm_uncompressed is an integer */
  return n;
}

static int _cffi_const_ZSTDnit_frameHeader(unsigned long long *o)
{
  int n = (ZSTDnit_frameHeader) <= 0;
  *o = (unsigned long long)((ZSTDnit_frameHeader) | 0);  /* check that ZSTDnit_frameHeader is an integer */
  return n;
}

static int _cffi_const_ZSTDnit_blockHeader(unsigned long long *o)
{
  int n = (ZSTDnit_blockHeader) <= 0;
  *o = (unsigned long long)((ZSTDnit_blockHeader) | 0);  /* check that ZSTDnit_blockHeader is an integer */
  return n;
}

static int _cffi_const_ZSTDnit_block(unsigned long long *o)
{
  int n = (ZSTDnit_block) <= 0;
  *o = (unsigned long long)((ZSTDnit_block) | 0);  /* check that ZSTDnit_block is an integer */
  return n;
}

static int _cffi_const_ZSTDnit_lastBlock(unsigned long long *o)
{
  int n = (ZSTDnit_lastBlock) <= 0;
  *o = (unsigned long long)((ZSTDnit_lastBlock) | 0);  /* check that ZSTDnit_lastBlock is an integer */
  return n;
}

static int _cffi_const_ZSTDnit_checksum(unsigned long long *o)
{
  int n = (ZSTDnit_checksum) <= 0;
  *o = (unsigned long long)((ZSTDnit_checksum) | 0);  /* check that ZSTDnit_checksum is an integer */
  return n;
}

static int _cffi_const_ZSTDnit_skippableFrame(unsigned long long *o)
{
  int n = (ZSTDnit_skippableFrame) <= 0;
  *o = (unsigned long long)((ZSTDnit_skippableFrame) | 0);  /* check that ZSTDnit_skippableFrame is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_ZSTD_parameters(ZSTD_parameters *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { ZSTD_compressionParameters *tmp = &p->cParams; (void)tmp; }
  { ZSTD_frameParameters *tmp = &p->fParams; (void)tmp; }
}
struct _cffi_align_typedef_ZSTD_parameters { char x; ZSTD_parameters y; };

static int _cffi_const_ZSTD_rmd_refSingleDDict(unsigned long long *o)
{
  int n = (ZSTD_rmd_refSingleDDict) <= 0;
  *o = (unsigned long long)((ZSTD_rmd_refSingleDDict) | 0);  /* check that ZSTD_rmd_refSingleDDict is an integer */
  return n;
}

static int _cffi_const_ZSTD_rmd_refMultipleDDicts(unsigned long long *o)
{
  int n = (ZSTD_rmd_refMultipleDDicts) <= 0;
  *o = (unsigned long long)((ZSTD_rmd_refMultipleDDicts) | 0);  /* check that ZSTD_rmd_refMultipleDDicts is an integer */
  return n;
}

static int _cffi_const_ZSTD_sf_noBlockDelimiters(unsigned long long *o)
{
  int n = (ZSTD_sf_noBlockDelimiters) <= 0;
  *o = (unsigned long long)((ZSTD_sf_noBlockDelimiters) | 0);  /* check that ZSTD_sf_noBlockDelimiters is an integer */
  return n;
}

static int _cffi_const_ZSTD_sf_explicitBlockDelimiters(unsigned long long *o)
{
  int n = (ZSTD_sf_explicitBlockDelimiters) <= 0;
  *o = (unsigned long long)((ZSTD_sf_explicitBlockDelimiters) | 0);  /* check that ZSTD_sf_explicitBlockDelimiters is an integer */
  return n;
}

static int _cffi_const_ZSTD_fast(unsigned long long *o)
{
  int n = (ZSTD_fast) <= 0;
  *o = (unsigned long long)((ZSTD_fast) | 0);  /* check that ZSTD_fast is an integer */
  return n;
}

static int _cffi_const_ZSTD_dfast(unsigned long long *o)
{
  int n = (ZSTD_dfast) <= 0;
  *o = (unsigned long long)((ZSTD_dfast) | 0);  /* check that ZSTD_dfast is an integer */
  return n;
}

static int _cffi_const_ZSTD_greedy(unsigned long long *o)
{
  int n = (ZSTD_greedy) <= 0;
  *o = (unsigned long long)((ZSTD_greedy) | 0);  /* check that ZSTD_greedy is an integer */
  return n;
}

static int _cffi_const_ZSTD_lazy(unsigned long long *o)
{
  int n = (ZSTD_lazy) <= 0;
  *o = (unsigned long long)((ZSTD_lazy) | 0);  /* check that ZSTD_lazy is an integer */
  return n;
}

static int _cffi_const_ZSTD_lazy2(unsigned long long *o)
{
  int n = (ZSTD_lazy2) <= 0;
  *o = (unsigned long long)((ZSTD_lazy2) | 0);  /* check that ZSTD_lazy2 is an integer */
  return n;
}

static int _cffi_const_ZSTD_btlazy2(unsigned long long *o)
{
  int n = (ZSTD_btlazy2) <= 0;
  *o = (unsigned long long)((ZSTD_btlazy2) | 0);  /* check that ZSTD_btlazy2 is an integer */
  return n;
}

static int _cffi_const_ZSTD_btopt(unsigned long long *o)
{
  int n = (ZSTD_btopt) <= 0;
  *o = (unsigned long long)((ZSTD_btopt) | 0);  /* check that ZSTD_btopt is an integer */
  return n;
}

static int _cffi_const_ZSTD_btultra(unsigned long long *o)
{
  int n = (ZSTD_btultra) <= 0;
  *o = (unsigned long long)((ZSTD_btultra) | 0);  /* check that ZSTD_btultra is an integer */
  return n;
}

static int _cffi_const_ZSTD_btultra2(unsigned long long *o)
{
  int n = (ZSTD_btultra2) <= 0;
  *o = (unsigned long long)((ZSTD_btultra2) | 0);  /* check that ZSTD_btultra2 is an integer */
  return n;
}

static int _cffi_const_ZSTD_urm_auto(unsigned long long *o)
{
  int n = (ZSTD_urm_auto) <= 0;
  *o = (unsigned long long)((ZSTD_urm_auto) | 0);  /* check that ZSTD_urm_auto is an integer */
  return n;
}

static int _cffi_const_ZSTD_urm_disableRowMatchFinder(unsigned long long *o)
{
  int n = (ZSTD_urm_disableRowMatchFinder) <= 0;
  *o = (unsigned long long)((ZSTD_urm_disableRowMatchFinder) | 0);  /* check that ZSTD_urm_disableRowMatchFinder is an integer */
  return n;
}

static int _cffi_const_ZSTD_urm_enableRowMatchFinder(unsigned long long *o)
{
  int n = (ZSTD_urm_enableRowMatchFinder) <= 0;
  *o = (unsigned long long)((ZSTD_urm_enableRowMatchFinder) | 0);  /* check that ZSTD_urm_enableRowMatchFinder is an integer */
  return n;
}

static void _cffi_const_ZSTD_defaultCMem(char *o)
{
  *(ZSTD_customMem *)o = ZSTD_defaultCMem;
}

static size_t _cffi_d_ZDICT_addEntropyTablesFromBuffer(void * x0, size_t x1, size_t x2, void const * x3, size_t const * x4, unsigned int x5)
{
  return ZDICT_addEntropyTablesFromBuffer(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_addEntropyTablesFromBuffer(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  size_t x2;
  void const * x3;
  size_t const * x4;
  unsigned int x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZDICT_addEntropyTablesFromBuffer", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(456), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (size_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(456), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, unsigned int);
  if (x5 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_addEntropyTablesFromBuffer(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZDICT_addEntropyTablesFromBuffer _cffi_d_ZDICT_addEntropyTablesFromBuffer
#endif

static size_t _cffi_d_ZDICT_finalizeDictionary(void * x0, size_t x1, void const * x2, size_t x3, void const * x4, size_t const * x5, unsigned int x6, ZDICT_params_t x7)
{
  return ZDICT_finalizeDictionary(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_finalizeDictionary(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t x3;
  void const * x4;
  size_t const * x5;
  unsigned int x6;
  ZDICT_params_t x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "ZDICT_finalizeDictionary", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(456), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (size_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(456), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, unsigned int);
  if (x6 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x7, _cffi_type(534), arg7) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_finalizeDictionary(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZDICT_finalizeDictionary(void * x0, size_t x1, void const * x2, size_t x3, void const * x4, size_t const * x5, unsigned int x6, ZDICT_params_t *x7)
{
  size_t result;
  { result = ZDICT_finalizeDictionary(x0, x1, x2, x3, x4, x5, x6, *x7); }
  return result;
}
#endif

static size_t _cffi_d_ZDICT_getDictHeaderSize(void const * x0, size_t x1)
{
  return ZDICT_getDictHeaderSize(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_getDictHeaderSize(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZDICT_getDictHeaderSize", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_getDictHeaderSize(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZDICT_getDictHeaderSize _cffi_d_ZDICT_getDictHeaderSize
#endif

static unsigned int _cffi_d_ZDICT_getDictID(void const * x0, size_t x1)
{
  return ZDICT_getDictID(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_getDictID(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZDICT_getDictID", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_getDictID(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZDICT_getDictID _cffi_d_ZDICT_getDictID
#endif

static char const * _cffi_d_ZDICT_getErrorName(size_t x0)
{
  return ZDICT_getErrorName(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_getErrorName(PyObject *self, PyObject *arg0)
{
  size_t x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_getErrorName(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(597));
  return pyresult;
}
#else
#  define _cffi_f_ZDICT_getErrorName _cffi_d_ZDICT_getErrorName
#endif

static unsigned int _cffi_d_ZDICT_isError(size_t x0)
{
  return ZDICT_isError(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_isError(PyObject *self, PyObject *arg0)
{
  size_t x0;
  unsigned int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_isError(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ZDICT_isError _cffi_d_ZDICT_isError
#endif

static size_t _cffi_d_ZDICT_optimizeTrainFromBuffer_cover(void * x0, size_t x1, void const * x2, size_t const * x3, unsigned int x4, ZDICT_cover_params_t * x5)
{
  return ZDICT_optimizeTrainFromBuffer_cover(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_optimizeTrainFromBuffer_cover(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t const * x3;
  unsigned int x4;
  ZDICT_cover_params_t * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZDICT_optimizeTrainFromBuffer_cover", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(456), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(456), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(472), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (ZDICT_cover_params_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(472), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_optimizeTrainFromBuffer_cover(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZDICT_optimizeTrainFromBuffer_cover _cffi_d_ZDICT_optimizeTrainFromBuffer_cover
#endif

static size_t _cffi_d_ZDICT_optimizeTrainFromBuffer_fastCover(void * x0, size_t x1, void const * x2, size_t const * x3, unsigned int x4, ZDICT_fastCover_params_t * x5)
{
  return ZDICT_optimizeTrainFromBuffer_fastCover(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_optimizeTrainFromBuffer_fastCover(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t const * x3;
  unsigned int x4;
  ZDICT_fastCover_params_t * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZDICT_optimizeTrainFromBuffer_fastCover", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(456), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(456), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(488), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (ZDICT_fastCover_params_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(488), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_optimizeTrainFromBuffer_fastCover(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZDICT_optimizeTrainFromBuffer_fastCover _cffi_d_ZDICT_optimizeTrainFromBuffer_fastCover
#endif

static size_t _cffi_d_ZDICT_trainFromBuffer(void * x0, size_t x1, void const * x2, size_t const * x3, unsigned int x4)
{
  return ZDICT_trainFromBuffer(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_trainFromBuffer(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t const * x3;
  unsigned int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZDICT_trainFromBuffer", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(456), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(456), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_trainFromBuffer(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZDICT_trainFromBuffer _cffi_d_ZDICT_trainFromBuffer
#endif

static size_t _cffi_d_ZDICT_trainFromBuffer_cover(void * x0, size_t x1, void const * x2, size_t const * x3, unsigned int x4, ZDICT_cover_params_t x5)
{
  return ZDICT_trainFromBuffer_cover(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_trainFromBuffer_cover(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t const * x3;
  unsigned int x4;
  ZDICT_cover_params_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZDICT_trainFromBuffer_cover", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(456), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(456), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(480), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_trainFromBuffer_cover(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZDICT_trainFromBuffer_cover(void * x0, size_t x1, void const * x2, size_t const * x3, unsigned int x4, ZDICT_cover_params_t *x5)
{
  size_t result;
  { result = ZDICT_trainFromBuffer_cover(x0, x1, x2, x3, x4, *x5); }
  return result;
}
#endif

static size_t _cffi_d_ZDICT_trainFromBuffer_fastCover(void * x0, size_t x1, void const * x2, size_t const * x3, unsigned int x4, ZDICT_fastCover_params_t x5)
{
  return ZDICT_trainFromBuffer_fastCover(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_trainFromBuffer_fastCover(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t const * x3;
  unsigned int x4;
  ZDICT_fastCover_params_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZDICT_trainFromBuffer_fastCover", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(456), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(456), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(496), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_trainFromBuffer_fastCover(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZDICT_trainFromBuffer_fastCover(void * x0, size_t x1, void const * x2, size_t const * x3, unsigned int x4, ZDICT_fastCover_params_t *x5)
{
  size_t result;
  { result = ZDICT_trainFromBuffer_fastCover(x0, x1, x2, x3, x4, *x5); }
  return result;
}
#endif

static size_t _cffi_d_ZDICT_trainFromBuffer_legacy(void * x0, size_t x1, void const * x2, size_t const * x3, unsigned int x4, ZDICT_legacy_params_t x5)
{
  return ZDICT_trainFromBuffer_legacy(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZDICT_trainFromBuffer_legacy(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t const * x3;
  unsigned int x4;
  ZDICT_legacy_params_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZDICT_trainFromBuffer_legacy", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(456), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(456), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(504), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZDICT_trainFromBuffer_legacy(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZDICT_trainFromBuffer_legacy(void * x0, size_t x1, void const * x2, size_t const * x3, unsigned int x4, ZDICT_legacy_params_t *x5)
{
  size_t result;
  { result = ZDICT_trainFromBuffer_legacy(x0, x1, x2, x3, x4, *x5); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_CCtxParams_getParameter(ZSTD_CCtx_params const * x0, ZSTD_cParameter x1, int * x2)
{
  return ZSTD_CCtxParams_getParameter(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtxParams_getParameter(PyObject *self, PyObject *args)
{
  ZSTD_CCtx_params const * x0;
  ZSTD_cParameter x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtxParams_getParameter", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(70), arg1) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(284), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(284), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtxParams_getParameter(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtxParams_getParameter _cffi_d_ZSTD_CCtxParams_getParameter
#endif

static size_t _cffi_d_ZSTD_CCtxParams_init(ZSTD_CCtx_params * x0, int x1)
{
  return ZSTD_CCtxParams_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtxParams_init(PyObject *self, PyObject *args)
{
  ZSTD_CCtx_params * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtxParams_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(287), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(287), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtxParams_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtxParams_init _cffi_d_ZSTD_CCtxParams_init
#endif

static size_t _cffi_d_ZSTD_CCtxParams_init_advanced(ZSTD_CCtx_params * x0, ZSTD_parameters x1)
{
  return ZSTD_CCtxParams_init_advanced(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtxParams_init_advanced(PyObject *self, PyObject *args)
{
  ZSTD_CCtx_params * x0;
  ZSTD_parameters x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtxParams_init_advanced", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(287), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(287), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(235), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtxParams_init_advanced(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_CCtxParams_init_advanced(ZSTD_CCtx_params * x0, ZSTD_parameters *x1)
{
  size_t result;
  { result = ZSTD_CCtxParams_init_advanced(x0, *x1); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_CCtxParams_reset(ZSTD_CCtx_params * x0)
{
  return ZSTD_CCtxParams_reset(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtxParams_reset(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx_params * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(287), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(287), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtxParams_reset(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtxParams_reset _cffi_d_ZSTD_CCtxParams_reset
#endif

static size_t _cffi_d_ZSTD_CCtxParams_setParameter(ZSTD_CCtx_params * x0, ZSTD_cParameter x1, int x2)
{
  return ZSTD_CCtxParams_setParameter(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtxParams_setParameter(PyObject *self, PyObject *args)
{
  ZSTD_CCtx_params * x0;
  ZSTD_cParameter x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtxParams_setParameter", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(287), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(287), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(70), arg1) < 0)
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtxParams_setParameter(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtxParams_setParameter _cffi_d_ZSTD_CCtxParams_setParameter
#endif

static size_t _cffi_d_ZSTD_CCtx_getParameter(ZSTD_CCtx const * x0, ZSTD_cParameter x1, int * x2)
{
  return ZSTD_CCtx_getParameter(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_getParameter(PyObject *self, PyObject *args)
{
  ZSTD_CCtx const * x0;
  ZSTD_cParameter x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_getParameter", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(86), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(70), arg1) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(284), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(284), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_getParameter(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_getParameter _cffi_d_ZSTD_CCtx_getParameter
#endif

static size_t _cffi_d_ZSTD_CCtx_loadDictionary(ZSTD_CCtx * x0, void const * x1, size_t x2)
{
  return ZSTD_CCtx_loadDictionary(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_loadDictionary(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_loadDictionary", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_loadDictionary(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_loadDictionary _cffi_d_ZSTD_CCtx_loadDictionary
#endif

static size_t _cffi_d_ZSTD_CCtx_loadDictionary_advanced(ZSTD_CCtx * x0, void const * x1, size_t x2, ZSTD_dictLoadMethod_e x3, ZSTD_dictContentType_e x4)
{
  return ZSTD_CCtx_loadDictionary_advanced(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_loadDictionary_advanced(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void const * x1;
  size_t x2;
  ZSTD_dictLoadMethod_e x3;
  ZSTD_dictContentType_e x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_loadDictionary_advanced", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(14), arg3) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(15), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_loadDictionary_advanced(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_loadDictionary_advanced _cffi_d_ZSTD_CCtx_loadDictionary_advanced
#endif

static size_t _cffi_d_ZSTD_CCtx_loadDictionary_byReference(ZSTD_CCtx * x0, void const * x1, size_t x2)
{
  return ZSTD_CCtx_loadDictionary_byReference(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_loadDictionary_byReference(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_loadDictionary_byReference", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_loadDictionary_byReference(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_loadDictionary_byReference _cffi_d_ZSTD_CCtx_loadDictionary_byReference
#endif

static size_t _cffi_d_ZSTD_CCtx_refCDict(ZSTD_CCtx * x0, ZSTD_CDict const * x1)
{
  return ZSTD_CCtx_refCDict(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_refCDict(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_CDict const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_refCDict", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_CDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_refCDict(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_refCDict _cffi_d_ZSTD_CCtx_refCDict
#endif

static size_t _cffi_d_ZSTD_CCtx_refPrefix(ZSTD_CCtx * x0, void const * x1, size_t x2)
{
  return ZSTD_CCtx_refPrefix(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_refPrefix(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_refPrefix", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_refPrefix(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_refPrefix _cffi_d_ZSTD_CCtx_refPrefix
#endif

static size_t _cffi_d_ZSTD_CCtx_refPrefix_advanced(ZSTD_CCtx * x0, void const * x1, size_t x2, ZSTD_dictContentType_e x3)
{
  return ZSTD_CCtx_refPrefix_advanced(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_refPrefix_advanced(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void const * x1;
  size_t x2;
  ZSTD_dictContentType_e x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_refPrefix_advanced", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(15), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_refPrefix_advanced(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_refPrefix_advanced _cffi_d_ZSTD_CCtx_refPrefix_advanced
#endif

static size_t _cffi_d_ZSTD_CCtx_refThreadPool(ZSTD_CCtx * x0, ZSTD_threadPool * x1)
{
  return ZSTD_CCtx_refThreadPool(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_refThreadPool(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_threadPool * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_refThreadPool", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(161), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_threadPool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(161), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_refThreadPool(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_refThreadPool _cffi_d_ZSTD_CCtx_refThreadPool
#endif

static size_t _cffi_d_ZSTD_CCtx_reset(ZSTD_CCtx * x0, ZSTD_ResetDirective x1)
{
  return ZSTD_CCtx_reset(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_reset(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_ResetDirective x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_reset", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(130), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_reset(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_reset _cffi_d_ZSTD_CCtx_reset
#endif

static size_t _cffi_d_ZSTD_CCtx_setParameter(ZSTD_CCtx * x0, ZSTD_cParameter x1, int x2)
{
  return ZSTD_CCtx_setParameter(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_setParameter(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_cParameter x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_setParameter", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(70), arg1) < 0)
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_setParameter(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_setParameter _cffi_d_ZSTD_CCtx_setParameter
#endif

static size_t _cffi_d_ZSTD_CCtx_setParametersUsingCCtxParams(ZSTD_CCtx * x0, ZSTD_CCtx_params const * x1)
{
  return ZSTD_CCtx_setParametersUsingCCtxParams(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_setParametersUsingCCtxParams(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_CCtx_params const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_setParametersUsingCCtxParams", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_setParametersUsingCCtxParams(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_setParametersUsingCCtxParams _cffi_d_ZSTD_CCtx_setParametersUsingCCtxParams
#endif

static size_t _cffi_d_ZSTD_CCtx_setPledgedSrcSize(ZSTD_CCtx * x0, unsigned long long x1)
{
  return ZSTD_CCtx_setPledgedSrcSize(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CCtx_setPledgedSrcSize(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  unsigned long long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_CCtx_setPledgedSrcSize", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned long long);
  if (x1 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CCtx_setPledgedSrcSize(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CCtx_setPledgedSrcSize _cffi_d_ZSTD_CCtx_setPledgedSrcSize
#endif

static size_t _cffi_d_ZSTD_CStreamInSize(void)
{
  return ZSTD_CStreamInSize();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CStreamInSize(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CStreamInSize(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CStreamInSize _cffi_d_ZSTD_CStreamInSize
#endif

static size_t _cffi_d_ZSTD_CStreamOutSize(void)
{
  return ZSTD_CStreamOutSize();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_CStreamOutSize(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_CStreamOutSize(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_CStreamOutSize _cffi_d_ZSTD_CStreamOutSize
#endif

static size_t _cffi_d_ZSTD_DCtx_getParameter(ZSTD_DCtx * x0, ZSTD_dParameter x1, int * x2)
{
  return ZSTD_DCtx_getParameter(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_getParameter(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  ZSTD_dParameter x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_getParameter", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(73), arg1) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(284), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(284), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_getParameter(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_getParameter _cffi_d_ZSTD_DCtx_getParameter
#endif

static size_t _cffi_d_ZSTD_DCtx_loadDictionary(ZSTD_DCtx * x0, void const * x1, size_t x2)
{
  return ZSTD_DCtx_loadDictionary(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_loadDictionary(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_loadDictionary", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_loadDictionary(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_loadDictionary _cffi_d_ZSTD_DCtx_loadDictionary
#endif

static size_t _cffi_d_ZSTD_DCtx_loadDictionary_advanced(ZSTD_DCtx * x0, void const * x1, size_t x2, ZSTD_dictLoadMethod_e x3, ZSTD_dictContentType_e x4)
{
  return ZSTD_DCtx_loadDictionary_advanced(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_loadDictionary_advanced(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void const * x1;
  size_t x2;
  ZSTD_dictLoadMethod_e x3;
  ZSTD_dictContentType_e x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_loadDictionary_advanced", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(14), arg3) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(15), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_loadDictionary_advanced(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_loadDictionary_advanced _cffi_d_ZSTD_DCtx_loadDictionary_advanced
#endif

static size_t _cffi_d_ZSTD_DCtx_loadDictionary_byReference(ZSTD_DCtx * x0, void const * x1, size_t x2)
{
  return ZSTD_DCtx_loadDictionary_byReference(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_loadDictionary_byReference(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_loadDictionary_byReference", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_loadDictionary_byReference(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_loadDictionary_byReference _cffi_d_ZSTD_DCtx_loadDictionary_byReference
#endif

static size_t _cffi_d_ZSTD_DCtx_refDDict(ZSTD_DCtx * x0, ZSTD_DDict const * x1)
{
  return ZSTD_DCtx_refDDict(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_refDDict(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  ZSTD_DDict const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_refDDict", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(321), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_DDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(321), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_refDDict(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_refDDict _cffi_d_ZSTD_DCtx_refDDict
#endif

static size_t _cffi_d_ZSTD_DCtx_refPrefix(ZSTD_DCtx * x0, void const * x1, size_t x2)
{
  return ZSTD_DCtx_refPrefix(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_refPrefix(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_refPrefix", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_refPrefix(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_refPrefix _cffi_d_ZSTD_DCtx_refPrefix
#endif

static size_t _cffi_d_ZSTD_DCtx_refPrefix_advanced(ZSTD_DCtx * x0, void const * x1, size_t x2, ZSTD_dictContentType_e x3)
{
  return ZSTD_DCtx_refPrefix_advanced(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_refPrefix_advanced(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void const * x1;
  size_t x2;
  ZSTD_dictContentType_e x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_refPrefix_advanced", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(15), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_refPrefix_advanced(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_refPrefix_advanced _cffi_d_ZSTD_DCtx_refPrefix_advanced
#endif

static size_t _cffi_d_ZSTD_DCtx_reset(ZSTD_DCtx * x0, ZSTD_ResetDirective x1)
{
  return ZSTD_DCtx_reset(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_reset(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  ZSTD_ResetDirective x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_reset", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(130), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_reset(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_reset _cffi_d_ZSTD_DCtx_reset
#endif

static size_t _cffi_d_ZSTD_DCtx_setFormat(ZSTD_DCtx * x0, ZSTD_format_e x1)
{
  return ZSTD_DCtx_setFormat(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_setFormat(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  ZSTD_format_e x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_setFormat", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(339), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_setFormat(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_setFormat _cffi_d_ZSTD_DCtx_setFormat
#endif

static size_t _cffi_d_ZSTD_DCtx_setMaxWindowSize(ZSTD_DCtx * x0, size_t x1)
{
  return ZSTD_DCtx_setMaxWindowSize(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_setMaxWindowSize(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_setMaxWindowSize", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_setMaxWindowSize(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_setMaxWindowSize _cffi_d_ZSTD_DCtx_setMaxWindowSize
#endif

static size_t _cffi_d_ZSTD_DCtx_setParameter(ZSTD_DCtx * x0, ZSTD_dParameter x1, int x2)
{
  return ZSTD_DCtx_setParameter(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DCtx_setParameter(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  ZSTD_dParameter x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_DCtx_setParameter", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(73), arg1) < 0)
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DCtx_setParameter(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DCtx_setParameter _cffi_d_ZSTD_DCtx_setParameter
#endif

static size_t _cffi_d_ZSTD_DStreamInSize(void)
{
  return ZSTD_DStreamInSize();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DStreamInSize(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DStreamInSize(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DStreamInSize _cffi_d_ZSTD_DStreamInSize
#endif

static size_t _cffi_d_ZSTD_DStreamOutSize(void)
{
  return ZSTD_DStreamOutSize();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_DStreamOutSize(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_DStreamOutSize(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_DStreamOutSize _cffi_d_ZSTD_DStreamOutSize
#endif

static ZSTD_compressionParameters _cffi_d_ZSTD_adjustCParams(ZSTD_compressionParameters x0, unsigned long long x1, size_t x2)
{
  return ZSTD_adjustCParams(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_adjustCParams(PyObject *self, PyObject *args)
{
  ZSTD_compressionParameters x0;
  unsigned long long x1;
  size_t x2;
  ZSTD_compressionParameters result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_adjustCParams", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  if (_cffi_to_c((char *)&x0, _cffi_type(24), arg0) < 0)
    return NULL;

  x1 = _cffi_to_c_int(arg1, unsigned long long);
  if (x1 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_adjustCParams(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(24));
  return pyresult;
}
#else
static void _cffi_f_ZSTD_adjustCParams(ZSTD_compressionParameters *result, ZSTD_compressionParameters *x0, unsigned long long x1, size_t x2)
{
  { *result = ZSTD_adjustCParams(*x0, x1, x2); }
}
#endif

static ZSTD_bounds _cffi_d_ZSTD_cParam_getBounds(ZSTD_cParameter x0)
{
  return ZSTD_cParam_getBounds(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_cParam_getBounds(PyObject *self, PyObject *arg0)
{
  ZSTD_cParameter x0;
  ZSTD_bounds result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(70), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_cParam_getBounds(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(582));
  return pyresult;
}
#else
static void _cffi_f_ZSTD_cParam_getBounds(ZSTD_bounds *result, ZSTD_cParameter x0)
{
  { *result = ZSTD_cParam_getBounds(x0); }
}
#endif

static size_t _cffi_d_ZSTD_checkCParams(ZSTD_compressionParameters x0)
{
  return ZSTD_checkCParams(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_checkCParams(PyObject *self, PyObject *arg0)
{
  ZSTD_compressionParameters x0;
  size_t result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(24), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_checkCParams(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_checkCParams(ZSTD_compressionParameters *x0)
{
  size_t result;
  { result = ZSTD_checkCParams(*x0); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_compress(void * x0, size_t x1, void const * x2, size_t x3, int x4)
{
  return ZSTD_compress(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compress(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_compress", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compress(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compress _cffi_d_ZSTD_compress
#endif

static size_t _cffi_d_ZSTD_compress2(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4)
{
  return ZSTD_compress2(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compress2(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_compress2", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compress2(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compress2 _cffi_d_ZSTD_compress2
#endif

static size_t _cffi_d_ZSTD_compressBegin(ZSTD_CCtx * x0, int x1)
{
  return ZSTD_compressBegin(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressBegin(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressBegin", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressBegin(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressBegin _cffi_d_ZSTD_compressBegin
#endif

static size_t _cffi_d_ZSTD_compressBegin_advanced(ZSTD_CCtx * x0, void const * x1, size_t x2, ZSTD_parameters x3, unsigned long long x4)
{
  return ZSTD_compressBegin_advanced(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressBegin_advanced(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void const * x1;
  size_t x2;
  ZSTD_parameters x3;
  unsigned long long x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressBegin_advanced", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(235), arg3) < 0)
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned long long);
  if (x4 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressBegin_advanced(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_compressBegin_advanced(ZSTD_CCtx * x0, void const * x1, size_t x2, ZSTD_parameters *x3, unsigned long long x4)
{
  size_t result;
  { result = ZSTD_compressBegin_advanced(x0, x1, x2, *x3, x4); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_compressBegin_usingCDict(ZSTD_CCtx * x0, ZSTD_CDict const * x1)
{
  return ZSTD_compressBegin_usingCDict(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressBegin_usingCDict(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_CDict const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressBegin_usingCDict", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_CDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressBegin_usingCDict(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressBegin_usingCDict _cffi_d_ZSTD_compressBegin_usingCDict
#endif

static size_t _cffi_d_ZSTD_compressBegin_usingCDict_advanced(ZSTD_CCtx * x0, ZSTD_CDict const * x1, ZSTD_frameParameters x2, unsigned long long x3)
{
  return ZSTD_compressBegin_usingCDict_advanced(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressBegin_usingCDict_advanced(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_CDict const * x1;
  ZSTD_frameParameters x2;
  unsigned long long x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressBegin_usingCDict_advanced", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_CDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(125), arg2) < 0)
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned long long);
  if (x3 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressBegin_usingCDict_advanced(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_compressBegin_usingCDict_advanced(ZSTD_CCtx * x0, ZSTD_CDict const * x1, ZSTD_frameParameters *x2, unsigned long long x3)
{
  size_t result;
  { result = ZSTD_compressBegin_usingCDict_advanced(x0, x1, *x2, x3); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_compressBegin_usingDict(ZSTD_CCtx * x0, void const * x1, size_t x2, int x3)
{
  return ZSTD_compressBegin_usingDict(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressBegin_usingDict(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void const * x1;
  size_t x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressBegin_usingDict", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressBegin_usingDict(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressBegin_usingDict _cffi_d_ZSTD_compressBegin_usingDict
#endif

static size_t _cffi_d_ZSTD_compressBlock(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4)
{
  return ZSTD_compressBlock(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressBlock(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressBlock", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressBlock(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressBlock _cffi_d_ZSTD_compressBlock
#endif

static size_t _cffi_d_ZSTD_compressBound(size_t x0)
{
  return ZSTD_compressBound(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressBound(PyObject *self, PyObject *arg0)
{
  size_t x0;
  size_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressBound(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressBound _cffi_d_ZSTD_compressBound
#endif

static size_t _cffi_d_ZSTD_compressCCtx(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4, int x5)
{
  return ZSTD_compressCCtx(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressCCtx(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  int x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressCCtx", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressCCtx(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressCCtx _cffi_d_ZSTD_compressCCtx
#endif

static size_t _cffi_d_ZSTD_compressContinue(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4)
{
  return ZSTD_compressContinue(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressContinue(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressContinue", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressContinue(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressContinue _cffi_d_ZSTD_compressContinue
#endif

static size_t _cffi_d_ZSTD_compressEnd(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4)
{
  return ZSTD_compressEnd(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressEnd(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressEnd", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressEnd(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressEnd _cffi_d_ZSTD_compressEnd
#endif

static size_t _cffi_d_ZSTD_compressSequences(ZSTD_CCtx * x0, void * x1, size_t x2, ZSTD_Sequence const * x3, size_t x4, void const * x5, size_t x6)
{
  return ZSTD_compressSequences(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressSequences(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  ZSTD_Sequence const * x3;
  size_t x4;
  void const * x5;
  size_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressSequences", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(180), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (ZSTD_Sequence const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(180), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressSequences(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressSequences _cffi_d_ZSTD_compressSequences
#endif

static size_t _cffi_d_ZSTD_compressStream(ZSTD_CCtx * x0, ZSTD_outBuffer * x1, ZSTD_inBuffer * x2)
{
  return ZSTD_compressStream(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressStream(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_outBuffer * x1;
  ZSTD_inBuffer * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressStream", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(146), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_outBuffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(146), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(151), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (ZSTD_inBuffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(151), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressStream(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressStream _cffi_d_ZSTD_compressStream
#endif

static size_t _cffi_d_ZSTD_compressStream2(ZSTD_CCtx * x0, ZSTD_outBuffer * x1, ZSTD_inBuffer * x2, ZSTD_EndDirective x3)
{
  return ZSTD_compressStream2(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressStream2(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_outBuffer * x1;
  ZSTD_inBuffer * x2;
  ZSTD_EndDirective x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressStream2", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(146), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_outBuffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(146), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(151), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (ZSTD_inBuffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(151), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x3, _cffi_type(157), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressStream2(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressStream2 _cffi_d_ZSTD_compressStream2
#endif

static size_t _cffi_d_ZSTD_compressStream2_simpleArgs(ZSTD_CCtx * x0, void * x1, size_t x2, size_t * x3, void const * x4, size_t x5, size_t * x6, ZSTD_EndDirective x7)
{
  return ZSTD_compressStream2_simpleArgs(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compressStream2_simpleArgs(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  size_t * x3;
  void const * x4;
  size_t x5;
  size_t * x6;
  ZSTD_EndDirective x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "ZSTD_compressStream2_simpleArgs", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(189), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(189), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, size_t);
  if (x5 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(189), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(189), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x7, _cffi_type(157), arg7) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compressStream2_simpleArgs(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compressStream2_simpleArgs _cffi_d_ZSTD_compressStream2_simpleArgs
#endif

static size_t _cffi_d_ZSTD_compress_advanced(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4, void const * x5, size_t x6, ZSTD_parameters x7)
{
  return ZSTD_compress_advanced(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compress_advanced(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  void const * x5;
  size_t x6;
  ZSTD_parameters x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "ZSTD_compress_advanced", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x7, _cffi_type(235), arg7) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compress_advanced(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_compress_advanced(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4, void const * x5, size_t x6, ZSTD_parameters *x7)
{
  size_t result;
  { result = ZSTD_compress_advanced(x0, x1, x2, x3, x4, x5, x6, *x7); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_compress_usingCDict(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4, ZSTD_CDict const * x5)
{
  return ZSTD_compress_usingCDict(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compress_usingCDict(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  ZSTD_CDict const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZSTD_compress_usingCDict", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (ZSTD_CDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compress_usingCDict(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compress_usingCDict _cffi_d_ZSTD_compress_usingCDict
#endif

static size_t _cffi_d_ZSTD_compress_usingCDict_advanced(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4, ZSTD_CDict const * x5, ZSTD_frameParameters x6)
{
  return ZSTD_compress_usingCDict_advanced(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compress_usingCDict_advanced(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  ZSTD_CDict const * x5;
  ZSTD_frameParameters x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "ZSTD_compress_usingCDict_advanced", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (ZSTD_CDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x6, _cffi_type(125), arg6) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compress_usingCDict_advanced(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_compress_usingCDict_advanced(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4, ZSTD_CDict const * x5, ZSTD_frameParameters *x6)
{
  size_t result;
  { result = ZSTD_compress_usingCDict_advanced(x0, x1, x2, x3, x4, x5, *x6); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_compress_usingDict(ZSTD_CCtx * x0, void * x1, size_t x2, void const * x3, size_t x4, void const * x5, size_t x6, int x7)
{
  return ZSTD_compress_usingDict(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_compress_usingDict(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  void const * x5;
  size_t x6;
  int x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "ZSTD_compress_usingDict", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, int);
  if (x7 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_compress_usingDict(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_compress_usingDict _cffi_d_ZSTD_compress_usingDict
#endif

static size_t _cffi_d_ZSTD_copyCCtx(ZSTD_CCtx * x0, ZSTD_CCtx const * x1, unsigned long long x2)
{
  return ZSTD_copyCCtx(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_copyCCtx(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_CCtx const * x1;
  unsigned long long x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_copyCCtx", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(86), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_copyCCtx(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_copyCCtx _cffi_d_ZSTD_copyCCtx
#endif

static void _cffi_d_ZSTD_copyDCtx(ZSTD_DCtx * x0, ZSTD_DCtx const * x1)
{
  ZSTD_copyDCtx(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_copyDCtx(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  ZSTD_DCtx const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_copyDCtx", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(402), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(402), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ZSTD_copyDCtx(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ZSTD_copyDCtx _cffi_d_ZSTD_copyDCtx
#endif

static ZSTD_CCtx * _cffi_d_ZSTD_createCCtx(void)
{
  return ZSTD_createCCtx();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createCCtx(PyObject *self, PyObject *noarg)
{
  ZSTD_CCtx * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createCCtx(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(107));
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_createCCtx _cffi_d_ZSTD_createCCtx
#endif

static ZSTD_CCtx_params * _cffi_d_ZSTD_createCCtxParams(void)
{
  return ZSTD_createCCtxParams();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createCCtxParams(PyObject *self, PyObject *noarg)
{
  ZSTD_CCtx_params * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createCCtxParams(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(287));
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_createCCtxParams _cffi_d_ZSTD_createCCtxParams
#endif

static ZSTD_CCtx * _cffi_d_ZSTD_createCCtx_advanced(ZSTD_customMem x0)
{
  return ZSTD_createCCtx_advanced(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createCCtx_advanced(PyObject *self, PyObject *arg0)
{
  ZSTD_customMem x0;
  ZSTD_CCtx * result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createCCtx_advanced(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(107));
  return pyresult;
}
#else
static ZSTD_CCtx * _cffi_f_ZSTD_createCCtx_advanced(ZSTD_customMem *x0)
{
  ZSTD_CCtx * result;
  { result = ZSTD_createCCtx_advanced(*x0); }
  return result;
}
#endif

static ZSTD_CDict * _cffi_d_ZSTD_createCDict(void const * x0, size_t x1, int x2)
{
  return ZSTD_createCDict(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createCDict(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_CDict * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_createCDict", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createCDict(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(311));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_createCDict _cffi_d_ZSTD_createCDict
#endif

static ZSTD_CDict * _cffi_d_ZSTD_createCDict_advanced(void const * x0, size_t x1, ZSTD_dictLoadMethod_e x2, ZSTD_dictContentType_e x3, ZSTD_compressionParameters x4, ZSTD_customMem x5)
{
  return ZSTD_createCDict_advanced(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createCDict_advanced(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  ZSTD_dictLoadMethod_e x2;
  ZSTD_dictContentType_e x3;
  ZSTD_compressionParameters x4;
  ZSTD_customMem x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_CDict * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZSTD_createCDict_advanced", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(14), arg2) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(15), arg3) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(24), arg4) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(1), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createCDict_advanced(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(311));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static ZSTD_CDict * _cffi_f_ZSTD_createCDict_advanced(void const * x0, size_t x1, ZSTD_dictLoadMethod_e x2, ZSTD_dictContentType_e x3, ZSTD_compressionParameters *x4, ZSTD_customMem *x5)
{
  ZSTD_CDict * result;
  { result = ZSTD_createCDict_advanced(x0, x1, x2, x3, *x4, *x5); }
  return result;
}
#endif

static ZSTD_CDict * _cffi_d_ZSTD_createCDict_advanced2(void const * x0, size_t x1, ZSTD_dictLoadMethod_e x2, ZSTD_dictContentType_e x3, ZSTD_CCtx_params const * x4, ZSTD_customMem x5)
{
  return ZSTD_createCDict_advanced2(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createCDict_advanced2(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  ZSTD_dictLoadMethod_e x2;
  ZSTD_dictContentType_e x3;
  ZSTD_CCtx_params const * x4;
  ZSTD_customMem x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_CDict * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZSTD_createCDict_advanced2", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(14), arg2) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(15), arg3) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x5, _cffi_type(1), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createCDict_advanced2(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(311));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static ZSTD_CDict * _cffi_f_ZSTD_createCDict_advanced2(void const * x0, size_t x1, ZSTD_dictLoadMethod_e x2, ZSTD_dictContentType_e x3, ZSTD_CCtx_params const * x4, ZSTD_customMem *x5)
{
  ZSTD_CDict * result;
  { result = ZSTD_createCDict_advanced2(x0, x1, x2, x3, x4, *x5); }
  return result;
}
#endif

static ZSTD_CDict * _cffi_d_ZSTD_createCDict_byReference(void const * x0, size_t x1, int x2)
{
  return ZSTD_createCDict_byReference(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createCDict_byReference(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_CDict * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_createCDict_byReference", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createCDict_byReference(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(311));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_createCDict_byReference _cffi_d_ZSTD_createCDict_byReference
#endif

static ZSTD_CCtx * _cffi_d_ZSTD_createCStream(void)
{
  return ZSTD_createCStream();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createCStream(PyObject *self, PyObject *noarg)
{
  ZSTD_CCtx * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createCStream(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(107));
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_createCStream _cffi_d_ZSTD_createCStream
#endif

static ZSTD_CCtx * _cffi_d_ZSTD_createCStream_advanced(ZSTD_customMem x0)
{
  return ZSTD_createCStream_advanced(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createCStream_advanced(PyObject *self, PyObject *arg0)
{
  ZSTD_customMem x0;
  ZSTD_CCtx * result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createCStream_advanced(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(107));
  return pyresult;
}
#else
static ZSTD_CCtx * _cffi_f_ZSTD_createCStream_advanced(ZSTD_customMem *x0)
{
  ZSTD_CCtx * result;
  { result = ZSTD_createCStream_advanced(*x0); }
  return result;
}
#endif

static ZSTD_DCtx * _cffi_d_ZSTD_createDCtx(void)
{
  return ZSTD_createDCtx();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createDCtx(PyObject *self, PyObject *noarg)
{
  ZSTD_DCtx * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createDCtx(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(89));
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_createDCtx _cffi_d_ZSTD_createDCtx
#endif

static ZSTD_DCtx * _cffi_d_ZSTD_createDCtx_advanced(ZSTD_customMem x0)
{
  return ZSTD_createDCtx_advanced(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createDCtx_advanced(PyObject *self, PyObject *arg0)
{
  ZSTD_customMem x0;
  ZSTD_DCtx * result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createDCtx_advanced(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(89));
  return pyresult;
}
#else
static ZSTD_DCtx * _cffi_f_ZSTD_createDCtx_advanced(ZSTD_customMem *x0)
{
  ZSTD_DCtx * result;
  { result = ZSTD_createDCtx_advanced(*x0); }
  return result;
}
#endif

static ZSTD_DDict * _cffi_d_ZSTD_createDDict(void const * x0, size_t x1)
{
  return ZSTD_createDDict(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createDDict(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_DDict * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_createDDict", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createDDict(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(405));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_createDDict _cffi_d_ZSTD_createDDict
#endif

static ZSTD_DDict * _cffi_d_ZSTD_createDDict_advanced(void const * x0, size_t x1, ZSTD_dictLoadMethod_e x2, ZSTD_dictContentType_e x3, ZSTD_customMem x4)
{
  return ZSTD_createDDict_advanced(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createDDict_advanced(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  ZSTD_dictLoadMethod_e x2;
  ZSTD_dictContentType_e x3;
  ZSTD_customMem x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_DDict * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_createDDict_advanced", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(14), arg2) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(15), arg3) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(1), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createDDict_advanced(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(405));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static ZSTD_DDict * _cffi_f_ZSTD_createDDict_advanced(void const * x0, size_t x1, ZSTD_dictLoadMethod_e x2, ZSTD_dictContentType_e x3, ZSTD_customMem *x4)
{
  ZSTD_DDict * result;
  { result = ZSTD_createDDict_advanced(x0, x1, x2, x3, *x4); }
  return result;
}
#endif

static ZSTD_DDict * _cffi_d_ZSTD_createDDict_byReference(void const * x0, size_t x1)
{
  return ZSTD_createDDict_byReference(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createDDict_byReference(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_DDict * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_createDDict_byReference", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createDDict_byReference(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(405));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_createDDict_byReference _cffi_d_ZSTD_createDDict_byReference
#endif

static ZSTD_DCtx * _cffi_d_ZSTD_createDStream(void)
{
  return ZSTD_createDStream();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createDStream(PyObject *self, PyObject *noarg)
{
  ZSTD_DCtx * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createDStream(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(89));
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_createDStream _cffi_d_ZSTD_createDStream
#endif

static ZSTD_DCtx * _cffi_d_ZSTD_createDStream_advanced(ZSTD_customMem x0)
{
  return ZSTD_createDStream_advanced(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createDStream_advanced(PyObject *self, PyObject *arg0)
{
  ZSTD_customMem x0;
  ZSTD_DCtx * result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(1), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createDStream_advanced(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(89));
  return pyresult;
}
#else
static ZSTD_DCtx * _cffi_f_ZSTD_createDStream_advanced(ZSTD_customMem *x0)
{
  ZSTD_DCtx * result;
  { result = ZSTD_createDStream_advanced(*x0); }
  return result;
}
#endif

static ZSTD_threadPool * _cffi_d_ZSTD_createThreadPool(size_t x0)
{
  return ZSTD_createThreadPool(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_createThreadPool(PyObject *self, PyObject *arg0)
{
  size_t x0;
  ZSTD_threadPool * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_createThreadPool(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(161));
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_createThreadPool _cffi_d_ZSTD_createThreadPool
#endif

static ZSTD_bounds _cffi_d_ZSTD_dParam_getBounds(ZSTD_dParameter x0)
{
  return ZSTD_dParam_getBounds(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_dParam_getBounds(PyObject *self, PyObject *arg0)
{
  ZSTD_dParameter x0;
  ZSTD_bounds result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(73), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_dParam_getBounds(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(582));
  return pyresult;
}
#else
static void _cffi_f_ZSTD_dParam_getBounds(ZSTD_bounds *result, ZSTD_dParameter x0)
{
  { *result = ZSTD_dParam_getBounds(x0); }
}
#endif

static size_t _cffi_d_ZSTD_decodingBufferSize_min(unsigned long long x0, unsigned long long x1)
{
  return ZSTD_decodingBufferSize_min(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decodingBufferSize_min(PyObject *self, PyObject *args)
{
  unsigned long long x0;
  unsigned long long x1;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_decodingBufferSize_min", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, unsigned long long);
  if (x0 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, unsigned long long);
  if (x1 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decodingBufferSize_min(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decodingBufferSize_min _cffi_d_ZSTD_decodingBufferSize_min
#endif

static size_t _cffi_d_ZSTD_decompress(void * x0, size_t x1, void const * x2, size_t x3)
{
  return ZSTD_decompress(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompress(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompress", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompress(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompress _cffi_d_ZSTD_decompress
#endif

static size_t _cffi_d_ZSTD_decompressBegin(ZSTD_DCtx * x0)
{
  return ZSTD_decompressBegin(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompressBegin(PyObject *self, PyObject *arg0)
{
  ZSTD_DCtx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompressBegin(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompressBegin _cffi_d_ZSTD_decompressBegin
#endif

static size_t _cffi_d_ZSTD_decompressBegin_usingDDict(ZSTD_DCtx * x0, ZSTD_DDict const * x1)
{
  return ZSTD_decompressBegin_usingDDict(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompressBegin_usingDDict(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  ZSTD_DDict const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompressBegin_usingDDict", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(321), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_DDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(321), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompressBegin_usingDDict(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompressBegin_usingDDict _cffi_d_ZSTD_decompressBegin_usingDDict
#endif

static size_t _cffi_d_ZSTD_decompressBegin_usingDict(ZSTD_DCtx * x0, void const * x1, size_t x2)
{
  return ZSTD_decompressBegin_usingDict(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompressBegin_usingDict(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompressBegin_usingDict", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompressBegin_usingDict(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompressBegin_usingDict _cffi_d_ZSTD_decompressBegin_usingDict
#endif

static size_t _cffi_d_ZSTD_decompressBlock(ZSTD_DCtx * x0, void * x1, size_t x2, void const * x3, size_t x4)
{
  return ZSTD_decompressBlock(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompressBlock(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompressBlock", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompressBlock(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompressBlock _cffi_d_ZSTD_decompressBlock
#endif

static unsigned long long _cffi_d_ZSTD_decompressBound(void const * x0, size_t x1)
{
  return ZSTD_decompressBound(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompressBound(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned long long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompressBound", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompressBound(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned long long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompressBound _cffi_d_ZSTD_decompressBound
#endif

static size_t _cffi_d_ZSTD_decompressContinue(ZSTD_DCtx * x0, void * x1, size_t x2, void const * x3, size_t x4)
{
  return ZSTD_decompressContinue(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompressContinue(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompressContinue", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompressContinue(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompressContinue _cffi_d_ZSTD_decompressContinue
#endif

static size_t _cffi_d_ZSTD_decompressDCtx(ZSTD_DCtx * x0, void * x1, size_t x2, void const * x3, size_t x4)
{
  return ZSTD_decompressDCtx(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompressDCtx(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompressDCtx", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompressDCtx(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompressDCtx _cffi_d_ZSTD_decompressDCtx
#endif

static size_t _cffi_d_ZSTD_decompressStream(ZSTD_DCtx * x0, ZSTD_outBuffer * x1, ZSTD_inBuffer * x2)
{
  return ZSTD_decompressStream(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompressStream(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  ZSTD_outBuffer * x1;
  ZSTD_inBuffer * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompressStream", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(146), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_outBuffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(146), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(151), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (ZSTD_inBuffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(151), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompressStream(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompressStream _cffi_d_ZSTD_decompressStream
#endif

static size_t _cffi_d_ZSTD_decompressStream_simpleArgs(ZSTD_DCtx * x0, void * x1, size_t x2, size_t * x3, void const * x4, size_t x5, size_t * x6)
{
  return ZSTD_decompressStream_simpleArgs(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompressStream_simpleArgs(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void * x1;
  size_t x2;
  size_t * x3;
  void const * x4;
  size_t x5;
  size_t * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompressStream_simpleArgs", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(189), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(189), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, size_t);
  if (x5 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(189), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(189), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompressStream_simpleArgs(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompressStream_simpleArgs _cffi_d_ZSTD_decompressStream_simpleArgs
#endif

static size_t _cffi_d_ZSTD_decompress_usingDDict(ZSTD_DCtx * x0, void * x1, size_t x2, void const * x3, size_t x4, ZSTD_DDict const * x5)
{
  return ZSTD_decompress_usingDDict(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompress_usingDDict(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  ZSTD_DDict const * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompress_usingDDict", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(321), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (ZSTD_DDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(321), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompress_usingDDict(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompress_usingDDict _cffi_d_ZSTD_decompress_usingDDict
#endif

static size_t _cffi_d_ZSTD_decompress_usingDict(ZSTD_DCtx * x0, void * x1, size_t x2, void const * x3, size_t x4, void const * x5, size_t x6)
{
  return ZSTD_decompress_usingDict(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_decompress_usingDict(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  void const * x5;
  size_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "ZSTD_decompress_usingDict", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_decompress_usingDict(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_decompress_usingDict _cffi_d_ZSTD_decompress_usingDict
#endif

static int _cffi_d_ZSTD_defaultCLevel(void)
{
  return ZSTD_defaultCLevel();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_defaultCLevel(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_defaultCLevel(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_defaultCLevel _cffi_d_ZSTD_defaultCLevel
#endif

static size_t _cffi_d_ZSTD_endStream(ZSTD_CCtx * x0, ZSTD_outBuffer * x1)
{
  return ZSTD_endStream(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_endStream(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_outBuffer * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_endStream", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(146), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_outBuffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(146), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_endStream(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_endStream _cffi_d_ZSTD_endStream
#endif

static size_t _cffi_d_ZSTD_estimateCCtxSize(int x0)
{
  return ZSTD_estimateCCtxSize(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateCCtxSize(PyObject *self, PyObject *arg0)
{
  int x0;
  size_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateCCtxSize(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_estimateCCtxSize _cffi_d_ZSTD_estimateCCtxSize
#endif

static size_t _cffi_d_ZSTD_estimateCCtxSize_usingCCtxParams(ZSTD_CCtx_params const * x0)
{
  return ZSTD_estimateCCtxSize_usingCCtxParams(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateCCtxSize_usingCCtxParams(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx_params const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateCCtxSize_usingCCtxParams(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_estimateCCtxSize_usingCCtxParams _cffi_d_ZSTD_estimateCCtxSize_usingCCtxParams
#endif

static size_t _cffi_d_ZSTD_estimateCCtxSize_usingCParams(ZSTD_compressionParameters x0)
{
  return ZSTD_estimateCCtxSize_usingCParams(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateCCtxSize_usingCParams(PyObject *self, PyObject *arg0)
{
  ZSTD_compressionParameters x0;
  size_t result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(24), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateCCtxSize_usingCParams(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_estimateCCtxSize_usingCParams(ZSTD_compressionParameters *x0)
{
  size_t result;
  { result = ZSTD_estimateCCtxSize_usingCParams(*x0); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_estimateCDictSize(size_t x0, int x1)
{
  return ZSTD_estimateCDictSize(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateCDictSize(PyObject *self, PyObject *args)
{
  size_t x0;
  int x1;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_estimateCDictSize", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateCDictSize(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_estimateCDictSize _cffi_d_ZSTD_estimateCDictSize
#endif

static size_t _cffi_d_ZSTD_estimateCDictSize_advanced(size_t x0, ZSTD_compressionParameters x1, ZSTD_dictLoadMethod_e x2)
{
  return ZSTD_estimateCDictSize_advanced(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateCDictSize_advanced(PyObject *self, PyObject *args)
{
  size_t x0;
  ZSTD_compressionParameters x1;
  ZSTD_dictLoadMethod_e x2;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_estimateCDictSize_advanced", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(24), arg1) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(14), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateCDictSize_advanced(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_estimateCDictSize_advanced(size_t x0, ZSTD_compressionParameters *x1, ZSTD_dictLoadMethod_e x2)
{
  size_t result;
  { result = ZSTD_estimateCDictSize_advanced(x0, *x1, x2); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_estimateCStreamSize(int x0)
{
  return ZSTD_estimateCStreamSize(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateCStreamSize(PyObject *self, PyObject *arg0)
{
  int x0;
  size_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateCStreamSize(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_estimateCStreamSize _cffi_d_ZSTD_estimateCStreamSize
#endif

static size_t _cffi_d_ZSTD_estimateCStreamSize_usingCCtxParams(ZSTD_CCtx_params const * x0)
{
  return ZSTD_estimateCStreamSize_usingCCtxParams(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateCStreamSize_usingCCtxParams(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx_params const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateCStreamSize_usingCCtxParams(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_estimateCStreamSize_usingCCtxParams _cffi_d_ZSTD_estimateCStreamSize_usingCCtxParams
#endif

static size_t _cffi_d_ZSTD_estimateCStreamSize_usingCParams(ZSTD_compressionParameters x0)
{
  return ZSTD_estimateCStreamSize_usingCParams(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateCStreamSize_usingCParams(PyObject *self, PyObject *arg0)
{
  ZSTD_compressionParameters x0;
  size_t result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(24), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateCStreamSize_usingCParams(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_estimateCStreamSize_usingCParams(ZSTD_compressionParameters *x0)
{
  size_t result;
  { result = ZSTD_estimateCStreamSize_usingCParams(*x0); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_estimateDCtxSize(void)
{
  return ZSTD_estimateDCtxSize();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateDCtxSize(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateDCtxSize(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_estimateDCtxSize _cffi_d_ZSTD_estimateDCtxSize
#endif

static size_t _cffi_d_ZSTD_estimateDDictSize(size_t x0, ZSTD_dictLoadMethod_e x1)
{
  return ZSTD_estimateDDictSize(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateDDictSize(PyObject *self, PyObject *args)
{
  size_t x0;
  ZSTD_dictLoadMethod_e x1;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_estimateDDictSize", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x1, _cffi_type(14), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateDDictSize(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_estimateDDictSize _cffi_d_ZSTD_estimateDDictSize
#endif

static size_t _cffi_d_ZSTD_estimateDStreamSize(size_t x0)
{
  return ZSTD_estimateDStreamSize(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateDStreamSize(PyObject *self, PyObject *arg0)
{
  size_t x0;
  size_t result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateDStreamSize(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_estimateDStreamSize _cffi_d_ZSTD_estimateDStreamSize
#endif

static size_t _cffi_d_ZSTD_estimateDStreamSize_fromFrame(void const * x0, size_t x1)
{
  return ZSTD_estimateDStreamSize_fromFrame(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_estimateDStreamSize_fromFrame(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_estimateDStreamSize_fromFrame", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_estimateDStreamSize_fromFrame(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_estimateDStreamSize_fromFrame _cffi_d_ZSTD_estimateDStreamSize_fromFrame
#endif

static unsigned long long _cffi_d_ZSTD_findDecompressedSize(void const * x0, size_t x1)
{
  return ZSTD_findDecompressedSize(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_findDecompressedSize(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned long long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_findDecompressedSize", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_findDecompressedSize(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned long long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_findDecompressedSize _cffi_d_ZSTD_findDecompressedSize
#endif

static size_t _cffi_d_ZSTD_findFrameCompressedSize(void const * x0, size_t x1)
{
  return ZSTD_findFrameCompressedSize(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_findFrameCompressedSize(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_findFrameCompressedSize", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_findFrameCompressedSize(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_findFrameCompressedSize _cffi_d_ZSTD_findFrameCompressedSize
#endif

static size_t _cffi_d_ZSTD_flushStream(ZSTD_CCtx * x0, ZSTD_outBuffer * x1)
{
  return ZSTD_flushStream(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_flushStream(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_outBuffer * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_flushStream", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(146), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_outBuffer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(146), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_flushStream(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_flushStream _cffi_d_ZSTD_flushStream
#endif

static size_t _cffi_d_ZSTD_frameHeaderSize(void const * x0, size_t x1)
{
  return ZSTD_frameHeaderSize(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_frameHeaderSize(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_frameHeaderSize", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_frameHeaderSize(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_frameHeaderSize _cffi_d_ZSTD_frameHeaderSize
#endif

static size_t _cffi_d_ZSTD_freeCCtx(ZSTD_CCtx * x0)
{
  return ZSTD_freeCCtx(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_freeCCtx(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_freeCCtx(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_freeCCtx _cffi_d_ZSTD_freeCCtx
#endif

static size_t _cffi_d_ZSTD_freeCCtxParams(ZSTD_CCtx_params * x0)
{
  return ZSTD_freeCCtxParams(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_freeCCtxParams(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx_params * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(287), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx_params *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(287), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_freeCCtxParams(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_freeCCtxParams _cffi_d_ZSTD_freeCCtxParams
#endif

static size_t _cffi_d_ZSTD_freeCDict(ZSTD_CDict * x0)
{
  return ZSTD_freeCDict(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_freeCDict(PyObject *self, PyObject *arg0)
{
  ZSTD_CDict * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(311), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CDict *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(311), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_freeCDict(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_freeCDict _cffi_d_ZSTD_freeCDict
#endif

static size_t _cffi_d_ZSTD_freeCStream(ZSTD_CCtx * x0)
{
  return ZSTD_freeCStream(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_freeCStream(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_freeCStream(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_freeCStream _cffi_d_ZSTD_freeCStream
#endif

static size_t _cffi_d_ZSTD_freeDCtx(ZSTD_DCtx * x0)
{
  return ZSTD_freeDCtx(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_freeDCtx(PyObject *self, PyObject *arg0)
{
  ZSTD_DCtx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_freeDCtx(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_freeDCtx _cffi_d_ZSTD_freeDCtx
#endif

static size_t _cffi_d_ZSTD_freeDDict(ZSTD_DDict * x0)
{
  return ZSTD_freeDDict(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_freeDDict(PyObject *self, PyObject *arg0)
{
  ZSTD_DDict * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(405), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DDict *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(405), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_freeDDict(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_freeDDict _cffi_d_ZSTD_freeDDict
#endif

static size_t _cffi_d_ZSTD_freeDStream(ZSTD_DCtx * x0)
{
  return ZSTD_freeDStream(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_freeDStream(PyObject *self, PyObject *arg0)
{
  ZSTD_DCtx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_freeDStream(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_freeDStream _cffi_d_ZSTD_freeDStream
#endif

static void _cffi_d_ZSTD_freeThreadPool(ZSTD_threadPool * x0)
{
  ZSTD_freeThreadPool(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_freeThreadPool(PyObject *self, PyObject *arg0)
{
  ZSTD_threadPool * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(161), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_threadPool *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(161), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ZSTD_freeThreadPool(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ZSTD_freeThreadPool _cffi_d_ZSTD_freeThreadPool
#endif

static size_t _cffi_d_ZSTD_generateSequences(ZSTD_CCtx * x0, ZSTD_Sequence * x1, size_t x2, void const * x3, size_t x4)
{
  return ZSTD_generateSequences(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_generateSequences(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_Sequence * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_generateSequences", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(134), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_Sequence *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(134), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_generateSequences(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_generateSequences _cffi_d_ZSTD_generateSequences
#endif

static size_t _cffi_d_ZSTD_getBlockSize(ZSTD_CCtx const * x0)
{
  return ZSTD_getBlockSize(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getBlockSize(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(86), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getBlockSize(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_getBlockSize _cffi_d_ZSTD_getBlockSize
#endif

static ZSTD_compressionParameters _cffi_d_ZSTD_getCParams(int x0, unsigned long long x1, size_t x2)
{
  return ZSTD_getCParams(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getCParams(PyObject *self, PyObject *args)
{
  int x0;
  unsigned long long x1;
  size_t x2;
  ZSTD_compressionParameters result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_getCParams", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, unsigned long long);
  if (x1 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getCParams(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(24));
  return pyresult;
}
#else
static void _cffi_f_ZSTD_getCParams(ZSTD_compressionParameters *result, int x0, unsigned long long x1, size_t x2)
{
  { *result = ZSTD_getCParams(x0, x1, x2); }
}
#endif

static unsigned long long _cffi_d_ZSTD_getDecompressedSize(void const * x0, size_t x1)
{
  return ZSTD_getDecompressedSize(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getDecompressedSize(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned long long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_getDecompressedSize", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getDecompressedSize(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned long long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_getDecompressedSize _cffi_d_ZSTD_getDecompressedSize
#endif

static unsigned int _cffi_d_ZSTD_getDictID_fromCDict(ZSTD_CDict const * x0)
{
  return ZSTD_getDictID_fromCDict(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getDictID_fromCDict(PyObject *self, PyObject *arg0)
{
  ZSTD_CDict const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getDictID_fromCDict(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_getDictID_fromCDict _cffi_d_ZSTD_getDictID_fromCDict
#endif

static unsigned int _cffi_d_ZSTD_getDictID_fromDDict(ZSTD_DDict const * x0)
{
  return ZSTD_getDictID_fromDDict(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getDictID_fromDDict(PyObject *self, PyObject *arg0)
{
  ZSTD_DDict const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(321), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(321), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getDictID_fromDDict(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_getDictID_fromDDict _cffi_d_ZSTD_getDictID_fromDDict
#endif

static unsigned int _cffi_d_ZSTD_getDictID_fromDict(void const * x0, size_t x1)
{
  return ZSTD_getDictID_fromDict(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getDictID_fromDict(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_getDictID_fromDict", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getDictID_fromDict(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_getDictID_fromDict _cffi_d_ZSTD_getDictID_fromDict
#endif

static unsigned int _cffi_d_ZSTD_getDictID_fromFrame(void const * x0, size_t x1)
{
  return ZSTD_getDictID_fromFrame(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getDictID_fromFrame(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_getDictID_fromFrame", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getDictID_fromFrame(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_getDictID_fromFrame _cffi_d_ZSTD_getDictID_fromFrame
#endif

static char const * _cffi_d_ZSTD_getErrorName(size_t x0)
{
  return ZSTD_getErrorName(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getErrorName(PyObject *self, PyObject *arg0)
{
  size_t x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getErrorName(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(597));
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_getErrorName _cffi_d_ZSTD_getErrorName
#endif

static unsigned long long _cffi_d_ZSTD_getFrameContentSize(void const * x0, size_t x1)
{
  return ZSTD_getFrameContentSize(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getFrameContentSize(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned long long result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_getFrameContentSize", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getFrameContentSize(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned long long);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_getFrameContentSize _cffi_d_ZSTD_getFrameContentSize
#endif

static size_t _cffi_d_ZSTD_getFrameHeader(ZSTD_frameHeader * x0, void const * x1, size_t x2)
{
  return ZSTD_getFrameHeader(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getFrameHeader(PyObject *self, PyObject *args)
{
  ZSTD_frameHeader * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_getFrameHeader", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(418), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_frameHeader *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(418), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getFrameHeader(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_getFrameHeader _cffi_d_ZSTD_getFrameHeader
#endif

static size_t _cffi_d_ZSTD_getFrameHeader_advanced(ZSTD_frameHeader * x0, void const * x1, size_t x2, ZSTD_format_e x3)
{
  return ZSTD_getFrameHeader_advanced(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getFrameHeader_advanced(PyObject *self, PyObject *args)
{
  ZSTD_frameHeader * x0;
  void const * x1;
  size_t x2;
  ZSTD_format_e x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ZSTD_getFrameHeader_advanced", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(418), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_frameHeader *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(418), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(339), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getFrameHeader_advanced(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_getFrameHeader_advanced _cffi_d_ZSTD_getFrameHeader_advanced
#endif

static ZSTD_frameProgression _cffi_d_ZSTD_getFrameProgression(ZSTD_CCtx const * x0)
{
  return ZSTD_getFrameProgression(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getFrameProgression(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_frameProgression result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(86), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getFrameProgression(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(586));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static void _cffi_f_ZSTD_getFrameProgression(ZSTD_frameProgression *result, ZSTD_CCtx const * x0)
{
  { *result = ZSTD_getFrameProgression(x0); }
}
#endif

static ZSTD_parameters _cffi_d_ZSTD_getParams(int x0, unsigned long long x1, size_t x2)
{
  return ZSTD_getParams(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_getParams(PyObject *self, PyObject *args)
{
  int x0;
  unsigned long long x1;
  size_t x2;
  ZSTD_parameters result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_getParams", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, unsigned long long);
  if (x1 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_getParams(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(235));
  return pyresult;
}
#else
static void _cffi_f_ZSTD_getParams(ZSTD_parameters *result, int x0, unsigned long long x1, size_t x2)
{
  { *result = ZSTD_getParams(x0, x1, x2); }
}
#endif

static size_t _cffi_d_ZSTD_initCStream(ZSTD_CCtx * x0, int x1)
{
  return ZSTD_initCStream(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initCStream(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_initCStream", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initCStream(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initCStream _cffi_d_ZSTD_initCStream
#endif

static size_t _cffi_d_ZSTD_initCStream_advanced(ZSTD_CCtx * x0, void const * x1, size_t x2, ZSTD_parameters x3, unsigned long long x4)
{
  return ZSTD_initCStream_advanced(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initCStream_advanced(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void const * x1;
  size_t x2;
  ZSTD_parameters x3;
  unsigned long long x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_initCStream_advanced", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(235), arg3) < 0)
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned long long);
  if (x4 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initCStream_advanced(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_initCStream_advanced(ZSTD_CCtx * x0, void const * x1, size_t x2, ZSTD_parameters *x3, unsigned long long x4)
{
  size_t result;
  { result = ZSTD_initCStream_advanced(x0, x1, x2, *x3, x4); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_initCStream_srcSize(ZSTD_CCtx * x0, int x1, unsigned long long x2)
{
  return ZSTD_initCStream_srcSize(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initCStream_srcSize(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  int x1;
  unsigned long long x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_initCStream_srcSize", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initCStream_srcSize(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initCStream_srcSize _cffi_d_ZSTD_initCStream_srcSize
#endif

static size_t _cffi_d_ZSTD_initCStream_usingCDict(ZSTD_CCtx * x0, ZSTD_CDict const * x1)
{
  return ZSTD_initCStream_usingCDict(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initCStream_usingCDict(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_CDict const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_initCStream_usingCDict", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_CDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initCStream_usingCDict(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initCStream_usingCDict _cffi_d_ZSTD_initCStream_usingCDict
#endif

static size_t _cffi_d_ZSTD_initCStream_usingCDict_advanced(ZSTD_CCtx * x0, ZSTD_CDict const * x1, ZSTD_frameParameters x2, unsigned long long x3)
{
  return ZSTD_initCStream_usingCDict_advanced(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initCStream_usingCDict_advanced(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  ZSTD_CDict const * x1;
  ZSTD_frameParameters x2;
  unsigned long long x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ZSTD_initCStream_usingCDict_advanced", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_CDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(125), arg2) < 0)
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned long long);
  if (x3 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initCStream_usingCDict_advanced(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static size_t _cffi_f_ZSTD_initCStream_usingCDict_advanced(ZSTD_CCtx * x0, ZSTD_CDict const * x1, ZSTD_frameParameters *x2, unsigned long long x3)
{
  size_t result;
  { result = ZSTD_initCStream_usingCDict_advanced(x0, x1, *x2, x3); }
  return result;
}
#endif

static size_t _cffi_d_ZSTD_initCStream_usingDict(ZSTD_CCtx * x0, void const * x1, size_t x2, int x3)
{
  return ZSTD_initCStream_usingDict(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initCStream_usingDict(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  void const * x1;
  size_t x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ZSTD_initCStream_usingDict", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initCStream_usingDict(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initCStream_usingDict _cffi_d_ZSTD_initCStream_usingDict
#endif

static size_t _cffi_d_ZSTD_initDStream(ZSTD_DCtx * x0)
{
  return ZSTD_initDStream(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initDStream(PyObject *self, PyObject *arg0)
{
  ZSTD_DCtx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initDStream(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initDStream _cffi_d_ZSTD_initDStream
#endif

static size_t _cffi_d_ZSTD_initDStream_usingDDict(ZSTD_DCtx * x0, ZSTD_DDict const * x1)
{
  return ZSTD_initDStream_usingDDict(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initDStream_usingDDict(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  ZSTD_DDict const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_initDStream_usingDDict", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(321), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ZSTD_DDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(321), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initDStream_usingDDict(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initDStream_usingDDict _cffi_d_ZSTD_initDStream_usingDDict
#endif

static size_t _cffi_d_ZSTD_initDStream_usingDict(ZSTD_DCtx * x0, void const * x1, size_t x2)
{
  return ZSTD_initDStream_usingDict(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initDStream_usingDict(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_initDStream_usingDict", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initDStream_usingDict(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initDStream_usingDict _cffi_d_ZSTD_initDStream_usingDict
#endif

static ZSTD_CCtx * _cffi_d_ZSTD_initStaticCCtx(void * x0, size_t x1)
{
  return ZSTD_initStaticCCtx(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initStaticCCtx(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_CCtx * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_initStaticCCtx", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initStaticCCtx(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(107));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initStaticCCtx _cffi_d_ZSTD_initStaticCCtx
#endif

static ZSTD_CDict const * _cffi_d_ZSTD_initStaticCDict(void * x0, size_t x1, void const * x2, size_t x3, ZSTD_dictLoadMethod_e x4, ZSTD_dictContentType_e x5, ZSTD_compressionParameters x6)
{
  return ZSTD_initStaticCDict(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initStaticCDict(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t x3;
  ZSTD_dictLoadMethod_e x4;
  ZSTD_dictContentType_e x5;
  ZSTD_compressionParameters x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_CDict const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "ZSTD_initStaticCDict", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(14), arg4) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(15), arg5) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x6, _cffi_type(24), arg6) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initStaticCDict(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(120));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static ZSTD_CDict const * _cffi_f_ZSTD_initStaticCDict(void * x0, size_t x1, void const * x2, size_t x3, ZSTD_dictLoadMethod_e x4, ZSTD_dictContentType_e x5, ZSTD_compressionParameters *x6)
{
  ZSTD_CDict const * result;
  { result = ZSTD_initStaticCDict(x0, x1, x2, x3, x4, x5, *x6); }
  return result;
}
#endif

static ZSTD_CCtx * _cffi_d_ZSTD_initStaticCStream(void * x0, size_t x1)
{
  return ZSTD_initStaticCStream(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initStaticCStream(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_CCtx * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_initStaticCStream", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initStaticCStream(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(107));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initStaticCStream _cffi_d_ZSTD_initStaticCStream
#endif

static ZSTD_DCtx * _cffi_d_ZSTD_initStaticDCtx(void * x0, size_t x1)
{
  return ZSTD_initStaticDCtx(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initStaticDCtx(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_DCtx * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_initStaticDCtx", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initStaticDCtx(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(89));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initStaticDCtx _cffi_d_ZSTD_initStaticDCtx
#endif

static ZSTD_DDict const * _cffi_d_ZSTD_initStaticDDict(void * x0, size_t x1, void const * x2, size_t x3, ZSTD_dictLoadMethod_e x4, ZSTD_dictContentType_e x5)
{
  return ZSTD_initStaticDDict(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initStaticDDict(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t x3;
  ZSTD_dictLoadMethod_e x4;
  ZSTD_dictContentType_e x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_DDict const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ZSTD_initStaticDDict", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(14), arg4) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x5, _cffi_type(15), arg5) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initStaticDDict(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(321));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initStaticDDict _cffi_d_ZSTD_initStaticDDict
#endif

static ZSTD_DCtx * _cffi_d_ZSTD_initStaticDStream(void * x0, size_t x1)
{
  return ZSTD_initStaticDStream(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_initStaticDStream(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_DCtx * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_initStaticDStream", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_initStaticDStream(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(89));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_initStaticDStream _cffi_d_ZSTD_initStaticDStream
#endif

static size_t _cffi_d_ZSTD_insertBlock(ZSTD_DCtx * x0, void const * x1, size_t x2)
{
  return ZSTD_insertBlock(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_insertBlock(PyObject *self, PyObject *args)
{
  ZSTD_DCtx * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ZSTD_insertBlock", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_insertBlock(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_insertBlock _cffi_d_ZSTD_insertBlock
#endif

static unsigned int _cffi_d_ZSTD_isError(size_t x0)
{
  return ZSTD_isError(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_isError(PyObject *self, PyObject *arg0)
{
  size_t x0;
  unsigned int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, size_t);
  if (x0 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_isError(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_isError _cffi_d_ZSTD_isError
#endif

static unsigned int _cffi_d_ZSTD_isFrame(void const * x0, size_t x1)
{
  return ZSTD_isFrame(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_isFrame(PyObject *self, PyObject *args)
{
  void const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_isFrame", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_isFrame(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_isFrame _cffi_d_ZSTD_isFrame
#endif

static int _cffi_d_ZSTD_maxCLevel(void)
{
  return ZSTD_maxCLevel();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_maxCLevel(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_maxCLevel(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_maxCLevel _cffi_d_ZSTD_maxCLevel
#endif

static size_t _cffi_d_ZSTD_mergeBlockDelimiters(ZSTD_Sequence * x0, size_t x1)
{
  return ZSTD_mergeBlockDelimiters(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_mergeBlockDelimiters(PyObject *self, PyObject *args)
{
  ZSTD_Sequence * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_mergeBlockDelimiters", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(134), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_Sequence *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(134), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_mergeBlockDelimiters(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_mergeBlockDelimiters _cffi_d_ZSTD_mergeBlockDelimiters
#endif

static int _cffi_d_ZSTD_minCLevel(void)
{
  return ZSTD_minCLevel();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_minCLevel(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_minCLevel(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_minCLevel _cffi_d_ZSTD_minCLevel
#endif

static ZSTD_nextInputType_e _cffi_d_ZSTD_nextInputType(ZSTD_DCtx * x0)
{
  return ZSTD_nextInputType(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_nextInputType(PyObject *self, PyObject *arg0)
{
  ZSTD_DCtx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ZSTD_nextInputType_e result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_nextInputType(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(590));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_nextInputType _cffi_d_ZSTD_nextInputType
#endif

static size_t _cffi_d_ZSTD_nextSrcSizeToDecompress(ZSTD_DCtx * x0)
{
  return ZSTD_nextSrcSizeToDecompress(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_nextSrcSizeToDecompress(PyObject *self, PyObject *arg0)
{
  ZSTD_DCtx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_nextSrcSizeToDecompress(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_nextSrcSizeToDecompress _cffi_d_ZSTD_nextSrcSizeToDecompress
#endif

static size_t _cffi_d_ZSTD_resetCStream(ZSTD_CCtx * x0, unsigned long long x1)
{
  return ZSTD_resetCStream(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_resetCStream(PyObject *self, PyObject *args)
{
  ZSTD_CCtx * x0;
  unsigned long long x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ZSTD_resetCStream", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned long long);
  if (x1 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_resetCStream(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_resetCStream _cffi_d_ZSTD_resetCStream
#endif

static size_t _cffi_d_ZSTD_resetDStream(ZSTD_DCtx * x0)
{
  return ZSTD_resetDStream(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_resetDStream(PyObject *self, PyObject *arg0)
{
  ZSTD_DCtx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(89), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(89), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_resetDStream(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_resetDStream _cffi_d_ZSTD_resetDStream
#endif

static size_t _cffi_d_ZSTD_sizeof_CCtx(ZSTD_CCtx const * x0)
{
  return ZSTD_sizeof_CCtx(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_sizeof_CCtx(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(86), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_sizeof_CCtx(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_sizeof_CCtx _cffi_d_ZSTD_sizeof_CCtx
#endif

static size_t _cffi_d_ZSTD_sizeof_CDict(ZSTD_CDict const * x0)
{
  return ZSTD_sizeof_CDict(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_sizeof_CDict(PyObject *self, PyObject *arg0)
{
  ZSTD_CDict const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(120), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(120), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_sizeof_CDict(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_sizeof_CDict _cffi_d_ZSTD_sizeof_CDict
#endif

static size_t _cffi_d_ZSTD_sizeof_CStream(ZSTD_CCtx const * x0)
{
  return ZSTD_sizeof_CStream(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_sizeof_CStream(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(86), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_sizeof_CStream(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_sizeof_CStream _cffi_d_ZSTD_sizeof_CStream
#endif

static size_t _cffi_d_ZSTD_sizeof_DCtx(ZSTD_DCtx const * x0)
{
  return ZSTD_sizeof_DCtx(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_sizeof_DCtx(PyObject *self, PyObject *arg0)
{
  ZSTD_DCtx const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(402), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(402), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_sizeof_DCtx(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_sizeof_DCtx _cffi_d_ZSTD_sizeof_DCtx
#endif

static size_t _cffi_d_ZSTD_sizeof_DDict(ZSTD_DDict const * x0)
{
  return ZSTD_sizeof_DDict(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_sizeof_DDict(PyObject *self, PyObject *arg0)
{
  ZSTD_DDict const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(321), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DDict const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(321), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_sizeof_DDict(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_sizeof_DDict _cffi_d_ZSTD_sizeof_DDict
#endif

static size_t _cffi_d_ZSTD_sizeof_DStream(ZSTD_DCtx const * x0)
{
  return ZSTD_sizeof_DStream(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_sizeof_DStream(PyObject *self, PyObject *arg0)
{
  ZSTD_DCtx const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(402), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_DCtx const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(402), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_sizeof_DStream(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_sizeof_DStream _cffi_d_ZSTD_sizeof_DStream
#endif

static size_t _cffi_d_ZSTD_toFlushNow(ZSTD_CCtx * x0)
{
  return ZSTD_toFlushNow(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_toFlushNow(PyObject *self, PyObject *arg0)
{
  ZSTD_CCtx * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(107), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ZSTD_CCtx *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(107), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_toFlushNow(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_toFlushNow _cffi_d_ZSTD_toFlushNow
#endif

static unsigned int _cffi_d_ZSTD_versionNumber(void)
{
  return ZSTD_versionNumber();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_versionNumber(PyObject *self, PyObject *noarg)
{
  unsigned int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_versionNumber(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_versionNumber _cffi_d_ZSTD_versionNumber
#endif

static char const * _cffi_d_ZSTD_versionString(void)
{
  return ZSTD_versionString();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_versionString(PyObject *self, PyObject *noarg)
{
  char const * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_versionString(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(597));
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_versionString _cffi_d_ZSTD_versionString
#endif

static size_t _cffi_d_ZSTD_writeSkippableFrame(void * x0, size_t x1, void const * x2, size_t x3, unsigned int x4)
{
  return ZSTD_writeSkippableFrame(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ZSTD_writeSkippableFrame(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  void const * x2;
  size_t x3;
  unsigned int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ZSTD_writeSkippableFrame", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(12), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(12), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, unsigned int);
  if (x4 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ZSTD_writeSkippableFrame(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ZSTD_writeSkippableFrame _cffi_d_ZSTD_writeSkippableFrame
#endif

static int _cffi_const_ZDICT_CONTENTSIZE_MIN(unsigned long long *o)
{
  int n = (ZDICT_CONTENTSIZE_MIN) <= 0;
  *o = (unsigned long long)((ZDICT_CONTENTSIZE_MIN) | 0);  /* check that ZDICT_CONTENTSIZE_MIN is an integer */
  return n;
}

static int _cffi_const_ZDICT_DICTSIZE_MIN(unsigned long long *o)
{
  int n = (ZDICT_DICTSIZE_MIN) <= 0;
  *o = (unsigned long long)((ZDICT_DICTSIZE_MIN) | 0);  /* check that ZDICT_DICTSIZE_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_BLOCKSIZELOG_MAX(unsigned long long *o)
{
  int n = (ZSTD_BLOCKSIZELOG_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_BLOCKSIZELOG_MAX) | 0);  /* check that ZSTD_BLOCKSIZELOG_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_BLOCKSIZE_MAX(unsigned long long *o)
{
  int n = (ZSTD_BLOCKSIZE_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_BLOCKSIZE_MAX) | 0);  /* check that ZSTD_BLOCKSIZE_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_CHAINLOG_MAX(unsigned long long *o)
{
  int n = (ZSTD_CHAINLOG_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_CHAINLOG_MAX) | 0);  /* check that ZSTD_CHAINLOG_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_CHAINLOG_MAX_32(unsigned long long *o)
{
  int n = (ZSTD_CHAINLOG_MAX_32) <= 0;
  *o = (unsigned long long)((ZSTD_CHAINLOG_MAX_32) | 0);  /* check that ZSTD_CHAINLOG_MAX_32 is an integer */
  return n;
}

static int _cffi_const_ZSTD_CHAINLOG_MAX_64(unsigned long long *o)
{
  int n = (ZSTD_CHAINLOG_MAX_64) <= 0;
  *o = (unsigned long long)((ZSTD_CHAINLOG_MAX_64) | 0);  /* check that ZSTD_CHAINLOG_MAX_64 is an integer */
  return n;
}

static int _cffi_const_ZSTD_CHAINLOG_MIN(unsigned long long *o)
{
  int n = (ZSTD_CHAINLOG_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_CHAINLOG_MIN) | 0);  /* check that ZSTD_CHAINLOG_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_CONTENTSIZE_ERROR(unsigned long long *o)
{
  int n = (ZSTD_CONTENTSIZE_ERROR) <= 0;
  *o = (unsigned long long)((ZSTD_CONTENTSIZE_ERROR) | 0);  /* check that ZSTD_CONTENTSIZE_ERROR is an integer */
  return n;
}

static int _cffi_const_ZSTD_CONTENTSIZE_UNKNOWN(unsigned long long *o)
{
  int n = (ZSTD_CONTENTSIZE_UNKNOWN) <= 0;
  *o = (unsigned long long)((ZSTD_CONTENTSIZE_UNKNOWN) | 0);  /* check that ZSTD_CONTENTSIZE_UNKNOWN is an integer */
  return n;
}

static int _cffi_const_ZSTD_FRAMEHEADERSIZE_MAX(unsigned long long *o)
{
  int n = (ZSTD_FRAMEHEADERSIZE_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_FRAMEHEADERSIZE_MAX) | 0);  /* check that ZSTD_FRAMEHEADERSIZE_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_HASHLOG3_MAX(unsigned long long *o)
{
  int n = (ZSTD_HASHLOG3_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_HASHLOG3_MAX) | 0);  /* check that ZSTD_HASHLOG3_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_HASHLOG_MAX(unsigned long long *o)
{
  int n = (ZSTD_HASHLOG_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_HASHLOG_MAX) | 0);  /* check that ZSTD_HASHLOG_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_HASHLOG_MIN(unsigned long long *o)
{
  int n = (ZSTD_HASHLOG_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_HASHLOG_MIN) | 0);  /* check that ZSTD_HASHLOG_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_LDM_BUCKETSIZELOG_MAX(unsigned long long *o)
{
  int n = (ZSTD_LDM_BUCKETSIZELOG_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_LDM_BUCKETSIZELOG_MAX) | 0);  /* check that ZSTD_LDM_BUCKETSIZELOG_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_LDM_BUCKETSIZELOG_MIN(unsigned long long *o)
{
  int n = (ZSTD_LDM_BUCKETSIZELOG_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_LDM_BUCKETSIZELOG_MIN) | 0);  /* check that ZSTD_LDM_BUCKETSIZELOG_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_LDM_HASHLOG_MAX(unsigned long long *o)
{
  int n = (ZSTD_LDM_HASHLOG_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_LDM_HASHLOG_MAX) | 0);  /* check that ZSTD_LDM_HASHLOG_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_LDM_HASHLOG_MIN(unsigned long long *o)
{
  int n = (ZSTD_LDM_HASHLOG_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_LDM_HASHLOG_MIN) | 0);  /* check that ZSTD_LDM_HASHLOG_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_LDM_HASHRATELOG_MAX(unsigned long long *o)
{
  int n = (ZSTD_LDM_HASHRATELOG_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_LDM_HASHRATELOG_MAX) | 0);  /* check that ZSTD_LDM_HASHRATELOG_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_LDM_HASHRATELOG_MIN(unsigned long long *o)
{
  int n = (ZSTD_LDM_HASHRATELOG_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_LDM_HASHRATELOG_MIN) | 0);  /* check that ZSTD_LDM_HASHRATELOG_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_LDM_MINMATCH_MAX(unsigned long long *o)
{
  int n = (ZSTD_LDM_MINMATCH_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_LDM_MINMATCH_MAX) | 0);  /* check that ZSTD_LDM_MINMATCH_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_LDM_MINMATCH_MIN(unsigned long long *o)
{
  int n = (ZSTD_LDM_MINMATCH_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_LDM_MINMATCH_MIN) | 0);  /* check that ZSTD_LDM_MINMATCH_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_MAGICNUMBER(unsigned long long *o)
{
  int n = (ZSTD_MAGICNUMBER) <= 0;
  *o = (unsigned long long)((ZSTD_MAGICNUMBER) | 0);  /* check that ZSTD_MAGICNUMBER is an integer */
  return n;
}

static int _cffi_const_ZSTD_MAGIC_DICTIONARY(unsigned long long *o)
{
  int n = (ZSTD_MAGIC_DICTIONARY) <= 0;
  *o = (unsigned long long)((ZSTD_MAGIC_DICTIONARY) | 0);  /* check that ZSTD_MAGIC_DICTIONARY is an integer */
  return n;
}

static int _cffi_const_ZSTD_MAGIC_SKIPPABLE_MASK(unsigned long long *o)
{
  int n = (ZSTD_MAGIC_SKIPPABLE_MASK) <= 0;
  *o = (unsigned long long)((ZSTD_MAGIC_SKIPPABLE_MASK) | 0);  /* check that ZSTD_MAGIC_SKIPPABLE_MASK is an integer */
  return n;
}

static int _cffi_const_ZSTD_MAGIC_SKIPPABLE_START(unsigned long long *o)
{
  int n = (ZSTD_MAGIC_SKIPPABLE_START) <= 0;
  *o = (unsigned long long)((ZSTD_MAGIC_SKIPPABLE_START) | 0);  /* check that ZSTD_MAGIC_SKIPPABLE_START is an integer */
  return n;
}

static int _cffi_const_ZSTD_MINMATCH_MAX(unsigned long long *o)
{
  int n = (ZSTD_MINMATCH_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_MINMATCH_MAX) | 0);  /* check that ZSTD_MINMATCH_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_MINMATCH_MIN(unsigned long long *o)
{
  int n = (ZSTD_MINMATCH_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_MINMATCH_MIN) | 0);  /* check that ZSTD_MINMATCH_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_OVERLAPLOG_MAX(unsigned long long *o)
{
  int n = (ZSTD_OVERLAPLOG_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_OVERLAPLOG_MAX) | 0);  /* check that ZSTD_OVERLAPLOG_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_OVERLAPLOG_MIN(unsigned long long *o)
{
  int n = (ZSTD_OVERLAPLOG_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_OVERLAPLOG_MIN) | 0);  /* check that ZSTD_OVERLAPLOG_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_SEARCHLOG_MAX(unsigned long long *o)
{
  int n = (ZSTD_SEARCHLOG_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_SEARCHLOG_MAX) | 0);  /* check that ZSTD_SEARCHLOG_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_SEARCHLOG_MIN(unsigned long long *o)
{
  int n = (ZSTD_SEARCHLOG_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_SEARCHLOG_MIN) | 0);  /* check that ZSTD_SEARCHLOG_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_SKIPPABLEHEADERSIZE(unsigned long long *o)
{
  int n = (ZSTD_SKIPPABLEHEADERSIZE) <= 0;
  *o = (unsigned long long)((ZSTD_SKIPPABLEHEADERSIZE) | 0);  /* check that ZSTD_SKIPPABLEHEADERSIZE is an integer */
  return n;
}

static int _cffi_const_ZSTD_SRCSIZEHINT_MAX(unsigned long long *o)
{
  int n = (ZSTD_SRCSIZEHINT_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_SRCSIZEHINT_MAX) | 0);  /* check that ZSTD_SRCSIZEHINT_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_SRCSIZEHINT_MIN(unsigned long long *o)
{
  int n = (ZSTD_SRCSIZEHINT_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_SRCSIZEHINT_MIN) | 0);  /* check that ZSTD_SRCSIZEHINT_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_STRATEGY_MAX(unsigned long long *o)
{
  int n = (ZSTD_STRATEGY_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_STRATEGY_MAX) | 0);  /* check that ZSTD_STRATEGY_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_STRATEGY_MIN(unsigned long long *o)
{
  int n = (ZSTD_STRATEGY_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_STRATEGY_MIN) | 0);  /* check that ZSTD_STRATEGY_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_TARGETCBLOCKSIZE_MAX(unsigned long long *o)
{
  int n = (ZSTD_TARGETCBLOCKSIZE_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_TARGETCBLOCKSIZE_MAX) | 0);  /* check that ZSTD_TARGETCBLOCKSIZE_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_TARGETCBLOCKSIZE_MIN(unsigned long long *o)
{
  int n = (ZSTD_TARGETCBLOCKSIZE_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_TARGETCBLOCKSIZE_MIN) | 0);  /* check that ZSTD_TARGETCBLOCKSIZE_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_TARGETLENGTH_MAX(unsigned long long *o)
{
  int n = (ZSTD_TARGETLENGTH_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_TARGETLENGTH_MAX) | 0);  /* check that ZSTD_TARGETLENGTH_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_TARGETLENGTH_MIN(unsigned long long *o)
{
  int n = (ZSTD_TARGETLENGTH_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_TARGETLENGTH_MIN) | 0);  /* check that ZSTD_TARGETLENGTH_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_VERSION_MAJOR(unsigned long long *o)
{
  int n = (ZSTD_VERSION_MAJOR) <= 0;
  *o = (unsigned long long)((ZSTD_VERSION_MAJOR) | 0);  /* check that ZSTD_VERSION_MAJOR is an integer */
  return n;
}

static int _cffi_const_ZSTD_VERSION_MINOR(unsigned long long *o)
{
  int n = (ZSTD_VERSION_MINOR) <= 0;
  *o = (unsigned long long)((ZSTD_VERSION_MINOR) | 0);  /* check that ZSTD_VERSION_MINOR is an integer */
  return n;
}

static int _cffi_const_ZSTD_VERSION_NUMBER(unsigned long long *o)
{
  int n = (ZSTD_VERSION_NUMBER) <= 0;
  *o = (unsigned long long)((ZSTD_VERSION_NUMBER) | 0);  /* check that ZSTD_VERSION_NUMBER is an integer */
  return n;
}

static int _cffi_const_ZSTD_VERSION_RELEASE(unsigned long long *o)
{
  int n = (ZSTD_VERSION_RELEASE) <= 0;
  *o = (unsigned long long)((ZSTD_VERSION_RELEASE) | 0);  /* check that ZSTD_VERSION_RELEASE is an integer */
  return n;
}

static int _cffi_const_ZSTD_WINDOWLOG_LIMIT_DEFAULT(unsigned long long *o)
{
  int n = (ZSTD_WINDOWLOG_LIMIT_DEFAULT) <= 0;
  *o = (unsigned long long)((ZSTD_WINDOWLOG_LIMIT_DEFAULT) | 0);  /* check that ZSTD_WINDOWLOG_LIMIT_DEFAULT is an integer */
  return n;
}

static int _cffi_const_ZSTD_WINDOWLOG_MAX(unsigned long long *o)
{
  int n = (ZSTD_WINDOWLOG_MAX) <= 0;
  *o = (unsigned long long)((ZSTD_WINDOWLOG_MAX) | 0);  /* check that ZSTD_WINDOWLOG_MAX is an integer */
  return n;
}

static int _cffi_const_ZSTD_WINDOWLOG_MAX_32(unsigned long long *o)
{
  int n = (ZSTD_WINDOWLOG_MAX_32) <= 0;
  *o = (unsigned long long)((ZSTD_WINDOWLOG_MAX_32) | 0);  /* check that ZSTD_WINDOWLOG_MAX_32 is an integer */
  return n;
}

static int _cffi_const_ZSTD_WINDOWLOG_MAX_64(unsigned long long *o)
{
  int n = (ZSTD_WINDOWLOG_MAX_64) <= 0;
  *o = (unsigned long long)((ZSTD_WINDOWLOG_MAX_64) | 0);  /* check that ZSTD_WINDOWLOG_MAX_64 is an integer */
  return n;
}

static int _cffi_const_ZSTD_WINDOWLOG_MIN(unsigned long long *o)
{
  int n = (ZSTD_WINDOWLOG_MIN) <= 0;
  *o = (unsigned long long)((ZSTD_WINDOWLOG_MIN) | 0);  /* check that ZSTD_WINDOWLOG_MIN is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_blockDelimiters(unsigned long long *o)
{
  int n = (ZSTD_c_blockDelimiters) <= 0;
  *o = (unsigned long long)((ZSTD_c_blockDelimiters) | 0);  /* check that ZSTD_c_blockDelimiters is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_deterministicRefPrefix(unsigned long long *o)
{
  int n = (ZSTD_c_deterministicRefPrefix) <= 0;
  *o = (unsigned long long)((ZSTD_c_deterministicRefPrefix) | 0);  /* check that ZSTD_c_deterministicRefPrefix is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_enableDedicatedDictSearch(unsigned long long *o)
{
  int n = (ZSTD_c_enableDedicatedDictSearch) <= 0;
  *o = (unsigned long long)((ZSTD_c_enableDedicatedDictSearch) | 0);  /* check that ZSTD_c_enableDedicatedDictSearch is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_forceAttachDict(unsigned long long *o)
{
  int n = (ZSTD_c_forceAttachDict) <= 0;
  *o = (unsigned long long)((ZSTD_c_forceAttachDict) | 0);  /* check that ZSTD_c_forceAttachDict is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_forceMaxWindow(unsigned long long *o)
{
  int n = (ZSTD_c_forceMaxWindow) <= 0;
  *o = (unsigned long long)((ZSTD_c_forceMaxWindow) | 0);  /* check that ZSTD_c_forceMaxWindow is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_format(unsigned long long *o)
{
  int n = (ZSTD_c_format) <= 0;
  *o = (unsigned long long)((ZSTD_c_format) | 0);  /* check that ZSTD_c_format is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_literalCompressionMode(unsigned long long *o)
{
  int n = (ZSTD_c_literalCompressionMode) <= 0;
  *o = (unsigned long long)((ZSTD_c_literalCompressionMode) | 0);  /* check that ZSTD_c_literalCompressionMode is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_rsyncable(unsigned long long *o)
{
  int n = (ZSTD_c_rsyncable) <= 0;
  *o = (unsigned long long)((ZSTD_c_rsyncable) | 0);  /* check that ZSTD_c_rsyncable is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_splitBlocks(unsigned long long *o)
{
  int n = (ZSTD_c_splitBlocks) <= 0;
  *o = (unsigned long long)((ZSTD_c_splitBlocks) | 0);  /* check that ZSTD_c_splitBlocks is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_srcSizeHint(unsigned long long *o)
{
  int n = (ZSTD_c_srcSizeHint) <= 0;
  *o = (unsigned long long)((ZSTD_c_srcSizeHint) | 0);  /* check that ZSTD_c_srcSizeHint is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_stableInBuffer(unsigned long long *o)
{
  int n = (ZSTD_c_stableInBuffer) <= 0;
  *o = (unsigned long long)((ZSTD_c_stableInBuffer) | 0);  /* check that ZSTD_c_stableInBuffer is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_stableOutBuffer(unsigned long long *o)
{
  int n = (ZSTD_c_stableOutBuffer) <= 0;
  *o = (unsigned long long)((ZSTD_c_stableOutBuffer) | 0);  /* check that ZSTD_c_stableOutBuffer is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_targetCBlockSize(unsigned long long *o)
{
  int n = (ZSTD_c_targetCBlockSize) <= 0;
  *o = (unsigned long long)((ZSTD_c_targetCBlockSize) | 0);  /* check that ZSTD_c_targetCBlockSize is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_useRowMatchFinder(unsigned long long *o)
{
  int n = (ZSTD_c_useRowMatchFinder) <= 0;
  *o = (unsigned long long)((ZSTD_c_useRowMatchFinder) | 0);  /* check that ZSTD_c_useRowMatchFinder is an integer */
  return n;
}

static int _cffi_const_ZSTD_c_validateSequences(unsigned long long *o)
{
  int n = (ZSTD_c_validateSequences) <= 0;
  *o = (unsigned long long)((ZSTD_c_validateSequences) | 0);  /* check that ZSTD_c_validateSequences is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_forceIgnoreChecksum(unsigned long long *o)
{
  int n = (ZSTD_d_forceIgnoreChecksum) <= 0;
  *o = (unsigned long long)((ZSTD_d_forceIgnoreChecksum) | 0);  /* check that ZSTD_d_forceIgnoreChecksum is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_format(unsigned long long *o)
{
  int n = (ZSTD_d_format) <= 0;
  *o = (unsigned long long)((ZSTD_d_format) | 0);  /* check that ZSTD_d_format is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_refMultipleDDicts(unsigned long long *o)
{
  int n = (ZSTD_d_refMultipleDDicts) <= 0;
  *o = (unsigned long long)((ZSTD_d_refMultipleDDicts) | 0);  /* check that ZSTD_d_refMultipleDDicts is an integer */
  return n;
}

static int _cffi_const_ZSTD_d_stableOutBuffer(unsigned long long *o)
{
  int n = (ZSTD_d_stableOutBuffer) <= 0;
  *o = (unsigned long long)((ZSTD_d_stableOutBuffer) | 0);  /* check that ZSTD_d_stableOutBuffer is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld__ZSTD_inBuffer(ZSTD_inBuffer *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void const * *tmp = &p->src; (void)tmp; }
  (void)((p->size) | 0);  /* check that 'ZSTD_inBuffer.size' is an integer */
  (void)((p->pos) | 0);  /* check that 'ZSTD_inBuffer.pos' is an integer */
}
struct _cffi_align__ZSTD_inBuffer { char x; ZSTD_inBuffer y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__ZSTD_outBuffer(ZSTD_outBuffer *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void * *tmp = &p->dst; (void)tmp; }
  (void)((p->size) | 0);  /* check that 'ZSTD_outBuffer.size' is an integer */
  (void)((p->pos) | 0);  /* check that 'ZSTD_outBuffer.pos' is an integer */
}
struct _cffi_align__ZSTD_outBuffer { char x; ZSTD_outBuffer y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "ZDICT_CONTENTSIZE_MIN", (void *)_cffi_const_ZDICT_CONTENTSIZE_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZDICT_DICTSIZE_MIN", (void *)_cffi_const_ZDICT_DICTSIZE_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZDICT_addEntropyTablesFromBuffer", (void *)_cffi_f_ZDICT_addEntropyTablesFromBuffer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 451), (void *)_cffi_d_ZDICT_addEntropyTablesFromBuffer },
  { "ZDICT_finalizeDictionary", (void *)_cffi_f_ZDICT_finalizeDictionary, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 526), (void *)_cffi_d_ZDICT_finalizeDictionary },
  { "ZDICT_getDictHeaderSize", (void *)_cffi_f_ZDICT_getDictHeaderSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 536), (void *)_cffi_d_ZDICT_getDictHeaderSize },
  { "ZDICT_getDictID", (void *)_cffi_f_ZDICT_getDictID, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 551), (void *)_cffi_d_ZDICT_getDictID },
  { "ZDICT_getErrorName", (void *)_cffi_f_ZDICT_getErrorName, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 99), (void *)_cffi_d_ZDICT_getErrorName },
  { "ZDICT_isError", (void *)_cffi_f_ZDICT_isError, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 548), (void *)_cffi_d_ZDICT_isError },
  { "ZDICT_optimizeTrainFromBuffer_cover", (void *)_cffi_f_ZDICT_optimizeTrainFromBuffer_cover, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 466), (void *)_cffi_d_ZDICT_optimizeTrainFromBuffer_cover },
  { "ZDICT_optimizeTrainFromBuffer_fastCover", (void *)_cffi_f_ZDICT_optimizeTrainFromBuffer_fastCover, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 482), (void *)_cffi_d_ZDICT_optimizeTrainFromBuffer_fastCover },
  { "ZDICT_trainFromBuffer", (void *)_cffi_f_ZDICT_trainFromBuffer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 459), (void *)_cffi_d_ZDICT_trainFromBuffer },
  { "ZDICT_trainFromBuffer_cover", (void *)_cffi_f_ZDICT_trainFromBuffer_cover, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 474), (void *)_cffi_d_ZDICT_trainFromBuffer_cover },
  { "ZDICT_trainFromBuffer_fastCover", (void *)_cffi_f_ZDICT_trainFromBuffer_fastCover, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 490), (void *)_cffi_d_ZDICT_trainFromBuffer_fastCover },
  { "ZDICT_trainFromBuffer_legacy", (void *)_cffi_f_ZDICT_trainFromBuffer_legacy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 498), (void *)_cffi_d_ZDICT_trainFromBuffer_legacy },
  { "ZSTD_BLOCKSIZELOG_MAX", (void *)_cffi_const_ZSTD_BLOCKSIZELOG_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_BLOCKSIZE_MAX", (void *)_cffi_const_ZSTD_BLOCKSIZE_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_CCtxParams_getParameter", (void *)_cffi_f_ZSTD_CCtxParams_getParameter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 305), (void *)_cffi_d_ZSTD_CCtxParams_getParameter },
  { "ZSTD_CCtxParams_init", (void *)_cffi_f_ZSTD_CCtxParams_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 298), (void *)_cffi_d_ZSTD_CCtxParams_init },
  { "ZSTD_CCtxParams_init_advanced", (void *)_cffi_f_ZSTD_CCtxParams_init_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 294), (void *)_cffi_d_ZSTD_CCtxParams_init_advanced },
  { "ZSTD_CCtxParams_reset", (void *)_cffi_f_ZSTD_CCtxParams_reset, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 286), (void *)_cffi_d_ZSTD_CCtxParams_reset },
  { "ZSTD_CCtxParams_setParameter", (void *)_cffi_f_ZSTD_CCtxParams_setParameter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 289), (void *)_cffi_d_ZSTD_CCtxParams_setParameter },
  { "ZSTD_CCtx_getParameter", (void *)_cffi_f_ZSTD_CCtx_getParameter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 281), (void *)_cffi_d_ZSTD_CCtx_getParameter },
  { "ZSTD_CCtx_loadDictionary", (void *)_cffi_f_ZSTD_CCtx_loadDictionary, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 247), (void *)_cffi_d_ZSTD_CCtx_loadDictionary },
  { "ZSTD_CCtx_loadDictionary_advanced", (void *)_cffi_f_ZSTD_CCtx_loadDictionary_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 258), (void *)_cffi_d_ZSTD_CCtx_loadDictionary_advanced },
  { "ZSTD_CCtx_loadDictionary_byReference", (void *)_cffi_f_ZSTD_CCtx_loadDictionary_byReference, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 247), (void *)_cffi_d_ZSTD_CCtx_loadDictionary_byReference },
  { "ZSTD_CCtx_refCDict", (void *)_cffi_f_ZSTD_CCtx_refCDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 118), (void *)_cffi_d_ZSTD_CCtx_refCDict },
  { "ZSTD_CCtx_refPrefix", (void *)_cffi_f_ZSTD_CCtx_refPrefix, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 247), (void *)_cffi_d_ZSTD_CCtx_refPrefix },
  { "ZSTD_CCtx_refPrefix_advanced", (void *)_cffi_f_ZSTD_CCtx_refPrefix_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 252), (void *)_cffi_d_ZSTD_CCtx_refPrefix_advanced },
  { "ZSTD_CCtx_refThreadPool", (void *)_cffi_f_ZSTD_CCtx_refThreadPool, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 159), (void *)_cffi_d_ZSTD_CCtx_refThreadPool },
  { "ZSTD_CCtx_reset", (void *)_cffi_f_ZSTD_CCtx_reset, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 128), (void *)_cffi_d_ZSTD_CCtx_reset },
  { "ZSTD_CCtx_setParameter", (void *)_cffi_f_ZSTD_CCtx_setParameter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 139), (void *)_cffi_d_ZSTD_CCtx_setParameter },
  { "ZSTD_CCtx_setParametersUsingCCtxParams", (void *)_cffi_f_ZSTD_CCtx_setParametersUsingCCtxParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 114), (void *)_cffi_d_ZSTD_CCtx_setParametersUsingCCtxParams },
  { "ZSTD_CCtx_setPledgedSrcSize", (void *)_cffi_f_ZSTD_CCtx_setPledgedSrcSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 172), (void *)_cffi_d_ZSTD_CCtx_setPledgedSrcSize },
  { "ZSTD_CHAINLOG_MAX", (void *)_cffi_const_ZSTD_CHAINLOG_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_CHAINLOG_MAX_32", (void *)_cffi_const_ZSTD_CHAINLOG_MAX_32, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_CHAINLOG_MAX_64", (void *)_cffi_const_ZSTD_CHAINLOG_MAX_64, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_CHAINLOG_MIN", (void *)_cffi_const_ZSTD_CHAINLOG_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_CONTENTSIZE_ERROR", (void *)_cffi_const_ZSTD_CONTENTSIZE_ERROR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_CONTENTSIZE_UNKNOWN", (void *)_cffi_const_ZSTD_CONTENTSIZE_UNKNOWN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_CStreamInSize", (void *)_cffi_f_ZSTD_CStreamInSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 540), (void *)_cffi_d_ZSTD_CStreamInSize },
  { "ZSTD_CStreamOutSize", (void *)_cffi_f_ZSTD_CStreamOutSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 540), (void *)_cffi_d_ZSTD_CStreamOutSize },
  { "ZSTD_DCtx_getParameter", (void *)_cffi_f_ZSTD_DCtx_getParameter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 327), (void *)_cffi_d_ZSTD_DCtx_getParameter },
  { "ZSTD_DCtx_loadDictionary", (void *)_cffi_f_ZSTD_DCtx_loadDictionary, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 383), (void *)_cffi_d_ZSTD_DCtx_loadDictionary },
  { "ZSTD_DCtx_loadDictionary_advanced", (void *)_cffi_f_ZSTD_DCtx_loadDictionary_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 394), (void *)_cffi_d_ZSTD_DCtx_loadDictionary_advanced },
  { "ZSTD_DCtx_loadDictionary_byReference", (void *)_cffi_f_ZSTD_DCtx_loadDictionary_byReference, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 383), (void *)_cffi_d_ZSTD_DCtx_loadDictionary_byReference },
  { "ZSTD_DCtx_refDDict", (void *)_cffi_f_ZSTD_DCtx_refDDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 319), (void *)_cffi_d_ZSTD_DCtx_refDDict },
  { "ZSTD_DCtx_refPrefix", (void *)_cffi_f_ZSTD_DCtx_refPrefix, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 383), (void *)_cffi_d_ZSTD_DCtx_refPrefix },
  { "ZSTD_DCtx_refPrefix_advanced", (void *)_cffi_f_ZSTD_DCtx_refPrefix_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 388), (void *)_cffi_d_ZSTD_DCtx_refPrefix_advanced },
  { "ZSTD_DCtx_reset", (void *)_cffi_f_ZSTD_DCtx_reset, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 323), (void *)_cffi_d_ZSTD_DCtx_reset },
  { "ZSTD_DCtx_setFormat", (void *)_cffi_f_ZSTD_DCtx_setFormat, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 337), (void *)_cffi_d_ZSTD_DCtx_setFormat },
  { "ZSTD_DCtx_setMaxWindowSize", (void *)_cffi_f_ZSTD_DCtx_setMaxWindowSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 346), (void *)_cffi_d_ZSTD_DCtx_setMaxWindowSize },
  { "ZSTD_DCtx_setParameter", (void *)_cffi_f_ZSTD_DCtx_setParameter, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 332), (void *)_cffi_d_ZSTD_DCtx_setParameter },
  { "ZSTD_DStreamInSize", (void *)_cffi_f_ZSTD_DStreamInSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 540), (void *)_cffi_d_ZSTD_DStreamInSize },
  { "ZSTD_DStreamOutSize", (void *)_cffi_f_ZSTD_DStreamOutSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 540), (void *)_cffi_d_ZSTD_DStreamOutSize },
  { "ZSTD_FRAMEHEADERSIZE_MAX", (void *)_cffi_const_ZSTD_FRAMEHEADERSIZE_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_HASHLOG3_MAX", (void *)_cffi_const_ZSTD_HASHLOG3_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_HASHLOG_MAX", (void *)_cffi_const_ZSTD_HASHLOG_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_HASHLOG_MIN", (void *)_cffi_const_ZSTD_HASHLOG_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_LDM_BUCKETSIZELOG_MAX", (void *)_cffi_const_ZSTD_LDM_BUCKETSIZELOG_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_LDM_BUCKETSIZELOG_MIN", (void *)_cffi_const_ZSTD_LDM_BUCKETSIZELOG_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_LDM_HASHLOG_MAX", (void *)_cffi_const_ZSTD_LDM_HASHLOG_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_LDM_HASHLOG_MIN", (void *)_cffi_const_ZSTD_LDM_HASHLOG_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_LDM_HASHRATELOG_MAX", (void *)_cffi_const_ZSTD_LDM_HASHRATELOG_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_LDM_HASHRATELOG_MIN", (void *)_cffi_const_ZSTD_LDM_HASHRATELOG_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_LDM_MINMATCH_MAX", (void *)_cffi_const_ZSTD_LDM_MINMATCH_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_LDM_MINMATCH_MIN", (void *)_cffi_const_ZSTD_LDM_MINMATCH_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_MAGICNUMBER", (void *)_cffi_const_ZSTD_MAGICNUMBER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_MAGIC_DICTIONARY", (void *)_cffi_const_ZSTD_MAGIC_DICTIONARY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_MAGIC_SKIPPABLE_MASK", (void *)_cffi_const_ZSTD_MAGIC_SKIPPABLE_MASK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_MAGIC_SKIPPABLE_START", (void *)_cffi_const_ZSTD_MAGIC_SKIPPABLE_START, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_MINMATCH_MAX", (void *)_cffi_const_ZSTD_MINMATCH_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_MINMATCH_MIN", (void *)_cffi_const_ZSTD_MINMATCH_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_OVERLAPLOG_MAX", (void *)_cffi_const_ZSTD_OVERLAPLOG_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_OVERLAPLOG_MIN", (void *)_cffi_const_ZSTD_OVERLAPLOG_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_SEARCHLOG_MAX", (void *)_cffi_const_ZSTD_SEARCHLOG_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_SEARCHLOG_MIN", (void *)_cffi_const_ZSTD_SEARCHLOG_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_SKIPPABLEHEADERSIZE", (void *)_cffi_const_ZSTD_SKIPPABLEHEADERSIZE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_SRCSIZEHINT_MAX", (void *)_cffi_const_ZSTD_SRCSIZEHINT_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_SRCSIZEHINT_MIN", (void *)_cffi_const_ZSTD_SRCSIZEHINT_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_STRATEGY_MAX", (void *)_cffi_const_ZSTD_STRATEGY_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_STRATEGY_MIN", (void *)_cffi_const_ZSTD_STRATEGY_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_TARGETCBLOCKSIZE_MAX", (void *)_cffi_const_ZSTD_TARGETCBLOCKSIZE_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_TARGETCBLOCKSIZE_MIN", (void *)_cffi_const_ZSTD_TARGETCBLOCKSIZE_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_TARGETLENGTH_MAX", (void *)_cffi_const_ZSTD_TARGETLENGTH_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_TARGETLENGTH_MIN", (void *)_cffi_const_ZSTD_TARGETLENGTH_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_VERSION_MAJOR", (void *)_cffi_const_ZSTD_VERSION_MAJOR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_VERSION_MINOR", (void *)_cffi_const_ZSTD_VERSION_MINOR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_VERSION_NUMBER", (void *)_cffi_const_ZSTD_VERSION_NUMBER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_VERSION_RELEASE", (void *)_cffi_const_ZSTD_VERSION_RELEASE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_WINDOWLOG_LIMIT_DEFAULT", (void *)_cffi_const_ZSTD_WINDOWLOG_LIMIT_DEFAULT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_WINDOWLOG_MAX", (void *)_cffi_const_ZSTD_WINDOWLOG_MAX, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_WINDOWLOG_MAX_32", (void *)_cffi_const_ZSTD_WINDOWLOG_MAX_32, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_WINDOWLOG_MAX_64", (void *)_cffi_const_ZSTD_WINDOWLOG_MAX_64, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_WINDOWLOG_MIN", (void *)_cffi_const_ZSTD_WINDOWLOG_MIN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_adjustCParams", (void *)_cffi_f_ZSTD_adjustCParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 75), (void *)_cffi_d_ZSTD_adjustCParams },
  { "ZSTD_btlazy2", (void *)_cffi_const_ZSTD_btlazy2, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_btopt", (void *)_cffi_const_ZSTD_btopt, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_btultra", (void *)_cffi_const_ZSTD_btultra, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_btultra2", (void *)_cffi_const_ZSTD_btultra2, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_cParam_getBounds", (void *)_cffi_f_ZSTD_cParam_getBounds, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 69), (void *)_cffi_d_ZSTD_cParam_getBounds },
  { "ZSTD_c_blockDelimiters", (void *)_cffi_const_ZSTD_c_blockDelimiters, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_chainLog", (void *)_cffi_const_ZSTD_c_chainLog, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_checksumFlag", (void *)_cffi_const_ZSTD_c_checksumFlag, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_compressionLevel", (void *)_cffi_const_ZSTD_c_compressionLevel, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_contentSizeFlag", (void *)_cffi_const_ZSTD_c_contentSizeFlag, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_deterministicRefPrefix", (void *)_cffi_const_ZSTD_c_deterministicRefPrefix, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_dictIDFlag", (void *)_cffi_const_ZSTD_c_dictIDFlag, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_enableDedicatedDictSearch", (void *)_cffi_const_ZSTD_c_enableDedicatedDictSearch, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_enableLongDistanceMatching", (void *)_cffi_const_ZSTD_c_enableLongDistanceMatching, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam1", (void *)_cffi_const_ZSTD_c_experimentalParam1, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam10", (void *)_cffi_const_ZSTD_c_experimentalParam10, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam11", (void *)_cffi_const_ZSTD_c_experimentalParam11, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam12", (void *)_cffi_const_ZSTD_c_experimentalParam12, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam13", (void *)_cffi_const_ZSTD_c_experimentalParam13, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam14", (void *)_cffi_const_ZSTD_c_experimentalParam14, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam15", (void *)_cffi_const_ZSTD_c_experimentalParam15, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam2", (void *)_cffi_const_ZSTD_c_experimentalParam2, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam3", (void *)_cffi_const_ZSTD_c_experimentalParam3, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam4", (void *)_cffi_const_ZSTD_c_experimentalParam4, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam5", (void *)_cffi_const_ZSTD_c_experimentalParam5, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam6", (void *)_cffi_const_ZSTD_c_experimentalParam6, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam7", (void *)_cffi_const_ZSTD_c_experimentalParam7, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam8", (void *)_cffi_const_ZSTD_c_experimentalParam8, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_experimentalParam9", (void *)_cffi_const_ZSTD_c_experimentalParam9, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_forceAttachDict", (void *)_cffi_const_ZSTD_c_forceAttachDict, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_forceMaxWindow", (void *)_cffi_const_ZSTD_c_forceMaxWindow, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_format", (void *)_cffi_const_ZSTD_c_format, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_hashLog", (void *)_cffi_const_ZSTD_c_hashLog, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_jobSize", (void *)_cffi_const_ZSTD_c_jobSize, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_ldmBucketSizeLog", (void *)_cffi_const_ZSTD_c_ldmBucketSizeLog, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_ldmHashLog", (void *)_cffi_const_ZSTD_c_ldmHashLog, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_ldmHashRateLog", (void *)_cffi_const_ZSTD_c_ldmHashRateLog, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_ldmMinMatch", (void *)_cffi_const_ZSTD_c_ldmMinMatch, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_literalCompressionMode", (void *)_cffi_const_ZSTD_c_literalCompressionMode, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_minMatch", (void *)_cffi_const_ZSTD_c_minMatch, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_nbWorkers", (void *)_cffi_const_ZSTD_c_nbWorkers, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_overlapLog", (void *)_cffi_const_ZSTD_c_overlapLog, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_rsyncable", (void *)_cffi_const_ZSTD_c_rsyncable, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_searchLog", (void *)_cffi_const_ZSTD_c_searchLog, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_splitBlocks", (void *)_cffi_const_ZSTD_c_splitBlocks, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_srcSizeHint", (void *)_cffi_const_ZSTD_c_srcSizeHint, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_stableInBuffer", (void *)_cffi_const_ZSTD_c_stableInBuffer, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_stableOutBuffer", (void *)_cffi_const_ZSTD_c_stableOutBuffer, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_strategy", (void *)_cffi_const_ZSTD_c_strategy, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_targetCBlockSize", (void *)_cffi_const_ZSTD_c_targetCBlockSize, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_targetLength", (void *)_cffi_const_ZSTD_c_targetLength, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_c_useRowMatchFinder", (void *)_cffi_const_ZSTD_c_useRowMatchFinder, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_validateSequences", (void *)_cffi_const_ZSTD_c_validateSequences, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_c_windowLog", (void *)_cffi_const_ZSTD_c_windowLog, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_checkCParams", (void *)_cffi_f_ZSTD_checkCParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 414), (void *)_cffi_d_ZSTD_checkCParams },
  { "ZSTD_compress", (void *)_cffi_f_ZSTD_compress, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 512), (void *)_cffi_d_ZSTD_compress },
  { "ZSTD_compress2", (void *)_cffi_f_ZSTD_compress2, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 195), (void *)_cffi_d_ZSTD_compress2 },
  { "ZSTD_compressBegin", (void *)_cffi_f_ZSTD_compressBegin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 163), (void *)_cffi_d_ZSTD_compressBegin },
  { "ZSTD_compressBegin_advanced", (void *)_cffi_f_ZSTD_compressBegin_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 265), (void *)_cffi_d_ZSTD_compressBegin_advanced },
  { "ZSTD_compressBegin_usingCDict", (void *)_cffi_f_ZSTD_compressBegin_usingCDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 118), (void *)_cffi_d_ZSTD_compressBegin_usingCDict },
  { "ZSTD_compressBegin_usingCDict_advanced", (void *)_cffi_f_ZSTD_compressBegin_usingCDict_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 122), (void *)_cffi_d_ZSTD_compressBegin_usingCDict_advanced },
  { "ZSTD_compressBegin_usingDict", (void *)_cffi_f_ZSTD_compressBegin_usingDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 272), (void *)_cffi_d_ZSTD_compressBegin_usingDict },
  { "ZSTD_compressBlock", (void *)_cffi_f_ZSTD_compressBlock, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 195), (void *)_cffi_d_ZSTD_compressBlock },
  { "ZSTD_compressBound", (void *)_cffi_f_ZSTD_compressBound, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 431), (void *)_cffi_d_ZSTD_compressBound },
  { "ZSTD_compressCCtx", (void *)_cffi_f_ZSTD_compressCCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 219), (void *)_cffi_d_ZSTD_compressCCtx },
  { "ZSTD_compressContinue", (void *)_cffi_f_ZSTD_compressContinue, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 195), (void *)_cffi_d_ZSTD_compressContinue },
  { "ZSTD_compressEnd", (void *)_cffi_f_ZSTD_compressEnd, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 195), (void *)_cffi_d_ZSTD_compressEnd },
  { "ZSTD_compressSequences", (void *)_cffi_f_ZSTD_compressSequences, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 176), (void *)_cffi_d_ZSTD_compressSequences },
  { "ZSTD_compressStream", (void *)_cffi_f_ZSTD_compressStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 148), (void *)_cffi_d_ZSTD_compressStream },
  { "ZSTD_compressStream2", (void *)_cffi_f_ZSTD_compressStream2, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 153), (void *)_cffi_d_ZSTD_compressStream2 },
  { "ZSTD_compressStream2_simpleArgs", (void *)_cffi_f_ZSTD_compressStream2_simpleArgs, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 185), (void *)_cffi_d_ZSTD_compressStream2_simpleArgs },
  { "ZSTD_compress_advanced", (void *)_cffi_f_ZSTD_compress_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 227), (void *)_cffi_d_ZSTD_compress_advanced },
  { "ZSTD_compress_usingCDict", (void *)_cffi_f_ZSTD_compress_usingCDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 202), (void *)_cffi_d_ZSTD_compress_usingCDict },
  { "ZSTD_compress_usingCDict_advanced", (void *)_cffi_f_ZSTD_compress_usingCDict_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 210), (void *)_cffi_d_ZSTD_compress_usingCDict_advanced },
  { "ZSTD_compress_usingDict", (void *)_cffi_f_ZSTD_compress_usingDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 237), (void *)_cffi_d_ZSTD_compress_usingDict },
  { "ZSTD_copyCCtx", (void *)_cffi_f_ZSTD_copyCCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 109), (void *)_cffi_d_ZSTD_copyCCtx },
  { "ZSTD_copyDCtx", (void *)_cffi_f_ZSTD_copyDCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 565), (void *)_cffi_d_ZSTD_copyDCtx },
  { "ZSTD_createCCtx", (void *)_cffi_f_ZSTD_createCCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 7), (void *)_cffi_d_ZSTD_createCCtx },
  { "ZSTD_createCCtxParams", (void *)_cffi_f_ZSTD_createCCtxParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 9), (void *)_cffi_d_ZSTD_createCCtxParams },
  { "ZSTD_createCCtx_advanced", (void *)_cffi_f_ZSTD_createCCtx_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_ZSTD_createCCtx_advanced },
  { "ZSTD_createCDict", (void *)_cffi_f_ZSTD_createCDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 27), (void *)_cffi_d_ZSTD_createCDict },
  { "ZSTD_createCDict_advanced", (void *)_cffi_f_ZSTD_createCDict_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 19), (void *)_cffi_d_ZSTD_createCDict_advanced },
  { "ZSTD_createCDict_advanced2", (void *)_cffi_f_ZSTD_createCDict_advanced2, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 11), (void *)_cffi_d_ZSTD_createCDict_advanced2 },
  { "ZSTD_createCDict_byReference", (void *)_cffi_f_ZSTD_createCDict_byReference, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 27), (void *)_cffi_d_ZSTD_createCDict_byReference },
  { "ZSTD_createCStream", (void *)_cffi_f_ZSTD_createCStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 7), (void *)_cffi_d_ZSTD_createCStream },
  { "ZSTD_createCStream_advanced", (void *)_cffi_f_ZSTD_createCStream_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_ZSTD_createCStream_advanced },
  { "ZSTD_createDCtx", (void *)_cffi_f_ZSTD_createDCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 48), (void *)_cffi_d_ZSTD_createDCtx },
  { "ZSTD_createDCtx_advanced", (void *)_cffi_f_ZSTD_createDCtx_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 41), (void *)_cffi_d_ZSTD_createDCtx_advanced },
  { "ZSTD_createDDict", (void *)_cffi_f_ZSTD_createDDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 50), (void *)_cffi_d_ZSTD_createDDict },
  { "ZSTD_createDDict_advanced", (void *)_cffi_f_ZSTD_createDDict_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 54), (void *)_cffi_d_ZSTD_createDDict_advanced },
  { "ZSTD_createDDict_byReference", (void *)_cffi_f_ZSTD_createDDict_byReference, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 50), (void *)_cffi_d_ZSTD_createDDict_byReference },
  { "ZSTD_createDStream", (void *)_cffi_f_ZSTD_createDStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 48), (void *)_cffi_d_ZSTD_createDStream },
  { "ZSTD_createDStream_advanced", (void *)_cffi_f_ZSTD_createDStream_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 41), (void *)_cffi_d_ZSTD_createDStream_advanced },
  { "ZSTD_createThreadPool", (void *)_cffi_f_ZSTD_createThreadPool, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 96), (void *)_cffi_d_ZSTD_createThreadPool },
  { "ZSTD_dParam_getBounds", (void *)_cffi_f_ZSTD_dParam_getBounds, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 72), (void *)_cffi_d_ZSTD_dParam_getBounds },
  { "ZSTD_d_experimentalParam1", (void *)_cffi_const_ZSTD_d_experimentalParam1, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_d_experimentalParam2", (void *)_cffi_const_ZSTD_d_experimentalParam2, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_d_experimentalParam3", (void *)_cffi_const_ZSTD_d_experimentalParam3, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_d_experimentalParam4", (void *)_cffi_const_ZSTD_d_experimentalParam4, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_d_forceIgnoreChecksum", (void *)_cffi_const_ZSTD_d_forceIgnoreChecksum, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_d_format", (void *)_cffi_const_ZSTD_d_format, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_d_ignoreChecksum", (void *)_cffi_const_ZSTD_d_ignoreChecksum, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_d_refMultipleDDicts", (void *)_cffi_const_ZSTD_d_refMultipleDDicts, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_d_stableOutBuffer", (void *)_cffi_const_ZSTD_d_stableOutBuffer, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ZSTD_d_validateChecksum", (void *)_cffi_const_ZSTD_d_validateChecksum, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_d_windowLogMax", (void *)_cffi_const_ZSTD_d_windowLogMax, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_dct_auto", (void *)_cffi_const_ZSTD_dct_auto, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_dct_fullDict", (void *)_cffi_const_ZSTD_dct_fullDict, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_dct_rawContent", (void *)_cffi_const_ZSTD_dct_rawContent, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_decodingBufferSize_min", (void *)_cffi_f_ZSTD_decodingBufferSize_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 447), (void *)_cffi_d_ZSTD_decodingBufferSize_min },
  { "ZSTD_decompress", (void *)_cffi_f_ZSTD_decompress, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 506), (void *)_cffi_d_ZSTD_decompress },
  { "ZSTD_decompressBegin", (void *)_cffi_f_ZSTD_decompressBegin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 316), (void *)_cffi_d_ZSTD_decompressBegin },
  { "ZSTD_decompressBegin_usingDDict", (void *)_cffi_f_ZSTD_decompressBegin_usingDDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 319), (void *)_cffi_d_ZSTD_decompressBegin_usingDDict },
  { "ZSTD_decompressBegin_usingDict", (void *)_cffi_f_ZSTD_decompressBegin_usingDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 383), (void *)_cffi_d_ZSTD_decompressBegin_usingDict },
  { "ZSTD_decompressBlock", (void *)_cffi_f_ZSTD_decompressBlock, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 359), (void *)_cffi_d_ZSTD_decompressBlock },
  { "ZSTD_decompressBound", (void *)_cffi_f_ZSTD_decompressBound, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 557), (void *)_cffi_d_ZSTD_decompressBound },
  { "ZSTD_decompressContinue", (void *)_cffi_f_ZSTD_decompressContinue, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 359), (void *)_cffi_d_ZSTD_decompressContinue },
  { "ZSTD_decompressDCtx", (void *)_cffi_f_ZSTD_decompressDCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 359), (void *)_cffi_d_ZSTD_decompressDCtx },
  { "ZSTD_decompressStream", (void *)_cffi_f_ZSTD_decompressStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 341), (void *)_cffi_d_ZSTD_decompressStream },
  { "ZSTD_decompressStream_simpleArgs", (void *)_cffi_f_ZSTD_decompressStream_simpleArgs, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 350), (void *)_cffi_d_ZSTD_decompressStream_simpleArgs },
  { "ZSTD_decompress_usingDDict", (void *)_cffi_f_ZSTD_decompress_usingDDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 366), (void *)_cffi_d_ZSTD_decompress_usingDDict },
  { "ZSTD_decompress_usingDict", (void *)_cffi_f_ZSTD_decompress_usingDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 374), (void *)_cffi_d_ZSTD_decompress_usingDict },
  { "ZSTD_defaultCLevel", (void *)_cffi_f_ZSTD_defaultCLevel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 104), (void *)_cffi_d_ZSTD_defaultCLevel },
  { "ZSTD_defaultCMem", (void *)_cffi_const_ZSTD_defaultCMem, _CFFI_OP(_CFFI_OP_CONSTANT, 1), (void *)0 },
  { "ZSTD_dfast", (void *)_cffi_const_ZSTD_dfast, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_dictDefaultAttach", (void *)_cffi_const_ZSTD_dictDefaultAttach, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_dictForceAttach", (void *)_cffi_const_ZSTD_dictForceAttach, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_dictForceCopy", (void *)_cffi_const_ZSTD_dictForceCopy, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_dictForceLoad", (void *)_cffi_const_ZSTD_dictForceLoad, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_dlm_byCopy", (void *)_cffi_const_ZSTD_dlm_byCopy, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_dlm_byRef", (void *)_cffi_const_ZSTD_dlm_byRef, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_e_continue", (void *)_cffi_const_ZSTD_e_continue, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_e_end", (void *)_cffi_const_ZSTD_e_end, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_e_flush", (void *)_cffi_const_ZSTD_e_flush, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_endStream", (void *)_cffi_f_ZSTD_endStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 144), (void *)_cffi_d_ZSTD_endStream },
  { "ZSTD_estimateCCtxSize", (void *)_cffi_f_ZSTD_estimateCCtxSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 428), (void *)_cffi_d_ZSTD_estimateCCtxSize },
  { "ZSTD_estimateCCtxSize_usingCCtxParams", (void *)_cffi_f_ZSTD_estimateCCtxSize_usingCCtxParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 302), (void *)_cffi_d_ZSTD_estimateCCtxSize_usingCCtxParams },
  { "ZSTD_estimateCCtxSize_usingCParams", (void *)_cffi_f_ZSTD_estimateCCtxSize_usingCParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 414), (void *)_cffi_d_ZSTD_estimateCCtxSize_usingCParams },
  { "ZSTD_estimateCDictSize", (void *)_cffi_f_ZSTD_estimateCDictSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 443), (void *)_cffi_d_ZSTD_estimateCDictSize },
  { "ZSTD_estimateCDictSize_advanced", (void *)_cffi_f_ZSTD_estimateCDictSize_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 434), (void *)_cffi_d_ZSTD_estimateCDictSize_advanced },
  { "ZSTD_estimateCStreamSize", (void *)_cffi_f_ZSTD_estimateCStreamSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 428), (void *)_cffi_d_ZSTD_estimateCStreamSize },
  { "ZSTD_estimateCStreamSize_usingCCtxParams", (void *)_cffi_f_ZSTD_estimateCStreamSize_usingCCtxParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 302), (void *)_cffi_d_ZSTD_estimateCStreamSize_usingCCtxParams },
  { "ZSTD_estimateCStreamSize_usingCParams", (void *)_cffi_f_ZSTD_estimateCStreamSize_usingCParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 414), (void *)_cffi_d_ZSTD_estimateCStreamSize_usingCParams },
  { "ZSTD_estimateDCtxSize", (void *)_cffi_f_ZSTD_estimateDCtxSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 540), (void *)_cffi_d_ZSTD_estimateDCtxSize },
  { "ZSTD_estimateDDictSize", (void *)_cffi_f_ZSTD_estimateDDictSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 439), (void *)_cffi_d_ZSTD_estimateDDictSize },
  { "ZSTD_estimateDStreamSize", (void *)_cffi_f_ZSTD_estimateDStreamSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 431), (void *)_cffi_d_ZSTD_estimateDStreamSize },
  { "ZSTD_estimateDStreamSize_fromFrame", (void *)_cffi_f_ZSTD_estimateDStreamSize_fromFrame, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 536), (void *)_cffi_d_ZSTD_estimateDStreamSize_fromFrame },
  { "ZSTD_f_zstd1", (void *)_cffi_const_ZSTD_f_zstd1, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_f_zstd1_magicless", (void *)_cffi_const_ZSTD_f_zstd1_magicless, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_fast", (void *)_cffi_const_ZSTD_fast, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_findDecompressedSize", (void *)_cffi_f_ZSTD_findDecompressedSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 557), (void *)_cffi_d_ZSTD_findDecompressedSize },
  { "ZSTD_findFrameCompressedSize", (void *)_cffi_f_ZSTD_findFrameCompressedSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 536), (void *)_cffi_d_ZSTD_findFrameCompressedSize },
  { "ZSTD_flushStream", (void *)_cffi_f_ZSTD_flushStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 144), (void *)_cffi_d_ZSTD_flushStream },
  { "ZSTD_frame", (void *)_cffi_const_ZSTD_frame, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_frameHeaderSize", (void *)_cffi_f_ZSTD_frameHeaderSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 536), (void *)_cffi_d_ZSTD_frameHeaderSize },
  { "ZSTD_freeCCtx", (void *)_cffi_f_ZSTD_freeCCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 106), (void *)_cffi_d_ZSTD_freeCCtx },
  { "ZSTD_freeCCtxParams", (void *)_cffi_f_ZSTD_freeCCtxParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 286), (void *)_cffi_d_ZSTD_freeCCtxParams },
  { "ZSTD_freeCDict", (void *)_cffi_f_ZSTD_freeCDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 310), (void *)_cffi_d_ZSTD_freeCDict },
  { "ZSTD_freeCStream", (void *)_cffi_f_ZSTD_freeCStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 106), (void *)_cffi_d_ZSTD_freeCStream },
  { "ZSTD_freeDCtx", (void *)_cffi_f_ZSTD_freeDCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 316), (void *)_cffi_d_ZSTD_freeDCtx },
  { "ZSTD_freeDDict", (void *)_cffi_f_ZSTD_freeDDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 404), (void *)_cffi_d_ZSTD_freeDDict },
  { "ZSTD_freeDStream", (void *)_cffi_f_ZSTD_freeDStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 316), (void *)_cffi_d_ZSTD_freeDStream },
  { "ZSTD_freeThreadPool", (void *)_cffi_f_ZSTD_freeThreadPool, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 569), (void *)_cffi_d_ZSTD_freeThreadPool },
  { "ZSTD_generateSequences", (void *)_cffi_f_ZSTD_generateSequences, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 132), (void *)_cffi_d_ZSTD_generateSequences },
  { "ZSTD_getBlockSize", (void *)_cffi_f_ZSTD_getBlockSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 278), (void *)_cffi_d_ZSTD_getBlockSize },
  { "ZSTD_getCParams", (void *)_cffi_f_ZSTD_getCParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 80), (void *)_cffi_d_ZSTD_getCParams },
  { "ZSTD_getDecompressedSize", (void *)_cffi_f_ZSTD_getDecompressedSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 557), (void *)_cffi_d_ZSTD_getDecompressedSize },
  { "ZSTD_getDictID_fromCDict", (void *)_cffi_f_ZSTD_getDictID_fromCDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 542), (void *)_cffi_d_ZSTD_getDictID_fromCDict },
  { "ZSTD_getDictID_fromDDict", (void *)_cffi_f_ZSTD_getDictID_fromDDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 545), (void *)_cffi_d_ZSTD_getDictID_fromDDict },
  { "ZSTD_getDictID_fromDict", (void *)_cffi_f_ZSTD_getDictID_fromDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 551), (void *)_cffi_d_ZSTD_getDictID_fromDict },
  { "ZSTD_getDictID_fromFrame", (void *)_cffi_f_ZSTD_getDictID_fromFrame, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 551), (void *)_cffi_d_ZSTD_getDictID_fromFrame },
  { "ZSTD_getErrorName", (void *)_cffi_f_ZSTD_getErrorName, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 99), (void *)_cffi_d_ZSTD_getErrorName },
  { "ZSTD_getFrameContentSize", (void *)_cffi_f_ZSTD_getFrameContentSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 557), (void *)_cffi_d_ZSTD_getFrameContentSize },
  { "ZSTD_getFrameHeader", (void *)_cffi_f_ZSTD_getFrameHeader, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 417), (void *)_cffi_d_ZSTD_getFrameHeader },
  { "ZSTD_getFrameHeader_advanced", (void *)_cffi_f_ZSTD_getFrameHeader_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 422), (void *)_cffi_d_ZSTD_getFrameHeader_advanced },
  { "ZSTD_getFrameProgression", (void *)_cffi_f_ZSTD_getFrameProgression, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 85), (void *)_cffi_d_ZSTD_getFrameProgression },
  { "ZSTD_getParams", (void *)_cffi_f_ZSTD_getParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 91), (void *)_cffi_d_ZSTD_getParams },
  { "ZSTD_greedy", (void *)_cffi_const_ZSTD_greedy, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_initCStream", (void *)_cffi_f_ZSTD_initCStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 163), (void *)_cffi_d_ZSTD_initCStream },
  { "ZSTD_initCStream_advanced", (void *)_cffi_f_ZSTD_initCStream_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 265), (void *)_cffi_d_ZSTD_initCStream_advanced },
  { "ZSTD_initCStream_srcSize", (void *)_cffi_f_ZSTD_initCStream_srcSize, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 167), (void *)_cffi_d_ZSTD_initCStream_srcSize },
  { "ZSTD_initCStream_usingCDict", (void *)_cffi_f_ZSTD_initCStream_usingCDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 118), (void *)_cffi_d_ZSTD_initCStream_usingCDict },
  { "ZSTD_initCStream_usingCDict_advanced", (void *)_cffi_f_ZSTD_initCStream_usingCDict_advanced, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 122), (void *)_cffi_d_ZSTD_initCStream_usingCDict_advanced },
  { "ZSTD_initCStream_usingDict", (void *)_cffi_f_ZSTD_initCStream_usingDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 272), (void *)_cffi_d_ZSTD_initCStream_usingDict },
  { "ZSTD_initDStream", (void *)_cffi_f_ZSTD_initDStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 316), (void *)_cffi_d_ZSTD_initDStream },
  { "ZSTD_initDStream_usingDDict", (void *)_cffi_f_ZSTD_initDStream_usingDDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 319), (void *)_cffi_d_ZSTD_initDStream_usingDDict },
  { "ZSTD_initDStream_usingDict", (void *)_cffi_f_ZSTD_initDStream_usingDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 383), (void *)_cffi_d_ZSTD_initDStream_usingDict },
  { "ZSTD_initStaticCCtx", (void *)_cffi_f_ZSTD_initStaticCCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 3), (void *)_cffi_d_ZSTD_initStaticCCtx },
  { "ZSTD_initStaticCDict", (void *)_cffi_f_ZSTD_initStaticCDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 32), (void *)_cffi_d_ZSTD_initStaticCDict },
  { "ZSTD_initStaticCStream", (void *)_cffi_f_ZSTD_initStaticCStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 3), (void *)_cffi_d_ZSTD_initStaticCStream },
  { "ZSTD_initStaticDCtx", (void *)_cffi_f_ZSTD_initStaticDCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 44), (void *)_cffi_d_ZSTD_initStaticDCtx },
  { "ZSTD_initStaticDDict", (void *)_cffi_f_ZSTD_initStaticDDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 61), (void *)_cffi_d_ZSTD_initStaticDDict },
  { "ZSTD_initStaticDStream", (void *)_cffi_f_ZSTD_initStaticDStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 44), (void *)_cffi_d_ZSTD_initStaticDStream },
  { "ZSTD_insertBlock", (void *)_cffi_f_ZSTD_insertBlock, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 383), (void *)_cffi_d_ZSTD_insertBlock },
  { "ZSTD_isError", (void *)_cffi_f_ZSTD_isError, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 548), (void *)_cffi_d_ZSTD_isError },
  { "ZSTD_isFrame", (void *)_cffi_f_ZSTD_isFrame, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 551), (void *)_cffi_d_ZSTD_isFrame },
  { "ZSTD_lazy", (void *)_cffi_const_ZSTD_lazy, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_lazy2", (void *)_cffi_const_ZSTD_lazy2, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_lcm_auto", (void *)_cffi_const_ZSTD_lcm_auto, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_lcm_huffman", (void *)_cffi_const_ZSTD_lcm_huffman, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_lcm_uncompressed", (void *)_cffi_const_ZSTD_lcm_uncompressed, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_maxCLevel", (void *)_cffi_f_ZSTD_maxCLevel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 104), (void *)_cffi_d_ZSTD_maxCLevel },
  { "ZSTD_mergeBlockDelimiters", (void *)_cffi_f_ZSTD_mergeBlockDelimiters, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 410), (void *)_cffi_d_ZSTD_mergeBlockDelimiters },
  { "ZSTD_minCLevel", (void *)_cffi_f_ZSTD_minCLevel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 104), (void *)_cffi_d_ZSTD_minCLevel },
  { "ZSTD_nextInputType", (void *)_cffi_f_ZSTD_nextInputType, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 88), (void *)_cffi_d_ZSTD_nextInputType },
  { "ZSTD_nextSrcSizeToDecompress", (void *)_cffi_f_ZSTD_nextSrcSizeToDecompress, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 316), (void *)_cffi_d_ZSTD_nextSrcSizeToDecompress },
  { "ZSTD_resetCStream", (void *)_cffi_f_ZSTD_resetCStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 172), (void *)_cffi_d_ZSTD_resetCStream },
  { "ZSTD_resetDStream", (void *)_cffi_f_ZSTD_resetDStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 316), (void *)_cffi_d_ZSTD_resetDStream },
  { "ZSTD_reset_parameters", (void *)_cffi_const_ZSTD_reset_parameters, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_reset_session_and_parameters", (void *)_cffi_const_ZSTD_reset_session_and_parameters, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_reset_session_only", (void *)_cffi_const_ZSTD_reset_session_only, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_rmd_refMultipleDDicts", (void *)_cffi_const_ZSTD_rmd_refMultipleDDicts, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_rmd_refSingleDDict", (void *)_cffi_const_ZSTD_rmd_refSingleDDict, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_sf_explicitBlockDelimiters", (void *)_cffi_const_ZSTD_sf_explicitBlockDelimiters, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_sf_noBlockDelimiters", (void *)_cffi_const_ZSTD_sf_noBlockDelimiters, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_sizeof_CCtx", (void *)_cffi_f_ZSTD_sizeof_CCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 278), (void *)_cffi_d_ZSTD_sizeof_CCtx },
  { "ZSTD_sizeof_CDict", (void *)_cffi_f_ZSTD_sizeof_CDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 313), (void *)_cffi_d_ZSTD_sizeof_CDict },
  { "ZSTD_sizeof_CStream", (void *)_cffi_f_ZSTD_sizeof_CStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 278), (void *)_cffi_d_ZSTD_sizeof_CStream },
  { "ZSTD_sizeof_DCtx", (void *)_cffi_f_ZSTD_sizeof_DCtx, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 401), (void *)_cffi_d_ZSTD_sizeof_DCtx },
  { "ZSTD_sizeof_DDict", (void *)_cffi_f_ZSTD_sizeof_DDict, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 407), (void *)_cffi_d_ZSTD_sizeof_DDict },
  { "ZSTD_sizeof_DStream", (void *)_cffi_f_ZSTD_sizeof_DStream, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 401), (void *)_cffi_d_ZSTD_sizeof_DStream },
  { "ZSTD_skippableFrame", (void *)_cffi_const_ZSTD_skippableFrame, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_toFlushNow", (void *)_cffi_f_ZSTD_toFlushNow, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 106), (void *)_cffi_d_ZSTD_toFlushNow },
  { "ZSTD_urm_auto", (void *)_cffi_const_ZSTD_urm_auto, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_urm_disableRowMatchFinder", (void *)_cffi_const_ZSTD_urm_disableRowMatchFinder, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_urm_enableRowMatchFinder", (void *)_cffi_const_ZSTD_urm_enableRowMatchFinder, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTD_versionNumber", (void *)_cffi_f_ZSTD_versionNumber, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 555), (void *)_cffi_d_ZSTD_versionNumber },
  { "ZSTD_versionString", (void *)_cffi_f_ZSTD_versionString, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 102), (void *)_cffi_d_ZSTD_versionString },
  { "ZSTD_writeSkippableFrame", (void *)_cffi_f_ZSTD_writeSkippableFrame, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 519), (void *)_cffi_d_ZSTD_writeSkippableFrame },
  { "ZSTDnit_block", (void *)_cffi_const_ZSTDnit_block, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTDnit_blockHeader", (void *)_cffi_const_ZSTDnit_blockHeader, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTDnit_checksum", (void *)_cffi_const_ZSTDnit_checksum, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTDnit_frameHeader", (void *)_cffi_const_ZSTDnit_frameHeader, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTDnit_lastBlock", (void *)_cffi_const_ZSTDnit_lastBlock, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ZSTDnit_skippableFrame", (void *)_cffi_const_ZSTDnit_skippableFrame, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "k", offsetof(ZDICT_cover_params_t, k),
         sizeof(((ZDICT_cover_params_t *)0)->k),
         _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "d", offsetof(ZDICT_cover_params_t, d),
         sizeof(((ZDICT_cover_params_t *)0)->d),
         _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "steps", offsetof(ZDICT_cover_params_t, steps),
             sizeof(((ZDICT_cover_params_t *)0)->steps),
             _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "nbThreads", offsetof(ZDICT_cover_params_t, nbThreads),
                 sizeof(((ZDICT_cover_params_t *)0)->nbThreads),
                 _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "splitPoint", offsetof(ZDICT_cover_params_t, splitPoint),
                  sizeof(((ZDICT_cover_params_t *)0)->splitPoint),
                  _CFFI_OP(_CFFI_OP_NOOP, 599) },
  { "shrinkDict", offsetof(ZDICT_cover_params_t, shrinkDict),
                  sizeof(((ZDICT_cover_params_t *)0)->shrinkDict),
                  _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "shrinkDictMaxRegression", offsetof(ZDICT_cover_params_t, shrinkDictMaxRegression),
                               sizeof(((ZDICT_cover_params_t *)0)->shrinkDictMaxRegression),
                               _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "zParams", offsetof(ZDICT_cover_params_t, zParams),
               sizeof(((ZDICT_cover_params_t *)0)->zParams),
               _CFFI_OP(_CFFI_OP_NOOP, 534) },
  { "k", offsetof(ZDICT_fastCover_params_t, k),
         sizeof(((ZDICT_fastCover_params_t *)0)->k),
         _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "d", offsetof(ZDICT_fastCover_params_t, d),
         sizeof(((ZDICT_fastCover_params_t *)0)->d),
         _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "f", offsetof(ZDICT_fastCover_params_t, f),
         sizeof(((ZDICT_fastCover_params_t *)0)->f),
         _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "steps", offsetof(ZDICT_fastCover_params_t, steps),
             sizeof(((ZDICT_fastCover_params_t *)0)->steps),
             _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "nbThreads", offsetof(ZDICT_fastCover_params_t, nbThreads),
                 sizeof(((ZDICT_fastCover_params_t *)0)->nbThreads),
                 _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "splitPoint", offsetof(ZDICT_fastCover_params_t, splitPoint),
                  sizeof(((ZDICT_fastCover_params_t *)0)->splitPoint),
                  _CFFI_OP(_CFFI_OP_NOOP, 599) },
  { "accel", offsetof(ZDICT_fastCover_params_t, accel),
             sizeof(((ZDICT_fastCover_params_t *)0)->accel),
             _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "shrinkDict", offsetof(ZDICT_fastCover_params_t, shrinkDict),
                  sizeof(((ZDICT_fastCover_params_t *)0)->shrinkDict),
                  _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "shrinkDictMaxRegression", offsetof(ZDICT_fastCover_params_t, shrinkDictMaxRegression),
                               sizeof(((ZDICT_fastCover_params_t *)0)->shrinkDictMaxRegression),
                               _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "zParams", offsetof(ZDICT_fastCover_params_t, zParams),
               sizeof(((ZDICT_fastCover_params_t *)0)->zParams),
               _CFFI_OP(_CFFI_OP_NOOP, 534) },
  { "selectivityLevel", offsetof(ZDICT_legacy_params_t, selectivityLevel),
                        sizeof(((ZDICT_legacy_params_t *)0)->selectivityLevel),
                        _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "zParams", offsetof(ZDICT_legacy_params_t, zParams),
               sizeof(((ZDICT_legacy_params_t *)0)->zParams),
               _CFFI_OP(_CFFI_OP_NOOP, 534) },
  { "compressionLevel", offsetof(ZDICT_params_t, compressionLevel),
                        sizeof(((ZDICT_params_t *)0)->compressionLevel),
                        _CFFI_OP(_CFFI_OP_NOOP, 30) },
  { "notificationLevel", offsetof(ZDICT_params_t, notificationLevel),
                         sizeof(((ZDICT_params_t *)0)->notificationLevel),
                         _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "dictID", offsetof(ZDICT_params_t, dictID),
              sizeof(((ZDICT_params_t *)0)->dictID),
              _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "offset", offsetof(ZSTD_Sequence, offset),
              sizeof(((ZSTD_Sequence *)0)->offset),
              _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "litLength", offsetof(ZSTD_Sequence, litLength),
                 sizeof(((ZSTD_Sequence *)0)->litLength),
                 _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "matchLength", offsetof(ZSTD_Sequence, matchLength),
                   sizeof(((ZSTD_Sequence *)0)->matchLength),
                   _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "rep", offsetof(ZSTD_Sequence, rep),
           sizeof(((ZSTD_Sequence *)0)->rep),
           _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "error", offsetof(ZSTD_bounds, error),
             sizeof(((ZSTD_bounds *)0)->error),
             _CFFI_OP(_CFFI_OP_NOOP, 5) },
  { "lowerBound", offsetof(ZSTD_bounds, lowerBound),
                  sizeof(((ZSTD_bounds *)0)->lowerBound),
                  _CFFI_OP(_CFFI_OP_NOOP, 30) },
  { "upperBound", offsetof(ZSTD_bounds, upperBound),
                  sizeof(((ZSTD_bounds *)0)->upperBound),
                  _CFFI_OP(_CFFI_OP_NOOP, 30) },
  { "windowLog", offsetof(ZSTD_compressionParameters, windowLog),
                 sizeof(((ZSTD_compressionParameters *)0)->windowLog),
                 _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "chainLog", offsetof(ZSTD_compressionParameters, chainLog),
                sizeof(((ZSTD_compressionParameters *)0)->chainLog),
                _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "hashLog", offsetof(ZSTD_compressionParameters, hashLog),
               sizeof(((ZSTD_compressionParameters *)0)->hashLog),
               _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "searchLog", offsetof(ZSTD_compressionParameters, searchLog),
                 sizeof(((ZSTD_compressionParameters *)0)->searchLog),
                 _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "minMatch", offsetof(ZSTD_compressionParameters, minMatch),
                sizeof(((ZSTD_compressionParameters *)0)->minMatch),
                _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "targetLength", offsetof(ZSTD_compressionParameters, targetLength),
                    sizeof(((ZSTD_compressionParameters *)0)->targetLength),
                    _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "strategy", offsetof(ZSTD_compressionParameters, strategy),
                sizeof(((ZSTD_compressionParameters *)0)->strategy),
                _CFFI_OP(_CFFI_OP_NOOP, 594) },
  { "customAlloc", offsetof(ZSTD_customMem, customAlloc),
                   sizeof(((ZSTD_customMem *)0)->customAlloc),
                   _CFFI_OP(_CFFI_OP_NOOP, 600) },
  { "customFree", offsetof(ZSTD_customMem, customFree),
                  sizeof(((ZSTD_customMem *)0)->customFree),
                  _CFFI_OP(_CFFI_OP_NOOP, 601) },
  { "opaque", offsetof(ZSTD_customMem, opaque),
              sizeof(((ZSTD_customMem *)0)->opaque),
              _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "frameContentSize", offsetof(ZSTD_frameHeader, frameContentSize),
                        sizeof(((ZSTD_frameHeader *)0)->frameContentSize),
                        _CFFI_OP(_CFFI_OP_NOOP, 77) },
  { "windowSize", offsetof(ZSTD_frameHeader, windowSize),
                  sizeof(((ZSTD_frameHeader *)0)->windowSize),
                  _CFFI_OP(_CFFI_OP_NOOP, 77) },
  { "blockSizeMax", offsetof(ZSTD_frameHeader, blockSizeMax),
                    sizeof(((ZSTD_frameHeader *)0)->blockSizeMax),
                    _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "frameType", offsetof(ZSTD_frameHeader, frameType),
                 sizeof(((ZSTD_frameHeader *)0)->frameType),
                 _CFFI_OP(_CFFI_OP_NOOP, 587) },
  { "headerSize", offsetof(ZSTD_frameHeader, headerSize),
                  sizeof(((ZSTD_frameHeader *)0)->headerSize),
                  _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "dictID", offsetof(ZSTD_frameHeader, dictID),
              sizeof(((ZSTD_frameHeader *)0)->dictID),
              _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "checksumFlag", offsetof(ZSTD_frameHeader, checksumFlag),
                    sizeof(((ZSTD_frameHeader *)0)->checksumFlag),
                    _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "contentSizeFlag", offsetof(ZSTD_frameParameters, contentSizeFlag),
                       sizeof(((ZSTD_frameParameters *)0)->contentSizeFlag),
                       _CFFI_OP(_CFFI_OP_NOOP, 30) },
  { "checksumFlag", offsetof(ZSTD_frameParameters, checksumFlag),
                    sizeof(((ZSTD_frameParameters *)0)->checksumFlag),
                    _CFFI_OP(_CFFI_OP_NOOP, 30) },
  { "noDictIDFlag", offsetof(ZSTD_frameParameters, noDictIDFlag),
                    sizeof(((ZSTD_frameParameters *)0)->noDictIDFlag),
                    _CFFI_OP(_CFFI_OP_NOOP, 30) },
  { "ingested", offsetof(ZSTD_frameProgression, ingested),
                sizeof(((ZSTD_frameProgression *)0)->ingested),
                _CFFI_OP(_CFFI_OP_NOOP, 77) },
  { "consumed", offsetof(ZSTD_frameProgression, consumed),
                sizeof(((ZSTD_frameProgression *)0)->consumed),
                _CFFI_OP(_CFFI_OP_NOOP, 77) },
  { "produced", offsetof(ZSTD_frameProgression, produced),
                sizeof(((ZSTD_frameProgression *)0)->produced),
                _CFFI_OP(_CFFI_OP_NOOP, 77) },
  { "flushed", offsetof(ZSTD_frameProgression, flushed),
               sizeof(((ZSTD_frameProgression *)0)->flushed),
               _CFFI_OP(_CFFI_OP_NOOP, 77) },
  { "currentJobID", offsetof(ZSTD_frameProgression, currentJobID),
                    sizeof(((ZSTD_frameProgression *)0)->currentJobID),
                    _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "nbActiveWorkers", offsetof(ZSTD_frameProgression, nbActiveWorkers),
                       sizeof(((ZSTD_frameProgression *)0)->nbActiveWorkers),
                       _CFFI_OP(_CFFI_OP_NOOP, 457) },
  { "cParams", offsetof(ZSTD_parameters, cParams),
               sizeof(((ZSTD_parameters *)0)->cParams),
               _CFFI_OP(_CFFI_OP_NOOP, 24) },
  { "fParams", offsetof(ZSTD_parameters, fParams),
               sizeof(((ZSTD_parameters *)0)->fParams),
               _CFFI_OP(_CFFI_OP_NOOP, 125) },
  { "src", offsetof(ZSTD_inBuffer, src),
           sizeof(((ZSTD_inBuffer *)0)->src),
           _CFFI_OP(_CFFI_OP_NOOP, 12) },
  { "size", offsetof(ZSTD_inBuffer, size),
            sizeof(((ZSTD_inBuffer *)0)->size),
            _CFFI_OP(_CFFI_OP_NOOP, 5) },
  { "pos", offsetof(ZSTD_inBuffer, pos),
           sizeof(((ZSTD_inBuffer *)0)->pos),
           _CFFI_OP(_CFFI_OP_NOOP, 5) },
  { "dst", offsetof(ZSTD_outBuffer, dst),
           sizeof(((ZSTD_outBuffer *)0)->dst),
           _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "size", offsetof(ZSTD_outBuffer, size),
            sizeof(((ZSTD_outBuffer *)0)->size),
            _CFFI_OP(_CFFI_OP_NOOP, 5) },
  { "pos", offsetof(ZSTD_outBuffer, pos),
           sizeof(((ZSTD_outBuffer *)0)->pos),
           _CFFI_OP(_CFFI_OP_NOOP, 5) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$ZDICT_cover_params_t", 480, _CFFI_F_CHECK_FIELDS,
    sizeof(ZDICT_cover_params_t), offsetof(struct _cffi_align_typedef_ZDICT_cover_params_t, y), 0, 8 },
  { "$ZDICT_fastCover_params_t", 496, _CFFI_F_CHECK_FIELDS,
    sizeof(ZDICT_fastCover_params_t), offsetof(struct _cffi_align_typedef_ZDICT_fastCover_params_t, y), 8, 10 },
  { "$ZDICT_legacy_params_t", 504, _CFFI_F_CHECK_FIELDS,
    sizeof(ZDICT_legacy_params_t), offsetof(struct _cffi_align_typedef_ZDICT_legacy_params_t, y), 18, 2 },
  { "$ZDICT_params_t", 534, _CFFI_F_CHECK_FIELDS,
    sizeof(ZDICT_params_t), offsetof(struct _cffi_align_typedef_ZDICT_params_t, y), 20, 3 },
  { "$ZSTD_Sequence", 581, _CFFI_F_CHECK_FIELDS,
    sizeof(ZSTD_Sequence), offsetof(struct _cffi_align_typedef_ZSTD_Sequence, y), 23, 4 },
  { "$ZSTD_bounds", 582, _CFFI_F_CHECK_FIELDS,
    sizeof(ZSTD_bounds), offsetof(struct _cffi_align_typedef_ZSTD_bounds, y), 27, 3 },
  { "$ZSTD_compressionParameters", 24, _CFFI_F_CHECK_FIELDS,
    sizeof(ZSTD_compressionParameters), offsetof(struct _cffi_align_typedef_ZSTD_compressionParameters, y), 30, 7 },
  { "$ZSTD_customMem", 1, _CFFI_F_CHECK_FIELDS,
    sizeof(ZSTD_customMem), offsetof(struct _cffi_align_typedef_ZSTD_customMem, y), 37, 3 },
  { "$ZSTD_frameHeader", 585, _CFFI_F_CHECK_FIELDS,
    sizeof(ZSTD_frameHeader), offsetof(struct _cffi_align_typedef_ZSTD_frameHeader, y), 40, 7 },
  { "$ZSTD_frameParameters", 125, _CFFI_F_CHECK_FIELDS,
    sizeof(ZSTD_frameParameters), offsetof(struct _cffi_align_typedef_ZSTD_frameParameters, y), 47, 3 },
  { "$ZSTD_frameProgression", 586, _CFFI_F_CHECK_FIELDS,
    sizeof(ZSTD_frameProgression), offsetof(struct _cffi_align_typedef_ZSTD_frameProgression, y), 50, 6 },
  { "$ZSTD_parameters", 235, _CFFI_F_CHECK_FIELDS,
    sizeof(ZSTD_parameters), offsetof(struct _cffi_align_typedef_ZSTD_parameters, y), 56, 2 },
  { "POOL_ctx_s", 595, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "ZSTD_CCtx_params_s", 577, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "ZSTD_CCtx_s", 576, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "ZSTD_CDict_s", 578, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "ZSTD_DCtx_s", 579, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "ZSTD_DDict_s", 580, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "ZSTD_inBuffer_s", 588, _CFFI_F_CHECK_FIELDS,
    sizeof(ZSTD_inBuffer), offsetof(struct _cffi_align__ZSTD_inBuffer, y), 58, 3 },
  { "ZSTD_outBuffer_s", 591, _CFFI_F_CHECK_FIELDS,
    sizeof(ZSTD_outBuffer), offsetof(struct _cffi_align__ZSTD_outBuffer, y), 61, 3 },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "$ZSTD_EndDirective", 157, _cffi_prim_int(sizeof(ZSTD_EndDirective), ((ZSTD_EndDirective)-1) <= 0),
    "ZSTD_e_continue,ZSTD_e_flush,ZSTD_e_end" },
  { "$ZSTD_ResetDirective", 130, _cffi_prim_int(sizeof(ZSTD_ResetDirective), ((ZSTD_ResetDirective)-1) <= 0),
    "ZSTD_reset_session_only,ZSTD_reset_parameters,ZSTD_reset_session_and_parameters" },
  { "$ZSTD_cParameter", 70, _cffi_prim_int(sizeof(ZSTD_cParameter), ((ZSTD_cParameter)-1) <= 0),
    "ZSTD_c_compressionLevel,ZSTD_c_windowLog,ZSTD_c_hashLog,ZSTD_c_chainLog,ZSTD_c_searchLog,ZSTD_c_minMatch,ZSTD_c_targetLength,ZSTD_c_strategy,ZSTD_c_enableLongDistanceMatching,ZSTD_c_ldmHashLog,ZSTD_c_ldmMinMatch,ZSTD_c_ldmBucketSizeLog,ZSTD_c_ldmHashRateLog,ZSTD_c_contentSizeFlag,ZSTD_c_checksumFlag,ZSTD_c_dictIDFlag,ZSTD_c_nbWorkers,ZSTD_c_jobSize,ZSTD_c_overlapLog,ZSTD_c_experimentalParam1,ZSTD_c_experimentalParam2,ZSTD_c_experimentalParam3,ZSTD_c_experimentalParam4,ZSTD_c_experimentalParam5,ZSTD_c_experimentalParam6,ZSTD_c_experimentalParam7,ZSTD_c_experimentalParam8,ZSTD_c_experimentalParam9,ZSTD_c_experimentalParam10,ZSTD_c_experimentalParam11,ZSTD_c_experimentalParam12,ZSTD_c_experimentalParam13,ZSTD_c_experimentalParam14,ZSTD_c_experimentalParam15" },
  { "$ZSTD_dParameter", 73, _cffi_prim_int(sizeof(ZSTD_dParameter), ((ZSTD_dParameter)-1) <= 0),
    "ZSTD_d_windowLogMax,ZSTD_d_experimentalParam1,ZSTD_d_experimentalParam2,ZSTD_d_experimentalParam3,ZSTD_d_experimentalParam4" },
  { "$ZSTD_dictAttachPref_e", 583, _cffi_prim_int(sizeof(ZSTD_dictAttachPref_e), ((ZSTD_dictAttachPref_e)-1) <= 0),
    "ZSTD_dictDefaultAttach,ZSTD_dictForceAttach,ZSTD_dictForceCopy,ZSTD_dictForceLoad" },
  { "$ZSTD_dictContentType_e", 15, _cffi_prim_int(sizeof(ZSTD_dictContentType_e), ((ZSTD_dictContentType_e)-1) <= 0),
    "ZSTD_dct_auto,ZSTD_dct_rawContent,ZSTD_dct_fullDict" },
  { "$ZSTD_dictLoadMethod_e", 14, _cffi_prim_int(sizeof(ZSTD_dictLoadMethod_e), ((ZSTD_dictLoadMethod_e)-1) <= 0),
    "ZSTD_dlm_byCopy,ZSTD_dlm_byRef" },
  { "$ZSTD_forceIgnoreChecksum_e", 584, _cffi_prim_int(sizeof(ZSTD_forceIgnoreChecksum_e), ((ZSTD_forceIgnoreChecksum_e)-1) <= 0),
    "ZSTD_d_validateChecksum,ZSTD_d_ignoreChecksum" },
  { "$ZSTD_format_e", 339, _cffi_prim_int(sizeof(ZSTD_format_e), ((ZSTD_format_e)-1) <= 0),
    "ZSTD_f_zstd1,ZSTD_f_zstd1_magicless" },
  { "$ZSTD_frameType_e", 587, _cffi_prim_int(sizeof(ZSTD_frameType_e), ((ZSTD_frameType_e)-1) <= 0),
    "ZSTD_frame,ZSTD_skippableFrame" },
  { "$ZSTD_literalCompressionMode_e", 589, _cffi_prim_int(sizeof(ZSTD_literalCompressionMode_e), ((ZSTD_literalCompressionMode_e)-1) <= 0),
    "ZSTD_lcm_auto,ZSTD_lcm_huffman,ZSTD_lcm_uncompressed" },
  { "$ZSTD_nextInputType_e", 590, _cffi_prim_int(sizeof(ZSTD_nextInputType_e), ((ZSTD_nextInputType_e)-1) <= 0),
    "ZSTDnit_frameHeader,ZSTDnit_blockHeader,ZSTDnit_block,ZSTDnit_lastBlock,ZSTDnit_checksum,ZSTDnit_skippableFrame" },
  { "$ZSTD_refMultipleDDicts_e", 592, _cffi_prim_int(sizeof(ZSTD_refMultipleDDicts_e), ((ZSTD_refMultipleDDicts_e)-1) <= 0),
    "ZSTD_rmd_refSingleDDict,ZSTD_rmd_refMultipleDDicts" },
  { "$ZSTD_sequenceFormat_e", 593, _cffi_prim_int(sizeof(ZSTD_sequenceFormat_e), ((ZSTD_sequenceFormat_e)-1) <= 0),
    "ZSTD_sf_noBlockDelimiters,ZSTD_sf_explicitBlockDelimiters" },
  { "$ZSTD_strategy", 594, _cffi_prim_int(sizeof(ZSTD_strategy), ((ZSTD_strategy)-1) <= 0),
    "ZSTD_fast,ZSTD_dfast,ZSTD_greedy,ZSTD_lazy,ZSTD_lazy2,ZSTD_btlazy2,ZSTD_btopt,ZSTD_btultra,ZSTD_btultra2" },
  { "$ZSTD_useRowMatchFinderMode_e", 596, _cffi_prim_int(sizeof(ZSTD_useRowMatchFinderMode_e), ((ZSTD_useRowMatchFinderMode_e)-1) <= 0),
    "ZSTD_urm_auto,ZSTD_urm_disableRowMatchFinder,ZSTD_urm_enableRowMatchFinder" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "ZDICT_cover_params_t", 480 },
  { "ZDICT_fastCover_params_t", 496 },
  { "ZDICT_legacy_params_t", 504 },
  { "ZDICT_params_t", 534 },
  { "ZSTD_CCtx", 576 },
  { "ZSTD_CCtx_params", 577 },
  { "ZSTD_CDict", 578 },
  { "ZSTD_CStream", 576 },
  { "ZSTD_DCtx", 579 },
  { "ZSTD_DDict", 580 },
  { "ZSTD_DStream", 579 },
  { "ZSTD_EndDirective", 157 },
  { "ZSTD_ResetDirective", 130 },
  { "ZSTD_Sequence", 581 },
  { "ZSTD_allocFunction", 600 },
  { "ZSTD_bounds", 582 },
  { "ZSTD_cParameter", 70 },
  { "ZSTD_compressionParameters", 24 },
  { "ZSTD_customMem", 1 },
  { "ZSTD_dParameter", 73 },
  { "ZSTD_dictAttachPref_e", 583 },
  { "ZSTD_dictContentType_e", 15 },
  { "ZSTD_dictLoadMethod_e", 14 },
  { "ZSTD_forceIgnoreChecksum_e", 584 },
  { "ZSTD_format_e", 339 },
  { "ZSTD_frameHeader", 585 },
  { "ZSTD_frameParameters", 125 },
  { "ZSTD_frameProgression", 586 },
  { "ZSTD_frameType_e", 587 },
  { "ZSTD_freeFunction", 601 },
  { "ZSTD_inBuffer", 588 },
  { "ZSTD_literalCompressionMode_e", 589 },
  { "ZSTD_nextInputType_e", 590 },
  { "ZSTD_outBuffer", 591 },
  { "ZSTD_parameters", 235 },
  { "ZSTD_refMultipleDDicts_e", 592 },
  { "ZSTD_sequenceFormat_e", 593 },
  { "ZSTD_strategy", 594 },
  { "ZSTD_threadPool", 595 },
  { "ZSTD_useRowMatchFinderMode_e", 596 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  330,  /* num_globals */
  20,  /* num_struct_unions */
  16,  /* num_enums */
  40,  /* num_typenames */
  NULL,  /* no includes */
  603,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__cffi(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__cffi(void) { return NULL; }
#  else
     init_cffi(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__cffi(void)
{
  return _cffi_init("zstandard._cffi", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_cffi(void)
{
  _cffi_init("zstandard._cffi", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
