/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* RISCVPreLegalizerCombinerImpl Combiner Match Table                         *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GICOMBINER_DEPS
#include "llvm/ADT/SparseBitVector.h"
namespace llvm {
extern cl::OptionCategory GICombinerOptionCategory;
} // end namespace llvm
#endif // ifdef GET_GICOMBINER_DEPS

#ifdef GET_GICOMBINER_TYPES
struct RISCVPreLegalizerCombinerImplRuleConfig {
  SparseBitVector<> DisabledRules;

  bool isRuleEnabled(unsigned RuleID) const;
  bool parseCommandLineOption();
  bool setRuleEnabled(StringRef RuleIdentifier);
  bool setRuleDisabled(StringRef RuleIdentifier);
};

static std::optional<uint64_t> getRuleIdxForIdentifier(StringRef RuleIdentifier) {
  uint64_t I;
  // getAtInteger(...) returns false on success
  bool Parsed = !RuleIdentifier.getAsInteger(0, I);
  if (Parsed)
    return I;

#ifndef NDEBUG
  switch (RuleIdentifier.size()) {
  default: break;
  case 9:	 // 5 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "opy_prop", 8) != 0)
        break;
      return 13;	 // "copy_prop"
    case 'm':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "tch_ors", 7) != 0)
          break;
        return 194;	 // "match_ors"
      case 'u':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "lo_by_", 6) != 0)
          break;
        switch (RuleIdentifier[8]) {
        default: break;
        case '0':	 // 1 string to match.
          return 144;	 // "mulo_by_0"
        case '2':	 // 1 string to match.
          return 143;	 // "mulo_by_2"
        }
        break;
      }
      break;
    case 'n':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "neg_zext", 8) != 0)
        break;
      return 199;	 // "nneg_zext"
    }
    break;
  case 10:	 // 7 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "2p_to_p2i", 9) != 0)
        break;
      return 89;	 // "i2p_to_p2i"
    case 'm':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "tch_ands", 8) != 0)
          break;
        return 193;	 // "match_ands"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "l_to_shl", 8) != 0)
          break;
        return 14;	 // "mul_to_shl"
      }
      break;
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "2i_to_i2p", 9) != 0)
        break;
      return 88;	 // "p2i_to_i2p"
    case 's':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "xt_trunc", 8) != 0)
          break;
        return 197;	 // "sext_trunc"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "b_to_add", 8) != 0)
          break;
        return 15;	 // "sub_to_add"
      }
      break;
    case 'z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_trunc", 9) != 0)
        break;
      return 198;	 // "zext_trunc"
    }
    break;
  case 11:	 // 5 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "dd_sub_reg", 10) != 0)
        break;
      return 94;	 // "add_sub_reg"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_addos", 10) != 0)
        break;
      return 213;	 // "match_addos"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ub_add_reg", 10) != 0)
        break;
      return 188;	 // "sub_add_reg"
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runc_shift", 10) != 0)
        break;
      return 131;	 // "trunc_shift"
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nmerge_cst", 10) != 0)
        break;
      return 207;	 // "unmerge_cst"
    }
    break;
  case 12:	 // 11 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'A':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "PlusBMinusB", 11) != 0)
        break;
      return 2;	 // "APlusBMinusB"
    case 'B':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "MinusAPlusA", 11) != 0)
        break;
      return 3;	 // "BMinusAPlusA"
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "dde_to_addo", 11) != 0)
        break;
      return 145;	 // "adde_to_addo"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "sub_to_fneg", 11) != 0)
        break;
      return 190;	 // "fsub_to_fneg"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ulh_to_lshr", 11) != 0)
        break;
      return 171;	 // "mulh_to_lshr"
    case 'n':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ot_cmp_fold", 11) != 0)
        break;
      return 132;	 // "not_cmp_fold"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "edundant_or", 11) != 0)
        break;
      return 127;	 // "redundant_or"
    case 's':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "iv_by_pow2", 10) != 0)
          break;
        return 185;	 // "sdiv_by_pow2"
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "xt_of_sext", 10) != 0)
          break;
        return 48;	 // "sext_of_sext"
      }
      break;
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "div_by_pow2", 11) != 0)
        break;
      return 184;	 // "udiv_by_pow2"
    case 'z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_of_zext", 11) != 0)
        break;
      return 46;	 // "zext_of_zext"
    }
    break;
  case 13:	 // 14 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "dd_of_vscale", 12) != 0)
        break;
      return 37;	 // "add_of_vscale"
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ommute_shift", 12) != 0)
        break;
      return 161;	 // "commute_shift"
    case 'l':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "oad_and_mask", 12) != 0)
        break;
      return 69;	 // "load_and_mask"
    case 'm':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "tch_selects", 11) != 0)
          break;
        return 124;	 // "match_selects"
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "rge_unmerge", 11) != 0)
          break;
        return 206;	 // "merge_unmerge"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "l_of_vscale", 11) != 0)
          break;
        return 38;	 // "mul_of_vscale"
      }
      break;
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "edundant_and", 12) != 0)
        break;
      return 125;	 // "redundant_and"
    case 's':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "iv_by_const", 11) != 0)
          break;
        return 187;	 // "sdiv_by_const"
      case 'h':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "l_of_vscale", 11) != 0)
          break;
        return 39;	 // "shl_of_vscale"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "b_of_vscale", 11) != 0)
          break;
        return 40;	 // "sub_of_vscale"
      }
      break;
    case 'u':	 // 4 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "iv_by_const", 11) != 0)
          break;
        return 186;	 // "udiv_by_const"
      case 'n':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "merge_", 6) != 0)
          break;
        switch (RuleIdentifier[8]) {
        default: break;
        case 'm':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+9, "erge", 4) != 0)
            break;
          return 205;	 // "unmerge_merge"
        case 'u':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+9, "ndef", 4) != 0)
            break;
          return 208;	 // "unmerge_undef"
        }
        break;
      case 'r':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "em_by_const", 11) != 0)
          break;
        return 183;	 // "urem_by_const"
      }
      break;
    }
    break;
  case 14:	 // 15 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'A':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'M':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "inusC1PlusC2", 12) != 0)
          break;
        return 12;	 // "AMinusC1PlusC2"
      case 'P':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "lusC1MinusC2", 12) != 0)
          break;
        return 8;	 // "APlusC1MinusC2"
      }
      break;
    case 'C':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "2MinusAPlusC1", 13) != 0)
        break;
      return 9;	 // "C2MinusAPlusC1"
    case 'a':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "nyext_of_", 9) != 0)
        break;
      switch (RuleIdentifier[10]) {
      default: break;
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+11, "ext", 3) != 0)
          break;
        return 52;	 // "anyext_of_sext"
      case 'z':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+11, "ext", 3) != 0)
          break;
        return 51;	 // "anyext_of_zext"
      }
      break;
    case 'b':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'i')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "op_same_val", 11) != 0)
          break;
        return 85;	 // "binop_same_val"
      case 't':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "reverse_shl", 11) != 0)
          break;
        return 159;	 // "bitreverse_shl"
      }
      break;
    case 'f':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "bs_fneg_fold", 12) != 0)
          break;
        return 170;	 // "fabs_fneg_fold"
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "eg_fneg_fold", 12) != 0)
          break;
        return 91;	 // "fneg_fneg_fold"
      }
      break;
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ul_by_neg_one", 13) != 0)
        break;
      return 17;	 // "mul_by_neg_one"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "eassoc_ptradd", 13) != 0)
        break;
      return 106;	 // "reassoc_ptradd"
    case 's':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 2 strings to match.
        switch (RuleIdentifier[2]) {
        default: break;
        case 'l':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+3, "ect_of_zext", 11) != 0)
            break;
          return 54;	 // "select_of_zext"
        case 'x':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+3, "t_of_anyext", 11) != 0)
            break;
          return 49;	 // "sext_of_anyext"
        }
        break;
      case 'h':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ifts_too_big", 12) != 0)
          break;
        return 105;	 // "shifts_too_big"
      }
      break;
    case 'z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_of_anyext", 13) != 0)
        break;
      return 47;	 // "zext_of_anyext"
    }
    break;
  case 15:	 // 12 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'A':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'M':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "inusC1MinusC2", 13) != 0)
          break;
        return 10;	 // "AMinusC1MinusC2"
      case 'P':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "lusZeroMinusB", 13) != 0)
          break;
        return 1;	 // "APlusZeroMinusB"
      }
      break;
    case 'C':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "1Minus2MinusC2", 14) != 0)
        break;
      return 11;	 // "C1Minus2MinusC2"
    case 'Z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "eroMinusAPlusB", 14) != 0)
        break;
      return 0;	 // "ZeroMinusAPlusB"
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "itreverse_lshr", 14) != 0)
        break;
      return 160;	 // "bitreverse_lshr"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtending_loads", 14) != 0)
        break;
      return 68;	 // "extending_loads"
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "dempotent_prop", 14) != 0)
        break;
      return 18;	 // "idempotent_prop"
    case 'l':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "oad_or_combine", 14) != 0)
        break;
      return 152;	 // "load_or_combine"
    case 'n':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "arrow_binop_or", 14) != 0)
        break;
      return 62;	 // "narrow_binop_or"
    case 'o':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "verlapping_and", 14) != 0)
        break;
      return 142;	 // "overlapping_and"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "elect_same_val", 14) != 0)
        break;
      return 83;	 // "select_same_val"
    case 'z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_trunc_fold", 14) != 0)
        break;
      return 129;	 // "zext_trunc_fold"
    }
    break;
  case 16:	 // 12 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nyext_of_anyext", 15) != 0)
        break;
      return 50;	 // "anyext_of_anyext"
    case 'n':	 // 5 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "arrow_binop_", 12) != 0)
        break;
      switch (RuleIdentifier[13]) {
      default: break;
      case 'a':	 // 2 strings to match.
        switch (RuleIdentifier[14]) {
        default: break;
        case 'd':	 // 1 string to match.
          if (RuleIdentifier[15] != 'd')
            break;
          return 58;	 // "narrow_binop_add"
        case 'n':	 // 1 string to match.
          if (RuleIdentifier[15] != 'd')
            break;
          return 61;	 // "narrow_binop_and"
        }
        break;
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+14, "ul", 2) != 0)
          break;
        return 60;	 // "narrow_binop_mul"
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+14, "ub", 2) != 0)
          break;
        return 59;	 // "narrow_binop_sub"
      case 'x':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+14, "or", 2) != 0)
          break;
        return 63;	 // "narrow_binop_xor"
      }
      break;
    case 's':	 // 3 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "elect_", 6) != 0)
        break;
      switch (RuleIdentifier[7]) {
      default: break;
      case 'o':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+8, "f_anyext", 8) != 0)
          break;
        return 55;	 // "select_of_anyext"
      case 't':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+8, "o_minmax", 8) != 0)
          break;
        return 189;	 // "select_to_minmax"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+8, "ndef_cmp", 8) != 0)
          break;
        return 121;	 // "select_undef_cmp"
      }
      break;
    case 't':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "runcate_of_", 11) != 0)
        break;
      switch (RuleIdentifier[12]) {
      default: break;
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+13, "ext", 3) != 0)
          break;
        return 44;	 // "truncate_of_sext"
      case 'z':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+13, "ext", 3) != 0)
          break;
        return 43;	 // "truncate_of_zext"
      }
      break;
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ndef_to_fp_zero", 15) != 0)
        break;
      return 71;	 // "undef_to_fp_zero"
    }
    break;
  case 17:	 // 14 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'A':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "PlusBMinus", 10) != 0)
        break;
      switch (RuleIdentifier[11]) {
      default: break;
      case 'A':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "plusC", 5) != 0)
          break;
        return 6;	 // "APlusBMinusAplusC"
      case 'C':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "PlusA", 5) != 0)
          break;
        return 7;	 // "APlusBMinusCPlusA"
      }
      break;
    case 'a':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "d_p2i_to_ptradd", 15) != 0)
          break;
        return 16;	 // "add_p2i_to_ptradd"
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "yext_trunc_fold", 15) != 0)
          break;
        return 90;	 // "anyext_trunc_fold"
      }
      break;
    case 'c':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "nonicalize_", 11) != 0)
          break;
        switch (RuleIdentifier[13]) {
        default: break;
        case 'f':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+14, "cmp", 3) != 0)
            break;
          return 110;	 // "canonicalize_fcmp"
        case 'i':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+14, "cmp", 3) != 0)
            break;
          return 109;	 // "canonicalize_icmp"
        }
        break;
      case 'o':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "nstant_fold_fma", 15) != 0)
          break;
        return 168;	 // "constant_fold_fma"
      }
      break;
    case 'd':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "iv_rem_to_divrem", 16) != 0)
        break;
      return 153;	 // "div_rem_to_divrem"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "rase_undef_store", 16) != 0)
        break;
      return 81;	 // "erase_undef_store"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "tr_add_with_zero", 16) != 0)
        break;
      return 149;	 // "ptr_add_with_zero"
    case 's':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "lect_to_iminmax", 15) != 0)
          break;
        return 123;	 // "select_to_iminmax"
      case 'h':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ift_immed_chain", 15) != 0)
          break;
        return 150;	 // "shift_immed_chain"
      }
      break;
    case 'u':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "def_to_int_zero", 15) != 0)
          break;
        return 72;	 // "undef_to_int_zero"
      case 'r':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "em_pow2_to_mask", 15) != 0)
          break;
        return 128;	 // "urem_pow2_to_mask"
      }
      break;
    }
    break;
  case 18:	 // 11 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'A':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "MinusBPlus", 10) != 0)
        break;
      switch (RuleIdentifier[11]) {
      default: break;
      case 'B':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "MinusC", 6) != 0)
          break;
        return 5;	 // "AMinusBPlusBMinusC"
      case 'C':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "MinusA", 6) != 0)
          break;
        return 4;	 // "AMinusBPlusCMinusA"
      }
      break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_left_to_zero", 17) != 0)
        break;
      return 86;	 // "binop_left_to_zero"
    case 'c':	 // 3 strings to match.
      if (RuleIdentifier[1] != 'o')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "bine_minmax_nan", 15) != 0)
          break;
        return 146;	 // "combine_minmax_nan"
      case 'n':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+3, "stant_fold_f", 12) != 0)
          break;
        switch (RuleIdentifier[15]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+16, "bs", 2) != 0)
            break;
          return 135;	 // "constant_fold_fabs"
        case 'n':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+16, "eg", 2) != 0)
            break;
          return 134;	 // "constant_fold_fneg"
        }
        break;
      }
      break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xpand_const_fpowi", 17) != 0)
        break;
      return 147;	 // "expand_const_fpowi"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ptrunc_fpext_fold", 17) != 0)
        break;
      return 99;	 // "fptrunc_fpext_fold"
    case 's':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'e')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "ect_of_truncate", 15) != 0)
          break;
        return 56;	 // "select_of_truncate"
      case 'x':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "t_inreg_of_load", 15) != 0)
          break;
        return 118;	 // "sext_inreg_of_load"
      }
      break;
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runcate_of_anyext", 17) != 0)
        break;
      return 45;	 // "truncate_of_anyext"
    }
    break;
  case 19:	 // 15 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_right_to_zero", 18) != 0)
        break;
      return 87;	 // "binop_right_to_zero"
    case 'c':	 // 4 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "onst", 4) != 0)
        break;
      switch (RuleIdentifier[5]) {
      default: break;
      case '_':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+6, "ptradd_to_i2p", 13) != 0)
          break;
        return 141;	 // "const_ptradd_to_i2p"
      case 'a':	 // 3 strings to match.
        if (memcmp(RuleIdentifier.data()+6, "nt_fold_", 8) != 0)
          break;
        switch (RuleIdentifier[14]) {
        default: break;
        case 'b':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+15, "inop", 4) != 0)
            break;
          return 166;	 // "constant_fold_binop"
        case 'f':	 // 2 strings to match.
          switch (RuleIdentifier[15]) {
          default: break;
          case 'l':	 // 1 string to match.
            if (memcmp(RuleIdentifier.data()+16, "og2", 3) != 0)
              break;
            return 137;	 // "constant_fold_flog2"
          case 's':	 // 1 string to match.
            if (memcmp(RuleIdentifier.data()+16, "qrt", 3) != 0)
              break;
            return 136;	 // "constant_fold_fsqrt"
          }
          break;
        }
        break;
      }
      break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtend_through_phis", 18) != 0)
        break;
      return 102;	 // "extend_through_phis"
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nteger_of_truncate", 18) != 0)
        break;
      return 64;	 // "integer_of_truncate"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "erge_of_x_and_zero", 18) != 0)
        break;
      return 212;	 // "merge_of_x_and_zero"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "tr_add_immed_chain", 18) != 0)
        break;
      return 108;	 // "ptr_add_immed_chain"
    case 'r':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "assoc_comm_binops", 17) != 0)
          break;
        return 107;	 // "reassoc_comm_binops"
      case 'i':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ght_identity_zero", 17) != 0)
          break;
        return 84;	 // "right_identity_zero"
      }
      break;
    case 's':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "lect_constant_cmp", 17) != 0)
          break;
        return 122;	 // "select_constant_cmp"
      case 'i':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "mplify_", 7) != 0)
          break;
        switch (RuleIdentifier[9]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+10, "dd_to_sub", 9) != 0)
            break;
          return 103;	 // "simplify_add_to_sub"
        case 'n':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+10, "eg_minmax", 9) != 0)
            break;
          return 195;	 // "simplify_neg_minmax"
        }
        break;
      }
      break;
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nary_undef_to_zero", 18) != 0)
        break;
      return 76;	 // "unary_undef_to_zero"
    }
    break;
  case 20:	 // 7 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nd_or_disjoint_mask", 19) != 0)
        break;
      return 173;	 // "and_or_disjoint_mask"
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "itcast_bitcast_fold", 19) != 0)
        break;
      return 98;	 // "bitcast_bitcast_fold"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "erge_of_x_and_undef", 19) != 0)
        break;
      return 211;	 // "merge_of_x_and_undef"
    case 'r':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "edu", 3) != 0)
        break;
      switch (RuleIdentifier[4]) {
      default: break;
      case 'c':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+5, "e_shl_of_extend", 15) != 0)
          break;
        return 119;	 // "reduce_shl_of_extend"
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+5, "dant_sext_inreg", 15) != 0)
          break;
        return 126;	 // "redundant_sext_inreg"
      }
      break;
    case 'u':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'n')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "ry_undef_to_undef", 17) != 0)
          break;
        return 77;	 // "unary_undef_to_undef"
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "erge_zext_to_zext", 17) != 0)
          break;
        return 210;	 // "unmerge_zext_to_zext"
      }
      break;
    }
    break;
  case 21:	 // 7 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 3 strings to match.
      if (RuleIdentifier[1] != 'o')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "bine_concat_vector", 18) != 0)
          break;
        return 196;	 // "combine_concat_vector"
      case 'n':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+3, "stant_fold_", 11) != 0)
          break;
        switch (RuleIdentifier[14]) {
        default: break;
        case 'c':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+15, "ast_op", 6) != 0)
            break;
          return 169;	 // "constant_fold_cast_op"
        case 'f':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+15, "ptrunc", 6) != 0)
            break;
          return 138;	 // "constant_fold_fptrunc"
        }
        break;
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nsert_vector_elt_oob", 20) != 0)
        break;
      return 24;	 // "insert_vector_elt_oob"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_one_fp", 20) != 0)
        break;
      return 93;	 // "right_identity_one_fp"
    case 'u':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'n')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "ef_to_negative_one", 18) != 0)
          break;
        return 73;	 // "undef_to_negative_one"
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "erge_dead_to_trunc", 18) != 0)
          break;
        return 209;	 // "unmerge_dead_to_trunc"
      }
      break;
    }
    break;
  case 22:	 // 13 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'o')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "bine_shuffle_concat", 19) != 0)
          break;
        return 200;	 // "combine_shuffle_concat"
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "stant_fold_fp_binop", 19) != 0)
          break;
        return 167;	 // "constant_fold_fp_binop"
      }
      break;
    case 'f':	 // 4 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'o':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ld_binop_into_select", 20) != 0)
          break;
        return 182;	 // "fold_binop_into_select"
      case 'u':	 // 3 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "nnel_shift_", 11) != 0)
          break;
        switch (RuleIdentifier[13]) {
        default: break;
        case 'l':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+14, "eft_zero", 8) != 0)
            break;
          return 157;	 // "funnel_shift_left_zero"
        case 'o':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+14, "vershift", 8) != 0)
            break;
          return 158;	 // "funnel_shift_overshift"
        case 't':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+14, "o_rotate", 8) != 0)
            break;
          return 155;	 // "funnel_shift_to_rotate"
        }
        break;
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "cmp_to_lhs_known_bits", 21) != 0)
        break;
      return 112;	 // "icmp_to_lhs_known_bits"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_subo_no_overflow", 21) != 0)
        break;
      return 214;	 // "match_subo_no_overflow"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ropagate_undef_any_op", 21) != 0)
        break;
      return 78;	 // "propagate_undef_any_op"
    case 'r':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "dundant_neg_operands", 20) != 0)
          break;
        return 172;	 // "redundant_neg_operands"
      case 'i':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ght_identity_one_int", 20) != 0)
          break;
        return 92;	 // "right_identity_one_int"
      }
      break;
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "hl_ashr_to_sext_inreg", 21) != 0)
        break;
      return 116;	 // "shl_ashr_to_sext_inreg"
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runc_buildvector_fold", 21) != 0)
        break;
      return 96;	 // "trunc_buildvector_fold"
    }
    break;
  case 23:	 // 5 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "uildvector_of_truncate", 22) != 0)
        break;
      return 57;	 // "buildvector_of_truncate"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "unnel_shift_right_zero", 22) != 0)
        break;
      return 156;	 // "funnel_shift_right_zero"
    case 'i':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "tof_const_zero_fold_", 20) != 0)
        break;
      switch (RuleIdentifier[21]) {
      default: break;
      case 's':	 // 1 string to match.
        if (RuleIdentifier[22] != 'i')
          break;
        return 139;	 // "itof_const_zero_fold_si"
      case 'u':	 // 1 string to match.
        if (RuleIdentifier[22] != 'i')
          break;
        return 140;	 // "itof_const_zero_fold_ui"
      }
      break;
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ropagate_undef_all_ops", 22) != 0)
        break;
      return 79;	 // "propagate_undef_all_ops"
    }
    break;
  case 24:	 // 6 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_left_undef_to_zero", 23) != 0)
        break;
      return 74;	 // "binop_left_undef_to_zero"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_extract_of_element", 23) != 0)
        break;
      return 23;	 // "match_extract_of_element"
    case 'n':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "arrow_binop_feeding_and", 23) != 0)
        break;
      return 120;	 // "narrow_binop_feeding_and"
    case 's':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_inreg_", 10) != 0)
        break;
      switch (RuleIdentifier[11]) {
      default: break;
      case 'o':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "f_sext_inreg", 12) != 0)
          break;
        return 53;	 // "sext_inreg_of_sext_inreg"
      case 't':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "o_zext_inreg", 12) != 0)
          break;
        return 130;	 // "sext_inreg_to_zext_inreg"
      }
      break;
    case 'x':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "or_of_and_with_same_reg", 23) != 0)
        break;
      return 148;	 // "xor_of_and_with_same_reg"
    }
    break;
  case 25:	 // 7 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'i':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "tfield_extract_from_", 20) != 0)
          break;
        switch (RuleIdentifier[22]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+23, "nd", 2) != 0)
            break;
          return 163;	 // "bitfield_extract_from_and"
        case 's':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+23, "hr", 2) != 0)
            break;
          return 164;	 // "bitfield_extract_from_shr"
        }
        break;
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ildvector_identity_fold", 23) != 0)
          break;
        return 95;	 // "buildvector_identity_fold"
      }
      break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_shuffle_undef_rhs", 24) != 0)
        break;
      return 201;	 // "combine_shuffle_undef_rhs"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtract_vec_elt_build_vec", 24) != 0)
        break;
      return 66;	 // "extract_vec_elt_build_vec"
    case 'n':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "eg_and_one_to_sext_inreg", 24) != 0)
        break;
      return 117;	 // "neg_and_one_to_sext_inreg"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_neg_one_fp", 24) != 0)
        break;
      return 101;	 // "right_identity_neg_one_fp"
    }
    break;
  case 26:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_right_undef_to_undef", 25) != 0)
        break;
      return 75;	 // "binop_right_undef_to_undef"
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ommute_fp_constant_to_rhs", 25) != 0)
        break;
      return 192;	 // "commute_fp_constant_to_rhs"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "unnel_shift_from_or_shift", 25) != 0)
        break;
      return 154;	 // "funnel_shift_from_or_shift"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_neg_zero_fp", 25) != 0)
        break;
      return 100;	 // "right_identity_neg_zero_fp"
    }
    break;
  case 27:	 // 6 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "om", 2) != 0)
        break;
      switch (RuleIdentifier[3]) {
      default: break;
      case 'b':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+4, "ine_use_vector_truncate", 23) != 0)
          break;
        return 203;	 // "combine_use_vector_truncate"
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+4, "ute_int_constant_to_rhs", 23) != 0)
          break;
        return 191;	 // "commute_int_constant_to_rhs"
      }
      break;
    case 'd':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ouble_icmp_zero_or_combine", 26) != 0)
        break;
      return 114;	 // "double_icmp_zero_or_combine"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "edundant_binop_in_equality", 26) != 0)
        break;
      return 115;	 // "redundant_binop_in_equality"
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runc_lshr_buildvector_fold", 26) != 0)
        break;
      return 97;	 // "trunc_lshr_buildvector_fold"
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nmerge_anyext_build_vector", 26) != 0)
        break;
      return 204;	 // "unmerge_anyext_build_vector"
    }
    break;
  case 28:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'd':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ouble_icmp_zero_and_combine", 27) != 0)
        break;
      return 113;	 // "double_icmp_zero_and_combine"
    case 'o':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "pt_brcond_by_inverting_cond", 27) != 0)
        break;
      return 133;	 // "opt_brcond_by_inverting_cond"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ropagate_undef_shuffle_mask", 27) != 0)
        break;
      return 80;	 // "propagate_undef_shuffle_mask"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "hift_of_shifted_logic_chain", 27) != 0)
        break;
      return 151;	 // "shift_of_shifted_logic_chain"
    }
    break;
  case 29:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "itfield_extract_from_shr_and", 28) != 0)
        break;
      return 165;	 // "bitfield_extract_from_shr_and"
    case 'c':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_", 7) != 0)
        break;
      switch (RuleIdentifier[8]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+9, "xtracted_vector_load", 20) != 0)
          break;
        return 70;	 // "combine_extracted_vector_load"
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+9, "huffle_disjoint_mask", 20) != 0)
          break;
        return 202;	 // "combine_shuffle_disjoint_mask"
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "cmp_to_true_false_known_bits", 28) != 0)
        break;
      return 111;	 // "icmp_to_true_false_known_bits"
    }
    break;
  case 30:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "freeze_of_non_undef_non_poison", 30) != 0)
      break;
    return 41;	 // "freeze_of_non_undef_non_poison"
  case 31:	 // 2 strings to match.
    if (memcmp(RuleIdentifier.data()+0, "insert_vector_element_", 22) != 0)
      break;
    switch (RuleIdentifier[22]) {
    default: break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+23, "lt_undef", 8) != 0)
        break;
      return 22;	 // "insert_vector_element_elt_undef"
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+23, "dx_undef", 8) != 0)
        break;
      return 21;	 // "insert_vector_element_idx_undef"
    }
    break;
  case 32:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "itfield_extract_from_sext_inreg", 31) != 0)
        break;
      return 162;	 // "bitfield_extract_from_sext_inreg"
    case 'c':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_f", 8) != 0)
        break;
      switch (RuleIdentifier[9]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+10, "dd_fmul_to_fmad_or_fma", 22) != 0)
          break;
        return 174;	 // "combine_fadd_fmul_to_fmad_or_fma"
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+10, "ub_fmul_to_fmad_or_fma", 22) != 0)
          break;
        return 178;	 // "combine_fsub_fmul_to_fmad_or_fma"
      }
      break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtract_vector_element_not_const", 31) != 0)
        break;
      return 25;	 // "extract_vector_element_not_const"
    }
    break;
  case 34:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "extract_all_elts_from_build_vector", 34) != 0)
      break;
    return 67;	 // "extract_all_elts_from_build_vector"
  case 35:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "extract_vector_element_build_vector", 35) != 0)
      break;
    return 27;	 // "extract_vector_element_build_vector"
  case 36:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_", 7) != 0)
        break;
      switch (RuleIdentifier[8]) {
      default: break;
      case 'f':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+9, "add_fma_fmul_to_fmad_or_fma", 27) != 0)
          break;
        return 176;	 // "combine_fadd_fma_fmul_to_fmad_or_fma"
      case 'i':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+9, "nsert_vec_elts_build_vector", 27) != 0)
          break;
        return 65;	 // "combine_insert_vec_elts_build_vector"
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nsert_extract_vec_elt_out_of_bounds", 35) != 0)
        break;
      return 82;	 // "insert_extract_vec_elt_out_of_bounds"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_extract_of_element_undef_index", 35) != 0)
        break;
      return 20;	 // "match_extract_of_element_undef_index"
    }
    break;
  case 37:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_fsub_fneg_fmul_to_fmad_or_fma", 36) != 0)
        break;
      return 179;	 // "combine_fsub_fneg_fmul_to_fmad_or_fma"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtract_vector_element_shuffle_vector", 36) != 0)
        break;
      return 35;	 // "extract_vector_element_shuffle_vector"
    case 'h':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "oist_logic_op_with_same_opcode_hands", 36) != 0)
        break;
      return 104;	 // "hoist_logic_op_with_same_opcode_hands"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_extract_of_element_undef_vector", 36) != 0)
        break;
      return 19;	 // "match_extract_of_element_undef_vector"
    }
    break;
  case 38:	 // 2 strings to match.
    if (memcmp(RuleIdentifier.data()+0, "combine_f", 9) != 0)
      break;
    switch (RuleIdentifier[9]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+10, "dd_fpext_fmul_to_fmad_or_fma", 28) != 0)
        break;
      return 175;	 // "combine_fadd_fpext_fmul_to_fmad_or_fma"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+10, "ub_fpext_fmul_to_fmad_or_fma", 28) != 0)
        break;
      return 180;	 // "combine_fsub_fpext_fmul_to_fmad_or_fma"
    }
    break;
  case 40:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "extract_vector_element_different_indices", 40) != 0)
      break;
    return 26;	 // "extract_vector_element_different_indices"
  case 42:	 // 8 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_fadd_fpext_fma_fmul_to_fmad_or_fma", 41) != 0)
        break;
      return 177;	 // "combine_fadd_fpext_fma_fmul_to_fmad_or_fma"
    case 'e':	 // 7 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "xtract_vector_element_build_vector_trunc", 40) != 0)
        break;
      switch (RuleIdentifier[41]) {
      default: break;
      case '2':	 // 1 string to match.
        return 28;	 // "extract_vector_element_build_vector_trunc2"
      case '3':	 // 1 string to match.
        return 29;	 // "extract_vector_element_build_vector_trunc3"
      case '4':	 // 1 string to match.
        return 30;	 // "extract_vector_element_build_vector_trunc4"
      case '5':	 // 1 string to match.
        return 31;	 // "extract_vector_element_build_vector_trunc5"
      case '6':	 // 1 string to match.
        return 32;	 // "extract_vector_element_build_vector_trunc6"
      case '7':	 // 1 string to match.
        return 33;	 // "extract_vector_element_build_vector_trunc7"
      case '8':	 // 1 string to match.
        return 34;	 // "extract_vector_element_build_vector_trunc8"
      }
      break;
    }
    break;
  case 43:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "combine_fsub_fpext_fneg_fmul_to_fmad_or_fma", 43) != 0)
      break;
    return 181;	 // "combine_fsub_fpext_fneg_fmul_to_fmad_or_fma"
  case 44:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "insert_vector_element_extract_vector_element", 44) != 0)
      break;
    return 36;	 // "insert_vector_element_extract_vector_element"
  case 46:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "push_freeze_to_prevent_poison_from_propagating", 46) != 0)
      break;
    return 42;	 // "push_freeze_to_prevent_poison_from_propagating"
  }
#endif // ifndef NDEBUG

  return std::nullopt;
}
static std::optional<std::pair<uint64_t, uint64_t>> getRuleRangeForIdentifier(StringRef RuleIdentifier) {
  std::pair<StringRef, StringRef> RangePair = RuleIdentifier.split('-');
  if (!RangePair.second.empty()) {
    const auto First = getRuleIdxForIdentifier(RangePair.first);
    const auto Last = getRuleIdxForIdentifier(RangePair.second);
    if (!First || !Last)
      return std::nullopt;
    if (First >= Last)
      report_fatal_error("Beginning of range should be before end of range");
    return {{*First, *Last + 1}};
  }
  if (RangePair.first == "*") {
    return {{0, 215}};
  }
  const auto I = getRuleIdxForIdentifier(RangePair.first);
  if (!I)
    return std::nullopt;
  return {{*I, *I + 1}};
}

bool RISCVPreLegalizerCombinerImplRuleConfig::setRuleEnabled(StringRef RuleIdentifier) {
  auto MaybeRange = getRuleRangeForIdentifier(RuleIdentifier);
  if (!MaybeRange)
    return false;
  for (auto I = MaybeRange->first; I < MaybeRange->second; ++I)
    DisabledRules.reset(I);
  return true;
}

bool RISCVPreLegalizerCombinerImplRuleConfig::setRuleDisabled(StringRef RuleIdentifier) {
  auto MaybeRange = getRuleRangeForIdentifier(RuleIdentifier);
  if (!MaybeRange)
    return false;
  for (auto I = MaybeRange->first; I < MaybeRange->second; ++I)
    DisabledRules.set(I);
  return true;
}

static std::vector<std::string> RISCVPreLegalizerCombinerOption;
static cl::list<std::string> RISCVPreLegalizerCombinerDisableOption(
    "riscvprelegalizercombiner-disable-rule",
    cl::desc("Disable one or more combiner rules temporarily in the RISCVPreLegalizerCombiner pass"),
    cl::CommaSeparated,
    cl::Hidden,
    cl::cat(GICombinerOptionCategory),
    cl::callback([](const std::string &Str) {
      RISCVPreLegalizerCombinerOption.push_back(Str);
    }));
static cl::list<std::string> RISCVPreLegalizerCombinerOnlyEnableOption(
    "riscvprelegalizercombiner-only-enable-rule",
    cl::desc("Disable all rules in the RISCVPreLegalizerCombiner pass then re-enable the specified ones"),
    cl::Hidden,
    cl::cat(GICombinerOptionCategory),
    cl::callback([](const std::string &CommaSeparatedArg) {
      StringRef Str = CommaSeparatedArg;
      RISCVPreLegalizerCombinerOption.push_back("*");
      do {
        auto X = Str.split(",");
        RISCVPreLegalizerCombinerOption.push_back(("!" + X.first).str());
        Str = X.second;
      } while (!Str.empty());
    }));


bool RISCVPreLegalizerCombinerImplRuleConfig::isRuleEnabled(unsigned RuleID) const {
    return  !DisabledRules.test(RuleID);
}
bool RISCVPreLegalizerCombinerImplRuleConfig::parseCommandLineOption() {
  for (StringRef Identifier : RISCVPreLegalizerCombinerOption) {
    bool Enabled = Identifier.consume_front("!");
    if (Enabled && !setRuleEnabled(Identifier))
      return false;
    if (!Enabled && !setRuleDisabled(Identifier))
      return false;
  }
  return true;
}

#endif // ifdef GET_GICOMBINER_TYPES

#ifdef GET_GICOMBINER_TYPES
const unsigned MAX_SUBTARGET_PREDICATES = 0;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GICOMBINER_TYPES

#ifdef GET_GICOMBINER_CLASS_MEMBERS
PredicateBitset AvailableModuleFeatures;
mutable PredicateBitset AvailableFunctionFeatures;
PredicateBitset getAvailableFeatures() const {
  return AvailableModuleFeatures | AvailableFunctionFeatures;
}
PredicateBitset
computeAvailableModuleFeatures(const RISCVSubtarget *Subtarget) const;
PredicateBitset
computeAvailableFunctionFeatures(const RISCVSubtarget *Subtarget,
                                 const MachineFunction *MF) const;
void setupGeneratedPerFunctionState(MachineFunction &MF) override;
#endif // ifdef GET_GICOMBINER_CLASS_MEMBERS
#ifdef GET_GICOMBINER_CLASS_MEMBERS
  mutable MatcherState State;
  typedef ComplexRendererFns(RISCVPreLegalizerCombinerImpl::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(RISCVPreLegalizerCombinerImpl::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static RISCVPreLegalizerCombinerImpl::ComplexMatcherMemFn ComplexPredicateFns[];
  static RISCVPreLegalizerCombinerImpl::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testMOPredicate_MO(unsigned PredicateID, const MachineOperand &MO, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GICOMBINER_CLASS_MEMBERS

#ifdef GET_GICOMBINER_IMPL
// LLT Objects.
enum {
  GILLT_s1,
};
const static size_t NumTypeObjects = 1;
const static LLT TypeObjects[] = {
  LLT::scalar(1),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
};

PredicateBitset RISCVPreLegalizerCombinerImpl::
computeAvailableModuleFeatures(const RISCVSubtarget *Subtarget) const {
  PredicateBitset Features{};
  return Features;
}

void RISCVPreLegalizerCombinerImpl::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const RISCVSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset RISCVPreLegalizerCombinerImpl::
computeAvailableFunctionFeatures(const RISCVSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

RISCVPreLegalizerCombinerImpl::ComplexMatcherMemFn
RISCVPreLegalizerCombinerImpl::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

enum {
  GICXXPred_MI_Predicate_GICombiner0 = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_GICombiner1,
  GICXXPred_MI_Predicate_GICombiner2,
  GICXXPred_MI_Predicate_GICombiner3,
  GICXXPred_MI_Predicate_GICombiner4,
  GICXXPred_MI_Predicate_GICombiner5,
  GICXXPred_MI_Predicate_GICombiner6,
  GICXXPred_MI_Predicate_GICombiner7,
  GICXXPred_MI_Predicate_GICombiner8,
  GICXXPred_MI_Predicate_GICombiner9,
};
bool RISCVPreLegalizerCombinerImpl::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_GICombiner0: {
    return isGuaranteedNotToBePoison(State.MIs[0]->getOperand(1).getReg(), MRI);
  }
  case GICXXPred_MI_Predicate_GICombiner1: {
    return isGuaranteedNotToBeUndefOrPoison(State.MIs[0]->getOperand(1).getReg(), MRI);
  }
  case GICXXPred_MI_Predicate_GICombiner2: {
    return Helper.matchConstantFPOp(State.MIs[0]->getOperand(2), 1.0);
  }
  case GICXXPred_MI_Predicate_GICombiner3: {
    return Helper.matchConstantFPOp(State.MIs[0]->getOperand(2), -0.0);
  }
  case GICXXPred_MI_Predicate_GICombiner4: {
    return Helper.matchConstantFPOp(State.MIs[0]->getOperand(2), -1.0);
  }
  case GICXXPred_MI_Predicate_GICombiner5: {
    return State.MIs[1]->getOperand(1).getPredicate() == CmpInst::ICMP_EQ &&
                               !MRI.getType(State.MIs[1]->getOperand(2).getReg()).getScalarType().isPointer() &&
                               (MRI.getType(State.MIs[1]->getOperand(2).getReg()) ==
                                   MRI.getType(State.MIs[2]->getOperand(2).getReg()));
  }
  case GICXXPred_MI_Predicate_GICombiner6: {
    return State.MIs[1]->getOperand(1).getPredicate() == CmpInst::ICMP_NE &&
                               !MRI.getType(State.MIs[1]->getOperand(2).getReg()).getScalarType().isPointer() &&
                               (MRI.getType(State.MIs[1]->getOperand(2).getReg()) ==
                                   MRI.getType(State.MIs[2]->getOperand(2).getReg()));
  }
  case GICXXPred_MI_Predicate_GICombiner7: {
    return MRI.hasOneNonDBGUse(State.MIs[0]->getOperand(2).getReg()) &&
                    Helper.isLegalOrBeforeLegalizer(
                      {TargetOpcode::G_SEXT_INREG, {MRI.getType(State.MIs[1]->getOperand(1).getReg())}});
  }
  case GICXXPred_MI_Predicate_GICombiner8: {
    return Helper.isLegalOrBeforeLegalizer({TargetOpcode::G_LSHR,
                                                           {MRI.getType(State.MIs[2]->getOperand(1).getReg()),
                                                            MRI.getType(State.MIs[1]->getOperand(2).getReg())}});
  }
  case GICXXPred_MI_Predicate_GICombiner9: {
    return Helper.isLegalOrBeforeLegalizer({TargetOpcode::G_SHL,
                                                           {MRI.getType(State.MIs[2]->getOperand(1).getReg()),
                                                            MRI.getType(State.MIs[1]->getOperand(2).getReg())}});
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVPreLegalizerCombinerImpl::testMOPredicate_MO(unsigned PredicateID, const MachineOperand & MO, const MatcherState &State) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVPreLegalizerCombinerImpl::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVPreLegalizerCombinerImpl::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVPreLegalizerCombinerImpl::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
enum {
  GICXXPred_Simple_IsRule0Enabled = GICXXPred_Invalid + 1,
  GICXXPred_Simple_IsRule1Enabled,
  GICXXPred_Simple_IsRule2Enabled,
  GICXXPred_Simple_IsRule3Enabled,
  GICXXPred_Simple_IsRule4Enabled,
  GICXXPred_Simple_IsRule5Enabled,
  GICXXPred_Simple_IsRule6Enabled,
  GICXXPred_Simple_IsRule7Enabled,
  GICXXPred_Simple_IsRule8Enabled,
  GICXXPred_Simple_IsRule9Enabled,
  GICXXPred_Simple_IsRule10Enabled,
  GICXXPred_Simple_IsRule11Enabled,
  GICXXPred_Simple_IsRule12Enabled,
  GICXXPred_Simple_IsRule13Enabled,
  GICXXPred_Simple_IsRule14Enabled,
  GICXXPred_Simple_IsRule15Enabled,
  GICXXPred_Simple_IsRule16Enabled,
  GICXXPred_Simple_IsRule17Enabled,
  GICXXPred_Simple_IsRule18Enabled,
  GICXXPred_Simple_IsRule19Enabled,
  GICXXPred_Simple_IsRule20Enabled,
  GICXXPred_Simple_IsRule21Enabled,
  GICXXPred_Simple_IsRule22Enabled,
  GICXXPred_Simple_IsRule23Enabled,
  GICXXPred_Simple_IsRule24Enabled,
  GICXXPred_Simple_IsRule25Enabled,
  GICXXPred_Simple_IsRule26Enabled,
  GICXXPred_Simple_IsRule27Enabled,
  GICXXPred_Simple_IsRule28Enabled,
  GICXXPred_Simple_IsRule29Enabled,
  GICXXPred_Simple_IsRule30Enabled,
  GICXXPred_Simple_IsRule31Enabled,
  GICXXPred_Simple_IsRule32Enabled,
  GICXXPred_Simple_IsRule33Enabled,
  GICXXPred_Simple_IsRule34Enabled,
  GICXXPred_Simple_IsRule35Enabled,
  GICXXPred_Simple_IsRule36Enabled,
  GICXXPred_Simple_IsRule37Enabled,
  GICXXPred_Simple_IsRule38Enabled,
  GICXXPred_Simple_IsRule39Enabled,
  GICXXPred_Simple_IsRule40Enabled,
  GICXXPred_Simple_IsRule41Enabled,
  GICXXPred_Simple_IsRule42Enabled,
  GICXXPred_Simple_IsRule43Enabled,
  GICXXPred_Simple_IsRule44Enabled,
  GICXXPred_Simple_IsRule45Enabled,
  GICXXPred_Simple_IsRule46Enabled,
  GICXXPred_Simple_IsRule47Enabled,
  GICXXPred_Simple_IsRule48Enabled,
  GICXXPred_Simple_IsRule49Enabled,
  GICXXPred_Simple_IsRule50Enabled,
  GICXXPred_Simple_IsRule51Enabled,
  GICXXPred_Simple_IsRule52Enabled,
  GICXXPred_Simple_IsRule53Enabled,
  GICXXPred_Simple_IsRule54Enabled,
  GICXXPred_Simple_IsRule55Enabled,
  GICXXPred_Simple_IsRule56Enabled,
  GICXXPred_Simple_IsRule57Enabled,
  GICXXPred_Simple_IsRule58Enabled,
  GICXXPred_Simple_IsRule59Enabled,
  GICXXPred_Simple_IsRule60Enabled,
  GICXXPred_Simple_IsRule61Enabled,
  GICXXPred_Simple_IsRule62Enabled,
  GICXXPred_Simple_IsRule63Enabled,
  GICXXPred_Simple_IsRule64Enabled,
  GICXXPred_Simple_IsRule65Enabled,
  GICXXPred_Simple_IsRule66Enabled,
  GICXXPred_Simple_IsRule67Enabled,
  GICXXPred_Simple_IsRule68Enabled,
  GICXXPred_Simple_IsRule69Enabled,
  GICXXPred_Simple_IsRule70Enabled,
  GICXXPred_Simple_IsRule71Enabled,
  GICXXPred_Simple_IsRule72Enabled,
  GICXXPred_Simple_IsRule73Enabled,
  GICXXPred_Simple_IsRule74Enabled,
  GICXXPred_Simple_IsRule75Enabled,
  GICXXPred_Simple_IsRule76Enabled,
  GICXXPred_Simple_IsRule77Enabled,
  GICXXPred_Simple_IsRule78Enabled,
  GICXXPred_Simple_IsRule79Enabled,
  GICXXPred_Simple_IsRule80Enabled,
  GICXXPred_Simple_IsRule81Enabled,
  GICXXPred_Simple_IsRule82Enabled,
  GICXXPred_Simple_IsRule83Enabled,
  GICXXPred_Simple_IsRule84Enabled,
  GICXXPred_Simple_IsRule85Enabled,
  GICXXPred_Simple_IsRule86Enabled,
  GICXXPred_Simple_IsRule87Enabled,
  GICXXPred_Simple_IsRule88Enabled,
  GICXXPred_Simple_IsRule89Enabled,
  GICXXPred_Simple_IsRule90Enabled,
  GICXXPred_Simple_IsRule91Enabled,
  GICXXPred_Simple_IsRule92Enabled,
  GICXXPred_Simple_IsRule93Enabled,
  GICXXPred_Simple_IsRule94Enabled,
  GICXXPred_Simple_IsRule95Enabled,
  GICXXPred_Simple_IsRule96Enabled,
  GICXXPred_Simple_IsRule97Enabled,
  GICXXPred_Simple_IsRule98Enabled,
  GICXXPred_Simple_IsRule99Enabled,
  GICXXPred_Simple_IsRule100Enabled,
  GICXXPred_Simple_IsRule101Enabled,
  GICXXPred_Simple_IsRule102Enabled,
  GICXXPred_Simple_IsRule103Enabled,
  GICXXPred_Simple_IsRule104Enabled,
  GICXXPred_Simple_IsRule105Enabled,
  GICXXPred_Simple_IsRule106Enabled,
  GICXXPred_Simple_IsRule107Enabled,
  GICXXPred_Simple_IsRule108Enabled,
  GICXXPred_Simple_IsRule109Enabled,
  GICXXPred_Simple_IsRule110Enabled,
  GICXXPred_Simple_IsRule111Enabled,
  GICXXPred_Simple_IsRule112Enabled,
  GICXXPred_Simple_IsRule113Enabled,
  GICXXPred_Simple_IsRule114Enabled,
  GICXXPred_Simple_IsRule115Enabled,
  GICXXPred_Simple_IsRule116Enabled,
  GICXXPred_Simple_IsRule117Enabled,
  GICXXPred_Simple_IsRule118Enabled,
  GICXXPred_Simple_IsRule119Enabled,
  GICXXPred_Simple_IsRule120Enabled,
  GICXXPred_Simple_IsRule121Enabled,
  GICXXPred_Simple_IsRule122Enabled,
  GICXXPred_Simple_IsRule123Enabled,
  GICXXPred_Simple_IsRule124Enabled,
  GICXXPred_Simple_IsRule125Enabled,
  GICXXPred_Simple_IsRule126Enabled,
  GICXXPred_Simple_IsRule127Enabled,
  GICXXPred_Simple_IsRule128Enabled,
  GICXXPred_Simple_IsRule129Enabled,
  GICXXPred_Simple_IsRule130Enabled,
  GICXXPred_Simple_IsRule131Enabled,
  GICXXPred_Simple_IsRule132Enabled,
  GICXXPred_Simple_IsRule133Enabled,
  GICXXPred_Simple_IsRule134Enabled,
  GICXXPred_Simple_IsRule135Enabled,
  GICXXPred_Simple_IsRule136Enabled,
  GICXXPred_Simple_IsRule137Enabled,
  GICXXPred_Simple_IsRule138Enabled,
  GICXXPred_Simple_IsRule139Enabled,
  GICXXPred_Simple_IsRule140Enabled,
  GICXXPred_Simple_IsRule141Enabled,
  GICXXPred_Simple_IsRule142Enabled,
  GICXXPred_Simple_IsRule143Enabled,
  GICXXPred_Simple_IsRule144Enabled,
  GICXXPred_Simple_IsRule145Enabled,
  GICXXPred_Simple_IsRule146Enabled,
  GICXXPred_Simple_IsRule147Enabled,
  GICXXPred_Simple_IsRule148Enabled,
  GICXXPred_Simple_IsRule149Enabled,
  GICXXPred_Simple_IsRule150Enabled,
  GICXXPred_Simple_IsRule151Enabled,
  GICXXPred_Simple_IsRule152Enabled,
  GICXXPred_Simple_IsRule153Enabled,
  GICXXPred_Simple_IsRule154Enabled,
  GICXXPred_Simple_IsRule155Enabled,
  GICXXPred_Simple_IsRule156Enabled,
  GICXXPred_Simple_IsRule157Enabled,
  GICXXPred_Simple_IsRule158Enabled,
  GICXXPred_Simple_IsRule159Enabled,
  GICXXPred_Simple_IsRule160Enabled,
  GICXXPred_Simple_IsRule161Enabled,
  GICXXPred_Simple_IsRule162Enabled,
  GICXXPred_Simple_IsRule163Enabled,
  GICXXPred_Simple_IsRule164Enabled,
  GICXXPred_Simple_IsRule165Enabled,
  GICXXPred_Simple_IsRule166Enabled,
  GICXXPred_Simple_IsRule167Enabled,
  GICXXPred_Simple_IsRule168Enabled,
  GICXXPred_Simple_IsRule169Enabled,
  GICXXPred_Simple_IsRule170Enabled,
  GICXXPred_Simple_IsRule171Enabled,
  GICXXPred_Simple_IsRule172Enabled,
  GICXXPred_Simple_IsRule173Enabled,
  GICXXPred_Simple_IsRule174Enabled,
  GICXXPred_Simple_IsRule175Enabled,
  GICXXPred_Simple_IsRule176Enabled,
  GICXXPred_Simple_IsRule177Enabled,
  GICXXPred_Simple_IsRule178Enabled,
  GICXXPred_Simple_IsRule179Enabled,
  GICXXPred_Simple_IsRule180Enabled,
  GICXXPred_Simple_IsRule181Enabled,
  GICXXPred_Simple_IsRule182Enabled,
  GICXXPred_Simple_IsRule183Enabled,
  GICXXPred_Simple_IsRule184Enabled,
  GICXXPred_Simple_IsRule185Enabled,
  GICXXPred_Simple_IsRule186Enabled,
  GICXXPred_Simple_IsRule187Enabled,
  GICXXPred_Simple_IsRule188Enabled,
  GICXXPred_Simple_IsRule189Enabled,
  GICXXPred_Simple_IsRule190Enabled,
  GICXXPred_Simple_IsRule191Enabled,
  GICXXPred_Simple_IsRule192Enabled,
  GICXXPred_Simple_IsRule193Enabled,
  GICXXPred_Simple_IsRule194Enabled,
  GICXXPred_Simple_IsRule195Enabled,
  GICXXPred_Simple_IsRule196Enabled,
  GICXXPred_Simple_IsRule197Enabled,
  GICXXPred_Simple_IsRule198Enabled,
  GICXXPred_Simple_IsRule199Enabled,
  GICXXPred_Simple_IsRule200Enabled,
  GICXXPred_Simple_IsRule201Enabled,
  GICXXPred_Simple_IsRule202Enabled,
  GICXXPred_Simple_IsRule203Enabled,
  GICXXPred_Simple_IsRule204Enabled,
  GICXXPred_Simple_IsRule205Enabled,
  GICXXPred_Simple_IsRule206Enabled,
  GICXXPred_Simple_IsRule207Enabled,
  GICXXPred_Simple_IsRule208Enabled,
  GICXXPred_Simple_IsRule209Enabled,
  GICXXPred_Simple_IsRule210Enabled,
  GICXXPred_Simple_IsRule211Enabled,
  GICXXPred_Simple_IsRule212Enabled,
  GICXXPred_Simple_IsRule213Enabled,
  GICXXPred_Simple_IsRule214Enabled,
};

bool RISCVPreLegalizerCombinerImpl::testSimplePredicate(unsigned Predicate) const {
    return RuleConfig.isRuleEnabled(Predicate - GICXXPred_Invalid - 1);
}
// Custom renderers.
enum {
  GICR_Invalid,
};
RISCVPreLegalizerCombinerImpl::CustomRendererFn
RISCVPreLegalizerCombinerImpl::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool RISCVPreLegalizerCombinerImpl::tryCombineAll(MachineInstr &I) const {
  const TargetSubtargetInfo &ST = MF.getSubtarget();
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  B.setInstrAndDebugLoc(I);
  State.MIs.clear();
  State.MIs.push_back(&I);
  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), *ST.getInstrInfo(), MRI, *MRI.getTargetRegisterInfo(), *ST.getRegBankInfo(), AvailableFeatures, /*CoverageInfo*/ nullptr)) {
    return true;
  }

  return false;
}

enum {
  GICXXCustomAction_GICombiner0 = GICXXCustomAction_Invalid + 1,
  GICXXCustomAction_GICombiner1,
  GICXXCustomAction_GICombiner2,
  GICXXCustomAction_GICombiner3,
  GICXXCustomAction_GICombiner4,
  GICXXCustomAction_GICombiner5,
  GICXXCustomAction_GICombiner6,
  GICXXCustomAction_GICombiner7,
  GICXXCustomAction_GICombiner8,
  GICXXCustomAction_GICombiner9,
  GICXXCustomAction_GICombiner10,
  GICXXCustomAction_GICombiner11,
  GICXXCustomAction_GICombiner12,
  GICXXCustomAction_GICombiner13,
  GICXXCustomAction_GICombiner14,
  GICXXCustomAction_GICombiner15,
  GICXXCustomAction_GICombiner16,
  GICXXCustomAction_GICombiner17,
  GICXXCustomAction_GICombiner18,
  GICXXCustomAction_GICombiner19,
  GICXXCustomAction_GICombiner20,
  GICXXCustomAction_GICombiner21,
  GICXXCustomAction_GICombiner22,
  GICXXCustomAction_GICombiner23,
  GICXXCustomAction_GICombiner24,
  GICXXCustomAction_GICombiner25,
  GICXXCustomAction_GICombiner26,
  GICXXCustomAction_GICombiner27,
  GICXXCustomAction_GICombiner28,
  GICXXCustomAction_GICombiner29,
  GICXXCustomAction_GICombiner30,
  GICXXCustomAction_GICombiner31,
  GICXXCustomAction_GICombiner32,
  GICXXCustomAction_GICombiner33,
  GICXXCustomAction_GICombiner34,
  GICXXCustomAction_GICombiner35,
  GICXXCustomAction_GICombiner36,
  GICXXCustomAction_GICombiner37,
  GICXXCustomAction_GICombiner38,
  GICXXCustomAction_GICombiner39,
  GICXXCustomAction_GICombiner40,
  GICXXCustomAction_GICombiner41,
  GICXXCustomAction_GICombiner42,
  GICXXCustomAction_GICombiner43,
  GICXXCustomAction_GICombiner44,
  GICXXCustomAction_GICombiner45,
  GICXXCustomAction_GICombiner46,
  GICXXCustomAction_GICombiner47,
  GICXXCustomAction_GICombiner48,
  GICXXCustomAction_GICombiner49,
  GICXXCustomAction_GICombiner50,
  GICXXCustomAction_GICombiner51,
  GICXXCustomAction_GICombiner52,
  GICXXCustomAction_GICombiner53,
  GICXXCustomAction_GICombiner54,
  GICXXCustomAction_GICombiner55,
  GICXXCustomAction_GICombiner56,
  GICXXCustomAction_GICombiner57,
  GICXXCustomAction_GICombiner58,
  GICXXCustomAction_GICombiner59,
  GICXXCustomAction_GICombiner60,
  GICXXCustomAction_GICombiner61,
  GICXXCustomAction_GICombiner62,
  GICXXCustomAction_GICombiner63,
  GICXXCustomAction_GICombiner64,
  GICXXCustomAction_GICombiner65,
  GICXXCustomAction_GICombiner66,
  GICXXCustomAction_GICombiner67,
  GICXXCustomAction_GICombiner68,
  GICXXCustomAction_GICombiner69,
  GICXXCustomAction_GICombiner70,
  GICXXCustomAction_GICombiner71,
  GICXXCustomAction_GICombiner72,
  GICXXCustomAction_GICombiner73,
  GICXXCustomAction_GICombiner74,
  GICXXCustomAction_GICombiner75,
  GICXXCustomAction_GICombiner76,
  GICXXCustomAction_GICombiner77,
  GICXXCustomAction_GICombiner78,
  GICXXCustomAction_GICombiner79,
  GICXXCustomAction_GICombiner80,
  GICXXCustomAction_GICombiner81,
  GICXXCustomAction_GICombiner82,
  GICXXCustomAction_GICombiner83,
  GICXXCustomAction_GICombiner84,
  GICXXCustomAction_GICombiner85,
  GICXXCustomAction_GICombiner86,
  GICXXCustomAction_GICombiner87,
  GICXXCustomAction_GICombiner88,
  GICXXCustomAction_GICombiner89,
  GICXXCustomAction_GICombiner90,
  GICXXCustomAction_GICombiner91,
  GICXXCustomAction_GICombiner92,
  GICXXCustomAction_GICombiner93,
  GICXXCustomAction_GICombiner94,
  GICXXCustomAction_GICombiner95,
  GICXXCustomAction_GICombiner96,
  GICXXCustomAction_GICombiner97,
  GICXXCustomAction_GICombiner98,
  GICXXCustomAction_GICombiner99,
  GICXXCustomAction_GICombiner100,
  GICXXCustomAction_GICombiner101,
  GICXXCustomAction_GICombiner102,
  GICXXCustomAction_GICombiner103,
  GICXXCustomAction_GICombiner104,
  GICXXCustomAction_GICombiner105,
  GICXXCustomAction_GICombiner106,
  GICXXCustomAction_GICombiner107,
  GICXXCustomAction_GICombiner108,
  GICXXCustomAction_GICombiner109,
  GICXXCustomAction_GICombiner110,
  GICXXCustomAction_GICombiner111,
  GICXXCustomAction_GICombiner112,
  GICXXCustomAction_GICombiner113,
  GICXXCustomAction_GICombiner114,
  GICXXCustomAction_GICombiner115,
  GICXXCustomAction_GICombiner116,
  GICXXCustomAction_GICombiner117,
  GICXXCustomAction_GICombiner118,
  GICXXCustomAction_GICombiner119,
  GICXXCustomAction_GICombiner120,
  GICXXCustomAction_GICombiner121,
  GICXXCustomAction_GICombiner122,
  GICXXCustomAction_GICombiner123,
  GICXXCustomAction_GICombiner124,
  GICXXCustomAction_GICombiner125,
  GICXXCustomAction_GICombiner126,
  GICXXCustomAction_GICombiner127,
  GICXXCustomAction_GICombiner128,
  GICXXCustomAction_GICombiner129,
  GICXXCustomAction_GICombiner130,
  GICXXCustomAction_GICombiner131,
  GICXXCustomAction_GICombiner132,
  GICXXCustomAction_GICombiner133,
  GICXXCustomAction_GICombiner134,
  GICXXCustomAction_GICombiner135,
  GICXXCustomAction_GICombiner136,
  GICXXCustomAction_GICombiner137,
  GICXXCustomAction_GICombiner138,
  GICXXCustomAction_GICombiner139,
  GICXXCustomAction_GICombiner140,
  GICXXCustomAction_GICombiner141,
  GICXXCustomAction_GICombiner142,
  GICXXCustomAction_GICombiner143,
  GICXXCustomAction_GICombiner144,
  GICXXCustomAction_GICombiner145,
  GICXXCustomAction_GICombiner146,
  GICXXCustomAction_GICombiner147,
  GICXXCustomAction_GICombiner148,
  GICXXCustomAction_GICombiner149,
  GICXXCustomAction_GICombiner150,
};
bool RISCVPreLegalizerCombinerImpl::runCustomAction(unsigned ApplyID, const MatcherState &State, NewMIVector &OutMIs) const {
  Helper.getBuilder().setInstrAndDebugLoc(*State.MIs[0]);
  switch(ApplyID) {
  case GICXXCustomAction_GICombiner0:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldAPlusC1MinusC2(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner1:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldC2MinusAPlusC1(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner2:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldAMinusC1MinusC2(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner3:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldC1Minus2MinusC2(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner4:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldAMinusC1PlusC2(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner5:{
    // Match Patterns
    if(![&](){return Helper.matchCombineCopy(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineCopy(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner6:{
    unsigned GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineMulToShl(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineMulToShl(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner7:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineSubToAdd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner8:{
    std::pair<Register, bool> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineAddP2IToPtrAdd(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineAddP2IToPtrAdd(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner9:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVectorElement(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner10:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchInsertVectorElementOOB(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner11:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVectorElementWithDifferentIndices(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner12:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVectorElementWithBuildVector(*State.MIs[0], *State.MIs[1],
              GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner13:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVectorElementWithBuildVectorTrunc(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner14:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVectorElementWithShuffleVector(*State.MIs[0], *State.MIs[1],
              GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner15:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchAddOfVScale(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner16:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMulOfVScale(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner17:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShlOfVScale(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner18:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSubOfVScale(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner19:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return !isGuaranteedNotToBePoison(State.MIs[0]->getOperand(1).getReg(), MRI) && Helper.matchFreezeOfSingleMaybePoisonOperand(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner20:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncateOfExt(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner21:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtOfExt(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner22:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchRedundantSextInReg(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner23:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCastOfSelect(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner24:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCastOfBuildVector(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner25:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchNarrowBinop(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner26:{
    APInt GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCastOfInteger(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner27:{
    SmallVector<Register> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineInsertVecElts(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineInsertVecElts(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner28:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVecEltBuildVec(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyExtractVecEltBuildVec(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner29:{
    SmallVector<std::pair<Register, MachineInstr*>> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractAllEltsFromBuildVector(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyExtractAllEltsFromBuildVector(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner30:{
    PreferredTuple GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineExtendingLoads(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineExtendingLoads(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner31:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineLoadWithAndMask(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner32:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineExtractedVectorLoad(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner33:{
    // Match Patterns
    if(![&](){return Helper.matchAnyExplicitUseIsUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithFConstant(*State.MIs[0], 0.0);
    return true;
  }
  case GICXXCustomAction_GICombiner34:{
    // Match Patterns
    if(![&](){return Helper.matchAnyExplicitUseIsUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], 0);
    return true;
  }
  case GICXXCustomAction_GICombiner35:{
    // Match Patterns
    if(![&](){return Helper.matchAnyExplicitUseIsUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], -1);
    return true;
  }
  case GICXXCustomAction_GICombiner36:{
    // Match Patterns
    if(![&](){return Helper.matchOperandIsUndef(*State.MIs[0], 1);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], 0);
    return true;
  }
  case GICXXCustomAction_GICombiner37:{
    // Match Patterns
    if(![&](){return Helper.matchOperandIsUndef(*State.MIs[0], 2);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner38:{
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]->getOperand(0).getParent());
    return true;
  }
  case GICXXCustomAction_GICombiner39:{
    // Match Patterns
    if(![&](){return Helper.matchAnyExplicitUseIsUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner40:{
    // Match Patterns
    if(![&](){return Helper.matchAllExplicitUsesAreUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner41:{
    // Match Patterns
    if(![&](){return Helper.matchUndefShuffleVectorMask(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner42:{
    // Match Patterns
    if(![&](){return Helper.matchUndefStore(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.eraseInst(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner43:{
    // Match Patterns
    if(![&](){return Helper.matchInsertExtractVecEltOutOfBounds(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner44:{
    // Match Patterns
    if(![&](){return Helper.matchSelectSameVal(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], 2);
    return true;
  }
  case GICXXCustomAction_GICombiner45:{
    // Match Patterns
    if(![&](){return Helper.matchOperandIsZero(*State.MIs[0], 1);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], 1);
    return true;
  }
  case GICXXCustomAction_GICombiner46:{
    Register GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineI2PToP2I(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineI2PToP2I(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner47:{
    Register GIMatchData_info;
    // Match Patterns
    if(![&](){GIMatchData_info = State.MIs[1]->getOperand(1).getReg(); return true;}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineP2IToI2P(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner48:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineAnyExtTrunc(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner49:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchBuildVectorIdentityFold(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner50:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncBuildVectorFold(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner51:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncLshrBuildVectorFold(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner52:{
    // Match Patterns
    if(![&](){return MRI.getType(State.MIs[1]->getOperand(1).getReg()) == MRI.getType(State.MIs[0]->getOperand(0).getReg());}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], State.MIs[1]->getOperand(1).getReg());
    return true;
  }
  case GICXXCustomAction_GICombiner53:{
    MachineInstr* GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtendThroughPhis(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyExtendThroughPhis(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner54:{
    std::tuple<Register, Register> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchSimplifyAddToSub(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySimplifyAddToSub(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner55:{
    InstructionStepsMatchInfo GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchHoistLogicOpWithSameOpcodeHands(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildInstructionSteps(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner56:{
    std::optional<int64_t> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShiftsTooBig(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    if (GIMatchData_matchinfo) {
              Helper.replaceInstWithConstant(*State.MIs[0], *GIMatchData_matchinfo);
            } else {
              Helper.replaceInstWithUndef(*State.MIs[0]);
            }
    return true;
  }
  case GICXXCustomAction_GICombiner57:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchReassocPtrAdd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner58:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchReassocCommBinOp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner59:{
    PtrAddChain GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchPtrAddImmedChain(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyPtrAddImmedChain(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner60:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCanonicalizeICmp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner61:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCanonicalizeFCmp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner62:{
    int64_t GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchICmpToTrueFalseKnownBits(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner63:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchICmpToLHSKnownBits(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner64:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchRedundantBinOpInEquality(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner65:{
    std::tuple<Register, int64_t> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchAshrShlToSextInreg(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyAshShlToSextInreg(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner66:{
    std::tuple<Register, unsigned> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSextInRegOfLoad(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySextInRegOfLoad(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner67:{
    RegisterImmPair GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineShlOfExtend(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineShlOfExtend(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner68:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchNarrowBinopFeedingAnd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner69:{
    unsigned GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantSelectCmp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner70:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchSelectIMinMax(State.MIs[0]->getOperand(0), GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner71:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSelect(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner72:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchRedundantAnd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner73:{
    // Match Patterns
    if(![&](){return Helper.matchRedundantSExtInReg(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], 1);
    return true;
  }
  case GICXXCustomAction_GICombiner74:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchRedundantOr(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner75:{
    // Match Patterns
    if(![&](){return Helper.matchOperandIsKnownToBeAPowerOfTwo(*State.MIs[0], 2);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySimplifyURemByPow2(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner76:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineZextTrunc(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner77:{
    // Match Patterns
    if(![&](){unsigned BitWidth = MRI.getType(State.MIs[0]->getOperand(1).getReg()).getScalarSizeInBits();
                return Helper.getValueTracking()->maskedValueIsZero(State.MIs[0]->getOperand(1).getReg(),
                         APInt::getOneBitSet(BitWidth, State.MIs[0]->getOperand(2).getImm() - 1));}()) {
      return false;
    }
    // Apply Patterns
    Helper.getBuilder().setInstrAndDebugLoc(*State.MIs[0]);
              Helper.getBuilder().buildZExtInReg(State.MIs[0]->getOperand(0), State.MIs[0]->getOperand(1), State.MIs[0]->getOperand(2).getImm());
              State.MIs[0]->eraseFromParent();
    return true;
  }
  case GICXXCustomAction_GICombiner78:{
    std::pair<MachineInstr*, LLT> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineTruncOfShift(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineTruncOfShift(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner79:{
    SmallVector<Register> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchNotCmp(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyNotCmp(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner80:{
    MachineInstr * GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchOptBrCondByInvertingCond(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyOptBrCondByInvertingCond(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner81:{
    // Apply Patterns
    Helper.applyCombineConstantFoldFpUnary(*State.MIs[0], State.MIs[1]->getOperand(1).getFPImm());
    return true;
  }
  case GICXXCustomAction_GICombiner82:{
    // Apply Patterns
    Helper.replaceInstWithFConstant(*State.MIs[0]->getOperand(0).getParent(), 0.0);
    return true;
  }
  case GICXXCustomAction_GICombiner83:{
    APInt GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineConstPtrAddToI2P(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineConstPtrAddToI2P(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner84:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchOverlappingAnd(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner85:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMulOBy2(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner86:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMulOBy0(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner87:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchAddEToAddO(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner88:{
    unsigned GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFMinMaxNaN(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner89:{
    // Match Patterns
    if(![&](){return Helper.matchFPowIExpansion(*State.MIs[0], State.MIs[1]->getOperand(1).getCImm()->getSExtValue());}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyExpandFPowI(*State.MIs[0], State.MIs[1]->getOperand(1).getCImm()->getSExtValue());
    return true;
  }
  case GICXXCustomAction_GICombiner90:{
    std::pair<Register, Register> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchXorOfAndWithSameReg(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyXorOfAndWithSameReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner91:{
    // Match Patterns
    if(![&](){return Helper.matchPtrAddZero(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyPtrAddZero(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner92:{
    RegisterImmPair GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShiftImmedChain(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyShiftImmedChain(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner93:{
    ShiftOfShiftedLogic GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShiftOfShiftedLogic(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyShiftOfShiftedLogic(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner94:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchLoadOrCombine(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner95:{
    MachineInstr * GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineDivRem(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineDivRem(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner96:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchOrShiftToFunnelShift(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner97:{
    // Match Patterns
    if(![&](){return Helper.matchFunnelShiftToRotate(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyFunnelShiftToRotate(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner98:{
    // Match Patterns
    if(![&](){return Helper.matchConstantLargerBitWidth(*State.MIs[0], 3);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyFunnelShiftConstantModulo(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner99:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCommuteShift(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner100:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchBitfieldExtractFromSExtInReg(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner101:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchBitfieldExtractFromAnd(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner102:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchBitfieldExtractFromShr(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner103:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchBitfieldExtractFromShrAnd(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner104:{
    APInt GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantFoldBinOp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner105:{
    ConstantFP* GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantFoldFPBinOp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithFConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner106:{
    ConstantFP* GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantFoldFMA(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithFConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner107:{
    APInt GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantFoldCastOp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner108:{
    // Match Patterns
    if(![&](){return Helper.matchUMulHToLShr(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyUMulHToLShr(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner109:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchRedundantNegOperands(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner110:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchAndOrDisjointMask(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner111:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFAddFMulToFMadOrFMA(*State.MIs[0],
                                                                  GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner112:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFAddFpExtFMulToFMadOrFMA(*State.MIs[0],
                                                                       GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner113:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFAddFMAFMulToFMadOrFMA(*State.MIs[0],
                                                                     GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner114:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFAddFpExtFMulToFMadOrFMAAggressive(
                                                          *State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner115:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFSubFMulToFMadOrFMA(*State.MIs[0],
                                                                  GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner116:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFSubFNegFMulToFMadOrFMA(*State.MIs[0],
                                                                      GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner117:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFSubFpExtFMulToFMadOrFMA(*State.MIs[0],
                                                                       GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner118:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFSubFpExtFNegFMulToFMadOrFMA(
                                                    *State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner119:{
    unsigned GIMatchData_select_op_no;
    // Match Patterns
    if(![&](){return Helper.matchFoldBinOpIntoSelect(*State.MIs[0], GIMatchData_select_op_no);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyFoldBinOpIntoSelect(*State.MIs[0], GIMatchData_select_op_no);
    return true;
  }
  case GICXXCustomAction_GICombiner120:{
    // Match Patterns
    if(![&](){return Helper.matchUDivorURemByConst(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyUDivorURemByConst(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner121:{
    // Match Patterns
    if(![&](){return Helper.matchDivByPow2(*State.MIs[0], /*IsSigned=*/false);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyUDivByPow2(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner122:{
    // Match Patterns
    if(![&](){return Helper.matchDivByPow2(*State.MIs[0], /*IsSigned=*/true);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySDivByPow2(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner123:{
    // Match Patterns
    if(![&](){return Helper.matchSDivByConst(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySDivByConst(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner124:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSubAddSameReg(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner125:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchSimplifySelectToMinMax(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner126:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFsubToFneg(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyFsubToFneg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner127:{
    // Match Patterns
    if(![&](){return Helper.matchCommuteConstantToRHS(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCommuteBinOpOperands(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner128:{
    // Match Patterns
    if(![&](){return Helper.matchCommuteFPConstantToRHS(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCommuteBinOpOperands(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner129:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchAnd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner130:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchOr(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner131:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSimplifyNegMinMax(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner132:{
    SmallVector<Register> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineConcatVectors(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineConcatVectors(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner133:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSextOfTrunc(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner134:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchZextOfTrunc(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner135:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchNonNegZext(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner136:{
    SmallVector<Register> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineShuffleConcat(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineShuffleConcat(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner137:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShuffleUndefRHS(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner138:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShuffleDisjointMask(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner139:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchUseVectorTruncate(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyUseVectorTruncate(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner140:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchUnmergeValuesAnyExtBuildVector(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner141:{
    SmallVector<Register> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeMergeToPlainValues(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineUnmergeMergeToPlainValues(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner142:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineMergeUnmerge(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner143:{
    SmallVector<APInt, 8> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeConstant(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineUnmergeConstant(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner144:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeUndef(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner145:{
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeWithDeadLanesToTrunc(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineUnmergeWithDeadLanesToTrunc(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner146:{
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeZExtToZExt(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineUnmergeZExtToZExt(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner147:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMergeXAndUndef(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner148:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMergeXAndZero(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner149:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchAddOverflow(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner150:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSuboCarryOut(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  }
  llvm_unreachable("Unknown Apply Action");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *RISCVPreLegalizerCombinerImpl::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
     /*    0 */ GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(20), GIMT_Encode2(268), /*)*//*default:*//*Label 95*/ GIMT_Encode4(7046),
     /*   10 */ /*TargetOpcode::COPY*//*Label 0*/ GIMT_Encode4(1002), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  142 */ /*TargetOpcode::G_ADD*//*Label 1*/ GIMT_Encode4(1014),
     /*  146 */ /*TargetOpcode::G_SUB*//*Label 2*/ GIMT_Encode4(1571),
     /*  150 */ /*TargetOpcode::G_MUL*//*Label 3*/ GIMT_Encode4(1889),
     /*  154 */ /*TargetOpcode::G_SDIV*//*Label 4*/ GIMT_Encode4(2055),
     /*  158 */ /*TargetOpcode::G_UDIV*//*Label 5*/ GIMT_Encode4(2128),
     /*  162 */ /*TargetOpcode::G_SREM*//*Label 6*/ GIMT_Encode4(2212),
     /*  166 */ /*TargetOpcode::G_UREM*//*Label 7*/ GIMT_Encode4(2257), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  178 */ /*TargetOpcode::G_AND*//*Label 8*/ GIMT_Encode4(2335),
     /*  182 */ /*TargetOpcode::G_OR*//*Label 9*/ GIMT_Encode4(2616),
     /*  186 */ /*TargetOpcode::G_XOR*//*Label 10*/ GIMT_Encode4(2861), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  202 */ /*TargetOpcode::G_PHI*//*Label 11*/ GIMT_Encode4(2962), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  226 */ /*TargetOpcode::G_UNMERGE_VALUES*//*Label 12*/ GIMT_Encode4(2974), GIMT_Encode4(0),
     /*  234 */ /*TargetOpcode::G_MERGE_VALUES*//*Label 13*/ GIMT_Encode4(3041),
     /*  238 */ /*TargetOpcode::G_BUILD_VECTOR*//*Label 14*/ GIMT_Encode4(3115),
     /*  242 */ /*TargetOpcode::G_BUILD_VECTOR_TRUNC*//*Label 15*/ GIMT_Encode4(3163),
     /*  246 */ /*TargetOpcode::G_CONCAT_VECTORS*//*Label 16*/ GIMT_Encode4(3175),
     /*  250 */ /*TargetOpcode::G_PTRTOINT*//*Label 17*/ GIMT_Encode4(3187),
     /*  254 */ /*TargetOpcode::G_INTTOPTR*//*Label 18*/ GIMT_Encode4(3230),
     /*  258 */ /*TargetOpcode::G_BITCAST*//*Label 19*/ GIMT_Encode4(3263),
     /*  262 */ /*TargetOpcode::G_FREEZE*//*Label 20*/ GIMT_Encode4(3306), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  302 */ /*TargetOpcode::G_LOAD*//*Label 21*/ GIMT_Encode4(3370),
     /*  306 */ /*TargetOpcode::G_SEXTLOAD*//*Label 22*/ GIMT_Encode4(3382),
     /*  310 */ /*TargetOpcode::G_ZEXTLOAD*//*Label 23*/ GIMT_Encode4(3394), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  326 */ /*TargetOpcode::G_STORE*//*Label 24*/ GIMT_Encode4(3406), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  462 */ /*TargetOpcode::G_ANYEXT*//*Label 25*/ GIMT_Encode4(3418),
     /*  466 */ /*TargetOpcode::G_TRUNC*//*Label 26*/ GIMT_Encode4(3546), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  498 */ /*TargetOpcode::G_SEXT*//*Label 27*/ GIMT_Encode4(3904),
     /*  502 */ /*TargetOpcode::G_SEXT_INREG*//*Label 28*/ GIMT_Encode4(3979),
     /*  506 */ /*TargetOpcode::G_ZEXT*//*Label 29*/ GIMT_Encode4(4045),
     /*  510 */ /*TargetOpcode::G_SHL*//*Label 30*/ GIMT_Encode4(4175),
     /*  514 */ /*TargetOpcode::G_LSHR*//*Label 31*/ GIMT_Encode4(4344),
     /*  518 */ /*TargetOpcode::G_ASHR*//*Label 32*/ GIMT_Encode4(4467),
     /*  522 */ /*TargetOpcode::G_FSHL*//*Label 33*/ GIMT_Encode4(4601),
     /*  526 */ /*TargetOpcode::G_FSHR*//*Label 34*/ GIMT_Encode4(4644),
     /*  530 */ /*TargetOpcode::G_ROTR*//*Label 35*/ GIMT_Encode4(4687),
     /*  534 */ /*TargetOpcode::G_ROTL*//*Label 36*/ GIMT_Encode4(4711),
     /*  538 */ /*TargetOpcode::G_ICMP*//*Label 37*/ GIMT_Encode4(4735),
     /*  542 */ /*TargetOpcode::G_FCMP*//*Label 38*/ GIMT_Encode4(4780), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  554 */ /*TargetOpcode::G_SELECT*//*Label 39*/ GIMT_Encode4(4792),
     /*  558 */ /*TargetOpcode::G_UADDO*//*Label 40*/ GIMT_Encode4(4887),
     /*  562 */ /*TargetOpcode::G_UADDE*//*Label 41*/ GIMT_Encode4(4910),
     /*  566 */ /*TargetOpcode::G_USUBO*//*Label 42*/ GIMT_Encode4(4922),
     /*  570 */ /*TargetOpcode::G_USUBE*//*Label 43*/ GIMT_Encode4(4934),
     /*  574 */ /*TargetOpcode::G_SADDO*//*Label 44*/ GIMT_Encode4(4946),
     /*  578 */ /*TargetOpcode::G_SADDE*//*Label 45*/ GIMT_Encode4(4969),
     /*  582 */ /*TargetOpcode::G_SSUBO*//*Label 46*/ GIMT_Encode4(4981),
     /*  586 */ /*TargetOpcode::G_SSUBE*//*Label 47*/ GIMT_Encode4(4993),
     /*  590 */ /*TargetOpcode::G_UMULO*//*Label 48*/ GIMT_Encode4(5005),
     /*  594 */ /*TargetOpcode::G_SMULO*//*Label 49*/ GIMT_Encode4(5039),
     /*  598 */ /*TargetOpcode::G_UMULH*//*Label 50*/ GIMT_Encode4(5073),
     /*  602 */ /*TargetOpcode::G_SMULH*//*Label 51*/ GIMT_Encode4(5096),
     /*  606 */ /*TargetOpcode::G_UADDSAT*//*Label 52*/ GIMT_Encode4(5108),
     /*  610 */ /*TargetOpcode::G_SADDSAT*//*Label 53*/ GIMT_Encode4(5120), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  622 */ /*TargetOpcode::G_USHLSAT*//*Label 54*/ GIMT_Encode4(5132),
     /*  626 */ /*TargetOpcode::G_SSHLSAT*//*Label 55*/ GIMT_Encode4(5155),
     /*  630 */ /*TargetOpcode::G_SMULFIX*//*Label 56*/ GIMT_Encode4(5178),
     /*  634 */ /*TargetOpcode::G_UMULFIX*//*Label 57*/ GIMT_Encode4(5190),
     /*  638 */ /*TargetOpcode::G_SMULFIXSAT*//*Label 58*/ GIMT_Encode4(5202),
     /*  642 */ /*TargetOpcode::G_UMULFIXSAT*//*Label 59*/ GIMT_Encode4(5214), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  662 */ /*TargetOpcode::G_FADD*//*Label 60*/ GIMT_Encode4(5226),
     /*  666 */ /*TargetOpcode::G_FSUB*//*Label 61*/ GIMT_Encode4(5338),
     /*  670 */ /*TargetOpcode::G_FMUL*//*Label 62*/ GIMT_Encode4(5427),
     /*  674 */ /*TargetOpcode::G_FMA*//*Label 63*/ GIMT_Encode4(5515),
     /*  678 */ /*TargetOpcode::G_FMAD*//*Label 64*/ GIMT_Encode4(5538),
     /*  682 */ /*TargetOpcode::G_FDIV*//*Label 65*/ GIMT_Encode4(5561),
     /*  686 */ /*TargetOpcode::G_FREM*//*Label 66*/ GIMT_Encode4(5595), GIMT_Encode4(0),
     /*  694 */ /*TargetOpcode::G_FPOWI*//*Label 67*/ GIMT_Encode4(5607), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  714 */ /*TargetOpcode::G_FLOG2*//*Label 68*/ GIMT_Encode4(5629), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  730 */ /*TargetOpcode::G_FNEG*//*Label 69*/ GIMT_Encode4(5651), GIMT_Encode4(0),
     /*  738 */ /*TargetOpcode::G_FPTRUNC*//*Label 70*/ GIMT_Encode4(5702),
     /*  742 */ /*TargetOpcode::G_FPTOSI*//*Label 71*/ GIMT_Encode4(5745),
     /*  746 */ /*TargetOpcode::G_FPTOUI*//*Label 72*/ GIMT_Encode4(5767),
     /*  750 */ /*TargetOpcode::G_SITOFP*//*Label 73*/ GIMT_Encode4(5789),
     /*  754 */ /*TargetOpcode::G_UITOFP*//*Label 74*/ GIMT_Encode4(5816), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  766 */ /*TargetOpcode::G_FABS*//*Label 75*/ GIMT_Encode4(5843), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  778 */ /*TargetOpcode::G_FCANONICALIZE*//*Label 76*/ GIMT_Encode4(5922),
     /*  782 */ /*TargetOpcode::G_FMINNUM*//*Label 77*/ GIMT_Encode4(5952),
     /*  786 */ /*TargetOpcode::G_FMAXNUM*//*Label 78*/ GIMT_Encode4(5986),
     /*  790 */ /*TargetOpcode::G_FMINNUM_IEEE*//*Label 79*/ GIMT_Encode4(6020),
     /*  794 */ /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 80*/ GIMT_Encode4(6032),
     /*  798 */ /*TargetOpcode::G_FMINIMUM*//*Label 81*/ GIMT_Encode4(6044),
     /*  802 */ /*TargetOpcode::G_FMAXIMUM*//*Label 82*/ GIMT_Encode4(6078), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  842 */ /*TargetOpcode::G_PTR_ADD*//*Label 83*/ GIMT_Encode4(6112), GIMT_Encode4(0),
     /*  850 */ /*TargetOpcode::G_SMIN*//*Label 84*/ GIMT_Encode4(6202),
     /*  854 */ /*TargetOpcode::G_SMAX*//*Label 85*/ GIMT_Encode4(6236),
     /*  858 */ /*TargetOpcode::G_UMIN*//*Label 86*/ GIMT_Encode4(6270),
     /*  862 */ /*TargetOpcode::G_UMAX*//*Label 87*/ GIMT_Encode4(6304),
     /*  866 */ /*TargetOpcode::G_ABS*//*Label 88*/ GIMT_Encode4(6338), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  878 */ /*TargetOpcode::G_BR*//*Label 89*/ GIMT_Encode4(6350), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  898 */ /*TargetOpcode::G_INSERT_VECTOR_ELT*//*Label 90*/ GIMT_Encode4(6362),
     /*  902 */ /*TargetOpcode::G_EXTRACT_VECTOR_ELT*//*Label 91*/ GIMT_Encode4(6492),
     /*  906 */ /*TargetOpcode::G_SHUFFLE_VECTOR*//*Label 92*/ GIMT_Encode4(6869), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  946 */ /*TargetOpcode::G_BITREVERSE*//*Label 93*/ GIMT_Encode4(6935), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  998 */ /*TargetOpcode::G_FSQRT*//*Label 94*/ GIMT_Encode4(7024),
     /* 1002 */ // Label 0: @1002
     /* 1002 */ GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(1013), // Rule ID 13 //
     /* 1007 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule13Enabled),
     /* 1010 */   // MIs[0] d
     /* 1010 */   // No operand predicates
     /* 1010 */   // MIs[0] s
     /* 1010 */   // No operand predicates
     /* 1010 */   // Combiner Rule #13: copy_prop
     /* 1010 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner5),
     /* 1013 */ // Label 96: @1013
     /* 1013 */ GIM_Reject,
     /* 1014 */ // Label 1: @1014
     /* 1014 */ GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(1025), // Rule ID 16 //
     /* 1019 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule16Enabled),
     /* 1022 */   // Combiner Rule #16: add_p2i_to_ptradd; wip_match_opcode 'G_ADD'
     /* 1022 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner8),
     /* 1025 */ // Label 97: @1025
     /* 1025 */ GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(1036), // Rule ID 94 //
     /* 1030 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule78Enabled),
     /* 1033 */   // Combiner Rule #78: propagate_undef_any_op; wip_match_opcode 'G_ADD'
     /* 1033 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 1036 */ // Label 98: @1036
     /* 1036 */ GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(1047), // Rule ID 141 //
     /* 1041 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule103Enabled),
     /* 1044 */   // Combiner Rule #103: simplify_add_to_sub; wip_match_opcode 'G_ADD'
     /* 1044 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner54),
     /* 1047 */ // Label 99: @1047
     /* 1047 */ GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(1058), // Rule ID 231 //
     /* 1052 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 1055 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_ADD'
     /* 1055 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 1058 */ // Label 100: @1058
     /* 1058 */ GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(1069), // Rule ID 275 //
     /* 1063 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 1066 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_ADD'
     /* 1066 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 1069 */ // Label 101: @1069
     /* 1069 */ GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(1080), // Rule ID 309 //
     /* 1074 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 1077 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_ADD'
     /* 1077 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 1080 */ // Label 102: @1080
     /* 1080 */ GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(1114), // Rule ID 0 //
     /* 1085 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule0Enabled),
     /* 1088 */   // MIs[0] root
     /* 1088 */   // No operand predicates
     /* 1088 */   // MIs[0] sub
     /* 1088 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1092 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1096 */   // MIs[1] Operand 1
     /* 1096 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 0,
     /* 1100 */   // MIs[1] A
     /* 1100 */   // No operand predicates
     /* 1100 */   // MIs[0] B
     /* 1100 */   // No operand predicates
     /* 1100 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1102 */   // Combiner Rule #0: ZeroMinusAPlusB
     /* 1102 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1105 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1107 */   GIR_RootToRootCopy, /*OpIdx*/2, // B
     /* 1109 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // A
     /* 1113 */   GIR_EraseRootFromParent_Done,
     /* 1114 */ // Label 103: @1114
     /* 1114 */ GIM_Try, /*On fail goto*//*Label 104*/ GIMT_Encode4(1151), // Rule ID 12 //
     /* 1119 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule12Enabled),
     /* 1122 */   // MIs[0] root
     /* 1122 */   // No operand predicates
     /* 1122 */   // MIs[0] sub
     /* 1122 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1126 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1130 */   // MIs[1] A
     /* 1130 */   // No operand predicates
     /* 1130 */   // MIs[1] c1
     /* 1130 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1134 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1138 */   // MIs[2] imm1
     /* 1138 */   // No operand predicates
     /* 1138 */   // MIs[0] c2
     /* 1138 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 1142 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1146 */   // MIs[3] imm2
     /* 1146 */   // No operand predicates
     /* 1146 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1148 */   // Combiner Rule #12: AMinusC1PlusC2
     /* 1148 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner4),
     /* 1151 */ // Label 104: @1151
     /* 1151 */ GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(1185), // Rule ID 3 //
     /* 1156 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule3Enabled),
     /* 1159 */   // MIs[0] root
     /* 1159 */   // No operand predicates
     /* 1159 */   // MIs[0] sub
     /* 1159 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1163 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1167 */   // MIs[1] B
     /* 1167 */   // No operand predicates
     /* 1167 */   // MIs[1] A
     /* 1167 */   // No operand predicates
     /* 1167 */   // MIs[0] A
     /* 1167 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 1172 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1177 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1179 */   // Combiner Rule #3: BMinusAPlusA
     /* 1179 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1184 */   GIR_EraseRootFromParent_Done,
     /* 1185 */ // Label 105: @1185
     /* 1185 */ GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(1219), // Rule ID 131 //
     /* 1190 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule94Enabled),
     /* 1193 */   // MIs[0] dst
     /* 1193 */   // No operand predicates
     /* 1193 */   // MIs[0] __add_sub_reg_match_0.tmp
     /* 1193 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1197 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1201 */   // MIs[1] src
     /* 1201 */   // No operand predicates
     /* 1201 */   // MIs[1] __add_sub_reg_match_0.x
     /* 1201 */   // No operand predicates
     /* 1201 */   // MIs[0] __add_sub_reg_match_0.x
     /* 1201 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 1206 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1211 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1213 */   // Combiner Rule #94: add_sub_reg @ [__add_sub_reg_match_0[1]]
     /* 1213 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1218 */   GIR_EraseRootFromParent_Done,
     /* 1219 */ // Label 106: @1219
     /* 1219 */ GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(1264), // Rule ID 5 //
     /* 1224 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule5Enabled),
     /* 1227 */   // MIs[0] root
     /* 1227 */   // No operand predicates
     /* 1227 */   // MIs[0] sub1
     /* 1227 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1231 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1235 */   // MIs[1] A
     /* 1235 */   // No operand predicates
     /* 1235 */   // MIs[1] B
     /* 1235 */   // No operand predicates
     /* 1235 */   // MIs[0] sub2
     /* 1235 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 1239 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1243 */   // MIs[2] B
     /* 1243 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 1248 */   // MIs[2] C
     /* 1248 */   // No operand predicates
     /* 1248 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1250 */   // Combiner Rule #5: AMinusBPlusBMinusC
     /* 1250 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1253 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1255 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // A
     /* 1259 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // C
     /* 1263 */   GIR_EraseRootFromParent_Done,
     /* 1264 */ // Label 107: @1264
     /* 1264 */ GIM_Try, /*On fail goto*//*Label 108*/ GIMT_Encode4(1309), // Rule ID 4 //
     /* 1269 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule4Enabled),
     /* 1272 */   // MIs[0] root
     /* 1272 */   // No operand predicates
     /* 1272 */   // MIs[0] sub1
     /* 1272 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1276 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1280 */   // MIs[1] A
     /* 1280 */   // No operand predicates
     /* 1280 */   // MIs[1] B
     /* 1280 */   // No operand predicates
     /* 1280 */   // MIs[0] sub2
     /* 1280 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 1284 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1288 */   // MIs[2] C
     /* 1288 */   // No operand predicates
     /* 1288 */   // MIs[2] A
     /* 1288 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /* 1293 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1295 */   // Combiner Rule #4: AMinusBPlusCMinusA
     /* 1295 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1298 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1300 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // C
     /* 1304 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // B
     /* 1308 */   GIR_EraseRootFromParent_Done,
     /* 1309 */ // Label 108: @1309
     /* 1309 */ GIM_Try, /*On fail goto*//*Label 109*/ GIMT_Encode4(1344), // Rule ID 39 //
     /* 1314 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule37Enabled),
     /* 1317 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::NoSWrap),
     /* 1323 */   // MIs[0] root
     /* 1323 */   // No operand predicates
     /* 1323 */   // MIs[0] left
     /* 1323 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1327 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VSCALE),
     /* 1331 */   // MIs[1] imm1
     /* 1331 */   // No operand predicates
     /* 1331 */   // MIs[0] right
     /* 1331 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 1335 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_VSCALE),
     /* 1339 */   // MIs[2] imm2
     /* 1339 */   // No operand predicates
     /* 1339 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1341 */   // Combiner Rule #37: add_of_vscale
     /* 1341 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner15),
     /* 1344 */ // Label 109: @1344
     /* 1344 */ GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(1378), // Rule ID 1 //
     /* 1349 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule1Enabled),
     /* 1352 */   // MIs[0] root
     /* 1352 */   // No operand predicates
     /* 1352 */   // MIs[0] A
     /* 1352 */   // No operand predicates
     /* 1352 */   // MIs[0] sub
     /* 1352 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1356 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1360 */   // MIs[1] Operand 1
     /* 1360 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 0,
     /* 1364 */   // MIs[1] B
     /* 1364 */   // No operand predicates
     /* 1364 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1366 */   // Combiner Rule #1: APlusZeroMinusB
     /* 1366 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1369 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1371 */   GIR_RootToRootCopy, /*OpIdx*/1, // A
     /* 1373 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // B
     /* 1377 */   GIR_EraseRootFromParent_Done,
     /* 1378 */ // Label 110: @1378
     /* 1378 */ GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(1412), // Rule ID 2 //
     /* 1383 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule2Enabled),
     /* 1386 */   // MIs[0] root
     /* 1386 */   // No operand predicates
     /* 1386 */   // MIs[0] A
     /* 1386 */   // No operand predicates
     /* 1386 */   // MIs[0] sub
     /* 1386 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1390 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1394 */   // MIs[1] B
     /* 1394 */   // No operand predicates
     /* 1394 */   // MIs[1] A
     /* 1394 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/1, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1399 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1404 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1406 */   // Combiner Rule #2: APlusBMinusB
     /* 1406 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1411 */   GIR_EraseRootFromParent_Done,
     /* 1412 */ // Label 111: @1412
     /* 1412 */ GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(1446), // Rule ID 130 //
     /* 1417 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule94Enabled),
     /* 1420 */   // MIs[0] dst
     /* 1420 */   // No operand predicates
     /* 1420 */   // MIs[0] __add_sub_reg_match_0.x
     /* 1420 */   // No operand predicates
     /* 1420 */   // MIs[0] __add_sub_reg_match_0.tmp
     /* 1420 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1424 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1428 */   // MIs[1] src
     /* 1428 */   // No operand predicates
     /* 1428 */   // MIs[1] __add_sub_reg_match_0.x
     /* 1428 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/1, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1433 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1438 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1440 */   // Combiner Rule #94: add_sub_reg @ [__add_sub_reg_match_0[0]]
     /* 1440 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1445 */   GIR_EraseRootFromParent_Done,
     /* 1446 */ // Label 112: @1446
     /* 1446 */ GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(1491), // Rule ID 6 //
     /* 1451 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule6Enabled),
     /* 1454 */   // MIs[0] root
     /* 1454 */   // No operand predicates
     /* 1454 */   // MIs[0] A
     /* 1454 */   // No operand predicates
     /* 1454 */   // MIs[0] sub1
     /* 1454 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1458 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1462 */   // MIs[1] B
     /* 1462 */   // No operand predicates
     /* 1462 */   // MIs[1] add1
     /* 1462 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1466 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 1470 */   // MIs[2] A
     /* 1470 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1475 */   // MIs[2] C
     /* 1475 */   // No operand predicates
     /* 1475 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1477 */   // Combiner Rule #6: APlusBMinusAplusC
     /* 1477 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1480 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1482 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // B
     /* 1486 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // C
     /* 1490 */   GIR_EraseRootFromParent_Done,
     /* 1491 */ // Label 113: @1491
     /* 1491 */ GIM_Try, /*On fail goto*//*Label 114*/ GIMT_Encode4(1536), // Rule ID 7 //
     /* 1496 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule7Enabled),
     /* 1499 */   // MIs[0] root
     /* 1499 */   // No operand predicates
     /* 1499 */   // MIs[0] A
     /* 1499 */   // No operand predicates
     /* 1499 */   // MIs[0] sub1
     /* 1499 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1503 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1507 */   // MIs[1] B
     /* 1507 */   // No operand predicates
     /* 1507 */   // MIs[1] add1
     /* 1507 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1511 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 1515 */   // MIs[2] C
     /* 1515 */   // No operand predicates
     /* 1515 */   // MIs[2] A
     /* 1515 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1520 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1522 */   // Combiner Rule #7: APlusBMinusCPlusA
     /* 1522 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1525 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1527 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // B
     /* 1531 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // C
     /* 1535 */   GIR_EraseRootFromParent_Done,
     /* 1536 */ // Label 114: @1536
     /* 1536 */ GIM_Try, /*On fail goto*//*Label 115*/ GIMT_Encode4(1559), // Rule ID 105 //
     /* 1541 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 1544 */   // MIs[0] dst
     /* 1544 */   // No operand predicates
     /* 1544 */   // MIs[0] lhs
     /* 1544 */   // No operand predicates
     /* 1544 */   // MIs[0] Operand 2
     /* 1544 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1548 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1553 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[1]]
     /* 1553 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1558 */   GIR_EraseRootFromParent_Done,
     /* 1559 */ // Label 115: @1559
     /* 1559 */ GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(1570), // Rule ID 149 //
     /* 1564 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule107Enabled),
     /* 1567 */   // MIs[0] root
     /* 1567 */   // No operand predicates
     /* 1567 */   // MIs[0] src1
     /* 1567 */   // No operand predicates
     /* 1567 */   // MIs[0] src2
     /* 1567 */   // No operand predicates
     /* 1567 */   // Combiner Rule #107: reassoc_comm_binops
     /* 1567 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner58),
     /* 1570 */ // Label 116: @1570
     /* 1570 */ GIM_Reject,
     /* 1571 */ // Label 2: @1571
     /* 1571 */ GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(1582), // Rule ID 95 //
     /* 1576 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule78Enabled),
     /* 1579 */   // Combiner Rule #78: propagate_undef_any_op; wip_match_opcode 'G_SUB'
     /* 1579 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 1582 */ // Label 117: @1582
     /* 1582 */ GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(1593), // Rule ID 239 //
     /* 1587 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 1590 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_SUB'
     /* 1590 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 1593 */ // Label 118: @1593
     /* 1593 */ GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(1604), // Rule ID 276 //
     /* 1598 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 1601 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_SUB'
     /* 1601 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 1604 */ // Label 119: @1604
     /* 1604 */ GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(1615), // Rule ID 306 //
     /* 1609 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule188Enabled),
     /* 1612 */   // Combiner Rule #188: sub_add_reg; wip_match_opcode 'G_SUB'
     /* 1612 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner124),
     /* 1615 */ // Label 120: @1615
     /* 1615 */ GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(1626), // Rule ID 340 //
     /* 1620 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 1623 */   // Combiner Rule #195: simplify_neg_minmax; wip_match_opcode 'G_SUB'
     /* 1623 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner131),
     /* 1626 */ // Label 121: @1626
     /* 1626 */ GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(1663), // Rule ID 8 //
     /* 1631 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule8Enabled),
     /* 1634 */   // MIs[0] root
     /* 1634 */   // No operand predicates
     /* 1634 */   // MIs[0] add
     /* 1634 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1638 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 1642 */   // MIs[1] A
     /* 1642 */   // No operand predicates
     /* 1642 */   // MIs[1] c1
     /* 1642 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1646 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1650 */   // MIs[2] imm1
     /* 1650 */   // No operand predicates
     /* 1650 */   // MIs[0] c2
     /* 1650 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 1654 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1658 */   // MIs[3] imm2
     /* 1658 */   // No operand predicates
     /* 1658 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1660 */   // Combiner Rule #8: APlusC1MinusC2
     /* 1660 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner0),
     /* 1663 */ // Label 122: @1663
     /* 1663 */ GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(1700), // Rule ID 11 //
     /* 1668 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule11Enabled),
     /* 1671 */   // MIs[0] root
     /* 1671 */   // No operand predicates
     /* 1671 */   // MIs[0] sub1
     /* 1671 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1675 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1679 */   // MIs[1] c1
     /* 1679 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /* 1683 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1687 */   // MIs[2] imm1
     /* 1687 */   // No operand predicates
     /* 1687 */   // MIs[1] A
     /* 1687 */   // No operand predicates
     /* 1687 */   // MIs[0] c2
     /* 1687 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 1691 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1695 */   // MIs[3] imm2
     /* 1695 */   // No operand predicates
     /* 1695 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1697 */   // Combiner Rule #11: C1Minus2MinusC2
     /* 1697 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner3),
     /* 1700 */ // Label 123: @1700
     /* 1700 */ GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(1737), // Rule ID 10 //
     /* 1705 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule10Enabled),
     /* 1708 */   // MIs[0] root
     /* 1708 */   // No operand predicates
     /* 1708 */   // MIs[0] sub1
     /* 1708 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1712 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1716 */   // MIs[1] A
     /* 1716 */   // No operand predicates
     /* 1716 */   // MIs[1] c1
     /* 1716 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1720 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1724 */   // MIs[2] imm1
     /* 1724 */   // No operand predicates
     /* 1724 */   // MIs[0] c2
     /* 1724 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 1728 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1732 */   // MIs[3] imm2
     /* 1732 */   // No operand predicates
     /* 1732 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1734 */   // Combiner Rule #10: AMinusC1MinusC2
     /* 1734 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner2),
     /* 1737 */ // Label 124: @1737
     /* 1737 */ GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(1780), // Rule ID 159 //
     /* 1742 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule117Enabled),
     /* 1745 */   // MIs[0] dst
     /* 1745 */   // No operand predicates
     /* 1745 */   // MIs[0] Operand 1
     /* 1745 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /* 1749 */   // MIs[0] and
     /* 1749 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1753 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /* 1757 */   // MIs[1] x
     /* 1757 */   // No operand predicates
     /* 1757 */   // MIs[1] Operand 2
     /* 1757 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /* 1761 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner7),
     /* 1765 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1767 */   // Combiner Rule #117: neg_and_one_to_sext_inreg
     /* 1767 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /* 1770 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 1772 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
     /* 1776 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /* 1779 */   GIR_EraseRootFromParent_Done,
     /* 1780 */ // Label 125: @1780
     /* 1780 */ GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(1817), // Rule ID 9 //
     /* 1785 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule9Enabled),
     /* 1788 */   // MIs[0] root
     /* 1788 */   // No operand predicates
     /* 1788 */   // MIs[0] c2
     /* 1788 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1792 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1796 */   // MIs[1] imm2
     /* 1796 */   // No operand predicates
     /* 1796 */   // MIs[0] add
     /* 1796 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 1800 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 1804 */   // MIs[2] A
     /* 1804 */   // No operand predicates
     /* 1804 */   // MIs[2] c1
     /* 1804 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /* 1808 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1812 */   // MIs[3] imm1
     /* 1812 */   // No operand predicates
     /* 1812 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1814 */   // Combiner Rule #9: C2MinusAPlusC1
     /* 1814 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner1),
     /* 1817 */ // Label 126: @1817
     /* 1817 */ GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(1844), // Rule ID 42 //
     /* 1822 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule40Enabled),
     /* 1825 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::NoSWrap),
     /* 1831 */   // MIs[0] root
     /* 1831 */   // No operand predicates
     /* 1831 */   // MIs[0] x
     /* 1831 */   // No operand predicates
     /* 1831 */   // MIs[0] right
     /* 1831 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1835 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VSCALE),
     /* 1839 */   // MIs[1] imm
     /* 1839 */   // No operand predicates
     /* 1839 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1841 */   // Combiner Rule #40: sub_of_vscale
     /* 1841 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner18),
     /* 1844 */ // Label 127: @1844
     /* 1844 */ GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(1867), // Rule ID 104 //
     /* 1849 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 1852 */   // MIs[0] dst
     /* 1852 */   // No operand predicates
     /* 1852 */   // MIs[0] lhs
     /* 1852 */   // No operand predicates
     /* 1852 */   // MIs[0] Operand 2
     /* 1852 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1856 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1861 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[0]]
     /* 1861 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1866 */   GIR_EraseRootFromParent_Done,
     /* 1867 */ // Label 128: @1867
     /* 1867 */ GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(1888), // Rule ID 15 //
     /* 1872 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule15Enabled),
     /* 1875 */   // MIs[0] d
     /* 1875 */   // No operand predicates
     /* 1875 */   // MIs[0] op1
     /* 1875 */   // No operand predicates
     /* 1875 */   // MIs[0] c
     /* 1875 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1879 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1883 */   // MIs[1] imm
     /* 1883 */   // No operand predicates
     /* 1883 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1885 */   // Combiner Rule #15: sub_to_add
     /* 1885 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner7),
     /* 1888 */ // Label 129: @1888
     /* 1888 */ GIM_Reject,
     /* 1889 */ // Label 3: @1889
     /* 1889 */ GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(1900), // Rule ID 78 //
     /* 1894 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule72Enabled),
     /* 1897 */   // Combiner Rule #72: undef_to_int_zero; wip_match_opcode 'G_MUL'
     /* 1897 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner34),
     /* 1900 */ // Label 130: @1900
     /* 1900 */ GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(1911), // Rule ID 236 //
     /* 1905 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 1908 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_MUL'
     /* 1908 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 1911 */ // Label 131: @1911
     /* 1911 */ GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(1922), // Rule ID 310 //
     /* 1916 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 1919 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_MUL'
     /* 1919 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 1922 */ // Label 132: @1922
     /* 1922 */ GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(1962), // Rule ID 17 //
     /* 1927 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule17Enabled),
     /* 1930 */   // MIs[0] dst
     /* 1930 */   GIM_RecordRegType, /*MI*/0, /*Op*/0, /*TempTypeIdx*/uint8_t(-1),
     /* 1934 */   // MIs[0] x
     /* 1934 */   // No operand predicates
     /* 1934 */   // MIs[0] Operand 2
     /* 1934 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /* 1938 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/uint8_t(-1),
     /* 1941 */   GIR_BuildConstant, /*TempRegID*/0, /*Val*/GIMT_Encode8(0),
     /* 1951 */   // Combiner Rule #17: mul_by_neg_one
     /* 1951 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1954 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 1956 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 1959 */   GIR_RootToRootCopy, /*OpIdx*/1, // x
     /* 1961 */   GIR_EraseRootFromParent_Done,
     /* 1962 */ // Label 133: @1962
     /* 1962 */ GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(1997), // Rule ID 40 //
     /* 1967 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule38Enabled),
     /* 1970 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::NoSWrap),
     /* 1976 */   // MIs[0] root
     /* 1976 */   // No operand predicates
     /* 1976 */   // MIs[0] left
     /* 1976 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1980 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VSCALE),
     /* 1984 */   // MIs[1] scale
     /* 1984 */   // No operand predicates
     /* 1984 */   // MIs[0] x
     /* 1984 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 1988 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1992 */   // MIs[2] imm1
     /* 1992 */   // No operand predicates
     /* 1992 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1994 */   // Combiner Rule #38: mul_of_vscale
     /* 1994 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner16),
     /* 1997 */ // Label 134: @1997
     /* 1997 */ GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(2020), // Rule ID 123 //
     /* 2002 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 2005 */   // MIs[0] dst
     /* 2005 */   // No operand predicates
     /* 2005 */   // MIs[0] lhs
     /* 2005 */   // No operand predicates
     /* 2005 */   // MIs[0] zero
     /* 2005 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 2009 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/2,
     /* 2014 */   // Combiner Rule #87: binop_right_to_zero
     /* 2014 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/2,
     /* 2019 */   GIR_EraseRootFromParent_Done,
     /* 2020 */ // Label 135: @2020
     /* 2020 */ GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(2043), // Rule ID 128 //
     /* 2025 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule92Enabled),
     /* 2028 */   // MIs[0] dst
     /* 2028 */   // No operand predicates
     /* 2028 */   // MIs[0] x
     /* 2028 */   // No operand predicates
     /* 2028 */   // MIs[0] Operand 2
     /* 2028 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /* 2032 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2037 */   // Combiner Rule #92: right_identity_one_int
     /* 2037 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2042 */   GIR_EraseRootFromParent_Done,
     /* 2043 */ // Label 136: @2043
     /* 2043 */ GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(2054), // Rule ID 14 //
     /* 2048 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule14Enabled),
     /* 2051 */   // MIs[0] d
     /* 2051 */   // No operand predicates
     /* 2051 */   // MIs[0] op1
     /* 2051 */   // No operand predicates
     /* 2051 */   // MIs[0] op2
     /* 2051 */   // No operand predicates
     /* 2051 */   // Combiner Rule #14: mul_to_shl
     /* 2051 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner6),
     /* 2054 */ // Label 137: @2054
     /* 2054 */ GIM_Reject,
     /* 2055 */ // Label 4: @2055
     /* 2055 */ GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(2066), // Rule ID 119 //
     /* 2060 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 2063 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_SDIV'
     /* 2063 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 2066 */ // Label 138: @2066
     /* 2066 */ GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(2077), // Rule ID 211 //
     /* 2071 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule153Enabled),
     /* 2074 */   // Combiner Rule #153: div_rem_to_divrem; wip_match_opcode 'G_SDIV'
     /* 2074 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner95),
     /* 2077 */ // Label 139: @2077
     /* 2077 */ GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(2088), // Rule ID 242 //
     /* 2082 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 2085 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_SDIV'
     /* 2085 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2088 */ // Label 140: @2088
     /* 2088 */ GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(2099), // Rule ID 281 //
     /* 2093 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 2096 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_SDIV'
     /* 2096 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2099 */ // Label 141: @2099
     /* 2099 */ GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(2116), // Rule ID 303 //
     /* 2104 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 2107 */   GIM_MIFlagsNot, /*MI*/0, GIMT_Encode4(MachineInstr::IsExact),
     /* 2113 */   // MIs[0] dst
     /* 2113 */   // No operand predicates
     /* 2113 */   // MIs[0] x
     /* 2113 */   // No operand predicates
     /* 2113 */   // MIs[0] y
     /* 2113 */   // No operand predicates
     /* 2113 */   // Combiner Rule #185: sdiv_by_pow2
     /* 2113 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner122),
     /* 2116 */ // Label 142: @2116
     /* 2116 */ GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(2127), // Rule ID 305 //
     /* 2121 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule187Enabled),
     /* 2124 */   // MIs[0] dst
     /* 2124 */   // No operand predicates
     /* 2124 */   // MIs[0] x
     /* 2124 */   // No operand predicates
     /* 2124 */   // MIs[0] y
     /* 2124 */   // No operand predicates
     /* 2124 */   // Combiner Rule #187: sdiv_by_const
     /* 2124 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner123),
     /* 2127 */ // Label 143: @2127
     /* 2127 */ GIM_Reject,
     /* 2128 */ // Label 5: @2128
     /* 2128 */ GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(2139), // Rule ID 81 //
     /* 2133 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule74Enabled),
     /* 2136 */   // Combiner Rule #74: binop_left_undef_to_zero; wip_match_opcode 'G_UDIV'
     /* 2136 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner36),
     /* 2139 */ // Label 144: @2139
     /* 2139 */ GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(2150), // Rule ID 120 //
     /* 2144 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 2147 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_UDIV'
     /* 2147 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 2150 */ // Label 145: @2150
     /* 2150 */ GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(2161), // Rule ID 212 //
     /* 2155 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule153Enabled),
     /* 2158 */   // Combiner Rule #153: div_rem_to_divrem; wip_match_opcode 'G_UDIV'
     /* 2158 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner95),
     /* 2161 */ // Label 146: @2161
     /* 2161 */ GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(2172), // Rule ID 241 //
     /* 2166 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 2169 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_UDIV'
     /* 2169 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2172 */ // Label 147: @2172
     /* 2172 */ GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(2183), // Rule ID 283 //
     /* 2177 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 2180 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_UDIV'
     /* 2180 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2183 */ // Label 148: @2183
     /* 2183 */ GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(2200), // Rule ID 302 //
     /* 2188 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule184Enabled),
     /* 2191 */   GIM_MIFlagsNot, /*MI*/0, GIMT_Encode4(MachineInstr::IsExact),
     /* 2197 */   // MIs[0] dst
     /* 2197 */   // No operand predicates
     /* 2197 */   // MIs[0] x
     /* 2197 */   // No operand predicates
     /* 2197 */   // MIs[0] y
     /* 2197 */   // No operand predicates
     /* 2197 */   // Combiner Rule #184: udiv_by_pow2
     /* 2197 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner121),
     /* 2200 */ // Label 149: @2200
     /* 2200 */ GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(2211), // Rule ID 304 //
     /* 2205 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule186Enabled),
     /* 2208 */   // MIs[0] dst
     /* 2208 */   // No operand predicates
     /* 2208 */   // MIs[0] x
     /* 2208 */   // No operand predicates
     /* 2208 */   // MIs[0] y
     /* 2208 */   // No operand predicates
     /* 2208 */   // Combiner Rule #186: udiv_by_const
     /* 2208 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner120),
     /* 2211 */ // Label 150: @2211
     /* 2211 */ GIM_Reject,
     /* 2212 */ // Label 6: @2212
     /* 2212 */ GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(2223), // Rule ID 121 //
     /* 2217 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 2220 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_SREM'
     /* 2220 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 2223 */ // Label 151: @2223
     /* 2223 */ GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(2234), // Rule ID 213 //
     /* 2228 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule153Enabled),
     /* 2231 */   // Combiner Rule #153: div_rem_to_divrem; wip_match_opcode 'G_SREM'
     /* 2231 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner95),
     /* 2234 */ // Label 152: @2234
     /* 2234 */ GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(2245), // Rule ID 244 //
     /* 2239 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 2242 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_SREM'
     /* 2242 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2245 */ // Label 153: @2245
     /* 2245 */ GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(2256), // Rule ID 282 //
     /* 2250 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 2253 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_SREM'
     /* 2253 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2256 */ // Label 154: @2256
     /* 2256 */ GIM_Reject,
     /* 2257 */ // Label 7: @2257
     /* 2257 */ GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(2268), // Rule ID 82 //
     /* 2262 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule74Enabled),
     /* 2265 */   // Combiner Rule #74: binop_left_undef_to_zero; wip_match_opcode 'G_UREM'
     /* 2265 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner36),
     /* 2268 */ // Label 155: @2268
     /* 2268 */ GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(2279), // Rule ID 122 //
     /* 2273 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 2276 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_UREM'
     /* 2276 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 2279 */ // Label 156: @2279
     /* 2279 */ GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(2290), // Rule ID 170 //
     /* 2284 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule128Enabled),
     /* 2287 */   // Combiner Rule #128: urem_pow2_to_mask; wip_match_opcode 'G_UREM'
     /* 2287 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner75),
     /* 2290 */ // Label 157: @2290
     /* 2290 */ GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(2301), // Rule ID 214 //
     /* 2295 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule153Enabled),
     /* 2298 */   // Combiner Rule #153: div_rem_to_divrem; wip_match_opcode 'G_UREM'
     /* 2298 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner95),
     /* 2301 */ // Label 158: @2301
     /* 2301 */ GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(2312), // Rule ID 243 //
     /* 2306 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 2309 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_UREM'
     /* 2309 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2312 */ // Label 159: @2312
     /* 2312 */ GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(2323), // Rule ID 284 //
     /* 2317 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 2320 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_UREM'
     /* 2320 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2323 */ // Label 160: @2323
     /* 2323 */ GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(2334), // Rule ID 301 //
     /* 2328 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule183Enabled),
     /* 2331 */   // MIs[0] dst
     /* 2331 */   // No operand predicates
     /* 2331 */   // MIs[0] x
     /* 2331 */   // No operand predicates
     /* 2331 */   // MIs[0] y
     /* 2331 */   // No operand predicates
     /* 2331 */   // Combiner Rule #183: urem_by_const
     /* 2331 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner120),
     /* 2334 */ // Label 161: @2334
     /* 2334 */ GIM_Reject,
     /* 2335 */ // Label 8: @2335
     /* 2335 */ GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(2346), // Rule ID 73 //
     /* 2340 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule69Enabled),
     /* 2343 */   // Combiner Rule #69: load_and_mask; wip_match_opcode 'G_AND'
     /* 2343 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner31),
     /* 2346 */ // Label 162: @2346
     /* 2346 */ GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(2357), // Rule ID 77 //
     /* 2351 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule72Enabled),
     /* 2354 */   // Combiner Rule #72: undef_to_int_zero; wip_match_opcode 'G_AND'
     /* 2354 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner34),
     /* 2357 */ // Label 163: @2357
     /* 2357 */ GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(2368), // Rule ID 142 //
     /* 2362 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule104Enabled),
     /* 2365 */   // Combiner Rule #104: hoist_logic_op_with_same_opcode_hands; wip_match_opcode 'G_AND'
     /* 2365 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner55),
     /* 2368 */ // Label 164: @2368
     /* 2368 */ GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(2379), // Rule ID 162 //
     /* 2373 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule120Enabled),
     /* 2376 */   // Combiner Rule #120: narrow_binop_feeding_and; wip_match_opcode 'G_AND'
     /* 2376 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner68),
     /* 2379 */ // Label 165: @2379
     /* 2379 */ GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(2390), // Rule ID 167 //
     /* 2384 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule125Enabled),
     /* 2387 */   // Combiner Rule #125: redundant_and; wip_match_opcode 'G_AND'
     /* 2387 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner72),
     /* 2390 */ // Label 166: @2390
     /* 2390 */ GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(2401), // Rule ID 184 //
     /* 2395 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule142Enabled),
     /* 2398 */   // Combiner Rule #142: overlapping_and; wip_match_opcode 'G_AND'
     /* 2398 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner84),
     /* 2401 */ // Label 167: @2401
     /* 2401 */ GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(2412), // Rule ID 233 //
     /* 2406 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 2409 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_AND'
     /* 2409 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2412 */ // Label 168: @2412
     /* 2412 */ GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(2423), // Rule ID 266 //
     /* 2417 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule173Enabled),
     /* 2420 */   // Combiner Rule #173: and_or_disjoint_mask; wip_match_opcode 'G_AND'
     /* 2420 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner110),
     /* 2423 */ // Label 169: @2423
     /* 2423 */ GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(2434), // Rule ID 278 //
     /* 2428 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 2431 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_AND'
     /* 2431 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2434 */ // Label 170: @2434
     /* 2434 */ GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(2445), // Rule ID 311 //
     /* 2439 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 2442 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_AND'
     /* 2442 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 2445 */ // Label 171: @2445
     /* 2445 */ GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(2456), // Rule ID 338 //
     /* 2450 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule193Enabled),
     /* 2453 */   // Combiner Rule #193: match_ands; wip_match_opcode 'G_AND'
     /* 2453 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner129),
     /* 2456 */ // Label 172: @2456
     /* 2456 */ GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(2554), // Rule ID 155 //
     /* 2461 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule113Enabled),
     /* 2464 */   // MIs[0] root
     /* 2464 */   // No operand predicates
     /* 2464 */   // MIs[0] d1
     /* 2464 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2468 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2472 */   // MIs[1] p
     /* 2472 */   // No operand predicates
     /* 2472 */   // MIs[1] s1
     /* 2472 */   GIM_RecordRegType, /*MI*/1, /*Op*/2, /*TempTypeIdx*/uint8_t(-1),
     /* 2476 */   // MIs[1] Operand 3
     /* 2476 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 2480 */   // MIs[0] d2
     /* 2480 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 2484 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2488 */   // MIs[2] p
     /* 2488 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /* 2493 */   // MIs[2] s2
     /* 2493 */   // No operand predicates
     /* 2493 */   // MIs[2] Operand 3
     /* 2493 */   GIM_CheckConstantInt8, /*MI*/2, /*Op*/3, 0,
     /* 2497 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner5),
     /* 2501 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 2503 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/uint8_t(-1),
     /* 2506 */   GIR_BuildConstant, /*TempRegID*/1, /*Val*/GIMT_Encode8(0),
     /* 2516 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/uint8_t(-1),
     /* 2519 */   // Combiner Rule #113: double_icmp_zero_and_combine
     /* 2519 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_OR),
     /* 2522 */   GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 2527 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // s1
     /* 2531 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // s2
     /* 2535 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2539 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/0, // root
     /* 2543 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // p
     /* 2547 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
     /* 2550 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 2553 */   GIR_EraseRootFromParent_Done,
     /* 2554 */ // Label 173: @2554
     /* 2554 */ GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(2591), // Rule ID 226 //
     /* 2559 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule163Enabled),
     /* 2562 */   // MIs[0] root
     /* 2562 */   // No operand predicates
     /* 2562 */   // MIs[0] shift
     /* 2562 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2566 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 2570 */   // MIs[1] x
     /* 2570 */   // No operand predicates
     /* 2570 */   // MIs[1] lsb
     /* 2570 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 2574 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 2578 */   // MIs[2] imm1
     /* 2578 */   // No operand predicates
     /* 2578 */   // MIs[0] mask
     /* 2578 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 2582 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 2586 */   // MIs[3] imm2
     /* 2586 */   // No operand predicates
     /* 2586 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 2588 */   // Combiner Rule #163: bitfield_extract_from_and
     /* 2588 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner101),
     /* 2591 */ // Label 174: @2591
     /* 2591 */ GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(2615), // Rule ID 114 //
     /* 2596 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule85Enabled),
     /* 2599 */   // MIs[0] dst
     /* 2599 */   // No operand predicates
     /* 2599 */   // MIs[0] src
     /* 2599 */   // No operand predicates
     /* 2599 */   // MIs[0] src
     /* 2599 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 2604 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2609 */   // Combiner Rule #85: binop_same_val @ [__binop_same_val_match_0[0]]
     /* 2609 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2614 */   GIR_EraseRootFromParent_Done,
     /* 2615 */ // Label 175: @2615
     /* 2615 */ GIM_Reject,
     /* 2616 */ // Label 9: @2616
     /* 2616 */ GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(2627), // Rule ID 79 //
     /* 2621 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule73Enabled),
     /* 2624 */   // Combiner Rule #73: undef_to_negative_one; wip_match_opcode 'G_OR'
     /* 2624 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner35),
     /* 2627 */ // Label 176: @2627
     /* 2627 */ GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(2638), // Rule ID 143 //
     /* 2632 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule104Enabled),
     /* 2635 */   // Combiner Rule #104: hoist_logic_op_with_same_opcode_hands; wip_match_opcode 'G_OR'
     /* 2635 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner55),
     /* 2638 */ // Label 177: @2638
     /* 2638 */ GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(2649), // Rule ID 169 //
     /* 2643 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule127Enabled),
     /* 2646 */   // Combiner Rule #127: redundant_or; wip_match_opcode 'G_OR'
     /* 2646 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner74),
     /* 2649 */ // Label 178: @2649
     /* 2649 */ GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(2660), // Rule ID 210 //
     /* 2654 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule152Enabled),
     /* 2657 */   // Combiner Rule #152: load_or_combine; wip_match_opcode 'G_OR'
     /* 2657 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner94),
     /* 2660 */ // Label 179: @2660
     /* 2660 */ GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(2671), // Rule ID 215 //
     /* 2665 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule154Enabled),
     /* 2668 */   // Combiner Rule #154: funnel_shift_from_or_shift; wip_match_opcode 'G_OR'
     /* 2668 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner96),
     /* 2671 */ // Label 180: @2671
     /* 2671 */ GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(2682), // Rule ID 237 //
     /* 2676 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 2679 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_OR'
     /* 2679 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2682 */ // Label 181: @2682
     /* 2682 */ GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(2693), // Rule ID 279 //
     /* 2687 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 2690 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_OR'
     /* 2690 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2693 */ // Label 182: @2693
     /* 2693 */ GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(2704), // Rule ID 312 //
     /* 2698 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 2701 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_OR'
     /* 2701 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 2704 */ // Label 183: @2704
     /* 2704 */ GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(2715), // Rule ID 339 //
     /* 2709 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule194Enabled),
     /* 2712 */   // Combiner Rule #194: match_ors; wip_match_opcode 'G_OR'
     /* 2712 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner130),
     /* 2715 */ // Label 184: @2715
     /* 2715 */ GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(2813), // Rule ID 156 //
     /* 2720 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule114Enabled),
     /* 2723 */   // MIs[0] root
     /* 2723 */   // No operand predicates
     /* 2723 */   // MIs[0] d1
     /* 2723 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2727 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2731 */   // MIs[1] p
     /* 2731 */   // No operand predicates
     /* 2731 */   // MIs[1] s1
     /* 2731 */   GIM_RecordRegType, /*MI*/1, /*Op*/2, /*TempTypeIdx*/uint8_t(-1),
     /* 2735 */   // MIs[1] Operand 3
     /* 2735 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 2739 */   // MIs[0] d2
     /* 2739 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 2743 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2747 */   // MIs[2] p
     /* 2747 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /* 2752 */   // MIs[2] s2
     /* 2752 */   // No operand predicates
     /* 2752 */   // MIs[2] Operand 3
     /* 2752 */   GIM_CheckConstantInt8, /*MI*/2, /*Op*/3, 0,
     /* 2756 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner6),
     /* 2760 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 2762 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/uint8_t(-1),
     /* 2765 */   GIR_BuildConstant, /*TempRegID*/1, /*Val*/GIMT_Encode8(0),
     /* 2775 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/uint8_t(-1),
     /* 2778 */   // Combiner Rule #114: double_icmp_zero_or_combine
     /* 2778 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_OR),
     /* 2781 */   GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 2786 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // s1
     /* 2790 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // s2
     /* 2794 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2798 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/0, // root
     /* 2802 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // p
     /* 2806 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
     /* 2809 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 2812 */   GIR_EraseRootFromParent_Done,
     /* 2813 */ // Label 185: @2813
     /* 2813 */ GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(2837), // Rule ID 115 //
     /* 2818 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule85Enabled),
     /* 2821 */   // MIs[0] dst
     /* 2821 */   // No operand predicates
     /* 2821 */   // MIs[0] src
     /* 2821 */   // No operand predicates
     /* 2821 */   // MIs[0] src
     /* 2821 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 2826 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2831 */   // Combiner Rule #85: binop_same_val @ [__binop_same_val_match_0[1]]
     /* 2831 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2836 */   GIR_EraseRootFromParent_Done,
     /* 2837 */ // Label 186: @2837
     /* 2837 */ GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(2860), // Rule ID 106 //
     /* 2842 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 2845 */   // MIs[0] dst
     /* 2845 */   // No operand predicates
     /* 2845 */   // MIs[0] lhs
     /* 2845 */   // No operand predicates
     /* 2845 */   // MIs[0] Operand 2
     /* 2845 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 2849 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2854 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[2]]
     /* 2854 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2859 */   GIR_EraseRootFromParent_Done,
     /* 2860 */ // Label 187: @2860
     /* 2860 */ GIM_Reject,
     /* 2861 */ // Label 10: @2861
     /* 2861 */ GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(2872), // Rule ID 96 //
     /* 2866 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule78Enabled),
     /* 2869 */   // Combiner Rule #78: propagate_undef_any_op; wip_match_opcode 'G_XOR'
     /* 2869 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 2872 */ // Label 188: @2872
     /* 2872 */ GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(2883), // Rule ID 144 //
     /* 2877 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule104Enabled),
     /* 2880 */   // Combiner Rule #104: hoist_logic_op_with_same_opcode_hands; wip_match_opcode 'G_XOR'
     /* 2880 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner55),
     /* 2883 */ // Label 189: @2883
     /* 2883 */ GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(2894), // Rule ID 174 //
     /* 2888 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule132Enabled),
     /* 2891 */   // Combiner Rule #132: not_cmp_fold; wip_match_opcode 'G_XOR'
     /* 2891 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner79),
     /* 2894 */ // Label 190: @2894
     /* 2894 */ GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(2905), // Rule ID 198 //
     /* 2899 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule148Enabled),
     /* 2902 */   // Combiner Rule #148: xor_of_and_with_same_reg; wip_match_opcode 'G_XOR'
     /* 2902 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner90),
     /* 2905 */ // Label 191: @2905
     /* 2905 */ GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(2916), // Rule ID 240 //
     /* 2910 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 2913 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_XOR'
     /* 2913 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2916 */ // Label 192: @2916
     /* 2916 */ GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(2927), // Rule ID 280 //
     /* 2921 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 2924 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_XOR'
     /* 2924 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2927 */ // Label 193: @2927
     /* 2927 */ GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(2938), // Rule ID 313 //
     /* 2932 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 2935 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_XOR'
     /* 2935 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 2938 */ // Label 194: @2938
     /* 2938 */ GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(2961), // Rule ID 107 //
     /* 2943 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 2946 */   // MIs[0] dst
     /* 2946 */   // No operand predicates
     /* 2946 */   // MIs[0] lhs
     /* 2946 */   // No operand predicates
     /* 2946 */   // MIs[0] Operand 2
     /* 2946 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 2950 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2955 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[3]]
     /* 2955 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2960 */   GIR_EraseRootFromParent_Done,
     /* 2961 */ // Label 195: @2961
     /* 2961 */ GIM_Reject,
     /* 2962 */ // Label 11: @2962
     /* 2962 */ GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(2973), // Rule ID 140 //
     /* 2967 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule102Enabled),
     /* 2970 */   // Combiner Rule #102: extend_through_phis; wip_match_opcode 'G_PHI'
     /* 2970 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner53),
     /* 2973 */ // Label 196: @2973
     /* 2973 */ GIM_Reject,
     /* 2974 */ // Label 12: @2974
     /* 2974 */ GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(2985), // Rule ID 349 //
     /* 2979 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule204Enabled),
     /* 2982 */   // Combiner Rule #204: unmerge_anyext_build_vector; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 2982 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner140),
     /* 2985 */ // Label 197: @2985
     /* 2985 */ GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(2996), // Rule ID 350 //
     /* 2990 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule205Enabled),
     /* 2993 */   // Combiner Rule #205: unmerge_merge; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 2993 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner141),
     /* 2996 */ // Label 198: @2996
     /* 2996 */ GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(3007), // Rule ID 352 //
     /* 3001 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule207Enabled),
     /* 3004 */   // Combiner Rule #207: unmerge_cst; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3004 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner143),
     /* 3007 */ // Label 199: @3007
     /* 3007 */ GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(3018), // Rule ID 353 //
     /* 3012 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule208Enabled),
     /* 3015 */   // Combiner Rule #208: unmerge_undef; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3015 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner144),
     /* 3018 */ // Label 200: @3018
     /* 3018 */ GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(3029), // Rule ID 354 //
     /* 3023 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule209Enabled),
     /* 3026 */   // Combiner Rule #209: unmerge_dead_to_trunc; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3026 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner145),
     /* 3029 */ // Label 201: @3029
     /* 3029 */ GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(3040), // Rule ID 355 //
     /* 3034 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule210Enabled),
     /* 3037 */   // Combiner Rule #210: unmerge_zext_to_zext; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3037 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner146),
     /* 3040 */ // Label 202: @3040
     /* 3040 */ GIM_Reject,
     /* 3041 */ // Label 13: @3041
     /* 3041 */ GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(3052), // Rule ID 351 //
     /* 3046 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule206Enabled),
     /* 3049 */   // Combiner Rule #206: merge_unmerge; wip_match_opcode 'G_MERGE_VALUES'
     /* 3049 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner142),
     /* 3052 */ // Label 203: @3052
     /* 3052 */ GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(3114),
     /* 3057 */   GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
     /* 3060 */   GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(3081), // Rule ID 356 //
     /* 3065 */     GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule211Enabled),
     /* 3068 */     // MIs[0] root
     /* 3068 */     // No operand predicates
     /* 3068 */     // MIs[0] x
     /* 3068 */     // No operand predicates
     /* 3068 */     // MIs[0] undef
     /* 3068 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 3072 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3076 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3078 */     // Combiner Rule #211: merge_of_x_and_undef
     /* 3078 */     GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner147),
     /* 3081 */   // Label 205: @3081
     /* 3081 */   GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(3113), // Rule ID 357 //
     /* 3086 */     GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule212Enabled),
     /* 3089 */     // MIs[0] root
     /* 3089 */     // No operand predicates
     /* 3089 */     // MIs[0] x
     /* 3089 */     // No operand predicates
     /* 3089 */     // MIs[0] zero
     /* 3089 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 3093 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 3097 */     // MIs[1] Operand 1
     /* 3097 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/1, GIMT_Encode8(0),
     /* 3108 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3110 */     // Combiner Rule #212: merge_of_x_and_zero
     /* 3110 */     GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner148),
     /* 3113 */   // Label 206: @3113
     /* 3113 */   GIM_Reject,
     /* 3114 */ // Label 204: @3114
     /* 3114 */ GIM_Reject,
     /* 3115 */ // Label 14: @3115
     /* 3115 */ GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(3126), // Rule ID 69 //
     /* 3120 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule67Enabled),
     /* 3123 */   // Combiner Rule #67: extract_all_elts_from_build_vector; wip_match_opcode 'G_BUILD_VECTOR'
     /* 3123 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner29),
     /* 3126 */ // Label 207: @3126
     /* 3126 */ GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(3137), // Rule ID 98 //
     /* 3131 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule79Enabled),
     /* 3134 */   // Combiner Rule #79: propagate_undef_all_ops; wip_match_opcode 'G_BUILD_VECTOR'
     /* 3134 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner40),
     /* 3137 */ // Label 208: @3137
     /* 3137 */ GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(3148), // Rule ID 133 //
     /* 3142 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule95Enabled),
     /* 3145 */   // Combiner Rule #95: buildvector_identity_fold; wip_match_opcode 'G_BUILD_VECTOR'
     /* 3145 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner49),
     /* 3148 */ // Label 209: @3148
     /* 3148 */ GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(3162), // Rule ID 348 //
     /* 3153 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule203Enabled),
     /* 3156 */   GIM_CheckNumOperandsGE, /*MI*/0, /*Expected*/2,
     /* 3159 */   // MIs[0] dst
     /* 3159 */   // No operand predicates
     /* 3159 */   // MIs[0] unused
     /* 3159 */   // No operand predicates
     /* 3159 */   // Combiner Rule #203: combine_use_vector_truncate
     /* 3159 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner139),
     /* 3162 */ // Label 210: @3162
     /* 3162 */ GIM_Reject,
     /* 3163 */ // Label 15: @3163
     /* 3163 */ GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(3174), // Rule ID 132 //
     /* 3168 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule95Enabled),
     /* 3171 */   // Combiner Rule #95: buildvector_identity_fold; wip_match_opcode 'G_BUILD_VECTOR_TRUNC'
     /* 3171 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner49),
     /* 3174 */ // Label 211: @3174
     /* 3174 */ GIM_Reject,
     /* 3175 */ // Label 16: @3175
     /* 3175 */ GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(3186), // Rule ID 341 //
     /* 3180 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule196Enabled),
     /* 3183 */   // Combiner Rule #196: combine_concat_vector; wip_match_opcode 'G_CONCAT_VECTORS'
     /* 3183 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner132),
     /* 3186 */ // Label 212: @3186
     /* 3186 */ GIM_Reject,
     /* 3187 */ // Label 17: @3187
     /* 3187 */ GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(3208), // Rule ID 125 //
     /* 3192 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule89Enabled),
     /* 3195 */   // MIs[0] dst
     /* 3195 */   // No operand predicates
     /* 3195 */   // MIs[0] t
     /* 3195 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3199 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTTOPTR),
     /* 3203 */   // MIs[1] ptr
     /* 3203 */   // No operand predicates
     /* 3203 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3205 */   // Combiner Rule #89: i2p_to_p2i
     /* 3205 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner47),
     /* 3208 */ // Label 213: @3208
     /* 3208 */ GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(3229), // Rule ID 90 //
     /* 3213 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 3216 */   // MIs[0] dst
     /* 3216 */   // No operand predicates
     /* 3216 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 3216 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3220 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3224 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3226 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[3]]
     /* 3226 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 3229 */ // Label 214: @3229
     /* 3229 */ GIM_Reject,
     /* 3230 */ // Label 18: @3230
     /* 3230 */ GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(3241), // Rule ID 124 //
     /* 3235 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule88Enabled),
     /* 3238 */   // Combiner Rule #88: p2i_to_i2p; wip_match_opcode 'G_INTTOPTR'
     /* 3238 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner46),
     /* 3241 */ // Label 215: @3241
     /* 3241 */ GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(3262), // Rule ID 91 //
     /* 3246 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 3249 */   // MIs[0] dst
     /* 3249 */   // No operand predicates
     /* 3249 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 3249 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3253 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3257 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3259 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[4]]
     /* 3259 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 3262 */ // Label 216: @3262
     /* 3262 */ GIM_Reject,
     /* 3263 */ // Label 19: @3263
     /* 3263 */ GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(3284), // Rule ID 136 //
     /* 3268 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule98Enabled),
     /* 3271 */   // MIs[0] dst
     /* 3271 */   // No operand predicates
     /* 3271 */   // MIs[0] src1
     /* 3271 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3275 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
     /* 3279 */   // MIs[1] src0
     /* 3279 */   // No operand predicates
     /* 3279 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3281 */   // Combiner Rule #98: bitcast_bitcast_fold
     /* 3281 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner52),
     /* 3284 */ // Label 217: @3284
     /* 3284 */ GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(3305), // Rule ID 88 //
     /* 3289 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 3292 */   // MIs[0] dst
     /* 3292 */   // No operand predicates
     /* 3292 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 3292 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3296 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3300 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3302 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[1]]
     /* 3302 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 3305 */ // Label 218: @3305
     /* 3305 */ GIM_Reject,
     /* 3306 */ // Label 20: @3306
     /* 3306 */ GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(3335), // Rule ID 18 //
     /* 3311 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule18Enabled),
     /* 3314 */   // MIs[0] dst
     /* 3314 */   // No operand predicates
     /* 3314 */   // MIs[0] src
     /* 3314 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3318 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FREEZE),
     /* 3322 */   // MIs[1] __idempotent_prop_match_0.x
     /* 3322 */   // No operand predicates
     /* 3322 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3327 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3329 */   // Combiner Rule #18: idempotent_prop @ [__idempotent_prop_match_0[0]]
     /* 3329 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3334 */   GIR_EraseRootFromParent_Done,
     /* 3335 */ // Label 219: @3335
     /* 3335 */ GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(3358), // Rule ID 43 //
     /* 3340 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule41Enabled),
     /* 3343 */   // MIs[0] root
     /* 3343 */   // No operand predicates
     /* 3343 */   // MIs[0] src
     /* 3343 */   // No operand predicates
     /* 3343 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner1),
     /* 3347 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3352 */   // Combiner Rule #41: freeze_of_non_undef_non_poison
     /* 3352 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3357 */   GIR_EraseRootFromParent_Done,
     /* 3358 */ // Label 220: @3358
     /* 3358 */ GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(3369), // Rule ID 44 //
     /* 3363 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule42Enabled),
     /* 3366 */   // MIs[0] dst
     /* 3366 */   // No operand predicates
     /* 3366 */   // MIs[0] src
     /* 3366 */   // No operand predicates
     /* 3366 */   // Combiner Rule #42: push_freeze_to_prevent_poison_from_propagating
     /* 3366 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner19),
     /* 3369 */ // Label 221: @3369
     /* 3369 */ GIM_Reject,
     /* 3370 */ // Label 21: @3370
     /* 3370 */ GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(3381), // Rule ID 70 //
     /* 3375 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule68Enabled),
     /* 3378 */   // Combiner Rule #68: extending_loads; wip_match_opcode 'G_LOAD'
     /* 3378 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner30),
     /* 3381 */ // Label 222: @3381
     /* 3381 */ GIM_Reject,
     /* 3382 */ // Label 22: @3382
     /* 3382 */ GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(3393), // Rule ID 71 //
     /* 3387 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule68Enabled),
     /* 3390 */   // Combiner Rule #68: extending_loads; wip_match_opcode 'G_SEXTLOAD'
     /* 3390 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner30),
     /* 3393 */ // Label 223: @3393
     /* 3393 */ GIM_Reject,
     /* 3394 */ // Label 23: @3394
     /* 3394 */ GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(3405), // Rule ID 72 //
     /* 3399 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule68Enabled),
     /* 3402 */   // Combiner Rule #68: extending_loads; wip_match_opcode 'G_ZEXTLOAD'
     /* 3402 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner30),
     /* 3405 */ // Label 224: @3405
     /* 3405 */ GIM_Reject,
     /* 3406 */ // Label 24: @3406
     /* 3406 */ GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(3417), // Rule ID 100 //
     /* 3411 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule81Enabled),
     /* 3414 */   // Combiner Rule #81: erase_undef_store; wip_match_opcode 'G_STORE'
     /* 3414 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner42),
     /* 3417 */ // Label 225: @3417
     /* 3417 */ GIM_Reject,
     /* 3418 */ // Label 25: @3418
     /* 3418 */ GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(3429), // Rule ID 126 //
     /* 3423 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule90Enabled),
     /* 3426 */   // Combiner Rule #90: anyext_trunc_fold; wip_match_opcode 'G_ANYEXT'
     /* 3426 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner48),
     /* 3429 */ // Label 226: @3429
     /* 3429 */ GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(3440), // Rule ID 257 //
     /* 3434 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 3437 */   // Combiner Rule #169: constant_fold_cast_op; wip_match_opcode 'G_ANYEXT'
     /* 3437 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner107),
     /* 3440 */ // Label 227: @3440
     /* 3440 */ GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(3461), // Rule ID 57 //
     /* 3445 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule55Enabled),
     /* 3448 */   // MIs[0] root
     /* 3448 */   // No operand predicates
     /* 3448 */   // MIs[0] select
     /* 3448 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3452 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /* 3456 */   // MIs[1] cond
     /* 3456 */   // No operand predicates
     /* 3456 */   // MIs[1] true
     /* 3456 */   // No operand predicates
     /* 3456 */   // MIs[1] false
     /* 3456 */   // No operand predicates
     /* 3456 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3458 */   // Combiner Rule #55: select_of_anyext
     /* 3458 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner23),
     /* 3461 */ // Label 228: @3461
     /* 3461 */ GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(3482), // Rule ID 52 //
     /* 3466 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule50Enabled),
     /* 3469 */   // MIs[0] root
     /* 3469 */   // No operand predicates
     /* 3469 */   // MIs[0] second
     /* 3469 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3473 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /* 3477 */   // MIs[1] src
     /* 3477 */   // No operand predicates
     /* 3477 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3479 */   // Combiner Rule #50: anyext_of_anyext
     /* 3479 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 3482 */ // Label 229: @3482
     /* 3482 */ GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(3503), // Rule ID 54 //
     /* 3487 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule52Enabled),
     /* 3490 */   // MIs[0] root
     /* 3490 */   // No operand predicates
     /* 3490 */   // MIs[0] second
     /* 3490 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3494 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /* 3498 */   // MIs[1] src
     /* 3498 */   // No operand predicates
     /* 3498 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3500 */   // Combiner Rule #52: anyext_of_sext
     /* 3500 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 3503 */ // Label 230: @3503
     /* 3503 */ GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(3524), // Rule ID 53 //
     /* 3508 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule51Enabled),
     /* 3511 */   // MIs[0] root
     /* 3511 */   // No operand predicates
     /* 3511 */   // MIs[0] second
     /* 3511 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3515 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /* 3519 */   // MIs[1] src
     /* 3519 */   // No operand predicates
     /* 3519 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3521 */   // Combiner Rule #51: anyext_of_zext
     /* 3521 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 3524 */ // Label 231: @3524
     /* 3524 */ GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(3545), // Rule ID 89 //
     /* 3529 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 3532 */   // MIs[0] dst
     /* 3532 */   // No operand predicates
     /* 3532 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 3532 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3536 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3540 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3542 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[2]]
     /* 3542 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 3545 */ // Label 232: @3545
     /* 3545 */ GIM_Reject,
     /* 3546 */ // Label 26: @3546
     /* 3546 */ GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(3557), // Rule ID 134 //
     /* 3551 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule96Enabled),
     /* 3554 */   // Combiner Rule #96: trunc_buildvector_fold; wip_match_opcode 'G_TRUNC'
     /* 3554 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner50),
     /* 3557 */ // Label 233: @3557
     /* 3557 */ GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(3568), // Rule ID 135 //
     /* 3562 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule97Enabled),
     /* 3565 */   // Combiner Rule #97: trunc_lshr_buildvector_fold; wip_match_opcode 'G_TRUNC'
     /* 3565 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner51),
     /* 3568 */ // Label 234: @3568
     /* 3568 */ GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(3579), // Rule ID 173 //
     /* 3573 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule131Enabled),
     /* 3576 */   // Combiner Rule #131: trunc_shift; wip_match_opcode 'G_TRUNC'
     /* 3576 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner78),
     /* 3579 */ // Label 235: @3579
     /* 3579 */ GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(3600), // Rule ID 58 //
     /* 3584 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule56Enabled),
     /* 3587 */   // MIs[0] root
     /* 3587 */   // No operand predicates
     /* 3587 */   // MIs[0] select
     /* 3587 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3591 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /* 3595 */   // MIs[1] cond
     /* 3595 */   // No operand predicates
     /* 3595 */   // MIs[1] true
     /* 3595 */   // No operand predicates
     /* 3595 */   // MIs[1] false
     /* 3595 */   // No operand predicates
     /* 3595 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3597 */   // Combiner Rule #56: select_of_truncate
     /* 3597 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner23),
     /* 3600 */ // Label 236: @3600
     /* 3600 */ GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(3629), // Rule ID 60 //
     /* 3605 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule58Enabled),
     /* 3608 */   // MIs[0] root
     /* 3608 */   // No operand predicates
     /* 3608 */   // MIs[0] binop
     /* 3608 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3612 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 3616 */   // MIs[1] x
     /* 3616 */   // No operand predicates
     /* 3616 */   // MIs[1] const
     /* 3616 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 3620 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 3624 */   // MIs[2] imm
     /* 3624 */   // No operand predicates
     /* 3624 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 3626 */   // Combiner Rule #58: narrow_binop_add
     /* 3626 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 3629 */ // Label 237: @3629
     /* 3629 */ GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(3658), // Rule ID 63 //
     /* 3634 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule61Enabled),
     /* 3637 */   // MIs[0] root
     /* 3637 */   // No operand predicates
     /* 3637 */   // MIs[0] binop
     /* 3637 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3641 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /* 3645 */   // MIs[1] x
     /* 3645 */   // No operand predicates
     /* 3645 */   // MIs[1] const
     /* 3645 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 3649 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 3653 */   // MIs[2] imm
     /* 3653 */   // No operand predicates
     /* 3653 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 3655 */   // Combiner Rule #61: narrow_binop_and
     /* 3655 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 3658 */ // Label 238: @3658
     /* 3658 */ GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(3687), // Rule ID 62 //
     /* 3663 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule60Enabled),
     /* 3666 */   // MIs[0] root
     /* 3666 */   // No operand predicates
     /* 3666 */   // MIs[0] binop
     /* 3666 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3670 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /* 3674 */   // MIs[1] x
     /* 3674 */   // No operand predicates
     /* 3674 */   // MIs[1] const
     /* 3674 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 3678 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 3682 */   // MIs[2] imm
     /* 3682 */   // No operand predicates
     /* 3682 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 3684 */   // Combiner Rule #60: narrow_binop_mul
     /* 3684 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 3687 */ // Label 239: @3687
     /* 3687 */ GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(3716), // Rule ID 64 //
     /* 3692 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule62Enabled),
     /* 3695 */   // MIs[0] root
     /* 3695 */   // No operand predicates
     /* 3695 */   // MIs[0] binop
     /* 3695 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3699 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
     /* 3703 */   // MIs[1] x
     /* 3703 */   // No operand predicates
     /* 3703 */   // MIs[1] const
     /* 3703 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 3707 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 3711 */   // MIs[2] imm
     /* 3711 */   // No operand predicates
     /* 3711 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 3713 */   // Combiner Rule #62: narrow_binop_or
     /* 3713 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 3716 */ // Label 240: @3716
     /* 3716 */ GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(3745), // Rule ID 61 //
     /* 3721 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule59Enabled),
     /* 3724 */   // MIs[0] root
     /* 3724 */   // No operand predicates
     /* 3724 */   // MIs[0] binop
     /* 3724 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3728 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 3732 */   // MIs[1] x
     /* 3732 */   // No operand predicates
     /* 3732 */   // MIs[1] const
     /* 3732 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 3736 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 3740 */   // MIs[2] imm
     /* 3740 */   // No operand predicates
     /* 3740 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 3742 */   // Combiner Rule #59: narrow_binop_sub
     /* 3742 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 3745 */ // Label 241: @3745
     /* 3745 */ GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(3774), // Rule ID 65 //
     /* 3750 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule63Enabled),
     /* 3753 */   // MIs[0] root
     /* 3753 */   // No operand predicates
     /* 3753 */   // MIs[0] binop
     /* 3753 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3757 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /* 3761 */   // MIs[1] x
     /* 3761 */   // No operand predicates
     /* 3761 */   // MIs[1] const
     /* 3761 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 3765 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 3769 */   // MIs[2] imm
     /* 3769 */   // No operand predicates
     /* 3769 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 3771 */   // Combiner Rule #63: narrow_binop_xor
     /* 3771 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 3774 */ // Label 242: @3774
     /* 3774 */ GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(3795), // Rule ID 47 //
     /* 3779 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule45Enabled),
     /* 3782 */   // MIs[0] root
     /* 3782 */   // No operand predicates
     /* 3782 */   // MIs[0] ext
     /* 3782 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3786 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /* 3790 */   // MIs[1] src
     /* 3790 */   // No operand predicates
     /* 3790 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3792 */   // Combiner Rule #45: truncate_of_anyext
     /* 3792 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner20),
     /* 3795 */ // Label 243: @3795
     /* 3795 */ GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(3819), // Rule ID 59 //
     /* 3800 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule57Enabled),
     /* 3803 */   // MIs[0] root
     /* 3803 */   // No operand predicates
     /* 3803 */   // MIs[0] bv
     /* 3803 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3807 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
     /* 3811 */   GIM_CheckNumOperandsGE, /*MI*/1, /*Expected*/2,
     /* 3814 */   // MIs[1] unused
     /* 3814 */   // No operand predicates
     /* 3814 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3816 */   // Combiner Rule #57: buildvector_of_truncate
     /* 3816 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner24),
     /* 3819 */ // Label 244: @3819
     /* 3819 */ GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(3840), // Rule ID 46 //
     /* 3824 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule44Enabled),
     /* 3827 */   // MIs[0] root
     /* 3827 */   // No operand predicates
     /* 3827 */   // MIs[0] ext
     /* 3827 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3831 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /* 3835 */   // MIs[1] src
     /* 3835 */   // No operand predicates
     /* 3835 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3837 */   // Combiner Rule #44: truncate_of_sext
     /* 3837 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner20),
     /* 3840 */ // Label 245: @3840
     /* 3840 */ GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(3861), // Rule ID 45 //
     /* 3845 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule43Enabled),
     /* 3848 */   // MIs[0] root
     /* 3848 */   // No operand predicates
     /* 3848 */   // MIs[0] ext
     /* 3848 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3852 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /* 3856 */   // MIs[1] src
     /* 3856 */   // No operand predicates
     /* 3856 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3858 */   // Combiner Rule #43: truncate_of_zext
     /* 3858 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner20),
     /* 3861 */ // Label 246: @3861
     /* 3861 */ GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(3882), // Rule ID 87 //
     /* 3866 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 3869 */   // MIs[0] dst
     /* 3869 */   // No operand predicates
     /* 3869 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 3869 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3873 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3877 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3879 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[0]]
     /* 3879 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 3882 */ // Label 247: @3882
     /* 3882 */ GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(3903), // Rule ID 66 //
     /* 3887 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule64Enabled),
     /* 3890 */   // MIs[0] root
     /* 3890 */   // No operand predicates
     /* 3890 */   // MIs[0] int
     /* 3890 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3894 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 3898 */   // MIs[1] imm
     /* 3898 */   // No operand predicates
     /* 3898 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3900 */   // Combiner Rule #64: integer_of_truncate
     /* 3900 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner26),
     /* 3903 */ // Label 248: @3903
     /* 3903 */ GIM_Reject,
     /* 3904 */ // Label 27: @3904
     /* 3904 */ GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(3915), // Rule ID 256 //
     /* 3909 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 3912 */   // Combiner Rule #169: constant_fold_cast_op; wip_match_opcode 'G_SEXT'
     /* 3912 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner107),
     /* 3915 */ // Label 249: @3915
     /* 3915 */ GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(3936), // Rule ID 51 //
     /* 3920 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule49Enabled),
     /* 3923 */   // MIs[0] root
     /* 3923 */   // No operand predicates
     /* 3923 */   // MIs[0] second
     /* 3923 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3927 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /* 3931 */   // MIs[1] src
     /* 3931 */   // No operand predicates
     /* 3931 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3933 */   // Combiner Rule #49: sext_of_anyext
     /* 3933 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 3936 */ // Label 250: @3936
     /* 3936 */ GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(3957), // Rule ID 50 //
     /* 3941 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 3944 */   // MIs[0] root
     /* 3944 */   // No operand predicates
     /* 3944 */   // MIs[0] second
     /* 3944 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3948 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /* 3952 */   // MIs[1] src
     /* 3952 */   // No operand predicates
     /* 3952 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3954 */   // Combiner Rule #48: sext_of_sext
     /* 3954 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 3957 */ // Label 251: @3957
     /* 3957 */ GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(3978), // Rule ID 342 //
     /* 3962 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule197Enabled),
     /* 3965 */   // MIs[0] root
     /* 3965 */   // No operand predicates
     /* 3965 */   // MIs[0] src
     /* 3965 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3969 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /* 3973 */   // MIs[1] x
     /* 3973 */   // No operand predicates
     /* 3973 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3975 */   // Combiner Rule #197: sext_trunc
     /* 3975 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner133),
     /* 3978 */ // Label 252: @3978
     /* 3978 */ GIM_Reject,
     /* 3979 */ // Label 28: @3979
     /* 3979 */ GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(3990), // Rule ID 160 //
     /* 3984 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule118Enabled),
     /* 3987 */   // Combiner Rule #118: sext_inreg_of_load; wip_match_opcode 'G_SEXT_INREG'
     /* 3987 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner66),
     /* 3990 */ // Label 253: @3990
     /* 3990 */ GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(4001), // Rule ID 168 //
     /* 3995 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule126Enabled),
     /* 3998 */   // Combiner Rule #126: redundant_sext_inreg; wip_match_opcode 'G_SEXT_INREG'
     /* 3998 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner73),
     /* 4001 */ // Label 254: @4001
     /* 4001 */ GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(4012), // Rule ID 225 //
     /* 4006 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule162Enabled),
     /* 4009 */   // Combiner Rule #162: bitfield_extract_from_sext_inreg; wip_match_opcode 'G_SEXT_INREG'
     /* 4009 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner100),
     /* 4012 */ // Label 255: @4012
     /* 4012 */ GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(4033), // Rule ID 55 //
     /* 4017 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule53Enabled),
     /* 4020 */   // MIs[0] dst
     /* 4020 */   // No operand predicates
     /* 4020 */   // MIs[0] x
     /* 4020 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4024 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /* 4028 */   // MIs[1] src
     /* 4028 */   // No operand predicates
     /* 4028 */   // MIs[1] a
     /* 4028 */   // No operand predicates
     /* 4028 */   // MIs[0] b
     /* 4028 */   // No operand predicates
     /* 4028 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4030 */   // Combiner Rule #53: sext_inreg_of_sext_inreg
     /* 4030 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner22),
     /* 4033 */ // Label 256: @4033
     /* 4033 */ GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(4044), // Rule ID 172 //
     /* 4038 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule130Enabled),
     /* 4041 */   // MIs[0] dst
     /* 4041 */   // No operand predicates
     /* 4041 */   // MIs[0] src
     /* 4041 */   // No operand predicates
     /* 4041 */   // MIs[0] imm
     /* 4041 */   // No operand predicates
     /* 4041 */   // Combiner Rule #130: sext_inreg_to_zext_inreg
     /* 4041 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner77),
     /* 4044 */ // Label 257: @4044
     /* 4044 */ GIM_Reject,
     /* 4045 */ // Label 29: @4045
     /* 4045 */ GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(4056), // Rule ID 171 //
     /* 4050 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule129Enabled),
     /* 4053 */   // Combiner Rule #129: zext_trunc_fold; wip_match_opcode 'G_ZEXT'
     /* 4053 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner76),
     /* 4056 */ // Label 258: @4056
     /* 4056 */ GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(4067), // Rule ID 255 //
     /* 4061 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 4064 */   // Combiner Rule #169: constant_fold_cast_op; wip_match_opcode 'G_ZEXT'
     /* 4064 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner107),
     /* 4067 */ // Label 259: @4067
     /* 4067 */ GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(4088), // Rule ID 56 //
     /* 4072 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule54Enabled),
     /* 4075 */   // MIs[0] root
     /* 4075 */   // No operand predicates
     /* 4075 */   // MIs[0] select
     /* 4075 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4079 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /* 4083 */   // MIs[1] cond
     /* 4083 */   // No operand predicates
     /* 4083 */   // MIs[1] true
     /* 4083 */   // No operand predicates
     /* 4083 */   // MIs[1] false
     /* 4083 */   // No operand predicates
     /* 4083 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4085 */   // Combiner Rule #54: select_of_zext
     /* 4085 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner23),
     /* 4088 */ // Label 260: @4088
     /* 4088 */ GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(4109), // Rule ID 49 //
     /* 4093 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule47Enabled),
     /* 4096 */   // MIs[0] root
     /* 4096 */   // No operand predicates
     /* 4096 */   // MIs[0] second
     /* 4096 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4100 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /* 4104 */   // MIs[1] src
     /* 4104 */   // No operand predicates
     /* 4104 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4106 */   // Combiner Rule #47: zext_of_anyext
     /* 4106 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 4109 */ // Label 261: @4109
     /* 4109 */ GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(4136), // Rule ID 343 //
     /* 4114 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule198Enabled),
     /* 4117 */   // MIs[0] root
     /* 4117 */   // No operand predicates
     /* 4117 */   // MIs[0] src
     /* 4117 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4121 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /* 4125 */   GIM_MIFlags, /*MI*/1, GIMT_Encode4(MachineInstr::NoUWrap),
     /* 4131 */   // MIs[1] x
     /* 4131 */   // No operand predicates
     /* 4131 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4133 */   // Combiner Rule #198: zext_trunc
     /* 4133 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner134),
     /* 4136 */ // Label 262: @4136
     /* 4136 */ GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(4157), // Rule ID 48 //
     /* 4141 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule46Enabled),
     /* 4144 */   // MIs[0] root
     /* 4144 */   // No operand predicates
     /* 4144 */   // MIs[0] second
     /* 4144 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4148 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /* 4152 */   // MIs[1] src
     /* 4152 */   // No operand predicates
     /* 4152 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4154 */   // Combiner Rule #46: zext_of_zext
     /* 4154 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 4157 */ // Label 263: @4157
     /* 4157 */ GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(4174), // Rule ID 344 //
     /* 4162 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule199Enabled),
     /* 4165 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::NonNeg),
     /* 4171 */   // MIs[0] root
     /* 4171 */   // No operand predicates
     /* 4171 */   // MIs[0] x
     /* 4171 */   // No operand predicates
     /* 4171 */   // Combiner Rule #199: nneg_zext
     /* 4171 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner135),
     /* 4174 */ // Label 264: @4174
     /* 4174 */ GIM_Reject,
     /* 4175 */ // Label 30: @4175
     /* 4175 */ GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(4186), // Rule ID 80 //
     /* 4180 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule74Enabled),
     /* 4183 */   // Combiner Rule #74: binop_left_undef_to_zero; wip_match_opcode 'G_SHL'
     /* 4183 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner36),
     /* 4186 */ // Label 265: @4186
     /* 4186 */ GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(4197), // Rule ID 83 //
     /* 4191 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule75Enabled),
     /* 4194 */   // Combiner Rule #75: binop_right_undef_to_undef; wip_match_opcode 'G_SHL'
     /* 4194 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner37),
     /* 4197 */ // Label 266: @4197
     /* 4197 */ GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(4208), // Rule ID 116 //
     /* 4202 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 4205 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_SHL'
     /* 4205 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 4208 */ // Label 267: @4208
     /* 4208 */ GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(4219), // Rule ID 200 //
     /* 4213 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule150Enabled),
     /* 4216 */   // Combiner Rule #150: shift_immed_chain; wip_match_opcode 'G_SHL'
     /* 4216 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner92),
     /* 4219 */ // Label 268: @4219
     /* 4219 */ GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(4230), // Rule ID 205 //
     /* 4224 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule151Enabled),
     /* 4227 */   // Combiner Rule #151: shift_of_shifted_logic_chain; wip_match_opcode 'G_SHL'
     /* 4227 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner93),
     /* 4230 */ // Label 269: @4230
     /* 4230 */ GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(4241), // Rule ID 224 //
     /* 4235 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule161Enabled),
     /* 4238 */   // Combiner Rule #161: commute_shift; wip_match_opcode 'G_SHL'
     /* 4238 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner99),
     /* 4241 */ // Label 270: @4241
     /* 4241 */ GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(4252), // Rule ID 238 //
     /* 4246 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 4249 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_SHL'
     /* 4249 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 4252 */ // Label 271: @4252
     /* 4252 */ GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(4263), // Rule ID 287 //
     /* 4257 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 4260 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_SHL'
     /* 4260 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 4263 */ // Label 272: @4263
     /* 4263 */ GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(4298), // Rule ID 41 //
     /* 4268 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule39Enabled),
     /* 4271 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::NoSWrap),
     /* 4277 */   // MIs[0] root
     /* 4277 */   // No operand predicates
     /* 4277 */   // MIs[0] left
     /* 4277 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4281 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VSCALE),
     /* 4285 */   // MIs[1] imm
     /* 4285 */   // No operand predicates
     /* 4285 */   // MIs[0] x
     /* 4285 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 4289 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 4293 */   // MIs[2] imm1
     /* 4293 */   // No operand predicates
     /* 4293 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 4295 */   // Combiner Rule #39: shl_of_vscale
     /* 4295 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner17),
     /* 4298 */ // Label 273: @4298
     /* 4298 */ GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(4321), // Rule ID 108 //
     /* 4303 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 4306 */   // MIs[0] dst
     /* 4306 */   // No operand predicates
     /* 4306 */   // MIs[0] lhs
     /* 4306 */   // No operand predicates
     /* 4306 */   // MIs[0] Operand 2
     /* 4306 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 4310 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4315 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[4]]
     /* 4315 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4320 */   GIR_EraseRootFromParent_Done,
     /* 4321 */ // Label 274: @4321
     /* 4321 */ GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(4332), // Rule ID 145 //
     /* 4326 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule105Enabled),
     /* 4329 */   // MIs[0] root
     /* 4329 */   // No operand predicates
     /* 4329 */   // MIs[0] mi.shifted
     /* 4329 */   // No operand predicates
     /* 4329 */   // MIs[0] mi.amt
     /* 4329 */   // No operand predicates
     /* 4329 */   // Combiner Rule #105: shifts_too_big @ [mi[0]]
     /* 4329 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner56),
     /* 4332 */ // Label 275: @4332
     /* 4332 */ GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(4343), // Rule ID 161 //
     /* 4337 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule119Enabled),
     /* 4340 */   // MIs[0] dst
     /* 4340 */   // No operand predicates
     /* 4340 */   // MIs[0] src0
     /* 4340 */   // No operand predicates
     /* 4340 */   // MIs[0] src1
     /* 4340 */   // No operand predicates
     /* 4340 */   // Combiner Rule #119: reduce_shl_of_extend
     /* 4340 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 4343 */ // Label 276: @4343
     /* 4343 */ GIM_Reject,
     /* 4344 */ // Label 31: @4344
     /* 4344 */ GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(4355), // Rule ID 85 //
     /* 4349 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule75Enabled),
     /* 4352 */   // Combiner Rule #75: binop_right_undef_to_undef; wip_match_opcode 'G_LSHR'
     /* 4352 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner37),
     /* 4355 */ // Label 277: @4355
     /* 4355 */ GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(4366), // Rule ID 117 //
     /* 4360 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 4363 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_LSHR'
     /* 4363 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 4366 */ // Label 278: @4366
     /* 4366 */ GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(4377), // Rule ID 202 //
     /* 4371 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule150Enabled),
     /* 4374 */   // Combiner Rule #150: shift_immed_chain; wip_match_opcode 'G_LSHR'
     /* 4374 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner92),
     /* 4377 */ // Label 279: @4377
     /* 4377 */ GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(4388), // Rule ID 207 //
     /* 4382 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule151Enabled),
     /* 4385 */   // Combiner Rule #151: shift_of_shifted_logic_chain; wip_match_opcode 'G_LSHR'
     /* 4385 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner93),
     /* 4388 */ // Label 280: @4388
     /* 4388 */ GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(4399), // Rule ID 228 //
     /* 4393 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule164Enabled),
     /* 4396 */   // Combiner Rule #164: bitfield_extract_from_shr; wip_match_opcode 'G_LSHR'
     /* 4396 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner102),
     /* 4399 */ // Label 281: @4399
     /* 4399 */ GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(4410), // Rule ID 230 //
     /* 4404 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule165Enabled),
     /* 4407 */   // Combiner Rule #165: bitfield_extract_from_shr_and; wip_match_opcode 'G_LSHR'
     /* 4407 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner103),
     /* 4410 */ // Label 282: @4410
     /* 4410 */ GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(4421), // Rule ID 235 //
     /* 4415 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 4418 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_LSHR'
     /* 4418 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 4421 */ // Label 283: @4421
     /* 4421 */ GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(4432), // Rule ID 285 //
     /* 4426 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 4429 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_LSHR'
     /* 4429 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 4432 */ // Label 284: @4432
     /* 4432 */ GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(4455), // Rule ID 110 //
     /* 4437 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 4440 */   // MIs[0] dst
     /* 4440 */   // No operand predicates
     /* 4440 */   // MIs[0] lhs
     /* 4440 */   // No operand predicates
     /* 4440 */   // MIs[0] Operand 2
     /* 4440 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 4444 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4449 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[6]]
     /* 4449 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4454 */   GIR_EraseRootFromParent_Done,
     /* 4455 */ // Label 285: @4455
     /* 4455 */ GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(4466), // Rule ID 147 //
     /* 4460 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule105Enabled),
     /* 4463 */   // MIs[0] root
     /* 4463 */   // No operand predicates
     /* 4463 */   // MIs[0] mi.shifted
     /* 4463 */   // No operand predicates
     /* 4463 */   // MIs[0] mi.amt
     /* 4463 */   // No operand predicates
     /* 4463 */   // Combiner Rule #105: shifts_too_big @ [mi[2]]
     /* 4463 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner56),
     /* 4466 */ // Label 286: @4466
     /* 4466 */ GIM_Reject,
     /* 4467 */ // Label 32: @4467
     /* 4467 */ GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(4478), // Rule ID 84 //
     /* 4472 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule75Enabled),
     /* 4475 */   // Combiner Rule #75: binop_right_undef_to_undef; wip_match_opcode 'G_ASHR'
     /* 4475 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner37),
     /* 4478 */ // Label 287: @4478
     /* 4478 */ GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(4489), // Rule ID 118 //
     /* 4483 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 4486 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_ASHR'
     /* 4486 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 4489 */ // Label 288: @4489
     /* 4489 */ GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(4500), // Rule ID 158 //
     /* 4494 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule116Enabled),
     /* 4497 */   // Combiner Rule #116: shl_ashr_to_sext_inreg; wip_match_opcode 'G_ASHR'
     /* 4497 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner65),
     /* 4500 */ // Label 289: @4500
     /* 4500 */ GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(4511), // Rule ID 201 //
     /* 4505 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule150Enabled),
     /* 4508 */   // Combiner Rule #150: shift_immed_chain; wip_match_opcode 'G_ASHR'
     /* 4508 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner92),
     /* 4511 */ // Label 290: @4511
     /* 4511 */ GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(4522), // Rule ID 206 //
     /* 4516 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule151Enabled),
     /* 4519 */   // Combiner Rule #151: shift_of_shifted_logic_chain; wip_match_opcode 'G_ASHR'
     /* 4519 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner93),
     /* 4522 */ // Label 291: @4522
     /* 4522 */ GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(4533), // Rule ID 227 //
     /* 4527 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule164Enabled),
     /* 4530 */   // Combiner Rule #164: bitfield_extract_from_shr; wip_match_opcode 'G_ASHR'
     /* 4530 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner102),
     /* 4533 */ // Label 292: @4533
     /* 4533 */ GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(4544), // Rule ID 229 //
     /* 4538 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule165Enabled),
     /* 4541 */   // Combiner Rule #165: bitfield_extract_from_shr_and; wip_match_opcode 'G_ASHR'
     /* 4541 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner103),
     /* 4544 */ // Label 293: @4544
     /* 4544 */ GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(4555), // Rule ID 234 //
     /* 4549 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 4552 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_ASHR'
     /* 4552 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 4555 */ // Label 294: @4555
     /* 4555 */ GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(4566), // Rule ID 286 //
     /* 4560 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 4563 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_ASHR'
     /* 4563 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 4566 */ // Label 295: @4566
     /* 4566 */ GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(4589), // Rule ID 109 //
     /* 4571 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 4574 */   // MIs[0] dst
     /* 4574 */   // No operand predicates
     /* 4574 */   // MIs[0] lhs
     /* 4574 */   // No operand predicates
     /* 4574 */   // MIs[0] Operand 2
     /* 4574 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 4578 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4583 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[5]]
     /* 4583 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4588 */   GIR_EraseRootFromParent_Done,
     /* 4589 */ // Label 296: @4589
     /* 4589 */ GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(4600), // Rule ID 146 //
     /* 4594 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule105Enabled),
     /* 4597 */   // MIs[0] root
     /* 4597 */   // No operand predicates
     /* 4597 */   // MIs[0] mi.shifted
     /* 4597 */   // No operand predicates
     /* 4597 */   // MIs[0] mi.amt
     /* 4597 */   // No operand predicates
     /* 4597 */   // Combiner Rule #105: shifts_too_big @ [mi[1]]
     /* 4597 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner56),
     /* 4600 */ // Label 297: @4600
     /* 4600 */ GIM_Reject,
     /* 4601 */ // Label 33: @4601
     /* 4601 */ GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(4612), // Rule ID 216 //
     /* 4606 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule155Enabled),
     /* 4609 */   // Combiner Rule #155: funnel_shift_to_rotate; wip_match_opcode 'G_FSHL'
     /* 4609 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner97),
     /* 4612 */ // Label 298: @4612
     /* 4612 */ GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(4623), // Rule ID 220 //
     /* 4617 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule158Enabled),
     /* 4620 */   // Combiner Rule #158: funnel_shift_overshift; wip_match_opcode 'G_FSHL'
     /* 4620 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner98),
     /* 4623 */ // Label 299: @4623
     /* 4623 */ GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(4643), // Rule ID 219 //
     /* 4628 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule157Enabled),
     /* 4631 */   // MIs[0] x
     /* 4631 */   // No operand predicates
     /* 4631 */   // MIs[0] y
     /* 4631 */   // No operand predicates
     /* 4631 */   // MIs[0] z
     /* 4631 */   // No operand predicates
     /* 4631 */   // MIs[0] Operand 3
     /* 4631 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/3, 0,
     /* 4635 */   // Combiner Rule #157: funnel_shift_left_zero
     /* 4635 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 4638 */   GIR_RootToRootCopy, /*OpIdx*/0, // x
     /* 4640 */   GIR_RootToRootCopy, /*OpIdx*/1, // y
     /* 4642 */   GIR_EraseRootFromParent_Done,
     /* 4643 */ // Label 300: @4643
     /* 4643 */ GIM_Reject,
     /* 4644 */ // Label 34: @4644
     /* 4644 */ GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(4655), // Rule ID 217 //
     /* 4649 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule155Enabled),
     /* 4652 */   // Combiner Rule #155: funnel_shift_to_rotate; wip_match_opcode 'G_FSHR'
     /* 4652 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner97),
     /* 4655 */ // Label 301: @4655
     /* 4655 */ GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(4666), // Rule ID 221 //
     /* 4660 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule158Enabled),
     /* 4663 */   // Combiner Rule #158: funnel_shift_overshift; wip_match_opcode 'G_FSHR'
     /* 4663 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner98),
     /* 4666 */ // Label 302: @4666
     /* 4666 */ GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(4686), // Rule ID 218 //
     /* 4671 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule156Enabled),
     /* 4674 */   // MIs[0] x
     /* 4674 */   // No operand predicates
     /* 4674 */   // MIs[0] y
     /* 4674 */   // No operand predicates
     /* 4674 */   // MIs[0] z
     /* 4674 */   // No operand predicates
     /* 4674 */   // MIs[0] Operand 3
     /* 4674 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/3, 0,
     /* 4678 */   // Combiner Rule #156: funnel_shift_right_zero
     /* 4678 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 4681 */   GIR_RootToRootCopy, /*OpIdx*/0, // x
     /* 4683 */   GIR_RootToRootCopy, /*OpIdx*/2, // z
     /* 4685 */   GIR_EraseRootFromParent_Done,
     /* 4686 */ // Label 303: @4686
     /* 4686 */ GIM_Reject,
     /* 4687 */ // Label 35: @4687
     /* 4687 */ GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(4710), // Rule ID 113 //
     /* 4692 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 4695 */   // MIs[0] dst
     /* 4695 */   // No operand predicates
     /* 4695 */   // MIs[0] lhs
     /* 4695 */   // No operand predicates
     /* 4695 */   // MIs[0] Operand 2
     /* 4695 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 4699 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4704 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[9]]
     /* 4704 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4709 */   GIR_EraseRootFromParent_Done,
     /* 4710 */ // Label 304: @4710
     /* 4710 */ GIM_Reject,
     /* 4711 */ // Label 36: @4711
     /* 4711 */ GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(4734), // Rule ID 112 //
     /* 4716 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 4719 */   // MIs[0] dst
     /* 4719 */   // No operand predicates
     /* 4719 */   // MIs[0] lhs
     /* 4719 */   // No operand predicates
     /* 4719 */   // MIs[0] Operand 2
     /* 4719 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 4723 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4728 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[8]]
     /* 4728 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4733 */   GIR_EraseRootFromParent_Done,
     /* 4734 */ // Label 305: @4734
     /* 4734 */ GIM_Reject,
     /* 4735 */ // Label 37: @4735
     /* 4735 */ GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(4746), // Rule ID 153 //
     /* 4740 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule111Enabled),
     /* 4743 */   // Combiner Rule #111: icmp_to_true_false_known_bits; wip_match_opcode 'G_ICMP'
     /* 4743 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner62),
     /* 4746 */ // Label 306: @4746
     /* 4746 */ GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(4757), // Rule ID 154 //
     /* 4751 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule112Enabled),
     /* 4754 */   // Combiner Rule #112: icmp_to_lhs_known_bits; wip_match_opcode 'G_ICMP'
     /* 4754 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner63),
     /* 4757 */ // Label 307: @4757
     /* 4757 */ GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(4768), // Rule ID 157 //
     /* 4762 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule115Enabled),
     /* 4765 */   // Combiner Rule #115: redundant_binop_in_equality; wip_match_opcode 'G_ICMP'
     /* 4765 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner64),
     /* 4768 */ // Label 308: @4768
     /* 4768 */ GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(4779), // Rule ID 151 //
     /* 4773 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule109Enabled),
     /* 4776 */   // MIs[0] root
     /* 4776 */   // No operand predicates
     /* 4776 */   // MIs[0] pred
     /* 4776 */   // No operand predicates
     /* 4776 */   // MIs[0] lhs
     /* 4776 */   // No operand predicates
     /* 4776 */   // MIs[0] rhs
     /* 4776 */   // No operand predicates
     /* 4776 */   // Combiner Rule #109: canonicalize_icmp
     /* 4776 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner60),
     /* 4779 */ // Label 309: @4779
     /* 4779 */ GIM_Reject,
     /* 4780 */ // Label 38: @4780
     /* 4780 */ GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(4791), // Rule ID 152 //
     /* 4785 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule110Enabled),
     /* 4788 */   // MIs[0] root
     /* 4788 */   // No operand predicates
     /* 4788 */   // MIs[0] pred
     /* 4788 */   // No operand predicates
     /* 4788 */   // MIs[0] lhs
     /* 4788 */   // No operand predicates
     /* 4788 */   // MIs[0] rhs
     /* 4788 */   // No operand predicates
     /* 4788 */   // Combiner Rule #110: canonicalize_fcmp
     /* 4788 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner61),
     /* 4791 */ // Label 310: @4791
     /* 4791 */ GIM_Reject,
     /* 4792 */ // Label 39: @4792
     /* 4792 */ GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(4803), // Rule ID 103 //
     /* 4797 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule83Enabled),
     /* 4800 */   // Combiner Rule #83: select_same_val; wip_match_opcode 'G_SELECT'
     /* 4800 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner44),
     /* 4803 */ // Label 311: @4803
     /* 4803 */ GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(4814), // Rule ID 164 //
     /* 4808 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule122Enabled),
     /* 4811 */   // Combiner Rule #122: select_constant_cmp; wip_match_opcode 'G_SELECT'
     /* 4811 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner69),
     /* 4814 */ // Label 312: @4814
     /* 4814 */ GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(4825), // Rule ID 166 //
     /* 4819 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule124Enabled),
     /* 4822 */   // Combiner Rule #124: match_selects; wip_match_opcode 'G_SELECT'
     /* 4822 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner71),
     /* 4825 */ // Label 313: @4825
     /* 4825 */ GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(4836), // Rule ID 307 //
     /* 4830 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule189Enabled),
     /* 4833 */   // Combiner Rule #189: select_to_minmax; wip_match_opcode 'G_SELECT'
     /* 4833 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner125),
     /* 4836 */ // Label 314: @4836
     /* 4836 */ GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(4857), // Rule ID 165 //
     /* 4841 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule123Enabled),
     /* 4844 */   // MIs[0] root
     /* 4844 */   // No operand predicates
     /* 4844 */   // MIs[0] tst
     /* 4844 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4848 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 4852 */   // MIs[1] tst1
     /* 4852 */   // No operand predicates
     /* 4852 */   // MIs[1] a
     /* 4852 */   // No operand predicates
     /* 4852 */   // MIs[1] b
     /* 4852 */   // No operand predicates
     /* 4852 */   // MIs[0] x
     /* 4852 */   // No operand predicates
     /* 4852 */   // MIs[0] y
     /* 4852 */   // No operand predicates
     /* 4852 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4854 */   // Combiner Rule #123: select_to_iminmax
     /* 4854 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner70),
     /* 4857 */ // Label 315: @4857
     /* 4857 */ GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(4886), // Rule ID 163 //
     /* 4862 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule121Enabled),
     /* 4865 */   // MIs[0] dst
     /* 4865 */   // No operand predicates
     /* 4865 */   // MIs[0] undef
     /* 4865 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4869 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 4873 */   // MIs[0] x
     /* 4873 */   // No operand predicates
     /* 4873 */   // MIs[0] y
     /* 4873 */   // No operand predicates
     /* 4873 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/3,
     /* 4878 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4880 */   // Combiner Rule #121: select_undef_cmp
     /* 4880 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/3,
     /* 4885 */   GIR_EraseRootFromParent_Done,
     /* 4886 */ // Label 316: @4886
     /* 4886 */ GIM_Reject,
     /* 4887 */ // Label 40: @4887
     /* 4887 */ GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(4898), // Rule ID 318 //
     /* 4892 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 4895 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_UADDO'
     /* 4895 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 4898 */ // Label 317: @4898
     /* 4898 */ GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(4909), // Rule ID 359 //
     /* 4903 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule213Enabled),
     /* 4906 */   // Combiner Rule #213: match_addos; wip_match_opcode 'G_UADDO'
     /* 4906 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner149),
     /* 4909 */ // Label 318: @4909
     /* 4909 */ GIM_Reject,
     /* 4910 */ // Label 41: @4910
     /* 4910 */ GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(4921), // Rule ID 189 //
     /* 4915 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule145Enabled),
     /* 4918 */   // Combiner Rule #145: adde_to_addo; wip_match_opcode 'G_UADDE'
     /* 4918 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner87),
     /* 4921 */ // Label 319: @4921
     /* 4921 */ GIM_Reject,
     /* 4922 */ // Label 42: @4922
     /* 4922 */ GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(4933), // Rule ID 361 //
     /* 4927 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule214Enabled),
     /* 4930 */   // Combiner Rule #214: match_subo_no_overflow; wip_match_opcode 'G_USUBO'
     /* 4930 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner150),
     /* 4933 */ // Label 320: @4933
     /* 4933 */ GIM_Reject,
     /* 4934 */ // Label 43: @4934
     /* 4934 */ GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(4945), // Rule ID 191 //
     /* 4939 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule145Enabled),
     /* 4942 */   // Combiner Rule #145: adde_to_addo; wip_match_opcode 'G_USUBE'
     /* 4942 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner87),
     /* 4945 */ // Label 321: @4945
     /* 4945 */ GIM_Reject,
     /* 4946 */ // Label 44: @4946
     /* 4946 */ GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(4957), // Rule ID 319 //
     /* 4951 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 4954 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_SADDO'
     /* 4954 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 4957 */ // Label 322: @4957
     /* 4957 */ GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(4968), // Rule ID 358 //
     /* 4962 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule213Enabled),
     /* 4965 */   // Combiner Rule #213: match_addos; wip_match_opcode 'G_SADDO'
     /* 4965 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner149),
     /* 4968 */ // Label 323: @4968
     /* 4968 */ GIM_Reject,
     /* 4969 */ // Label 45: @4969
     /* 4969 */ GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(4980), // Rule ID 190 //
     /* 4974 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule145Enabled),
     /* 4977 */   // Combiner Rule #145: adde_to_addo; wip_match_opcode 'G_SADDE'
     /* 4977 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner87),
     /* 4980 */ // Label 324: @4980
     /* 4980 */ GIM_Reject,
     /* 4981 */ // Label 46: @4981
     /* 4981 */ GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(4992), // Rule ID 360 //
     /* 4986 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule214Enabled),
     /* 4989 */   // Combiner Rule #214: match_subo_no_overflow; wip_match_opcode 'G_SSUBO'
     /* 4989 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner150),
     /* 4992 */ // Label 325: @4992
     /* 4992 */ GIM_Reject,
     /* 4993 */ // Label 47: @4993
     /* 4993 */ GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(5004), // Rule ID 192 //
     /* 4998 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule145Enabled),
     /* 5001 */   // Combiner Rule #145: adde_to_addo; wip_match_opcode 'G_SSUBE'
     /* 5001 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner87),
     /* 5004 */ // Label 326: @5004
     /* 5004 */ GIM_Reject,
     /* 5005 */ // Label 48: @5005
     /* 5005 */ GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(5016), // Rule ID 185 //
     /* 5010 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule143Enabled),
     /* 5013 */   // Combiner Rule #143: mulo_by_2; wip_match_opcode 'G_UMULO'
     /* 5013 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner85),
     /* 5016 */ // Label 327: @5016
     /* 5016 */ GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(5027), // Rule ID 187 //
     /* 5021 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule144Enabled),
     /* 5024 */   // Combiner Rule #144: mulo_by_0; wip_match_opcode 'G_UMULO'
     /* 5024 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner86),
     /* 5027 */ // Label 328: @5027
     /* 5027 */ GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(5038), // Rule ID 320 //
     /* 5032 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 5035 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULO'
     /* 5035 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5038 */ // Label 329: @5038
     /* 5038 */ GIM_Reject,
     /* 5039 */ // Label 49: @5039
     /* 5039 */ GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(5050), // Rule ID 186 //
     /* 5044 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule143Enabled),
     /* 5047 */   // Combiner Rule #143: mulo_by_2; wip_match_opcode 'G_SMULO'
     /* 5047 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner85),
     /* 5050 */ // Label 330: @5050
     /* 5050 */ GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(5061), // Rule ID 188 //
     /* 5055 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule144Enabled),
     /* 5058 */   // Combiner Rule #144: mulo_by_0; wip_match_opcode 'G_SMULO'
     /* 5058 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner86),
     /* 5061 */ // Label 331: @5061
     /* 5061 */ GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(5072), // Rule ID 321 //
     /* 5066 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 5069 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULO'
     /* 5069 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5072 */ // Label 332: @5072
     /* 5072 */ GIM_Reject,
     /* 5073 */ // Label 50: @5073
     /* 5073 */ GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(5084), // Rule ID 259 //
     /* 5078 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule171Enabled),
     /* 5081 */   // Combiner Rule #171: mulh_to_lshr; wip_match_opcode 'G_UMULH'
     /* 5081 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner108),
     /* 5084 */ // Label 333: @5084
     /* 5084 */ GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(5095), // Rule ID 322 //
     /* 5089 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 5092 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULH'
     /* 5092 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5095 */ // Label 334: @5095
     /* 5095 */ GIM_Reject,
     /* 5096 */ // Label 51: @5096
     /* 5096 */ GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(5107), // Rule ID 323 //
     /* 5101 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 5104 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULH'
     /* 5104 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5107 */ // Label 335: @5107
     /* 5107 */ GIM_Reject,
     /* 5108 */ // Label 52: @5108
     /* 5108 */ GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(5119), // Rule ID 324 //
     /* 5113 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 5116 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_UADDSAT'
     /* 5116 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5119 */ // Label 336: @5119
     /* 5119 */ GIM_Reject,
     /* 5120 */ // Label 53: @5120
     /* 5120 */ GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(5131), // Rule ID 325 //
     /* 5125 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 5128 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_SADDSAT'
     /* 5128 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5131 */ // Label 337: @5131
     /* 5131 */ GIM_Reject,
     /* 5132 */ // Label 54: @5132
     /* 5132 */ GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(5143), // Rule ID 204 //
     /* 5137 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule150Enabled),
     /* 5140 */   // Combiner Rule #150: shift_immed_chain; wip_match_opcode 'G_USHLSAT'
     /* 5140 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner92),
     /* 5143 */ // Label 338: @5143
     /* 5143 */ GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(5154), // Rule ID 208 //
     /* 5148 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule151Enabled),
     /* 5151 */   // Combiner Rule #151: shift_of_shifted_logic_chain; wip_match_opcode 'G_USHLSAT'
     /* 5151 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner93),
     /* 5154 */ // Label 339: @5154
     /* 5154 */ GIM_Reject,
     /* 5155 */ // Label 55: @5155
     /* 5155 */ GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(5166), // Rule ID 203 //
     /* 5160 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule150Enabled),
     /* 5163 */   // Combiner Rule #150: shift_immed_chain; wip_match_opcode 'G_SSHLSAT'
     /* 5163 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner92),
     /* 5166 */ // Label 340: @5166
     /* 5166 */ GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(5177), // Rule ID 209 //
     /* 5171 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule151Enabled),
     /* 5174 */   // Combiner Rule #151: shift_of_shifted_logic_chain; wip_match_opcode 'G_SSHLSAT'
     /* 5174 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner93),
     /* 5177 */ // Label 341: @5177
     /* 5177 */ GIM_Reject,
     /* 5178 */ // Label 56: @5178
     /* 5178 */ GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(5189), // Rule ID 326 //
     /* 5183 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 5186 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULFIX'
     /* 5186 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5189 */ // Label 342: @5189
     /* 5189 */ GIM_Reject,
     /* 5190 */ // Label 57: @5190
     /* 5190 */ GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(5201), // Rule ID 327 //
     /* 5195 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 5198 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULFIX'
     /* 5198 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5201 */ // Label 343: @5201
     /* 5201 */ GIM_Reject,
     /* 5202 */ // Label 58: @5202
     /* 5202 */ GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(5213), // Rule ID 328 //
     /* 5207 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 5210 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULFIXSAT'
     /* 5210 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5213 */ // Label 344: @5213
     /* 5213 */ GIM_Reject,
     /* 5214 */ // Label 59: @5214
     /* 5214 */ GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(5225), // Rule ID 329 //
     /* 5219 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 5222 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULFIXSAT'
     /* 5222 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5225 */ // Label 345: @5225
     /* 5225 */ GIM_Reject,
     /* 5226 */ // Label 60: @5226
     /* 5226 */ GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(5237), // Rule ID 249 //
     /* 5231 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule167Enabled),
     /* 5234 */   // Combiner Rule #167: constant_fold_fp_binop; wip_match_opcode 'G_FADD'
     /* 5234 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner105),
     /* 5237 */ // Label 346: @5237
     /* 5237 */ GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(5248), // Rule ID 260 //
     /* 5242 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule172Enabled),
     /* 5245 */   // Combiner Rule #172: redundant_neg_operands; wip_match_opcode 'G_FADD'
     /* 5245 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 5248 */ // Label 347: @5248
     /* 5248 */ GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(5259), // Rule ID 267 //
     /* 5253 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule174Enabled),
     /* 5256 */   // Combiner Rule #174: combine_fadd_fmul_to_fmad_or_fma; wip_match_opcode 'G_FADD'
     /* 5256 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner111),
     /* 5259 */ // Label 348: @5259
     /* 5259 */ GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(5270), // Rule ID 268 //
     /* 5264 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule175Enabled),
     /* 5267 */   // Combiner Rule #175: combine_fadd_fpext_fmul_to_fmad_or_fma; wip_match_opcode 'G_FADD'
     /* 5267 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner112),
     /* 5270 */ // Label 349: @5270
     /* 5270 */ GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(5281), // Rule ID 269 //
     /* 5275 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule176Enabled),
     /* 5278 */   // Combiner Rule #176: combine_fadd_fma_fmul_to_fmad_or_fma; wip_match_opcode 'G_FADD'
     /* 5278 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner113),
     /* 5281 */ // Label 350: @5281
     /* 5281 */ GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(5292), // Rule ID 270 //
     /* 5286 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule177Enabled),
     /* 5289 */   // Combiner Rule #177: combine_fadd_fpext_fma_fmul_to_fmad_or_fma; wip_match_opcode 'G_FADD'
     /* 5289 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner114),
     /* 5292 */ // Label 351: @5292
     /* 5292 */ GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(5303), // Rule ID 293 //
     /* 5297 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 5300 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_FADD'
     /* 5300 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 5303 */ // Label 352: @5303
     /* 5303 */ GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(5314), // Rule ID 330 //
     /* 5308 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 5311 */   // Combiner Rule #192: commute_fp_constant_to_rhs; wip_match_opcode 'G_FADD'
     /* 5311 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 5314 */ // Label 353: @5314
     /* 5314 */ GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(5337), // Rule ID 138 //
     /* 5319 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule100Enabled),
     /* 5322 */   // MIs[0] dst
     /* 5322 */   // No operand predicates
     /* 5322 */   // MIs[0] x
     /* 5322 */   // No operand predicates
     /* 5322 */   // MIs[0] y
     /* 5322 */   // No operand predicates
     /* 5322 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner3),
     /* 5326 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5331 */   // Combiner Rule #100: right_identity_neg_zero_fp
     /* 5331 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5336 */   GIR_EraseRootFromParent_Done,
     /* 5337 */ // Label 354: @5337
     /* 5337 */ GIM_Reject,
     /* 5338 */ // Label 61: @5338
     /* 5338 */ GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(5349), // Rule ID 250 //
     /* 5343 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule167Enabled),
     /* 5346 */   // Combiner Rule #167: constant_fold_fp_binop; wip_match_opcode 'G_FSUB'
     /* 5346 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner105),
     /* 5349 */ // Label 355: @5349
     /* 5349 */ GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(5360), // Rule ID 261 //
     /* 5354 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule172Enabled),
     /* 5357 */   // Combiner Rule #172: redundant_neg_operands; wip_match_opcode 'G_FSUB'
     /* 5357 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 5360 */ // Label 356: @5360
     /* 5360 */ GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(5371), // Rule ID 271 //
     /* 5365 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule178Enabled),
     /* 5368 */   // Combiner Rule #178: combine_fsub_fmul_to_fmad_or_fma; wip_match_opcode 'G_FSUB'
     /* 5368 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner115),
     /* 5371 */ // Label 357: @5371
     /* 5371 */ GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(5382), // Rule ID 272 //
     /* 5376 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule179Enabled),
     /* 5379 */   // Combiner Rule #179: combine_fsub_fneg_fmul_to_fmad_or_fma; wip_match_opcode 'G_FSUB'
     /* 5379 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner116),
     /* 5382 */ // Label 358: @5382
     /* 5382 */ GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(5393), // Rule ID 273 //
     /* 5387 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule180Enabled),
     /* 5390 */   // Combiner Rule #180: combine_fsub_fpext_fmul_to_fmad_or_fma; wip_match_opcode 'G_FSUB'
     /* 5390 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner117),
     /* 5393 */ // Label 359: @5393
     /* 5393 */ GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(5404), // Rule ID 274 //
     /* 5398 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule181Enabled),
     /* 5401 */   // Combiner Rule #181: combine_fsub_fpext_fneg_fmul_to_fmad_or_fma; wip_match_opcode 'G_FSUB'
     /* 5401 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner118),
     /* 5404 */ // Label 360: @5404
     /* 5404 */ GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(5415), // Rule ID 294 //
     /* 5409 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 5412 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_FSUB'
     /* 5412 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 5415 */ // Label 361: @5415
     /* 5415 */ GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(5426), // Rule ID 308 //
     /* 5420 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule190Enabled),
     /* 5423 */   // Combiner Rule #190: fsub_to_fneg; wip_match_opcode 'G_FSUB'
     /* 5423 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner126),
     /* 5426 */ // Label 362: @5426
     /* 5426 */ GIM_Reject,
     /* 5427 */ // Label 62: @5427
     /* 5427 */ GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(5438), // Rule ID 251 //
     /* 5432 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule167Enabled),
     /* 5435 */   // Combiner Rule #167: constant_fold_fp_binop; wip_match_opcode 'G_FMUL'
     /* 5435 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner105),
     /* 5438 */ // Label 363: @5438
     /* 5438 */ GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(5449), // Rule ID 262 //
     /* 5443 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule172Enabled),
     /* 5446 */   // Combiner Rule #172: redundant_neg_operands; wip_match_opcode 'G_FMUL'
     /* 5446 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 5449 */ // Label 364: @5449
     /* 5449 */ GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(5460), // Rule ID 292 //
     /* 5454 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 5457 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_FMUL'
     /* 5457 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 5460 */ // Label 365: @5460
     /* 5460 */ GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(5471), // Rule ID 331 //
     /* 5465 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 5468 */   // Combiner Rule #192: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMUL'
     /* 5468 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 5471 */ // Label 366: @5471
     /* 5471 */ GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(5494), // Rule ID 129 //
     /* 5476 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule93Enabled),
     /* 5479 */   // MIs[0] dst
     /* 5479 */   // No operand predicates
     /* 5479 */   // MIs[0] x
     /* 5479 */   // No operand predicates
     /* 5479 */   // MIs[0] y
     /* 5479 */   // No operand predicates
     /* 5479 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner2),
     /* 5483 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5488 */   // Combiner Rule #93: right_identity_one_fp
     /* 5488 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5493 */   GIR_EraseRootFromParent_Done,
     /* 5494 */ // Label 367: @5494
     /* 5494 */ GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(5514), // Rule ID 139 //
     /* 5499 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule101Enabled),
     /* 5502 */   // MIs[0] dst
     /* 5502 */   // No operand predicates
     /* 5502 */   // MIs[0] x
     /* 5502 */   // No operand predicates
     /* 5502 */   // MIs[0] y
     /* 5502 */   // No operand predicates
     /* 5502 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner4),
     /* 5506 */   // Combiner Rule #101: right_identity_neg_one_fp
     /* 5506 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_FNEG),
     /* 5509 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 5511 */   GIR_RootToRootCopy, /*OpIdx*/1, // x
     /* 5513 */   GIR_EraseRootFromParent_Done,
     /* 5514 */ // Label 368: @5514
     /* 5514 */ GIM_Reject,
     /* 5515 */ // Label 63: @5515
     /* 5515 */ GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(5526), // Rule ID 254 //
     /* 5520 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule168Enabled),
     /* 5523 */   // Combiner Rule #168: constant_fold_fma; wip_match_opcode 'G_FMA'
     /* 5523 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner106),
     /* 5526 */ // Label 369: @5526
     /* 5526 */ GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(5537), // Rule ID 265 //
     /* 5531 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule172Enabled),
     /* 5534 */   // Combiner Rule #172: redundant_neg_operands; wip_match_opcode 'G_FMA'
     /* 5534 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 5537 */ // Label 370: @5537
     /* 5537 */ GIM_Reject,
     /* 5538 */ // Label 64: @5538
     /* 5538 */ GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(5549), // Rule ID 253 //
     /* 5543 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule168Enabled),
     /* 5546 */   // Combiner Rule #168: constant_fold_fma; wip_match_opcode 'G_FMAD'
     /* 5546 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner106),
     /* 5549 */ // Label 371: @5549
     /* 5549 */ GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(5560), // Rule ID 264 //
     /* 5554 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule172Enabled),
     /* 5557 */   // Combiner Rule #172: redundant_neg_operands; wip_match_opcode 'G_FMAD'
     /* 5557 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 5560 */ // Label 372: @5560
     /* 5560 */ GIM_Reject,
     /* 5561 */ // Label 65: @5561
     /* 5561 */ GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(5572), // Rule ID 252 //
     /* 5566 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule167Enabled),
     /* 5569 */   // Combiner Rule #167: constant_fold_fp_binop; wip_match_opcode 'G_FDIV'
     /* 5569 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner105),
     /* 5572 */ // Label 373: @5572
     /* 5572 */ GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(5583), // Rule ID 263 //
     /* 5577 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule172Enabled),
     /* 5580 */   // Combiner Rule #172: redundant_neg_operands; wip_match_opcode 'G_FDIV'
     /* 5580 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 5583 */ // Label 374: @5583
     /* 5583 */ GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(5594), // Rule ID 295 //
     /* 5588 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 5591 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_FDIV'
     /* 5591 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 5594 */ // Label 375: @5594
     /* 5594 */ GIM_Reject,
     /* 5595 */ // Label 66: @5595
     /* 5595 */ GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(5606), // Rule ID 296 //
     /* 5600 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 5603 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_FREM'
     /* 5603 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 5606 */ // Label 376: @5606
     /* 5606 */ GIM_Reject,
     /* 5607 */ // Label 67: @5607
     /* 5607 */ GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(5628), // Rule ID 197 //
     /* 5612 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule147Enabled),
     /* 5615 */   // MIs[0] dst
     /* 5615 */   // No operand predicates
     /* 5615 */   // MIs[0] float
     /* 5615 */   // No operand predicates
     /* 5615 */   // MIs[0] int
     /* 5615 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 5619 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 5623 */   // MIs[1] imm
     /* 5623 */   // No operand predicates
     /* 5623 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5625 */   // Combiner Rule #147: expand_const_fpowi
     /* 5625 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner89),
     /* 5628 */ // Label 377: @5628
     /* 5628 */ GIM_Reject,
     /* 5629 */ // Label 68: @5629
     /* 5629 */ GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(5650), // Rule ID 179 //
     /* 5634 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule137Enabled),
     /* 5637 */   // MIs[0] dst
     /* 5637 */   // No operand predicates
     /* 5637 */   // MIs[0] src0
     /* 5637 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5641 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
     /* 5645 */   // MIs[1] cst
     /* 5645 */   // No operand predicates
     /* 5645 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5647 */   // Combiner Rule #137: constant_fold_flog2
     /* 5647 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner81),
     /* 5650 */ // Label 378: @5650
     /* 5650 */ GIM_Reject,
     /* 5651 */ // Label 69: @5651
     /* 5651 */ GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(5672), // Rule ID 176 //
     /* 5656 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule134Enabled),
     /* 5659 */   // MIs[0] dst
     /* 5659 */   // No operand predicates
     /* 5659 */   // MIs[0] src0
     /* 5659 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5663 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
     /* 5667 */   // MIs[1] cst
     /* 5667 */   // No operand predicates
     /* 5667 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5669 */   // Combiner Rule #134: constant_fold_fneg
     /* 5669 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner81),
     /* 5672 */ // Label 379: @5672
     /* 5672 */ GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(5701), // Rule ID 127 //
     /* 5677 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule91Enabled),
     /* 5680 */   // MIs[0] dst
     /* 5680 */   // No operand predicates
     /* 5680 */   // MIs[0] t
     /* 5680 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5684 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FNEG),
     /* 5688 */   // MIs[1] src
     /* 5688 */   // No operand predicates
     /* 5688 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 5693 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5695 */   // Combiner Rule #91: fneg_fneg_fold
     /* 5695 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 5700 */   GIR_EraseRootFromParent_Done,
     /* 5701 */ // Label 380: @5701
     /* 5701 */ GIM_Reject,
     /* 5702 */ // Label 70: @5702
     /* 5702 */ GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(5723), // Rule ID 180 //
     /* 5707 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule138Enabled),
     /* 5710 */   // MIs[0] dst
     /* 5710 */   // No operand predicates
     /* 5710 */   // MIs[0] src0
     /* 5710 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5714 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
     /* 5718 */   // MIs[1] cst
     /* 5718 */   // No operand predicates
     /* 5718 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5720 */   // Combiner Rule #138: constant_fold_fptrunc
     /* 5720 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner81),
     /* 5723 */ // Label 381: @5723
     /* 5723 */ GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(5744), // Rule ID 137 //
     /* 5728 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule99Enabled),
     /* 5731 */   // MIs[0] dst
     /* 5731 */   // No operand predicates
     /* 5731 */   // MIs[0] src1
     /* 5731 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5735 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FPEXT),
     /* 5739 */   // MIs[1] src0
     /* 5739 */   // No operand predicates
     /* 5739 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5741 */   // Combiner Rule #99: fptrunc_fpext_fold
     /* 5741 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner52),
     /* 5744 */ // Label 382: @5744
     /* 5744 */ GIM_Reject,
     /* 5745 */ // Label 71: @5745
     /* 5745 */ GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(5766), // Rule ID 92 //
     /* 5750 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 5753 */   // MIs[0] dst
     /* 5753 */   // No operand predicates
     /* 5753 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 5753 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5757 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 5761 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5763 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[5]]
     /* 5763 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 5766 */ // Label 383: @5766
     /* 5766 */ GIM_Reject,
     /* 5767 */ // Label 72: @5767
     /* 5767 */ GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(5788), // Rule ID 93 //
     /* 5772 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 5775 */   // MIs[0] dst
     /* 5775 */   // No operand predicates
     /* 5775 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 5775 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5779 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 5783 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5785 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[6]]
     /* 5785 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 5788 */ // Label 384: @5788
     /* 5788 */ GIM_Reject,
     /* 5789 */ // Label 73: @5789
     /* 5789 */ GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(5800), // Rule ID 76 //
     /* 5794 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule71Enabled),
     /* 5797 */   // Combiner Rule #71: undef_to_fp_zero; wip_match_opcode 'G_SITOFP'
     /* 5797 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner33),
     /* 5800 */ // Label 385: @5800
     /* 5800 */ GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(5815), // Rule ID 181 //
     /* 5805 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule139Enabled),
     /* 5808 */   // MIs[0] dst
     /* 5808 */   // No operand predicates
     /* 5808 */   // MIs[0] Operand 1
     /* 5808 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /* 5812 */   // Combiner Rule #139: itof_const_zero_fold_si
     /* 5812 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner82),
     /* 5815 */ // Label 386: @5815
     /* 5815 */ GIM_Reject,
     /* 5816 */ // Label 74: @5816
     /* 5816 */ GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(5827), // Rule ID 75 //
     /* 5821 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule71Enabled),
     /* 5824 */   // Combiner Rule #71: undef_to_fp_zero; wip_match_opcode 'G_UITOFP'
     /* 5824 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner33),
     /* 5827 */ // Label 387: @5827
     /* 5827 */ GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(5842), // Rule ID 182 //
     /* 5832 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule140Enabled),
     /* 5835 */   // MIs[0] dst
     /* 5835 */   // No operand predicates
     /* 5835 */   // MIs[0] Operand 1
     /* 5835 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /* 5839 */   // Combiner Rule #140: itof_const_zero_fold_ui
     /* 5839 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner82),
     /* 5842 */ // Label 388: @5842
     /* 5842 */ GIM_Reject,
     /* 5843 */ // Label 75: @5843
     /* 5843 */ GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(5872), // Rule ID 19 //
     /* 5848 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule18Enabled),
     /* 5851 */   // MIs[0] dst
     /* 5851 */   // No operand predicates
     /* 5851 */   // MIs[0] src
     /* 5851 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5855 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FABS),
     /* 5859 */   // MIs[1] __idempotent_prop_match_0.x
     /* 5859 */   // No operand predicates
     /* 5859 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5864 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5866 */   // Combiner Rule #18: idempotent_prop @ [__idempotent_prop_match_0[1]]
     /* 5866 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5871 */   GIR_EraseRootFromParent_Done,
     /* 5872 */ // Label 389: @5872
     /* 5872 */ GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(5893), // Rule ID 177 //
     /* 5877 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule135Enabled),
     /* 5880 */   // MIs[0] dst
     /* 5880 */   // No operand predicates
     /* 5880 */   // MIs[0] src0
     /* 5880 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5884 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
     /* 5888 */   // MIs[1] cst
     /* 5888 */   // No operand predicates
     /* 5888 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5890 */   // Combiner Rule #135: constant_fold_fabs
     /* 5890 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner81),
     /* 5893 */ // Label 390: @5893
     /* 5893 */ GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(5921), // Rule ID 258 //
     /* 5898 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule170Enabled),
     /* 5901 */   // MIs[0] dst
     /* 5901 */   // No operand predicates
     /* 5901 */   // MIs[0] tmp
     /* 5901 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5905 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FNEG),
     /* 5909 */   // MIs[1] x
     /* 5909 */   // No operand predicates
     /* 5909 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5911 */   // Combiner Rule #170: fabs_fneg_fold
     /* 5911 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_FABS),
     /* 5914 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 5916 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
     /* 5920 */   GIR_EraseRootFromParent_Done,
     /* 5921 */ // Label 391: @5921
     /* 5921 */ GIM_Reject,
     /* 5922 */ // Label 76: @5922
     /* 5922 */ GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(5951), // Rule ID 20 //
     /* 5927 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule18Enabled),
     /* 5930 */   // MIs[0] dst
     /* 5930 */   // No operand predicates
     /* 5930 */   // MIs[0] src
     /* 5930 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5934 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCANONICALIZE),
     /* 5938 */   // MIs[1] __idempotent_prop_match_0.x
     /* 5938 */   // No operand predicates
     /* 5938 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5943 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5945 */   // Combiner Rule #18: idempotent_prop @ [__idempotent_prop_match_0[2]]
     /* 5945 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5950 */   GIR_EraseRootFromParent_Done,
     /* 5951 */ // Label 392: @5951
     /* 5951 */ GIM_Reject,
     /* 5952 */ // Label 77: @5952
     /* 5952 */ GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(5963), // Rule ID 193 //
     /* 5957 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule146Enabled),
     /* 5960 */   // Combiner Rule #146: combine_minmax_nan; wip_match_opcode 'G_FMINNUM'
     /* 5960 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner88),
     /* 5963 */ // Label 393: @5963
     /* 5963 */ GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(5974), // Rule ID 297 //
     /* 5968 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 5971 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_FMINNUM'
     /* 5971 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 5974 */ // Label 394: @5974
     /* 5974 */ GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(5985), // Rule ID 332 //
     /* 5979 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 5982 */   // Combiner Rule #192: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMINNUM'
     /* 5982 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 5985 */ // Label 395: @5985
     /* 5985 */ GIM_Reject,
     /* 5986 */ // Label 78: @5986
     /* 5986 */ GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(5997), // Rule ID 194 //
     /* 5991 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule146Enabled),
     /* 5994 */   // Combiner Rule #146: combine_minmax_nan; wip_match_opcode 'G_FMAXNUM'
     /* 5994 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner88),
     /* 5997 */ // Label 396: @5997
     /* 5997 */ GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(6008), // Rule ID 298 //
     /* 6002 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 6005 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_FMAXNUM'
     /* 6005 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6008 */ // Label 397: @6008
     /* 6008 */ GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(6019), // Rule ID 333 //
     /* 6013 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 6016 */   // Combiner Rule #192: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMAXNUM'
     /* 6016 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6019 */ // Label 398: @6019
     /* 6019 */ GIM_Reject,
     /* 6020 */ // Label 79: @6020
     /* 6020 */ GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(6031), // Rule ID 334 //
     /* 6025 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 6028 */   // Combiner Rule #192: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMINNUM_IEEE'
     /* 6028 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6031 */ // Label 399: @6031
     /* 6031 */ GIM_Reject,
     /* 6032 */ // Label 80: @6032
     /* 6032 */ GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(6043), // Rule ID 335 //
     /* 6037 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 6040 */   // Combiner Rule #192: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMAXNUM_IEEE'
     /* 6040 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6043 */ // Label 400: @6043
     /* 6043 */ GIM_Reject,
     /* 6044 */ // Label 81: @6044
     /* 6044 */ GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(6055), // Rule ID 195 //
     /* 6049 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule146Enabled),
     /* 6052 */   // Combiner Rule #146: combine_minmax_nan; wip_match_opcode 'G_FMINIMUM'
     /* 6052 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner88),
     /* 6055 */ // Label 401: @6055
     /* 6055 */ GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(6066), // Rule ID 299 //
     /* 6060 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 6063 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_FMINIMUM'
     /* 6063 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6066 */ // Label 402: @6066
     /* 6066 */ GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(6077), // Rule ID 336 //
     /* 6071 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 6074 */   // Combiner Rule #192: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMINIMUM'
     /* 6074 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6077 */ // Label 403: @6077
     /* 6077 */ GIM_Reject,
     /* 6078 */ // Label 82: @6078
     /* 6078 */ GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(6089), // Rule ID 196 //
     /* 6083 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule146Enabled),
     /* 6086 */   // Combiner Rule #146: combine_minmax_nan; wip_match_opcode 'G_FMAXIMUM'
     /* 6086 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner88),
     /* 6089 */ // Label 404: @6089
     /* 6089 */ GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(6100), // Rule ID 300 //
     /* 6094 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 6097 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_FMAXIMUM'
     /* 6097 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6100 */ // Label 405: @6100
     /* 6100 */ GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(6111), // Rule ID 337 //
     /* 6105 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 6108 */   // Combiner Rule #192: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMAXIMUM'
     /* 6108 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6111 */ // Label 406: @6111
     /* 6111 */ GIM_Reject,
     /* 6112 */ // Label 83: @6112
     /* 6112 */ GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(6123), // Rule ID 148 //
     /* 6117 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule106Enabled),
     /* 6120 */   // Combiner Rule #106: reassoc_ptradd; wip_match_opcode 'G_PTR_ADD'
     /* 6120 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner57),
     /* 6123 */ // Label 407: @6123
     /* 6123 */ GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(6134), // Rule ID 150 //
     /* 6128 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule108Enabled),
     /* 6131 */   // Combiner Rule #108: ptr_add_immed_chain; wip_match_opcode 'G_PTR_ADD'
     /* 6131 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner59),
     /* 6134 */ // Label 408: @6134
     /* 6134 */ GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(6145), // Rule ID 183 //
     /* 6139 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule141Enabled),
     /* 6142 */   // Combiner Rule #141: const_ptradd_to_i2p; wip_match_opcode 'G_PTR_ADD'
     /* 6142 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner83),
     /* 6145 */ // Label 409: @6145
     /* 6145 */ GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(6156), // Rule ID 199 //
     /* 6150 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule149Enabled),
     /* 6153 */   // Combiner Rule #149: ptr_add_with_zero; wip_match_opcode 'G_PTR_ADD'
     /* 6153 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner91),
     /* 6156 */ // Label 410: @6156
     /* 6156 */ GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(6167), // Rule ID 232 //
     /* 6161 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 6164 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_PTR_ADD'
     /* 6164 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 6167 */ // Label 411: @6167
     /* 6167 */ GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(6178), // Rule ID 277 //
     /* 6172 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 6175 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_PTR_ADD'
     /* 6175 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6178 */ // Label 412: @6178
     /* 6178 */ GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(6201), // Rule ID 111 //
     /* 6183 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 6186 */   // MIs[0] dst
     /* 6186 */   // No operand predicates
     /* 6186 */   // MIs[0] lhs
     /* 6186 */   // No operand predicates
     /* 6186 */   // MIs[0] Operand 2
     /* 6186 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 6190 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6195 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[7]]
     /* 6195 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6200 */   GIR_EraseRootFromParent_Done,
     /* 6201 */ // Label 413: @6201
     /* 6201 */ GIM_Reject,
     /* 6202 */ // Label 84: @6202
     /* 6202 */ GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(6213), // Rule ID 245 //
     /* 6207 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 6210 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_SMIN'
     /* 6210 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 6213 */ // Label 414: @6213
     /* 6213 */ GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(6224), // Rule ID 288 //
     /* 6218 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 6221 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_SMIN'
     /* 6221 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6224 */ // Label 415: @6224
     /* 6224 */ GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(6235), // Rule ID 314 //
     /* 6229 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 6232 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_SMIN'
     /* 6232 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 6235 */ // Label 416: @6235
     /* 6235 */ GIM_Reject,
     /* 6236 */ // Label 85: @6236
     /* 6236 */ GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(6247), // Rule ID 246 //
     /* 6241 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 6244 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_SMAX'
     /* 6244 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 6247 */ // Label 417: @6247
     /* 6247 */ GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(6258), // Rule ID 289 //
     /* 6252 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 6255 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_SMAX'
     /* 6255 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6258 */ // Label 418: @6258
     /* 6258 */ GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(6269), // Rule ID 315 //
     /* 6263 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 6266 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_SMAX'
     /* 6266 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 6269 */ // Label 419: @6269
     /* 6269 */ GIM_Reject,
     /* 6270 */ // Label 86: @6270
     /* 6270 */ GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(6281), // Rule ID 247 //
     /* 6275 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 6278 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_UMIN'
     /* 6278 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 6281 */ // Label 420: @6281
     /* 6281 */ GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(6292), // Rule ID 290 //
     /* 6286 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 6289 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_UMIN'
     /* 6289 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6292 */ // Label 421: @6292
     /* 6292 */ GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(6303), // Rule ID 316 //
     /* 6297 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 6300 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_UMIN'
     /* 6300 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 6303 */ // Label 422: @6303
     /* 6303 */ GIM_Reject,
     /* 6304 */ // Label 87: @6304
     /* 6304 */ GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(6315), // Rule ID 248 //
     /* 6309 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 6312 */   // Combiner Rule #166: constant_fold_binop; wip_match_opcode 'G_UMAX'
     /* 6312 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 6315 */ // Label 423: @6315
     /* 6315 */ GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(6326), // Rule ID 291 //
     /* 6320 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 6323 */   // Combiner Rule #182: fold_binop_into_select; wip_match_opcode 'G_UMAX'
     /* 6323 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6326 */ // Label 424: @6326
     /* 6326 */ GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(6337), // Rule ID 317 //
     /* 6331 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 6334 */   // Combiner Rule #191: commute_int_constant_to_rhs; wip_match_opcode 'G_UMAX'
     /* 6334 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 6337 */ // Label 425: @6337
     /* 6337 */ GIM_Reject,
     /* 6338 */ // Label 88: @6338
     /* 6338 */ GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(6349), // Rule ID 86 //
     /* 6343 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule76Enabled),
     /* 6346 */   // Combiner Rule #76: unary_undef_to_zero; wip_match_opcode 'G_ABS'
     /* 6346 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner36),
     /* 6349 */ // Label 426: @6349
     /* 6349 */ GIM_Reject,
     /* 6350 */ // Label 89: @6350
     /* 6350 */ GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(6361), // Rule ID 175 //
     /* 6355 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule133Enabled),
     /* 6358 */   // Combiner Rule #133: opt_brcond_by_inverting_cond; wip_match_opcode 'G_BR'
     /* 6358 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner80),
     /* 6361 */ // Label 427: @6361
     /* 6361 */ GIM_Reject,
     /* 6362 */ // Label 90: @6362
     /* 6362 */ GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(6373), // Rule ID 26 //
     /* 6367 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 6370 */   // Combiner Rule #24: insert_vector_elt_oob; wip_match_opcode 'G_INSERT_VECTOR_ELT'
     /* 6370 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner10),
     /* 6373 */ // Label 428: @6373
     /* 6373 */ GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(6384), // Rule ID 67 //
     /* 6378 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule65Enabled),
     /* 6381 */   // Combiner Rule #65: combine_insert_vec_elts_build_vector; wip_match_opcode 'G_INSERT_VECTOR_ELT'
     /* 6381 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner27),
     /* 6384 */ // Label 429: @6384
     /* 6384 */ GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(6395), // Rule ID 101 //
     /* 6389 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule82Enabled),
     /* 6392 */   // Combiner Rule #82: insert_extract_vec_elt_out_of_bounds; wip_match_opcode 'G_INSERT_VECTOR_ELT'
     /* 6392 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner43),
     /* 6395 */ // Label 430: @6395
     /* 6395 */ GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(6434), // Rule ID 38 //
     /* 6400 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule36Enabled),
     /* 6403 */   // MIs[0] root
     /* 6403 */   // No operand predicates
     /* 6403 */   // MIs[0] src
     /* 6403 */   // No operand predicates
     /* 6403 */   // MIs[0] elt
     /* 6403 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 6407 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_VECTOR_ELT),
     /* 6411 */   // MIs[1] src
     /* 6411 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 6416 */   // MIs[1] idx
     /* 6416 */   // No operand predicates
     /* 6416 */   // MIs[0] idx
     /* 6416 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 6421 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6426 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6428 */   // Combiner Rule #36: insert_vector_element_extract_vector_element
     /* 6428 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6433 */   GIR_EraseRootFromParent_Done,
     /* 6434 */ // Label 431: @6434
     /* 6434 */ GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(6467), // Rule ID 24 //
     /* 6439 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule22Enabled),
     /* 6442 */   // MIs[0] root
     /* 6442 */   // No operand predicates
     /* 6442 */   // MIs[0] src
     /* 6442 */   // No operand predicates
     /* 6442 */   // MIs[0] elt
     /* 6442 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 6446 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 6450 */   // MIs[0] idx
     /* 6450 */   // No operand predicates
     /* 6450 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner0),
     /* 6454 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6459 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6461 */   // Combiner Rule #22: insert_vector_element_elt_undef
     /* 6461 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6466 */   GIR_EraseRootFromParent_Done,
     /* 6467 */ // Label 432: @6467
     /* 6467 */ GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(6491), // Rule ID 23 //
     /* 6472 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule21Enabled),
     /* 6475 */   // MIs[0] root
     /* 6475 */   // No operand predicates
     /* 6475 */   // MIs[0] src
     /* 6475 */   // No operand predicates
     /* 6475 */   // MIs[0] elt
     /* 6475 */   // No operand predicates
     /* 6475 */   // MIs[0] idx
     /* 6475 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
     /* 6479 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 6483 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6485 */   // Combiner Rule #21: insert_vector_element_idx_undef
     /* 6485 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 6488 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 6490 */   GIR_EraseRootFromParent_Done,
     /* 6491 */ // Label 433: @6491
     /* 6491 */ GIM_Reject,
     /* 6492 */ // Label 91: @6492
     /* 6492 */ GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(6503), // Rule ID 25 //
     /* 6497 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule23Enabled),
     /* 6500 */   // Combiner Rule #23: match_extract_of_element; wip_match_opcode 'G_EXTRACT_VECTOR_ELT'
     /* 6500 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner9),
     /* 6503 */ // Label 434: @6503
     /* 6503 */ GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(6514), // Rule ID 68 //
     /* 6508 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule66Enabled),
     /* 6511 */   // Combiner Rule #66: extract_vec_elt_build_vec; wip_match_opcode 'G_EXTRACT_VECTOR_ELT'
     /* 6511 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner28),
     /* 6514 */ // Label 435: @6514
     /* 6514 */ GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(6525), // Rule ID 74 //
     /* 6519 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule70Enabled),
     /* 6522 */   // Combiner Rule #70: combine_extracted_vector_load; wip_match_opcode 'G_EXTRACT_VECTOR_ELT'
     /* 6522 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner32),
     /* 6525 */ // Label 436: @6525
     /* 6525 */ GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(6536), // Rule ID 102 //
     /* 6530 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule82Enabled),
     /* 6533 */   // Combiner Rule #82: insert_extract_vec_elt_out_of_bounds; wip_match_opcode 'G_EXTRACT_VECTOR_ELT'
     /* 6533 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner43),
     /* 6536 */ // Label 437: @6536
     /* 6536 */ GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(6560), // Rule ID 36 //
     /* 6541 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule34Enabled),
     /* 6544 */   // MIs[0] root
     /* 6544 */   // No operand predicates
     /* 6544 */   // MIs[0] src
     /* 6544 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6548 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 6552 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/9,
     /* 6555 */   // MIs[1] x
     /* 6555 */   // No operand predicates
     /* 6555 */   // MIs[1] y
     /* 6555 */   // No operand predicates
     /* 6555 */   // MIs[1] z
     /* 6555 */   // No operand predicates
     /* 6555 */   // MIs[1] a
     /* 6555 */   // No operand predicates
     /* 6555 */   // MIs[1] b
     /* 6555 */   // No operand predicates
     /* 6555 */   // MIs[1] c
     /* 6555 */   // No operand predicates
     /* 6555 */   // MIs[1] d
     /* 6555 */   // No operand predicates
     /* 6555 */   // MIs[1] e
     /* 6555 */   // No operand predicates
     /* 6555 */   // MIs[0] idx
     /* 6555 */   // No operand predicates
     /* 6555 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6557 */   // Combiner Rule #34: extract_vector_element_build_vector_trunc8
     /* 6557 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 6560 */ // Label 438: @6560
     /* 6560 */ GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(6584), // Rule ID 35 //
     /* 6565 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule33Enabled),
     /* 6568 */   // MIs[0] root
     /* 6568 */   // No operand predicates
     /* 6568 */   // MIs[0] src
     /* 6568 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6572 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 6576 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/8,
     /* 6579 */   // MIs[1] x
     /* 6579 */   // No operand predicates
     /* 6579 */   // MIs[1] y
     /* 6579 */   // No operand predicates
     /* 6579 */   // MIs[1] z
     /* 6579 */   // No operand predicates
     /* 6579 */   // MIs[1] a
     /* 6579 */   // No operand predicates
     /* 6579 */   // MIs[1] b
     /* 6579 */   // No operand predicates
     /* 6579 */   // MIs[1] c
     /* 6579 */   // No operand predicates
     /* 6579 */   // MIs[1] d
     /* 6579 */   // No operand predicates
     /* 6579 */   // MIs[0] idx
     /* 6579 */   // No operand predicates
     /* 6579 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6581 */   // Combiner Rule #33: extract_vector_element_build_vector_trunc7
     /* 6581 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 6584 */ // Label 439: @6584
     /* 6584 */ GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(6608), // Rule ID 34 //
     /* 6589 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule32Enabled),
     /* 6592 */   // MIs[0] root
     /* 6592 */   // No operand predicates
     /* 6592 */   // MIs[0] src
     /* 6592 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6596 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 6600 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/7,
     /* 6603 */   // MIs[1] x
     /* 6603 */   // No operand predicates
     /* 6603 */   // MIs[1] y
     /* 6603 */   // No operand predicates
     /* 6603 */   // MIs[1] z
     /* 6603 */   // No operand predicates
     /* 6603 */   // MIs[1] a
     /* 6603 */   // No operand predicates
     /* 6603 */   // MIs[1] b
     /* 6603 */   // No operand predicates
     /* 6603 */   // MIs[1] c
     /* 6603 */   // No operand predicates
     /* 6603 */   // MIs[0] idx
     /* 6603 */   // No operand predicates
     /* 6603 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6605 */   // Combiner Rule #32: extract_vector_element_build_vector_trunc6
     /* 6605 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 6608 */ // Label 440: @6608
     /* 6608 */ GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(6632), // Rule ID 33 //
     /* 6613 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule31Enabled),
     /* 6616 */   // MIs[0] root
     /* 6616 */   // No operand predicates
     /* 6616 */   // MIs[0] src
     /* 6616 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6620 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 6624 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/6,
     /* 6627 */   // MIs[1] x
     /* 6627 */   // No operand predicates
     /* 6627 */   // MIs[1] y
     /* 6627 */   // No operand predicates
     /* 6627 */   // MIs[1] z
     /* 6627 */   // No operand predicates
     /* 6627 */   // MIs[1] a
     /* 6627 */   // No operand predicates
     /* 6627 */   // MIs[1] b
     /* 6627 */   // No operand predicates
     /* 6627 */   // MIs[0] idx
     /* 6627 */   // No operand predicates
     /* 6627 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6629 */   // Combiner Rule #31: extract_vector_element_build_vector_trunc5
     /* 6629 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 6632 */ // Label 441: @6632
     /* 6632 */ GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(6656), // Rule ID 32 //
     /* 6637 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule30Enabled),
     /* 6640 */   // MIs[0] root
     /* 6640 */   // No operand predicates
     /* 6640 */   // MIs[0] src
     /* 6640 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6644 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 6648 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/5,
     /* 6651 */   // MIs[1] x
     /* 6651 */   // No operand predicates
     /* 6651 */   // MIs[1] y
     /* 6651 */   // No operand predicates
     /* 6651 */   // MIs[1] z
     /* 6651 */   // No operand predicates
     /* 6651 */   // MIs[1] a
     /* 6651 */   // No operand predicates
     /* 6651 */   // MIs[0] idx
     /* 6651 */   // No operand predicates
     /* 6651 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6653 */   // Combiner Rule #30: extract_vector_element_build_vector_trunc4
     /* 6653 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 6656 */ // Label 442: @6656
     /* 6656 */ GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(6680), // Rule ID 31 //
     /* 6661 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule29Enabled),
     /* 6664 */   // MIs[0] root
     /* 6664 */   // No operand predicates
     /* 6664 */   // MIs[0] src
     /* 6664 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6668 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 6672 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /* 6675 */   // MIs[1] x
     /* 6675 */   // No operand predicates
     /* 6675 */   // MIs[1] y
     /* 6675 */   // No operand predicates
     /* 6675 */   // MIs[1] z
     /* 6675 */   // No operand predicates
     /* 6675 */   // MIs[0] idx
     /* 6675 */   // No operand predicates
     /* 6675 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6677 */   // Combiner Rule #29: extract_vector_element_build_vector_trunc3
     /* 6677 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 6680 */ // Label 443: @6680
     /* 6680 */ GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(6714), // Rule ID 27 //
     /* 6685 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule25Enabled),
     /* 6688 */   // MIs[0] root
     /* 6688 */   // No operand predicates
     /* 6688 */   // MIs[0] src
     /* 6688 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6692 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INSERT_VECTOR_ELT),
     /* 6696 */   // MIs[1] x
     /* 6696 */   // No operand predicates
     /* 6696 */   // MIs[1] value
     /* 6696 */   // No operand predicates
     /* 6696 */   // MIs[1] idx
     /* 6696 */   // No operand predicates
     /* 6696 */   // MIs[0] idx
     /* 6696 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/3,
     /* 6701 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/2,
     /* 6706 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6708 */   // Combiner Rule #25: extract_vector_element_not_const
     /* 6708 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/2,
     /* 6713 */   GIR_EraseRootFromParent_Done,
     /* 6714 */ // Label 444: @6714
     /* 6714 */ GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(6735), // Rule ID 28 //
     /* 6719 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule26Enabled),
     /* 6722 */   // MIs[0] root
     /* 6722 */   // No operand predicates
     /* 6722 */   // MIs[0] src
     /* 6722 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6726 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INSERT_VECTOR_ELT),
     /* 6730 */   // MIs[1] x
     /* 6730 */   // No operand predicates
     /* 6730 */   // MIs[1] value
     /* 6730 */   // No operand predicates
     /* 6730 */   // MIs[1] idx2
     /* 6730 */   // No operand predicates
     /* 6730 */   // MIs[0] idx1
     /* 6730 */   // No operand predicates
     /* 6730 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6732 */   // Combiner Rule #26: extract_vector_element_different_indices
     /* 6732 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner11),
     /* 6735 */ // Label 445: @6735
     /* 6735 */ GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(6764), // Rule ID 37 //
     /* 6740 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule35Enabled),
     /* 6743 */   // MIs[0] root
     /* 6743 */   // No operand predicates
     /* 6743 */   // MIs[0] src
     /* 6743 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6747 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHUFFLE_VECTOR),
     /* 6751 */   // MIs[1] src1
     /* 6751 */   // No operand predicates
     /* 6751 */   // MIs[1] src2
     /* 6751 */   // No operand predicates
     /* 6751 */   // MIs[1] mask
     /* 6751 */   // No operand predicates
     /* 6751 */   // MIs[0] idx
     /* 6751 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 6755 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 6759 */   // MIs[2] imm
     /* 6759 */   // No operand predicates
     /* 6759 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 6761 */   // Combiner Rule #35: extract_vector_element_shuffle_vector
     /* 6761 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 6764 */ // Label 446: @6764
     /* 6764 */ GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(6788), // Rule ID 30 //
     /* 6769 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule28Enabled),
     /* 6772 */   // MIs[0] root
     /* 6772 */   // No operand predicates
     /* 6772 */   // MIs[0] src
     /* 6772 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6776 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 6780 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /* 6783 */   // MIs[1] x
     /* 6783 */   // No operand predicates
     /* 6783 */   // MIs[1] y
     /* 6783 */   // No operand predicates
     /* 6783 */   // MIs[0] idx
     /* 6783 */   // No operand predicates
     /* 6783 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6785 */   // Combiner Rule #28: extract_vector_element_build_vector_trunc2
     /* 6785 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 6788 */ // Label 447: @6788
     /* 6788 */ GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(6820), // Rule ID 29 //
     /* 6793 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule27Enabled),
     /* 6796 */   // MIs[0] root
     /* 6796 */   // No operand predicates
     /* 6796 */   // MIs[0] src
     /* 6796 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6800 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
     /* 6804 */   GIM_CheckNumOperandsGE, /*MI*/1, /*Expected*/2,
     /* 6807 */   // MIs[1] unused
     /* 6807 */   // No operand predicates
     /* 6807 */   // MIs[0] idx
     /* 6807 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 6811 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 6815 */   // MIs[2] imm
     /* 6815 */   // No operand predicates
     /* 6815 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 6817 */   // Combiner Rule #27: extract_vector_element_build_vector
     /* 6817 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner12),
     /* 6820 */ // Label 448: @6820
     /* 6820 */ GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(6844), // Rule ID 21 //
     /* 6825 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule19Enabled),
     /* 6828 */   // MIs[0] root
     /* 6828 */   // No operand predicates
     /* 6828 */   // MIs[0] vector
     /* 6828 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6832 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 6836 */   // MIs[0] idx
     /* 6836 */   // No operand predicates
     /* 6836 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6838 */   // Combiner Rule #19: match_extract_of_element_undef_vector
     /* 6838 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 6841 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 6843 */   GIR_EraseRootFromParent_Done,
     /* 6844 */ // Label 449: @6844
     /* 6844 */ GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(6868), // Rule ID 22 //
     /* 6849 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule20Enabled),
     /* 6852 */   // MIs[0] root
     /* 6852 */   // No operand predicates
     /* 6852 */   // MIs[0] vector
     /* 6852 */   // No operand predicates
     /* 6852 */   // MIs[0] idx
     /* 6852 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 6856 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 6860 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6862 */   // Combiner Rule #20: match_extract_of_element_undef_index
     /* 6862 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 6865 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 6867 */   GIR_EraseRootFromParent_Done,
     /* 6868 */ // Label 450: @6868
     /* 6868 */ GIM_Reject,
     /* 6869 */ // Label 92: @6869
     /* 6869 */ GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(6880), // Rule ID 97 //
     /* 6874 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule79Enabled),
     /* 6877 */   // Combiner Rule #79: propagate_undef_all_ops; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 6877 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner40),
     /* 6880 */ // Label 451: @6880
     /* 6880 */ GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(6891), // Rule ID 99 //
     /* 6885 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule80Enabled),
     /* 6888 */   // Combiner Rule #80: propagate_undef_shuffle_mask; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 6888 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner41),
     /* 6891 */ // Label 452: @6891
     /* 6891 */ GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(6902), // Rule ID 345 //
     /* 6896 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule200Enabled),
     /* 6899 */   // Combiner Rule #200: combine_shuffle_concat; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 6899 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner136),
     /* 6902 */ // Label 453: @6902
     /* 6902 */ GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(6913), // Rule ID 347 //
     /* 6907 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule202Enabled),
     /* 6910 */   // Combiner Rule #202: combine_shuffle_disjoint_mask; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 6910 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner138),
     /* 6913 */ // Label 454: @6913
     /* 6913 */ GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(6934), // Rule ID 346 //
     /* 6918 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule201Enabled),
     /* 6921 */   // MIs[0] root
     /* 6921 */   // No operand predicates
     /* 6921 */   // MIs[0] src1
     /* 6921 */   // No operand predicates
     /* 6921 */   // MIs[0] undef
     /* 6921 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 6925 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 6929 */   // MIs[0] mask
     /* 6929 */   // No operand predicates
     /* 6929 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6931 */   // Combiner Rule #201: combine_shuffle_undef_rhs
     /* 6931 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner137),
     /* 6934 */ // Label 455: @6934
     /* 6934 */ GIM_Reject,
     /* 6935 */ // Label 93: @6935
     /* 6935 */ GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(6979), // Rule ID 223 //
     /* 6940 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule160Enabled),
     /* 6943 */   // MIs[0] d
     /* 6943 */   // No operand predicates
     /* 6943 */   // MIs[0] src
     /* 6943 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6947 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 6951 */   // MIs[1] rev
     /* 6951 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /* 6955 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BITREVERSE),
     /* 6959 */   // MIs[2] val
     /* 6959 */   // No operand predicates
     /* 6959 */   // MIs[1] amt
     /* 6959 */   // No operand predicates
     /* 6959 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner9),
     /* 6963 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 6965 */   // Combiner Rule #160: bitreverse_lshr
     /* 6965 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SHL),
     /* 6968 */   GIR_RootToRootCopy, /*OpIdx*/0, // d
     /* 6970 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // val
     /* 6974 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // amt
     /* 6978 */   GIR_EraseRootFromParent_Done,
     /* 6979 */ // Label 456: @6979
     /* 6979 */ GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(7023), // Rule ID 222 //
     /* 6984 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule159Enabled),
     /* 6987 */   // MIs[0] d
     /* 6987 */   // No operand predicates
     /* 6987 */   // MIs[0] src
     /* 6987 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6991 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /* 6995 */   // MIs[1] rev
     /* 6995 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /* 6999 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BITREVERSE),
     /* 7003 */   // MIs[2] val
     /* 7003 */   // No operand predicates
     /* 7003 */   // MIs[1] amt
     /* 7003 */   // No operand predicates
     /* 7003 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner8),
     /* 7007 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 7009 */   // Combiner Rule #159: bitreverse_shl
     /* 7009 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 7012 */   GIR_RootToRootCopy, /*OpIdx*/0, // d
     /* 7014 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // val
     /* 7018 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // amt
     /* 7022 */   GIR_EraseRootFromParent_Done,
     /* 7023 */ // Label 457: @7023
     /* 7023 */ GIM_Reject,
     /* 7024 */ // Label 94: @7024
     /* 7024 */ GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(7045), // Rule ID 178 //
     /* 7029 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule136Enabled),
     /* 7032 */   // MIs[0] dst
     /* 7032 */   // No operand predicates
     /* 7032 */   // MIs[0] src0
     /* 7032 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7036 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
     /* 7040 */   // MIs[1] cst
     /* 7040 */   // No operand predicates
     /* 7040 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7042 */   // Combiner Rule #136: constant_fold_fsqrt
     /* 7042 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner81),
     /* 7045 */ // Label 458: @7045
     /* 7045 */ GIM_Reject,
     /* 7046 */ // Label 95: @7046
     /* 7046 */ GIM_Reject,
     /* 7047 */ }; // Size: 7047 bytes
  return MatchTable0;
}
#undef GIMT_Encode2
#undef GIMT_Encode4
#undef GIMT_Encode8

#endif // ifdef GET_GICOMBINER_IMPL

#ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
AvailableModuleFeatures(computeAvailableModuleFeatures(&STI)),
AvailableFunctionFeatures()
#endif // ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
#ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GICOMBINER_CONSTRUCTOR_INITS

