/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the Mips target                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 44;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(MipsInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(MipsInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static MipsInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static MipsInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testMOPredicate_MO(unsigned PredicateID, const MachineOperand &MO, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s16,
  GILLT_v2s64,
  GILLT_v4s8,
  GILLT_v4s32,
  GILLT_v8s16,
  GILLT_v16s8,
};
const static size_t NumTypeObjects = 9;
const static LLT TypeObjects[] = {
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getFixed(2), 16),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 8),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(16), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasMips2Bit = 7,
  Feature_HasMips3Bit = 17,
  Feature_HasMips4_32Bit = 27,
  Feature_NotMips4_32Bit = 28,
  Feature_HasMips4_32r2Bit = 18,
  Feature_HasMips32Bit = 3,
  Feature_HasMips32r2Bit = 6,
  Feature_HasMips32r6Bit = 29,
  Feature_NotMips32r6Bit = 4,
  Feature_IsGP64bitBit = 22,
  Feature_IsPTR64bitBit = 24,
  Feature_HasMips64Bit = 25,
  Feature_HasMips64r2Bit = 23,
  Feature_HasMips64r6Bit = 30,
  Feature_NotMips64r6Bit = 5,
  Feature_InMips16ModeBit = 31,
  Feature_NotInMips16ModeBit = 0,
  Feature_HasCnMipsBit = 26,
  Feature_NotCnMipsBit = 8,
  Feature_IsSym32Bit = 38,
  Feature_IsSym64Bit = 39,
  Feature_IsN64Bit = 40,
  Feature_RelocNotPICBit = 9,
  Feature_RelocPICBit = 37,
  Feature_NoNaNsFPMathBit = 21,
  Feature_UseAbsBit = 14,
  Feature_HasStdEncBit = 1,
  Feature_NotDSPBit = 11,
  Feature_InMicroMipsBit = 35,
  Feature_NotInMicroMipsBit = 2,
  Feature_IsLEBit = 42,
  Feature_IsBEBit = 43,
  Feature_IsNotNaClBit = 19,
  Feature_HasEVABit = 36,
  Feature_HasMSABit = 34,
  Feature_HasMadd4Bit = 20,
  Feature_UseIndirectJumpsHazardBit = 12,
  Feature_NoIndirectJumpGuardsBit = 10,
  Feature_AllowFPOpFusionBit = 41,
  Feature_IsFP64bitBit = 16,
  Feature_NotFP64bitBit = 15,
  Feature_IsNotSoftFloatBit = 13,
  Feature_HasDSPBit = 32,
  Feature_HasDSPR2Bit = 33,
};

PredicateBitset MipsInstructionSelector::
computeAvailableModuleFeatures(const MipsSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (Subtarget->hasMips2())
    Features.set(Feature_HasMips2Bit);
  if (Subtarget->hasMips3())
    Features.set(Feature_HasMips3Bit);
  if (Subtarget->hasMips4_32())
    Features.set(Feature_HasMips4_32Bit);
  if (!Subtarget->hasMips4_32())
    Features.set(Feature_NotMips4_32Bit);
  if (Subtarget->hasMips4_32r2())
    Features.set(Feature_HasMips4_32r2Bit);
  if (Subtarget->hasMips32())
    Features.set(Feature_HasMips32Bit);
  if (Subtarget->hasMips32r2())
    Features.set(Feature_HasMips32r2Bit);
  if (Subtarget->hasMips32r6())
    Features.set(Feature_HasMips32r6Bit);
  if (!Subtarget->hasMips32r6())
    Features.set(Feature_NotMips32r6Bit);
  if (Subtarget->isGP64bit())
    Features.set(Feature_IsGP64bitBit);
  if (Subtarget->isABI_N64())
    Features.set(Feature_IsPTR64bitBit);
  if (Subtarget->hasMips64())
    Features.set(Feature_HasMips64Bit);
  if (Subtarget->hasMips64r2())
    Features.set(Feature_HasMips64r2Bit);
  if (Subtarget->hasMips64r6())
    Features.set(Feature_HasMips64r6Bit);
  if (!Subtarget->hasMips64r6())
    Features.set(Feature_NotMips64r6Bit);
  if (Subtarget->inMips16Mode())
    Features.set(Feature_InMips16ModeBit);
  if (!Subtarget->inMips16Mode())
    Features.set(Feature_NotInMips16ModeBit);
  if (Subtarget->hasCnMips())
    Features.set(Feature_HasCnMipsBit);
  if (!Subtarget->hasCnMips())
    Features.set(Feature_NotCnMipsBit);
  if (Subtarget->hasSym32())
    Features.set(Feature_IsSym32Bit);
  if (!Subtarget->hasSym32())
    Features.set(Feature_IsSym64Bit);
  if (Subtarget->isABI_N64())
    Features.set(Feature_IsN64Bit);
  if (!TM.isPositionIndependent())
    Features.set(Feature_RelocNotPICBit);
  if (TM.isPositionIndependent())
    Features.set(Feature_RelocPICBit);
  if (TM.Options.NoNaNsFPMath)
    Features.set(Feature_NoNaNsFPMathBit);
  if (Subtarget->inAbs2008Mode() ||TM.Options.NoNaNsFPMath)
    Features.set(Feature_UseAbsBit);
  if (Subtarget->hasStandardEncoding())
    Features.set(Feature_HasStdEncBit);
  if (!Subtarget->hasDSP())
    Features.set(Feature_NotDSPBit);
  if (Subtarget->inMicroMipsMode())
    Features.set(Feature_InMicroMipsBit);
  if (!Subtarget->inMicroMipsMode())
    Features.set(Feature_NotInMicroMipsBit);
  if (Subtarget->isLittle())
    Features.set(Feature_IsLEBit);
  if (!Subtarget->isLittle())
    Features.set(Feature_IsBEBit);
  if (!Subtarget->isTargetNaCl())
    Features.set(Feature_IsNotNaClBit);
  if (Subtarget->hasEVA())
    Features.set(Feature_HasEVABit);
  if (Subtarget->hasMSA())
    Features.set(Feature_HasMSABit);
  if (!Subtarget->disableMadd4())
    Features.set(Feature_HasMadd4Bit);
  if (Subtarget->useIndirectJumpsHazard())
    Features.set(Feature_UseIndirectJumpsHazardBit);
  if (!Subtarget->useIndirectJumpsHazard())
    Features.set(Feature_NoIndirectJumpGuardsBit);
  if (TM.Options.AllowFPOpFusion == FPOpFusion::Fast)
    Features.set(Feature_AllowFPOpFusionBit);
  if (Subtarget->isFP64bit())
    Features.set(Feature_IsFP64bitBit);
  if (!Subtarget->isFP64bit())
    Features.set(Feature_NotFP64bitBit);
  if (!Subtarget->useSoftFloat())
    Features.set(Feature_IsNotSoftFloatBit);
  if (Subtarget->hasDSP())
    Features.set(Feature_HasDSPBit);
  if (Subtarget->hasDSPR2())
    Features.set(Feature_HasDSPR2Bit);
  return Features;
}

void MipsInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const MipsSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset MipsInstructionSelector::
computeAvailableFunctionFeatures(const MipsSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasCnMips,
  GIFBS_HasDSP,
  GIFBS_HasDSPR2,
  GIFBS_HasMSA,
  GIFBS_InMicroMips,
  GIFBS_InMips16Mode,
  GIFBS_IsFP64bit,
  GIFBS_NotFP64bit,
  GIFBS_NotInMips16Mode,
  GIFBS_HasDSP_InMicroMips,
  GIFBS_HasDSP_NotInMicroMips,
  GIFBS_HasDSPR2_InMicroMips,
  GIFBS_HasMSA_HasStdEnc,
  GIFBS_HasMSA_IsBE,
  GIFBS_HasMSA_IsLE,
  GIFBS_HasMips32r6_HasStdEnc,
  GIFBS_HasMips32r6_InMicroMips,
  GIFBS_HasMips64r2_HasStdEnc,
  GIFBS_HasMips64r6_HasStdEnc,
  GIFBS_HasStdEnc_IsNotSoftFloat,
  GIFBS_HasStdEnc_NotInMicroMips,
  GIFBS_HasStdEnc_NotMips4_32,
  GIFBS_InMicroMips_IsFP64bit,
  GIFBS_InMicroMips_IsNotSoftFloat,
  GIFBS_InMicroMips_NotFP64bit,
  GIFBS_InMicroMips_NotMips32r6,
  GIFBS_IsGP64bit_NotInMips16Mode,
  GIFBS_AllowFPOpFusion_HasMSA_HasStdEnc,
  GIFBS_HasMSA_HasMips64_HasStdEnc,
  GIFBS_HasMips3_HasStdEnc_IsGP64bit,
  GIFBS_HasMips3_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips32r2_HasStdEnc_IsGP64bit,
  GIFBS_HasMips32r2_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat,
  GIFBS_HasMips64r2_HasStdEnc_NotInMicroMips,
  GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips,
  GIFBS_HasStdEnc_IsFP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_IsFP64bit_NotMips4_32,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasStdEnc_NotFP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_NotFP64bit_NotMips4_32,
  GIFBS_HasStdEnc_NotInMicroMips_RelocNotPIC,
  GIFBS_InMicroMips_IsFP64bit_IsNotSoftFloat,
  GIFBS_InMicroMips_IsNotSoftFloat_NotFP64bit,
  GIFBS_InMicroMips_IsNotSoftFloat_UseAbs,
  GIFBS_InMicroMips_NotFP64bit_NotMips32r6,
  GIFBS_InMicroMips_NotMips32r6_RelocNotPIC,
  GIFBS_InMicroMips_NotMips32r6_RelocPIC,
  GIFBS_IsFP64bit_IsNotSoftFloat_NotInMips16Mode,
  GIFBS_IsNotSoftFloat_NotFP64bit_NotInMips16Mode,
  GIFBS_HasMadd4_InMicroMips_NoNaNsFPMath_NotMips32r6,
  GIFBS_HasMips2_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips3_HasStdEnc_IsGP64bit_NotInMicroMips,
  GIFBS_HasMips3_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips32_HasStdEnc_NotMips32r6_NotMips64r6,
  GIFBS_HasMips32r6_HasStdEnc_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips4_32_HasStdEnc_NotMips32r6_NotMips64r6,
  GIFBS_HasMips64r2_HasStdEnc_IsGP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips_UseAbs,
  GIFBS_HasMadd4_InMicroMips_NoNaNsFPMath_NotFP64bit_NotMips32r6,
  GIFBS_HasMips2_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips,
  GIFBS_HasMips2_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips,
  GIFBS_HasMips32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips4_32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips64_HasStdEnc_IsGP64bit_NotInMicroMips_NotMips64r6,
  GIFBS_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips_UseAbs,
  GIFBS_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips_UseAbs,
  GIFBS_HasMips4_32_HasStdEnc_IsFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips4_32_HasStdEnc_IsGP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMips4_32_HasStdEnc_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsNotSoftFloat_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_NoNaNsFPMath_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsFP64bit_IsNotSoftFloat_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsFP64bit_NoNaNsFPMath_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_IsNotSoftFloat_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
  GIFBS_HasMadd4_HasMips4_32r2_HasStdEnc_NoNaNsFPMath_NotFP64bit_NotInMicroMips_NotMips32r6_NotMips64r6,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasCnMipsBit, },
  {Feature_HasDSPBit, },
  {Feature_HasDSPR2Bit, },
  {Feature_HasMSABit, },
  {Feature_InMicroMipsBit, },
  {Feature_InMips16ModeBit, },
  {Feature_IsFP64bitBit, },
  {Feature_NotFP64bitBit, },
  {Feature_NotInMips16ModeBit, },
  {Feature_HasDSPBit, Feature_InMicroMipsBit, },
  {Feature_HasDSPBit, Feature_NotInMicroMipsBit, },
  {Feature_HasDSPR2Bit, Feature_InMicroMipsBit, },
  {Feature_HasMSABit, Feature_HasStdEncBit, },
  {Feature_HasMSABit, Feature_IsBEBit, },
  {Feature_HasMSABit, Feature_IsLEBit, },
  {Feature_HasMips32r6Bit, Feature_HasStdEncBit, },
  {Feature_HasMips32r6Bit, Feature_InMicroMipsBit, },
  {Feature_HasMips64r2Bit, Feature_HasStdEncBit, },
  {Feature_HasMips64r6Bit, Feature_HasStdEncBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, },
  {Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_NotMips4_32Bit, },
  {Feature_InMicroMipsBit, Feature_IsFP64bitBit, },
  {Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, },
  {Feature_InMicroMipsBit, Feature_NotFP64bitBit, },
  {Feature_InMicroMipsBit, Feature_NotMips32r6Bit, },
  {Feature_IsGP64bitBit, Feature_NotInMips16ModeBit, },
  {Feature_AllowFPOpFusionBit, Feature_HasMSABit, Feature_HasStdEncBit, },
  {Feature_HasMSABit, Feature_HasMips64Bit, Feature_HasStdEncBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r2Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, },
  {Feature_HasMips32r2Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r6Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32r6Bit, Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, },
  {Feature_HasMips64r2Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips64r6Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NotMips4_32Bit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_NotFP64bitBit, Feature_NotMips4_32Bit, },
  {Feature_HasStdEncBit, Feature_NotInMicroMipsBit, Feature_RelocNotPICBit, },
  {Feature_InMicroMipsBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, },
  {Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, },
  {Feature_InMicroMipsBit, Feature_IsNotSoftFloatBit, Feature_UseAbsBit, },
  {Feature_InMicroMipsBit, Feature_NotFP64bitBit, Feature_NotMips32r6Bit, },
  {Feature_InMicroMipsBit, Feature_NotMips32r6Bit, Feature_RelocNotPICBit, },
  {Feature_InMicroMipsBit, Feature_NotMips32r6Bit, Feature_RelocPICBit, },
  {Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMips16ModeBit, },
  {Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMips16ModeBit, },
  {Feature_HasMadd4Bit, Feature_InMicroMipsBit, Feature_NoNaNsFPMathBit, Feature_NotMips32r6Bit, },
  {Feature_HasMips2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips3Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32Bit, Feature_HasStdEncBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips32r6Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips64r2Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_UseAbsBit, },
  {Feature_HasMadd4Bit, Feature_InMicroMipsBit, Feature_NoNaNsFPMathBit, Feature_NotFP64bitBit, Feature_NotMips32r6Bit, },
  {Feature_HasMips2Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, },
  {Feature_HasMips32Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips64Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips64r6Bit, },
  {Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_UseAbsBit, },
  {Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_UseAbsBit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_IsGP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMips4_32Bit, Feature_HasStdEncBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_NoNaNsFPMathBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_IsNotSoftFloatBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsFP64bitBit, Feature_NoNaNsFPMathBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_IsNotSoftFloatBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
  {Feature_HasMadd4Bit, Feature_HasMips4_32r2Bit, Feature_HasStdEncBit, Feature_NoNaNsFPMathBit, Feature_NotFP64bitBit, Feature_NotInMicroMipsBit, Feature_NotMips32r6Bit, Feature_NotMips64r6Bit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

MipsInstructionSelector::ComplexMatcherMemFn
MipsInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_or_disjoint = GICXXPred_Invalid + 1,
};
bool MipsInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_or_disjoint: {
    
        return MI.getFlag(MachineInstr::Disjoint);
      
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool MipsInstructionSelector::testMOPredicate_MO(unsigned PredicateID, const MachineOperand & MO, const MatcherState &State) const {
  const auto &Operands = State.RecordedOperands;
  Register Reg = MO.getReg();
  (void)Operands;
  (void)Reg;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_immLi16 = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_immSExt6,
  GICXXPred_I64_Predicate_immSExt10,
  GICXXPred_I64_Predicate_immSExtAddiur2,
  GICXXPred_I64_Predicate_immSExtAddius5,
  GICXXPred_I64_Predicate_immZExt1,
  GICXXPred_I64_Predicate_immZExt1Ptr,
  GICXXPred_I64_Predicate_immZExt2,
  GICXXPred_I64_Predicate_immZExt2Lsa,
  GICXXPred_I64_Predicate_immZExt2Ptr,
  GICXXPred_I64_Predicate_immZExt2Shift,
  GICXXPred_I64_Predicate_immZExt3,
  GICXXPred_I64_Predicate_immZExt3Ptr,
  GICXXPred_I64_Predicate_immZExt4,
  GICXXPred_I64_Predicate_immZExt4Ptr,
  GICXXPred_I64_Predicate_immZExt5,
  GICXXPred_I64_Predicate_immZExt5_64,
  GICXXPred_I64_Predicate_immZExt6,
  GICXXPred_I64_Predicate_immZExt8,
  GICXXPred_I64_Predicate_immZExt10,
  GICXXPred_I64_Predicate_immZExtAndi16,
  GICXXPred_I64_Predicate_immi32Cst7,
  GICXXPred_I64_Predicate_immi32Cst15,
  GICXXPred_I64_Predicate_immi32Cst31,
  GICXXPred_I64_Predicate_timmSExt6,
  GICXXPred_I64_Predicate_timmZExt1,
  GICXXPred_I64_Predicate_timmZExt1Ptr,
  GICXXPred_I64_Predicate_timmZExt2,
  GICXXPred_I64_Predicate_timmZExt2Ptr,
  GICXXPred_I64_Predicate_timmZExt3,
  GICXXPred_I64_Predicate_timmZExt3Ptr,
  GICXXPred_I64_Predicate_timmZExt4,
  GICXXPred_I64_Predicate_timmZExt4Ptr,
  GICXXPred_I64_Predicate_timmZExt5,
  GICXXPred_I64_Predicate_timmZExt6,
  GICXXPred_I64_Predicate_timmZExt8,
  GICXXPred_I64_Predicate_timmZExt10,
};
bool MipsInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_immLi16: {
    return Imm >= -1 && Imm <= 126;
  }
  case GICXXPred_I64_Predicate_immSExt6: {
    return isInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_immSExt10: {
    return isInt<10>(Imm);
  }
  case GICXXPred_I64_Predicate_immSExtAddiur2: {
    return Imm == 1 || Imm == -1 ||
                                               ((Imm % 4 == 0) &&
                                                Imm < 28 && Imm > 0);
  }
  case GICXXPred_I64_Predicate_immSExtAddius5: {
    return Imm >= -8 && Imm <= 7;
  }
  case GICXXPred_I64_Predicate_immZExt1: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt1Ptr: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt2Lsa: {
    return isUInt<2>(Imm - 1);
  }
  case GICXXPred_I64_Predicate_immZExt2Ptr: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt2Shift: {
    return Imm >= 1 && Imm <= 8;
  }
  case GICXXPred_I64_Predicate_immZExt3: {
    return isUInt<3>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt3Ptr: {
    return isUInt<3>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt4: {
    return isUInt<4>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt4Ptr: {
    return isUInt<4>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt5: {
    return Imm == (Imm & 0x1f);
  }
  case GICXXPred_I64_Predicate_immZExt5_64: {
     return Imm == (Imm & 0x1f); 
  }
  case GICXXPred_I64_Predicate_immZExt6: {
    return Imm == (Imm & 0x3f);
  }
  case GICXXPred_I64_Predicate_immZExt8: {
    return isUInt<8>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExt10: {
    return isUInt<10>(Imm);
  }
  case GICXXPred_I64_Predicate_immZExtAndi16: {
    return (Imm == 128 || (Imm >= 1 && Imm <= 4) || Imm == 7 || Imm == 8 ||
                Imm == 15 || Imm == 16 || Imm == 31 || Imm == 32 || Imm == 63 ||
                Imm == 64 || Imm == 255 || Imm == 32768 || Imm == 65535 );
  }
  case GICXXPred_I64_Predicate_immi32Cst7: {
    return isUInt<32>(Imm) && Imm == 7;
  }
  case GICXXPred_I64_Predicate_immi32Cst15: {
    return isUInt<32>(Imm) && Imm == 15;
  }
  case GICXXPred_I64_Predicate_immi32Cst31: {
    return isUInt<32>(Imm) && Imm == 31;
  }
  case GICXXPred_I64_Predicate_timmSExt6: {
    return isInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt1: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt1Ptr: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt2Ptr: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt3: {
    return isUInt<3>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt3Ptr: {
    return isUInt<3>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt4: {
    return isUInt<4>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt4Ptr: {
    return isUInt<4>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt5: {
    return Imm == (Imm & 0x1f);
  }
  case GICXXPred_I64_Predicate_timmZExt6: {
    return Imm == (Imm & 0x3f);
  }
  case GICXXPred_I64_Predicate_timmZExt8: {
    return isUInt<8>(Imm);
  }
  case GICXXPred_I64_Predicate_timmZExt10: {
    return isUInt<10>(Imm);
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool MipsInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_imm32SExt16 = GICXXPred_Invalid + 1,
  GICXXPred_APInt_Predicate_imm32ZExt16,
};
bool MipsInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_imm32SExt16: {
     return isInt<16>(Imm.getSExtValue()); 
  }
  case GICXXPred_APInt_Predicate_imm32ZExt16: {
    
      return (uint32_t)Imm.getZExtValue() == (unsigned short)Imm.getZExtValue();
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool MipsInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("MipsInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
};
MipsInstructionSelector::CustomRendererFn
MipsInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool MipsInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool MipsInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("MipsInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *MipsInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
     /*     0 */ GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(53), GIMT_Encode2(293), /*)*//*default:*//*Label 79*/ GIMT_Encode4(69793),
     /*    10 */ /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(970),
     /*    14 */ /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(2268),
     /*    18 */ /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(2959),
     /*    22 */ /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(3440),
     /*    26 */ /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(3709),
     /*    30 */ /*TargetOpcode::G_SREM*//*Label 5*/ GIMT_Encode4(3978),
     /*    34 */ /*TargetOpcode::G_UREM*//*Label 6*/ GIMT_Encode4(4247), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    46 */ /*TargetOpcode::G_AND*//*Label 7*/ GIMT_Encode4(4516),
     /*    50 */ /*TargetOpcode::G_OR*//*Label 8*/ GIMT_Encode4(5072),
     /*    54 */ /*TargetOpcode::G_XOR*//*Label 9*/ GIMT_Encode4(5476), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   102 */ /*TargetOpcode::G_MERGE_VALUES*//*Label 10*/ GIMT_Encode4(6368),
     /*   106 */ /*TargetOpcode::G_BUILD_VECTOR*//*Label 11*/ GIMT_Encode4(6441), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   126 */ /*TargetOpcode::G_BITCAST*//*Label 12*/ GIMT_Encode4(6782), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   170 */ /*TargetOpcode::G_LOAD*//*Label 13*/ GIMT_Encode4(11093),
     /*   174 */ /*TargetOpcode::G_SEXTLOAD*//*Label 14*/ GIMT_Encode4(11158),
     /*   178 */ /*TargetOpcode::G_ZEXTLOAD*//*Label 15*/ GIMT_Encode4(11226), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   206 */ /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 16*/ GIMT_Encode4(11294),
     /*   210 */ /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 17*/ GIMT_Encode4(11486),
     /*   214 */ /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 18*/ GIMT_Encode4(11656),
     /*   218 */ /*TargetOpcode::G_ATOMICRMW_SUB*//*Label 19*/ GIMT_Encode4(11826),
     /*   222 */ /*TargetOpcode::G_ATOMICRMW_AND*//*Label 20*/ GIMT_Encode4(11996),
     /*   226 */ /*TargetOpcode::G_ATOMICRMW_NAND*//*Label 21*/ GIMT_Encode4(12166),
     /*   230 */ /*TargetOpcode::G_ATOMICRMW_OR*//*Label 22*/ GIMT_Encode4(12336),
     /*   234 */ /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 23*/ GIMT_Encode4(12506),
     /*   238 */ /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 24*/ GIMT_Encode4(12676),
     /*   242 */ /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 25*/ GIMT_Encode4(12846),
     /*   246 */ /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 26*/ GIMT_Encode4(13016),
     /*   250 */ /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 27*/ GIMT_Encode4(13186), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   302 */ /*TargetOpcode::G_BRCOND*//*Label 28*/ GIMT_Encode4(13356), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   314 */ /*TargetOpcode::G_INTRINSIC*//*Label 29*/ GIMT_Encode4(18077),
     /*   318 */ /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 30*/ GIMT_Encode4(32342), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   330 */ /*TargetOpcode::G_ANYEXT*//*Label 31*/ GIMT_Encode4(37436),
     /*   334 */ /*TargetOpcode::G_TRUNC*//*Label 32*/ GIMT_Encode4(37502), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   350 */ /*TargetOpcode::G_CONSTANT*//*Label 33*/ GIMT_Encode4(37566), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   366 */ /*TargetOpcode::G_SEXT*//*Label 34*/ GIMT_Encode4(37627),
     /*   370 */ /*TargetOpcode::G_SEXT_INREG*//*Label 35*/ GIMT_Encode4(39091),
     /*   374 */ /*TargetOpcode::G_ZEXT*//*Label 36*/ GIMT_Encode4(39439),
     /*   378 */ /*TargetOpcode::G_SHL*//*Label 37*/ GIMT_Encode4(39640),
     /*   382 */ /*TargetOpcode::G_LSHR*//*Label 38*/ GIMT_Encode4(41437),
     /*   386 */ /*TargetOpcode::G_ASHR*//*Label 39*/ GIMT_Encode4(43234), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   398 */ /*TargetOpcode::G_ROTR*//*Label 40*/ GIMT_Encode4(44989), GIMT_Encode4(0),
     /*   406 */ /*TargetOpcode::G_ICMP*//*Label 41*/ GIMT_Encode4(45277),
     /*   410 */ /*TargetOpcode::G_FCMP*//*Label 42*/ GIMT_Encode4(47808), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   422 */ /*TargetOpcode::G_SELECT*//*Label 43*/ GIMT_Encode4(49514), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   466 */ /*TargetOpcode::G_UMULH*//*Label 44*/ GIMT_Encode4(61552),
     /*   470 */ /*TargetOpcode::G_SMULH*//*Label 45*/ GIMT_Encode4(61661), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   530 */ /*TargetOpcode::G_FADD*//*Label 46*/ GIMT_Encode4(61770),
     /*   534 */ /*TargetOpcode::G_FSUB*//*Label 47*/ GIMT_Encode4(62683),
     /*   538 */ /*TargetOpcode::G_FMUL*//*Label 48*/ GIMT_Encode4(63295),
     /*   542 */ /*TargetOpcode::G_FMA*//*Label 49*/ GIMT_Encode4(63782), GIMT_Encode4(0),
     /*   550 */ /*TargetOpcode::G_FDIV*//*Label 50*/ GIMT_Encode4(63888), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   570 */ /*TargetOpcode::G_FEXP2*//*Label 51*/ GIMT_Encode4(64187), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   582 */ /*TargetOpcode::G_FLOG2*//*Label 52*/ GIMT_Encode4(64265), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   598 */ /*TargetOpcode::G_FNEG*//*Label 53*/ GIMT_Encode4(64343),
     /*   602 */ /*TargetOpcode::G_FPEXT*//*Label 54*/ GIMT_Encode4(65712),
     /*   606 */ /*TargetOpcode::G_FPTRUNC*//*Label 55*/ GIMT_Encode4(65890),
     /*   610 */ /*TargetOpcode::G_FPTOSI*//*Label 56*/ GIMT_Encode4(66053),
     /*   614 */ /*TargetOpcode::G_FPTOUI*//*Label 57*/ GIMT_Encode4(66131),
     /*   618 */ /*TargetOpcode::G_SITOFP*//*Label 58*/ GIMT_Encode4(66209),
     /*   622 */ /*TargetOpcode::G_UITOFP*//*Label 59*/ GIMT_Encode4(66462), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   634 */ /*TargetOpcode::G_FABS*//*Label 60*/ GIMT_Encode4(66540), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   646 */ /*TargetOpcode::G_FCANONICALIZE*//*Label 61*/ GIMT_Encode4(66780),
     /*   650 */ /*TargetOpcode::G_FMINNUM*//*Label 62*/ GIMT_Encode4(66854),
     /*   654 */ /*TargetOpcode::G_FMAXNUM*//*Label 63*/ GIMT_Encode4(66926),
     /*   658 */ /*TargetOpcode::G_FMINNUM_IEEE*//*Label 64*/ GIMT_Encode4(66998),
     /*   662 */ /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 65*/ GIMT_Encode4(67070), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   718 */ /*TargetOpcode::G_SMIN*//*Label 66*/ GIMT_Encode4(67142),
     /*   722 */ /*TargetOpcode::G_SMAX*//*Label 67*/ GIMT_Encode4(67310),
     /*   726 */ /*TargetOpcode::G_UMIN*//*Label 68*/ GIMT_Encode4(67478),
     /*   730 */ /*TargetOpcode::G_UMAX*//*Label 69*/ GIMT_Encode4(67646), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   746 */ /*TargetOpcode::G_BR*//*Label 70*/ GIMT_Encode4(67814), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   766 */ /*TargetOpcode::G_INSERT_VECTOR_ELT*//*Label 71*/ GIMT_Encode4(67938),
     /*   770 */ /*TargetOpcode::G_EXTRACT_VECTOR_ELT*//*Label 72*/ GIMT_Encode4(68502), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   798 */ /*TargetOpcode::G_CTLZ*//*Label 73*/ GIMT_Encode4(68554), GIMT_Encode4(0),
     /*   806 */ /*TargetOpcode::G_CTPOP*//*Label 74*/ GIMT_Encode4(69059),
     /*   810 */ /*TargetOpcode::G_BSWAP*//*Label 75*/ GIMT_Encode4(69265), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   866 */ /*TargetOpcode::G_FSQRT*//*Label 76*/ GIMT_Encode4(69429), GIMT_Encode4(0),
     /*   874 */ /*TargetOpcode::G_FRINT*//*Label 77*/ GIMT_Encode4(69669), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   966 */ /*TargetOpcode::G_TRAP*//*Label 78*/ GIMT_Encode4(69747),
     /*   970 */ // Label 0: @970
     /*   970 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 88*/ GIMT_Encode4(2267),
     /*   981 */ /*GILLT_s32*//*Label 80*/ GIMT_Encode4(1013),
     /*   985 */ /*GILLT_s64*//*Label 81*/ GIMT_Encode4(1421),
     /*   989 */ /*GILLT_v2s16*//*Label 82*/ GIMT_Encode4(1587),
     /*   993 */ /*GILLT_v2s64*//*Label 83*/ GIMT_Encode4(1619),
     /*   997 */ /*GILLT_v4s8*//*Label 84*/ GIMT_Encode4(1773),
     /*  1001 */ /*GILLT_v4s32*//*Label 85*/ GIMT_Encode4(1805),
     /*  1005 */ /*GILLT_v8s16*//*Label 86*/ GIMT_Encode4(1959),
     /*  1009 */ /*GILLT_v16s8*//*Label 87*/ GIMT_Encode4(2113),
     /*  1013 */ // Label 80: @1013
     /*  1013 */ GIM_Try, /*On fail goto*//*Label 89*/ GIMT_Encode4(1420),
     /*  1018 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  1021 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  1024 */   GIM_Try, /*On fail goto*//*Label 90*/ GIMT_Encode4(1091), // Rule ID 2400 //
     /*  1029 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  1032 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  1036 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  1040 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  1044 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  1048 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  1052 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  1057 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  1061 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  1065 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2Lsa),
     /*  1069 */     // MIs[2] Operand 1
     /*  1069 */     // No operand predicates
     /*  1069 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  1073 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  1075 */     // (add:{ *:[i32] } (shl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa), GPR32Opnd:{ *:[i32] }:$rt)  =>  (LSA:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$sa)
     /*  1075 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LSA),
     /*  1078 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*  1080 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
     /*  1084 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /*  1086 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
     /*  1089 */     GIR_RootConstrainSelectedInstOperands,
     /*  1090 */     // GIR_Coverage, 2400,
     /*  1090 */     GIR_EraseRootFromParent_Done,
     /*  1091 */   // Label 90: @1091
     /*  1091 */   GIM_Try, /*On fail goto*//*Label 91*/ GIMT_Encode4(1158), // Rule ID 834 //
     /*  1096 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  1099 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  1103 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  1107 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  1111 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  1115 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  1119 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  1123 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  1128 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  1132 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  1136 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2Lsa),
     /*  1140 */     // MIs[2] Operand 1
     /*  1140 */     // No operand predicates
     /*  1140 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  1142 */     // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (shl:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa))  =>  (LSA:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$sa)
     /*  1142 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LSA),
     /*  1145 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*  1147 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
     /*  1151 */     GIR_RootToRootCopy, /*OpIdx*/1, // rt
     /*  1153 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
     /*  1156 */     GIR_RootConstrainSelectedInstOperands,
     /*  1157 */     // GIR_Coverage, 834,
     /*  1157 */     GIR_EraseRootFromParent_Done,
     /*  1158 */   // Label 91: @1158
     /*  1158 */   GIM_Try, /*On fail goto*//*Label 92*/ GIMT_Encode4(1200), // Rule ID 40 //
     /*  1163 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /*  1166 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  1170 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  1174 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  1178 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  1182 */     GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_imm32SExt16),
     /*  1186 */     // MIs[1] Operand 1
     /*  1186 */     // No operand predicates
     /*  1186 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  1188 */     // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$imm16)  =>  (ADDiu:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$imm16)
     /*  1188 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDiu),
     /*  1191 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /*  1193 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs
     /*  1195 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm16
     /*  1198 */     GIR_RootConstrainSelectedInstOperands,
     /*  1199 */     // GIR_Coverage, 40,
     /*  1199 */     GIR_EraseRootFromParent_Done,
     /*  1200 */   // Label 92: @1200
     /*  1200 */   GIM_Try, /*On fail goto*//*Label 93*/ GIMT_Encode4(1242), // Rule ID 2169 //
     /*  1205 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
     /*  1208 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  1212 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  1216 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  1220 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  1224 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immSExtAddiur2),
     /*  1228 */     // MIs[1] Operand 1
     /*  1228 */     // No operand predicates
     /*  1228 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  1230 */     // (add:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddiur2>>:$imm)  =>  (ADDIUR2_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddiur2>>:$imm)
     /*  1230 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDIUR2_MM),
     /*  1233 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*  1235 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  1237 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*  1240 */     GIR_RootConstrainSelectedInstOperands,
     /*  1241 */     // GIR_Coverage, 2169,
     /*  1241 */     GIR_EraseRootFromParent_Done,
     /*  1242 */   // Label 93: @1242
     /*  1242 */   GIM_Try, /*On fail goto*//*Label 94*/ GIMT_Encode4(1284), // Rule ID 2170 //
     /*  1247 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
     /*  1250 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  1254 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  1258 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  1262 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  1266 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immSExtAddius5),
     /*  1270 */     // MIs[1] Operand 1
     /*  1270 */     // No operand predicates
     /*  1270 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  1272 */     // (add:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddius5>>:$imm)  =>  (ADDIUS5_MM:{ *:[i32] } GPR32:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immSExtAddius5>>:$imm)
     /*  1272 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDIUS5_MM),
     /*  1275 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  1277 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  1279 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*  1282 */     GIR_RootConstrainSelectedInstOperands,
     /*  1283 */     // GIR_Coverage, 2170,
     /*  1283 */     GIR_EraseRootFromParent_Done,
     /*  1284 */   // Label 94: @1284
     /*  1284 */   GIM_Try, /*On fail goto*//*Label 95*/ GIMT_Encode4(1311), // Rule ID 1208 //
     /*  1289 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /*  1292 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  1296 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  1300 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  1304 */     // (add:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (ADDU16_MMR6:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
     /*  1304 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDU16_MMR6),
     /*  1309 */     GIR_RootConstrainSelectedInstOperands,
     /*  1310 */     // GIR_Coverage, 1208,
     /*  1310 */     GIR_Done,
     /*  1311 */   // Label 95: @1311
     /*  1311 */   GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(1338), // Rule ID 46 //
     /*  1316 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /*  1319 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  1323 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  1327 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  1331 */     // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDu:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  1331 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDu),
     /*  1336 */     GIR_RootConstrainSelectedInstOperands,
     /*  1337 */     // GIR_Coverage, 46,
     /*  1337 */     GIR_Done,
     /*  1338 */   // Label 96: @1338
     /*  1338 */   GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(1365), // Rule ID 1060 //
     /*  1343 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /*  1346 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  1350 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  1354 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  1358 */     // (add:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (ADDU16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
     /*  1358 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDU16_MM),
     /*  1363 */     GIR_RootConstrainSelectedInstOperands,
     /*  1364 */     // GIR_Coverage, 1060,
     /*  1364 */     GIR_Done,
     /*  1365 */   // Label 97: @1365
     /*  1365 */   GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(1392), // Rule ID 1072 //
     /*  1370 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /*  1373 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  1377 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  1381 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  1385 */     // (add:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDu_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  1385 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDu_MM),
     /*  1390 */     GIR_RootConstrainSelectedInstOperands,
     /*  1391 */     // GIR_Coverage, 1072,
     /*  1391 */     GIR_Done,
     /*  1392 */   // Label 98: @1392
     /*  1392 */   GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(1419), // Rule ID 1827 //
     /*  1397 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
     /*  1400 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  1404 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  1408 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  1412 */     // (add:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (AdduRxRyRz16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
     /*  1412 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AdduRxRyRz16),
     /*  1417 */     GIR_RootConstrainSelectedInstOperands,
     /*  1418 */     // GIR_Coverage, 1827,
     /*  1418 */     GIR_Done,
     /*  1419 */   // Label 99: @1419
     /*  1419 */   GIM_Reject,
     /*  1420 */ // Label 89: @1420
     /*  1420 */ GIM_Reject,
     /*  1421 */ // Label 81: @1421
     /*  1421 */ GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(1586),
     /*  1426 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  1429 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  1432 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  1436 */   GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(1499), // Rule ID 2401 //
     /*  1441 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasMips64_HasStdEnc),
     /*  1444 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  1448 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  1452 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  1456 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  1460 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  1465 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  1469 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  1473 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2Lsa),
     /*  1477 */     // MIs[2] Operand 1
     /*  1477 */     // No operand predicates
     /*  1477 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  1481 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  1483 */     // (add:{ *:[i64] } (shl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa), GPR64Opnd:{ *:[i64] }:$rt)  =>  (DLSA:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$sa)
     /*  1483 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DLSA),
     /*  1486 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*  1488 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
     /*  1492 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /*  1494 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
     /*  1497 */     GIR_RootConstrainSelectedInstOperands,
     /*  1498 */     // GIR_Coverage, 2401,
     /*  1498 */     GIR_EraseRootFromParent_Done,
     /*  1499 */   // Label 101: @1499
     /*  1499 */   GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(1562), // Rule ID 835 //
     /*  1504 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasMips64_HasStdEnc),
     /*  1507 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  1511 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  1515 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  1519 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  1523 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  1527 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  1532 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  1536 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  1540 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2Lsa),
     /*  1544 */     // MIs[2] Operand 1
     /*  1544 */     // No operand predicates
     /*  1544 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  1546 */     // (add:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rt, (shl:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2Lsa>>:$sa))  =>  (DLSA:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, (imm:{ *:[i32] }):$sa)
     /*  1546 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DLSA),
     /*  1549 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*  1551 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
     /*  1555 */     GIR_RootToRootCopy, /*OpIdx*/1, // rt
     /*  1557 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sa
     /*  1560 */     GIR_RootConstrainSelectedInstOperands,
     /*  1561 */     // GIR_Coverage, 835,
     /*  1561 */     GIR_EraseRootFromParent_Done,
     /*  1562 */   // Label 102: @1562
     /*  1562 */   GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(1585), // Rule ID 202 //
     /*  1567 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_NotInMicroMips),
     /*  1570 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  1574 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  1578 */     // (add:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DADDu:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
     /*  1578 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DADDu),
     /*  1583 */     GIR_RootConstrainSelectedInstOperands,
     /*  1584 */     // GIR_Coverage, 202,
     /*  1584 */     GIR_Done,
     /*  1585 */   // Label 103: @1585
     /*  1585 */   GIM_Reject,
     /*  1586 */ // Label 100: @1586
     /*  1586 */ GIM_Reject,
     /*  1587 */ // Label 82: @1587
     /*  1587 */ GIM_Try, /*On fail goto*//*Label 104*/ GIMT_Encode4(1618), // Rule ID 1926 //
     /*  1592 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /*  1595 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  1598 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  1601 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /*  1605 */   // (add:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (ADDQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
     /*  1605 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDQ_PH),
     /*  1610 */   GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::DSPOutFlag20), GIMT_Encode2(RegState::Dead),
     /*  1616 */   GIR_RootConstrainSelectedInstOperands,
     /*  1617 */   // GIR_Coverage, 1926,
     /*  1617 */   GIR_Done,
     /*  1618 */ // Label 104: @1618
     /*  1618 */ GIM_Reject,
     /*  1619 */ // Label 83: @1619
     /*  1619 */ GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(1772),
     /*  1624 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  1627 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  1630 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  1634 */   GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(1691), // Rule ID 2405 //
     /*  1639 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  1642 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  1646 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  1650 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  1654 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  1658 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  1663 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  1668 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  1672 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  1674 */     // (add:{ *:[v2i64] } (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt), MSA128DOpnd:{ *:[v2i64] }:$wd_in)  =>  (MADDV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /*  1674 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_D),
     /*  1677 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /*  1679 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /*  1681 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
     /*  1685 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
     /*  1689 */     GIR_RootConstrainSelectedInstOperands,
     /*  1690 */     // GIR_Coverage, 2405,
     /*  1690 */     GIR_EraseRootFromParent_Done,
     /*  1691 */   // Label 106: @1691
     /*  1691 */   GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(1748), // Rule ID 843 //
     /*  1696 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  1699 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  1703 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  1707 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  1711 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  1715 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  1719 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  1724 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  1729 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  1731 */     // (add:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt))  =>  (MADDV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /*  1731 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_D),
     /*  1734 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /*  1736 */     GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
     /*  1738 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
     /*  1742 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
     /*  1746 */     GIR_RootConstrainSelectedInstOperands,
     /*  1747 */     // GIR_Coverage, 843,
     /*  1747 */     GIR_EraseRootFromParent_Done,
     /*  1748 */   // Label 107: @1748
     /*  1748 */   GIM_Try, /*On fail goto*//*Label 108*/ GIMT_Encode4(1771), // Rule ID 510 //
     /*  1753 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  1756 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  1760 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  1764 */     // (add:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /*  1764 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDV_D),
     /*  1769 */     GIR_RootConstrainSelectedInstOperands,
     /*  1770 */     // GIR_Coverage, 510,
     /*  1770 */     GIR_Done,
     /*  1771 */   // Label 108: @1771
     /*  1771 */   GIM_Reject,
     /*  1772 */ // Label 105: @1772
     /*  1772 */ GIM_Reject,
     /*  1773 */ // Label 84: @1773
     /*  1773 */ GIM_Try, /*On fail goto*//*Label 109*/ GIMT_Encode4(1804), // Rule ID 1932 //
     /*  1778 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /*  1781 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
     /*  1784 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /*  1787 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /*  1791 */   // (add:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (ADDU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
     /*  1791 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDU_QB),
     /*  1796 */   GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::DSPOutFlag20), GIMT_Encode2(RegState::Dead),
     /*  1802 */   GIR_RootConstrainSelectedInstOperands,
     /*  1803 */   // GIR_Coverage, 1932,
     /*  1803 */   GIR_Done,
     /*  1804 */ // Label 109: @1804
     /*  1804 */ GIM_Reject,
     /*  1805 */ // Label 85: @1805
     /*  1805 */ GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(1958),
     /*  1810 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  1813 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  1816 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  1820 */   GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(1877), // Rule ID 2404 //
     /*  1825 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  1828 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  1832 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  1836 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  1840 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  1844 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  1849 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  1854 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  1858 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  1860 */     // (add:{ *:[v4i32] } (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt), MSA128WOpnd:{ *:[v4i32] }:$wd_in)  =>  (MADDV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /*  1860 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_W),
     /*  1863 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /*  1865 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /*  1867 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
     /*  1871 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
     /*  1875 */     GIR_RootConstrainSelectedInstOperands,
     /*  1876 */     // GIR_Coverage, 2404,
     /*  1876 */     GIR_EraseRootFromParent_Done,
     /*  1877 */   // Label 111: @1877
     /*  1877 */   GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(1934), // Rule ID 842 //
     /*  1882 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  1885 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  1889 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  1893 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  1897 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  1901 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  1905 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  1910 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  1915 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  1917 */     // (add:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt))  =>  (MADDV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /*  1917 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_W),
     /*  1920 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /*  1922 */     GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
     /*  1924 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
     /*  1928 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
     /*  1932 */     GIR_RootConstrainSelectedInstOperands,
     /*  1933 */     // GIR_Coverage, 842,
     /*  1933 */     GIR_EraseRootFromParent_Done,
     /*  1934 */   // Label 112: @1934
     /*  1934 */   GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(1957), // Rule ID 509 //
     /*  1939 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  1942 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  1946 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  1950 */     // (add:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /*  1950 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDV_W),
     /*  1955 */     GIR_RootConstrainSelectedInstOperands,
     /*  1956 */     // GIR_Coverage, 509,
     /*  1956 */     GIR_Done,
     /*  1957 */   // Label 113: @1957
     /*  1957 */   GIM_Reject,
     /*  1958 */ // Label 110: @1958
     /*  1958 */ GIM_Reject,
     /*  1959 */ // Label 86: @1959
     /*  1959 */ GIM_Try, /*On fail goto*//*Label 114*/ GIMT_Encode4(2112),
     /*  1964 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  1967 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  1970 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  1974 */   GIM_Try, /*On fail goto*//*Label 115*/ GIMT_Encode4(2031), // Rule ID 2403 //
     /*  1979 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  1982 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  1986 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  1990 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  1994 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  1998 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  2003 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  2008 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  2012 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  2014 */     // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt), MSA128HOpnd:{ *:[v8i16] }:$wd_in)  =>  (MADDV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /*  2014 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_H),
     /*  2017 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /*  2019 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /*  2021 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
     /*  2025 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
     /*  2029 */     GIR_RootConstrainSelectedInstOperands,
     /*  2030 */     // GIR_Coverage, 2403,
     /*  2030 */     GIR_EraseRootFromParent_Done,
     /*  2031 */   // Label 115: @2031
     /*  2031 */   GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(2088), // Rule ID 841 //
     /*  2036 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  2039 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  2043 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  2047 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  2051 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  2055 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  2059 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  2064 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  2069 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  2071 */     // (add:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt))  =>  (MADDV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /*  2071 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_H),
     /*  2074 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /*  2076 */     GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
     /*  2078 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
     /*  2082 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
     /*  2086 */     GIR_RootConstrainSelectedInstOperands,
     /*  2087 */     // GIR_Coverage, 841,
     /*  2087 */     GIR_EraseRootFromParent_Done,
     /*  2088 */   // Label 116: @2088
     /*  2088 */   GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(2111), // Rule ID 508 //
     /*  2093 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  2096 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  2100 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  2104 */     // (add:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /*  2104 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDV_H),
     /*  2109 */     GIR_RootConstrainSelectedInstOperands,
     /*  2110 */     // GIR_Coverage, 508,
     /*  2110 */     GIR_Done,
     /*  2111 */   // Label 117: @2111
     /*  2111 */   GIM_Reject,
     /*  2112 */ // Label 114: @2112
     /*  2112 */ GIM_Reject,
     /*  2113 */ // Label 87: @2113
     /*  2113 */ GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(2266),
     /*  2118 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  2121 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  2124 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  2128 */   GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(2185), // Rule ID 2402 //
     /*  2133 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  2136 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  2140 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  2144 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  2148 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  2152 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  2157 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  2162 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  2166 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  2168 */     // (add:{ *:[v16i8] } (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt), MSA128BOpnd:{ *:[v16i8] }:$wd_in)  =>  (MADDV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /*  2168 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_B),
     /*  2171 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /*  2173 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /*  2175 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
     /*  2179 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
     /*  2183 */     GIR_RootConstrainSelectedInstOperands,
     /*  2184 */     // GIR_Coverage, 2402,
     /*  2184 */     GIR_EraseRootFromParent_Done,
     /*  2185 */   // Label 119: @2185
     /*  2185 */   GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(2242), // Rule ID 840 //
     /*  2190 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  2193 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  2197 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  2201 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  2205 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  2209 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  2213 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  2218 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  2223 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  2225 */     // (add:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt))  =>  (MADDV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /*  2225 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDV_B),
     /*  2228 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /*  2230 */     GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
     /*  2232 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
     /*  2236 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
     /*  2240 */     GIR_RootConstrainSelectedInstOperands,
     /*  2241 */     // GIR_Coverage, 840,
     /*  2241 */     GIR_EraseRootFromParent_Done,
     /*  2242 */   // Label 120: @2242
     /*  2242 */   GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(2265), // Rule ID 507 //
     /*  2247 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  2250 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  2254 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  2258 */     // (add:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /*  2258 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ADDV_B),
     /*  2263 */     GIR_RootConstrainSelectedInstOperands,
     /*  2264 */     // GIR_Coverage, 507,
     /*  2264 */     GIR_Done,
     /*  2265 */   // Label 121: @2265
     /*  2265 */   GIM_Reject,
     /*  2266 */ // Label 118: @2266
     /*  2266 */ GIM_Reject,
     /*  2267 */ // Label 88: @2267
     /*  2267 */ GIM_Reject,
     /*  2268 */ // Label 1: @2268
     /*  2268 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 130*/ GIMT_Encode4(2958),
     /*  2279 */ /*GILLT_s32*//*Label 122*/ GIMT_Encode4(2311),
     /*  2283 */ /*GILLT_s64*//*Label 123*/ GIMT_Encode4(2488),
     /*  2287 */ /*GILLT_v2s16*//*Label 124*/ GIMT_Encode4(2522),
     /*  2291 */ /*GILLT_v2s64*//*Label 125*/ GIMT_Encode4(2554),
     /*  2295 */ /*GILLT_v4s8*//*Label 126*/ GIMT_Encode4(2647),
     /*  2299 */ /*GILLT_v4s32*//*Label 127*/ GIMT_Encode4(2679),
     /*  2303 */ /*GILLT_v8s16*//*Label 128*/ GIMT_Encode4(2772),
     /*  2307 */ /*GILLT_v16s8*//*Label 129*/ GIMT_Encode4(2865),
     /*  2311 */ // Label 122: @2311
     /*  2311 */ GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(2487),
     /*  2316 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  2319 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  2322 */   GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(2351), // Rule ID 1826 //
     /*  2327 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
     /*  2330 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  2334 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*  2338 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  2342 */     // (sub:{ *:[i32] } 0:{ *:[i32] }, CPU16Regs:{ *:[i32] }:$r)  =>  (NegRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r)
     /*  2342 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NegRxRy16),
     /*  2345 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rx]
     /*  2347 */     GIR_RootToRootCopy, /*OpIdx*/2, // r
     /*  2349 */     GIR_RootConstrainSelectedInstOperands,
     /*  2350 */     // GIR_Coverage, 1826,
     /*  2350 */     GIR_EraseRootFromParent_Done,
     /*  2351 */   // Label 132: @2351
     /*  2351 */   GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(2378), // Rule ID 1210 //
     /*  2356 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /*  2359 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  2363 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  2367 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  2371 */     // (sub:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (SUBU16_MMR6:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
     /*  2371 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBU16_MMR6),
     /*  2376 */     GIR_RootConstrainSelectedInstOperands,
     /*  2377 */     // GIR_Coverage, 1210,
     /*  2377 */     GIR_Done,
     /*  2378 */   // Label 133: @2378
     /*  2378 */   GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(2405), // Rule ID 47 //
     /*  2383 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /*  2386 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  2390 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  2394 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  2398 */     // (sub:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBu:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  2398 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBu),
     /*  2403 */     GIR_RootConstrainSelectedInstOperands,
     /*  2404 */     // GIR_Coverage, 47,
     /*  2404 */     GIR_Done,
     /*  2405 */   // Label 134: @2405
     /*  2405 */   GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(2432), // Rule ID 1064 //
     /*  2410 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /*  2413 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  2417 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  2421 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  2425 */     // (sub:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (SUBU16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
     /*  2425 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBU16_MM),
     /*  2430 */     GIR_RootConstrainSelectedInstOperands,
     /*  2431 */     // GIR_Coverage, 1064,
     /*  2431 */     GIR_Done,
     /*  2432 */   // Label 135: @2432
     /*  2432 */   GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(2459), // Rule ID 1073 //
     /*  2437 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /*  2440 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  2444 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  2448 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  2452 */     // (sub:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBu_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  2452 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBu_MM),
     /*  2457 */     GIR_RootConstrainSelectedInstOperands,
     /*  2458 */     // GIR_Coverage, 1073,
     /*  2458 */     GIR_Done,
     /*  2459 */   // Label 136: @2459
     /*  2459 */   GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(2486), // Rule ID 1831 //
     /*  2464 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
     /*  2467 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  2471 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  2475 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  2479 */     // (sub:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (SubuRxRyRz16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
     /*  2479 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SubuRxRyRz16),
     /*  2484 */     GIR_RootConstrainSelectedInstOperands,
     /*  2485 */     // GIR_Coverage, 1831,
     /*  2485 */     GIR_Done,
     /*  2486 */   // Label 137: @2486
     /*  2486 */   GIM_Reject,
     /*  2487 */ // Label 131: @2487
     /*  2487 */ GIM_Reject,
     /*  2488 */ // Label 123: @2488
     /*  2488 */ GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(2521), // Rule ID 203 //
     /*  2493 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_NotInMicroMips),
     /*  2496 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  2499 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  2502 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  2506 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  2510 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  2514 */   // (sub:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DSUBu:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
     /*  2514 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DSUBu),
     /*  2519 */   GIR_RootConstrainSelectedInstOperands,
     /*  2520 */   // GIR_Coverage, 203,
     /*  2520 */   GIR_Done,
     /*  2521 */ // Label 138: @2521
     /*  2521 */ GIM_Reject,
     /*  2522 */ // Label 124: @2522
     /*  2522 */ GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(2553), // Rule ID 1928 //
     /*  2527 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /*  2530 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  2533 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  2536 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /*  2540 */   // (sub:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (SUBQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
     /*  2540 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBQ_PH),
     /*  2545 */   GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::DSPOutFlag20), GIMT_Encode2(RegState::Dead),
     /*  2551 */   GIR_RootConstrainSelectedInstOperands,
     /*  2552 */   // GIR_Coverage, 1928,
     /*  2552 */   GIR_Done,
     /*  2553 */ // Label 139: @2553
     /*  2553 */ GIM_Reject,
     /*  2554 */ // Label 125: @2554
     /*  2554 */ GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(2646),
     /*  2559 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  2562 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  2565 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  2569 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  2573 */   GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(2626), // Rule ID 899 //
     /*  2578 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  2581 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  2585 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  2589 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  2593 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  2597 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  2602 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  2607 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  2609 */     // (sub:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt))  =>  (MSUBV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /*  2609 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUBV_D),
     /*  2612 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /*  2614 */     GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
     /*  2616 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
     /*  2620 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
     /*  2624 */     GIR_RootConstrainSelectedInstOperands,
     /*  2625 */     // GIR_Coverage, 899,
     /*  2625 */     GIR_EraseRootFromParent_Done,
     /*  2626 */   // Label 141: @2626
     /*  2626 */   GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(2645), // Rule ID 1028 //
     /*  2631 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  2634 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  2638 */     // (sub:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /*  2638 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBV_D),
     /*  2643 */     GIR_RootConstrainSelectedInstOperands,
     /*  2644 */     // GIR_Coverage, 1028,
     /*  2644 */     GIR_Done,
     /*  2645 */   // Label 142: @2645
     /*  2645 */   GIM_Reject,
     /*  2646 */ // Label 140: @2646
     /*  2646 */ GIM_Reject,
     /*  2647 */ // Label 126: @2647
     /*  2647 */ GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(2678), // Rule ID 1934 //
     /*  2652 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /*  2655 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
     /*  2658 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /*  2661 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /*  2665 */   // (sub:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (SUBU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
     /*  2665 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBU_QB),
     /*  2670 */   GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::DSPOutFlag20), GIMT_Encode2(RegState::Dead),
     /*  2676 */   GIR_RootConstrainSelectedInstOperands,
     /*  2677 */   // GIR_Coverage, 1934,
     /*  2677 */   GIR_Done,
     /*  2678 */ // Label 143: @2678
     /*  2678 */ GIM_Reject,
     /*  2679 */ // Label 127: @2679
     /*  2679 */ GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(2771),
     /*  2684 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  2687 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  2690 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  2694 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  2698 */   GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(2751), // Rule ID 898 //
     /*  2703 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  2706 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  2710 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  2714 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  2718 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  2722 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  2727 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  2732 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  2734 */     // (sub:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt))  =>  (MSUBV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /*  2734 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUBV_W),
     /*  2737 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /*  2739 */     GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
     /*  2741 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
     /*  2745 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
     /*  2749 */     GIR_RootConstrainSelectedInstOperands,
     /*  2750 */     // GIR_Coverage, 898,
     /*  2750 */     GIR_EraseRootFromParent_Done,
     /*  2751 */   // Label 145: @2751
     /*  2751 */   GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(2770), // Rule ID 1027 //
     /*  2756 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  2759 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  2763 */     // (sub:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /*  2763 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBV_W),
     /*  2768 */     GIR_RootConstrainSelectedInstOperands,
     /*  2769 */     // GIR_Coverage, 1027,
     /*  2769 */     GIR_Done,
     /*  2770 */   // Label 146: @2770
     /*  2770 */   GIM_Reject,
     /*  2771 */ // Label 144: @2771
     /*  2771 */ GIM_Reject,
     /*  2772 */ // Label 128: @2772
     /*  2772 */ GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(2864),
     /*  2777 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  2780 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  2783 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  2787 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  2791 */   GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(2844), // Rule ID 897 //
     /*  2796 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  2799 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  2803 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  2807 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  2811 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  2815 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  2820 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  2825 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  2827 */     // (sub:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt))  =>  (MSUBV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /*  2827 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUBV_H),
     /*  2830 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /*  2832 */     GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
     /*  2834 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
     /*  2838 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
     /*  2842 */     GIR_RootConstrainSelectedInstOperands,
     /*  2843 */     // GIR_Coverage, 897,
     /*  2843 */     GIR_EraseRootFromParent_Done,
     /*  2844 */   // Label 148: @2844
     /*  2844 */   GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(2863), // Rule ID 1026 //
     /*  2849 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  2852 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  2856 */     // (sub:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /*  2856 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBV_H),
     /*  2861 */     GIR_RootConstrainSelectedInstOperands,
     /*  2862 */     // GIR_Coverage, 1026,
     /*  2862 */     GIR_Done,
     /*  2863 */   // Label 149: @2863
     /*  2863 */   GIM_Reject,
     /*  2864 */ // Label 147: @2864
     /*  2864 */ GIM_Reject,
     /*  2865 */ // Label 129: @2865
     /*  2865 */ GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(2957),
     /*  2870 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  2873 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  2876 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  2880 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  2884 */   GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(2937), // Rule ID 896 //
     /*  2889 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  2892 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  2896 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  2900 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  2904 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  2908 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  2913 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  2918 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  2920 */     // (sub:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt))  =>  (MSUBV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /*  2920 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUBV_B),
     /*  2923 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /*  2925 */     GIR_RootToRootCopy, /*OpIdx*/1, // wd_in
     /*  2927 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // ws
     /*  2931 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // wt
     /*  2935 */     GIR_RootConstrainSelectedInstOperands,
     /*  2936 */     // GIR_Coverage, 896,
     /*  2936 */     GIR_EraseRootFromParent_Done,
     /*  2937 */   // Label 151: @2937
     /*  2937 */   GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(2956), // Rule ID 1025 //
     /*  2942 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  2945 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  2949 */     // (sub:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /*  2949 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::SUBV_B),
     /*  2954 */     GIR_RootConstrainSelectedInstOperands,
     /*  2955 */     // GIR_Coverage, 1025,
     /*  2955 */     GIR_Done,
     /*  2956 */   // Label 152: @2956
     /*  2956 */   GIM_Reject,
     /*  2957 */ // Label 150: @2957
     /*  2957 */ GIM_Reject,
     /*  2958 */ // Label 130: @2958
     /*  2958 */ GIM_Reject,
     /*  2959 */ // Label 2: @2959
     /*  2959 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 160*/ GIMT_Encode4(3439),
     /*  2970 */ /*GILLT_s32*//*Label 153*/ GIMT_Encode4(3002),
     /*  2974 */ /*GILLT_s64*//*Label 154*/ GIMT_Encode4(3186),
     /*  2978 */ /*GILLT_v2s16*//*Label 155*/ GIMT_Encode4(3271),
     /*  2982 */ /*GILLT_v2s64*//*Label 156*/ GIMT_Encode4(3303), GIMT_Encode4(0),
     /*  2990 */ /*GILLT_v4s32*//*Label 157*/ GIMT_Encode4(3337),
     /*  2994 */ /*GILLT_v8s16*//*Label 158*/ GIMT_Encode4(3371),
     /*  2998 */ /*GILLT_v16s8*//*Label 159*/ GIMT_Encode4(3405),
     /*  3002 */ // Label 153: @3002
     /*  3002 */ GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(3185),
     /*  3007 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  3010 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  3013 */   GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(3052), // Rule ID 48 //
     /*  3018 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32_HasStdEnc_NotInMicroMips_NotMips32r6_NotMips64r6),
     /*  3021 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  3025 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  3029 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  3033 */     // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL:{ *:[i32] }:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  3033 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL),
     /*  3038 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::HI0), GIMT_Encode2(RegState::Dead),
     /*  3044 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::LO0), GIMT_Encode2(RegState::Dead),
     /*  3050 */     GIR_RootConstrainSelectedInstOperands,
     /*  3051 */     // GIR_Coverage, 48,
     /*  3051 */     GIR_Done,
     /*  3052 */   // Label 162: @3052
     /*  3052 */   GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(3079), // Rule ID 332 //
     /*  3057 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips),
     /*  3060 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  3064 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  3068 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  3072 */     // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL_R6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  3072 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_R6),
     /*  3077 */     GIR_RootConstrainSelectedInstOperands,
     /*  3078 */     // GIR_Coverage, 332,
     /*  3078 */     GIR_Done,
     /*  3079 */   // Label 163: @3079
     /*  3079 */   GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(3118), // Rule ID 1074 //
     /*  3084 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /*  3087 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  3091 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  3095 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  3099 */     // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL_MM:{ *:[i32] }:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  3099 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_MM),
     /*  3104 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::HI0), GIMT_Encode2(RegState::Dead),
     /*  3110 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::LO0), GIMT_Encode2(RegState::Dead),
     /*  3116 */     GIR_RootConstrainSelectedInstOperands,
     /*  3117 */     // GIR_Coverage, 1074,
     /*  3117 */     GIR_Done,
     /*  3118 */   // Label 164: @3118
     /*  3118 */   GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(3145), // Rule ID 1179 //
     /*  3123 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /*  3126 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  3130 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  3134 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  3138 */     // (mul:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MUL_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  3138 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_MMR6),
     /*  3143 */     GIR_RootConstrainSelectedInstOperands,
     /*  3144 */     // GIR_Coverage, 1179,
     /*  3144 */     GIR_Done,
     /*  3145 */   // Label 165: @3145
     /*  3145 */   GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(3184), // Rule ID 1829 //
     /*  3150 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
     /*  3153 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  3157 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  3161 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  3165 */     // (mul:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (MultRxRyRz16:{ *:[i32] }:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
     /*  3165 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MultRxRyRz16),
     /*  3170 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::HI0), GIMT_Encode2(RegState::Dead),
     /*  3176 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::LO0), GIMT_Encode2(RegState::Dead),
     /*  3182 */     GIR_RootConstrainSelectedInstOperands,
     /*  3183 */     // GIR_Coverage, 1829,
     /*  3183 */     GIR_Done,
     /*  3184 */   // Label 166: @3184
     /*  3184 */   GIM_Reject,
     /*  3185 */ // Label 161: @3185
     /*  3185 */ GIM_Reject,
     /*  3186 */ // Label 154: @3186
     /*  3186 */ GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(3270),
     /*  3191 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  3194 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  3197 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  3201 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  3205 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  3209 */   GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(3254), // Rule ID 274 //
     /*  3214 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
     /*  3217 */     // (mul:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMUL:{ *:[i64] }:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
     /*  3217 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMUL),
     /*  3222 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::HI0), GIMT_Encode2(RegState::Dead),
     /*  3228 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::LO0), GIMT_Encode2(RegState::Dead),
     /*  3234 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::P0), GIMT_Encode2(RegState::Dead),
     /*  3240 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::P1), GIMT_Encode2(RegState::Dead),
     /*  3246 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::P2), GIMT_Encode2(RegState::Dead),
     /*  3252 */     GIR_RootConstrainSelectedInstOperands,
     /*  3253 */     // GIR_Coverage, 274,
     /*  3253 */     GIR_Done,
     /*  3254 */   // Label 168: @3254
     /*  3254 */   GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(3269), // Rule ID 347 //
     /*  3259 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips),
     /*  3262 */     // (mul:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMUL_R6:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
     /*  3262 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMUL_R6),
     /*  3267 */     GIR_RootConstrainSelectedInstOperands,
     /*  3268 */     // GIR_Coverage, 347,
     /*  3268 */     GIR_Done,
     /*  3269 */   // Label 169: @3269
     /*  3269 */   GIM_Reject,
     /*  3270 */ // Label 167: @3270
     /*  3270 */ GIM_Reject,
     /*  3271 */ // Label 155: @3271
     /*  3271 */ GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(3302), // Rule ID 1930 //
     /*  3276 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /*  3279 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  3282 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  3285 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /*  3289 */   // (mul:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (MUL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
     /*  3289 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MUL_PH),
     /*  3294 */   GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::DSPOutFlag21), GIMT_Encode2(RegState::Dead),
     /*  3300 */   GIR_RootConstrainSelectedInstOperands,
     /*  3301 */   // GIR_Coverage, 1930,
     /*  3301 */   GIR_Done,
     /*  3302 */ // Label 170: @3302
     /*  3302 */ GIM_Reject,
     /*  3303 */ // Label 156: @3303
     /*  3303 */ GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(3336), // Rule ID 907 //
     /*  3308 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  3311 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  3314 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  3317 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  3321 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  3325 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  3329 */   // (mul:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MULV_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /*  3329 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULV_D),
     /*  3334 */   GIR_RootConstrainSelectedInstOperands,
     /*  3335 */   // GIR_Coverage, 907,
     /*  3335 */   GIR_Done,
     /*  3336 */ // Label 171: @3336
     /*  3336 */ GIM_Reject,
     /*  3337 */ // Label 157: @3337
     /*  3337 */ GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(3370), // Rule ID 906 //
     /*  3342 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  3345 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  3348 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  3351 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  3355 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  3359 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  3363 */   // (mul:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MULV_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /*  3363 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULV_W),
     /*  3368 */   GIR_RootConstrainSelectedInstOperands,
     /*  3369 */   // GIR_Coverage, 906,
     /*  3369 */   GIR_Done,
     /*  3370 */ // Label 172: @3370
     /*  3370 */ GIM_Reject,
     /*  3371 */ // Label 158: @3371
     /*  3371 */ GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(3404), // Rule ID 905 //
     /*  3376 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  3379 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  3382 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  3385 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  3389 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  3393 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  3397 */   // (mul:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MULV_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /*  3397 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULV_H),
     /*  3402 */   GIR_RootConstrainSelectedInstOperands,
     /*  3403 */   // GIR_Coverage, 905,
     /*  3403 */   GIR_Done,
     /*  3404 */ // Label 173: @3404
     /*  3404 */ GIM_Reject,
     /*  3405 */ // Label 159: @3405
     /*  3405 */ GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(3438), // Rule ID 904 //
     /*  3410 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  3413 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  3416 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  3419 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  3423 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  3427 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  3431 */   // (mul:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MULV_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /*  3431 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MULV_B),
     /*  3436 */   GIR_RootConstrainSelectedInstOperands,
     /*  3437 */   // GIR_Coverage, 904,
     /*  3437 */   GIR_Done,
     /*  3438 */ // Label 174: @3438
     /*  3438 */ GIM_Reject,
     /*  3439 */ // Label 160: @3439
     /*  3439 */ GIM_Reject,
     /*  3440 */ // Label 3: @3440
     /*  3440 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 181*/ GIMT_Encode4(3708),
     /*  3451 */ /*GILLT_s32*//*Label 175*/ GIMT_Encode4(3483),
     /*  3455 */ /*GILLT_s64*//*Label 176*/ GIMT_Encode4(3538), GIMT_Encode4(0),
     /*  3463 */ /*GILLT_v2s64*//*Label 177*/ GIMT_Encode4(3572), GIMT_Encode4(0),
     /*  3471 */ /*GILLT_v4s32*//*Label 178*/ GIMT_Encode4(3606),
     /*  3475 */ /*GILLT_v8s16*//*Label 179*/ GIMT_Encode4(3640),
     /*  3479 */ /*GILLT_v16s8*//*Label 180*/ GIMT_Encode4(3674),
     /*  3483 */ // Label 175: @3483
     /*  3483 */ GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(3537),
     /*  3488 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  3491 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  3494 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  3498 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  3502 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  3506 */   GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(3521), // Rule ID 326 //
     /*  3511 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips),
     /*  3514 */     // (sdiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  3514 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV),
     /*  3519 */     GIR_RootConstrainSelectedInstOperands,
     /*  3520 */     // GIR_Coverage, 326,
     /*  3520 */     GIR_Done,
     /*  3521 */   // Label 183: @3521
     /*  3521 */   GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(3536), // Rule ID 1172 //
     /*  3526 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /*  3529 */     // (sdiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIV_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  3529 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_MMR6),
     /*  3534 */     GIR_RootConstrainSelectedInstOperands,
     /*  3535 */     // GIR_Coverage, 1172,
     /*  3535 */     GIR_Done,
     /*  3536 */   // Label 184: @3536
     /*  3536 */   GIM_Reject,
     /*  3537 */ // Label 182: @3537
     /*  3537 */ GIM_Reject,
     /*  3538 */ // Label 176: @3538
     /*  3538 */ GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(3571), // Rule ID 341 //
     /*  3543 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips),
     /*  3546 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  3549 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  3552 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  3556 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  3560 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  3564 */   // (sdiv:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DDIV:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
     /*  3564 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DDIV),
     /*  3569 */   GIR_RootConstrainSelectedInstOperands,
     /*  3570 */   // GIR_Coverage, 341,
     /*  3570 */   GIR_Done,
     /*  3571 */ // Label 185: @3571
     /*  3571 */ GIM_Reject,
     /*  3572 */ // Label 177: @3572
     /*  3572 */ GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(3605), // Rule ID 647 //
     /*  3577 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  3580 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  3583 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  3586 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  3590 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  3594 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  3598 */   // (sdiv:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (DIV_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /*  3598 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_S_D),
     /*  3603 */   GIR_RootConstrainSelectedInstOperands,
     /*  3604 */   // GIR_Coverage, 647,
     /*  3604 */   GIR_Done,
     /*  3605 */ // Label 186: @3605
     /*  3605 */ GIM_Reject,
     /*  3606 */ // Label 178: @3606
     /*  3606 */ GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(3639), // Rule ID 646 //
     /*  3611 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  3614 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  3617 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  3620 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  3624 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  3628 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  3632 */   // (sdiv:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DIV_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /*  3632 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_S_W),
     /*  3637 */   GIR_RootConstrainSelectedInstOperands,
     /*  3638 */   // GIR_Coverage, 646,
     /*  3638 */   GIR_Done,
     /*  3639 */ // Label 187: @3639
     /*  3639 */ GIM_Reject,
     /*  3640 */ // Label 179: @3640
     /*  3640 */ GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(3673), // Rule ID 645 //
     /*  3645 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  3648 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  3651 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  3654 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  3658 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  3662 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  3666 */   // (sdiv:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DIV_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /*  3666 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_S_H),
     /*  3671 */   GIR_RootConstrainSelectedInstOperands,
     /*  3672 */   // GIR_Coverage, 645,
     /*  3672 */   GIR_Done,
     /*  3673 */ // Label 188: @3673
     /*  3673 */ GIM_Reject,
     /*  3674 */ // Label 180: @3674
     /*  3674 */ GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(3707), // Rule ID 644 //
     /*  3679 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  3682 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  3685 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  3688 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  3692 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  3696 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  3700 */   // (sdiv:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DIV_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /*  3700 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_S_B),
     /*  3705 */   GIR_RootConstrainSelectedInstOperands,
     /*  3706 */   // GIR_Coverage, 644,
     /*  3706 */   GIR_Done,
     /*  3707 */ // Label 189: @3707
     /*  3707 */ GIM_Reject,
     /*  3708 */ // Label 181: @3708
     /*  3708 */ GIM_Reject,
     /*  3709 */ // Label 4: @3709
     /*  3709 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 196*/ GIMT_Encode4(3977),
     /*  3720 */ /*GILLT_s32*//*Label 190*/ GIMT_Encode4(3752),
     /*  3724 */ /*GILLT_s64*//*Label 191*/ GIMT_Encode4(3807), GIMT_Encode4(0),
     /*  3732 */ /*GILLT_v2s64*//*Label 192*/ GIMT_Encode4(3841), GIMT_Encode4(0),
     /*  3740 */ /*GILLT_v4s32*//*Label 193*/ GIMT_Encode4(3875),
     /*  3744 */ /*GILLT_v8s16*//*Label 194*/ GIMT_Encode4(3909),
     /*  3748 */ /*GILLT_v16s8*//*Label 195*/ GIMT_Encode4(3943),
     /*  3752 */ // Label 190: @3752
     /*  3752 */ GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(3806),
     /*  3757 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  3760 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  3763 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  3767 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  3771 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  3775 */   GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(3790), // Rule ID 327 //
     /*  3780 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips),
     /*  3783 */     // (udiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIVU:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  3783 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIVU),
     /*  3788 */     GIR_RootConstrainSelectedInstOperands,
     /*  3789 */     // GIR_Coverage, 327,
     /*  3789 */     GIR_Done,
     /*  3790 */   // Label 198: @3790
     /*  3790 */   GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(3805), // Rule ID 1173 //
     /*  3795 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /*  3798 */     // (udiv:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (DIVU_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  3798 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIVU_MMR6),
     /*  3803 */     GIR_RootConstrainSelectedInstOperands,
     /*  3804 */     // GIR_Coverage, 1173,
     /*  3804 */     GIR_Done,
     /*  3805 */   // Label 199: @3805
     /*  3805 */   GIM_Reject,
     /*  3806 */ // Label 197: @3806
     /*  3806 */ GIM_Reject,
     /*  3807 */ // Label 191: @3807
     /*  3807 */ GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(3840), // Rule ID 342 //
     /*  3812 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips),
     /*  3815 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  3818 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  3821 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  3825 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  3829 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  3833 */   // (udiv:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DDIVU:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
     /*  3833 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DDIVU),
     /*  3838 */   GIR_RootConstrainSelectedInstOperands,
     /*  3839 */   // GIR_Coverage, 342,
     /*  3839 */   GIR_Done,
     /*  3840 */ // Label 200: @3840
     /*  3840 */ GIM_Reject,
     /*  3841 */ // Label 192: @3841
     /*  3841 */ GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(3874), // Rule ID 651 //
     /*  3846 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  3849 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  3852 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  3855 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  3859 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  3863 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  3867 */   // (udiv:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (DIV_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /*  3867 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_U_D),
     /*  3872 */   GIR_RootConstrainSelectedInstOperands,
     /*  3873 */   // GIR_Coverage, 651,
     /*  3873 */   GIR_Done,
     /*  3874 */ // Label 201: @3874
     /*  3874 */ GIM_Reject,
     /*  3875 */ // Label 193: @3875
     /*  3875 */ GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(3908), // Rule ID 650 //
     /*  3880 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  3883 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  3886 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  3889 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  3893 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  3897 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  3901 */   // (udiv:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DIV_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /*  3901 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_U_W),
     /*  3906 */   GIR_RootConstrainSelectedInstOperands,
     /*  3907 */   // GIR_Coverage, 650,
     /*  3907 */   GIR_Done,
     /*  3908 */ // Label 202: @3908
     /*  3908 */ GIM_Reject,
     /*  3909 */ // Label 194: @3909
     /*  3909 */ GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(3942), // Rule ID 649 //
     /*  3914 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  3917 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  3920 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  3923 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  3927 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  3931 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  3935 */   // (udiv:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DIV_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /*  3935 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_U_H),
     /*  3940 */   GIR_RootConstrainSelectedInstOperands,
     /*  3941 */   // GIR_Coverage, 649,
     /*  3941 */   GIR_Done,
     /*  3942 */ // Label 203: @3942
     /*  3942 */ GIM_Reject,
     /*  3943 */ // Label 195: @3943
     /*  3943 */ GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(3976), // Rule ID 648 //
     /*  3948 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  3951 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  3954 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  3957 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  3961 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  3965 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  3969 */   // (udiv:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DIV_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /*  3969 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DIV_U_B),
     /*  3974 */   GIR_RootConstrainSelectedInstOperands,
     /*  3975 */   // GIR_Coverage, 648,
     /*  3975 */   GIR_Done,
     /*  3976 */ // Label 204: @3976
     /*  3976 */ GIM_Reject,
     /*  3977 */ // Label 196: @3977
     /*  3977 */ GIM_Reject,
     /*  3978 */ // Label 5: @3978
     /*  3978 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 211*/ GIMT_Encode4(4246),
     /*  3989 */ /*GILLT_s32*//*Label 205*/ GIMT_Encode4(4021),
     /*  3993 */ /*GILLT_s64*//*Label 206*/ GIMT_Encode4(4076), GIMT_Encode4(0),
     /*  4001 */ /*GILLT_v2s64*//*Label 207*/ GIMT_Encode4(4110), GIMT_Encode4(0),
     /*  4009 */ /*GILLT_v4s32*//*Label 208*/ GIMT_Encode4(4144),
     /*  4013 */ /*GILLT_v8s16*//*Label 209*/ GIMT_Encode4(4178),
     /*  4017 */ /*GILLT_v16s8*//*Label 210*/ GIMT_Encode4(4212),
     /*  4021 */ // Label 205: @4021
     /*  4021 */ GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(4075),
     /*  4026 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  4029 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  4032 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  4036 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  4040 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  4044 */   GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(4059), // Rule ID 328 //
     /*  4049 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips),
     /*  4052 */     // (srem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MOD:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  4052 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD),
     /*  4057 */     GIR_RootConstrainSelectedInstOperands,
     /*  4058 */     // GIR_Coverage, 328,
     /*  4058 */     GIR_Done,
     /*  4059 */   // Label 213: @4059
     /*  4059 */   GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(4074), // Rule ID 1177 //
     /*  4064 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /*  4067 */     // (srem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MOD_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  4067 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_MMR6),
     /*  4072 */     GIR_RootConstrainSelectedInstOperands,
     /*  4073 */     // GIR_Coverage, 1177,
     /*  4073 */     GIR_Done,
     /*  4074 */   // Label 214: @4074
     /*  4074 */   GIM_Reject,
     /*  4075 */ // Label 212: @4075
     /*  4075 */ GIM_Reject,
     /*  4076 */ // Label 206: @4076
     /*  4076 */ GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(4109), // Rule ID 343 //
     /*  4081 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips),
     /*  4084 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  4087 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  4090 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  4094 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  4098 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  4102 */   // (srem:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMOD:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
     /*  4102 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMOD),
     /*  4107 */   GIR_RootConstrainSelectedInstOperands,
     /*  4108 */   // GIR_Coverage, 343,
     /*  4108 */   GIR_Done,
     /*  4109 */ // Label 215: @4109
     /*  4109 */ GIM_Reject,
     /*  4110 */ // Label 207: @4110
     /*  4110 */ GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(4143), // Rule ID 887 //
     /*  4115 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  4118 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  4121 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  4124 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  4128 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  4132 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  4136 */   // (srem:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MOD_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /*  4136 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_S_D),
     /*  4141 */   GIR_RootConstrainSelectedInstOperands,
     /*  4142 */   // GIR_Coverage, 887,
     /*  4142 */   GIR_Done,
     /*  4143 */ // Label 216: @4143
     /*  4143 */ GIM_Reject,
     /*  4144 */ // Label 208: @4144
     /*  4144 */ GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(4177), // Rule ID 886 //
     /*  4149 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  4152 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  4155 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  4158 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  4162 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  4166 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  4170 */   // (srem:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MOD_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /*  4170 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_S_W),
     /*  4175 */   GIR_RootConstrainSelectedInstOperands,
     /*  4176 */   // GIR_Coverage, 886,
     /*  4176 */   GIR_Done,
     /*  4177 */ // Label 217: @4177
     /*  4177 */ GIM_Reject,
     /*  4178 */ // Label 209: @4178
     /*  4178 */ GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(4211), // Rule ID 885 //
     /*  4183 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  4186 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  4189 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  4192 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  4196 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  4200 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  4204 */   // (srem:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MOD_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /*  4204 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_S_H),
     /*  4209 */   GIR_RootConstrainSelectedInstOperands,
     /*  4210 */   // GIR_Coverage, 885,
     /*  4210 */   GIR_Done,
     /*  4211 */ // Label 218: @4211
     /*  4211 */ GIM_Reject,
     /*  4212 */ // Label 210: @4212
     /*  4212 */ GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(4245), // Rule ID 884 //
     /*  4217 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  4220 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  4223 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  4226 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  4230 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  4234 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  4238 */   // (srem:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MOD_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /*  4238 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_S_B),
     /*  4243 */   GIR_RootConstrainSelectedInstOperands,
     /*  4244 */   // GIR_Coverage, 884,
     /*  4244 */   GIR_Done,
     /*  4245 */ // Label 219: @4245
     /*  4245 */ GIM_Reject,
     /*  4246 */ // Label 211: @4246
     /*  4246 */ GIM_Reject,
     /*  4247 */ // Label 6: @4247
     /*  4247 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 226*/ GIMT_Encode4(4515),
     /*  4258 */ /*GILLT_s32*//*Label 220*/ GIMT_Encode4(4290),
     /*  4262 */ /*GILLT_s64*//*Label 221*/ GIMT_Encode4(4345), GIMT_Encode4(0),
     /*  4270 */ /*GILLT_v2s64*//*Label 222*/ GIMT_Encode4(4379), GIMT_Encode4(0),
     /*  4278 */ /*GILLT_v4s32*//*Label 223*/ GIMT_Encode4(4413),
     /*  4282 */ /*GILLT_v8s16*//*Label 224*/ GIMT_Encode4(4447),
     /*  4286 */ /*GILLT_v16s8*//*Label 225*/ GIMT_Encode4(4481),
     /*  4290 */ // Label 220: @4290
     /*  4290 */ GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(4344),
     /*  4295 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  4298 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  4301 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  4305 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  4309 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  4313 */   GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(4328), // Rule ID 329 //
     /*  4318 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_HasStdEnc_NotInMicroMips),
     /*  4321 */     // (urem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODU:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  4321 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MODU),
     /*  4326 */     GIR_RootConstrainSelectedInstOperands,
     /*  4327 */     // GIR_Coverage, 329,
     /*  4327 */     GIR_Done,
     /*  4328 */   // Label 228: @4328
     /*  4328 */   GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(4343), // Rule ID 1178 //
     /*  4333 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /*  4336 */     // (urem:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODU_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  4336 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MODU_MMR6),
     /*  4341 */     GIR_RootConstrainSelectedInstOperands,
     /*  4342 */     // GIR_Coverage, 1178,
     /*  4342 */     GIR_Done,
     /*  4343 */   // Label 229: @4343
     /*  4343 */   GIM_Reject,
     /*  4344 */ // Label 227: @4344
     /*  4344 */ GIM_Reject,
     /*  4345 */ // Label 221: @4345
     /*  4345 */ GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(4378), // Rule ID 344 //
     /*  4350 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips64r6_HasStdEnc_NotInMicroMips),
     /*  4353 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  4356 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  4359 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  4363 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  4367 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  4371 */   // (urem:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMODU:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
     /*  4371 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMODU),
     /*  4376 */   GIR_RootConstrainSelectedInstOperands,
     /*  4377 */   // GIR_Coverage, 344,
     /*  4377 */   GIR_Done,
     /*  4378 */ // Label 230: @4378
     /*  4378 */ GIM_Reject,
     /*  4379 */ // Label 222: @4379
     /*  4379 */ GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(4412), // Rule ID 891 //
     /*  4384 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  4387 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  4390 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  4393 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  4397 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  4401 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  4405 */   // (urem:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MOD_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /*  4405 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_U_D),
     /*  4410 */   GIR_RootConstrainSelectedInstOperands,
     /*  4411 */   // GIR_Coverage, 891,
     /*  4411 */   GIR_Done,
     /*  4412 */ // Label 231: @4412
     /*  4412 */ GIM_Reject,
     /*  4413 */ // Label 223: @4413
     /*  4413 */ GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(4446), // Rule ID 890 //
     /*  4418 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  4421 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  4424 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  4427 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  4431 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  4435 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  4439 */   // (urem:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MOD_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /*  4439 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_U_W),
     /*  4444 */   GIR_RootConstrainSelectedInstOperands,
     /*  4445 */   // GIR_Coverage, 890,
     /*  4445 */   GIR_Done,
     /*  4446 */ // Label 232: @4446
     /*  4446 */ GIM_Reject,
     /*  4447 */ // Label 224: @4447
     /*  4447 */ GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(4480), // Rule ID 889 //
     /*  4452 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  4455 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  4458 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  4461 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  4465 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  4469 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  4473 */   // (urem:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MOD_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /*  4473 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_U_H),
     /*  4478 */   GIR_RootConstrainSelectedInstOperands,
     /*  4479 */   // GIR_Coverage, 889,
     /*  4479 */   GIR_Done,
     /*  4480 */ // Label 233: @4480
     /*  4480 */ GIM_Reject,
     /*  4481 */ // Label 225: @4481
     /*  4481 */ GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(4514), // Rule ID 888 //
     /*  4486 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  4489 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  4492 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  4495 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  4499 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  4503 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  4507 */   // (urem:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MOD_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /*  4507 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MOD_U_B),
     /*  4512 */   GIR_RootConstrainSelectedInstOperands,
     /*  4513 */   // GIR_Coverage, 888,
     /*  4513 */   GIR_Done,
     /*  4514 */ // Label 234: @4514
     /*  4514 */ GIM_Reject,
     /*  4515 */ // Label 226: @4515
     /*  4515 */ GIM_Reject,
     /*  4516 */ // Label 7: @4516
     /*  4516 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 241*/ GIMT_Encode4(5071),
     /*  4527 */ /*GILLT_s32*//*Label 235*/ GIMT_Encode4(4559),
     /*  4531 */ /*GILLT_s64*//*Label 236*/ GIMT_Encode4(4833), GIMT_Encode4(0),
     /*  4539 */ /*GILLT_v2s64*//*Label 237*/ GIMT_Encode4(4935), GIMT_Encode4(0),
     /*  4547 */ /*GILLT_v4s32*//*Label 238*/ GIMT_Encode4(4969),
     /*  4551 */ /*GILLT_v8s16*//*Label 239*/ GIMT_Encode4(5003),
     /*  4555 */ /*GILLT_v16s8*//*Label 240*/ GIMT_Encode4(5037),
     /*  4559 */ // Label 235: @4559
     /*  4559 */ GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(4832),
     /*  4564 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  4567 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  4570 */   GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(4612), // Rule ID 41 //
     /*  4575 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /*  4578 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  4582 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  4586 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  4590 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  4594 */     GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_imm32ZExt16),
     /*  4598 */     // MIs[1] Operand 1
     /*  4598 */     // No operand predicates
     /*  4598 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  4600 */     // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_imm32ZExt16>>:$imm16)  =>  (ANDi:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$imm16)
     /*  4600 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ANDi),
     /*  4603 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /*  4605 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs
     /*  4607 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm16
     /*  4610 */     GIR_RootConstrainSelectedInstOperands,
     /*  4611 */     // GIR_Coverage, 41,
     /*  4611 */     GIR_EraseRootFromParent_Done,
     /*  4612 */   // Label 243: @4612
     /*  4612 */   GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(4654), // Rule ID 2172 //
     /*  4617 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
     /*  4620 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  4624 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  4628 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  4632 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  4636 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExtAndi16),
     /*  4640 */     // MIs[1] Operand 1
     /*  4640 */     // No operand predicates
     /*  4640 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  4642 */     // (and:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)  =>  (ANDI16_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)
     /*  4642 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ANDI16_MM),
     /*  4645 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*  4647 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  4649 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*  4652 */     GIR_RootConstrainSelectedInstOperands,
     /*  4653 */     // GIR_Coverage, 2172,
     /*  4653 */     GIR_EraseRootFromParent_Done,
     /*  4654 */   // Label 244: @4654
     /*  4654 */   GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(4696), // Rule ID 2331 //
     /*  4659 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /*  4662 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  4666 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  4670 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  4674 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  4678 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExtAndi16),
     /*  4682 */     // MIs[1] Operand 1
     /*  4682 */     // No operand predicates
     /*  4682 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  4684 */     // (and:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)  =>  (ANDI16_MMR6:{ *:[i32] } GPRMM16:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_immZExtAndi16>>:$imm)
     /*  4684 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ANDI16_MMR6),
     /*  4687 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*  4689 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  4691 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*  4694 */     GIR_RootConstrainSelectedInstOperands,
     /*  4695 */     // GIR_Coverage, 2331,
     /*  4695 */     GIR_EraseRootFromParent_Done,
     /*  4696 */   // Label 245: @4696
     /*  4696 */   GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(4723), // Rule ID 51 //
     /*  4701 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /*  4704 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  4708 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  4712 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  4716 */     // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (AND:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  4716 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND),
     /*  4721 */     GIR_RootConstrainSelectedInstOperands,
     /*  4722 */     // GIR_Coverage, 51,
     /*  4722 */     GIR_Done,
     /*  4723 */   // Label 246: @4723
     /*  4723 */   GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(4750), // Rule ID 1061 //
     /*  4728 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /*  4731 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  4735 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  4739 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  4743 */     // (and:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (AND16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
     /*  4743 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND16_MM),
     /*  4748 */     GIR_RootConstrainSelectedInstOperands,
     /*  4749 */     // GIR_Coverage, 1061,
     /*  4749 */     GIR_Done,
     /*  4750 */   // Label 247: @4750
     /*  4750 */   GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(4777), // Rule ID 1077 //
     /*  4755 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /*  4758 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  4762 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  4766 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  4770 */     // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (AND_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  4770 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_MM),
     /*  4775 */     GIR_RootConstrainSelectedInstOperands,
     /*  4776 */     // GIR_Coverage, 1077,
     /*  4776 */     GIR_Done,
     /*  4777 */   // Label 248: @4777
     /*  4777 */   GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(4804), // Rule ID 1170 //
     /*  4782 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /*  4785 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  4789 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  4793 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  4797 */     // (and:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (AND_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  4797 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_MMR6),
     /*  4802 */     GIR_RootConstrainSelectedInstOperands,
     /*  4803 */     // GIR_Coverage, 1170,
     /*  4803 */     GIR_Done,
     /*  4804 */   // Label 249: @4804
     /*  4804 */   GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(4831), // Rule ID 1828 //
     /*  4809 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
     /*  4812 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  4816 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  4820 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  4824 */     // (and:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (AndRxRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
     /*  4824 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AndRxRxRy16),
     /*  4829 */     GIR_RootConstrainSelectedInstOperands,
     /*  4830 */     // GIR_Coverage, 1828,
     /*  4830 */     GIR_Done,
     /*  4831 */   // Label 250: @4831
     /*  4831 */   GIM_Reject,
     /*  4832 */ // Label 242: @4832
     /*  4832 */ GIM_Reject,
     /*  4833 */ // Label 236: @4833
     /*  4833 */ GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(4934),
     /*  4838 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  4841 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  4844 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  4848 */   GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(4910), // Rule ID 269 //
     /*  4853 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
     /*  4856 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  4860 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  4864 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  4868 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  4872 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  4877 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  4882 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
     /*  4893 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  4895 */     // (and:{ *:[i64] } (add:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt), 255:{ *:[i64] })  =>  (BADDu:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
     /*  4895 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BADDu),
     /*  4898 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*  4900 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
     /*  4904 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
     /*  4908 */     GIR_RootConstrainSelectedInstOperands,
     /*  4909 */     // GIR_Coverage, 269,
     /*  4909 */     GIR_EraseRootFromParent_Done,
     /*  4910 */   // Label 252: @4910
     /*  4910 */   GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(4933), // Rule ID 206 //
     /*  4915 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
     /*  4918 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  4922 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  4926 */     // (and:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (AND64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
     /*  4926 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND64),
     /*  4931 */     GIR_RootConstrainSelectedInstOperands,
     /*  4932 */     // GIR_Coverage, 206,
     /*  4932 */     GIR_Done,
     /*  4933 */   // Label 253: @4933
     /*  4933 */   GIM_Reject,
     /*  4934 */ // Label 251: @4934
     /*  4934 */ GIM_Reject,
     /*  4935 */ // Label 237: @4935
     /*  4935 */ GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(4968), // Rule ID 518 //
     /*  4940 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  4943 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  4946 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  4949 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  4953 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  4957 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  4961 */   // (and:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AND_V_D_PSEUDO:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /*  4961 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_V_D_PSEUDO),
     /*  4966 */   GIR_RootConstrainSelectedInstOperands,
     /*  4967 */   // GIR_Coverage, 518,
     /*  4967 */   GIR_Done,
     /*  4968 */ // Label 254: @4968
     /*  4968 */ GIM_Reject,
     /*  4969 */ // Label 238: @4969
     /*  4969 */ GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(5002), // Rule ID 517 //
     /*  4974 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  4977 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  4980 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  4983 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  4987 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  4991 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  4995 */   // (and:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AND_V_W_PSEUDO:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /*  4995 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_V_W_PSEUDO),
     /*  5000 */   GIR_RootConstrainSelectedInstOperands,
     /*  5001 */   // GIR_Coverage, 517,
     /*  5001 */   GIR_Done,
     /*  5002 */ // Label 255: @5002
     /*  5002 */ GIM_Reject,
     /*  5003 */ // Label 239: @5003
     /*  5003 */ GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(5036), // Rule ID 516 //
     /*  5008 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  5011 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  5014 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  5017 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  5021 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  5025 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  5029 */   // (and:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AND_V_H_PSEUDO:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /*  5029 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_V_H_PSEUDO),
     /*  5034 */   GIR_RootConstrainSelectedInstOperands,
     /*  5035 */   // GIR_Coverage, 516,
     /*  5035 */   GIR_Done,
     /*  5036 */ // Label 256: @5036
     /*  5036 */ GIM_Reject,
     /*  5037 */ // Label 240: @5037
     /*  5037 */ GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(5070), // Rule ID 515 //
     /*  5042 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  5045 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  5048 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  5051 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  5055 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  5059 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  5063 */   // (and:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AND_V:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /*  5063 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::AND_V),
     /*  5068 */   GIR_RootConstrainSelectedInstOperands,
     /*  5069 */   // GIR_Coverage, 515,
     /*  5069 */   GIR_Done,
     /*  5070 */ // Label 257: @5070
     /*  5070 */ GIM_Reject,
     /*  5071 */ // Label 241: @5071
     /*  5071 */ GIM_Reject,
     /*  5072 */ // Label 8: @5072
     /*  5072 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 264*/ GIMT_Encode4(5475),
     /*  5083 */ /*GILLT_s32*//*Label 258*/ GIMT_Encode4(5115),
     /*  5087 */ /*GILLT_s64*//*Label 259*/ GIMT_Encode4(5305), GIMT_Encode4(0),
     /*  5095 */ /*GILLT_v2s64*//*Label 260*/ GIMT_Encode4(5339), GIMT_Encode4(0),
     /*  5103 */ /*GILLT_v4s32*//*Label 261*/ GIMT_Encode4(5373),
     /*  5107 */ /*GILLT_v8s16*//*Label 262*/ GIMT_Encode4(5407),
     /*  5111 */ /*GILLT_v16s8*//*Label 263*/ GIMT_Encode4(5441),
     /*  5115 */ // Label 258: @5115
     /*  5115 */ GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(5304),
     /*  5120 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  5123 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  5126 */   GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(5168), // Rule ID 42 //
     /*  5131 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /*  5134 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5138 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5142 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  5146 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  5150 */     GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_imm32ZExt16),
     /*  5154 */     // MIs[1] Operand 1
     /*  5154 */     // No operand predicates
     /*  5154 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  5156 */     // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_imm32ZExt16>>:$imm16)  =>  (ORi:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$imm16)
     /*  5156 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ORi),
     /*  5159 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /*  5161 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs
     /*  5163 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm16
     /*  5166 */     GIR_RootConstrainSelectedInstOperands,
     /*  5167 */     // GIR_Coverage, 42,
     /*  5167 */     GIR_EraseRootFromParent_Done,
     /*  5168 */   // Label 266: @5168
     /*  5168 */   GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(5195), // Rule ID 52 //
     /*  5173 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /*  5176 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5180 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5184 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5188 */     // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (OR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  5188 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR),
     /*  5193 */     GIR_RootConstrainSelectedInstOperands,
     /*  5194 */     // GIR_Coverage, 52,
     /*  5194 */     GIR_Done,
     /*  5195 */   // Label 267: @5195
     /*  5195 */   GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(5222), // Rule ID 1063 //
     /*  5200 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /*  5203 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  5207 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  5211 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  5215 */     // (or:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (OR16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
     /*  5215 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR16_MM),
     /*  5220 */     GIR_RootConstrainSelectedInstOperands,
     /*  5221 */     // GIR_Coverage, 1063,
     /*  5221 */     GIR_Done,
     /*  5222 */   // Label 268: @5222
     /*  5222 */   GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(5249), // Rule ID 1078 //
     /*  5227 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /*  5230 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5234 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5238 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5242 */     // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (OR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  5242 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_MM),
     /*  5247 */     GIR_RootConstrainSelectedInstOperands,
     /*  5248 */     // GIR_Coverage, 1078,
     /*  5248 */     GIR_Done,
     /*  5249 */   // Label 269: @5249
     /*  5249 */   GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(5276), // Rule ID 1183 //
     /*  5254 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /*  5257 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5261 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5265 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5269 */     // (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (OR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  5269 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_MMR6),
     /*  5274 */     GIR_RootConstrainSelectedInstOperands,
     /*  5275 */     // GIR_Coverage, 1183,
     /*  5275 */     GIR_Done,
     /*  5276 */   // Label 270: @5276
     /*  5276 */   GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(5303), // Rule ID 1830 //
     /*  5281 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
     /*  5284 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  5288 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  5292 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  5296 */     // (or:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (OrRxRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
     /*  5296 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OrRxRxRy16),
     /*  5301 */     GIR_RootConstrainSelectedInstOperands,
     /*  5302 */     // GIR_Coverage, 1830,
     /*  5302 */     GIR_Done,
     /*  5303 */   // Label 271: @5303
     /*  5303 */   GIM_Reject,
     /*  5304 */ // Label 265: @5304
     /*  5304 */ GIM_Reject,
     /*  5305 */ // Label 259: @5305
     /*  5305 */ GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(5338), // Rule ID 207 //
     /*  5310 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
     /*  5313 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  5316 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  5319 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  5323 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  5327 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  5331 */   // (or:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (OR64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
     /*  5331 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR64),
     /*  5336 */   GIR_RootConstrainSelectedInstOperands,
     /*  5337 */   // GIR_Coverage, 207,
     /*  5337 */   GIR_Done,
     /*  5338 */ // Label 272: @5338
     /*  5338 */ GIM_Reject,
     /*  5339 */ // Label 260: @5339
     /*  5339 */ GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(5372), // Rule ID 924 //
     /*  5344 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  5347 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  5350 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  5353 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  5357 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  5361 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  5365 */   // (or:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (OR_V_D_PSEUDO:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /*  5365 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_V_D_PSEUDO),
     /*  5370 */   GIR_RootConstrainSelectedInstOperands,
     /*  5371 */   // GIR_Coverage, 924,
     /*  5371 */   GIR_Done,
     /*  5372 */ // Label 273: @5372
     /*  5372 */ GIM_Reject,
     /*  5373 */ // Label 261: @5373
     /*  5373 */ GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(5406), // Rule ID 923 //
     /*  5378 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  5381 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  5384 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  5387 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  5391 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  5395 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  5399 */   // (or:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (OR_V_W_PSEUDO:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /*  5399 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_V_W_PSEUDO),
     /*  5404 */   GIR_RootConstrainSelectedInstOperands,
     /*  5405 */   // GIR_Coverage, 923,
     /*  5405 */   GIR_Done,
     /*  5406 */ // Label 274: @5406
     /*  5406 */ GIM_Reject,
     /*  5407 */ // Label 262: @5407
     /*  5407 */ GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(5440), // Rule ID 922 //
     /*  5412 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  5415 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  5418 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  5421 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  5425 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  5429 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  5433 */   // (or:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (OR_V_H_PSEUDO:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /*  5433 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_V_H_PSEUDO),
     /*  5438 */   GIR_RootConstrainSelectedInstOperands,
     /*  5439 */   // GIR_Coverage, 922,
     /*  5439 */   GIR_Done,
     /*  5440 */ // Label 275: @5440
     /*  5440 */ GIM_Reject,
     /*  5441 */ // Label 263: @5441
     /*  5441 */ GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(5474), // Rule ID 921 //
     /*  5446 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  5449 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  5452 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  5455 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  5459 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  5463 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  5467 */   // (or:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (OR_V:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /*  5467 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::OR_V),
     /*  5472 */   GIR_RootConstrainSelectedInstOperands,
     /*  5473 */   // GIR_Coverage, 921,
     /*  5473 */   GIR_Done,
     /*  5474 */ // Label 276: @5474
     /*  5474 */ GIM_Reject,
     /*  5475 */ // Label 264: @5475
     /*  5475 */ GIM_Reject,
     /*  5476 */ // Label 9: @5476
     /*  5476 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 283*/ GIMT_Encode4(6367),
     /*  5487 */ /*GILLT_s32*//*Label 277*/ GIMT_Encode4(5519),
     /*  5491 */ /*GILLT_s64*//*Label 278*/ GIMT_Encode4(6136), GIMT_Encode4(0),
     /*  5499 */ /*GILLT_v2s64*//*Label 279*/ GIMT_Encode4(6231), GIMT_Encode4(0),
     /*  5507 */ /*GILLT_v4s32*//*Label 280*/ GIMT_Encode4(6265),
     /*  5511 */ /*GILLT_v8s16*//*Label 281*/ GIMT_Encode4(6299),
     /*  5515 */ /*GILLT_v16s8*//*Label 282*/ GIMT_Encode4(6333),
     /*  5519 */ // Label 277: @5519
     /*  5519 */ GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(6135),
     /*  5524 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  5527 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  5530 */   GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(5589), // Rule ID 54 //
     /*  5535 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /*  5538 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5542 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  5546 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
     /*  5550 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  5554 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  5558 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5563 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5568 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  5572 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  5574 */     // (xor:{ *:[i32] } (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt), -1:{ *:[i32] })  =>  (NOR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  5574 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR),
     /*  5577 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*  5579 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
     /*  5583 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
     /*  5587 */     GIR_RootConstrainSelectedInstOperands,
     /*  5588 */     // GIR_Coverage, 54,
     /*  5588 */     GIR_EraseRootFromParent_Done,
     /*  5589 */   // Label 285: @5589
     /*  5589 */   GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(5648), // Rule ID 1080 //
     /*  5594 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /*  5597 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5601 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  5605 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
     /*  5609 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  5613 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  5617 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5622 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5627 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  5631 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  5633 */     // (xor:{ *:[i32] } (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt), -1:{ *:[i32] })  =>  (NOR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  5633 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR_MM),
     /*  5636 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*  5638 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
     /*  5642 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
     /*  5646 */     GIR_RootConstrainSelectedInstOperands,
     /*  5647 */     // GIR_Coverage, 1080,
     /*  5647 */     GIR_EraseRootFromParent_Done,
     /*  5648 */   // Label 286: @5648
     /*  5648 */   GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(5707), // Rule ID 1182 //
     /*  5653 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /*  5656 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5660 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  5664 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
     /*  5668 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  5672 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  5676 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5681 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5686 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  5690 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  5692 */     // (xor:{ *:[i32] } (or:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt), -1:{ *:[i32] })  =>  (NOR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  5692 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR_MMR6),
     /*  5695 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*  5697 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
     /*  5701 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
     /*  5705 */     GIR_RootConstrainSelectedInstOperands,
     /*  5706 */     // GIR_Coverage, 1182,
     /*  5706 */     GIR_EraseRootFromParent_Done,
     /*  5707 */   // Label 287: @5707
     /*  5707 */   GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(5736), // Rule ID 1209 //
     /*  5712 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /*  5715 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  5719 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  5723 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  5727 */     // (xor:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, -1:{ *:[i32] })  =>  (NOT16_MMR6:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs)
     /*  5727 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOT16_MMR6),
     /*  5730 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /*  5732 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs
     /*  5734 */     GIR_RootConstrainSelectedInstOperands,
     /*  5735 */     // GIR_Coverage, 1209,
     /*  5735 */     GIR_EraseRootFromParent_Done,
     /*  5736 */   // Label 288: @5736
     /*  5736 */   GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(5765), // Rule ID 1062 //
     /*  5741 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /*  5744 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  5748 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  5752 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  5756 */     // (xor:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, -1:{ *:[i32] })  =>  (NOT16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs)
     /*  5756 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOT16_MM),
     /*  5759 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /*  5761 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs
     /*  5763 */     GIR_RootConstrainSelectedInstOperands,
     /*  5764 */     // GIR_Coverage, 1062,
     /*  5764 */     GIR_EraseRootFromParent_Done,
     /*  5765 */   // Label 289: @5765
     /*  5765 */   GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(5800), // Rule ID 1397 //
     /*  5770 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /*  5773 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5777 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5781 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  5785 */     // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$in, ZERO:{ *:[i32] })
     /*  5785 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR),
     /*  5788 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*  5790 */     GIR_RootToRootCopy, /*OpIdx*/1, // in
     /*  5792 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  5798 */     GIR_RootConstrainSelectedInstOperands,
     /*  5799 */     // GIR_Coverage, 1397,
     /*  5799 */     GIR_EraseRootFromParent_Done,
     /*  5800 */   // Label 290: @5800
     /*  5800 */   GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(5829), // Rule ID 1825 //
     /*  5805 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
     /*  5808 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  5812 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  5816 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  5820 */     // (xor:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r, -1:{ *:[i32] })  =>  (NotRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$r)
     /*  5820 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NotRxRy16),
     /*  5823 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rx]
     /*  5825 */     GIR_RootToRootCopy, /*OpIdx*/1, // r
     /*  5827 */     GIR_RootConstrainSelectedInstOperands,
     /*  5828 */     // GIR_Coverage, 1825,
     /*  5828 */     GIR_EraseRootFromParent_Done,
     /*  5829 */   // Label 291: @5829
     /*  5829 */   GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(5858), // Rule ID 2167 //
     /*  5834 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
     /*  5837 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  5841 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  5845 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  5849 */     // (xor:{ *:[i32] } GPRMM16:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOT16_MM:{ *:[i32] } GPRMM16:{ *:[i32] }:$in)
     /*  5849 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOT16_MM),
     /*  5852 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /*  5854 */     GIR_RootToRootCopy, /*OpIdx*/1, // in
     /*  5856 */     GIR_RootConstrainSelectedInstOperands,
     /*  5857 */     // GIR_Coverage, 2167,
     /*  5857 */     GIR_EraseRootFromParent_Done,
     /*  5858 */   // Label 292: @5858
     /*  5858 */   GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(5893), // Rule ID 2168 //
     /*  5863 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips),
     /*  5866 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5870 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5874 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  5878 */     // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$in, ZERO:{ *:[i32] })
     /*  5878 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR_MM),
     /*  5881 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*  5883 */     GIR_RootToRootCopy, /*OpIdx*/1, // in
     /*  5885 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  5891 */     GIR_RootConstrainSelectedInstOperands,
     /*  5892 */     // GIR_Coverage, 2168,
     /*  5892 */     GIR_EraseRootFromParent_Done,
     /*  5893 */   // Label 293: @5893
     /*  5893 */   GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(5922), // Rule ID 2334 //
     /*  5898 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /*  5901 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  5905 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  5909 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  5913 */     // (xor:{ *:[i32] } GPRMM16:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOT16_MMR6:{ *:[i32] } GPRMM16:{ *:[i32] }:$in)
     /*  5913 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOT16_MMR6),
     /*  5916 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /*  5918 */     GIR_RootToRootCopy, /*OpIdx*/1, // in
     /*  5920 */     GIR_RootConstrainSelectedInstOperands,
     /*  5921 */     // GIR_Coverage, 2334,
     /*  5921 */     GIR_EraseRootFromParent_Done,
     /*  5922 */   // Label 294: @5922
     /*  5922 */   GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(5957), // Rule ID 2335 //
     /*  5927 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /*  5930 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5934 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5938 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  5942 */     // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$in, -1:{ *:[i32] })  =>  (NOR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$in, ZERO:{ *:[i32] })
     /*  5942 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR_MMR6),
     /*  5945 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*  5947 */     GIR_RootToRootCopy, /*OpIdx*/1, // in
     /*  5949 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  5955 */     GIR_RootConstrainSelectedInstOperands,
     /*  5956 */     // GIR_Coverage, 2335,
     /*  5956 */     GIR_EraseRootFromParent_Done,
     /*  5957 */   // Label 295: @5957
     /*  5957 */   GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(5999), // Rule ID 43 //
     /*  5962 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /*  5965 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5969 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  5973 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  5977 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  5981 */     GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_imm32ZExt16),
     /*  5985 */     // MIs[1] Operand 1
     /*  5985 */     // No operand predicates
     /*  5985 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  5987 */     // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_imm32ZExt16>>:$imm16)  =>  (XORi:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$imm16)
     /*  5987 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::XORi),
     /*  5990 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /*  5992 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs
     /*  5994 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm16
     /*  5997 */     GIR_RootConstrainSelectedInstOperands,
     /*  5998 */     // GIR_Coverage, 43,
     /*  5998 */     GIR_EraseRootFromParent_Done,
     /*  5999 */   // Label 296: @5999
     /*  5999 */   GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(6026), // Rule ID 53 //
     /*  6004 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /*  6007 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6011 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6015 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6019 */     // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (XOR:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  6019 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR),
     /*  6024 */     GIR_RootConstrainSelectedInstOperands,
     /*  6025 */     // GIR_Coverage, 53,
     /*  6025 */     GIR_Done,
     /*  6026 */   // Label 297: @6026
     /*  6026 */   GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(6053), // Rule ID 1065 //
     /*  6031 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /*  6034 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  6038 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  6042 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPRMM16RegClassID),
     /*  6046 */     // (xor:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)  =>  (XOR16_MM:{ *:[i32] } GPRMM16Opnd:{ *:[i32] }:$rs, GPRMM16Opnd:{ *:[i32] }:$rt)
     /*  6046 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR16_MM),
     /*  6051 */     GIR_RootConstrainSelectedInstOperands,
     /*  6052 */     // GIR_Coverage, 1065,
     /*  6052 */     GIR_Done,
     /*  6053 */   // Label 298: @6053
     /*  6053 */   GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(6080), // Rule ID 1079 //
     /*  6058 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /*  6061 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6065 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6069 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6073 */     // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (XOR_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  6073 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_MM),
     /*  6078 */     GIR_RootConstrainSelectedInstOperands,
     /*  6079 */     // GIR_Coverage, 1079,
     /*  6079 */     GIR_Done,
     /*  6080 */   // Label 299: @6080
     /*  6080 */   GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(6107), // Rule ID 1186 //
     /*  6085 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /*  6088 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6092 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6096 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6100 */     // (xor:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (XOR_MMR6:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /*  6100 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_MMR6),
     /*  6105 */     GIR_RootConstrainSelectedInstOperands,
     /*  6106 */     // GIR_Coverage, 1186,
     /*  6106 */     GIR_Done,
     /*  6107 */   // Label 300: @6107
     /*  6107 */   GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(6134), // Rule ID 1832 //
     /*  6112 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
     /*  6115 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  6119 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  6123 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /*  6127 */     // (xor:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)  =>  (XorRxRxRy16:{ *:[i32] } CPU16Regs:{ *:[i32] }:$l, CPU16Regs:{ *:[i32] }:$r)
     /*  6127 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XorRxRxRy16),
     /*  6132 */     GIR_RootConstrainSelectedInstOperands,
     /*  6133 */     // GIR_Coverage, 1832,
     /*  6133 */     GIR_Done,
     /*  6134 */   // Label 301: @6134
     /*  6134 */   GIM_Reject,
     /*  6135 */ // Label 284: @6135
     /*  6135 */ GIM_Reject,
     /*  6136 */ // Label 278: @6136
     /*  6136 */ GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(6230),
     /*  6141 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  6144 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  6147 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  6151 */   GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(6206), // Rule ID 209 //
     /*  6156 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
     /*  6159 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  6163 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
     /*  6167 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  6171 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  6175 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  6180 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  6185 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  6189 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  6191 */     // (xor:{ *:[i64] } (or:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt), -1:{ *:[i64] })  =>  (NOR64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
     /*  6191 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NOR64),
     /*  6194 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*  6196 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs
     /*  6200 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rt
     /*  6204 */     GIR_RootConstrainSelectedInstOperands,
     /*  6205 */     // GIR_Coverage, 209,
     /*  6205 */     GIR_EraseRootFromParent_Done,
     /*  6206 */   // Label 303: @6206
     /*  6206 */   GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(6229), // Rule ID 208 //
     /*  6211 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
     /*  6214 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  6218 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  6222 */     // (xor:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)  =>  (XOR64:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt)
     /*  6222 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR64),
     /*  6227 */     GIR_RootConstrainSelectedInstOperands,
     /*  6228 */     // GIR_Coverage, 208,
     /*  6228 */     GIR_Done,
     /*  6229 */   // Label 304: @6229
     /*  6229 */   GIM_Reject,
     /*  6230 */ // Label 302: @6230
     /*  6230 */ GIM_Reject,
     /*  6231 */ // Label 279: @6231
     /*  6231 */ GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(6264), // Rule ID 1040 //
     /*  6236 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  6239 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  6242 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  6245 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  6249 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  6253 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  6257 */   // (xor:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (XOR_V_D_PSEUDO:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /*  6257 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_V_D_PSEUDO),
     /*  6262 */   GIR_RootConstrainSelectedInstOperands,
     /*  6263 */   // GIR_Coverage, 1040,
     /*  6263 */   GIR_Done,
     /*  6264 */ // Label 305: @6264
     /*  6264 */ GIM_Reject,
     /*  6265 */ // Label 280: @6265
     /*  6265 */ GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(6298), // Rule ID 1039 //
     /*  6270 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  6273 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  6276 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  6279 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  6283 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  6287 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  6291 */   // (xor:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (XOR_V_W_PSEUDO:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /*  6291 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_V_W_PSEUDO),
     /*  6296 */   GIR_RootConstrainSelectedInstOperands,
     /*  6297 */   // GIR_Coverage, 1039,
     /*  6297 */   GIR_Done,
     /*  6298 */ // Label 306: @6298
     /*  6298 */ GIM_Reject,
     /*  6299 */ // Label 281: @6299
     /*  6299 */ GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(6332), // Rule ID 1038 //
     /*  6304 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  6307 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  6310 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  6313 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  6317 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  6321 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  6325 */   // (xor:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (XOR_V_H_PSEUDO:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /*  6325 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_V_H_PSEUDO),
     /*  6330 */   GIR_RootConstrainSelectedInstOperands,
     /*  6331 */   // GIR_Coverage, 1038,
     /*  6331 */   GIR_Done,
     /*  6332 */ // Label 307: @6332
     /*  6332 */ GIM_Reject,
     /*  6333 */ // Label 282: @6333
     /*  6333 */ GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(6366), // Rule ID 1037 //
     /*  6338 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  6341 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  6344 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  6347 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  6351 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  6355 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  6359 */   // (xor:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (XOR_V:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /*  6359 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::XOR_V),
     /*  6364 */   GIR_RootConstrainSelectedInstOperands,
     /*  6365 */   // GIR_Coverage, 1037,
     /*  6365 */   GIR_Done,
     /*  6366 */ // Label 308: @6366
     /*  6366 */ GIM_Reject,
     /*  6367 */ // Label 283: @6367
     /*  6367 */ GIM_Reject,
     /*  6368 */ // Label 10: @6368
     /*  6368 */ GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(6440),
     /*  6373 */   GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
     /*  6376 */   GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
     /*  6379 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  6382 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  6385 */   GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(6412), // Rule ID 180 //
     /*  6390 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsNotSoftFloat_NotFP64bit_NotInMips16Mode),
     /*  6393 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::AFGR64RegClassID),
     /*  6397 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6401 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6405 */     // (MipsBuildPairF64:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$lo, GPR32Opnd:{ *:[i32] }:$hi)  =>  (BuildPairF64:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$lo, GPR32Opnd:{ *:[i32] }:$hi)
     /*  6405 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BuildPairF64),
     /*  6410 */     GIR_RootConstrainSelectedInstOperands,
     /*  6411 */     // GIR_Coverage, 180,
     /*  6411 */     GIR_Done,
     /*  6412 */   // Label 310: @6412
     /*  6412 */   GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(6439), // Rule ID 181 //
     /*  6417 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsFP64bit_IsNotSoftFloat_NotInMips16Mode),
     /*  6420 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR64RegClassID),
     /*  6424 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6428 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6432 */     // (MipsBuildPairF64:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$lo, GPR32Opnd:{ *:[i32] }:$hi)  =>  (BuildPairF64_64:{ *:[f64] } GPR32Opnd:{ *:[i32] }:$lo, GPR32Opnd:{ *:[i32] }:$hi)
     /*  6432 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BuildPairF64_64),
     /*  6437 */     GIR_RootConstrainSelectedInstOperands,
     /*  6438 */     // GIR_Coverage, 181,
     /*  6438 */     GIR_Done,
     /*  6439 */   // Label 311: @6439
     /*  6439 */   GIM_Reject,
     /*  6440 */ // Label 309: @6440
     /*  6440 */ GIM_Reject,
     /*  6441 */ // Label 11: @6441
     /*  6441 */ GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(6512),
     /*  6446 */   GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
     /*  6449 */   GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /*  6452 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  6455 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  6459 */   GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(6485), // Rule ID 719 //
     /*  6464 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasMips64_HasStdEnc),
     /*  6467 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  6471 */     // MIs[0] rs
     /*  6471 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6476 */     // (build_vector:{ *:[v2i64] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rs)  =>  (FILL_D:{ *:[v2i64] } GPR64Opnd:{ *:[i64] }:$rs)
     /*  6476 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FILL_D),
     /*  6479 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /*  6481 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs
     /*  6483 */     GIR_RootConstrainSelectedInstOperands,
     /*  6484 */     // GIR_Coverage, 719,
     /*  6484 */     GIR_EraseRootFromParent_Done,
     /*  6485 */   // Label 313: @6485
     /*  6485 */   GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(6511), // Rule ID 721 //
     /*  6490 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  6493 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR64RegClassID),
     /*  6497 */     // MIs[0] fs
     /*  6497 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6502 */     // (build_vector:{ *:[v2f64] } FGR64:{ *:[f64] }:$fs, FGR64:{ *:[f64] }:$fs)  =>  (FILL_FD_PSEUDO:{ *:[v2f64] } FGR64:{ *:[f64] }:$fs)
     /*  6502 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FILL_FD_PSEUDO),
     /*  6505 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /*  6507 */     GIR_RootToRootCopy, /*OpIdx*/1, // fs
     /*  6509 */     GIR_RootConstrainSelectedInstOperands,
     /*  6510 */     // GIR_Coverage, 721,
     /*  6510 */     GIR_EraseRootFromParent_Done,
     /*  6511 */   // Label 314: @6511
     /*  6511 */   GIM_Reject,
     /*  6512 */ // Label 312: @6512
     /*  6512 */ GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(6603),
     /*  6517 */   GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
     /*  6520 */   GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /*  6523 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  6526 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  6530 */   GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(6566), // Rule ID 718 //
     /*  6535 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  6538 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6542 */     // MIs[0] rs
     /*  6542 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6547 */     // MIs[0] rs
     /*  6547 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6552 */     // MIs[0] rs
     /*  6552 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6557 */     // (build_vector:{ *:[v4i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs)  =>  (FILL_W:{ *:[v4i32] } GPR32Opnd:{ *:[i32] }:$rs)
     /*  6557 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FILL_W),
     /*  6560 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /*  6562 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs
     /*  6564 */     GIR_RootConstrainSelectedInstOperands,
     /*  6565 */     // GIR_Coverage, 718,
     /*  6565 */     GIR_EraseRootFromParent_Done,
     /*  6566 */   // Label 316: @6566
     /*  6566 */   GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(6602), // Rule ID 720 //
     /*  6571 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  6574 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
     /*  6578 */     // MIs[0] fs
     /*  6578 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6583 */     // MIs[0] fs
     /*  6583 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6588 */     // MIs[0] fs
     /*  6588 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6593 */     // (build_vector:{ *:[v4f32] } FGR32:{ *:[f32] }:$fs, FGR32:{ *:[f32] }:$fs, FGR32:{ *:[f32] }:$fs, FGR32:{ *:[f32] }:$fs)  =>  (FILL_FW_PSEUDO:{ *:[v4f32] } FGR32:{ *:[f32] }:$fs)
     /*  6593 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FILL_FW_PSEUDO),
     /*  6596 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /*  6598 */     GIR_RootToRootCopy, /*OpIdx*/1, // fs
     /*  6600 */     GIR_RootConstrainSelectedInstOperands,
     /*  6601 */     // GIR_Coverage, 720,
     /*  6601 */     GIR_EraseRootFromParent_Done,
     /*  6602 */   // Label 317: @6602
     /*  6602 */   GIM_Reject,
     /*  6603 */ // Label 315: @6603
     /*  6603 */ GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(6672), // Rule ID 717 //
     /*  6608 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  6611 */   GIM_CheckNumOperands, /*MI*/0, /*Expected*/9,
     /*  6614 */   GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /*  6617 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  6620 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  6624 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6628 */   // MIs[0] rs
     /*  6628 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6633 */   // MIs[0] rs
     /*  6633 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6638 */   // MIs[0] rs
     /*  6638 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6643 */   // MIs[0] rs
     /*  6643 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/5, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6648 */   // MIs[0] rs
     /*  6648 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/6, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6653 */   // MIs[0] rs
     /*  6653 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/7, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6658 */   // MIs[0] rs
     /*  6658 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/8, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6663 */   // (build_vector:{ *:[v8i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs)  =>  (FILL_H:{ *:[v8i16] } GPR32Opnd:{ *:[i32] }:$rs)
     /*  6663 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FILL_H),
     /*  6666 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /*  6668 */   GIR_RootToRootCopy, /*OpIdx*/1, // rs
     /*  6670 */   GIR_RootConstrainSelectedInstOperands,
     /*  6671 */   // GIR_Coverage, 717,
     /*  6671 */   GIR_EraseRootFromParent_Done,
     /*  6672 */ // Label 318: @6672
     /*  6672 */ GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(6781), // Rule ID 716 //
     /*  6677 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /*  6680 */   GIM_CheckNumOperands, /*MI*/0, /*Expected*/17,
     /*  6683 */   GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /*  6686 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  6689 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  6693 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6697 */   // MIs[0] rs
     /*  6697 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6702 */   // MIs[0] rs
     /*  6702 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/3, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6707 */   // MIs[0] rs
     /*  6707 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/4, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6712 */   // MIs[0] rs
     /*  6712 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/5, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6717 */   // MIs[0] rs
     /*  6717 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/6, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6722 */   // MIs[0] rs
     /*  6722 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/7, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6727 */   // MIs[0] rs
     /*  6727 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/8, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6732 */   // MIs[0] rs
     /*  6732 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/9, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6737 */   // MIs[0] rs
     /*  6737 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/10, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6742 */   // MIs[0] rs
     /*  6742 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/11, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6747 */   // MIs[0] rs
     /*  6747 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/12, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6752 */   // MIs[0] rs
     /*  6752 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/13, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6757 */   // MIs[0] rs
     /*  6757 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/14, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6762 */   // MIs[0] rs
     /*  6762 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/15, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6767 */   // MIs[0] rs
     /*  6767 */   GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/16, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  6772 */   // (build_vector:{ *:[v16i8] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rs)  =>  (FILL_B:{ *:[v16i8] } GPR32Opnd:{ *:[i32] }:$rs)
     /*  6772 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FILL_B),
     /*  6775 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /*  6777 */   GIR_RootToRootCopy, /*OpIdx*/1, // rs
     /*  6779 */   GIR_RootConstrainSelectedInstOperands,
     /*  6780 */   // GIR_Coverage, 716,
     /*  6780 */   GIR_EraseRootFromParent_Done,
     /*  6781 */ // Label 319: @6781
     /*  6781 */ GIM_Reject,
     /*  6782 */ // Label 12: @6782
     /*  6782 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(9), /*)*//*default:*//*Label 328*/ GIMT_Encode4(11092),
     /*  6793 */ /*GILLT_s32*//*Label 320*/ GIMT_Encode4(6825),
     /*  6797 */ /*GILLT_s64*//*Label 321*/ GIMT_Encode4(7102),
     /*  6801 */ /*GILLT_v2s16*//*Label 322*/ GIMT_Encode4(7158),
     /*  6805 */ /*GILLT_v2s64*//*Label 323*/ GIMT_Encode4(7218),
     /*  6809 */ /*GILLT_v4s8*//*Label 324*/ GIMT_Encode4(8353),
     /*  6813 */ /*GILLT_v4s32*//*Label 325*/ GIMT_Encode4(8413),
     /*  6817 */ /*GILLT_v8s16*//*Label 326*/ GIMT_Encode4(9482),
     /*  6821 */ /*GILLT_v16s8*//*Label 327*/ GIMT_Encode4(10407),
     /*  6825 */ // Label 320: @6825
     /*  6825 */ GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(6851), // Rule ID 135 //
     /*  6830 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips),
     /*  6833 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  6836 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6840 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
     /*  6844 */   // (bitconvert:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (MFC1:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)
     /*  6844 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MFC1),
     /*  6849 */   GIR_RootConstrainSelectedInstOperands,
     /*  6850 */   // GIR_Coverage, 135,
     /*  6850 */   GIR_Done,
     /*  6851 */ // Label 329: @6851
     /*  6851 */ GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(6877), // Rule ID 136 //
     /*  6856 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_IsNotSoftFloat_NotInMicroMips),
     /*  6859 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  6862 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
     /*  6866 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6870 */   // (bitconvert:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)  =>  (MTC1:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)
     /*  6870 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MTC1),
     /*  6875 */   GIR_RootConstrainSelectedInstOperands,
     /*  6876 */   // GIR_Coverage, 136,
     /*  6876 */   GIR_Done,
     /*  6877 */ // Label 330: @6877
     /*  6877 */ GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(6903), // Rule ID 1160 //
     /*  6882 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_IsNotSoftFloat),
     /*  6885 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  6888 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6892 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
     /*  6896 */   // (bitconvert:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (MFC1_MM:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)
     /*  6896 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MFC1_MM),
     /*  6901 */   GIR_RootConstrainSelectedInstOperands,
     /*  6902 */   // GIR_Coverage, 1160,
     /*  6902 */   GIR_Done,
     /*  6903 */ // Label 331: @6903
     /*  6903 */ GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(6929), // Rule ID 1161 //
     /*  6908 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_IsNotSoftFloat),
     /*  6911 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  6914 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
     /*  6918 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6922 */   // (bitconvert:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)  =>  (MTC1_MM:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)
     /*  6922 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MTC1_MM),
     /*  6927 */   GIR_RootConstrainSelectedInstOperands,
     /*  6928 */   // GIR_Coverage, 1161,
     /*  6928 */   GIR_Done,
     /*  6929 */ // Label 332: @6929
     /*  6929 */ GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(6955), // Rule ID 1175 //
     /*  6934 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat),
     /*  6937 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  6940 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
     /*  6944 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6948 */   // (bitconvert:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)  =>  (MTC1_MMR6:{ *:[f32] } GPR32Opnd:{ *:[i32] }:$rt)
     /*  6948 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MTC1_MMR6),
     /*  6953 */   GIR_RootConstrainSelectedInstOperands,
     /*  6954 */   // GIR_Coverage, 1175,
     /*  6954 */   GIR_Done,
     /*  6955 */ // Label 333: @6955
     /*  6955 */ GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(6981), // Rule ID 1176 //
     /*  6960 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips_IsNotSoftFloat),
     /*  6963 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  6966 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6970 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
     /*  6974 */   // (bitconvert:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)  =>  (MFC1_MMR6:{ *:[i32] } FGR32Opnd:{ *:[f32] }:$fs)
     /*  6974 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::MFC1_MMR6),
     /*  6979 */   GIR_RootConstrainSelectedInstOperands,
     /*  6980 */   // GIR_Coverage, 1176,
     /*  6980 */   GIR_Done,
     /*  6981 */ // Label 334: @6981
     /*  6981 */ GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(7011), // Rule ID 1913 //
     /*  6986 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /*  6989 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  6992 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  6996 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /*  7000 */   // (bitconvert:{ *:[i32] } DSPR:{ *:[v2i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[i32] } DSPR:{ *:[v2i16] }:$src, GPR32:{ *:[i32] })
     /*  7000 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7005 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR32RegClassID),
     /*  7010 */   // GIR_Coverage, 1913,
     /*  7010 */   GIR_Done,
     /*  7011 */ // Label 335: @7011
     /*  7011 */ GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(7041), // Rule ID 1914 //
     /*  7016 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /*  7019 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
     /*  7022 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  7026 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /*  7030 */   // (bitconvert:{ *:[i32] } DSPR:{ *:[v4i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[i32] } DSPR:{ *:[v4i8] }:$src, GPR32:{ *:[i32] })
     /*  7030 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7035 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::GPR32RegClassID),
     /*  7040 */   // GIR_Coverage, 1914,
     /*  7040 */   GIR_Done,
     /*  7041 */ // Label 336: @7041
     /*  7041 */ GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(7071), // Rule ID 1917 //
     /*  7046 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /*  7049 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  7052 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
     /*  7056 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /*  7060 */   // (bitconvert:{ *:[f32] } DSPR:{ *:[v2i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f32] } DSPR:{ *:[v2i16] }:$src, FGR32:{ *:[i32] })
     /*  7060 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7065 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::FGR32RegClassID),
     /*  7070 */   // GIR_Coverage, 1917,
     /*  7070 */   GIR_Done,
     /*  7071 */ // Label 337: @7071
     /*  7071 */ GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(7101), // Rule ID 1918 //
     /*  7076 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /*  7079 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s8,
     /*  7082 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
     /*  7086 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /*  7090 */   // (bitconvert:{ *:[f32] } DSPR:{ *:[v4i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f32] } DSPR:{ *:[v4i8] }:$src, FGR32:{ *:[i32] })
     /*  7090 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7095 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::FGR32RegClassID),
     /*  7100 */   // GIR_Coverage, 1918,
     /*  7100 */   GIR_Done,
     /*  7101 */ // Label 338: @7101
     /*  7101 */ GIM_Reject,
     /*  7102 */ // Label 321: @7102
     /*  7102 */ GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(7157),
     /*  7107 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  7110 */   GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(7133), // Rule ID 137 //
     /*  7115 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsNotSoftFloat_NotInMicroMips),
     /*  7118 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::FGR64RegClassID),
     /*  7122 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  7126 */     // (bitconvert:{ *:[f64] } GPR64Opnd:{ *:[i64] }:$rt)  =>  (DMTC1:{ *:[f64] } GPR64Opnd:{ *:[i64] }:$rt)
     /*  7126 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMTC1),
     /*  7131 */     GIR_RootConstrainSelectedInstOperands,
     /*  7132 */     // GIR_Coverage, 137,
     /*  7132 */     GIR_Done,
     /*  7133 */   // Label 340: @7133
     /*  7133 */   GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(7156), // Rule ID 138 //
     /*  7138 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsNotSoftFloat_NotInMicroMips),
     /*  7141 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /*  7145 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR64RegClassID),
     /*  7149 */     // (bitconvert:{ *:[i64] } FGR64Opnd:{ *:[f64] }:$fs)  =>  (DMFC1:{ *:[i64] } FGR64Opnd:{ *:[f64] }:$fs)
     /*  7149 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::DMFC1),
     /*  7154 */     GIR_RootConstrainSelectedInstOperands,
     /*  7155 */     // GIR_Coverage, 138,
     /*  7155 */     GIR_Done,
     /*  7156 */   // Label 341: @7156
     /*  7156 */   GIM_Reject,
     /*  7157 */ // Label 339: @7157
     /*  7157 */ GIM_Reject,
     /*  7158 */ // Label 322: @7158
     /*  7158 */ GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(7217),
     /*  7163 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  7166 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /*  7170 */   GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(7193), // Rule ID 1915 //
     /*  7175 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /*  7178 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  7182 */     // (bitconvert:{ *:[v2i16] } GPR32:{ *:[i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i16] } GPR32:{ *:[i32] }:$src, DSPR:{ *:[i32] })
     /*  7182 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7187 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
     /*  7192 */     // GIR_Coverage, 1915,
     /*  7192 */     GIR_Done,
     /*  7193 */   // Label 343: @7193
     /*  7193 */   GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(7216), // Rule ID 1919 //
     /*  7198 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /*  7201 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
     /*  7205 */     // (bitconvert:{ *:[v2i16] } FGR32:{ *:[f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i16] } FGR32:{ *:[f32] }:$src, DSPR:{ *:[i32] })
     /*  7205 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7210 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
     /*  7215 */     // GIR_Coverage, 1919,
     /*  7215 */     GIR_Done,
     /*  7216 */   // Label 344: @7216
     /*  7216 */   GIM_Reject,
     /*  7217 */ // Label 342: @7217
     /*  7217 */ GIM_Reject,
     /*  7218 */ // Label 323: @7218
     /*  7218 */ GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(7244), // Rule ID 2000 //
     /*  7223 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
     /*  7226 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  7229 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7233 */   // (bitconvert:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v2f64:{ *:[v2f64] }:$src, MSA128D:{ *:[i32] })
     /*  7233 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7238 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7243 */   // GIR_Coverage, 2000,
     /*  7243 */   GIR_Done,
     /*  7244 */ // Label 345: @7244
     /*  7244 */ GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(7270), // Rule ID 2003 //
     /*  7249 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
     /*  7252 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  7255 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7259 */   // (bitconvert:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v2i64:{ *:[v2i64] }:$src, MSA128D:{ *:[i32] })
     /*  7259 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7264 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7269 */   // GIR_Coverage, 2003,
     /*  7269 */   GIR_Done,
     /*  7270 */ // Label 346: @7270
     /*  7270 */ GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(7296), // Rule ID 2020 //
     /*  7275 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  7278 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  7281 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7285 */   // (bitconvert:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$src, MSA128D:{ *:[i32] })
     /*  7285 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7290 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7295 */   // GIR_Coverage, 2020,
     /*  7295 */   GIR_Done,
     /*  7296 */ // Label 347: @7296
     /*  7296 */ GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(7322), // Rule ID 2021 //
     /*  7301 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  7304 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  7307 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7311 */   // (bitconvert:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$src, MSA128D:{ *:[i32] })
     /*  7311 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7316 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7321 */   // GIR_Coverage, 2021,
     /*  7321 */   GIR_Done,
     /*  7322 */ // Label 348: @7322
     /*  7322 */ GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(7348), // Rule ID 2022 //
     /*  7327 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  7330 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  7333 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7337 */   // (bitconvert:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$src, MSA128D:{ *:[i32] })
     /*  7337 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7342 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7347 */   // GIR_Coverage, 2022,
     /*  7347 */   GIR_Done,
     /*  7348 */ // Label 349: @7348
     /*  7348 */ GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(7374), // Rule ID 2023 //
     /*  7353 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  7356 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  7359 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7363 */   // (bitconvert:{ *:[v2i64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v8f16:{ *:[v8f16] }:$src, MSA128D:{ *:[i32] })
     /*  7363 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7368 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7373 */   // GIR_Coverage, 2023,
     /*  7373 */   GIR_Done,
     /*  7374 */ // Label 350: @7374
     /*  7374 */ GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(7400), // Rule ID 2024 //
     /*  7379 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  7382 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  7385 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7389 */   // (bitconvert:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$src, MSA128D:{ *:[i32] })
     /*  7389 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7394 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7399 */   // GIR_Coverage, 2024,
     /*  7399 */   GIR_Done,
     /*  7400 */ // Label 351: @7400
     /*  7400 */ GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(7426), // Rule ID 2030 //
     /*  7405 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  7408 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  7411 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7415 */   // (bitconvert:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$src, MSA128D:{ *:[i32] })
     /*  7415 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7420 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7425 */   // GIR_Coverage, 2030,
     /*  7425 */   GIR_Done,
     /*  7426 */ // Label 352: @7426
     /*  7426 */ GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(7452), // Rule ID 2031 //
     /*  7431 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  7434 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  7437 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7441 */   // (bitconvert:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$src, MSA128D:{ *:[i32] })
     /*  7441 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7446 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7451 */   // GIR_Coverage, 2031,
     /*  7451 */   GIR_Done,
     /*  7452 */ // Label 353: @7452
     /*  7452 */ GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(7478), // Rule ID 2032 //
     /*  7457 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  7460 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  7463 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7467 */   // (bitconvert:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$src, MSA128D:{ *:[i32] })
     /*  7467 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7472 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7477 */   // GIR_Coverage, 2032,
     /*  7477 */   GIR_Done,
     /*  7478 */ // Label 354: @7478
     /*  7478 */ GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(7504), // Rule ID 2033 //
     /*  7483 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  7486 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  7489 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7493 */   // (bitconvert:{ *:[v2f64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v8f16:{ *:[v8f16] }:$src, MSA128D:{ *:[i32] })
     /*  7493 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7498 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7503 */   // GIR_Coverage, 2033,
     /*  7503 */   GIR_Done,
     /*  7504 */ // Label 355: @7504
     /*  7504 */ GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(7530), // Rule ID 2034 //
     /*  7509 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  7512 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  7515 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7519 */   // (bitconvert:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$src, MSA128D:{ *:[i32] })
     /*  7519 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7524 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7529 */   // GIR_Coverage, 2034,
     /*  7529 */   GIR_Done,
     /*  7530 */ // Label 356: @7530
     /*  7530 */ GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(7647), // Rule ID 2039 //
     /*  7535 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  7538 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  7541 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7545 */   // (bitconvert:{ *:[v2i64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
     /*  7545 */   GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
     /*  7548 */   GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7552 */   GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  7557 */   GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  7561 */   GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  7566 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
     /*  7569 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
     /*  7573 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  7578 */   GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
     /*  7581 */   GIR_AddImm8, /*InsnID*/3, /*Imm*/27,
     /*  7584 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  7586 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /*  7589 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7593 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  7598 */   GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  7601 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  7606 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  7609 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
     /*  7613 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  7618 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  7621 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /*  7631 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  7633 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7636 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  7638 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  7641 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7646 */   // GIR_Coverage, 2039,
     /*  7646 */   GIR_EraseRootFromParent_Done,
     /*  7647 */ // Label 357: @7647
     /*  7647 */ GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(7764), // Rule ID 2040 //
     /*  7652 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  7655 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  7658 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7662 */   // (bitconvert:{ *:[v2f64] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
     /*  7662 */   GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
     /*  7665 */   GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7669 */   GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  7674 */   GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  7678 */   GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  7683 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
     /*  7686 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
     /*  7690 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  7695 */   GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
     /*  7698 */   GIR_AddImm8, /*InsnID*/3, /*Imm*/27,
     /*  7701 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  7703 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /*  7706 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7710 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  7715 */   GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  7718 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  7723 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  7726 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
     /*  7730 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  7735 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  7738 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /*  7748 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  7750 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7753 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  7755 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  7758 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7763 */   // GIR_Coverage, 2040,
     /*  7763 */   GIR_EraseRootFromParent_Done,
     /*  7764 */ // Label 358: @7764
     /*  7764 */ GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(7834), // Rule ID 2044 //
     /*  7769 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  7772 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  7775 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7779 */   // (bitconvert:{ *:[v2i64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
     /*  7779 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  7782 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7786 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  7791 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  7795 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  7800 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  7803 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
     /*  7807 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  7812 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  7815 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
     /*  7818 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  7820 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7823 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  7825 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  7828 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7833 */   // GIR_Coverage, 2044,
     /*  7833 */   GIR_EraseRootFromParent_Done,
     /*  7834 */ // Label 359: @7834
     /*  7834 */ GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(7904), // Rule ID 2045 //
     /*  7839 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  7842 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  7845 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7849 */   // (bitconvert:{ *:[v2f64] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
     /*  7849 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  7852 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7856 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  7861 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  7865 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  7870 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  7873 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
     /*  7877 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  7882 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  7885 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
     /*  7888 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  7890 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7893 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  7895 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  7898 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7903 */   // GIR_Coverage, 2045,
     /*  7903 */   GIR_EraseRootFromParent_Done,
     /*  7904 */ // Label 360: @7904
     /*  7904 */ GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(7974), // Rule ID 2049 //
     /*  7909 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  7912 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  7915 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7919 */   // (bitconvert:{ *:[v2i64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
     /*  7919 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  7922 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7926 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  7931 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  7935 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  7940 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  7943 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
     /*  7947 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  7952 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  7955 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
     /*  7958 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  7960 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7963 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  7965 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  7968 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7973 */   // GIR_Coverage, 2049,
     /*  7973 */   GIR_EraseRootFromParent_Done,
     /*  7974 */ // Label 361: @7974
     /*  7974 */ GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(8044), // Rule ID 2050 //
     /*  7979 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  7982 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  7985 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  7989 */   // (bitconvert:{ *:[v2f64] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128D:{ *:[i32] })
     /*  7989 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  7992 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  7996 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  8001 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  8005 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  8010 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  8013 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
     /*  8017 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  8022 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  8025 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
     /*  8028 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  8030 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8033 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  8035 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  8038 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  8043 */   // GIR_Coverage, 2050,
     /*  8043 */   GIR_EraseRootFromParent_Done,
     /*  8044 */ // Label 362: @8044
     /*  8044 */ GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(8121), // Rule ID 2054 //
     /*  8049 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  8052 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  8055 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  8059 */   // (bitconvert:{ *:[v2i64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
     /*  8059 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /*  8062 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8066 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  8071 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  8075 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8080 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  8083 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
     /*  8087 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  8092 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  8095 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /*  8105 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  8107 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8110 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  8112 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  8115 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  8120 */   // GIR_Coverage, 2054,
     /*  8120 */   GIR_EraseRootFromParent_Done,
     /*  8121 */ // Label 363: @8121
     /*  8121 */ GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(8198), // Rule ID 2055 //
     /*  8126 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  8129 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  8132 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  8136 */   // (bitconvert:{ *:[v2f64] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
     /*  8136 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /*  8139 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8143 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  8148 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  8152 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8157 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  8160 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
     /*  8164 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  8169 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  8172 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /*  8182 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  8184 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8187 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  8189 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  8192 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  8197 */   // GIR_Coverage, 2055,
     /*  8197 */   GIR_EraseRootFromParent_Done,
     /*  8198 */ // Label 364: @8198
     /*  8198 */ GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(8275), // Rule ID 2059 //
     /*  8203 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  8206 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  8209 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  8213 */   // (bitconvert:{ *:[v2i64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2i64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
     /*  8213 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /*  8216 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8220 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  8225 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  8229 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8234 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  8237 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
     /*  8241 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  8246 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  8249 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /*  8259 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  8261 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8264 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  8266 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  8269 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  8274 */   // GIR_Coverage, 2059,
     /*  8274 */   GIR_EraseRootFromParent_Done,
     /*  8275 */ // Label 365: @8275
     /*  8275 */ GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(8352), // Rule ID 2060 //
     /*  8280 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  8283 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  8286 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  8290 */   // (bitconvert:{ *:[v2f64] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v2f64] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128D:{ *:[i32] })
     /*  8290 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /*  8293 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8297 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  8302 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  8306 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8311 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  8314 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
     /*  8318 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  8323 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  8326 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /*  8336 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  8338 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8341 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  8343 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  8346 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128DRegClassID),
     /*  8351 */   // GIR_Coverage, 2060,
     /*  8351 */   GIR_EraseRootFromParent_Done,
     /*  8352 */ // Label 366: @8352
     /*  8352 */ GIM_Reject,
     /*  8353 */ // Label 324: @8353
     /*  8353 */ GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(8412),
     /*  8358 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  8361 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /*  8365 */   GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(8388), // Rule ID 1916 //
     /*  8370 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /*  8373 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /*  8377 */     // (bitconvert:{ *:[v4i8] } GPR32:{ *:[i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i8] } GPR32:{ *:[i32] }:$src, DSPR:{ *:[i32] })
     /*  8377 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8382 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
     /*  8387 */     // GIR_Coverage, 1916,
     /*  8387 */     GIR_Done,
     /*  8388 */   // Label 368: @8388
     /*  8388 */   GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(8411), // Rule ID 1920 //
     /*  8393 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /*  8396 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(Mips::FGR32RegClassID),
     /*  8400 */     // (bitconvert:{ *:[v4i8] } FGR32:{ *:[f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i8] } FGR32:{ *:[f32] }:$src, DSPR:{ *:[i32] })
     /*  8400 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8405 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::DSPRRegClassID),
     /*  8410 */     // GIR_Coverage, 1920,
     /*  8410 */     GIR_Done,
     /*  8411 */   // Label 369: @8411
     /*  8411 */   GIM_Reject,
     /*  8412 */ // Label 367: @8412
     /*  8412 */ GIM_Reject,
     /*  8413 */ // Label 325: @8413
     /*  8413 */ GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(8439), // Rule ID 1999 //
     /*  8418 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
     /*  8421 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  8424 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8428 */   // (bitconvert:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v4f32:{ *:[v4f32] }:$src, MSA128W:{ *:[i32] })
     /*  8428 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8433 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8438 */   // GIR_Coverage, 1999,
     /*  8438 */   GIR_Done,
     /*  8439 */ // Label 370: @8439
     /*  8439 */ GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(8465), // Rule ID 2002 //
     /*  8444 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
     /*  8447 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  8450 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8454 */   // (bitconvert:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v4i32:{ *:[v4i32] }:$src, MSA128W:{ *:[i32] })
     /*  8454 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8459 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8464 */   // GIR_Coverage, 2002,
     /*  8464 */   GIR_Done,
     /*  8465 */ // Label 371: @8465
     /*  8465 */ GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(8491), // Rule ID 2015 //
     /*  8470 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  8473 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  8476 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8480 */   // (bitconvert:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$src, MSA128W:{ *:[i32] })
     /*  8480 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8485 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8490 */   // GIR_Coverage, 2015,
     /*  8490 */   GIR_Done,
     /*  8491 */ // Label 372: @8491
     /*  8491 */ GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(8517), // Rule ID 2016 //
     /*  8496 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  8499 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  8502 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8506 */   // (bitconvert:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$src, MSA128W:{ *:[i32] })
     /*  8506 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8511 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8516 */   // GIR_Coverage, 2016,
     /*  8516 */   GIR_Done,
     /*  8517 */ // Label 373: @8517
     /*  8517 */ GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(8543), // Rule ID 2017 //
     /*  8522 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  8525 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  8528 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8532 */   // (bitconvert:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] })
     /*  8532 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8537 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8542 */   // GIR_Coverage, 2017,
     /*  8542 */   GIR_Done,
     /*  8543 */ // Label 374: @8543
     /*  8543 */ GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(8569), // Rule ID 2018 //
     /*  8548 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  8551 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  8554 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8558 */   // (bitconvert:{ *:[v4i32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v8f16:{ *:[v8f16] }:$src, MSA128W:{ *:[i32] })
     /*  8558 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8563 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8568 */   // GIR_Coverage, 2018,
     /*  8568 */   GIR_Done,
     /*  8569 */ // Label 375: @8569
     /*  8569 */ GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(8595), // Rule ID 2019 //
     /*  8574 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  8577 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  8580 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8584 */   // (bitconvert:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] })
     /*  8584 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8589 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8594 */   // GIR_Coverage, 2019,
     /*  8594 */   GIR_Done,
     /*  8595 */ // Label 376: @8595
     /*  8595 */ GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(8621), // Rule ID 2025 //
     /*  8600 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  8603 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  8606 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8610 */   // (bitconvert:{ *:[v4f32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v16i8:{ *:[v16i8] }:$src, MSA128W:{ *:[i32] })
     /*  8610 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8615 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8620 */   // GIR_Coverage, 2025,
     /*  8620 */   GIR_Done,
     /*  8621 */ // Label 377: @8621
     /*  8621 */ GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(8647), // Rule ID 2026 //
     /*  8626 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  8629 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  8632 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8636 */   // (bitconvert:{ *:[v4f32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v8i16:{ *:[v8i16] }:$src, MSA128W:{ *:[i32] })
     /*  8636 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8641 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8646 */   // GIR_Coverage, 2026,
     /*  8646 */   GIR_Done,
     /*  8647 */ // Label 378: @8647
     /*  8647 */ GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(8673), // Rule ID 2027 //
     /*  8652 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  8655 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  8658 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8662 */   // (bitconvert:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] })
     /*  8662 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8667 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8672 */   // GIR_Coverage, 2027,
     /*  8672 */   GIR_Done,
     /*  8673 */ // Label 379: @8673
     /*  8673 */ GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(8699), // Rule ID 2028 //
     /*  8678 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  8681 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  8684 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8688 */   // (bitconvert:{ *:[v4f32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v8f16:{ *:[v8f16] }:$src, MSA128W:{ *:[i32] })
     /*  8688 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8693 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8698 */   // GIR_Coverage, 2028,
     /*  8698 */   GIR_Done,
     /*  8699 */ // Label 380: @8699
     /*  8699 */ GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(8725), // Rule ID 2029 //
     /*  8704 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  8707 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  8710 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8714 */   // (bitconvert:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] })
     /*  8714 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8719 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8724 */   // GIR_Coverage, 2029,
     /*  8724 */   GIR_Done,
     /*  8725 */ // Label 381: @8725
     /*  8725 */ GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(8795), // Rule ID 2037 //
     /*  8730 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  8733 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  8736 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8740 */   // (bitconvert:{ *:[v4i32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] })
     /*  8740 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
     /*  8743 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8747 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  8752 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  8756 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  8761 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
     /*  8764 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
     /*  8768 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  8773 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  8776 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
     /*  8779 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  8781 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8784 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  8786 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  8789 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8794 */   // GIR_Coverage, 2037,
     /*  8794 */   GIR_EraseRootFromParent_Done,
     /*  8795 */ // Label 382: @8795
     /*  8795 */ GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(8865), // Rule ID 2038 //
     /*  8800 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  8803 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  8806 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8810 */   // (bitconvert:{ *:[v4f32] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] })
     /*  8810 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
     /*  8813 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8817 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  8822 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  8826 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  8831 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
     /*  8834 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
     /*  8838 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  8843 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  8846 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
     /*  8849 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  8851 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8854 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  8856 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  8859 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8864 */   // GIR_Coverage, 2038,
     /*  8864 */   GIR_EraseRootFromParent_Done,
     /*  8865 */ // Label 383: @8865
     /*  8865 */ GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(8942), // Rule ID 2042 //
     /*  8870 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  8873 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  8876 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8880 */   // (bitconvert:{ *:[v4i32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
     /*  8880 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  8883 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8887 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  8892 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  8896 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  8901 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  8904 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
     /*  8908 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  8913 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  8916 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /*  8926 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  8928 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8931 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  8933 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  8936 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8941 */   // GIR_Coverage, 2042,
     /*  8941 */   GIR_EraseRootFromParent_Done,
     /*  8942 */ // Label 384: @8942
     /*  8942 */ GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(9019), // Rule ID 2043 //
     /*  8947 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  8950 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  8953 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  8957 */   // (bitconvert:{ *:[v4f32] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
     /*  8957 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  8960 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  8964 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  8969 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  8973 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  8978 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  8981 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
     /*  8985 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  8990 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  8993 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /*  9003 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  9005 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9008 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  9010 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  9013 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  9018 */   // GIR_Coverage, 2043,
     /*  9018 */   GIR_EraseRootFromParent_Done,
     /*  9019 */ // Label 385: @9019
     /*  9019 */ GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(9096), // Rule ID 2047 //
     /*  9024 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  9027 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  9030 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  9034 */   // (bitconvert:{ *:[v4i32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
     /*  9034 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  9037 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9041 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9046 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  9050 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9055 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  9058 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
     /*  9062 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9067 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  9070 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /*  9080 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  9082 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9085 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  9087 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  9090 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  9095 */   // GIR_Coverage, 2047,
     /*  9095 */   GIR_EraseRootFromParent_Done,
     /*  9096 */ // Label 386: @9096
     /*  9096 */ GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(9173), // Rule ID 2048 //
     /*  9101 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  9104 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  9107 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  9111 */   // (bitconvert:{ *:[v4f32] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
     /*  9111 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  9114 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9118 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9123 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  9127 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9132 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  9135 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
     /*  9139 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9144 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  9147 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /*  9157 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  9159 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9162 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  9164 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  9167 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  9172 */   // GIR_Coverage, 2048,
     /*  9172 */   GIR_EraseRootFromParent_Done,
     /*  9173 */ // Label 387: @9173
     /*  9173 */ GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(9250), // Rule ID 2064 //
     /*  9178 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  9181 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  9184 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  9188 */   // (bitconvert:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
     /*  9188 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /*  9191 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9195 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9200 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  9204 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  9209 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  9212 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
     /*  9216 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9221 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  9224 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /*  9234 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  9236 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9239 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  9241 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  9244 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  9249 */   // GIR_Coverage, 2064,
     /*  9249 */   GIR_EraseRootFromParent_Done,
     /*  9250 */ // Label 388: @9250
     /*  9250 */ GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(9327), // Rule ID 2065 //
     /*  9255 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  9258 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  9261 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  9265 */   // (bitconvert:{ *:[v4f32] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2i64:{ *:[v2i64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
     /*  9265 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /*  9268 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9272 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9277 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  9281 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  9286 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  9289 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
     /*  9293 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9298 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  9301 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /*  9311 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  9313 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9316 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  9318 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  9321 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  9326 */   // GIR_Coverage, 2065,
     /*  9326 */   GIR_EraseRootFromParent_Done,
     /*  9327 */ // Label 389: @9327
     /*  9327 */ GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(9404), // Rule ID 2069 //
     /*  9332 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  9335 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  9338 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  9342 */   // (bitconvert:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
     /*  9342 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /*  9345 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9349 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9354 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  9358 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  9363 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  9366 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
     /*  9370 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9375 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  9378 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /*  9388 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  9390 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9393 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  9395 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  9398 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  9403 */   // GIR_Coverage, 2069,
     /*  9403 */   GIR_EraseRootFromParent_Done,
     /*  9404 */ // Label 390: @9404
     /*  9404 */ GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(9481), // Rule ID 2070 //
     /*  9409 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  9412 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  9415 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  9419 */   // (bitconvert:{ *:[v4f32] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v4f32] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } v2f64:{ *:[v2f64] }:$src, MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128W:{ *:[i32] })
     /*  9419 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /*  9422 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9426 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9431 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  9435 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  9440 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  9443 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
     /*  9447 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9452 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  9455 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /*  9465 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  9467 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9470 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  9472 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  9475 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /*  9480 */   // GIR_Coverage, 2070,
     /*  9480 */   GIR_EraseRootFromParent_Done,
     /*  9481 */ // Label 391: @9481
     /*  9481 */ GIM_Reject,
     /*  9482 */ // Label 326: @9482
     /*  9482 */ GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(9508), // Rule ID 1998 //
     /*  9487 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
     /*  9490 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  9493 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9497 */   // (bitconvert:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v8f16:{ *:[v8f16] }:$src, MSA128H:{ *:[i32] })
     /*  9497 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9502 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9507 */   // GIR_Coverage, 1998,
     /*  9507 */   GIR_Done,
     /*  9508 */ // Label 392: @9508
     /*  9508 */ GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(9534), // Rule ID 2001 //
     /*  9513 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA),
     /*  9516 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  9519 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9523 */   // (bitconvert:{ *:[v8f16] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } v8i16:{ *:[v8i16] }:$src, MSA128H:{ *:[i32] })
     /*  9523 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9528 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9533 */   // GIR_Coverage, 2001,
     /*  9533 */   GIR_Done,
     /*  9534 */ // Label 393: @9534
     /*  9534 */ GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(9560), // Rule ID 2010 //
     /*  9539 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  9542 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  9545 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9549 */   // (bitconvert:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$src, MSA128H:{ *:[i32] })
     /*  9549 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9554 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9559 */   // GIR_Coverage, 2010,
     /*  9559 */   GIR_Done,
     /*  9560 */ // Label 394: @9560
     /*  9560 */ GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(9586), // Rule ID 2011 //
     /*  9565 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  9568 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  9571 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9575 */   // (bitconvert:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src, MSA128H:{ *:[i32] })
     /*  9575 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9580 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9585 */   // GIR_Coverage, 2011,
     /*  9585 */   GIR_Done,
     /*  9586 */ // Label 395: @9586
     /*  9586 */ GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(9612), // Rule ID 2012 //
     /*  9591 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  9594 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  9597 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9601 */   // (bitconvert:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src, MSA128H:{ *:[i32] })
     /*  9601 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9606 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9611 */   // GIR_Coverage, 2012,
     /*  9611 */   GIR_Done,
     /*  9612 */ // Label 396: @9612
     /*  9612 */ GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(9638), // Rule ID 2013 //
     /*  9617 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  9620 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  9623 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9627 */   // (bitconvert:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src, MSA128H:{ *:[i32] })
     /*  9627 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9632 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9637 */   // GIR_Coverage, 2013,
     /*  9637 */   GIR_Done,
     /*  9638 */ // Label 397: @9638
     /*  9638 */ GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(9664), // Rule ID 2014 //
     /*  9643 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /*  9646 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  9649 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9653 */   // (bitconvert:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src, MSA128H:{ *:[i32] })
     /*  9653 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9658 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9663 */   // GIR_Coverage, 2014,
     /*  9663 */   GIR_Done,
     /*  9664 */ // Label 398: @9664
     /*  9664 */ GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(9741), // Rule ID 2035 //
     /*  9669 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  9672 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  9675 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9679 */   // (bitconvert:{ *:[v8i16] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
     /*  9679 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
     /*  9682 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9686 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9691 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  9695 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  9700 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
     /*  9703 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
     /*  9707 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9712 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  9715 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /*  9725 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  9727 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9730 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  9732 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  9735 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9740 */   // GIR_Coverage, 2035,
     /*  9740 */   GIR_EraseRootFromParent_Done,
     /*  9741 */ // Label 399: @9741
     /*  9741 */ GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(9818), // Rule ID 2036 //
     /*  9746 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  9749 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  9752 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9756 */   // (bitconvert:{ *:[v8f16] } v16i8:{ *:[v16i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
     /*  9756 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
     /*  9759 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9763 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9768 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  9772 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /*  9777 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
     /*  9780 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
     /*  9784 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9789 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  9792 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /*  9802 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  9804 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9807 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  9809 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  9812 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9817 */   // GIR_Coverage, 2036,
     /*  9817 */   GIR_EraseRootFromParent_Done,
     /*  9818 */ // Label 400: @9818
     /*  9818 */ GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(9895), // Rule ID 2052 //
     /*  9823 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  9826 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  9829 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9833 */   // (bitconvert:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
     /*  9833 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  9836 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9840 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9845 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  9849 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9854 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  9857 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
     /*  9861 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9866 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  9869 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /*  9879 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  9881 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9884 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  9886 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  9889 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9894 */   // GIR_Coverage, 2052,
     /*  9894 */   GIR_EraseRootFromParent_Done,
     /*  9895 */ // Label 401: @9895
     /*  9895 */ GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(9972), // Rule ID 2053 //
     /*  9900 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  9903 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  9906 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9910 */   // (bitconvert:{ *:[v8f16] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4i32:{ *:[v4i32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
     /*  9910 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  9913 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9917 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9922 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /*  9926 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9931 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  9934 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
     /*  9938 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9943 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  9946 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /*  9956 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  9958 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9961 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  9963 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  9966 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9971 */   // GIR_Coverage, 2053,
     /*  9971 */   GIR_EraseRootFromParent_Done,
     /*  9972 */ // Label 402: @9972
     /*  9972 */ GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(10049), // Rule ID 2057 //
     /*  9977 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /*  9980 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  9983 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /*  9987 */   // (bitconvert:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
     /*  9987 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  9990 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  9994 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  9999 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /* 10003 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 10008 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /* 10011 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
     /* 10015 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10020 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 10023 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /* 10033 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 10035 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10038 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 10040 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 10043 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 10048 */   // GIR_Coverage, 2057,
     /* 10048 */   GIR_EraseRootFromParent_Done,
     /* 10049 */ // Label 403: @10049
     /* 10049 */ GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(10126), // Rule ID 2058 //
     /* 10054 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /* 10057 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /* 10060 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 10064 */   // (bitconvert:{ *:[v8f16] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v4f32:{ *:[v4f32] }:$src, MSA128H:{ *:[i32] }), 177:{ *:[i32] }), MSA128H:{ *:[i32] })
     /* 10064 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /* 10067 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10071 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10076 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /* 10080 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 10085 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /* 10088 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
     /* 10092 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10097 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 10100 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /* 10110 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 10112 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10115 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 10117 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 10120 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 10125 */   // GIR_Coverage, 2058,
     /* 10125 */   GIR_EraseRootFromParent_Done,
     /* 10126 */ // Label 404: @10126
     /* 10126 */ GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(10196), // Rule ID 2062 //
     /* 10131 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /* 10134 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 10137 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 10141 */   // (bitconvert:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
     /* 10141 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /* 10144 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10148 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10153 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /* 10157 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 10162 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /* 10165 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
     /* 10169 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10174 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 10177 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
     /* 10180 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 10182 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10185 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 10187 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 10190 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 10195 */   // GIR_Coverage, 2062,
     /* 10195 */   GIR_EraseRootFromParent_Done,
     /* 10196 */ // Label 405: @10196
     /* 10196 */ GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(10266), // Rule ID 2063 //
     /* 10201 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /* 10204 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 10207 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 10211 */   // (bitconvert:{ *:[v8f16] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2i64:{ *:[v2i64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
     /* 10211 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /* 10214 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10218 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10223 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /* 10227 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 10232 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /* 10235 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
     /* 10239 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10244 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 10247 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
     /* 10250 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 10252 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10255 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 10257 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 10260 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 10265 */   // GIR_Coverage, 2063,
     /* 10265 */   GIR_EraseRootFromParent_Done,
     /* 10266 */ // Label 406: @10266
     /* 10266 */ GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(10336), // Rule ID 2067 //
     /* 10271 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /* 10274 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 10277 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 10281 */   // (bitconvert:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
     /* 10281 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /* 10284 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10288 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10293 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /* 10297 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 10302 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /* 10305 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
     /* 10309 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10314 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 10317 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
     /* 10320 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 10322 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10325 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 10327 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 10330 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 10335 */   // GIR_Coverage, 2067,
     /* 10335 */   GIR_EraseRootFromParent_Done,
     /* 10336 */ // Label 407: @10336
     /* 10336 */ GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(10406), // Rule ID 2068 //
     /* 10341 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /* 10344 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 10347 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 10351 */   // (bitconvert:{ *:[v8f16] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8f16] } (SHF_H:{ *:[v8i16] } (COPY_TO_REGCLASS:{ *:[v8i16] } v2f64:{ *:[v2f64] }:$src, MSA128H:{ *:[i32] }), 27:{ *:[i32] }), MSA128H:{ *:[i32] })
     /* 10351 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /* 10354 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10358 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10363 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /* 10367 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 10372 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /* 10375 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_H),
     /* 10379 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10384 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 10387 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
     /* 10390 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 10392 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10395 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 10397 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 10400 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 10405 */   // GIR_Coverage, 2068,
     /* 10405 */   GIR_EraseRootFromParent_Done,
     /* 10406 */ // Label 408: @10406
     /* 10406 */ GIM_Reject,
     /* 10407 */ // Label 327: @10407
     /* 10407 */ GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(10433), // Rule ID 2004 //
     /* 10412 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /* 10415 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /* 10418 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10422 */   // (bitconvert:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src, MSA128B:{ *:[i32] })
     /* 10422 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10427 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10432 */   // GIR_Coverage, 2004,
     /* 10432 */   GIR_Done,
     /* 10433 */ // Label 409: @10433
     /* 10433 */ GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(10459), // Rule ID 2005 //
     /* 10438 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /* 10441 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /* 10444 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10448 */   // (bitconvert:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src, MSA128B:{ *:[i32] })
     /* 10448 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10453 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10458 */   // GIR_Coverage, 2005,
     /* 10458 */   GIR_Done,
     /* 10459 */ // Label 410: @10459
     /* 10459 */ GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(10485), // Rule ID 2006 //
     /* 10464 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /* 10467 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 10470 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10474 */   // (bitconvert:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src, MSA128B:{ *:[i32] })
     /* 10474 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10479 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10484 */   // GIR_Coverage, 2006,
     /* 10484 */   GIR_Done,
     /* 10485 */ // Label 411: @10485
     /* 10485 */ GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(10511), // Rule ID 2007 //
     /* 10490 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /* 10493 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /* 10496 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10500 */   // (bitconvert:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src, MSA128B:{ *:[i32] })
     /* 10500 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10505 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10510 */   // GIR_Coverage, 2007,
     /* 10510 */   GIR_Done,
     /* 10511 */ // Label 412: @10511
     /* 10511 */ GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(10537), // Rule ID 2008 //
     /* 10516 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /* 10519 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /* 10522 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10526 */   // (bitconvert:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src, MSA128B:{ *:[i32] })
     /* 10526 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10531 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10536 */   // GIR_Coverage, 2008,
     /* 10536 */   GIR_Done,
     /* 10537 */ // Label 413: @10537
     /* 10537 */ GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(10563), // Rule ID 2009 //
     /* 10542 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsLE),
     /* 10545 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 10548 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10552 */   // (bitconvert:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src, MSA128B:{ *:[i32] })
     /* 10552 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10557 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10562 */   // GIR_Coverage, 2009,
     /* 10562 */   GIR_Done,
     /* 10563 */ // Label 414: @10563
     /* 10563 */ GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(10640), // Rule ID 2041 //
     /* 10568 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /* 10571 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /* 10574 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10578 */   // (bitconvert:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v8i16:{ *:[v8i16] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
     /* 10578 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
     /* 10581 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10585 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10590 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /* 10594 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10599 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
     /* 10602 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
     /* 10606 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10611 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 10614 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /* 10624 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 10626 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10629 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 10631 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 10634 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10639 */   // GIR_Coverage, 2041,
     /* 10639 */   GIR_EraseRootFromParent_Done,
     /* 10640 */ // Label 415: @10640
     /* 10640 */ GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(10717), // Rule ID 2046 //
     /* 10645 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /* 10648 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /* 10651 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10655 */   // (bitconvert:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v8f16:{ *:[v8f16] }:$src, MSA128B:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
     /* 10655 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
     /* 10658 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10662 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10667 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /* 10671 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10676 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
     /* 10679 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
     /* 10683 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10688 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 10691 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /* 10701 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 10703 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10706 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 10708 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 10711 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10716 */   // GIR_Coverage, 2046,
     /* 10716 */   GIR_EraseRootFromParent_Done,
     /* 10717 */ // Label 416: @10717
     /* 10717 */ GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(10787), // Rule ID 2051 //
     /* 10722 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /* 10725 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /* 10728 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10732 */   // (bitconvert:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v4i32:{ *:[v4i32] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128B:{ *:[i32] })
     /* 10732 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
     /* 10735 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10739 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10744 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /* 10748 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10753 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
     /* 10756 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
     /* 10760 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10765 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 10768 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
     /* 10771 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 10773 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10776 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 10778 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 10781 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10786 */   // GIR_Coverage, 2051,
     /* 10786 */   GIR_EraseRootFromParent_Done,
     /* 10787 */ // Label 417: @10787
     /* 10787 */ GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(10857), // Rule ID 2056 //
     /* 10792 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /* 10795 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /* 10798 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10802 */   // (bitconvert:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v4f32:{ *:[v4f32] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128B:{ *:[i32] })
     /* 10802 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
     /* 10805 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10809 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10814 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /* 10818 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10823 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s8,
     /* 10826 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
     /* 10830 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10835 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 10838 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/27,
     /* 10841 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 10843 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10846 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 10848 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 10851 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10856 */   // GIR_Coverage, 2056,
     /* 10856 */   GIR_EraseRootFromParent_Done,
     /* 10857 */ // Label 418: @10857
     /* 10857 */ GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(10974), // Rule ID 2061 //
     /* 10862 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /* 10865 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 10868 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10872 */   // (bitconvert:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v2i64:{ *:[v2i64] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
     /* 10872 */   GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
     /* 10875 */   GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10879 */   GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10884 */   GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
     /* 10888 */   GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10893 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
     /* 10896 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
     /* 10900 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10905 */   GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
     /* 10908 */   GIR_AddImm8, /*InsnID*/3, /*Imm*/27,
     /* 10911 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /* 10913 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /* 10916 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10920 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10925 */   GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /* 10928 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 10933 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /* 10936 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
     /* 10940 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 10945 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 10948 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /* 10958 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 10960 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10963 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 10965 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 10968 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10973 */   // GIR_Coverage, 2061,
     /* 10973 */   GIR_EraseRootFromParent_Done,
     /* 10974 */ // Label 419: @10974
     /* 10974 */ GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(11091), // Rule ID 2066 //
     /* 10979 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_IsBE),
     /* 10982 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 10985 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 10989 */   // (bitconvert:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i8] } (SHF_W:{ *:[v4i32] } (COPY_TO_REGCLASS:{ *:[v4i32] } (SHF_B:{ *:[v16i8] } (COPY_TO_REGCLASS:{ *:[v16i8] } v2f64:{ *:[v2f64] }:$src, MSA128B:{ *:[i32] }), 27:{ *:[i32] }), MSA128W:{ *:[i32] }), 177:{ *:[i32] }), MSA128B:{ *:[i32] })
     /* 10989 */   GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v16s8,
     /* 10992 */   GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 10996 */   GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 11001 */   GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
     /* 11005 */   GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 11010 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
     /* 11013 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(Mips::SHF_B),
     /* 11017 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 11022 */   GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
     /* 11025 */   GIR_AddImm8, /*InsnID*/3, /*Imm*/27,
     /* 11028 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /* 11030 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /* 11033 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 11037 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 11042 */   GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /* 11045 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 11050 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /* 11053 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SHF_W),
     /* 11057 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 11062 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 11065 */   GIR_AddImm, /*InsnID*/1, /*Imm*/GIMT_Encode8(177),
     /* 11075 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 11077 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 11080 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 11082 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 11085 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 11090 */   // GIR_Coverage, 2066,
     /* 11090 */   GIR_EraseRootFromParent_Done,
     /* 11091 */ // Label 420: @11091
     /* 11091 */ GIM_Reject,
     /* 11092 */ // Label 328: @11092
     /* 11092 */ GIM_Reject,
     /* 11093 */ // Label 13: @11093
     /* 11093 */ GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(11157), // Rule ID 1989 //
     /* 11098 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 11101 */   GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 11104 */   GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /* 11107 */   GIM_CheckMemorySizeEqualToLLT, /*MI*/0, /*MMO*/0, /*OpIdx*/0,
     /* 11111 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11115 */   // MIs[0] Operand 1
     /* 11115 */   GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
     /* 11119 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 11123 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 11127 */   GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /* 11131 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 11135 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 11137 */   // (ld:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index))<<P:Predicate_unindexedload>><<P:Predicate_load>>  =>  (LWX:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index)
     /* 11137 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LWX),
     /* 11140 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 11142 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // base
     /* 11146 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // index
     /* 11150 */   GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /* 11155 */   GIR_RootConstrainSelectedInstOperands,
     /* 11156 */   // GIR_Coverage, 1989,
     /* 11156 */   GIR_EraseRootFromParent_Done,
     /* 11157 */ // Label 421: @11157
     /* 11157 */ GIM_Reject,
     /* 11158 */ // Label 14: @11158
     /* 11158 */ GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(11225), // Rule ID 1988 //
     /* 11163 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 11166 */   GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 11169 */   GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /* 11172 */   GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
     /* 11179 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11183 */   // MIs[0] Operand 1
     /* 11183 */   GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
     /* 11187 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 11191 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 11195 */   GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /* 11199 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 11203 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 11205 */   // (ld:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index))<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>>  =>  (LHX:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index)
     /* 11205 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LHX),
     /* 11208 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 11210 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // base
     /* 11214 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // index
     /* 11218 */   GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /* 11223 */   GIR_RootConstrainSelectedInstOperands,
     /* 11224 */   // GIR_Coverage, 1988,
     /* 11224 */   GIR_EraseRootFromParent_Done,
     /* 11225 */ // Label 422: @11225
     /* 11225 */ GIM_Reject,
     /* 11226 */ // Label 15: @11226
     /* 11226 */ GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(11293), // Rule ID 1987 //
     /* 11231 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 11234 */   GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 11237 */   GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /* 11240 */   GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
     /* 11247 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11251 */   // MIs[0] Operand 1
     /* 11251 */   GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
     /* 11255 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 11259 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 11263 */   GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /* 11267 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 11271 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 11273 */   // (ld:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index))<<P:Predicate_unindexedload>><<P:Predicate_zextload>><<P:Predicate_zextloadi8>>  =>  (LBUX:{ *:[i32] } i32:{ *:[i32] }:$base, i32:{ *:[i32] }:$index)
     /* 11273 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::LBUX),
     /* 11276 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 11278 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // base
     /* 11282 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // index
     /* 11286 */   GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /* 11291 */   GIR_RootConstrainSelectedInstOperands,
     /* 11292 */   // GIR_Coverage, 1987,
     /* 11292 */   GIR_EraseRootFromParent_Done,
     /* 11293 */ // Label 423: @11293
     /* 11293 */ GIM_Reject,
     /* 11294 */ // Label 16: @11294
     /* 11294 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 426*/ GIMT_Encode4(11485),
     /* 11305 */ /*GILLT_s32*//*Label 424*/ GIMT_Encode4(11313),
     /* 11309 */ /*GILLT_s64*//*Label 425*/ GIMT_Encode4(11440),
     /* 11313 */ // Label 424: @11313
     /* 11313 */ GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(11439),
     /* 11318 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 11321 */   GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 11324 */   GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(11362), // Rule ID 25 //
     /* 11329 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 11332 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
     /* 11339 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11343 */     // MIs[0] ptr
     /* 11343 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 11347 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11351 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11355 */     // (atomic_cmp_swap:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$cmp, GPR32:{ *:[i32] }:$swap)<<P:Predicate_atomic_cmp_swap_i8>>  =>  (ATOMIC_CMP_SWAP_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$cmp, GPR32:{ *:[i32] }:$swap)
     /* 11355 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_CMP_SWAP_I8),
     /* 11360 */     GIR_RootConstrainSelectedInstOperands,
     /* 11361 */     // GIR_Coverage, 25,
     /* 11361 */     GIR_Done,
     /* 11362 */   // Label 428: @11362
     /* 11362 */   GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(11400), // Rule ID 26 //
     /* 11367 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 11370 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
     /* 11377 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11381 */     // MIs[0] ptr
     /* 11381 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 11385 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11389 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11393 */     // (atomic_cmp_swap:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$cmp, GPR32:{ *:[i32] }:$swap)<<P:Predicate_atomic_cmp_swap_i16>>  =>  (ATOMIC_CMP_SWAP_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$cmp, GPR32:{ *:[i32] }:$swap)
     /* 11393 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_CMP_SWAP_I16),
     /* 11398 */     GIR_RootConstrainSelectedInstOperands,
     /* 11399 */     // GIR_Coverage, 26,
     /* 11399 */     GIR_Done,
     /* 11400 */   // Label 429: @11400
     /* 11400 */   GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(11438), // Rule ID 27 //
     /* 11405 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 11408 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
     /* 11415 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11419 */     // MIs[0] ptr
     /* 11419 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 11423 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11427 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11431 */     // (atomic_cmp_swap:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$cmp, GPR32:{ *:[i32] }:$swap)<<P:Predicate_atomic_cmp_swap_i32>>  =>  (ATOMIC_CMP_SWAP_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$cmp, GPR32:{ *:[i32] }:$swap)
     /* 11431 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_CMP_SWAP_I32),
     /* 11436 */     GIR_RootConstrainSelectedInstOperands,
     /* 11437 */     // GIR_Coverage, 27,
     /* 11437 */     GIR_Done,
     /* 11438 */   // Label 430: @11438
     /* 11438 */   GIM_Reject,
     /* 11439 */ // Label 427: @11439
     /* 11439 */ GIM_Reject,
     /* 11440 */ // Label 425: @11440
     /* 11440 */ GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(11484), // Rule ID 191 //
     /* 11445 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 11448 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 11451 */   GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
     /* 11454 */   GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
     /* 11461 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 11465 */   // MIs[0] ptr
     /* 11465 */   GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 11469 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 11473 */   GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 11477 */   // (atomic_cmp_swap:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$cmp, GPR64:{ *:[i64] }:$swap)<<P:Predicate_atomic_cmp_swap_i64>>  =>  (ATOMIC_CMP_SWAP_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$cmp, GPR64:{ *:[i64] }:$swap)
     /* 11477 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_CMP_SWAP_I64),
     /* 11482 */   GIR_RootConstrainSelectedInstOperands,
     /* 11483 */   // GIR_Coverage, 191,
     /* 11483 */   GIR_Done,
     /* 11484 */ // Label 431: @11484
     /* 11484 */ GIM_Reject,
     /* 11485 */ // Label 426: @11485
     /* 11485 */ GIM_Reject,
     /* 11486 */ // Label 17: @11486
     /* 11486 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 434*/ GIMT_Encode4(11655),
     /* 11497 */ /*GILLT_s32*//*Label 432*/ GIMT_Encode4(11505),
     /* 11501 */ /*GILLT_s64*//*Label 433*/ GIMT_Encode4(11617),
     /* 11505 */ // Label 432: @11505
     /* 11505 */ GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(11616),
     /* 11510 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 11513 */   GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(11547), // Rule ID 22 //
     /* 11518 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 11521 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
     /* 11528 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11532 */     // MIs[0] ptr
     /* 11532 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 11536 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11540 */     // (atomic_swap:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_swap_i8>>  =>  (ATOMIC_SWAP_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 11540 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_SWAP_I8),
     /* 11545 */     GIR_RootConstrainSelectedInstOperands,
     /* 11546 */     // GIR_Coverage, 22,
     /* 11546 */     GIR_Done,
     /* 11547 */   // Label 436: @11547
     /* 11547 */   GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(11581), // Rule ID 23 //
     /* 11552 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 11555 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
     /* 11562 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11566 */     // MIs[0] ptr
     /* 11566 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 11570 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11574 */     // (atomic_swap:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_swap_i16>>  =>  (ATOMIC_SWAP_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 11574 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_SWAP_I16),
     /* 11579 */     GIR_RootConstrainSelectedInstOperands,
     /* 11580 */     // GIR_Coverage, 23,
     /* 11580 */     GIR_Done,
     /* 11581 */   // Label 437: @11581
     /* 11581 */   GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(11615), // Rule ID 24 //
     /* 11586 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 11589 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
     /* 11596 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11600 */     // MIs[0] ptr
     /* 11600 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 11604 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11608 */     // (atomic_swap:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_swap_i32>>  =>  (ATOMIC_SWAP_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 11608 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_SWAP_I32),
     /* 11613 */     GIR_RootConstrainSelectedInstOperands,
     /* 11614 */     // GIR_Coverage, 24,
     /* 11614 */     GIR_Done,
     /* 11615 */   // Label 438: @11615
     /* 11615 */   GIM_Reject,
     /* 11616 */ // Label 435: @11616
     /* 11616 */ GIM_Reject,
     /* 11617 */ // Label 433: @11617
     /* 11617 */ GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(11654), // Rule ID 190 //
     /* 11622 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 11625 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 11628 */   GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
     /* 11635 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 11639 */   // MIs[0] ptr
     /* 11639 */   GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 11643 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 11647 */   // (atomic_swap:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_swap_i64>>  =>  (ATOMIC_SWAP_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
     /* 11647 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_SWAP_I64),
     /* 11652 */   GIR_RootConstrainSelectedInstOperands,
     /* 11653 */   // GIR_Coverage, 190,
     /* 11653 */   GIR_Done,
     /* 11654 */ // Label 439: @11654
     /* 11654 */ GIM_Reject,
     /* 11655 */ // Label 434: @11655
     /* 11655 */ GIM_Reject,
     /* 11656 */ // Label 18: @11656
     /* 11656 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 442*/ GIMT_Encode4(11825),
     /* 11667 */ /*GILLT_s32*//*Label 440*/ GIMT_Encode4(11675),
     /* 11671 */ /*GILLT_s64*//*Label 441*/ GIMT_Encode4(11787),
     /* 11675 */ // Label 440: @11675
     /* 11675 */ GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(11786),
     /* 11680 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 11683 */   GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(11717), // Rule ID 4 //
     /* 11688 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 11691 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
     /* 11698 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11702 */     // MIs[0] ptr
     /* 11702 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 11706 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11710 */     // (atomic_load_add:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_add_i8>>  =>  (ATOMIC_LOAD_ADD_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 11710 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_ADD_I8),
     /* 11715 */     GIR_RootConstrainSelectedInstOperands,
     /* 11716 */     // GIR_Coverage, 4,
     /* 11716 */     GIR_Done,
     /* 11717 */   // Label 444: @11717
     /* 11717 */   GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(11751), // Rule ID 5 //
     /* 11722 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 11725 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
     /* 11732 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11736 */     // MIs[0] ptr
     /* 11736 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 11740 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11744 */     // (atomic_load_add:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_add_i16>>  =>  (ATOMIC_LOAD_ADD_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 11744 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_ADD_I16),
     /* 11749 */     GIR_RootConstrainSelectedInstOperands,
     /* 11750 */     // GIR_Coverage, 5,
     /* 11750 */     GIR_Done,
     /* 11751 */   // Label 445: @11751
     /* 11751 */   GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(11785), // Rule ID 6 //
     /* 11756 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 11759 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
     /* 11766 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11770 */     // MIs[0] ptr
     /* 11770 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 11774 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11778 */     // (atomic_load_add:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_add_i32>>  =>  (ATOMIC_LOAD_ADD_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 11778 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_ADD_I32),
     /* 11783 */     GIR_RootConstrainSelectedInstOperands,
     /* 11784 */     // GIR_Coverage, 6,
     /* 11784 */     GIR_Done,
     /* 11785 */   // Label 446: @11785
     /* 11785 */   GIM_Reject,
     /* 11786 */ // Label 443: @11786
     /* 11786 */ GIM_Reject,
     /* 11787 */ // Label 441: @11787
     /* 11787 */ GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(11824), // Rule ID 184 //
     /* 11792 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 11795 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 11798 */   GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
     /* 11805 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 11809 */   // MIs[0] ptr
     /* 11809 */   GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 11813 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 11817 */   // (atomic_load_add:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_add_i64>>  =>  (ATOMIC_LOAD_ADD_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
     /* 11817 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_ADD_I64),
     /* 11822 */   GIR_RootConstrainSelectedInstOperands,
     /* 11823 */   // GIR_Coverage, 184,
     /* 11823 */   GIR_Done,
     /* 11824 */ // Label 447: @11824
     /* 11824 */ GIM_Reject,
     /* 11825 */ // Label 442: @11825
     /* 11825 */ GIM_Reject,
     /* 11826 */ // Label 19: @11826
     /* 11826 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 450*/ GIMT_Encode4(11995),
     /* 11837 */ /*GILLT_s32*//*Label 448*/ GIMT_Encode4(11845),
     /* 11841 */ /*GILLT_s64*//*Label 449*/ GIMT_Encode4(11957),
     /* 11845 */ // Label 448: @11845
     /* 11845 */ GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(11956),
     /* 11850 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 11853 */   GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(11887), // Rule ID 7 //
     /* 11858 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 11861 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
     /* 11868 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11872 */     // MIs[0] ptr
     /* 11872 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 11876 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11880 */     // (atomic_load_sub:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_sub_i8>>  =>  (ATOMIC_LOAD_SUB_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 11880 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_SUB_I8),
     /* 11885 */     GIR_RootConstrainSelectedInstOperands,
     /* 11886 */     // GIR_Coverage, 7,
     /* 11886 */     GIR_Done,
     /* 11887 */   // Label 452: @11887
     /* 11887 */   GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(11921), // Rule ID 8 //
     /* 11892 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 11895 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
     /* 11902 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11906 */     // MIs[0] ptr
     /* 11906 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 11910 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11914 */     // (atomic_load_sub:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_sub_i16>>  =>  (ATOMIC_LOAD_SUB_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 11914 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_SUB_I16),
     /* 11919 */     GIR_RootConstrainSelectedInstOperands,
     /* 11920 */     // GIR_Coverage, 8,
     /* 11920 */     GIR_Done,
     /* 11921 */   // Label 453: @11921
     /* 11921 */   GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(11955), // Rule ID 9 //
     /* 11926 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 11929 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
     /* 11936 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11940 */     // MIs[0] ptr
     /* 11940 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 11944 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 11948 */     // (atomic_load_sub:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_sub_i32>>  =>  (ATOMIC_LOAD_SUB_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 11948 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_SUB_I32),
     /* 11953 */     GIR_RootConstrainSelectedInstOperands,
     /* 11954 */     // GIR_Coverage, 9,
     /* 11954 */     GIR_Done,
     /* 11955 */   // Label 454: @11955
     /* 11955 */   GIM_Reject,
     /* 11956 */ // Label 451: @11956
     /* 11956 */ GIM_Reject,
     /* 11957 */ // Label 449: @11957
     /* 11957 */ GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(11994), // Rule ID 185 //
     /* 11962 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 11965 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 11968 */   GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
     /* 11975 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 11979 */   // MIs[0] ptr
     /* 11979 */   GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 11983 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 11987 */   // (atomic_load_sub:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_sub_i64>>  =>  (ATOMIC_LOAD_SUB_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
     /* 11987 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_SUB_I64),
     /* 11992 */   GIR_RootConstrainSelectedInstOperands,
     /* 11993 */   // GIR_Coverage, 185,
     /* 11993 */   GIR_Done,
     /* 11994 */ // Label 455: @11994
     /* 11994 */ GIM_Reject,
     /* 11995 */ // Label 450: @11995
     /* 11995 */ GIM_Reject,
     /* 11996 */ // Label 20: @11996
     /* 11996 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 458*/ GIMT_Encode4(12165),
     /* 12007 */ /*GILLT_s32*//*Label 456*/ GIMT_Encode4(12015),
     /* 12011 */ /*GILLT_s64*//*Label 457*/ GIMT_Encode4(12127),
     /* 12015 */ // Label 456: @12015
     /* 12015 */ GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(12126),
     /* 12020 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 12023 */   GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(12057), // Rule ID 10 //
     /* 12028 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12031 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
     /* 12038 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12042 */     // MIs[0] ptr
     /* 12042 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12046 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12050 */     // (atomic_load_and:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_and_i8>>  =>  (ATOMIC_LOAD_AND_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 12050 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_AND_I8),
     /* 12055 */     GIR_RootConstrainSelectedInstOperands,
     /* 12056 */     // GIR_Coverage, 10,
     /* 12056 */     GIR_Done,
     /* 12057 */   // Label 460: @12057
     /* 12057 */   GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(12091), // Rule ID 11 //
     /* 12062 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12065 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
     /* 12072 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12076 */     // MIs[0] ptr
     /* 12076 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12080 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12084 */     // (atomic_load_and:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_and_i16>>  =>  (ATOMIC_LOAD_AND_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 12084 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_AND_I16),
     /* 12089 */     GIR_RootConstrainSelectedInstOperands,
     /* 12090 */     // GIR_Coverage, 11,
     /* 12090 */     GIR_Done,
     /* 12091 */   // Label 461: @12091
     /* 12091 */   GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(12125), // Rule ID 12 //
     /* 12096 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12099 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
     /* 12106 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12110 */     // MIs[0] ptr
     /* 12110 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12114 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12118 */     // (atomic_load_and:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_and_i32>>  =>  (ATOMIC_LOAD_AND_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 12118 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_AND_I32),
     /* 12123 */     GIR_RootConstrainSelectedInstOperands,
     /* 12124 */     // GIR_Coverage, 12,
     /* 12124 */     GIR_Done,
     /* 12125 */   // Label 462: @12125
     /* 12125 */   GIM_Reject,
     /* 12126 */ // Label 459: @12126
     /* 12126 */ GIM_Reject,
     /* 12127 */ // Label 457: @12127
     /* 12127 */ GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(12164), // Rule ID 186 //
     /* 12132 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12135 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 12138 */   GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
     /* 12145 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 12149 */   // MIs[0] ptr
     /* 12149 */   GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12153 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 12157 */   // (atomic_load_and:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_and_i64>>  =>  (ATOMIC_LOAD_AND_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
     /* 12157 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_AND_I64),
     /* 12162 */   GIR_RootConstrainSelectedInstOperands,
     /* 12163 */   // GIR_Coverage, 186,
     /* 12163 */   GIR_Done,
     /* 12164 */ // Label 463: @12164
     /* 12164 */ GIM_Reject,
     /* 12165 */ // Label 458: @12165
     /* 12165 */ GIM_Reject,
     /* 12166 */ // Label 21: @12166
     /* 12166 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 466*/ GIMT_Encode4(12335),
     /* 12177 */ /*GILLT_s32*//*Label 464*/ GIMT_Encode4(12185),
     /* 12181 */ /*GILLT_s64*//*Label 465*/ GIMT_Encode4(12297),
     /* 12185 */ // Label 464: @12185
     /* 12185 */ GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(12296),
     /* 12190 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 12193 */   GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(12227), // Rule ID 19 //
     /* 12198 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12201 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
     /* 12208 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12212 */     // MIs[0] ptr
     /* 12212 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12216 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12220 */     // (atomic_load_nand:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_nand_i8>>  =>  (ATOMIC_LOAD_NAND_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 12220 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_NAND_I8),
     /* 12225 */     GIR_RootConstrainSelectedInstOperands,
     /* 12226 */     // GIR_Coverage, 19,
     /* 12226 */     GIR_Done,
     /* 12227 */   // Label 468: @12227
     /* 12227 */   GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(12261), // Rule ID 20 //
     /* 12232 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12235 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
     /* 12242 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12246 */     // MIs[0] ptr
     /* 12246 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12250 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12254 */     // (atomic_load_nand:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_nand_i16>>  =>  (ATOMIC_LOAD_NAND_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 12254 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_NAND_I16),
     /* 12259 */     GIR_RootConstrainSelectedInstOperands,
     /* 12260 */     // GIR_Coverage, 20,
     /* 12260 */     GIR_Done,
     /* 12261 */   // Label 469: @12261
     /* 12261 */   GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(12295), // Rule ID 21 //
     /* 12266 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12269 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
     /* 12276 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12280 */     // MIs[0] ptr
     /* 12280 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12284 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12288 */     // (atomic_load_nand:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_nand_i32>>  =>  (ATOMIC_LOAD_NAND_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 12288 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_NAND_I32),
     /* 12293 */     GIR_RootConstrainSelectedInstOperands,
     /* 12294 */     // GIR_Coverage, 21,
     /* 12294 */     GIR_Done,
     /* 12295 */   // Label 470: @12295
     /* 12295 */   GIM_Reject,
     /* 12296 */ // Label 467: @12296
     /* 12296 */ GIM_Reject,
     /* 12297 */ // Label 465: @12297
     /* 12297 */ GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(12334), // Rule ID 189 //
     /* 12302 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12305 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 12308 */   GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
     /* 12315 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 12319 */   // MIs[0] ptr
     /* 12319 */   GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12323 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 12327 */   // (atomic_load_nand:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_nand_i64>>  =>  (ATOMIC_LOAD_NAND_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
     /* 12327 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_NAND_I64),
     /* 12332 */   GIR_RootConstrainSelectedInstOperands,
     /* 12333 */   // GIR_Coverage, 189,
     /* 12333 */   GIR_Done,
     /* 12334 */ // Label 471: @12334
     /* 12334 */ GIM_Reject,
     /* 12335 */ // Label 466: @12335
     /* 12335 */ GIM_Reject,
     /* 12336 */ // Label 22: @12336
     /* 12336 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 474*/ GIMT_Encode4(12505),
     /* 12347 */ /*GILLT_s32*//*Label 472*/ GIMT_Encode4(12355),
     /* 12351 */ /*GILLT_s64*//*Label 473*/ GIMT_Encode4(12467),
     /* 12355 */ // Label 472: @12355
     /* 12355 */ GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(12466),
     /* 12360 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 12363 */   GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(12397), // Rule ID 13 //
     /* 12368 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12371 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
     /* 12378 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12382 */     // MIs[0] ptr
     /* 12382 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12386 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12390 */     // (atomic_load_or:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_or_i8>>  =>  (ATOMIC_LOAD_OR_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 12390 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_OR_I8),
     /* 12395 */     GIR_RootConstrainSelectedInstOperands,
     /* 12396 */     // GIR_Coverage, 13,
     /* 12396 */     GIR_Done,
     /* 12397 */   // Label 476: @12397
     /* 12397 */   GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(12431), // Rule ID 14 //
     /* 12402 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12405 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
     /* 12412 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12416 */     // MIs[0] ptr
     /* 12416 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12420 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12424 */     // (atomic_load_or:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_or_i16>>  =>  (ATOMIC_LOAD_OR_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 12424 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_OR_I16),
     /* 12429 */     GIR_RootConstrainSelectedInstOperands,
     /* 12430 */     // GIR_Coverage, 14,
     /* 12430 */     GIR_Done,
     /* 12431 */   // Label 477: @12431
     /* 12431 */   GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(12465), // Rule ID 15 //
     /* 12436 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12439 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
     /* 12446 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12450 */     // MIs[0] ptr
     /* 12450 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12454 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12458 */     // (atomic_load_or:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_or_i32>>  =>  (ATOMIC_LOAD_OR_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 12458 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_OR_I32),
     /* 12463 */     GIR_RootConstrainSelectedInstOperands,
     /* 12464 */     // GIR_Coverage, 15,
     /* 12464 */     GIR_Done,
     /* 12465 */   // Label 478: @12465
     /* 12465 */   GIM_Reject,
     /* 12466 */ // Label 475: @12466
     /* 12466 */ GIM_Reject,
     /* 12467 */ // Label 473: @12467
     /* 12467 */ GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(12504), // Rule ID 187 //
     /* 12472 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12475 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 12478 */   GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
     /* 12485 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 12489 */   // MIs[0] ptr
     /* 12489 */   GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12493 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 12497 */   // (atomic_load_or:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_or_i64>>  =>  (ATOMIC_LOAD_OR_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
     /* 12497 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_OR_I64),
     /* 12502 */   GIR_RootConstrainSelectedInstOperands,
     /* 12503 */   // GIR_Coverage, 187,
     /* 12503 */   GIR_Done,
     /* 12504 */ // Label 479: @12504
     /* 12504 */ GIM_Reject,
     /* 12505 */ // Label 474: @12505
     /* 12505 */ GIM_Reject,
     /* 12506 */ // Label 23: @12506
     /* 12506 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 482*/ GIMT_Encode4(12675),
     /* 12517 */ /*GILLT_s32*//*Label 480*/ GIMT_Encode4(12525),
     /* 12521 */ /*GILLT_s64*//*Label 481*/ GIMT_Encode4(12637),
     /* 12525 */ // Label 480: @12525
     /* 12525 */ GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(12636),
     /* 12530 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 12533 */   GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(12567), // Rule ID 16 //
     /* 12538 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12541 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
     /* 12548 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12552 */     // MIs[0] ptr
     /* 12552 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12556 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12560 */     // (atomic_load_xor:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_xor_i8>>  =>  (ATOMIC_LOAD_XOR_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 12560 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_XOR_I8),
     /* 12565 */     GIR_RootConstrainSelectedInstOperands,
     /* 12566 */     // GIR_Coverage, 16,
     /* 12566 */     GIR_Done,
     /* 12567 */   // Label 484: @12567
     /* 12567 */   GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(12601), // Rule ID 17 //
     /* 12572 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12575 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
     /* 12582 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12586 */     // MIs[0] ptr
     /* 12586 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12590 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12594 */     // (atomic_load_xor:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_xor_i16>>  =>  (ATOMIC_LOAD_XOR_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 12594 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_XOR_I16),
     /* 12599 */     GIR_RootConstrainSelectedInstOperands,
     /* 12600 */     // GIR_Coverage, 17,
     /* 12600 */     GIR_Done,
     /* 12601 */   // Label 485: @12601
     /* 12601 */   GIM_Try, /*On fail goto*//*Label 486*/ GIMT_Encode4(12635), // Rule ID 18 //
     /* 12606 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12609 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
     /* 12616 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12620 */     // MIs[0] ptr
     /* 12620 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12624 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12628 */     // (atomic_load_xor:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_xor_i32>>  =>  (ATOMIC_LOAD_XOR_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 12628 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_XOR_I32),
     /* 12633 */     GIR_RootConstrainSelectedInstOperands,
     /* 12634 */     // GIR_Coverage, 18,
     /* 12634 */     GIR_Done,
     /* 12635 */   // Label 486: @12635
     /* 12635 */   GIM_Reject,
     /* 12636 */ // Label 483: @12636
     /* 12636 */ GIM_Reject,
     /* 12637 */ // Label 481: @12637
     /* 12637 */ GIM_Try, /*On fail goto*//*Label 487*/ GIMT_Encode4(12674), // Rule ID 188 //
     /* 12642 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12645 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 12648 */   GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
     /* 12655 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 12659 */   // MIs[0] ptr
     /* 12659 */   GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12663 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 12667 */   // (atomic_load_xor:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_xor_i64>>  =>  (ATOMIC_LOAD_XOR_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
     /* 12667 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_XOR_I64),
     /* 12672 */   GIR_RootConstrainSelectedInstOperands,
     /* 12673 */   // GIR_Coverage, 188,
     /* 12673 */   GIR_Done,
     /* 12674 */ // Label 487: @12674
     /* 12674 */ GIM_Reject,
     /* 12675 */ // Label 482: @12675
     /* 12675 */ GIM_Reject,
     /* 12676 */ // Label 24: @12676
     /* 12676 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 490*/ GIMT_Encode4(12845),
     /* 12687 */ /*GILLT_s32*//*Label 488*/ GIMT_Encode4(12695),
     /* 12691 */ /*GILLT_s64*//*Label 489*/ GIMT_Encode4(12807),
     /* 12695 */ // Label 488: @12695
     /* 12695 */ GIM_Try, /*On fail goto*//*Label 491*/ GIMT_Encode4(12806),
     /* 12700 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 12703 */   GIM_Try, /*On fail goto*//*Label 492*/ GIMT_Encode4(12737), // Rule ID 31 //
     /* 12708 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12711 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
     /* 12718 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12722 */     // MIs[0] ptr
     /* 12722 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12726 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12730 */     // (atomic_load_max:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_max_i8>>  =>  (ATOMIC_LOAD_MAX_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 12730 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_MAX_I8),
     /* 12735 */     GIR_RootConstrainSelectedInstOperands,
     /* 12736 */     // GIR_Coverage, 31,
     /* 12736 */     GIR_Done,
     /* 12737 */   // Label 492: @12737
     /* 12737 */   GIM_Try, /*On fail goto*//*Label 493*/ GIMT_Encode4(12771), // Rule ID 32 //
     /* 12742 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12745 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
     /* 12752 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12756 */     // MIs[0] ptr
     /* 12756 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12760 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12764 */     // (atomic_load_max:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_max_i16>>  =>  (ATOMIC_LOAD_MAX_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 12764 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_MAX_I16),
     /* 12769 */     GIR_RootConstrainSelectedInstOperands,
     /* 12770 */     // GIR_Coverage, 32,
     /* 12770 */     GIR_Done,
     /* 12771 */   // Label 493: @12771
     /* 12771 */   GIM_Try, /*On fail goto*//*Label 494*/ GIMT_Encode4(12805), // Rule ID 33 //
     /* 12776 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12779 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
     /* 12786 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12790 */     // MIs[0] ptr
     /* 12790 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12794 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12798 */     // (atomic_load_max:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_max_i32>>  =>  (ATOMIC_LOAD_MAX_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 12798 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_MAX_I32),
     /* 12803 */     GIR_RootConstrainSelectedInstOperands,
     /* 12804 */     // GIR_Coverage, 33,
     /* 12804 */     GIR_Done,
     /* 12805 */   // Label 494: @12805
     /* 12805 */   GIM_Reject,
     /* 12806 */ // Label 491: @12806
     /* 12806 */ GIM_Reject,
     /* 12807 */ // Label 489: @12807
     /* 12807 */ GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(12844), // Rule ID 193 //
     /* 12812 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12815 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 12818 */   GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
     /* 12825 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 12829 */   // MIs[0] ptr
     /* 12829 */   GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12833 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 12837 */   // (atomic_load_max:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_max_i64>>  =>  (ATOMIC_LOAD_MAX_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
     /* 12837 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_MAX_I64),
     /* 12842 */   GIR_RootConstrainSelectedInstOperands,
     /* 12843 */   // GIR_Coverage, 193,
     /* 12843 */   GIR_Done,
     /* 12844 */ // Label 495: @12844
     /* 12844 */ GIM_Reject,
     /* 12845 */ // Label 490: @12845
     /* 12845 */ GIM_Reject,
     /* 12846 */ // Label 25: @12846
     /* 12846 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 498*/ GIMT_Encode4(13015),
     /* 12857 */ /*GILLT_s32*//*Label 496*/ GIMT_Encode4(12865),
     /* 12861 */ /*GILLT_s64*//*Label 497*/ GIMT_Encode4(12977),
     /* 12865 */ // Label 496: @12865
     /* 12865 */ GIM_Try, /*On fail goto*//*Label 499*/ GIMT_Encode4(12976),
     /* 12870 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 12873 */   GIM_Try, /*On fail goto*//*Label 500*/ GIMT_Encode4(12907), // Rule ID 28 //
     /* 12878 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12881 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
     /* 12888 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12892 */     // MIs[0] ptr
     /* 12892 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12896 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12900 */     // (atomic_load_min:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_min_i8>>  =>  (ATOMIC_LOAD_MIN_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 12900 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_MIN_I8),
     /* 12905 */     GIR_RootConstrainSelectedInstOperands,
     /* 12906 */     // GIR_Coverage, 28,
     /* 12906 */     GIR_Done,
     /* 12907 */   // Label 500: @12907
     /* 12907 */   GIM_Try, /*On fail goto*//*Label 501*/ GIMT_Encode4(12941), // Rule ID 29 //
     /* 12912 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12915 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
     /* 12922 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12926 */     // MIs[0] ptr
     /* 12926 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12930 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12934 */     // (atomic_load_min:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_min_i16>>  =>  (ATOMIC_LOAD_MIN_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 12934 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_MIN_I16),
     /* 12939 */     GIR_RootConstrainSelectedInstOperands,
     /* 12940 */     // GIR_Coverage, 29,
     /* 12940 */     GIR_Done,
     /* 12941 */   // Label 501: @12941
     /* 12941 */   GIM_Try, /*On fail goto*//*Label 502*/ GIMT_Encode4(12975), // Rule ID 30 //
     /* 12946 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12949 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
     /* 12956 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12960 */     // MIs[0] ptr
     /* 12960 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 12964 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 12968 */     // (atomic_load_min:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_min_i32>>  =>  (ATOMIC_LOAD_MIN_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 12968 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_MIN_I32),
     /* 12973 */     GIR_RootConstrainSelectedInstOperands,
     /* 12974 */     // GIR_Coverage, 30,
     /* 12974 */     GIR_Done,
     /* 12975 */   // Label 502: @12975
     /* 12975 */   GIM_Reject,
     /* 12976 */ // Label 499: @12976
     /* 12976 */ GIM_Reject,
     /* 12977 */ // Label 497: @12977
     /* 12977 */ GIM_Try, /*On fail goto*//*Label 503*/ GIMT_Encode4(13014), // Rule ID 192 //
     /* 12982 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 12985 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 12988 */   GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
     /* 12995 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 12999 */   // MIs[0] ptr
     /* 12999 */   GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 13003 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 13007 */   // (atomic_load_min:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_min_i64>>  =>  (ATOMIC_LOAD_MIN_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
     /* 13007 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_MIN_I64),
     /* 13012 */   GIR_RootConstrainSelectedInstOperands,
     /* 13013 */   // GIR_Coverage, 192,
     /* 13013 */   GIR_Done,
     /* 13014 */ // Label 503: @13014
     /* 13014 */ GIM_Reject,
     /* 13015 */ // Label 498: @13015
     /* 13015 */ GIM_Reject,
     /* 13016 */ // Label 26: @13016
     /* 13016 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 506*/ GIMT_Encode4(13185),
     /* 13027 */ /*GILLT_s32*//*Label 504*/ GIMT_Encode4(13035),
     /* 13031 */ /*GILLT_s64*//*Label 505*/ GIMT_Encode4(13147),
     /* 13035 */ // Label 504: @13035
     /* 13035 */ GIM_Try, /*On fail goto*//*Label 507*/ GIMT_Encode4(13146),
     /* 13040 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 13043 */   GIM_Try, /*On fail goto*//*Label 508*/ GIMT_Encode4(13077), // Rule ID 37 //
     /* 13048 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 13051 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
     /* 13058 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 13062 */     // MIs[0] ptr
     /* 13062 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 13066 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 13070 */     // (atomic_load_umax:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_umax_i8>>  =>  (ATOMIC_LOAD_UMAX_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 13070 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_UMAX_I8),
     /* 13075 */     GIR_RootConstrainSelectedInstOperands,
     /* 13076 */     // GIR_Coverage, 37,
     /* 13076 */     GIR_Done,
     /* 13077 */   // Label 508: @13077
     /* 13077 */   GIM_Try, /*On fail goto*//*Label 509*/ GIMT_Encode4(13111), // Rule ID 38 //
     /* 13082 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 13085 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
     /* 13092 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 13096 */     // MIs[0] ptr
     /* 13096 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 13100 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 13104 */     // (atomic_load_umax:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_umax_i16>>  =>  (ATOMIC_LOAD_UMAX_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 13104 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_UMAX_I16),
     /* 13109 */     GIR_RootConstrainSelectedInstOperands,
     /* 13110 */     // GIR_Coverage, 38,
     /* 13110 */     GIR_Done,
     /* 13111 */   // Label 509: @13111
     /* 13111 */   GIM_Try, /*On fail goto*//*Label 510*/ GIMT_Encode4(13145), // Rule ID 39 //
     /* 13116 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 13119 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
     /* 13126 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 13130 */     // MIs[0] ptr
     /* 13130 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 13134 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 13138 */     // (atomic_load_umax:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_umax_i32>>  =>  (ATOMIC_LOAD_UMAX_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 13138 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_UMAX_I32),
     /* 13143 */     GIR_RootConstrainSelectedInstOperands,
     /* 13144 */     // GIR_Coverage, 39,
     /* 13144 */     GIR_Done,
     /* 13145 */   // Label 510: @13145
     /* 13145 */   GIM_Reject,
     /* 13146 */ // Label 507: @13146
     /* 13146 */ GIM_Reject,
     /* 13147 */ // Label 505: @13147
     /* 13147 */ GIM_Try, /*On fail goto*//*Label 511*/ GIMT_Encode4(13184), // Rule ID 195 //
     /* 13152 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 13155 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 13158 */   GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
     /* 13165 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 13169 */   // MIs[0] ptr
     /* 13169 */   GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 13173 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 13177 */   // (atomic_load_umax:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_umax_i64>>  =>  (ATOMIC_LOAD_UMAX_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
     /* 13177 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_UMAX_I64),
     /* 13182 */   GIR_RootConstrainSelectedInstOperands,
     /* 13183 */   // GIR_Coverage, 195,
     /* 13183 */   GIR_Done,
     /* 13184 */ // Label 511: @13184
     /* 13184 */ GIM_Reject,
     /* 13185 */ // Label 506: @13185
     /* 13185 */ GIM_Reject,
     /* 13186 */ // Label 27: @13186
     /* 13186 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 514*/ GIMT_Encode4(13355),
     /* 13197 */ /*GILLT_s32*//*Label 512*/ GIMT_Encode4(13205),
     /* 13201 */ /*GILLT_s64*//*Label 513*/ GIMT_Encode4(13317),
     /* 13205 */ // Label 512: @13205
     /* 13205 */ GIM_Try, /*On fail goto*//*Label 515*/ GIMT_Encode4(13316),
     /* 13210 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 13213 */   GIM_Try, /*On fail goto*//*Label 516*/ GIMT_Encode4(13247), // Rule ID 34 //
     /* 13218 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 13221 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
     /* 13228 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 13232 */     // MIs[0] ptr
     /* 13232 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 13236 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 13240 */     // (atomic_load_umin:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_umin_i8>>  =>  (ATOMIC_LOAD_UMIN_I8:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 13240 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_UMIN_I8),
     /* 13245 */     GIR_RootConstrainSelectedInstOperands,
     /* 13246 */     // GIR_Coverage, 34,
     /* 13246 */     GIR_Done,
     /* 13247 */   // Label 516: @13247
     /* 13247 */   GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(13281), // Rule ID 35 //
     /* 13252 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 13255 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
     /* 13262 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 13266 */     // MIs[0] ptr
     /* 13266 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 13270 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 13274 */     // (atomic_load_umin:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_umin_i16>>  =>  (ATOMIC_LOAD_UMIN_I16:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 13274 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_UMIN_I16),
     /* 13279 */     GIR_RootConstrainSelectedInstOperands,
     /* 13280 */     // GIR_Coverage, 35,
     /* 13280 */     GIR_Done,
     /* 13281 */   // Label 517: @13281
     /* 13281 */   GIM_Try, /*On fail goto*//*Label 518*/ GIMT_Encode4(13315), // Rule ID 36 //
     /* 13286 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 13289 */     GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(4),
     /* 13296 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 13300 */     // MIs[0] ptr
     /* 13300 */     GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 13304 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 13308 */     // (atomic_load_umin:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)<<P:Predicate_atomic_load_umin_i32>>  =>  (ATOMIC_LOAD_UMIN_I32:{ *:[i32] } iPTR:{ *:[iPTR] }:$ptr, GPR32:{ *:[i32] }:$incr)
     /* 13308 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_UMIN_I32),
     /* 13313 */     GIR_RootConstrainSelectedInstOperands,
     /* 13314 */     // GIR_Coverage, 36,
     /* 13314 */     GIR_Done,
     /* 13315 */   // Label 518: @13315
     /* 13315 */   GIM_Reject,
     /* 13316 */ // Label 515: @13316
     /* 13316 */ GIM_Reject,
     /* 13317 */ // Label 513: @13317
     /* 13317 */ GIM_Try, /*On fail goto*//*Label 519*/ GIMT_Encode4(13354), // Rule ID 194 //
     /* 13322 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotInMips16Mode),
     /* 13325 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 13328 */   GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(8),
     /* 13335 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 13339 */   // MIs[0] ptr
     /* 13339 */   GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/0,
     /* 13343 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 13347 */   // (atomic_load_umin:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)<<P:Predicate_atomic_load_umin_i64>>  =>  (ATOMIC_LOAD_UMIN_I64:{ *:[i64] } iPTR:{ *:[iPTR] }:$ptr, GPR64:{ *:[i64] }:$incr)
     /* 13347 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::ATOMIC_LOAD_UMIN_I64),
     /* 13352 */   GIR_RootConstrainSelectedInstOperands,
     /* 13353 */   // GIR_Coverage, 194,
     /* 13353 */   GIR_Done,
     /* 13354 */ // Label 519: @13354
     /* 13354 */ GIM_Reject,
     /* 13355 */ // Label 514: @13355
     /* 13355 */ GIM_Reject,
     /* 13356 */ // Label 28: @13356
     /* 13356 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(3), /*)*//*default:*//*Label 522*/ GIMT_Encode4(18076),
     /* 13367 */ /*GILLT_s32*//*Label 520*/ GIMT_Encode4(13375),
     /* 13371 */ /*GILLT_s64*//*Label 521*/ GIMT_Encode4(18042),
     /* 13375 */ // Label 520: @13375
     /* 13375 */ GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(13483), // Rule ID 2365 //
     /* 13380 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
     /* 13383 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 13387 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 13391 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 13395 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 13399 */   // MIs[1] Operand 1
     /* 13399 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
     /* 13404 */   GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 13408 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /* 13412 */   GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /* 13416 */   GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /* 13420 */   GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /* 13424 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
     /* 13428 */   GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
     /* 13432 */   GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /* 13436 */   GIM_CheckConstantInt8, /*MI*/3, /*Op*/1, 1,
     /* 13440 */   GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /* 13444 */   GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 13448 */   GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
     /* 13452 */   // MIs[4] Operand 1
     /* 13452 */   // No operand predicates
     /* 13452 */   GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 13457 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 13461 */   // MIs[0] offset
     /* 13461 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 13464 */   GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /* 13466 */   // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p), GPR64Opnd:{ *:[i64] }:$rs), 0:{ *:[i64] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT0 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
     /* 13466 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT0),
     /* 13469 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs
     /* 13473 */   GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
     /* 13476 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 13478 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 13481 */   GIR_RootConstrainSelectedInstOperands,
     /* 13482 */   // GIR_Coverage, 2365,
     /* 13482 */   GIR_EraseRootFromParent_Done,
     /* 13483 */ // Label 523: @13483
     /* 13483 */ GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(13598), // Rule ID 2366 //
     /* 13488 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
     /* 13491 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 13495 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 13499 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 13503 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 13507 */   // MIs[1] Operand 1
     /* 13507 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
     /* 13512 */   GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 13516 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /* 13520 */   GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /* 13524 */   GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /* 13528 */   GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /* 13532 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
     /* 13536 */   GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
     /* 13540 */   GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /* 13544 */   GIM_CheckConstantInt, /*MI*/3, /*Op*/1, GIMT_Encode8(4294967296),
     /* 13555 */   GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /* 13559 */   GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 13563 */   GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
     /* 13567 */   // MIs[4] Operand 1
     /* 13567 */   // No operand predicates
     /* 13567 */   GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 13572 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 13576 */   // MIs[0] offset
     /* 13576 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 13579 */   GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /* 13581 */   // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } (shl:{ *:[i64] } 4294967296:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p), GPR64Opnd:{ *:[i64] }:$rs), 0:{ *:[i64] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT032 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
     /* 13581 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT032),
     /* 13584 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs
     /* 13588 */   GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
     /* 13591 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 13593 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 13596 */   GIR_RootConstrainSelectedInstOperands,
     /* 13597 */   // GIR_Coverage, 2366,
     /* 13597 */   GIR_EraseRootFromParent_Done,
     /* 13598 */ // Label 524: @13598
     /* 13598 */ GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(13706), // Rule ID 2367 //
     /* 13603 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
     /* 13606 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 13610 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 13614 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 13618 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 13622 */   // MIs[1] Operand 1
     /* 13622 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
     /* 13627 */   GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 13631 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /* 13635 */   GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /* 13639 */   GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /* 13643 */   GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /* 13647 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
     /* 13651 */   GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
     /* 13655 */   GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /* 13659 */   GIM_CheckConstantInt8, /*MI*/3, /*Op*/1, 1,
     /* 13663 */   GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /* 13667 */   GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 13671 */   GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
     /* 13675 */   // MIs[4] Operand 1
     /* 13675 */   // No operand predicates
     /* 13675 */   GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 13680 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 13684 */   // MIs[0] offset
     /* 13684 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 13687 */   GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /* 13689 */   // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p), GPR64Opnd:{ *:[i64] }:$rs), 0:{ *:[i64] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT1 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
     /* 13689 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT1),
     /* 13692 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs
     /* 13696 */   GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
     /* 13699 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 13701 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 13704 */   GIR_RootConstrainSelectedInstOperands,
     /* 13705 */   // GIR_Coverage, 2367,
     /* 13705 */   GIR_EraseRootFromParent_Done,
     /* 13706 */ // Label 525: @13706
     /* 13706 */ GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(13821), // Rule ID 2368 //
     /* 13711 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
     /* 13714 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 13718 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 13722 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 13726 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 13730 */   // MIs[1] Operand 1
     /* 13730 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
     /* 13735 */   GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 13739 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /* 13743 */   GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /* 13747 */   GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /* 13751 */   GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /* 13755 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
     /* 13759 */   GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
     /* 13763 */   GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /* 13767 */   GIM_CheckConstantInt, /*MI*/3, /*Op*/1, GIMT_Encode8(4294967296),
     /* 13778 */   GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /* 13782 */   GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 13786 */   GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
     /* 13790 */   // MIs[4] Operand 1
     /* 13790 */   // No operand predicates
     /* 13790 */   GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 13795 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 13799 */   // MIs[0] offset
     /* 13799 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 13802 */   GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /* 13804 */   // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } (shl:{ *:[i64] } 4294967296:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p), GPR64Opnd:{ *:[i64] }:$rs), 0:{ *:[i64] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT132 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
     /* 13804 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT132),
     /* 13807 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // rs
     /* 13811 */   GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
     /* 13814 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 13816 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 13819 */   GIR_RootConstrainSelectedInstOperands,
     /* 13820 */   // GIR_Coverage, 2368,
     /* 13820 */   GIR_EraseRootFromParent_Done,
     /* 13821 */ // Label 526: @13821
     /* 13821 */ GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(13929), // Rule ID 270 //
     /* 13826 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
     /* 13829 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 13833 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 13837 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 13841 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 13845 */   // MIs[1] Operand 1
     /* 13845 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
     /* 13850 */   GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 13854 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /* 13858 */   GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /* 13862 */   GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /* 13866 */   GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 13871 */   GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /* 13875 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
     /* 13879 */   GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
     /* 13883 */   GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /* 13887 */   GIM_CheckConstantInt8, /*MI*/3, /*Op*/1, 1,
     /* 13891 */   GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /* 13895 */   GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 13899 */   GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
     /* 13903 */   // MIs[4] Operand 1
     /* 13903 */   // No operand predicates
     /* 13903 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 13907 */   // MIs[0] offset
     /* 13907 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 13910 */   GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /* 13912 */   // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (shl:{ *:[i64] } 1:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p)), 0:{ *:[i64] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT0 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
     /* 13912 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT0),
     /* 13915 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs
     /* 13919 */   GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
     /* 13922 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 13924 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 13927 */   GIR_RootConstrainSelectedInstOperands,
     /* 13928 */   // GIR_Coverage, 270,
     /* 13928 */   GIR_EraseRootFromParent_Done,
     /* 13929 */ // Label 527: @13929
     /* 13929 */ GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(14044), // Rule ID 271 //
     /* 13934 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
     /* 13937 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 13941 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 13945 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 13949 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 13953 */   // MIs[1] Operand 1
     /* 13953 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
     /* 13958 */   GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 13962 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /* 13966 */   GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /* 13970 */   GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /* 13974 */   GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 13979 */   GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /* 13983 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
     /* 13987 */   GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
     /* 13991 */   GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /* 13995 */   GIM_CheckConstantInt, /*MI*/3, /*Op*/1, GIMT_Encode8(4294967296),
     /* 14006 */   GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /* 14010 */   GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 14014 */   GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
     /* 14018 */   // MIs[4] Operand 1
     /* 14018 */   // No operand predicates
     /* 14018 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 14022 */   // MIs[0] offset
     /* 14022 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 14025 */   GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /* 14027 */   // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (shl:{ *:[i64] } 4294967296:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p)), 0:{ *:[i64] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT032 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
     /* 14027 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT032),
     /* 14030 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs
     /* 14034 */   GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
     /* 14037 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 14039 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 14042 */   GIR_RootConstrainSelectedInstOperands,
     /* 14043 */   // GIR_Coverage, 271,
     /* 14043 */   GIR_EraseRootFromParent_Done,
     /* 14044 */ // Label 528: @14044
     /* 14044 */ GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(14152), // Rule ID 272 //
     /* 14049 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
     /* 14052 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 14056 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 14060 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 14064 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 14068 */   // MIs[1] Operand 1
     /* 14068 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
     /* 14073 */   GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 14077 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /* 14081 */   GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /* 14085 */   GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /* 14089 */   GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 14094 */   GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /* 14098 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
     /* 14102 */   GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
     /* 14106 */   GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /* 14110 */   GIM_CheckConstantInt8, /*MI*/3, /*Op*/1, 1,
     /* 14114 */   GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /* 14118 */   GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 14122 */   GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
     /* 14126 */   // MIs[4] Operand 1
     /* 14126 */   // No operand predicates
     /* 14126 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 14130 */   // MIs[0] offset
     /* 14130 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 14133 */   GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /* 14135 */   // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (shl:{ *:[i64] } 1:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p)), 0:{ *:[i64] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT1 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
     /* 14135 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT1),
     /* 14138 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs
     /* 14142 */   GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
     /* 14145 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 14147 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 14150 */   GIR_RootConstrainSelectedInstOperands,
     /* 14151 */   // GIR_Coverage, 272,
     /* 14151 */   GIR_EraseRootFromParent_Done,
     /* 14152 */ // Label 529: @14152
     /* 14152 */ GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(14267), // Rule ID 273 //
     /* 14157 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCnMips),
     /* 14160 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 14164 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 14168 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 14172 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 14176 */   // MIs[1] Operand 1
     /* 14176 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
     /* 14181 */   GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 14185 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /* 14189 */   GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /* 14193 */   GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /* 14197 */   GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 14202 */   GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /* 14206 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
     /* 14210 */   GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
     /* 14214 */   GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /* 14218 */   GIM_CheckConstantInt, /*MI*/3, /*Op*/1, GIMT_Encode8(4294967296),
     /* 14229 */   GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /* 14233 */   GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 14237 */   GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5_64),
     /* 14241 */   // MIs[4] Operand 1
     /* 14241 */   // No operand predicates
     /* 14241 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 14245 */   // MIs[0] offset
     /* 14245 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 14248 */   GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /* 14250 */   // (brcond (setcc:{ *:[i32] } (and:{ *:[i64] } GPR64Opnd:{ *:[i64] }:$rs, (shl:{ *:[i64] } 4294967296:{ *:[i64] }, (imm:{ *:[i64] })<<P:Predicate_immZExt5_64>>:$p)), 0:{ *:[i64] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BBIT132 GPR64Opnd:{ *:[i64] }:$rs, (imm:{ *:[i64] }):$p, (bb:{ *:[Other] }):$offset)
     /* 14250 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BBIT132),
     /* 14253 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs
     /* 14257 */   GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // p
     /* 14260 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 14262 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 14265 */   GIR_RootConstrainSelectedInstOperands,
     /* 14266 */   // GIR_Coverage, 273,
     /* 14266 */   GIR_EraseRootFromParent_Done,
     /* 14267 */ // Label 530: @14267
     /* 14267 */ GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(14324), // Rule ID 94 //
     /* 14272 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /* 14275 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 14279 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 14283 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 14287 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 14291 */   // MIs[1] Operand 1
     /* 14291 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
     /* 14296 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 14301 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 14305 */   // MIs[0] offset
     /* 14305 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 14308 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 14310 */   // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BGEZ GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
     /* 14310 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGEZ),
     /* 14313 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
     /* 14317 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 14319 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 14322 */   GIR_RootConstrainSelectedInstOperands,
     /* 14323 */   // GIR_Coverage, 94,
     /* 14323 */   GIR_EraseRootFromParent_Done,
     /* 14324 */ // Label 531: @14324
     /* 14324 */ GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(14381), // Rule ID 95 //
     /* 14329 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /* 14332 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 14336 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 14340 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 14344 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 14348 */   // MIs[1] Operand 1
     /* 14348 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
     /* 14353 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 14358 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 14362 */   // MIs[0] offset
     /* 14362 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 14365 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 14367 */   // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BGTZ GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
     /* 14367 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGTZ),
     /* 14370 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
     /* 14374 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 14376 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 14379 */   GIR_RootConstrainSelectedInstOperands,
     /* 14380 */   // GIR_Coverage, 95,
     /* 14380 */   GIR_EraseRootFromParent_Done,
     /* 14381 */ // Label 532: @14381
     /* 14381 */ GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(14438), // Rule ID 96 //
     /* 14386 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /* 14389 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 14393 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 14397 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 14401 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 14405 */   // MIs[1] Operand 1
     /* 14405 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
     /* 14410 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 14415 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 14419 */   // MIs[0] offset
     /* 14419 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 14422 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 14424 */   // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BLEZ GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
     /* 14424 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLEZ),
     /* 14427 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
     /* 14431 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 14433 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 14436 */   GIR_RootConstrainSelectedInstOperands,
     /* 14437 */   // GIR_Coverage, 96,
     /* 14437 */   GIR_EraseRootFromParent_Done,
     /* 14438 */ // Label 533: @14438
     /* 14438 */ GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(14495), // Rule ID 97 //
     /* 14443 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /* 14446 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 14450 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 14454 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 14458 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 14462 */   // MIs[1] Operand 1
     /* 14462 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
     /* 14467 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 14472 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 14476 */   // MIs[0] offset
     /* 14476 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 14479 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 14481 */   // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BLTZ GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
     /* 14481 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLTZ),
     /* 14484 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
     /* 14488 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 14490 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 14493 */   GIR_RootConstrainSelectedInstOperands,
     /* 14494 */   // GIR_Coverage, 97,
     /* 14494 */   GIR_EraseRootFromParent_Done,
     /* 14495 */ // Label 534: @14495
     /* 14495 */ GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(14552), // Rule ID 245 //
     /* 14500 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
     /* 14503 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 14507 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 14511 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 14515 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 14519 */   // MIs[1] Operand 1
     /* 14519 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
     /* 14524 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 14529 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 14533 */   // MIs[0] offset
     /* 14533 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 14536 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 14538 */   // (brcond (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, 0:{ *:[i64] }, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BGEZ64 GPR64Opnd:{ *:[i64] }:$rs, (bb:{ *:[Other] }):$offset)
     /* 14538 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGEZ64),
     /* 14541 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
     /* 14545 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 14547 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 14550 */   GIR_RootConstrainSelectedInstOperands,
     /* 14551 */   // GIR_Coverage, 245,
     /* 14551 */   GIR_EraseRootFromParent_Done,
     /* 14552 */ // Label 535: @14552
     /* 14552 */ GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(14609), // Rule ID 246 //
     /* 14557 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
     /* 14560 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 14564 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 14568 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 14572 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 14576 */   // MIs[1] Operand 1
     /* 14576 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
     /* 14581 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 14586 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 14590 */   // MIs[0] offset
     /* 14590 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 14593 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 14595 */   // (brcond (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, 0:{ *:[i64] }, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BGTZ64 GPR64Opnd:{ *:[i64] }:$rs, (bb:{ *:[Other] }):$offset)
     /* 14595 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGTZ64),
     /* 14598 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
     /* 14602 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 14604 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 14607 */   GIR_RootConstrainSelectedInstOperands,
     /* 14608 */   // GIR_Coverage, 246,
     /* 14608 */   GIR_EraseRootFromParent_Done,
     /* 14609 */ // Label 536: @14609
     /* 14609 */ GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(14666), // Rule ID 247 //
     /* 14614 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
     /* 14617 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 14621 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 14625 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 14629 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 14633 */   // MIs[1] Operand 1
     /* 14633 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
     /* 14638 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 14643 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 14647 */   // MIs[0] offset
     /* 14647 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 14650 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 14652 */   // (brcond (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, 0:{ *:[i64] }, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BLEZ64 GPR64Opnd:{ *:[i64] }:$rs, (bb:{ *:[Other] }):$offset)
     /* 14652 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLEZ64),
     /* 14655 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
     /* 14659 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 14661 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 14664 */   GIR_RootConstrainSelectedInstOperands,
     /* 14665 */   // GIR_Coverage, 247,
     /* 14665 */   GIR_EraseRootFromParent_Done,
     /* 14666 */ // Label 537: @14666
     /* 14666 */ GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(14723), // Rule ID 248 //
     /* 14671 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
     /* 14674 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 14678 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 14682 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 14686 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 14690 */   // MIs[1] Operand 1
     /* 14690 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
     /* 14695 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 14700 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 14704 */   // MIs[0] offset
     /* 14704 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 14707 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 14709 */   // (brcond (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, 0:{ *:[i64] }, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BLTZ64 GPR64Opnd:{ *:[i64] }:$rs, (bb:{ *:[Other] }):$offset)
     /* 14709 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLTZ64),
     /* 14712 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
     /* 14716 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 14718 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 14721 */   GIR_RootConstrainSelectedInstOperands,
     /* 14722 */   // GIR_Coverage, 248,
     /* 14722 */   GIR_EraseRootFromParent_Done,
     /* 14723 */ // Label 538: @14723
     /* 14723 */ GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(14780), // Rule ID 1109 //
     /* 14728 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /* 14731 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 14735 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 14739 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 14743 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 14747 */   // MIs[1] Operand 1
     /* 14747 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
     /* 14752 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 14757 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 14761 */   // MIs[0] offset
     /* 14761 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 14764 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 14766 */   // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BGEZ_MM GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
     /* 14766 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGEZ_MM),
     /* 14769 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
     /* 14773 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 14775 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 14778 */   GIR_RootConstrainSelectedInstOperands,
     /* 14779 */   // GIR_Coverage, 1109,
     /* 14779 */   GIR_EraseRootFromParent_Done,
     /* 14780 */ // Label 539: @14780
     /* 14780 */ GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(14837), // Rule ID 1110 //
     /* 14785 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /* 14788 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 14792 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 14796 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 14800 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 14804 */   // MIs[1] Operand 1
     /* 14804 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
     /* 14809 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 14814 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 14818 */   // MIs[0] offset
     /* 14818 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 14821 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 14823 */   // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BGTZ_MM GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
     /* 14823 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGTZ_MM),
     /* 14826 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
     /* 14830 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 14832 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 14835 */   GIR_RootConstrainSelectedInstOperands,
     /* 14836 */   // GIR_Coverage, 1110,
     /* 14836 */   GIR_EraseRootFromParent_Done,
     /* 14837 */ // Label 540: @14837
     /* 14837 */ GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(14894), // Rule ID 1111 //
     /* 14842 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /* 14845 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 14849 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 14853 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 14857 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 14861 */   // MIs[1] Operand 1
     /* 14861 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
     /* 14866 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 14871 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 14875 */   // MIs[0] offset
     /* 14875 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 14878 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 14880 */   // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BLEZ_MM GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
     /* 14880 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLEZ_MM),
     /* 14883 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
     /* 14887 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 14889 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 14892 */   GIR_RootConstrainSelectedInstOperands,
     /* 14893 */   // GIR_Coverage, 1111,
     /* 14893 */   GIR_EraseRootFromParent_Done,
     /* 14894 */ // Label 541: @14894
     /* 14894 */ GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(14951), // Rule ID 1112 //
     /* 14899 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /* 14902 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 14906 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 14910 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 14914 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 14918 */   // MIs[1] Operand 1
     /* 14918 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
     /* 14923 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 14928 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 14932 */   // MIs[0] offset
     /* 14932 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 14935 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 14937 */   // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, 0:{ *:[i32] }, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BLTZ_MM GPR32Opnd:{ *:[i32] }:$rs, (bb:{ *:[Other] }):$offset)
     /* 14937 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLTZ_MM),
     /* 14940 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
     /* 14944 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 14946 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 14949 */   GIR_RootConstrainSelectedInstOperands,
     /* 14950 */   // GIR_Coverage, 1112,
     /* 14950 */   GIR_EraseRootFromParent_Done,
     /* 14951 */ // Label 542: @14951
     /* 14951 */ GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(15014), // Rule ID 1402 //
     /* 14956 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /* 14959 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 14963 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 14967 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 14971 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 14975 */   // MIs[1] Operand 1
     /* 14975 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
     /* 14980 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 14985 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 14989 */   // MIs[0] dst
     /* 14989 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 14992 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 14994 */   // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BNE GPR32:{ *:[i32] }:$lhs, ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
     /* 14994 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE),
     /* 14997 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 15001 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 15007 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 15009 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 15012 */   GIR_RootConstrainSelectedInstOperands,
     /* 15013 */   // GIR_Coverage, 1402,
     /* 15013 */   GIR_EraseRootFromParent_Done,
     /* 15014 */ // Label 543: @15014
     /* 15014 */ GIM_Try, /*On fail goto*//*Label 544*/ GIMT_Encode4(15077), // Rule ID 1403 //
     /* 15019 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /* 15022 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 15026 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 15030 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 15034 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 15038 */   // MIs[1] Operand 1
     /* 15038 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
     /* 15043 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 15048 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 15052 */   // MIs[0] dst
     /* 15052 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 15055 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 15057 */   // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ GPR32:{ *:[i32] }:$lhs, ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
     /* 15057 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
     /* 15060 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 15064 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 15070 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 15072 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 15075 */   GIR_RootConstrainSelectedInstOperands,
     /* 15076 */   // GIR_Coverage, 1403,
     /* 15076 */   GIR_EraseRootFromParent_Done,
     /* 15077 */ // Label 544: @15077
     /* 15077 */ GIM_Try, /*On fail goto*//*Label 545*/ GIMT_Encode4(15140), // Rule ID 1548 //
     /* 15082 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
     /* 15085 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 15089 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 15093 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 15097 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 15101 */   // MIs[1] Operand 1
     /* 15101 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
     /* 15106 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 15111 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 15115 */   // MIs[0] dst
     /* 15115 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 15118 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 15120 */   // (brcond (setcc:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, 0:{ *:[i64] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BNE64 GPR64:{ *:[i64] }:$lhs, ZERO_64:{ *:[i64] }, (bb:{ *:[Other] }):$dst)
     /* 15120 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE64),
     /* 15123 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 15127 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO_64), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 15133 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 15135 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 15138 */   GIR_RootConstrainSelectedInstOperands,
     /* 15139 */   // GIR_Coverage, 1548,
     /* 15139 */   GIR_EraseRootFromParent_Done,
     /* 15140 */ // Label 545: @15140
     /* 15140 */ GIM_Try, /*On fail goto*//*Label 546*/ GIMT_Encode4(15203), // Rule ID 1549 //
     /* 15145 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
     /* 15148 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 15152 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 15156 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 15160 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 15164 */   // MIs[1] Operand 1
     /* 15164 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
     /* 15169 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 15174 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 15178 */   // MIs[0] dst
     /* 15178 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 15181 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 15183 */   // (brcond (setcc:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, 0:{ *:[i64] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ64 GPR64:{ *:[i64] }:$lhs, ZERO_64:{ *:[i64] }, (bb:{ *:[Other] }):$dst)
     /* 15183 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ64),
     /* 15186 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 15190 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO_64), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 15196 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 15198 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 15201 */   GIR_RootConstrainSelectedInstOperands,
     /* 15202 */   // GIR_Coverage, 1549,
     /* 15202 */   GIR_EraseRootFromParent_Done,
     /* 15203 */ // Label 546: @15203
     /* 15203 */ GIM_Try, /*On fail goto*//*Label 547*/ GIMT_Encode4(15257), // Rule ID 1856 //
     /* 15208 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
     /* 15211 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 15215 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 15219 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 15223 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 15227 */   // MIs[1] Operand 1
     /* 15227 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
     /* 15232 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /* 15237 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 15241 */   // MIs[0] targ16
     /* 15241 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 15244 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 15246 */   // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, 0:{ *:[i32] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$targ16)  =>  (BeqzRxImm16 CPU16Regs:{ *:[i32] }:$rx, (bb:{ *:[Other] }):$targ16)
     /* 15246 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BeqzRxImm16),
     /* 15249 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
     /* 15253 */   GIR_RootToRootCopy, /*OpIdx*/1, // targ16
     /* 15255 */   GIR_RootConstrainSelectedInstOperands,
     /* 15256 */   // GIR_Coverage, 1856,
     /* 15256 */   GIR_EraseRootFromParent_Done,
     /* 15257 */ // Label 547: @15257
     /* 15257 */ GIM_Try, /*On fail goto*//*Label 548*/ GIMT_Encode4(15311), // Rule ID 1865 //
     /* 15262 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
     /* 15265 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 15269 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 15273 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 15277 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 15281 */   // MIs[1] Operand 1
     /* 15281 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
     /* 15286 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /* 15291 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 15295 */   // MIs[0] targ16
     /* 15295 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 15298 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 15300 */   // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, 0:{ *:[i32] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$targ16)  =>  (BnezRxImm16 CPU16Regs:{ *:[i32] }:$rx, (bb:{ *:[Other] }):$targ16)
     /* 15300 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BnezRxImm16),
     /* 15303 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
     /* 15307 */   GIR_RootToRootCopy, /*OpIdx*/1, // targ16
     /* 15309 */   GIR_RootConstrainSelectedInstOperands,
     /* 15310 */   // GIR_Coverage, 1865,
     /* 15310 */   GIR_EraseRootFromParent_Done,
     /* 15311 */ // Label 548: @15311
     /* 15311 */ GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(15374), // Rule ID 2195 //
     /* 15316 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /* 15319 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 15323 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 15327 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 15331 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 15335 */   // MIs[1] Operand 1
     /* 15335 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
     /* 15340 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 15345 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 15349 */   // MIs[0] dst
     /* 15349 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 15352 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 15354 */   // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BNE_MM GPR32:{ *:[i32] }:$lhs, ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
     /* 15354 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE_MM),
     /* 15357 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 15361 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 15367 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 15369 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 15372 */   GIR_RootConstrainSelectedInstOperands,
     /* 15373 */   // GIR_Coverage, 2195,
     /* 15373 */   GIR_EraseRootFromParent_Done,
     /* 15374 */ // Label 549: @15374
     /* 15374 */ GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(15437), // Rule ID 2196 //
     /* 15379 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /* 15382 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 15386 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 15390 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 15394 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 15398 */   // MIs[1] Operand 1
     /* 15398 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
     /* 15403 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 15408 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 15412 */   // MIs[0] dst
     /* 15412 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 15415 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 15417 */   // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ_MM GPR32:{ *:[i32] }:$lhs, ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
     /* 15417 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ_MM),
     /* 15420 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 15424 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 15430 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 15432 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 15435 */   GIR_RootConstrainSelectedInstOperands,
     /* 15436 */   // GIR_Coverage, 2196,
     /* 15436 */   GIR_EraseRootFromParent_Done,
     /* 15437 */ // Label 550: @15437
     /* 15437 */ GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(15494), // Rule ID 2342 //
     /* 15442 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /* 15445 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 15449 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 15453 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 15457 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 15461 */   // MIs[1] Operand 1
     /* 15461 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
     /* 15466 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 15471 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 15475 */   // MIs[0] dst
     /* 15475 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 15478 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 15480 */   // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BNEZC_MMR6 GPR32:{ *:[i32] }:$lhs, (bb:{ *:[Other] }):$dst)
     /* 15480 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNEZC_MMR6),
     /* 15483 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 15487 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 15489 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 15492 */   GIR_RootConstrainSelectedInstOperands,
     /* 15493 */   // GIR_Coverage, 2342,
     /* 15493 */   GIR_EraseRootFromParent_Done,
     /* 15494 */ // Label 551: @15494
     /* 15494 */ GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(15551), // Rule ID 2343 //
     /* 15499 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /* 15502 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 15506 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 15510 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 15514 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 15518 */   // MIs[1] Operand 1
     /* 15518 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
     /* 15523 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 15528 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 15532 */   // MIs[0] dst
     /* 15532 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 15535 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 15537 */   // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, 0:{ *:[i32] }, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQZC_MMR6 GPR32:{ *:[i32] }:$lhs, (bb:{ *:[Other] }):$dst)
     /* 15537 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQZC_MMR6),
     /* 15540 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 15544 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 15546 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 15549 */   GIR_RootConstrainSelectedInstOperands,
     /* 15550 */   // GIR_Coverage, 2343,
     /* 15550 */   GIR_EraseRootFromParent_Done,
     /* 15551 */ // Label 552: @15551
     /* 15551 */ GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(15603), // Rule ID 1413 //
     /* 15556 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /* 15559 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 15563 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 15567 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 15571 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 15575 */   // MIs[1] Operand 1
     /* 15575 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
     /* 15580 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 1,
     /* 15584 */   // MIs[0] dst
     /* 15584 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 15587 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 15589 */   // (brcond (setcc:{ *:[i32] } i32:{ *:[i32] }:$lhs, 1:{ *:[i32] }, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BLEZ i32:{ *:[i32] }:$lhs, (bb:{ *:[Other] }):$dst)
     /* 15589 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLEZ),
     /* 15592 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 15596 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 15598 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 15601 */   GIR_RootConstrainSelectedInstOperands,
     /* 15602 */   // GIR_Coverage, 1413,
     /* 15602 */   GIR_EraseRootFromParent_Done,
     /* 15603 */ // Label 553: @15603
     /* 15603 */ GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(15655), // Rule ID 1414 //
     /* 15608 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /* 15611 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 15615 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 15619 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 15623 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 15627 */   // MIs[1] Operand 1
     /* 15627 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
     /* 15632 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, uint8_t(-1),
     /* 15636 */   // MIs[0] dst
     /* 15636 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 15639 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 15641 */   // (brcond (setcc:{ *:[i32] } i32:{ *:[i32] }:$lhs, -1:{ *:[i32] }, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BGEZ i32:{ *:[i32] }:$lhs, (bb:{ *:[Other] }):$dst)
     /* 15641 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGEZ),
     /* 15644 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 15648 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 15650 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 15653 */   GIR_RootConstrainSelectedInstOperands,
     /* 15654 */   // GIR_Coverage, 1414,
     /* 15654 */   GIR_EraseRootFromParent_Done,
     /* 15655 */ // Label 554: @15655
     /* 15655 */ GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(15707), // Rule ID 1559 //
     /* 15660 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
     /* 15663 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 15667 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 15671 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 15675 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 15679 */   // MIs[1] Operand 1
     /* 15679 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
     /* 15684 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 1,
     /* 15688 */   // MIs[0] dst
     /* 15688 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 15691 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 15693 */   // (brcond (setcc:{ *:[i32] } i64:{ *:[i64] }:$lhs, 1:{ *:[i64] }, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BLEZ64 i64:{ *:[i64] }:$lhs, (bb:{ *:[Other] }):$dst)
     /* 15693 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLEZ64),
     /* 15696 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 15700 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 15702 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 15705 */   GIR_RootConstrainSelectedInstOperands,
     /* 15706 */   // GIR_Coverage, 1559,
     /* 15706 */   GIR_EraseRootFromParent_Done,
     /* 15707 */ // Label 555: @15707
     /* 15707 */ GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(15759), // Rule ID 1560 //
     /* 15712 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
     /* 15715 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 15719 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 15723 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 15727 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 15731 */   // MIs[1] Operand 1
     /* 15731 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
     /* 15736 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, uint8_t(-1),
     /* 15740 */   // MIs[0] dst
     /* 15740 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 15743 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 15745 */   // (brcond (setcc:{ *:[i32] } i64:{ *:[i64] }:$lhs, -1:{ *:[i64] }, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BGEZ64 i64:{ *:[i64] }:$lhs, (bb:{ *:[Other] }):$dst)
     /* 15745 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGEZ64),
     /* 15748 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 15752 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 15754 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 15757 */   GIR_RootConstrainSelectedInstOperands,
     /* 15758 */   // GIR_Coverage, 1560,
     /* 15758 */   GIR_EraseRootFromParent_Done,
     /* 15759 */ // Label 556: @15759
     /* 15759 */ GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(15811), // Rule ID 2206 //
     /* 15764 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /* 15767 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 15771 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 15775 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 15779 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 15783 */   // MIs[1] Operand 1
     /* 15783 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
     /* 15788 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 1,
     /* 15792 */   // MIs[0] dst
     /* 15792 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 15795 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 15797 */   // (brcond (setcc:{ *:[i32] } i32:{ *:[i32] }:$lhs, 1:{ *:[i32] }, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BLEZ_MM i32:{ *:[i32] }:$lhs, (bb:{ *:[Other] }):$dst)
     /* 15797 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BLEZ_MM),
     /* 15800 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 15804 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 15806 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 15809 */   GIR_RootConstrainSelectedInstOperands,
     /* 15810 */   // GIR_Coverage, 2206,
     /* 15810 */   GIR_EraseRootFromParent_Done,
     /* 15811 */ // Label 557: @15811
     /* 15811 */ GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(15863), // Rule ID 2207 //
     /* 15816 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /* 15819 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 15823 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 15827 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 15831 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 15835 */   // MIs[1] Operand 1
     /* 15835 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
     /* 15840 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, uint8_t(-1),
     /* 15844 */   // MIs[0] dst
     /* 15844 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 15847 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 15849 */   // (brcond (setcc:{ *:[i32] } i32:{ *:[i32] }:$lhs, -1:{ *:[i32] }, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BGEZ_MM i32:{ *:[i32] }:$lhs, (bb:{ *:[Other] }):$dst)
     /* 15849 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BGEZ_MM),
     /* 15852 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 15856 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 15858 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 15861 */   GIR_RootConstrainSelectedInstOperands,
     /* 15862 */   // GIR_Coverage, 2207,
     /* 15862 */   GIR_EraseRootFromParent_Done,
     /* 15863 */ // Label 558: @15863
     /* 15863 */ GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(15925), // Rule ID 92 //
     /* 15868 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /* 15871 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 15875 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 15879 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 15883 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 15887 */   // MIs[1] Operand 1
     /* 15887 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
     /* 15892 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 15897 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 15902 */   // MIs[0] offset
     /* 15902 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 15905 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 15907 */   // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BEQ GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (bb:{ *:[Other] }):$offset)
     /* 15907 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
     /* 15910 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
     /* 15914 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
     /* 15918 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 15920 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 15923 */   GIR_RootConstrainSelectedInstOperands,
     /* 15924 */   // GIR_Coverage, 92,
     /* 15924 */   GIR_EraseRootFromParent_Done,
     /* 15925 */ // Label 559: @15925
     /* 15925 */ GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(15987), // Rule ID 93 //
     /* 15930 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /* 15933 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 15937 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 15941 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 15945 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 15949 */   // MIs[1] Operand 1
     /* 15949 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
     /* 15954 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 15959 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 15964 */   // MIs[0] offset
     /* 15964 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 15967 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 15969 */   // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BNE GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (bb:{ *:[Other] }):$offset)
     /* 15969 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE),
     /* 15972 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
     /* 15976 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
     /* 15980 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 15982 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 15985 */   GIR_RootConstrainSelectedInstOperands,
     /* 15986 */   // GIR_Coverage, 93,
     /* 15986 */   GIR_EraseRootFromParent_Done,
     /* 15987 */ // Label 560: @15987
     /* 15987 */ GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(16049), // Rule ID 243 //
     /* 15992 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
     /* 15995 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 15999 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 16003 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 16007 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 16011 */   // MIs[1] Operand 1
     /* 16011 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
     /* 16016 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 16021 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 16026 */   // MIs[0] offset
     /* 16026 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 16029 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 16031 */   // (brcond (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BEQ64 GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, (bb:{ *:[Other] }):$offset)
     /* 16031 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ64),
     /* 16034 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
     /* 16038 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
     /* 16042 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 16044 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 16047 */   GIR_RootConstrainSelectedInstOperands,
     /* 16048 */   // GIR_Coverage, 243,
     /* 16048 */   GIR_EraseRootFromParent_Done,
     /* 16049 */ // Label 561: @16049
     /* 16049 */ GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(16111), // Rule ID 244 //
     /* 16054 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsGP64bit_NotInMips16Mode),
     /* 16057 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 16061 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 16065 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 16069 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 16073 */   // MIs[1] Operand 1
     /* 16073 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
     /* 16078 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 16083 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 16088 */   // MIs[0] offset
     /* 16088 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 16091 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 16093 */   // (brcond (setcc:{ *:[i32] } GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BNE64 GPR64Opnd:{ *:[i64] }:$rs, GPR64Opnd:{ *:[i64] }:$rt, (bb:{ *:[Other] }):$offset)
     /* 16093 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE64),
     /* 16096 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
     /* 16100 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
     /* 16104 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 16106 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 16109 */   GIR_RootConstrainSelectedInstOperands,
     /* 16110 */   // GIR_Coverage, 244,
     /* 16110 */   GIR_EraseRootFromParent_Done,
     /* 16111 */ // Label 562: @16111
     /* 16111 */ GIM_Try, /*On fail goto*//*Label 563*/ GIMT_Encode4(16173), // Rule ID 1107 //
     /* 16116 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /* 16119 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 16123 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 16127 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 16131 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 16135 */   // MIs[1] Operand 1
     /* 16135 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
     /* 16140 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 16145 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 16150 */   // MIs[0] offset
     /* 16150 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 16153 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 16155 */   // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BEQ_MM GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (bb:{ *:[Other] }):$offset)
     /* 16155 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ_MM),
     /* 16158 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
     /* 16162 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
     /* 16166 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 16168 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 16171 */   GIR_RootConstrainSelectedInstOperands,
     /* 16172 */   // GIR_Coverage, 1107,
     /* 16172 */   GIR_EraseRootFromParent_Done,
     /* 16173 */ // Label 563: @16173
     /* 16173 */ GIM_Try, /*On fail goto*//*Label 564*/ GIMT_Encode4(16235), // Rule ID 1108 //
     /* 16178 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /* 16181 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 16185 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 16189 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 16193 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 16197 */   // MIs[1] Operand 1
     /* 16197 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
     /* 16202 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 16207 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 16212 */   // MIs[0] offset
     /* 16212 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 16215 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 16217 */   // (brcond (setcc:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$offset)  =>  (BNE_MM GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt, (bb:{ *:[Other] }):$offset)
     /* 16217 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE_MM),
     /* 16220 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs
     /* 16224 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // rt
     /* 16228 */   GIR_RootToRootCopy, /*OpIdx*/1, // offset
     /* 16230 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 16233 */   GIR_RootConstrainSelectedInstOperands,
     /* 16234 */   // GIR_Coverage, 1108,
     /* 16234 */   GIR_EraseRootFromParent_Done,
     /* 16235 */ // Label 564: @16235
     /* 16235 */ GIM_Try, /*On fail goto*//*Label 565*/ GIMT_Encode4(16320), // Rule ID 1404 //
     /* 16240 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /* 16243 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 16247 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 16251 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 16255 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 16259 */   // MIs[1] Operand 1
     /* 16259 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
     /* 16264 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 16269 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 16274 */   // MIs[0] dst
     /* 16274 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 16277 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 16279 */   // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLT:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
     /* 16279 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /* 16282 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT),
     /* 16286 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 16291 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 16295 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
     /* 16299 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 16301 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
     /* 16304 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 16307 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 16313 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 16315 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 16318 */   GIR_RootConstrainSelectedInstOperands,
     /* 16319 */   // GIR_Coverage, 1404,
     /* 16319 */   GIR_EraseRootFromParent_Done,
     /* 16320 */ // Label 565: @16320
     /* 16320 */ GIM_Try, /*On fail goto*//*Label 566*/ GIMT_Encode4(16405), // Rule ID 1405 //
     /* 16325 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /* 16328 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 16332 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 16336 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 16340 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 16344 */   // MIs[1] Operand 1
     /* 16344 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGE),
     /* 16349 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 16354 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 16359 */   // MIs[0] dst
     /* 16359 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 16362 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 16364 */   // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETUGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLTu:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
     /* 16364 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /* 16367 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu),
     /* 16371 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 16376 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 16380 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
     /* 16384 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 16386 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
     /* 16389 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 16392 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 16398 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 16400 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 16403 */   GIR_RootConstrainSelectedInstOperands,
     /* 16404 */   // GIR_Coverage, 1405,
     /* 16404 */   GIR_EraseRootFromParent_Done,
     /* 16405 */ // Label 566: @16405
     /* 16405 */ GIM_Try, /*On fail goto*//*Label 567*/ GIMT_Encode4(16490), // Rule ID 1410 //
     /* 16410 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /* 16413 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 16417 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 16421 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 16425 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 16429 */   // MIs[1] Operand 1
     /* 16429 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
     /* 16434 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 16439 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 16444 */   // MIs[0] dst
     /* 16444 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 16447 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 16449 */   // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLT:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
     /* 16449 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /* 16452 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT),
     /* 16456 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 16461 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
     /* 16465 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 16469 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 16471 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
     /* 16474 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 16477 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 16483 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 16485 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 16488 */   GIR_RootConstrainSelectedInstOperands,
     /* 16489 */   // GIR_Coverage, 1410,
     /* 16489 */   GIR_EraseRootFromParent_Done,
     /* 16490 */ // Label 567: @16490
     /* 16490 */ GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(16575), // Rule ID 1411 //
     /* 16495 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /* 16498 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 16502 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 16506 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 16510 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 16514 */   // MIs[1] Operand 1
     /* 16514 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_ULE),
     /* 16519 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 16524 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 16529 */   // MIs[0] dst
     /* 16529 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 16532 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 16534 */   // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETULE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLTu:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
     /* 16534 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /* 16537 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu),
     /* 16541 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 16546 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
     /* 16550 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 16554 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 16556 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
     /* 16559 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 16562 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 16568 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 16570 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 16573 */   GIR_RootConstrainSelectedInstOperands,
     /* 16574 */   // GIR_Coverage, 1411,
     /* 16574 */   GIR_EraseRootFromParent_Done,
     /* 16575 */ // Label 568: @16575
     /* 16575 */ GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(16660), // Rule ID 1550 //
     /* 16580 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
     /* 16583 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 16587 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 16591 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 16595 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 16599 */   // MIs[1] Operand 1
     /* 16599 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
     /* 16604 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 16609 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 16614 */   // MIs[0] dst
     /* 16614 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 16617 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 16619 */   // (brcond (setcc:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, GPR64:{ *:[i64] }:$rhs, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLT64:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, GPR64:{ *:[i64] }:$rhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
     /* 16619 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /* 16622 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT64),
     /* 16626 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 16631 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 16635 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
     /* 16639 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 16641 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
     /* 16644 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 16647 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 16653 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 16655 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 16658 */   GIR_RootConstrainSelectedInstOperands,
     /* 16659 */   // GIR_Coverage, 1550,
     /* 16659 */   GIR_EraseRootFromParent_Done,
     /* 16660 */ // Label 569: @16660
     /* 16660 */ GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(16745), // Rule ID 1551 //
     /* 16665 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
     /* 16668 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 16672 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 16676 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 16680 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 16684 */   // MIs[1] Operand 1
     /* 16684 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGE),
     /* 16689 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 16694 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 16699 */   // MIs[0] dst
     /* 16699 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 16702 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 16704 */   // (brcond (setcc:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, GPR64:{ *:[i64] }:$rhs, SETUGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLTu64:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, GPR64:{ *:[i64] }:$rhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
     /* 16704 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /* 16707 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu64),
     /* 16711 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 16716 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 16720 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
     /* 16724 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 16726 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
     /* 16729 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 16732 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 16738 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 16740 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 16743 */   GIR_RootConstrainSelectedInstOperands,
     /* 16744 */   // GIR_Coverage, 1551,
     /* 16744 */   GIR_EraseRootFromParent_Done,
     /* 16745 */ // Label 570: @16745
     /* 16745 */ GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(16830), // Rule ID 1556 //
     /* 16750 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
     /* 16753 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 16757 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 16761 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 16765 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 16769 */   // MIs[1] Operand 1
     /* 16769 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
     /* 16774 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 16779 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 16784 */   // MIs[0] dst
     /* 16784 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 16787 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 16789 */   // (brcond (setcc:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, GPR64:{ *:[i64] }:$rhs, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLT64:{ *:[i32] } GPR64:{ *:[i64] }:$rhs, GPR64:{ *:[i64] }:$lhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
     /* 16789 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /* 16792 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT64),
     /* 16796 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 16801 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
     /* 16805 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 16809 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 16811 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
     /* 16814 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 16817 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 16823 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 16825 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 16828 */   GIR_RootConstrainSelectedInstOperands,
     /* 16829 */   // GIR_Coverage, 1556,
     /* 16829 */   GIR_EraseRootFromParent_Done,
     /* 16830 */ // Label 571: @16830
     /* 16830 */ GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(16915), // Rule ID 1557 //
     /* 16835 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
     /* 16838 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 16842 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 16846 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 16850 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /* 16854 */   // MIs[1] Operand 1
     /* 16854 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_ULE),
     /* 16859 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 16864 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 16869 */   // MIs[0] dst
     /* 16869 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 16872 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 16874 */   // (brcond (setcc:{ *:[i32] } GPR64:{ *:[i64] }:$lhs, GPR64:{ *:[i64] }:$rhs, SETULE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ (SLTu64:{ *:[i32] } GPR64:{ *:[i64] }:$rhs, GPR64:{ *:[i64] }:$lhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
     /* 16874 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /* 16877 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu64),
     /* 16881 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 16886 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
     /* 16890 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 16894 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 16896 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ),
     /* 16899 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 16902 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 16908 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 16910 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 16913 */   GIR_RootConstrainSelectedInstOperands,
     /* 16914 */   // GIR_Coverage, 1557,
     /* 16914 */   GIR_EraseRootFromParent_Done,
     /* 16915 */ // Label 572: @16915
     /* 16915 */ GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(16974), // Rule ID 1854 //
     /* 16920 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
     /* 16923 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 16927 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 16931 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 16935 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 16939 */   // MIs[1] Operand 1
     /* 16939 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_EQ),
     /* 16944 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /* 16949 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /* 16954 */   // MIs[0] imm16
     /* 16954 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 16957 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 16959 */   // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, SETEQ:{ *:[Other] }), (bb:{ *:[Other] }):$imm16)  =>  (BteqzT8CmpX16 CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, (bb:{ *:[Other] }):$imm16)
     /* 16959 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BteqzT8CmpX16),
     /* 16962 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
     /* 16966 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // ry
     /* 16970 */   GIR_RootToRootCopy, /*OpIdx*/1, // imm16
     /* 16972 */   GIR_RootConstrainSelectedInstOperands,
     /* 16973 */   // GIR_Coverage, 1854,
     /* 16973 */   GIR_EraseRootFromParent_Done,
     /* 16974 */ // Label 573: @16974
     /* 16974 */ GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(17033), // Rule ID 1857 //
     /* 16979 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
     /* 16982 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 16986 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 16990 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 16994 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 16998 */   // MIs[1] Operand 1
     /* 16998 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGT),
     /* 17003 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /* 17008 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /* 17013 */   // MIs[0] imm16
     /* 17013 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 17016 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 17018 */   // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, SETGT:{ *:[Other] }), (bb:{ *:[Other] }):$imm16)  =>  (BtnezT8SltX16 CPU16Regs:{ *:[i32] }:$ry, CPU16Regs:{ *:[i32] }:$rx, (bb:{ *:[Other] }):$imm16)
     /* 17018 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BtnezT8SltX16),
     /* 17021 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // ry
     /* 17025 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
     /* 17029 */   GIR_RootToRootCopy, /*OpIdx*/1, // imm16
     /* 17031 */   GIR_RootConstrainSelectedInstOperands,
     /* 17032 */   // GIR_Coverage, 1857,
     /* 17032 */   GIR_EraseRootFromParent_Done,
     /* 17033 */ // Label 574: @17033
     /* 17033 */ GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(17092), // Rule ID 1858 //
     /* 17038 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
     /* 17041 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 17045 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 17049 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 17053 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 17057 */   // MIs[1] Operand 1
     /* 17057 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
     /* 17062 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /* 17067 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /* 17072 */   // MIs[0] imm16
     /* 17072 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 17075 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 17077 */   // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$imm16)  =>  (BteqzT8SltX16 CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, (bb:{ *:[Other] }):$imm16)
     /* 17077 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BteqzT8SltX16),
     /* 17080 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
     /* 17084 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // ry
     /* 17088 */   GIR_RootToRootCopy, /*OpIdx*/1, // imm16
     /* 17090 */   GIR_RootConstrainSelectedInstOperands,
     /* 17091 */   // GIR_Coverage, 1858,
     /* 17091 */   GIR_EraseRootFromParent_Done,
     /* 17092 */ // Label 575: @17092
     /* 17092 */ GIM_Try, /*On fail goto*//*Label 576*/ GIMT_Encode4(17151), // Rule ID 1860 //
     /* 17097 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
     /* 17100 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 17104 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 17108 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 17112 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 17116 */   // MIs[1] Operand 1
     /* 17116 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLT),
     /* 17121 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /* 17126 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /* 17131 */   // MIs[0] imm16
     /* 17131 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 17134 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 17136 */   // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, SETLT:{ *:[Other] }), (bb:{ *:[Other] }):$imm16)  =>  (BtnezT8SltX16 CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, (bb:{ *:[Other] }):$imm16)
     /* 17136 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BtnezT8SltX16),
     /* 17139 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
     /* 17143 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // ry
     /* 17147 */   GIR_RootToRootCopy, /*OpIdx*/1, // imm16
     /* 17149 */   GIR_RootConstrainSelectedInstOperands,
     /* 17150 */   // GIR_Coverage, 1860,
     /* 17150 */   GIR_EraseRootFromParent_Done,
     /* 17151 */ // Label 576: @17151
     /* 17151 */ GIM_Try, /*On fail goto*//*Label 577*/ GIMT_Encode4(17210), // Rule ID 1862 //
     /* 17156 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
     /* 17159 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 17163 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 17167 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 17171 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 17175 */   // MIs[1] Operand 1
     /* 17175 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
     /* 17180 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /* 17185 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /* 17190 */   // MIs[0] imm16
     /* 17190 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 17193 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 17195 */   // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$imm16)  =>  (BteqzT8SltX16 CPU16Regs:{ *:[i32] }:$ry, CPU16Regs:{ *:[i32] }:$rx, (bb:{ *:[Other] }):$imm16)
     /* 17195 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BteqzT8SltX16),
     /* 17198 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // ry
     /* 17202 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
     /* 17206 */   GIR_RootToRootCopy, /*OpIdx*/1, // imm16
     /* 17208 */   GIR_RootConstrainSelectedInstOperands,
     /* 17209 */   // GIR_Coverage, 1862,
     /* 17209 */   GIR_EraseRootFromParent_Done,
     /* 17210 */ // Label 577: @17210
     /* 17210 */ GIM_Try, /*On fail goto*//*Label 578*/ GIMT_Encode4(17269), // Rule ID 1863 //
     /* 17215 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
     /* 17218 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 17222 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 17226 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 17230 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 17234 */   // MIs[1] Operand 1
     /* 17234 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_NE),
     /* 17239 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /* 17244 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /* 17249 */   // MIs[0] imm16
     /* 17249 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 17252 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 17254 */   // (brcond (setcc:{ *:[i32] } CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, SETNE:{ *:[Other] }), (bb:{ *:[Other] }):$imm16)  =>  (BtnezT8CmpX16 CPU16Regs:{ *:[i32] }:$rx, CPU16Regs:{ *:[i32] }:$ry, (bb:{ *:[Other] }):$imm16)
     /* 17254 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BtnezT8CmpX16),
     /* 17257 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rx
     /* 17261 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // ry
     /* 17265 */   GIR_RootToRootCopy, /*OpIdx*/1, // imm16
     /* 17267 */   GIR_RootConstrainSelectedInstOperands,
     /* 17268 */   // GIR_Coverage, 1863,
     /* 17268 */   GIR_EraseRootFromParent_Done,
     /* 17269 */ // Label 578: @17269
     /* 17269 */ GIM_Try, /*On fail goto*//*Label 579*/ GIMT_Encode4(17354), // Rule ID 2197 //
     /* 17274 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /* 17277 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 17281 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 17285 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 17289 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 17293 */   // MIs[1] Operand 1
     /* 17293 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
     /* 17298 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 17303 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 17308 */   // MIs[0] dst
     /* 17308 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 17311 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 17313 */   // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ_MM (SLT_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
     /* 17313 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /* 17316 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT_MM),
     /* 17320 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 17325 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 17329 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
     /* 17333 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 17335 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ_MM),
     /* 17338 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 17341 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 17347 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 17349 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 17352 */   GIR_RootConstrainSelectedInstOperands,
     /* 17353 */   // GIR_Coverage, 2197,
     /* 17353 */   GIR_EraseRootFromParent_Done,
     /* 17354 */ // Label 579: @17354
     /* 17354 */ GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(17439), // Rule ID 2198 //
     /* 17359 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /* 17362 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 17366 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 17370 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 17374 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 17378 */   // MIs[1] Operand 1
     /* 17378 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGE),
     /* 17383 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 17388 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 17393 */   // MIs[0] dst
     /* 17393 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 17396 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 17398 */   // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETUGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ_MM (SLTu_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
     /* 17398 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /* 17401 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu_MM),
     /* 17405 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 17410 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 17414 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
     /* 17418 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 17420 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ_MM),
     /* 17423 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 17426 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 17432 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 17434 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 17437 */   GIR_RootConstrainSelectedInstOperands,
     /* 17438 */   // GIR_Coverage, 2198,
     /* 17438 */   GIR_EraseRootFromParent_Done,
     /* 17439 */ // Label 580: @17439
     /* 17439 */ GIM_Try, /*On fail goto*//*Label 581*/ GIMT_Encode4(17524), // Rule ID 2203 //
     /* 17444 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /* 17447 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 17451 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 17455 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 17459 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 17463 */   // MIs[1] Operand 1
     /* 17463 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
     /* 17468 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 17473 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 17478 */   // MIs[0] dst
     /* 17478 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 17481 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 17483 */   // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ_MM (SLT_MM:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
     /* 17483 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /* 17486 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT_MM),
     /* 17490 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 17495 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
     /* 17499 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 17503 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 17505 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ_MM),
     /* 17508 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 17511 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 17517 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 17519 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 17522 */   GIR_RootConstrainSelectedInstOperands,
     /* 17523 */   // GIR_Coverage, 2203,
     /* 17523 */   GIR_EraseRootFromParent_Done,
     /* 17524 */ // Label 581: @17524
     /* 17524 */ GIM_Try, /*On fail goto*//*Label 582*/ GIMT_Encode4(17609), // Rule ID 2204 //
     /* 17529 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /* 17532 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 17536 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 17540 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 17544 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 17548 */   // MIs[1] Operand 1
     /* 17548 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_ULE),
     /* 17553 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 17558 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 17563 */   // MIs[0] dst
     /* 17563 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 17566 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 17568 */   // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETULE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQ_MM (SLTu_MM:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs), ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
     /* 17568 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /* 17571 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu_MM),
     /* 17575 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 17580 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
     /* 17584 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 17588 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 17590 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQ_MM),
     /* 17593 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 17596 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 17602 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 17604 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 17607 */   GIR_RootConstrainSelectedInstOperands,
     /* 17608 */   // GIR_Coverage, 2204,
     /* 17608 */   GIR_EraseRootFromParent_Done,
     /* 17609 */ // Label 582: @17609
     /* 17609 */ GIM_Try, /*On fail goto*//*Label 583*/ GIMT_Encode4(17688), // Rule ID 2344 //
     /* 17614 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /* 17617 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 17621 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 17625 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 17629 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 17633 */   // MIs[1] Operand 1
     /* 17633 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SGE),
     /* 17638 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 17643 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 17648 */   // MIs[0] dst
     /* 17648 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 17651 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 17653 */   // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQZC_MMR6 (SLT_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs), (bb:{ *:[Other] }):$dst)
     /* 17653 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /* 17656 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT_MM),
     /* 17660 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 17665 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 17669 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
     /* 17673 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 17675 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQZC_MMR6),
     /* 17678 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 17681 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 17683 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 17686 */   GIR_RootConstrainSelectedInstOperands,
     /* 17687 */   // GIR_Coverage, 2344,
     /* 17687 */   GIR_EraseRootFromParent_Done,
     /* 17688 */ // Label 583: @17688
     /* 17688 */ GIM_Try, /*On fail goto*//*Label 584*/ GIMT_Encode4(17767), // Rule ID 2345 //
     /* 17693 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /* 17696 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 17700 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 17704 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 17708 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 17712 */   // MIs[1] Operand 1
     /* 17712 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGE),
     /* 17717 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 17722 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 17727 */   // MIs[0] dst
     /* 17727 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 17730 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 17732 */   // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETUGE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQZC_MMR6 (SLTu_MM:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs), (bb:{ *:[Other] }):$dst)
     /* 17732 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /* 17735 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu_MM),
     /* 17739 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 17744 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 17748 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
     /* 17752 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 17754 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQZC_MMR6),
     /* 17757 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 17760 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 17762 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 17765 */   GIR_RootConstrainSelectedInstOperands,
     /* 17766 */   // GIR_Coverage, 2345,
     /* 17766 */   GIR_EraseRootFromParent_Done,
     /* 17767 */ // Label 584: @17767
     /* 17767 */ GIM_Try, /*On fail goto*//*Label 585*/ GIMT_Encode4(17846), // Rule ID 2350 //
     /* 17772 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /* 17775 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 17779 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 17783 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 17787 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 17791 */   // MIs[1] Operand 1
     /* 17791 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_SLE),
     /* 17796 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 17801 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 17806 */   // MIs[0] dst
     /* 17806 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 17809 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 17811 */   // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETLE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQZC_MMR6 (SLT_MM:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs), (bb:{ *:[Other] }):$dst)
     /* 17811 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /* 17814 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLT_MM),
     /* 17818 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 17823 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
     /* 17827 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 17831 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 17833 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQZC_MMR6),
     /* 17836 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 17839 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 17841 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 17844 */   GIR_RootConstrainSelectedInstOperands,
     /* 17845 */   // GIR_Coverage, 2350,
     /* 17845 */   GIR_EraseRootFromParent_Done,
     /* 17846 */ // Label 585: @17846
     /* 17846 */ GIM_Try, /*On fail goto*//*Label 586*/ GIMT_Encode4(17925), // Rule ID 2351 //
     /* 17851 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /* 17854 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/0, // MIs[1]
     /* 17858 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 17862 */   GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /* 17866 */   GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /* 17870 */   // MIs[1] Operand 1
     /* 17870 */   GIM_CheckCmpPredicate, /*MI*/1, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_ULE),
     /* 17875 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 17880 */   GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 17885 */   // MIs[0] dst
     /* 17885 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 17888 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 17890 */   // (brcond (setcc:{ *:[i32] } GPR32:{ *:[i32] }:$lhs, GPR32:{ *:[i32] }:$rhs, SETULE:{ *:[Other] }), (bb:{ *:[Other] }):$dst)  =>  (BEQZC_MMR6 (SLTu_MM:{ *:[i32] } GPR32:{ *:[i32] }:$rhs, GPR32:{ *:[i32] }:$lhs), (bb:{ *:[Other] }):$dst)
     /* 17890 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /* 17893 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(Mips::SLTu_MM),
     /* 17897 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 17902 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/3, // rhs
     /* 17906 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // lhs
     /* 17910 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 17912 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BEQZC_MMR6),
     /* 17915 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 17918 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 17920 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 17923 */   GIR_RootConstrainSelectedInstOperands,
     /* 17924 */   // GIR_Coverage, 2351,
     /* 17924 */   GIR_EraseRootFromParent_Done,
     /* 17925 */ // Label 586: @17925
     /* 17925 */ GIM_Try, /*On fail goto*//*Label 587*/ GIMT_Encode4(17958), // Rule ID 1412 //
     /* 17930 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdEnc_NotInMicroMips),
     /* 17933 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 17937 */   // MIs[0] dst
     /* 17937 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 17940 */   // (brcond GPR32:{ *:[i32] }:$cond, (bb:{ *:[Other] }):$dst)  =>  (BNE GPR32:{ *:[i32] }:$cond, ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
     /* 17940 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE),
     /* 17943 */   GIR_RootToRootCopy, /*OpIdx*/0, // cond
     /* 17945 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 17951 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 17953 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 17956 */   GIR_RootConstrainSelectedInstOperands,
     /* 17957 */   // GIR_Coverage, 1412,
     /* 17957 */   GIR_EraseRootFromParent_Done,
     /* 17958 */ // Label 587: @17958
     /* 17958 */ GIM_Try, /*On fail goto*//*Label 588*/ GIMT_Encode4(17980), // Rule ID 1866 //
     /* 17963 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMips16Mode),
     /* 17966 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::CPU16RegsRegClassID),
     /* 17970 */   // MIs[0] targ16
     /* 17970 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 17973 */   // (brcond CPU16Regs:{ *:[i32] }:$rx, (bb:{ *:[Other] }):$targ16)  =>  (BnezRxImm16 CPU16Regs:{ *:[i32] }:$rx, (bb:{ *:[Other] }):$targ16)
     /* 17973 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BnezRxImm16),
     /* 17978 */   GIR_RootConstrainSelectedInstOperands,
     /* 17979 */   // GIR_Coverage, 1866,
     /* 17979 */   GIR_Done,
     /* 17980 */ // Label 588: @17980
     /* 17980 */ GIM_Try, /*On fail goto*//*Label 589*/ GIMT_Encode4(18013), // Rule ID 2205 //
     /* 17985 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_InMicroMips_NotMips32r6),
     /* 17988 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 17992 */   // MIs[0] dst
     /* 17992 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 17995 */   // (brcond GPR32:{ *:[i32] }:$cond, (bb:{ *:[Other] }):$dst)  =>  (BNE_MM GPR32:{ *:[i32] }:$cond, ZERO:{ *:[i32] }, (bb:{ *:[Other] }):$dst)
     /* 17995 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE_MM),
     /* 17998 */   GIR_RootToRootCopy, /*OpIdx*/0, // cond
     /* 18000 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 18006 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 18008 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 18011 */   GIR_RootConstrainSelectedInstOperands,
     /* 18012 */   // GIR_Coverage, 2205,
     /* 18012 */   GIR_EraseRootFromParent_Done,
     /* 18013 */ // Label 589: @18013
     /* 18013 */ GIM_Try, /*On fail goto*//*Label 590*/ GIMT_Encode4(18041), // Rule ID 2352 //
     /* 18018 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips32r6_InMicroMips),
     /* 18021 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 18025 */   // MIs[0] dst
     /* 18025 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 18028 */   // (brcond GPR32:{ *:[i32] }:$cond, (bb:{ *:[Other] }):$dst)  =>  (BNEZC_MMR6 GPR32:{ *:[i32] }:$cond, (bb:{ *:[Other] }):$dst)
     /* 18028 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(Mips::BNEZC_MMR6),
     /* 18033 */   GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(Mips::AT), GIMT_Encode2(RegState::Dead),
     /* 18039 */   GIR_RootConstrainSelectedInstOperands,
     /* 18040 */   // GIR_Coverage, 2352,
     /* 18040 */   GIR_Done,
     /* 18041 */ // Label 590: @18041
     /* 18041 */ GIM_Reject,
     /* 18042 */ // Label 521: @18042
     /* 18042 */ GIM_Try, /*On fail goto*//*Label 591*/ GIMT_Encode4(18075), // Rule ID 1558 //
     /* 18047 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMips3_HasStdEnc_IsGP64bit),
     /* 18050 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR64RegClassID),
     /* 18054 */   // MIs[0] dst
     /* 18054 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/1,
     /* 18057 */   // (brcond GPR64:{ *:[i64] }:$cond, (bb:{ *:[Other] }):$dst)  =>  (BNE64 GPR64:{ *:[i64] }:$cond, ZERO_64:{ *:[i64] }, (bb:{ *:[Other] }):$dst)
     /* 18057 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BNE64),
     /* 18060 */   GIR_RootToRootCopy, /*OpIdx*/0, // cond
     /* 18062 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(Mips::ZERO_64), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /* 18068 */   GIR_RootToRootCopy, /*OpIdx*/1, // dst
     /* 18070 */   GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::AT*/0,
     /* 18073 */   GIR_RootConstrainSelectedInstOperands,
     /* 18074 */   // GIR_Coverage, 1558,
     /* 18074 */   GIR_EraseRootFromParent_Done,
     /* 18075 */ // Label 591: @18075
     /* 18075 */ GIM_Reject,
     /* 18076 */ // Label 522: @18076
     /* 18076 */ GIM_Reject,
     /* 18077 */ // Label 29: @18077
     /* 18077 */ GIM_Try, /*On fail goto*//*Label 592*/ GIMT_Encode4(20074),
     /* 18082 */   GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
     /* 18085 */   GIM_Try, /*On fail goto*//*Label 593*/ GIMT_Encode4(18132), // Rule ID 428 //
     /* 18090 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 18093 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_qb),
     /* 18098 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 18101 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 18104 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18108 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 18112 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 18116 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt8),
     /* 18120 */     // MIs[1] Operand 1
     /* 18120 */     // No operand predicates
     /* 18120 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 18122 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8136:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immZExt8>>:$imm)  =>  (REPL_QB:{ *:[v4i8] } (imm:{ *:[i32] }):$imm)
     /* 18122 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPL_QB),
     /* 18125 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 18127 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /* 18130 */     GIR_RootConstrainSelectedInstOperands,
     /* 18131 */     // GIR_Coverage, 428,
     /* 18131 */     GIR_EraseRootFromParent_Done,
     /* 18132 */   // Label 593: @18132
     /* 18132 */   GIM_Try, /*On fail goto*//*Label 594*/ GIMT_Encode4(18179), // Rule ID 429 //
     /* 18137 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 18140 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_ph),
     /* 18145 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 18148 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 18151 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18155 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 18159 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 18163 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immSExt10),
     /* 18167 */     // MIs[1] Operand 1
     /* 18167 */     // No operand predicates
     /* 18167 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 18169 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8135:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immSExt10>>:$imm)  =>  (REPL_PH:{ *:[v2i16] } (imm:{ *:[i32] }):$imm)
     /* 18169 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPL_PH),
     /* 18172 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 18174 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /* 18177 */     GIR_RootConstrainSelectedInstOperands,
     /* 18178 */     // GIR_Coverage, 429,
     /* 18178 */     GIR_EraseRootFromParent_Done,
     /* 18179 */   // Label 594: @18179
     /* 18179 */   GIM_Try, /*On fail goto*//*Label 595*/ GIMT_Encode4(18226), // Rule ID 1288 //
     /* 18184 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 18187 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_ph),
     /* 18192 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 18195 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 18198 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18202 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 18206 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 18210 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immSExt10),
     /* 18214 */     // MIs[1] Operand 1
     /* 18214 */     // No operand predicates
     /* 18214 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 18216 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8135:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immSExt10>>:$imm)  =>  (REPL_PH_MM:{ *:[v2i16] } (imm:{ *:[i32] }):$imm)
     /* 18216 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPL_PH_MM),
     /* 18219 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 18221 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /* 18224 */     GIR_RootConstrainSelectedInstOperands,
     /* 18225 */     // GIR_Coverage, 1288,
     /* 18225 */     GIR_EraseRootFromParent_Done,
     /* 18226 */   // Label 595: @18226
     /* 18226 */   GIM_Try, /*On fail goto*//*Label 596*/ GIMT_Encode4(18273), // Rule ID 1289 //
     /* 18231 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 18234 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_qb),
     /* 18239 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 18242 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 18245 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18249 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 18253 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 18257 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt8),
     /* 18261 */     // MIs[1] Operand 1
     /* 18261 */     // No operand predicates
     /* 18261 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 18263 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8136:{ *:[iPTR] }, (imm:{ *:[i32] })<<P:Predicate_immZExt8>>:$imm)  =>  (REPL_QB_MM:{ *:[v4i8] } (imm:{ *:[i32] }):$imm)
     /* 18263 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPL_QB_MM),
     /* 18266 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 18268 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /* 18271 */     GIR_RootConstrainSelectedInstOperands,
     /* 18272 */     // GIR_Coverage, 1289,
     /* 18272 */     GIR_EraseRootFromParent_Done,
     /* 18273 */   // Label 596: @18273
     /* 18273 */   GIM_Try, /*On fail goto*//*Label 597*/ GIMT_Encode4(18309), // Rule ID 362 //
     /* 18278 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 18281 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_raddu_w_qb),
     /* 18286 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 18289 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 18292 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 18296 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18300 */     // (intrinsic_wo_chain:{ *:[i32] } 8133:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (RADDU_W_QB:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs)
     /* 18300 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::RADDU_W_QB),
     /* 18303 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 18305 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 18307 */     GIR_RootConstrainSelectedInstOperands,
     /* 18308 */     // GIR_Coverage, 362,
     /* 18308 */     GIR_EraseRootFromParent_Done,
     /* 18309 */   // Label 597: @18309
     /* 18309 */   GIM_Try, /*On fail goto*//*Label 598*/ GIMT_Encode4(18345), // Rule ID 369 //
     /* 18314 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 18317 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceq_w_phl),
     /* 18322 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 18325 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 18328 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 18332 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18336 */     // (intrinsic_wo_chain:{ *:[i32] } 8115:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECEQ_W_PHL:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rt)
     /* 18336 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQ_W_PHL),
     /* 18339 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 18341 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 18343 */     GIR_RootConstrainSelectedInstOperands,
     /* 18344 */     // GIR_Coverage, 369,
     /* 18344 */     GIR_EraseRootFromParent_Done,
     /* 18345 */   // Label 598: @18345
     /* 18345 */   GIM_Try, /*On fail goto*//*Label 599*/ GIMT_Encode4(18381), // Rule ID 370 //
     /* 18350 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 18353 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceq_w_phr),
     /* 18358 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 18361 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 18364 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 18368 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18372 */     // (intrinsic_wo_chain:{ *:[i32] } 8116:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECEQ_W_PHR:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rt)
     /* 18372 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQ_W_PHR),
     /* 18375 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 18377 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 18379 */     GIR_RootConstrainSelectedInstOperands,
     /* 18380 */     // GIR_Coverage, 370,
     /* 18380 */     GIR_EraseRootFromParent_Done,
     /* 18381 */   // Label 599: @18381
     /* 18381 */   GIM_Try, /*On fail goto*//*Label 600*/ GIMT_Encode4(18417), // Rule ID 371 //
     /* 18386 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 18389 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbl),
     /* 18394 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 18397 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 18400 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18404 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18408 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8117:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBL:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
     /* 18408 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBL),
     /* 18411 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 18413 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 18415 */     GIR_RootConstrainSelectedInstOperands,
     /* 18416 */     // GIR_Coverage, 371,
     /* 18416 */     GIR_EraseRootFromParent_Done,
     /* 18417 */   // Label 600: @18417
     /* 18417 */   GIM_Try, /*On fail goto*//*Label 601*/ GIMT_Encode4(18453), // Rule ID 372 //
     /* 18422 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 18425 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbr),
     /* 18430 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 18433 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 18436 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18440 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18444 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8119:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBR:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
     /* 18444 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBR),
     /* 18447 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 18449 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 18451 */     GIR_RootConstrainSelectedInstOperands,
     /* 18452 */     // GIR_Coverage, 372,
     /* 18452 */     GIR_EraseRootFromParent_Done,
     /* 18453 */   // Label 601: @18453
     /* 18453 */   GIM_Try, /*On fail goto*//*Label 602*/ GIMT_Encode4(18489), // Rule ID 373 //
     /* 18458 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 18461 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbla),
     /* 18466 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 18469 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 18472 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18476 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18480 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8118:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBLA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
     /* 18480 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBLA),
     /* 18483 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 18485 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 18487 */     GIR_RootConstrainSelectedInstOperands,
     /* 18488 */     // GIR_Coverage, 373,
     /* 18488 */     GIR_EraseRootFromParent_Done,
     /* 18489 */   // Label 602: @18489
     /* 18489 */   GIM_Try, /*On fail goto*//*Label 603*/ GIMT_Encode4(18525), // Rule ID 374 //
     /* 18494 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 18497 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbra),
     /* 18502 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 18505 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 18508 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18512 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18516 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8120:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEQU_PH_QBRA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
     /* 18516 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBRA),
     /* 18519 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 18521 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 18523 */     GIR_RootConstrainSelectedInstOperands,
     /* 18524 */     // GIR_Coverage, 374,
     /* 18524 */     GIR_EraseRootFromParent_Done,
     /* 18525 */   // Label 603: @18525
     /* 18525 */   GIM_Try, /*On fail goto*//*Label 604*/ GIMT_Encode4(18561), // Rule ID 375 //
     /* 18530 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 18533 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbl),
     /* 18538 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 18541 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 18544 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18548 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18552 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8121:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBL:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
     /* 18552 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBL),
     /* 18555 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 18557 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 18559 */     GIR_RootConstrainSelectedInstOperands,
     /* 18560 */     // GIR_Coverage, 375,
     /* 18560 */     GIR_EraseRootFromParent_Done,
     /* 18561 */   // Label 604: @18561
     /* 18561 */   GIM_Try, /*On fail goto*//*Label 605*/ GIMT_Encode4(18597), // Rule ID 376 //
     /* 18566 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 18569 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbr),
     /* 18574 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 18577 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 18580 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18584 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18588 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8123:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBR:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
     /* 18588 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBR),
     /* 18591 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 18593 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 18595 */     GIR_RootConstrainSelectedInstOperands,
     /* 18596 */     // GIR_Coverage, 376,
     /* 18596 */     GIR_EraseRootFromParent_Done,
     /* 18597 */   // Label 605: @18597
     /* 18597 */   GIM_Try, /*On fail goto*//*Label 606*/ GIMT_Encode4(18633), // Rule ID 377 //
     /* 18602 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 18605 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbla),
     /* 18610 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 18613 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 18616 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18620 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18624 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8122:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBLA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
     /* 18624 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBLA),
     /* 18627 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 18629 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 18631 */     GIR_RootConstrainSelectedInstOperands,
     /* 18632 */     // GIR_Coverage, 377,
     /* 18632 */     GIR_EraseRootFromParent_Done,
     /* 18633 */   // Label 606: @18633
     /* 18633 */   GIM_Try, /*On fail goto*//*Label 607*/ GIMT_Encode4(18669), // Rule ID 378 //
     /* 18638 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 18641 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbra),
     /* 18646 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 18649 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 18652 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18656 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18660 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8124:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (PRECEU_PH_QBRA:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rt)
     /* 18660 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBRA),
     /* 18663 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 18665 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 18667 */     GIR_RootConstrainSelectedInstOperands,
     /* 18668 */     // GIR_Coverage, 378,
     /* 18668 */     GIR_EraseRootFromParent_Done,
     /* 18669 */   // Label 607: @18669
     /* 18669 */   GIM_Try, /*On fail goto*//*Label 608*/ GIMT_Encode4(18705), // Rule ID 426 //
     /* 18674 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 18677 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_bitrev),
     /* 18682 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 18685 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 18688 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 18692 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 18696 */     // (intrinsic_wo_chain:{ *:[i32] } 7689:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (BITREV:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt)
     /* 18696 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BITREV),
     /* 18699 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 18701 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 18703 */     GIR_RootConstrainSelectedInstOperands,
     /* 18704 */     // GIR_Coverage, 426,
     /* 18704 */     GIR_EraseRootFromParent_Done,
     /* 18705 */   // Label 608: @18705
     /* 18705 */   GIM_Try, /*On fail goto*//*Label 609*/ GIMT_Encode4(18741), // Rule ID 430 //
     /* 18710 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 18713 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_qb),
     /* 18718 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 18721 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 18724 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18728 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 18732 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8136:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (REPLV_QB:{ *:[v4i8] } GPR32Opnd:{ *:[i32] }:$rt)
     /* 18732 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPLV_QB),
     /* 18735 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 18737 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 18739 */     GIR_RootConstrainSelectedInstOperands,
     /* 18740 */     // GIR_Coverage, 430,
     /* 18740 */     GIR_EraseRootFromParent_Done,
     /* 18741 */   // Label 609: @18741
     /* 18741 */   GIM_Try, /*On fail goto*//*Label 610*/ GIMT_Encode4(18777), // Rule ID 431 //
     /* 18746 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 18749 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_ph),
     /* 18754 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 18757 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 18760 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 18764 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 18768 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8135:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt)  =>  (REPLV_PH:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rt)
     /* 18768 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPLV_PH),
     /* 18771 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 18773 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 18775 */     GIR_RootConstrainSelectedInstOperands,
     /* 18776 */     // GIR_Coverage, 431,
     /* 18776 */     GIR_EraseRootFromParent_Done,
     /* 18777 */   // Label 610: @18777
     /* 18777 */   GIM_Try, /*On fail goto*//*Label 611*/ GIMT_Encode4(18813), // Rule ID 680 //
     /* 18782 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 18785 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fclass_w),
     /* 18790 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 18793 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 18796 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 18800 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 18804 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7841:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FCLASS_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
     /* 18804 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FCLASS_W),
     /* 18807 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 18809 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 18811 */     GIR_RootConstrainSelectedInstOperands,
     /* 18812 */     // GIR_Coverage, 680,
     /* 18812 */     GIR_EraseRootFromParent_Done,
     /* 18813 */   // Label 611: @18813
     /* 18813 */   GIM_Try, /*On fail goto*//*Label 612*/ GIMT_Encode4(18849), // Rule ID 681 //
     /* 18818 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 18821 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fclass_d),
     /* 18826 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 18829 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 18832 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 18836 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 18840 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7840:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FCLASS_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
     /* 18840 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FCLASS_D),
     /* 18843 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 18845 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 18847 */     GIR_RootConstrainSelectedInstOperands,
     /* 18848 */     // GIR_Coverage, 681,
     /* 18848 */     GIR_EraseRootFromParent_Done,
     /* 18849 */   // Label 612: @18849
     /* 18849 */   GIM_Try, /*On fail goto*//*Label 613*/ GIMT_Encode4(18885), // Rule ID 704 //
     /* 18854 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 18857 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexupl_w),
     /* 18862 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 18865 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 18868 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 18872 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 18876 */     // (intrinsic_wo_chain:{ *:[v4f32] } 7867:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8f16] }:$ws)  =>  (FEXUPL_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8f16] }:$ws)
     /* 18876 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FEXUPL_W),
     /* 18879 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 18881 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 18883 */     GIR_RootConstrainSelectedInstOperands,
     /* 18884 */     // GIR_Coverage, 704,
     /* 18884 */     GIR_EraseRootFromParent_Done,
     /* 18885 */   // Label 613: @18885
     /* 18885 */   GIM_Try, /*On fail goto*//*Label 614*/ GIMT_Encode4(18921), // Rule ID 705 //
     /* 18890 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 18893 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexupl_d),
     /* 18898 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 18901 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 18904 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 18908 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 18912 */     // (intrinsic_wo_chain:{ *:[v2f64] } 7866:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FEXUPL_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4f32] }:$ws)
     /* 18912 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FEXUPL_D),
     /* 18915 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 18917 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 18919 */     GIR_RootConstrainSelectedInstOperands,
     /* 18920 */     // GIR_Coverage, 705,
     /* 18920 */     GIR_EraseRootFromParent_Done,
     /* 18921 */   // Label 614: @18921
     /* 18921 */   GIM_Try, /*On fail goto*//*Label 615*/ GIMT_Encode4(18957), // Rule ID 706 //
     /* 18926 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 18929 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexupr_w),
     /* 18934 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 18937 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 18940 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 18944 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 18948 */     // (intrinsic_wo_chain:{ *:[v4f32] } 7869:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8f16] }:$ws)  =>  (FEXUPR_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8f16] }:$ws)
     /* 18948 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FEXUPR_W),
     /* 18951 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 18953 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 18955 */     GIR_RootConstrainSelectedInstOperands,
     /* 18956 */     // GIR_Coverage, 706,
     /* 18956 */     GIR_EraseRootFromParent_Done,
     /* 18957 */   // Label 615: @18957
     /* 18957 */   GIM_Try, /*On fail goto*//*Label 616*/ GIMT_Encode4(18993), // Rule ID 707 //
     /* 18962 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 18965 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexupr_d),
     /* 18970 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 18973 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 18976 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 18980 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 18984 */     // (intrinsic_wo_chain:{ *:[v2f64] } 7868:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FEXUPR_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4f32] }:$ws)
     /* 18984 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FEXUPR_D),
     /* 18987 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 18989 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 18991 */     GIR_RootConstrainSelectedInstOperands,
     /* 18992 */     // GIR_Coverage, 707,
     /* 18992 */     GIR_EraseRootFromParent_Done,
     /* 18993 */   // Label 616: @18993
     /* 18993 */   GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(19029), // Rule ID 712 //
     /* 18998 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 19001 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ffql_w),
     /* 19006 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 19009 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 19012 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 19016 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 19020 */     // (intrinsic_wo_chain:{ *:[v4f32] } 7875:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws)  =>  (FFQL_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8i16] }:$ws)
     /* 19020 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FFQL_W),
     /* 19023 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 19025 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 19027 */     GIR_RootConstrainSelectedInstOperands,
     /* 19028 */     // GIR_Coverage, 712,
     /* 19028 */     GIR_EraseRootFromParent_Done,
     /* 19029 */   // Label 617: @19029
     /* 19029 */   GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(19065), // Rule ID 713 //
     /* 19034 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 19037 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ffql_d),
     /* 19042 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 19045 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 19048 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 19052 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 19056 */     // (intrinsic_wo_chain:{ *:[v2f64] } 7874:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (FFQL_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4i32] }:$ws)
     /* 19056 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FFQL_D),
     /* 19059 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 19061 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 19063 */     GIR_RootConstrainSelectedInstOperands,
     /* 19064 */     // GIR_Coverage, 713,
     /* 19064 */     GIR_EraseRootFromParent_Done,
     /* 19065 */   // Label 618: @19065
     /* 19065 */   GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(19101), // Rule ID 714 //
     /* 19070 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 19073 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ffqr_w),
     /* 19078 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 19081 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 19084 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 19088 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 19092 */     // (intrinsic_wo_chain:{ *:[v4f32] } 7877:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws)  =>  (FFQR_W:{ *:[v4f32] } MSA128HOpnd:{ *:[v8i16] }:$ws)
     /* 19092 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FFQR_W),
     /* 19095 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 19097 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 19099 */     GIR_RootConstrainSelectedInstOperands,
     /* 19100 */     // GIR_Coverage, 714,
     /* 19100 */     GIR_EraseRootFromParent_Done,
     /* 19101 */   // Label 619: @19101
     /* 19101 */   GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(19137), // Rule ID 715 //
     /* 19106 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 19109 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ffqr_d),
     /* 19114 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 19117 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 19120 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 19124 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 19128 */     // (intrinsic_wo_chain:{ *:[v2f64] } 7876:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (FFQR_D:{ *:[v2f64] } MSA128WOpnd:{ *:[v4i32] }:$ws)
     /* 19128 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FFQR_D),
     /* 19131 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 19133 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 19135 */     GIR_RootConstrainSelectedInstOperands,
     /* 19136 */     // GIR_Coverage, 715,
     /* 19136 */     GIR_EraseRootFromParent_Done,
     /* 19137 */   // Label 620: @19137
     /* 19137 */   GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(19173), // Rule ID 740 //
     /* 19142 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 19145 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_frcp_w),
     /* 19150 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 19153 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 19156 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 19160 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 19164 */     // (intrinsic_wo_chain:{ *:[v4f32] } 7899:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FRCP_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
     /* 19164 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FRCP_W),
     /* 19167 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 19169 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 19171 */     GIR_RootConstrainSelectedInstOperands,
     /* 19172 */     // GIR_Coverage, 740,
     /* 19172 */     GIR_EraseRootFromParent_Done,
     /* 19173 */   // Label 621: @19173
     /* 19173 */   GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(19209), // Rule ID 741 //
     /* 19178 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 19181 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_frcp_d),
     /* 19186 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 19189 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 19192 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 19196 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 19200 */     // (intrinsic_wo_chain:{ *:[v2f64] } 7898:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FRCP_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
     /* 19200 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FRCP_D),
     /* 19203 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 19205 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 19207 */     GIR_RootConstrainSelectedInstOperands,
     /* 19208 */     // GIR_Coverage, 741,
     /* 19208 */     GIR_EraseRootFromParent_Done,
     /* 19209 */   // Label 622: @19209
     /* 19209 */   GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(19245), // Rule ID 742 //
     /* 19214 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 19217 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_frsqrt_w),
     /* 19222 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 19225 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 19228 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 19232 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 19236 */     // (intrinsic_wo_chain:{ *:[v4f32] } 7903:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FRSQRT_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
     /* 19236 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FRSQRT_W),
     /* 19239 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 19241 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 19243 */     GIR_RootConstrainSelectedInstOperands,
     /* 19244 */     // GIR_Coverage, 742,
     /* 19244 */     GIR_EraseRootFromParent_Done,
     /* 19245 */   // Label 623: @19245
     /* 19245 */   GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(19281), // Rule ID 743 //
     /* 19250 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 19253 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_frsqrt_d),
     /* 19258 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 19261 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 19264 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 19268 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 19272 */     // (intrinsic_wo_chain:{ *:[v2f64] } 7902:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FRSQRT_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
     /* 19272 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FRSQRT_D),
     /* 19275 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 19277 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 19279 */     GIR_RootConstrainSelectedInstOperands,
     /* 19280 */     // GIR_Coverage, 743,
     /* 19280 */     GIR_EraseRootFromParent_Done,
     /* 19281 */   // Label 624: @19281
     /* 19281 */   GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(19317), // Rule ID 770 //
     /* 19286 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 19289 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftint_s_w),
     /* 19294 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 19297 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 19300 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 19304 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 19308 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7931:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FTINT_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
     /* 19308 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FTINT_S_W),
     /* 19311 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 19313 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 19315 */     GIR_RootConstrainSelectedInstOperands,
     /* 19316 */     // GIR_Coverage, 770,
     /* 19316 */     GIR_EraseRootFromParent_Done,
     /* 19317 */   // Label 625: @19317
     /* 19317 */   GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(19353), // Rule ID 771 //
     /* 19322 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 19325 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftint_s_d),
     /* 19330 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 19333 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 19336 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 19340 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 19344 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7930:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FTINT_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
     /* 19344 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FTINT_S_D),
     /* 19347 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 19349 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 19351 */     GIR_RootConstrainSelectedInstOperands,
     /* 19352 */     // GIR_Coverage, 771,
     /* 19352 */     GIR_EraseRootFromParent_Done,
     /* 19353 */   // Label 626: @19353
     /* 19353 */   GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(19389), // Rule ID 772 //
     /* 19358 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 19361 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftint_u_w),
     /* 19366 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 19369 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 19372 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 19376 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 19380 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7933:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws)  =>  (FTINT_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws)
     /* 19380 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FTINT_U_W),
     /* 19383 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 19385 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 19387 */     GIR_RootConstrainSelectedInstOperands,
     /* 19388 */     // GIR_Coverage, 772,
     /* 19388 */     GIR_EraseRootFromParent_Done,
     /* 19389 */   // Label 627: @19389
     /* 19389 */   GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(19425), // Rule ID 773 //
     /* 19394 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 19397 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftint_u_d),
     /* 19402 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 19405 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 19408 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 19412 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 19416 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7932:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws)  =>  (FTINT_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws)
     /* 19416 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FTINT_U_D),
     /* 19419 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 19421 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 19423 */     GIR_RootConstrainSelectedInstOperands,
     /* 19424 */     // GIR_Coverage, 773,
     /* 19424 */     GIR_EraseRootFromParent_Done,
     /* 19425 */   // Label 628: @19425
     /* 19425 */   GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(19461), // Rule ID 908 //
     /* 19430 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 19433 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_nloc_b),
     /* 19438 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 19441 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 19444 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 19448 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 19452 */     // (intrinsic_wo_chain:{ *:[v16i8] } 8088:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws)  =>  (NLOC_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws)
     /* 19452 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NLOC_B),
     /* 19455 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 19457 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 19459 */     GIR_RootConstrainSelectedInstOperands,
     /* 19460 */     // GIR_Coverage, 908,
     /* 19460 */     GIR_EraseRootFromParent_Done,
     /* 19461 */   // Label 629: @19461
     /* 19461 */   GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(19497), // Rule ID 909 //
     /* 19466 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 19469 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_nloc_h),
     /* 19474 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 19477 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 19480 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 19484 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 19488 */     // (intrinsic_wo_chain:{ *:[v8i16] } 8090:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws)  =>  (NLOC_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws)
     /* 19488 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NLOC_H),
     /* 19491 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 19493 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 19495 */     GIR_RootConstrainSelectedInstOperands,
     /* 19496 */     // GIR_Coverage, 909,
     /* 19496 */     GIR_EraseRootFromParent_Done,
     /* 19497 */   // Label 630: @19497
     /* 19497 */   GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(19533), // Rule ID 910 //
     /* 19502 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 19505 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_nloc_w),
     /* 19510 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 19513 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 19516 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 19520 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 19524 */     // (intrinsic_wo_chain:{ *:[v4i32] } 8091:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws)  =>  (NLOC_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws)
     /* 19524 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NLOC_W),
     /* 19527 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 19529 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 19531 */     GIR_RootConstrainSelectedInstOperands,
     /* 19532 */     // GIR_Coverage, 910,
     /* 19532 */     GIR_EraseRootFromParent_Done,
     /* 19533 */   // Label 631: @19533
     /* 19533 */   GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(19569), // Rule ID 911 //
     /* 19538 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 19541 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_nloc_d),
     /* 19546 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 19549 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 19552 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 19556 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 19560 */     // (intrinsic_wo_chain:{ *:[v2i64] } 8089:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws)  =>  (NLOC_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws)
     /* 19560 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::NLOC_D),
     /* 19563 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 19565 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 19567 */     GIR_RootConstrainSelectedInstOperands,
     /* 19568 */     // GIR_Coverage, 911,
     /* 19568 */     GIR_EraseRootFromParent_Done,
     /* 19569 */   // Label 632: @19569
     /* 19569 */   GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(19605), // Rule ID 1251 //
     /* 19574 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 19577 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceq_w_phl),
     /* 19582 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 19585 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 19588 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 19592 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 19596 */     // (intrinsic_wo_chain:{ *:[i32] } 8115:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs)  =>  (PRECEQ_W_PHL_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs)
     /* 19596 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQ_W_PHL_MM),
     /* 19599 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 19601 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 19603 */     GIR_RootConstrainSelectedInstOperands,
     /* 19604 */     // GIR_Coverage, 1251,
     /* 19604 */     GIR_EraseRootFromParent_Done,
     /* 19605 */   // Label 633: @19605
     /* 19605 */   GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(19641), // Rule ID 1252 //
     /* 19610 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 19613 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceq_w_phr),
     /* 19618 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 19621 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 19624 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 19628 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 19632 */     // (intrinsic_wo_chain:{ *:[i32] } 8116:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs)  =>  (PRECEQ_W_PHR_MM:{ *:[i32] } DSPROpnd:{ *:[v2i16] }:$rs)
     /* 19632 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQ_W_PHR_MM),
     /* 19635 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 19637 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 19639 */     GIR_RootConstrainSelectedInstOperands,
     /* 19640 */     // GIR_Coverage, 1252,
     /* 19640 */     GIR_EraseRootFromParent_Done,
     /* 19641 */   // Label 634: @19641
     /* 19641 */   GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(19677), // Rule ID 1253 //
     /* 19646 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 19649 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbl),
     /* 19654 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 19657 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 19660 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 19664 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 19668 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8117:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBL_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
     /* 19668 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBL_MM),
     /* 19671 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 19673 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 19675 */     GIR_RootConstrainSelectedInstOperands,
     /* 19676 */     // GIR_Coverage, 1253,
     /* 19676 */     GIR_EraseRootFromParent_Done,
     /* 19677 */   // Label 635: @19677
     /* 19677 */   GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(19713), // Rule ID 1254 //
     /* 19682 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 19685 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbla),
     /* 19690 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 19693 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 19696 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 19700 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 19704 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8118:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBLA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
     /* 19704 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBLA_MM),
     /* 19707 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 19709 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 19711 */     GIR_RootConstrainSelectedInstOperands,
     /* 19712 */     // GIR_Coverage, 1254,
     /* 19712 */     GIR_EraseRootFromParent_Done,
     /* 19713 */   // Label 636: @19713
     /* 19713 */   GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(19749), // Rule ID 1255 //
     /* 19718 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 19721 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbr),
     /* 19726 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 19729 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 19732 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 19736 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 19740 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8119:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBR_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
     /* 19740 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBR_MM),
     /* 19743 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 19745 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 19747 */     GIR_RootConstrainSelectedInstOperands,
     /* 19748 */     // GIR_Coverage, 1255,
     /* 19748 */     GIR_EraseRootFromParent_Done,
     /* 19749 */   // Label 637: @19749
     /* 19749 */   GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(19785), // Rule ID 1256 //
     /* 19754 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 19757 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precequ_ph_qbra),
     /* 19762 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 19765 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 19768 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 19772 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 19776 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8120:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEQU_PH_QBRA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
     /* 19776 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEQU_PH_QBRA_MM),
     /* 19779 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 19781 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 19783 */     GIR_RootConstrainSelectedInstOperands,
     /* 19784 */     // GIR_Coverage, 1256,
     /* 19784 */     GIR_EraseRootFromParent_Done,
     /* 19785 */   // Label 638: @19785
     /* 19785 */   GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(19821), // Rule ID 1257 //
     /* 19790 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 19793 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbl),
     /* 19798 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 19801 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 19804 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 19808 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 19812 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8121:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBL_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
     /* 19812 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBL_MM),
     /* 19815 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 19817 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 19819 */     GIR_RootConstrainSelectedInstOperands,
     /* 19820 */     // GIR_Coverage, 1257,
     /* 19820 */     GIR_EraseRootFromParent_Done,
     /* 19821 */   // Label 639: @19821
     /* 19821 */   GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(19857), // Rule ID 1258 //
     /* 19826 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 19829 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbla),
     /* 19834 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 19837 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 19840 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 19844 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 19848 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8122:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBLA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
     /* 19848 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBLA_MM),
     /* 19851 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 19853 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 19855 */     GIR_RootConstrainSelectedInstOperands,
     /* 19856 */     // GIR_Coverage, 1258,
     /* 19856 */     GIR_EraseRootFromParent_Done,
     /* 19857 */   // Label 640: @19857
     /* 19857 */   GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(19893), // Rule ID 1259 //
     /* 19862 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 19865 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbr),
     /* 19870 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 19873 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 19876 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 19880 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 19884 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8123:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBR_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
     /* 19884 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBR_MM),
     /* 19887 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 19889 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 19891 */     GIR_RootConstrainSelectedInstOperands,
     /* 19892 */     // GIR_Coverage, 1259,
     /* 19892 */     GIR_EraseRootFromParent_Done,
     /* 19893 */   // Label 641: @19893
     /* 19893 */   GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(19929), // Rule ID 1260 //
     /* 19898 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 19901 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_preceu_ph_qbra),
     /* 19906 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 19909 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 19912 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 19916 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 19920 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8124:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (PRECEU_PH_QBRA_MM:{ *:[v2i16] } DSPROpnd:{ *:[v4i8] }:$rs)
     /* 19920 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECEU_PH_QBRA_MM),
     /* 19923 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 19925 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 19927 */     GIR_RootConstrainSelectedInstOperands,
     /* 19928 */     // GIR_Coverage, 1260,
     /* 19928 */     GIR_EraseRootFromParent_Done,
     /* 19929 */   // Label 642: @19929
     /* 19929 */   GIM_Try, /*On fail goto*//*Label 643*/ GIMT_Encode4(19965), // Rule ID 1286 //
     /* 19934 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 19937 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_raddu_w_qb),
     /* 19942 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 19945 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 19948 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 19952 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 19956 */     // (intrinsic_wo_chain:{ *:[i32] } 8133:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs)  =>  (RADDU_W_QB_MM:{ *:[i32] } DSPROpnd:{ *:[v4i8] }:$rs)
     /* 19956 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::RADDU_W_QB_MM),
     /* 19959 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 19961 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 19963 */     GIR_RootConstrainSelectedInstOperands,
     /* 19964 */     // GIR_Coverage, 1286,
     /* 19964 */     GIR_EraseRootFromParent_Done,
     /* 19965 */   // Label 643: @19965
     /* 19965 */   GIM_Try, /*On fail goto*//*Label 644*/ GIMT_Encode4(20001), // Rule ID 1290 //
     /* 19970 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 19973 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_ph),
     /* 19978 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 19981 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 19984 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 19988 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 19992 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8135:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (REPLV_PH_MM:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs)
     /* 19992 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPLV_PH_MM),
     /* 19995 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 19997 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 19999 */     GIR_RootConstrainSelectedInstOperands,
     /* 20000 */     // GIR_Coverage, 1290,
     /* 20000 */     GIR_EraseRootFromParent_Done,
     /* 20001 */   // Label 644: @20001
     /* 20001 */   GIM_Try, /*On fail goto*//*Label 645*/ GIMT_Encode4(20037), // Rule ID 1291 //
     /* 20006 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 20009 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_repl_qb),
     /* 20014 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 20017 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 20020 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 20024 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 20028 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8136:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (REPLV_QB_MM:{ *:[v4i8] } GPR32Opnd:{ *:[i32] }:$rs)
     /* 20028 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::REPLV_QB_MM),
     /* 20031 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 20033 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 20035 */     GIR_RootConstrainSelectedInstOperands,
     /* 20036 */     // GIR_Coverage, 1291,
     /* 20036 */     GIR_EraseRootFromParent_Done,
     /* 20037 */   // Label 645: @20037
     /* 20037 */   GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(20073), // Rule ID 1301 //
     /* 20042 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 20045 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_bitrev),
     /* 20050 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 20053 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 20056 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 20060 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 20064 */     // (intrinsic_wo_chain:{ *:[i32] } 7689:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs)  =>  (BITREV_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs)
     /* 20064 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BITREV_MM),
     /* 20067 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 20069 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 20071 */     GIR_RootConstrainSelectedInstOperands,
     /* 20072 */     // GIR_Coverage, 1301,
     /* 20072 */     GIR_EraseRootFromParent_Done,
     /* 20073 */   // Label 646: @20073
     /* 20073 */   GIM_Reject,
     /* 20074 */ // Label 592: @20074
     /* 20074 */ GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(29827),
     /* 20079 */   GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
     /* 20082 */   GIM_Try, /*On fail goto*//*Label 648*/ GIMT_Encode4(20128), // Rule ID 938 //
     /* 20087 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 20090 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_s_b),
     /* 20095 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 20098 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 20101 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 20105 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 20109 */     // MIs[0] m
     /* 20109 */     GIM_CheckIsImm, /*MI*/0, /*Op*/3,
     /* 20112 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt3),
     /* 20117 */     // (intrinsic_wo_chain:{ *:[v16i8] } 8137:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$m)  =>  (SAT_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$m)
     /* 20117 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_S_B),
     /* 20120 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 20122 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 20124 */     GIR_RootToRootCopy, /*OpIdx*/3, // m
     /* 20126 */     GIR_RootConstrainSelectedInstOperands,
     /* 20127 */     // GIR_Coverage, 938,
     /* 20127 */     GIR_EraseRootFromParent_Done,
     /* 20128 */   // Label 648: @20128
     /* 20128 */   GIM_Try, /*On fail goto*//*Label 649*/ GIMT_Encode4(20174), // Rule ID 939 //
     /* 20133 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 20136 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_s_h),
     /* 20141 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 20144 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 20147 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 20151 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 20155 */     // MIs[0] m
     /* 20155 */     GIM_CheckIsImm, /*MI*/0, /*Op*/3,
     /* 20158 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt4),
     /* 20163 */     // (intrinsic_wo_chain:{ *:[v8i16] } 8139:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$m)  =>  (SAT_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$m)
     /* 20163 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_S_H),
     /* 20166 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 20168 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 20170 */     GIR_RootToRootCopy, /*OpIdx*/3, // m
     /* 20172 */     GIR_RootConstrainSelectedInstOperands,
     /* 20173 */     // GIR_Coverage, 939,
     /* 20173 */     GIR_EraseRootFromParent_Done,
     /* 20174 */   // Label 649: @20174
     /* 20174 */   GIM_Try, /*On fail goto*//*Label 650*/ GIMT_Encode4(20220), // Rule ID 940 //
     /* 20179 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 20182 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_s_w),
     /* 20187 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 20190 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 20193 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 20197 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 20201 */     // MIs[0] m
     /* 20201 */     GIM_CheckIsImm, /*MI*/0, /*Op*/3,
     /* 20204 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
     /* 20209 */     // (intrinsic_wo_chain:{ *:[v4i32] } 8140:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$m)  =>  (SAT_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$m)
     /* 20209 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_S_W),
     /* 20212 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 20214 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 20216 */     GIR_RootToRootCopy, /*OpIdx*/3, // m
     /* 20218 */     GIR_RootConstrainSelectedInstOperands,
     /* 20219 */     // GIR_Coverage, 940,
     /* 20219 */     GIR_EraseRootFromParent_Done,
     /* 20220 */   // Label 650: @20220
     /* 20220 */   GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(20266), // Rule ID 941 //
     /* 20225 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 20228 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_s_d),
     /* 20233 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 20236 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 20239 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 20243 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 20247 */     // MIs[0] m
     /* 20247 */     GIM_CheckIsImm, /*MI*/0, /*Op*/3,
     /* 20250 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt6),
     /* 20255 */     // (intrinsic_wo_chain:{ *:[v2i64] } 8138:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt6>>:$m)  =>  (SAT_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$m)
     /* 20255 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_S_D),
     /* 20258 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 20260 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 20262 */     GIR_RootToRootCopy, /*OpIdx*/3, // m
     /* 20264 */     GIR_RootConstrainSelectedInstOperands,
     /* 20265 */     // GIR_Coverage, 941,
     /* 20265 */     GIR_EraseRootFromParent_Done,
     /* 20266 */   // Label 651: @20266
     /* 20266 */   GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(20312), // Rule ID 942 //
     /* 20271 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 20274 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_u_b),
     /* 20279 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 20282 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 20285 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 20289 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 20293 */     // MIs[0] m
     /* 20293 */     GIM_CheckIsImm, /*MI*/0, /*Op*/3,
     /* 20296 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt3),
     /* 20301 */     // (intrinsic_wo_chain:{ *:[v16i8] } 8141:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$m)  =>  (SAT_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$m)
     /* 20301 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_U_B),
     /* 20304 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 20306 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 20308 */     GIR_RootToRootCopy, /*OpIdx*/3, // m
     /* 20310 */     GIR_RootConstrainSelectedInstOperands,
     /* 20311 */     // GIR_Coverage, 942,
     /* 20311 */     GIR_EraseRootFromParent_Done,
     /* 20312 */   // Label 652: @20312
     /* 20312 */   GIM_Try, /*On fail goto*//*Label 653*/ GIMT_Encode4(20358), // Rule ID 943 //
     /* 20317 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 20320 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_u_h),
     /* 20325 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 20328 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 20331 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 20335 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 20339 */     // MIs[0] m
     /* 20339 */     GIM_CheckIsImm, /*MI*/0, /*Op*/3,
     /* 20342 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt4),
     /* 20347 */     // (intrinsic_wo_chain:{ *:[v8i16] } 8143:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$m)  =>  (SAT_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$m)
     /* 20347 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_U_H),
     /* 20350 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 20352 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 20354 */     GIR_RootToRootCopy, /*OpIdx*/3, // m
     /* 20356 */     GIR_RootConstrainSelectedInstOperands,
     /* 20357 */     // GIR_Coverage, 943,
     /* 20357 */     GIR_EraseRootFromParent_Done,
     /* 20358 */   // Label 653: @20358
     /* 20358 */   GIM_Try, /*On fail goto*//*Label 654*/ GIMT_Encode4(20404), // Rule ID 944 //
     /* 20363 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 20366 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_u_w),
     /* 20371 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 20374 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 20377 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 20381 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 20385 */     // MIs[0] m
     /* 20385 */     GIM_CheckIsImm, /*MI*/0, /*Op*/3,
     /* 20388 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
     /* 20393 */     // (intrinsic_wo_chain:{ *:[v4i32] } 8144:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$m)  =>  (SAT_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$m)
     /* 20393 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_U_W),
     /* 20396 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 20398 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 20400 */     GIR_RootToRootCopy, /*OpIdx*/3, // m
     /* 20402 */     GIR_RootConstrainSelectedInstOperands,
     /* 20403 */     // GIR_Coverage, 944,
     /* 20403 */     GIR_EraseRootFromParent_Done,
     /* 20404 */   // Label 654: @20404
     /* 20404 */   GIM_Try, /*On fail goto*//*Label 655*/ GIMT_Encode4(20450), // Rule ID 945 //
     /* 20409 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 20412 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sat_u_d),
     /* 20417 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 20420 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 20423 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 20427 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 20431 */     // MIs[0] m
     /* 20431 */     GIM_CheckIsImm, /*MI*/0, /*Op*/3,
     /* 20434 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt6),
     /* 20439 */     // (intrinsic_wo_chain:{ *:[v2i64] } 8142:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt6>>:$m)  =>  (SAT_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$m)
     /* 20439 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SAT_U_D),
     /* 20442 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 20444 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 20446 */     GIR_RootToRootCopy, /*OpIdx*/3, // m
     /* 20448 */     GIR_RootConstrainSelectedInstOperands,
     /* 20449 */     // GIR_Coverage, 945,
     /* 20449 */     GIR_EraseRootFromParent_Done,
     /* 20450 */   // Label 655: @20450
     /* 20450 */   GIM_Try, /*On fail goto*//*Label 656*/ GIMT_Encode4(20496), // Rule ID 985 //
     /* 20455 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 20458 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srari_b),
     /* 20463 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 20466 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 20469 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 20473 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 20477 */     // MIs[0] m
     /* 20477 */     GIM_CheckIsImm, /*MI*/0, /*Op*/3,
     /* 20480 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt3),
     /* 20485 */     // (intrinsic_wo_chain:{ *:[v16i8] } 8196:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$m)  =>  (SRARI_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$m)
     /* 20485 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRARI_B),
     /* 20488 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 20490 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 20492 */     GIR_RootToRootCopy, /*OpIdx*/3, // m
     /* 20494 */     GIR_RootConstrainSelectedInstOperands,
     /* 20495 */     // GIR_Coverage, 985,
     /* 20495 */     GIR_EraseRootFromParent_Done,
     /* 20496 */   // Label 656: @20496
     /* 20496 */   GIM_Try, /*On fail goto*//*Label 657*/ GIMT_Encode4(20542), // Rule ID 986 //
     /* 20501 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 20504 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srari_h),
     /* 20509 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 20512 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 20515 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 20519 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 20523 */     // MIs[0] m
     /* 20523 */     GIM_CheckIsImm, /*MI*/0, /*Op*/3,
     /* 20526 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt4),
     /* 20531 */     // (intrinsic_wo_chain:{ *:[v8i16] } 8198:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$m)  =>  (SRARI_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$m)
     /* 20531 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRARI_H),
     /* 20534 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 20536 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 20538 */     GIR_RootToRootCopy, /*OpIdx*/3, // m
     /* 20540 */     GIR_RootConstrainSelectedInstOperands,
     /* 20541 */     // GIR_Coverage, 986,
     /* 20541 */     GIR_EraseRootFromParent_Done,
     /* 20542 */   // Label 657: @20542
     /* 20542 */   GIM_Try, /*On fail goto*//*Label 658*/ GIMT_Encode4(20588), // Rule ID 987 //
     /* 20547 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 20550 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srari_w),
     /* 20555 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 20558 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 20561 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 20565 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 20569 */     // MIs[0] m
     /* 20569 */     GIM_CheckIsImm, /*MI*/0, /*Op*/3,
     /* 20572 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
     /* 20577 */     // (intrinsic_wo_chain:{ *:[v4i32] } 8199:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$m)  =>  (SRARI_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$m)
     /* 20577 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRARI_W),
     /* 20580 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 20582 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 20584 */     GIR_RootToRootCopy, /*OpIdx*/3, // m
     /* 20586 */     GIR_RootConstrainSelectedInstOperands,
     /* 20587 */     // GIR_Coverage, 987,
     /* 20587 */     GIR_EraseRootFromParent_Done,
     /* 20588 */   // Label 658: @20588
     /* 20588 */   GIM_Try, /*On fail goto*//*Label 659*/ GIMT_Encode4(20634), // Rule ID 988 //
     /* 20593 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 20596 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srari_d),
     /* 20601 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 20604 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 20607 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 20611 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 20615 */     // MIs[0] m
     /* 20615 */     GIM_CheckIsImm, /*MI*/0, /*Op*/3,
     /* 20618 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt6),
     /* 20623 */     // (intrinsic_wo_chain:{ *:[v2i64] } 8197:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt6>>:$m)  =>  (SRARI_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$m)
     /* 20623 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRARI_D),
     /* 20626 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 20628 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 20630 */     GIR_RootToRootCopy, /*OpIdx*/3, // m
     /* 20632 */     GIR_RootConstrainSelectedInstOperands,
     /* 20633 */     // GIR_Coverage, 988,
     /* 20633 */     GIR_EraseRootFromParent_Done,
     /* 20634 */   // Label 659: @20634
     /* 20634 */   GIM_Try, /*On fail goto*//*Label 660*/ GIMT_Encode4(20680), // Rule ID 1001 //
     /* 20639 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 20642 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlri_b),
     /* 20647 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 20650 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 20653 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 20657 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 20661 */     // MIs[0] m
     /* 20661 */     GIM_CheckIsImm, /*MI*/0, /*Op*/3,
     /* 20664 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt3),
     /* 20669 */     // (intrinsic_wo_chain:{ *:[v16i8] } 8212:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$m)  =>  (SRLRI_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$m)
     /* 20669 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLRI_B),
     /* 20672 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 20674 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 20676 */     GIR_RootToRootCopy, /*OpIdx*/3, // m
     /* 20678 */     GIR_RootConstrainSelectedInstOperands,
     /* 20679 */     // GIR_Coverage, 1001,
     /* 20679 */     GIR_EraseRootFromParent_Done,
     /* 20680 */   // Label 660: @20680
     /* 20680 */   GIM_Try, /*On fail goto*//*Label 661*/ GIMT_Encode4(20726), // Rule ID 1002 //
     /* 20685 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 20688 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlri_h),
     /* 20693 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 20696 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 20699 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 20703 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 20707 */     // MIs[0] m
     /* 20707 */     GIM_CheckIsImm, /*MI*/0, /*Op*/3,
     /* 20710 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt4),
     /* 20715 */     // (intrinsic_wo_chain:{ *:[v8i16] } 8214:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$m)  =>  (SRLRI_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$m)
     /* 20715 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLRI_H),
     /* 20718 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 20720 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 20722 */     GIR_RootToRootCopy, /*OpIdx*/3, // m
     /* 20724 */     GIR_RootConstrainSelectedInstOperands,
     /* 20725 */     // GIR_Coverage, 1002,
     /* 20725 */     GIR_EraseRootFromParent_Done,
     /* 20726 */   // Label 661: @20726
     /* 20726 */   GIM_Try, /*On fail goto*//*Label 662*/ GIMT_Encode4(20772), // Rule ID 1003 //
     /* 20731 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 20734 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlri_w),
     /* 20739 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 20742 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 20745 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 20749 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 20753 */     // MIs[0] m
     /* 20753 */     GIM_CheckIsImm, /*MI*/0, /*Op*/3,
     /* 20756 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
     /* 20761 */     // (intrinsic_wo_chain:{ *:[v4i32] } 8215:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$m)  =>  (SRLRI_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$m)
     /* 20761 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLRI_W),
     /* 20764 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 20766 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 20768 */     GIR_RootToRootCopy, /*OpIdx*/3, // m
     /* 20770 */     GIR_RootConstrainSelectedInstOperands,
     /* 20771 */     // GIR_Coverage, 1003,
     /* 20771 */     GIR_EraseRootFromParent_Done,
     /* 20772 */   // Label 662: @20772
     /* 20772 */   GIM_Try, /*On fail goto*//*Label 663*/ GIMT_Encode4(20818), // Rule ID 1004 //
     /* 20777 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 20780 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlri_d),
     /* 20785 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 20788 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 20791 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 20795 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 20799 */     // MIs[0] m
     /* 20799 */     GIM_CheckIsImm, /*MI*/0, /*Op*/3,
     /* 20802 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt6),
     /* 20807 */     // (intrinsic_wo_chain:{ *:[v2i64] } 8213:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt6>>:$m)  =>  (SRLRI_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$m)
     /* 20807 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLRI_D),
     /* 20810 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 20812 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 20814 */     GIR_RootToRootCopy, /*OpIdx*/3, // m
     /* 20816 */     GIR_RootConstrainSelectedInstOperands,
     /* 20817 */     // GIR_Coverage, 1004,
     /* 20817 */     GIR_EraseRootFromParent_Done,
     /* 20818 */   // Label 663: @20818
     /* 20818 */   GIM_Try, /*On fail goto*//*Label 664*/ GIMT_Encode4(20874), // Rule ID 385 //
     /* 20823 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 20826 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_ph),
     /* 20831 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 20834 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 20837 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 20840 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 20844 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 20848 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
     /* 20852 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 20856 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
     /* 20860 */     // MIs[1] Operand 1
     /* 20860 */     // No operand predicates
     /* 20860 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 20862 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8155:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$rs_sa)  =>  (SHRA_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, (imm:{ *:[i32] }):$rs_sa)
     /* 20862 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_PH),
     /* 20865 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 20867 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 20869 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
     /* 20872 */     GIR_RootConstrainSelectedInstOperands,
     /* 20873 */     // GIR_Coverage, 385,
     /* 20873 */     GIR_EraseRootFromParent_Done,
     /* 20874 */   // Label 664: @20874
     /* 20874 */   GIM_Try, /*On fail goto*//*Label 665*/ GIMT_Encode4(20930), // Rule ID 389 //
     /* 20879 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 20882 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_w),
     /* 20887 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 20890 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 20893 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 20896 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 20900 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 20904 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
     /* 20908 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 20912 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
     /* 20916 */     // MIs[1] Operand 1
     /* 20916 */     // No operand predicates
     /* 20916 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 20918 */     // (intrinsic_wo_chain:{ *:[i32] } 8157:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$rs_sa)  =>  (SHRA_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, (imm:{ *:[i32] }):$rs_sa)
     /* 20918 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_W),
     /* 20921 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 20923 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 20925 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
     /* 20928 */     GIR_RootConstrainSelectedInstOperands,
     /* 20929 */     // GIR_Coverage, 389,
     /* 20929 */     GIR_EraseRootFromParent_Done,
     /* 20930 */   // Label 665: @20930
     /* 20930 */   GIM_Try, /*On fail goto*//*Label 666*/ GIMT_Encode4(20986), // Rule ID 480 //
     /* 20935 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 20938 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_qb),
     /* 20943 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 20946 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 20949 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 20952 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 20956 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 20960 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
     /* 20964 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 20968 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt3),
     /* 20972 */     // MIs[1] Operand 1
     /* 20972 */     // No operand predicates
     /* 20972 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 20974 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8156:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$rs_sa)  =>  (SHRA_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, (imm:{ *:[i32] }):$rs_sa)
     /* 20974 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_QB),
     /* 20977 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 20979 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 20981 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // rs_sa
     /* 20984 */     GIR_RootConstrainSelectedInstOperands,
     /* 20985 */     // GIR_Coverage, 480,
     /* 20985 */     GIR_EraseRootFromParent_Done,
     /* 20986 */   // Label 666: @20986
     /* 20986 */   GIM_Try, /*On fail goto*//*Label 667*/ GIMT_Encode4(21042), // Rule ID 1245 //
     /* 20991 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 20994 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_ph),
     /* 20999 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 21002 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 21005 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 21008 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21012 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21016 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
     /* 21020 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 21024 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
     /* 21028 */     // MIs[1] Operand 1
     /* 21028 */     // No operand predicates
     /* 21028 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 21030 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8155:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$sa)  =>  (SHRA_R_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, (imm:{ *:[i32] }):$sa)
     /* 21030 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_PH_MM),
     /* 21033 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 21035 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 21037 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
     /* 21040 */     GIR_RootConstrainSelectedInstOperands,
     /* 21041 */     // GIR_Coverage, 1245,
     /* 21041 */     GIR_EraseRootFromParent_Done,
     /* 21042 */   // Label 667: @21042
     /* 21042 */   GIM_Try, /*On fail goto*//*Label 668*/ GIMT_Encode4(21098), // Rule ID 1249 //
     /* 21047 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 21050 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_w),
     /* 21055 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 21058 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 21061 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 21064 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 21068 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 21072 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
     /* 21076 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 21080 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt5),
     /* 21084 */     // MIs[1] Operand 1
     /* 21084 */     // No operand predicates
     /* 21084 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 21086 */     // (intrinsic_wo_chain:{ *:[i32] } 8157:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt5>>:$sa)  =>  (SHRA_R_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$sa)
     /* 21086 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_W_MM),
     /* 21089 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 21091 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 21093 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
     /* 21096 */     GIR_RootConstrainSelectedInstOperands,
     /* 21097 */     // GIR_Coverage, 1249,
     /* 21097 */     GIR_EraseRootFromParent_Done,
     /* 21098 */   // Label 668: @21098
     /* 21098 */   GIM_Try, /*On fail goto*//*Label 669*/ GIMT_Encode4(21154), // Rule ID 1324 //
     /* 21103 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 21106 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_qb),
     /* 21111 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 21114 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 21117 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 21120 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21124 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21128 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
     /* 21132 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 21136 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt3),
     /* 21140 */     // MIs[1] Operand 1
     /* 21140 */     // No operand predicates
     /* 21140 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 21142 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8156:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$sa)  =>  (SHRA_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, (imm:{ *:[i32] }):$sa)
     /* 21142 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_R_QB_MMR2),
     /* 21145 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 21147 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 21149 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // sa
     /* 21152 */     GIR_RootConstrainSelectedInstOperands,
     /* 21153 */     // GIR_Coverage, 1324,
     /* 21153 */     GIR_EraseRootFromParent_Done,
     /* 21154 */   // Label 669: @21154
     /* 21154 */   GIM_Try, /*On fail goto*//*Label 670*/ GIMT_Encode4(21206), // Rule ID 1943 //
     /* 21159 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 21162 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_ph),
     /* 21167 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 21170 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 21173 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 21176 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21180 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
     /* 21184 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 21188 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
     /* 21192 */     // MIs[1] Operand 1
     /* 21192 */     // No operand predicates
     /* 21192 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 21194 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8153:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)  =>  (SHRA_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)
     /* 21194 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_PH),
     /* 21197 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 21199 */     GIR_RootToRootCopy, /*OpIdx*/2, // a
     /* 21201 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
     /* 21204 */     GIR_RootConstrainSelectedInstOperands,
     /* 21205 */     // GIR_Coverage, 1943,
     /* 21205 */     GIR_EraseRootFromParent_Done,
     /* 21206 */   // Label 670: @21206
     /* 21206 */   GIM_Try, /*On fail goto*//*Label 671*/ GIMT_Encode4(21258), // Rule ID 1944 //
     /* 21211 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 21214 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_ph),
     /* 21219 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 21222 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 21225 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 21228 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21232 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
     /* 21236 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 21240 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt4),
     /* 21244 */     // MIs[1] Operand 1
     /* 21244 */     // No operand predicates
     /* 21244 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 21246 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8158:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)  =>  (SHRL_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt4>>:$shamt)
     /* 21246 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRL_PH),
     /* 21249 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 21251 */     GIR_RootToRootCopy, /*OpIdx*/2, // a
     /* 21253 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
     /* 21256 */     GIR_RootConstrainSelectedInstOperands,
     /* 21257 */     // GIR_Coverage, 1944,
     /* 21257 */     GIR_EraseRootFromParent_Done,
     /* 21258 */   // Label 671: @21258
     /* 21258 */   GIM_Try, /*On fail goto*//*Label 672*/ GIMT_Encode4(21310), // Rule ID 1949 //
     /* 21263 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 21266 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_qb),
     /* 21271 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 21274 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 21277 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 21280 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21284 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
     /* 21288 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 21292 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt3),
     /* 21296 */     // MIs[1] Operand 1
     /* 21296 */     // No operand predicates
     /* 21296 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 21298 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8154:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)  =>  (SHRA_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)
     /* 21298 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRA_QB),
     /* 21301 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 21303 */     GIR_RootToRootCopy, /*OpIdx*/2, // a
     /* 21305 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
     /* 21308 */     GIR_RootConstrainSelectedInstOperands,
     /* 21309 */     // GIR_Coverage, 1949,
     /* 21309 */     GIR_EraseRootFromParent_Done,
     /* 21310 */   // Label 672: @21310
     /* 21310 */   GIM_Try, /*On fail goto*//*Label 673*/ GIMT_Encode4(21362), // Rule ID 1950 //
     /* 21315 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 21318 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_qb),
     /* 21323 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 21326 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 21329 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 21332 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21336 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
     /* 21340 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 21344 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt3),
     /* 21348 */     // MIs[1] Operand 1
     /* 21348 */     // No operand predicates
     /* 21348 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 21350 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8159:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)  =>  (SHRL_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, (imm:{ *:[i32] })<<P:Predicate_immZExt3>>:$shamt)
     /* 21350 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRL_QB),
     /* 21353 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 21355 */     GIR_RootToRootCopy, /*OpIdx*/2, // a
     /* 21357 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // shamt
     /* 21360 */     GIR_RootConstrainSelectedInstOperands,
     /* 21361 */     // GIR_Coverage, 1950,
     /* 21361 */     GIR_EraseRootFromParent_Done,
     /* 21362 */   // Label 673: @21362
     /* 21362 */   GIM_Try, /*On fail goto*//*Label 674*/ GIMT_Encode4(21410), // Rule ID 355 //
     /* 21367 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 21370 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_s_qb),
     /* 21375 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 21378 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 21381 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
     /* 21384 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21388 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21392 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21396 */     // (intrinsic_wo_chain:{ *:[v4i8] } 7625:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDU_S_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
     /* 21396 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDU_S_QB),
     /* 21399 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 21401 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 21403 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 21405 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
     /* 21408 */     GIR_RootConstrainSelectedInstOperands,
     /* 21409 */     // GIR_Coverage, 355,
     /* 21409 */     GIR_EraseRootFromParent_Done,
     /* 21410 */   // Label 674: @21410
     /* 21410 */   GIM_Try, /*On fail goto*//*Label 675*/ GIMT_Encode4(21458), // Rule ID 356 //
     /* 21415 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 21418 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_s_qb),
     /* 21423 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 21426 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 21429 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
     /* 21432 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21436 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21440 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21444 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8248:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBU_S_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
     /* 21444 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBU_S_QB),
     /* 21447 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 21449 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 21451 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 21453 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
     /* 21456 */     GIR_RootConstrainSelectedInstOperands,
     /* 21457 */     // GIR_Coverage, 356,
     /* 21457 */     GIR_EraseRootFromParent_Done,
     /* 21458 */   // Label 675: @21458
     /* 21458 */   GIM_Try, /*On fail goto*//*Label 676*/ GIMT_Encode4(21506), // Rule ID 357 //
     /* 21463 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 21466 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addq_s_ph),
     /* 21471 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 21474 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 21477 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
     /* 21480 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21484 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21488 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21492 */     // (intrinsic_wo_chain:{ *:[v2i16] } 7603:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
     /* 21492 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQ_S_PH),
     /* 21495 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 21497 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 21499 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 21501 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
     /* 21504 */     GIR_RootConstrainSelectedInstOperands,
     /* 21505 */     // GIR_Coverage, 357,
     /* 21505 */     GIR_EraseRootFromParent_Done,
     /* 21506 */   // Label 676: @21506
     /* 21506 */   GIM_Try, /*On fail goto*//*Label 677*/ GIMT_Encode4(21554), // Rule ID 358 //
     /* 21511 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 21514 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subq_s_ph),
     /* 21519 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 21522 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 21525 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
     /* 21528 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21532 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21536 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21540 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8223:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQ_S_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
     /* 21540 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQ_S_PH),
     /* 21543 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 21545 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 21547 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 21549 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
     /* 21552 */     GIR_RootConstrainSelectedInstOperands,
     /* 21553 */     // GIR_Coverage, 358,
     /* 21553 */     GIR_EraseRootFromParent_Done,
     /* 21554 */   // Label 677: @21554
     /* 21554 */   GIM_Try, /*On fail goto*//*Label 678*/ GIMT_Encode4(21599), // Rule ID 361 //
     /* 21559 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 21562 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_modsub),
     /* 21567 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 21570 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 21573 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 21576 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 21580 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 21584 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 21588 */     // (intrinsic_wo_chain:{ *:[i32] } 8053:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODSUB:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /* 21588 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MODSUB),
     /* 21591 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 21593 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 21595 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 21597 */     GIR_RootConstrainSelectedInstOperands,
     /* 21598 */     // GIR_Coverage, 361,
     /* 21598 */     GIR_EraseRootFromParent_Done,
     /* 21599 */   // Label 678: @21599
     /* 21599 */   GIM_Try, /*On fail goto*//*Label 679*/ GIMT_Encode4(21644), // Rule ID 365 //
     /* 21604 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 21607 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_qb_ph),
     /* 21612 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 21615 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 21618 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
     /* 21621 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21625 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21629 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21633 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8129:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQ_QB_PH:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
     /* 21633 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_QB_PH),
     /* 21636 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 21638 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 21640 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 21642 */     GIR_RootConstrainSelectedInstOperands,
     /* 21643 */     // GIR_Coverage, 365,
     /* 21643 */     GIR_EraseRootFromParent_Done,
     /* 21644 */   // Label 679: @21644
     /* 21644 */   GIM_Try, /*On fail goto*//*Label 680*/ GIMT_Encode4(21689), // Rule ID 366 //
     /* 21649 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 21652 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_ph_w),
     /* 21657 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 21660 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 21663 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 21666 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21670 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 21674 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 21678 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8128:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /* 21678 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_PH_W),
     /* 21681 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 21683 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 21685 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 21687 */     GIR_RootConstrainSelectedInstOperands,
     /* 21688 */     // GIR_Coverage, 366,
     /* 21688 */     GIR_EraseRootFromParent_Done,
     /* 21689 */   // Label 680: @21689
     /* 21689 */   GIM_Try, /*On fail goto*//*Label 681*/ GIMT_Encode4(21734), // Rule ID 380 //
     /* 21694 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 21697 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_qb),
     /* 21702 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 21705 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 21708 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 21711 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21715 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21719 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 21723 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8159:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRLV_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
     /* 21723 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRLV_QB),
     /* 21726 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 21728 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 21730 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
     /* 21732 */     GIR_RootConstrainSelectedInstOperands,
     /* 21733 */     // GIR_Coverage, 380,
     /* 21733 */     GIR_EraseRootFromParent_Done,
     /* 21734 */   // Label 681: @21734
     /* 21734 */   GIM_Try, /*On fail goto*//*Label 682*/ GIMT_Encode4(21779), // Rule ID 384 //
     /* 21739 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 21742 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_ph),
     /* 21747 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 21750 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 21753 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 21756 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21760 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21764 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 21768 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8153:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
     /* 21768 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_PH),
     /* 21771 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 21773 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 21775 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
     /* 21777 */     GIR_RootConstrainSelectedInstOperands,
     /* 21778 */     // GIR_Coverage, 384,
     /* 21778 */     GIR_EraseRootFromParent_Done,
     /* 21779 */   // Label 682: @21779
     /* 21779 */   GIM_Try, /*On fail goto*//*Label 683*/ GIMT_Encode4(21824), // Rule ID 386 //
     /* 21784 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 21787 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_ph),
     /* 21792 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 21795 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 21798 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 21801 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21805 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21809 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 21813 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8155:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
     /* 21813 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_PH),
     /* 21816 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 21818 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 21820 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
     /* 21822 */     GIR_RootConstrainSelectedInstOperands,
     /* 21823 */     // GIR_Coverage, 386,
     /* 21823 */     GIR_EraseRootFromParent_Done,
     /* 21824 */   // Label 683: @21824
     /* 21824 */   GIM_Try, /*On fail goto*//*Label 684*/ GIMT_Encode4(21869), // Rule ID 390 //
     /* 21829 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 21832 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_w),
     /* 21837 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 21840 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 21843 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 21846 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 21850 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 21854 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 21858 */     // (intrinsic_wo_chain:{ *:[i32] } 8157:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
     /* 21858 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_W),
     /* 21861 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 21863 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 21865 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
     /* 21867 */     GIR_RootConstrainSelectedInstOperands,
     /* 21868 */     // GIR_Coverage, 390,
     /* 21868 */     GIR_EraseRootFromParent_Done,
     /* 21869 */   // Label 684: @21869
     /* 21869 */   GIM_Try, /*On fail goto*//*Label 685*/ GIMT_Encode4(21914), // Rule ID 427 //
     /* 21874 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 21877 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_packrl_ph),
     /* 21882 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 21885 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 21888 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
     /* 21891 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21895 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21899 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21903 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8100:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PACKRL_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
     /* 21903 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PACKRL_PH),
     /* 21906 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 21908 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 21910 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 21912 */     GIR_RootConstrainSelectedInstOperands,
     /* 21913 */     // GIR_Coverage, 427,
     /* 21913 */     GIR_EraseRootFromParent_Done,
     /* 21914 */   // Label 685: @21914
     /* 21914 */   GIM_Try, /*On fail goto*//*Label 686*/ GIMT_Encode4(21959), // Rule ID 451 //
     /* 21919 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 21922 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adduh_qb),
     /* 21927 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 21930 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 21933 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
     /* 21936 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21940 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21944 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21948 */     // (intrinsic_wo_chain:{ *:[v4i8] } 7626:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
     /* 21948 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDUH_QB),
     /* 21951 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 21953 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 21955 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 21957 */     GIR_RootConstrainSelectedInstOperands,
     /* 21958 */     // GIR_Coverage, 451,
     /* 21958 */     GIR_EraseRootFromParent_Done,
     /* 21959 */   // Label 686: @21959
     /* 21959 */   GIM_Try, /*On fail goto*//*Label 687*/ GIMT_Encode4(22004), // Rule ID 452 //
     /* 21964 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 21967 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adduh_r_qb),
     /* 21972 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 21975 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 21978 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
     /* 21981 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21985 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21989 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 21993 */     // (intrinsic_wo_chain:{ *:[v4i8] } 7627:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
     /* 21993 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDUH_R_QB),
     /* 21996 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 21998 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 22000 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 22002 */     GIR_RootConstrainSelectedInstOperands,
     /* 22003 */     // GIR_Coverage, 452,
     /* 22003 */     GIR_EraseRootFromParent_Done,
     /* 22004 */   // Label 687: @22004
     /* 22004 */   GIM_Try, /*On fail goto*//*Label 688*/ GIMT_Encode4(22049), // Rule ID 453 //
     /* 22009 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 22012 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subuh_qb),
     /* 22017 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 22020 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 22023 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
     /* 22026 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22030 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22034 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22038 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8249:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
     /* 22038 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBUH_QB),
     /* 22041 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 22043 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 22045 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 22047 */     GIR_RootConstrainSelectedInstOperands,
     /* 22048 */     // GIR_Coverage, 453,
     /* 22048 */     GIR_EraseRootFromParent_Done,
     /* 22049 */   // Label 688: @22049
     /* 22049 */   GIM_Try, /*On fail goto*//*Label 689*/ GIMT_Encode4(22094), // Rule ID 454 //
     /* 22054 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 22057 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subuh_r_qb),
     /* 22062 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 22065 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 22068 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
     /* 22071 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22075 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22079 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22083 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8250:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
     /* 22083 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBUH_R_QB),
     /* 22086 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 22088 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 22090 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 22092 */     GIR_RootConstrainSelectedInstOperands,
     /* 22093 */     // GIR_Coverage, 454,
     /* 22093 */     GIR_EraseRootFromParent_Done,
     /* 22094 */   // Label 689: @22094
     /* 22094 */   GIM_Try, /*On fail goto*//*Label 690*/ GIMT_Encode4(22139), // Rule ID 455 //
     /* 22099 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 22102 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_ph),
     /* 22107 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 22110 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 22113 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
     /* 22116 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22120 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22124 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22128 */     // (intrinsic_wo_chain:{ *:[v2i16] } 7605:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
     /* 22128 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_PH),
     /* 22131 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 22133 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 22135 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 22137 */     GIR_RootConstrainSelectedInstOperands,
     /* 22138 */     // GIR_Coverage, 455,
     /* 22138 */     GIR_EraseRootFromParent_Done,
     /* 22139 */   // Label 690: @22139
     /* 22139 */   GIM_Try, /*On fail goto*//*Label 691*/ GIMT_Encode4(22184), // Rule ID 456 //
     /* 22144 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 22147 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_r_ph),
     /* 22152 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 22155 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 22158 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
     /* 22161 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22165 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22169 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22173 */     // (intrinsic_wo_chain:{ *:[v2i16] } 7606:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
     /* 22173 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_R_PH),
     /* 22176 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 22178 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 22180 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 22182 */     GIR_RootConstrainSelectedInstOperands,
     /* 22183 */     // GIR_Coverage, 456,
     /* 22183 */     GIR_EraseRootFromParent_Done,
     /* 22184 */   // Label 691: @22184
     /* 22184 */   GIM_Try, /*On fail goto*//*Label 692*/ GIMT_Encode4(22229), // Rule ID 457 //
     /* 22189 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 22192 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_ph),
     /* 22197 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 22200 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 22203 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
     /* 22206 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22210 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22214 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22218 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8225:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
     /* 22218 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_PH),
     /* 22221 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 22223 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 22225 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 22227 */     GIR_RootConstrainSelectedInstOperands,
     /* 22228 */     // GIR_Coverage, 457,
     /* 22228 */     GIR_EraseRootFromParent_Done,
     /* 22229 */   // Label 692: @22229
     /* 22229 */   GIM_Try, /*On fail goto*//*Label 693*/ GIMT_Encode4(22274), // Rule ID 458 //
     /* 22234 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 22237 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_r_ph),
     /* 22242 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 22245 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 22248 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
     /* 22251 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22255 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22259 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22263 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8226:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_R_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
     /* 22263 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_R_PH),
     /* 22266 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 22268 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 22270 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 22272 */     GIR_RootConstrainSelectedInstOperands,
     /* 22273 */     // GIR_Coverage, 458,
     /* 22273 */     GIR_EraseRootFromParent_Done,
     /* 22274 */   // Label 693: @22274
     /* 22274 */   GIM_Try, /*On fail goto*//*Label 694*/ GIMT_Encode4(22319), // Rule ID 459 //
     /* 22279 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 22282 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_w),
     /* 22287 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 22290 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 22293 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 22296 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 22300 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 22304 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 22308 */     // (intrinsic_wo_chain:{ *:[i32] } 7608:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /* 22308 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_W),
     /* 22311 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 22313 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 22315 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 22317 */     GIR_RootConstrainSelectedInstOperands,
     /* 22318 */     // GIR_Coverage, 459,
     /* 22318 */     GIR_EraseRootFromParent_Done,
     /* 22319 */   // Label 694: @22319
     /* 22319 */   GIM_Try, /*On fail goto*//*Label 695*/ GIMT_Encode4(22364), // Rule ID 460 //
     /* 22324 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 22327 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_r_w),
     /* 22332 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 22335 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 22338 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 22341 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 22345 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 22349 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 22353 */     // (intrinsic_wo_chain:{ *:[i32] } 7607:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /* 22353 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_R_W),
     /* 22356 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 22358 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 22360 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 22362 */     GIR_RootConstrainSelectedInstOperands,
     /* 22363 */     // GIR_Coverage, 460,
     /* 22363 */     GIR_EraseRootFromParent_Done,
     /* 22364 */   // Label 695: @22364
     /* 22364 */   GIM_Try, /*On fail goto*//*Label 696*/ GIMT_Encode4(22409), // Rule ID 461 //
     /* 22369 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 22372 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_w),
     /* 22377 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 22380 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 22383 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 22386 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 22390 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 22394 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 22398 */     // (intrinsic_wo_chain:{ *:[i32] } 8228:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /* 22398 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_W),
     /* 22401 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 22403 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 22405 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 22407 */     GIR_RootConstrainSelectedInstOperands,
     /* 22408 */     // GIR_Coverage, 461,
     /* 22408 */     GIR_EraseRootFromParent_Done,
     /* 22409 */   // Label 696: @22409
     /* 22409 */   GIM_Try, /*On fail goto*//*Label 697*/ GIMT_Encode4(22454), // Rule ID 462 //
     /* 22414 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 22417 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_r_w),
     /* 22422 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 22425 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 22428 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 22431 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 22435 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 22439 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 22443 */     // (intrinsic_wo_chain:{ *:[i32] } 8227:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_R_W:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /* 22443 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_R_W),
     /* 22446 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 22448 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 22450 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 22452 */     GIR_RootConstrainSelectedInstOperands,
     /* 22453 */     // GIR_Coverage, 462,
     /* 22453 */     GIR_EraseRootFromParent_Done,
     /* 22454 */   // Label 697: @22454
     /* 22454 */   GIM_Try, /*On fail goto*//*Label 698*/ GIMT_Encode4(22499), // Rule ID 479 //
     /* 22459 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 22462 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_qb),
     /* 22467 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 22470 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 22473 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 22476 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22480 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22484 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 22488 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8154:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
     /* 22488 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_QB),
     /* 22491 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 22493 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 22495 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
     /* 22497 */     GIR_RootConstrainSelectedInstOperands,
     /* 22498 */     // GIR_Coverage, 479,
     /* 22498 */     GIR_EraseRootFromParent_Done,
     /* 22499 */   // Label 698: @22499
     /* 22499 */   GIM_Try, /*On fail goto*//*Label 699*/ GIMT_Encode4(22544), // Rule ID 481 //
     /* 22504 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 22507 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_qb),
     /* 22512 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 22515 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 22518 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 22521 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22525 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22529 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 22533 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8156:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRAV_R_QB:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
     /* 22533 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_QB),
     /* 22536 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 22538 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 22540 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
     /* 22542 */     GIR_RootConstrainSelectedInstOperands,
     /* 22543 */     // GIR_Coverage, 481,
     /* 22543 */     GIR_EraseRootFromParent_Done,
     /* 22544 */   // Label 699: @22544
     /* 22544 */   GIM_Try, /*On fail goto*//*Label 700*/ GIMT_Encode4(22589), // Rule ID 482 //
     /* 22549 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 22552 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_ph),
     /* 22557 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 22560 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 22563 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 22566 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22570 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 22574 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 22578 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8158:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)  =>  (SHRLV_PH:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs_sa)
     /* 22578 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRLV_PH),
     /* 22581 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 22583 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 22585 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs_sa
     /* 22587 */     GIR_RootConstrainSelectedInstOperands,
     /* 22588 */     // GIR_Coverage, 482,
     /* 22588 */     GIR_EraseRootFromParent_Done,
     /* 22589 */   // Label 700: @22589
     /* 22589 */   GIM_Try, /*On fail goto*//*Label 701*/ GIMT_Encode4(22634), // Rule ID 491 //
     /* 22594 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 22597 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_add_a_b),
     /* 22602 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 22605 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 22608 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 22611 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 22615 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 22619 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 22623 */     // (intrinsic_wo_chain:{ *:[v16i8] } 7598:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADD_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 22623 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADD_A_B),
     /* 22626 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 22628 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 22630 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 22632 */     GIR_RootConstrainSelectedInstOperands,
     /* 22633 */     // GIR_Coverage, 491,
     /* 22633 */     GIR_EraseRootFromParent_Done,
     /* 22634 */   // Label 701: @22634
     /* 22634 */   GIM_Try, /*On fail goto*//*Label 702*/ GIMT_Encode4(22679), // Rule ID 492 //
     /* 22639 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 22642 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_add_a_h),
     /* 22647 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 22650 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 22653 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 22656 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 22660 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 22664 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 22668 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7600:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADD_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 22668 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADD_A_H),
     /* 22671 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 22673 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 22675 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 22677 */     GIR_RootConstrainSelectedInstOperands,
     /* 22678 */     // GIR_Coverage, 492,
     /* 22678 */     GIR_EraseRootFromParent_Done,
     /* 22679 */   // Label 702: @22679
     /* 22679 */   GIM_Try, /*On fail goto*//*Label 703*/ GIMT_Encode4(22724), // Rule ID 493 //
     /* 22684 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 22687 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_add_a_w),
     /* 22692 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 22695 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 22698 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 22701 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 22705 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 22709 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 22713 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7601:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADD_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 22713 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADD_A_W),
     /* 22716 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 22718 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 22720 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 22722 */     GIR_RootConstrainSelectedInstOperands,
     /* 22723 */     // GIR_Coverage, 493,
     /* 22723 */     GIR_EraseRootFromParent_Done,
     /* 22724 */   // Label 703: @22724
     /* 22724 */   GIM_Try, /*On fail goto*//*Label 704*/ GIMT_Encode4(22769), // Rule ID 494 //
     /* 22729 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 22732 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_add_a_d),
     /* 22737 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 22740 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 22743 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 22746 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 22750 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 22754 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 22758 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7599:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADD_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /* 22758 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADD_A_D),
     /* 22761 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 22763 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 22765 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 22767 */     GIR_RootConstrainSelectedInstOperands,
     /* 22768 */     // GIR_Coverage, 494,
     /* 22768 */     GIR_EraseRootFromParent_Done,
     /* 22769 */   // Label 704: @22769
     /* 22769 */   GIM_Try, /*On fail goto*//*Label 705*/ GIMT_Encode4(22814), // Rule ID 495 //
     /* 22774 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 22777 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_a_b),
     /* 22782 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 22785 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 22788 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 22791 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 22795 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 22799 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 22803 */     // (intrinsic_wo_chain:{ *:[v16i8] } 7609:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDS_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 22803 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_A_B),
     /* 22806 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 22808 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 22810 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 22812 */     GIR_RootConstrainSelectedInstOperands,
     /* 22813 */     // GIR_Coverage, 495,
     /* 22813 */     GIR_EraseRootFromParent_Done,
     /* 22814 */   // Label 705: @22814
     /* 22814 */   GIM_Try, /*On fail goto*//*Label 706*/ GIMT_Encode4(22859), // Rule ID 496 //
     /* 22819 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 22822 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_a_h),
     /* 22827 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 22830 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 22833 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 22836 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 22840 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 22844 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 22848 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7611:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDS_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 22848 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_A_H),
     /* 22851 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 22853 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 22855 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 22857 */     GIR_RootConstrainSelectedInstOperands,
     /* 22858 */     // GIR_Coverage, 496,
     /* 22858 */     GIR_EraseRootFromParent_Done,
     /* 22859 */   // Label 706: @22859
     /* 22859 */   GIM_Try, /*On fail goto*//*Label 707*/ GIMT_Encode4(22904), // Rule ID 497 //
     /* 22864 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 22867 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_a_w),
     /* 22872 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 22875 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 22878 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 22881 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 22885 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 22889 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 22893 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7612:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDS_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 22893 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_A_W),
     /* 22896 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 22898 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 22900 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 22902 */     GIR_RootConstrainSelectedInstOperands,
     /* 22903 */     // GIR_Coverage, 497,
     /* 22903 */     GIR_EraseRootFromParent_Done,
     /* 22904 */   // Label 707: @22904
     /* 22904 */   GIM_Try, /*On fail goto*//*Label 708*/ GIMT_Encode4(22949), // Rule ID 498 //
     /* 22909 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 22912 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_a_d),
     /* 22917 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 22920 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 22923 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 22926 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 22930 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 22934 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 22938 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7610:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDS_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /* 22938 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_A_D),
     /* 22941 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 22943 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 22945 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 22947 */     GIR_RootConstrainSelectedInstOperands,
     /* 22948 */     // GIR_Coverage, 498,
     /* 22948 */     GIR_EraseRootFromParent_Done,
     /* 22949 */   // Label 708: @22949
     /* 22949 */   GIM_Try, /*On fail goto*//*Label 709*/ GIMT_Encode4(22994), // Rule ID 499 //
     /* 22954 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 22957 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_s_b),
     /* 22962 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 22965 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 22968 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 22971 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 22975 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 22979 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 22983 */     // (intrinsic_wo_chain:{ *:[v16i8] } 7613:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDS_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 22983 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_S_B),
     /* 22986 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 22988 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 22990 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 22992 */     GIR_RootConstrainSelectedInstOperands,
     /* 22993 */     // GIR_Coverage, 499,
     /* 22993 */     GIR_EraseRootFromParent_Done,
     /* 22994 */   // Label 709: @22994
     /* 22994 */   GIM_Try, /*On fail goto*//*Label 710*/ GIMT_Encode4(23039), // Rule ID 500 //
     /* 22999 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23002 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_s_h),
     /* 23007 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 23010 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 23013 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 23016 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 23020 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 23024 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 23028 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7615:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDS_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 23028 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_S_H),
     /* 23031 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23033 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23035 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23037 */     GIR_RootConstrainSelectedInstOperands,
     /* 23038 */     // GIR_Coverage, 500,
     /* 23038 */     GIR_EraseRootFromParent_Done,
     /* 23039 */   // Label 710: @23039
     /* 23039 */   GIM_Try, /*On fail goto*//*Label 711*/ GIMT_Encode4(23084), // Rule ID 501 //
     /* 23044 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23047 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_s_w),
     /* 23052 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 23055 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 23058 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 23061 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 23065 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 23069 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 23073 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7616:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDS_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 23073 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_S_W),
     /* 23076 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23078 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23080 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23082 */     GIR_RootConstrainSelectedInstOperands,
     /* 23083 */     // GIR_Coverage, 501,
     /* 23083 */     GIR_EraseRootFromParent_Done,
     /* 23084 */   // Label 711: @23084
     /* 23084 */   GIM_Try, /*On fail goto*//*Label 712*/ GIMT_Encode4(23129), // Rule ID 502 //
     /* 23089 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23092 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_s_d),
     /* 23097 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 23100 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 23103 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 23106 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 23110 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 23114 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 23118 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7614:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDS_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /* 23118 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_S_D),
     /* 23121 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23123 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23125 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23127 */     GIR_RootConstrainSelectedInstOperands,
     /* 23128 */     // GIR_Coverage, 502,
     /* 23128 */     GIR_EraseRootFromParent_Done,
     /* 23129 */   // Label 712: @23129
     /* 23129 */   GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(23174), // Rule ID 503 //
     /* 23134 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23137 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_u_b),
     /* 23142 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 23145 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 23148 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 23151 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 23155 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 23159 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 23163 */     // (intrinsic_wo_chain:{ *:[v16i8] } 7617:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ADDS_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 23163 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_U_B),
     /* 23166 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23168 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23170 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23172 */     GIR_RootConstrainSelectedInstOperands,
     /* 23173 */     // GIR_Coverage, 503,
     /* 23173 */     GIR_EraseRootFromParent_Done,
     /* 23174 */   // Label 713: @23174
     /* 23174 */   GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(23219), // Rule ID 504 //
     /* 23179 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23182 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_u_h),
     /* 23187 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 23190 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 23193 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 23196 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 23200 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 23204 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 23208 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7619:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ADDS_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 23208 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_U_H),
     /* 23211 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23213 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23215 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23217 */     GIR_RootConstrainSelectedInstOperands,
     /* 23218 */     // GIR_Coverage, 504,
     /* 23218 */     GIR_EraseRootFromParent_Done,
     /* 23219 */   // Label 714: @23219
     /* 23219 */   GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(23264), // Rule ID 505 //
     /* 23224 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23227 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_u_w),
     /* 23232 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 23235 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 23238 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 23241 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 23245 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 23249 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 23253 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7620:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ADDS_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 23253 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_U_W),
     /* 23256 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23258 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23260 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23262 */     GIR_RootConstrainSelectedInstOperands,
     /* 23263 */     // GIR_Coverage, 505,
     /* 23263 */     GIR_EraseRootFromParent_Done,
     /* 23264 */   // Label 715: @23264
     /* 23264 */   GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(23309), // Rule ID 506 //
     /* 23269 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23272 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adds_u_d),
     /* 23277 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 23280 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 23283 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 23286 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 23290 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 23294 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 23298 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7618:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ADDS_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /* 23298 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDS_U_D),
     /* 23301 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23303 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23305 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23307 */     GIR_RootConstrainSelectedInstOperands,
     /* 23308 */     // GIR_Coverage, 506,
     /* 23308 */     GIR_EraseRootFromParent_Done,
     /* 23309 */   // Label 716: @23309
     /* 23309 */   GIM_Try, /*On fail goto*//*Label 717*/ GIMT_Encode4(23354), // Rule ID 520 //
     /* 23314 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23317 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_s_b),
     /* 23322 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 23325 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 23328 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 23331 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 23335 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 23339 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 23343 */     // (intrinsic_wo_chain:{ *:[v16i8] } 7640:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ASUB_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 23343 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_S_B),
     /* 23346 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23348 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23350 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23352 */     GIR_RootConstrainSelectedInstOperands,
     /* 23353 */     // GIR_Coverage, 520,
     /* 23353 */     GIR_EraseRootFromParent_Done,
     /* 23354 */   // Label 717: @23354
     /* 23354 */   GIM_Try, /*On fail goto*//*Label 718*/ GIMT_Encode4(23399), // Rule ID 521 //
     /* 23359 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23362 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_s_h),
     /* 23367 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 23370 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 23373 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 23376 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 23380 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 23384 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 23388 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7642:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ASUB_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 23388 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_S_H),
     /* 23391 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23393 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23395 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23397 */     GIR_RootConstrainSelectedInstOperands,
     /* 23398 */     // GIR_Coverage, 521,
     /* 23398 */     GIR_EraseRootFromParent_Done,
     /* 23399 */   // Label 718: @23399
     /* 23399 */   GIM_Try, /*On fail goto*//*Label 719*/ GIMT_Encode4(23444), // Rule ID 522 //
     /* 23404 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23407 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_s_w),
     /* 23412 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 23415 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 23418 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 23421 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 23425 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 23429 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 23433 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7643:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ASUB_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 23433 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_S_W),
     /* 23436 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23438 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23440 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23442 */     GIR_RootConstrainSelectedInstOperands,
     /* 23443 */     // GIR_Coverage, 522,
     /* 23443 */     GIR_EraseRootFromParent_Done,
     /* 23444 */   // Label 719: @23444
     /* 23444 */   GIM_Try, /*On fail goto*//*Label 720*/ GIMT_Encode4(23489), // Rule ID 523 //
     /* 23449 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23452 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_s_d),
     /* 23457 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 23460 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 23463 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 23466 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 23470 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 23474 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 23478 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7641:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ASUB_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /* 23478 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_S_D),
     /* 23481 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23483 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23485 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23487 */     GIR_RootConstrainSelectedInstOperands,
     /* 23488 */     // GIR_Coverage, 523,
     /* 23488 */     GIR_EraseRootFromParent_Done,
     /* 23489 */   // Label 720: @23489
     /* 23489 */   GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(23534), // Rule ID 524 //
     /* 23494 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23497 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_u_b),
     /* 23502 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 23505 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 23508 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 23511 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 23515 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 23519 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 23523 */     // (intrinsic_wo_chain:{ *:[v16i8] } 7644:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (ASUB_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 23523 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_U_B),
     /* 23526 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23528 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23530 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23532 */     GIR_RootConstrainSelectedInstOperands,
     /* 23533 */     // GIR_Coverage, 524,
     /* 23533 */     GIR_EraseRootFromParent_Done,
     /* 23534 */   // Label 721: @23534
     /* 23534 */   GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(23579), // Rule ID 525 //
     /* 23539 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23542 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_u_h),
     /* 23547 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 23550 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 23553 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 23556 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 23560 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 23564 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 23568 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7646:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (ASUB_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 23568 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_U_H),
     /* 23571 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23573 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23575 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23577 */     GIR_RootConstrainSelectedInstOperands,
     /* 23578 */     // GIR_Coverage, 525,
     /* 23578 */     GIR_EraseRootFromParent_Done,
     /* 23579 */   // Label 722: @23579
     /* 23579 */   GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(23624), // Rule ID 526 //
     /* 23584 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23587 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_u_w),
     /* 23592 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 23595 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 23598 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 23601 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 23605 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 23609 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 23613 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7647:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (ASUB_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 23613 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_U_W),
     /* 23616 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23618 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23620 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23622 */     GIR_RootConstrainSelectedInstOperands,
     /* 23623 */     // GIR_Coverage, 526,
     /* 23623 */     GIR_EraseRootFromParent_Done,
     /* 23624 */   // Label 723: @23624
     /* 23624 */   GIM_Try, /*On fail goto*//*Label 724*/ GIMT_Encode4(23669), // Rule ID 527 //
     /* 23629 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23632 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_asub_u_d),
     /* 23637 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 23640 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 23643 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 23646 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 23650 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 23654 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 23658 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7645:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (ASUB_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /* 23658 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ASUB_U_D),
     /* 23661 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23663 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23665 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23667 */     GIR_RootConstrainSelectedInstOperands,
     /* 23668 */     // GIR_Coverage, 527,
     /* 23668 */     GIR_EraseRootFromParent_Done,
     /* 23669 */   // Label 724: @23669
     /* 23669 */   GIM_Try, /*On fail goto*//*Label 725*/ GIMT_Encode4(23714), // Rule ID 528 //
     /* 23674 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23677 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_s_b),
     /* 23682 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 23685 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 23688 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 23691 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 23695 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 23699 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 23703 */     // (intrinsic_wo_chain:{ *:[v16i8] } 7648:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVE_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 23703 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_S_B),
     /* 23706 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23708 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23710 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23712 */     GIR_RootConstrainSelectedInstOperands,
     /* 23713 */     // GIR_Coverage, 528,
     /* 23713 */     GIR_EraseRootFromParent_Done,
     /* 23714 */   // Label 725: @23714
     /* 23714 */   GIM_Try, /*On fail goto*//*Label 726*/ GIMT_Encode4(23759), // Rule ID 529 //
     /* 23719 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23722 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_s_h),
     /* 23727 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 23730 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 23733 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 23736 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 23740 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 23744 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 23748 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7650:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVE_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 23748 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_S_H),
     /* 23751 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23753 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23755 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23757 */     GIR_RootConstrainSelectedInstOperands,
     /* 23758 */     // GIR_Coverage, 529,
     /* 23758 */     GIR_EraseRootFromParent_Done,
     /* 23759 */   // Label 726: @23759
     /* 23759 */   GIM_Try, /*On fail goto*//*Label 727*/ GIMT_Encode4(23804), // Rule ID 530 //
     /* 23764 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23767 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_s_w),
     /* 23772 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 23775 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 23778 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 23781 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 23785 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 23789 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 23793 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7651:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVE_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 23793 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_S_W),
     /* 23796 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23798 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23800 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23802 */     GIR_RootConstrainSelectedInstOperands,
     /* 23803 */     // GIR_Coverage, 530,
     /* 23803 */     GIR_EraseRootFromParent_Done,
     /* 23804 */   // Label 727: @23804
     /* 23804 */   GIM_Try, /*On fail goto*//*Label 728*/ GIMT_Encode4(23849), // Rule ID 531 //
     /* 23809 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23812 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_s_d),
     /* 23817 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 23820 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 23823 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 23826 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 23830 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 23834 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 23838 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7649:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVE_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /* 23838 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_S_D),
     /* 23841 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23843 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23845 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23847 */     GIR_RootConstrainSelectedInstOperands,
     /* 23848 */     // GIR_Coverage, 531,
     /* 23848 */     GIR_EraseRootFromParent_Done,
     /* 23849 */   // Label 728: @23849
     /* 23849 */   GIM_Try, /*On fail goto*//*Label 729*/ GIMT_Encode4(23894), // Rule ID 532 //
     /* 23854 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23857 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_u_b),
     /* 23862 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 23865 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 23868 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 23871 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 23875 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 23879 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 23883 */     // (intrinsic_wo_chain:{ *:[v16i8] } 7652:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVE_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 23883 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_U_B),
     /* 23886 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23888 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23890 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23892 */     GIR_RootConstrainSelectedInstOperands,
     /* 23893 */     // GIR_Coverage, 532,
     /* 23893 */     GIR_EraseRootFromParent_Done,
     /* 23894 */   // Label 729: @23894
     /* 23894 */   GIM_Try, /*On fail goto*//*Label 730*/ GIMT_Encode4(23939), // Rule ID 533 //
     /* 23899 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23902 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_u_h),
     /* 23907 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 23910 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 23913 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 23916 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 23920 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 23924 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 23928 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7654:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVE_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 23928 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_U_H),
     /* 23931 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23933 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23935 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23937 */     GIR_RootConstrainSelectedInstOperands,
     /* 23938 */     // GIR_Coverage, 533,
     /* 23938 */     GIR_EraseRootFromParent_Done,
     /* 23939 */   // Label 730: @23939
     /* 23939 */   GIM_Try, /*On fail goto*//*Label 731*/ GIMT_Encode4(23984), // Rule ID 534 //
     /* 23944 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23947 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_u_w),
     /* 23952 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 23955 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 23958 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 23961 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 23965 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 23969 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 23973 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7655:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVE_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 23973 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_U_W),
     /* 23976 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 23978 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 23980 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 23982 */     GIR_RootConstrainSelectedInstOperands,
     /* 23983 */     // GIR_Coverage, 534,
     /* 23983 */     GIR_EraseRootFromParent_Done,
     /* 23984 */   // Label 731: @23984
     /* 23984 */   GIM_Try, /*On fail goto*//*Label 732*/ GIMT_Encode4(24029), // Rule ID 535 //
     /* 23989 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 23992 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ave_u_d),
     /* 23997 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 24000 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 24003 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 24006 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 24010 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 24014 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 24018 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7653:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVE_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /* 24018 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVE_U_D),
     /* 24021 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24023 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24025 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24027 */     GIR_RootConstrainSelectedInstOperands,
     /* 24028 */     // GIR_Coverage, 535,
     /* 24028 */     GIR_EraseRootFromParent_Done,
     /* 24029 */   // Label 732: @24029
     /* 24029 */   GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(24074), // Rule ID 536 //
     /* 24034 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24037 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_s_b),
     /* 24042 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 24045 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 24048 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 24051 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 24055 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 24059 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 24063 */     // (intrinsic_wo_chain:{ *:[v16i8] } 7656:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVER_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 24063 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_S_B),
     /* 24066 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24068 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24070 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24072 */     GIR_RootConstrainSelectedInstOperands,
     /* 24073 */     // GIR_Coverage, 536,
     /* 24073 */     GIR_EraseRootFromParent_Done,
     /* 24074 */   // Label 733: @24074
     /* 24074 */   GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(24119), // Rule ID 537 //
     /* 24079 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24082 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_s_h),
     /* 24087 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 24090 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 24093 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 24096 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 24100 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 24104 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 24108 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7658:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVER_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 24108 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_S_H),
     /* 24111 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24113 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24115 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24117 */     GIR_RootConstrainSelectedInstOperands,
     /* 24118 */     // GIR_Coverage, 537,
     /* 24118 */     GIR_EraseRootFromParent_Done,
     /* 24119 */   // Label 734: @24119
     /* 24119 */   GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(24164), // Rule ID 538 //
     /* 24124 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24127 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_s_w),
     /* 24132 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 24135 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 24138 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 24141 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24145 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24149 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24153 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7659:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVER_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 24153 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_S_W),
     /* 24156 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24158 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24160 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24162 */     GIR_RootConstrainSelectedInstOperands,
     /* 24163 */     // GIR_Coverage, 538,
     /* 24163 */     GIR_EraseRootFromParent_Done,
     /* 24164 */   // Label 735: @24164
     /* 24164 */   GIM_Try, /*On fail goto*//*Label 736*/ GIMT_Encode4(24209), // Rule ID 539 //
     /* 24169 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24172 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_s_d),
     /* 24177 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 24180 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 24183 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 24186 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 24190 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 24194 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 24198 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7657:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVER_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /* 24198 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_S_D),
     /* 24201 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24203 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24205 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24207 */     GIR_RootConstrainSelectedInstOperands,
     /* 24208 */     // GIR_Coverage, 539,
     /* 24208 */     GIR_EraseRootFromParent_Done,
     /* 24209 */   // Label 736: @24209
     /* 24209 */   GIM_Try, /*On fail goto*//*Label 737*/ GIMT_Encode4(24254), // Rule ID 540 //
     /* 24214 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24217 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_u_b),
     /* 24222 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 24225 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 24228 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 24231 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 24235 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 24239 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 24243 */     // (intrinsic_wo_chain:{ *:[v16i8] } 7660:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (AVER_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 24243 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_U_B),
     /* 24246 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24248 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24250 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24252 */     GIR_RootConstrainSelectedInstOperands,
     /* 24253 */     // GIR_Coverage, 540,
     /* 24253 */     GIR_EraseRootFromParent_Done,
     /* 24254 */   // Label 737: @24254
     /* 24254 */   GIM_Try, /*On fail goto*//*Label 738*/ GIMT_Encode4(24299), // Rule ID 541 //
     /* 24259 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24262 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_u_h),
     /* 24267 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 24270 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 24273 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 24276 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 24280 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 24284 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 24288 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7662:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (AVER_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 24288 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_U_H),
     /* 24291 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24293 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24295 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24297 */     GIR_RootConstrainSelectedInstOperands,
     /* 24298 */     // GIR_Coverage, 541,
     /* 24298 */     GIR_EraseRootFromParent_Done,
     /* 24299 */   // Label 738: @24299
     /* 24299 */   GIM_Try, /*On fail goto*//*Label 739*/ GIMT_Encode4(24344), // Rule ID 542 //
     /* 24304 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24307 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_u_w),
     /* 24312 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 24315 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 24318 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 24321 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24325 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24329 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24333 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7663:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (AVER_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 24333 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_U_W),
     /* 24336 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24338 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24340 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24342 */     GIR_RootConstrainSelectedInstOperands,
     /* 24343 */     // GIR_Coverage, 542,
     /* 24343 */     GIR_EraseRootFromParent_Done,
     /* 24344 */   // Label 739: @24344
     /* 24344 */   GIM_Try, /*On fail goto*//*Label 740*/ GIMT_Encode4(24389), // Rule ID 543 //
     /* 24349 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24352 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_aver_u_d),
     /* 24357 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 24360 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 24363 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 24366 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 24370 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 24374 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 24378 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7661:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (AVER_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /* 24378 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::AVER_U_D),
     /* 24381 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24383 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24385 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24387 */     GIR_RootConstrainSelectedInstOperands,
     /* 24388 */     // GIR_Coverage, 543,
     /* 24388 */     GIR_EraseRootFromParent_Done,
     /* 24389 */   // Label 740: @24389
     /* 24389 */   GIM_Try, /*On fail goto*//*Label 741*/ GIMT_Encode4(24434), // Rule ID 652 //
     /* 24394 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24397 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_s_h),
     /* 24402 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 24405 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 24408 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 24411 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 24415 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 24419 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 24423 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7795:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DOTP_S_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 24423 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DOTP_S_H),
     /* 24426 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24428 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24430 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24432 */     GIR_RootConstrainSelectedInstOperands,
     /* 24433 */     // GIR_Coverage, 652,
     /* 24433 */     GIR_EraseRootFromParent_Done,
     /* 24434 */   // Label 741: @24434
     /* 24434 */   GIM_Try, /*On fail goto*//*Label 742*/ GIMT_Encode4(24479), // Rule ID 653 //
     /* 24439 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24442 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_s_w),
     /* 24447 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 24450 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 24453 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 24456 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24460 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 24464 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 24468 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7796:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DOTP_S_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 24468 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DOTP_S_W),
     /* 24471 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24473 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24475 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24477 */     GIR_RootConstrainSelectedInstOperands,
     /* 24478 */     // GIR_Coverage, 653,
     /* 24478 */     GIR_EraseRootFromParent_Done,
     /* 24479 */   // Label 742: @24479
     /* 24479 */   GIM_Try, /*On fail goto*//*Label 743*/ GIMT_Encode4(24524), // Rule ID 654 //
     /* 24484 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24487 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_s_d),
     /* 24492 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 24495 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 24498 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 24501 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 24505 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24509 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24513 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7794:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DOTP_S_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 24513 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DOTP_S_D),
     /* 24516 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24518 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24520 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24522 */     GIR_RootConstrainSelectedInstOperands,
     /* 24523 */     // GIR_Coverage, 654,
     /* 24523 */     GIR_EraseRootFromParent_Done,
     /* 24524 */   // Label 743: @24524
     /* 24524 */   GIM_Try, /*On fail goto*//*Label 744*/ GIMT_Encode4(24569), // Rule ID 655 //
     /* 24529 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24532 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_u_h),
     /* 24537 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 24540 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 24543 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 24546 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 24550 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 24554 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 24558 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7798:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DOTP_U_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 24558 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DOTP_U_H),
     /* 24561 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24563 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24565 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24567 */     GIR_RootConstrainSelectedInstOperands,
     /* 24568 */     // GIR_Coverage, 655,
     /* 24568 */     GIR_EraseRootFromParent_Done,
     /* 24569 */   // Label 744: @24569
     /* 24569 */   GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(24614), // Rule ID 656 //
     /* 24574 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24577 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_u_w),
     /* 24582 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 24585 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 24588 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 24591 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24595 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 24599 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 24603 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7799:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DOTP_U_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 24603 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DOTP_U_W),
     /* 24606 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24608 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24610 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24612 */     GIR_RootConstrainSelectedInstOperands,
     /* 24613 */     // GIR_Coverage, 656,
     /* 24613 */     GIR_EraseRootFromParent_Done,
     /* 24614 */   // Label 745: @24614
     /* 24614 */   GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(24659), // Rule ID 657 //
     /* 24619 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24622 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dotp_u_d),
     /* 24627 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 24630 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 24633 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 24636 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 24640 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24644 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24648 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7797:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DOTP_U_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 24648 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DOTP_U_D),
     /* 24651 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24653 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24655 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24657 */     GIR_RootConstrainSelectedInstOperands,
     /* 24658 */     // GIR_Coverage, 657,
     /* 24658 */     GIR_EraseRootFromParent_Done,
     /* 24659 */   // Label 746: @24659
     /* 24659 */   GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(24704), // Rule ID 672 //
     /* 24664 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24667 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fcaf_w),
     /* 24672 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 24675 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 24678 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 24681 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24685 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24689 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24693 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7837:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FCAF_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
     /* 24693 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FCAF_W),
     /* 24696 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24698 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24700 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24702 */     GIR_RootConstrainSelectedInstOperands,
     /* 24703 */     // GIR_Coverage, 672,
     /* 24703 */     GIR_EraseRootFromParent_Done,
     /* 24704 */   // Label 747: @24704
     /* 24704 */   GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(24749), // Rule ID 673 //
     /* 24709 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24712 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fcaf_d),
     /* 24717 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 24720 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 24723 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 24726 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 24730 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 24734 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 24738 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7836:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FCAF_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
     /* 24738 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FCAF_D),
     /* 24741 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24743 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24745 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24747 */     GIR_RootConstrainSelectedInstOperands,
     /* 24748 */     // GIR_Coverage, 673,
     /* 24748 */     GIR_EraseRootFromParent_Done,
     /* 24749 */   // Label 748: @24749
     /* 24749 */   GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(24794), // Rule ID 698 //
     /* 24754 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24757 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexdo_h),
     /* 24762 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 24765 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 24768 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 24771 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 24775 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24779 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24783 */     // (intrinsic_wo_chain:{ *:[v8f16] } 7862:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FEXDO_H:{ *:[v8f16] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
     /* 24783 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FEXDO_H),
     /* 24786 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24788 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24790 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24792 */     GIR_RootConstrainSelectedInstOperands,
     /* 24793 */     // GIR_Coverage, 698,
     /* 24793 */     GIR_EraseRootFromParent_Done,
     /* 24794 */   // Label 749: @24794
     /* 24794 */   GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(24839), // Rule ID 699 //
     /* 24799 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24802 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fexdo_w),
     /* 24807 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 24810 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 24813 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 24816 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24820 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 24824 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 24828 */     // (intrinsic_wo_chain:{ *:[v4f32] } 7863:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FEXDO_W:{ *:[v4f32] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
     /* 24828 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FEXDO_W),
     /* 24831 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24833 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24835 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24837 */     GIR_RootConstrainSelectedInstOperands,
     /* 24838 */     // GIR_Coverage, 699,
     /* 24838 */     GIR_EraseRootFromParent_Done,
     /* 24839 */   // Label 750: @24839
     /* 24839 */   GIM_Try, /*On fail goto*//*Label 751*/ GIMT_Encode4(24884), // Rule ID 726 //
     /* 24844 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24847 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmax_w),
     /* 24852 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 24855 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 24858 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 24861 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24865 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24869 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24873 */     // (intrinsic_wo_chain:{ *:[v4f32] } 7889:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMAX_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
     /* 24873 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMAX_W),
     /* 24876 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24878 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24880 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24882 */     GIR_RootConstrainSelectedInstOperands,
     /* 24883 */     // GIR_Coverage, 726,
     /* 24883 */     GIR_EraseRootFromParent_Done,
     /* 24884 */   // Label 751: @24884
     /* 24884 */   GIM_Try, /*On fail goto*//*Label 752*/ GIMT_Encode4(24929), // Rule ID 727 //
     /* 24889 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24892 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmax_d),
     /* 24897 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 24900 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 24903 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 24906 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 24910 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 24914 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 24918 */     // (intrinsic_wo_chain:{ *:[v2f64] } 7888:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMAX_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
     /* 24918 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMAX_D),
     /* 24921 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24923 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24925 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24927 */     GIR_RootConstrainSelectedInstOperands,
     /* 24928 */     // GIR_Coverage, 727,
     /* 24928 */     GIR_EraseRootFromParent_Done,
     /* 24929 */   // Label 752: @24929
     /* 24929 */   GIM_Try, /*On fail goto*//*Label 753*/ GIMT_Encode4(24974), // Rule ID 728 //
     /* 24934 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24937 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmax_a_w),
     /* 24942 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 24945 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 24948 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 24951 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24955 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24959 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 24963 */     // (intrinsic_wo_chain:{ *:[v4f32] } 7887:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMAX_A_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
     /* 24963 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMAX_A_W),
     /* 24966 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 24968 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 24970 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 24972 */     GIR_RootConstrainSelectedInstOperands,
     /* 24973 */     // GIR_Coverage, 728,
     /* 24973 */     GIR_EraseRootFromParent_Done,
     /* 24974 */   // Label 753: @24974
     /* 24974 */   GIM_Try, /*On fail goto*//*Label 754*/ GIMT_Encode4(25019), // Rule ID 729 //
     /* 24979 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 24982 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmax_a_d),
     /* 24987 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 24990 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 24993 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 24996 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25000 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25004 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25008 */     // (intrinsic_wo_chain:{ *:[v2f64] } 7886:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMAX_A_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
     /* 25008 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMAX_A_D),
     /* 25011 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25013 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25015 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25017 */     GIR_RootConstrainSelectedInstOperands,
     /* 25018 */     // GIR_Coverage, 729,
     /* 25018 */     GIR_EraseRootFromParent_Done,
     /* 25019 */   // Label 754: @25019
     /* 25019 */   GIM_Try, /*On fail goto*//*Label 755*/ GIMT_Encode4(25064), // Rule ID 730 //
     /* 25024 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25027 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmin_w),
     /* 25032 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 25035 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 25038 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 25041 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25045 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25049 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25053 */     // (intrinsic_wo_chain:{ *:[v4f32] } 7893:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMIN_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
     /* 25053 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMIN_W),
     /* 25056 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25058 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25060 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25062 */     GIR_RootConstrainSelectedInstOperands,
     /* 25063 */     // GIR_Coverage, 730,
     /* 25063 */     GIR_EraseRootFromParent_Done,
     /* 25064 */   // Label 755: @25064
     /* 25064 */   GIM_Try, /*On fail goto*//*Label 756*/ GIMT_Encode4(25109), // Rule ID 731 //
     /* 25069 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25072 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmin_d),
     /* 25077 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 25080 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 25083 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 25086 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25090 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25094 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25098 */     // (intrinsic_wo_chain:{ *:[v2f64] } 7892:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMIN_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
     /* 25098 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMIN_D),
     /* 25101 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25103 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25105 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25107 */     GIR_RootConstrainSelectedInstOperands,
     /* 25108 */     // GIR_Coverage, 731,
     /* 25108 */     GIR_EraseRootFromParent_Done,
     /* 25109 */   // Label 756: @25109
     /* 25109 */   GIM_Try, /*On fail goto*//*Label 757*/ GIMT_Encode4(25154), // Rule ID 732 //
     /* 25114 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25117 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmin_a_w),
     /* 25122 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 25125 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 25128 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 25131 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25135 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25139 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25143 */     // (intrinsic_wo_chain:{ *:[v4f32] } 7891:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FMIN_A_W:{ *:[v4f32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
     /* 25143 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMIN_A_W),
     /* 25146 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25148 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25150 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25152 */     GIR_RootConstrainSelectedInstOperands,
     /* 25153 */     // GIR_Coverage, 732,
     /* 25153 */     GIR_EraseRootFromParent_Done,
     /* 25154 */   // Label 757: @25154
     /* 25154 */   GIM_Try, /*On fail goto*//*Label 758*/ GIMT_Encode4(25199), // Rule ID 733 //
     /* 25159 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25162 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fmin_a_d),
     /* 25167 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 25170 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 25173 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 25176 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25180 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25184 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25188 */     // (intrinsic_wo_chain:{ *:[v2f64] } 7890:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FMIN_A_D:{ *:[v2f64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
     /* 25188 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FMIN_A_D),
     /* 25191 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25193 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25195 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25197 */     GIR_RootConstrainSelectedInstOperands,
     /* 25198 */     // GIR_Coverage, 733,
     /* 25198 */     GIR_EraseRootFromParent_Done,
     /* 25199 */   // Label 758: @25199
     /* 25199 */   GIM_Try, /*On fail goto*//*Label 759*/ GIMT_Encode4(25244), // Rule ID 744 //
     /* 25204 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25207 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsaf_w),
     /* 25212 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 25215 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 25218 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 25221 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25225 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25229 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25233 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7905:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSAF_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
     /* 25233 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSAF_W),
     /* 25236 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25238 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25240 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25242 */     GIR_RootConstrainSelectedInstOperands,
     /* 25243 */     // GIR_Coverage, 744,
     /* 25243 */     GIR_EraseRootFromParent_Done,
     /* 25244 */   // Label 759: @25244
     /* 25244 */   GIM_Try, /*On fail goto*//*Label 760*/ GIMT_Encode4(25289), // Rule ID 745 //
     /* 25249 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25252 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsaf_d),
     /* 25257 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 25260 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 25263 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 25266 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25270 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25274 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25278 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7904:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSAF_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
     /* 25278 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSAF_D),
     /* 25281 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25283 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25285 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25287 */     GIR_RootConstrainSelectedInstOperands,
     /* 25288 */     // GIR_Coverage, 745,
     /* 25288 */     GIR_EraseRootFromParent_Done,
     /* 25289 */   // Label 760: @25289
     /* 25289 */   GIM_Try, /*On fail goto*//*Label 761*/ GIMT_Encode4(25334), // Rule ID 746 //
     /* 25294 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25297 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fseq_w),
     /* 25302 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 25305 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 25308 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 25311 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25315 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25319 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25323 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7907:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSEQ_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
     /* 25323 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSEQ_W),
     /* 25326 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25328 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25330 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25332 */     GIR_RootConstrainSelectedInstOperands,
     /* 25333 */     // GIR_Coverage, 746,
     /* 25333 */     GIR_EraseRootFromParent_Done,
     /* 25334 */   // Label 761: @25334
     /* 25334 */   GIM_Try, /*On fail goto*//*Label 762*/ GIMT_Encode4(25379), // Rule ID 747 //
     /* 25339 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25342 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fseq_d),
     /* 25347 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 25350 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 25353 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 25356 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25360 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25364 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25368 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7906:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSEQ_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
     /* 25368 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSEQ_D),
     /* 25371 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25373 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25375 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25377 */     GIR_RootConstrainSelectedInstOperands,
     /* 25378 */     // GIR_Coverage, 747,
     /* 25378 */     GIR_EraseRootFromParent_Done,
     /* 25379 */   // Label 762: @25379
     /* 25379 */   GIM_Try, /*On fail goto*//*Label 763*/ GIMT_Encode4(25424), // Rule ID 748 //
     /* 25384 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25387 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsle_w),
     /* 25392 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 25395 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 25398 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 25401 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25405 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25409 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25413 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7909:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSLE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
     /* 25413 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSLE_W),
     /* 25416 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25418 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25420 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25422 */     GIR_RootConstrainSelectedInstOperands,
     /* 25423 */     // GIR_Coverage, 748,
     /* 25423 */     GIR_EraseRootFromParent_Done,
     /* 25424 */   // Label 763: @25424
     /* 25424 */   GIM_Try, /*On fail goto*//*Label 764*/ GIMT_Encode4(25469), // Rule ID 749 //
     /* 25429 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25432 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsle_d),
     /* 25437 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 25440 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 25443 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 25446 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25450 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25454 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25458 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7908:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSLE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
     /* 25458 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSLE_D),
     /* 25461 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25463 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25465 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25467 */     GIR_RootConstrainSelectedInstOperands,
     /* 25468 */     // GIR_Coverage, 749,
     /* 25468 */     GIR_EraseRootFromParent_Done,
     /* 25469 */   // Label 764: @25469
     /* 25469 */   GIM_Try, /*On fail goto*//*Label 765*/ GIMT_Encode4(25514), // Rule ID 750 //
     /* 25474 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25477 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fslt_w),
     /* 25482 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 25485 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 25488 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 25491 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25495 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25499 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25503 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7911:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSLT_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
     /* 25503 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSLT_W),
     /* 25506 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25508 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25510 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25512 */     GIR_RootConstrainSelectedInstOperands,
     /* 25513 */     // GIR_Coverage, 750,
     /* 25513 */     GIR_EraseRootFromParent_Done,
     /* 25514 */   // Label 765: @25514
     /* 25514 */   GIM_Try, /*On fail goto*//*Label 766*/ GIMT_Encode4(25559), // Rule ID 751 //
     /* 25519 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25522 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fslt_d),
     /* 25527 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 25530 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 25533 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 25536 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25540 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25544 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25548 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7910:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSLT_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
     /* 25548 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSLT_D),
     /* 25551 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25553 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25555 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25557 */     GIR_RootConstrainSelectedInstOperands,
     /* 25558 */     // GIR_Coverage, 751,
     /* 25558 */     GIR_EraseRootFromParent_Done,
     /* 25559 */   // Label 766: @25559
     /* 25559 */   GIM_Try, /*On fail goto*//*Label 767*/ GIMT_Encode4(25604), // Rule ID 752 //
     /* 25564 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25567 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsne_w),
     /* 25572 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 25575 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 25578 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 25581 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25585 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25589 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25593 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7913:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSNE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
     /* 25593 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSNE_W),
     /* 25596 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25598 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25600 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25602 */     GIR_RootConstrainSelectedInstOperands,
     /* 25603 */     // GIR_Coverage, 752,
     /* 25603 */     GIR_EraseRootFromParent_Done,
     /* 25604 */   // Label 767: @25604
     /* 25604 */   GIM_Try, /*On fail goto*//*Label 768*/ GIMT_Encode4(25649), // Rule ID 753 //
     /* 25609 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25612 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsne_d),
     /* 25617 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 25620 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 25623 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 25626 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25630 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25634 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25638 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7912:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSNE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
     /* 25638 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSNE_D),
     /* 25641 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25643 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25645 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25647 */     GIR_RootConstrainSelectedInstOperands,
     /* 25648 */     // GIR_Coverage, 753,
     /* 25648 */     GIR_EraseRootFromParent_Done,
     /* 25649 */   // Label 768: @25649
     /* 25649 */   GIM_Try, /*On fail goto*//*Label 769*/ GIMT_Encode4(25694), // Rule ID 754 //
     /* 25654 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25657 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsor_w),
     /* 25662 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 25665 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 25668 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 25671 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25675 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25679 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25683 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7915:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSOR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
     /* 25683 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSOR_W),
     /* 25686 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25688 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25690 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25692 */     GIR_RootConstrainSelectedInstOperands,
     /* 25693 */     // GIR_Coverage, 754,
     /* 25693 */     GIR_EraseRootFromParent_Done,
     /* 25694 */   // Label 769: @25694
     /* 25694 */   GIM_Try, /*On fail goto*//*Label 770*/ GIMT_Encode4(25739), // Rule ID 755 //
     /* 25699 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25702 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsor_d),
     /* 25707 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 25710 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 25713 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 25716 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25720 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25724 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25728 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7914:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSOR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
     /* 25728 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSOR_D),
     /* 25731 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25733 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25735 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25737 */     GIR_RootConstrainSelectedInstOperands,
     /* 25738 */     // GIR_Coverage, 755,
     /* 25738 */     GIR_EraseRootFromParent_Done,
     /* 25739 */   // Label 770: @25739
     /* 25739 */   GIM_Try, /*On fail goto*//*Label 771*/ GIMT_Encode4(25784), // Rule ID 760 //
     /* 25744 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25747 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsueq_w),
     /* 25752 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 25755 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 25758 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 25761 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25765 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25769 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25773 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7921:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSUEQ_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
     /* 25773 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSUEQ_W),
     /* 25776 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25778 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25780 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25782 */     GIR_RootConstrainSelectedInstOperands,
     /* 25783 */     // GIR_Coverage, 760,
     /* 25783 */     GIR_EraseRootFromParent_Done,
     /* 25784 */   // Label 771: @25784
     /* 25784 */   GIM_Try, /*On fail goto*//*Label 772*/ GIMT_Encode4(25829), // Rule ID 761 //
     /* 25789 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25792 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsueq_d),
     /* 25797 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 25800 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 25803 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 25806 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25810 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25814 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25818 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7920:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSUEQ_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
     /* 25818 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSUEQ_D),
     /* 25821 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25823 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25825 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25827 */     GIR_RootConstrainSelectedInstOperands,
     /* 25828 */     // GIR_Coverage, 761,
     /* 25828 */     GIR_EraseRootFromParent_Done,
     /* 25829 */   // Label 772: @25829
     /* 25829 */   GIM_Try, /*On fail goto*//*Label 773*/ GIMT_Encode4(25874), // Rule ID 762 //
     /* 25834 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25837 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsule_w),
     /* 25842 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 25845 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 25848 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 25851 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25855 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25859 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25863 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7923:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSULE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
     /* 25863 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSULE_W),
     /* 25866 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25868 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25870 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25872 */     GIR_RootConstrainSelectedInstOperands,
     /* 25873 */     // GIR_Coverage, 762,
     /* 25873 */     GIR_EraseRootFromParent_Done,
     /* 25874 */   // Label 773: @25874
     /* 25874 */   GIM_Try, /*On fail goto*//*Label 774*/ GIMT_Encode4(25919), // Rule ID 763 //
     /* 25879 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25882 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsule_d),
     /* 25887 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 25890 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 25893 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 25896 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25900 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25904 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25908 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7922:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSULE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
     /* 25908 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSULE_D),
     /* 25911 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25913 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25915 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25917 */     GIR_RootConstrainSelectedInstOperands,
     /* 25918 */     // GIR_Coverage, 763,
     /* 25918 */     GIR_EraseRootFromParent_Done,
     /* 25919 */   // Label 774: @25919
     /* 25919 */   GIM_Try, /*On fail goto*//*Label 775*/ GIMT_Encode4(25964), // Rule ID 764 //
     /* 25924 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25927 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsult_w),
     /* 25932 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 25935 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 25938 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 25941 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25945 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25949 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 25953 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7925:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSULT_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
     /* 25953 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSULT_W),
     /* 25956 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 25958 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 25960 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 25962 */     GIR_RootConstrainSelectedInstOperands,
     /* 25963 */     // GIR_Coverage, 764,
     /* 25963 */     GIR_EraseRootFromParent_Done,
     /* 25964 */   // Label 775: @25964
     /* 25964 */   GIM_Try, /*On fail goto*//*Label 776*/ GIMT_Encode4(26009), // Rule ID 765 //
     /* 25969 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 25972 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsult_d),
     /* 25977 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 25980 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 25983 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 25986 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25990 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25994 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 25998 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7924:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSULT_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
     /* 25998 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSULT_D),
     /* 26001 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26003 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26005 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26007 */     GIR_RootConstrainSelectedInstOperands,
     /* 26008 */     // GIR_Coverage, 765,
     /* 26008 */     GIR_EraseRootFromParent_Done,
     /* 26009 */   // Label 776: @26009
     /* 26009 */   GIM_Try, /*On fail goto*//*Label 777*/ GIMT_Encode4(26054), // Rule ID 766 //
     /* 26014 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26017 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsun_w),
     /* 26022 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 26025 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 26028 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 26031 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26035 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26039 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26043 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7927:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSUN_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
     /* 26043 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSUN_W),
     /* 26046 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26048 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26050 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26052 */     GIR_RootConstrainSelectedInstOperands,
     /* 26053 */     // GIR_Coverage, 766,
     /* 26053 */     GIR_EraseRootFromParent_Done,
     /* 26054 */   // Label 777: @26054
     /* 26054 */   GIM_Try, /*On fail goto*//*Label 778*/ GIMT_Encode4(26099), // Rule ID 767 //
     /* 26059 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26062 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsun_d),
     /* 26067 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 26070 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 26073 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 26076 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 26080 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 26084 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 26088 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7926:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSUN_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
     /* 26088 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSUN_D),
     /* 26091 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26093 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26095 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26097 */     GIR_RootConstrainSelectedInstOperands,
     /* 26098 */     // GIR_Coverage, 767,
     /* 26098 */     GIR_EraseRootFromParent_Done,
     /* 26099 */   // Label 778: @26099
     /* 26099 */   GIM_Try, /*On fail goto*//*Label 779*/ GIMT_Encode4(26144), // Rule ID 768 //
     /* 26104 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26107 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsune_w),
     /* 26112 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 26115 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 26118 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 26121 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26125 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26129 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26133 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7929:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FSUNE_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
     /* 26133 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSUNE_W),
     /* 26136 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26138 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26140 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26142 */     GIR_RootConstrainSelectedInstOperands,
     /* 26143 */     // GIR_Coverage, 768,
     /* 26143 */     GIR_EraseRootFromParent_Done,
     /* 26144 */   // Label 779: @26144
     /* 26144 */   GIM_Try, /*On fail goto*//*Label 780*/ GIMT_Encode4(26189), // Rule ID 769 //
     /* 26149 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26152 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_fsune_d),
     /* 26157 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 26160 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 26163 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 26166 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 26170 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 26174 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 26178 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7928:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FSUNE_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
     /* 26178 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FSUNE_D),
     /* 26181 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26183 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26185 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26187 */     GIR_RootConstrainSelectedInstOperands,
     /* 26188 */     // GIR_Coverage, 769,
     /* 26188 */     GIR_EraseRootFromParent_Done,
     /* 26189 */   // Label 780: @26189
     /* 26189 */   GIM_Try, /*On fail goto*//*Label 781*/ GIMT_Encode4(26234), // Rule ID 774 //
     /* 26194 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26197 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftq_h),
     /* 26202 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 26205 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 26208 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 26211 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 26215 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26219 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26223 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7934:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)  =>  (FTQ_H:{ *:[v8i16] } MSA128WOpnd:{ *:[v4f32] }:$ws, MSA128WOpnd:{ *:[v4f32] }:$wt)
     /* 26223 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FTQ_H),
     /* 26226 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26228 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26230 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26232 */     GIR_RootConstrainSelectedInstOperands,
     /* 26233 */     // GIR_Coverage, 774,
     /* 26233 */     GIR_EraseRootFromParent_Done,
     /* 26234 */   // Label 781: @26234
     /* 26234 */   GIM_Try, /*On fail goto*//*Label 782*/ GIMT_Encode4(26279), // Rule ID 775 //
     /* 26239 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26242 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_ftq_w),
     /* 26247 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 26250 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 26253 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 26256 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26260 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 26264 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 26268 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7935:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)  =>  (FTQ_W:{ *:[v4i32] } MSA128DOpnd:{ *:[v2f64] }:$ws, MSA128DOpnd:{ *:[v2f64] }:$wt)
     /* 26268 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::FTQ_W),
     /* 26271 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26273 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26275 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26277 */     GIR_RootConstrainSelectedInstOperands,
     /* 26278 */     // GIR_Coverage, 775,
     /* 26278 */     GIR_EraseRootFromParent_Done,
     /* 26279 */   // Label 782: @26279
     /* 26279 */   GIM_Try, /*On fail goto*//*Label 783*/ GIMT_Encode4(26324), // Rule ID 780 //
     /* 26284 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26287 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_s_h),
     /* 26292 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 26295 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 26298 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 26301 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 26305 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 26309 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 26313 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7941:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HADD_S_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 26313 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HADD_S_H),
     /* 26316 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26318 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26320 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26322 */     GIR_RootConstrainSelectedInstOperands,
     /* 26323 */     // GIR_Coverage, 780,
     /* 26323 */     GIR_EraseRootFromParent_Done,
     /* 26324 */   // Label 783: @26324
     /* 26324 */   GIM_Try, /*On fail goto*//*Label 784*/ GIMT_Encode4(26369), // Rule ID 781 //
     /* 26329 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26332 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_s_w),
     /* 26337 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 26340 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 26343 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 26346 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26350 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 26354 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 26358 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7942:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HADD_S_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 26358 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HADD_S_W),
     /* 26361 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26363 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26365 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26367 */     GIR_RootConstrainSelectedInstOperands,
     /* 26368 */     // GIR_Coverage, 781,
     /* 26368 */     GIR_EraseRootFromParent_Done,
     /* 26369 */   // Label 784: @26369
     /* 26369 */   GIM_Try, /*On fail goto*//*Label 785*/ GIMT_Encode4(26414), // Rule ID 782 //
     /* 26374 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26377 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_s_d),
     /* 26382 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 26385 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 26388 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 26391 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 26395 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26399 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26403 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7940:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HADD_S_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 26403 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HADD_S_D),
     /* 26406 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26408 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26410 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26412 */     GIR_RootConstrainSelectedInstOperands,
     /* 26413 */     // GIR_Coverage, 782,
     /* 26413 */     GIR_EraseRootFromParent_Done,
     /* 26414 */   // Label 785: @26414
     /* 26414 */   GIM_Try, /*On fail goto*//*Label 786*/ GIMT_Encode4(26459), // Rule ID 783 //
     /* 26419 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26422 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_u_h),
     /* 26427 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 26430 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 26433 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 26436 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 26440 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 26444 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 26448 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7944:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HADD_U_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 26448 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HADD_U_H),
     /* 26451 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26453 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26455 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26457 */     GIR_RootConstrainSelectedInstOperands,
     /* 26458 */     // GIR_Coverage, 783,
     /* 26458 */     GIR_EraseRootFromParent_Done,
     /* 26459 */   // Label 786: @26459
     /* 26459 */   GIM_Try, /*On fail goto*//*Label 787*/ GIMT_Encode4(26504), // Rule ID 784 //
     /* 26464 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26467 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_u_w),
     /* 26472 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 26475 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 26478 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 26481 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26485 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 26489 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 26493 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7945:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HADD_U_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 26493 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HADD_U_W),
     /* 26496 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26498 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26500 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26502 */     GIR_RootConstrainSelectedInstOperands,
     /* 26503 */     // GIR_Coverage, 784,
     /* 26503 */     GIR_EraseRootFromParent_Done,
     /* 26504 */   // Label 787: @26504
     /* 26504 */   GIM_Try, /*On fail goto*//*Label 788*/ GIMT_Encode4(26549), // Rule ID 785 //
     /* 26509 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26512 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hadd_u_d),
     /* 26517 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 26520 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 26523 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 26526 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 26530 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26534 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26538 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7943:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HADD_U_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 26538 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HADD_U_D),
     /* 26541 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26543 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26545 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26547 */     GIR_RootConstrainSelectedInstOperands,
     /* 26548 */     // GIR_Coverage, 785,
     /* 26548 */     GIR_EraseRootFromParent_Done,
     /* 26549 */   // Label 788: @26549
     /* 26549 */   GIM_Try, /*On fail goto*//*Label 789*/ GIMT_Encode4(26594), // Rule ID 786 //
     /* 26554 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26557 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_s_h),
     /* 26562 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 26565 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 26568 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 26571 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 26575 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 26579 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 26583 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7947:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HSUB_S_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 26583 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HSUB_S_H),
     /* 26586 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26588 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26590 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26592 */     GIR_RootConstrainSelectedInstOperands,
     /* 26593 */     // GIR_Coverage, 786,
     /* 26593 */     GIR_EraseRootFromParent_Done,
     /* 26594 */   // Label 789: @26594
     /* 26594 */   GIM_Try, /*On fail goto*//*Label 790*/ GIMT_Encode4(26639), // Rule ID 787 //
     /* 26599 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26602 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_s_w),
     /* 26607 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 26610 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 26613 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 26616 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26620 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 26624 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 26628 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7948:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HSUB_S_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 26628 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HSUB_S_W),
     /* 26631 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26633 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26635 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26637 */     GIR_RootConstrainSelectedInstOperands,
     /* 26638 */     // GIR_Coverage, 787,
     /* 26638 */     GIR_EraseRootFromParent_Done,
     /* 26639 */   // Label 790: @26639
     /* 26639 */   GIM_Try, /*On fail goto*//*Label 791*/ GIMT_Encode4(26684), // Rule ID 788 //
     /* 26644 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26647 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_s_d),
     /* 26652 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 26655 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 26658 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 26661 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 26665 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26669 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26673 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7946:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HSUB_S_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 26673 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HSUB_S_D),
     /* 26676 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26678 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26680 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26682 */     GIR_RootConstrainSelectedInstOperands,
     /* 26683 */     // GIR_Coverage, 788,
     /* 26683 */     GIR_EraseRootFromParent_Done,
     /* 26684 */   // Label 791: @26684
     /* 26684 */   GIM_Try, /*On fail goto*//*Label 792*/ GIMT_Encode4(26729), // Rule ID 789 //
     /* 26689 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26692 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_u_h),
     /* 26697 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 26700 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 26703 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 26706 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 26710 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 26714 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 26718 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7950:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (HSUB_U_H:{ *:[v8i16] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 26718 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HSUB_U_H),
     /* 26721 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26723 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26725 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26727 */     GIR_RootConstrainSelectedInstOperands,
     /* 26728 */     // GIR_Coverage, 789,
     /* 26728 */     GIR_EraseRootFromParent_Done,
     /* 26729 */   // Label 792: @26729
     /* 26729 */   GIM_Try, /*On fail goto*//*Label 793*/ GIMT_Encode4(26774), // Rule ID 790 //
     /* 26734 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26737 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_u_w),
     /* 26742 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 26745 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 26748 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 26751 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26755 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 26759 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 26763 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7951:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (HSUB_U_W:{ *:[v4i32] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 26763 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HSUB_U_W),
     /* 26766 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26768 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26770 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26772 */     GIR_RootConstrainSelectedInstOperands,
     /* 26773 */     // GIR_Coverage, 790,
     /* 26773 */     GIR_EraseRootFromParent_Done,
     /* 26774 */   // Label 793: @26774
     /* 26774 */   GIM_Try, /*On fail goto*//*Label 794*/ GIMT_Encode4(26819), // Rule ID 791 //
     /* 26779 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26782 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_hsub_u_d),
     /* 26787 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 26790 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 26793 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 26796 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 26800 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26804 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26808 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7949:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (HSUB_U_D:{ *:[v2i64] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 26808 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::HSUB_U_D),
     /* 26811 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26813 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26815 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26817 */     GIR_RootConstrainSelectedInstOperands,
     /* 26818 */     // GIR_Coverage, 791,
     /* 26818 */     GIR_EraseRootFromParent_Done,
     /* 26819 */   // Label 794: @26819
     /* 26819 */   GIM_Try, /*On fail goto*//*Label 795*/ GIMT_Encode4(26864), // Rule ID 844 //
     /* 26824 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26827 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_max_a_b),
     /* 26832 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 26835 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 26838 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 26841 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 26845 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 26849 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 26853 */     // (intrinsic_wo_chain:{ *:[v16i8] } 8005:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MAX_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 26853 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MAX_A_B),
     /* 26856 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26858 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26860 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26862 */     GIR_RootConstrainSelectedInstOperands,
     /* 26863 */     // GIR_Coverage, 844,
     /* 26863 */     GIR_EraseRootFromParent_Done,
     /* 26864 */   // Label 795: @26864
     /* 26864 */   GIM_Try, /*On fail goto*//*Label 796*/ GIMT_Encode4(26909), // Rule ID 845 //
     /* 26869 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26872 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_max_a_h),
     /* 26877 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 26880 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 26883 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 26886 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 26890 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 26894 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 26898 */     // (intrinsic_wo_chain:{ *:[v8i16] } 8007:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MAX_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 26898 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MAX_A_H),
     /* 26901 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26903 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26905 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26907 */     GIR_RootConstrainSelectedInstOperands,
     /* 26908 */     // GIR_Coverage, 845,
     /* 26908 */     GIR_EraseRootFromParent_Done,
     /* 26909 */   // Label 796: @26909
     /* 26909 */   GIM_Try, /*On fail goto*//*Label 797*/ GIMT_Encode4(26954), // Rule ID 846 //
     /* 26914 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26917 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_max_a_w),
     /* 26922 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 26925 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 26928 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 26931 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26935 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26939 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 26943 */     // (intrinsic_wo_chain:{ *:[v4i32] } 8008:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MAX_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 26943 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MAX_A_W),
     /* 26946 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26948 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26950 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26952 */     GIR_RootConstrainSelectedInstOperands,
     /* 26953 */     // GIR_Coverage, 846,
     /* 26953 */     GIR_EraseRootFromParent_Done,
     /* 26954 */   // Label 797: @26954
     /* 26954 */   GIM_Try, /*On fail goto*//*Label 798*/ GIMT_Encode4(26999), // Rule ID 847 //
     /* 26959 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 26962 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_max_a_d),
     /* 26967 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 26970 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 26973 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 26976 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 26980 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 26984 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 26988 */     // (intrinsic_wo_chain:{ *:[v2i64] } 8006:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MAX_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /* 26988 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MAX_A_D),
     /* 26991 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 26993 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 26995 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 26997 */     GIR_RootConstrainSelectedInstOperands,
     /* 26998 */     // GIR_Coverage, 847,
     /* 26998 */     GIR_EraseRootFromParent_Done,
     /* 26999 */   // Label 798: @26999
     /* 26999 */   GIM_Try, /*On fail goto*//*Label 799*/ GIMT_Encode4(27044), // Rule ID 864 //
     /* 27004 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27007 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_min_a_b),
     /* 27012 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 27015 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 27018 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 27021 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 27025 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 27029 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 27033 */     // (intrinsic_wo_chain:{ *:[v16i8] } 8025:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (MIN_A_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 27033 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MIN_A_B),
     /* 27036 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27038 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27040 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27042 */     GIR_RootConstrainSelectedInstOperands,
     /* 27043 */     // GIR_Coverage, 864,
     /* 27043 */     GIR_EraseRootFromParent_Done,
     /* 27044 */   // Label 799: @27044
     /* 27044 */   GIM_Try, /*On fail goto*//*Label 800*/ GIMT_Encode4(27089), // Rule ID 865 //
     /* 27049 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27052 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_min_a_h),
     /* 27057 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 27060 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 27063 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 27066 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27070 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27074 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27078 */     // (intrinsic_wo_chain:{ *:[v8i16] } 8027:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MIN_A_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 27078 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MIN_A_H),
     /* 27081 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27083 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27085 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27087 */     GIR_RootConstrainSelectedInstOperands,
     /* 27088 */     // GIR_Coverage, 865,
     /* 27088 */     GIR_EraseRootFromParent_Done,
     /* 27089 */   // Label 800: @27089
     /* 27089 */   GIM_Try, /*On fail goto*//*Label 801*/ GIMT_Encode4(27134), // Rule ID 866 //
     /* 27094 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27097 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_min_a_w),
     /* 27102 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 27105 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 27108 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 27111 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 27115 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 27119 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 27123 */     // (intrinsic_wo_chain:{ *:[v4i32] } 8028:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MIN_A_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 27123 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MIN_A_W),
     /* 27126 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27128 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27130 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27132 */     GIR_RootConstrainSelectedInstOperands,
     /* 27133 */     // GIR_Coverage, 866,
     /* 27133 */     GIR_EraseRootFromParent_Done,
     /* 27134 */   // Label 801: @27134
     /* 27134 */   GIM_Try, /*On fail goto*//*Label 802*/ GIMT_Encode4(27179), // Rule ID 867 //
     /* 27139 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27142 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_min_a_d),
     /* 27147 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 27150 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 27153 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 27156 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 27160 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 27164 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 27168 */     // (intrinsic_wo_chain:{ *:[v2i64] } 8026:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (MIN_A_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /* 27168 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MIN_A_D),
     /* 27171 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27173 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27175 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27177 */     GIR_RootConstrainSelectedInstOperands,
     /* 27178 */     // GIR_Coverage, 867,
     /* 27178 */     GIR_EraseRootFromParent_Done,
     /* 27179 */   // Label 802: @27179
     /* 27179 */   GIM_Try, /*On fail goto*//*Label 803*/ GIMT_Encode4(27224), // Rule ID 900 //
     /* 27184 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27187 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mul_q_h),
     /* 27192 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 27195 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 27198 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 27201 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27205 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27209 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27213 */     // (intrinsic_wo_chain:{ *:[v8i16] } 8067:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MUL_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 27213 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MUL_Q_H),
     /* 27216 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27218 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27220 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27222 */     GIR_RootConstrainSelectedInstOperands,
     /* 27223 */     // GIR_Coverage, 900,
     /* 27223 */     GIR_EraseRootFromParent_Done,
     /* 27224 */   // Label 803: @27224
     /* 27224 */   GIM_Try, /*On fail goto*//*Label 804*/ GIMT_Encode4(27269), // Rule ID 901 //
     /* 27229 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27232 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mul_q_w),
     /* 27237 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 27240 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 27243 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 27246 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 27250 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 27254 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 27258 */     // (intrinsic_wo_chain:{ *:[v4i32] } 8068:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MUL_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 27258 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MUL_Q_W),
     /* 27261 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27263 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27265 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27267 */     GIR_RootConstrainSelectedInstOperands,
     /* 27268 */     // GIR_Coverage, 901,
     /* 27268 */     GIR_EraseRootFromParent_Done,
     /* 27269 */   // Label 804: @27269
     /* 27269 */   GIM_Try, /*On fail goto*//*Label 805*/ GIMT_Encode4(27314), // Rule ID 902 //
     /* 27274 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27277 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulr_q_h),
     /* 27282 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 27285 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 27288 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 27291 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27295 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27299 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27303 */     // (intrinsic_wo_chain:{ *:[v8i16] } 8078:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MULR_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 27303 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULR_Q_H),
     /* 27306 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27308 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27310 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27312 */     GIR_RootConstrainSelectedInstOperands,
     /* 27313 */     // GIR_Coverage, 902,
     /* 27313 */     GIR_EraseRootFromParent_Done,
     /* 27314 */   // Label 805: @27314
     /* 27314 */   GIM_Try, /*On fail goto*//*Label 806*/ GIMT_Encode4(27359), // Rule ID 903 //
     /* 27319 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27322 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_mulr_q_w),
     /* 27327 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 27330 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 27333 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 27336 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 27340 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 27344 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 27348 */     // (intrinsic_wo_chain:{ *:[v4i32] } 8079:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MULR_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 27348 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MULR_Q_W),
     /* 27351 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27353 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27355 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27357 */     GIR_RootConstrainSelectedInstOperands,
     /* 27358 */     // GIR_Coverage, 903,
     /* 27358 */     GIR_EraseRootFromParent_Done,
     /* 27359 */   // Label 806: @27359
     /* 27359 */   GIM_Try, /*On fail goto*//*Label 807*/ GIMT_Encode4(27404), // Rule ID 981 //
     /* 27364 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27367 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srar_b),
     /* 27372 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 27375 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 27378 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 27381 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 27385 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 27389 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 27393 */     // (intrinsic_wo_chain:{ *:[v16i8] } 8192:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SRAR_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 27393 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRAR_B),
     /* 27396 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27398 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27400 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27402 */     GIR_RootConstrainSelectedInstOperands,
     /* 27403 */     // GIR_Coverage, 981,
     /* 27403 */     GIR_EraseRootFromParent_Done,
     /* 27404 */   // Label 807: @27404
     /* 27404 */   GIM_Try, /*On fail goto*//*Label 808*/ GIMT_Encode4(27449), // Rule ID 982 //
     /* 27409 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27412 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srar_h),
     /* 27417 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 27420 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 27423 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 27426 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27430 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27434 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27438 */     // (intrinsic_wo_chain:{ *:[v8i16] } 8194:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SRAR_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 27438 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRAR_H),
     /* 27441 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27443 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27445 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27447 */     GIR_RootConstrainSelectedInstOperands,
     /* 27448 */     // GIR_Coverage, 982,
     /* 27448 */     GIR_EraseRootFromParent_Done,
     /* 27449 */   // Label 808: @27449
     /* 27449 */   GIM_Try, /*On fail goto*//*Label 809*/ GIMT_Encode4(27494), // Rule ID 983 //
     /* 27454 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27457 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srar_w),
     /* 27462 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 27465 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 27468 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 27471 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 27475 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 27479 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 27483 */     // (intrinsic_wo_chain:{ *:[v4i32] } 8195:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SRAR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 27483 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRAR_W),
     /* 27486 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27488 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27490 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27492 */     GIR_RootConstrainSelectedInstOperands,
     /* 27493 */     // GIR_Coverage, 983,
     /* 27493 */     GIR_EraseRootFromParent_Done,
     /* 27494 */   // Label 809: @27494
     /* 27494 */   GIM_Try, /*On fail goto*//*Label 810*/ GIMT_Encode4(27539), // Rule ID 984 //
     /* 27499 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27502 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srar_d),
     /* 27507 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 27510 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 27513 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 27516 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 27520 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 27524 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 27528 */     // (intrinsic_wo_chain:{ *:[v2i64] } 8193:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SRAR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /* 27528 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRAR_D),
     /* 27531 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27533 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27535 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27537 */     GIR_RootConstrainSelectedInstOperands,
     /* 27538 */     // GIR_Coverage, 984,
     /* 27538 */     GIR_EraseRootFromParent_Done,
     /* 27539 */   // Label 810: @27539
     /* 27539 */   GIM_Try, /*On fail goto*//*Label 811*/ GIMT_Encode4(27584), // Rule ID 997 //
     /* 27544 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27547 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlr_b),
     /* 27552 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 27555 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 27558 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 27561 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 27565 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 27569 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 27573 */     // (intrinsic_wo_chain:{ *:[v16i8] } 8208:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SRLR_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 27573 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLR_B),
     /* 27576 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27578 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27580 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27582 */     GIR_RootConstrainSelectedInstOperands,
     /* 27583 */     // GIR_Coverage, 997,
     /* 27583 */     GIR_EraseRootFromParent_Done,
     /* 27584 */   // Label 811: @27584
     /* 27584 */   GIM_Try, /*On fail goto*//*Label 812*/ GIMT_Encode4(27629), // Rule ID 998 //
     /* 27589 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27592 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlr_h),
     /* 27597 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 27600 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 27603 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 27606 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27610 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27614 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27618 */     // (intrinsic_wo_chain:{ *:[v8i16] } 8210:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SRLR_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 27618 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLR_H),
     /* 27621 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27623 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27625 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27627 */     GIR_RootConstrainSelectedInstOperands,
     /* 27628 */     // GIR_Coverage, 998,
     /* 27628 */     GIR_EraseRootFromParent_Done,
     /* 27629 */   // Label 812: @27629
     /* 27629 */   GIM_Try, /*On fail goto*//*Label 813*/ GIMT_Encode4(27674), // Rule ID 999 //
     /* 27634 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27637 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlr_w),
     /* 27642 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 27645 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 27648 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 27651 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 27655 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 27659 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 27663 */     // (intrinsic_wo_chain:{ *:[v4i32] } 8211:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SRLR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 27663 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLR_W),
     /* 27666 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27668 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27670 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27672 */     GIR_RootConstrainSelectedInstOperands,
     /* 27673 */     // GIR_Coverage, 999,
     /* 27673 */     GIR_EraseRootFromParent_Done,
     /* 27674 */   // Label 813: @27674
     /* 27674 */   GIM_Try, /*On fail goto*//*Label 814*/ GIMT_Encode4(27719), // Rule ID 1000 //
     /* 27679 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27682 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_srlr_d),
     /* 27687 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 27690 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 27693 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 27696 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 27700 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 27704 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 27708 */     // (intrinsic_wo_chain:{ *:[v2i64] } 8209:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SRLR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /* 27708 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SRLR_D),
     /* 27711 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27713 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27715 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27717 */     GIR_RootConstrainSelectedInstOperands,
     /* 27718 */     // GIR_Coverage, 1000,
     /* 27718 */     GIR_EraseRootFromParent_Done,
     /* 27719 */   // Label 814: @27719
     /* 27719 */   GIM_Try, /*On fail goto*//*Label 815*/ GIMT_Encode4(27764), // Rule ID 1009 //
     /* 27724 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27727 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_s_b),
     /* 27732 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 27735 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 27738 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 27741 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 27745 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 27749 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 27753 */     // (intrinsic_wo_chain:{ *:[v16i8] } 8229:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBS_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 27753 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_S_B),
     /* 27756 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27758 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27760 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27762 */     GIR_RootConstrainSelectedInstOperands,
     /* 27763 */     // GIR_Coverage, 1009,
     /* 27763 */     GIR_EraseRootFromParent_Done,
     /* 27764 */   // Label 815: @27764
     /* 27764 */   GIM_Try, /*On fail goto*//*Label 816*/ GIMT_Encode4(27809), // Rule ID 1010 //
     /* 27769 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27772 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_s_h),
     /* 27777 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 27780 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 27783 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 27786 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27790 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27794 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27798 */     // (intrinsic_wo_chain:{ *:[v8i16] } 8231:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBS_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 27798 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_S_H),
     /* 27801 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27803 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27805 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27807 */     GIR_RootConstrainSelectedInstOperands,
     /* 27808 */     // GIR_Coverage, 1010,
     /* 27808 */     GIR_EraseRootFromParent_Done,
     /* 27809 */   // Label 816: @27809
     /* 27809 */   GIM_Try, /*On fail goto*//*Label 817*/ GIMT_Encode4(27854), // Rule ID 1011 //
     /* 27814 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27817 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_s_w),
     /* 27822 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 27825 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 27828 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 27831 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 27835 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 27839 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 27843 */     // (intrinsic_wo_chain:{ *:[v4i32] } 8232:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBS_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 27843 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_S_W),
     /* 27846 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27848 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27850 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27852 */     GIR_RootConstrainSelectedInstOperands,
     /* 27853 */     // GIR_Coverage, 1011,
     /* 27853 */     GIR_EraseRootFromParent_Done,
     /* 27854 */   // Label 817: @27854
     /* 27854 */   GIM_Try, /*On fail goto*//*Label 818*/ GIMT_Encode4(27899), // Rule ID 1012 //
     /* 27859 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27862 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_s_d),
     /* 27867 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 27870 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 27873 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 27876 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 27880 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 27884 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 27888 */     // (intrinsic_wo_chain:{ *:[v2i64] } 8230:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBS_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /* 27888 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_S_D),
     /* 27891 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27893 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27895 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27897 */     GIR_RootConstrainSelectedInstOperands,
     /* 27898 */     // GIR_Coverage, 1012,
     /* 27898 */     GIR_EraseRootFromParent_Done,
     /* 27899 */   // Label 818: @27899
     /* 27899 */   GIM_Try, /*On fail goto*//*Label 819*/ GIMT_Encode4(27944), // Rule ID 1013 //
     /* 27904 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27907 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_u_b),
     /* 27912 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 27915 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 27918 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 27921 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 27925 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 27929 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 27933 */     // (intrinsic_wo_chain:{ *:[v16i8] } 8233:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBS_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 27933 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_U_B),
     /* 27936 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27938 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27940 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27942 */     GIR_RootConstrainSelectedInstOperands,
     /* 27943 */     // GIR_Coverage, 1013,
     /* 27943 */     GIR_EraseRootFromParent_Done,
     /* 27944 */   // Label 819: @27944
     /* 27944 */   GIM_Try, /*On fail goto*//*Label 820*/ GIMT_Encode4(27989), // Rule ID 1014 //
     /* 27949 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27952 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_u_h),
     /* 27957 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 27960 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 27963 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 27966 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27970 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27974 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 27978 */     // (intrinsic_wo_chain:{ *:[v8i16] } 8235:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBS_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 27978 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_U_H),
     /* 27981 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 27983 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 27985 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 27987 */     GIR_RootConstrainSelectedInstOperands,
     /* 27988 */     // GIR_Coverage, 1014,
     /* 27988 */     GIR_EraseRootFromParent_Done,
     /* 27989 */   // Label 820: @27989
     /* 27989 */   GIM_Try, /*On fail goto*//*Label 821*/ GIMT_Encode4(28034), // Rule ID 1015 //
     /* 27994 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 27997 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_u_w),
     /* 28002 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 28005 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 28008 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 28011 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 28015 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 28019 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 28023 */     // (intrinsic_wo_chain:{ *:[v4i32] } 8236:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBS_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 28023 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_U_W),
     /* 28026 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 28028 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 28030 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 28032 */     GIR_RootConstrainSelectedInstOperands,
     /* 28033 */     // GIR_Coverage, 1015,
     /* 28033 */     GIR_EraseRootFromParent_Done,
     /* 28034 */   // Label 821: @28034
     /* 28034 */   GIM_Try, /*On fail goto*//*Label 822*/ GIMT_Encode4(28079), // Rule ID 1016 //
     /* 28039 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 28042 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subs_u_d),
     /* 28047 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 28050 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 28053 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 28056 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 28060 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 28064 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 28068 */     // (intrinsic_wo_chain:{ *:[v2i64] } 8234:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBS_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /* 28068 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBS_U_D),
     /* 28071 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 28073 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 28075 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 28077 */     GIR_RootConstrainSelectedInstOperands,
     /* 28078 */     // GIR_Coverage, 1016,
     /* 28078 */     GIR_EraseRootFromParent_Done,
     /* 28079 */   // Label 822: @28079
     /* 28079 */   GIM_Try, /*On fail goto*//*Label 823*/ GIMT_Encode4(28124), // Rule ID 1017 //
     /* 28084 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 28087 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsus_u_b),
     /* 28092 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 28095 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 28098 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 28101 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 28105 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 28109 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 28113 */     // (intrinsic_wo_chain:{ *:[v16i8] } 8237:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBSUS_U_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 28113 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUS_U_B),
     /* 28116 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 28118 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 28120 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 28122 */     GIR_RootConstrainSelectedInstOperands,
     /* 28123 */     // GIR_Coverage, 1017,
     /* 28123 */     GIR_EraseRootFromParent_Done,
     /* 28124 */   // Label 823: @28124
     /* 28124 */   GIM_Try, /*On fail goto*//*Label 824*/ GIMT_Encode4(28169), // Rule ID 1018 //
     /* 28129 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 28132 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsus_u_h),
     /* 28137 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 28140 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 28143 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 28146 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 28150 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 28154 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 28158 */     // (intrinsic_wo_chain:{ *:[v8i16] } 8239:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBSUS_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 28158 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUS_U_H),
     /* 28161 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 28163 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 28165 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 28167 */     GIR_RootConstrainSelectedInstOperands,
     /* 28168 */     // GIR_Coverage, 1018,
     /* 28168 */     GIR_EraseRootFromParent_Done,
     /* 28169 */   // Label 824: @28169
     /* 28169 */   GIM_Try, /*On fail goto*//*Label 825*/ GIMT_Encode4(28214), // Rule ID 1019 //
     /* 28174 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 28177 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsus_u_w),
     /* 28182 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 28185 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 28188 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 28191 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 28195 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 28199 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 28203 */     // (intrinsic_wo_chain:{ *:[v4i32] } 8240:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBSUS_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 28203 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUS_U_W),
     /* 28206 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 28208 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 28210 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 28212 */     GIR_RootConstrainSelectedInstOperands,
     /* 28213 */     // GIR_Coverage, 1019,
     /* 28213 */     GIR_EraseRootFromParent_Done,
     /* 28214 */   // Label 825: @28214
     /* 28214 */   GIM_Try, /*On fail goto*//*Label 826*/ GIMT_Encode4(28259), // Rule ID 1020 //
     /* 28219 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 28222 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsus_u_d),
     /* 28227 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 28230 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 28233 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 28236 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 28240 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 28244 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 28248 */     // (intrinsic_wo_chain:{ *:[v2i64] } 8238:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBSUS_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /* 28248 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUS_U_D),
     /* 28251 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 28253 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 28255 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 28257 */     GIR_RootConstrainSelectedInstOperands,
     /* 28258 */     // GIR_Coverage, 1020,
     /* 28258 */     GIR_EraseRootFromParent_Done,
     /* 28259 */   // Label 826: @28259
     /* 28259 */   GIM_Try, /*On fail goto*//*Label 827*/ GIMT_Encode4(28304), // Rule ID 1021 //
     /* 28264 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 28267 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsuu_s_b),
     /* 28272 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 28275 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 28278 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 28281 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 28285 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 28289 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 28293 */     // (intrinsic_wo_chain:{ *:[v16i8] } 8241:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (SUBSUU_S_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 28293 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUU_S_B),
     /* 28296 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 28298 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 28300 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 28302 */     GIR_RootConstrainSelectedInstOperands,
     /* 28303 */     // GIR_Coverage, 1021,
     /* 28303 */     GIR_EraseRootFromParent_Done,
     /* 28304 */   // Label 827: @28304
     /* 28304 */   GIM_Try, /*On fail goto*//*Label 828*/ GIMT_Encode4(28349), // Rule ID 1022 //
     /* 28309 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 28312 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsuu_s_h),
     /* 28317 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 28320 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 28323 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 28326 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 28330 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 28334 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 28338 */     // (intrinsic_wo_chain:{ *:[v8i16] } 8243:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (SUBSUU_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 28338 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUU_S_H),
     /* 28341 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 28343 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 28345 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 28347 */     GIR_RootConstrainSelectedInstOperands,
     /* 28348 */     // GIR_Coverage, 1022,
     /* 28348 */     GIR_EraseRootFromParent_Done,
     /* 28349 */   // Label 828: @28349
     /* 28349 */   GIM_Try, /*On fail goto*//*Label 829*/ GIMT_Encode4(28394), // Rule ID 1023 //
     /* 28354 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 28357 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsuu_s_w),
     /* 28362 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 28365 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 28368 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 28371 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 28375 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 28379 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 28383 */     // (intrinsic_wo_chain:{ *:[v4i32] } 8244:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (SUBSUU_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 28383 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUU_S_W),
     /* 28386 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 28388 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 28390 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 28392 */     GIR_RootConstrainSelectedInstOperands,
     /* 28393 */     // GIR_Coverage, 1023,
     /* 28393 */     GIR_EraseRootFromParent_Done,
     /* 28394 */   // Label 829: @28394
     /* 28394 */   GIM_Try, /*On fail goto*//*Label 830*/ GIMT_Encode4(28439), // Rule ID 1024 //
     /* 28399 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 28402 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subsuu_s_d),
     /* 28407 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 28410 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 28413 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 28416 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 28420 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 28424 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 28428 */     // (intrinsic_wo_chain:{ *:[v2i64] } 8242:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (SUBSUU_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /* 28428 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBSUU_S_D),
     /* 28431 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 28433 */     GIR_RootToRootCopy, /*OpIdx*/2, // ws
     /* 28435 */     GIR_RootToRootCopy, /*OpIdx*/3, // wt
     /* 28437 */     GIR_RootConstrainSelectedInstOperands,
     /* 28438 */     // GIR_Coverage, 1024,
     /* 28438 */     GIR_EraseRootFromParent_Done,
     /* 28439 */   // Label 830: @28439
     /* 28439 */   GIM_Try, /*On fail goto*//*Label 831*/ GIMT_Encode4(28487), // Rule ID 1223 //
     /* 28444 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 28447 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addq_s_ph),
     /* 28452 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 28455 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 28458 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
     /* 28461 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28465 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28469 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28473 */     // (intrinsic_wo_chain:{ *:[v2i16] } 7603:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQ_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
     /* 28473 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQ_S_PH_MM),
     /* 28476 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 28478 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 28480 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 28482 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
     /* 28485 */     GIR_RootConstrainSelectedInstOperands,
     /* 28486 */     // GIR_Coverage, 1223,
     /* 28486 */     GIR_EraseRootFromParent_Done,
     /* 28487 */   // Label 831: @28487
     /* 28487 */   GIM_Try, /*On fail goto*//*Label 832*/ GIMT_Encode4(28535), // Rule ID 1225 //
     /* 28492 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 28495 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_s_qb),
     /* 28500 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 28503 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 28506 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
     /* 28509 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28513 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28517 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28521 */     // (intrinsic_wo_chain:{ *:[v4i8] } 7625:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDU_S_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
     /* 28521 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDU_S_QB_MM),
     /* 28524 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 28526 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 28528 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 28530 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
     /* 28533 */     GIR_RootConstrainSelectedInstOperands,
     /* 28534 */     // GIR_Coverage, 1225,
     /* 28534 */     GIR_EraseRootFromParent_Done,
     /* 28535 */   // Label 832: @28535
     /* 28535 */   GIM_Try, /*On fail goto*//*Label 833*/ GIMT_Encode4(28580), // Rule ID 1246 //
     /* 28540 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 28543 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_ph),
     /* 28548 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 28551 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 28554 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 28557 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28561 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28565 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 28569 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8153:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
     /* 28569 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_PH_MM),
     /* 28572 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 28574 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 28576 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs
     /* 28578 */     GIR_RootConstrainSelectedInstOperands,
     /* 28579 */     // GIR_Coverage, 1246,
     /* 28579 */     GIR_EraseRootFromParent_Done,
     /* 28580 */   // Label 833: @28580
     /* 28580 */   GIM_Try, /*On fail goto*//*Label 834*/ GIMT_Encode4(28625), // Rule ID 1247 //
     /* 28585 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 28588 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_ph),
     /* 28593 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 28596 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 28599 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 28602 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28606 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28610 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 28614 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8155:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_R_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
     /* 28614 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_PH_MM),
     /* 28617 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 28619 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 28621 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs
     /* 28623 */     GIR_RootConstrainSelectedInstOperands,
     /* 28624 */     // GIR_Coverage, 1247,
     /* 28624 */     GIR_EraseRootFromParent_Done,
     /* 28625 */   // Label 834: @28625
     /* 28625 */   GIM_Try, /*On fail goto*//*Label 835*/ GIMT_Encode4(28670), // Rule ID 1248 //
     /* 28630 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 28633 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_w),
     /* 28638 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 28641 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 28644 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 28647 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 28651 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 28655 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 28659 */     // (intrinsic_wo_chain:{ *:[i32] } 8157:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_R_W_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
     /* 28659 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_W_MM),
     /* 28662 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 28664 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 28666 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs
     /* 28668 */     GIR_RootConstrainSelectedInstOperands,
     /* 28669 */     // GIR_Coverage, 1248,
     /* 28669 */     GIR_EraseRootFromParent_Done,
     /* 28670 */   // Label 835: @28670
     /* 28670 */   GIM_Try, /*On fail goto*//*Label 836*/ GIMT_Encode4(28715), // Rule ID 1250 //
     /* 28675 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 28678 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_qb),
     /* 28683 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 28686 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 28689 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 28692 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28696 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28700 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 28704 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8159:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRLV_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
     /* 28704 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRLV_QB_MM),
     /* 28707 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 28709 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 28711 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs
     /* 28713 */     GIR_RootConstrainSelectedInstOperands,
     /* 28714 */     // GIR_Coverage, 1250,
     /* 28714 */     GIR_EraseRootFromParent_Done,
     /* 28715 */   // Label 836: @28715
     /* 28715 */   GIM_Try, /*On fail goto*//*Label 837*/ GIMT_Encode4(28763), // Rule ID 1261 //
     /* 28720 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 28723 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subq_s_ph),
     /* 28728 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 28731 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 28734 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
     /* 28737 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28741 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28745 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28749 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8223:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQ_S_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
     /* 28749 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQ_S_PH_MM),
     /* 28752 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 28754 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 28756 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 28758 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
     /* 28761 */     GIR_RootConstrainSelectedInstOperands,
     /* 28762 */     // GIR_Coverage, 1261,
     /* 28762 */     GIR_EraseRootFromParent_Done,
     /* 28763 */   // Label 837: @28763
     /* 28763 */   GIM_Try, /*On fail goto*//*Label 838*/ GIMT_Encode4(28811), // Rule ID 1263 //
     /* 28768 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 28771 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_s_qb),
     /* 28776 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 28779 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 28782 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
     /* 28785 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28789 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28793 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28797 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8248:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBU_S_QB_MM:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
     /* 28797 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBU_S_QB_MM),
     /* 28800 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 28802 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 28804 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 28806 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
     /* 28809 */     GIR_RootConstrainSelectedInstOperands,
     /* 28810 */     // GIR_Coverage, 1263,
     /* 28810 */     GIR_EraseRootFromParent_Done,
     /* 28811 */   // Label 838: @28811
     /* 28811 */   GIM_Try, /*On fail goto*//*Label 839*/ GIMT_Encode4(28856), // Rule ID 1273 //
     /* 28816 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 28819 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_ph_w),
     /* 28824 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 28827 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 28830 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 28833 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28837 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 28841 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 28845 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8128:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (PRECRQ_PH_W_MM:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /* 28845 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_PH_W_MM),
     /* 28848 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 28850 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 28852 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 28854 */     GIR_RootConstrainSelectedInstOperands,
     /* 28855 */     // GIR_Coverage, 1273,
     /* 28855 */     GIR_EraseRootFromParent_Done,
     /* 28856 */   // Label 839: @28856
     /* 28856 */   GIM_Try, /*On fail goto*//*Label 840*/ GIMT_Encode4(28901), // Rule ID 1274 //
     /* 28861 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 28864 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precrq_qb_ph),
     /* 28869 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 28872 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 28875 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
     /* 28878 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28882 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28886 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28890 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8129:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PRECRQ_QB_PH_MM:{ *:[v4i8] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
     /* 28890 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECRQ_QB_PH_MM),
     /* 28893 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 28895 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 28897 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 28899 */     GIR_RootConstrainSelectedInstOperands,
     /* 28900 */     // GIR_Coverage, 1274,
     /* 28900 */     GIR_EraseRootFromParent_Done,
     /* 28901 */   // Label 840: @28901
     /* 28901 */   GIM_Try, /*On fail goto*//*Label 841*/ GIMT_Encode4(28946), // Rule ID 1293 //
     /* 28906 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 28909 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_packrl_ph),
     /* 28914 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 28917 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 28920 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
     /* 28923 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28927 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28931 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 28935 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8100:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (PACKRL_PH_MM:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
     /* 28935 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PACKRL_PH_MM),
     /* 28938 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 28940 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 28942 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 28944 */     GIR_RootConstrainSelectedInstOperands,
     /* 28945 */     // GIR_Coverage, 1293,
     /* 28945 */     GIR_EraseRootFromParent_Done,
     /* 28946 */   // Label 841: @28946
     /* 28946 */   GIM_Try, /*On fail goto*//*Label 842*/ GIMT_Encode4(28991), // Rule ID 1299 //
     /* 28951 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_InMicroMips),
     /* 28954 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_modsub),
     /* 28959 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 28962 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 28965 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 28968 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 28972 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 28976 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 28980 */     // (intrinsic_wo_chain:{ *:[i32] } 8053:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (MODSUB_MM:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /* 28980 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MODSUB_MM),
     /* 28983 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 28985 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 28987 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 28989 */     GIR_RootConstrainSelectedInstOperands,
     /* 28990 */     // GIR_Coverage, 1299,
     /* 28990 */     GIR_EraseRootFromParent_Done,
     /* 28991 */   // Label 842: @28991
     /* 28991 */   GIM_Try, /*On fail goto*//*Label 843*/ GIMT_Encode4(29036), // Rule ID 1312 //
     /* 28996 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 28999 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_ph),
     /* 29004 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 29007 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 29010 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
     /* 29013 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29017 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29021 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29025 */     // (intrinsic_wo_chain:{ *:[v2i16] } 7605:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
     /* 29025 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_PH_MMR2),
     /* 29028 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 29030 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 29032 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 29034 */     GIR_RootConstrainSelectedInstOperands,
     /* 29035 */     // GIR_Coverage, 1312,
     /* 29035 */     GIR_EraseRootFromParent_Done,
     /* 29036 */   // Label 843: @29036
     /* 29036 */   GIM_Try, /*On fail goto*//*Label 844*/ GIMT_Encode4(29081), // Rule ID 1313 //
     /* 29041 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 29044 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_r_ph),
     /* 29049 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 29052 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 29055 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
     /* 29058 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29062 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29066 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29070 */     // (intrinsic_wo_chain:{ *:[v2i16] } 7606:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (ADDQH_R_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
     /* 29070 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_R_PH_MMR2),
     /* 29073 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 29075 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 29077 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 29079 */     GIR_RootConstrainSelectedInstOperands,
     /* 29080 */     // GIR_Coverage, 1313,
     /* 29080 */     GIR_EraseRootFromParent_Done,
     /* 29081 */   // Label 844: @29081
     /* 29081 */   GIM_Try, /*On fail goto*//*Label 845*/ GIMT_Encode4(29126), // Rule ID 1314 //
     /* 29086 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 29089 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_w),
     /* 29094 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 29097 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 29100 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 29103 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29107 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29111 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29115 */     // (intrinsic_wo_chain:{ *:[i32] } 7608:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /* 29115 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_W_MMR2),
     /* 29118 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 29120 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 29122 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 29124 */     GIR_RootConstrainSelectedInstOperands,
     /* 29125 */     // GIR_Coverage, 1314,
     /* 29125 */     GIR_EraseRootFromParent_Done,
     /* 29126 */   // Label 845: @29126
     /* 29126 */   GIM_Try, /*On fail goto*//*Label 846*/ GIMT_Encode4(29171), // Rule ID 1315 //
     /* 29131 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 29134 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addqh_r_w),
     /* 29139 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 29142 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 29145 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 29148 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29152 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29156 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29160 */     // (intrinsic_wo_chain:{ *:[i32] } 7607:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (ADDQH_R_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /* 29160 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQH_R_W_MMR2),
     /* 29163 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 29165 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 29167 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 29169 */     GIR_RootConstrainSelectedInstOperands,
     /* 29170 */     // GIR_Coverage, 1315,
     /* 29170 */     GIR_EraseRootFromParent_Done,
     /* 29171 */   // Label 846: @29171
     /* 29171 */   GIM_Try, /*On fail goto*//*Label 847*/ GIMT_Encode4(29216), // Rule ID 1318 //
     /* 29176 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 29179 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adduh_qb),
     /* 29184 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 29187 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 29190 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
     /* 29193 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29197 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29201 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29205 */     // (intrinsic_wo_chain:{ *:[v4i8] } 7626:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
     /* 29205 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDUH_QB_MMR2),
     /* 29208 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 29210 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 29212 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 29214 */     GIR_RootConstrainSelectedInstOperands,
     /* 29215 */     // GIR_Coverage, 1318,
     /* 29215 */     GIR_EraseRootFromParent_Done,
     /* 29216 */   // Label 847: @29216
     /* 29216 */   GIM_Try, /*On fail goto*//*Label 848*/ GIMT_Encode4(29261), // Rule ID 1319 //
     /* 29221 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 29224 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_adduh_r_qb),
     /* 29229 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 29232 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 29235 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
     /* 29238 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29242 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29246 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29250 */     // (intrinsic_wo_chain:{ *:[v4i8] } 7627:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (ADDUH_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
     /* 29250 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDUH_R_QB_MMR2),
     /* 29253 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 29255 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 29257 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 29259 */     GIR_RootConstrainSelectedInstOperands,
     /* 29260 */     // GIR_Coverage, 1319,
     /* 29260 */     GIR_EraseRootFromParent_Done,
     /* 29261 */   // Label 848: @29261
     /* 29261 */   GIM_Try, /*On fail goto*//*Label 849*/ GIMT_Encode4(29306), // Rule ID 1325 //
     /* 29266 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 29269 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_qb),
     /* 29274 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 29277 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 29280 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 29283 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29287 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29291 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29295 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8154:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
     /* 29295 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_QB_MMR2),
     /* 29298 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 29300 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 29302 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs
     /* 29304 */     GIR_RootConstrainSelectedInstOperands,
     /* 29305 */     // GIR_Coverage, 1325,
     /* 29305 */     GIR_EraseRootFromParent_Done,
     /* 29306 */   // Label 849: @29306
     /* 29306 */   GIM_Try, /*On fail goto*//*Label 850*/ GIMT_Encode4(29351), // Rule ID 1326 //
     /* 29311 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 29314 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shra_r_qb),
     /* 29319 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 29322 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 29325 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 29328 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29332 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29336 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29340 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8156:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRAV_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
     /* 29340 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRAV_R_QB_MMR2),
     /* 29343 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 29345 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 29347 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs
     /* 29349 */     GIR_RootConstrainSelectedInstOperands,
     /* 29350 */     // GIR_Coverage, 1326,
     /* 29350 */     GIR_EraseRootFromParent_Done,
     /* 29351 */   // Label 850: @29351
     /* 29351 */   GIM_Try, /*On fail goto*//*Label 851*/ GIMT_Encode4(29396), // Rule ID 1331 //
     /* 29356 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 29359 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_shrl_ph),
     /* 29364 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 29367 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 29370 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 29373 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29377 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29381 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29385 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8158:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)  =>  (SHRLV_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rt, GPR32Opnd:{ *:[i32] }:$rs)
     /* 29385 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SHRLV_PH_MMR2),
     /* 29388 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 29390 */     GIR_RootToRootCopy, /*OpIdx*/2, // rt
     /* 29392 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs
     /* 29394 */     GIR_RootConstrainSelectedInstOperands,
     /* 29395 */     // GIR_Coverage, 1331,
     /* 29395 */     GIR_EraseRootFromParent_Done,
     /* 29396 */   // Label 851: @29396
     /* 29396 */   GIM_Try, /*On fail goto*//*Label 852*/ GIMT_Encode4(29441), // Rule ID 1332 //
     /* 29401 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 29404 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_ph),
     /* 29409 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 29412 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 29415 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
     /* 29418 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29422 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29426 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29430 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8225:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
     /* 29430 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_PH_MMR2),
     /* 29433 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 29435 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 29437 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 29439 */     GIR_RootConstrainSelectedInstOperands,
     /* 29440 */     // GIR_Coverage, 1332,
     /* 29440 */     GIR_EraseRootFromParent_Done,
     /* 29441 */   // Label 852: @29441
     /* 29441 */   GIM_Try, /*On fail goto*//*Label 853*/ GIMT_Encode4(29486), // Rule ID 1333 //
     /* 29446 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 29449 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_r_ph),
     /* 29454 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 29457 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 29460 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
     /* 29463 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29467 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29471 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29475 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8226:{ *:[iPTR] }, DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)  =>  (SUBQH_R_PH_MMR2:{ *:[v2i16] } DSPROpnd:{ *:[v2i16] }:$rs, DSPROpnd:{ *:[v2i16] }:$rt)
     /* 29475 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_R_PH_MMR2),
     /* 29478 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 29480 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 29482 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 29484 */     GIR_RootConstrainSelectedInstOperands,
     /* 29485 */     // GIR_Coverage, 1333,
     /* 29485 */     GIR_EraseRootFromParent_Done,
     /* 29486 */   // Label 853: @29486
     /* 29486 */   GIM_Try, /*On fail goto*//*Label 854*/ GIMT_Encode4(29531), // Rule ID 1334 //
     /* 29491 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 29494 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_w),
     /* 29499 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 29502 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 29505 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 29508 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29512 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29516 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29520 */     // (intrinsic_wo_chain:{ *:[i32] } 8228:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /* 29520 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_W_MMR2),
     /* 29523 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 29525 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 29527 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 29529 */     GIR_RootConstrainSelectedInstOperands,
     /* 29530 */     // GIR_Coverage, 1334,
     /* 29530 */     GIR_EraseRootFromParent_Done,
     /* 29531 */   // Label 854: @29531
     /* 29531 */   GIM_Try, /*On fail goto*//*Label 855*/ GIMT_Encode4(29576), // Rule ID 1335 //
     /* 29536 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 29539 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subqh_r_w),
     /* 29544 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 29547 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 29550 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 29553 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29557 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29561 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29565 */     // (intrinsic_wo_chain:{ *:[i32] } 8227:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)  =>  (SUBQH_R_W_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, GPR32Opnd:{ *:[i32] }:$rt)
     /* 29565 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQH_R_W_MMR2),
     /* 29568 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 29570 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 29572 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 29574 */     GIR_RootConstrainSelectedInstOperands,
     /* 29575 */     // GIR_Coverage, 1335,
     /* 29575 */     GIR_EraseRootFromParent_Done,
     /* 29576 */   // Label 855: @29576
     /* 29576 */   GIM_Try, /*On fail goto*//*Label 856*/ GIMT_Encode4(29621), // Rule ID 1338 //
     /* 29581 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 29584 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subuh_qb),
     /* 29589 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 29592 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 29595 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
     /* 29598 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29602 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29606 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29610 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8249:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
     /* 29610 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBUH_QB_MMR2),
     /* 29613 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 29615 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 29617 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 29619 */     GIR_RootConstrainSelectedInstOperands,
     /* 29620 */     // GIR_Coverage, 1338,
     /* 29620 */     GIR_EraseRootFromParent_Done,
     /* 29621 */   // Label 856: @29621
     /* 29621 */   GIM_Try, /*On fail goto*//*Label 857*/ GIMT_Encode4(29666), // Rule ID 1339 //
     /* 29626 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 29629 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subuh_r_qb),
     /* 29634 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 29637 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 29640 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
     /* 29643 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29647 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29651 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29655 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8250:{ *:[iPTR] }, DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)  =>  (SUBUH_R_QB_MMR2:{ *:[v4i8] } DSPROpnd:{ *:[v4i8] }:$rs, DSPROpnd:{ *:[v4i8] }:$rt)
     /* 29655 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBUH_R_QB_MMR2),
     /* 29658 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 29660 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs
     /* 29662 */     GIR_RootToRootCopy, /*OpIdx*/3, // rt
     /* 29664 */     GIR_RootConstrainSelectedInstOperands,
     /* 29665 */     // GIR_Coverage, 1339,
     /* 29665 */     GIR_EraseRootFromParent_Done,
     /* 29666 */   // Label 857: @29666
     /* 29666 */   GIM_Try, /*On fail goto*//*Label 858*/ GIMT_Encode4(29706), // Rule ID 1925 //
     /* 29671 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 29674 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addq_ph),
     /* 29679 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 29682 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 29685 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
     /* 29688 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29692 */     // (intrinsic_wo_chain:{ *:[v2i16] } 7602:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (ADDQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
     /* 29692 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDQ_PH),
     /* 29695 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 29697 */     GIR_RootToRootCopy, /*OpIdx*/2, // a
     /* 29699 */     GIR_RootToRootCopy, /*OpIdx*/3, // b
     /* 29701 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
     /* 29704 */     GIR_RootConstrainSelectedInstOperands,
     /* 29705 */     // GIR_Coverage, 1925,
     /* 29705 */     GIR_EraseRootFromParent_Done,
     /* 29706 */   // Label 858: @29706
     /* 29706 */   GIM_Try, /*On fail goto*//*Label 859*/ GIMT_Encode4(29746), // Rule ID 1927 //
     /* 29711 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 29714 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subq_ph),
     /* 29719 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 29722 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /* 29725 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s16,
     /* 29728 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29732 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8222:{ *:[iPTR] }, v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)  =>  (SUBQ_PH:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$a, v2i16:{ *:[v2i16] }:$b)
     /* 29732 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBQ_PH),
     /* 29735 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 29737 */     GIR_RootToRootCopy, /*OpIdx*/2, // a
     /* 29739 */     GIR_RootToRootCopy, /*OpIdx*/3, // b
     /* 29741 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
     /* 29744 */     GIR_RootConstrainSelectedInstOperands,
     /* 29745 */     // GIR_Coverage, 1927,
     /* 29745 */     GIR_EraseRootFromParent_Done,
     /* 29746 */   // Label 859: @29746
     /* 29746 */   GIM_Try, /*On fail goto*//*Label 860*/ GIMT_Encode4(29786), // Rule ID 1931 //
     /* 29751 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 29754 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_addu_qb),
     /* 29759 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 29762 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 29765 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
     /* 29768 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29772 */     // (intrinsic_wo_chain:{ *:[v4i8] } 7623:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (ADDU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
     /* 29772 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::ADDU_QB),
     /* 29775 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 29777 */     GIR_RootToRootCopy, /*OpIdx*/2, // a
     /* 29779 */     GIR_RootToRootCopy, /*OpIdx*/3, // b
     /* 29781 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
     /* 29784 */     GIR_RootConstrainSelectedInstOperands,
     /* 29785 */     // GIR_Coverage, 1931,
     /* 29785 */     GIR_EraseRootFromParent_Done,
     /* 29786 */   // Label 860: @29786
     /* 29786 */   GIM_Try, /*On fail goto*//*Label 861*/ GIMT_Encode4(29826), // Rule ID 1933 //
     /* 29791 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP),
     /* 29794 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_subu_qb),
     /* 29799 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s8,
     /* 29802 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s8,
     /* 29805 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s8,
     /* 29808 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29812 */     // (intrinsic_wo_chain:{ *:[v4i8] } 8246:{ *:[iPTR] }, v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)  =>  (SUBU_QB:{ *:[v4i8] } v4i8:{ *:[v4i8] }:$a, v4i8:{ *:[v4i8] }:$b)
     /* 29812 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SUBU_QB),
     /* 29815 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /* 29817 */     GIR_RootToRootCopy, /*OpIdx*/2, // a
     /* 29819 */     GIR_RootToRootCopy, /*OpIdx*/3, // b
     /* 29821 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for Mips::DSPOutFlag20*/0,
     /* 29824 */     GIR_RootConstrainSelectedInstOperands,
     /* 29825 */     // GIR_Coverage, 1933,
     /* 29825 */     GIR_EraseRootFromParent_Done,
     /* 29826 */   // Label 861: @29826
     /* 29826 */   GIM_Reject,
     /* 29827 */ // Label 647: @29827
     /* 29827 */ GIM_Try, /*On fail goto*//*Label 862*/ GIMT_Encode4(32341),
     /* 29832 */   GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
     /* 29835 */   GIM_Try, /*On fail goto*//*Label 863*/ GIMT_Encode4(29890), // Rule ID 477 //
     /* 29840 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 29843 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_sra_ph_w),
     /* 29848 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 29851 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 29854 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 29857 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29861 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29865 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29869 */     // MIs[0] sa
     /* 29869 */     GIM_CheckIsImm, /*MI*/0, /*Op*/4,
     /* 29872 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
     /* 29877 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8126:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PRECR_SRA_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
     /* 29877 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECR_SRA_PH_W),
     /* 29880 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 29882 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs
     /* 29884 */     GIR_RootToRootCopy, /*OpIdx*/4, // sa
     /* 29886 */     GIR_RootToRootCopy, /*OpIdx*/2, // src
     /* 29888 */     GIR_RootConstrainSelectedInstOperands,
     /* 29889 */     // GIR_Coverage, 477,
     /* 29889 */     GIR_EraseRootFromParent_Done,
     /* 29890 */   // Label 863: @29890
     /* 29890 */   GIM_Try, /*On fail goto*//*Label 864*/ GIMT_Encode4(29945), // Rule ID 478 //
     /* 29895 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 29898 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_sra_r_ph_w),
     /* 29903 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 29906 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 29909 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 29912 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 29916 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29920 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29924 */     // MIs[0] sa
     /* 29924 */     GIM_CheckIsImm, /*MI*/0, /*Op*/4,
     /* 29927 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
     /* 29932 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8127:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PRECR_SRA_R_PH_W:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
     /* 29932 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECR_SRA_R_PH_W),
     /* 29935 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 29937 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs
     /* 29939 */     GIR_RootToRootCopy, /*OpIdx*/4, // sa
     /* 29941 */     GIR_RootToRootCopy, /*OpIdx*/2, // src
     /* 29943 */     GIR_RootConstrainSelectedInstOperands,
     /* 29944 */     // GIR_Coverage, 478,
     /* 29944 */     GIR_EraseRootFromParent_Done,
     /* 29945 */   // Label 864: @29945
     /* 29945 */   GIM_Try, /*On fail goto*//*Label 865*/ GIMT_Encode4(30000), // Rule ID 483 //
     /* 29950 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 29953 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_append),
     /* 29958 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 29961 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 29964 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 29967 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29971 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29975 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 29979 */     // MIs[0] sa
     /* 29979 */     GIM_CheckIsImm, /*MI*/0, /*Op*/4,
     /* 29982 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
     /* 29987 */     // (intrinsic_wo_chain:{ *:[i32] } 7639:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (APPEND:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
     /* 29987 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::APPEND),
     /* 29990 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 29992 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs
     /* 29994 */     GIR_RootToRootCopy, /*OpIdx*/4, // sa
     /* 29996 */     GIR_RootToRootCopy, /*OpIdx*/2, // src
     /* 29998 */     GIR_RootConstrainSelectedInstOperands,
     /* 29999 */     // GIR_Coverage, 483,
     /* 29999 */     GIR_EraseRootFromParent_Done,
     /* 30000 */   // Label 865: @30000
     /* 30000 */   GIM_Try, /*On fail goto*//*Label 866*/ GIMT_Encode4(30055), // Rule ID 484 //
     /* 30005 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 30008 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_balign),
     /* 30013 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 30016 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 30019 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 30022 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 30026 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 30030 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 30034 */     // MIs[0] sa
     /* 30034 */     GIM_CheckIsImm, /*MI*/0, /*Op*/4,
     /* 30037 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt2),
     /* 30042 */     // (intrinsic_wo_chain:{ *:[i32] } 7664:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt2>>:$sa)  =>  (BALIGN:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
     /* 30042 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BALIGN),
     /* 30045 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 30047 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs
     /* 30049 */     GIR_RootToRootCopy, /*OpIdx*/4, // sa
     /* 30051 */     GIR_RootToRootCopy, /*OpIdx*/2, // src
     /* 30053 */     GIR_RootConstrainSelectedInstOperands,
     /* 30054 */     // GIR_Coverage, 484,
     /* 30054 */     GIR_EraseRootFromParent_Done,
     /* 30055 */   // Label 866: @30055
     /* 30055 */   GIM_Try, /*On fail goto*//*Label 867*/ GIMT_Encode4(30110), // Rule ID 485 //
     /* 30060 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2),
     /* 30063 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_prepend),
     /* 30068 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 30071 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 30074 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 30077 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 30081 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 30085 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 30089 */     // MIs[0] sa
     /* 30089 */     GIM_CheckIsImm, /*MI*/0, /*Op*/4,
     /* 30092 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
     /* 30097 */     // (intrinsic_wo_chain:{ *:[i32] } 8132:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PREPEND:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
     /* 30097 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PREPEND),
     /* 30100 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 30102 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs
     /* 30104 */     GIR_RootToRootCopy, /*OpIdx*/4, // sa
     /* 30106 */     GIR_RootToRootCopy, /*OpIdx*/2, // src
     /* 30108 */     GIR_RootConstrainSelectedInstOperands,
     /* 30109 */     // GIR_Coverage, 485,
     /* 30109 */     GIR_EraseRootFromParent_Done,
     /* 30110 */   // Label 867: @30110
     /* 30110 */   GIM_Try, /*On fail goto*//*Label 868*/ GIMT_Encode4(30165), // Rule ID 953 //
     /* 30115 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 30118 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sldi_b),
     /* 30123 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 30126 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 30129 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 30132 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 30136 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 30140 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 30144 */     // MIs[0] n
     /* 30144 */     GIM_CheckIsImm, /*MI*/0, /*Op*/4,
     /* 30147 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt4),
     /* 30152 */     // (intrinsic_wo_chain:{ *:[v16i8] } 8164:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt4>>:$n)  =>  (SLDI_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, (timm:{ *:[i32] }):$n)
     /* 30152 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLDI_B),
     /* 30155 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 30157 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 30159 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 30161 */     GIR_RootToRootCopy, /*OpIdx*/4, // n
     /* 30163 */     GIR_RootConstrainSelectedInstOperands,
     /* 30164 */     // GIR_Coverage, 953,
     /* 30164 */     GIR_EraseRootFromParent_Done,
     /* 30165 */   // Label 868: @30165
     /* 30165 */   GIM_Try, /*On fail goto*//*Label 869*/ GIMT_Encode4(30220), // Rule ID 954 //
     /* 30170 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 30173 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sldi_h),
     /* 30178 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 30181 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 30184 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 30187 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 30191 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 30195 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 30199 */     // MIs[0] n
     /* 30199 */     GIM_CheckIsImm, /*MI*/0, /*Op*/4,
     /* 30202 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt3),
     /* 30207 */     // (intrinsic_wo_chain:{ *:[v8i16] } 8166:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt3>>:$n)  =>  (SLDI_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, (timm:{ *:[i32] }):$n)
     /* 30207 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLDI_H),
     /* 30210 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 30212 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 30214 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 30216 */     GIR_RootToRootCopy, /*OpIdx*/4, // n
     /* 30218 */     GIR_RootConstrainSelectedInstOperands,
     /* 30219 */     // GIR_Coverage, 954,
     /* 30219 */     GIR_EraseRootFromParent_Done,
     /* 30220 */   // Label 869: @30220
     /* 30220 */   GIM_Try, /*On fail goto*//*Label 870*/ GIMT_Encode4(30275), // Rule ID 955 //
     /* 30225 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 30228 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sldi_w),
     /* 30233 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 30236 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 30239 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 30242 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 30246 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 30250 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 30254 */     // MIs[0] n
     /* 30254 */     GIM_CheckIsImm, /*MI*/0, /*Op*/4,
     /* 30257 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt2),
     /* 30262 */     // (intrinsic_wo_chain:{ *:[v4i32] } 8167:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt2>>:$n)  =>  (SLDI_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, (timm:{ *:[i32] }):$n)
     /* 30262 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLDI_W),
     /* 30265 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 30267 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 30269 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 30271 */     GIR_RootToRootCopy, /*OpIdx*/4, // n
     /* 30273 */     GIR_RootConstrainSelectedInstOperands,
     /* 30274 */     // GIR_Coverage, 955,
     /* 30274 */     GIR_EraseRootFromParent_Done,
     /* 30275 */   // Label 870: @30275
     /* 30275 */   GIM_Try, /*On fail goto*//*Label 871*/ GIMT_Encode4(30330), // Rule ID 956 //
     /* 30280 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 30283 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_sldi_d),
     /* 30288 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 30291 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 30294 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 30297 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 30301 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 30305 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 30309 */     // MIs[0] n
     /* 30309 */     GIM_CheckIsImm, /*MI*/0, /*Op*/4,
     /* 30312 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt1),
     /* 30317 */     // (intrinsic_wo_chain:{ *:[v2i64] } 8165:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] })<<P:Predicate_timmZExt1>>:$n)  =>  (SLDI_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, (timm:{ *:[i32] }):$n)
     /* 30317 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::SLDI_D),
     /* 30320 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 30322 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 30324 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 30326 */     GIR_RootToRootCopy, /*OpIdx*/4, // n
     /* 30328 */     GIR_RootConstrainSelectedInstOperands,
     /* 30329 */     // GIR_Coverage, 956,
     /* 30329 */     GIR_EraseRootFromParent_Done,
     /* 30330 */   // Label 871: @30330
     /* 30330 */   GIM_Try, /*On fail goto*//*Label 872*/ GIMT_Encode4(30385), // Rule ID 1349 //
     /* 30335 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 30338 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_sra_ph_w),
     /* 30343 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 30346 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 30349 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 30352 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 30356 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 30360 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 30364 */     // MIs[0] sa
     /* 30364 */     GIM_CheckIsImm, /*MI*/0, /*Op*/4,
     /* 30367 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
     /* 30372 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8126:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PRECR_SRA_PH_W_MMR2:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
     /* 30372 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECR_SRA_PH_W_MMR2),
     /* 30375 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 30377 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs
     /* 30379 */     GIR_RootToRootCopy, /*OpIdx*/4, // sa
     /* 30381 */     GIR_RootToRootCopy, /*OpIdx*/2, // src
     /* 30383 */     GIR_RootConstrainSelectedInstOperands,
     /* 30384 */     // GIR_Coverage, 1349,
     /* 30384 */     GIR_EraseRootFromParent_Done,
     /* 30385 */   // Label 872: @30385
     /* 30385 */   GIM_Try, /*On fail goto*//*Label 873*/ GIMT_Encode4(30440), // Rule ID 1350 //
     /* 30390 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 30393 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_precr_sra_r_ph_w),
     /* 30398 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s16,
     /* 30401 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 30404 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 30407 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::DSPRRegClassID),
     /* 30411 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 30415 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 30419 */     // MIs[0] sa
     /* 30419 */     GIM_CheckIsImm, /*MI*/0, /*Op*/4,
     /* 30422 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
     /* 30427 */     // (intrinsic_wo_chain:{ *:[v2i16] } 8127:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PRECR_SRA_R_PH_W_MMR2:{ *:[v2i16] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
     /* 30427 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PRECR_SRA_R_PH_W_MMR2),
     /* 30430 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 30432 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs
     /* 30434 */     GIR_RootToRootCopy, /*OpIdx*/4, // sa
     /* 30436 */     GIR_RootToRootCopy, /*OpIdx*/2, // src
     /* 30438 */     GIR_RootConstrainSelectedInstOperands,
     /* 30439 */     // GIR_Coverage, 1350,
     /* 30439 */     GIR_EraseRootFromParent_Done,
     /* 30440 */   // Label 873: @30440
     /* 30440 */   GIM_Try, /*On fail goto*//*Label 874*/ GIMT_Encode4(30495), // Rule ID 1351 //
     /* 30445 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 30448 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_prepend),
     /* 30453 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 30456 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 30459 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 30462 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 30466 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 30470 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 30474 */     // MIs[0] sa
     /* 30474 */     GIM_CheckIsImm, /*MI*/0, /*Op*/4,
     /* 30477 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
     /* 30482 */     // (intrinsic_wo_chain:{ *:[i32] } 8132:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (PREPEND_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
     /* 30482 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::PREPEND_MMR2),
     /* 30485 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 30487 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs
     /* 30489 */     GIR_RootToRootCopy, /*OpIdx*/4, // sa
     /* 30491 */     GIR_RootToRootCopy, /*OpIdx*/2, // src
     /* 30493 */     GIR_RootConstrainSelectedInstOperands,
     /* 30494 */     // GIR_Coverage, 1351,
     /* 30494 */     GIR_EraseRootFromParent_Done,
     /* 30495 */   // Label 874: @30495
     /* 30495 */   GIM_Try, /*On fail goto*//*Label 875*/ GIMT_Encode4(30550), // Rule ID 1352 //
     /* 30500 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 30503 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_append),
     /* 30508 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 30511 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 30514 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 30517 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 30521 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 30525 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 30529 */     // MIs[0] sa
     /* 30529 */     GIM_CheckIsImm, /*MI*/0, /*Op*/4,
     /* 30532 */     GIM_CheckImmOperandPredicate, /*MI*/0, /*MO*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_timmZExt5),
     /* 30537 */     // (intrinsic_wo_chain:{ *:[i32] } 7639:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] })<<P:Predicate_timmZExt5>>:$sa)  =>  (APPEND_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (timm:{ *:[i32] }):$sa, GPR32Opnd:{ *:[i32] }:$src)
     /* 30537 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::APPEND_MMR2),
     /* 30540 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 30542 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs
     /* 30544 */     GIR_RootToRootCopy, /*OpIdx*/4, // sa
     /* 30546 */     GIR_RootToRootCopy, /*OpIdx*/2, // src
     /* 30548 */     GIR_RootConstrainSelectedInstOperands,
     /* 30549 */     // GIR_Coverage, 1352,
     /* 30549 */     GIR_EraseRootFromParent_Done,
     /* 30550 */   // Label 875: @30550
     /* 30550 */   GIM_Try, /*On fail goto*//*Label 876*/ GIMT_Encode4(30612), // Rule ID 1327 //
     /* 30555 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSPR2_InMicroMips),
     /* 30558 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_balign),
     /* 30563 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 30566 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 30569 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
     /* 30572 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 30576 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 30580 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::GPR32RegClassID),
     /* 30584 */     // MIs[0] bp
     /* 30584 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/4, // MIs[1]
     /* 30588 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 30592 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_immZExt2),
     /* 30596 */     // MIs[1] Operand 1
     /* 30596 */     // No operand predicates
     /* 30596 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 30598 */     // (intrinsic_wo_chain:{ *:[i32] } 7664:{ *:[iPTR] }, GPR32Opnd:{ *:[i32] }:$src, GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] })<<P:Predicate_immZExt2>>:$bp)  =>  (BALIGN_MMR2:{ *:[i32] } GPR32Opnd:{ *:[i32] }:$rs, (imm:{ *:[i32] }):$bp, GPR32Opnd:{ *:[i32] }:$src)
     /* 30598 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BALIGN_MMR2),
     /* 30601 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rt]
     /* 30603 */     GIR_RootToRootCopy, /*OpIdx*/3, // rs
     /* 30605 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // bp
     /* 30608 */     GIR_RootToRootCopy, /*OpIdx*/2, // src
     /* 30610 */     GIR_RootConstrainSelectedInstOperands,
     /* 30611 */     // GIR_Coverage, 1327,
     /* 30611 */     GIR_EraseRootFromParent_Done,
     /* 30612 */   // Label 876: @30612
     /* 30612 */   GIM_Try, /*On fail goto*//*Label 877*/ GIMT_Encode4(30666), // Rule ID 552 //
     /* 30617 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 30620 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsl_b),
     /* 30625 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 30628 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 30631 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 30634 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
     /* 30637 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 30641 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 30645 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 30649 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 30653 */     // (intrinsic_wo_chain:{ *:[v16i8] } 7673:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (BINSL_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 30653 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSL_B),
     /* 30656 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 30658 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 30660 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 30662 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 30664 */     GIR_RootConstrainSelectedInstOperands,
     /* 30665 */     // GIR_Coverage, 552,
     /* 30665 */     GIR_EraseRootFromParent_Done,
     /* 30666 */   // Label 877: @30666
     /* 30666 */   GIM_Try, /*On fail goto*//*Label 878*/ GIMT_Encode4(30720), // Rule ID 553 //
     /* 30671 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 30674 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsl_h),
     /* 30679 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 30682 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 30685 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 30688 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
     /* 30691 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 30695 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 30699 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 30703 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 30707 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7675:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (BINSL_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 30707 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSL_H),
     /* 30710 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 30712 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 30714 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 30716 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 30718 */     GIR_RootConstrainSelectedInstOperands,
     /* 30719 */     // GIR_Coverage, 553,
     /* 30719 */     GIR_EraseRootFromParent_Done,
     /* 30720 */   // Label 878: @30720
     /* 30720 */   GIM_Try, /*On fail goto*//*Label 879*/ GIMT_Encode4(30774), // Rule ID 554 //
     /* 30725 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 30728 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsl_w),
     /* 30733 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 30736 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 30739 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 30742 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
     /* 30745 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 30749 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 30753 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 30757 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 30761 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7676:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (BINSL_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 30761 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSL_W),
     /* 30764 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 30766 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 30768 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 30770 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 30772 */     GIR_RootConstrainSelectedInstOperands,
     /* 30773 */     // GIR_Coverage, 554,
     /* 30773 */     GIR_EraseRootFromParent_Done,
     /* 30774 */   // Label 879: @30774
     /* 30774 */   GIM_Try, /*On fail goto*//*Label 880*/ GIMT_Encode4(30828), // Rule ID 555 //
     /* 30779 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 30782 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsl_d),
     /* 30787 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 30790 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 30793 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 30796 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
     /* 30799 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 30803 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 30807 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 30811 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 30815 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7674:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (BINSL_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /* 30815 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSL_D),
     /* 30818 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 30820 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 30822 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 30824 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 30826 */     GIR_RootConstrainSelectedInstOperands,
     /* 30827 */     // GIR_Coverage, 555,
     /* 30827 */     GIR_EraseRootFromParent_Done,
     /* 30828 */   // Label 880: @30828
     /* 30828 */   GIM_Try, /*On fail goto*//*Label 881*/ GIMT_Encode4(30882), // Rule ID 560 //
     /* 30833 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 30836 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsr_b),
     /* 30841 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
     /* 30844 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /* 30847 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 30850 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
     /* 30853 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 30857 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 30861 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 30865 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 30869 */     // (intrinsic_wo_chain:{ *:[v16i8] } 7681:{ *:[iPTR] }, MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (BINSR_B:{ *:[v16i8] } MSA128BOpnd:{ *:[v16i8] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 30869 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSR_B),
     /* 30872 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 30874 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 30876 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 30878 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 30880 */     GIR_RootConstrainSelectedInstOperands,
     /* 30881 */     // GIR_Coverage, 560,
     /* 30881 */     GIR_EraseRootFromParent_Done,
     /* 30882 */   // Label 881: @30882
     /* 30882 */   GIM_Try, /*On fail goto*//*Label 882*/ GIMT_Encode4(30936), // Rule ID 561 //
     /* 30887 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 30890 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsr_h),
     /* 30895 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 30898 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 30901 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 30904 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
     /* 30907 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 30911 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 30915 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 30919 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 30923 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7683:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (BINSR_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 30923 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSR_H),
     /* 30926 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 30928 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 30930 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 30932 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 30934 */     GIR_RootConstrainSelectedInstOperands,
     /* 30935 */     // GIR_Coverage, 561,
     /* 30935 */     GIR_EraseRootFromParent_Done,
     /* 30936 */   // Label 882: @30936
     /* 30936 */   GIM_Try, /*On fail goto*//*Label 883*/ GIMT_Encode4(30990), // Rule ID 562 //
     /* 30941 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 30944 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsr_w),
     /* 30949 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 30952 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 30955 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 30958 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
     /* 30961 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 30965 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 30969 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 30973 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 30977 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7684:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (BINSR_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 30977 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSR_W),
     /* 30980 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 30982 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 30984 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 30986 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 30988 */     GIR_RootConstrainSelectedInstOperands,
     /* 30989 */     // GIR_Coverage, 562,
     /* 30989 */     GIR_EraseRootFromParent_Done,
     /* 30990 */   // Label 883: @30990
     /* 30990 */   GIM_Try, /*On fail goto*//*Label 884*/ GIMT_Encode4(31044), // Rule ID 563 //
     /* 30995 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 30998 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_binsr_d),
     /* 31003 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 31006 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 31009 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 31012 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
     /* 31015 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 31019 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 31023 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 31027 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 31031 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7682:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)  =>  (BINSR_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128DOpnd:{ *:[v2i64] }:$ws, MSA128DOpnd:{ *:[v2i64] }:$wt)
     /* 31031 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::BINSR_D),
     /* 31034 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 31036 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 31038 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 31040 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 31042 */     GIR_RootConstrainSelectedInstOperands,
     /* 31043 */     // GIR_Coverage, 563,
     /* 31043 */     GIR_EraseRootFromParent_Done,
     /* 31044 */   // Label 884: @31044
     /* 31044 */   GIM_Try, /*On fail goto*//*Label 885*/ GIMT_Encode4(31098), // Rule ID 658 //
     /* 31049 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 31052 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_s_h),
     /* 31057 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 31060 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 31063 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 31066 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
     /* 31069 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31073 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31077 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 31081 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 31085 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7802:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPADD_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 31085 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPADD_S_H),
     /* 31088 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 31090 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 31092 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 31094 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 31096 */     GIR_RootConstrainSelectedInstOperands,
     /* 31097 */     // GIR_Coverage, 658,
     /* 31097 */     GIR_EraseRootFromParent_Done,
     /* 31098 */   // Label 885: @31098
     /* 31098 */   GIM_Try, /*On fail goto*//*Label 886*/ GIMT_Encode4(31152), // Rule ID 659 //
     /* 31103 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 31106 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_s_w),
     /* 31111 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 31114 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 31117 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 31120 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
     /* 31123 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31127 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31131 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31135 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31139 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7803:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPADD_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 31139 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPADD_S_W),
     /* 31142 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 31144 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 31146 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 31148 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 31150 */     GIR_RootConstrainSelectedInstOperands,
     /* 31151 */     // GIR_Coverage, 659,
     /* 31151 */     GIR_EraseRootFromParent_Done,
     /* 31152 */   // Label 886: @31152
     /* 31152 */   GIM_Try, /*On fail goto*//*Label 887*/ GIMT_Encode4(31206), // Rule ID 660 //
     /* 31157 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 31160 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_s_d),
     /* 31165 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 31168 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 31171 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 31174 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
     /* 31177 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 31181 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 31185 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31189 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31193 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7801:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPADD_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 31193 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPADD_S_D),
     /* 31196 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 31198 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 31200 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 31202 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 31204 */     GIR_RootConstrainSelectedInstOperands,
     /* 31205 */     // GIR_Coverage, 660,
     /* 31205 */     GIR_EraseRootFromParent_Done,
     /* 31206 */   // Label 887: @31206
     /* 31206 */   GIM_Try, /*On fail goto*//*Label 888*/ GIMT_Encode4(31260), // Rule ID 661 //
     /* 31211 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 31214 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_u_h),
     /* 31219 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 31222 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 31225 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 31228 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
     /* 31231 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31235 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31239 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 31243 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 31247 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7805:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPADD_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 31247 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPADD_U_H),
     /* 31250 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 31252 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 31254 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 31256 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 31258 */     GIR_RootConstrainSelectedInstOperands,
     /* 31259 */     // GIR_Coverage, 661,
     /* 31259 */     GIR_EraseRootFromParent_Done,
     /* 31260 */   // Label 888: @31260
     /* 31260 */   GIM_Try, /*On fail goto*//*Label 889*/ GIMT_Encode4(31314), // Rule ID 662 //
     /* 31265 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 31268 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_u_w),
     /* 31273 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 31276 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 31279 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 31282 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
     /* 31285 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31289 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31293 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31297 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31301 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7806:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPADD_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 31301 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPADD_U_W),
     /* 31304 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 31306 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 31308 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 31310 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 31312 */     GIR_RootConstrainSelectedInstOperands,
     /* 31313 */     // GIR_Coverage, 662,
     /* 31313 */     GIR_EraseRootFromParent_Done,
     /* 31314 */   // Label 889: @31314
     /* 31314 */   GIM_Try, /*On fail goto*//*Label 890*/ GIMT_Encode4(31368), // Rule ID 663 //
     /* 31319 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 31322 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpadd_u_d),
     /* 31327 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 31330 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 31333 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 31336 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
     /* 31339 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 31343 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 31347 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31351 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31355 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7804:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPADD_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 31355 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPADD_U_D),
     /* 31358 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 31360 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 31362 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 31364 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 31366 */     GIR_RootConstrainSelectedInstOperands,
     /* 31367 */     // GIR_Coverage, 663,
     /* 31367 */     GIR_EraseRootFromParent_Done,
     /* 31368 */   // Label 890: @31368
     /* 31368 */   GIM_Try, /*On fail goto*//*Label 891*/ GIMT_Encode4(31422), // Rule ID 664 //
     /* 31373 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 31376 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_s_h),
     /* 31381 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 31384 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 31387 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 31390 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
     /* 31393 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31397 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31401 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 31405 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 31409 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7822:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPSUB_S_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 31409 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPSUB_S_H),
     /* 31412 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 31414 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 31416 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 31418 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 31420 */     GIR_RootConstrainSelectedInstOperands,
     /* 31421 */     // GIR_Coverage, 664,
     /* 31421 */     GIR_EraseRootFromParent_Done,
     /* 31422 */   // Label 891: @31422
     /* 31422 */   GIM_Try, /*On fail goto*//*Label 892*/ GIMT_Encode4(31476), // Rule ID 665 //
     /* 31427 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 31430 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_s_w),
     /* 31435 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 31438 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 31441 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 31444 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
     /* 31447 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31451 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31455 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31459 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31463 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7823:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPSUB_S_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 31463 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPSUB_S_W),
     /* 31466 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 31468 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 31470 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 31472 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 31474 */     GIR_RootConstrainSelectedInstOperands,
     /* 31475 */     // GIR_Coverage, 665,
     /* 31475 */     GIR_EraseRootFromParent_Done,
     /* 31476 */   // Label 892: @31476
     /* 31476 */   GIM_Try, /*On fail goto*//*Label 893*/ GIMT_Encode4(31530), // Rule ID 666 //
     /* 31481 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 31484 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_s_d),
     /* 31489 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 31492 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 31495 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 31498 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
     /* 31501 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 31505 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 31509 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31513 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31517 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7821:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPSUB_S_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 31517 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPSUB_S_D),
     /* 31520 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 31522 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 31524 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 31526 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 31528 */     GIR_RootConstrainSelectedInstOperands,
     /* 31529 */     // GIR_Coverage, 666,
     /* 31529 */     GIR_EraseRootFromParent_Done,
     /* 31530 */   // Label 893: @31530
     /* 31530 */   GIM_Try, /*On fail goto*//*Label 894*/ GIMT_Encode4(31584), // Rule ID 667 //
     /* 31535 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 31538 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_u_h),
     /* 31543 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 31546 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 31549 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
     /* 31552 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v16s8,
     /* 31555 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31559 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31563 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 31567 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128BRegClassID),
     /* 31571 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7825:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)  =>  (DPSUB_U_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128BOpnd:{ *:[v16i8] }:$ws, MSA128BOpnd:{ *:[v16i8] }:$wt)
     /* 31571 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPSUB_U_H),
     /* 31574 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 31576 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 31578 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 31580 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 31582 */     GIR_RootConstrainSelectedInstOperands,
     /* 31583 */     // GIR_Coverage, 667,
     /* 31583 */     GIR_EraseRootFromParent_Done,
     /* 31584 */   // Label 894: @31584
     /* 31584 */   GIM_Try, /*On fail goto*//*Label 895*/ GIMT_Encode4(31638), // Rule ID 668 //
     /* 31589 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 31592 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_u_w),
     /* 31597 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 31600 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 31603 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 31606 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
     /* 31609 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31613 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31617 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31621 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31625 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7826:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (DPSUB_U_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 31625 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPSUB_U_W),
     /* 31628 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 31630 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 31632 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 31634 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 31636 */     GIR_RootConstrainSelectedInstOperands,
     /* 31637 */     // GIR_Coverage, 668,
     /* 31637 */     GIR_EraseRootFromParent_Done,
     /* 31638 */   // Label 895: @31638
     /* 31638 */   GIM_Try, /*On fail goto*//*Label 896*/ GIMT_Encode4(31692), // Rule ID 669 //
     /* 31643 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 31646 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_dpsub_u_d),
     /* 31651 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
     /* 31654 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 31657 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 31660 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
     /* 31663 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 31667 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128DRegClassID),
     /* 31671 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31675 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31679 */     // (intrinsic_wo_chain:{ *:[v2i64] } 7824:{ *:[iPTR] }, MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (DPSUB_U_D:{ *:[v2i64] } MSA128DOpnd:{ *:[v2i64] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 31679 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::DPSUB_U_D),
     /* 31682 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 31684 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 31686 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 31688 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 31690 */     GIR_RootConstrainSelectedInstOperands,
     /* 31691 */     // GIR_Coverage, 669,
     /* 31691 */     GIR_EraseRootFromParent_Done,
     /* 31692 */   // Label 896: @31692
     /* 31692 */   GIM_Try, /*On fail goto*//*Label 897*/ GIMT_Encode4(31746), // Rule ID 836 //
     /* 31697 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 31700 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_madd_q_h),
     /* 31705 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 31708 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 31711 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 31714 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
     /* 31717 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31721 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31725 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31729 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31733 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7992:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MADD_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 31733 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADD_Q_H),
     /* 31736 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 31738 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 31740 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 31742 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 31744 */     GIR_RootConstrainSelectedInstOperands,
     /* 31745 */     // GIR_Coverage, 836,
     /* 31745 */     GIR_EraseRootFromParent_Done,
     /* 31746 */   // Label 897: @31746
     /* 31746 */   GIM_Try, /*On fail goto*//*Label 898*/ GIMT_Encode4(31800), // Rule ID 837 //
     /* 31751 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 31754 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_madd_q_w),
     /* 31759 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 31762 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 31765 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 31768 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
     /* 31771 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31775 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31779 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31783 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31787 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7993:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MADD_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 31787 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADD_Q_W),
     /* 31790 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 31792 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 31794 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 31796 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 31798 */     GIR_RootConstrainSelectedInstOperands,
     /* 31799 */     // GIR_Coverage, 837,
     /* 31799 */     GIR_EraseRootFromParent_Done,
     /* 31800 */   // Label 898: @31800
     /* 31800 */   GIM_Try, /*On fail goto*//*Label 899*/ GIMT_Encode4(31854), // Rule ID 838 //
     /* 31805 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 31808 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_maddr_q_h),
     /* 31813 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 31816 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 31819 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 31822 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
     /* 31825 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31829 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31833 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31837 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31841 */     // (intrinsic_wo_chain:{ *:[v8i16] } 7994:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MADDR_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 31841 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDR_Q_H),
     /* 31844 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 31846 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 31848 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 31850 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 31852 */     GIR_RootConstrainSelectedInstOperands,
     /* 31853 */     // GIR_Coverage, 838,
     /* 31853 */     GIR_EraseRootFromParent_Done,
     /* 31854 */   // Label 899: @31854
     /* 31854 */   GIM_Try, /*On fail goto*//*Label 900*/ GIMT_Encode4(31908), // Rule ID 839 //
     /* 31859 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 31862 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_maddr_q_w),
     /* 31867 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 31870 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 31873 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 31876 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
     /* 31879 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31883 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31887 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31891 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31895 */     // (intrinsic_wo_chain:{ *:[v4i32] } 7995:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MADDR_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 31895 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MADDR_Q_W),
     /* 31898 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 31900 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 31902 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 31904 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 31906 */     GIR_RootConstrainSelectedInstOperands,
     /* 31907 */     // GIR_Coverage, 839,
     /* 31907 */     GIR_EraseRootFromParent_Done,
     /* 31908 */   // Label 900: @31908
     /* 31908 */   GIM_Try, /*On fail goto*//*Label 901*/ GIMT_Encode4(31962), // Rule ID 892 //
     /* 31913 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 31916 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_msub_q_h),
     /* 31921 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
     /* 31924 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /* 31927 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
     /* 31930 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
     /* 31933 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31937 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31941 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31945 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128HRegClassID),
     /* 31949 */     // (intrinsic_wo_chain:{ *:[v8i16] } 8056:{ *:[iPTR] }, MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)  =>  (MSUB_Q_H:{ *:[v8i16] } MSA128HOpnd:{ *:[v8i16] }:$wd_in, MSA128HOpnd:{ *:[v8i16] }:$ws, MSA128HOpnd:{ *:[v8i16] }:$wt)
     /* 31949 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(Mips::MSUB_Q_H),
     /* 31952 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[wd]
     /* 31954 */     GIR_RootToRootCopy, /*OpIdx*/2, // wd_in
     /* 31956 */     GIR_RootToRootCopy, /*OpIdx*/3, // ws
     /* 31958 */     GIR_RootToRootCopy, /*OpIdx*/4, // wt
     /* 31960 */     GIR_RootConstrainSelectedInstOperands,
     /* 31961 */     // GIR_Coverage, 892,
     /* 31961 */     GIR_EraseRootFromParent_Done,
     /* 31962 */   // Label 901: @31962
     /* 31962 */   GIM_Try, /*On fail goto*//*Label 902*/ GIMT_Encode4(32016), // Rule ID 893 //
     /* 31967 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMSA_HasStdEnc),
     /* 31970 */     GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::mips_msub_q_w),
     /* 31975 */     GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
     /* 31978 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /* 31981 */     GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
     /* 31984 */     GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
     /* 31987 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31991 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31995 */     GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 31999 */     GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(Mips::MSA128WRegClassID),
     /* 32003 */     // (intrinsic_wo_chain:{ *:[v4i32] } 8057:{ *:[iPTR] }, MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)  =>  (MSUB_Q_W:{ *:[v4i32] } MSA128WOpnd:{ *:[v4i32] }:$wd_in, MSA128WOpnd:{ *:[v4i32] }:$ws, MSA128WOpnd:{ *:[v4i32] }:$wt)
     /* 32003 */     GIR_BuildRootMI, /*Opco