/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|*  * Mips Disassembler                                                       *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#include "llvm/MC/MCInst.h"
#include "llvm/MC/MCSubtargetInfo.h"
#include "llvm/Support/DataTypes.h"
#include "llvm/Support/Debug.h"
#include "llvm/Support/LEB128.h"
#include "llvm/Support/raw_ostream.h"
#include "llvm/TargetParser/SubtargetFeature.h"
#include <assert.h>

namespace {

// Helper functions for extracting fields from encoded instructions.
// InsnType must either be integral or an APInt-like object that must:
// * be default-constructible and copy-constructible
// * Support extractBitsAsZExtValue(numBits, startBit)
// * Support the ~, &, ==, and != operators with other objects of the same type
// * Support the != and bitwise & with uint64_t
template <typename InsnType>
#if defined(_MSC_VER) && !defined(__clang__)
__declspec(noinline)
#endif
static std::enable_if_t<std::is_integral<InsnType>::value, InsnType>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  assert(startBit + numBits <= 64 && "Cannot support >64-bit extractions!");
  assert(startBit + numBits <= (sizeof(InsnType) * 8) &&
         "Instruction field out of bounds!");
  InsnType fieldMask;
  if (numBits == sizeof(InsnType) * 8)
    fieldMask = (InsnType)(-1LL);
  else
    fieldMask = (((InsnType)1 << numBits) - 1) << startBit;
  return (insn & fieldMask) >> startBit;
}

template <typename InsnType>
static std::enable_if_t<!std::is_integral<InsnType>::value, uint64_t>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  return insn.extractBitsAsZExtValue(numBits, startBit);
}

// Helper function for inserting bits extracted from an encoded instruction into
// an integer-typed field.
template <typename IntType>
static std::enable_if_t<std::is_integral_v<IntType>, void>
insertBits(IntType &field, IntType bits, unsigned startBit, unsigned numBits) {
  // Check that no bit beyond numBits is set, so that a simple bitwise |
  // is sufficient.
  assert((~(((IntType)1 << numBits) - 1) & bits) == 0 &&
           "bits has more than numBits bits set");
  assert(startBit + numBits <= sizeof(IntType) * 8);
  (void)numBits;
  field |= bits << startBit;
}

static bool Check(DecodeStatus &Out, DecodeStatus In) {
  Out = static_cast<DecodeStatus>(Out & In);
  return Out != MCDisassembler::Fail;
}

static const uint8_t DecoderTable16[] = {
/* 0 */       MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 3 */       MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 13
/* 7 */       MCD::OPC_CheckPredicateOrFail, 0, 
/* 9 */       MCD::OPC_Decode, 202, 8, 0, // Opcode: Bimm16, DecodeIdx: 0
/* 13 */      MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 23
/* 17 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 19 */      MCD::OPC_Decode, 200, 8, 1, // Opcode: BeqzRxImm16, DecodeIdx: 1
/* 23 */      MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 33
/* 27 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 29 */      MCD::OPC_Decode, 204, 8, 1, // Opcode: BnezRxImm16, DecodeIdx: 1
/* 33 */      MCD::OPC_FilterValue, 9, 6, 0, // Skip to: 43
/* 37 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 39 */      MCD::OPC_Decode, 135, 7, 2, // Opcode: AddiuRxRxImm16, DecodeIdx: 2
/* 43 */      MCD::OPC_FilterValue, 10, 6, 0, // Skip to: 53
/* 47 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 49 */      MCD::OPC_Decode, 249, 21, 3, // Opcode: SltiRxImm16, DecodeIdx: 3
/* 53 */      MCD::OPC_FilterValue, 11, 6, 0, // Skip to: 63
/* 57 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 59 */      MCD::OPC_Decode, 251, 21, 3, // Opcode: SltiuRxImm16, DecodeIdx: 3
/* 63 */      MCD::OPC_FilterValue, 12, 51, 0, // Skip to: 118
/* 67 */      MCD::OPC_ExtractField, 8, 3,  // Inst{10-8} ...
/* 70 */      MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 80
/* 74 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 76 */      MCD::OPC_Decode, 207, 8, 4, // Opcode: Bteqz16, DecodeIdx: 4
/* 80 */      MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 90
/* 84 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 86 */      MCD::OPC_Decode, 209, 8, 4, // Opcode: Btnez16, DecodeIdx: 4
/* 90 */      MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 100
/* 94 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 96 */      MCD::OPC_Decode, 138, 7, 4, // Opcode: AddiuSpImm16, DecodeIdx: 4
/* 100 */     MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 110
/* 104 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 106 */     MCD::OPC_Decode, 253, 17, 5, // Opcode: Move32R16, DecodeIdx: 5
/* 110 */     MCD::OPC_FilterValueOrFail, 7, 
/* 112 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 114 */     MCD::OPC_Decode, 254, 17, 6, // Opcode: MoveR3216, DecodeIdx: 6
/* 118 */     MCD::OPC_FilterValue, 13, 6, 0, // Skip to: 128
/* 122 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 124 */     MCD::OPC_Decode, 207, 15, 3, // Opcode: LiRxImm16, DecodeIdx: 3
/* 128 */     MCD::OPC_FilterValue, 14, 6, 0, // Skip to: 138
/* 132 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 134 */     MCD::OPC_Decode, 145, 11, 3, // Opcode: CmpiRxImm16, DecodeIdx: 3
/* 138 */     MCD::OPC_FilterValue, 22, 6, 0, // Skip to: 148
/* 142 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 144 */     MCD::OPC_Decode, 210, 15, 7, // Opcode: LwRxPcTcp16, DecodeIdx: 7
/* 148 */     MCD::OPC_FilterValue, 28, 21, 0, // Skip to: 173
/* 152 */     MCD::OPC_ExtractField, 0, 2,  // Inst{1-0} ...
/* 155 */     MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 165
/* 159 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 161 */     MCD::OPC_Decode, 140, 7, 8, // Opcode: AdduRxRyRz16, DecodeIdx: 8
/* 165 */     MCD::OPC_FilterValueOrFail, 3, 
/* 167 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 169 */     MCD::OPC_Decode, 130, 22, 8, // Opcode: SubuRxRyRz16, DecodeIdx: 8
/* 173 */     MCD::OPC_FilterValueOrFail, 29, 
/* 175 */     MCD::OPC_ExtractField, 0, 5,  // Inst{4-0} ...
/* 178 */     MCD::OPC_FilterValue, 0, 53, 0, // Skip to: 235
/* 182 */     MCD::OPC_ExtractField, 5, 3,  // Inst{7-5} ...
/* 185 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 195
/* 189 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 191 */     MCD::OPC_Decode, 213, 14, 9, // Opcode: JumpLinkReg16, DecodeIdx: 9
/* 195 */     MCD::OPC_FilterValue, 1, 10, 0, // Skip to: 209
/* 199 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 201 */     MCD::OPC_CheckFieldOrFail, 8, 3, 0, 
/* 205 */     MCD::OPC_Decode, 210, 14, 10, // Opcode: JrRa16, DecodeIdx: 10
/* 209 */     MCD::OPC_FilterValue, 6, 10, 0, // Skip to: 223
/* 213 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 215 */     MCD::OPC_CheckFieldOrFail, 8, 3, 0, 
/* 219 */     MCD::OPC_Decode, 212, 14, 10, // Opcode: JrcRx16, DecodeIdx: 10
/* 223 */     MCD::OPC_FilterValueOrFail, 7, 
/* 225 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 227 */     MCD::OPC_CheckFieldOrFail, 8, 3, 0, 
/* 231 */     MCD::OPC_Decode, 211, 14, 10, // Opcode: JrcRa16, DecodeIdx: 10
/* 235 */     MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 245
/* 239 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 241 */     MCD::OPC_Decode, 248, 21, 11, // Opcode: SltRxRy16, DecodeIdx: 11
/* 245 */     MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 255
/* 249 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 251 */     MCD::OPC_Decode, 253, 21, 11, // Opcode: SltuRxRy16, DecodeIdx: 11
/* 255 */     MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 265
/* 259 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 261 */     MCD::OPC_Decode, 247, 21, 12, // Opcode: SllvRxRy16, DecodeIdx: 12
/* 265 */     MCD::OPC_FilterValue, 5, 10, 0, // Skip to: 279
/* 269 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 271 */     MCD::OPC_CheckFieldOrFail, 5, 6, 0, 
/* 275 */     MCD::OPC_Decode, 206, 8, 10, // Opcode: Break16, DecodeIdx: 10
/* 279 */     MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 289
/* 283 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 285 */     MCD::OPC_Decode, 129, 22, 12, // Opcode: SrlvRxRy16, DecodeIdx: 12
/* 289 */     MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 299
/* 293 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 295 */     MCD::OPC_Decode, 255, 21, 12, // Opcode: SravRxRy16, DecodeIdx: 12
/* 299 */     MCD::OPC_FilterValue, 10, 6, 0, // Skip to: 309
/* 303 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 305 */     MCD::OPC_Decode, 144, 11, 11, // Opcode: CmpRxRy16, DecodeIdx: 11
/* 309 */     MCD::OPC_FilterValue, 12, 6, 0, // Skip to: 319
/* 313 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 315 */     MCD::OPC_Decode, 141, 7, 12, // Opcode: AndRxRxRy16, DecodeIdx: 12
/* 319 */     MCD::OPC_FilterValue, 13, 6, 0, // Skip to: 329
/* 323 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 325 */     MCD::OPC_Decode, 168, 18, 12, // Opcode: OrRxRxRy16, DecodeIdx: 12
/* 329 */     MCD::OPC_FilterValue, 14, 6, 0, // Skip to: 339
/* 333 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 335 */     MCD::OPC_Decode, 222, 22, 12, // Opcode: XorRxRxRy16, DecodeIdx: 12
/* 339 */     MCD::OPC_FilterValue, 15, 6, 0, // Skip to: 349
/* 343 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 345 */     MCD::OPC_Decode, 155, 18, 11, // Opcode: NotRxRy16, DecodeIdx: 11
/* 349 */     MCD::OPC_FilterValue, 16, 10, 0, // Skip to: 363
/* 353 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 355 */     MCD::OPC_CheckFieldOrFail, 5, 3, 0, 
/* 359 */     MCD::OPC_Decode, 251, 17, 9, // Opcode: Mfhi16, DecodeIdx: 9
/* 363 */     MCD::OPC_FilterValue, 17, 21, 0, // Skip to: 388
/* 367 */     MCD::OPC_ExtractField, 5, 3,  // Inst{7-5} ...
/* 370 */     MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 380
/* 374 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 376 */     MCD::OPC_Decode, 243, 21, 13, // Opcode: SebRx16, DecodeIdx: 13
/* 380 */     MCD::OPC_FilterValueOrFail, 5, 
/* 382 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 384 */     MCD::OPC_Decode, 244, 21, 13, // Opcode: SehRx16, DecodeIdx: 13
/* 388 */     MCD::OPC_FilterValue, 18, 10, 0, // Skip to: 402
/* 392 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 394 */     MCD::OPC_CheckFieldOrFail, 5, 3, 0, 
/* 398 */     MCD::OPC_Decode, 252, 17, 9, // Opcode: Mflo16, DecodeIdx: 9
/* 402 */     MCD::OPC_FilterValue, 26, 6, 0, // Skip to: 412
/* 406 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 408 */     MCD::OPC_Decode, 154, 12, 11, // Opcode: DivRxRy16, DecodeIdx: 11
/* 412 */     MCD::OPC_FilterValue, 27, 6, 0, // Skip to: 422
/* 416 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 418 */     MCD::OPC_Decode, 155, 12, 11, // Opcode: DivuRxRy16, DecodeIdx: 11
/* 422 */     MCD::OPC_FilterValueOrFail, 29, 
/* 424 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 426 */     MCD::OPC_Decode, 154, 18, 11, // Opcode: NegRxRy16, DecodeIdx: 11
/* 430 */     MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTable32[] = {
/* 0 */       MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 3 */       MCD::OPC_FilterValue, 1, 14, 0, // Skip to: 21
/* 7 */       MCD::OPC_CheckPredicateOrFail, 0, 
/* 9 */       MCD::OPC_CheckFieldOrFail, 27, 5, 30, 
/* 13 */      MCD::OPC_CheckFieldOrFail, 5, 3, 0, 
/* 17 */      MCD::OPC_Decode, 134, 7, 14, // Opcode: AddiuRxPcImmX16, DecodeIdx: 14
/* 21 */      MCD::OPC_FilterValue, 2, 14, 0, // Skip to: 39
/* 25 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 27 */      MCD::OPC_CheckFieldOrFail, 27, 5, 30, 
/* 31 */      MCD::OPC_CheckFieldOrFail, 5, 6, 0, 
/* 35 */      MCD::OPC_Decode, 203, 8, 15, // Opcode: BimmX16, DecodeIdx: 15
/* 39 */      MCD::OPC_FilterValue, 4, 14, 0, // Skip to: 57
/* 43 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 45 */      MCD::OPC_CheckFieldOrFail, 27, 5, 30, 
/* 49 */      MCD::OPC_CheckFieldOrFail, 5, 3, 0, 
/* 53 */      MCD::OPC_Decode, 201, 8, 16, // Opcode: BeqzRxImmX16, DecodeIdx: 16
/* 57 */      MCD::OPC_FilterValue, 5, 14, 0, // Skip to: 75
/* 61 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 63 */      MCD::OPC_CheckFieldOrFail, 27, 5, 30, 
/* 67 */      MCD::OPC_CheckFieldOrFail, 5, 3, 0, 
/* 71 */      MCD::OPC_Decode, 205, 8, 16, // Opcode: BnezRxImmX16, DecodeIdx: 16
/* 75 */      MCD::OPC_FilterValue, 6, 82, 0, // Skip to: 161
/* 79 */      MCD::OPC_ExtractField, 27, 5,  // Inst{31-27} ...
/* 82 */      MCD::OPC_FilterValueOrFail, 30, 
/* 84 */      MCD::OPC_ExtractField, 16, 5,  // Inst{20-16} ...
/* 87 */      MCD::OPC_FilterValue, 0, 39, 0, // Skip to: 130
/* 91 */      MCD::OPC_ExtractField, 0, 5,  // Inst{4-0} ...
/* 94 */      MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 106
/* 98 */      MCD::OPC_CheckPredicate, 0, 28, 0, // Skip to: 130
/* 102 */     MCD::OPC_Decode, 246, 21, 17, // Opcode: SllX16, DecodeIdx: 17
/* 106 */     MCD::OPC_FilterValue, 2, 8, 0, // Skip to: 118
/* 110 */     MCD::OPC_CheckPredicate, 0, 16, 0, // Skip to: 130
/* 114 */     MCD::OPC_Decode, 128, 22, 17, // Opcode: SrlX16, DecodeIdx: 17
/* 118 */     MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 130
/* 122 */     MCD::OPC_CheckPredicate, 0, 4, 0, // Skip to: 130
/* 126 */     MCD::OPC_Decode, 254, 21, 17, // Opcode: SraX16, DecodeIdx: 17
/* 130 */     MCD::OPC_ExtractField, 5, 6,  // Inst{10-5} ...
/* 133 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 143
/* 137 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 139 */     MCD::OPC_Decode, 208, 8, 18, // Opcode: BteqzX16, DecodeIdx: 18
/* 143 */     MCD::OPC_FilterValue, 8, 6, 0, // Skip to: 153
/* 147 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 149 */     MCD::OPC_Decode, 210, 8, 18, // Opcode: BtnezX16, DecodeIdx: 18
/* 153 */     MCD::OPC_FilterValueOrFail, 24, 
/* 155 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 157 */     MCD::OPC_Decode, 139, 7, 18, // Opcode: AddiuSpImmX16, DecodeIdx: 18
/* 161 */     MCD::OPC_FilterValue, 8, 14, 0, // Skip to: 179
/* 165 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 167 */     MCD::OPC_CheckFieldOrFail, 27, 5, 30, 
/* 171 */     MCD::OPC_CheckFieldOrFail, 4, 1, 0, 
/* 175 */     MCD::OPC_Decode, 137, 7, 19, // Opcode: AddiuRxRyOffMemX16, DecodeIdx: 19
/* 179 */     MCD::OPC_FilterValue, 9, 14, 0, // Skip to: 197
/* 183 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 185 */     MCD::OPC_CheckFieldOrFail, 27, 5, 30, 
/* 189 */     MCD::OPC_CheckFieldOrFail, 5, 3, 0, 
/* 193 */     MCD::OPC_Decode, 133, 7, 14, // Opcode: AddiuRxImmX16, DecodeIdx: 14
/* 197 */     MCD::OPC_FilterValue, 10, 14, 0, // Skip to: 215
/* 201 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 203 */     MCD::OPC_CheckFieldOrFail, 27, 5, 30, 
/* 207 */     MCD::OPC_CheckFieldOrFail, 5, 3, 0, 
/* 211 */     MCD::OPC_Decode, 250, 21, 14, // Opcode: SltiRxImmX16, DecodeIdx: 14
/* 215 */     MCD::OPC_FilterValue, 11, 14, 0, // Skip to: 233
/* 219 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 221 */     MCD::OPC_CheckFieldOrFail, 27, 5, 30, 
/* 225 */     MCD::OPC_CheckFieldOrFail, 5, 3, 0, 
/* 229 */     MCD::OPC_Decode, 252, 21, 14, // Opcode: SltiuRxImmX16, DecodeIdx: 14
/* 233 */     MCD::OPC_FilterValue, 13, 14, 0, // Skip to: 251
/* 237 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 239 */     MCD::OPC_CheckFieldOrFail, 27, 5, 30, 
/* 243 */     MCD::OPC_CheckFieldOrFail, 5, 3, 0, 
/* 247 */     MCD::OPC_Decode, 209, 15, 14, // Opcode: LiRxImmX16, DecodeIdx: 14
/* 251 */     MCD::OPC_FilterValue, 14, 14, 0, // Skip to: 269
/* 255 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 257 */     MCD::OPC_CheckFieldOrFail, 27, 5, 30, 
/* 261 */     MCD::OPC_CheckFieldOrFail, 5, 3, 0, 
/* 265 */     MCD::OPC_Decode, 146, 11, 14, // Opcode: CmpiRxImmX16, DecodeIdx: 14
/* 269 */     MCD::OPC_FilterValue, 18, 10, 0, // Skip to: 283
/* 273 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 275 */     MCD::OPC_CheckFieldOrFail, 27, 5, 30, 
/* 279 */     MCD::OPC_Decode, 213, 15, 19, // Opcode: LwRxSpImmX16, DecodeIdx: 19
/* 283 */     MCD::OPC_FilterValue, 22, 14, 0, // Skip to: 301
/* 287 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 289 */     MCD::OPC_CheckFieldOrFail, 27, 5, 30, 
/* 293 */     MCD::OPC_CheckFieldOrFail, 5, 3, 0, 
/* 297 */     MCD::OPC_Decode, 211, 15, 20, // Opcode: LwRxPcTcpX16, DecodeIdx: 20
/* 301 */     MCD::OPC_FilterValue, 24, 10, 0, // Skip to: 315
/* 305 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 307 */     MCD::OPC_CheckFieldOrFail, 27, 5, 30, 
/* 311 */     MCD::OPC_Decode, 242, 21, 19, // Opcode: SbRxRyOffMemX16, DecodeIdx: 19
/* 315 */     MCD::OPC_FilterValue, 25, 10, 0, // Skip to: 329
/* 319 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 321 */     MCD::OPC_CheckFieldOrFail, 27, 5, 30, 
/* 325 */     MCD::OPC_Decode, 245, 21, 19, // Opcode: ShRxRyOffMemX16, DecodeIdx: 19
/* 329 */     MCD::OPC_FilterValue, 26, 10, 0, // Skip to: 343
/* 333 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 335 */     MCD::OPC_CheckFieldOrFail, 27, 5, 30, 
/* 339 */     MCD::OPC_Decode, 132, 22, 19, // Opcode: SwRxSpImmX16, DecodeIdx: 19
/* 343 */     MCD::OPC_FilterValueOrFail, 27, 
/* 345 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 347 */     MCD::OPC_CheckFieldOrFail, 27, 5, 30, 
/* 351 */     MCD::OPC_Decode, 131, 22, 19, // Opcode: SwRxRyOffMemX16, DecodeIdx: 19
/* 355 */     MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableCOP3_32[] = {
/* 0 */       MCD::OPC_ExtractField, 26, 6,  // Inst{31-26} ...
/* 3 */       MCD::OPC_FilterValue, 51, 6, 0, // Skip to: 13
/* 7 */       MCD::OPC_CheckPredicateOrFail, 1, 
/* 9 */       MCD::OPC_Decode, 170, 15, 21, // Opcode: LWC3, DecodeIdx: 21
/* 13 */      MCD::OPC_FilterValue, 55, 6, 0, // Skip to: 23
/* 17 */      MCD::OPC_CheckPredicateOrFail, 2, 
/* 19 */      MCD::OPC_Decode, 238, 14, 21, // Opcode: LDC3, DecodeIdx: 21
/* 23 */      MCD::OPC_FilterValue, 59, 6, 0, // Skip to: 33
/* 27 */      MCD::OPC_CheckPredicateOrFail, 1, 
/* 29 */      MCD::OPC_Decode, 207, 21, 21, // Opcode: SWC3, DecodeIdx: 21
/* 33 */      MCD::OPC_FilterValueOrFail, 63, 
/* 35 */      MCD::OPC_CheckPredicateOrFail, 2, 
/* 37 */      MCD::OPC_Decode, 203, 19, 21, // Opcode: SDC3, DecodeIdx: 21
/* 41 */      MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableCnMips32[] = {
/* 0 */       MCD::OPC_ExtractField, 26, 6,  // Inst{31-26} ...
/* 3 */       MCD::OPC_FilterValue, 18, 21, 0, // Skip to: 28
/* 7 */       MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 10 */      MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 20
/* 14 */      MCD::OPC_CheckPredicateOrFail, 3, 
/* 16 */      MCD::OPC_Decode, 192, 11, 22, // Opcode: DMFC2_OCTEON, DecodeIdx: 22
/* 20 */      MCD::OPC_FilterValueOrFail, 5, 
/* 22 */      MCD::OPC_CheckPredicateOrFail, 3, 
/* 24 */      MCD::OPC_Decode, 200, 11, 22, // Opcode: DMTC2_OCTEON, DecodeIdx: 22
/* 28 */      MCD::OPC_FilterValue, 28, 23, 1, // Skip to: 311
/* 32 */      MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 35 */      MCD::OPC_FilterValue, 3, 10, 0, // Skip to: 49
/* 39 */      MCD::OPC_CheckPredicateOrFail, 3, 
/* 41 */      MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 45 */      MCD::OPC_Decode, 204, 11, 23, // Opcode: DMUL, DecodeIdx: 23
/* 49 */      MCD::OPC_FilterValue, 8, 10, 0, // Skip to: 63
/* 53 */      MCD::OPC_CheckPredicateOrFail, 3, 
/* 55 */      MCD::OPC_CheckFieldOrFail, 6, 15, 0, 
/* 59 */      MCD::OPC_Decode, 193, 17, 24, // Opcode: MTM0, DecodeIdx: 24
/* 63 */      MCD::OPC_FilterValue, 9, 10, 0, // Skip to: 77
/* 67 */      MCD::OPC_CheckPredicateOrFail, 3, 
/* 69 */      MCD::OPC_CheckFieldOrFail, 6, 15, 0, 
/* 73 */      MCD::OPC_Decode, 196, 17, 24, // Opcode: MTP0, DecodeIdx: 24
/* 77 */      MCD::OPC_FilterValue, 10, 10, 0, // Skip to: 91
/* 81 */      MCD::OPC_CheckPredicateOrFail, 3, 
/* 83 */      MCD::OPC_CheckFieldOrFail, 6, 15, 0, 
/* 87 */      MCD::OPC_Decode, 197, 17, 24, // Opcode: MTP1, DecodeIdx: 24
/* 91 */      MCD::OPC_FilterValue, 11, 10, 0, // Skip to: 105
/* 95 */      MCD::OPC_CheckPredicateOrFail, 3, 
/* 97 */      MCD::OPC_CheckFieldOrFail, 6, 15, 0, 
/* 101 */     MCD::OPC_Decode, 198, 17, 24, // Opcode: MTP2, DecodeIdx: 24
/* 105 */     MCD::OPC_FilterValue, 12, 10, 0, // Skip to: 119
/* 109 */     MCD::OPC_CheckPredicateOrFail, 3, 
/* 111 */     MCD::OPC_CheckFieldOrFail, 6, 15, 0, 
/* 115 */     MCD::OPC_Decode, 194, 17, 24, // Opcode: MTM1, DecodeIdx: 24
/* 119 */     MCD::OPC_FilterValue, 13, 10, 0, // Skip to: 133
/* 123 */     MCD::OPC_CheckPredicateOrFail, 3, 
/* 125 */     MCD::OPC_CheckFieldOrFail, 6, 15, 0, 
/* 129 */     MCD::OPC_Decode, 195, 17, 24, // Opcode: MTM2, DecodeIdx: 24
/* 133 */     MCD::OPC_FilterValue, 15, 10, 0, // Skip to: 147
/* 137 */     MCD::OPC_CheckPredicateOrFail, 3, 
/* 139 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 143 */     MCD::OPC_Decode, 196, 22, 23, // Opcode: VMULU, DecodeIdx: 23
/* 147 */     MCD::OPC_FilterValue, 16, 10, 0, // Skip to: 161
/* 151 */     MCD::OPC_CheckPredicateOrFail, 3, 
/* 153 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 157 */     MCD::OPC_Decode, 195, 22, 23, // Opcode: VMM0, DecodeIdx: 23
/* 161 */     MCD::OPC_FilterValue, 17, 10, 0, // Skip to: 175
/* 165 */     MCD::OPC_CheckPredicateOrFail, 3, 
/* 167 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 171 */     MCD::OPC_Decode, 194, 22, 23, // Opcode: V3MULU, DecodeIdx: 23
/* 175 */     MCD::OPC_FilterValue, 40, 10, 0, // Skip to: 189
/* 179 */     MCD::OPC_CheckPredicateOrFail, 3, 
/* 181 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 185 */     MCD::OPC_Decode, 143, 7, 23, // Opcode: BADDu, DecodeIdx: 23
/* 189 */     MCD::OPC_FilterValue, 42, 10, 0, // Skip to: 203
/* 193 */     MCD::OPC_CheckPredicateOrFail, 3, 
/* 195 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 199 */     MCD::OPC_Decode, 234, 19, 23, // Opcode: SEQ, DecodeIdx: 23
/* 203 */     MCD::OPC_FilterValue, 43, 10, 0, // Skip to: 217
/* 207 */     MCD::OPC_CheckPredicateOrFail, 3, 
/* 209 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 213 */     MCD::OPC_Decode, 206, 20, 23, // Opcode: SNE, DecodeIdx: 23
/* 217 */     MCD::OPC_FilterValue, 44, 14, 0, // Skip to: 235
/* 221 */     MCD::OPC_CheckPredicateOrFail, 3, 
/* 223 */     MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 227 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 231 */     MCD::OPC_Decode, 192, 18, 25, // Opcode: POP, DecodeIdx: 25
/* 235 */     MCD::OPC_FilterValue, 45, 14, 0, // Skip to: 253
/* 239 */     MCD::OPC_CheckPredicateOrFail, 3, 
/* 241 */     MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 245 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 249 */     MCD::OPC_Decode, 237, 11, 26, // Opcode: DPOP, DecodeIdx: 26
/* 253 */     MCD::OPC_FilterValue, 46, 6, 0, // Skip to: 263
/* 257 */     MCD::OPC_CheckPredicateOrFail, 3, 
/* 259 */     MCD::OPC_Decode, 235, 19, 27, // Opcode: SEQi, DecodeIdx: 27
/* 263 */     MCD::OPC_FilterValue, 47, 6, 0, // Skip to: 273
/* 267 */     MCD::OPC_CheckPredicateOrFail, 3, 
/* 269 */     MCD::OPC_Decode, 207, 20, 27, // Opcode: SNEi, DecodeIdx: 27
/* 273 */     MCD::OPC_FilterValue, 50, 6, 0, // Skip to: 283
/* 277 */     MCD::OPC_CheckPredicateOrFail, 4, 
/* 279 */     MCD::OPC_Decode, 240, 8, 28, // Opcode: CINS, DecodeIdx: 28
/* 283 */     MCD::OPC_FilterValue, 51, 6, 0, // Skip to: 293
/* 287 */     MCD::OPC_CheckPredicateOrFail, 4, 
/* 289 */     MCD::OPC_Decode, 241, 8, 28, // Opcode: CINS32, DecodeIdx: 28
/* 293 */     MCD::OPC_FilterValue, 58, 6, 0, // Skip to: 303
/* 297 */     MCD::OPC_CheckPredicateOrFail, 4, 
/* 299 */     MCD::OPC_Decode, 196, 12, 28, // Opcode: EXTS, DecodeIdx: 28
/* 303 */     MCD::OPC_FilterValueOrFail, 59, 
/* 305 */     MCD::OPC_CheckPredicateOrFail, 4, 
/* 307 */     MCD::OPC_Decode, 197, 12, 28, // Opcode: EXTS32, DecodeIdx: 28
/* 311 */     MCD::OPC_FilterValue, 50, 6, 0, // Skip to: 321
/* 315 */     MCD::OPC_CheckPredicateOrFail, 3, 
/* 317 */     MCD::OPC_Decode, 149, 7, 29, // Opcode: BBIT0, DecodeIdx: 29
/* 321 */     MCD::OPC_FilterValue, 54, 6, 0, // Skip to: 331
/* 325 */     MCD::OPC_CheckPredicateOrFail, 3, 
/* 327 */     MCD::OPC_Decode, 150, 7, 29, // Opcode: BBIT032, DecodeIdx: 29
/* 331 */     MCD::OPC_FilterValue, 58, 6, 0, // Skip to: 341
/* 335 */     MCD::OPC_CheckPredicateOrFail, 3, 
/* 337 */     MCD::OPC_Decode, 151, 7, 29, // Opcode: BBIT1, DecodeIdx: 29
/* 341 */     MCD::OPC_FilterValueOrFail, 62, 
/* 343 */     MCD::OPC_CheckPredicateOrFail, 3, 
/* 345 */     MCD::OPC_Decode, 152, 7, 29, // Opcode: BBIT132, DecodeIdx: 29
/* 349 */     MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableCnMipsP32[] = {
/* 0 */       MCD::OPC_ExtractField, 0, 16,  // Inst{15-0} ...
/* 3 */       MCD::OPC_FilterValue, 24, 10, 0, // Skip to: 17
/* 7 */       MCD::OPC_CheckPredicateOrFail, 5, 
/* 9 */       MCD::OPC_CheckFieldOrFail, 26, 6, 28, 
/* 13 */      MCD::OPC_Decode, 160, 19, 30, // Opcode: SAA, DecodeIdx: 30
/* 17 */      MCD::OPC_FilterValueOrFail, 25, 
/* 19 */      MCD::OPC_CheckPredicateOrFail, 5, 
/* 21 */      MCD::OPC_CheckFieldOrFail, 26, 6, 28, 
/* 25 */      MCD::OPC_Decode, 161, 19, 30, // Opcode: SAAD, DecodeIdx: 30
/* 29 */      MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableMicroMips16[] = {
/* 0 */       MCD::OPC_ExtractField, 10, 6,  // Inst{15-10} ...
/* 3 */       MCD::OPC_FilterValue, 1, 21, 0, // Skip to: 28
/* 7 */       MCD::OPC_ExtractField, 0, 1,  // Inst{0} ...
/* 10 */      MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 20
/* 14 */      MCD::OPC_CheckPredicateOrFail, 6, 
/* 16 */      MCD::OPC_Decode, 176, 6, 31, // Opcode: ADDU16_MM, DecodeIdx: 31
/* 20 */      MCD::OPC_FilterValueOrFail, 1, 
/* 22 */      MCD::OPC_CheckPredicateOrFail, 6, 
/* 24 */      MCD::OPC_Decode, 168, 21, 31, // Opcode: SUBU16_MM, DecodeIdx: 31
/* 28 */      MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 38
/* 32 */      MCD::OPC_CheckPredicateOrFail, 7, 
/* 34 */      MCD::OPC_Decode, 218, 14, 32, // Opcode: LBU16_MM, DecodeIdx: 32
/* 38 */      MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 48
/* 42 */      MCD::OPC_CheckPredicateOrFail, 6, 
/* 44 */      MCD::OPC_Decode, 220, 16, 33, // Opcode: MOVE16_MM, DecodeIdx: 33
/* 48 */      MCD::OPC_FilterValue, 9, 21, 0, // Skip to: 73
/* 52 */      MCD::OPC_ExtractField, 0, 1,  // Inst{0} ...
/* 55 */      MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 65
/* 59 */      MCD::OPC_CheckPredicateOrFail, 6, 
/* 61 */      MCD::OPC_Decode, 178, 20, 34, // Opcode: SLL16_MM, DecodeIdx: 34
/* 65 */      MCD::OPC_FilterValueOrFail, 1, 
/* 67 */      MCD::OPC_CheckPredicateOrFail, 6, 
/* 69 */      MCD::OPC_Decode, 237, 20, 34, // Opcode: SRL16_MM, DecodeIdx: 34
/* 73 */      MCD::OPC_FilterValue, 10, 6, 0, // Skip to: 83
/* 77 */      MCD::OPC_CheckPredicateOrFail, 7, 
/* 79 */      MCD::OPC_Decode, 131, 15, 32, // Opcode: LHU16_MM, DecodeIdx: 32
/* 83 */      MCD::OPC_FilterValue, 11, 6, 0, // Skip to: 93
/* 87 */      MCD::OPC_CheckPredicateOrFail, 6, 
/* 89 */      MCD::OPC_Decode, 221, 6, 35, // Opcode: ANDI16_MM, DecodeIdx: 35
/* 93 */      MCD::OPC_FilterValue, 17, 181, 0, // Skip to: 278
/* 97 */      MCD::OPC_ExtractField, 6, 4,  // Inst{9-6} ...
/* 100 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 110
/* 104 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 106 */     MCD::OPC_Decode, 152, 18, 36, // Opcode: NOT16_MM, DecodeIdx: 36
/* 110 */     MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 120
/* 114 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 116 */     MCD::OPC_Decode, 211, 22, 37, // Opcode: XOR16_MM, DecodeIdx: 37
/* 120 */     MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 130
/* 124 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 126 */     MCD::OPC_Decode, 218, 6, 37, // Opcode: AND16_MM, DecodeIdx: 37
/* 130 */     MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 140
/* 134 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 136 */     MCD::OPC_Decode, 157, 18, 37, // Opcode: OR16_MM, DecodeIdx: 37
/* 140 */     MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 150
/* 144 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 146 */     MCD::OPC_Decode, 181, 15, 38, // Opcode: LWM16_MM, DecodeIdx: 38
/* 150 */     MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 160
/* 154 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 156 */     MCD::OPC_Decode, 217, 21, 38, // Opcode: SWM16_MM, DecodeIdx: 38
/* 160 */     MCD::OPC_FilterValue, 6, 21, 0, // Skip to: 185
/* 164 */     MCD::OPC_ExtractField, 5, 1,  // Inst{5} ...
/* 167 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 177
/* 171 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 173 */     MCD::OPC_Decode, 196, 14, 39, // Opcode: JR16_MM, DecodeIdx: 39
/* 177 */     MCD::OPC_FilterValueOrFail, 1, 
/* 179 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 181 */     MCD::OPC_Decode, 199, 14, 39, // Opcode: JRC16_MM, DecodeIdx: 39
/* 185 */     MCD::OPC_FilterValue, 7, 21, 0, // Skip to: 210
/* 189 */     MCD::OPC_ExtractField, 5, 1,  // Inst{5} ...
/* 192 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 202
/* 196 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 198 */     MCD::OPC_Decode, 175, 14, 39, // Opcode: JALR16_MM, DecodeIdx: 39
/* 202 */     MCD::OPC_FilterValueOrFail, 1, 
/* 204 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 206 */     MCD::OPC_Decode, 180, 14, 39, // Opcode: JALRS16_MM, DecodeIdx: 39
/* 210 */     MCD::OPC_FilterValue, 8, 10, 0, // Skip to: 224
/* 214 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 216 */     MCD::OPC_CheckFieldOrFail, 5, 1, 0, 
/* 220 */     MCD::OPC_Decode, 166, 16, 39, // Opcode: MFHI16_MM, DecodeIdx: 39
/* 224 */     MCD::OPC_FilterValue, 9, 10, 0, // Skip to: 238
/* 228 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 230 */     MCD::OPC_CheckFieldOrFail, 5, 1, 0, 
/* 234 */     MCD::OPC_Decode, 172, 16, 39, // Opcode: MFLO16_MM, DecodeIdx: 39
/* 238 */     MCD::OPC_FilterValue, 10, 10, 0, // Skip to: 252
/* 242 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 244 */     MCD::OPC_CheckFieldOrFail, 4, 2, 0, 
/* 248 */     MCD::OPC_Decode, 181, 8, 40, // Opcode: BREAK16_MM, DecodeIdx: 40
/* 252 */     MCD::OPC_FilterValue, 11, 10, 0, // Skip to: 266
/* 256 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 258 */     MCD::OPC_CheckFieldOrFail, 4, 2, 0, 
/* 262 */     MCD::OPC_Decode, 190, 19, 40, // Opcode: SDBBP16_MM, DecodeIdx: 40
/* 266 */     MCD::OPC_FilterValueOrFail, 12, 
/* 268 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 270 */     MCD::OPC_CheckFieldOrFail, 5, 1, 0, 
/* 274 */     MCD::OPC_Decode, 198, 14, 41, // Opcode: JRADDIUSP, DecodeIdx: 41
/* 278 */     MCD::OPC_FilterValue, 18, 6, 0, // Skip to: 288
/* 282 */     MCD::OPC_CheckPredicateOrFail, 7, 
/* 284 */     MCD::OPC_Decode, 192, 15, 42, // Opcode: LWSP_MM, DecodeIdx: 42
/* 288 */     MCD::OPC_FilterValue, 19, 21, 0, // Skip to: 313
/* 292 */     MCD::OPC_ExtractField, 0, 1,  // Inst{0} ...
/* 295 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 305
/* 299 */     MCD::OPC_CheckPredicateOrFail, 7, 
/* 301 */     MCD::OPC_Decode, 144, 6, 43, // Opcode: ADDIUS5_MM, DecodeIdx: 43
/* 305 */     MCD::OPC_FilterValueOrFail, 1, 
/* 307 */     MCD::OPC_CheckPredicateOrFail, 7, 
/* 309 */     MCD::OPC_Decode, 145, 6, 44, // Opcode: ADDIUSP_MM, DecodeIdx: 44
/* 313 */     MCD::OPC_FilterValue, 25, 6, 0, // Skip to: 323
/* 317 */     MCD::OPC_CheckPredicateOrFail, 7, 
/* 319 */     MCD::OPC_Decode, 175, 15, 45, // Opcode: LWGP_MM, DecodeIdx: 45
/* 323 */     MCD::OPC_FilterValue, 26, 6, 0, // Skip to: 333
/* 327 */     MCD::OPC_CheckPredicateOrFail, 7, 
/* 329 */     MCD::OPC_Decode, 163, 15, 32, // Opcode: LW16_MM, DecodeIdx: 32
/* 333 */     MCD::OPC_FilterValue, 27, 21, 0, // Skip to: 358
/* 337 */     MCD::OPC_ExtractField, 0, 1,  // Inst{0} ...
/* 340 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 350
/* 344 */     MCD::OPC_CheckPredicateOrFail, 7, 
/* 346 */     MCD::OPC_Decode, 143, 6, 46, // Opcode: ADDIUR2_MM, DecodeIdx: 46
/* 350 */     MCD::OPC_FilterValueOrFail, 1, 
/* 352 */     MCD::OPC_CheckPredicateOrFail, 7, 
/* 354 */     MCD::OPC_Decode, 142, 6, 47, // Opcode: ADDIUR1SP_MM, DecodeIdx: 47
/* 358 */     MCD::OPC_FilterValue, 33, 10, 0, // Skip to: 372
/* 362 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 364 */     MCD::OPC_CheckFieldOrFail, 0, 1, 0, 
/* 368 */     MCD::OPC_Decode, 222, 16, 48, // Opcode: MOVEP_MM, DecodeIdx: 48
/* 372 */     MCD::OPC_FilterValue, 34, 6, 0, // Skip to: 382
/* 376 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 378 */     MCD::OPC_Decode, 171, 19, 32, // Opcode: SB16_MM, DecodeIdx: 32
/* 382 */     MCD::OPC_FilterValue, 35, 6, 0, // Skip to: 392
/* 386 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 388 */     MCD::OPC_Decode, 184, 7, 49, // Opcode: BEQZ16_MM, DecodeIdx: 49
/* 392 */     MCD::OPC_FilterValue, 42, 6, 0, // Skip to: 402
/* 396 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 398 */     MCD::OPC_Decode, 237, 19, 32, // Opcode: SH16_MM, DecodeIdx: 32
/* 402 */     MCD::OPC_FilterValue, 43, 6, 0, // Skip to: 412
/* 406 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 408 */     MCD::OPC_Decode, 159, 8, 49, // Opcode: BNEZ16_MM, DecodeIdx: 49
/* 412 */     MCD::OPC_FilterValue, 50, 6, 0, // Skip to: 422
/* 416 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 418 */     MCD::OPC_Decode, 226, 21, 42, // Opcode: SWSP_MM, DecodeIdx: 42
/* 422 */     MCD::OPC_FilterValue, 51, 6, 0, // Skip to: 432
/* 426 */     MCD::OPC_CheckPredicateOrFail, 7, 
/* 428 */     MCD::OPC_Decode, 142, 7, 50, // Opcode: B16_MM, DecodeIdx: 50
/* 432 */     MCD::OPC_FilterValue, 58, 6, 0, // Skip to: 442
/* 436 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 438 */     MCD::OPC_Decode, 199, 21, 32, // Opcode: SW16_MM, DecodeIdx: 32
/* 442 */     MCD::OPC_FilterValueOrFail, 59, 
/* 444 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 446 */     MCD::OPC_Decode, 140, 15, 51, // Opcode: LI16_MM, DecodeIdx: 51
/* 450 */     MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableMicroMips32[] = {
/* 0 */       MCD::OPC_ExtractField, 26, 6,  // Inst{31-26} ...
/* 3 */       MCD::OPC_FilterValue, 0, 118, 10, // Skip to: 2685
/* 7 */       MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 10 */      MCD::OPC_FilterValue, 0, 80, 0, // Skip to: 94
/* 14 */      MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 17 */      MCD::OPC_FilterValue, 0, 45, 0, // Skip to: 66
/* 21 */      MCD::OPC_ExtractField, 11, 15,  // Inst{25-11} ...
/* 24 */      MCD::OPC_FilterValue, 1, 8, 0, // Skip to: 36
/* 28 */      MCD::OPC_CheckPredicate, 7, 28, 0, // Skip to: 60
/* 32 */      MCD::OPC_Decode, 131, 21, 10, // Opcode: SSNOP_MM, DecodeIdx: 10
/* 36 */      MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 48
/* 40 */      MCD::OPC_CheckPredicate, 7, 16, 0, // Skip to: 60
/* 44 */      MCD::OPC_Decode, 157, 12, 10, // Opcode: EHB_MM, DecodeIdx: 10
/* 48 */      MCD::OPC_FilterValue, 5, 8, 0, // Skip to: 60
/* 52 */      MCD::OPC_CheckPredicate, 7, 4, 0, // Skip to: 60
/* 56 */      MCD::OPC_Decode, 172, 18, 10, // Opcode: PAUSE_MM, DecodeIdx: 10
/* 60 */      MCD::OPC_CheckPredicateOrFail, 7, 
/* 62 */      MCD::OPC_Decode, 191, 20, 52, // Opcode: SLL_MM, DecodeIdx: 52
/* 66 */      MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 76
/* 70 */      MCD::OPC_CheckPredicateOrFail, 7, 
/* 72 */      MCD::OPC_Decode, 128, 21, 52, // Opcode: SRL_MM, DecodeIdx: 52
/* 76 */      MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 86
/* 80 */      MCD::OPC_CheckPredicateOrFail, 7, 
/* 82 */      MCD::OPC_Decode, 234, 20, 52, // Opcode: SRA_MM, DecodeIdx: 52
/* 86 */      MCD::OPC_FilterValueOrFail, 3, 
/* 88 */      MCD::OPC_CheckPredicateOrFail, 7, 
/* 90 */      MCD::OPC_Decode, 140, 19, 52, // Opcode: ROTR_MM, DecodeIdx: 52
/* 94 */      MCD::OPC_FilterValue, 5, 155, 0, // Skip to: 253
/* 98 */      MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 101 */     MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 115
/* 105 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 107 */     MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 111 */     MCD::OPC_Decode, 183, 9, 53, // Opcode: CMP_EQ_PH_MM, DecodeIdx: 53
/* 115 */     MCD::OPC_FilterValue, 1, 10, 0, // Skip to: 129
/* 119 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 121 */     MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 125 */     MCD::OPC_Decode, 197, 9, 53, // Opcode: CMP_LT_PH_MM, DecodeIdx: 53
/* 129 */     MCD::OPC_FilterValue, 2, 10, 0, // Skip to: 143
/* 133 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 135 */     MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 139 */     MCD::OPC_Decode, 191, 9, 53, // Opcode: CMP_LE_PH_MM, DecodeIdx: 53
/* 143 */     MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 153
/* 147 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 149 */     MCD::OPC_Decode, 161, 9, 54, // Opcode: CMPGDU_EQ_QB_MMR2, DecodeIdx: 54
/* 153 */     MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 163
/* 157 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 159 */     MCD::OPC_Decode, 165, 9, 54, // Opcode: CMPGDU_LT_QB_MMR2, DecodeIdx: 54
/* 163 */     MCD::OPC_FilterValue, 8, 6, 0, // Skip to: 173
/* 167 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 169 */     MCD::OPC_Decode, 163, 9, 54, // Opcode: CMPGDU_LE_QB_MMR2, DecodeIdx: 54
/* 173 */     MCD::OPC_FilterValue, 9, 10, 0, // Skip to: 187
/* 177 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 179 */     MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 183 */     MCD::OPC_Decode, 173, 9, 53, // Opcode: CMPU_EQ_QB_MM, DecodeIdx: 53
/* 187 */     MCD::OPC_FilterValue, 10, 10, 0, // Skip to: 201
/* 191 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 193 */     MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 197 */     MCD::OPC_Decode, 177, 9, 53, // Opcode: CMPU_LT_QB_MM, DecodeIdx: 53
/* 201 */     MCD::OPC_FilterValue, 11, 10, 0, // Skip to: 215
/* 205 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 207 */     MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 211 */     MCD::OPC_Decode, 175, 9, 53, // Opcode: CMPU_LE_QB_MM, DecodeIdx: 53
/* 215 */     MCD::OPC_FilterValue, 12, 6, 0, // Skip to: 225
/* 219 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 221 */     MCD::OPC_Decode, 160, 6, 55, // Opcode: ADDQ_S_W_MM, DecodeIdx: 55
/* 225 */     MCD::OPC_FilterValue, 13, 6, 0, // Skip to: 235
/* 229 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 231 */     MCD::OPC_Decode, 151, 21, 55, // Opcode: SUBQ_S_W_MM, DecodeIdx: 55
/* 235 */     MCD::OPC_FilterValue, 14, 6, 0, // Skip to: 245
/* 239 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 241 */     MCD::OPC_Decode, 163, 6, 55, // Opcode: ADDSC_MM, DecodeIdx: 55
/* 245 */     MCD::OPC_FilterValueOrFail, 15, 
/* 247 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 249 */     MCD::OPC_Decode, 200, 6, 55, // Opcode: ADDWC_MM, DecodeIdx: 55
/* 253 */     MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 263
/* 257 */     MCD::OPC_CheckPredicateOrFail, 7, 
/* 259 */     MCD::OPC_Decode, 183, 8, 56, // Opcode: BREAK_MM, DecodeIdx: 56
/* 263 */     MCD::OPC_FilterValue, 12, 6, 0, // Skip to: 273
/* 267 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 269 */     MCD::OPC_Decode, 170, 14, 57, // Opcode: INS_MM, DecodeIdx: 57
/* 273 */     MCD::OPC_FilterValue, 13, 45, 1, // Skip to: 578
/* 277 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 280 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 290
/* 284 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 286 */     MCD::OPC_Decode, 156, 6, 58, // Opcode: ADDQ_PH_MM, DecodeIdx: 58
/* 290 */     MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 300
/* 294 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 296 */     MCD::OPC_Decode, 148, 6, 58, // Opcode: ADDQH_PH_MMR2, DecodeIdx: 58
/* 300 */     MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 310
/* 304 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 306 */     MCD::OPC_Decode, 154, 6, 55, // Opcode: ADDQH_W_MMR2, DecodeIdx: 55
/* 310 */     MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 320
/* 314 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 316 */     MCD::OPC_Decode, 186, 6, 58, // Opcode: ADDU_QB_MM, DecodeIdx: 58
/* 320 */     MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 330
/* 324 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 326 */     MCD::OPC_Decode, 184, 6, 58, // Opcode: ADDU_PH_MMR2, DecodeIdx: 58
/* 330 */     MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 340
/* 334 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 336 */     MCD::OPC_Decode, 179, 6, 58, // Opcode: ADDUH_QB_MMR2, DecodeIdx: 58
/* 340 */     MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 350
/* 344 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 346 */     MCD::OPC_Decode, 138, 20, 59, // Opcode: SHRAV_PH_MM, DecodeIdx: 59
/* 350 */     MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 360
/* 354 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 356 */     MCD::OPC_Decode, 140, 20, 59, // Opcode: SHRAV_QB_MMR2, DecodeIdx: 59
/* 360 */     MCD::OPC_FilterValue, 8, 6, 0, // Skip to: 370
/* 364 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 366 */     MCD::OPC_Decode, 147, 21, 58, // Opcode: SUBQ_PH_MM, DecodeIdx: 58
/* 370 */     MCD::OPC_FilterValue, 9, 6, 0, // Skip to: 380
/* 374 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 376 */     MCD::OPC_Decode, 139, 21, 58, // Opcode: SUBQH_PH_MMR2, DecodeIdx: 58
/* 380 */     MCD::OPC_FilterValue, 10, 6, 0, // Skip to: 390
/* 384 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 386 */     MCD::OPC_Decode, 145, 21, 55, // Opcode: SUBQH_W_MMR2, DecodeIdx: 55
/* 390 */     MCD::OPC_FilterValue, 11, 6, 0, // Skip to: 400
/* 394 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 396 */     MCD::OPC_Decode, 178, 21, 58, // Opcode: SUBU_QB_MM, DecodeIdx: 58
/* 400 */     MCD::OPC_FilterValue, 12, 6, 0, // Skip to: 410
/* 404 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 406 */     MCD::OPC_Decode, 176, 21, 58, // Opcode: SUBU_PH_MMR2, DecodeIdx: 58
/* 410 */     MCD::OPC_FilterValue, 13, 6, 0, // Skip to: 420
/* 414 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 416 */     MCD::OPC_Decode, 171, 21, 58, // Opcode: SUBUH_QB_MMR2, DecodeIdx: 58
/* 420 */     MCD::OPC_FilterValue, 15, 6, 0, // Skip to: 430
/* 424 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 426 */     MCD::OPC_Decode, 224, 18, 60, // Opcode: PRECR_SRA_PH_W_MMR2, DecodeIdx: 60
/* 430 */     MCD::OPC_FilterValue, 16, 6, 0, // Skip to: 440
/* 434 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 436 */     MCD::OPC_Decode, 158, 6, 58, // Opcode: ADDQ_S_PH_MM, DecodeIdx: 58
/* 440 */     MCD::OPC_FilterValue, 17, 6, 0, // Skip to: 450
/* 444 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 446 */     MCD::OPC_Decode, 150, 6, 58, // Opcode: ADDQH_R_PH_MMR2, DecodeIdx: 58
/* 450 */     MCD::OPC_FilterValue, 18, 6, 0, // Skip to: 460
/* 454 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 456 */     MCD::OPC_Decode, 152, 6, 55, // Opcode: ADDQH_R_W_MMR2, DecodeIdx: 55
/* 460 */     MCD::OPC_FilterValue, 19, 6, 0, // Skip to: 470
/* 464 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 466 */     MCD::OPC_Decode, 190, 6, 58, // Opcode: ADDU_S_QB_MM, DecodeIdx: 58
/* 470 */     MCD::OPC_FilterValue, 20, 6, 0, // Skip to: 480
/* 474 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 476 */     MCD::OPC_Decode, 188, 6, 58, // Opcode: ADDU_S_PH_MMR2, DecodeIdx: 58
/* 480 */     MCD::OPC_FilterValue, 21, 6, 0, // Skip to: 490
/* 484 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 486 */     MCD::OPC_Decode, 181, 6, 58, // Opcode: ADDUH_R_QB_MMR2, DecodeIdx: 58
/* 490 */     MCD::OPC_FilterValue, 22, 6, 0, // Skip to: 500
/* 494 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 496 */     MCD::OPC_Decode, 142, 20, 59, // Opcode: SHRAV_R_PH_MM, DecodeIdx: 59
/* 500 */     MCD::OPC_FilterValue, 23, 6, 0, // Skip to: 510
/* 504 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 506 */     MCD::OPC_Decode, 144, 20, 59, // Opcode: SHRAV_R_QB_MMR2, DecodeIdx: 59
/* 510 */     MCD::OPC_FilterValue, 24, 6, 0, // Skip to: 520
/* 514 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 516 */     MCD::OPC_Decode, 149, 21, 58, // Opcode: SUBQ_S_PH_MM, DecodeIdx: 58
/* 520 */     MCD::OPC_FilterValue, 25, 6, 0, // Skip to: 530
/* 524 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 526 */     MCD::OPC_Decode, 141, 21, 58, // Opcode: SUBQH_R_PH_MMR2, DecodeIdx: 58
/* 530 */     MCD::OPC_FilterValue, 26, 6, 0, // Skip to: 540
/* 534 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 536 */     MCD::OPC_Decode, 143, 21, 55, // Opcode: SUBQH_R_W_MMR2, DecodeIdx: 55
/* 540 */     MCD::OPC_FilterValue, 27, 6, 0, // Skip to: 550
/* 544 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 546 */     MCD::OPC_Decode, 182, 21, 58, // Opcode: SUBU_S_QB_MM, DecodeIdx: 58
/* 550 */     MCD::OPC_FilterValue, 28, 6, 0, // Skip to: 560
/* 554 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 556 */     MCD::OPC_Decode, 180, 21, 58, // Opcode: SUBU_S_PH_MMR2, DecodeIdx: 58
/* 560 */     MCD::OPC_FilterValue, 29, 6, 0, // Skip to: 570
/* 564 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 566 */     MCD::OPC_Decode, 173, 21, 58, // Opcode: SUBUH_R_QB_MMR2, DecodeIdx: 58
/* 570 */     MCD::OPC_FilterValueOrFail, 31, 
/* 572 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 574 */     MCD::OPC_Decode, 226, 18, 60, // Opcode: PRECR_SRA_R_PH_W_MMR2, DecodeIdx: 60
/* 578 */     MCD::OPC_FilterValue, 14, 21, 0, // Skip to: 603
/* 582 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 585 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 595
/* 589 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 591 */     MCD::OPC_Decode, 250, 19, 59, // Opcode: SHLLV_PH_MM, DecodeIdx: 59
/* 595 */     MCD::OPC_FilterValueOrFail, 16, 
/* 597 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 599 */     MCD::OPC_Decode, 254, 19, 59, // Opcode: SHLLV_S_PH_MM, DecodeIdx: 59
/* 603 */     MCD::OPC_FilterValue, 16, 151, 0, // Skip to: 758
/* 607 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 610 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 620
/* 614 */     MCD::OPC_CheckPredicateOrFail, 7, 
/* 616 */     MCD::OPC_Decode, 187, 20, 61, // Opcode: SLLV_MM, DecodeIdx: 61
/* 620 */     MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 630
/* 624 */     MCD::OPC_CheckPredicateOrFail, 7, 
/* 626 */     MCD::OPC_Decode, 252, 20, 61, // Opcode: SRLV_MM, DecodeIdx: 61
/* 630 */     MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 640
/* 634 */     MCD::OPC_CheckPredicateOrFail, 7, 
/* 636 */     MCD::OPC_Decode, 230, 20, 61, // Opcode: SRAV_MM, DecodeIdx: 61
/* 640 */     MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 650
/* 644 */     MCD::OPC_CheckPredicateOrFail, 7, 
/* 646 */     MCD::OPC_Decode, 139, 19, 61, // Opcode: ROTRV_MM, DecodeIdx: 61
/* 650 */     MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 660
/* 654 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 656 */     MCD::OPC_Decode, 205, 6, 55, // Opcode: ADD_MM, DecodeIdx: 55
/* 660 */     MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 670
/* 664 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 666 */     MCD::OPC_Decode, 212, 6, 55, // Opcode: ADDu_MM, DecodeIdx: 55
/* 670 */     MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 680
/* 674 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 676 */     MCD::OPC_Decode, 191, 21, 55, // Opcode: SUB_MM, DecodeIdx: 55
/* 680 */     MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 690
/* 684 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 686 */     MCD::OPC_Decode, 194, 21, 55, // Opcode: SUBu_MM, DecodeIdx: 55
/* 690 */     MCD::OPC_FilterValue, 8, 6, 0, // Skip to: 700
/* 694 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 696 */     MCD::OPC_Decode, 242, 17, 55, // Opcode: MUL_MM, DecodeIdx: 55
/* 700 */     MCD::OPC_FilterValue, 9, 6, 0, // Skip to: 710
/* 704 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 706 */     MCD::OPC_Decode, 225, 6, 55, // Opcode: AND_MM, DecodeIdx: 55
/* 710 */     MCD::OPC_FilterValue, 10, 6, 0, // Skip to: 720
/* 714 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 716 */     MCD::OPC_Decode, 162, 18, 55, // Opcode: OR_MM, DecodeIdx: 55
/* 720 */     MCD::OPC_FilterValue, 11, 6, 0, // Skip to: 730
/* 724 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 726 */     MCD::OPC_Decode, 149, 18, 55, // Opcode: NOR_MM, DecodeIdx: 55
/* 730 */     MCD::OPC_FilterValue, 12, 6, 0, // Skip to: 740
/* 734 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 736 */     MCD::OPC_Decode, 216, 22, 55, // Opcode: XOR_MM, DecodeIdx: 55
/* 740 */     MCD::OPC_FilterValue, 13, 6, 0, // Skip to: 750
/* 744 */     MCD::OPC_CheckPredicateOrFail, 7, 
/* 746 */     MCD::OPC_Decode, 196, 20, 55, // Opcode: SLT_MM, DecodeIdx: 55
/* 750 */     MCD::OPC_FilterValueOrFail, 14, 
/* 752 */     MCD::OPC_CheckPredicateOrFail, 7, 
/* 754 */     MCD::OPC_Decode, 205, 20, 55, // Opcode: SLTu_MM, DecodeIdx: 55
/* 758 */     MCD::OPC_FilterValue, 21, 141, 0, // Skip to: 903
/* 762 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 765 */     MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 775
/* 769 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 771 */     MCD::OPC_Decode, 210, 17, 58, // Opcode: MULEU_S_PH_QBL_MM, DecodeIdx: 58
/* 775 */     MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 785
/* 779 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 781 */     MCD::OPC_Decode, 212, 17, 58, // Opcode: MULEU_S_PH_QBR_MM, DecodeIdx: 58
/* 785 */     MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 795
/* 789 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 791 */     MCD::OPC_Decode, 214, 17, 58, // Opcode: MULQ_RS_PH_MM, DecodeIdx: 58
/* 795 */     MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 805
/* 799 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 801 */     MCD::OPC_Decode, 218, 17, 58, // Opcode: MULQ_S_PH_MMR2, DecodeIdx: 58
/* 805 */     MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 815
/* 809 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 811 */     MCD::OPC_Decode, 216, 17, 55, // Opcode: MULQ_RS_W_MMR2, DecodeIdx: 55
/* 815 */     MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 825
/* 819 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 821 */     MCD::OPC_Decode, 220, 17, 55, // Opcode: MULQ_S_W_MMR2, DecodeIdx: 55
/* 825 */     MCD::OPC_FilterValue, 8, 6, 0, // Skip to: 835
/* 829 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 831 */     MCD::OPC_Decode, 232, 6, 62, // Opcode: APPEND_MMR2, DecodeIdx: 62
/* 835 */     MCD::OPC_FilterValue, 9, 6, 0, // Skip to: 845
/* 839 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 841 */     MCD::OPC_Decode, 235, 18, 62, // Opcode: PREPEND_MMR2, DecodeIdx: 62
/* 845 */     MCD::OPC_FilterValue, 10, 6, 0, // Skip to: 855
/* 849 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 851 */     MCD::OPC_Decode, 208, 16, 55, // Opcode: MODSUB_MM, DecodeIdx: 55
/* 855 */     MCD::OPC_FilterValue, 11, 6, 0, // Skip to: 865
/* 859 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 861 */     MCD::OPC_Decode, 146, 20, 61, // Opcode: SHRAV_R_W_MM, DecodeIdx: 61
/* 865 */     MCD::OPC_FilterValue, 12, 6, 0, // Skip to: 875
/* 869 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 871 */     MCD::OPC_Decode, 158, 20, 59, // Opcode: SHRLV_PH_MMR2, DecodeIdx: 59
/* 875 */     MCD::OPC_FilterValue, 13, 6, 0, // Skip to: 885
/* 879 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 881 */     MCD::OPC_Decode, 160, 20, 59, // Opcode: SHRLV_QB_MM, DecodeIdx: 59
/* 885 */     MCD::OPC_FilterValue, 14, 6, 0, // Skip to: 895
/* 889 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 891 */     MCD::OPC_Decode, 252, 19, 59, // Opcode: SHLLV_QB_MM, DecodeIdx: 59
/* 895 */     MCD::OPC_FilterValueOrFail, 15, 
/* 897 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 899 */     MCD::OPC_Decode, 128, 20, 61, // Opcode: SHLLV_S_W_MM, DecodeIdx: 61
/* 903 */     MCD::OPC_FilterValue, 24, 31, 0, // Skip to: 938
/* 907 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 910 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 920
/* 914 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 916 */     MCD::OPC_Decode, 242, 16, 63, // Opcode: MOVN_I_MM, DecodeIdx: 63
/* 920 */     MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 930
/* 924 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 926 */     MCD::OPC_Decode, 134, 17, 63, // Opcode: MOVZ_I_MM, DecodeIdx: 63
/* 930 */     MCD::OPC_FilterValueOrFail, 4, 
/* 932 */     MCD::OPC_CheckPredicateOrFail, 7, 
/* 934 */     MCD::OPC_Decode, 198, 15, 64, // Opcode: LWXS_MM, DecodeIdx: 64
/* 938 */     MCD::OPC_FilterValue, 29, 14, 0, // Skip to: 956
/* 942 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 944 */     MCD::OPC_CheckFieldOrFail, 22, 4, 0, 
/* 948 */     MCD::OPC_CheckFieldOrFail, 6, 8, 0, 
/* 952 */     MCD::OPC_Decode, 248, 19, 65, // Opcode: SHILO_MM, DecodeIdx: 65
/* 956 */     MCD::OPC_FilterValue, 37, 51, 0, // Skip to: 1011
/* 960 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 963 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 973
/* 967 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 969 */     MCD::OPC_Decode, 206, 17, 54, // Opcode: MULEQ_S_W_PHL_MM, DecodeIdx: 54
/* 973 */     MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 983
/* 977 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 979 */     MCD::OPC_Decode, 208, 17, 54, // Opcode: MULEQ_S_W_PHR_MM, DecodeIdx: 54
/* 983 */     MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 993
/* 987 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 989 */     MCD::OPC_Decode, 133, 15, 64, // Opcode: LHX_MM, DecodeIdx: 64
/* 993 */     MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 1003
/* 997 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 999 */     MCD::OPC_Decode, 199, 15, 64, // Opcode: LWX_MM, DecodeIdx: 64
/* 1003 */    MCD::OPC_FilterValueOrFail, 8, 
/* 1005 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1007 */    MCD::OPC_Decode, 220, 14, 64, // Opcode: LBUX_MM, DecodeIdx: 64
/* 1011 */    MCD::OPC_FilterValue, 44, 6, 0, // Skip to: 1021
/* 1015 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 1017 */    MCD::OPC_Decode, 198, 12, 66, // Opcode: EXT_MM, DecodeIdx: 66
/* 1021 */    MCD::OPC_FilterValue, 45, 101, 0, // Skip to: 1126
/* 1025 */    MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 1028 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 1038
/* 1032 */    MCD::OPC_CheckPredicateOrFail, 9, 
/* 1034 */    MCD::OPC_Decode, 245, 17, 58, // Opcode: MUL_PH_MMR2, DecodeIdx: 58
/* 1038 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 1048
/* 1042 */    MCD::OPC_CheckPredicateOrFail, 9, 
/* 1044 */    MCD::OPC_Decode, 222, 18, 58, // Opcode: PRECR_QB_PH_MMR2, DecodeIdx: 58
/* 1048 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 1058
/* 1052 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1054 */    MCD::OPC_Decode, 218, 18, 58, // Opcode: PRECRQ_QB_PH_MM, DecodeIdx: 58
/* 1058 */    MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 1068
/* 1062 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1064 */    MCD::OPC_Decode, 216, 18, 67, // Opcode: PRECRQ_PH_W_MM, DecodeIdx: 67
/* 1068 */    MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 1078
/* 1072 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1074 */    MCD::OPC_Decode, 220, 18, 67, // Opcode: PRECRQ_RS_PH_W_MM, DecodeIdx: 67
/* 1078 */    MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 1088
/* 1082 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1084 */    MCD::OPC_Decode, 214, 18, 58, // Opcode: PRECRQU_S_QB_PH_MM, DecodeIdx: 58
/* 1088 */    MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 1098
/* 1092 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1094 */    MCD::OPC_Decode, 170, 18, 58, // Opcode: PACKRL_PH_MM, DecodeIdx: 58
/* 1098 */    MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 1108
/* 1102 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1104 */    MCD::OPC_Decode, 189, 18, 58, // Opcode: PICK_QB_MM, DecodeIdx: 58
/* 1108 */    MCD::OPC_FilterValue, 8, 6, 0, // Skip to: 1118
/* 1112 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1114 */    MCD::OPC_Decode, 187, 18, 58, // Opcode: PICK_PH_MM, DecodeIdx: 58
/* 1118 */    MCD::OPC_FilterValueOrFail, 16, 
/* 1120 */    MCD::OPC_CheckPredicateOrFail, 9, 
/* 1122 */    MCD::OPC_Decode, 250, 17, 58, // Opcode: MUL_S_PH_MMR2, DecodeIdx: 58
/* 1126 */    MCD::OPC_FilterValue, 52, 29, 0, // Skip to: 1159
/* 1130 */    MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 1133 */    MCD::OPC_FilterValue, 19, 10, 0, // Skip to: 1147
/* 1137 */    MCD::OPC_CheckPredicateOrFail, 10, 
/* 1139 */    MCD::OPC_CheckFieldOrFail, 14, 2, 0, 
/* 1143 */    MCD::OPC_Decode, 164, 16, 68, // Opcode: MFHGC0_MM, DecodeIdx: 68
/* 1147 */    MCD::OPC_FilterValueOrFail, 27, 
/* 1149 */    MCD::OPC_CheckPredicateOrFail, 10, 
/* 1151 */    MCD::OPC_CheckFieldOrFail, 14, 2, 0, 
/* 1155 */    MCD::OPC_Decode, 180, 17, 69, // Opcode: MTHGC0_MM, DecodeIdx: 69
/* 1159 */    MCD::OPC_FilterValue, 53, 74, 0, // Skip to: 1237
/* 1163 */    MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 1166 */    MCD::OPC_FilterValue, 11, 6, 0, // Skip to: 1176
/* 1170 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1172 */    MCD::OPC_Decode, 156, 20, 52, // Opcode: SHRA_R_W_MM, DecodeIdx: 52
/* 1176 */    MCD::OPC_FilterValue, 12, 10, 0, // Skip to: 1190
/* 1180 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1182 */    MCD::OPC_CheckFieldOrFail, 11, 1, 0, 
/* 1186 */    MCD::OPC_Decode, 148, 20, 70, // Opcode: SHRA_PH_MM, DecodeIdx: 70
/* 1190 */    MCD::OPC_FilterValue, 14, 21, 0, // Skip to: 1215
/* 1194 */    MCD::OPC_ExtractField, 11, 1,  // Inst{11} ...
/* 1197 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 1207
/* 1201 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1203 */    MCD::OPC_Decode, 130, 20, 70, // Opcode: SHLL_PH_MM, DecodeIdx: 70
/* 1207 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1209 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1211 */    MCD::OPC_Decode, 134, 20, 70, // Opcode: SHLL_S_PH_MM, DecodeIdx: 70
/* 1215 */    MCD::OPC_FilterValue, 15, 6, 0, // Skip to: 1225
/* 1219 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1221 */    MCD::OPC_Decode, 136, 20, 52, // Opcode: SHLL_S_W_MM, DecodeIdx: 52
/* 1225 */    MCD::OPC_FilterValueOrFail, 28, 
/* 1227 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1229 */    MCD::OPC_CheckFieldOrFail, 11, 1, 0, 
/* 1233 */    MCD::OPC_Decode, 152, 20, 70, // Opcode: SHRA_R_PH_MM, DecodeIdx: 70
/* 1237 */    MCD::OPC_FilterValue, 60, 152, 5, // Skip to: 2673
/* 1241 */    MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 1244 */    MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 1269
/* 1248 */    MCD::OPC_ExtractField, 11, 1,  // Inst{11} ...
/* 1251 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 1261
/* 1255 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 1257 */    MCD::OPC_Decode, 136, 22, 71, // Opcode: TEQ_MM, DecodeIdx: 71
/* 1261 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1263 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 1265 */    MCD::OPC_Decode, 175, 22, 71, // Opcode: TLT_MM, DecodeIdx: 71
/* 1269 */    MCD::OPC_FilterValue, 1, 87, 0, // Skip to: 1360
/* 1273 */    MCD::OPC_ExtractField, 11, 2,  // Inst{12-11} ...
/* 1276 */    MCD::OPC_FilterValue, 0, 29, 0, // Skip to: 1309
/* 1280 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1283 */    MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 1297
/* 1287 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1289 */    MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 1293 */    MCD::OPC_Decode, 169, 16, 72, // Opcode: MFHI_DSP_MM, DecodeIdx: 72
/* 1297 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1299 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1301 */    MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 1305 */    MCD::OPC_Decode, 184, 17, 73, // Opcode: MTHI_DSP_MM, DecodeIdx: 73
/* 1309 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 1319
/* 1313 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1315 */    MCD::OPC_Decode, 132, 20, 74, // Opcode: SHLL_QB_MM, DecodeIdx: 74
/* 1319 */    MCD::OPC_FilterValue, 2, 29, 0, // Skip to: 1352
/* 1323 */    MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 1326 */    MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 1340
/* 1330 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1332 */    MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 1336 */    MCD::OPC_Decode, 175, 16, 72, // Opcode: MFLO_DSP_MM, DecodeIdx: 72
/* 1340 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1342 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1344 */    MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 1348 */    MCD::OPC_Decode, 191, 17, 75, // Opcode: MTLO_DSP_MM, DecodeIdx: 75
/* 1352 */    MCD::OPC_FilterValueOrFail, 3, 
/* 1354 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1356 */    MCD::OPC_Decode, 164, 20, 74, // Opcode: SHRL_QB_MM, DecodeIdx: 74
/* 1360 */    MCD::OPC_FilterValue, 2, 71, 0, // Skip to: 1435
/* 1364 */    MCD::OPC_ExtractField, 11, 3,  // Inst{13-11} ...
/* 1367 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 1377
/* 1371 */    MCD::OPC_CheckPredicateOrFail, 9, 
/* 1373 */    MCD::OPC_Decode, 236, 11, 76, // Opcode: DPA_W_PH_MMR2, DecodeIdx: 76
/* 1377 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 1387
/* 1381 */    MCD::OPC_CheckPredicateOrFail, 9, 
/* 1383 */    MCD::OPC_Decode, 148, 7, 77, // Opcode: BALIGN_MMR2, DecodeIdx: 77
/* 1387 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 1397
/* 1391 */    MCD::OPC_CheckPredicateOrFail, 9, 
/* 1393 */    MCD::OPC_Decode, 234, 11, 76, // Opcode: DPAX_W_PH_MMR2, DecodeIdx: 76
/* 1397 */    MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 1407
/* 1401 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1403 */    MCD::OPC_Decode, 230, 11, 76, // Opcode: DPAU_H_QBL_MM, DecodeIdx: 76
/* 1407 */    MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 1417
/* 1411 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1413 */    MCD::OPC_Decode, 178, 12, 78, // Opcode: EXTPV_MM, DecodeIdx: 78
/* 1417 */    MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 1427
/* 1421 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1423 */    MCD::OPC_Decode, 232, 11, 76, // Opcode: DPAU_H_QBR_MM, DecodeIdx: 76
/* 1427 */    MCD::OPC_FilterValueOrFail, 7, 
/* 1429 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1431 */    MCD::OPC_Decode, 175, 12, 78, // Opcode: EXTPDPV_MM, DecodeIdx: 78
/* 1435 */    MCD::OPC_FilterValue, 4, 121, 0, // Skip to: 1560
/* 1439 */    MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 1442 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 1452
/* 1446 */    MCD::OPC_CheckPredicateOrFail, 9, 
/* 1448 */    MCD::OPC_Decode, 135, 6, 79, // Opcode: ABSQ_S_QB_MMR2, DecodeIdx: 79
/* 1452 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 1462
/* 1456 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1458 */    MCD::OPC_Decode, 133, 6, 79, // Opcode: ABSQ_S_PH_MM, DecodeIdx: 79
/* 1462 */    MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 1472
/* 1466 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1468 */    MCD::OPC_Decode, 137, 6, 80, // Opcode: ABSQ_S_W_MM, DecodeIdx: 80
/* 1472 */    MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 1482
/* 1476 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1478 */    MCD::OPC_Decode, 238, 7, 80, // Opcode: BITREV_MM, DecodeIdx: 80
/* 1482 */    MCD::OPC_FilterValue, 8, 6, 0, // Skip to: 1492
/* 1486 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1488 */    MCD::OPC_Decode, 169, 14, 81, // Opcode: INSV_MM, DecodeIdx: 81
/* 1492 */    MCD::OPC_FilterValue, 10, 6, 0, // Skip to: 1502
/* 1496 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1498 */    MCD::OPC_Decode, 202, 18, 82, // Opcode: PRECEQ_W_PHL_MM, DecodeIdx: 82
/* 1502 */    MCD::OPC_FilterValue, 12, 6, 0, // Skip to: 1512
/* 1506 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1508 */    MCD::OPC_Decode, 204, 18, 82, // Opcode: PRECEQ_W_PHR_MM, DecodeIdx: 82
/* 1512 */    MCD::OPC_FilterValue, 14, 6, 0, // Skip to: 1522
/* 1516 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1518 */    MCD::OPC_Decode, 196, 18, 79, // Opcode: PRECEQU_PH_QBL_MM, DecodeIdx: 79
/* 1522 */    MCD::OPC_FilterValue, 18, 6, 0, // Skip to: 1532
/* 1526 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1528 */    MCD::OPC_Decode, 200, 18, 79, // Opcode: PRECEQU_PH_QBR_MM, DecodeIdx: 79
/* 1532 */    MCD::OPC_FilterValue, 22, 6, 0, // Skip to: 1542
/* 1536 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1538 */    MCD::OPC_Decode, 208, 18, 79, // Opcode: PRECEU_PH_QBL_MM, DecodeIdx: 79
/* 1542 */    MCD::OPC_FilterValue, 26, 6, 0, // Skip to: 1552
/* 1546 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1548 */    MCD::OPC_Decode, 212, 18, 79, // Opcode: PRECEU_PH_QBR_MM, DecodeIdx: 79
/* 1552 */    MCD::OPC_FilterValueOrFail, 30, 
/* 1554 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1556 */    MCD::OPC_Decode, 239, 18, 82, // Opcode: RADDU_W_QB_MM, DecodeIdx: 82
/* 1560 */    MCD::OPC_FilterValue, 5, 61, 0, // Skip to: 1625
/* 1564 */    MCD::OPC_ExtractField, 11, 15,  // Inst{25-11} ...
/* 1567 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 1577
/* 1571 */    MCD::OPC_CheckPredicateOrFail, 10, 
/* 1573 */    MCD::OPC_Decode, 150, 22, 10, // Opcode: TLBGP_MM, DecodeIdx: 10
/* 1577 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 1587
/* 1581 */    MCD::OPC_CheckPredicateOrFail, 10, 
/* 1583 */    MCD::OPC_Decode, 152, 22, 10, // Opcode: TLBGR_MM, DecodeIdx: 10
/* 1587 */    MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 1597
/* 1591 */    MCD::OPC_CheckPredicateOrFail, 10, 
/* 1593 */    MCD::OPC_Decode, 154, 22, 10, // Opcode: TLBGWI_MM, DecodeIdx: 10
/* 1597 */    MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 1607
/* 1601 */    MCD::OPC_CheckPredicateOrFail, 10, 
/* 1603 */    MCD::OPC_Decode, 156, 22, 10, // Opcode: TLBGWR_MM, DecodeIdx: 10
/* 1607 */    MCD::OPC_FilterValue, 8, 6, 0, // Skip to: 1617
/* 1611 */    MCD::OPC_CheckPredicateOrFail, 10, 
/* 1613 */    MCD::OPC_Decode, 148, 22, 10, // Opcode: TLBGINV_MM, DecodeIdx: 10
/* 1617 */    MCD::OPC_FilterValueOrFail, 10, 
/* 1619 */    MCD::OPC_CheckPredicateOrFail, 10, 
/* 1621 */    MCD::OPC_Decode, 147, 22, 10, // Opcode: TLBGINVF_MM, DecodeIdx: 10
/* 1625 */    MCD::OPC_FilterValue, 7, 21, 0, // Skip to: 1650
/* 1629 */    MCD::OPC_ExtractField, 11, 2,  // Inst{12-11} ...
/* 1632 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 1642
/* 1636 */    MCD::OPC_CheckPredicateOrFail, 9, 
/* 1638 */    MCD::OPC_Decode, 150, 20, 74, // Opcode: SHRA_QB_MMR2, DecodeIdx: 74
/* 1642 */    MCD::OPC_FilterValueOrFail, 2, 
/* 1644 */    MCD::OPC_CheckPredicateOrFail, 9, 
/* 1646 */    MCD::OPC_Decode, 154, 20, 74, // Opcode: SHRA_R_QB_MMR2, DecodeIdx: 74
/* 1650 */    MCD::OPC_FilterValue, 8, 21, 0, // Skip to: 1675
/* 1654 */    MCD::OPC_ExtractField, 11, 1,  // Inst{11} ...
/* 1657 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 1667
/* 1661 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 1663 */    MCD::OPC_Decode, 144, 22, 71, // Opcode: TGE_MM, DecodeIdx: 71
/* 1667 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1669 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 1671 */    MCD::OPC_Decode, 174, 22, 71, // Opcode: TLTU_MM, DecodeIdx: 71
/* 1675 */    MCD::OPC_FilterValue, 9, 69, 0, // Skip to: 1748
/* 1679 */    MCD::OPC_ExtractField, 11, 3,  // Inst{13-11} ...
/* 1682 */    MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 1696
/* 1686 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1688 */    MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 1692 */    MCD::OPC_Decode, 187, 17, 83, // Opcode: MTHLIP_MM, DecodeIdx: 83
/* 1696 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 1706
/* 1700 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1702 */    MCD::OPC_Decode, 246, 15, 76, // Opcode: MAQ_S_W_PHR_MM, DecodeIdx: 76
/* 1706 */    MCD::OPC_FilterValue, 2, 10, 0, // Skip to: 1720
/* 1710 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1712 */    MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 1716 */    MCD::OPC_Decode, 247, 19, 83, // Opcode: SHILOV_MM, DecodeIdx: 83
/* 1720 */    MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 1730
/* 1724 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1726 */    MCD::OPC_Decode, 244, 15, 76, // Opcode: MAQ_S_W_PHL_MM, DecodeIdx: 76
/* 1730 */    MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 1740
/* 1734 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1736 */    MCD::OPC_Decode, 242, 15, 76, // Opcode: MAQ_SA_W_PHR_MM, DecodeIdx: 76
/* 1740 */    MCD::OPC_FilterValueOrFail, 7, 
/* 1742 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1744 */    MCD::OPC_Decode, 240, 15, 76, // Opcode: MAQ_SA_W_PHL_MM, DecodeIdx: 76
/* 1748 */    MCD::OPC_FilterValue, 10, 81, 0, // Skip to: 1833
/* 1752 */    MCD::OPC_ExtractField, 11, 3,  // Inst{13-11} ...
/* 1755 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 1765
/* 1759 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1761 */    MCD::OPC_Decode, 228, 11, 76, // Opcode: DPAQ_S_W_PH_MM, DecodeIdx: 76
/* 1765 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 1775
/* 1769 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1771 */    MCD::OPC_Decode, 233, 15, 76, // Opcode: MADD_DSP_MM, DecodeIdx: 76
/* 1775 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 1785
/* 1779 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1781 */    MCD::OPC_Decode, 226, 11, 76, // Opcode: DPAQ_SA_L_W_MM, DecodeIdx: 76
/* 1785 */    MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 1795
/* 1789 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1791 */    MCD::OPC_Decode, 223, 15, 76, // Opcode: MADDU_DSP_MM, DecodeIdx: 76
/* 1795 */    MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 1805
/* 1799 */    MCD::OPC_CheckPredicateOrFail, 9, 
/* 1801 */    MCD::OPC_Decode, 224, 11, 76, // Opcode: DPAQX_S_W_PH_MMR2, DecodeIdx: 76
/* 1805 */    MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 1815
/* 1809 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1811 */    MCD::OPC_Decode, 156, 17, 76, // Opcode: MSUB_DSP_MM, DecodeIdx: 76
/* 1815 */    MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 1825
/* 1819 */    MCD::OPC_CheckPredicateOrFail, 9, 
/* 1821 */    MCD::OPC_Decode, 222, 11, 76, // Opcode: DPAQX_SA_W_PH_MMR2, DecodeIdx: 76
/* 1825 */    MCD::OPC_FilterValueOrFail, 7, 
/* 1827 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1829 */    MCD::OPC_Decode, 146, 17, 76, // Opcode: MSUBU_DSP_MM, DecodeIdx: 76
/* 1833 */    MCD::OPC_FilterValue, 12, 201, 0, // Skip to: 2038
/* 1837 */    MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 1840 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 1850
/* 1844 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1846 */    MCD::OPC_Decode, 254, 18, 84, // Opcode: REPLV_PH_MM, DecodeIdx: 84
/* 1850 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 1860
/* 1854 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1856 */    MCD::OPC_Decode, 128, 19, 84, // Opcode: REPLV_QB_MM, DecodeIdx: 84
/* 1860 */    MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 1870
/* 1864 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 1866 */    MCD::OPC_Decode, 212, 19, 80, // Opcode: SEB_MM, DecodeIdx: 80
/* 1870 */    MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 1880
/* 1874 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 1876 */    MCD::OPC_Decode, 215, 19, 80, // Opcode: SEH_MM, DecodeIdx: 80
/* 1880 */    MCD::OPC_FilterValue, 9, 6, 0, // Skip to: 1890
/* 1884 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 1886 */    MCD::OPC_Decode, 137, 9, 80, // Opcode: CLO_MM, DecodeIdx: 80
/* 1890 */    MCD::OPC_FilterValue, 11, 6, 0, // Skip to: 1900
/* 1894 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 1896 */    MCD::OPC_Decode, 157, 9, 80, // Opcode: CLZ_MM, DecodeIdx: 80
/* 1900 */    MCD::OPC_FilterValue, 13, 6, 0, // Skip to: 1910
/* 1904 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 1906 */    MCD::OPC_Decode, 244, 18, 85, // Opcode: RDHWR_MM, DecodeIdx: 85
/* 1910 */    MCD::OPC_FilterValue, 14, 6, 0, // Skip to: 1920
/* 1914 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1916 */    MCD::OPC_Decode, 195, 18, 79, // Opcode: PRECEQU_PH_QBLA_MM, DecodeIdx: 79
/* 1920 */    MCD::OPC_FilterValue, 15, 6, 0, // Skip to: 1930
/* 1924 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 1926 */    MCD::OPC_Decode, 208, 22, 80, // Opcode: WSBH_MM, DecodeIdx: 80
/* 1930 */    MCD::OPC_FilterValue, 17, 6, 0, // Skip to: 1940
/* 1934 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 1936 */    MCD::OPC_Decode, 233, 17, 86, // Opcode: MULT_MM, DecodeIdx: 86
/* 1940 */    MCD::OPC_FilterValue, 18, 6, 0, // Skip to: 1950
/* 1944 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1946 */    MCD::OPC_Decode, 199, 18, 79, // Opcode: PRECEQU_PH_QBRA_MM, DecodeIdx: 79
/* 1950 */    MCD::OPC_FilterValue, 19, 6, 0, // Skip to: 1960
/* 1954 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 1956 */    MCD::OPC_Decode, 235, 17, 86, // Opcode: MULTu_MM, DecodeIdx: 86
/* 1960 */    MCD::OPC_FilterValue, 21, 6, 0, // Skip to: 1970
/* 1964 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 1966 */    MCD::OPC_Decode, 205, 19, 86, // Opcode: SDIV_MM, DecodeIdx: 86
/* 1970 */    MCD::OPC_FilterValue, 22, 6, 0, // Skip to: 1980
/* 1974 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 1976 */    MCD::OPC_Decode, 207, 18, 79, // Opcode: PRECEU_PH_QBLA_MM, DecodeIdx: 79
/* 1980 */    MCD::OPC_FilterValue, 23, 6, 0, // Skip to: 1990
/* 1984 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 1986 */    MCD::OPC_Decode, 193, 22, 86, // Opcode: UDIV_MM, DecodeIdx: 86
/* 1990 */    MCD::OPC_FilterValue, 25, 6, 0, // Skip to: 2000
/* 1994 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 1996 */    MCD::OPC_Decode, 234, 15, 86, // Opcode: MADD_MM, DecodeIdx: 86
/* 2000 */    MCD::OPC_FilterValue, 26, 6, 0, // Skip to: 2010
/* 2004 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2006 */    MCD::OPC_Decode, 211, 18, 79, // Opcode: PRECEU_PH_QBRA_MM, DecodeIdx: 79
/* 2010 */    MCD::OPC_FilterValue, 27, 6, 0, // Skip to: 2020
/* 2014 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2016 */    MCD::OPC_Decode, 224, 15, 86, // Opcode: MADDU_MM, DecodeIdx: 86
/* 2020 */    MCD::OPC_FilterValue, 29, 6, 0, // Skip to: 2030
/* 2024 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2026 */    MCD::OPC_Decode, 157, 17, 86, // Opcode: MSUB_MM, DecodeIdx: 86
/* 2030 */    MCD::OPC_FilterValueOrFail, 31, 
/* 2032 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2034 */    MCD::OPC_Decode, 147, 17, 86, // Opcode: MSUBU_MM, DecodeIdx: 86
/* 2038 */    MCD::OPC_FilterValue, 13, 139, 0, // Skip to: 2181
/* 2042 */    MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 2045 */    MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 2059
/* 2049 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2051 */    MCD::OPC_CheckFieldOrFail, 16, 10, 0, 
/* 2055 */    MCD::OPC_Decode, 162, 22, 10, // Opcode: TLBP_MM, DecodeIdx: 10
/* 2059 */    MCD::OPC_FilterValue, 2, 10, 0, // Skip to: 2073
/* 2063 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2065 */    MCD::OPC_CheckFieldOrFail, 16, 10, 0, 
/* 2069 */    MCD::OPC_Decode, 164, 22, 10, // Opcode: TLBR_MM, DecodeIdx: 10
/* 2073 */    MCD::OPC_FilterValue, 4, 10, 0, // Skip to: 2087
/* 2077 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2079 */    MCD::OPC_CheckFieldOrFail, 16, 10, 0, 
/* 2083 */    MCD::OPC_Decode, 166, 22, 10, // Opcode: TLBWI_MM, DecodeIdx: 10
/* 2087 */    MCD::OPC_FilterValue, 6, 10, 0, // Skip to: 2101
/* 2091 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2093 */    MCD::OPC_CheckFieldOrFail, 16, 10, 0, 
/* 2097 */    MCD::OPC_Decode, 168, 22, 10, // Opcode: TLBWR_MM, DecodeIdx: 10
/* 2101 */    MCD::OPC_FilterValue, 13, 10, 0, // Skip to: 2115
/* 2105 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2107 */    MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 2111 */    MCD::OPC_Decode, 236, 21, 87, // Opcode: SYNC_MM, DecodeIdx: 87
/* 2115 */    MCD::OPC_FilterValue, 17, 6, 0, // Skip to: 2125
/* 2119 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2121 */    MCD::OPC_Decode, 239, 21, 88, // Opcode: SYSCALL_MM, DecodeIdx: 88
/* 2125 */    MCD::OPC_FilterValue, 18, 6, 0, // Skip to: 2135
/* 2129 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2131 */    MCD::OPC_Decode, 202, 22, 88, // Opcode: WAIT_MM, DecodeIdx: 88
/* 2135 */    MCD::OPC_FilterValue, 24, 6, 0, // Skip to: 2145
/* 2139 */    MCD::OPC_CheckPredicateOrFail, 10, 
/* 2141 */    MCD::OPC_Decode, 142, 14, 88, // Opcode: HYPCALL_MM, DecodeIdx: 88
/* 2145 */    MCD::OPC_FilterValue, 27, 6, 0, // Skip to: 2155
/* 2149 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2151 */    MCD::OPC_Decode, 192, 19, 88, // Opcode: SDBBP_MM, DecodeIdx: 88
/* 2155 */    MCD::OPC_FilterValue, 28, 10, 0, // Skip to: 2169
/* 2159 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2161 */    MCD::OPC_CheckFieldOrFail, 16, 10, 0, 
/* 2165 */    MCD::OPC_Decode, 163, 11, 10, // Opcode: DERET_MM, DecodeIdx: 10
/* 2169 */    MCD::OPC_FilterValueOrFail, 30, 
/* 2171 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2173 */    MCD::OPC_CheckFieldOrFail, 16, 10, 0, 
/* 2177 */    MCD::OPC_Decode, 166, 12, 10, // Opcode: ERET_MM, DecodeIdx: 10
/* 2181 */    MCD::OPC_FilterValue, 15, 10, 0, // Skip to: 2195
/* 2185 */    MCD::OPC_CheckPredicateOrFail, 9, 
/* 2187 */    MCD::OPC_CheckFieldOrFail, 11, 1, 0, 
/* 2191 */    MCD::OPC_Decode, 162, 20, 70, // Opcode: SHRL_PH_MMR2, DecodeIdx: 70
/* 2195 */    MCD::OPC_FilterValue, 16, 21, 0, // Skip to: 2220
/* 2199 */    MCD::OPC_ExtractField, 11, 1,  // Inst{11} ...
/* 2202 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 2212
/* 2206 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2208 */    MCD::OPC_Decode, 143, 22, 71, // Opcode: TGEU_MM, DecodeIdx: 71
/* 2212 */    MCD::OPC_FilterValueOrFail, 1, 
/* 2214 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2216 */    MCD::OPC_Decode, 179, 22, 71, // Opcode: TNE_MM, DecodeIdx: 71
/* 2220 */    MCD::OPC_FilterValue, 18, 81, 0, // Skip to: 2305
/* 2224 */    MCD::OPC_ExtractField, 11, 3,  // Inst{13-11} ...
/* 2227 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 2237
/* 2231 */    MCD::OPC_CheckPredicateOrFail, 9, 
/* 2233 */    MCD::OPC_Decode, 131, 12, 76, // Opcode: DPS_W_PH_MMR2, DecodeIdx: 76
/* 2237 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 2247
/* 2241 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2243 */    MCD::OPC_Decode, 232, 17, 89, // Opcode: MULT_DSP_MM, DecodeIdx: 89
/* 2247 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 2257
/* 2251 */    MCD::OPC_CheckPredicateOrFail, 9, 
/* 2253 */    MCD::OPC_Decode, 129, 12, 76, // Opcode: DPSX_W_PH_MMR2, DecodeIdx: 76
/* 2257 */    MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 2267
/* 2261 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2263 */    MCD::OPC_Decode, 230, 17, 89, // Opcode: MULTU_DSP_MM, DecodeIdx: 89
/* 2267 */    MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 2277
/* 2271 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2273 */    MCD::OPC_Decode, 253, 11, 76, // Opcode: DPSU_H_QBL_MM, DecodeIdx: 76
/* 2277 */    MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 2287
/* 2281 */    MCD::OPC_CheckPredicateOrFail, 9, 
/* 2283 */    MCD::OPC_Decode, 227, 17, 76, // Opcode: MULSA_W_PH_MMR2, DecodeIdx: 76
/* 2287 */    MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 2297
/* 2291 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2293 */    MCD::OPC_Decode, 255, 11, 76, // Opcode: DPSU_H_QBR_MM, DecodeIdx: 76
/* 2297 */    MCD::OPC_FilterValueOrFail, 7, 
/* 2299 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2301 */    MCD::OPC_Decode, 225, 17, 76, // Opcode: MULSAQ_S_W_PH_MM, DecodeIdx: 76
/* 2305 */    MCD::OPC_FilterValue, 19, 10, 0, // Skip to: 2319
/* 2309 */    MCD::OPC_CheckPredicateOrFail, 10, 
/* 2311 */    MCD::OPC_CheckFieldOrFail, 14, 2, 0, 
/* 2315 */    MCD::OPC_Decode, 156, 16, 68, // Opcode: MFGC0_MM, DecodeIdx: 68
/* 2319 */    MCD::OPC_FilterValue, 20, 21, 0, // Skip to: 2344
/* 2323 */    MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 2326 */    MCD::OPC_FilterValue, 25, 6, 0, // Skip to: 2336
/* 2330 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2332 */    MCD::OPC_Decode, 238, 8, 90, // Opcode: CFC2_MM, DecodeIdx: 90
/* 2336 */    MCD::OPC_FilterValueOrFail, 27, 
/* 2338 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2340 */    MCD::OPC_Decode, 137, 10, 91, // Opcode: CTC2_MM, DecodeIdx: 91
/* 2344 */    MCD::OPC_FilterValue, 21, 57, 0, // Skip to: 2405
/* 2348 */    MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 2351 */    MCD::OPC_FilterValue, 1, 10, 0, // Skip to: 2365
/* 2355 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2357 */    MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 2361 */    MCD::OPC_Decode, 170, 16, 92, // Opcode: MFHI_MM, DecodeIdx: 92
/* 2365 */    MCD::OPC_FilterValue, 3, 10, 0, // Skip to: 2379
/* 2369 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2371 */    MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 2375 */    MCD::OPC_Decode, 176, 16, 92, // Opcode: MFLO_MM, DecodeIdx: 92
/* 2379 */    MCD::OPC_FilterValue, 5, 10, 0, // Skip to: 2393
/* 2383 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2385 */    MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 2389 */    MCD::OPC_Decode, 185, 17, 92, // Opcode: MTHI_MM, DecodeIdx: 92
/* 2393 */    MCD::OPC_FilterValueOrFail, 7, 
/* 2395 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2397 */    MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 2401 */    MCD::OPC_Decode, 192, 17, 92, // Opcode: MTLO_MM, DecodeIdx: 92
/* 2405 */    MCD::OPC_FilterValue, 23, 10, 0, // Skip to: 2419
/* 2409 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2411 */    MCD::OPC_CheckFieldOrFail, 11, 2, 0, 
/* 2415 */    MCD::OPC_Decode, 132, 19, 93, // Opcode: REPL_QB_MM, DecodeIdx: 93
/* 2419 */    MCD::OPC_FilterValue, 25, 81, 0, // Skip to: 2504
/* 2423 */    MCD::OPC_ExtractField, 11, 3,  // Inst{13-11} ...
/* 2426 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 2436
/* 2430 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2432 */    MCD::OPC_Decode, 241, 18, 94, // Opcode: RDDSP_MM, DecodeIdx: 94
/* 2436 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 2446
/* 2440 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2442 */    MCD::OPC_Decode, 195, 12, 95, // Opcode: EXTR_W_MM, DecodeIdx: 95
/* 2446 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 2456
/* 2450 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2452 */    MCD::OPC_Decode, 205, 22, 94, // Opcode: WRDSP_MM, DecodeIdx: 94
/* 2456 */    MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 2466
/* 2460 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2462 */    MCD::OPC_Decode, 191, 12, 95, // Opcode: EXTR_R_W_MM, DecodeIdx: 95
/* 2466 */    MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 2476
/* 2470 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2472 */    MCD::OPC_Decode, 179, 12, 95, // Opcode: EXTP_MM, DecodeIdx: 95
/* 2476 */    MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 2486
/* 2480 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2482 */    MCD::OPC_Decode, 189, 12, 95, // Opcode: EXTR_RS_W_MM, DecodeIdx: 95
/* 2486 */    MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 2496
/* 2490 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2492 */    MCD::OPC_Decode, 176, 12, 95, // Opcode: EXTPDP_MM, DecodeIdx: 95
/* 2496 */    MCD::OPC_FilterValueOrFail, 7, 
/* 2498 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2500 */    MCD::OPC_Decode, 193, 12, 95, // Opcode: EXTR_S_H_MM, DecodeIdx: 95
/* 2504 */    MCD::OPC_FilterValue, 26, 81, 0, // Skip to: 2589
/* 2508 */    MCD::OPC_ExtractField, 11, 3,  // Inst{13-11} ...
/* 2511 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 2521
/* 2515 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2517 */    MCD::OPC_Decode, 245, 11, 76, // Opcode: DPSQ_S_W_PH_MM, DecodeIdx: 76
/* 2521 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 2531
/* 2525 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2527 */    MCD::OPC_Decode, 187, 12, 78, // Opcode: EXTRV_W_MM, DecodeIdx: 78
/* 2531 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 2541
/* 2535 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2537 */    MCD::OPC_Decode, 243, 11, 76, // Opcode: DPSQ_SA_L_W_MM, DecodeIdx: 76
/* 2541 */    MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 2551
/* 2545 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2547 */    MCD::OPC_Decode, 183, 12, 78, // Opcode: EXTRV_R_W_MM, DecodeIdx: 78
/* 2551 */    MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 2561
/* 2555 */    MCD::OPC_CheckPredicateOrFail, 9, 
/* 2557 */    MCD::OPC_Decode, 241, 11, 76, // Opcode: DPSQX_S_W_PH_MMR2, DecodeIdx: 76
/* 2561 */    MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 2571
/* 2565 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2567 */    MCD::OPC_Decode, 181, 12, 78, // Opcode: EXTRV_RS_W_MM, DecodeIdx: 78
/* 2571 */    MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 2581
/* 2575 */    MCD::OPC_CheckPredicateOrFail, 9, 
/* 2577 */    MCD::OPC_Decode, 239, 11, 76, // Opcode: DPSQX_SA_W_PH_MMR2, DecodeIdx: 76
/* 2581 */    MCD::OPC_FilterValueOrFail, 7, 
/* 2583 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2585 */    MCD::OPC_Decode, 185, 12, 78, // Opcode: EXTRV_S_H_MM, DecodeIdx: 78
/* 2589 */    MCD::OPC_FilterValue, 27, 10, 0, // Skip to: 2603
/* 2593 */    MCD::OPC_CheckPredicateOrFail, 10, 
/* 2595 */    MCD::OPC_CheckFieldOrFail, 14, 2, 0, 
/* 2599 */    MCD::OPC_Decode, 172, 17, 69, // Opcode: MTGC0_MM, DecodeIdx: 69
/* 2603 */    MCD::OPC_FilterValue, 28, 35, 0, // Skip to: 2642
/* 2607 */    MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 2610 */    MCD::OPC_FilterValue, 1, 20, 0, // Skip to: 2634
/* 2614 */    MCD::OPC_CheckPredicate, 6, 10, 0, // Skip to: 2628
/* 2618 */    MCD::OPC_CheckField, 21, 5, 0, 4, 0, // Skip to: 2628
/* 2624 */    MCD::OPC_Decode, 206, 14, 92, // Opcode: JR_MM, DecodeIdx: 92
/* 2628 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2630 */    MCD::OPC_Decode, 184, 14, 80, // Opcode: JALR_MM, DecodeIdx: 80
/* 2634 */    MCD::OPC_FilterValueOrFail, 9, 
/* 2636 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2638 */    MCD::OPC_Decode, 181, 14, 80, // Opcode: JALRS_MM, DecodeIdx: 80
/* 2642 */    MCD::OPC_FilterValueOrFail, 29, 
/* 2644 */    MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 2647 */    MCD::OPC_FilterValue, 8, 10, 0, // Skip to: 2661
/* 2651 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2653 */    MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 2657 */    MCD::OPC_Decode, 185, 11, 92, // Opcode: DI_MM, DecodeIdx: 92
/* 2661 */    MCD::OPC_FilterValueOrFail, 10, 
/* 2663 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2665 */    MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 2669 */    MCD::OPC_Decode, 160, 12, 92, // Opcode: EI_MM, DecodeIdx: 92
/* 2673 */    MCD::OPC_FilterValueOrFail, 61, 
/* 2675 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 2677 */    MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 2681 */    MCD::OPC_Decode, 130, 19, 96, // Opcode: REPL_PH_MM, DecodeIdx: 96
/* 2685 */    MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 2695
/* 2689 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2691 */    MCD::OPC_Decode, 208, 6, 97, // Opcode: ADDi_MM, DecodeIdx: 97
/* 2695 */    MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 2705
/* 2699 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2701 */    MCD::OPC_Decode, 228, 14, 98, // Opcode: LBu_MM, DecodeIdx: 98
/* 2705 */    MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 2715
/* 2709 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2711 */    MCD::OPC_Decode, 176, 19, 98, // Opcode: SB_MM, DecodeIdx: 98
/* 2715 */    MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 2725
/* 2719 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2721 */    MCD::OPC_Decode, 222, 14, 98, // Opcode: LB_MM, DecodeIdx: 98
/* 2725 */    MCD::OPC_FilterValue, 8, 51, 0, // Skip to: 2780
/* 2729 */    MCD::OPC_ExtractField, 12, 4,  // Inst{15-12} ...
/* 2732 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 2742
/* 2736 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2738 */    MCD::OPC_Decode, 186, 15, 99, // Opcode: LWP_MM, DecodeIdx: 99
/* 2742 */    MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 2752
/* 2746 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2748 */    MCD::OPC_Decode, 183, 15, 99, // Opcode: LWM32_MM, DecodeIdx: 99
/* 2752 */    MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 2762
/* 2756 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2758 */    MCD::OPC_Decode, 214, 8, 100, // Opcode: CACHE_MM, DecodeIdx: 100
/* 2762 */    MCD::OPC_FilterValue, 9, 6, 0, // Skip to: 2772
/* 2766 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2768 */    MCD::OPC_Decode, 220, 21, 99, // Opcode: SWP_MM, DecodeIdx: 99
/* 2772 */    MCD::OPC_FilterValueOrFail, 13, 
/* 2774 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2776 */    MCD::OPC_Decode, 219, 21, 99, // Opcode: SWM32_MM, DecodeIdx: 99
/* 2780 */    MCD::OPC_FilterValue, 12, 6, 0, // Skip to: 2790
/* 2784 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2786 */    MCD::OPC_Decode, 210, 6, 97, // Opcode: ADDiu_MM, DecodeIdx: 97
/* 2790 */    MCD::OPC_FilterValue, 13, 6, 0, // Skip to: 2800
/* 2794 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2796 */    MCD::OPC_Decode, 139, 15, 98, // Opcode: LHu_MM, DecodeIdx: 98
/* 2800 */    MCD::OPC_FilterValue, 14, 6, 0, // Skip to: 2810
/* 2804 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2806 */    MCD::OPC_Decode, 165, 20, 98, // Opcode: SH_MM, DecodeIdx: 98
/* 2810 */    MCD::OPC_FilterValue, 15, 6, 0, // Skip to: 2820
/* 2814 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 2816 */    MCD::OPC_Decode, 134, 15, 98, // Opcode: LH_MM, DecodeIdx: 98
/* 2820 */    MCD::OPC_FilterValue, 16, 237, 0, // Skip to: 3061
/* 2824 */    MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 2827 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 2837
/* 2831 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2833 */    MCD::OPC_Decode, 140, 8, 101, // Opcode: BLTZ_MM, DecodeIdx: 101
/* 2837 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 2847
/* 2841 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2843 */    MCD::OPC_Decode, 135, 8, 101, // Opcode: BLTZAL_MM, DecodeIdx: 101
/* 2847 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 2857
/* 2851 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2853 */    MCD::OPC_Decode, 211, 7, 101, // Opcode: BGEZ_MM, DecodeIdx: 101
/* 2857 */    MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 2867
/* 2861 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2863 */    MCD::OPC_Decode, 206, 7, 101, // Opcode: BGEZAL_MM, DecodeIdx: 101
/* 2867 */    MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 2877
/* 2871 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2873 */    MCD::OPC_Decode, 249, 7, 101, // Opcode: BLEZ_MM, DecodeIdx: 101
/* 2877 */    MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 2887
/* 2881 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2883 */    MCD::OPC_Decode, 165, 8, 101, // Opcode: BNEZC_MM, DecodeIdx: 101
/* 2887 */    MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 2897
/* 2891 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2893 */    MCD::OPC_Decode, 220, 7, 101, // Opcode: BGTZ_MM, DecodeIdx: 101
/* 2897 */    MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 2907
/* 2901 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2903 */    MCD::OPC_Decode, 190, 7, 101, // Opcode: BEQZC_MM, DecodeIdx: 101
/* 2907 */    MCD::OPC_FilterValue, 8, 6, 0, // Skip to: 2917
/* 2911 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2913 */    MCD::OPC_Decode, 172, 22, 102, // Opcode: TLTI_MM, DecodeIdx: 102
/* 2917 */    MCD::OPC_FilterValue, 9, 6, 0, // Skip to: 2927
/* 2921 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2923 */    MCD::OPC_Decode, 141, 22, 102, // Opcode: TGEI_MM, DecodeIdx: 102
/* 2927 */    MCD::OPC_FilterValue, 10, 6, 0, // Skip to: 2937
/* 2931 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2933 */    MCD::OPC_Decode, 171, 22, 102, // Opcode: TLTIU_MM, DecodeIdx: 102
/* 2937 */    MCD::OPC_FilterValue, 11, 6, 0, // Skip to: 2947
/* 2941 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2943 */    MCD::OPC_Decode, 140, 22, 102, // Opcode: TGEIU_MM, DecodeIdx: 102
/* 2947 */    MCD::OPC_FilterValue, 12, 6, 0, // Skip to: 2957
/* 2951 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2953 */    MCD::OPC_Decode, 178, 22, 102, // Opcode: TNEI_MM, DecodeIdx: 102
/* 2957 */    MCD::OPC_FilterValue, 13, 6, 0, // Skip to: 2967
/* 2961 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2963 */    MCD::OPC_Decode, 161, 15, 103, // Opcode: LUi_MM, DecodeIdx: 103
/* 2967 */    MCD::OPC_FilterValue, 14, 6, 0, // Skip to: 2977
/* 2971 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2973 */    MCD::OPC_Decode, 135, 22, 102, // Opcode: TEQI_MM, DecodeIdx: 102
/* 2977 */    MCD::OPC_FilterValue, 16, 6, 0, // Skip to: 2987
/* 2981 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2983 */    MCD::OPC_Decode, 234, 21, 104, // Opcode: SYNCI_MM, DecodeIdx: 104
/* 2987 */    MCD::OPC_FilterValue, 17, 6, 0, // Skip to: 2997
/* 2991 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 2993 */    MCD::OPC_Decode, 134, 8, 101, // Opcode: BLTZALS_MM, DecodeIdx: 101
/* 2997 */    MCD::OPC_FilterValue, 19, 6, 0, // Skip to: 3007
/* 3001 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3003 */    MCD::OPC_Decode, 205, 7, 101, // Opcode: BGEZALS_MM, DecodeIdx: 101
/* 3007 */    MCD::OPC_FilterValue, 25, 10, 0, // Skip to: 3021
/* 3011 */    MCD::OPC_CheckPredicateOrFail, 11, 
/* 3013 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 3017 */    MCD::OPC_Decode, 178, 8, 105, // Opcode: BPOSGE32C_MMR3, DecodeIdx: 105
/* 3021 */    MCD::OPC_FilterValue, 27, 10, 0, // Skip to: 3035
/* 3025 */    MCD::OPC_CheckPredicateOrFail, 12, 
/* 3027 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 3031 */    MCD::OPC_Decode, 179, 8, 106, // Opcode: BPOSGE32_MM, DecodeIdx: 106
/* 3035 */    MCD::OPC_FilterValue, 28, 10, 0, // Skip to: 3049
/* 3039 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3041 */    MCD::OPC_CheckFieldOrFail, 16, 2, 0, 
/* 3045 */    MCD::OPC_Decode, 159, 7, 107, // Opcode: BC1F_MM, DecodeIdx: 107
/* 3049 */    MCD::OPC_FilterValueOrFail, 29, 
/* 3051 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3053 */    MCD::OPC_CheckFieldOrFail, 16, 2, 0, 
/* 3057 */    MCD::OPC_Decode, 164, 7, 107, // Opcode: BC1T_MM, DecodeIdx: 107
/* 3061 */    MCD::OPC_FilterValue, 20, 6, 0, // Skip to: 3071
/* 3065 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3067 */    MCD::OPC_Decode, 167, 18, 108, // Opcode: ORi_MM, DecodeIdx: 108
/* 3071 */    MCD::OPC_FilterValue, 21, 46, 4, // Skip to: 4145
/* 3075 */    MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 3078 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 3088
/* 3082 */    MCD::OPC_CheckPredicateOrFail, 14, 
/* 3084 */    MCD::OPC_Decode, 238, 15, 109, // Opcode: MADD_S_MM, DecodeIdx: 109
/* 3088 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 3098
/* 3092 */    MCD::OPC_CheckPredicateOrFail, 14, 
/* 3094 */    MCD::OPC_Decode, 140, 18, 109, // Opcode: NMADD_S_MM, DecodeIdx: 109
/* 3098 */    MCD::OPC_FilterValue, 8, 41, 0, // Skip to: 3143
/* 3102 */    MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 3105 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 3115
/* 3109 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3111 */    MCD::OPC_Decode, 197, 15, 110, // Opcode: LWXC1_MM, DecodeIdx: 110
/* 3115 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 3125
/* 3119 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3121 */    MCD::OPC_Decode, 229, 21, 110, // Opcode: SWXC1_MM, DecodeIdx: 110
/* 3125 */    MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 3135
/* 3129 */    MCD::OPC_CheckPredicateOrFail, 15, 
/* 3131 */    MCD::OPC_Decode, 158, 15, 111, // Opcode: LUXC1_MM, DecodeIdx: 111
/* 3135 */    MCD::OPC_FilterValueOrFail, 6, 
/* 3137 */    MCD::OPC_CheckPredicateOrFail, 15, 
/* 3139 */    MCD::OPC_Decode, 197, 21, 111, // Opcode: SUXC1_MM, DecodeIdx: 111
/* 3143 */    MCD::OPC_FilterValue, 9, 6, 0, // Skip to: 3153
/* 3147 */    MCD::OPC_CheckPredicateOrFail, 16, 
/* 3149 */    MCD::OPC_Decode, 230, 15, 112, // Opcode: MADD_D32_MM, DecodeIdx: 112
/* 3153 */    MCD::OPC_FilterValue, 10, 6, 0, // Skip to: 3163
/* 3157 */    MCD::OPC_CheckPredicateOrFail, 16, 
/* 3159 */    MCD::OPC_Decode, 137, 18, 112, // Opcode: NMADD_D32_MM, DecodeIdx: 112
/* 3163 */    MCD::OPC_FilterValue, 32, 67, 0, // Skip to: 3234
/* 3167 */    MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 3170 */    MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 3184
/* 3174 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3176 */    MCD::OPC_CheckFieldOrFail, 11, 2, 0, 
/* 3180 */    MCD::OPC_Decode, 232, 16, 113, // Opcode: MOVF_S_MM, DecodeIdx: 113
/* 3184 */    MCD::OPC_FilterValue, 1, 10, 0, // Skip to: 3198
/* 3188 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3190 */    MCD::OPC_CheckFieldOrFail, 11, 2, 0, 
/* 3194 */    MCD::OPC_Decode, 252, 16, 113, // Opcode: MOVT_S_MM, DecodeIdx: 113
/* 3198 */    MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 3208
/* 3202 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 3204 */    MCD::OPC_Decode, 230, 18, 114, // Opcode: PREFX_MM, DecodeIdx: 114
/* 3208 */    MCD::OPC_FilterValue, 8, 10, 0, // Skip to: 3222
/* 3212 */    MCD::OPC_CheckPredicateOrFail, 17, 
/* 3214 */    MCD::OPC_CheckFieldOrFail, 11, 2, 0, 
/* 3218 */    MCD::OPC_Decode, 226, 16, 115, // Opcode: MOVF_D32_MM, DecodeIdx: 115
/* 3222 */    MCD::OPC_FilterValueOrFail, 9, 
/* 3224 */    MCD::OPC_CheckPredicateOrFail, 17, 
/* 3226 */    MCD::OPC_CheckFieldOrFail, 11, 2, 0, 
/* 3230 */    MCD::OPC_Decode, 246, 16, 115, // Opcode: MOVT_D32_MM, DecodeIdx: 115
/* 3234 */    MCD::OPC_FilterValue, 33, 6, 0, // Skip to: 3244
/* 3238 */    MCD::OPC_CheckPredicateOrFail, 14, 
/* 3240 */    MCD::OPC_Decode, 161, 17, 109, // Opcode: MSUB_S_MM, DecodeIdx: 109
/* 3244 */    MCD::OPC_FilterValue, 34, 6, 0, // Skip to: 3254
/* 3248 */    MCD::OPC_CheckPredicateOrFail, 14, 
/* 3250 */    MCD::OPC_Decode, 145, 18, 109, // Opcode: NMSUB_S_MM, DecodeIdx: 109
/* 3254 */    MCD::OPC_FilterValue, 41, 6, 0, // Skip to: 3264
/* 3258 */    MCD::OPC_CheckPredicateOrFail, 16, 
/* 3260 */    MCD::OPC_Decode, 153, 17, 112, // Opcode: MSUB_D32_MM, DecodeIdx: 112
/* 3264 */    MCD::OPC_FilterValue, 42, 6, 0, // Skip to: 3274
/* 3268 */    MCD::OPC_CheckPredicateOrFail, 16, 
/* 3270 */    MCD::OPC_Decode, 142, 18, 112, // Opcode: NMSUB_D32_MM, DecodeIdx: 112
/* 3274 */    MCD::OPC_FilterValue, 48, 41, 0, // Skip to: 3319
/* 3278 */    MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 3281 */    MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 3291
/* 3285 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 3287 */    MCD::OPC_Decode, 208, 12, 116, // Opcode: FADD_D32_MM, DecodeIdx: 116
/* 3291 */    MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 3301
/* 3295 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 3297 */    MCD::OPC_Decode, 225, 13, 116, // Opcode: FSUB_D32_MM, DecodeIdx: 116
/* 3301 */    MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 3311
/* 3305 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 3307 */    MCD::OPC_Decode, 181, 13, 116, // Opcode: FMUL_D32_MM, DecodeIdx: 116
/* 3311 */    MCD::OPC_FilterValueOrFail, 7, 
/* 3313 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 3315 */    MCD::OPC_Decode, 247, 12, 116, // Opcode: FDIV_D32_MM, DecodeIdx: 116
/* 3319 */    MCD::OPC_FilterValue, 56, 41, 0, // Skip to: 3364
/* 3323 */    MCD::OPC_ExtractField, 6, 4,  // Inst{9-6} ...
/* 3326 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 3336
/* 3330 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3332 */    MCD::OPC_Decode, 244, 16, 117, // Opcode: MOVN_I_S_MM, DecodeIdx: 117
/* 3336 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 3346
/* 3340 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3342 */    MCD::OPC_Decode, 136, 17, 117, // Opcode: MOVZ_I_S_MM, DecodeIdx: 117
/* 3346 */    MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 3356
/* 3350 */    MCD::OPC_CheckPredicateOrFail, 17, 
/* 3352 */    MCD::OPC_Decode, 238, 16, 118, // Opcode: MOVN_I_D32_MM, DecodeIdx: 118
/* 3356 */    MCD::OPC_FilterValueOrFail, 5, 
/* 3358 */    MCD::OPC_CheckPredicateOrFail, 17, 
/* 3360 */    MCD::OPC_Decode, 130, 17, 118, // Opcode: MOVZ_I_D32_MM, DecodeIdx: 118
/* 3364 */    MCD::OPC_FilterValue, 59, 166, 1, // Skip to: 3790
/* 3368 */    MCD::OPC_ExtractField, 6, 7,  // Inst{12-6} ...
/* 3371 */    MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 3385
/* 3375 */    MCD::OPC_CheckPredicateOrFail, 19, 
/* 3377 */    MCD::OPC_CheckFieldOrFail, 13, 3, 1, 
/* 3381 */    MCD::OPC_Decode, 151, 16, 119, // Opcode: MFC1_MM, DecodeIdx: 119
/* 3385 */    MCD::OPC_FilterValue, 1, 10, 0, // Skip to: 3399
/* 3389 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 3391 */    MCD::OPC_CheckFieldOrFail, 13, 3, 1, 
/* 3395 */    MCD::OPC_Decode, 170, 13, 120, // Opcode: FMOV_D32_MM, DecodeIdx: 120
/* 3399 */    MCD::OPC_FilterValue, 4, 21, 0, // Skip to: 3424
/* 3403 */    MCD::OPC_ExtractField, 13, 3,  // Inst{15-13} ...
/* 3406 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 3416
/* 3410 */    MCD::OPC_CheckPredicateOrFail, 20, 
/* 3412 */    MCD::OPC_Decode, 153, 10, 121, // Opcode: CVT_L_S_MM, DecodeIdx: 121
/* 3416 */    MCD::OPC_FilterValueOrFail, 2, 
/* 3418 */    MCD::OPC_CheckPredicateOrFail, 20, 
/* 3420 */    MCD::OPC_Decode, 150, 10, 122, // Opcode: CVT_L_D64_MM, DecodeIdx: 122
/* 3424 */    MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 3434
/* 3428 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3430 */    MCD::OPC_Decode, 230, 16, 123, // Opcode: MOVF_I_MM, DecodeIdx: 123
/* 3434 */    MCD::OPC_FilterValue, 8, 21, 0, // Skip to: 3459
/* 3438 */    MCD::OPC_ExtractField, 13, 3,  // Inst{15-13} ...
/* 3441 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 3451
/* 3445 */    MCD::OPC_CheckPredicateOrFail, 19, 
/* 3447 */    MCD::OPC_Decode, 157, 19, 124, // Opcode: RSQRT_S_MM, DecodeIdx: 124
/* 3451 */    MCD::OPC_FilterValueOrFail, 2, 
/* 3453 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 3455 */    MCD::OPC_Decode, 153, 19, 120, // Opcode: RSQRT_D32_MM, DecodeIdx: 120
/* 3459 */    MCD::OPC_FilterValue, 13, 21, 0, // Skip to: 3484
/* 3463 */    MCD::OPC_ExtractField, 13, 3,  // Inst{15-13} ...
/* 3466 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 3476
/* 3470 */    MCD::OPC_CheckPredicateOrFail, 19, 
/* 3472 */    MCD::OPC_Decode, 205, 12, 124, // Opcode: FABS_S_MM, DecodeIdx: 124
/* 3476 */    MCD::OPC_FilterValueOrFail, 1, 
/* 3478 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 3480 */    MCD::OPC_Decode, 201, 12, 120, // Opcode: FABS_D32_MM, DecodeIdx: 120
/* 3484 */    MCD::OPC_FilterValue, 32, 10, 0, // Skip to: 3498
/* 3488 */    MCD::OPC_CheckPredicateOrFail, 19, 
/* 3490 */    MCD::OPC_CheckFieldOrFail, 13, 3, 1, 
/* 3494 */    MCD::OPC_Decode, 167, 17, 125, // Opcode: MTC1_MM, DecodeIdx: 125
/* 3498 */    MCD::OPC_FilterValue, 36, 21, 0, // Skip to: 3523
/* 3502 */    MCD::OPC_ExtractField, 13, 3,  // Inst{15-13} ...
/* 3505 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 3515
/* 3509 */    MCD::OPC_CheckPredicateOrFail, 19, 
/* 3511 */    MCD::OPC_Decode, 174, 10, 124, // Opcode: CVT_W_S_MM, DecodeIdx: 124
/* 3515 */    MCD::OPC_FilterValueOrFail, 2, 
/* 3517 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 3519 */    MCD::OPC_Decode, 170, 10, 126, // Opcode: CVT_W_D32_MM, DecodeIdx: 126
/* 3523 */    MCD::OPC_FilterValue, 37, 6, 0, // Skip to: 3533
/* 3527 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3529 */    MCD::OPC_Decode, 250, 16, 123, // Opcode: MOVT_I_MM, DecodeIdx: 123
/* 3533 */    MCD::OPC_FilterValue, 40, 21, 0, // Skip to: 3558
/* 3537 */    MCD::OPC_ExtractField, 13, 3,  // Inst{15-13} ...
/* 3540 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 3550
/* 3544 */    MCD::OPC_CheckPredicateOrFail, 19, 
/* 3546 */    MCD::OPC_Decode, 221, 13, 124, // Opcode: FSQRT_S_MM, DecodeIdx: 124
/* 3550 */    MCD::OPC_FilterValueOrFail, 2, 
/* 3552 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 3554 */    MCD::OPC_Decode, 217, 13, 120, // Opcode: FSQRT_D32_MM, DecodeIdx: 120
/* 3558 */    MCD::OPC_FilterValue, 44, 41, 0, // Skip to: 3603
/* 3562 */    MCD::OPC_ExtractField, 13, 3,  // Inst{15-13} ...
/* 3565 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 3575
/* 3569 */    MCD::OPC_CheckPredicateOrFail, 19, 
/* 3571 */    MCD::OPC_Decode, 157, 13, 124, // Opcode: FLOOR_W_S_MM, DecodeIdx: 124
/* 3575 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 3585
/* 3579 */    MCD::OPC_CheckPredicateOrFail, 19, 
/* 3581 */    MCD::OPC_Decode, 189, 22, 124, // Opcode: TRUNC_W_S_MM, DecodeIdx: 124
/* 3585 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 3595
/* 3589 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 3591 */    MCD::OPC_Decode, 155, 13, 126, // Opcode: FLOOR_W_MM, DecodeIdx: 126
/* 3595 */    MCD::OPC_FilterValueOrFail, 3, 
/* 3597 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 3599 */    MCD::OPC_Decode, 187, 22, 126, // Opcode: TRUNC_W_MM, DecodeIdx: 126
/* 3603 */    MCD::OPC_FilterValue, 45, 10, 0, // Skip to: 3617
/* 3607 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 3609 */    MCD::OPC_CheckFieldOrFail, 13, 3, 1, 
/* 3613 */    MCD::OPC_Decode, 190, 13, 120, // Opcode: FNEG_D32_MM, DecodeIdx: 120
/* 3617 */    MCD::OPC_FilterValue, 64, 22, 0, // Skip to: 3643
/* 3621 */    MCD::OPC_ExtractField, 13, 3,  // Inst{15-13} ...
/* 3624 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 3634
/* 3628 */    MCD::OPC_CheckPredicateOrFail, 19, 
/* 3630 */    MCD::OPC_Decode, 237, 8, 127, // Opcode: CFC1_MM, DecodeIdx: 127
/* 3634 */    MCD::OPC_FilterValueOrFail, 1, 
/* 3636 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 3638 */    MCD::OPC_Decode, 159, 16, 128, 1, // Opcode: MFHC1_D32_MM, DecodeIdx: 128
/* 3643 */    MCD::OPC_FilterValue, 72, 21, 0, // Skip to: 3668
/* 3647 */    MCD::OPC_ExtractField, 13, 3,  // Inst{15-13} ...
/* 3650 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 3660
/* 3654 */    MCD::OPC_CheckPredicateOrFail, 19, 
/* 3656 */    MCD::OPC_Decode, 252, 18, 124, // Opcode: RECIP_S_MM, DecodeIdx: 124
/* 3660 */    MCD::OPC_FilterValueOrFail, 2, 
/* 3662 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 3664 */    MCD::OPC_Decode, 248, 18, 120, // Opcode: RECIP_D32_MM, DecodeIdx: 120
/* 3668 */    MCD::OPC_FilterValue, 77, 23, 0, // Skip to: 3695
/* 3672 */    MCD::OPC_ExtractField, 13, 3,  // Inst{15-13} ...
/* 3675 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 3686
/* 3679 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 3681 */    MCD::OPC_Decode, 140, 10, 129, 1, // Opcode: CVT_D32_S_MM, DecodeIdx: 129
/* 3686 */    MCD::OPC_FilterValueOrFail, 1, 
/* 3688 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 3690 */    MCD::OPC_Decode, 142, 10, 129, 1, // Opcode: CVT_D32_W_MM, DecodeIdx: 129
/* 3695 */    MCD::OPC_FilterValue, 96, 23, 0, // Skip to: 3722
/* 3699 */    MCD::OPC_ExtractField, 13, 3,  // Inst{15-13} ...
/* 3702 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 3713
/* 3706 */    MCD::OPC_CheckPredicateOrFail, 19, 
/* 3708 */    MCD::OPC_Decode, 136, 10, 130, 1, // Opcode: CTC1_MM, DecodeIdx: 130
/* 3713 */    MCD::OPC_FilterValueOrFail, 1, 
/* 3715 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 3717 */    MCD::OPC_Decode, 175, 17, 131, 1, // Opcode: MTHC1_D32_MM, DecodeIdx: 131
/* 3722 */    MCD::OPC_FilterValue, 108, 41, 0, // Skip to: 3767
/* 3726 */    MCD::OPC_ExtractField, 13, 3,  // Inst{15-13} ...
/* 3729 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 3739
/* 3733 */    MCD::OPC_CheckPredicateOrFail, 19, 
/* 3735 */    MCD::OPC_Decode, 226, 8, 124, // Opcode: CEIL_W_S_MM, DecodeIdx: 124
/* 3739 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 3749
/* 3743 */    MCD::OPC_CheckPredicateOrFail, 19, 
/* 3745 */    MCD::OPC_Decode, 150, 19, 124, // Opcode: ROUND_W_S_MM, DecodeIdx: 124
/* 3749 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 3759
/* 3753 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 3755 */    MCD::OPC_Decode, 224, 8, 126, // Opcode: CEIL_W_MM, DecodeIdx: 126
/* 3759 */    MCD::OPC_FilterValueOrFail, 3, 
/* 3761 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 3763 */    MCD::OPC_Decode, 148, 19, 126, // Opcode: ROUND_W_MM, DecodeIdx: 126
/* 3767 */    MCD::OPC_FilterValueOrFail, 109, 
/* 3769 */    MCD::OPC_ExtractField, 13, 3,  // Inst{15-13} ...
/* 3772 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 3782
/* 3776 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 3778 */    MCD::OPC_Decode, 159, 10, 126, // Opcode: CVT_S_D32_MM, DecodeIdx: 126
/* 3782 */    MCD::OPC_FilterValueOrFail, 1, 
/* 3784 */    MCD::OPC_CheckPredicateOrFail, 19, 
/* 3786 */    MCD::OPC_Decode, 167, 10, 124, // Opcode: CVT_S_W_MM, DecodeIdx: 124
/* 3790 */    MCD::OPC_FilterValueOrFail, 60, 
/* 3792 */    MCD::OPC_ExtractField, 6, 7,  // Inst{12-6} ...
/* 3795 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 3806
/* 3799 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3801 */    MCD::OPC_Decode, 187, 10, 132, 1, // Opcode: C_F_S_MM, DecodeIdx: 132
/* 3806 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 3817
/* 3810 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3812 */    MCD::OPC_Decode, 143, 11, 132, 1, // Opcode: C_UN_S_MM, DecodeIdx: 132
/* 3817 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 3828
/* 3821 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3823 */    MCD::OPC_Decode, 181, 10, 132, 1, // Opcode: C_EQ_S_MM, DecodeIdx: 132
/* 3828 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 3839
/* 3832 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3834 */    MCD::OPC_Decode, 253, 10, 132, 1, // Opcode: C_UEQ_S_MM, DecodeIdx: 132
/* 3839 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 3850
/* 3843 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3845 */    MCD::OPC_Decode, 235, 10, 132, 1, // Opcode: C_OLT_S_MM, DecodeIdx: 132
/* 3850 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 3861
/* 3854 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3856 */    MCD::OPC_Decode, 137, 11, 132, 1, // Opcode: C_ULT_S_MM, DecodeIdx: 132
/* 3861 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 3872
/* 3865 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3867 */    MCD::OPC_Decode, 229, 10, 132, 1, // Opcode: C_OLE_S_MM, DecodeIdx: 132
/* 3872 */    MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 3883
/* 3876 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3878 */    MCD::OPC_Decode, 131, 11, 132, 1, // Opcode: C_ULE_S_MM, DecodeIdx: 132
/* 3883 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 3894
/* 3887 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3889 */    MCD::OPC_Decode, 247, 10, 132, 1, // Opcode: C_SF_S_MM, DecodeIdx: 132
/* 3894 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 3905
/* 3898 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3900 */    MCD::OPC_Decode, 211, 10, 132, 1, // Opcode: C_NGLE_S_MM, DecodeIdx: 132
/* 3905 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 3916
/* 3909 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3911 */    MCD::OPC_Decode, 241, 10, 132, 1, // Opcode: C_SEQ_S_MM, DecodeIdx: 132
/* 3916 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 3927
/* 3920 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3922 */    MCD::OPC_Decode, 217, 10, 132, 1, // Opcode: C_NGL_S_MM, DecodeIdx: 132
/* 3927 */    MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 3938
/* 3931 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3933 */    MCD::OPC_Decode, 199, 10, 132, 1, // Opcode: C_LT_S_MM, DecodeIdx: 132
/* 3938 */    MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 3949
/* 3942 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3944 */    MCD::OPC_Decode, 205, 10, 132, 1, // Opcode: C_NGE_S_MM, DecodeIdx: 132
/* 3949 */    MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 3960
/* 3953 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3955 */    MCD::OPC_Decode, 193, 10, 132, 1, // Opcode: C_LE_S_MM, DecodeIdx: 132
/* 3960 */    MCD::OPC_FilterValue, 15, 7, 0, // Skip to: 3971
/* 3964 */    MCD::OPC_CheckPredicateOrFail, 13, 
/* 3966 */    MCD::OPC_Decode, 223, 10, 132, 1, // Opcode: C_NGT_S_MM, DecodeIdx: 132
/* 3971 */    MCD::OPC_FilterValue, 16, 7, 0, // Skip to: 3982
/* 3975 */    MCD::OPC_CheckPredicateOrFail, 17, 
/* 3977 */    MCD::OPC_Decode, 183, 10, 133, 1, // Opcode: C_F_D32_MM, DecodeIdx: 133
/* 3982 */    MCD::OPC_FilterValue, 17, 7, 0, // Skip to: 3993
/* 3986 */    MCD::OPC_CheckPredicateOrFail, 17, 
/* 3988 */    MCD::OPC_Decode, 139, 11, 133, 1, // Opcode: C_UN_D32_MM, DecodeIdx: 133
/* 3993 */    MCD::OPC_FilterValue, 18, 7, 0, // Skip to: 4004
/* 3997 */    MCD::OPC_CheckPredicateOrFail, 17, 
/* 3999 */    MCD::OPC_Decode, 177, 10, 133, 1, // Opcode: C_EQ_D32_MM, DecodeIdx: 133
/* 4004 */    MCD::OPC_FilterValue, 19, 7, 0, // Skip to: 4015
/* 4008 */    MCD::OPC_CheckPredicateOrFail, 17, 
/* 4010 */    MCD::OPC_Decode, 249, 10, 133, 1, // Opcode: C_UEQ_D32_MM, DecodeIdx: 133
/* 4015 */    MCD::OPC_FilterValue, 20, 7, 0, // Skip to: 4026
/* 4019 */    MCD::OPC_CheckPredicateOrFail, 17, 
/* 4021 */    MCD::OPC_Decode, 231, 10, 133, 1, // Opcode: C_OLT_D32_MM, DecodeIdx: 133
/* 4026 */    MCD::OPC_FilterValue, 21, 7, 0, // Skip to: 4037
/* 4030 */    MCD::OPC_CheckPredicateOrFail, 17, 
/* 4032 */    MCD::OPC_Decode, 133, 11, 133, 1, // Opcode: C_ULT_D32_MM, DecodeIdx: 133
/* 4037 */    MCD::OPC_FilterValue, 22, 7, 0, // Skip to: 4048
/* 4041 */    MCD::OPC_CheckPredicateOrFail, 17, 
/* 4043 */    MCD::OPC_Decode, 225, 10, 133, 1, // Opcode: C_OLE_D32_MM, DecodeIdx: 133
/* 4048 */    MCD::OPC_FilterValue, 23, 7, 0, // Skip to: 4059
/* 4052 */    MCD::OPC_CheckPredicateOrFail, 17, 
/* 4054 */    MCD::OPC_Decode, 255, 10, 133, 1, // Opcode: C_ULE_D32_MM, DecodeIdx: 133
/* 4059 */    MCD::OPC_FilterValue, 24, 7, 0, // Skip to: 4070
/* 4063 */    MCD::OPC_CheckPredicateOrFail, 17, 
/* 4065 */    MCD::OPC_Decode, 243, 10, 133, 1, // Opcode: C_SF_D32_MM, DecodeIdx: 133
/* 4070 */    MCD::OPC_FilterValue, 25, 7, 0, // Skip to: 4081
/* 4074 */    MCD::OPC_CheckPredicateOrFail, 17, 
/* 4076 */    MCD::OPC_Decode, 207, 10, 133, 1, // Opcode: C_NGLE_D32_MM, DecodeIdx: 133
/* 4081 */    MCD::OPC_FilterValue, 26, 7, 0, // Skip to: 4092
/* 4085 */    MCD::OPC_CheckPredicateOrFail, 17, 
/* 4087 */    MCD::OPC_Decode, 237, 10, 133, 1, // Opcode: C_SEQ_D32_MM, DecodeIdx: 133
/* 4092 */    MCD::OPC_FilterValue, 27, 7, 0, // Skip to: 4103
/* 4096 */    MCD::OPC_CheckPredicateOrFail, 17, 
/* 4098 */    MCD::OPC_Decode, 213, 10, 133, 1, // Opcode: C_NGL_D32_MM, DecodeIdx: 133
/* 4103 */    MCD::OPC_FilterValue, 28, 7, 0, // Skip to: 4114
/* 4107 */    MCD::OPC_CheckPredicateOrFail, 17, 
/* 4109 */    MCD::OPC_Decode, 195, 10, 133, 1, // Opcode: C_LT_D32_MM, DecodeIdx: 133
/* 4114 */    MCD::OPC_FilterValue, 29, 7, 0, // Skip to: 4125
/* 4118 */    MCD::OPC_CheckPredicateOrFail, 17, 
/* 4120 */    MCD::OPC_Decode, 201, 10, 133, 1, // Opcode: C_NGE_D32_MM, DecodeIdx: 133
/* 4125 */    MCD::OPC_FilterValue, 30, 7, 0, // Skip to: 4136
/* 4129 */    MCD::OPC_CheckPredicateOrFail, 17, 
/* 4131 */    MCD::OPC_Decode, 189, 10, 133, 1, // Opcode: C_LE_D32_MM, DecodeIdx: 133
/* 4136 */    MCD::OPC_FilterValueOrFail, 31, 
/* 4138 */    MCD::OPC_CheckPredicateOrFail, 17, 
/* 4140 */    MCD::OPC_Decode, 219, 10, 133, 1, // Opcode: C_NGT_D32_MM, DecodeIdx: 133
/* 4145 */    MCD::OPC_FilterValue, 22, 34, 0, // Skip to: 4183
/* 4149 */    MCD::OPC_ExtractField, 0, 11,  // Inst{10-0} ...
/* 4152 */    MCD::OPC_FilterValue, 197, 1, 6, 0, // Skip to: 4163
/* 4157 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 4159 */    MCD::OPC_Decode, 167, 9, 54, // Opcode: CMPGU_EQ_QB_MM, DecodeIdx: 54
/* 4163 */    MCD::OPC_FilterValue, 133, 2, 6, 0, // Skip to: 4174
/* 4168 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 4170 */    MCD::OPC_Decode, 171, 9, 54, // Opcode: CMPGU_LT_QB_MM, DecodeIdx: 54
/* 4174 */    MCD::OPC_FilterValueOrFail, 197, 2, 
/* 4177 */    MCD::OPC_CheckPredicateOrFail, 8, 
/* 4179 */    MCD::OPC_Decode, 169, 9, 54, // Opcode: CMPGU_LE_QB_MM, DecodeIdx: 54
/* 4183 */    MCD::OPC_FilterValue, 24, 11, 1, // Skip to: 4454
/* 4187 */    MCD::OPC_ExtractField, 12, 4,  // Inst{15-12} ...
/* 4190 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 4200
/* 4194 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4196 */    MCD::OPC_Decode, 180, 15, 99, // Opcode: LWL_MM, DecodeIdx: 99
/* 4200 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 4210
/* 4204 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4206 */    MCD::OPC_Decode, 191, 15, 99, // Opcode: LWR_MM, DecodeIdx: 99
/* 4210 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 4220
/* 4214 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4216 */    MCD::OPC_Decode, 231, 18, 100, // Opcode: PREF_MM, DecodeIdx: 100
/* 4220 */    MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 4230
/* 4224 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4226 */    MCD::OPC_Decode, 149, 15, 99, // Opcode: LL_MM, DecodeIdx: 99
/* 4230 */    MCD::OPC_FilterValue, 6, 89, 0, // Skip to: 4323
/* 4234 */    MCD::OPC_ExtractField, 9, 3,  // Inst{11-9} ...
/* 4237 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4248
/* 4241 */    MCD::OPC_CheckPredicateOrFail, 21, 
/* 4243 */    MCD::OPC_Decode, 227, 14, 134, 1, // Opcode: LBuE_MM, DecodeIdx: 134
/* 4248 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 4259
/* 4252 */    MCD::OPC_CheckPredicateOrFail, 21, 
/* 4254 */    MCD::OPC_Decode, 138, 15, 134, 1, // Opcode: LHuE_MM, DecodeIdx: 134
/* 4259 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 4270
/* 4263 */    MCD::OPC_CheckPredicateOrFail, 22, 
/* 4265 */    MCD::OPC_Decode, 179, 15, 134, 1, // Opcode: LWLE_MM, DecodeIdx: 134
/* 4270 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 4281
/* 4274 */    MCD::OPC_CheckPredicateOrFail, 22, 
/* 4276 */    MCD::OPC_Decode, 190, 15, 134, 1, // Opcode: LWRE_MM, DecodeIdx: 134
/* 4281 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 4292
/* 4285 */    MCD::OPC_CheckPredicateOrFail, 21, 
/* 4287 */    MCD::OPC_Decode, 217, 14, 134, 1, // Opcode: LBE_MM, DecodeIdx: 134
/* 4292 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 4303
/* 4296 */    MCD::OPC_CheckPredicateOrFail, 21, 
/* 4298 */    MCD::OPC_Decode, 130, 15, 134, 1, // Opcode: LHE_MM, DecodeIdx: 134
/* 4303 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 4314
/* 4307 */    MCD::OPC_CheckPredicateOrFail, 21, 
/* 4309 */    MCD::OPC_Decode, 148, 15, 134, 1, // Opcode: LLE_MM, DecodeIdx: 134
/* 4314 */    MCD::OPC_FilterValueOrFail, 7, 
/* 4316 */    MCD::OPC_CheckPredicateOrFail, 21, 
/* 4318 */    MCD::OPC_Decode, 174, 15, 134, 1, // Opcode: LWE_MM, DecodeIdx: 134
/* 4323 */    MCD::OPC_FilterValue, 8, 6, 0, // Skip to: 4333
/* 4327 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4329 */    MCD::OPC_Decode, 216, 21, 99, // Opcode: SWL_MM, DecodeIdx: 99
/* 4333 */    MCD::OPC_FilterValue, 9, 6, 0, // Skip to: 4343
/* 4337 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4339 */    MCD::OPC_Decode, 225, 21, 99, // Opcode: SWR_MM, DecodeIdx: 99
/* 4343 */    MCD::OPC_FilterValue, 10, 89, 0, // Skip to: 4436
/* 4347 */    MCD::OPC_ExtractField, 9, 3,  // Inst{11-9} ...
/* 4350 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4361
/* 4354 */    MCD::OPC_CheckPredicateOrFail, 22, 
/* 4356 */    MCD::OPC_Decode, 215, 21, 134, 1, // Opcode: SWLE_MM, DecodeIdx: 134
/* 4361 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 4372
/* 4365 */    MCD::OPC_CheckPredicateOrFail, 22, 
/* 4367 */    MCD::OPC_Decode, 224, 21, 134, 1, // Opcode: SWRE_MM, DecodeIdx: 134
/* 4372 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 4383
/* 4376 */    MCD::OPC_CheckPredicateOrFail, 21, 
/* 4378 */    MCD::OPC_Decode, 229, 18, 135, 1, // Opcode: PREFE_MM, DecodeIdx: 135
/* 4383 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 4394
/* 4387 */    MCD::OPC_CheckPredicateOrFail, 21, 
/* 4389 */    MCD::OPC_Decode, 213, 8, 135, 1, // Opcode: CACHEE_MM, DecodeIdx: 135
/* 4394 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 4405
/* 4398 */    MCD::OPC_CheckPredicateOrFail, 21, 
/* 4400 */    MCD::OPC_Decode, 175, 19, 134, 1, // Opcode: SBE_MM, DecodeIdx: 134
/* 4405 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 4416
/* 4409 */    MCD::OPC_CheckPredicateOrFail, 21, 
/* 4411 */    MCD::OPC_Decode, 241, 19, 134, 1, // Opcode: SHE_MM, DecodeIdx: 134
/* 4416 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 4427
/* 4420 */    MCD::OPC_CheckPredicateOrFail, 21, 
/* 4422 */    MCD::OPC_Decode, 184, 19, 134, 1, // Opcode: SCE_MM, DecodeIdx: 134
/* 4427 */    MCD::OPC_FilterValueOrFail, 7, 
/* 4429 */    MCD::OPC_CheckPredicateOrFail, 21, 
/* 4431 */    MCD::OPC_Decode, 211, 21, 134, 1, // Opcode: SWE_MM, DecodeIdx: 134
/* 4436 */    MCD::OPC_FilterValue, 11, 6, 0, // Skip to: 4446
/* 4440 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4442 */    MCD::OPC_Decode, 185, 19, 99, // Opcode: SC_MM, DecodeIdx: 99
/* 4446 */    MCD::OPC_FilterValueOrFail, 14, 
/* 4448 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4450 */    MCD::OPC_Decode, 194, 15, 99, // Opcode: LWU_MM, DecodeIdx: 99
/* 4454 */    MCD::OPC_FilterValue, 28, 6, 0, // Skip to: 4464
/* 4458 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4460 */    MCD::OPC_Decode, 221, 22, 108, // Opcode: XORi_MM, DecodeIdx: 108
/* 4464 */    MCD::OPC_FilterValue, 29, 7, 0, // Skip to: 4475
/* 4468 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4470 */    MCD::OPC_Decode, 185, 14, 136, 1, // Opcode: JALS_MM, DecodeIdx: 136
/* 4475 */    MCD::OPC_FilterValue, 30, 7, 0, // Skip to: 4486
/* 4479 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4481 */    MCD::OPC_Decode, 140, 6, 137, 1, // Opcode: ADDIUPC_MM, DecodeIdx: 137
/* 4486 */    MCD::OPC_FilterValue, 36, 6, 0, // Skip to: 4496
/* 4490 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 4492 */    MCD::OPC_Decode, 199, 20, 97, // Opcode: SLTi_MM, DecodeIdx: 97
/* 4496 */    MCD::OPC_FilterValue, 37, 7, 0, // Skip to: 4507
/* 4500 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4502 */    MCD::OPC_Decode, 192, 7, 138, 1, // Opcode: BEQ_MM, DecodeIdx: 138
/* 4507 */    MCD::OPC_FilterValue, 38, 7, 0, // Skip to: 4518
/* 4511 */    MCD::OPC_CheckPredicateOrFail, 19, 
/* 4513 */    MCD::OPC_Decode, 203, 21, 139, 1, // Opcode: SWC1_MM, DecodeIdx: 139
/* 4518 */    MCD::OPC_FilterValue, 39, 7, 0, // Skip to: 4529
/* 4522 */    MCD::OPC_CheckPredicateOrFail, 19, 
/* 4524 */    MCD::OPC_Decode, 166, 15, 139, 1, // Opcode: LWC1_MM, DecodeIdx: 139
/* 4529 */    MCD::OPC_FilterValue, 44, 6, 0, // Skip to: 4539
/* 4533 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 4535 */    MCD::OPC_Decode, 202, 20, 97, // Opcode: SLTiu_MM, DecodeIdx: 97
/* 4539 */    MCD::OPC_FilterValue, 45, 7, 0, // Skip to: 4550
/* 4543 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4545 */    MCD::OPC_Decode, 167, 8, 138, 1, // Opcode: BNE_MM, DecodeIdx: 138
/* 4550 */    MCD::OPC_FilterValue, 46, 7, 0, // Skip to: 4561
/* 4554 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 4556 */    MCD::OPC_Decode, 198, 19, 139, 1, // Opcode: SDC1_MM_D32, DecodeIdx: 139
/* 4561 */    MCD::OPC_FilterValue, 47, 7, 0, // Skip to: 4572
/* 4565 */    MCD::OPC_CheckPredicateOrFail, 18, 
/* 4567 */    MCD::OPC_Decode, 233, 14, 139, 1, // Opcode: LDC1_MM_D32, DecodeIdx: 139
/* 4572 */    MCD::OPC_FilterValue, 52, 6, 0, // Skip to: 4582
/* 4576 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4578 */    MCD::OPC_Decode, 230, 6, 108, // Opcode: ANDi_MM, DecodeIdx: 108
/* 4582 */    MCD::OPC_FilterValue, 53, 7, 0, // Skip to: 4593
/* 4586 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4588 */    MCD::OPC_Decode, 207, 14, 136, 1, // Opcode: J_MM, DecodeIdx: 136
/* 4593 */    MCD::OPC_FilterValue, 60, 7, 0, // Skip to: 4604
/* 4597 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4599 */    MCD::OPC_Decode, 187, 14, 140, 1, // Opcode: JALX_MM, DecodeIdx: 140
/* 4604 */    MCD::OPC_FilterValue, 61, 7, 0, // Skip to: 4615
/* 4608 */    MCD::OPC_CheckPredicateOrFail, 6, 
/* 4610 */    MCD::OPC_Decode, 188, 14, 136, 1, // Opcode: JAL_MM, DecodeIdx: 136
/* 4615 */    MCD::OPC_FilterValue, 62, 6, 0, // Skip to: 4625
/* 4619 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 4621 */    MCD::OPC_Decode, 230, 21, 98, // Opcode: SW_MM, DecodeIdx: 98
/* 4625 */    MCD::OPC_FilterValueOrFail, 63, 
/* 4627 */    MCD::OPC_CheckPredicateOrFail, 7, 
/* 4629 */    MCD::OPC_Decode, 200, 15, 98, // Opcode: LW_MM, DecodeIdx: 98
/* 4633 */    MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableMicroMipsDSP32[] = {
/* 0 */       MCD::OPC_ExtractField, 26, 6,  // Inst{31-26} ...
/* 3 */       MCD::OPC_FilterValue, 62, 7, 0, // Skip to: 14
/* 7 */       MCD::OPC_CheckPredicateOrFail, 8, 
/* 9 */       MCD::OPC_Decode, 209, 21, 141, 1, // Opcode: SWDSP_MM, DecodeIdx: 141
/* 14 */      MCD::OPC_FilterValueOrFail, 63, 
/* 16 */      MCD::OPC_CheckPredicateOrFail, 8, 
/* 18 */      MCD::OPC_Decode, 172, 15, 141, 1, // Opcode: LWDSP_MM, DecodeIdx: 141
/* 23 */      MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableMicroMipsFP6432[] = {
/* 0 */       MCD::OPC_ExtractField, 26, 6,  // Inst{31-26} ...
/* 3 */       MCD::OPC_FilterValue, 21, 210, 0, // Skip to: 217
/* 7 */       MCD::OPC_ExtractField, 0, 11,  // Inst{10-0} ...
/* 10 */      MCD::OPC_FilterValue, 59, 34, 0, // Skip to: 48
/* 14 */      MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 17 */      MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 28
/* 21 */      MCD::OPC_CheckPredicateOrFail, 20, 
/* 23 */      MCD::OPC_Decode, 166, 17, 142, 1, // Opcode: MTC1_D64_MM, DecodeIdx: 142
/* 28 */      MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 39
/* 32 */      MCD::OPC_CheckPredicateOrFail, 20, 
/* 34 */      MCD::OPC_Decode, 161, 16, 143, 1, // Opcode: MFHC1_D64_MM, DecodeIdx: 143
/* 39 */      MCD::OPC_FilterValueOrFail, 7, 
/* 41 */      MCD::OPC_CheckPredicateOrFail, 20, 
/* 43 */      MCD::OPC_Decode, 177, 17, 144, 1, // Opcode: MTHC1_D64_MM, DecodeIdx: 144
/* 48 */      MCD::OPC_FilterValue, 123, 10, 0, // Skip to: 62
/* 52 */      MCD::OPC_CheckPredicateOrFail, 20, 
/* 54 */      MCD::OPC_CheckFieldOrFail, 11, 5, 4, 
/* 58 */      MCD::OPC_Decode, 172, 13, 122, // Opcode: FMOV_D64_MM, DecodeIdx: 122
/* 62 */      MCD::OPC_FilterValue, 176, 2, 7, 0, // Skip to: 74
/* 67 */      MCD::OPC_CheckPredicateOrFail, 20, 
/* 69 */      MCD::OPC_Decode, 210, 12, 145, 1, // Opcode: FADD_D64_MM, DecodeIdx: 145
/* 74 */      MCD::OPC_FilterValue, 187, 2, 11, 0, // Skip to: 90
/* 79 */      MCD::OPC_CheckPredicateOrFail, 20, 
/* 81 */      MCD::OPC_CheckFieldOrFail, 11, 5, 9, 
/* 85 */      MCD::OPC_Decode, 172, 10, 146, 1, // Opcode: CVT_W_D64_MM, DecodeIdx: 146
/* 90 */      MCD::OPC_FilterValue, 240, 2, 7, 0, // Skip to: 102
/* 95 */      MCD::OPC_CheckPredicateOrFail, 20, 
/* 97 */      MCD::OPC_Decode, 227, 13, 145, 1, // Opcode: FSUB_D64_MM, DecodeIdx: 145
/* 102 */     MCD::OPC_FilterValue, 176, 3, 7, 0, // Skip to: 114
/* 107 */     MCD::OPC_CheckPredicateOrFail, 20, 
/* 109 */     MCD::OPC_Decode, 183, 13, 145, 1, // Opcode: FMUL_D64_MM, DecodeIdx: 145
/* 114 */     MCD::OPC_FilterValue, 240, 3, 7, 0, // Skip to: 126
/* 119 */     MCD::OPC_CheckPredicateOrFail, 20, 
/* 121 */     MCD::OPC_Decode, 249, 12, 145, 1, // Opcode: FDIV_D64_MM, DecodeIdx: 145
/* 126 */     MCD::OPC_FilterValue, 187, 4, 31, 0, // Skip to: 162
/* 131 */     MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 134 */     MCD::OPC_FilterValue, 8, 6, 0, // Skip to: 144
/* 138 */     MCD::OPC_CheckPredicateOrFail, 20, 
/* 140 */     MCD::OPC_Decode, 155, 19, 122, // Opcode: RSQRT_D64_MM, DecodeIdx: 122
/* 144 */     MCD::OPC_FilterValue, 9, 6, 0, // Skip to: 154
/* 148 */     MCD::OPC_CheckPredicateOrFail, 20, 
/* 150 */     MCD::OPC_Decode, 219, 13, 122, // Opcode: FSQRT_D64_MM, DecodeIdx: 122
/* 154 */     MCD::OPC_FilterValueOrFail, 10, 
/* 156 */     MCD::OPC_CheckPredicateOrFail, 20, 
/* 158 */     MCD::OPC_Decode, 250, 18, 122, // Opcode: RECIP_D64_MM, DecodeIdx: 122
/* 162 */     MCD::OPC_FilterValueOrFail, 251, 6, 
/* 165 */     MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 168 */     MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 178
/* 172 */     MCD::OPC_CheckPredicateOrFail, 20, 
/* 174 */     MCD::OPC_Decode, 145, 10, 121, // Opcode: CVT_D64_S_MM, DecodeIdx: 121
/* 178 */     MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 189
/* 182 */     MCD::OPC_CheckPredicateOrFail, 20, 
/* 184 */     MCD::OPC_Decode, 161, 10, 146, 1, // Opcode: CVT_S_D64_MM, DecodeIdx: 146
/* 189 */     MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 199
/* 193 */     MCD::OPC_CheckPredicateOrFail, 20, 
/* 195 */     MCD::OPC_Decode, 203, 12, 122, // Opcode: FABS_D64_MM, DecodeIdx: 122
/* 199 */     MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 209
/* 203 */     MCD::OPC_CheckPredicateOrFail, 20, 
/* 205 */     MCD::OPC_Decode, 192, 13, 122, // Opcode: FNEG_D64_MM, DecodeIdx: 122
/* 209 */     MCD::OPC_FilterValueOrFail, 6, 
/* 211 */     MCD::OPC_CheckPredicateOrFail, 20, 
/* 213 */     MCD::OPC_Decode, 147, 10, 121, // Opcode: CVT_D64_W_MM, DecodeIdx: 121
/* 217 */     MCD::OPC_FilterValue, 46, 7, 0, // Skip to: 228
/* 221 */     MCD::OPC_CheckPredicateOrFail, 23, 
/* 223 */     MCD::OPC_Decode, 197, 19, 139, 1, // Opcode: SDC1_D64_MMR6, DecodeIdx: 139
/* 228 */     MCD::OPC_FilterValueOrFail, 47, 
/* 230 */     MCD::OPC_CheckPredicateOrFail, 23, 
/* 232 */     MCD::OPC_Decode, 232, 14, 139, 1, // Opcode: LDC1_D64_MMR6, DecodeIdx: 139
/* 237 */     MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableMicroMipsR616[] = {
/* 0 */       MCD::OPC_ExtractField, 10, 6,  // Inst{15-10} ...
/* 3 */       MCD::OPC_FilterValue, 1, 23, 0, // Skip to: 30
/* 7 */       MCD::OPC_ExtractField, 0, 1,  // Inst{0} ...
/* 10 */      MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 21
/* 14 */      MCD::OPC_CheckPredicateOrFail, 24, 
/* 16 */      MCD::OPC_Decode, 177, 6, 147, 1, // Opcode: ADDU16_MMR6, DecodeIdx: 147
/* 21 */      MCD::OPC_FilterValueOrFail, 1, 
/* 23 */      MCD::OPC_CheckPredicateOrFail, 24, 
/* 25 */      MCD::OPC_Decode, 169, 21, 147, 1, // Opcode: SUBU16_MMR6, DecodeIdx: 147
/* 30 */      MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 40
/* 34 */      MCD::OPC_CheckPredicateOrFail, 24, 
/* 36 */      MCD::OPC_Decode, 221, 16, 33, // Opcode: MOVE16_MMR6, DecodeIdx: 33
/* 40 */      MCD::OPC_FilterValue, 9, 21, 0, // Skip to: 65
/* 44 */      MCD::OPC_ExtractField, 0, 1,  // Inst{0} ...
/* 47 */      MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 57
/* 51 */      MCD::OPC_CheckPredicateOrFail, 24, 
/* 53 */      MCD::OPC_Decode, 179, 20, 34, // Opcode: SLL16_MMR6, DecodeIdx: 34
/* 57 */      MCD::OPC_FilterValueOrFail, 1, 
/* 59 */      MCD::OPC_CheckPredicateOrFail, 24, 
/* 61 */      MCD::OPC_Decode, 238, 20, 34, // Opcode: SRL16_MMR6, DecodeIdx: 34
/* 65 */      MCD::OPC_FilterValue, 11, 6, 0, // Skip to: 75
/* 69 */      MCD::OPC_CheckPredicateOrFail, 24, 
/* 71 */      MCD::OPC_Decode, 222, 6, 35, // Opcode: ANDI16_MMR6, DecodeIdx: 35
/* 75 */      MCD::OPC_FilterValue, 17, 160, 0, // Skip to: 239
/* 79 */      MCD::OPC_ExtractField, 2, 1,  // Inst{2} ...
/* 82 */      MCD::OPC_FilterValue, 0, 145, 0, // Skip to: 231
/* 86 */      MCD::OPC_ExtractField, 0, 2,  // Inst{1-0} ...
/* 89 */      MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 116
/* 93 */      MCD::OPC_ExtractField, 3, 1,  // Inst{3} ...
/* 96 */      MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 107
/* 100 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 102 */     MCD::OPC_Decode, 153, 18, 148, 1, // Opcode: NOT16_MMR6, DecodeIdx: 148
/* 107 */     MCD::OPC_FilterValueOrFail, 1, 
/* 109 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 111 */     MCD::OPC_Decode, 212, 22, 149, 1, // Opcode: XOR16_MMR6, DecodeIdx: 149
/* 116 */     MCD::OPC_FilterValue, 1, 23, 0, // Skip to: 143
/* 120 */     MCD::OPC_ExtractField, 3, 1,  // Inst{3} ...
/* 123 */     MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 134
/* 127 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 129 */     MCD::OPC_Decode, 219, 6, 149, 1, // Opcode: AND16_MMR6, DecodeIdx: 149
/* 134 */     MCD::OPC_FilterValueOrFail, 1, 
/* 136 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 138 */     MCD::OPC_Decode, 158, 18, 149, 1, // Opcode: OR16_MMR6, DecodeIdx: 149
/* 143 */     MCD::OPC_FilterValue, 2, 21, 0, // Skip to: 168
/* 147 */     MCD::OPC_ExtractField, 3, 1,  // Inst{3} ...
/* 150 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 160
/* 154 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 156 */     MCD::OPC_Decode, 182, 15, 38, // Opcode: LWM16_MMR6, DecodeIdx: 38
/* 160 */     MCD::OPC_FilterValueOrFail, 1, 
/* 162 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 164 */     MCD::OPC_Decode, 218, 21, 38, // Opcode: SWM16_MMR6, DecodeIdx: 38
/* 168 */     MCD::OPC_FilterValueOrFail, 3, 
/* 170 */     MCD::OPC_ExtractField, 3, 2,  // Inst{4-3} ...
/* 173 */     MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 184
/* 177 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 179 */     MCD::OPC_Decode, 200, 14, 150, 1, // Opcode: JRC16_MMR6, DecodeIdx: 150
/* 184 */     MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 195
/* 188 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 190 */     MCD::OPC_Decode, 177, 14, 150, 1, // Opcode: JALRC16_MMR6, DecodeIdx: 150
/* 195 */     MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 206
/* 199 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 201 */     MCD::OPC_Decode, 201, 14, 151, 1, // Opcode: JRCADDIUSP_MMR6, DecodeIdx: 151
/* 206 */     MCD::OPC_FilterValueOrFail, 3, 
/* 208 */     MCD::OPC_ExtractField, 5, 1,  // Inst{5} ...
/* 211 */     MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 222
/* 215 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 217 */     MCD::OPC_Decode, 182, 8, 152, 1, // Opcode: BREAK16_MMR6, DecodeIdx: 152
/* 222 */     MCD::OPC_FilterValueOrFail, 1, 
/* 224 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 226 */     MCD::OPC_Decode, 191, 19, 152, 1, // Opcode: SDBBP16_MMR6, DecodeIdx: 152
/* 231 */     MCD::OPC_FilterValueOrFail, 1, 
/* 233 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 235 */     MCD::OPC_Decode, 223, 16, 48, // Opcode: MOVEP_MMR6, DecodeIdx: 48
/* 239 */     MCD::OPC_FilterValue, 34, 6, 0, // Skip to: 249
/* 243 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 245 */     MCD::OPC_Decode, 172, 19, 32, // Opcode: SB16_MMR6, DecodeIdx: 32
/* 249 */     MCD::OPC_FilterValue, 35, 6, 0, // Skip to: 259
/* 253 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 255 */     MCD::OPC_Decode, 188, 7, 49, // Opcode: BEQZC16_MMR6, DecodeIdx: 49
/* 259 */     MCD::OPC_FilterValue, 42, 6, 0, // Skip to: 269
/* 263 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 265 */     MCD::OPC_Decode, 238, 19, 32, // Opcode: SH16_MMR6, DecodeIdx: 32
/* 269 */     MCD::OPC_FilterValue, 43, 6, 0, // Skip to: 279
/* 273 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 275 */     MCD::OPC_Decode, 163, 8, 49, // Opcode: BNEZC16_MMR6, DecodeIdx: 49
/* 279 */     MCD::OPC_FilterValue, 50, 6, 0, // Skip to: 289
/* 283 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 285 */     MCD::OPC_Decode, 227, 21, 42, // Opcode: SWSP_MMR6, DecodeIdx: 42
/* 289 */     MCD::OPC_FilterValue, 51, 6, 0, // Skip to: 299
/* 293 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 295 */     MCD::OPC_Decode, 154, 7, 50, // Opcode: BC16_MMR6, DecodeIdx: 50
/* 299 */     MCD::OPC_FilterValue, 58, 6, 0, // Skip to: 309
/* 303 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 305 */     MCD::OPC_Decode, 200, 21, 32, // Opcode: SW16_MMR6, DecodeIdx: 32
/* 309 */     MCD::OPC_FilterValueOrFail, 59, 
/* 311 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 313 */     MCD::OPC_Decode, 141, 15, 51, // Opcode: LI16_MMR6, DecodeIdx: 51
/* 317 */     MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableMicroMipsR632[] = {
/* 0 */       MCD::OPC_ExtractField, 26, 6,  // Inst{31-26} ...
/* 3 */       MCD::OPC_FilterValue, 0, 8, 3, // Skip to: 783
/* 7 */       MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 10 */      MCD::OPC_FilterValue, 0, 85, 0, // Skip to: 99
/* 14 */      MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 17 */      MCD::OPC_FilterValue, 0, 45, 0, // Skip to: 66
/* 21 */      MCD::OPC_ExtractField, 11, 15,  // Inst{25-11} ...
/* 24 */      MCD::OPC_FilterValue, 1, 8, 0, // Skip to: 36
/* 28 */      MCD::OPC_CheckPredicate, 24, 28, 0, // Skip to: 60
/* 32 */      MCD::OPC_Decode, 132, 21, 10, // Opcode: SSNOP_MMR6, DecodeIdx: 10
/* 36 */      MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 48
/* 40 */      MCD::OPC_CheckPredicate, 24, 16, 0, // Skip to: 60
/* 44 */      MCD::OPC_Decode, 158, 12, 10, // Opcode: EHB_MMR6, DecodeIdx: 10
/* 48 */      MCD::OPC_FilterValue, 5, 8, 0, // Skip to: 60
/* 52 */      MCD::OPC_CheckPredicate, 24, 4, 0, // Skip to: 60
/* 56 */      MCD::OPC_Decode, 173, 18, 10, // Opcode: PAUSE_MMR6, DecodeIdx: 10
/* 60 */      MCD::OPC_CheckPredicateOrFail, 24, 
/* 62 */      MCD::OPC_Decode, 192, 20, 52, // Opcode: SLL_MMR6, DecodeIdx: 52
/* 66 */      MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 76
/* 70 */      MCD::OPC_CheckPredicateOrFail, 24, 
/* 72 */      MCD::OPC_Decode, 220, 19, 55, // Opcode: SELEQZ_MMR6, DecodeIdx: 55
/* 76 */      MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 86
/* 80 */      MCD::OPC_CheckPredicateOrFail, 24, 
/* 82 */      MCD::OPC_Decode, 227, 19, 55, // Opcode: SELNEZ_MMR6, DecodeIdx: 55
/* 86 */      MCD::OPC_FilterValueOrFail, 7, 
/* 88 */      MCD::OPC_CheckPredicateOrFail, 24, 
/* 90 */      MCD::OPC_CheckFieldOrFail, 14, 2, 0, 
/* 94 */      MCD::OPC_Decode, 245, 18, 153, 1, // Opcode: RDHWR_MMR6, DecodeIdx: 153
/* 99 */      MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 109
/* 103 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 105 */     MCD::OPC_Decode, 184, 8, 56, // Opcode: BREAK_MMR6, DecodeIdx: 56
/* 109 */     MCD::OPC_FilterValue, 12, 6, 0, // Skip to: 119
/* 113 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 115 */     MCD::OPC_Decode, 171, 14, 57, // Opcode: INS_MMR6, DecodeIdx: 57
/* 119 */     MCD::OPC_FilterValue, 15, 11, 0, // Skip to: 134
/* 123 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 125 */     MCD::OPC_CheckFieldOrFail, 6, 3, 0, 
/* 129 */     MCD::OPC_Decode, 153, 15, 154, 1, // Opcode: LSA_MMR6, DecodeIdx: 154
/* 134 */     MCD::OPC_FilterValue, 16, 95, 0, // Skip to: 233
/* 138 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 141 */     MCD::OPC_FilterValue, 1, 10, 0, // Skip to: 155
/* 145 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 147 */     MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 151 */     MCD::OPC_Decode, 158, 9, 25, // Opcode: CLZ_MMR6, DecodeIdx: 25
/* 155 */     MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 165
/* 159 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 161 */     MCD::OPC_Decode, 206, 6, 55, // Opcode: ADD_MMR6, DecodeIdx: 55
/* 165 */     MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 175
/* 169 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 171 */     MCD::OPC_Decode, 182, 6, 55, // Opcode: ADDU_MMR6, DecodeIdx: 55
/* 175 */     MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 185
/* 179 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 181 */     MCD::OPC_Decode, 192, 21, 55, // Opcode: SUB_MMR6, DecodeIdx: 55
/* 185 */     MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 195
/* 189 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 191 */     MCD::OPC_Decode, 174, 21, 55, // Opcode: SUBU_MMR6, DecodeIdx: 55
/* 195 */     MCD::OPC_FilterValue, 9, 6, 0, // Skip to: 205
/* 199 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 201 */     MCD::OPC_Decode, 226, 6, 55, // Opcode: AND_MMR6, DecodeIdx: 55
/* 205 */     MCD::OPC_FilterValue, 10, 6, 0, // Skip to: 215
/* 209 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 211 */     MCD::OPC_Decode, 163, 18, 55, // Opcode: OR_MMR6, DecodeIdx: 55
/* 215 */     MCD::OPC_FilterValue, 11, 6, 0, // Skip to: 225
/* 219 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 221 */     MCD::OPC_Decode, 150, 18, 55, // Opcode: NOR_MMR6, DecodeIdx: 55
/* 225 */     MCD::OPC_FilterValueOrFail, 12, 
/* 227 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 229 */     MCD::OPC_Decode, 217, 22, 55, // Opcode: XOR_MMR6, DecodeIdx: 55
/* 233 */     MCD::OPC_FilterValue, 24, 81, 0, // Skip to: 318
/* 237 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 240 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 250
/* 244 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 246 */     MCD::OPC_Decode, 243, 17, 55, // Opcode: MUL_MMR6, DecodeIdx: 55
/* 250 */     MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 260
/* 254 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 256 */     MCD::OPC_Decode, 203, 17, 55, // Opcode: MUH_MMR6, DecodeIdx: 55
/* 260 */     MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 270
/* 264 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 266 */     MCD::OPC_Decode, 237, 17, 55, // Opcode: MULU_MMR6, DecodeIdx: 55
/* 270 */     MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 280
/* 274 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 276 */     MCD::OPC_Decode, 202, 17, 55, // Opcode: MUHU_MMR6, DecodeIdx: 55
/* 280 */     MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 290
/* 284 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 286 */     MCD::OPC_Decode, 176, 11, 55, // Opcode: DIV_MMR6, DecodeIdx: 55
/* 290 */     MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 300
/* 294 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 296 */     MCD::OPC_Decode, 211, 16, 55, // Opcode: MOD_MMR6, DecodeIdx: 55
/* 300 */     MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 310
/* 304 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 306 */     MCD::OPC_Decode, 175, 11, 55, // Opcode: DIVU_MMR6, DecodeIdx: 55
/* 310 */     MCD::OPC_FilterValueOrFail, 7, 
/* 312 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 314 */     MCD::OPC_Decode, 210, 16, 55, // Opcode: MODU_MMR6, DecodeIdx: 55
/* 318 */     MCD::OPC_FilterValue, 31, 11, 0, // Skip to: 333
/* 322 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 324 */     MCD::OPC_CheckFieldOrFail, 6, 3, 0, 
/* 328 */     MCD::OPC_Decode, 214, 6, 155, 1, // Opcode: ALIGN_MMR6, DecodeIdx: 155
/* 333 */     MCD::OPC_FilterValue, 44, 6, 0, // Skip to: 343
/* 337 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 339 */     MCD::OPC_Decode, 199, 12, 66, // Opcode: EXT_MMR6, DecodeIdx: 66
/* 343 */     MCD::OPC_FilterValue, 52, 29, 0, // Skip to: 376
/* 347 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 350 */     MCD::OPC_FilterValue, 3, 10, 0, // Skip to: 364
/* 354 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 356 */     MCD::OPC_CheckFieldOrFail, 14, 2, 0, 
/* 360 */     MCD::OPC_Decode, 157, 16, 68, // Opcode: MFHC0_MMR6, DecodeIdx: 68
/* 364 */     MCD::OPC_FilterValueOrFail, 11, 
/* 366 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 368 */     MCD::OPC_CheckFieldOrFail, 14, 2, 0, 
/* 372 */     MCD::OPC_Decode, 173, 17, 69, // Opcode: MTHC0_MMR6, DecodeIdx: 69
/* 376 */     MCD::OPC_FilterValue, 60, 134, 1, // Skip to: 770
/* 380 */     MCD::OPC_ExtractField, 14, 2,  // Inst{15-14} ...
/* 383 */     MCD::OPC_FilterValue, 0, 93, 0, // Skip to: 480
/* 387 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 390 */     MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 400
/* 394 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 396 */     MCD::OPC_Decode, 148, 16, 68, // Opcode: MFC0_MMR6, DecodeIdx: 68
/* 400 */     MCD::OPC_FilterValue, 5, 29, 0, // Skip to: 433
/* 404 */     MCD::OPC_ExtractField, 11, 3,  // Inst{13-11} ...
/* 407 */     MCD::OPC_FilterValue, 3, 10, 0, // Skip to: 421
/* 411 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 413 */     MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 417 */     MCD::OPC_Decode, 153, 12, 92, // Opcode: DVP_MMR6, DecodeIdx: 92
/* 421 */     MCD::OPC_FilterValueOrFail, 7, 
/* 423 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 425 */     MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 429 */     MCD::OPC_Decode, 170, 12, 92, // Opcode: EVP_MMR6, DecodeIdx: 92
/* 433 */     MCD::OPC_FilterValue, 11, 6, 0, // Skip to: 443
/* 437 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 439 */     MCD::OPC_Decode, 163, 17, 69, // Opcode: MTC0_MMR6, DecodeIdx: 69
/* 443 */     MCD::OPC_FilterValue, 12, 10, 0, // Skip to: 457
/* 447 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 449 */     MCD::OPC_CheckFieldOrFail, 11, 3, 1, 
/* 453 */     MCD::OPC_Decode, 240, 7, 86, // Opcode: BITSWAP_MMR6, DecodeIdx: 86
/* 457 */     MCD::OPC_FilterValueOrFail, 28, 
/* 459 */     MCD::OPC_ExtractField, 11, 3,  // Inst{13-11} ...
/* 462 */     MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 472
/* 466 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 468 */     MCD::OPC_Decode, 179, 14, 80, // Opcode: JALRC_MMR6, DecodeIdx: 80
/* 472 */     MCD::OPC_FilterValueOrFail, 3, 
/* 474 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 476 */     MCD::OPC_Decode, 178, 14, 80, // Opcode: JALRC_HB_MMR6, DecodeIdx: 80
/* 480 */     MCD::OPC_FilterValue, 1, 175, 0, // Skip to: 659
/* 484 */     MCD::OPC_ExtractField, 11, 3,  // Inst{13-11} ...
/* 487 */     MCD::OPC_FilterValue, 0, 29, 0, // Skip to: 520
/* 491 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 494 */     MCD::OPC_FilterValue, 13, 10, 0, // Skip to: 508
/* 498 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 500 */     MCD::OPC_CheckFieldOrFail, 16, 10, 0, 
/* 504 */     MCD::OPC_Decode, 160, 22, 10, // Opcode: TLBINV_MMR6, DecodeIdx: 10
/* 508 */     MCD::OPC_FilterValueOrFail, 29, 
/* 510 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 512 */     MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 516 */     MCD::OPC_Decode, 186, 11, 92, // Opcode: DI_MMR6, DecodeIdx: 92
/* 520 */     MCD::OPC_FilterValue, 1, 21, 0, // Skip to: 545
/* 524 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 527 */     MCD::OPC_FilterValue, 12, 6, 0, // Skip to: 537
/* 531 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 533 */     MCD::OPC_Decode, 138, 9, 80, // Opcode: CLO_MMR6, DecodeIdx: 80
/* 537 */     MCD::OPC_FilterValueOrFail, 20, 
/* 539 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 541 */     MCD::OPC_Decode, 154, 16, 90, // Opcode: MFC2_MMR6, DecodeIdx: 90
/* 545 */     MCD::OPC_FilterValue, 2, 29, 0, // Skip to: 578
/* 549 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 552 */     MCD::OPC_FilterValue, 13, 10, 0, // Skip to: 566
/* 556 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 558 */     MCD::OPC_CheckFieldOrFail, 16, 10, 0, 
/* 562 */     MCD::OPC_Decode, 159, 22, 10, // Opcode: TLBINVF_MMR6, DecodeIdx: 10
/* 566 */     MCD::OPC_FilterValueOrFail, 29, 
/* 568 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 570 */     MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 574 */     MCD::OPC_Decode, 161, 12, 92, // Opcode: EI_MMR6, DecodeIdx: 92
/* 578 */     MCD::OPC_FilterValue, 3, 10, 0, // Skip to: 592
/* 582 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 584 */     MCD::OPC_CheckFieldOrFail, 6, 5, 20, 
/* 588 */     MCD::OPC_Decode, 170, 17, 91, // Opcode: MTC2_MMR6, DecodeIdx: 91
/* 592 */     MCD::OPC_FilterValue, 4, 14, 0, // Skip to: 610
/* 596 */     MCD::OPC_CheckPredicateOrFail, 25, 
/* 598 */     MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 602 */     MCD::OPC_CheckFieldOrFail, 6, 5, 5, 
/* 606 */     MCD::OPC_Decode, 254, 13, 92, // Opcode: GINVI_MMR6, DecodeIdx: 92
/* 610 */     MCD::OPC_FilterValue, 5, 14, 0, // Skip to: 628
/* 614 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 616 */     MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 620 */     MCD::OPC_CheckFieldOrFail, 6, 5, 13, 
/* 624 */     MCD::OPC_Decode, 237, 21, 87, // Opcode: SYNC_MMR6, DecodeIdx: 87
/* 628 */     MCD::OPC_FilterValue, 6, 15, 0, // Skip to: 647
/* 632 */     MCD::OPC_CheckPredicateOrFail, 25, 
/* 634 */     MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 638 */     MCD::OPC_CheckFieldOrFail, 6, 3, 5, 
/* 642 */     MCD::OPC_Decode, 128, 14, 156, 1, // Opcode: GINVT_MMR6, DecodeIdx: 156
/* 647 */     MCD::OPC_FilterValueOrFail, 7, 
/* 649 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 651 */     MCD::OPC_CheckFieldOrFail, 6, 5, 12, 
/* 655 */     MCD::OPC_Decode, 209, 22, 80, // Opcode: WSBH_MMR6, DecodeIdx: 80
/* 659 */     MCD::OPC_FilterValue, 2, 31, 0, // Skip to: 694
/* 663 */     MCD::OPC_ExtractField, 6, 8,  // Inst{13-6} ...
/* 666 */     MCD::OPC_FilterValue, 52, 6, 0, // Skip to: 676
/* 670 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 672 */     MCD::OPC_Decode, 162, 16, 90, // Opcode: MFHC2_MMR6, DecodeIdx: 90
/* 676 */     MCD::OPC_FilterValue, 77, 6, 0, // Skip to: 686
/* 680 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 682 */     MCD::OPC_Decode, 203, 22, 88, // Opcode: WAIT_MMR6, DecodeIdx: 88
/* 686 */     MCD::OPC_FilterValueOrFail, 116, 
/* 688 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 690 */     MCD::OPC_Decode, 178, 17, 91, // Opcode: MTHC2_MMR6, DecodeIdx: 91
/* 694 */     MCD::OPC_FilterValueOrFail, 3, 
/* 696 */     MCD::OPC_ExtractField, 6, 8,  // Inst{13-6} ...
/* 699 */     MCD::OPC_FilterValue, 109, 6, 0, // Skip to: 709
/* 703 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 705 */     MCD::OPC_Decode, 193, 19, 88, // Opcode: SDBBP_MMR6, DecodeIdx: 88
/* 709 */     MCD::OPC_FilterValue, 133, 1, 6, 0, // Skip to: 720
/* 714 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 716 */     MCD::OPC_Decode, 246, 18, 80, // Opcode: RDPGPR_MMR6, DecodeIdx: 80
/* 720 */     MCD::OPC_FilterValue, 141, 1, 10, 0, // Skip to: 735
/* 725 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 727 */     MCD::OPC_CheckFieldOrFail, 16, 10, 0, 
/* 731 */     MCD::OPC_Decode, 164, 11, 10, // Opcode: DERET_MMR6, DecodeIdx: 10
/* 735 */     MCD::OPC_FilterValue, 197, 1, 6, 0, // Skip to: 746
/* 740 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 742 */     MCD::OPC_Decode, 206, 22, 80, // Opcode: WRPGPR_MMR6, DecodeIdx: 80
/* 746 */     MCD::OPC_FilterValueOrFail, 205, 1, 
/* 749 */     MCD::OPC_ExtractField, 16, 10,  // Inst{25-16} ...
/* 752 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 762
/* 756 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 758 */     MCD::OPC_Decode, 167, 12, 10, // Opcode: ERET_MMR6, DecodeIdx: 10
/* 762 */     MCD::OPC_FilterValueOrFail, 1, 
/* 764 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 766 */     MCD::OPC_Decode, 165, 12, 10, // Opcode: ERETNC_MMR6, DecodeIdx: 10
/* 770 */     MCD::OPC_FilterValueOrFail, 63, 
/* 772 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 774 */     MCD::OPC_CheckFieldOrFail, 22, 4, 0, 
/* 778 */     MCD::OPC_Decode, 168, 20, 157, 1, // Opcode: SIGRIE_MMR6, DecodeIdx: 157
/* 783 */     MCD::OPC_FilterValue, 4, 21, 0, // Skip to: 808
/* 787 */     MCD::OPC_CheckPredicate, 24, 11, 0, // Skip to: 802
/* 791 */     MCD::OPC_CheckField, 16, 5, 0, 5, 0, // Skip to: 802
/* 797 */     MCD::OPC_Decode, 155, 15, 158, 1, // Opcode: LUI_MMR6, DecodeIdx: 158
/* 802 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 804 */     MCD::OPC_Decode, 244, 6, 108, // Opcode: AUI_MMR6, DecodeIdx: 108
/* 808 */     MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 819
/* 812 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 814 */     MCD::OPC_Decode, 221, 14, 159, 1, // Opcode: LBU_MMR6, DecodeIdx: 159
/* 819 */     MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 829
/* 823 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 825 */     MCD::OPC_Decode, 177, 19, 98, // Opcode: SB_MMR6, DecodeIdx: 98
/* 829 */     MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 840
/* 833 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 835 */     MCD::OPC_Decode, 223, 14, 159, 1, // Opcode: LB_MMR6, DecodeIdx: 159
/* 840 */     MCD::OPC_FilterValue, 8, 71, 0, // Skip to: 915
/* 844 */     MCD::OPC_ExtractField, 12, 4,  // Inst{15-12} ...
/* 847 */     MCD::OPC_FilterValue, 0, 11, 0, // Skip to: 862
/* 851 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 853 */     MCD::OPC_CheckFieldOrFail, 11, 1, 0, 
/* 857 */     MCD::OPC_Decode, 168, 15, 160, 1, // Opcode: LWC2_MMR6, DecodeIdx: 160
/* 862 */     MCD::OPC_FilterValue, 2, 11, 0, // Skip to: 877
/* 866 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 868 */     MCD::OPC_CheckFieldOrFail, 11, 1, 0, 
/* 872 */     MCD::OPC_Decode, 236, 14, 160, 1, // Opcode: LDC2_MMR6, DecodeIdx: 160
/* 877 */     MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 887
/* 881 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 883 */     MCD::OPC_Decode, 215, 8, 100, // Opcode: CACHE_MMR6, DecodeIdx: 100
/* 887 */     MCD::OPC_FilterValue, 8, 11, 0, // Skip to: 902
/* 891 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 893 */     MCD::OPC_CheckFieldOrFail, 11, 1, 0, 
/* 897 */     MCD::OPC_Decode, 205, 21, 160, 1, // Opcode: SWC2_MMR6, DecodeIdx: 160
/* 902 */     MCD::OPC_FilterValueOrFail, 10, 
/* 904 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 906 */     MCD::OPC_CheckFieldOrFail, 11, 1, 0, 
/* 910 */     MCD::OPC_Decode, 201, 19, 160, 1, // Opcode: SDC2_MMR6, DecodeIdx: 160
/* 915 */     MCD::OPC_FilterValue, 12, 6, 0, // Skip to: 925
/* 919 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 921 */     MCD::OPC_Decode, 146, 6, 97, // Opcode: ADDIU_MMR6, DecodeIdx: 97
/* 925 */     MCD::OPC_FilterValue, 14, 6, 0, // Skip to: 935
/* 929 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 931 */     MCD::OPC_Decode, 166, 20, 98, // Opcode: SH_MMR6, DecodeIdx: 98
/* 935 */     MCD::OPC_FilterValue, 16, 56, 0, // Skip to: 995
/* 939 */     MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 942 */     MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 953
/* 946 */     MCD::OPC_CheckPredicateOrFail, 26, 
/* 948 */     MCD::OPC_Decode, 156, 7, 161, 1, // Opcode: BC1EQZC_MMR6, DecodeIdx: 161
/* 953 */     MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 964
/* 957 */     MCD::OPC_CheckPredicateOrFail, 26, 
/* 959 */     MCD::OPC_Decode, 161, 7, 161, 1, // Opcode: BC1NEZC_MMR6, DecodeIdx: 161
/* 964 */     MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 975
/* 968 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 970 */     MCD::OPC_Decode, 166, 7, 162, 1, // Opcode: BC2EQZC_MMR6, DecodeIdx: 162
/* 975 */     MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 986
/* 979 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 981 */     MCD::OPC_Decode, 168, 7, 162, 1, // Opcode: BC2NEZC_MMR6, DecodeIdx: 162
/* 986 */     MCD::OPC_FilterValueOrFail, 12, 
/* 988 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 990 */     MCD::OPC_Decode, 235, 21, 163, 1, // Opcode: SYNCI_MMR6, DecodeIdx: 163
/* 995 */     MCD::OPC_FilterValue, 20, 6, 0, // Skip to: 1005
/* 999 */     MCD::OPC_CheckPredicateOrFail, 24, 
/* 1001 */    MCD::OPC_Decode, 161, 18, 108, // Opcode: ORI_MMR6, DecodeIdx: 108
/* 1005 */    MCD::OPC_FilterValue, 21, 230, 3, // Skip to: 2007
/* 1009 */    MCD::OPC_ExtractField, 0, 11,  // Inst{10-0} ...
/* 1012 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 1023
/* 1016 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1018 */    MCD::OPC_Decode, 200, 16, 164, 1, // Opcode: MIN_S_MMR6, DecodeIdx: 164
/* 1023 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 1034
/* 1027 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1029 */    MCD::OPC_Decode, 179, 9, 165, 1, // Opcode: CMP_AF_S_MMR6, DecodeIdx: 165
/* 1034 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 1045
/* 1038 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1040 */    MCD::OPC_Decode, 141, 16, 164, 1, // Opcode: MAX_S_MMR6, DecodeIdx: 164
/* 1045 */    MCD::OPC_FilterValue, 21, 7, 0, // Skip to: 1056
/* 1049 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1051 */    MCD::OPC_Decode, 178, 9, 166, 1, // Opcode: CMP_AF_D_MMR6, DecodeIdx: 166
/* 1056 */    MCD::OPC_FilterValue, 32, 11, 0, // Skip to: 1071
/* 1060 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 1062 */    MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 1066 */    MCD::OPC_Decode, 136, 19, 167, 1, // Opcode: RINT_S_MMR6, DecodeIdx: 167
/* 1071 */    MCD::OPC_FilterValue, 35, 7, 0, // Skip to: 1082
/* 1075 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1077 */    MCD::OPC_Decode, 181, 16, 164, 1, // Opcode: MINA_S_MMR6, DecodeIdx: 164
/* 1082 */    MCD::OPC_FilterValue, 43, 7, 0, // Skip to: 1093
/* 1086 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1088 */    MCD::OPC_Decode, 250, 15, 164, 1, // Opcode: MAXA_S_MMR6, DecodeIdx: 164
/* 1093 */    MCD::OPC_FilterValue, 48, 7, 0, // Skip to: 1104
/* 1097 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1099 */    MCD::OPC_Decode, 214, 12, 168, 1, // Opcode: FADD_S_MMR6, DecodeIdx: 168
/* 1104 */    MCD::OPC_FilterValue, 56, 7, 0, // Skip to: 1115
/* 1108 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 1110 */    MCD::OPC_Decode, 222, 19, 164, 1, // Opcode: SELEQZ_S_MMR6, DecodeIdx: 164
/* 1115 */    MCD::OPC_FilterValue, 59, 21, 0, // Skip to: 1140
/* 1119 */    MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 1122 */    MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 1132
/* 1126 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1128 */    MCD::OPC_Decode, 152, 16, 119, // Opcode: MFC1_MMR6, DecodeIdx: 119
/* 1132 */    MCD::OPC_FilterValueOrFail, 5, 
/* 1134 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1136 */    MCD::OPC_Decode, 168, 17, 125, // Opcode: MTC1_MMR6, DecodeIdx: 125
/* 1140 */    MCD::OPC_FilterValue, 69, 7, 0, // Skip to: 1151
/* 1144 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1146 */    MCD::OPC_Decode, 247, 9, 165, 1, // Opcode: CMP_UN_S_MMR6, DecodeIdx: 165
/* 1151 */    MCD::OPC_FilterValue, 85, 7, 0, // Skip to: 1162
/* 1155 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1157 */    MCD::OPC_Decode, 245, 9, 166, 1, // Opcode: CMP_UN_D_MMR6, DecodeIdx: 166
/* 1162 */    MCD::OPC_FilterValue, 96, 11, 0, // Skip to: 1177
/* 1166 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 1168 */    MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 1172 */    MCD::OPC_Decode, 247, 8, 167, 1, // Opcode: CLASS_S_MMR6, DecodeIdx: 167
/* 1177 */    MCD::OPC_FilterValue, 112, 7, 0, // Skip to: 1188
/* 1181 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1183 */    MCD::OPC_Decode, 231, 13, 168, 1, // Opcode: FSUB_S_MMR6, DecodeIdx: 168
/* 1188 */    MCD::OPC_FilterValue, 120, 7, 0, // Skip to: 1199
/* 1192 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 1194 */    MCD::OPC_Decode, 229, 19, 164, 1, // Opcode: SELNEZ_S_MMR6, DecodeIdx: 164
/* 1199 */    MCD::OPC_FilterValue, 123, 21, 0, // Skip to: 1224
/* 1203 */    MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 1206 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 1216
/* 1210 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1212 */    MCD::OPC_Decode, 176, 13, 124, // Opcode: FMOV_S_MMR6, DecodeIdx: 124
/* 1216 */    MCD::OPC_FilterValueOrFail, 4, 
/* 1218 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1220 */    MCD::OPC_Decode, 173, 13, 122, // Opcode: FMOV_D_MMR6, DecodeIdx: 122
/* 1224 */    MCD::OPC_FilterValue, 133, 1, 7, 0, // Skip to: 1236
/* 1229 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1231 */    MCD::OPC_Decode, 185, 9, 165, 1, // Opcode: CMP_EQ_S_MMR6, DecodeIdx: 165
/* 1236 */    MCD::OPC_FilterValue, 149, 1, 7, 0, // Skip to: 1248
/* 1241 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1243 */    MCD::OPC_Decode, 181, 9, 166, 1, // Opcode: CMP_EQ_D_MMR6, DecodeIdx: 166
/* 1248 */    MCD::OPC_FilterValue, 176, 1, 7, 0, // Skip to: 1260
/* 1253 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1255 */    MCD::OPC_Decode, 187, 13, 168, 1, // Opcode: FMUL_S_MMR6, DecodeIdx: 168
/* 1260 */    MCD::OPC_FilterValue, 184, 1, 7, 0, // Skip to: 1272
/* 1265 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 1267 */    MCD::OPC_Decode, 233, 19, 169, 1, // Opcode: SEL_S_MMR6, DecodeIdx: 169
/* 1272 */    MCD::OPC_FilterValue, 197, 1, 7, 0, // Skip to: 1284
/* 1277 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1279 */    MCD::OPC_Decode, 235, 9, 165, 1, // Opcode: CMP_UEQ_S_MMR6, DecodeIdx: 165
/* 1284 */    MCD::OPC_FilterValue, 213, 1, 7, 0, // Skip to: 1296
/* 1289 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1291 */    MCD::OPC_Decode, 233, 9, 166, 1, // Opcode: CMP_UEQ_D_MMR6, DecodeIdx: 166
/* 1296 */    MCD::OPC_FilterValue, 240, 1, 7, 0, // Skip to: 1308
/* 1301 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1303 */    MCD::OPC_Decode, 252, 12, 168, 1, // Opcode: FDIV_S_MMR6, DecodeIdx: 168
/* 1308 */    MCD::OPC_FilterValue, 133, 2, 7, 0, // Skip to: 1320
/* 1313 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1315 */    MCD::OPC_Decode, 199, 9, 165, 1, // Opcode: CMP_LT_S_MMR6, DecodeIdx: 165
/* 1320 */    MCD::OPC_FilterValue, 149, 2, 7, 0, // Skip to: 1332
/* 1325 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1327 */    MCD::OPC_Decode, 195, 9, 166, 1, // Opcode: CMP_LT_D_MMR6, DecodeIdx: 166
/* 1332 */    MCD::OPC_FilterValue, 187, 2, 31, 0, // Skip to: 1368
/* 1337 */    MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 1340 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 1350
/* 1344 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1346 */    MCD::OPC_Decode, 154, 10, 121, // Opcode: CVT_L_S_MMR6, DecodeIdx: 121
/* 1350 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 1360
/* 1354 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1356 */    MCD::OPC_Decode, 175, 10, 124, // Opcode: CVT_W_S_MMR6, DecodeIdx: 124
/* 1360 */    MCD::OPC_FilterValueOrFail, 8, 
/* 1362 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1364 */    MCD::OPC_Decode, 151, 10, 122, // Opcode: CVT_L_D_MMR6, DecodeIdx: 122
/* 1368 */    MCD::OPC_FilterValue, 197, 2, 7, 0, // Skip to: 1380
/* 1373 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1375 */    MCD::OPC_Decode, 243, 9, 165, 1, // Opcode: CMP_ULT_S_MMR6, DecodeIdx: 165
/* 1380 */    MCD::OPC_FilterValue, 213, 2, 7, 0, // Skip to: 1392
/* 1385 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1387 */    MCD::OPC_Decode, 241, 9, 166, 1, // Opcode: CMP_ULT_D_MMR6, DecodeIdx: 166
/* 1392 */    MCD::OPC_FilterValue, 133, 3, 7, 0, // Skip to: 1404
/* 1397 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1399 */    MCD::OPC_Decode, 193, 9, 165, 1, // Opcode: CMP_LE_S_MMR6, DecodeIdx: 165
/* 1404 */    MCD::OPC_FilterValue, 149, 3, 7, 0, // Skip to: 1416
/* 1409 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1411 */    MCD::OPC_Decode, 189, 9, 166, 1, // Opcode: CMP_LE_D_MMR6, DecodeIdx: 166
/* 1416 */    MCD::OPC_FilterValue, 184, 3, 7, 0, // Skip to: 1428
/* 1421 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1423 */    MCD::OPC_Decode, 218, 15, 170, 1, // Opcode: MADDF_S_MMR6, DecodeIdx: 170
/* 1428 */    MCD::OPC_FilterValue, 197, 3, 7, 0, // Skip to: 1440
/* 1433 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1435 */    MCD::OPC_Decode, 239, 9, 165, 1, // Opcode: CMP_ULE_S_MMR6, DecodeIdx: 165
/* 1440 */    MCD::OPC_FilterValue, 213, 3, 7, 0, // Skip to: 1452
/* 1445 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1447 */    MCD::OPC_Decode, 237, 9, 166, 1, // Opcode: CMP_ULE_D_MMR6, DecodeIdx: 166
/* 1452 */    MCD::OPC_FilterValue, 248, 3, 7, 0, // Skip to: 1464
/* 1457 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1459 */    MCD::OPC_Decode, 141, 17, 170, 1, // Opcode: MSUBF_S_MMR6, DecodeIdx: 170
/* 1464 */    MCD::OPC_FilterValue, 131, 4, 7, 0, // Skip to: 1476
/* 1469 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1471 */    MCD::OPC_Decode, 195, 16, 145, 1, // Opcode: MIN_D_MMR6, DecodeIdx: 145
/* 1476 */    MCD::OPC_FilterValue, 133, 4, 7, 0, // Skip to: 1488
/* 1481 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1483 */    MCD::OPC_Decode, 203, 9, 165, 1, // Opcode: CMP_SAF_S_MMR6, DecodeIdx: 165
/* 1488 */    MCD::OPC_FilterValue, 139, 4, 7, 0, // Skip to: 1500
/* 1493 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1495 */    MCD::OPC_Decode, 136, 16, 145, 1, // Opcode: MAX_D_MMR6, DecodeIdx: 145
/* 1500 */    MCD::OPC_FilterValue, 149, 4, 7, 0, // Skip to: 1512
/* 1505 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1507 */    MCD::OPC_Decode, 201, 9, 166, 1, // Opcode: CMP_SAF_D_MMR6, DecodeIdx: 166
/* 1512 */    MCD::OPC_FilterValue, 160, 4, 11, 0, // Skip to: 1528
/* 1517 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 1519 */    MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 1523 */    MCD::OPC_Decode, 134, 19, 171, 1, // Opcode: RINT_D_MMR6, DecodeIdx: 171
/* 1528 */    MCD::OPC_FilterValue, 163, 4, 7, 0, // Skip to: 1540
/* 1533 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1535 */    MCD::OPC_Decode, 179, 16, 145, 1, // Opcode: MINA_D_MMR6, DecodeIdx: 145
/* 1540 */    MCD::OPC_FilterValue, 171, 4, 7, 0, // Skip to: 1552
/* 1545 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1547 */    MCD::OPC_Decode, 248, 15, 145, 1, // Opcode: MAXA_D_MMR6, DecodeIdx: 145
/* 1552 */    MCD::OPC_FilterValue, 184, 4, 7, 0, // Skip to: 1564
/* 1557 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 1559 */    MCD::OPC_Decode, 219, 19, 145, 1, // Opcode: SELEQZ_D_MMR6, DecodeIdx: 145
/* 1564 */    MCD::OPC_FilterValue, 197, 4, 7, 0, // Skip to: 1576
/* 1569 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1571 */    MCD::OPC_Decode, 231, 9, 165, 1, // Opcode: CMP_SUN_S_MMR6, DecodeIdx: 165
/* 1576 */    MCD::OPC_FilterValue, 213, 4, 7, 0, // Skip to: 1588
/* 1581 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1583 */    MCD::OPC_Decode, 229, 9, 166, 1, // Opcode: CMP_SUN_D_MMR6, DecodeIdx: 166
/* 1588 */    MCD::OPC_FilterValue, 224, 4, 11, 0, // Skip to: 1604
/* 1593 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 1595 */    MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 1599 */    MCD::OPC_Decode, 245, 8, 171, 1, // Opcode: CLASS_D_MMR6, DecodeIdx: 171
/* 1604 */    MCD::OPC_FilterValue, 248, 4, 7, 0, // Skip to: 1616
/* 1609 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 1611 */    MCD::OPC_Decode, 226, 19, 145, 1, // Opcode: SELNEZ_D_MMR6, DecodeIdx: 145
/* 1616 */    MCD::OPC_FilterValue, 133, 5, 7, 0, // Skip to: 1628
/* 1621 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1623 */    MCD::OPC_Decode, 207, 9, 165, 1, // Opcode: CMP_SEQ_S_MMR6, DecodeIdx: 165
/* 1628 */    MCD::OPC_FilterValue, 149, 5, 7, 0, // Skip to: 1640
/* 1633 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1635 */    MCD::OPC_Decode, 205, 9, 166, 1, // Opcode: CMP_SEQ_D_MMR6, DecodeIdx: 166
/* 1640 */    MCD::OPC_FilterValue, 184, 5, 7, 0, // Skip to: 1652
/* 1645 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 1647 */    MCD::OPC_Decode, 231, 19, 172, 1, // Opcode: SEL_D_MMR6, DecodeIdx: 172
/* 1652 */    MCD::OPC_FilterValue, 197, 5, 7, 0, // Skip to: 1664
/* 1657 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1659 */    MCD::OPC_Decode, 219, 9, 165, 1, // Opcode: CMP_SUEQ_S_MMR6, DecodeIdx: 165
/* 1664 */    MCD::OPC_FilterValue, 213, 5, 7, 0, // Skip to: 1676
/* 1669 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1671 */    MCD::OPC_Decode, 217, 9, 166, 1, // Opcode: CMP_SUEQ_D_MMR6, DecodeIdx: 166
/* 1676 */    MCD::OPC_FilterValue, 133, 6, 7, 0, // Skip to: 1688
/* 1681 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1683 */    MCD::OPC_Decode, 215, 9, 165, 1, // Opcode: CMP_SLT_S_MMR6, DecodeIdx: 165
/* 1688 */    MCD::OPC_FilterValue, 149, 6, 7, 0, // Skip to: 1700
/* 1693 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1695 */    MCD::OPC_Decode, 213, 9, 166, 1, // Opcode: CMP_SLT_D_MMR6, DecodeIdx: 166
/* 1700 */    MCD::OPC_FilterValue, 187, 6, 162, 0, // Skip to: 1867
/* 1705 */    MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 1708 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 1718
/* 1712 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1714 */    MCD::OPC_Decode, 151, 13, 121, // Opcode: FLOOR_L_S_MMR6, DecodeIdx: 121
/* 1718 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 1728
/* 1722 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1724 */    MCD::OPC_Decode, 158, 13, 124, // Opcode: FLOOR_W_S_MMR6, DecodeIdx: 124
/* 1728 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 1738
/* 1732 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1734 */    MCD::OPC_Decode, 220, 8, 121, // Opcode: CEIL_L_S_MMR6, DecodeIdx: 121
/* 1738 */    MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 1748
/* 1742 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1744 */    MCD::OPC_Decode, 227, 8, 124, // Opcode: CEIL_W_S_MMR6, DecodeIdx: 124
/* 1748 */    MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 1758
/* 1752 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1754 */    MCD::OPC_Decode, 183, 22, 121, // Opcode: TRUNC_L_S_MMR6, DecodeIdx: 121
/* 1758 */    MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 1768
/* 1762 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1764 */    MCD::OPC_Decode, 190, 22, 124, // Opcode: TRUNC_W_S_MMR6, DecodeIdx: 124
/* 1768 */    MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 1778
/* 1772 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1774 */    MCD::OPC_Decode, 144, 19, 121, // Opcode: ROUND_L_S_MMR6, DecodeIdx: 121
/* 1778 */    MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 1788
/* 1782 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1784 */    MCD::OPC_Decode, 151, 19, 124, // Opcode: ROUND_W_S_MMR6, DecodeIdx: 124
/* 1788 */    MCD::OPC_FilterValue, 8, 6, 0, // Skip to: 1798
/* 1792 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1794 */    MCD::OPC_Decode, 149, 13, 122, // Opcode: FLOOR_L_D_MMR6, DecodeIdx: 122
/* 1798 */    MCD::OPC_FilterValue, 9, 6, 0, // Skip to: 1808
/* 1802 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1804 */    MCD::OPC_Decode, 154, 13, 126, // Opcode: FLOOR_W_D_MMR6, DecodeIdx: 126
/* 1808 */    MCD::OPC_FilterValue, 10, 6, 0, // Skip to: 1818
/* 1812 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1814 */    MCD::OPC_Decode, 218, 8, 122, // Opcode: CEIL_L_D_MMR6, DecodeIdx: 122
/* 1818 */    MCD::OPC_FilterValue, 11, 6, 0, // Skip to: 1828
/* 1822 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1824 */    MCD::OPC_Decode, 223, 8, 126, // Opcode: CEIL_W_D_MMR6, DecodeIdx: 126
/* 1828 */    MCD::OPC_FilterValue, 12, 6, 0, // Skip to: 1838
/* 1832 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1834 */    MCD::OPC_Decode, 181, 22, 122, // Opcode: TRUNC_L_D_MMR6, DecodeIdx: 122
/* 1838 */    MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 1849
/* 1842 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1844 */    MCD::OPC_Decode, 186, 22, 146, 1, // Opcode: TRUNC_W_D_MMR6, DecodeIdx: 146
/* 1849 */    MCD::OPC_FilterValue, 14, 6, 0, // Skip to: 1859
/* 1853 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1855 */    MCD::OPC_Decode, 142, 19, 122, // Opcode: ROUND_L_D_MMR6, DecodeIdx: 122
/* 1859 */    MCD::OPC_FilterValueOrFail, 15, 
/* 1861 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1863 */    MCD::OPC_Decode, 147, 19, 122, // Opcode: ROUND_W_D_MMR6, DecodeIdx: 122
/* 1867 */    MCD::OPC_FilterValue, 197, 6, 7, 0, // Skip to: 1879
/* 1872 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1874 */    MCD::OPC_Decode, 227, 9, 165, 1, // Opcode: CMP_SULT_S_MMR6, DecodeIdx: 165
/* 1879 */    MCD::OPC_FilterValue, 213, 6, 7, 0, // Skip to: 1891
/* 1884 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1886 */    MCD::OPC_Decode, 225, 9, 166, 1, // Opcode: CMP_SULT_D_MMR6, DecodeIdx: 166
/* 1891 */    MCD::OPC_FilterValue, 251, 6, 41, 0, // Skip to: 1937
/* 1896 */    MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 1899 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 1909
/* 1903 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1905 */    MCD::OPC_Decode, 195, 13, 124, // Opcode: FNEG_S_MMR6, DecodeIdx: 124
/* 1909 */    MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 1919
/* 1913 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1915 */    MCD::OPC_Decode, 168, 10, 124, // Opcode: CVT_S_W_MMR6, DecodeIdx: 124
/* 1919 */    MCD::OPC_FilterValue, 10, 6, 0, // Skip to: 1929
/* 1923 */    MCD::OPC_CheckPredicateOrFail, 23, 
/* 1925 */    MCD::OPC_Decode, 148, 10, 122, // Opcode: CVT_D_L_MMR6, DecodeIdx: 122
/* 1929 */    MCD::OPC_FilterValueOrFail, 11, 
/* 1931 */    MCD::OPC_CheckPredicateOrFail, 23, 
/* 1933 */    MCD::OPC_Decode, 163, 10, 121, // Opcode: CVT_S_L_MMR6, DecodeIdx: 121
/* 1937 */    MCD::OPC_FilterValue, 133, 7, 7, 0, // Skip to: 1949
/* 1942 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1944 */    MCD::OPC_Decode, 211, 9, 165, 1, // Opcode: CMP_SLE_S_MMR6, DecodeIdx: 165
/* 1949 */    MCD::OPC_FilterValue, 149, 7, 7, 0, // Skip to: 1961
/* 1954 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1956 */    MCD::OPC_Decode, 209, 9, 166, 1, // Opcode: CMP_SLE_D_MMR6, DecodeIdx: 166
/* 1961 */    MCD::OPC_FilterValue, 184, 7, 7, 0, // Skip to: 1973
/* 1966 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1968 */    MCD::OPC_Decode, 216, 15, 172, 1, // Opcode: MADDF_D_MMR6, DecodeIdx: 172
/* 1973 */    MCD::OPC_FilterValue, 197, 7, 7, 0, // Skip to: 1985
/* 1978 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1980 */    MCD::OPC_Decode, 223, 9, 165, 1, // Opcode: CMP_SULE_S_MMR6, DecodeIdx: 165
/* 1985 */    MCD::OPC_FilterValue, 213, 7, 7, 0, // Skip to: 1997
/* 1990 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 1992 */    MCD::OPC_Decode, 221, 9, 166, 1, // Opcode: CMP_SULE_D_MMR6, DecodeIdx: 166
/* 1997 */    MCD::OPC_FilterValueOrFail, 248, 7, 
/* 2000 */    MCD::OPC_CheckPredicateOrFail, 26, 
/* 2002 */    MCD::OPC_Decode, 139, 17, 172, 1, // Opcode: MSUBF_D_MMR6, DecodeIdx: 172
/* 2007 */    MCD::OPC_FilterValue, 24, 41, 0, // Skip to: 2052
/* 2011 */    MCD::OPC_ExtractField, 12, 4,  // Inst{15-12} ...
/* 2014 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 2024
/* 2018 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2020 */    MCD::OPC_Decode, 232, 18, 100, // Opcode: PREF_MMR6, DecodeIdx: 100
/* 2024 */    MCD::OPC_FilterValue, 3, 11, 0, // Skip to: 2039
/* 2028 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2030 */    MCD::OPC_CheckFieldOrFail, 9, 3, 0, 
/* 2034 */    MCD::OPC_Decode, 150, 15, 134, 1, // Opcode: LL_MMR6, DecodeIdx: 134
/* 2039 */    MCD::OPC_FilterValueOrFail, 11, 
/* 2041 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2043 */    MCD::OPC_CheckFieldOrFail, 9, 3, 0, 
/* 2047 */    MCD::OPC_Decode, 186, 19, 134, 1, // Opcode: SC_MMR6, DecodeIdx: 134
/* 2052 */    MCD::OPC_FilterValue, 28, 6, 0, // Skip to: 2062
/* 2056 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2058 */    MCD::OPC_Decode, 215, 22, 108, // Opcode: XORI_MMR6, DecodeIdx: 108
/* 2062 */    MCD::OPC_FilterValue, 29, 22, 0, // Skip to: 2088
/* 2066 */    MCD::OPC_CheckPredicate, 24, 11, 0, // Skip to: 2081
/* 2070 */    MCD::OPC_CheckField, 16, 5, 0, 5, 0, // Skip to: 2081
/* 2076 */    MCD::OPC_Decode, 186, 7, 173, 1, // Opcode: BEQZALC_MMR6, DecodeIdx: 173
/* 2081 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2083 */    MCD::OPC_Decode, 182, 7, 173, 1, // Opcode: BEQC_MMR6, DecodeIdx: 173
/* 2088 */    MCD::OPC_FilterValue, 30, 50, 0, // Skip to: 2142
/* 2092 */    MCD::OPC_ExtractField, 19, 2,  // Inst{20-19} ...
/* 2095 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 2106
/* 2099 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2101 */    MCD::OPC_Decode, 141, 6, 174, 1, // Opcode: ADDIUPC_MMR6, DecodeIdx: 174
/* 2106 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 2117
/* 2110 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2112 */    MCD::OPC_Decode, 185, 15, 174, 1, // Opcode: LWPC_MMR6, DecodeIdx: 174
/* 2117 */    MCD::OPC_FilterValueOrFail, 3, 
/* 2119 */    MCD::OPC_ExtractField, 16, 3,  // Inst{18-16} ...
/* 2122 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 2133
/* 2126 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2128 */    MCD::OPC_Decode, 243, 6, 175, 1, // Opcode: AUIPC_MMR6, DecodeIdx: 175
/* 2133 */    MCD::OPC_FilterValueOrFail, 7, 
/* 2135 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2137 */    MCD::OPC_Decode, 216, 6, 175, 1, // Opcode: ALUIPC_MMR6, DecodeIdx: 175
/* 2142 */    MCD::OPC_FilterValue, 31, 22, 0, // Skip to: 2168
/* 2146 */    MCD::OPC_CheckPredicate, 24, 11, 0, // Skip to: 2161
/* 2150 */    MCD::OPC_CheckField, 16, 5, 0, 5, 0, // Skip to: 2161
/* 2156 */    MCD::OPC_Decode, 161, 8, 176, 1, // Opcode: BNEZALC_MMR6, DecodeIdx: 176
/* 2161 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2163 */    MCD::OPC_Decode, 149, 8, 176, 1, // Opcode: BNEC_MMR6, DecodeIdx: 176
/* 2168 */    MCD::OPC_FilterValue, 32, 21, 0, // Skip to: 2193
/* 2172 */    MCD::OPC_CheckPredicate, 24, 10, 0, // Skip to: 2186
/* 2176 */    MCD::OPC_CheckField, 21, 5, 0, 4, 0, // Skip to: 2186
/* 2182 */    MCD::OPC_Decode, 191, 14, 103, // Opcode: JIALC_MMR6, DecodeIdx: 103
/* 2186 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2188 */    MCD::OPC_Decode, 191, 7, 177, 1, // Opcode: BEQZC_MMR6, DecodeIdx: 177
/* 2193 */    MCD::OPC_FilterValue, 37, 7, 0, // Skip to: 2204
/* 2197 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2199 */    MCD::OPC_Decode, 177, 7, 178, 1, // Opcode: BC_MMR6, DecodeIdx: 178
/* 2204 */    MCD::OPC_FilterValue, 40, 21, 0, // Skip to: 2229
/* 2208 */    MCD::OPC_CheckPredicate, 24, 10, 0, // Skip to: 2222
/* 2212 */    MCD::OPC_CheckField, 21, 5, 0, 4, 0, // Skip to: 2222
/* 2218 */    MCD::OPC_Decode, 194, 14, 103, // Opcode: JIC_MMR6, DecodeIdx: 103
/* 2222 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2224 */    MCD::OPC_Decode, 166, 8, 177, 1, // Opcode: BNEZC_MMR6, DecodeIdx: 177
/* 2229 */    MCD::OPC_FilterValue, 45, 7, 0, // Skip to: 2240
/* 2233 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2235 */    MCD::OPC_Decode, 146, 7, 178, 1, // Opcode: BALC_MMR6, DecodeIdx: 178
/* 2240 */    MCD::OPC_FilterValue, 48, 7, 0, // Skip to: 2251
/* 2244 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2246 */    MCD::OPC_Decode, 198, 7, 179, 1, // Opcode: BGEUC_MMR6, DecodeIdx: 179
/* 2251 */    MCD::OPC_FilterValue, 52, 6, 0, // Skip to: 2261
/* 2255 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2257 */    MCD::OPC_Decode, 224, 6, 108, // Opcode: ANDI_MMR6, DecodeIdx: 108
/* 2261 */    MCD::OPC_FilterValue, 53, 7, 0, // Skip to: 2272
/* 2265 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2267 */    MCD::OPC_Decode, 252, 7, 180, 1, // Opcode: BLTC_MMR6, DecodeIdx: 180
/* 2272 */    MCD::OPC_FilterValue, 56, 7, 0, // Skip to: 2283
/* 2276 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2278 */    MCD::OPC_Decode, 255, 7, 181, 1, // Opcode: BLTUC_MMR6, DecodeIdx: 181
/* 2283 */    MCD::OPC_FilterValue, 61, 7, 0, // Skip to: 2294
/* 2287 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2289 */    MCD::OPC_Decode, 195, 7, 182, 1, // Opcode: BGEC_MMR6, DecodeIdx: 182
/* 2294 */    MCD::OPC_FilterValue, 62, 6, 0, // Skip to: 2304
/* 2298 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2300 */    MCD::OPC_Decode, 231, 21, 98, // Opcode: SW_MMR6, DecodeIdx: 98
/* 2304 */    MCD::OPC_FilterValueOrFail, 63, 
/* 2306 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 2308 */    MCD::OPC_Decode, 201, 15, 98, // Opcode: LW_MMR6, DecodeIdx: 98
/* 2312 */    MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableMicroMipsR6_Ambiguous32[] = {
/* 0 */       MCD::OPC_ExtractField, 26, 6,  // Inst{31-26} ...
/* 3 */       MCD::OPC_FilterValue, 29, 7, 0, // Skip to: 14
/* 7 */       MCD::OPC_CheckPredicateOrFail, 24, 
/* 9 */       MCD::OPC_Decode, 176, 8, 173, 1, // Opcode: BOVC_MMR6, DecodeIdx: 173
/* 14 */      MCD::OPC_FilterValue, 31, 7, 0, // Skip to: 25
/* 18 */      MCD::OPC_CheckPredicateOrFail, 24, 
/* 20 */      MCD::OPC_Decode, 169, 8, 176, 1, // Opcode: BNVC_MMR6, DecodeIdx: 176
/* 25 */      MCD::OPC_FilterValue, 48, 22, 0, // Skip to: 51
/* 29 */      MCD::OPC_CheckPredicate, 24, 11, 0, // Skip to: 44
/* 33 */      MCD::OPC_CheckField, 16, 5, 0, 5, 0, // Skip to: 44
/* 39 */      MCD::OPC_Decode, 244, 7, 179, 1, // Opcode: BLEZALC_MMR6, DecodeIdx: 179
/* 44 */      MCD::OPC_CheckPredicateOrFail, 24, 
/* 46 */      MCD::OPC_Decode, 203, 7, 179, 1, // Opcode: BGEZALC_MMR6, DecodeIdx: 179
/* 51 */      MCD::OPC_FilterValueOrFail, 56, 
/* 53 */      MCD::OPC_CheckPredicate, 24, 11, 0, // Skip to: 68
/* 57 */      MCD::OPC_CheckField, 16, 5, 0, 5, 0, // Skip to: 68
/* 63 */      MCD::OPC_Decode, 215, 7, 181, 1, // Opcode: BGTZALC_MMR6, DecodeIdx: 181
/* 68 */      MCD::OPC_CheckPredicateOrFail, 24, 
/* 70 */      MCD::OPC_Decode, 132, 8, 181, 1, // Opcode: BLTZALC_MMR6, DecodeIdx: 181
/* 75 */      MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableMips32[] = {
/* 0 */       MCD::OPC_ExtractField, 26, 6,  // Inst{31-26} ...
/* 3 */       MCD::OPC_FilterValue, 0, 28, 3, // Skip to: 803
/* 7 */       MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 10 */      MCD::OPC_FilterValue, 0, 51, 0, // Skip to: 65
/* 14 */      MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 17 */      MCD::OPC_FilterValueOrFail, 0, 
/* 19 */      MCD::OPC_ExtractField, 6, 15,  // Inst{20-6} ...
/* 22 */      MCD::OPC_FilterValue, 1, 8, 0, // Skip to: 34
/* 26 */      MCD::OPC_CheckPredicate, 27, 28, 0, // Skip to: 58
/* 30 */      MCD::OPC_Decode, 130, 21, 10, // Opcode: SSNOP, DecodeIdx: 10
/* 34 */      MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 46
/* 38 */      MCD::OPC_CheckPredicate, 27, 16, 0, // Skip to: 58
/* 42 */      MCD::OPC_Decode, 156, 12, 10, // Opcode: EHB, DecodeIdx: 10
/* 46 */      MCD::OPC_FilterValue, 5, 8, 0, // Skip to: 58
/* 50 */      MCD::OPC_CheckPredicate, 28, 4, 0, // Skip to: 58
/* 54 */      MCD::OPC_Decode, 171, 18, 10, // Opcode: PAUSE, DecodeIdx: 10
/* 58 */      MCD::OPC_CheckPredicateOrFail, 27, 
/* 60 */      MCD::OPC_Decode, 177, 20, 183, 1, // Opcode: SLL, DecodeIdx: 183
/* 65 */      MCD::OPC_FilterValue, 1, 31, 0, // Skip to: 100
/* 69 */      MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 72 */      MCD::OPC_FilterValue, 0, 11, 0, // Skip to: 87
/* 76 */      MCD::OPC_CheckPredicateOrFail, 29, 
/* 78 */      MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 82 */      MCD::OPC_Decode, 228, 16, 184, 1, // Opcode: MOVF_I, DecodeIdx: 184
/* 87 */      MCD::OPC_FilterValueOrFail, 1, 
/* 89 */      MCD::OPC_CheckPredicateOrFail, 29, 
/* 91 */      MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 95 */      MCD::OPC_Decode, 248, 16, 184, 1, // Opcode: MOVT_I, DecodeIdx: 184
/* 100 */     MCD::OPC_FilterValue, 2, 23, 0, // Skip to: 127
/* 104 */     MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 107 */     MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 118
/* 111 */     MCD::OPC_CheckPredicateOrFail, 27, 
/* 113 */     MCD::OPC_Decode, 236, 20, 183, 1, // Opcode: SRL, DecodeIdx: 183
/* 118 */     MCD::OPC_FilterValueOrFail, 1, 
/* 120 */     MCD::OPC_CheckPredicateOrFail, 28, 
/* 122 */     MCD::OPC_Decode, 137, 19, 183, 1, // Opcode: ROTR, DecodeIdx: 183
/* 127 */     MCD::OPC_FilterValue, 3, 11, 0, // Skip to: 142
/* 131 */     MCD::OPC_CheckPredicateOrFail, 27, 
/* 133 */     MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 137 */     MCD::OPC_Decode, 216, 20, 183, 1, // Opcode: SRA, DecodeIdx: 183
/* 142 */     MCD::OPC_FilterValue, 4, 10, 0, // Skip to: 156
/* 146 */     MCD::OPC_CheckPredicateOrFail, 27, 
/* 148 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 152 */     MCD::OPC_Decode, 186, 20, 55, // Opcode: SLLV, DecodeIdx: 55
/* 156 */     MCD::OPC_FilterValue, 5, 11, 0, // Skip to: 171
/* 160 */     MCD::OPC_CheckPredicateOrFail, 30, 
/* 162 */     MCD::OPC_CheckFieldOrFail, 8, 3, 0, 
/* 166 */     MCD::OPC_Decode, 152, 15, 185, 1, // Opcode: LSA, DecodeIdx: 185
/* 171 */     MCD::OPC_FilterValue, 6, 21, 0, // Skip to: 196
/* 175 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 178 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 188
/* 182 */     MCD::OPC_CheckPredicateOrFail, 27, 
/* 184 */     MCD::OPC_Decode, 251, 20, 55, // Opcode: SRLV, DecodeIdx: 55
/* 188 */     MCD::OPC_FilterValueOrFail, 1, 
/* 190 */     MCD::OPC_CheckPredicateOrFail, 28, 
/* 192 */     MCD::OPC_Decode, 138, 19, 55, // Opcode: ROTRV, DecodeIdx: 55
/* 196 */     MCD::OPC_FilterValue, 7, 10, 0, // Skip to: 210
/* 200 */     MCD::OPC_CheckPredicateOrFail, 27, 
/* 202 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 206 */     MCD::OPC_Decode, 229, 20, 55, // Opcode: SRAV, DecodeIdx: 55
/* 210 */     MCD::OPC_FilterValue, 8, 23, 0, // Skip to: 237
/* 214 */     MCD::OPC_ExtractField, 6, 15,  // Inst{20-6} ...
/* 217 */     MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 228
/* 221 */     MCD::OPC_CheckPredicateOrFail, 31, 
/* 223 */     MCD::OPC_Decode, 195, 14, 186, 1, // Opcode: JR, DecodeIdx: 186
/* 228 */     MCD::OPC_FilterValueOrFail, 16, 
/* 230 */     MCD::OPC_CheckPredicateOrFail, 32, 
/* 232 */     MCD::OPC_Decode, 202, 14, 186, 1, // Opcode: JR_HB, DecodeIdx: 186
/* 237 */     MCD::OPC_FilterValue, 9, 29, 0, // Skip to: 270
/* 241 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 244 */     MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 258
/* 248 */     MCD::OPC_CheckPredicateOrFail, 33, 
/* 250 */     MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 254 */     MCD::OPC_Decode, 174, 14, 25, // Opcode: JALR, DecodeIdx: 25
/* 258 */     MCD::OPC_FilterValueOrFail, 16, 
/* 260 */     MCD::OPC_CheckPredicateOrFail, 34, 
/* 262 */     MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 266 */     MCD::OPC_Decode, 182, 14, 25, // Opcode: JALR_HB, DecodeIdx: 25
/* 270 */     MCD::OPC_FilterValue, 10, 11, 0, // Skip to: 285
/* 274 */     MCD::OPC_CheckPredicateOrFail, 35, 
/* 276 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 280 */     MCD::OPC_Decode, 132, 17, 187, 1, // Opcode: MOVZ_I_I, DecodeIdx: 187
/* 285 */     MCD::OPC_FilterValue, 11, 11, 0, // Skip to: 300
/* 289 */     MCD::OPC_CheckPredicateOrFail, 35, 
/* 291 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 295 */     MCD::OPC_Decode, 240, 16, 187, 1, // Opcode: MOVN_I_I, DecodeIdx: 187
/* 300 */     MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 311
/* 304 */     MCD::OPC_CheckPredicateOrFail, 27, 
/* 306 */     MCD::OPC_Decode, 238, 21, 188, 1, // Opcode: SYSCALL, DecodeIdx: 188
/* 311 */     MCD::OPC_FilterValue, 13, 6, 0, // Skip to: 321
/* 315 */     MCD::OPC_CheckPredicateOrFail, 27, 
/* 317 */     MCD::OPC_Decode, 180, 8, 56, // Opcode: BREAK, DecodeIdx: 56
/* 321 */     MCD::OPC_FilterValue, 15, 7, 0, // Skip to: 332
/* 325 */     MCD::OPC_CheckPredicateOrFail, 36, 
/* 327 */     MCD::OPC_Decode, 232, 21, 189, 1, // Opcode: SYNC, DecodeIdx: 189
/* 332 */     MCD::OPC_FilterValue, 16, 37, 0, // Skip to: 373
/* 336 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 339 */     MCD::OPC_FilterValueOrFail, 0, 
/* 341 */     MCD::OPC_ExtractField, 16, 5,  // Inst{20-16} ...
/* 344 */     MCD::OPC_FilterValueOrFail, 0, 
/* 346 */     MCD::OPC_ExtractField, 23, 3,  // Inst{25-23} ...
/* 349 */     MCD::OPC_FilterValueOrFail, 0, 
/* 351 */     MCD::OPC_CheckPredicate, 31, 11, 0, // Skip to: 366
/* 355 */     MCD::OPC_CheckField, 21, 2, 0, 5, 0, // Skip to: 366
/* 361 */     MCD::OPC_Decode, 165, 16, 190, 1, // Opcode: MFHI, DecodeIdx: 190
/* 366 */     MCD::OPC_CheckPredicateOrFail, 37, 
/* 368 */     MCD::OPC_Decode, 168, 16, 191, 1, // Opcode: MFHI_DSP, DecodeIdx: 191
/* 373 */     MCD::OPC_FilterValue, 17, 32, 0, // Skip to: 409
/* 377 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 380 */     MCD::OPC_FilterValueOrFail, 0, 
/* 382 */     MCD::OPC_ExtractField, 13, 8,  // Inst{20-13} ...
/* 385 */     MCD::OPC_FilterValueOrFail, 0, 
/* 387 */     MCD::OPC_CheckPredicate, 31, 11, 0, // Skip to: 402
/* 391 */     MCD::OPC_CheckField, 11, 2, 0, 5, 0, // Skip to: 402
/* 397 */     MCD::OPC_Decode, 181, 17, 186, 1, // Opcode: MTHI, DecodeIdx: 186
/* 402 */     MCD::OPC_CheckPredicateOrFail, 37, 
/* 404 */     MCD::OPC_Decode, 183, 17, 192, 1, // Opcode: MTHI_DSP, DecodeIdx: 192
/* 409 */     MCD::OPC_FilterValue, 18, 37, 0, // Skip to: 450
/* 413 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 416 */     MCD::OPC_FilterValueOrFail, 0, 
/* 418 */     MCD::OPC_ExtractField, 16, 5,  // Inst{20-16} ...
/* 421 */     MCD::OPC_FilterValueOrFail, 0, 
/* 423 */     MCD::OPC_ExtractField, 23, 3,  // Inst{25-23} ...
/* 426 */     MCD::OPC_FilterValueOrFail, 0, 
/* 428 */     MCD::OPC_CheckPredicate, 31, 11, 0, // Skip to: 443
/* 432 */     MCD::OPC_CheckField, 21, 2, 0, 5, 0, // Skip to: 443
/* 438 */     MCD::OPC_Decode, 171, 16, 190, 1, // Opcode: MFLO, DecodeIdx: 190
/* 443 */     MCD::OPC_CheckPredicateOrFail, 37, 
/* 445 */     MCD::OPC_Decode, 174, 16, 191, 1, // Opcode: MFLO_DSP, DecodeIdx: 191
/* 450 */     MCD::OPC_FilterValue, 19, 32, 0, // Skip to: 486
/* 454 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 457 */     MCD::OPC_FilterValueOrFail, 0, 
/* 459 */     MCD::OPC_ExtractField, 13, 8,  // Inst{20-13} ...
/* 462 */     MCD::OPC_FilterValueOrFail, 0, 
/* 464 */     MCD::OPC_CheckPredicate, 31, 11, 0, // Skip to: 479
/* 468 */     MCD::OPC_CheckField, 11, 2, 0, 5, 0, // Skip to: 479
/* 474 */     MCD::OPC_Decode, 188, 17, 186, 1, // Opcode: MTLO, DecodeIdx: 186
/* 479 */     MCD::OPC_CheckPredicateOrFail, 37, 
/* 481 */     MCD::OPC_Decode, 190, 17, 193, 1, // Opcode: MTLO_DSP, DecodeIdx: 193
/* 486 */     MCD::OPC_FilterValue, 21, 11, 0, // Skip to: 501
/* 490 */     MCD::OPC_CheckPredicateOrFail, 38, 
/* 492 */     MCD::OPC_CheckFieldOrFail, 8, 3, 0, 
/* 496 */     MCD::OPC_Decode, 187, 11, 194, 1, // Opcode: DLSA, DecodeIdx: 194
/* 501 */     MCD::OPC_FilterValue, 24, 31, 0, // Skip to: 536
/* 505 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 508 */     MCD::OPC_FilterValueOrFail, 0, 
/* 510 */     MCD::OPC_ExtractField, 13, 3,  // Inst{15-13} ...
/* 513 */     MCD::OPC_FilterValueOrFail, 0, 
/* 515 */     MCD::OPC_CheckPredicate, 31, 10, 0, // Skip to: 529
/* 519 */     MCD::OPC_CheckField, 11, 2, 0, 4, 0, // Skip to: 529
/* 525 */     MCD::OPC_Decode, 228, 17, 80, // Opcode: MULT, DecodeIdx: 80
/* 529 */     MCD::OPC_CheckPredicateOrFail, 37, 
/* 531 */     MCD::OPC_Decode, 231, 17, 195, 1, // Opcode: MULT_DSP, DecodeIdx: 195
/* 536 */     MCD::OPC_FilterValue, 25, 31, 0, // Skip to: 571
/* 540 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 543 */     MCD::OPC_FilterValueOrFail, 0, 
/* 545 */     MCD::OPC_ExtractField, 13, 3,  // Inst{15-13} ...
/* 548 */     MCD::OPC_FilterValueOrFail, 0, 
/* 550 */     MCD::OPC_CheckPredicate, 31, 10, 0, // Skip to: 564
/* 554 */     MCD::OPC_CheckField, 11, 2, 0, 4, 0, // Skip to: 564
/* 560 */     MCD::OPC_Decode, 234, 17, 80, // Opcode: MULTu, DecodeIdx: 80
/* 564 */     MCD::OPC_CheckPredicateOrFail, 37, 
/* 566 */     MCD::OPC_Decode, 229, 17, 195, 1, // Opcode: MULTU_DSP, DecodeIdx: 195
/* 571 */     MCD::OPC_FilterValue, 26, 10, 0, // Skip to: 585
/* 575 */     MCD::OPC_CheckPredicateOrFail, 31, 
/* 577 */     MCD::OPC_CheckFieldOrFail, 6, 10, 0, 
/* 581 */     MCD::OPC_Decode, 204, 19, 80, // Opcode: SDIV, DecodeIdx: 80
/* 585 */     MCD::OPC_FilterValue, 27, 10, 0, // Skip to: 599
/* 589 */     MCD::OPC_CheckPredicateOrFail, 31, 
/* 591 */     MCD::OPC_CheckFieldOrFail, 6, 10, 0, 
/* 595 */     MCD::OPC_Decode, 192, 22, 80, // Opcode: UDIV, DecodeIdx: 80
/* 599 */     MCD::OPC_FilterValue, 32, 10, 0, // Skip to: 613
/* 603 */     MCD::OPC_CheckPredicateOrFail, 27, 
/* 605 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 609 */     MCD::OPC_Decode, 138, 6, 61, // Opcode: ADD, DecodeIdx: 61
/* 613 */     MCD::OPC_FilterValue, 33, 10, 0, // Skip to: 627
/* 617 */     MCD::OPC_CheckPredicateOrFail, 27, 
/* 619 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 623 */     MCD::OPC_Decode, 211, 6, 61, // Opcode: ADDu, DecodeIdx: 61
/* 627 */     MCD::OPC_FilterValue, 34, 10, 0, // Skip to: 641
/* 631 */     MCD::OPC_CheckPredicateOrFail, 27, 
/* 633 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 637 */     MCD::OPC_Decode, 137, 21, 61, // Opcode: SUB, DecodeIdx: 61
/* 641 */     MCD::OPC_FilterValue, 35, 10, 0, // Skip to: 655
/* 645 */     MCD::OPC_CheckPredicateOrFail, 27, 
/* 647 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 651 */     MCD::OPC_Decode, 193, 21, 61, // Opcode: SUBu, DecodeIdx: 61
/* 655 */     MCD::OPC_FilterValue, 36, 10, 0, // Skip to: 669
/* 659 */     MCD::OPC_CheckPredicateOrFail, 27, 
/* 661 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 665 */     MCD::OPC_Decode, 217, 6, 61, // Opcode: AND, DecodeIdx: 61
/* 669 */     MCD::OPC_FilterValue, 37, 10, 0, // Skip to: 683
/* 673 */     MCD::OPC_CheckPredicateOrFail, 27, 
/* 675 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 679 */     MCD::OPC_Decode, 156, 18, 61, // Opcode: OR, DecodeIdx: 61
/* 683 */     MCD::OPC_FilterValue, 38, 10, 0, // Skip to: 697
/* 687 */     MCD::OPC_CheckPredicateOrFail, 27, 
/* 689 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 693 */     MCD::OPC_Decode, 210, 22, 61, // Opcode: XOR, DecodeIdx: 61
/* 697 */     MCD::OPC_FilterValue, 39, 10, 0, // Skip to: 711
/* 701 */     MCD::OPC_CheckPredicateOrFail, 27, 
/* 703 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 707 */     MCD::OPC_Decode, 146, 18, 61, // Opcode: NOR, DecodeIdx: 61
/* 711 */     MCD::OPC_FilterValue, 42, 10, 0, // Skip to: 725
/* 715 */     MCD::OPC_CheckPredicateOrFail, 27, 
/* 717 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 721 */     MCD::OPC_Decode, 194, 20, 61, // Opcode: SLT, DecodeIdx: 61
/* 725 */     MCD::OPC_FilterValue, 43, 10, 0, // Skip to: 739
/* 729 */     MCD::OPC_CheckPredicateOrFail, 27, 
/* 731 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 735 */     MCD::OPC_Decode, 203, 20, 61, // Opcode: SLTu, DecodeIdx: 61
/* 739 */     MCD::OPC_FilterValue, 48, 7, 0, // Skip to: 750
/* 743 */     MCD::OPC_CheckPredicateOrFail, 36, 
/* 745 */     MCD::OPC_Decode, 137, 22, 196, 1, // Opcode: TGE, DecodeIdx: 196
/* 750 */     MCD::OPC_FilterValue, 49, 7, 0, // Skip to: 761
/* 754 */     MCD::OPC_CheckPredicateOrFail, 36, 
/* 756 */     MCD::OPC_Decode, 142, 22, 196, 1, // Opcode: TGEU, DecodeIdx: 196
/* 761 */     MCD::OPC_FilterValue, 50, 7, 0, // Skip to: 772
/* 765 */     MCD::OPC_CheckPredicateOrFail, 36, 
/* 767 */     MCD::OPC_Decode, 169, 22, 196, 1, // Opcode: TLT, DecodeIdx: 196
/* 772 */     MCD::OPC_FilterValue, 51, 7, 0, // Skip to: 783
/* 776 */     MCD::OPC_CheckPredicateOrFail, 36, 
/* 778 */     MCD::OPC_Decode, 173, 22, 196, 1, // Opcode: TLTU, DecodeIdx: 196
/* 783 */     MCD::OPC_FilterValue, 52, 7, 0, // Skip to: 794
/* 787 */     MCD::OPC_CheckPredicateOrFail, 36, 
/* 789 */     MCD::OPC_Decode, 133, 22, 196, 1, // Opcode: TEQ, DecodeIdx: 196
/* 794 */     MCD::OPC_FilterValueOrFail, 54, 
/* 796 */     MCD::OPC_CheckPredicateOrFail, 36, 
/* 798 */     MCD::OPC_Decode, 176, 22, 196, 1, // Opcode: TNE, DecodeIdx: 196
/* 803 */     MCD::OPC_FilterValue, 1, 181, 0, // Skip to: 988
/* 807 */     MCD::OPC_ExtractField, 16, 5,  // Inst{20-16} ...
/* 810 */     MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 821
/* 814 */     MCD::OPC_CheckPredicateOrFail, 27, 
/* 816 */     MCD::OPC_Decode, 128, 8, 197, 1, // Opcode: BLTZ, DecodeIdx: 197
/* 821 */     MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 832
/* 825 */     MCD::OPC_CheckPredicateOrFail, 27, 
/* 827 */     MCD::OPC_Decode, 199, 7, 197, 1, // Opcode: BGEZ, DecodeIdx: 197
/* 832 */     MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 843
/* 836 */     MCD::OPC_CheckPredicateOrFail, 39, 
/* 838 */     MCD::OPC_Decode, 139, 8, 197, 1, // Opcode: BLTZL, DecodeIdx: 197
/* 843 */     MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 854
/* 847 */     MCD::OPC_CheckPredicateOrFail, 39, 
/* 849 */     MCD::OPC_Decode, 210, 7, 197, 1, // Opcode: BGEZL, DecodeIdx: 197
/* 854 */     MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 865
/* 858 */     MCD::OPC_CheckPredicateOrFail, 39, 
/* 860 */     MCD::OPC_Decode, 138, 22, 175, 1, // Opcode: TGEI, DecodeIdx: 175
/* 865 */     MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 876
/* 869 */     MCD::OPC_CheckPredicateOrFail, 39, 
/* 871 */     MCD::OPC_Decode, 139, 22, 175, 1, // Opcode: TGEIU, DecodeIdx: 175
/* 876 */     MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 887
/* 880 */     MCD::OPC_CheckPredicateOrFail, 39, 
/* 882 */     MCD::OPC_Decode, 170, 22, 175, 1, // Opcode: TLTI, DecodeIdx: 175
/* 887 */     MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 898
/* 891 */     MCD::OPC_CheckPredicateOrFail, 39, 
/* 893 */     MCD::OPC_Decode, 191, 22, 175, 1, // Opcode: TTLTIU, DecodeIdx: 175
/* 898 */     MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 909
/* 902 */     MCD::OPC_CheckPredicateOrFail, 39, 
/* 904 */     MCD::OPC_Decode, 134, 22, 175, 1, // Opcode: TEQI, DecodeIdx: 175
/* 909 */     MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 920
/* 913 */     MCD::OPC_CheckPredicateOrFail, 39, 
/* 915 */     MCD::OPC_Decode, 177, 22, 175, 1, // Opcode: TNEI, DecodeIdx: 175
/* 920 */     MCD::OPC_FilterValue, 16, 7, 0, // Skip to: 931
/* 924 */     MCD::OPC_CheckPredicateOrFail, 31, 
/* 926 */     MCD::OPC_Decode, 130, 8, 197, 1, // Opcode: BLTZAL, DecodeIdx: 197
/* 931 */     MCD::OPC_FilterValue, 17, 7, 0, // Skip to: 942
/* 935 */     MCD::OPC_CheckPredicateOrFail, 31, 
/* 937 */     MCD::OPC_Decode, 201, 7, 197, 1, // Opcode: BGEZAL, DecodeIdx: 197
/* 942 */     MCD::OPC_FilterValue, 18, 7, 0, // Skip to: 953
/* 946 */     MCD::OPC_CheckPredicateOrFail, 39, 
/* 948 */     MCD::OPC_Decode, 133, 8, 197, 1, // Opcode: BLTZALL, DecodeIdx: 197
/* 953 */     MCD::OPC_FilterValue, 19, 7, 0, // Skip to: 964
/* 957 */     MCD::OPC_CheckPredicateOrFail, 39, 
/* 959 */     MCD::OPC_Decode, 204, 7, 197, 1, // Opcode: BGEZALL, DecodeIdx: 197
/* 964 */     MCD::OPC_FilterValue, 28, 11, 0, // Skip to: 979
/* 968 */     MCD::OPC_CheckPredicateOrFail, 40, 
/* 970 */     MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 974 */     MCD::OPC_Decode, 177, 8, 198, 1, // Opcode: BPOSGE32, DecodeIdx: 198
/* 979 */     MCD::OPC_FilterValueOrFail, 31, 
/* 981 */     MCD::OPC_CheckPredicateOrFail, 28, 
/* 983 */     MCD::OPC_Decode, 233, 21, 199, 1, // Opcode: SYNCI, DecodeIdx: 199
/* 988 */     MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 999
/* 992 */     MCD::OPC_CheckPredicateOrFail, 27, 
/* 994 */     MCD::OPC_Decode, 172, 14, 200, 1, // Opcode: J, DecodeIdx: 200
/* 999 */     MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 1010
/* 1003 */    MCD::OPC_CheckPredicateOrFail, 27, 
/* 1005 */    MCD::OPC_Decode, 173, 14, 200, 1, // Opcode: JAL, DecodeIdx: 200
/* 1010 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 1021
/* 1014 */    MCD::OPC_CheckPredicateOrFail, 27, 
/* 1016 */    MCD::OPC_Decode, 178, 7, 201, 1, // Opcode: BEQ, DecodeIdx: 201
/* 1021 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 1032
/* 1025 */    MCD::OPC_CheckPredicateOrFail, 27, 
/* 1027 */    MCD::OPC_Decode, 145, 8, 201, 1, // Opcode: BNE, DecodeIdx: 201
/* 1032 */    MCD::OPC_FilterValue, 6, 11, 0, // Skip to: 1047
/* 1036 */    MCD::OPC_CheckPredicateOrFail, 27, 
/* 1038 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 1042 */    MCD::OPC_Decode, 241, 7, 197, 1, // Opcode: BLEZ, DecodeIdx: 197
/* 1047 */    MCD::OPC_FilterValue, 7, 11, 0, // Skip to: 1062
/* 1051 */    MCD::OPC_CheckPredicateOrFail, 27, 
/* 1053 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 1057 */    MCD::OPC_Decode, 212, 7, 197, 1, // Opcode: BGTZ, DecodeIdx: 197
/* 1062 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 1073
/* 1066 */    MCD::OPC_CheckPredicateOrFail, 31, 
/* 1068 */    MCD::OPC_Decode, 207, 6, 202, 1, // Opcode: ADDi, DecodeIdx: 202
/* 1073 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 1084
/* 1077 */    MCD::OPC_CheckPredicateOrFail, 27, 
/* 1079 */    MCD::OPC_Decode, 209, 6, 202, 1, // Opcode: ADDiu, DecodeIdx: 202
/* 1084 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 1095
/* 1088 */    MCD::OPC_CheckPredicateOrFail, 27, 
/* 1090 */    MCD::OPC_Decode, 197, 20, 202, 1, // Opcode: SLTi, DecodeIdx: 202
/* 1095 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 1106
/* 1099 */    MCD::OPC_CheckPredicateOrFail, 27, 
/* 1101 */    MCD::OPC_Decode, 200, 20, 202, 1, // Opcode: SLTiu, DecodeIdx: 202
/* 1106 */    MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 1117
/* 1110 */    MCD::OPC_CheckPredicateOrFail, 27, 
/* 1112 */    MCD::OPC_Decode, 228, 6, 203, 1, // Opcode: ANDi, DecodeIdx: 203
/* 1117 */    MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 1128
/* 1121 */    MCD::OPC_CheckPredicateOrFail, 27, 
/* 1123 */    MCD::OPC_Decode, 165, 18, 203, 1, // Opcode: ORi, DecodeIdx: 203
/* 1128 */    MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 1139
/* 1132 */    MCD::OPC_CheckPredicateOrFail, 27, 
/* 1134 */    MCD::OPC_Decode, 219, 22, 203, 1, // Opcode: XORi, DecodeIdx: 203
/* 1139 */    MCD::OPC_FilterValue, 15, 10, 0, // Skip to: 1153
/* 1143 */    MCD::OPC_CheckPredicateOrFail, 27, 
/* 1145 */    MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 1149 */    MCD::OPC_Decode, 159, 15, 103, // Opcode: LUi, DecodeIdx: 103
/* 1153 */    MCD::OPC_FilterValue, 16, 224, 1, // Skip to: 1637
/* 1157 */    MCD::OPC_ExtractField, 3, 1,  // Inst{3} ...
/* 1160 */    MCD::OPC_FilterValue, 0, 47, 1, // Skip to: 1467
/* 1164 */    MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 1167 */    MCD::OPC_FilterValue, 0, 11, 0, // Skip to: 1182
/* 1171 */    MCD::OPC_CheckPredicateOrFail, 27, 
/* 1173 */    MCD::OPC_CheckFieldOrFail, 4, 7, 0, 
/* 1177 */    MCD::OPC_Decode, 147, 16, 204, 1, // Opcode: MFC0, DecodeIdx: 204
/* 1182 */    MCD::OPC_FilterValue, 3, 45, 0, // Skip to: 1231
/* 1186 */    MCD::OPC_ExtractField, 4, 7,  // Inst{10-4} ...
/* 1189 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 1200
/* 1193 */    MCD::OPC_CheckPredicateOrFail, 41, 
/* 1195 */    MCD::OPC_Decode, 155, 16, 204, 1, // Opcode: MFGC0, DecodeIdx: 204
/* 1200 */    MCD::OPC_FilterValue, 32, 7, 0, // Skip to: 1211
/* 1204 */    MCD::OPC_CheckPredicateOrFail, 41, 
/* 1206 */    MCD::OPC_Decode, 171, 17, 205, 1, // Opcode: MTGC0, DecodeIdx: 205
/* 1211 */    MCD::OPC_FilterValue, 64, 7, 0, // Skip to: 1222
/* 1215 */    MCD::OPC_CheckPredicateOrFail, 41, 
/* 1217 */    MCD::OPC_Decode, 163, 16, 204, 1, // Opcode: MFHGC0, DecodeIdx: 204
/* 1222 */    MCD::OPC_FilterValueOrFail, 96, 
/* 1224 */    MCD::OPC_CheckPredicateOrFail, 41, 
/* 1226 */    MCD::OPC_Decode, 179, 17, 205, 1, // Opcode: MTHGC0, DecodeIdx: 205
/* 1231 */    MCD::OPC_FilterValue, 4, 11, 0, // Skip to: 1246
/* 1235 */    MCD::OPC_CheckPredicateOrFail, 27, 
/* 1237 */    MCD::OPC_CheckFieldOrFail, 4, 7, 0, 
/* 1241 */    MCD::OPC_Decode, 162, 17, 205, 1, // Opcode: MTC0, DecodeIdx: 205
/* 1246 */    MCD::OPC_FilterValue, 8, 11, 0, // Skip to: 1261
/* 1250 */    MCD::OPC_CheckPredicateOrFail, 42, 
/* 1252 */    MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 1256 */    MCD::OPC_Decode, 177, 16, 206, 1, // Opcode: MFTR, DecodeIdx: 206
/* 1261 */    MCD::OPC_FilterValue, 11, 89, 0, // Skip to: 1354
/* 1265 */    MCD::OPC_ExtractField, 4, 12,  // Inst{15-4} ...
/* 1268 */    MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 1282
/* 1272 */    MCD::OPC_CheckPredicateOrFail, 42, 
/* 1274 */    MCD::OPC_CheckFieldOrFail, 0, 3, 1, 
/* 1278 */    MCD::OPC_Decode, 152, 12, 92, // Opcode: DVPE, DecodeIdx: 92
/* 1282 */    MCD::OPC_FilterValue, 2, 10, 0, // Skip to: 1296
/* 1286 */    MCD::OPC_CheckPredicateOrFail, 42, 
/* 1288 */    MCD::OPC_CheckFieldOrFail, 0, 3, 1, 
/* 1292 */    MCD::OPC_Decode, 169, 12, 92, // Opcode: EVPE, DecodeIdx: 92
/* 1296 */    MCD::OPC_FilterValue, 188, 1, 10, 0, // Skip to: 1311
/* 1301 */    MCD::OPC_CheckPredicateOrFail, 42, 
/* 1303 */    MCD::OPC_CheckFieldOrFail, 0, 3, 1, 
/* 1307 */    MCD::OPC_Decode, 196, 11, 92, // Opcode: DMT, DecodeIdx: 92
/* 1311 */    MCD::OPC_FilterValue, 190, 1, 10, 0, // Skip to: 1326
/* 1316 */    MCD::OPC_CheckPredicateOrFail, 42, 
/* 1318 */    MCD::OPC_CheckFieldOrFail, 0, 3, 1, 
/* 1322 */    MCD::OPC_Decode, 162, 12, 92, // Opcode: EMT, DecodeIdx: 92
/* 1326 */    MCD::OPC_FilterValue, 128, 12, 10, 0, // Skip to: 1341
/* 1331 */    MCD::OPC_CheckPredicateOrFail, 28, 
/* 1333 */    MCD::OPC_CheckFieldOrFail, 0, 3, 0, 
/* 1337 */    MCD::OPC_Decode, 169, 11, 92, // Opcode: DI, DecodeIdx: 92
/* 1341 */    MCD::OPC_FilterValueOrFail, 130, 12, 
/* 1344 */    MCD::OPC_CheckPredicateOrFail, 28, 
/* 1346 */    MCD::OPC_CheckFieldOrFail, 0, 3, 0, 
/* 1350 */    MCD::OPC_Decode, 159, 12, 92, // Opcode: EI, DecodeIdx: 92
/* 1354 */    MCD::OPC_FilterValue, 12, 11, 0, // Skip to: 1369
/* 1358 */    MCD::OPC_CheckPredicateOrFail, 42, 
/* 1360 */    MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 1364 */    MCD::OPC_Decode, 199, 17, 206, 1, // Opcode: MTTR, DecodeIdx: 206
/* 1369 */    MCD::OPC_FilterValueOrFail, 16, 
/* 1371 */    MCD::OPC_ExtractField, 0, 3,  // Inst{2-0} ...
/* 1374 */    MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 1399
/* 1378 */    MCD::OPC_ExtractField, 4, 17,  // Inst{20-4} ...
/* 1381 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 1391
/* 1385 */    MCD::OPC_CheckPredicateOrFail, 41, 
/* 1387 */    MCD::OPC_Decode, 149, 22, 10, // Opcode: TLBGP, DecodeIdx: 10
/* 1391 */    MCD::OPC_FilterValueOrFail, 2, 
/* 1393 */    MCD::OPC_CheckPredicateOrFail, 43, 
/* 1395 */    MCD::OPC_Decode, 201, 22, 10, // Opcode: WAIT, DecodeIdx: 10
/* 1399 */    MCD::OPC_FilterValue, 1, 10, 0, // Skip to: 1413
/* 1403 */    MCD::OPC_CheckPredicateOrFail, 27, 
/* 1405 */    MCD::OPC_CheckFieldOrFail, 4, 17, 0, 
/* 1409 */    MCD::OPC_Decode, 163, 22, 10, // Opcode: TLBR, DecodeIdx: 10
/* 1413 */    MCD::OPC_FilterValue, 2, 10, 0, // Skip to: 1427
/* 1417 */    MCD::OPC_CheckPredicateOrFail, 27, 
/* 1419 */    MCD::OPC_CheckFieldOrFail, 4, 17, 0, 
/* 1423 */    MCD::OPC_Decode, 165, 22, 10, // Opcode: TLBWI, DecodeIdx: 10
/* 1427 */    MCD::OPC_FilterValue, 3, 10, 0, // Skip to: 1441
/* 1431 */    MCD::OPC_CheckPredicateOrFail, 44, 
/* 1433 */    MCD::OPC_CheckFieldOrFail, 4, 17, 0, 
/* 1437 */    MCD::OPC_Decode, 157, 22, 10, // Opcode: TLBINV, DecodeIdx: 10
/* 1441 */    MCD::OPC_FilterValue, 4, 10, 0, // Skip to: 1455
/* 1445 */    MCD::OPC_CheckPredicateOrFail, 44, 
/* 1447 */    MCD::OPC_CheckFieldOrFail, 4, 17, 0, 
/* 1451 */    MCD::OPC_Decode, 158, 22, 10, // Opcode: TLBINVF, DecodeIdx: 10
/* 1455 */    MCD::OPC_FilterValueOrFail, 6, 
/* 1457 */    MCD::OPC_CheckPredicateOrFail, 27, 
/* 1459 */    MCD::OPC_CheckFieldOrFail, 4, 17, 0, 
/* 1463 */    MCD::OPC_Decode, 167, 22, 10, // Opcode: TLBWR, DecodeIdx: 10
/* 1467 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1469 */    MCD::OPC_ExtractField, 0, 3,  // Inst{2-0} ...
/* 1472 */    MCD::OPC_FilterValue, 0, 61, 0, // Skip to: 1537
/* 1476 */    MCD::OPC_ExtractField, 4, 2,  // Inst{5-4} ...
/* 1479 */    MCD::OPC_FilterValue, 0, 12, 0, // Skip to: 1495
/* 1483 */    MCD::OPC_CheckPredicateOrFail, 27, 
/* 1485 */    MCD::OPC_CheckFieldOrFail, 6, 20, 128, 128, 32, 
/* 1491 */    MCD::OPC_Decode, 161, 22, 10, // Opcode: TLBP, DecodeIdx: 10
/* 1495 */    MCD::OPC_FilterValue, 1, 25, 0, // Skip to: 1524
/* 1499 */    MCD::OPC_ExtractField, 6, 20,  // Inst{25-6} ...
/* 1502 */    MCD::OPC_FilterValue, 128, 128, 32, 6, 0, // Skip to: 1514
/* 1508 */    MCD::OPC_CheckPredicateOrFail, 43, 
/* 1510 */    MCD::OPC_Decode, 163, 12, 10, // Opcode: ERET, DecodeIdx: 10
/* 1514 */    MCD::OPC_FilterValueOrFail, 129, 128, 32, 
/* 1518 */    MCD::OPC_CheckPredicateOrFail, 45, 
/* 1520 */    MCD::OPC_Decode, 164, 12, 10, // Opcode: ERETNC, DecodeIdx: 10
/* 1524 */    MCD::OPC_FilterValueOrFail, 2, 
/* 1526 */    MCD::OPC_CheckPredicateOrFail, 41, 
/* 1528 */    MCD::OPC_CheckFieldOrFail, 25, 1, 1, 
/* 1532 */    MCD::OPC_Decode, 141, 14, 207, 1, // Opcode: HYPCALL, DecodeIdx: 207
/* 1537 */    MCD::OPC_FilterValue, 1, 13, 0, // Skip to: 1554
/* 1541 */    MCD::OPC_CheckPredicateOrFail, 41, 
/* 1543 */    MCD::OPC_CheckFieldOrFail, 4, 22, 128, 128, 128, 1, 
/* 1550 */    MCD::OPC_Decode, 151, 22, 10, // Opcode: TLBGR, DecodeIdx: 10
/* 1554 */    MCD::OPC_FilterValue, 2, 13, 0, // Skip to: 1571
/* 1558 */    MCD::OPC_CheckPredicateOrFail, 41, 
/* 1560 */    MCD::OPC_CheckFieldOrFail, 4, 22, 128, 128, 128, 1, 
/* 1567 */    MCD::OPC_Decode, 153, 22, 10, // Opcode: TLBGWI, DecodeIdx: 10
/* 1571 */    MCD::OPC_FilterValue, 3, 13, 0, // Skip to: 1588
/* 1575 */    MCD::OPC_CheckPredicateOrFail, 41, 
/* 1577 */    MCD::OPC_CheckFieldOrFail, 4, 22, 128, 128, 128, 1, 
/* 1584 */    MCD::OPC_Decode, 145, 22, 10, // Opcode: TLBGINV, DecodeIdx: 10
/* 1588 */    MCD::OPC_FilterValue, 4, 13, 0, // Skip to: 1605
/* 1592 */    MCD::OPC_CheckPredicateOrFail, 41, 
/* 1594 */    MCD::OPC_CheckFieldOrFail, 4, 22, 128, 128, 128, 1, 
/* 1601 */    MCD::OPC_Decode, 146, 22, 10, // Opcode: TLBGINVF, DecodeIdx: 10
/* 1605 */    MCD::OPC_FilterValue, 6, 13, 0, // Skip to: 1622
/* 1609 */    MCD::OPC_CheckPredicateOrFail, 41, 
/* 1611 */    MCD::OPC_CheckFieldOrFail, 4, 22, 128, 128, 128, 1, 
/* 1618 */    MCD::OPC_Decode, 155, 22, 10, // Opcode: TLBGWR, DecodeIdx: 10
/* 1622 */    MCD::OPC_FilterValueOrFail, 7, 
/* 1624 */    MCD::OPC_CheckPredicateOrFail, 46, 
/* 1626 */    MCD::OPC_CheckFieldOrFail, 4, 22, 129, 128, 128, 1, 
/* 1633 */    MCD::OPC_Decode, 162, 11, 10, // Opcode: DERET, DecodeIdx: 10
/* 1637 */    MCD::OPC_FilterValue, 17, 101, 5, // Skip to: 3022
/* 1641 */    MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 1644 */    MCD::OPC_FilterValue, 0, 11, 0, // Skip to: 1659
/* 1648 */    MCD::OPC_CheckPredicateOrFail, 47, 
/* 1650 */    MCD::OPC_CheckFieldOrFail, 0, 11, 0, 
/* 1654 */    MCD::OPC_Decode, 149, 16, 208, 1, // Opcode: MFC1, DecodeIdx: 208
/* 1659 */    MCD::OPC_FilterValue, 1, 11, 0, // Skip to: 1674
/* 1663 */    MCD::OPC_CheckPredicateOrFail, 48, 
/* 1665 */    MCD::OPC_CheckFieldOrFail, 0, 11, 0, 
/* 1669 */    MCD::OPC_Decode, 190, 11, 209, 1, // Opcode: DMFC1, DecodeIdx: 209
/* 1674 */    MCD::OPC_FilterValue, 2, 11, 0, // Skip to: 1689
/* 1678 */    MCD::OPC_CheckPredicateOrFail, 47, 
/* 1680 */    MCD::OPC_CheckFieldOrFail, 0, 11, 0, 
/* 1684 */    MCD::OPC_Decode, 236, 8, 210, 1, // Opcode: CFC1, DecodeIdx: 210
/* 1689 */    MCD::OPC_FilterValue, 3, 11, 0, // Skip to: 1704
/* 1693 */    MCD::OPC_CheckPredicateOrFail, 49, 
/* 1695 */    MCD::OPC_CheckFieldOrFail, 0, 11, 0, 
/* 1699 */    MCD::OPC_Decode, 158, 16, 211, 1, // Opcode: MFHC1_D32, DecodeIdx: 211
/* 1704 */    MCD::OPC_FilterValue, 4, 11, 0, // Skip to: 1719
/* 1708 */    MCD::OPC_CheckPredicateOrFail, 47, 
/* 1710 */    MCD::OPC_CheckFieldOrFail, 0, 11, 0, 
/* 1714 */    MCD::OPC_Decode, 164, 17, 212, 1, // Opcode: MTC1, DecodeIdx: 212
/* 1719 */    MCD::OPC_FilterValue, 5, 11, 0, // Skip to: 1734
/* 1723 */    MCD::OPC_CheckPredicateOrFail, 48, 
/* 1725 */    MCD::OPC_CheckFieldOrFail, 0, 11, 0, 
/* 1729 */    MCD::OPC_Decode, 198, 11, 213, 1, // Opcode: DMTC1, DecodeIdx: 213
/* 1734 */    MCD::OPC_FilterValue, 6, 11, 0, // Skip to: 1749
/* 1738 */    MCD::OPC_CheckPredicateOrFail, 47, 
/* 1740 */    MCD::OPC_CheckFieldOrFail, 0, 11, 0, 
/* 1744 */    MCD::OPC_Decode, 135, 10, 214, 1, // Opcode: CTC1, DecodeIdx: 214
/* 1749 */    MCD::OPC_FilterValue, 7, 11, 0, // Skip to: 1764
/* 1753 */    MCD::OPC_CheckPredicateOrFail, 49, 
/* 1755 */    MCD::OPC_CheckFieldOrFail, 0, 11, 0, 
/* 1759 */    MCD::OPC_Decode, 174, 17, 215, 1, // Opcode: MTHC1_D32, DecodeIdx: 215
/* 1764 */    MCD::OPC_FilterValue, 8, 45, 0, // Skip to: 1813
/* 1768 */    MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 1771 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 1782
/* 1775 */    MCD::OPC_CheckPredicateOrFail, 50, 
/* 1777 */    MCD::OPC_Decode, 157, 7, 216, 1, // Opcode: BC1F, DecodeIdx: 216
/* 1782 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 1793
/* 1786 */    MCD::OPC_CheckPredicateOrFail, 50, 
/* 1788 */    MCD::OPC_Decode, 162, 7, 216, 1, // Opcode: BC1T, DecodeIdx: 216
/* 1793 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 1804
/* 1797 */    MCD::OPC_CheckPredicateOrFail, 51, 
/* 1799 */    MCD::OPC_Decode, 158, 7, 216, 1, // Opcode: BC1FL, DecodeIdx: 216
/* 1804 */    MCD::OPC_FilterValueOrFail, 3, 
/* 1806 */    MCD::OPC_CheckPredicateOrFail, 51, 
/* 1808 */    MCD::OPC_Decode, 163, 7, 216, 1, // Opcode: BC1TL, DecodeIdx: 216
/* 1813 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 1824
/* 1817 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 1819 */    MCD::OPC_Decode, 198, 8, 217, 1, // Opcode: BZ_V, DecodeIdx: 217
/* 1824 */    MCD::OPC_FilterValue, 15, 7, 0, // Skip to: 1835
/* 1828 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 1830 */    MCD::OPC_Decode, 173, 8, 217, 1, // Opcode: BNZ_V, DecodeIdx: 217
/* 1835 */    MCD::OPC_FilterValue, 16, 17, 2, // Skip to: 2368
/* 1839 */    MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 1842 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 1853
/* 1846 */    MCD::OPC_CheckPredicateOrFail, 47, 
/* 1848 */    MCD::OPC_Decode, 212, 12, 218, 1, // Opcode: FADD_S, DecodeIdx: 218
/* 1853 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 1864
/* 1857 */    MCD::OPC_CheckPredicateOrFail, 47, 
/* 1859 */    MCD::OPC_Decode, 229, 13, 218, 1, // Opcode: FSUB_S, DecodeIdx: 218
/* 1864 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 1875
/* 1868 */    MCD::OPC_CheckPredicateOrFail, 47, 
/* 1870 */    MCD::OPC_Decode, 185, 13, 218, 1, // Opcode: FMUL_S, DecodeIdx: 218
/* 1875 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 1886
/* 1879 */    MCD::OPC_CheckPredicateOrFail, 47, 
/* 1881 */    MCD::OPC_Decode, 250, 12, 218, 1, // Opcode: FDIV_S, DecodeIdx: 218
/* 1886 */    MCD::OPC_FilterValue, 4, 11, 0, // Skip to: 1901
/* 1890 */    MCD::OPC_CheckPredicateOrFail, 52, 
/* 1892 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 1896 */    MCD::OPC_Decode, 220, 13, 219, 1, // Opcode: FSQRT_S, DecodeIdx: 219
/* 1901 */    MCD::OPC_FilterValue, 5, 11, 0, // Skip to: 1916
/* 1905 */    MCD::OPC_CheckPredicateOrFail, 47, 
/* 1907 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 1911 */    MCD::OPC_Decode, 204, 12, 219, 1, // Opcode: FABS_S, DecodeIdx: 219
/* 1916 */    MCD::OPC_FilterValue, 6, 11, 0, // Skip to: 1931
/* 1920 */    MCD::OPC_CheckPredicateOrFail, 47, 
/* 1922 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 1926 */    MCD::OPC_Decode, 174, 13, 219, 1, // Opcode: FMOV_S, DecodeIdx: 219
/* 1931 */    MCD::OPC_FilterValue, 7, 11, 0, // Skip to: 1946
/* 1935 */    MCD::OPC_CheckPredicateOrFail, 53, 
/* 1937 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 1941 */    MCD::OPC_Decode, 193, 13, 219, 1, // Opcode: FNEG_S, DecodeIdx: 219
/* 1946 */    MCD::OPC_FilterValue, 12, 11, 0, // Skip to: 1961
/* 1950 */    MCD::OPC_CheckPredicateOrFail, 52, 
/* 1952 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 1956 */    MCD::OPC_Decode, 149, 19, 219, 1, // Opcode: ROUND_W_S, DecodeIdx: 219
/* 1961 */    MCD::OPC_FilterValue, 13, 11, 0, // Skip to: 1976
/* 1965 */    MCD::OPC_CheckPredicateOrFail, 52, 
/* 1967 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 1971 */    MCD::OPC_Decode, 188, 22, 219, 1, // Opcode: TRUNC_W_S, DecodeIdx: 219
/* 1976 */    MCD::OPC_FilterValue, 14, 11, 0, // Skip to: 1991
/* 1980 */    MCD::OPC_CheckPredicateOrFail, 52, 
/* 1982 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 1986 */    MCD::OPC_Decode, 225, 8, 219, 1, // Opcode: CEIL_W_S, DecodeIdx: 219
/* 1991 */    MCD::OPC_FilterValue, 15, 11, 0, // Skip to: 2006
/* 1995 */    MCD::OPC_CheckPredicateOrFail, 52, 
/* 1997 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2001 */    MCD::OPC_Decode, 156, 13, 219, 1, // Opcode: FLOOR_W_S, DecodeIdx: 219
/* 2006 */    MCD::OPC_FilterValue, 17, 23, 0, // Skip to: 2033
/* 2010 */    MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 2013 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 2024
/* 2017 */    MCD::OPC_CheckPredicateOrFail, 29, 
/* 2019 */    MCD::OPC_Decode, 231, 16, 220, 1, // Opcode: MOVF_S, DecodeIdx: 220
/* 2024 */    MCD::OPC_FilterValueOrFail, 1, 
/* 2026 */    MCD::OPC_CheckPredicateOrFail, 29, 
/* 2028 */    MCD::OPC_Decode, 251, 16, 220, 1, // Opcode: MOVT_S, DecodeIdx: 220
/* 2033 */    MCD::OPC_FilterValue, 18, 7, 0, // Skip to: 2044
/* 2037 */    MCD::OPC_CheckPredicateOrFail, 29, 
/* 2039 */    MCD::OPC_Decode, 135, 17, 221, 1, // Opcode: MOVZ_I_S, DecodeIdx: 221
/* 2044 */    MCD::OPC_FilterValue, 19, 7, 0, // Skip to: 2055
/* 2048 */    MCD::OPC_CheckPredicateOrFail, 29, 
/* 2050 */    MCD::OPC_Decode, 243, 16, 221, 1, // Opcode: MOVN_I_S, DecodeIdx: 221
/* 2055 */    MCD::OPC_FilterValue, 21, 11, 0, // Skip to: 2070
/* 2059 */    MCD::OPC_CheckPredicateOrFail, 54, 
/* 2061 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2065 */    MCD::OPC_Decode, 251, 18, 219, 1, // Opcode: RECIP_S, DecodeIdx: 219
/* 2070 */    MCD::OPC_FilterValue, 22, 11, 0, // Skip to: 2085
/* 2074 */    MCD::OPC_CheckPredicateOrFail, 54, 
/* 2076 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2080 */    MCD::OPC_Decode, 156, 19, 219, 1, // Opcode: RSQRT_S, DecodeIdx: 219
/* 2085 */    MCD::OPC_FilterValue, 33, 11, 0, // Skip to: 2100
/* 2089 */    MCD::OPC_CheckPredicateOrFail, 55, 
/* 2091 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2095 */    MCD::OPC_Decode, 139, 10, 222, 1, // Opcode: CVT_D32_S, DecodeIdx: 222
/* 2100 */    MCD::OPC_FilterValue, 36, 11, 0, // Skip to: 2115
/* 2104 */    MCD::OPC_CheckPredicateOrFail, 47, 
/* 2106 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2110 */    MCD::OPC_Decode, 173, 10, 219, 1, // Opcode: CVT_W_S, DecodeIdx: 219
/* 2115 */    MCD::OPC_FilterValue, 37, 11, 0, // Skip to: 2130
/* 2119 */    MCD::OPC_CheckPredicateOrFail, 56, 
/* 2121 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2125 */    MCD::OPC_Decode, 152, 10, 223, 1, // Opcode: CVT_L_S, DecodeIdx: 223
/* 2130 */    MCD::OPC_FilterValue, 48, 11, 0, // Skip to: 2145
/* 2134 */    MCD::OPC_CheckPredicateOrFail, 50, 
/* 2136 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2140 */    MCD::OPC_Decode, 186, 10, 224, 1, // Opcode: C_F_S, DecodeIdx: 224
/* 2145 */    MCD::OPC_FilterValue, 49, 11, 0, // Skip to: 2160
/* 2149 */    MCD::OPC_CheckPredicateOrFail, 50, 
/* 2151 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2155 */    MCD::OPC_Decode, 142, 11, 224, 1, // Opcode: C_UN_S, DecodeIdx: 224
/* 2160 */    MCD::OPC_FilterValue, 50, 11, 0, // Skip to: 2175
/* 2164 */    MCD::OPC_CheckPredicateOrFail, 50, 
/* 2166 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2170 */    MCD::OPC_Decode, 180, 10, 224, 1, // Opcode: C_EQ_S, DecodeIdx: 224
/* 2175 */    MCD::OPC_FilterValue, 51, 11, 0, // Skip to: 2190
/* 2179 */    MCD::OPC_CheckPredicateOrFail, 50, 
/* 2181 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2185 */    MCD::OPC_Decode, 252, 10, 224, 1, // Opcode: C_UEQ_S, DecodeIdx: 224
/* 2190 */    MCD::OPC_FilterValue, 52, 11, 0, // Skip to: 2205
/* 2194 */    MCD::OPC_CheckPredicateOrFail, 50, 
/* 2196 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2200 */    MCD::OPC_Decode, 234, 10, 224, 1, // Opcode: C_OLT_S, DecodeIdx: 224
/* 2205 */    MCD::OPC_FilterValue, 53, 11, 0, // Skip to: 2220
/* 2209 */    MCD::OPC_CheckPredicateOrFail, 50, 
/* 2211 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2215 */    MCD::OPC_Decode, 136, 11, 224, 1, // Opcode: C_ULT_S, DecodeIdx: 224
/* 2220 */    MCD::OPC_FilterValue, 54, 11, 0, // Skip to: 2235
/* 2224 */    MCD::OPC_CheckPredicateOrFail, 50, 
/* 2226 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2230 */    MCD::OPC_Decode, 228, 10, 224, 1, // Opcode: C_OLE_S, DecodeIdx: 224
/* 2235 */    MCD::OPC_FilterValue, 55, 11, 0, // Skip to: 2250
/* 2239 */    MCD::OPC_CheckPredicateOrFail, 50, 
/* 2241 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2245 */    MCD::OPC_Decode, 130, 11, 224, 1, // Opcode: C_ULE_S, DecodeIdx: 224
/* 2250 */    MCD::OPC_FilterValue, 56, 11, 0, // Skip to: 2265
/* 2254 */    MCD::OPC_CheckPredicateOrFail, 50, 
/* 2256 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2260 */    MCD::OPC_Decode, 246, 10, 224, 1, // Opcode: C_SF_S, DecodeIdx: 224
/* 2265 */    MCD::OPC_FilterValue, 57, 11, 0, // Skip to: 2280
/* 2269 */    MCD::OPC_CheckPredicateOrFail, 50, 
/* 2271 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2275 */    MCD::OPC_Decode, 210, 10, 224, 1, // Opcode: C_NGLE_S, DecodeIdx: 224
/* 2280 */    MCD::OPC_FilterValue, 58, 11, 0, // Skip to: 2295
/* 2284 */    MCD::OPC_CheckPredicateOrFail, 50, 
/* 2286 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2290 */    MCD::OPC_Decode, 240, 10, 224, 1, // Opcode: C_SEQ_S, DecodeIdx: 224
/* 2295 */    MCD::OPC_FilterValue, 59, 11, 0, // Skip to: 2310
/* 2299 */    MCD::OPC_CheckPredicateOrFail, 50, 
/* 2301 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2305 */    MCD::OPC_Decode, 216, 10, 224, 1, // Opcode: C_NGL_S, DecodeIdx: 224
/* 2310 */    MCD::OPC_FilterValue, 60, 11, 0, // Skip to: 2325
/* 2314 */    MCD::OPC_CheckPredicateOrFail, 50, 
/* 2316 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2320 */    MCD::OPC_Decode, 198, 10, 224, 1, // Opcode: C_LT_S, DecodeIdx: 224
/* 2325 */    MCD::OPC_FilterValue, 61, 11, 0, // Skip to: 2340
/* 2329 */    MCD::OPC_CheckPredicateOrFail, 50, 
/* 2331 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2335 */    MCD::OPC_Decode, 204, 10, 224, 1, // Opcode: C_NGE_S, DecodeIdx: 224
/* 2340 */    MCD::OPC_FilterValue, 62, 11, 0, // Skip to: 2355
/* 2344 */    MCD::OPC_CheckPredicateOrFail, 50, 
/* 2346 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2350 */    MCD::OPC_Decode, 192, 10, 224, 1, // Opcode: C_LE_S, DecodeIdx: 224
/* 2355 */    MCD::OPC_FilterValueOrFail, 63, 
/* 2357 */    MCD::OPC_CheckPredicateOrFail, 50, 
/* 2359 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2363 */    MCD::OPC_Decode, 222, 10, 224, 1, // Opcode: C_NGT_S, DecodeIdx: 224
/* 2368 */    MCD::OPC_FilterValue, 17, 17, 2, // Skip to: 2901
/* 2372 */    MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 2375 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 2386
/* 2379 */    MCD::OPC_CheckPredicateOrFail, 55, 
/* 2381 */    MCD::OPC_Decode, 207, 12, 225, 1, // Opcode: FADD_D32, DecodeIdx: 225
/* 2386 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 2397
/* 2390 */    MCD::OPC_CheckPredicateOrFail, 55, 
/* 2392 */    MCD::OPC_Decode, 224, 13, 225, 1, // Opcode: FSUB_D32, DecodeIdx: 225
/* 2397 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 2408
/* 2401 */    MCD::OPC_CheckPredicateOrFail, 55, 
/* 2403 */    MCD::OPC_Decode, 180, 13, 225, 1, // Opcode: FMUL_D32, DecodeIdx: 225
/* 2408 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 2419
/* 2412 */    MCD::OPC_CheckPredicateOrFail, 55, 
/* 2414 */    MCD::OPC_Decode, 246, 12, 225, 1, // Opcode: FDIV_D32, DecodeIdx: 225
/* 2419 */    MCD::OPC_FilterValue, 4, 11, 0, // Skip to: 2434
/* 2423 */    MCD::OPC_CheckPredicateOrFail, 57, 
/* 2425 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2429 */    MCD::OPC_Decode, 216, 13, 226, 1, // Opcode: FSQRT_D32, DecodeIdx: 226
/* 2434 */    MCD::OPC_FilterValue, 5, 11, 0, // Skip to: 2449
/* 2438 */    MCD::OPC_CheckPredicateOrFail, 55, 
/* 2440 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2444 */    MCD::OPC_Decode, 200, 12, 226, 1, // Opcode: FABS_D32, DecodeIdx: 226
/* 2449 */    MCD::OPC_FilterValue, 6, 11, 0, // Skip to: 2464
/* 2453 */    MCD::OPC_CheckPredicateOrFail, 55, 
/* 2455 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2459 */    MCD::OPC_Decode, 169, 13, 226, 1, // Opcode: FMOV_D32, DecodeIdx: 226
/* 2464 */    MCD::OPC_FilterValue, 7, 11, 0, // Skip to: 2479
/* 2468 */    MCD::OPC_CheckPredicateOrFail, 55, 
/* 2470 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2474 */    MCD::OPC_Decode, 189, 13, 226, 1, // Opcode: FNEG_D32, DecodeIdx: 226
/* 2479 */    MCD::OPC_FilterValue, 12, 11, 0, // Skip to: 2494
/* 2483 */    MCD::OPC_CheckPredicateOrFail, 57, 
/* 2485 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2489 */    MCD::OPC_Decode, 145, 19, 227, 1, // Opcode: ROUND_W_D32, DecodeIdx: 227
/* 2494 */    MCD::OPC_FilterValue, 13, 11, 0, // Skip to: 2509
/* 2498 */    MCD::OPC_CheckPredicateOrFail, 57, 
/* 2500 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2504 */    MCD::OPC_Decode, 184, 22, 227, 1, // Opcode: TRUNC_W_D32, DecodeIdx: 227
/* 2509 */    MCD::OPC_FilterValue, 14, 11, 0, // Skip to: 2524
/* 2513 */    MCD::OPC_CheckPredicateOrFail, 57, 
/* 2515 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2519 */    MCD::OPC_Decode, 221, 8, 227, 1, // Opcode: CEIL_W_D32, DecodeIdx: 227
/* 2524 */    MCD::OPC_FilterValue, 15, 11, 0, // Skip to: 2539
/* 2528 */    MCD::OPC_CheckPredicateOrFail, 57, 
/* 2530 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2534 */    MCD::OPC_Decode, 152, 13, 227, 1, // Opcode: FLOOR_W_D32, DecodeIdx: 227
/* 2539 */    MCD::OPC_FilterValue, 17, 23, 0, // Skip to: 2566
/* 2543 */    MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 2546 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 2557
/* 2550 */    MCD::OPC_CheckPredicateOrFail, 58, 
/* 2552 */    MCD::OPC_Decode, 225, 16, 228, 1, // Opcode: MOVF_D32, DecodeIdx: 228
/* 2557 */    MCD::OPC_FilterValueOrFail, 1, 
/* 2559 */    MCD::OPC_CheckPredicateOrFail, 58, 
/* 2561 */    MCD::OPC_Decode, 245, 16, 228, 1, // Opcode: MOVT_D32, DecodeIdx: 228
/* 2566 */    MCD::OPC_FilterValue, 18, 7, 0, // Skip to: 2577
/* 2570 */    MCD::OPC_CheckPredicateOrFail, 58, 
/* 2572 */    MCD::OPC_Decode, 129, 17, 229, 1, // Opcode: MOVZ_I_D32, DecodeIdx: 229
/* 2577 */    MCD::OPC_FilterValue, 19, 7, 0, // Skip to: 2588
/* 2581 */    MCD::OPC_CheckPredicateOrFail, 58, 
/* 2583 */    MCD::OPC_Decode, 237, 16, 229, 1, // Opcode: MOVN_I_D32, DecodeIdx: 229
/* 2588 */    MCD::OPC_FilterValue, 21, 11, 0, // Skip to: 2603
/* 2592 */    MCD::OPC_CheckPredicateOrFail, 59, 
/* 2594 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2598 */    MCD::OPC_Decode, 247, 18, 226, 1, // Opcode: RECIP_D32, DecodeIdx: 226
/* 2603 */    MCD::OPC_FilterValue, 22, 11, 0, // Skip to: 2618
/* 2607 */    MCD::OPC_CheckPredicateOrFail, 59, 
/* 2609 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2613 */    MCD::OPC_Decode, 152, 19, 226, 1, // Opcode: RSQRT_D32, DecodeIdx: 226
/* 2618 */    MCD::OPC_FilterValue, 32, 11, 0, // Skip to: 2633
/* 2622 */    MCD::OPC_CheckPredicateOrFail, 55, 
/* 2624 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2628 */    MCD::OPC_Decode, 158, 10, 227, 1, // Opcode: CVT_S_D32, DecodeIdx: 227
/* 2633 */    MCD::OPC_FilterValue, 36, 11, 0, // Skip to: 2648
/* 2637 */    MCD::OPC_CheckPredicateOrFail, 55, 
/* 2639 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2643 */    MCD::OPC_Decode, 169, 10, 227, 1, // Opcode: CVT_W_D32, DecodeIdx: 227
/* 2648 */    MCD::OPC_FilterValue, 37, 11, 0, // Skip to: 2663
/* 2652 */    MCD::OPC_CheckPredicateOrFail, 56, 
/* 2654 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2658 */    MCD::OPC_Decode, 149, 10, 230, 1, // Opcode: CVT_L_D64, DecodeIdx: 230
/* 2663 */    MCD::OPC_FilterValue, 48, 11, 0, // Skip to: 2678
/* 2667 */    MCD::OPC_CheckPredicateOrFail, 60, 
/* 2669 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2673 */    MCD::OPC_Decode, 182, 10, 231, 1, // Opcode: C_F_D32, DecodeIdx: 231
/* 2678 */    MCD::OPC_FilterValue, 49, 11, 0, // Skip to: 2693
/* 2682 */    MCD::OPC_CheckPredicateOrFail, 60, 
/* 2684 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2688 */    MCD::OPC_Decode, 138, 11, 231, 1, // Opcode: C_UN_D32, DecodeIdx: 231
/* 2693 */    MCD::OPC_FilterValue, 50, 11, 0, // Skip to: 2708
/* 2697 */    MCD::OPC_CheckPredicateOrFail, 60, 
/* 2699 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2703 */    MCD::OPC_Decode, 176, 10, 231, 1, // Opcode: C_EQ_D32, DecodeIdx: 231
/* 2708 */    MCD::OPC_FilterValue, 51, 11, 0, // Skip to: 2723
/* 2712 */    MCD::OPC_CheckPredicateOrFail, 60, 
/* 2714 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2718 */    MCD::OPC_Decode, 248, 10, 231, 1, // Opcode: C_UEQ_D32, DecodeIdx: 231
/* 2723 */    MCD::OPC_FilterValue, 52, 11, 0, // Skip to: 2738
/* 2727 */    MCD::OPC_CheckPredicateOrFail, 60, 
/* 2729 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2733 */    MCD::OPC_Decode, 230, 10, 231, 1, // Opcode: C_OLT_D32, DecodeIdx: 231
/* 2738 */    MCD::OPC_FilterValue, 53, 11, 0, // Skip to: 2753
/* 2742 */    MCD::OPC_CheckPredicateOrFail, 60, 
/* 2744 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2748 */    MCD::OPC_Decode, 132, 11, 231, 1, // Opcode: C_ULT_D32, DecodeIdx: 231
/* 2753 */    MCD::OPC_FilterValue, 54, 11, 0, // Skip to: 2768
/* 2757 */    MCD::OPC_CheckPredicateOrFail, 60, 
/* 2759 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2763 */    MCD::OPC_Decode, 224, 10, 231, 1, // Opcode: C_OLE_D32, DecodeIdx: 231
/* 2768 */    MCD::OPC_FilterValue, 55, 11, 0, // Skip to: 2783
/* 2772 */    MCD::OPC_CheckPredicateOrFail, 60, 
/* 2774 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2778 */    MCD::OPC_Decode, 254, 10, 231, 1, // Opcode: C_ULE_D32, DecodeIdx: 231
/* 2783 */    MCD::OPC_FilterValue, 56, 11, 0, // Skip to: 2798
/* 2787 */    MCD::OPC_CheckPredicateOrFail, 60, 
/* 2789 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2793 */    MCD::OPC_Decode, 242, 10, 231, 1, // Opcode: C_SF_D32, DecodeIdx: 231
/* 2798 */    MCD::OPC_FilterValue, 57, 11, 0, // Skip to: 2813
/* 2802 */    MCD::OPC_CheckPredicateOrFail, 60, 
/* 2804 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2808 */    MCD::OPC_Decode, 206, 10, 231, 1, // Opcode: C_NGLE_D32, DecodeIdx: 231
/* 2813 */    MCD::OPC_FilterValue, 58, 11, 0, // Skip to: 2828
/* 2817 */    MCD::OPC_CheckPredicateOrFail, 60, 
/* 2819 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2823 */    MCD::OPC_Decode, 236, 10, 231, 1, // Opcode: C_SEQ_D32, DecodeIdx: 231
/* 2828 */    MCD::OPC_FilterValue, 59, 11, 0, // Skip to: 2843
/* 2832 */    MCD::OPC_CheckPredicateOrFail, 60, 
/* 2834 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2838 */    MCD::OPC_Decode, 212, 10, 231, 1, // Opcode: C_NGL_D32, DecodeIdx: 231
/* 2843 */    MCD::OPC_FilterValue, 60, 11, 0, // Skip to: 2858
/* 2847 */    MCD::OPC_CheckPredicateOrFail, 60, 
/* 2849 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2853 */    MCD::OPC_Decode, 194, 10, 231, 1, // Opcode: C_LT_D32, DecodeIdx: 231
/* 2858 */    MCD::OPC_FilterValue, 61, 11, 0, // Skip to: 2873
/* 2862 */    MCD::OPC_CheckPredicateOrFail, 60, 
/* 2864 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2868 */    MCD::OPC_Decode, 200, 10, 231, 1, // Opcode: C_NGE_D32, DecodeIdx: 231
/* 2873 */    MCD::OPC_FilterValue, 62, 11, 0, // Skip to: 2888
/* 2877 */    MCD::OPC_CheckPredicateOrFail, 60, 
/* 2879 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2883 */    MCD::OPC_Decode, 188, 10, 231, 1, // Opcode: C_LE_D32, DecodeIdx: 231
/* 2888 */    MCD::OPC_FilterValueOrFail, 63, 
/* 2890 */    MCD::OPC_CheckPredicateOrFail, 60, 
/* 2892 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 2896 */    MCD::OPC_Decode, 218, 10, 231, 1, // Opcode: C_NGT_D32, DecodeIdx: 231
/* 2901 */    MCD::OPC_FilterValue, 20, 31, 0, // Skip to: 2936
/* 2905 */    MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 2908 */    MCD::OPC_FilterValue, 32, 11, 0, // Skip to: 2923
/* 2912 */    MCD::OPC_CheckPredicateOrFail, 47, 
/* 2914 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2918 */    MCD::OPC_Decode, 166, 10, 219, 1, // Opcode: CVT_S_W, DecodeIdx: 219
/* 2923 */    MCD::OPC_FilterValueOrFail, 33, 
/* 2925 */    MCD::OPC_CheckPredicateOrFail, 55, 
/* 2927 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 2931 */    MCD::OPC_Decode, 141, 10, 222, 1, // Opcode: CVT_D32_W, DecodeIdx: 222
/* 2936 */    MCD::OPC_FilterValue, 24, 7, 0, // Skip to: 2947
/* 2940 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 2942 */    MCD::OPC_Decode, 195, 8, 217, 1, // Opcode: BZ_B, DecodeIdx: 217
/* 2947 */    MCD::OPC_FilterValue, 25, 7, 0, // Skip to: 2958
/* 2951 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 2953 */    MCD::OPC_Decode, 197, 8, 232, 1, // Opcode: BZ_H, DecodeIdx: 232
/* 2958 */    MCD::OPC_FilterValue, 26, 7, 0, // Skip to: 2969
/* 2962 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 2964 */    MCD::OPC_Decode, 199, 8, 233, 1, // Opcode: BZ_W, DecodeIdx: 233
/* 2969 */    MCD::OPC_FilterValue, 27, 7, 0, // Skip to: 2980
/* 2973 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 2975 */    MCD::OPC_Decode, 196, 8, 234, 1, // Opcode: BZ_D, DecodeIdx: 234
/* 2980 */    MCD::OPC_FilterValue, 28, 7, 0, // Skip to: 2991
/* 2984 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 2986 */    MCD::OPC_Decode, 170, 8, 217, 1, // Opcode: BNZ_B, DecodeIdx: 217
/* 2991 */    MCD::OPC_FilterValue, 29, 7, 0, // Skip to: 3002
/* 2995 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 2997 */    MCD::OPC_Decode, 172, 8, 232, 1, // Opcode: BNZ_H, DecodeIdx: 232
/* 3002 */    MCD::OPC_FilterValue, 30, 7, 0, // Skip to: 3013
/* 3006 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3008 */    MCD::OPC_Decode, 174, 8, 233, 1, // Opcode: BNZ_W, DecodeIdx: 233
/* 3013 */    MCD::OPC_FilterValueOrFail, 31, 
/* 3015 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3017 */    MCD::OPC_Decode, 171, 8, 234, 1, // Opcode: BNZ_D, DecodeIdx: 234
/* 3022 */    MCD::OPC_FilterValue, 18, 31, 0, // Skip to: 3057
/* 3026 */    MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 3029 */    MCD::OPC_FilterValue, 0, 11, 0, // Skip to: 3044
/* 3033 */    MCD::OPC_CheckPredicateOrFail, 27, 
/* 3035 */    MCD::OPC_CheckFieldOrFail, 3, 8, 0, 
/* 3039 */    MCD::OPC_Decode, 153, 16, 235, 1, // Opcode: MFC2, DecodeIdx: 235
/* 3044 */    MCD::OPC_FilterValueOrFail, 4, 
/* 3046 */    MCD::OPC_CheckPredicateOrFail, 27, 
/* 3048 */    MCD::OPC_CheckFieldOrFail, 3, 8, 0, 
/* 3052 */    MCD::OPC_Decode, 169, 17, 236, 1, // Opcode: MTC2, DecodeIdx: 236
/* 3057 */    MCD::OPC_FilterValue, 19, 179, 0, // Skip to: 3240
/* 3061 */    MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 3064 */    MCD::OPC_FilterValue, 0, 11, 0, // Skip to: 3079
/* 3068 */    MCD::OPC_CheckPredicateOrFail, 61, 
/* 3070 */    MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 3074 */    MCD::OPC_Decode, 196, 15, 237, 1, // Opcode: LWXC1, DecodeIdx: 237
/* 3079 */    MCD::OPC_FilterValue, 1, 11, 0, // Skip to: 3094
/* 3083 */    MCD::OPC_CheckPredicateOrFail, 62, 
/* 3085 */    MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 3089 */    MCD::OPC_Decode, 246, 14, 238, 1, // Opcode: LDXC1, DecodeIdx: 238
/* 3094 */    MCD::OPC_FilterValue, 5, 11, 0, // Skip to: 3109
/* 3098 */    MCD::OPC_CheckPredicateOrFail, 63, 
/* 3100 */    MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 3104 */    MCD::OPC_Decode, 156, 15, 238, 1, // Opcode: LUXC1, DecodeIdx: 238
/* 3109 */    MCD::OPC_FilterValue, 8, 11, 0, // Skip to: 3124
/* 3113 */    MCD::OPC_CheckPredicateOrFail, 61, 
/* 3115 */    MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 3119 */    MCD::OPC_Decode, 228, 21, 239, 1, // Opcode: SWXC1, DecodeIdx: 239
/* 3124 */    MCD::OPC_FilterValue, 9, 11, 0, // Skip to: 3139
/* 3128 */    MCD::OPC_CheckPredicateOrFail, 62, 
/* 3130 */    MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 3134 */    MCD::OPC_Decode, 208, 19, 240, 1, // Opcode: SDXC1, DecodeIdx: 240
/* 3139 */    MCD::OPC_FilterValue, 13, 11, 0, // Skip to: 3154
/* 3143 */    MCD::OPC_CheckPredicateOrFail, 63, 
/* 3145 */    MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 3149 */    MCD::OPC_Decode, 195, 21, 240, 1, // Opcode: SUXC1, DecodeIdx: 240
/* 3154 */    MCD::OPC_FilterValue, 32, 7, 0, // Skip to: 3165
/* 3158 */    MCD::OPC_CheckPredicateOrFail, 64, 
/* 3160 */    MCD::OPC_Decode, 237, 15, 241, 1, // Opcode: MADD_S, DecodeIdx: 241
/* 3165 */    MCD::OPC_FilterValue, 33, 7, 0, // Skip to: 3176
/* 3169 */    MCD::OPC_CheckPredicateOrFail, 65, 
/* 3171 */    MCD::OPC_Decode, 229, 15, 242, 1, // Opcode: MADD_D32, DecodeIdx: 242
/* 3176 */    MCD::OPC_FilterValue, 40, 7, 0, // Skip to: 3187
/* 3180 */    MCD::OPC_CheckPredicateOrFail, 64, 
/* 3182 */    MCD::OPC_Decode, 160, 17, 241, 1, // Opcode: MSUB_S, DecodeIdx: 241
/* 3187 */    MCD::OPC_FilterValue, 41, 7, 0, // Skip to: 3198
/* 3191 */    MCD::OPC_CheckPredicateOrFail, 65, 
/* 3193 */    MCD::OPC_Decode, 152, 17, 242, 1, // Opcode: MSUB_D32, DecodeIdx: 242
/* 3198 */    MCD::OPC_FilterValue, 48, 7, 0, // Skip to: 3209
/* 3202 */    MCD::OPC_CheckPredicateOrFail, 66, 
/* 3204 */    MCD::OPC_Decode, 139, 18, 241, 1, // Opcode: NMADD_S, DecodeIdx: 241
/* 3209 */    MCD::OPC_FilterValue, 49, 7, 0, // Skip to: 3220
/* 3213 */    MCD::OPC_CheckPredicateOrFail, 67, 
/* 3215 */    MCD::OPC_Decode, 136, 18, 242, 1, // Opcode: NMADD_D32, DecodeIdx: 242
/* 3220 */    MCD::OPC_FilterValue, 56, 7, 0, // Skip to: 3231
/* 3224 */    MCD::OPC_CheckPredicateOrFail, 66, 
/* 3226 */    MCD::OPC_Decode, 144, 18, 241, 1, // Opcode: NMSUB_S, DecodeIdx: 241
/* 3231 */    MCD::OPC_FilterValueOrFail, 57, 
/* 3233 */    MCD::OPC_CheckPredicateOrFail, 67, 
/* 3235 */    MCD::OPC_Decode, 141, 18, 242, 1, // Opcode: NMSUB_D32, DecodeIdx: 242
/* 3240 */    MCD::OPC_FilterValue, 20, 7, 0, // Skip to: 3251
/* 3244 */    MCD::OPC_CheckPredicateOrFail, 39, 
/* 3246 */    MCD::OPC_Decode, 183, 7, 201, 1, // Opcode: BEQL, DecodeIdx: 201
/* 3251 */    MCD::OPC_FilterValue, 21, 92, 0, // Skip to: 3347
/* 3255 */    MCD::OPC_ExtractField, 0, 16,  // Inst{15-0} ...
/* 3258 */    MCD::OPC_FilterValue, 123, 8, 0, // Skip to: 3270
/* 3262 */    MCD::OPC_CheckPredicate, 19, 17, 0, // Skip to: 3283
/* 3266 */    MCD::OPC_Decode, 175, 13, 124, // Opcode: FMOV_S_MM, DecodeIdx: 124
/* 3270 */    MCD::OPC_FilterValue, 251, 22, 8, 0, // Skip to: 3283
/* 3275 */    MCD::OPC_CheckPredicate, 19, 4, 0, // Skip to: 3283
/* 3279 */    MCD::OPC_Decode, 194, 13, 124, // Opcode: FNEG_S_MM, DecodeIdx: 124
/* 3283 */    MCD::OPC_ExtractField, 0, 11,  // Inst{10-0} ...
/* 3286 */    MCD::OPC_FilterValue, 48, 9, 0, // Skip to: 3299
/* 3290 */    MCD::OPC_CheckPredicate, 19, 46, 0, // Skip to: 3340
/* 3294 */    MCD::OPC_Decode, 213, 12, 164, 1, // Opcode: FADD_S_MM, DecodeIdx: 164
/* 3299 */    MCD::OPC_FilterValue, 112, 9, 0, // Skip to: 3312
/* 3303 */    MCD::OPC_CheckPredicate, 19, 33, 0, // Skip to: 3340
/* 3307 */    MCD::OPC_Decode, 230, 13, 164, 1, // Opcode: FSUB_S_MM, DecodeIdx: 164
/* 3312 */    MCD::OPC_FilterValue, 176, 1, 9, 0, // Skip to: 3326
/* 3317 */    MCD::OPC_CheckPredicate, 19, 19, 0, // Skip to: 3340
/* 3321 */    MCD::OPC_Decode, 186, 13, 164, 1, // Opcode: FMUL_S_MM, DecodeIdx: 164
/* 3326 */    MCD::OPC_FilterValue, 240, 1, 9, 0, // Skip to: 3340
/* 3331 */    MCD::OPC_CheckPredicate, 19, 5, 0, // Skip to: 3340
/* 3335 */    MCD::OPC_Decode, 251, 12, 164, 1, // Opcode: FDIV_S_MM, DecodeIdx: 164
/* 3340 */    MCD::OPC_CheckPredicateOrFail, 39, 
/* 3342 */    MCD::OPC_Decode, 158, 8, 201, 1, // Opcode: BNEL, DecodeIdx: 201
/* 3347 */    MCD::OPC_FilterValue, 22, 11, 0, // Skip to: 3362
/* 3351 */    MCD::OPC_CheckPredicateOrFail, 39, 
/* 3353 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 3357 */    MCD::OPC_Decode, 248, 7, 197, 1, // Opcode: BLEZL, DecodeIdx: 197
/* 3362 */    MCD::OPC_FilterValue, 23, 11, 0, // Skip to: 3377
/* 3366 */    MCD::OPC_CheckPredicateOrFail, 39, 
/* 3368 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 3372 */    MCD::OPC_Decode, 219, 7, 197, 1, // Opcode: BGTZL, DecodeIdx: 197
/* 3377 */    MCD::OPC_FilterValue, 28, 196, 0, // Skip to: 3577
/* 3381 */    MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 3384 */    MCD::OPC_FilterValue, 0, 31, 0, // Skip to: 3419
/* 3388 */    MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 3391 */    MCD::OPC_FilterValueOrFail, 0, 
/* 3393 */    MCD::OPC_ExtractField, 13, 3,  // Inst{15-13} ...
/* 3396 */    MCD::OPC_FilterValueOrFail, 0, 
/* 3398 */    MCD::OPC_CheckPredicate, 68, 10, 0, // Skip to: 3412
/* 3402 */    MCD::OPC_CheckField, 11, 2, 0, 4, 0, // Skip to: 3412
/* 3408 */    MCD::OPC_Decode, 214, 15, 80, // Opcode: MADD, DecodeIdx: 80
/* 3412 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 3414 */    MCD::OPC_Decode, 232, 15, 243, 1, // Opcode: MADD_DSP, DecodeIdx: 243
/* 3419 */    MCD::OPC_FilterValue, 1, 31, 0, // Skip to: 3454
/* 3423 */    MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 3426 */    MCD::OPC_FilterValueOrFail, 0, 
/* 3428 */    MCD::OPC_ExtractField, 13, 3,  // Inst{15-13} ...
/* 3431 */    MCD::OPC_FilterValueOrFail, 0, 
/* 3433 */    MCD::OPC_CheckPredicate, 68, 10, 0, // Skip to: 3447
/* 3437 */    MCD::OPC_CheckField, 11, 2, 0, 4, 0, // Skip to: 3447
/* 3443 */    MCD::OPC_Decode, 221, 15, 80, // Opcode: MADDU, DecodeIdx: 80
/* 3447 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 3449 */    MCD::OPC_Decode, 222, 15, 243, 1, // Opcode: MADDU_DSP, DecodeIdx: 243
/* 3454 */    MCD::OPC_FilterValue, 2, 10, 0, // Skip to: 3468
/* 3458 */    MCD::OPC_CheckPredicateOrFail, 68, 
/* 3460 */    MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 3464 */    MCD::OPC_Decode, 204, 17, 61, // Opcode: MUL, DecodeIdx: 61
/* 3468 */    MCD::OPC_FilterValue, 4, 31, 0, // Skip to: 3503
/* 3472 */    MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 3475 */    MCD::OPC_FilterValueOrFail, 0, 
/* 3477 */    MCD::OPC_ExtractField, 13, 3,  // Inst{15-13} ...
/* 3480 */    MCD::OPC_FilterValueOrFail, 0, 
/* 3482 */    MCD::OPC_CheckPredicate, 68, 10, 0, // Skip to: 3496
/* 3486 */    MCD::OPC_CheckField, 11, 2, 0, 4, 0, // Skip to: 3496
/* 3492 */    MCD::OPC_Decode, 137, 17, 80, // Opcode: MSUB, DecodeIdx: 80
/* 3496 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 3498 */    MCD::OPC_Decode, 155, 17, 243, 1, // Opcode: MSUB_DSP, DecodeIdx: 243
/* 3503 */    MCD::OPC_FilterValue, 5, 31, 0, // Skip to: 3538
/* 3507 */    MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 3510 */    MCD::OPC_FilterValueOrFail, 0, 
/* 3512 */    MCD::OPC_ExtractField, 13, 3,  // Inst{15-13} ...
/* 3515 */    MCD::OPC_FilterValueOrFail, 0, 
/* 3517 */    MCD::OPC_CheckPredicate, 68, 10, 0, // Skip to: 3531
/* 3521 */    MCD::OPC_CheckField, 11, 2, 0, 4, 0, // Skip to: 3531
/* 3527 */    MCD::OPC_Decode, 144, 17, 80, // Opcode: MSUBU, DecodeIdx: 80
/* 3531 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 3533 */    MCD::OPC_Decode, 145, 17, 243, 1, // Opcode: MSUBU_DSP, DecodeIdx: 243
/* 3538 */    MCD::OPC_FilterValue, 32, 11, 0, // Skip to: 3553
/* 3542 */    MCD::OPC_CheckPredicateOrFail, 68, 
/* 3544 */    MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 3548 */    MCD::OPC_Decode, 156, 9, 244, 1, // Opcode: CLZ, DecodeIdx: 244
/* 3553 */    MCD::OPC_FilterValue, 33, 11, 0, // Skip to: 3568
/* 3557 */    MCD::OPC_CheckPredicateOrFail, 68, 
/* 3559 */    MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 3563 */    MCD::OPC_Decode, 136, 9, 244, 1, // Opcode: CLO, DecodeIdx: 244
/* 3568 */    MCD::OPC_FilterValueOrFail, 63, 
/* 3570 */    MCD::OPC_CheckPredicateOrFail, 68, 
/* 3572 */    MCD::OPC_Decode, 189, 19, 188, 1, // Opcode: SDBBP, DecodeIdx: 188
/* 3577 */    MCD::OPC_FilterValue, 29, 7, 0, // Skip to: 3588
/* 3581 */    MCD::OPC_CheckPredicateOrFail, 68, 
/* 3583 */    MCD::OPC_Decode, 186, 14, 200, 1, // Opcode: JALX, DecodeIdx: 200
/* 3588 */    MCD::OPC_FilterValue, 30, 190, 23, // Skip to: 9670
/* 3592 */    MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 3595 */    MCD::OPC_FilterValue, 0, 45, 0, // Skip to: 3644
/* 3599 */    MCD::OPC_ExtractField, 24, 2,  // Inst{25-24} ...
/* 3602 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 3613
/* 3606 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3608 */    MCD::OPC_Decode, 223, 6, 245, 1, // Opcode: ANDI_B, DecodeIdx: 245
/* 3613 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 3624
/* 3617 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3619 */    MCD::OPC_Decode, 160, 18, 245, 1, // Opcode: ORI_B, DecodeIdx: 245
/* 3624 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 3635
/* 3628 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3630 */    MCD::OPC_Decode, 148, 18, 245, 1, // Opcode: NORI_B, DecodeIdx: 245
/* 3635 */    MCD::OPC_FilterValueOrFail, 3, 
/* 3637 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3639 */    MCD::OPC_Decode, 214, 22, 245, 1, // Opcode: XORI_B, DecodeIdx: 245
/* 3644 */    MCD::OPC_FilterValue, 1, 34, 0, // Skip to: 3682
/* 3648 */    MCD::OPC_ExtractField, 24, 2,  // Inst{25-24} ...
/* 3651 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 3662
/* 3655 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3657 */    MCD::OPC_Decode, 141, 8, 246, 1, // Opcode: BMNZI_B, DecodeIdx: 246
/* 3662 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 3673
/* 3666 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3668 */    MCD::OPC_Decode, 143, 8, 246, 1, // Opcode: BMZI_B, DecodeIdx: 246
/* 3673 */    MCD::OPC_FilterValueOrFail, 2, 
/* 3675 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3677 */    MCD::OPC_Decode, 185, 8, 246, 1, // Opcode: BSELI_B, DecodeIdx: 246
/* 3682 */    MCD::OPC_FilterValue, 2, 34, 0, // Skip to: 3720
/* 3686 */    MCD::OPC_ExtractField, 24, 2,  // Inst{25-24} ...
/* 3689 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 3700
/* 3693 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3695 */    MCD::OPC_Decode, 242, 19, 245, 1, // Opcode: SHF_B, DecodeIdx: 245
/* 3700 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 3711
/* 3704 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3706 */    MCD::OPC_Decode, 243, 19, 247, 1, // Opcode: SHF_H, DecodeIdx: 247
/* 3711 */    MCD::OPC_FilterValueOrFail, 2, 
/* 3713 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3715 */    MCD::OPC_Decode, 244, 19, 248, 1, // Opcode: SHF_W, DecodeIdx: 248
/* 3720 */    MCD::OPC_FilterValue, 6, 9, 1, // Skip to: 3989
/* 3724 */    MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 3727 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 3738
/* 3731 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3733 */    MCD::OPC_Decode, 191, 6, 249, 1, // Opcode: ADDVI_B, DecodeIdx: 249
/* 3738 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 3749
/* 3742 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3744 */    MCD::OPC_Decode, 193, 6, 250, 1, // Opcode: ADDVI_H, DecodeIdx: 250
/* 3749 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 3760
/* 3753 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3755 */    MCD::OPC_Decode, 194, 6, 251, 1, // Opcode: ADDVI_W, DecodeIdx: 251
/* 3760 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 3771
/* 3764 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3766 */    MCD::OPC_Decode, 192, 6, 252, 1, // Opcode: ADDVI_D, DecodeIdx: 252
/* 3771 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 3782
/* 3775 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3777 */    MCD::OPC_Decode, 183, 21, 249, 1, // Opcode: SUBVI_B, DecodeIdx: 249
/* 3782 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 3793
/* 3786 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3788 */    MCD::OPC_Decode, 185, 21, 250, 1, // Opcode: SUBVI_H, DecodeIdx: 250
/* 3793 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 3804
/* 3797 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3799 */    MCD::OPC_Decode, 186, 21, 251, 1, // Opcode: SUBVI_W, DecodeIdx: 251
/* 3804 */    MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 3815
/* 3808 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3810 */    MCD::OPC_Decode, 184, 21, 252, 1, // Opcode: SUBVI_D, DecodeIdx: 252
/* 3815 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 3826
/* 3819 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3821 */    MCD::OPC_Decode, 251, 15, 249, 1, // Opcode: MAXI_S_B, DecodeIdx: 249
/* 3826 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 3837
/* 3830 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3832 */    MCD::OPC_Decode, 253, 15, 250, 1, // Opcode: MAXI_S_H, DecodeIdx: 250
/* 3837 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 3848
/* 3841 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3843 */    MCD::OPC_Decode, 254, 15, 251, 1, // Opcode: MAXI_S_W, DecodeIdx: 251
/* 3848 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 3859
/* 3852 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3854 */    MCD::OPC_Decode, 252, 15, 252, 1, // Opcode: MAXI_S_D, DecodeIdx: 252
/* 3859 */    MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 3870
/* 3863 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3865 */    MCD::OPC_Decode, 255, 15, 249, 1, // Opcode: MAXI_U_B, DecodeIdx: 249
/* 3870 */    MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 3881
/* 3874 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3876 */    MCD::OPC_Decode, 129, 16, 250, 1, // Opcode: MAXI_U_H, DecodeIdx: 250
/* 3881 */    MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 3892
/* 3885 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3887 */    MCD::OPC_Decode, 130, 16, 251, 1, // Opcode: MAXI_U_W, DecodeIdx: 251
/* 3892 */    MCD::OPC_FilterValue, 15, 7, 0, // Skip to: 3903
/* 3896 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3898 */    MCD::OPC_Decode, 128, 16, 252, 1, // Opcode: MAXI_U_D, DecodeIdx: 252
/* 3903 */    MCD::OPC_FilterValue, 16, 7, 0, // Skip to: 3914
/* 3907 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3909 */    MCD::OPC_Decode, 182, 16, 249, 1, // Opcode: MINI_S_B, DecodeIdx: 249
/* 3914 */    MCD::OPC_FilterValue, 17, 7, 0, // Skip to: 3925
/* 3918 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3920 */    MCD::OPC_Decode, 184, 16, 250, 1, // Opcode: MINI_S_H, DecodeIdx: 250
/* 3925 */    MCD::OPC_FilterValue, 18, 7, 0, // Skip to: 3936
/* 3929 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3931 */    MCD::OPC_Decode, 185, 16, 251, 1, // Opcode: MINI_S_W, DecodeIdx: 251
/* 3936 */    MCD::OPC_FilterValue, 19, 7, 0, // Skip to: 3947
/* 3940 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3942 */    MCD::OPC_Decode, 183, 16, 252, 1, // Opcode: MINI_S_D, DecodeIdx: 252
/* 3947 */    MCD::OPC_FilterValue, 20, 7, 0, // Skip to: 3958
/* 3951 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3953 */    MCD::OPC_Decode, 186, 16, 249, 1, // Opcode: MINI_U_B, DecodeIdx: 249
/* 3958 */    MCD::OPC_FilterValue, 21, 7, 0, // Skip to: 3969
/* 3962 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3964 */    MCD::OPC_Decode, 188, 16, 250, 1, // Opcode: MINI_U_H, DecodeIdx: 250
/* 3969 */    MCD::OPC_FilterValue, 22, 7, 0, // Skip to: 3980
/* 3973 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3975 */    MCD::OPC_Decode, 189, 16, 251, 1, // Opcode: MINI_U_W, DecodeIdx: 251
/* 3980 */    MCD::OPC_FilterValueOrFail, 23, 
/* 3982 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 3984 */    MCD::OPC_Decode, 187, 16, 252, 1, // Opcode: MINI_U_D, DecodeIdx: 252
/* 3989 */    MCD::OPC_FilterValue, 7, 9, 1, // Skip to: 4258
/* 3993 */    MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 3996 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4007
/* 4000 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4002 */    MCD::OPC_Decode, 228, 8, 249, 1, // Opcode: CEQI_B, DecodeIdx: 249
/* 4007 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 4018
/* 4011 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4013 */    MCD::OPC_Decode, 230, 8, 250, 1, // Opcode: CEQI_H, DecodeIdx: 250
/* 4018 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 4029
/* 4022 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4024 */    MCD::OPC_Decode, 231, 8, 251, 1, // Opcode: CEQI_W, DecodeIdx: 251
/* 4029 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 4040
/* 4033 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4035 */    MCD::OPC_Decode, 229, 8, 252, 1, // Opcode: CEQI_D, DecodeIdx: 252
/* 4040 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 4051
/* 4044 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4046 */    MCD::OPC_Decode, 140, 9, 249, 1, // Opcode: CLTI_S_B, DecodeIdx: 249
/* 4051 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 4062
/* 4055 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4057 */    MCD::OPC_Decode, 142, 9, 250, 1, // Opcode: CLTI_S_H, DecodeIdx: 250
/* 4062 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 4073
/* 4066 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4068 */    MCD::OPC_Decode, 143, 9, 251, 1, // Opcode: CLTI_S_W, DecodeIdx: 251
/* 4073 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 4084
/* 4077 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4079 */    MCD::OPC_Decode, 141, 9, 252, 1, // Opcode: CLTI_S_D, DecodeIdx: 252
/* 4084 */    MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 4095
/* 4088 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4090 */    MCD::OPC_Decode, 144, 9, 249, 1, // Opcode: CLTI_U_B, DecodeIdx: 249
/* 4095 */    MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 4106
/* 4099 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4101 */    MCD::OPC_Decode, 146, 9, 250, 1, // Opcode: CLTI_U_H, DecodeIdx: 250
/* 4106 */    MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 4117
/* 4110 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4112 */    MCD::OPC_Decode, 147, 9, 251, 1, // Opcode: CLTI_U_W, DecodeIdx: 251
/* 4117 */    MCD::OPC_FilterValue, 15, 7, 0, // Skip to: 4128
/* 4121 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4123 */    MCD::OPC_Decode, 145, 9, 252, 1, // Opcode: CLTI_U_D, DecodeIdx: 252
/* 4128 */    MCD::OPC_FilterValue, 16, 7, 0, // Skip to: 4139
/* 4132 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4134 */    MCD::OPC_Decode, 248, 8, 249, 1, // Opcode: CLEI_S_B, DecodeIdx: 249
/* 4139 */    MCD::OPC_FilterValue, 17, 7, 0, // Skip to: 4150
/* 4143 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4145 */    MCD::OPC_Decode, 250, 8, 250, 1, // Opcode: CLEI_S_H, DecodeIdx: 250
/* 4150 */    MCD::OPC_FilterValue, 18, 7, 0, // Skip to: 4161
/* 4154 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4156 */    MCD::OPC_Decode, 251, 8, 251, 1, // Opcode: CLEI_S_W, DecodeIdx: 251
/* 4161 */    MCD::OPC_FilterValue, 19, 7, 0, // Skip to: 4172
/* 4165 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4167 */    MCD::OPC_Decode, 249, 8, 252, 1, // Opcode: CLEI_S_D, DecodeIdx: 252
/* 4172 */    MCD::OPC_FilterValue, 20, 7, 0, // Skip to: 4183
/* 4176 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4178 */    MCD::OPC_Decode, 252, 8, 249, 1, // Opcode: CLEI_U_B, DecodeIdx: 249
/* 4183 */    MCD::OPC_FilterValue, 21, 7, 0, // Skip to: 4194
/* 4187 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4189 */    MCD::OPC_Decode, 254, 8, 250, 1, // Opcode: CLEI_U_H, DecodeIdx: 250
/* 4194 */    MCD::OPC_FilterValue, 22, 7, 0, // Skip to: 4205
/* 4198 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4200 */    MCD::OPC_Decode, 255, 8, 251, 1, // Opcode: CLEI_U_W, DecodeIdx: 251
/* 4205 */    MCD::OPC_FilterValue, 23, 7, 0, // Skip to: 4216
/* 4209 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4211 */    MCD::OPC_Decode, 253, 8, 252, 1, // Opcode: CLEI_U_D, DecodeIdx: 252
/* 4216 */    MCD::OPC_FilterValue, 24, 7, 0, // Skip to: 4227
/* 4220 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4222 */    MCD::OPC_Decode, 239, 14, 253, 1, // Opcode: LDI_B, DecodeIdx: 253
/* 4227 */    MCD::OPC_FilterValue, 25, 7, 0, // Skip to: 4238
/* 4231 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4233 */    MCD::OPC_Decode, 241, 14, 254, 1, // Opcode: LDI_H, DecodeIdx: 254
/* 4238 */    MCD::OPC_FilterValue, 26, 7, 0, // Skip to: 4249
/* 4242 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4244 */    MCD::OPC_Decode, 242, 14, 255, 1, // Opcode: LDI_W, DecodeIdx: 255
/* 4249 */    MCD::OPC_FilterValueOrFail, 27, 
/* 4251 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4253 */    MCD::OPC_Decode, 240, 14, 128, 2, // Opcode: LDI_D, DecodeIdx: 256
/* 4258 */    MCD::OPC_FilterValue, 9, 209, 1, // Skip to: 4727
/* 4262 */    MCD::OPC_ExtractField, 22, 4,  // Inst{25-22} ...
/* 4265 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4276
/* 4269 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4271 */    MCD::OPC_Decode, 183, 20, 129, 2, // Opcode: SLLI_D, DecodeIdx: 257
/* 4276 */    MCD::OPC_FilterValue, 1, 43, 0, // Skip to: 4323
/* 4280 */    MCD::OPC_ExtractField, 21, 1,  // Inst{21} ...
/* 4283 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4294
/* 4287 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4289 */    MCD::OPC_Decode, 185, 20, 251, 1, // Opcode: SLLI_W, DecodeIdx: 251
/* 4294 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4296 */    MCD::OPC_ExtractField, 20, 1,  // Inst{20} ...
/* 4299 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4310
/* 4303 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4305 */    MCD::OPC_Decode, 184, 20, 130, 2, // Opcode: SLLI_H, DecodeIdx: 258
/* 4310 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4312 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4314 */    MCD::OPC_CheckFieldOrFail, 19, 1, 0, 
/* 4318 */    MCD::OPC_Decode, 182, 20, 131, 2, // Opcode: SLLI_B, DecodeIdx: 259
/* 4323 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 4334
/* 4327 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4329 */    MCD::OPC_Decode, 218, 20, 129, 2, // Opcode: SRAI_D, DecodeIdx: 257
/* 4334 */    MCD::OPC_FilterValue, 3, 43, 0, // Skip to: 4381
/* 4338 */    MCD::OPC_ExtractField, 21, 1,  // Inst{21} ...
/* 4341 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4352
/* 4345 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4347 */    MCD::OPC_Decode, 220, 20, 251, 1, // Opcode: SRAI_W, DecodeIdx: 251
/* 4352 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4354 */    MCD::OPC_ExtractField, 20, 1,  // Inst{20} ...
/* 4357 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4368
/* 4361 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4363 */    MCD::OPC_Decode, 219, 20, 130, 2, // Opcode: SRAI_H, DecodeIdx: 258
/* 4368 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4370 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4372 */    MCD::OPC_CheckFieldOrFail, 19, 1, 0, 
/* 4376 */    MCD::OPC_Decode, 217, 20, 131, 2, // Opcode: SRAI_B, DecodeIdx: 259
/* 4381 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 4392
/* 4385 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4387 */    MCD::OPC_Decode, 240, 20, 129, 2, // Opcode: SRLI_D, DecodeIdx: 257
/* 4392 */    MCD::OPC_FilterValue, 5, 43, 0, // Skip to: 4439
/* 4396 */    MCD::OPC_ExtractField, 21, 1,  // Inst{21} ...
/* 4399 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4410
/* 4403 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4405 */    MCD::OPC_Decode, 242, 20, 251, 1, // Opcode: SRLI_W, DecodeIdx: 251
/* 4410 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4412 */    MCD::OPC_ExtractField, 20, 1,  // Inst{20} ...
/* 4415 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4426
/* 4419 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4421 */    MCD::OPC_Decode, 241, 20, 130, 2, // Opcode: SRLI_H, DecodeIdx: 258
/* 4426 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4428 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4430 */    MCD::OPC_CheckFieldOrFail, 19, 1, 0, 
/* 4434 */    MCD::OPC_Decode, 239, 20, 131, 2, // Opcode: SRLI_B, DecodeIdx: 259
/* 4439 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 4450
/* 4443 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4445 */    MCD::OPC_Decode, 170, 7, 129, 2, // Opcode: BCLRI_D, DecodeIdx: 257
/* 4450 */    MCD::OPC_FilterValue, 7, 43, 0, // Skip to: 4497
/* 4454 */    MCD::OPC_ExtractField, 21, 1,  // Inst{21} ...
/* 4457 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4468
/* 4461 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4463 */    MCD::OPC_Decode, 172, 7, 251, 1, // Opcode: BCLRI_W, DecodeIdx: 251
/* 4468 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4470 */    MCD::OPC_ExtractField, 20, 1,  // Inst{20} ...
/* 4473 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4484
/* 4477 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4479 */    MCD::OPC_Decode, 171, 7, 130, 2, // Opcode: BCLRI_H, DecodeIdx: 258
/* 4484 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4486 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4488 */    MCD::OPC_CheckFieldOrFail, 19, 1, 0, 
/* 4492 */    MCD::OPC_Decode, 169, 7, 131, 2, // Opcode: BCLRI_B, DecodeIdx: 259
/* 4497 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 4508
/* 4501 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4503 */    MCD::OPC_Decode, 188, 8, 129, 2, // Opcode: BSETI_D, DecodeIdx: 257
/* 4508 */    MCD::OPC_FilterValue, 9, 43, 0, // Skip to: 4555
/* 4512 */    MCD::OPC_ExtractField, 21, 1,  // Inst{21} ...
/* 4515 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4526
/* 4519 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4521 */    MCD::OPC_Decode, 190, 8, 251, 1, // Opcode: BSETI_W, DecodeIdx: 251
/* 4526 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4528 */    MCD::OPC_ExtractField, 20, 1,  // Inst{20} ...
/* 4531 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4542
/* 4535 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4537 */    MCD::OPC_Decode, 189, 8, 130, 2, // Opcode: BSETI_H, DecodeIdx: 258
/* 4542 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4544 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4546 */    MCD::OPC_CheckFieldOrFail, 19, 1, 0, 
/* 4550 */    MCD::OPC_Decode, 187, 8, 131, 2, // Opcode: BSETI_B, DecodeIdx: 259
/* 4555 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 4566
/* 4559 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4561 */    MCD::OPC_Decode, 151, 8, 129, 2, // Opcode: BNEGI_D, DecodeIdx: 257
/* 4566 */    MCD::OPC_FilterValue, 11, 43, 0, // Skip to: 4613
/* 4570 */    MCD::OPC_ExtractField, 21, 1,  // Inst{21} ...
/* 4573 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4584
/* 4577 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4579 */    MCD::OPC_Decode, 153, 8, 251, 1, // Opcode: BNEGI_W, DecodeIdx: 251
/* 4584 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4586 */    MCD::OPC_ExtractField, 20, 1,  // Inst{20} ...
/* 4589 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4600
/* 4593 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4595 */    MCD::OPC_Decode, 152, 8, 130, 2, // Opcode: BNEGI_H, DecodeIdx: 258
/* 4600 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4602 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4604 */    MCD::OPC_CheckFieldOrFail, 19, 1, 0, 
/* 4608 */    MCD::OPC_Decode, 150, 8, 131, 2, // Opcode: BNEGI_B, DecodeIdx: 259
/* 4613 */    MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 4624
/* 4617 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4619 */    MCD::OPC_Decode, 222, 7, 132, 2, // Opcode: BINSLI_D, DecodeIdx: 260
/* 4624 */    MCD::OPC_FilterValue, 13, 43, 0, // Skip to: 4671
/* 4628 */    MCD::OPC_ExtractField, 21, 1,  // Inst{21} ...
/* 4631 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4642
/* 4635 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4637 */    MCD::OPC_Decode, 224, 7, 133, 2, // Opcode: BINSLI_W, DecodeIdx: 261
/* 4642 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4644 */    MCD::OPC_ExtractField, 20, 1,  // Inst{20} ...
/* 4647 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4658
/* 4651 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4653 */    MCD::OPC_Decode, 223, 7, 134, 2, // Opcode: BINSLI_H, DecodeIdx: 262
/* 4658 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4660 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4662 */    MCD::OPC_CheckFieldOrFail, 19, 1, 0, 
/* 4666 */    MCD::OPC_Decode, 221, 7, 135, 2, // Opcode: BINSLI_B, DecodeIdx: 263
/* 4671 */    MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 4682
/* 4675 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4677 */    MCD::OPC_Decode, 230, 7, 132, 2, // Opcode: BINSRI_D, DecodeIdx: 260
/* 4682 */    MCD::OPC_FilterValueOrFail, 15, 
/* 4684 */    MCD::OPC_ExtractField, 21, 1,  // Inst{21} ...
/* 4687 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4698
/* 4691 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4693 */    MCD::OPC_Decode, 232, 7, 133, 2, // Opcode: BINSRI_W, DecodeIdx: 261
/* 4698 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4700 */    MCD::OPC_ExtractField, 20, 1,  // Inst{20} ...
/* 4703 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4714
/* 4707 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4709 */    MCD::OPC_Decode, 231, 7, 134, 2, // Opcode: BINSRI_H, DecodeIdx: 262
/* 4714 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4716 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4718 */    MCD::OPC_CheckFieldOrFail, 19, 1, 0, 
/* 4722 */    MCD::OPC_Decode, 229, 7, 135, 2, // Opcode: BINSRI_B, DecodeIdx: 263
/* 4727 */    MCD::OPC_FilterValue, 10, 233, 0, // Skip to: 4964
/* 4731 */    MCD::OPC_ExtractField, 22, 4,  // Inst{25-22} ...
/* 4734 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4745
/* 4738 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4740 */    MCD::OPC_Decode, 163, 19, 129, 2, // Opcode: SAT_S_D, DecodeIdx: 257
/* 4745 */    MCD::OPC_FilterValue, 1, 43, 0, // Skip to: 4792
/* 4749 */    MCD::OPC_ExtractField, 21, 1,  // Inst{21} ...
/* 4752 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4763
/* 4756 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4758 */    MCD::OPC_Decode, 165, 19, 251, 1, // Opcode: SAT_S_W, DecodeIdx: 251
/* 4763 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4765 */    MCD::OPC_ExtractField, 20, 1,  // Inst{20} ...
/* 4768 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4779
/* 4772 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4774 */    MCD::OPC_Decode, 164, 19, 130, 2, // Opcode: SAT_S_H, DecodeIdx: 258
/* 4779 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4781 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4783 */    MCD::OPC_CheckFieldOrFail, 19, 1, 0, 
/* 4787 */    MCD::OPC_Decode, 162, 19, 131, 2, // Opcode: SAT_S_B, DecodeIdx: 259
/* 4792 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 4803
/* 4796 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4798 */    MCD::OPC_Decode, 167, 19, 129, 2, // Opcode: SAT_U_D, DecodeIdx: 257
/* 4803 */    MCD::OPC_FilterValue, 3, 43, 0, // Skip to: 4850
/* 4807 */    MCD::OPC_ExtractField, 21, 1,  // Inst{21} ...
/* 4810 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4821
/* 4814 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4816 */    MCD::OPC_Decode, 169, 19, 251, 1, // Opcode: SAT_U_W, DecodeIdx: 251
/* 4821 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4823 */    MCD::OPC_ExtractField, 20, 1,  // Inst{20} ...
/* 4826 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4837
/* 4830 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4832 */    MCD::OPC_Decode, 168, 19, 130, 2, // Opcode: SAT_U_H, DecodeIdx: 258
/* 4837 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4839 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4841 */    MCD::OPC_CheckFieldOrFail, 19, 1, 0, 
/* 4845 */    MCD::OPC_Decode, 166, 19, 131, 2, // Opcode: SAT_U_B, DecodeIdx: 259
/* 4850 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 4861
/* 4854 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4856 */    MCD::OPC_Decode, 222, 20, 129, 2, // Opcode: SRARI_D, DecodeIdx: 257
/* 4861 */    MCD::OPC_FilterValue, 5, 43, 0, // Skip to: 4908
/* 4865 */    MCD::OPC_ExtractField, 21, 1,  // Inst{21} ...
/* 4868 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4879
/* 4872 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4874 */    MCD::OPC_Decode, 224, 20, 251, 1, // Opcode: SRARI_W, DecodeIdx: 251
/* 4879 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4881 */    MCD::OPC_ExtractField, 20, 1,  // Inst{20} ...
/* 4884 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4895
/* 4888 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4890 */    MCD::OPC_Decode, 223, 20, 130, 2, // Opcode: SRARI_H, DecodeIdx: 258
/* 4895 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4897 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4899 */    MCD::OPC_CheckFieldOrFail, 19, 1, 0, 
/* 4903 */    MCD::OPC_Decode, 221, 20, 131, 2, // Opcode: SRARI_B, DecodeIdx: 259
/* 4908 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 4919
/* 4912 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4914 */    MCD::OPC_Decode, 244, 20, 129, 2, // Opcode: SRLRI_D, DecodeIdx: 257
/* 4919 */    MCD::OPC_FilterValueOrFail, 7, 
/* 4921 */    MCD::OPC_ExtractField, 21, 1,  // Inst{21} ...
/* 4924 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4935
/* 4928 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4930 */    MCD::OPC_Decode, 246, 20, 251, 1, // Opcode: SRLRI_W, DecodeIdx: 251
/* 4935 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4937 */    MCD::OPC_ExtractField, 20, 1,  // Inst{20} ...
/* 4940 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4951
/* 4944 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4946 */    MCD::OPC_Decode, 245, 20, 130, 2, // Opcode: SRLRI_H, DecodeIdx: 258
/* 4951 */    MCD::OPC_FilterValueOrFail, 1, 
/* 4953 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4955 */    MCD::OPC_CheckFieldOrFail, 19, 1, 0, 
/* 4959 */    MCD::OPC_Decode, 243, 20, 131, 2, // Opcode: SRLRI_B, DecodeIdx: 259
/* 4964 */    MCD::OPC_FilterValue, 13, 97, 1, // Skip to: 5321
/* 4968 */    MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 4971 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 4982
/* 4975 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4977 */    MCD::OPC_Decode, 188, 20, 136, 2, // Opcode: SLL_B, DecodeIdx: 264
/* 4982 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 4993
/* 4986 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4988 */    MCD::OPC_Decode, 190, 20, 137, 2, // Opcode: SLL_H, DecodeIdx: 265
/* 4993 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 5004
/* 4997 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 4999 */    MCD::OPC_Decode, 193, 20, 138, 2, // Opcode: SLL_W, DecodeIdx: 266
/* 5004 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 5015
/* 5008 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5010 */    MCD::OPC_Decode, 189, 20, 139, 2, // Opcode: SLL_D, DecodeIdx: 267
/* 5015 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 5026
/* 5019 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5021 */    MCD::OPC_Decode, 231, 20, 136, 2, // Opcode: SRA_B, DecodeIdx: 264
/* 5026 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 5037
/* 5030 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5032 */    MCD::OPC_Decode, 233, 20, 137, 2, // Opcode: SRA_H, DecodeIdx: 265
/* 5037 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 5048
/* 5041 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5043 */    MCD::OPC_Decode, 235, 20, 138, 2, // Opcode: SRA_W, DecodeIdx: 266
/* 5048 */    MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 5059
/* 5052 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5054 */    MCD::OPC_Decode, 232, 20, 139, 2, // Opcode: SRA_D, DecodeIdx: 267
/* 5059 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 5070
/* 5063 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5065 */    MCD::OPC_Decode, 253, 20, 136, 2, // Opcode: SRL_B, DecodeIdx: 264
/* 5070 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 5081
/* 5074 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5076 */    MCD::OPC_Decode, 255, 20, 137, 2, // Opcode: SRL_H, DecodeIdx: 265
/* 5081 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 5092
/* 5085 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5087 */    MCD::OPC_Decode, 129, 21, 138, 2, // Opcode: SRL_W, DecodeIdx: 266
/* 5092 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 5103
/* 5096 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5098 */    MCD::OPC_Decode, 254, 20, 139, 2, // Opcode: SRL_D, DecodeIdx: 267
/* 5103 */    MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 5114
/* 5107 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5109 */    MCD::OPC_Decode, 173, 7, 136, 2, // Opcode: BCLR_B, DecodeIdx: 264
/* 5114 */    MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 5125
/* 5118 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5120 */    MCD::OPC_Decode, 175, 7, 137, 2, // Opcode: BCLR_H, DecodeIdx: 265
/* 5125 */    MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 5136
/* 5129 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5131 */    MCD::OPC_Decode, 176, 7, 138, 2, // Opcode: BCLR_W, DecodeIdx: 266
/* 5136 */    MCD::OPC_FilterValue, 15, 7, 0, // Skip to: 5147
/* 5140 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5142 */    MCD::OPC_Decode, 174, 7, 139, 2, // Opcode: BCLR_D, DecodeIdx: 267
/* 5147 */    MCD::OPC_FilterValue, 16, 7, 0, // Skip to: 5158
/* 5151 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5153 */    MCD::OPC_Decode, 191, 8, 136, 2, // Opcode: BSET_B, DecodeIdx: 264
/* 5158 */    MCD::OPC_FilterValue, 17, 7, 0, // Skip to: 5169
/* 5162 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5164 */    MCD::OPC_Decode, 193, 8, 137, 2, // Opcode: BSET_H, DecodeIdx: 265
/* 5169 */    MCD::OPC_FilterValue, 18, 7, 0, // Skip to: 5180
/* 5173 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5175 */    MCD::OPC_Decode, 194, 8, 138, 2, // Opcode: BSET_W, DecodeIdx: 266
/* 5180 */    MCD::OPC_FilterValue, 19, 7, 0, // Skip to: 5191
/* 5184 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5186 */    MCD::OPC_Decode, 192, 8, 139, 2, // Opcode: BSET_D, DecodeIdx: 267
/* 5191 */    MCD::OPC_FilterValue, 20, 7, 0, // Skip to: 5202
/* 5195 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5197 */    MCD::OPC_Decode, 154, 8, 136, 2, // Opcode: BNEG_B, DecodeIdx: 264
/* 5202 */    MCD::OPC_FilterValue, 21, 7, 0, // Skip to: 5213
/* 5206 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5208 */    MCD::OPC_Decode, 156, 8, 137, 2, // Opcode: BNEG_H, DecodeIdx: 265
/* 5213 */    MCD::OPC_FilterValue, 22, 7, 0, // Skip to: 5224
/* 5217 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5219 */    MCD::OPC_Decode, 157, 8, 138, 2, // Opcode: BNEG_W, DecodeIdx: 266
/* 5224 */    MCD::OPC_FilterValue, 23, 7, 0, // Skip to: 5235
/* 5228 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5230 */    MCD::OPC_Decode, 155, 8, 139, 2, // Opcode: BNEG_D, DecodeIdx: 267
/* 5235 */    MCD::OPC_FilterValue, 24, 7, 0, // Skip to: 5246
/* 5239 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5241 */    MCD::OPC_Decode, 225, 7, 140, 2, // Opcode: BINSL_B, DecodeIdx: 268
/* 5246 */    MCD::OPC_FilterValue, 25, 7, 0, // Skip to: 5257
/* 5250 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5252 */    MCD::OPC_Decode, 227, 7, 141, 2, // Opcode: BINSL_H, DecodeIdx: 269
/* 5257 */    MCD::OPC_FilterValue, 26, 7, 0, // Skip to: 5268
/* 5261 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5263 */    MCD::OPC_Decode, 228, 7, 142, 2, // Opcode: BINSL_W, DecodeIdx: 270
/* 5268 */    MCD::OPC_FilterValue, 27, 7, 0, // Skip to: 5279
/* 5272 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5274 */    MCD::OPC_Decode, 226, 7, 143, 2, // Opcode: BINSL_D, DecodeIdx: 271
/* 5279 */    MCD::OPC_FilterValue, 28, 7, 0, // Skip to: 5290
/* 5283 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5285 */    MCD::OPC_Decode, 233, 7, 140, 2, // Opcode: BINSR_B, DecodeIdx: 268
/* 5290 */    MCD::OPC_FilterValue, 29, 7, 0, // Skip to: 5301
/* 5294 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5296 */    MCD::OPC_Decode, 235, 7, 141, 2, // Opcode: BINSR_H, DecodeIdx: 269
/* 5301 */    MCD::OPC_FilterValue, 30, 7, 0, // Skip to: 5312
/* 5305 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5307 */    MCD::OPC_Decode, 236, 7, 142, 2, // Opcode: BINSR_W, DecodeIdx: 270
/* 5312 */    MCD::OPC_FilterValueOrFail, 31, 
/* 5314 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5316 */    MCD::OPC_Decode, 234, 7, 143, 2, // Opcode: BINSR_D, DecodeIdx: 271
/* 5321 */    MCD::OPC_FilterValue, 14, 97, 1, // Skip to: 5678
/* 5325 */    MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 5328 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 5339
/* 5332 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5334 */    MCD::OPC_Decode, 195, 6, 136, 2, // Opcode: ADDV_B, DecodeIdx: 264
/* 5339 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 5350
/* 5343 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5345 */    MCD::OPC_Decode, 197, 6, 137, 2, // Opcode: ADDV_H, DecodeIdx: 265
/* 5350 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 5361
/* 5354 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5356 */    MCD::OPC_Decode, 198, 6, 138, 2, // Opcode: ADDV_W, DecodeIdx: 266
/* 5361 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 5372
/* 5365 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5367 */    MCD::OPC_Decode, 196, 6, 139, 2, // Opcode: ADDV_D, DecodeIdx: 267
/* 5372 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 5383
/* 5376 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5378 */    MCD::OPC_Decode, 187, 21, 136, 2, // Opcode: SUBV_B, DecodeIdx: 264
/* 5383 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 5394
/* 5387 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5389 */    MCD::OPC_Decode, 189, 21, 137, 2, // Opcode: SUBV_H, DecodeIdx: 265
/* 5394 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 5405
/* 5398 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5400 */    MCD::OPC_Decode, 190, 21, 138, 2, // Opcode: SUBV_W, DecodeIdx: 266
/* 5405 */    MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 5416
/* 5409 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5411 */    MCD::OPC_Decode, 188, 21, 139, 2, // Opcode: SUBV_D, DecodeIdx: 267
/* 5416 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 5427
/* 5420 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5422 */    MCD::OPC_Decode, 138, 16, 136, 2, // Opcode: MAX_S_B, DecodeIdx: 264
/* 5427 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 5438
/* 5431 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5433 */    MCD::OPC_Decode, 140, 16, 137, 2, // Opcode: MAX_S_H, DecodeIdx: 265
/* 5438 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 5449
/* 5442 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5444 */    MCD::OPC_Decode, 142, 16, 138, 2, // Opcode: MAX_S_W, DecodeIdx: 266
/* 5449 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 5460
/* 5453 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5455 */    MCD::OPC_Decode, 139, 16, 139, 2, // Opcode: MAX_S_D, DecodeIdx: 267
/* 5460 */    MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 5471
/* 5464 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5466 */    MCD::OPC_Decode, 143, 16, 136, 2, // Opcode: MAX_U_B, DecodeIdx: 264
/* 5471 */    MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 5482
/* 5475 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5477 */    MCD::OPC_Decode, 145, 16, 137, 2, // Opcode: MAX_U_H, DecodeIdx: 265
/* 5482 */    MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 5493
/* 5486 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5488 */    MCD::OPC_Decode, 146, 16, 138, 2, // Opcode: MAX_U_W, DecodeIdx: 266
/* 5493 */    MCD::OPC_FilterValue, 15, 7, 0, // Skip to: 5504
/* 5497 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5499 */    MCD::OPC_Decode, 144, 16, 139, 2, // Opcode: MAX_U_D, DecodeIdx: 267
/* 5504 */    MCD::OPC_FilterValue, 16, 7, 0, // Skip to: 5515
/* 5508 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5510 */    MCD::OPC_Decode, 197, 16, 136, 2, // Opcode: MIN_S_B, DecodeIdx: 264
/* 5515 */    MCD::OPC_FilterValue, 17, 7, 0, // Skip to: 5526
/* 5519 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5521 */    MCD::OPC_Decode, 199, 16, 137, 2, // Opcode: MIN_S_H, DecodeIdx: 265
/* 5526 */    MCD::OPC_FilterValue, 18, 7, 0, // Skip to: 5537
/* 5530 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5532 */    MCD::OPC_Decode, 201, 16, 138, 2, // Opcode: MIN_S_W, DecodeIdx: 266
/* 5537 */    MCD::OPC_FilterValue, 19, 7, 0, // Skip to: 5548
/* 5541 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5543 */    MCD::OPC_Decode, 198, 16, 139, 2, // Opcode: MIN_S_D, DecodeIdx: 267
/* 5548 */    MCD::OPC_FilterValue, 20, 7, 0, // Skip to: 5559
/* 5552 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5554 */    MCD::OPC_Decode, 202, 16, 136, 2, // Opcode: MIN_U_B, DecodeIdx: 264
/* 5559 */    MCD::OPC_FilterValue, 21, 7, 0, // Skip to: 5570
/* 5563 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5565 */    MCD::OPC_Decode, 204, 16, 137, 2, // Opcode: MIN_U_H, DecodeIdx: 265
/* 5570 */    MCD::OPC_FilterValue, 22, 7, 0, // Skip to: 5581
/* 5574 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5576 */    MCD::OPC_Decode, 205, 16, 138, 2, // Opcode: MIN_U_W, DecodeIdx: 266
/* 5581 */    MCD::OPC_FilterValue, 23, 7, 0, // Skip to: 5592
/* 5585 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5587 */    MCD::OPC_Decode, 203, 16, 139, 2, // Opcode: MIN_U_D, DecodeIdx: 267
/* 5592 */    MCD::OPC_FilterValue, 24, 7, 0, // Skip to: 5603
/* 5596 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5598 */    MCD::OPC_Decode, 131, 16, 136, 2, // Opcode: MAX_A_B, DecodeIdx: 264
/* 5603 */    MCD::OPC_FilterValue, 25, 7, 0, // Skip to: 5614
/* 5607 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5609 */    MCD::OPC_Decode, 133, 16, 137, 2, // Opcode: MAX_A_H, DecodeIdx: 265
/* 5614 */    MCD::OPC_FilterValue, 26, 7, 0, // Skip to: 5625
/* 5618 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5620 */    MCD::OPC_Decode, 134, 16, 138, 2, // Opcode: MAX_A_W, DecodeIdx: 266
/* 5625 */    MCD::OPC_FilterValue, 27, 7, 0, // Skip to: 5636
/* 5629 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5631 */    MCD::OPC_Decode, 132, 16, 139, 2, // Opcode: MAX_A_D, DecodeIdx: 267
/* 5636 */    MCD::OPC_FilterValue, 28, 7, 0, // Skip to: 5647
/* 5640 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5642 */    MCD::OPC_Decode, 190, 16, 136, 2, // Opcode: MIN_A_B, DecodeIdx: 264
/* 5647 */    MCD::OPC_FilterValue, 29, 7, 0, // Skip to: 5658
/* 5651 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5653 */    MCD::OPC_Decode, 192, 16, 137, 2, // Opcode: MIN_A_H, DecodeIdx: 265
/* 5658 */    MCD::OPC_FilterValue, 30, 7, 0, // Skip to: 5669
/* 5662 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5664 */    MCD::OPC_Decode, 193, 16, 138, 2, // Opcode: MIN_A_W, DecodeIdx: 266
/* 5669 */    MCD::OPC_FilterValueOrFail, 31, 
/* 5671 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5673 */    MCD::OPC_Decode, 191, 16, 139, 2, // Opcode: MIN_A_D, DecodeIdx: 267
/* 5678 */    MCD::OPC_FilterValue, 15, 221, 0, // Skip to: 5903
/* 5682 */    MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 5685 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 5696
/* 5689 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5691 */    MCD::OPC_Decode, 232, 8, 136, 2, // Opcode: CEQ_B, DecodeIdx: 264
/* 5696 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 5707
/* 5700 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5702 */    MCD::OPC_Decode, 234, 8, 137, 2, // Opcode: CEQ_H, DecodeIdx: 265
/* 5707 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 5718
/* 5711 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5713 */    MCD::OPC_Decode, 235, 8, 138, 2, // Opcode: CEQ_W, DecodeIdx: 266
/* 5718 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 5729
/* 5722 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5724 */    MCD::OPC_Decode, 233, 8, 139, 2, // Opcode: CEQ_D, DecodeIdx: 267
/* 5729 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 5740
/* 5733 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5735 */    MCD::OPC_Decode, 148, 9, 136, 2, // Opcode: CLT_S_B, DecodeIdx: 264
/* 5740 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 5751
/* 5744 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5746 */    MCD::OPC_Decode, 150, 9, 137, 2, // Opcode: CLT_S_H, DecodeIdx: 265
/* 5751 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 5762
/* 5755 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5757 */    MCD::OPC_Decode, 151, 9, 138, 2, // Opcode: CLT_S_W, DecodeIdx: 266
/* 5762 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 5773
/* 5766 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5768 */    MCD::OPC_Decode, 149, 9, 139, 2, // Opcode: CLT_S_D, DecodeIdx: 267
/* 5773 */    MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 5784
/* 5777 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5779 */    MCD::OPC_Decode, 152, 9, 136, 2, // Opcode: CLT_U_B, DecodeIdx: 264
/* 5784 */    MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 5795
/* 5788 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5790 */    MCD::OPC_Decode, 154, 9, 137, 2, // Opcode: CLT_U_H, DecodeIdx: 265
/* 5795 */    MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 5806
/* 5799 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5801 */    MCD::OPC_Decode, 155, 9, 138, 2, // Opcode: CLT_U_W, DecodeIdx: 266
/* 5806 */    MCD::OPC_FilterValue, 15, 7, 0, // Skip to: 5817
/* 5810 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5812 */    MCD::OPC_Decode, 153, 9, 139, 2, // Opcode: CLT_U_D, DecodeIdx: 267
/* 5817 */    MCD::OPC_FilterValue, 16, 7, 0, // Skip to: 5828
/* 5821 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5823 */    MCD::OPC_Decode, 128, 9, 136, 2, // Opcode: CLE_S_B, DecodeIdx: 264
/* 5828 */    MCD::OPC_FilterValue, 17, 7, 0, // Skip to: 5839
/* 5832 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5834 */    MCD::OPC_Decode, 130, 9, 137, 2, // Opcode: CLE_S_H, DecodeIdx: 265
/* 5839 */    MCD::OPC_FilterValue, 18, 7, 0, // Skip to: 5850
/* 5843 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5845 */    MCD::OPC_Decode, 131, 9, 138, 2, // Opcode: CLE_S_W, DecodeIdx: 266
/* 5850 */    MCD::OPC_FilterValue, 19, 7, 0, // Skip to: 5861
/* 5854 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5856 */    MCD::OPC_Decode, 129, 9, 139, 2, // Opcode: CLE_S_D, DecodeIdx: 267
/* 5861 */    MCD::OPC_FilterValue, 20, 7, 0, // Skip to: 5872
/* 5865 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5867 */    MCD::OPC_Decode, 132, 9, 136, 2, // Opcode: CLE_U_B, DecodeIdx: 264
/* 5872 */    MCD::OPC_FilterValue, 21, 7, 0, // Skip to: 5883
/* 5876 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5878 */    MCD::OPC_Decode, 134, 9, 137, 2, // Opcode: CLE_U_H, DecodeIdx: 265
/* 5883 */    MCD::OPC_FilterValue, 22, 7, 0, // Skip to: 5894
/* 5887 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5889 */    MCD::OPC_Decode, 135, 9, 138, 2, // Opcode: CLE_U_W, DecodeIdx: 266
/* 5894 */    MCD::OPC_FilterValueOrFail, 23, 
/* 5896 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5898 */    MCD::OPC_Decode, 133, 9, 139, 2, // Opcode: CLE_U_D, DecodeIdx: 267
/* 5903 */    MCD::OPC_FilterValue, 16, 97, 1, // Skip to: 6260
/* 5907 */    MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 5910 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 5921
/* 5914 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5916 */    MCD::OPC_Decode, 201, 6, 136, 2, // Opcode: ADD_A_B, DecodeIdx: 264
/* 5921 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 5932
/* 5925 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5927 */    MCD::OPC_Decode, 203, 6, 137, 2, // Opcode: ADD_A_H, DecodeIdx: 265
/* 5932 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 5943
/* 5936 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5938 */    MCD::OPC_Decode, 204, 6, 138, 2, // Opcode: ADD_A_W, DecodeIdx: 266
/* 5943 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 5954
/* 5947 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5949 */    MCD::OPC_Decode, 202, 6, 139, 2, // Opcode: ADD_A_D, DecodeIdx: 267
/* 5954 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 5965
/* 5958 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5960 */    MCD::OPC_Decode, 164, 6, 136, 2, // Opcode: ADDS_A_B, DecodeIdx: 264
/* 5965 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 5976
/* 5969 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5971 */    MCD::OPC_Decode, 166, 6, 137, 2, // Opcode: ADDS_A_H, DecodeIdx: 265
/* 5976 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 5987
/* 5980 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5982 */    MCD::OPC_Decode, 167, 6, 138, 2, // Opcode: ADDS_A_W, DecodeIdx: 266
/* 5987 */    MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 5998
/* 5991 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 5993 */    MCD::OPC_Decode, 165, 6, 139, 2, // Opcode: ADDS_A_D, DecodeIdx: 267
/* 5998 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 6009
/* 6002 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6004 */    MCD::OPC_Decode, 168, 6, 136, 2, // Opcode: ADDS_S_B, DecodeIdx: 264
/* 6009 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 6020
/* 6013 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6015 */    MCD::OPC_Decode, 170, 6, 137, 2, // Opcode: ADDS_S_H, DecodeIdx: 265
/* 6020 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 6031
/* 6024 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6026 */    MCD::OPC_Decode, 171, 6, 138, 2, // Opcode: ADDS_S_W, DecodeIdx: 266
/* 6031 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 6042
/* 6035 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6037 */    MCD::OPC_Decode, 169, 6, 139, 2, // Opcode: ADDS_S_D, DecodeIdx: 267
/* 6042 */    MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 6053
/* 6046 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6048 */    MCD::OPC_Decode, 172, 6, 136, 2, // Opcode: ADDS_U_B, DecodeIdx: 264
/* 6053 */    MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 6064
/* 6057 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6059 */    MCD::OPC_Decode, 174, 6, 137, 2, // Opcode: ADDS_U_H, DecodeIdx: 265
/* 6064 */    MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 6075
/* 6068 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6070 */    MCD::OPC_Decode, 175, 6, 138, 2, // Opcode: ADDS_U_W, DecodeIdx: 266
/* 6075 */    MCD::OPC_FilterValue, 15, 7, 0, // Skip to: 6086
/* 6079 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6081 */    MCD::OPC_Decode, 173, 6, 139, 2, // Opcode: ADDS_U_D, DecodeIdx: 267
/* 6086 */    MCD::OPC_FilterValue, 16, 7, 0, // Skip to: 6097
/* 6090 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6092 */    MCD::OPC_Decode, 253, 6, 136, 2, // Opcode: AVE_S_B, DecodeIdx: 264
/* 6097 */    MCD::OPC_FilterValue, 17, 7, 0, // Skip to: 6108
/* 6101 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6103 */    MCD::OPC_Decode, 255, 6, 137, 2, // Opcode: AVE_S_H, DecodeIdx: 265
/* 6108 */    MCD::OPC_FilterValue, 18, 7, 0, // Skip to: 6119
/* 6112 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6114 */    MCD::OPC_Decode, 128, 7, 138, 2, // Opcode: AVE_S_W, DecodeIdx: 266
/* 6119 */    MCD::OPC_FilterValue, 19, 7, 0, // Skip to: 6130
/* 6123 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6125 */    MCD::OPC_Decode, 254, 6, 139, 2, // Opcode: AVE_S_D, DecodeIdx: 267
/* 6130 */    MCD::OPC_FilterValue, 20, 7, 0, // Skip to: 6141
/* 6134 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6136 */    MCD::OPC_Decode, 129, 7, 136, 2, // Opcode: AVE_U_B, DecodeIdx: 264
/* 6141 */    MCD::OPC_FilterValue, 21, 7, 0, // Skip to: 6152
/* 6145 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6147 */    MCD::OPC_Decode, 131, 7, 137, 2, // Opcode: AVE_U_H, DecodeIdx: 265
/* 6152 */    MCD::OPC_FilterValue, 22, 7, 0, // Skip to: 6163
/* 6156 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6158 */    MCD::OPC_Decode, 132, 7, 138, 2, // Opcode: AVE_U_W, DecodeIdx: 266
/* 6163 */    MCD::OPC_FilterValue, 23, 7, 0, // Skip to: 6174
/* 6167 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6169 */    MCD::OPC_Decode, 130, 7, 139, 2, // Opcode: AVE_U_D, DecodeIdx: 267
/* 6174 */    MCD::OPC_FilterValue, 24, 7, 0, // Skip to: 6185
/* 6178 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6180 */    MCD::OPC_Decode, 245, 6, 136, 2, // Opcode: AVER_S_B, DecodeIdx: 264
/* 6185 */    MCD::OPC_FilterValue, 25, 7, 0, // Skip to: 6196
/* 6189 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6191 */    MCD::OPC_Decode, 247, 6, 137, 2, // Opcode: AVER_S_H, DecodeIdx: 265
/* 6196 */    MCD::OPC_FilterValue, 26, 7, 0, // Skip to: 6207
/* 6200 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6202 */    MCD::OPC_Decode, 248, 6, 138, 2, // Opcode: AVER_S_W, DecodeIdx: 266
/* 6207 */    MCD::OPC_FilterValue, 27, 7, 0, // Skip to: 6218
/* 6211 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6213 */    MCD::OPC_Decode, 246, 6, 139, 2, // Opcode: AVER_S_D, DecodeIdx: 267
/* 6218 */    MCD::OPC_FilterValue, 28, 7, 0, // Skip to: 6229
/* 6222 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6224 */    MCD::OPC_Decode, 249, 6, 136, 2, // Opcode: AVER_U_B, DecodeIdx: 264
/* 6229 */    MCD::OPC_FilterValue, 29, 7, 0, // Skip to: 6240
/* 6233 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6235 */    MCD::OPC_Decode, 251, 6, 137, 2, // Opcode: AVER_U_H, DecodeIdx: 265
/* 6240 */    MCD::OPC_FilterValue, 30, 7, 0, // Skip to: 6251
/* 6244 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6246 */    MCD::OPC_Decode, 252, 6, 138, 2, // Opcode: AVER_U_W, DecodeIdx: 266
/* 6251 */    MCD::OPC_FilterValueOrFail, 31, 
/* 6253 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6255 */    MCD::OPC_Decode, 250, 6, 139, 2, // Opcode: AVER_U_D, DecodeIdx: 267
/* 6260 */    MCD::OPC_FilterValue, 17, 9, 1, // Skip to: 6529
/* 6264 */    MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 6267 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 6278
/* 6271 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6273 */    MCD::OPC_Decode, 160, 21, 136, 2, // Opcode: SUBS_S_B, DecodeIdx: 264
/* 6278 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 6289
/* 6282 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6284 */    MCD::OPC_Decode, 162, 21, 137, 2, // Opcode: SUBS_S_H, DecodeIdx: 265
/* 6289 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 6300
/* 6293 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6295 */    MCD::OPC_Decode, 163, 21, 138, 2, // Opcode: SUBS_S_W, DecodeIdx: 266
/* 6300 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 6311
/* 6304 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6306 */    MCD::OPC_Decode, 161, 21, 139, 2, // Opcode: SUBS_S_D, DecodeIdx: 267
/* 6311 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 6322
/* 6315 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6317 */    MCD::OPC_Decode, 164, 21, 136, 2, // Opcode: SUBS_U_B, DecodeIdx: 264
/* 6322 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 6333
/* 6326 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6328 */    MCD::OPC_Decode, 166, 21, 137, 2, // Opcode: SUBS_U_H, DecodeIdx: 265
/* 6333 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 6344
/* 6337 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6339 */    MCD::OPC_Decode, 167, 21, 138, 2, // Opcode: SUBS_U_W, DecodeIdx: 266
/* 6344 */    MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 6355
/* 6348 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6350 */    MCD::OPC_Decode, 165, 21, 139, 2, // Opcode: SUBS_U_D, DecodeIdx: 267
/* 6355 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 6366
/* 6359 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6361 */    MCD::OPC_Decode, 152, 21, 136, 2, // Opcode: SUBSUS_U_B, DecodeIdx: 264
/* 6366 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 6377
/* 6370 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6372 */    MCD::OPC_Decode, 154, 21, 137, 2, // Opcode: SUBSUS_U_H, DecodeIdx: 265
/* 6377 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 6388
/* 6381 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6383 */    MCD::OPC_Decode, 155, 21, 138, 2, // Opcode: SUBSUS_U_W, DecodeIdx: 266
/* 6388 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 6399
/* 6392 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6394 */    MCD::OPC_Decode, 153, 21, 139, 2, // Opcode: SUBSUS_U_D, DecodeIdx: 267
/* 6399 */    MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 6410
/* 6403 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6405 */    MCD::OPC_Decode, 156, 21, 136, 2, // Opcode: SUBSUU_S_B, DecodeIdx: 264
/* 6410 */    MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 6421
/* 6414 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6416 */    MCD::OPC_Decode, 158, 21, 137, 2, // Opcode: SUBSUU_S_H, DecodeIdx: 265
/* 6421 */    MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 6432
/* 6425 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6427 */    MCD::OPC_Decode, 159, 21, 138, 2, // Opcode: SUBSUU_S_W, DecodeIdx: 266
/* 6432 */    MCD::OPC_FilterValue, 15, 7, 0, // Skip to: 6443
/* 6436 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6438 */    MCD::OPC_Decode, 157, 21, 139, 2, // Opcode: SUBSUU_S_D, DecodeIdx: 267
/* 6443 */    MCD::OPC_FilterValue, 16, 7, 0, // Skip to: 6454
/* 6447 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6449 */    MCD::OPC_Decode, 233, 6, 136, 2, // Opcode: ASUB_S_B, DecodeIdx: 264
/* 6454 */    MCD::OPC_FilterValue, 17, 7, 0, // Skip to: 6465
/* 6458 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6460 */    MCD::OPC_Decode, 235, 6, 137, 2, // Opcode: ASUB_S_H, DecodeIdx: 265
/* 6465 */    MCD::OPC_FilterValue, 18, 7, 0, // Skip to: 6476
/* 6469 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6471 */    MCD::OPC_Decode, 236, 6, 138, 2, // Opcode: ASUB_S_W, DecodeIdx: 266
/* 6476 */    MCD::OPC_FilterValue, 19, 7, 0, // Skip to: 6487
/* 6480 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6482 */    MCD::OPC_Decode, 234, 6, 139, 2, // Opcode: ASUB_S_D, DecodeIdx: 267
/* 6487 */    MCD::OPC_FilterValue, 20, 7, 0, // Skip to: 6498
/* 6491 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6493 */    MCD::OPC_Decode, 237, 6, 136, 2, // Opcode: ASUB_U_B, DecodeIdx: 264
/* 6498 */    MCD::OPC_FilterValue, 21, 7, 0, // Skip to: 6509
/* 6502 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6504 */    MCD::OPC_Decode, 239, 6, 137, 2, // Opcode: ASUB_U_H, DecodeIdx: 265
/* 6509 */    MCD::OPC_FilterValue, 22, 7, 0, // Skip to: 6520
/* 6513 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6515 */    MCD::OPC_Decode, 240, 6, 138, 2, // Opcode: ASUB_U_W, DecodeIdx: 266
/* 6520 */    MCD::OPC_FilterValueOrFail, 23, 
/* 6522 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6524 */    MCD::OPC_Decode, 238, 6, 139, 2, // Opcode: ASUB_U_D, DecodeIdx: 267
/* 6529 */    MCD::OPC_FilterValue, 18, 53, 1, // Skip to: 6842
/* 6533 */    MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 6536 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 6547
/* 6540 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6542 */    MCD::OPC_Decode, 238, 17, 136, 2, // Opcode: MULV_B, DecodeIdx: 264
/* 6547 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 6558
/* 6551 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6553 */    MCD::OPC_Decode, 240, 17, 137, 2, // Opcode: MULV_H, DecodeIdx: 265
/* 6558 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 6569
/* 6562 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6564 */    MCD::OPC_Decode, 241, 17, 138, 2, // Opcode: MULV_W, DecodeIdx: 266
/* 6569 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 6580
/* 6573 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6575 */    MCD::OPC_Decode, 239, 17, 139, 2, // Opcode: MULV_D, DecodeIdx: 267
/* 6580 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 6591
/* 6584 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6586 */    MCD::OPC_Decode, 225, 15, 140, 2, // Opcode: MADDV_B, DecodeIdx: 268
/* 6591 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 6602
/* 6595 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6597 */    MCD::OPC_Decode, 227, 15, 141, 2, // Opcode: MADDV_H, DecodeIdx: 269
/* 6602 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 6613
/* 6606 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6608 */    MCD::OPC_Decode, 228, 15, 142, 2, // Opcode: MADDV_W, DecodeIdx: 270
/* 6613 */    MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 6624
/* 6617 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6619 */    MCD::OPC_Decode, 226, 15, 143, 2, // Opcode: MADDV_D, DecodeIdx: 271
/* 6624 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 6635
/* 6628 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6630 */    MCD::OPC_Decode, 148, 17, 140, 2, // Opcode: MSUBV_B, DecodeIdx: 268
/* 6635 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 6646
/* 6639 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6641 */    MCD::OPC_Decode, 150, 17, 141, 2, // Opcode: MSUBV_H, DecodeIdx: 269
/* 6646 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 6657
/* 6650 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6652 */    MCD::OPC_Decode, 151, 17, 142, 2, // Opcode: MSUBV_W, DecodeIdx: 270
/* 6657 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 6668
/* 6661 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6663 */    MCD::OPC_Decode, 149, 17, 143, 2, // Opcode: MSUBV_D, DecodeIdx: 271
/* 6668 */    MCD::OPC_FilterValue, 16, 7, 0, // Skip to: 6679
/* 6672 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6674 */    MCD::OPC_Decode, 177, 11, 136, 2, // Opcode: DIV_S_B, DecodeIdx: 264
/* 6679 */    MCD::OPC_FilterValue, 17, 7, 0, // Skip to: 6690
/* 6683 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6685 */    MCD::OPC_Decode, 179, 11, 137, 2, // Opcode: DIV_S_H, DecodeIdx: 265
/* 6690 */    MCD::OPC_FilterValue, 18, 7, 0, // Skip to: 6701
/* 6694 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6696 */    MCD::OPC_Decode, 180, 11, 138, 2, // Opcode: DIV_S_W, DecodeIdx: 266
/* 6701 */    MCD::OPC_FilterValue, 19, 7, 0, // Skip to: 6712
/* 6705 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6707 */    MCD::OPC_Decode, 178, 11, 139, 2, // Opcode: DIV_S_D, DecodeIdx: 267
/* 6712 */    MCD::OPC_FilterValue, 20, 7, 0, // Skip to: 6723
/* 6716 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6718 */    MCD::OPC_Decode, 181, 11, 136, 2, // Opcode: DIV_U_B, DecodeIdx: 264
/* 6723 */    MCD::OPC_FilterValue, 21, 7, 0, // Skip to: 6734
/* 6727 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6729 */    MCD::OPC_Decode, 183, 11, 137, 2, // Opcode: DIV_U_H, DecodeIdx: 265
/* 6734 */    MCD::OPC_FilterValue, 22, 7, 0, // Skip to: 6745
/* 6738 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6740 */    MCD::OPC_Decode, 184, 11, 138, 2, // Opcode: DIV_U_W, DecodeIdx: 266
/* 6745 */    MCD::OPC_FilterValue, 23, 7, 0, // Skip to: 6756
/* 6749 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6751 */    MCD::OPC_Decode, 182, 11, 139, 2, // Opcode: DIV_U_D, DecodeIdx: 267
/* 6756 */    MCD::OPC_FilterValue, 24, 7, 0, // Skip to: 6767
/* 6760 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6762 */    MCD::OPC_Decode, 212, 16, 136, 2, // Opcode: MOD_S_B, DecodeIdx: 264
/* 6767 */    MCD::OPC_FilterValue, 25, 7, 0, // Skip to: 6778
/* 6771 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6773 */    MCD::OPC_Decode, 214, 16, 137, 2, // Opcode: MOD_S_H, DecodeIdx: 265
/* 6778 */    MCD::OPC_FilterValue, 26, 7, 0, // Skip to: 6789
/* 6782 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6784 */    MCD::OPC_Decode, 215, 16, 138, 2, // Opcode: MOD_S_W, DecodeIdx: 266
/* 6789 */    MCD::OPC_FilterValue, 27, 7, 0, // Skip to: 6800
/* 6793 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6795 */    MCD::OPC_Decode, 213, 16, 139, 2, // Opcode: MOD_S_D, DecodeIdx: 267
/* 6800 */    MCD::OPC_FilterValue, 28, 7, 0, // Skip to: 6811
/* 6804 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6806 */    MCD::OPC_Decode, 216, 16, 136, 2, // Opcode: MOD_U_B, DecodeIdx: 264
/* 6811 */    MCD::OPC_FilterValue, 29, 7, 0, // Skip to: 6822
/* 6815 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6817 */    MCD::OPC_Decode, 218, 16, 137, 2, // Opcode: MOD_U_H, DecodeIdx: 265
/* 6822 */    MCD::OPC_FilterValue, 30, 7, 0, // Skip to: 6833
/* 6826 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6828 */    MCD::OPC_Decode, 219, 16, 138, 2, // Opcode: MOD_U_W, DecodeIdx: 266
/* 6833 */    MCD::OPC_FilterValueOrFail, 31, 
/* 6835 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6837 */    MCD::OPC_Decode, 217, 16, 139, 2, // Opcode: MOD_U_D, DecodeIdx: 267
/* 6842 */    MCD::OPC_FilterValue, 19, 199, 0, // Skip to: 7045
/* 6846 */    MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 6849 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 6860
/* 6853 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6855 */    MCD::OPC_Decode, 210, 11, 144, 2, // Opcode: DOTP_S_H, DecodeIdx: 272
/* 6860 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 6871
/* 6864 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6866 */    MCD::OPC_Decode, 211, 11, 145, 2, // Opcode: DOTP_S_W, DecodeIdx: 273
/* 6871 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 6882
/* 6875 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6877 */    MCD::OPC_Decode, 209, 11, 146, 2, // Opcode: DOTP_S_D, DecodeIdx: 274
/* 6882 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 6893
/* 6886 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6888 */    MCD::OPC_Decode, 213, 11, 144, 2, // Opcode: DOTP_U_H, DecodeIdx: 272
/* 6893 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 6904
/* 6897 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6899 */    MCD::OPC_Decode, 214, 11, 145, 2, // Opcode: DOTP_U_W, DecodeIdx: 273
/* 6904 */    MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 6915
/* 6908 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6910 */    MCD::OPC_Decode, 212, 11, 146, 2, // Opcode: DOTP_U_D, DecodeIdx: 274
/* 6915 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 6926
/* 6919 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6921 */    MCD::OPC_Decode, 216, 11, 147, 2, // Opcode: DPADD_S_H, DecodeIdx: 275
/* 6926 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 6937
/* 6930 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6932 */    MCD::OPC_Decode, 217, 11, 148, 2, // Opcode: DPADD_S_W, DecodeIdx: 276
/* 6937 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 6948
/* 6941 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6943 */    MCD::OPC_Decode, 215, 11, 149, 2, // Opcode: DPADD_S_D, DecodeIdx: 277
/* 6948 */    MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 6959
/* 6952 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6954 */    MCD::OPC_Decode, 219, 11, 147, 2, // Opcode: DPADD_U_H, DecodeIdx: 275
/* 6959 */    MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 6970
/* 6963 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6965 */    MCD::OPC_Decode, 220, 11, 148, 2, // Opcode: DPADD_U_W, DecodeIdx: 276
/* 6970 */    MCD::OPC_FilterValue, 15, 7, 0, // Skip to: 6981
/* 6974 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6976 */    MCD::OPC_Decode, 218, 11, 149, 2, // Opcode: DPADD_U_D, DecodeIdx: 277
/* 6981 */    MCD::OPC_FilterValue, 17, 7, 0, // Skip to: 6992
/* 6985 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6987 */    MCD::OPC_Decode, 247, 11, 147, 2, // Opcode: DPSUB_S_H, DecodeIdx: 275
/* 6992 */    MCD::OPC_FilterValue, 18, 7, 0, // Skip to: 7003
/* 6996 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 6998 */    MCD::OPC_Decode, 248, 11, 148, 2, // Opcode: DPSUB_S_W, DecodeIdx: 276
/* 7003 */    MCD::OPC_FilterValue, 19, 7, 0, // Skip to: 7014
/* 7007 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7009 */    MCD::OPC_Decode, 246, 11, 149, 2, // Opcode: DPSUB_S_D, DecodeIdx: 277
/* 7014 */    MCD::OPC_FilterValue, 21, 7, 0, // Skip to: 7025
/* 7018 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7020 */    MCD::OPC_Decode, 250, 11, 147, 2, // Opcode: DPSUB_U_H, DecodeIdx: 275
/* 7025 */    MCD::OPC_FilterValue, 22, 7, 0, // Skip to: 7036
/* 7029 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7031 */    MCD::OPC_Decode, 251, 11, 148, 2, // Opcode: DPSUB_U_W, DecodeIdx: 276
/* 7036 */    MCD::OPC_FilterValueOrFail, 23, 
/* 7038 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7040 */    MCD::OPC_Decode, 249, 11, 149, 2, // Opcode: DPSUB_U_D, DecodeIdx: 277
/* 7045 */    MCD::OPC_FilterValue, 20, 97, 1, // Skip to: 7402
/* 7049 */    MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 7052 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 7063
/* 7056 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7058 */    MCD::OPC_Decode, 173, 20, 150, 2, // Opcode: SLD_B, DecodeIdx: 278
/* 7063 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 7074
/* 7067 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7069 */    MCD::OPC_Decode, 175, 20, 151, 2, // Opcode: SLD_H, DecodeIdx: 279
/* 7074 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 7085
/* 7078 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7080 */    MCD::OPC_Decode, 176, 20, 152, 2, // Opcode: SLD_W, DecodeIdx: 280
/* 7085 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 7096
/* 7089 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7091 */    MCD::OPC_Decode, 174, 20, 153, 2, // Opcode: SLD_D, DecodeIdx: 281
/* 7096 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 7107
/* 7100 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7102 */    MCD::OPC_Decode, 212, 20, 154, 2, // Opcode: SPLAT_B, DecodeIdx: 282
/* 7107 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 7118
/* 7111 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7113 */    MCD::OPC_Decode, 214, 20, 155, 2, // Opcode: SPLAT_H, DecodeIdx: 283
/* 7118 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 7129
/* 7122 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7124 */    MCD::OPC_Decode, 215, 20, 156, 2, // Opcode: SPLAT_W, DecodeIdx: 284
/* 7129 */    MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 7140
/* 7133 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7135 */    MCD::OPC_Decode, 213, 20, 157, 2, // Opcode: SPLAT_D, DecodeIdx: 285
/* 7140 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 7151
/* 7144 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7146 */    MCD::OPC_Decode, 174, 18, 136, 2, // Opcode: PCKEV_B, DecodeIdx: 264
/* 7151 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 7162
/* 7155 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7157 */    MCD::OPC_Decode, 176, 18, 137, 2, // Opcode: PCKEV_H, DecodeIdx: 265
/* 7162 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 7173
/* 7166 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7168 */    MCD::OPC_Decode, 177, 18, 138, 2, // Opcode: PCKEV_W, DecodeIdx: 266
/* 7173 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 7184
/* 7177 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7179 */    MCD::OPC_Decode, 175, 18, 139, 2, // Opcode: PCKEV_D, DecodeIdx: 267
/* 7184 */    MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 7195
/* 7188 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7190 */    MCD::OPC_Decode, 178, 18, 136, 2, // Opcode: PCKOD_B, DecodeIdx: 264
/* 7195 */    MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 7206
/* 7199 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7201 */    MCD::OPC_Decode, 180, 18, 137, 2, // Opcode: PCKOD_H, DecodeIdx: 265
/* 7206 */    MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 7217
/* 7210 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7212 */    MCD::OPC_Decode, 181, 18, 138, 2, // Opcode: PCKOD_W, DecodeIdx: 266
/* 7217 */    MCD::OPC_FilterValue, 15, 7, 0, // Skip to: 7228
/* 7221 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7223 */    MCD::OPC_Decode, 179, 18, 139, 2, // Opcode: PCKOD_D, DecodeIdx: 267
/* 7228 */    MCD::OPC_FilterValue, 16, 7, 0, // Skip to: 7239
/* 7232 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7234 */    MCD::OPC_Decode, 147, 14, 136, 2, // Opcode: ILVL_B, DecodeIdx: 264
/* 7239 */    MCD::OPC_FilterValue, 17, 7, 0, // Skip to: 7250
/* 7243 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7245 */    MCD::OPC_Decode, 149, 14, 137, 2, // Opcode: ILVL_H, DecodeIdx: 265
/* 7250 */    MCD::OPC_FilterValue, 18, 7, 0, // Skip to: 7261
/* 7254 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7256 */    MCD::OPC_Decode, 150, 14, 138, 2, // Opcode: ILVL_W, DecodeIdx: 266
/* 7261 */    MCD::OPC_FilterValue, 19, 7, 0, // Skip to: 7272
/* 7265 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7267 */    MCD::OPC_Decode, 148, 14, 139, 2, // Opcode: ILVL_D, DecodeIdx: 267
/* 7272 */    MCD::OPC_FilterValue, 20, 7, 0, // Skip to: 7283
/* 7276 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7278 */    MCD::OPC_Decode, 155, 14, 136, 2, // Opcode: ILVR_B, DecodeIdx: 264
/* 7283 */    MCD::OPC_FilterValue, 21, 7, 0, // Skip to: 7294
/* 7287 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7289 */    MCD::OPC_Decode, 157, 14, 137, 2, // Opcode: ILVR_H, DecodeIdx: 265
/* 7294 */    MCD::OPC_FilterValue, 22, 7, 0, // Skip to: 7305
/* 7298 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7300 */    MCD::OPC_Decode, 158, 14, 138, 2, // Opcode: ILVR_W, DecodeIdx: 266
/* 7305 */    MCD::OPC_FilterValue, 23, 7, 0, // Skip to: 7316
/* 7309 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7311 */    MCD::OPC_Decode, 156, 14, 139, 2, // Opcode: ILVR_D, DecodeIdx: 267
/* 7316 */    MCD::OPC_FilterValue, 24, 7, 0, // Skip to: 7327
/* 7320 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7322 */    MCD::OPC_Decode, 143, 14, 136, 2, // Opcode: ILVEV_B, DecodeIdx: 264
/* 7327 */    MCD::OPC_FilterValue, 25, 7, 0, // Skip to: 7338
/* 7331 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7333 */    MCD::OPC_Decode, 145, 14, 137, 2, // Opcode: ILVEV_H, DecodeIdx: 265
/* 7338 */    MCD::OPC_FilterValue, 26, 7, 0, // Skip to: 7349
/* 7342 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7344 */    MCD::OPC_Decode, 146, 14, 138, 2, // Opcode: ILVEV_W, DecodeIdx: 266
/* 7349 */    MCD::OPC_FilterValue, 27, 7, 0, // Skip to: 7360
/* 7353 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7355 */    MCD::OPC_Decode, 144, 14, 139, 2, // Opcode: ILVEV_D, DecodeIdx: 267
/* 7360 */    MCD::OPC_FilterValue, 28, 7, 0, // Skip to: 7371
/* 7364 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7366 */    MCD::OPC_Decode, 151, 14, 136, 2, // Opcode: ILVOD_B, DecodeIdx: 264
/* 7371 */    MCD::OPC_FilterValue, 29, 7, 0, // Skip to: 7382
/* 7375 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7377 */    MCD::OPC_Decode, 153, 14, 137, 2, // Opcode: ILVOD_H, DecodeIdx: 265
/* 7382 */    MCD::OPC_FilterValue, 30, 7, 0, // Skip to: 7393
/* 7386 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7388 */    MCD::OPC_Decode, 154, 14, 138, 2, // Opcode: ILVOD_W, DecodeIdx: 266
/* 7393 */    MCD::OPC_FilterValueOrFail, 31, 
/* 7395 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7397 */    MCD::OPC_Decode, 152, 14, 139, 2, // Opcode: ILVOD_D, DecodeIdx: 267
/* 7402 */    MCD::OPC_FilterValue, 21, 9, 1, // Skip to: 7671
/* 7406 */    MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 7409 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 7420
/* 7413 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7415 */    MCD::OPC_Decode, 197, 22, 140, 2, // Opcode: VSHF_B, DecodeIdx: 268
/* 7420 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 7431
/* 7424 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7426 */    MCD::OPC_Decode, 199, 22, 141, 2, // Opcode: VSHF_H, DecodeIdx: 269
/* 7431 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 7442
/* 7435 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7437 */    MCD::OPC_Decode, 200, 22, 142, 2, // Opcode: VSHF_W, DecodeIdx: 270
/* 7442 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 7453
/* 7446 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7448 */    MCD::OPC_Decode, 198, 22, 143, 2, // Opcode: VSHF_D, DecodeIdx: 271
/* 7453 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 7464
/* 7457 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7459 */    MCD::OPC_Decode, 225, 20, 136, 2, // Opcode: SRAR_B, DecodeIdx: 264
/* 7464 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 7475
/* 7468 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7470 */    MCD::OPC_Decode, 227, 20, 137, 2, // Opcode: SRAR_H, DecodeIdx: 265
/* 7475 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 7486
/* 7479 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7481 */    MCD::OPC_Decode, 228, 20, 138, 2, // Opcode: SRAR_W, DecodeIdx: 266
/* 7486 */    MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 7497
/* 7490 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7492 */    MCD::OPC_Decode, 226, 20, 139, 2, // Opcode: SRAR_D, DecodeIdx: 267
/* 7497 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 7508
/* 7501 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7503 */    MCD::OPC_Decode, 247, 20, 136, 2, // Opcode: SRLR_B, DecodeIdx: 264
/* 7508 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 7519
/* 7512 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7514 */    MCD::OPC_Decode, 249, 20, 137, 2, // Opcode: SRLR_H, DecodeIdx: 265
/* 7519 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 7530
/* 7523 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7525 */    MCD::OPC_Decode, 250, 20, 138, 2, // Opcode: SRLR_W, DecodeIdx: 266
/* 7530 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 7541
/* 7534 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7536 */    MCD::OPC_Decode, 248, 20, 139, 2, // Opcode: SRLR_D, DecodeIdx: 267
/* 7541 */    MCD::OPC_FilterValue, 17, 7, 0, // Skip to: 7552
/* 7545 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7547 */    MCD::OPC_Decode, 130, 14, 144, 2, // Opcode: HADD_S_H, DecodeIdx: 272
/* 7552 */    MCD::OPC_FilterValue, 18, 7, 0, // Skip to: 7563
/* 7556 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7558 */    MCD::OPC_Decode, 131, 14, 145, 2, // Opcode: HADD_S_W, DecodeIdx: 273
/* 7563 */    MCD::OPC_FilterValue, 19, 7, 0, // Skip to: 7574
/* 7567 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7569 */    MCD::OPC_Decode, 129, 14, 146, 2, // Opcode: HADD_S_D, DecodeIdx: 274
/* 7574 */    MCD::OPC_FilterValue, 21, 7, 0, // Skip to: 7585
/* 7578 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7580 */    MCD::OPC_Decode, 133, 14, 144, 2, // Opcode: HADD_U_H, DecodeIdx: 272
/* 7585 */    MCD::OPC_FilterValue, 22, 7, 0, // Skip to: 7596
/* 7589 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7591 */    MCD::OPC_Decode, 134, 14, 145, 2, // Opcode: HADD_U_W, DecodeIdx: 273
/* 7596 */    MCD::OPC_FilterValue, 23, 7, 0, // Skip to: 7607
/* 7600 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7602 */    MCD::OPC_Decode, 132, 14, 146, 2, // Opcode: HADD_U_D, DecodeIdx: 274
/* 7607 */    MCD::OPC_FilterValue, 25, 7, 0, // Skip to: 7618
/* 7611 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7613 */    MCD::OPC_Decode, 136, 14, 144, 2, // Opcode: HSUB_S_H, DecodeIdx: 272
/* 7618 */    MCD::OPC_FilterValue, 26, 7, 0, // Skip to: 7629
/* 7622 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7624 */    MCD::OPC_Decode, 137, 14, 145, 2, // Opcode: HSUB_S_W, DecodeIdx: 273
/* 7629 */    MCD::OPC_FilterValue, 27, 7, 0, // Skip to: 7640
/* 7633 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7635 */    MCD::OPC_Decode, 135, 14, 146, 2, // Opcode: HSUB_S_D, DecodeIdx: 274
/* 7640 */    MCD::OPC_FilterValue, 29, 7, 0, // Skip to: 7651
/* 7644 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7646 */    MCD::OPC_Decode, 139, 14, 144, 2, // Opcode: HSUB_U_H, DecodeIdx: 272
/* 7651 */    MCD::OPC_FilterValue, 30, 7, 0, // Skip to: 7662
/* 7655 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7657 */    MCD::OPC_Decode, 140, 14, 145, 2, // Opcode: HSUB_U_W, DecodeIdx: 273
/* 7662 */    MCD::OPC_FilterValueOrFail, 31, 
/* 7664 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7666 */    MCD::OPC_Decode, 138, 14, 146, 2, // Opcode: HSUB_U_D, DecodeIdx: 274
/* 7671 */    MCD::OPC_FilterValue, 25, 116, 1, // Skip to: 8047
/* 7675 */    MCD::OPC_ExtractField, 20, 6,  // Inst{25-20} ...
/* 7678 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 7689
/* 7682 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7684 */    MCD::OPC_Decode, 169, 20, 158, 2, // Opcode: SLDI_B, DecodeIdx: 286
/* 7689 */    MCD::OPC_FilterValue, 2, 11, 0, // Skip to: 7704
/* 7693 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7695 */    MCD::OPC_CheckFieldOrFail, 19, 1, 0, 
/* 7699 */    MCD::OPC_Decode, 171, 20, 159, 2, // Opcode: SLDI_H, DecodeIdx: 287
/* 7704 */    MCD::OPC_FilterValue, 3, 42, 0, // Skip to: 7750
/* 7708 */    MCD::OPC_ExtractField, 18, 2,  // Inst{19-18} ...
/* 7711 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 7722
/* 7715 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7717 */    MCD::OPC_Decode, 172, 20, 160, 2, // Opcode: SLDI_W, DecodeIdx: 288
/* 7722 */    MCD::OPC_FilterValue, 2, 11, 0, // Skip to: 7737
/* 7726 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7728 */    MCD::OPC_CheckFieldOrFail, 17, 1, 0, 
/* 7732 */    MCD::OPC_Decode, 170, 20, 161, 2, // Opcode: SLDI_D, DecodeIdx: 289
/* 7737 */    MCD::OPC_FilterValueOrFail, 3, 
/* 7739 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7741 */    MCD::OPC_CheckFieldOrFail, 16, 2, 2, 
/* 7745 */    MCD::OPC_Decode, 138, 10, 162, 2, // Opcode: CTCMSA, DecodeIdx: 290
/* 7750 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 7761
/* 7754 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7756 */    MCD::OPC_Decode, 208, 20, 163, 2, // Opcode: SPLATI_B, DecodeIdx: 291
/* 7761 */    MCD::OPC_FilterValue, 6, 11, 0, // Skip to: 7776
/* 7765 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7767 */    MCD::OPC_CheckFieldOrFail, 19, 1, 0, 
/* 7771 */    MCD::OPC_Decode, 210, 20, 164, 2, // Opcode: SPLATI_H, DecodeIdx: 292
/* 7776 */    MCD::OPC_FilterValue, 7, 42, 0, // Skip to: 7822
/* 7780 */    MCD::OPC_ExtractField, 18, 2,  // Inst{19-18} ...
/* 7783 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 7794
/* 7787 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7789 */    MCD::OPC_Decode, 211, 20, 165, 2, // Opcode: SPLATI_W, DecodeIdx: 293
/* 7794 */    MCD::OPC_FilterValue, 2, 11, 0, // Skip to: 7809
/* 7798 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7800 */    MCD::OPC_CheckFieldOrFail, 17, 1, 0, 
/* 7804 */    MCD::OPC_Decode, 209, 20, 166, 2, // Opcode: SPLATI_D, DecodeIdx: 294
/* 7809 */    MCD::OPC_FilterValueOrFail, 3, 
/* 7811 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7813 */    MCD::OPC_CheckFieldOrFail, 16, 2, 2, 
/* 7817 */    MCD::OPC_Decode, 239, 8, 167, 2, // Opcode: CFCMSA, DecodeIdx: 295
/* 7822 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 7833
/* 7826 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7828 */    MCD::OPC_Decode, 248, 9, 168, 2, // Opcode: COPY_S_B, DecodeIdx: 296
/* 7833 */    MCD::OPC_FilterValue, 10, 11, 0, // Skip to: 7848
/* 7837 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7839 */    MCD::OPC_CheckFieldOrFail, 19, 1, 0, 
/* 7843 */    MCD::OPC_Decode, 250, 9, 169, 2, // Opcode: COPY_S_H, DecodeIdx: 297
/* 7848 */    MCD::OPC_FilterValue, 11, 42, 0, // Skip to: 7894
/* 7852 */    MCD::OPC_ExtractField, 18, 2,  // Inst{19-18} ...
/* 7855 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 7866
/* 7859 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7861 */    MCD::OPC_Decode, 251, 9, 170, 2, // Opcode: COPY_S_W, DecodeIdx: 298
/* 7866 */    MCD::OPC_FilterValue, 2, 11, 0, // Skip to: 7881
/* 7870 */    MCD::OPC_CheckPredicateOrFail, 38, 
/* 7872 */    MCD::OPC_CheckFieldOrFail, 17, 1, 0, 
/* 7876 */    MCD::OPC_Decode, 249, 9, 171, 2, // Opcode: COPY_S_D, DecodeIdx: 299
/* 7881 */    MCD::OPC_FilterValueOrFail, 3, 
/* 7883 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7885 */    MCD::OPC_CheckFieldOrFail, 16, 2, 2, 
/* 7889 */    MCD::OPC_Decode, 224, 16, 172, 2, // Opcode: MOVE_V, DecodeIdx: 300
/* 7894 */    MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 7905
/* 7898 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7900 */    MCD::OPC_Decode, 252, 9, 168, 2, // Opcode: COPY_U_B, DecodeIdx: 296
/* 7905 */    MCD::OPC_FilterValue, 14, 11, 0, // Skip to: 7920
/* 7909 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7911 */    MCD::OPC_CheckFieldOrFail, 19, 1, 0, 
/* 7915 */    MCD::OPC_Decode, 253, 9, 169, 2, // Opcode: COPY_U_H, DecodeIdx: 297
/* 7920 */    MCD::OPC_FilterValue, 15, 11, 0, // Skip to: 7935
/* 7924 */    MCD::OPC_CheckPredicateOrFail, 38, 
/* 7926 */    MCD::OPC_CheckFieldOrFail, 18, 2, 0, 
/* 7930 */    MCD::OPC_Decode, 254, 9, 170, 2, // Opcode: COPY_U_W, DecodeIdx: 298
/* 7935 */    MCD::OPC_FilterValue, 16, 7, 0, // Skip to: 7946
/* 7939 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7941 */    MCD::OPC_Decode, 160, 14, 173, 2, // Opcode: INSERT_B, DecodeIdx: 301
/* 7946 */    MCD::OPC_FilterValue, 18, 11, 0, // Skip to: 7961
/* 7950 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7952 */    MCD::OPC_CheckFieldOrFail, 19, 1, 0, 
/* 7956 */    MCD::OPC_Decode, 162, 14, 174, 2, // Opcode: INSERT_H, DecodeIdx: 302
/* 7961 */    MCD::OPC_FilterValue, 19, 27, 0, // Skip to: 7992
/* 7965 */    MCD::OPC_ExtractField, 18, 2,  // Inst{19-18} ...
/* 7968 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 7979
/* 7972 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7974 */    MCD::OPC_Decode, 163, 14, 175, 2, // Opcode: INSERT_W, DecodeIdx: 303
/* 7979 */    MCD::OPC_FilterValueOrFail, 2, 
/* 7981 */    MCD::OPC_CheckPredicateOrFail, 38, 
/* 7983 */    MCD::OPC_CheckFieldOrFail, 17, 1, 0, 
/* 7987 */    MCD::OPC_Decode, 161, 14, 176, 2, // Opcode: INSERT_D, DecodeIdx: 304
/* 7992 */    MCD::OPC_FilterValue, 20, 7, 0, // Skip to: 8003
/* 7996 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 7998 */    MCD::OPC_Decode, 165, 14, 177, 2, // Opcode: INSVE_B, DecodeIdx: 305
/* 8003 */    MCD::OPC_FilterValue, 22, 11, 0, // Skip to: 8018
/* 8007 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8009 */    MCD::OPC_CheckFieldOrFail, 19, 1, 0, 
/* 8013 */    MCD::OPC_Decode, 167, 14, 177, 2, // Opcode: INSVE_H, DecodeIdx: 305
/* 8018 */    MCD::OPC_FilterValueOrFail, 23, 
/* 8020 */    MCD::OPC_ExtractField, 18, 2,  // Inst{19-18} ...
/* 8023 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 8034
/* 8027 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8029 */    MCD::OPC_Decode, 168, 14, 177, 2, // Opcode: INSVE_W, DecodeIdx: 305
/* 8034 */    MCD::OPC_FilterValueOrFail, 2, 
/* 8036 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8038 */    MCD::OPC_CheckFieldOrFail, 17, 1, 0, 
/* 8042 */    MCD::OPC_Decode, 166, 14, 177, 2, // Opcode: INSVE_D, DecodeIdx: 305
/* 8047 */    MCD::OPC_FilterValue, 26, 97, 1, // Skip to: 8404
/* 8051 */    MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 8054 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 8065
/* 8058 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8060 */    MCD::OPC_Decode, 217, 12, 138, 2, // Opcode: FCAF_W, DecodeIdx: 266
/* 8065 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 8076
/* 8069 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8071 */    MCD::OPC_Decode, 216, 12, 139, 2, // Opcode: FCAF_D, DecodeIdx: 267
/* 8076 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 8087
/* 8080 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8082 */    MCD::OPC_Decode, 244, 12, 138, 2, // Opcode: FCUN_W, DecodeIdx: 266
/* 8087 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 8098
/* 8091 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8093 */    MCD::OPC_Decode, 243, 12, 139, 2, // Opcode: FCUN_D, DecodeIdx: 267
/* 8098 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 8109
/* 8102 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8104 */    MCD::OPC_Decode, 219, 12, 138, 2, // Opcode: FCEQ_W, DecodeIdx: 266
/* 8109 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 8120
/* 8113 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8115 */    MCD::OPC_Decode, 218, 12, 139, 2, // Opcode: FCEQ_D, DecodeIdx: 267
/* 8120 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 8131
/* 8124 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8126 */    MCD::OPC_Decode, 236, 12, 138, 2, // Opcode: FCUEQ_W, DecodeIdx: 266
/* 8131 */    MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 8142
/* 8135 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8137 */    MCD::OPC_Decode, 235, 12, 139, 2, // Opcode: FCUEQ_D, DecodeIdx: 267
/* 8142 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 8153
/* 8146 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8148 */    MCD::OPC_Decode, 225, 12, 138, 2, // Opcode: FCLT_W, DecodeIdx: 266
/* 8153 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 8164
/* 8157 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8159 */    MCD::OPC_Decode, 224, 12, 139, 2, // Opcode: FCLT_D, DecodeIdx: 267
/* 8164 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 8175
/* 8168 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8170 */    MCD::OPC_Decode, 240, 12, 138, 2, // Opcode: FCULT_W, DecodeIdx: 266
/* 8175 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 8186
/* 8179 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8181 */    MCD::OPC_Decode, 239, 12, 139, 2, // Opcode: FCULT_D, DecodeIdx: 267
/* 8186 */    MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 8197
/* 8190 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8192 */    MCD::OPC_Decode, 223, 12, 138, 2, // Opcode: FCLE_W, DecodeIdx: 266
/* 8197 */    MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 8208
/* 8201 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8203 */    MCD::OPC_Decode, 222, 12, 139, 2, // Opcode: FCLE_D, DecodeIdx: 267
/* 8208 */    MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 8219
/* 8212 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8214 */    MCD::OPC_Decode, 238, 12, 138, 2, // Opcode: FCULE_W, DecodeIdx: 266
/* 8219 */    MCD::OPC_FilterValue, 15, 7, 0, // Skip to: 8230
/* 8223 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8225 */    MCD::OPC_Decode, 237, 12, 139, 2, // Opcode: FCULE_D, DecodeIdx: 267
/* 8230 */    MCD::OPC_FilterValue, 16, 7, 0, // Skip to: 8241
/* 8234 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8236 */    MCD::OPC_Decode, 204, 13, 138, 2, // Opcode: FSAF_W, DecodeIdx: 266
/* 8241 */    MCD::OPC_FilterValue, 17, 7, 0, // Skip to: 8252
/* 8245 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8247 */    MCD::OPC_Decode, 203, 13, 139, 2, // Opcode: FSAF_D, DecodeIdx: 267
/* 8252 */    MCD::OPC_FilterValue, 18, 7, 0, // Skip to: 8263
/* 8256 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8258 */    MCD::OPC_Decode, 242, 13, 138, 2, // Opcode: FSUN_W, DecodeIdx: 266
/* 8263 */    MCD::OPC_FilterValue, 19, 7, 0, // Skip to: 8274
/* 8267 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8269 */    MCD::OPC_Decode, 241, 13, 139, 2, // Opcode: FSUN_D, DecodeIdx: 267
/* 8274 */    MCD::OPC_FilterValue, 20, 7, 0, // Skip to: 8285
/* 8278 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8280 */    MCD::OPC_Decode, 206, 13, 138, 2, // Opcode: FSEQ_W, DecodeIdx: 266
/* 8285 */    MCD::OPC_FilterValue, 21, 7, 0, // Skip to: 8296
/* 8289 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8291 */    MCD::OPC_Decode, 205, 13, 139, 2, // Opcode: FSEQ_D, DecodeIdx: 267
/* 8296 */    MCD::OPC_FilterValue, 22, 7, 0, // Skip to: 8307
/* 8300 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8302 */    MCD::OPC_Decode, 234, 13, 138, 2, // Opcode: FSUEQ_W, DecodeIdx: 266
/* 8307 */    MCD::OPC_FilterValue, 23, 7, 0, // Skip to: 8318
/* 8311 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8313 */    MCD::OPC_Decode, 233, 13, 139, 2, // Opcode: FSUEQ_D, DecodeIdx: 267
/* 8318 */    MCD::OPC_FilterValue, 24, 7, 0, // Skip to: 8329
/* 8322 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8324 */    MCD::OPC_Decode, 210, 13, 138, 2, // Opcode: FSLT_W, DecodeIdx: 266
/* 8329 */    MCD::OPC_FilterValue, 25, 7, 0, // Skip to: 8340
/* 8333 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8335 */    MCD::OPC_Decode, 209, 13, 139, 2, // Opcode: FSLT_D, DecodeIdx: 267
/* 8340 */    MCD::OPC_FilterValue, 26, 7, 0, // Skip to: 8351
/* 8344 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8346 */    MCD::OPC_Decode, 238, 13, 138, 2, // Opcode: FSULT_W, DecodeIdx: 266
/* 8351 */    MCD::OPC_FilterValue, 27, 7, 0, // Skip to: 8362
/* 8355 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8357 */    MCD::OPC_Decode, 237, 13, 139, 2, // Opcode: FSULT_D, DecodeIdx: 267
/* 8362 */    MCD::OPC_FilterValue, 28, 7, 0, // Skip to: 8373
/* 8366 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8368 */    MCD::OPC_Decode, 208, 13, 138, 2, // Opcode: FSLE_W, DecodeIdx: 266
/* 8373 */    MCD::OPC_FilterValue, 29, 7, 0, // Skip to: 8384
/* 8377 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8379 */    MCD::OPC_Decode, 207, 13, 139, 2, // Opcode: FSLE_D, DecodeIdx: 267
/* 8384 */    MCD::OPC_FilterValue, 30, 7, 0, // Skip to: 8395
/* 8388 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8390 */    MCD::OPC_Decode, 236, 13, 138, 2, // Opcode: FSULE_W, DecodeIdx: 266
/* 8395 */    MCD::OPC_FilterValueOrFail, 31, 
/* 8397 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8399 */    MCD::OPC_Decode, 235, 13, 139, 2, // Opcode: FSULE_D, DecodeIdx: 267
/* 8404 */    MCD::OPC_FilterValue, 27, 31, 1, // Skip to: 8695
/* 8408 */    MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 8411 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 8422
/* 8415 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8417 */    MCD::OPC_Decode, 215, 12, 138, 2, // Opcode: FADD_W, DecodeIdx: 266
/* 8422 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 8433
/* 8426 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8428 */    MCD::OPC_Decode, 206, 12, 139, 2, // Opcode: FADD_D, DecodeIdx: 267
/* 8433 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 8444
/* 8437 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8439 */    MCD::OPC_Decode, 232, 13, 138, 2, // Opcode: FSUB_W, DecodeIdx: 266
/* 8444 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 8455
/* 8448 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8450 */    MCD::OPC_Decode, 223, 13, 139, 2, // Opcode: FSUB_D, DecodeIdx: 267
/* 8455 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 8466
/* 8459 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8461 */    MCD::OPC_Decode, 188, 13, 138, 2, // Opcode: FMUL_W, DecodeIdx: 266
/* 8466 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 8477
/* 8470 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8472 */    MCD::OPC_Decode, 179, 13, 139, 2, // Opcode: FMUL_D, DecodeIdx: 267
/* 8477 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 8488
/* 8481 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8483 */    MCD::OPC_Decode, 253, 12, 138, 2, // Opcode: FDIV_W, DecodeIdx: 266
/* 8488 */    MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 8499
/* 8492 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8494 */    MCD::OPC_Decode, 245, 12, 139, 2, // Opcode: FDIV_D, DecodeIdx: 267
/* 8499 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 8510
/* 8503 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8505 */    MCD::OPC_Decode, 160, 13, 142, 2, // Opcode: FMADD_W, DecodeIdx: 270
/* 8510 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 8521
/* 8514 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8516 */    MCD::OPC_Decode, 159, 13, 143, 2, // Opcode: FMADD_D, DecodeIdx: 271
/* 8521 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 8532
/* 8525 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8527 */    MCD::OPC_Decode, 178, 13, 142, 2, // Opcode: FMSUB_W, DecodeIdx: 270
/* 8532 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 8543
/* 8536 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8538 */    MCD::OPC_Decode, 177, 13, 143, 2, // Opcode: FMSUB_D, DecodeIdx: 271
/* 8543 */    MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 8554
/* 8547 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8549 */    MCD::OPC_Decode, 129, 13, 138, 2, // Opcode: FEXP2_W, DecodeIdx: 266
/* 8554 */    MCD::OPC_FilterValue, 15, 7, 0, // Skip to: 8565
/* 8558 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8560 */    MCD::OPC_Decode, 128, 13, 139, 2, // Opcode: FEXP2_D, DecodeIdx: 267
/* 8565 */    MCD::OPC_FilterValue, 16, 7, 0, // Skip to: 8576
/* 8569 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8571 */    MCD::OPC_Decode, 254, 12, 178, 2, // Opcode: FEXDO_H, DecodeIdx: 306
/* 8576 */    MCD::OPC_FilterValue, 17, 7, 0, // Skip to: 8587
/* 8580 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8582 */    MCD::OPC_Decode, 255, 12, 179, 2, // Opcode: FEXDO_W, DecodeIdx: 307
/* 8587 */    MCD::OPC_FilterValue, 20, 7, 0, // Skip to: 8598
/* 8591 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8593 */    MCD::OPC_Decode, 247, 13, 178, 2, // Opcode: FTQ_H, DecodeIdx: 306
/* 8598 */    MCD::OPC_FilterValue, 21, 7, 0, // Skip to: 8609
/* 8602 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8604 */    MCD::OPC_Decode, 248, 13, 179, 2, // Opcode: FTQ_W, DecodeIdx: 307
/* 8609 */    MCD::OPC_FilterValue, 24, 7, 0, // Skip to: 8620
/* 8613 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8615 */    MCD::OPC_Decode, 168, 13, 138, 2, // Opcode: FMIN_W, DecodeIdx: 266
/* 8620 */    MCD::OPC_FilterValue, 25, 7, 0, // Skip to: 8631
/* 8624 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8626 */    MCD::OPC_Decode, 167, 13, 139, 2, // Opcode: FMIN_D, DecodeIdx: 267
/* 8631 */    MCD::OPC_FilterValue, 26, 7, 0, // Skip to: 8642
/* 8635 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8637 */    MCD::OPC_Decode, 166, 13, 138, 2, // Opcode: FMIN_A_W, DecodeIdx: 266
/* 8642 */    MCD::OPC_FilterValue, 27, 7, 0, // Skip to: 8653
/* 8646 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8648 */    MCD::OPC_Decode, 165, 13, 139, 2, // Opcode: FMIN_A_D, DecodeIdx: 267
/* 8653 */    MCD::OPC_FilterValue, 28, 7, 0, // Skip to: 8664
/* 8657 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8659 */    MCD::OPC_Decode, 164, 13, 138, 2, // Opcode: FMAX_W, DecodeIdx: 266
/* 8664 */    MCD::OPC_FilterValue, 29, 7, 0, // Skip to: 8675
/* 8668 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8670 */    MCD::OPC_Decode, 163, 13, 139, 2, // Opcode: FMAX_D, DecodeIdx: 267
/* 8675 */    MCD::OPC_FilterValue, 30, 7, 0, // Skip to: 8686
/* 8679 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8681 */    MCD::OPC_Decode, 162, 13, 138, 2, // Opcode: FMAX_A_W, DecodeIdx: 266
/* 8686 */    MCD::OPC_FilterValueOrFail, 31, 
/* 8688 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8690 */    MCD::OPC_Decode, 161, 13, 139, 2, // Opcode: FMAX_A_D, DecodeIdx: 267
/* 8695 */    MCD::OPC_FilterValue, 28, 9, 1, // Skip to: 8964
/* 8699 */    MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 8702 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 8713
/* 8706 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8708 */    MCD::OPC_Decode, 234, 12, 138, 2, // Opcode: FCOR_W, DecodeIdx: 266
/* 8713 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 8724
/* 8717 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8719 */    MCD::OPC_Decode, 233, 12, 139, 2, // Opcode: FCOR_D, DecodeIdx: 267
/* 8724 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 8735
/* 8728 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8730 */    MCD::OPC_Decode, 242, 12, 138, 2, // Opcode: FCUNE_W, DecodeIdx: 266
/* 8735 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 8746
/* 8739 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8741 */    MCD::OPC_Decode, 241, 12, 139, 2, // Opcode: FCUNE_D, DecodeIdx: 267
/* 8746 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 8757
/* 8750 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8752 */    MCD::OPC_Decode, 232, 12, 138, 2, // Opcode: FCNE_W, DecodeIdx: 266
/* 8757 */    MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 8768
/* 8761 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8763 */    MCD::OPC_Decode, 231, 12, 139, 2, // Opcode: FCNE_D, DecodeIdx: 267
/* 8768 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 8779
/* 8772 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8774 */    MCD::OPC_Decode, 246, 17, 137, 2, // Opcode: MUL_Q_H, DecodeIdx: 265
/* 8779 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 8790
/* 8783 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8785 */    MCD::OPC_Decode, 247, 17, 138, 2, // Opcode: MUL_Q_W, DecodeIdx: 266
/* 8790 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 8801
/* 8794 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8796 */    MCD::OPC_Decode, 235, 15, 141, 2, // Opcode: MADD_Q_H, DecodeIdx: 269
/* 8801 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 8812
/* 8805 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8807 */    MCD::OPC_Decode, 236, 15, 142, 2, // Opcode: MADD_Q_W, DecodeIdx: 270
/* 8812 */    MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 8823
/* 8816 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8818 */    MCD::OPC_Decode, 158, 17, 141, 2, // Opcode: MSUB_Q_H, DecodeIdx: 269
/* 8823 */    MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 8834
/* 8827 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8829 */    MCD::OPC_Decode, 159, 17, 142, 2, // Opcode: MSUB_Q_W, DecodeIdx: 270
/* 8834 */    MCD::OPC_FilterValue, 18, 7, 0, // Skip to: 8845
/* 8838 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8840 */    MCD::OPC_Decode, 214, 13, 138, 2, // Opcode: FSOR_W, DecodeIdx: 266
/* 8845 */    MCD::OPC_FilterValue, 19, 7, 0, // Skip to: 8856
/* 8849 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8851 */    MCD::OPC_Decode, 213, 13, 139, 2, // Opcode: FSOR_D, DecodeIdx: 267
/* 8856 */    MCD::OPC_FilterValue, 20, 7, 0, // Skip to: 8867
/* 8860 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8862 */    MCD::OPC_Decode, 240, 13, 138, 2, // Opcode: FSUNE_W, DecodeIdx: 266
/* 8867 */    MCD::OPC_FilterValue, 21, 7, 0, // Skip to: 8878
/* 8871 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8873 */    MCD::OPC_Decode, 239, 13, 139, 2, // Opcode: FSUNE_D, DecodeIdx: 267
/* 8878 */    MCD::OPC_FilterValue, 22, 7, 0, // Skip to: 8889
/* 8882 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8884 */    MCD::OPC_Decode, 212, 13, 138, 2, // Opcode: FSNE_W, DecodeIdx: 266
/* 8889 */    MCD::OPC_FilterValue, 23, 7, 0, // Skip to: 8900
/* 8893 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8895 */    MCD::OPC_Decode, 211, 13, 139, 2, // Opcode: FSNE_D, DecodeIdx: 267
/* 8900 */    MCD::OPC_FilterValue, 24, 7, 0, // Skip to: 8911
/* 8904 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8906 */    MCD::OPC_Decode, 222, 17, 137, 2, // Opcode: MULR_Q_H, DecodeIdx: 265
/* 8911 */    MCD::OPC_FilterValue, 25, 7, 0, // Skip to: 8922
/* 8915 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8917 */    MCD::OPC_Decode, 223, 17, 138, 2, // Opcode: MULR_Q_W, DecodeIdx: 266
/* 8922 */    MCD::OPC_FilterValue, 26, 7, 0, // Skip to: 8933
/* 8926 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8928 */    MCD::OPC_Decode, 219, 15, 141, 2, // Opcode: MADDR_Q_H, DecodeIdx: 269
/* 8933 */    MCD::OPC_FilterValue, 27, 7, 0, // Skip to: 8944
/* 8937 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8939 */    MCD::OPC_Decode, 220, 15, 142, 2, // Opcode: MADDR_Q_W, DecodeIdx: 270
/* 8944 */    MCD::OPC_FilterValue, 28, 7, 0, // Skip to: 8955
/* 8948 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8950 */    MCD::OPC_Decode, 142, 17, 141, 2, // Opcode: MSUBR_Q_H, DecodeIdx: 269
/* 8955 */    MCD::OPC_FilterValueOrFail, 29, 
/* 8957 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8959 */    MCD::OPC_Decode, 143, 17, 142, 2, // Opcode: MSUBR_Q_W, DecodeIdx: 270
/* 8964 */    MCD::OPC_FilterValue, 30, 104, 2, // Skip to: 9584
/* 8968 */    MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 8971 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 8982
/* 8975 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8977 */    MCD::OPC_Decode, 227, 6, 136, 2, // Opcode: AND_V, DecodeIdx: 264
/* 8982 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 8993
/* 8986 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8988 */    MCD::OPC_Decode, 164, 18, 136, 2, // Opcode: OR_V, DecodeIdx: 264
/* 8993 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 9004
/* 8997 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 8999 */    MCD::OPC_Decode, 151, 18, 136, 2, // Opcode: NOR_V, DecodeIdx: 264
/* 9004 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 9015
/* 9008 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9010 */    MCD::OPC_Decode, 218, 22, 136, 2, // Opcode: XOR_V, DecodeIdx: 264
/* 9015 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 9026
/* 9019 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9021 */    MCD::OPC_Decode, 142, 8, 140, 2, // Opcode: BMNZ_V, DecodeIdx: 268
/* 9026 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 9037
/* 9030 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9032 */    MCD::OPC_Decode, 144, 8, 140, 2, // Opcode: BMZ_V, DecodeIdx: 268
/* 9037 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 9048
/* 9041 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9043 */    MCD::OPC_Decode, 186, 8, 140, 2, // Opcode: BSEL_V, DecodeIdx: 268
/* 9048 */    MCD::OPC_FilterValue, 24, 177, 0, // Skip to: 9229
/* 9052 */    MCD::OPC_ExtractField, 16, 5,  // Inst{20-16} ...
/* 9055 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 9066
/* 9059 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9061 */    MCD::OPC_Decode, 142, 13, 180, 2, // Opcode: FILL_B, DecodeIdx: 308
/* 9066 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 9077
/* 9070 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9072 */    MCD::OPC_Decode, 144, 13, 181, 2, // Opcode: FILL_H, DecodeIdx: 309
/* 9077 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 9088
/* 9081 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9083 */    MCD::OPC_Decode, 145, 13, 182, 2, // Opcode: FILL_W, DecodeIdx: 310
/* 9088 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 9099
/* 9092 */    MCD::OPC_CheckPredicateOrFail, 38, 
/* 9094 */    MCD::OPC_Decode, 143, 13, 183, 2, // Opcode: FILL_D, DecodeIdx: 311
/* 9099 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 9110
/* 9103 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9105 */    MCD::OPC_Decode, 182, 18, 172, 2, // Opcode: PCNT_B, DecodeIdx: 300
/* 9110 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 9121
/* 9114 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9116 */    MCD::OPC_Decode, 184, 18, 184, 2, // Opcode: PCNT_H, DecodeIdx: 312
/* 9121 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 9132
/* 9125 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9127 */    MCD::OPC_Decode, 185, 18, 185, 2, // Opcode: PCNT_W, DecodeIdx: 313
/* 9132 */    MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 9143
/* 9136 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9138 */    MCD::OPC_Decode, 183, 18, 186, 2, // Opcode: PCNT_D, DecodeIdx: 314
/* 9143 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 9154
/* 9147 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9149 */    MCD::OPC_Decode, 128, 18, 172, 2, // Opcode: NLOC_B, DecodeIdx: 300
/* 9154 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 9165
/* 9158 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9160 */    MCD::OPC_Decode, 130, 18, 184, 2, // Opcode: NLOC_H, DecodeIdx: 312
/* 9165 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 9176
/* 9169 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9171 */    MCD::OPC_Decode, 131, 18, 185, 2, // Opcode: NLOC_W, DecodeIdx: 313
/* 9176 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 9187
/* 9180 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9182 */    MCD::OPC_Decode, 129, 18, 186, 2, // Opcode: NLOC_D, DecodeIdx: 314
/* 9187 */    MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 9198
/* 9191 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9193 */    MCD::OPC_Decode, 132, 18, 172, 2, // Opcode: NLZC_B, DecodeIdx: 300
/* 9198 */    MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 9209
/* 9202 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9204 */    MCD::OPC_Decode, 134, 18, 184, 2, // Opcode: NLZC_H, DecodeIdx: 312
/* 9209 */    MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 9220
/* 9213 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9215 */    MCD::OPC_Decode, 135, 18, 185, 2, // Opcode: NLZC_W, DecodeIdx: 313
/* 9220 */    MCD::OPC_FilterValueOrFail, 15, 
/* 9222 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9224 */    MCD::OPC_Decode, 133, 18, 186, 2, // Opcode: NLZC_D, DecodeIdx: 314
/* 9229 */    MCD::OPC_FilterValueOrFail, 25, 
/* 9231 */    MCD::OPC_ExtractField, 16, 5,  // Inst{20-16} ...
/* 9234 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 9245
/* 9238 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9240 */    MCD::OPC_Decode, 221, 12, 185, 2, // Opcode: FCLASS_W, DecodeIdx: 313
/* 9245 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 9256
/* 9249 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9251 */    MCD::OPC_Decode, 220, 12, 186, 2, // Opcode: FCLASS_D, DecodeIdx: 314
/* 9256 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 9267
/* 9260 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9262 */    MCD::OPC_Decode, 250, 13, 185, 2, // Opcode: FTRUNC_S_W, DecodeIdx: 313
/* 9267 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 9278
/* 9271 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9273 */    MCD::OPC_Decode, 249, 13, 186, 2, // Opcode: FTRUNC_S_D, DecodeIdx: 314
/* 9278 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 9289
/* 9282 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9284 */    MCD::OPC_Decode, 252, 13, 185, 2, // Opcode: FTRUNC_U_W, DecodeIdx: 313
/* 9289 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 9300
/* 9293 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9295 */    MCD::OPC_Decode, 251, 13, 186, 2, // Opcode: FTRUNC_U_D, DecodeIdx: 314
/* 9300 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 9311
/* 9304 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9306 */    MCD::OPC_Decode, 222, 13, 185, 2, // Opcode: FSQRT_W, DecodeIdx: 313
/* 9311 */    MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 9322
/* 9315 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9317 */    MCD::OPC_Decode, 215, 13, 186, 2, // Opcode: FSQRT_D, DecodeIdx: 314
/* 9322 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 9333
/* 9326 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9328 */    MCD::OPC_Decode, 202, 13, 185, 2, // Opcode: FRSQRT_W, DecodeIdx: 313
/* 9333 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 9344
/* 9337 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9339 */    MCD::OPC_Decode, 201, 13, 186, 2, // Opcode: FRSQRT_D, DecodeIdx: 314
/* 9344 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 9355
/* 9348 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9350 */    MCD::OPC_Decode, 198, 13, 185, 2, // Opcode: FRCP_W, DecodeIdx: 313
/* 9355 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 9366
/* 9359 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9361 */    MCD::OPC_Decode, 197, 13, 186, 2, // Opcode: FRCP_D, DecodeIdx: 314
/* 9366 */    MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 9377
/* 9370 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9372 */    MCD::OPC_Decode, 200, 13, 185, 2, // Opcode: FRINT_W, DecodeIdx: 313
/* 9377 */    MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 9388
/* 9381 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9383 */    MCD::OPC_Decode, 199, 13, 186, 2, // Opcode: FRINT_D, DecodeIdx: 314
/* 9388 */    MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 9399
/* 9392 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9394 */    MCD::OPC_Decode, 147, 13, 185, 2, // Opcode: FLOG2_W, DecodeIdx: 313
/* 9399 */    MCD::OPC_FilterValue, 15, 7, 0, // Skip to: 9410
/* 9403 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9405 */    MCD::OPC_Decode, 146, 13, 186, 2, // Opcode: FLOG2_D, DecodeIdx: 314
/* 9410 */    MCD::OPC_FilterValue, 16, 7, 0, // Skip to: 9421
/* 9414 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9416 */    MCD::OPC_Decode, 131, 13, 187, 2, // Opcode: FEXUPL_W, DecodeIdx: 315
/* 9421 */    MCD::OPC_FilterValue, 17, 7, 0, // Skip to: 9432
/* 9425 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9427 */    MCD::OPC_Decode, 130, 13, 188, 2, // Opcode: FEXUPL_D, DecodeIdx: 316
/* 9432 */    MCD::OPC_FilterValue, 18, 7, 0, // Skip to: 9443
/* 9436 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9438 */    MCD::OPC_Decode, 133, 13, 187, 2, // Opcode: FEXUPR_W, DecodeIdx: 315
/* 9443 */    MCD::OPC_FilterValue, 19, 7, 0, // Skip to: 9454
/* 9447 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9449 */    MCD::OPC_Decode, 132, 13, 188, 2, // Opcode: FEXUPR_D, DecodeIdx: 316
/* 9454 */    MCD::OPC_FilterValue, 20, 7, 0, // Skip to: 9465
/* 9458 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9460 */    MCD::OPC_Decode, 139, 13, 187, 2, // Opcode: FFQL_W, DecodeIdx: 315
/* 9465 */    MCD::OPC_FilterValue, 21, 7, 0, // Skip to: 9476
/* 9469 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9471 */    MCD::OPC_Decode, 138, 13, 188, 2, // Opcode: FFQL_D, DecodeIdx: 316
/* 9476 */    MCD::OPC_FilterValue, 22, 7, 0, // Skip to: 9487
/* 9480 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9482 */    MCD::OPC_Decode, 141, 13, 187, 2, // Opcode: FFQR_W, DecodeIdx: 315
/* 9487 */    MCD::OPC_FilterValue, 23, 7, 0, // Skip to: 9498
/* 9491 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9493 */    MCD::OPC_Decode, 140, 13, 188, 2, // Opcode: FFQR_D, DecodeIdx: 316
/* 9498 */    MCD::OPC_FilterValue, 24, 7, 0, // Skip to: 9509
/* 9502 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9504 */    MCD::OPC_Decode, 244, 13, 185, 2, // Opcode: FTINT_S_W, DecodeIdx: 313
/* 9509 */    MCD::OPC_FilterValue, 25, 7, 0, // Skip to: 9520
/* 9513 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9515 */    MCD::OPC_Decode, 243, 13, 186, 2, // Opcode: FTINT_S_D, DecodeIdx: 314
/* 9520 */    MCD::OPC_FilterValue, 26, 7, 0, // Skip to: 9531
/* 9524 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9526 */    MCD::OPC_Decode, 246, 13, 185, 2, // Opcode: FTINT_U_W, DecodeIdx: 313
/* 9531 */    MCD::OPC_FilterValue, 27, 7, 0, // Skip to: 9542
/* 9535 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9537 */    MCD::OPC_Decode, 245, 13, 186, 2, // Opcode: FTINT_U_D, DecodeIdx: 314
/* 9542 */    MCD::OPC_FilterValue, 28, 7, 0, // Skip to: 9553
/* 9546 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9548 */    MCD::OPC_Decode, 135, 13, 185, 2, // Opcode: FFINT_S_W, DecodeIdx: 313
/* 9553 */    MCD::OPC_FilterValue, 29, 7, 0, // Skip to: 9564
/* 9557 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9559 */    MCD::OPC_Decode, 134, 13, 186, 2, // Opcode: FFINT_S_D, DecodeIdx: 314
/* 9564 */    MCD::OPC_FilterValue, 30, 7, 0, // Skip to: 9575
/* 9568 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9570 */    MCD::OPC_Decode, 137, 13, 185, 2, // Opcode: FFINT_U_W, DecodeIdx: 313
/* 9575 */    MCD::OPC_FilterValueOrFail, 31, 
/* 9577 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9579 */    MCD::OPC_Decode, 136, 13, 186, 2, // Opcode: FFINT_U_D, DecodeIdx: 314
/* 9584 */    MCD::OPC_FilterValue, 32, 7, 0, // Skip to: 9595
/* 9588 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9590 */    MCD::OPC_Decode, 248, 14, 189, 2, // Opcode: LD_B, DecodeIdx: 317
/* 9595 */    MCD::OPC_FilterValue, 33, 7, 0, // Skip to: 9606
/* 9599 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9601 */    MCD::OPC_Decode, 250, 14, 189, 2, // Opcode: LD_H, DecodeIdx: 317
/* 9606 */    MCD::OPC_FilterValue, 34, 7, 0, // Skip to: 9617
/* 9610 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9612 */    MCD::OPC_Decode, 251, 14, 189, 2, // Opcode: LD_W, DecodeIdx: 317
/* 9617 */    MCD::OPC_FilterValue, 35, 7, 0, // Skip to: 9628
/* 9621 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9623 */    MCD::OPC_Decode, 249, 14, 189, 2, // Opcode: LD_D, DecodeIdx: 317
/* 9628 */    MCD::OPC_FilterValue, 36, 7, 0, // Skip to: 9639
/* 9632 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9634 */    MCD::OPC_Decode, 133, 21, 189, 2, // Opcode: ST_B, DecodeIdx: 317
/* 9639 */    MCD::OPC_FilterValue, 37, 7, 0, // Skip to: 9650
/* 9643 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9645 */    MCD::OPC_Decode, 135, 21, 189, 2, // Opcode: ST_H, DecodeIdx: 317
/* 9650 */    MCD::OPC_FilterValue, 38, 7, 0, // Skip to: 9661
/* 9654 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9656 */    MCD::OPC_Decode, 136, 21, 189, 2, // Opcode: ST_W, DecodeIdx: 317
/* 9661 */    MCD::OPC_FilterValueOrFail, 39, 
/* 9663 */    MCD::OPC_CheckPredicateOrFail, 30, 
/* 9665 */    MCD::OPC_Decode, 134, 21, 189, 2, // Opcode: ST_D, DecodeIdx: 317
/* 9670 */    MCD::OPC_FilterValue, 31, 214, 8, // Skip to: 11936
/* 9674 */    MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 9677 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 9688
/* 9681 */    MCD::OPC_CheckPredicateOrFail, 28, 
/* 9683 */    MCD::OPC_Decode, 171, 12, 190, 2, // Opcode: EXT, DecodeIdx: 318
/* 9688 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 9699
/* 9692 */    MCD::OPC_CheckPredicateOrFail, 28, 
/* 9694 */    MCD::OPC_Decode, 159, 14, 191, 2, // Opcode: INS, DecodeIdx: 319
/* 9699 */    MCD::OPC_FilterValue, 8, 11, 0, // Skip to: 9714
/* 9703 */    MCD::OPC_CheckPredicateOrFail, 42, 
/* 9705 */    MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 9709 */    MCD::OPC_Decode, 196, 13, 192, 2, // Opcode: FORK, DecodeIdx: 320
/* 9714 */    MCD::OPC_FilterValue, 9, 14, 0, // Skip to: 9732
/* 9718 */    MCD::OPC_CheckPredicateOrFail, 42, 
/* 9720 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 9724 */    MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 9728 */    MCD::OPC_Decode, 223, 22, 25, // Opcode: YIELD, DecodeIdx: 25
/* 9732 */    MCD::OPC_FilterValue, 10, 34, 0, // Skip to: 9770
/* 9736 */    MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 9739 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 9750
/* 9743 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 9745 */    MCD::OPC_Decode, 195, 15, 193, 2, // Opcode: LWX, DecodeIdx: 321
/* 9750 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 9761
/* 9754 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 9756 */    MCD::OPC_Decode, 132, 15, 193, 2, // Opcode: LHX, DecodeIdx: 321
/* 9761 */    MCD::OPC_FilterValueOrFail, 6, 
/* 9763 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 9765 */    MCD::OPC_Decode, 219, 14, 193, 2, // Opcode: LBUX, DecodeIdx: 321
/* 9770 */    MCD::OPC_FilterValue, 12, 11, 0, // Skip to: 9785
/* 9774 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 9776 */    MCD::OPC_CheckFieldOrFail, 6, 10, 0, 
/* 9780 */    MCD::OPC_Decode, 164, 14, 194, 2, // Opcode: INSV, DecodeIdx: 322
/* 9785 */    MCD::OPC_FilterValue, 16, 8, 1, // Skip to: 10053
/* 9789 */    MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 9792 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 9803
/* 9796 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 9798 */    MCD::OPC_Decode, 185, 6, 195, 2, // Opcode: ADDU_QB, DecodeIdx: 323
/* 9803 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 9814
/* 9807 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 9809 */    MCD::OPC_Decode, 177, 21, 195, 2, // Opcode: SUBU_QB, DecodeIdx: 323
/* 9814 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 9825
/* 9818 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 9820 */    MCD::OPC_Decode, 189, 6, 195, 2, // Opcode: ADDU_S_QB, DecodeIdx: 323
/* 9825 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 9836
/* 9829 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 9831 */    MCD::OPC_Decode, 181, 21, 195, 2, // Opcode: SUBU_S_QB, DecodeIdx: 323
/* 9836 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 9847
/* 9840 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 9842 */    MCD::OPC_Decode, 209, 17, 195, 2, // Opcode: MULEU_S_PH_QBL, DecodeIdx: 323
/* 9847 */    MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 9858
/* 9851 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 9853 */    MCD::OPC_Decode, 211, 17, 195, 2, // Opcode: MULEU_S_PH_QBR, DecodeIdx: 323
/* 9858 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 9869
/* 9862 */    MCD::OPC_CheckPredicateOrFail, 69, 
/* 9864 */    MCD::OPC_Decode, 183, 6, 195, 2, // Opcode: ADDU_PH, DecodeIdx: 323
/* 9869 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 9880
/* 9873 */    MCD::OPC_CheckPredicateOrFail, 69, 
/* 9875 */    MCD::OPC_Decode, 175, 21, 195, 2, // Opcode: SUBU_PH, DecodeIdx: 323
/* 9880 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 9891
/* 9884 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 9886 */    MCD::OPC_Decode, 155, 6, 195, 2, // Opcode: ADDQ_PH, DecodeIdx: 323
/* 9891 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 9902
/* 9895 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 9897 */    MCD::OPC_Decode, 146, 21, 195, 2, // Opcode: SUBQ_PH, DecodeIdx: 323
/* 9902 */    MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 9913
/* 9906 */    MCD::OPC_CheckPredicateOrFail, 69, 
/* 9908 */    MCD::OPC_Decode, 187, 6, 195, 2, // Opcode: ADDU_S_PH, DecodeIdx: 323
/* 9913 */    MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 9924
/* 9917 */    MCD::OPC_CheckPredicateOrFail, 69, 
/* 9919 */    MCD::OPC_Decode, 179, 21, 195, 2, // Opcode: SUBU_S_PH, DecodeIdx: 323
/* 9924 */    MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 9935
/* 9928 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 9930 */    MCD::OPC_Decode, 157, 6, 195, 2, // Opcode: ADDQ_S_PH, DecodeIdx: 323
/* 9935 */    MCD::OPC_FilterValue, 15, 7, 0, // Skip to: 9946
/* 9939 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 9941 */    MCD::OPC_Decode, 148, 21, 195, 2, // Opcode: SUBQ_S_PH, DecodeIdx: 323
/* 9946 */    MCD::OPC_FilterValue, 16, 6, 0, // Skip to: 9956
/* 9950 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 9952 */    MCD::OPC_Decode, 162, 6, 61, // Opcode: ADDSC, DecodeIdx: 61
/* 9956 */    MCD::OPC_FilterValue, 17, 6, 0, // Skip to: 9966
/* 9960 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 9962 */    MCD::OPC_Decode, 199, 6, 61, // Opcode: ADDWC, DecodeIdx: 61
/* 9966 */    MCD::OPC_FilterValue, 18, 6, 0, // Skip to: 9976
/* 9970 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 9972 */    MCD::OPC_Decode, 207, 16, 61, // Opcode: MODSUB, DecodeIdx: 61
/* 9976 */    MCD::OPC_FilterValue, 20, 11, 0, // Skip to: 9991
/* 9980 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 9982 */    MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 9986 */    MCD::OPC_Decode, 238, 18, 196, 2, // Opcode: RADDU_W_QB, DecodeIdx: 324
/* 9991 */    MCD::OPC_FilterValue, 22, 6, 0, // Skip to: 10001
/* 9995 */    MCD::OPC_CheckPredicateOrFail, 37, 
/* 9997 */    MCD::OPC_Decode, 159, 6, 61, // Opcode: ADDQ_S_W, DecodeIdx: 61
/* 10001 */   MCD::OPC_FilterValue, 23, 6, 0, // Skip to: 10011
/* 10005 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10007 */   MCD::OPC_Decode, 150, 21, 61, // Opcode: SUBQ_S_W, DecodeIdx: 61
/* 10011 */   MCD::OPC_FilterValue, 28, 7, 0, // Skip to: 10022
/* 10015 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10017 */   MCD::OPC_Decode, 205, 17, 197, 2, // Opcode: MULEQ_S_W_PHL, DecodeIdx: 325
/* 10022 */   MCD::OPC_FilterValue, 29, 7, 0, // Skip to: 10033
/* 10026 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10028 */   MCD::OPC_Decode, 207, 17, 197, 2, // Opcode: MULEQ_S_W_PHR, DecodeIdx: 325
/* 10033 */   MCD::OPC_FilterValue, 30, 7, 0, // Skip to: 10044
/* 10037 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10039 */   MCD::OPC_Decode, 217, 17, 195, 2, // Opcode: MULQ_S_PH, DecodeIdx: 323
/* 10044 */   MCD::OPC_FilterValueOrFail, 31, 
/* 10046 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10048 */   MCD::OPC_Decode, 213, 17, 195, 2, // Opcode: MULQ_RS_PH, DecodeIdx: 323
/* 10053 */   MCD::OPC_FilterValue, 17, 5, 1, // Skip to: 10318
/* 10057 */   MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 10060 */   MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 10074
/* 10064 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10066 */   MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 10070 */   MCD::OPC_Decode, 172, 9, 79, // Opcode: CMPU_EQ_QB, DecodeIdx: 79
/* 10074 */   MCD::OPC_FilterValue, 1, 10, 0, // Skip to: 10088
/* 10078 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10080 */   MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 10084 */   MCD::OPC_Decode, 176, 9, 79, // Opcode: CMPU_LT_QB, DecodeIdx: 79
/* 10088 */   MCD::OPC_FilterValue, 2, 10, 0, // Skip to: 10102
/* 10092 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10094 */   MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 10098 */   MCD::OPC_Decode, 174, 9, 79, // Opcode: CMPU_LE_QB, DecodeIdx: 79
/* 10102 */   MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 10113
/* 10106 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10108 */   MCD::OPC_Decode, 188, 18, 195, 2, // Opcode: PICK_QB, DecodeIdx: 323
/* 10113 */   MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 10124
/* 10117 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10119 */   MCD::OPC_Decode, 166, 9, 197, 2, // Opcode: CMPGU_EQ_QB, DecodeIdx: 325
/* 10124 */   MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 10135
/* 10128 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10130 */   MCD::OPC_Decode, 170, 9, 197, 2, // Opcode: CMPGU_LT_QB, DecodeIdx: 325
/* 10135 */   MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 10146
/* 10139 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10141 */   MCD::OPC_Decode, 168, 9, 197, 2, // Opcode: CMPGU_LE_QB, DecodeIdx: 325
/* 10146 */   MCD::OPC_FilterValue, 8, 10, 0, // Skip to: 10160
/* 10150 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10152 */   MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 10156 */   MCD::OPC_Decode, 182, 9, 79, // Opcode: CMP_EQ_PH, DecodeIdx: 79
/* 10160 */   MCD::OPC_FilterValue, 9, 10, 0, // Skip to: 10174
/* 10164 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10166 */   MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 10170 */   MCD::OPC_Decode, 196, 9, 79, // Opcode: CMP_LT_PH, DecodeIdx: 79
/* 10174 */   MCD::OPC_FilterValue, 10, 10, 0, // Skip to: 10188
/* 10178 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10180 */   MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 10184 */   MCD::OPC_Decode, 190, 9, 79, // Opcode: CMP_LE_PH, DecodeIdx: 79
/* 10188 */   MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 10199
/* 10192 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10194 */   MCD::OPC_Decode, 186, 18, 195, 2, // Opcode: PICK_PH, DecodeIdx: 323
/* 10199 */   MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 10210
/* 10203 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10205 */   MCD::OPC_Decode, 217, 18, 195, 2, // Opcode: PRECRQ_QB_PH, DecodeIdx: 323
/* 10210 */   MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 10221
/* 10214 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10216 */   MCD::OPC_Decode, 221, 18, 195, 2, // Opcode: PRECR_QB_PH, DecodeIdx: 323
/* 10221 */   MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 10232
/* 10225 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10227 */   MCD::OPC_Decode, 169, 18, 195, 2, // Opcode: PACKRL_PH, DecodeIdx: 323
/* 10232 */   MCD::OPC_FilterValue, 15, 7, 0, // Skip to: 10243
/* 10236 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10238 */   MCD::OPC_Decode, 213, 18, 195, 2, // Opcode: PRECRQU_S_QB_PH, DecodeIdx: 323
/* 10243 */   MCD::OPC_FilterValue, 20, 7, 0, // Skip to: 10254
/* 10247 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10249 */   MCD::OPC_Decode, 215, 18, 198, 2, // Opcode: PRECRQ_PH_W, DecodeIdx: 326
/* 10254 */   MCD::OPC_FilterValue, 21, 7, 0, // Skip to: 10265
/* 10258 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10260 */   MCD::OPC_Decode, 219, 18, 198, 2, // Opcode: PRECRQ_RS_PH_W, DecodeIdx: 326
/* 10265 */   MCD::OPC_FilterValue, 24, 7, 0, // Skip to: 10276
/* 10269 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10271 */   MCD::OPC_Decode, 160, 9, 197, 2, // Opcode: CMPGDU_EQ_QB, DecodeIdx: 325
/* 10276 */   MCD::OPC_FilterValue, 25, 7, 0, // Skip to: 10287
/* 10280 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10282 */   MCD::OPC_Decode, 164, 9, 197, 2, // Opcode: CMPGDU_LT_QB, DecodeIdx: 325
/* 10287 */   MCD::OPC_FilterValue, 26, 7, 0, // Skip to: 10298
/* 10291 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10293 */   MCD::OPC_Decode, 162, 9, 197, 2, // Opcode: CMPGDU_LE_QB, DecodeIdx: 325
/* 10298 */   MCD::OPC_FilterValue, 30, 7, 0, // Skip to: 10309
/* 10302 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10304 */   MCD::OPC_Decode, 223, 18, 199, 2, // Opcode: PRECR_SRA_PH_W, DecodeIdx: 327
/* 10309 */   MCD::OPC_FilterValueOrFail, 31, 
/* 10311 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10313 */   MCD::OPC_Decode, 225, 18, 199, 2, // Opcode: PRECR_SRA_R_PH_W, DecodeIdx: 327
/* 10318 */   MCD::OPC_FilterValue, 18, 6, 1, // Skip to: 10584
/* 10322 */   MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 10325 */   MCD::OPC_FilterValue, 1, 11, 0, // Skip to: 10340
/* 10329 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10331 */   MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 10335 */   MCD::OPC_Decode, 134, 6, 200, 2, // Opcode: ABSQ_S_QB, DecodeIdx: 328
/* 10340 */   MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 10351
/* 10344 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10346 */   MCD::OPC_Decode, 131, 19, 201, 2, // Opcode: REPL_QB, DecodeIdx: 329
/* 10351 */   MCD::OPC_FilterValue, 3, 11, 0, // Skip to: 10366
/* 10355 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10357 */   MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 10361 */   MCD::OPC_Decode, 255, 18, 202, 2, // Opcode: REPLV_QB, DecodeIdx: 330
/* 10366 */   MCD::OPC_FilterValue, 4, 11, 0, // Skip to: 10381
/* 10370 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10372 */   MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 10376 */   MCD::OPC_Decode, 193, 18, 200, 2, // Opcode: PRECEQU_PH_QBL, DecodeIdx: 328
/* 10381 */   MCD::OPC_FilterValue, 5, 11, 0, // Skip to: 10396
/* 10385 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10387 */   MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 10391 */   MCD::OPC_Decode, 197, 18, 200, 2, // Opcode: PRECEQU_PH_QBR, DecodeIdx: 328
/* 10396 */   MCD::OPC_FilterValue, 6, 11, 0, // Skip to: 10411
/* 10400 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10402 */   MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 10406 */   MCD::OPC_Decode, 194, 18, 200, 2, // Opcode: PRECEQU_PH_QBLA, DecodeIdx: 328
/* 10411 */   MCD::OPC_FilterValue, 7, 11, 0, // Skip to: 10426
/* 10415 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10417 */   MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 10421 */   MCD::OPC_Decode, 198, 18, 200, 2, // Opcode: PRECEQU_PH_QBRA, DecodeIdx: 328
/* 10426 */   MCD::OPC_FilterValue, 9, 11, 0, // Skip to: 10441
/* 10430 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10432 */   MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 10436 */   MCD::OPC_Decode, 132, 6, 200, 2, // Opcode: ABSQ_S_PH, DecodeIdx: 328
/* 10441 */   MCD::OPC_FilterValue, 10, 6, 0, // Skip to: 10451
/* 10445 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10447 */   MCD::OPC_Decode, 129, 19, 96, // Opcode: REPL_PH, DecodeIdx: 96
/* 10451 */   MCD::OPC_FilterValue, 11, 11, 0, // Skip to: 10466
/* 10455 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10457 */   MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 10461 */   MCD::OPC_Decode, 253, 18, 202, 2, // Opcode: REPLV_PH, DecodeIdx: 330
/* 10466 */   MCD::OPC_FilterValue, 12, 11, 0, // Skip to: 10481
/* 10470 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10472 */   MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 10476 */   MCD::OPC_Decode, 201, 18, 203, 2, // Opcode: PRECEQ_W_PHL, DecodeIdx: 331
/* 10481 */   MCD::OPC_FilterValue, 13, 11, 0, // Skip to: 10496
/* 10485 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10487 */   MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 10491 */   MCD::OPC_Decode, 203, 18, 203, 2, // Opcode: PRECEQ_W_PHR, DecodeIdx: 331
/* 10496 */   MCD::OPC_FilterValue, 17, 11, 0, // Skip to: 10511
/* 10500 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10502 */   MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 10506 */   MCD::OPC_Decode, 136, 6, 204, 2, // Opcode: ABSQ_S_W, DecodeIdx: 332
/* 10511 */   MCD::OPC_FilterValue, 27, 11, 0, // Skip to: 10526
/* 10515 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10517 */   MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 10521 */   MCD::OPC_Decode, 237, 7, 204, 2, // Opcode: BITREV, DecodeIdx: 332
/* 10526 */   MCD::OPC_FilterValue, 28, 11, 0, // Skip to: 10541
/* 10530 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10532 */   MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 10536 */   MCD::OPC_Decode, 205, 18, 200, 2, // Opcode: PRECEU_PH_QBL, DecodeIdx: 328
/* 10541 */   MCD::OPC_FilterValue, 29, 11, 0, // Skip to: 10556
/* 10545 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10547 */   MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 10551 */   MCD::OPC_Decode, 209, 18, 200, 2, // Opcode: PRECEU_PH_QBR, DecodeIdx: 328
/* 10556 */   MCD::OPC_FilterValue, 30, 11, 0, // Skip to: 10571
/* 10560 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10562 */   MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 10566 */   MCD::OPC_Decode, 206, 18, 200, 2, // Opcode: PRECEU_PH_QBLA, DecodeIdx: 328
/* 10571 */   MCD::OPC_FilterValueOrFail, 31, 
/* 10573 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10575 */   MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 10579 */   MCD::OPC_Decode, 210, 18, 200, 2, // Opcode: PRECEU_PH_QBRA, DecodeIdx: 328
/* 10584 */   MCD::OPC_FilterValue, 19, 241, 0, // Skip to: 10829
/* 10588 */   MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 10591 */   MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 10602
/* 10595 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10597 */   MCD::OPC_Decode, 131, 20, 205, 2, // Opcode: SHLL_QB, DecodeIdx: 333
/* 10602 */   MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 10613
/* 10606 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10608 */   MCD::OPC_Decode, 163, 20, 205, 2, // Opcode: SHRL_QB, DecodeIdx: 333
/* 10613 */   MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 10624
/* 10617 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10619 */   MCD::OPC_Decode, 251, 19, 206, 2, // Opcode: SHLLV_QB, DecodeIdx: 334
/* 10624 */   MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 10635
/* 10628 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10630 */   MCD::OPC_Decode, 159, 20, 206, 2, // Opcode: SHRLV_QB, DecodeIdx: 334
/* 10635 */   MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 10646
/* 10639 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10641 */   MCD::OPC_Decode, 149, 20, 205, 2, // Opcode: SHRA_QB, DecodeIdx: 333
/* 10646 */   MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 10657
/* 10650 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10652 */   MCD::OPC_Decode, 153, 20, 205, 2, // Opcode: SHRA_R_QB, DecodeIdx: 333
/* 10657 */   MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 10668
/* 10661 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10663 */   MCD::OPC_Decode, 139, 20, 206, 2, // Opcode: SHRAV_QB, DecodeIdx: 334
/* 10668 */   MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 10679
/* 10672 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10674 */   MCD::OPC_Decode, 143, 20, 206, 2, // Opcode: SHRAV_R_QB, DecodeIdx: 334
/* 10679 */   MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 10690
/* 10683 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10685 */   MCD::OPC_Decode, 129, 20, 205, 2, // Opcode: SHLL_PH, DecodeIdx: 333
/* 10690 */   MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 10701
/* 10694 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10696 */   MCD::OPC_Decode, 147, 20, 205, 2, // Opcode: SHRA_PH, DecodeIdx: 333
/* 10701 */   MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 10712
/* 10705 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10707 */   MCD::OPC_Decode, 249, 19, 206, 2, // Opcode: SHLLV_PH, DecodeIdx: 334
/* 10712 */   MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 10723
/* 10716 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10718 */   MCD::OPC_Decode, 137, 20, 206, 2, // Opcode: SHRAV_PH, DecodeIdx: 334
/* 10723 */   MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 10734
/* 10727 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10729 */   MCD::OPC_Decode, 133, 20, 205, 2, // Opcode: SHLL_S_PH, DecodeIdx: 333
/* 10734 */   MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 10745
/* 10738 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10740 */   MCD::OPC_Decode, 151, 20, 205, 2, // Opcode: SHRA_R_PH, DecodeIdx: 333
/* 10745 */   MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 10756
/* 10749 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10751 */   MCD::OPC_Decode, 253, 19, 206, 2, // Opcode: SHLLV_S_PH, DecodeIdx: 334
/* 10756 */   MCD::OPC_FilterValue, 15, 7, 0, // Skip to: 10767
/* 10760 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10762 */   MCD::OPC_Decode, 141, 20, 206, 2, // Opcode: SHRAV_R_PH, DecodeIdx: 334
/* 10767 */   MCD::OPC_FilterValue, 20, 7, 0, // Skip to: 10778
/* 10771 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10773 */   MCD::OPC_Decode, 135, 20, 207, 2, // Opcode: SHLL_S_W, DecodeIdx: 335
/* 10778 */   MCD::OPC_FilterValue, 21, 7, 0, // Skip to: 10789
/* 10782 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10784 */   MCD::OPC_Decode, 155, 20, 207, 2, // Opcode: SHRA_R_W, DecodeIdx: 335
/* 10789 */   MCD::OPC_FilterValue, 22, 6, 0, // Skip to: 10799
/* 10793 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10795 */   MCD::OPC_Decode, 255, 19, 55, // Opcode: SHLLV_S_W, DecodeIdx: 55
/* 10799 */   MCD::OPC_FilterValue, 23, 6, 0, // Skip to: 10809
/* 10803 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 10805 */   MCD::OPC_Decode, 145, 20, 55, // Opcode: SHRAV_R_W, DecodeIdx: 55
/* 10809 */   MCD::OPC_FilterValue, 25, 7, 0, // Skip to: 10820
/* 10813 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10815 */   MCD::OPC_Decode, 161, 20, 205, 2, // Opcode: SHRL_PH, DecodeIdx: 333
/* 10820 */   MCD::OPC_FilterValueOrFail, 27, 
/* 10822 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10824 */   MCD::OPC_Decode, 157, 20, 206, 2, // Opcode: SHRLV_PH, DecodeIdx: 334
/* 10829 */   MCD::OPC_FilterValue, 24, 171, 0, // Skip to: 11004
/* 10833 */   MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 10836 */   MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 10847
/* 10840 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10842 */   MCD::OPC_Decode, 178, 6, 195, 2, // Opcode: ADDUH_QB, DecodeIdx: 323
/* 10847 */   MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 10858
/* 10851 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10853 */   MCD::OPC_Decode, 170, 21, 195, 2, // Opcode: SUBUH_QB, DecodeIdx: 323
/* 10858 */   MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 10869
/* 10862 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10864 */   MCD::OPC_Decode, 180, 6, 195, 2, // Opcode: ADDUH_R_QB, DecodeIdx: 323
/* 10869 */   MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 10880
/* 10873 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10875 */   MCD::OPC_Decode, 172, 21, 195, 2, // Opcode: SUBUH_R_QB, DecodeIdx: 323
/* 10880 */   MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 10891
/* 10884 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10886 */   MCD::OPC_Decode, 147, 6, 195, 2, // Opcode: ADDQH_PH, DecodeIdx: 323
/* 10891 */   MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 10902
/* 10895 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10897 */   MCD::OPC_Decode, 138, 21, 195, 2, // Opcode: SUBQH_PH, DecodeIdx: 323
/* 10902 */   MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 10913
/* 10906 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10908 */   MCD::OPC_Decode, 149, 6, 195, 2, // Opcode: ADDQH_R_PH, DecodeIdx: 323
/* 10913 */   MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 10924
/* 10917 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10919 */   MCD::OPC_Decode, 140, 21, 195, 2, // Opcode: SUBQH_R_PH, DecodeIdx: 323
/* 10924 */   MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 10935
/* 10928 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10930 */   MCD::OPC_Decode, 244, 17, 195, 2, // Opcode: MUL_PH, DecodeIdx: 323
/* 10935 */   MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 10946
/* 10939 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10941 */   MCD::OPC_Decode, 249, 17, 195, 2, // Opcode: MUL_S_PH, DecodeIdx: 323
/* 10946 */   MCD::OPC_FilterValue, 16, 6, 0, // Skip to: 10956
/* 10950 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10952 */   MCD::OPC_Decode, 153, 6, 61, // Opcode: ADDQH_W, DecodeIdx: 61
/* 10956 */   MCD::OPC_FilterValue, 17, 6, 0, // Skip to: 10966
/* 10960 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10962 */   MCD::OPC_Decode, 144, 21, 61, // Opcode: SUBQH_W, DecodeIdx: 61
/* 10966 */   MCD::OPC_FilterValue, 18, 6, 0, // Skip to: 10976
/* 10970 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10972 */   MCD::OPC_Decode, 151, 6, 61, // Opcode: ADDQH_R_W, DecodeIdx: 61
/* 10976 */   MCD::OPC_FilterValue, 19, 6, 0, // Skip to: 10986
/* 10980 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10982 */   MCD::OPC_Decode, 142, 21, 61, // Opcode: SUBQH_R_W, DecodeIdx: 61
/* 10986 */   MCD::OPC_FilterValue, 22, 6, 0, // Skip to: 10996
/* 10990 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 10992 */   MCD::OPC_Decode, 219, 17, 61, // Opcode: MULQ_S_W, DecodeIdx: 61
/* 10996 */   MCD::OPC_FilterValueOrFail, 23, 
/* 10998 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 11000 */   MCD::OPC_Decode, 215, 17, 61, // Opcode: MULQ_RS_W, DecodeIdx: 61
/* 11004 */   MCD::OPC_FilterValue, 25, 11, 0, // Skip to: 11019
/* 11008 */   MCD::OPC_CheckPredicateOrFail, 70, 
/* 11010 */   MCD::OPC_CheckFieldOrFail, 6, 1, 0, 
/* 11014 */   MCD::OPC_Decode, 178, 15, 208, 2, // Opcode: LWLE, DecodeIdx: 336
/* 11019 */   MCD::OPC_FilterValue, 26, 11, 0, // Skip to: 11034
/* 11023 */   MCD::OPC_CheckPredicateOrFail, 70, 
/* 11025 */   MCD::OPC_CheckFieldOrFail, 6, 1, 0, 
/* 11029 */   MCD::OPC_Decode, 189, 15, 208, 2, // Opcode: LWRE, DecodeIdx: 336
/* 11034 */   MCD::OPC_FilterValue, 27, 11, 0, // Skip to: 11049
/* 11038 */   MCD::OPC_CheckPredicateOrFail, 44, 
/* 11040 */   MCD::OPC_CheckFieldOrFail, 6, 1, 0, 
/* 11044 */   MCD::OPC_Decode, 212, 8, 209, 2, // Opcode: CACHEE, DecodeIdx: 337
/* 11049 */   MCD::OPC_FilterValue, 28, 11, 0, // Skip to: 11064
/* 11053 */   MCD::OPC_CheckPredicateOrFail, 44, 
/* 11055 */   MCD::OPC_CheckFieldOrFail, 6, 1, 0, 
/* 11059 */   MCD::OPC_Decode, 174, 19, 208, 2, // Opcode: SBE, DecodeIdx: 336
/* 11064 */   MCD::OPC_FilterValue, 29, 11, 0, // Skip to: 11079
/* 11068 */   MCD::OPC_CheckPredicateOrFail, 44, 
/* 11070 */   MCD::OPC_CheckFieldOrFail, 6, 1, 0, 
/* 11074 */   MCD::OPC_Decode, 240, 19, 208, 2, // Opcode: SHE, DecodeIdx: 336
/* 11079 */   MCD::OPC_FilterValue, 30, 11, 0, // Skip to: 11094
/* 11083 */   MCD::OPC_CheckPredicateOrFail, 44, 
/* 11085 */   MCD::OPC_CheckFieldOrFail, 6, 1, 0, 
/* 11089 */   MCD::OPC_Decode, 183, 19, 208, 2, // Opcode: SCE, DecodeIdx: 336
/* 11094 */   MCD::OPC_FilterValue, 31, 11, 0, // Skip to: 11109
/* 11098 */   MCD::OPC_CheckPredicateOrFail, 44, 
/* 11100 */   MCD::OPC_CheckFieldOrFail, 6, 1, 0, 
/* 11104 */   MCD::OPC_Decode, 210, 21, 208, 2, // Opcode: SWE, DecodeIdx: 336
/* 11109 */   MCD::OPC_FilterValue, 32, 46, 0, // Skip to: 11159
/* 11113 */   MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 11116 */   MCD::OPC_FilterValue, 2, 11, 0, // Skip to: 11131
/* 11120 */   MCD::OPC_CheckPredicateOrFail, 28, 
/* 11122 */   MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 11126 */   MCD::OPC_Decode, 207, 22, 204, 2, // Opcode: WSBH, DecodeIdx: 332
/* 11131 */   MCD::OPC_FilterValue, 16, 11, 0, // Skip to: 11146
/* 11135 */   MCD::OPC_CheckPredicateOrFail, 28, 
/* 11137 */   MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 11141 */   MCD::OPC_Decode, 210, 19, 204, 2, // Opcode: SEB, DecodeIdx: 332
/* 11146 */   MCD::OPC_FilterValueOrFail, 24, 
/* 11148 */   MCD::OPC_CheckPredicateOrFail, 28, 
/* 11150 */   MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 11154 */   MCD::OPC_Decode, 213, 19, 204, 2, // Opcode: SEH, DecodeIdx: 332
/* 11159 */   MCD::OPC_FilterValue, 33, 11, 0, // Skip to: 11174
/* 11163 */   MCD::OPC_CheckPredicateOrFail, 70, 
/* 11165 */   MCD::OPC_CheckFieldOrFail, 6, 1, 0, 
/* 11169 */   MCD::OPC_Decode, 214, 21, 208, 2, // Opcode: SWLE, DecodeIdx: 336
/* 11174 */   MCD::OPC_FilterValue, 34, 11, 0, // Skip to: 11189
/* 11178 */   MCD::OPC_CheckPredicateOrFail, 70, 
/* 11180 */   MCD::OPC_CheckFieldOrFail, 6, 1, 0, 
/* 11184 */   MCD::OPC_Decode, 223, 21, 208, 2, // Opcode: SWRE, DecodeIdx: 336
/* 11189 */   MCD::OPC_FilterValue, 35, 11, 0, // Skip to: 11204
/* 11193 */   MCD::OPC_CheckPredicateOrFail, 44, 
/* 11195 */   MCD::OPC_CheckFieldOrFail, 6, 1, 0, 
/* 11199 */   MCD::OPC_Decode, 228, 18, 209, 2, // Opcode: PREFE, DecodeIdx: 337
/* 11204 */   MCD::OPC_FilterValue, 40, 11, 0, // Skip to: 11219
/* 11208 */   MCD::OPC_CheckPredicateOrFail, 44, 
/* 11210 */   MCD::OPC_CheckFieldOrFail, 6, 1, 0, 
/* 11214 */   MCD::OPC_Decode, 226, 14, 208, 2, // Opcode: LBuE, DecodeIdx: 336
/* 11219 */   MCD::OPC_FilterValue, 41, 11, 0, // Skip to: 11234
/* 11223 */   MCD::OPC_CheckPredicateOrFail, 44, 
/* 11225 */   MCD::OPC_CheckFieldOrFail, 6, 1, 0, 
/* 11229 */   MCD::OPC_Decode, 137, 15, 208, 2, // Opcode: LHuE, DecodeIdx: 336
/* 11234 */   MCD::OPC_FilterValue, 44, 11, 0, // Skip to: 11249
/* 11238 */   MCD::OPC_CheckPredicateOrFail, 44, 
/* 11240 */   MCD::OPC_CheckFieldOrFail, 6, 1, 0, 
/* 11244 */   MCD::OPC_Decode, 216, 14, 208, 2, // Opcode: LBE, DecodeIdx: 336
/* 11249 */   MCD::OPC_FilterValue, 45, 11, 0, // Skip to: 11264
/* 11253 */   MCD::OPC_CheckPredicateOrFail, 44, 
/* 11255 */   MCD::OPC_CheckFieldOrFail, 6, 1, 0, 
/* 11259 */   MCD::OPC_Decode, 129, 15, 208, 2, // Opcode: LHE, DecodeIdx: 336
/* 11264 */   MCD::OPC_FilterValue, 46, 11, 0, // Skip to: 11279
/* 11268 */   MCD::OPC_CheckPredicateOrFail, 44, 
/* 11270 */   MCD::OPC_CheckFieldOrFail, 6, 1, 0, 
/* 11274 */   MCD::OPC_Decode, 147, 15, 208, 2, // Opcode: LLE, DecodeIdx: 336
/* 11279 */   MCD::OPC_FilterValue, 47, 11, 0, // Skip to: 11294
/* 11283 */   MCD::OPC_CheckPredicateOrFail, 44, 
/* 11285 */   MCD::OPC_CheckFieldOrFail, 6, 1, 0, 
/* 11289 */   MCD::OPC_Decode, 173, 15, 208, 2, // Opcode: LWE, DecodeIdx: 336
/* 11294 */   MCD::OPC_FilterValue, 48, 75, 1, // Skip to: 11629
/* 11298 */   MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 11301 */   MCD::OPC_FilterValue, 0, 11, 0, // Skip to: 11316
/* 11305 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 11307 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11311 */   MCD::OPC_Decode, 235, 11, 243, 1, // Opcode: DPA_W_PH, DecodeIdx: 243
/* 11316 */   MCD::OPC_FilterValue, 1, 11, 0, // Skip to: 11331
/* 11320 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 11322 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11326 */   MCD::OPC_Decode, 130, 12, 243, 1, // Opcode: DPS_W_PH, DecodeIdx: 243
/* 11331 */   MCD::OPC_FilterValue, 2, 11, 0, // Skip to: 11346
/* 11335 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 11337 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11341 */   MCD::OPC_Decode, 226, 17, 243, 1, // Opcode: MULSA_W_PH, DecodeIdx: 243
/* 11346 */   MCD::OPC_FilterValue, 3, 11, 0, // Skip to: 11361
/* 11350 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11352 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11356 */   MCD::OPC_Decode, 229, 11, 243, 1, // Opcode: DPAU_H_QBL, DecodeIdx: 243
/* 11361 */   MCD::OPC_FilterValue, 4, 11, 0, // Skip to: 11376
/* 11365 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11367 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11371 */   MCD::OPC_Decode, 227, 11, 243, 1, // Opcode: DPAQ_S_W_PH, DecodeIdx: 243
/* 11376 */   MCD::OPC_FilterValue, 5, 11, 0, // Skip to: 11391
/* 11380 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11382 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11386 */   MCD::OPC_Decode, 244, 11, 243, 1, // Opcode: DPSQ_S_W_PH, DecodeIdx: 243
/* 11391 */   MCD::OPC_FilterValue, 6, 11, 0, // Skip to: 11406
/* 11395 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11397 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11401 */   MCD::OPC_Decode, 224, 17, 243, 1, // Opcode: MULSAQ_S_W_PH, DecodeIdx: 243
/* 11406 */   MCD::OPC_FilterValue, 7, 11, 0, // Skip to: 11421
/* 11410 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11412 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11416 */   MCD::OPC_Decode, 231, 11, 243, 1, // Opcode: DPAU_H_QBR, DecodeIdx: 243
/* 11421 */   MCD::OPC_FilterValue, 8, 11, 0, // Skip to: 11436
/* 11425 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 11427 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11431 */   MCD::OPC_Decode, 233, 11, 243, 1, // Opcode: DPAX_W_PH, DecodeIdx: 243
/* 11436 */   MCD::OPC_FilterValue, 9, 11, 0, // Skip to: 11451
/* 11440 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 11442 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11446 */   MCD::OPC_Decode, 128, 12, 243, 1, // Opcode: DPSX_W_PH, DecodeIdx: 243
/* 11451 */   MCD::OPC_FilterValue, 11, 11, 0, // Skip to: 11466
/* 11455 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11457 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11461 */   MCD::OPC_Decode, 252, 11, 243, 1, // Opcode: DPSU_H_QBL, DecodeIdx: 243
/* 11466 */   MCD::OPC_FilterValue, 12, 11, 0, // Skip to: 11481
/* 11470 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11472 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11476 */   MCD::OPC_Decode, 225, 11, 243, 1, // Opcode: DPAQ_SA_L_W, DecodeIdx: 243
/* 11481 */   MCD::OPC_FilterValue, 13, 11, 0, // Skip to: 11496
/* 11485 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11487 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11491 */   MCD::OPC_Decode, 242, 11, 243, 1, // Opcode: DPSQ_SA_L_W, DecodeIdx: 243
/* 11496 */   MCD::OPC_FilterValue, 15, 11, 0, // Skip to: 11511
/* 11500 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11502 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11506 */   MCD::OPC_Decode, 254, 11, 243, 1, // Opcode: DPSU_H_QBR, DecodeIdx: 243
/* 11511 */   MCD::OPC_FilterValue, 16, 11, 0, // Skip to: 11526
/* 11515 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11517 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11521 */   MCD::OPC_Decode, 239, 15, 243, 1, // Opcode: MAQ_SA_W_PHL, DecodeIdx: 243
/* 11526 */   MCD::OPC_FilterValue, 18, 11, 0, // Skip to: 11541
/* 11530 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11532 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11536 */   MCD::OPC_Decode, 241, 15, 243, 1, // Opcode: MAQ_SA_W_PHR, DecodeIdx: 243
/* 11541 */   MCD::OPC_FilterValue, 20, 11, 0, // Skip to: 11556
/* 11545 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11547 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11551 */   MCD::OPC_Decode, 243, 15, 243, 1, // Opcode: MAQ_S_W_PHL, DecodeIdx: 243
/* 11556 */   MCD::OPC_FilterValue, 22, 11, 0, // Skip to: 11571
/* 11560 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11562 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11566 */   MCD::OPC_Decode, 245, 15, 243, 1, // Opcode: MAQ_S_W_PHR, DecodeIdx: 243
/* 11571 */   MCD::OPC_FilterValue, 24, 11, 0, // Skip to: 11586
/* 11575 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 11577 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11581 */   MCD::OPC_Decode, 223, 11, 243, 1, // Opcode: DPAQX_S_W_PH, DecodeIdx: 243
/* 11586 */   MCD::OPC_FilterValue, 25, 11, 0, // Skip to: 11601
/* 11590 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 11592 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11596 */   MCD::OPC_Decode, 240, 11, 243, 1, // Opcode: DPSQX_S_W_PH, DecodeIdx: 243
/* 11601 */   MCD::OPC_FilterValue, 26, 11, 0, // Skip to: 11616
/* 11605 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 11607 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11611 */   MCD::OPC_Decode, 221, 11, 243, 1, // Opcode: DPAQX_SA_W_PH, DecodeIdx: 243
/* 11616 */   MCD::OPC_FilterValueOrFail, 27, 
/* 11618 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 11620 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11624 */   MCD::OPC_Decode, 238, 11, 243, 1, // Opcode: DPSQX_SA_W_PH, DecodeIdx: 243
/* 11629 */   MCD::OPC_FilterValue, 49, 34, 0, // Skip to: 11667
/* 11633 */   MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 11636 */   MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 11647
/* 11640 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 11642 */   MCD::OPC_Decode, 231, 6, 210, 2, // Opcode: APPEND, DecodeIdx: 338
/* 11647 */   MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 11658
/* 11651 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 11653 */   MCD::OPC_Decode, 234, 18, 210, 2, // Opcode: PREPEND, DecodeIdx: 338
/* 11658 */   MCD::OPC_FilterValueOrFail, 16, 
/* 11660 */   MCD::OPC_CheckPredicateOrFail, 69, 
/* 11662 */   MCD::OPC_Decode, 147, 7, 210, 2, // Opcode: BALIGN, DecodeIdx: 338
/* 11667 */   MCD::OPC_FilterValue, 56, 248, 0, // Skip to: 11919
/* 11671 */   MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 11674 */   MCD::OPC_FilterValue, 0, 11, 0, // Skip to: 11689
/* 11678 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11680 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11684 */   MCD::OPC_Decode, 194, 12, 211, 2, // Opcode: EXTR_W, DecodeIdx: 339
/* 11689 */   MCD::OPC_FilterValue, 1, 11, 0, // Skip to: 11704
/* 11693 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11695 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11699 */   MCD::OPC_Decode, 186, 12, 212, 2, // Opcode: EXTRV_W, DecodeIdx: 340
/* 11704 */   MCD::OPC_FilterValue, 2, 11, 0, // Skip to: 11719
/* 11708 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11710 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11714 */   MCD::OPC_Decode, 172, 12, 211, 2, // Opcode: EXTP, DecodeIdx: 339
/* 11719 */   MCD::OPC_FilterValue, 3, 11, 0, // Skip to: 11734
/* 11723 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11725 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11729 */   MCD::OPC_Decode, 177, 12, 212, 2, // Opcode: EXTPV, DecodeIdx: 340
/* 11734 */   MCD::OPC_FilterValue, 4, 11, 0, // Skip to: 11749
/* 11738 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11740 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11744 */   MCD::OPC_Decode, 190, 12, 211, 2, // Opcode: EXTR_R_W, DecodeIdx: 339
/* 11749 */   MCD::OPC_FilterValue, 5, 11, 0, // Skip to: 11764
/* 11753 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11755 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11759 */   MCD::OPC_Decode, 182, 12, 212, 2, // Opcode: EXTRV_R_W, DecodeIdx: 340
/* 11764 */   MCD::OPC_FilterValue, 6, 11, 0, // Skip to: 11779
/* 11768 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11770 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11774 */   MCD::OPC_Decode, 188, 12, 211, 2, // Opcode: EXTR_RS_W, DecodeIdx: 339
/* 11779 */   MCD::OPC_FilterValue, 7, 11, 0, // Skip to: 11794
/* 11783 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11785 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11789 */   MCD::OPC_Decode, 180, 12, 212, 2, // Opcode: EXTRV_RS_W, DecodeIdx: 340
/* 11794 */   MCD::OPC_FilterValue, 10, 11, 0, // Skip to: 11809
/* 11798 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11800 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11804 */   MCD::OPC_Decode, 173, 12, 211, 2, // Opcode: EXTPDP, DecodeIdx: 339
/* 11809 */   MCD::OPC_FilterValue, 11, 11, 0, // Skip to: 11824
/* 11813 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11815 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11819 */   MCD::OPC_Decode, 174, 12, 212, 2, // Opcode: EXTPDPV, DecodeIdx: 340
/* 11824 */   MCD::OPC_FilterValue, 14, 11, 0, // Skip to: 11839
/* 11828 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11830 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11834 */   MCD::OPC_Decode, 192, 12, 211, 2, // Opcode: EXTR_S_H, DecodeIdx: 339
/* 11839 */   MCD::OPC_FilterValue, 15, 11, 0, // Skip to: 11854
/* 11843 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11845 */   MCD::OPC_CheckFieldOrFail, 13, 3, 0, 
/* 11849 */   MCD::OPC_Decode, 184, 12, 212, 2, // Opcode: EXTRV_S_H, DecodeIdx: 340
/* 11854 */   MCD::OPC_FilterValue, 18, 7, 0, // Skip to: 11865
/* 11858 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11860 */   MCD::OPC_Decode, 240, 18, 213, 2, // Opcode: RDDSP, DecodeIdx: 341
/* 11865 */   MCD::OPC_FilterValue, 19, 7, 0, // Skip to: 11876
/* 11869 */   MCD::OPC_CheckPredicateOrFail, 40, 
/* 11871 */   MCD::OPC_Decode, 204, 22, 214, 2, // Opcode: WRDSP, DecodeIdx: 342
/* 11876 */   MCD::OPC_FilterValue, 26, 11, 0, // Skip to: 11891
/* 11880 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11882 */   MCD::OPC_CheckFieldOrFail, 13, 7, 0, 
/* 11886 */   MCD::OPC_Decode, 245, 19, 215, 2, // Opcode: SHILO, DecodeIdx: 343
/* 11891 */   MCD::OPC_FilterValue, 27, 11, 0, // Skip to: 11906
/* 11895 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11897 */   MCD::OPC_CheckFieldOrFail, 13, 8, 0, 
/* 11901 */   MCD::OPC_Decode, 246, 19, 216, 2, // Opcode: SHILOV, DecodeIdx: 344
/* 11906 */   MCD::OPC_FilterValueOrFail, 31, 
/* 11908 */   MCD::OPC_CheckPredicateOrFail, 37, 
/* 11910 */   MCD::OPC_CheckFieldOrFail, 13, 8, 0, 
/* 11914 */   MCD::OPC_Decode, 186, 17, 216, 2, // Opcode: MTHLIP, DecodeIdx: 344
/* 11919 */   MCD::OPC_FilterValueOrFail, 59, 
/* 11921 */   MCD::OPC_CheckPredicateOrFail, 27, 
/* 11923 */   MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 11927 */   MCD::OPC_CheckFieldOrFail, 9, 2, 0, 
/* 11931 */   MCD::OPC_Decode, 242, 18, 217, 2, // Opcode: RDHWR, DecodeIdx: 345
/* 11936 */   MCD::OPC_FilterValue, 32, 7, 0, // Skip to: 11947
/* 11940 */   MCD::OPC_CheckPredicateOrFail, 27, 
/* 11942 */   MCD::OPC_Decode, 214, 14, 141, 1, // Opcode: LB, DecodeIdx: 141
/* 11947 */   MCD::OPC_FilterValue, 33, 7, 0, // Skip to: 11958
/* 11951 */   MCD::OPC_CheckPredicateOrFail, 27, 
/* 11953 */   MCD::OPC_Decode, 255, 14, 141, 1, // Opcode: LH, DecodeIdx: 141
/* 11958 */   MCD::OPC_FilterValue, 34, 7, 0, // Skip to: 11969
/* 11962 */   MCD::OPC_CheckPredicateOrFail, 31, 
/* 11964 */   MCD::OPC_Decode, 176, 15, 141, 1, // Opcode: LWL, DecodeIdx: 141
/* 11969 */   MCD::OPC_FilterValue, 35, 7, 0, // Skip to: 11980
/* 11973 */   MCD::OPC_CheckPredicateOrFail, 27, 
/* 11975 */   MCD::OPC_Decode, 162, 15, 141, 1, // Opcode: LW, DecodeIdx: 141
/* 11980 */   MCD::OPC_FilterValue, 36, 7, 0, // Skip to: 11991
/* 11984 */   MCD::OPC_CheckPredicateOrFail, 27, 
/* 11986 */   MCD::OPC_Decode, 224, 14, 141, 1, // Opcode: LBu, DecodeIdx: 141
/* 11991 */   MCD::OPC_FilterValue, 37, 7, 0, // Skip to: 12002
/* 11995 */   MCD::OPC_CheckPredicateOrFail, 27, 
/* 11997 */   MCD::OPC_Decode, 135, 15, 141, 1, // Opcode: LHu, DecodeIdx: 141
/* 12002 */   MCD::OPC_FilterValue, 38, 7, 0, // Skip to: 12013
/* 12006 */   MCD::OPC_CheckPredicateOrFail, 31, 
/* 12008 */   MCD::OPC_Decode, 187, 15, 141, 1, // Opcode: LWR, DecodeIdx: 141
/* 12013 */   MCD::OPC_FilterValue, 40, 7, 0, // Skip to: 12024
/* 12017 */   MCD::OPC_CheckPredicateOrFail, 27, 
/* 12019 */   MCD::OPC_Decode, 170, 19, 141, 1, // Opcode: SB, DecodeIdx: 141
/* 12024 */   MCD::OPC_FilterValue, 41, 7, 0, // Skip to: 12035
/* 12028 */   MCD::OPC_CheckPredicateOrFail, 27, 
/* 12030 */   MCD::OPC_Decode, 236, 19, 141, 1, // Opcode: SH, DecodeIdx: 141
/* 12035 */   MCD::OPC_FilterValue, 42, 7, 0, // Skip to: 12046
/* 12039 */   MCD::OPC_CheckPredicateOrFail, 31, 
/* 12041 */   MCD::OPC_Decode, 212, 21, 141, 1, // Opcode: SWL, DecodeIdx: 141
/* 12046 */   MCD::OPC_FilterValue, 43, 7, 0, // Skip to: 12057
/* 12050 */   MCD::OPC_CheckPredicateOrFail, 27, 
/* 12052 */   MCD::OPC_Decode, 198, 21, 141, 1, // Opcode: SW, DecodeIdx: 141
/* 12057 */   MCD::OPC_FilterValue, 46, 7, 0, // Skip to: 12068
/* 12061 */   MCD::OPC_CheckPredicateOrFail, 31, 
/* 12063 */   MCD::OPC_Decode, 221, 21, 141, 1, // Opcode: SWR, DecodeIdx: 141
/* 12068 */   MCD::OPC_FilterValue, 47, 7, 0, // Skip to: 12079
/* 12072 */   MCD::OPC_CheckPredicateOrFail, 71, 
/* 12074 */   MCD::OPC_Decode, 211, 8, 218, 2, // Opcode: CACHE, DecodeIdx: 346
/* 12079 */   MCD::OPC_FilterValue, 48, 7, 0, // Skip to: 12090
/* 12083 */   MCD::OPC_CheckPredicateOrFail, 72, 
/* 12085 */   MCD::OPC_Decode, 142, 15, 141, 1, // Opcode: LL, DecodeIdx: 141
/* 12090 */   MCD::OPC_FilterValue, 49, 7, 0, // Skip to: 12101
/* 12094 */   MCD::OPC_CheckPredicateOrFail, 47, 
/* 12096 */   MCD::OPC_Decode, 165, 15, 219, 2, // Opcode: LWC1, DecodeIdx: 347
/* 12101 */   MCD::OPC_FilterValue, 50, 7, 0, // Skip to: 12112
/* 12105 */   MCD::OPC_CheckPredicateOrFail, 31, 
/* 12107 */   MCD::OPC_Decode, 167, 15, 220, 2, // Opcode: LWC2, DecodeIdx: 348
/* 12112 */   MCD::OPC_FilterValue, 51, 7, 0, // Skip to: 12123
/* 12116 */   MCD::OPC_CheckPredicateOrFail, 71, 
/* 12118 */   MCD::OPC_Decode, 227, 18, 218, 2, // Opcode: PREF, DecodeIdx: 346
/* 12123 */   MCD::OPC_FilterValue, 53, 7, 0, // Skip to: 12134
/* 12127 */   MCD::OPC_CheckPredicateOrFail, 57, 
/* 12129 */   MCD::OPC_Decode, 230, 14, 219, 2, // Opcode: LDC1, DecodeIdx: 347
/* 12134 */   MCD::OPC_FilterValue, 54, 7, 0, // Skip to: 12145
/* 12138 */   MCD::OPC_CheckPredicateOrFail, 39, 
/* 12140 */   MCD::OPC_Decode, 235, 14, 220, 2, // Opcode: LDC2, DecodeIdx: 348
/* 12145 */   MCD::OPC_FilterValue, 56, 7, 0, // Skip to: 12156
/* 12149 */   MCD::OPC_CheckPredicateOrFail, 72, 
/* 12151 */   MCD::OPC_Decode, 178, 19, 141, 1, // Opcode: SC, DecodeIdx: 141
/* 12156 */   MCD::OPC_FilterValue, 57, 7, 0, // Skip to: 12167
/* 12160 */   MCD::OPC_CheckPredicateOrFail, 47, 
/* 12162 */   MCD::OPC_Decode, 202, 21, 219, 2, // Opcode: SWC1, DecodeIdx: 347
/* 12167 */   MCD::OPC_FilterValue, 58, 7, 0, // Skip to: 12178
/* 12171 */   MCD::OPC_CheckPredicateOrFail, 31, 
/* 12173 */   MCD::OPC_Decode, 204, 21, 220, 2, // Opcode: SWC2, DecodeIdx: 348
/* 12178 */   MCD::OPC_FilterValue, 61, 7, 0, // Skip to: 12189
/* 12182 */   MCD::OPC_CheckPredicateOrFail, 57, 
/* 12184 */   MCD::OPC_Decode, 195, 19, 219, 2, // Opcode: SDC1, DecodeIdx: 347
/* 12189 */   MCD::OPC_FilterValueOrFail, 62, 
/* 12191 */   MCD::OPC_CheckPredicateOrFail, 39, 
/* 12193 */   MCD::OPC_Decode, 200, 19, 220, 2, // Opcode: SDC2, DecodeIdx: 348
/* 12198 */   MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableMips32_64_PTR6432[] = {
/* 0 */       MCD::OPC_ExtractField, 26, 6,  // Inst{31-26} ...
/* 3 */       MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 17
/* 7 */       MCD::OPC_CheckPredicateOrFail, 73, 
/* 9 */       MCD::OPC_CheckFieldOrFail, 0, 21, 8, 
/* 13 */      MCD::OPC_Decode, 197, 14, 24, // Opcode: JR64, DecodeIdx: 24
/* 17 */      MCD::OPC_FilterValue, 48, 7, 0, // Skip to: 28
/* 21 */      MCD::OPC_CheckPredicateOrFail, 74, 
/* 23 */      MCD::OPC_Decode, 143, 15, 141, 1, // Opcode: LL64, DecodeIdx: 141
/* 28 */      MCD::OPC_FilterValueOrFail, 56, 
/* 30 */      MCD::OPC_CheckPredicateOrFail, 74, 
/* 32 */      MCD::OPC_Decode, 179, 19, 141, 1, // Opcode: SC64, DecodeIdx: 141
/* 37 */      MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableMips32r6_64r632[] = {
/* 0 */       MCD::OPC_ExtractField, 26, 6,  // Inst{31-26} ...
/* 3 */       MCD::OPC_FilterValue, 0, 101, 1, // Skip to: 364
/* 7 */       MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 10 */      MCD::OPC_FilterValue, 5, 11, 0, // Skip to: 25
/* 14 */      MCD::OPC_CheckPredicateOrFail, 75, 
/* 16 */      MCD::OPC_CheckFieldOrFail, 8, 3, 0, 
/* 20 */      MCD::OPC_Decode, 154, 15, 185, 1, // Opcode: LSA_R6, DecodeIdx: 185
/* 25 */      MCD::OPC_FilterValue, 9, 11, 0, // Skip to: 40
/* 29 */      MCD::OPC_CheckPredicateOrFail, 75, 
/* 31 */      MCD::OPC_CheckFieldOrFail, 6, 15, 16, 
/* 35 */      MCD::OPC_Decode, 205, 14, 186, 1, // Opcode: JR_HB_R6, DecodeIdx: 186
/* 40 */      MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 51
/* 44 */      MCD::OPC_CheckPredicateOrFail, 76, 
/* 46 */      MCD::OPC_Decode, 194, 19, 188, 1, // Opcode: SDBBP_R6, DecodeIdx: 188
/* 51 */      MCD::OPC_FilterValue, 16, 14, 0, // Skip to: 69
/* 55 */      MCD::OPC_CheckPredicateOrFail, 75, 
/* 57 */      MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 61 */      MCD::OPC_CheckFieldOrFail, 6, 5, 1, 
/* 65 */      MCD::OPC_Decode, 159, 9, 25, // Opcode: CLZ_R6, DecodeIdx: 25
/* 69 */      MCD::OPC_FilterValue, 17, 14, 0, // Skip to: 87
/* 73 */      MCD::OPC_CheckPredicateOrFail, 75, 
/* 75 */      MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 79 */      MCD::OPC_CheckFieldOrFail, 6, 5, 1, 
/* 83 */      MCD::OPC_Decode, 139, 9, 25, // Opcode: CLO_R6, DecodeIdx: 25
/* 87 */      MCD::OPC_FilterValue, 18, 14, 0, // Skip to: 105
/* 91 */      MCD::OPC_CheckPredicateOrFail, 77, 
/* 93 */      MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 97 */      MCD::OPC_CheckFieldOrFail, 6, 5, 1, 
/* 101 */     MCD::OPC_Decode, 159, 11, 26, // Opcode: DCLZ_R6, DecodeIdx: 26
/* 105 */     MCD::OPC_FilterValue, 19, 14, 0, // Skip to: 123
/* 109 */     MCD::OPC_CheckPredicateOrFail, 77, 
/* 111 */     MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 115 */     MCD::OPC_CheckFieldOrFail, 6, 5, 1, 
/* 119 */     MCD::OPC_Decode, 157, 11, 26, // Opcode: DCLO_R6, DecodeIdx: 26
/* 123 */     MCD::OPC_FilterValue, 21, 11, 0, // Skip to: 138
/* 127 */     MCD::OPC_CheckPredicateOrFail, 77, 
/* 129 */     MCD::OPC_CheckFieldOrFail, 8, 3, 0, 
/* 133 */     MCD::OPC_Decode, 188, 11, 194, 1, // Opcode: DLSA_R6, DecodeIdx: 194
/* 138 */     MCD::OPC_FilterValue, 24, 21, 0, // Skip to: 163
/* 142 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 145 */     MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 155
/* 149 */     MCD::OPC_CheckPredicateOrFail, 76, 
/* 151 */     MCD::OPC_Decode, 248, 17, 61, // Opcode: MUL_R6, DecodeIdx: 61
/* 155 */     MCD::OPC_FilterValueOrFail, 3, 
/* 157 */     MCD::OPC_CheckPredicateOrFail, 76, 
/* 159 */     MCD::OPC_Decode, 200, 17, 61, // Opcode: MUH, DecodeIdx: 61
/* 163 */     MCD::OPC_FilterValue, 25, 21, 0, // Skip to: 188
/* 167 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 170 */     MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 180
/* 174 */     MCD::OPC_CheckPredicateOrFail, 76, 
/* 176 */     MCD::OPC_Decode, 236, 17, 61, // Opcode: MULU, DecodeIdx: 61
/* 180 */     MCD::OPC_FilterValueOrFail, 3, 
/* 182 */     MCD::OPC_CheckPredicateOrFail, 76, 
/* 184 */     MCD::OPC_Decode, 201, 17, 61, // Opcode: MUHU, DecodeIdx: 61
/* 188 */     MCD::OPC_FilterValue, 26, 21, 0, // Skip to: 213
/* 192 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 195 */     MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 205
/* 199 */     MCD::OPC_CheckPredicateOrFail, 76, 
/* 201 */     MCD::OPC_Decode, 173, 11, 61, // Opcode: DIV, DecodeIdx: 61
/* 205 */     MCD::OPC_FilterValueOrFail, 3, 
/* 207 */     MCD::OPC_CheckPredicateOrFail, 76, 
/* 209 */     MCD::OPC_Decode, 206, 16, 61, // Opcode: MOD, DecodeIdx: 61
/* 213 */     MCD::OPC_FilterValue, 27, 21, 0, // Skip to: 238
/* 217 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 220 */     MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 230
/* 224 */     MCD::OPC_CheckPredicateOrFail, 76, 
/* 226 */     MCD::OPC_Decode, 174, 11, 61, // Opcode: DIVU, DecodeIdx: 61
/* 230 */     MCD::OPC_FilterValueOrFail, 3, 
/* 232 */     MCD::OPC_CheckPredicateOrFail, 76, 
/* 234 */     MCD::OPC_Decode, 209, 16, 61, // Opcode: MODU, DecodeIdx: 61
/* 238 */     MCD::OPC_FilterValue, 28, 21, 0, // Skip to: 263
/* 242 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 245 */     MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 255
/* 249 */     MCD::OPC_CheckPredicateOrFail, 77, 
/* 251 */     MCD::OPC_Decode, 208, 11, 23, // Opcode: DMUL_R6, DecodeIdx: 23
/* 255 */     MCD::OPC_FilterValueOrFail, 3, 
/* 257 */     MCD::OPC_CheckPredicateOrFail, 77, 
/* 259 */     MCD::OPC_Decode, 202, 11, 23, // Opcode: DMUH, DecodeIdx: 23
/* 263 */     MCD::OPC_FilterValue, 29, 21, 0, // Skip to: 288
/* 267 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 270 */     MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 280
/* 274 */     MCD::OPC_CheckPredicateOrFail, 77, 
/* 276 */     MCD::OPC_Decode, 207, 11, 23, // Opcode: DMULU, DecodeIdx: 23
/* 280 */     MCD::OPC_FilterValueOrFail, 3, 
/* 282 */     MCD::OPC_CheckPredicateOrFail, 77, 
/* 284 */     MCD::OPC_Decode, 203, 11, 23, // Opcode: DMUHU, DecodeIdx: 23
/* 288 */     MCD::OPC_FilterValue, 30, 21, 0, // Skip to: 313
/* 292 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 295 */     MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 305
/* 299 */     MCD::OPC_CheckPredicateOrFail, 77, 
/* 301 */     MCD::OPC_Decode, 160, 11, 23, // Opcode: DDIV, DecodeIdx: 23
/* 305 */     MCD::OPC_FilterValueOrFail, 3, 
/* 307 */     MCD::OPC_CheckPredicateOrFail, 77, 
/* 309 */     MCD::OPC_Decode, 194, 11, 23, // Opcode: DMOD, DecodeIdx: 23
/* 313 */     MCD::OPC_FilterValue, 31, 21, 0, // Skip to: 338
/* 317 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 320 */     MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 330
/* 324 */     MCD::OPC_CheckPredicateOrFail, 77, 
/* 326 */     MCD::OPC_Decode, 161, 11, 23, // Opcode: DDIVU, DecodeIdx: 23
/* 330 */     MCD::OPC_FilterValueOrFail, 3, 
/* 332 */     MCD::OPC_CheckPredicateOrFail, 77, 
/* 334 */     MCD::OPC_Decode, 195, 11, 23, // Opcode: DMODU, DecodeIdx: 23
/* 338 */     MCD::OPC_FilterValue, 53, 10, 0, // Skip to: 352
/* 342 */     MCD::OPC_CheckPredicateOrFail, 78, 
/* 344 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 348 */     MCD::OPC_Decode, 216, 19, 61, // Opcode: SELEQZ, DecodeIdx: 61
/* 352 */     MCD::OPC_FilterValueOrFail, 55, 
/* 354 */     MCD::OPC_CheckPredicateOrFail, 78, 
/* 356 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 360 */     MCD::OPC_Decode, 223, 19, 61, // Opcode: SELNEZ, DecodeIdx: 61
/* 364 */     MCD::OPC_FilterValue, 1, 71, 0, // Skip to: 439
/* 368 */     MCD::OPC_ExtractField, 16, 5,  // Inst{20-16} ...
/* 371 */     MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 382
/* 375 */     MCD::OPC_CheckPredicateOrFail, 77, 
/* 377 */     MCD::OPC_Decode, 151, 11, 221, 2, // Opcode: DAHI, DecodeIdx: 349
/* 382 */     MCD::OPC_FilterValue, 16, 14, 0, // Skip to: 400
/* 386 */     MCD::OPC_CheckPredicateOrFail, 75, 
/* 388 */     MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 392 */     MCD::OPC_CheckFieldOrFail, 0, 16, 0, 
/* 396 */     MCD::OPC_Decode, 255, 17, 10, // Opcode: NAL, DecodeIdx: 10
/* 400 */     MCD::OPC_FilterValue, 17, 11, 0, // Skip to: 415
/* 404 */     MCD::OPC_CheckPredicateOrFail, 75, 
/* 406 */     MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 410 */     MCD::OPC_Decode, 144, 7, 198, 1, // Opcode: BAL, DecodeIdx: 198
/* 415 */     MCD::OPC_FilterValue, 23, 11, 0, // Skip to: 430
/* 419 */     MCD::OPC_CheckPredicateOrFail, 76, 
/* 421 */     MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 425 */     MCD::OPC_Decode, 167, 20, 222, 2, // Opcode: SIGRIE, DecodeIdx: 350
/* 430 */     MCD::OPC_FilterValueOrFail, 30, 
/* 432 */     MCD::OPC_CheckPredicateOrFail, 77, 
/* 434 */     MCD::OPC_Decode, 153, 11, 221, 2, // Opcode: DATI, DecodeIdx: 349
/* 439 */     MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 450
/* 443 */     MCD::OPC_CheckPredicateOrFail, 76, 
/* 445 */     MCD::OPC_Decode, 202, 7, 223, 2, // Opcode: BGEZALC, DecodeIdx: 351
/* 450 */     MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 461
/* 454 */     MCD::OPC_CheckPredicateOrFail, 76, 
/* 456 */     MCD::OPC_Decode, 131, 8, 224, 2, // Opcode: BLTZALC, DecodeIdx: 352
/* 461 */     MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 472
/* 465 */     MCD::OPC_CheckPredicateOrFail, 76, 
/* 467 */     MCD::OPC_Decode, 180, 7, 225, 2, // Opcode: BEQC, DecodeIdx: 353
/* 472 */     MCD::OPC_FilterValue, 15, 7, 0, // Skip to: 483
/* 476 */     MCD::OPC_CheckPredicateOrFail, 75, 
/* 478 */     MCD::OPC_Decode, 241, 6, 203, 1, // Opcode: AUI, DecodeIdx: 203
/* 483 */     MCD::OPC_FilterValue, 16, 29, 0, // Skip to: 516
/* 487 */     MCD::OPC_ExtractField, 0, 16,  // Inst{15-0} ...
/* 490 */     MCD::OPC_FilterValue, 4, 10, 0, // Skip to: 504
/* 494 */     MCD::OPC_CheckPredicateOrFail, 75, 
/* 496 */     MCD::OPC_CheckFieldOrFail, 21, 5, 11, 
/* 500 */     MCD::OPC_Decode, 168, 12, 92, // Opcode: EVP, DecodeIdx: 92
/* 504 */     MCD::OPC_FilterValueOrFail, 36, 
/* 506 */     MCD::OPC_CheckPredicateOrFail, 75, 
/* 508 */     MCD::OPC_CheckFieldOrFail, 21, 5, 11, 
/* 512 */     MCD::OPC_Decode, 151, 12, 92, // Opcode: DVP, DecodeIdx: 92
/* 516 */     MCD::OPC_FilterValue, 17, 141, 2, // Skip to: 1173
/* 520 */     MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 523 */     MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 534
/* 527 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 529 */     MCD::OPC_Decode, 155, 7, 226, 2, // Opcode: BC1EQZ, DecodeIdx: 354
/* 534 */     MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 545
/* 538 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 540 */     MCD::OPC_Decode, 160, 7, 226, 2, // Opcode: BC1NEZ, DecodeIdx: 354
/* 545 */     MCD::OPC_FilterValue, 16, 130, 0, // Skip to: 679
/* 549 */     MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 552 */     MCD::OPC_FilterValue, 16, 7, 0, // Skip to: 563
/* 556 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 558 */     MCD::OPC_Decode, 232, 19, 227, 2, // Opcode: SEL_S, DecodeIdx: 355
/* 563 */     MCD::OPC_FilterValue, 20, 7, 0, // Skip to: 574
/* 567 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 569 */     MCD::OPC_Decode, 221, 19, 218, 1, // Opcode: SELEQZ_S, DecodeIdx: 218
/* 574 */     MCD::OPC_FilterValue, 23, 7, 0, // Skip to: 585
/* 578 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 580 */     MCD::OPC_Decode, 228, 19, 218, 1, // Opcode: SELNEZ_S, DecodeIdx: 218
/* 585 */     MCD::OPC_FilterValue, 24, 7, 0, // Skip to: 596
/* 589 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 591 */     MCD::OPC_Decode, 217, 15, 228, 2, // Opcode: MADDF_S, DecodeIdx: 356
/* 596 */     MCD::OPC_FilterValue, 25, 7, 0, // Skip to: 607
/* 600 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 602 */     MCD::OPC_Decode, 140, 17, 228, 2, // Opcode: MSUBF_S, DecodeIdx: 356
/* 607 */     MCD::OPC_FilterValue, 26, 11, 0, // Skip to: 622
/* 611 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 613 */     MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 617 */     MCD::OPC_Decode, 135, 19, 219, 1, // Opcode: RINT_S, DecodeIdx: 219
/* 622 */     MCD::OPC_FilterValue, 27, 11, 0, // Skip to: 637
/* 626 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 628 */     MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 632 */     MCD::OPC_Decode, 246, 8, 219, 1, // Opcode: CLASS_S, DecodeIdx: 219
/* 637 */     MCD::OPC_FilterValue, 28, 7, 0, // Skip to: 648
/* 641 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 643 */     MCD::OPC_Decode, 196, 16, 218, 1, // Opcode: MIN_S, DecodeIdx: 218
/* 648 */     MCD::OPC_FilterValue, 29, 7, 0, // Skip to: 659
/* 652 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 654 */     MCD::OPC_Decode, 180, 16, 218, 1, // Opcode: MINA_S, DecodeIdx: 218
/* 659 */     MCD::OPC_FilterValue, 30, 7, 0, // Skip to: 670
/* 663 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 665 */     MCD::OPC_Decode, 137, 16, 218, 1, // Opcode: MAX_S, DecodeIdx: 218
/* 670 */     MCD::OPC_FilterValueOrFail, 31, 
/* 672 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 674 */     MCD::OPC_Decode, 249, 15, 218, 1, // Opcode: MAXA_S, DecodeIdx: 218
/* 679 */     MCD::OPC_FilterValue, 17, 130, 0, // Skip to: 813
/* 683 */     MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 686 */     MCD::OPC_FilterValue, 16, 7, 0, // Skip to: 697
/* 690 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 692 */     MCD::OPC_Decode, 230, 19, 229, 2, // Opcode: SEL_D, DecodeIdx: 357
/* 697 */     MCD::OPC_FilterValue, 20, 7, 0, // Skip to: 708
/* 701 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 703 */     MCD::OPC_Decode, 218, 19, 230, 2, // Opcode: SELEQZ_D, DecodeIdx: 358
/* 708 */     MCD::OPC_FilterValue, 23, 7, 0, // Skip to: 719
/* 712 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 714 */     MCD::OPC_Decode, 225, 19, 230, 2, // Opcode: SELNEZ_D, DecodeIdx: 358
/* 719 */     MCD::OPC_FilterValue, 24, 7, 0, // Skip to: 730
/* 723 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 725 */     MCD::OPC_Decode, 215, 15, 229, 2, // Opcode: MADDF_D, DecodeIdx: 357
/* 730 */     MCD::OPC_FilterValue, 25, 7, 0, // Skip to: 741
/* 734 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 736 */     MCD::OPC_Decode, 138, 17, 229, 2, // Opcode: MSUBF_D, DecodeIdx: 357
/* 741 */     MCD::OPC_FilterValue, 26, 11, 0, // Skip to: 756
/* 745 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 747 */     MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 751 */     MCD::OPC_Decode, 133, 19, 230, 1, // Opcode: RINT_D, DecodeIdx: 230
/* 756 */     MCD::OPC_FilterValue, 27, 11, 0, // Skip to: 771
/* 760 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 762 */     MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 766 */     MCD::OPC_Decode, 244, 8, 230, 1, // Opcode: CLASS_D, DecodeIdx: 230
/* 771 */     MCD::OPC_FilterValue, 28, 7, 0, // Skip to: 782
/* 775 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 777 */     MCD::OPC_Decode, 194, 16, 230, 2, // Opcode: MIN_D, DecodeIdx: 358
/* 782 */     MCD::OPC_FilterValue, 29, 7, 0, // Skip to: 793
/* 786 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 788 */     MCD::OPC_Decode, 178, 16, 230, 2, // Opcode: MINA_D, DecodeIdx: 358
/* 793 */     MCD::OPC_FilterValue, 30, 7, 0, // Skip to: 804
/* 797 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 799 */     MCD::OPC_Decode, 135, 16, 230, 2, // Opcode: MAX_D, DecodeIdx: 358
/* 804 */     MCD::OPC_FilterValueOrFail, 31, 
/* 806 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 808 */     MCD::OPC_Decode, 247, 15, 230, 2, // Opcode: MAXA_D, DecodeIdx: 358
/* 813 */     MCD::OPC_FilterValue, 20, 177, 0, // Skip to: 994
/* 817 */     MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 820 */     MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 831
/* 824 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 826 */     MCD::OPC_Decode, 187, 9, 231, 2, // Opcode: CMP_F_S, DecodeIdx: 359
/* 831 */     MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 842
/* 835 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 837 */     MCD::OPC_Decode, 246, 9, 231, 2, // Opcode: CMP_UN_S, DecodeIdx: 359
/* 842 */     MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 853
/* 846 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 848 */     MCD::OPC_Decode, 184, 9, 231, 2, // Opcode: CMP_EQ_S, DecodeIdx: 359
/* 853 */     MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 864
/* 857 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 859 */     MCD::OPC_Decode, 234, 9, 231, 2, // Opcode: CMP_UEQ_S, DecodeIdx: 359
/* 864 */     MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 875
/* 868 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 870 */     MCD::OPC_Decode, 198, 9, 231, 2, // Opcode: CMP_LT_S, DecodeIdx: 359
/* 875 */     MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 886
/* 879 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 881 */     MCD::OPC_Decode, 242, 9, 231, 2, // Opcode: CMP_ULT_S, DecodeIdx: 359
/* 886 */     MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 897
/* 890 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 892 */     MCD::OPC_Decode, 192, 9, 231, 2, // Opcode: CMP_LE_S, DecodeIdx: 359
/* 897 */     MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 908
/* 901 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 903 */     MCD::OPC_Decode, 238, 9, 231, 2, // Opcode: CMP_ULE_S, DecodeIdx: 359
/* 908 */     MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 919
/* 912 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 914 */     MCD::OPC_Decode, 202, 9, 231, 2, // Opcode: CMP_SAF_S, DecodeIdx: 359
/* 919 */     MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 930
/* 923 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 925 */     MCD::OPC_Decode, 230, 9, 231, 2, // Opcode: CMP_SUN_S, DecodeIdx: 359
/* 930 */     MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 941
/* 934 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 936 */     MCD::OPC_Decode, 206, 9, 231, 2, // Opcode: CMP_SEQ_S, DecodeIdx: 359
/* 941 */     MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 952
/* 945 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 947 */     MCD::OPC_Decode, 218, 9, 231, 2, // Opcode: CMP_SUEQ_S, DecodeIdx: 359
/* 952 */     MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 963
/* 956 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 958 */     MCD::OPC_Decode, 214, 9, 231, 2, // Opcode: CMP_SLT_S, DecodeIdx: 359
/* 963 */     MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 974
/* 967 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 969 */     MCD::OPC_Decode, 226, 9, 231, 2, // Opcode: CMP_SULT_S, DecodeIdx: 359
/* 974 */     MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 985
/* 978 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 980 */     MCD::OPC_Decode, 210, 9, 231, 2, // Opcode: CMP_SLE_S, DecodeIdx: 359
/* 985 */     MCD::OPC_FilterValueOrFail, 15, 
/* 987 */     MCD::OPC_CheckPredicateOrFail, 79, 
/* 989 */     MCD::OPC_Decode, 222, 9, 231, 2, // Opcode: CMP_SULE_S, DecodeIdx: 359
/* 994 */     MCD::OPC_FilterValueOrFail, 21, 
/* 996 */     MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 999 */     MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 1010
/* 1003 */    MCD::OPC_CheckPredicateOrFail, 79, 
/* 1005 */    MCD::OPC_Decode, 186, 9, 232, 2, // Opcode: CMP_F_D, DecodeIdx: 360
/* 1010 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 1021
/* 1014 */    MCD::OPC_CheckPredicateOrFail, 79, 
/* 1016 */    MCD::OPC_Decode, 244, 9, 232, 2, // Opcode: CMP_UN_D, DecodeIdx: 360
/* 1021 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 1032
/* 1025 */    MCD::OPC_CheckPredicateOrFail, 79, 
/* 1027 */    MCD::OPC_Decode, 180, 9, 232, 2, // Opcode: CMP_EQ_D, DecodeIdx: 360
/* 1032 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 1043
/* 1036 */    MCD::OPC_CheckPredicateOrFail, 79, 
/* 1038 */    MCD::OPC_Decode, 232, 9, 232, 2, // Opcode: CMP_UEQ_D, DecodeIdx: 360
/* 1043 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 1054
/* 1047 */    MCD::OPC_CheckPredicateOrFail, 79, 
/* 1049 */    MCD::OPC_Decode, 194, 9, 232, 2, // Opcode: CMP_LT_D, DecodeIdx: 360
/* 1054 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 1065
/* 1058 */    MCD::OPC_CheckPredicateOrFail, 79, 
/* 1060 */    MCD::OPC_Decode, 240, 9, 232, 2, // Opcode: CMP_ULT_D, DecodeIdx: 360
/* 1065 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 1076
/* 1069 */    MCD::OPC_CheckPredicateOrFail, 79, 
/* 1071 */    MCD::OPC_Decode, 188, 9, 232, 2, // Opcode: CMP_LE_D, DecodeIdx: 360
/* 1076 */    MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 1087
/* 1080 */    MCD::OPC_CheckPredicateOrFail, 79, 
/* 1082 */    MCD::OPC_Decode, 236, 9, 232, 2, // Opcode: CMP_ULE_D, DecodeIdx: 360
/* 1087 */    MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 1098
/* 1091 */    MCD::OPC_CheckPredicateOrFail, 79, 
/* 1093 */    MCD::OPC_Decode, 200, 9, 232, 2, // Opcode: CMP_SAF_D, DecodeIdx: 360
/* 1098 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 1109
/* 1102 */    MCD::OPC_CheckPredicateOrFail, 79, 
/* 1104 */    MCD::OPC_Decode, 228, 9, 232, 2, // Opcode: CMP_SUN_D, DecodeIdx: 360
/* 1109 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 1120
/* 1113 */    MCD::OPC_CheckPredicateOrFail, 79, 
/* 1115 */    MCD::OPC_Decode, 204, 9, 232, 2, // Opcode: CMP_SEQ_D, DecodeIdx: 360
/* 1120 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 1131
/* 1124 */    MCD::OPC_CheckPredicateOrFail, 79, 
/* 1126 */    MCD::OPC_Decode, 216, 9, 232, 2, // Opcode: CMP_SUEQ_D, DecodeIdx: 360
/* 1131 */    MCD::OPC_FilterValue, 12, 7, 0, // Skip to: 1142
/* 1135 */    MCD::OPC_CheckPredicateOrFail, 79, 
/* 1137 */    MCD::OPC_Decode, 212, 9, 232, 2, // Opcode: CMP_SLT_D, DecodeIdx: 360
/* 1142 */    MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 1153
/* 1146 */    MCD::OPC_CheckPredicateOrFail, 79, 
/* 1148 */    MCD::OPC_Decode, 224, 9, 232, 2, // Opcode: CMP_SULT_D, DecodeIdx: 360
/* 1153 */    MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 1164
/* 1157 */    MCD::OPC_CheckPredicateOrFail, 79, 
/* 1159 */    MCD::OPC_Decode, 208, 9, 232, 2, // Opcode: CMP_SLE_D, DecodeIdx: 360
/* 1164 */    MCD::OPC_FilterValueOrFail, 15, 
/* 1166 */    MCD::OPC_CheckPredicateOrFail, 79, 
/* 1168 */    MCD::OPC_Decode, 220, 9, 232, 2, // Opcode: CMP_SULE_D, DecodeIdx: 360
/* 1173 */    MCD::OPC_FilterValue, 18, 67, 0, // Skip to: 1244
/* 1177 */    MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 1180 */    MCD::OPC_FilterValue, 9, 7, 0, // Skip to: 1191
/* 1184 */    MCD::OPC_CheckPredicateOrFail, 76, 
/* 1186 */    MCD::OPC_Decode, 165, 7, 233, 2, // Opcode: BC2EQZ, DecodeIdx: 361
/* 1191 */    MCD::OPC_FilterValue, 10, 7, 0, // Skip to: 1202
/* 1195 */    MCD::OPC_CheckPredicateOrFail, 76, 
/* 1197 */    MCD::OPC_Decode, 169, 15, 234, 2, // Opcode: LWC2_R6, DecodeIdx: 362
/* 1202 */    MCD::OPC_FilterValue, 11, 7, 0, // Skip to: 1213
/* 1206 */    MCD::OPC_CheckPredicateOrFail, 76, 
/* 1208 */    MCD::OPC_Decode, 206, 21, 234, 2, // Opcode: SWC2_R6, DecodeIdx: 362
/* 1213 */    MCD::OPC_FilterValue, 13, 7, 0, // Skip to: 1224
/* 1217 */    MCD::OPC_CheckPredicateOrFail, 76, 
/* 1219 */    MCD::OPC_Decode, 167, 7, 233, 2, // Opcode: BC2NEZ, DecodeIdx: 361
/* 1224 */    MCD::OPC_FilterValue, 14, 7, 0, // Skip to: 1235
/* 1228 */    MCD::OPC_CheckPredicateOrFail, 76, 
/* 1230 */    MCD::OPC_Decode, 237, 14, 234, 2, // Opcode: LDC2_R6, DecodeIdx: 362
/* 1235 */    MCD::OPC_FilterValueOrFail, 15, 
/* 1237 */    MCD::OPC_CheckPredicateOrFail, 76, 
/* 1239 */    MCD::OPC_Decode, 202, 19, 234, 2, // Opcode: SDC2_R6, DecodeIdx: 362
/* 1244 */    MCD::OPC_FilterValue, 22, 7, 0, // Skip to: 1255
/* 1248 */    MCD::OPC_CheckPredicateOrFail, 76, 
/* 1250 */    MCD::OPC_Decode, 207, 7, 235, 2, // Opcode: BGEZC, DecodeIdx: 363
/* 1255 */    MCD::OPC_FilterValue, 23, 7, 0, // Skip to: 1266
/* 1259 */    MCD::OPC_CheckPredicateOrFail, 76, 
/* 1261 */    MCD::OPC_Decode, 136, 8, 236, 2, // Opcode: BLTZC, DecodeIdx: 364
/* 1266 */    MCD::OPC_FilterValue, 24, 7, 0, // Skip to: 1277
/* 1270 */    MCD::OPC_CheckPredicateOrFail, 76, 
/* 1272 */    MCD::OPC_Decode, 147, 8, 237, 2, // Opcode: BNEC, DecodeIdx: 365
/* 1277 */    MCD::OPC_FilterValue, 29, 7, 0, // Skip to: 1288
/* 1281 */    MCD::OPC_CheckPredicateOrFail, 77, 
/* 1283 */    MCD::OPC_Decode, 154, 11, 238, 2, // Opcode: DAUI, DecodeIdx: 366
/* 1288 */    MCD::OPC_FilterValue, 31, 17, 1, // Skip to: 1565
/* 1292 */    MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 1295 */    MCD::OPC_FilterValue, 15, 89, 0, // Skip to: 1388
/* 1299 */    MCD::OPC_ExtractField, 6, 10,  // Inst{15-6} ...
/* 1302 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 1313
/* 1306 */    MCD::OPC_CheckPredicateOrFail, 80, 
/* 1308 */    MCD::OPC_Decode, 255, 9, 239, 2, // Opcode: CRC32B, DecodeIdx: 367
/* 1313 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 1324
/* 1317 */    MCD::OPC_CheckPredicateOrFail, 80, 
/* 1319 */    MCD::OPC_Decode, 133, 10, 239, 2, // Opcode: CRC32H, DecodeIdx: 367
/* 1324 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 1335
/* 1328 */    MCD::OPC_CheckPredicateOrFail, 80, 
/* 1330 */    MCD::OPC_Decode, 134, 10, 239, 2, // Opcode: CRC32W, DecodeIdx: 367
/* 1335 */    MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 1346
/* 1339 */    MCD::OPC_CheckPredicateOrFail, 81, 
/* 1341 */    MCD::OPC_Decode, 132, 10, 239, 2, // Opcode: CRC32D, DecodeIdx: 367
/* 1346 */    MCD::OPC_FilterValue, 4, 7, 0, // Skip to: 1357
/* 1350 */    MCD::OPC_CheckPredicateOrFail, 80, 
/* 1352 */    MCD::OPC_Decode, 128, 10, 239, 2, // Opcode: CRC32CB, DecodeIdx: 367
/* 1357 */    MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 1368
/* 1361 */    MCD::OPC_CheckPredicateOrFail, 80, 
/* 1363 */    MCD::OPC_Decode, 130, 10, 239, 2, // Opcode: CRC32CH, DecodeIdx: 367
/* 1368 */    MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 1379
/* 1372 */    MCD::OPC_CheckPredicateOrFail, 80, 
/* 1374 */    MCD::OPC_Decode, 131, 10, 239, 2, // Opcode: CRC32CW, DecodeIdx: 367
/* 1379 */    MCD::OPC_FilterValueOrFail, 7, 
/* 1381 */    MCD::OPC_CheckPredicateOrFail, 81, 
/* 1383 */    MCD::OPC_Decode, 129, 10, 239, 2, // Opcode: CRC32CD, DecodeIdx: 367
/* 1388 */    MCD::OPC_FilterValue, 32, 31, 0, // Skip to: 1423
/* 1392 */    MCD::OPC_ExtractField, 8, 3,  // Inst{10-8} ...
/* 1395 */    MCD::OPC_FilterValue, 0, 15, 0, // Skip to: 1414
/* 1399 */    MCD::OPC_CheckPredicateOrFail, 75, 
/* 1401 */    MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 1405 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 1409 */    MCD::OPC_Decode, 239, 7, 204, 2, // Opcode: BITSWAP, DecodeIdx: 332
/* 1414 */    MCD::OPC_FilterValueOrFail, 2, 
/* 1416 */    MCD::OPC_CheckPredicateOrFail, 75, 
/* 1418 */    MCD::OPC_Decode, 213, 6, 240, 2, // Opcode: ALIGN, DecodeIdx: 368
/* 1423 */    MCD::OPC_FilterValue, 36, 31, 0, // Skip to: 1458
/* 1427 */    MCD::OPC_ExtractField, 9, 2,  // Inst{10-9} ...
/* 1430 */    MCD::OPC_FilterValue, 0, 15, 0, // Skip to: 1449
/* 1434 */    MCD::OPC_CheckPredicateOrFail, 77, 
/* 1436 */    MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 1440 */    MCD::OPC_CheckFieldOrFail, 6, 3, 0, 
/* 1444 */    MCD::OPC_Decode, 155, 11, 241, 2, // Opcode: DBITSWAP, DecodeIdx: 369
/* 1449 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1451 */    MCD::OPC_CheckPredicateOrFail, 77, 
/* 1453 */    MCD::OPC_Decode, 152, 11, 242, 2, // Opcode: DALIGN, DecodeIdx: 370
/* 1458 */    MCD::OPC_FilterValue, 37, 11, 0, // Skip to: 1473
/* 1462 */    MCD::OPC_CheckPredicateOrFail, 76, 
/* 1464 */    MCD::OPC_CheckFieldOrFail, 6, 1, 0, 
/* 1468 */    MCD::OPC_Decode, 216, 8, 209, 2, // Opcode: CACHE_R6, DecodeIdx: 337
/* 1473 */    MCD::OPC_FilterValue, 38, 7, 0, // Skip to: 1484
/* 1477 */    MCD::OPC_CheckPredicateOrFail, 82, 
/* 1479 */    MCD::OPC_Decode, 187, 19, 243, 2, // Opcode: SC_R6, DecodeIdx: 371
/* 1484 */    MCD::OPC_FilterValue, 39, 7, 0, // Skip to: 1495
/* 1488 */    MCD::OPC_CheckPredicateOrFail, 75, 
/* 1490 */    MCD::OPC_Decode, 182, 19, 243, 2, // Opcode: SCD_R6, DecodeIdx: 371
/* 1495 */    MCD::OPC_FilterValue, 53, 11, 0, // Skip to: 1510
/* 1499 */    MCD::OPC_CheckPredicateOrFail, 76, 
/* 1501 */    MCD::OPC_CheckFieldOrFail, 6, 1, 0, 
/* 1505 */    MCD::OPC_Decode, 233, 18, 209, 2, // Opcode: PREF_R6, DecodeIdx: 337
/* 1510 */    MCD::OPC_FilterValue, 54, 7, 0, // Skip to: 1521
/* 1514 */    MCD::OPC_CheckPredicateOrFail, 82, 
/* 1516 */    MCD::OPC_Decode, 151, 15, 243, 2, // Opcode: LL_R6, DecodeIdx: 371
/* 1521 */    MCD::OPC_FilterValue, 55, 7, 0, // Skip to: 1532
/* 1525 */    MCD::OPC_CheckPredicateOrFail, 77, 
/* 1527 */    MCD::OPC_Decode, 146, 15, 243, 2, // Opcode: LLD_R6, DecodeIdx: 371
/* 1532 */    MCD::OPC_FilterValueOrFail, 61, 
/* 1534 */    MCD::OPC_ExtractField, 6, 2,  // Inst{7-6} ...
/* 1537 */    MCD::OPC_FilterValue, 0, 11, 0, // Skip to: 1552
/* 1541 */    MCD::OPC_CheckPredicateOrFail, 83, 
/* 1543 */    MCD::OPC_CheckFieldOrFail, 8, 13, 0, 
/* 1547 */    MCD::OPC_Decode, 253, 13, 186, 1, // Opcode: GINVI, DecodeIdx: 186
/* 1552 */    MCD::OPC_FilterValueOrFail, 2, 
/* 1554 */    MCD::OPC_CheckPredicateOrFail, 83, 
/* 1556 */    MCD::OPC_CheckFieldOrFail, 10, 11, 0, 
/* 1560 */    MCD::OPC_Decode, 255, 13, 244, 2, // Opcode: GINVT, DecodeIdx: 372
/* 1565 */    MCD::OPC_FilterValue, 50, 7, 0, // Skip to: 1576
/* 1569 */    MCD::OPC_CheckPredicateOrFail, 76, 
/* 1571 */    MCD::OPC_Decode, 153, 7, 245, 2, // Opcode: BC, DecodeIdx: 373
/* 1576 */    MCD::OPC_FilterValue, 53, 22, 0, // Skip to: 1602
/* 1580 */    MCD::OPC_CheckPredicate, 24, 11, 0, // Skip to: 1595
/* 1584 */    MCD::OPC_CheckField, 16, 5, 0, 5, 0, // Skip to: 1595
/* 1590 */    MCD::OPC_Decode, 218, 7, 180, 1, // Opcode: BGTZC_MMR6, DecodeIdx: 180
/* 1595 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 1597 */    MCD::OPC_Decode, 138, 8, 180, 1, // Opcode: BLTZC_MMR6, DecodeIdx: 180
/* 1602 */    MCD::OPC_FilterValue, 54, 21, 0, // Skip to: 1627
/* 1606 */    MCD::OPC_CheckPredicate, 75, 10, 0, // Skip to: 1620
/* 1610 */    MCD::OPC_CheckField, 21, 5, 0, 4, 0, // Skip to: 1620
/* 1616 */    MCD::OPC_Decode, 192, 14, 103, // Opcode: JIC, DecodeIdx: 103
/* 1620 */    MCD::OPC_CheckPredicateOrFail, 76, 
/* 1622 */    MCD::OPC_Decode, 187, 7, 246, 2, // Opcode: BEQZC, DecodeIdx: 374
/* 1627 */    MCD::OPC_FilterValue, 58, 7, 0, // Skip to: 1638
/* 1631 */    MCD::OPC_CheckPredicateOrFail, 75, 
/* 1633 */    MCD::OPC_Decode, 145, 7, 245, 2, // Opcode: BALC, DecodeIdx: 373
/* 1638 */    MCD::OPC_FilterValue, 59, 77, 0, // Skip to: 1719
/* 1642 */    MCD::OPC_ExtractField, 19, 2,  // Inst{20-19} ...
/* 1645 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 1656
/* 1649 */    MCD::OPC_CheckPredicateOrFail, 75, 
/* 1651 */    MCD::OPC_Decode, 139, 6, 174, 1, // Opcode: ADDIUPC, DecodeIdx: 174
/* 1656 */    MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 1667
/* 1660 */    MCD::OPC_CheckPredicateOrFail, 75, 
/* 1662 */    MCD::OPC_Decode, 184, 15, 174, 1, // Opcode: LWPC, DecodeIdx: 174
/* 1667 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 1678
/* 1671 */    MCD::OPC_CheckPredicateOrFail, 84, 
/* 1673 */    MCD::OPC_Decode, 193, 15, 174, 1, // Opcode: LWUPC, DecodeIdx: 174
/* 1678 */    MCD::OPC_FilterValueOrFail, 3, 
/* 1680 */    MCD::OPC_ExtractField, 18, 1,  // Inst{18} ...
/* 1683 */    MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 1694
/* 1687 */    MCD::OPC_CheckPredicateOrFail, 84, 
/* 1689 */    MCD::OPC_Decode, 244, 14, 247, 2, // Opcode: LDPC, DecodeIdx: 375
/* 1694 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1696 */    MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 1699 */    MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 1710
/* 1703 */    MCD::OPC_CheckPredicateOrFail, 75, 
/* 1705 */    MCD::OPC_Decode, 242, 6, 175, 1, // Opcode: AUIPC, DecodeIdx: 175
/* 1710 */    MCD::OPC_FilterValueOrFail, 3, 
/* 1712 */    MCD::OPC_CheckPredicateOrFail, 75, 
/* 1714 */    MCD::OPC_Decode, 215, 6, 175, 1, // Opcode: ALUIPC, DecodeIdx: 175
/* 1719 */    MCD::OPC_FilterValue, 61, 22, 0, // Skip to: 1745
/* 1723 */    MCD::OPC_CheckPredicate, 24, 11, 0, // Skip to: 1738
/* 1727 */    MCD::OPC_CheckField, 16, 5, 0, 5, 0, // Skip to: 1738
/* 1733 */    MCD::OPC_Decode, 247, 7, 182, 1, // Opcode: BLEZC_MMR6, DecodeIdx: 182
/* 1738 */    MCD::OPC_CheckPredicateOrFail, 24, 
/* 1740 */    MCD::OPC_Decode, 209, 7, 182, 1, // Opcode: BGEZC_MMR6, DecodeIdx: 182
/* 1745 */    MCD::OPC_FilterValueOrFail, 62, 
/* 1747 */    MCD::OPC_CheckPredicate, 75, 10, 0, // Skip to: 1761
/* 1751 */    MCD::OPC_CheckField, 21, 5, 0, 4, 0, // Skip to: 1761
/* 1757 */    MCD::OPC_Decode, 189, 14, 103, // Opcode: JIALC, DecodeIdx: 103
/* 1761 */    MCD::OPC_CheckPredicateOrFail, 76, 
/* 1763 */    MCD::OPC_Decode, 162, 8, 246, 2, // Opcode: BNEZC, DecodeIdx: 374
/* 1768 */    MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableMips32r6_64r6_Ambiguous32[] = {
/* 0 */       MCD::OPC_ExtractField, 26, 6,  // Inst{31-26} ...
/* 3 */       MCD::OPC_FilterValue, 6, 22, 0, // Skip to: 29
/* 7 */       MCD::OPC_CheckPredicate, 76, 11, 0, // Skip to: 22
/* 11 */      MCD::OPC_CheckField, 21, 5, 0, 5, 0, // Skip to: 22
/* 17 */      MCD::OPC_Decode, 243, 7, 223, 2, // Opcode: BLEZALC, DecodeIdx: 351
/* 22 */      MCD::OPC_CheckPredicateOrFail, 76, 
/* 24 */      MCD::OPC_Decode, 196, 7, 223, 2, // Opcode: BGEUC, DecodeIdx: 351
/* 29 */      MCD::OPC_FilterValue, 7, 22, 0, // Skip to: 55
/* 33 */      MCD::OPC_CheckPredicate, 76, 11, 0, // Skip to: 48
/* 37 */      MCD::OPC_CheckField, 21, 5, 0, 5, 0, // Skip to: 48
/* 43 */      MCD::OPC_Decode, 214, 7, 224, 2, // Opcode: BGTZALC, DecodeIdx: 352
/* 48 */      MCD::OPC_CheckPredicateOrFail, 76, 
/* 50 */      MCD::OPC_Decode, 253, 7, 224, 2, // Opcode: BLTUC, DecodeIdx: 352
/* 55 */      MCD::OPC_FilterValue, 8, 22, 0, // Skip to: 81
/* 59 */      MCD::OPC_CheckPredicate, 76, 11, 0, // Skip to: 74
/* 63 */      MCD::OPC_CheckField, 21, 5, 0, 5, 0, // Skip to: 74
/* 69 */      MCD::OPC_Decode, 185, 7, 237, 2, // Opcode: BEQZALC, DecodeIdx: 365
/* 74 */      MCD::OPC_CheckPredicateOrFail, 76, 
/* 76 */      MCD::OPC_Decode, 175, 8, 225, 2, // Opcode: BOVC, DecodeIdx: 353
/* 81 */      MCD::OPC_FilterValue, 22, 22, 0, // Skip to: 107
/* 85 */      MCD::OPC_CheckPredicate, 76, 11, 0, // Skip to: 100
/* 89 */      MCD::OPC_CheckField, 21, 5, 0, 5, 0, // Skip to: 100
/* 95 */      MCD::OPC_Decode, 245, 7, 235, 2, // Opcode: BLEZC, DecodeIdx: 363
/* 100 */     MCD::OPC_CheckPredicateOrFail, 76, 
/* 102 */     MCD::OPC_Decode, 193, 7, 235, 2, // Opcode: BGEC, DecodeIdx: 363
/* 107 */     MCD::OPC_FilterValue, 23, 22, 0, // Skip to: 133
/* 111 */     MCD::OPC_CheckPredicate, 76, 11, 0, // Skip to: 126
/* 115 */     MCD::OPC_CheckField, 21, 5, 0, 5, 0, // Skip to: 126
/* 121 */     MCD::OPC_Decode, 216, 7, 236, 2, // Opcode: BGTZC, DecodeIdx: 364
/* 126 */     MCD::OPC_CheckPredicateOrFail, 76, 
/* 128 */     MCD::OPC_Decode, 250, 7, 236, 2, // Opcode: BLTC, DecodeIdx: 364
/* 133 */     MCD::OPC_FilterValueOrFail, 24, 
/* 135 */     MCD::OPC_CheckPredicate, 76, 11, 0, // Skip to: 150
/* 139 */     MCD::OPC_CheckField, 21, 5, 0, 5, 0, // Skip to: 150
/* 145 */     MCD::OPC_Decode, 160, 8, 237, 2, // Opcode: BNEZALC, DecodeIdx: 365
/* 150 */     MCD::OPC_CheckPredicateOrFail, 76, 
/* 152 */     MCD::OPC_Decode, 168, 8, 237, 2, // Opcode: BNVC, DecodeIdx: 365
/* 157 */     MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableMips32r6_64r6_BranchZero32[] = {
/* 0 */       MCD::OPC_ExtractField, 26, 6,  // Inst{31-26} ...
/* 3 */       MCD::OPC_FilterValue, 22, 7, 0, // Skip to: 14
/* 7 */       MCD::OPC_CheckPredicateOrFail, 85, 
/* 9 */       MCD::OPC_Decode, 208, 7, 235, 2, // Opcode: BGEZC64, DecodeIdx: 363
/* 14 */      MCD::OPC_FilterValueOrFail, 23, 
/* 16 */      MCD::OPC_CheckPredicateOrFail, 85, 
/* 18 */      MCD::OPC_Decode, 137, 8, 236, 2, // Opcode: BLTZC64, DecodeIdx: 364
/* 23 */      MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableMips32r6_64r6_GP6432[] = {
/* 0 */       MCD::OPC_ExtractField, 26, 6,  // Inst{31-26} ...
/* 3 */       MCD::OPC_FilterValue, 0, 36, 0, // Skip to: 43
/* 7 */       MCD::OPC_ExtractField, 0, 11,  // Inst{10-0} ...
/* 10 */      MCD::OPC_FilterValue, 53, 6, 0, // Skip to: 20
/* 14 */      MCD::OPC_CheckPredicateOrFail, 86, 
/* 16 */      MCD::OPC_Decode, 217, 19, 23, // Opcode: SELEQZ64, DecodeIdx: 23
/* 20 */      MCD::OPC_FilterValue, 55, 6, 0, // Skip to: 30
/* 24 */      MCD::OPC_CheckPredicateOrFail, 86, 
/* 26 */      MCD::OPC_Decode, 224, 19, 23, // Opcode: SELNEZ64, DecodeIdx: 23
/* 30 */      MCD::OPC_FilterValueOrFail, 137, 8, 
/* 33 */      MCD::OPC_CheckPredicateOrFail, 75, 
/* 35 */      MCD::OPC_CheckFieldOrFail, 11, 10, 0, 
/* 39 */      MCD::OPC_Decode, 204, 14, 24, // Opcode: JR_HB64_R6, DecodeIdx: 24
/* 43 */      MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 54
/* 47 */      MCD::OPC_CheckPredicateOrFail, 85, 
/* 49 */      MCD::OPC_Decode, 197, 7, 223, 2, // Opcode: BGEUC64, DecodeIdx: 351
/* 54 */      MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 65
/* 58 */      MCD::OPC_CheckPredicateOrFail, 85, 
/* 60 */      MCD::OPC_Decode, 254, 7, 224, 2, // Opcode: BLTUC64, DecodeIdx: 352
/* 65 */      MCD::OPC_FilterValue, 8, 7, 0, // Skip to: 76
/* 69 */      MCD::OPC_CheckPredicateOrFail, 85, 
/* 71 */      MCD::OPC_Decode, 181, 7, 225, 2, // Opcode: BEQC64, DecodeIdx: 353
/* 76 */      MCD::OPC_FilterValue, 22, 22, 0, // Skip to: 102
/* 80 */      MCD::OPC_CheckPredicate, 85, 11, 0, // Skip to: 95
/* 84 */      MCD::OPC_CheckField, 21, 5, 0, 5, 0, // Skip to: 95
/* 90 */      MCD::OPC_Decode, 246, 7, 235, 2, // Opcode: BLEZC64, DecodeIdx: 363
/* 95 */      MCD::OPC_CheckPredicateOrFail, 85, 
/* 97 */      MCD::OPC_Decode, 194, 7, 235, 2, // Opcode: BGEC64, DecodeIdx: 363
/* 102 */     MCD::OPC_FilterValue, 23, 22, 0, // Skip to: 128
/* 106 */     MCD::OPC_CheckPredicate, 85, 11, 0, // Skip to: 121
/* 110 */     MCD::OPC_CheckField, 21, 5, 0, 5, 0, // Skip to: 121
/* 116 */     MCD::OPC_Decode, 217, 7, 236, 2, // Opcode: BGTZC64, DecodeIdx: 364
/* 121 */     MCD::OPC_CheckPredicateOrFail, 85, 
/* 123 */     MCD::OPC_Decode, 251, 7, 236, 2, // Opcode: BLTC64, DecodeIdx: 364
/* 128 */     MCD::OPC_FilterValue, 24, 7, 0, // Skip to: 139
/* 132 */     MCD::OPC_CheckPredicateOrFail, 85, 
/* 134 */     MCD::OPC_Decode, 148, 8, 237, 2, // Opcode: BNEC64, DecodeIdx: 365
/* 139 */     MCD::OPC_FilterValue, 54, 21, 0, // Skip to: 164
/* 143 */     MCD::OPC_CheckPredicate, 85, 10, 0, // Skip to: 157
/* 147 */     MCD::OPC_CheckField, 21, 5, 0, 4, 0, // Skip to: 157
/* 153 */     MCD::OPC_Decode, 193, 14, 22, // Opcode: JIC64, DecodeIdx: 22
/* 157 */     MCD::OPC_CheckPredicateOrFail, 85, 
/* 159 */     MCD::OPC_Decode, 189, 7, 248, 2, // Opcode: BEQZC64, DecodeIdx: 376
/* 164 */     MCD::OPC_FilterValueOrFail, 62, 
/* 166 */     MCD::OPC_CheckPredicate, 85, 10, 0, // Skip to: 180
/* 170 */     MCD::OPC_CheckField, 21, 5, 0, 4, 0, // Skip to: 180
/* 176 */     MCD::OPC_Decode, 190, 14, 22, // Opcode: JIALC64, DecodeIdx: 22
/* 180 */     MCD::OPC_CheckPredicateOrFail, 85, 
/* 182 */     MCD::OPC_Decode, 164, 8, 248, 2, // Opcode: BNEZC64, DecodeIdx: 376
/* 187 */     MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableMips32r6_64r6_PTR6432[] = {
/* 0 */       MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 3 */       MCD::OPC_FilterValue, 38, 11, 0, // Skip to: 18
/* 7 */       MCD::OPC_CheckPredicateOrFail, 87, 
/* 9 */       MCD::OPC_CheckFieldOrFail, 26, 6, 31, 
/* 13 */      MCD::OPC_Decode, 180, 19, 243, 2, // Opcode: SC64_R6, DecodeIdx: 371
/* 18 */      MCD::OPC_FilterValueOrFail, 54, 
/* 20 */      MCD::OPC_CheckPredicateOrFail, 87, 
/* 22 */      MCD::OPC_CheckFieldOrFail, 26, 6, 31, 
/* 26 */      MCD::OPC_Decode, 144, 15, 243, 2, // Opcode: LL64_R6, DecodeIdx: 371
/* 31 */      MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableMips6432[] = {
/* 0 */       MCD::OPC_ExtractField, 26, 6,  // Inst{31-26} ...
/* 3 */       MCD::OPC_FilterValue, 0, 79, 1, // Skip to: 342
/* 7 */       MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 10 */      MCD::OPC_FilterValue, 8, 10, 0, // Skip to: 24
/* 14 */      MCD::OPC_CheckPredicateOrFail, 88, 
/* 16 */      MCD::OPC_CheckFieldOrFail, 6, 15, 16, 
/* 20 */      MCD::OPC_Decode, 203, 14, 24, // Opcode: JR_HB64, DecodeIdx: 24
/* 24 */      MCD::OPC_FilterValue, 9, 29, 0, // Skip to: 57
/* 28 */      MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 31 */      MCD::OPC_FilterValue, 0, 10, 0, // Skip to: 45
/* 35 */      MCD::OPC_CheckPredicateOrFail, 89, 
/* 37 */      MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 41 */      MCD::OPC_Decode, 176, 14, 26, // Opcode: JALR64, DecodeIdx: 26
/* 45 */      MCD::OPC_FilterValueOrFail, 16, 
/* 47 */      MCD::OPC_CheckPredicateOrFail, 90, 
/* 49 */      MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 53 */      MCD::OPC_Decode, 183, 14, 26, // Opcode: JALR_HB64, DecodeIdx: 26
/* 57 */      MCD::OPC_FilterValue, 20, 11, 0, // Skip to: 72
/* 61 */      MCD::OPC_CheckPredicateOrFail, 91, 
/* 63 */      MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 67 */      MCD::OPC_Decode, 141, 12, 249, 2, // Opcode: DSLLV, DecodeIdx: 377
/* 72 */      MCD::OPC_FilterValue, 22, 23, 0, // Skip to: 99
/* 76 */      MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 79 */      MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 90
/* 83 */      MCD::OPC_CheckPredicateOrFail, 91, 
/* 85 */      MCD::OPC_Decode, 147, 12, 249, 2, // Opcode: DSRLV, DecodeIdx: 377
/* 90 */      MCD::OPC_FilterValueOrFail, 1, 
/* 92 */      MCD::OPC_CheckPredicateOrFail, 90, 
/* 94 */      MCD::OPC_Decode, 134, 12, 249, 2, // Opcode: DROTRV, DecodeIdx: 377
/* 99 */      MCD::OPC_FilterValue, 23, 11, 0, // Skip to: 114
/* 103 */     MCD::OPC_CheckPredicateOrFail, 91, 
/* 105 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 109 */     MCD::OPC_Decode, 144, 12, 249, 2, // Opcode: DSRAV, DecodeIdx: 377
/* 114 */     MCD::OPC_FilterValue, 28, 11, 0, // Skip to: 129
/* 118 */     MCD::OPC_CheckPredicateOrFail, 92, 
/* 120 */     MCD::OPC_CheckFieldOrFail, 6, 10, 0, 
/* 124 */     MCD::OPC_Decode, 205, 11, 250, 2, // Opcode: DMULT, DecodeIdx: 378
/* 129 */     MCD::OPC_FilterValue, 29, 11, 0, // Skip to: 144
/* 133 */     MCD::OPC_CheckPredicateOrFail, 92, 
/* 135 */     MCD::OPC_CheckFieldOrFail, 6, 10, 0, 
/* 139 */     MCD::OPC_Decode, 206, 11, 250, 2, // Opcode: DMULTu, DecodeIdx: 378
/* 144 */     MCD::OPC_FilterValue, 30, 11, 0, // Skip to: 159
/* 148 */     MCD::OPC_CheckPredicateOrFail, 92, 
/* 150 */     MCD::OPC_CheckFieldOrFail, 6, 10, 0, 
/* 154 */     MCD::OPC_Decode, 136, 12, 250, 2, // Opcode: DSDIV, DecodeIdx: 378
/* 159 */     MCD::OPC_FilterValue, 31, 11, 0, // Skip to: 174
/* 163 */     MCD::OPC_CheckPredicateOrFail, 92, 
/* 165 */     MCD::OPC_CheckFieldOrFail, 6, 10, 0, 
/* 169 */     MCD::OPC_Decode, 150, 12, 250, 2, // Opcode: DUDIV, DecodeIdx: 378
/* 174 */     MCD::OPC_FilterValue, 44, 10, 0, // Skip to: 188
/* 178 */     MCD::OPC_CheckPredicateOrFail, 91, 
/* 180 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 184 */     MCD::OPC_Decode, 147, 11, 23, // Opcode: DADD, DecodeIdx: 23
/* 188 */     MCD::OPC_FilterValue, 45, 10, 0, // Skip to: 202
/* 192 */     MCD::OPC_CheckPredicateOrFail, 91, 
/* 194 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 198 */     MCD::OPC_Decode, 150, 11, 23, // Opcode: DADDu, DecodeIdx: 23
/* 202 */     MCD::OPC_FilterValue, 46, 10, 0, // Skip to: 216
/* 206 */     MCD::OPC_CheckPredicateOrFail, 91, 
/* 208 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 212 */     MCD::OPC_Decode, 148, 12, 23, // Opcode: DSUB, DecodeIdx: 23
/* 216 */     MCD::OPC_FilterValue, 47, 10, 0, // Skip to: 230
/* 220 */     MCD::OPC_CheckPredicateOrFail, 91, 
/* 222 */     MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 226 */     MCD::OPC_Decode, 149, 12, 23, // Opcode: DSUBu, DecodeIdx: 23
/* 230 */     MCD::OPC_FilterValue, 56, 11, 0, // Skip to: 245
/* 234 */     MCD::OPC_CheckPredicateOrFail, 91, 
/* 236 */     MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 240 */     MCD::OPC_Decode, 138, 12, 251, 2, // Opcode: DSLL, DecodeIdx: 379
/* 245 */     MCD::OPC_FilterValue, 58, 23, 0, // Skip to: 272
/* 249 */     MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 252 */     MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 263
/* 256 */     MCD::OPC_CheckPredicateOrFail, 91, 
/* 258 */     MCD::OPC_Decode, 145, 12, 251, 2, // Opcode: DSRL, DecodeIdx: 379
/* 263 */     MCD::OPC_FilterValueOrFail, 1, 
/* 265 */     MCD::OPC_CheckPredicateOrFail, 90, 
/* 267 */     MCD::OPC_Decode, 132, 12, 251, 2, // Opcode: DROTR, DecodeIdx: 379
/* 272 */     MCD::OPC_FilterValue, 59, 11, 0, // Skip to: 287
/* 276 */     MCD::OPC_CheckPredicateOrFail, 91, 
/* 278 */     MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 282 */     MCD::OPC_Decode, 142, 12, 251, 2, // Opcode: DSRA, DecodeIdx: 379
/* 287 */     MCD::OPC_FilterValue, 60, 11, 0, // Skip to: 302
/* 291 */     MCD::OPC_CheckPredicateOrFail, 91, 
/* 293 */     MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 297 */     MCD::OPC_Decode, 139, 12, 251, 2, // Opcode: DSLL32, DecodeIdx: 379
/* 302 */     MCD::OPC_FilterValue, 62, 23, 0, // Skip to: 329
/* 306 */     MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 309 */     MCD::OPC_FilterValue, 0, 7, 0, // Skip to: 320
/* 313 */     MCD::OPC_CheckPredicateOrFail, 91, 
/* 315 */     MCD::OPC_Decode, 146, 12, 251, 2, // Opcode: DSRL32, DecodeIdx: 379
/* 320 */     MCD::OPC_FilterValueOrFail, 1, 
/* 322 */     MCD::OPC_CheckPredicateOrFail, 90, 
/* 324 */     MCD::OPC_Decode, 133, 12, 251, 2, // Opcode: DROTR32, DecodeIdx: 379
/* 329 */     MCD::OPC_FilterValueOrFail, 63, 
/* 331 */     MCD::OPC_CheckPredicateOrFail, 91, 
/* 333 */     MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 337 */     MCD::OPC_Decode, 143, 12, 251, 2, // Opcode: DSRA32, DecodeIdx: 379
/* 342 */     MCD::OPC_FilterValue, 16, 58, 0, // Skip to: 404
/* 346 */     MCD::OPC_ExtractField, 3, 8,  // Inst{10-3} ...
/* 349 */     MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 376
/* 353 */     MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 356 */     MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 367
/* 360 */     MCD::OPC_CheckPredicateOrFail, 93, 
/* 362 */     MCD::OPC_Decode, 189, 11, 252, 2, // Opcode: DMFC0, DecodeIdx: 380
/* 367 */     MCD::OPC_FilterValueOrFail, 5, 
/* 369 */     MCD::OPC_CheckPredicateOrFail, 93, 
/* 371 */     MCD::OPC_Decode, 197, 11, 253, 2, // Opcode: DMTC0, DecodeIdx: 381
/* 376 */     MCD::OPC_FilterValue, 32, 11, 0, // Skip to: 391
/* 380 */     MCD::OPC_CheckPredicateOrFail, 94, 
/* 382 */     MCD::OPC_CheckFieldOrFail, 21, 5, 3, 
/* 386 */     MCD::OPC_Decode, 193, 11, 252, 2, // Opcode: DMFGC0, DecodeIdx: 380
/* 391 */     MCD::OPC_FilterValueOrFail, 96, 
/* 393 */     MCD::OPC_CheckPredicateOrFail, 94, 
/* 395 */     MCD::OPC_CheckFieldOrFail, 21, 5, 3, 
/* 399 */     MCD::OPC_Decode, 201, 11, 253, 2, // Opcode: DMTGC0, DecodeIdx: 381
/* 404 */     MCD::OPC_FilterValue, 18, 31, 0, // Skip to: 439
/* 408 */     MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 411 */     MCD::OPC_FilterValue, 1, 11, 0, // Skip to: 426
/* 415 */     MCD::OPC_CheckPredicateOrFail, 93, 
/* 417 */     MCD::OPC_CheckFieldOrFail, 3, 8, 0, 
/* 421 */     MCD::OPC_Decode, 191, 11, 254, 2, // Opcode: DMFC2, DecodeIdx: 382
/* 426 */     MCD::OPC_FilterValueOrFail, 5, 
/* 428 */     MCD::OPC_CheckPredicateOrFail, 93, 
/* 430 */     MCD::OPC_CheckFieldOrFail, 3, 8, 0, 
/* 434 */     MCD::OPC_Decode, 199, 11, 255, 2, // Opcode: DMTC2, DecodeIdx: 383
/* 439 */     MCD::OPC_FilterValue, 21, 193, 0, // Skip to: 636
/* 443 */     MCD::OPC_ExtractField, 0, 13,  // Inst{12-0} ...
/* 446 */     MCD::OPC_FilterValue, 188, 8, 7, 0, // Skip to: 458
/* 451 */     MCD::OPC_CheckPredicateOrFail, 15, 
/* 453 */     MCD::OPC_Decode, 185, 10, 128, 3, // Opcode: C_F_D64_MM, DecodeIdx: 384
/* 458 */     MCD::OPC_FilterValue, 252, 8, 7, 0, // Skip to: 470
/* 463 */     MCD::OPC_CheckPredicateOrFail, 15, 
/* 465 */     MCD::OPC_Decode, 141, 11, 128, 3, // Opcode: C_UN_D64_MM, DecodeIdx: 384
/* 470 */     MCD::OPC_FilterValue, 188, 9, 7, 0, // Skip to: 482
/* 475 */     MCD::OPC_CheckPredicateOrFail, 15, 
/* 477 */     MCD::OPC_Decode, 179, 10, 128, 3, // Opcode: C_EQ_D64_MM, DecodeIdx: 384
/* 482 */     MCD::OPC_FilterValue, 252, 9, 7, 0, // Skip to: 494
/* 487 */     MCD::OPC_CheckPredicateOrFail, 15, 
/* 489 */     MCD::OPC_Decode, 251, 10, 128, 3, // Opcode: C_UEQ_D64_MM, DecodeIdx: 384
/* 494 */     MCD::OPC_FilterValue, 188, 10, 7, 0, // Skip to: 506
/* 499 */     MCD::OPC_CheckPredicateOrFail, 15, 
/* 501 */     MCD::OPC_Decode, 233, 10, 128, 3, // Opcode: C_OLT_D64_MM, DecodeIdx: 384
/* 506 */     MCD::OPC_FilterValue, 252, 10, 7, 0, // Skip to: 518
/* 511 */     MCD::OPC_CheckPredicateOrFail, 15, 
/* 513 */     MCD::OPC_Decode, 135, 11, 128, 3, // Opcode: C_ULT_D64_MM, DecodeIdx: 384
/* 518 */     MCD::OPC_FilterValue, 188, 11, 7, 0, // Skip to: 530
/* 523 */     MCD::OPC_CheckPredicateOrFail, 15, 
/* 525 */     MCD::OPC_Decode, 227, 10, 128, 3, // Opcode: C_OLE_D64_MM, DecodeIdx: 384
/* 530 */     MCD::OPC_FilterValue, 252, 11, 7, 0, // Skip to: 542
/* 535 */     MCD::OPC_CheckPredicateOrFail, 15, 
/* 537 */     MCD::OPC_Decode, 129, 11, 128, 3, // Opcode: C_ULE_D64_MM, DecodeIdx: 384
/* 542 */     MCD::OPC_FilterValue, 188, 12, 7, 0, // Skip to: 554
/* 547 */     MCD::OPC_CheckPredicateOrFail, 15, 
/* 549 */     MCD::OPC_Decode, 245, 10, 128, 3, // Opcode: C_SF_D64_MM, DecodeIdx: 384
/* 554 */     MCD::OPC_FilterValue, 252, 12, 7, 0, // Skip to: 566
/* 559 */     MCD::OPC_CheckPredicateOrFail, 15, 
/* 561 */     MCD::OPC_Decode, 209, 10, 128, 3, // Opcode: C_NGLE_D64_MM, DecodeIdx: 384
/* 566 */     MCD::OPC_FilterValue, 188, 13, 7, 0, // Skip to: 578
/* 571 */     MCD::OPC_CheckPredicateOrFail, 15, 
/* 573 */     MCD::OPC_Decode, 239, 10, 128, 3, // Opcode: C_SEQ_D64_MM, DecodeIdx: 384
/* 578 */     MCD::OPC_FilterValue, 252, 13, 7, 0, // Skip to: 590
/* 583 */     MCD::OPC_CheckPredicateOrFail, 15, 
/* 585 */     MCD::OPC_Decode, 215, 10, 128, 3, // Opcode: C_NGL_D64_MM, DecodeIdx: 384
/* 590 */     MCD::OPC_FilterValue, 188, 14, 7, 0, // Skip to: 602
/* 595 */     MCD::OPC_CheckPredicateOrFail, 15, 
/* 597 */     MCD::OPC_Decode, 197, 10, 128, 3, // Opcode: C_LT_D64_MM, DecodeIdx: 384
/* 602 */     MCD::OPC_FilterValue, 252, 14, 7, 0, // Skip to: 614
/* 607 */     MCD::OPC_CheckPredicateOrFail, 15, 
/* 609 */     MCD::OPC_Decode, 203, 10, 128, 3, // Opcode: C_NGE_D64_MM, DecodeIdx: 384
/* 614 */     MCD::OPC_FilterValue, 188, 15, 7, 0, // Skip to: 626
/* 619 */     MCD::OPC_CheckPredicateOrFail, 15, 
/* 621 */     MCD::OPC_Decode, 191, 10, 128, 3, // Opcode: C_LE_D64_MM, DecodeIdx: 384
/* 626 */     MCD::OPC_FilterValueOrFail, 252, 15, 
/* 629 */     MCD::OPC_CheckPredicateOrFail, 15, 
/* 631 */     MCD::OPC_Decode, 221, 10, 128, 3, // Opcode: C_NGT_D64_MM, DecodeIdx: 384
/* 636 */     MCD::OPC_FilterValue, 24, 7, 0, // Skip to: 647
/* 640 */     MCD::OPC_CheckPredicateOrFail, 95, 
/* 642 */     MCD::OPC_Decode, 148, 11, 129, 3, // Opcode: DADDi, DecodeIdx: 385
/* 647 */     MCD::OPC_FilterValue, 25, 7, 0, // Skip to: 658
/* 651 */     MCD::OPC_CheckPredicateOrFail, 91, 
/* 653 */     MCD::OPC_Decode, 149, 11, 129, 3, // Opcode: DADDiu, DecodeIdx: 385
/* 658 */     MCD::OPC_FilterValue, 26, 7, 0, // Skip to: 669
/* 662 */     MCD::OPC_CheckPredicateOrFail, 95, 
/* 664 */     MCD::OPC_Decode, 243, 14, 141, 1, // Opcode: LDL, DecodeIdx: 141
/* 669 */     MCD::OPC_FilterValue, 27, 7, 0, // Skip to: 680
/* 673 */     MCD::OPC_CheckPredicateOrFail, 95, 
/* 675 */     MCD::OPC_Decode, 245, 14, 141, 1, // Opcode: LDR, DecodeIdx: 141
/* 680 */     MCD::OPC_FilterValue, 28, 23, 0, // Skip to: 707
/* 684 */     MCD::OPC_ExtractField, 0, 11,  // Inst{10-0} ...
/* 687 */     MCD::OPC_FilterValue, 36, 7, 0, // Skip to: 698
/* 691 */     MCD::OPC_CheckPredicateOrFail, 96, 
/* 693 */     MCD::OPC_Decode, 158, 11, 130, 3, // Opcode: DCLZ, DecodeIdx: 386
/* 698 */     MCD::OPC_FilterValueOrFail, 37, 
/* 700 */     MCD::OPC_CheckPredicateOrFail, 96, 
/* 702 */     MCD::OPC_Decode, 156, 11, 130, 3, // Opcode: DCLO, DecodeIdx: 386
/* 707 */     MCD::OPC_FilterValue, 31, 102, 0, // Skip to: 813
/* 711 */     MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 714 */     MCD::OPC_FilterValue, 1, 7, 0, // Skip to: 725
/* 718 */     MCD::OPC_CheckPredicateOrFail, 90, 
/* 720 */     MCD::OPC_Decode, 167, 11, 131, 3, // Opcode: DEXTM, DecodeIdx: 387
/* 725 */     MCD::OPC_FilterValue, 2, 7, 0, // Skip to: 736
/* 729 */     MCD::OPC_CheckPredicateOrFail, 90, 
/* 731 */     MCD::OPC_Decode, 168, 11, 131, 3, // Opcode: DEXTU, DecodeIdx: 387
/* 736 */     MCD::OPC_FilterValue, 3, 7, 0, // Skip to: 747
/* 740 */     MCD::OPC_CheckPredicateOrFail, 90, 
/* 742 */     MCD::OPC_Decode, 165, 11, 131, 3, // Opcode: DEXT, DecodeIdx: 387
/* 747 */     MCD::OPC_FilterValue, 5, 7, 0, // Skip to: 758
/* 751 */     MCD::OPC_CheckPredicateOrFail, 90, 
/* 753 */     MCD::OPC_Decode, 171, 11, 132, 3, // Opcode: DINSM, DecodeIdx: 388
/* 758 */     MCD::OPC_FilterValue, 6, 7, 0, // Skip to: 769
/* 762 */     MCD::OPC_CheckPredicateOrFail, 90, 
/* 764 */     MCD::OPC_Decode, 172, 11, 132, 3, // Opcode: DINSU, DecodeIdx: 388
/* 769 */     MCD::OPC_FilterValue, 7, 7, 0, // Skip to: 780
/* 773 */     MCD::OPC_CheckPredicateOrFail, 90, 
/* 775 */     MCD::OPC_Decode, 170, 11, 132, 3, // Opcode: DINS, DecodeIdx: 388
/* 780 */     MCD::OPC_FilterValueOrFail, 36, 
/* 782 */     MCD::OPC_ExtractField, 6, 5,  // Inst{10-6} ...
/* 785 */     MCD::OPC_FilterValue, 2, 11, 0, // Skip to: 800
/* 789 */     MCD::OPC_CheckPredicateOrFail, 90, 
/* 791 */     MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 795 */     MCD::OPC_Decode, 135, 12, 241, 2, // Opcode: DSBH, DecodeIdx: 369
/* 800 */     MCD::OPC_FilterValueOrFail, 5, 
/* 802 */     MCD::OPC_CheckPredicateOrFail, 90, 
/* 804 */     MCD::OPC_CheckFieldOrFail, 21, 5, 0, 
/* 808 */     MCD::OPC_Decode, 137, 12, 241, 2, // Opcode: DSHD, DecodeIdx: 369
/* 813 */     MCD::OPC_FilterValue, 39, 7, 0, // Skip to: 824
/* 817 */     MCD::OPC_CheckPredicateOrFail, 91, 
/* 819 */     MCD::OPC_Decode, 202, 15, 141, 1, // Opcode: LWu, DecodeIdx: 141
/* 824 */     MCD::OPC_FilterValue, 44, 7, 0, // Skip to: 835
/* 828 */     MCD::OPC_CheckPredicateOrFail, 95, 
/* 830 */     MCD::OPC_Decode, 206, 19, 141, 1, // Opcode: SDL, DecodeIdx: 141
/* 835 */     MCD::OPC_FilterValue, 45, 7, 0, // Skip to: 846
/* 839 */     MCD::OPC_CheckPredicateOrFail, 95, 
/* 841 */     MCD::OPC_Decode, 207, 19, 141, 1, // Opcode: SDR, DecodeIdx: 141
/* 846 */     MCD::OPC_FilterValue, 46, 7, 0, // Skip to: 857
/* 850 */     MCD::OPC_CheckPredicateOrFail, 20, 
/* 852 */     MCD::OPC_Decode, 199, 19, 139, 1, // Opcode: SDC1_MM_D64, DecodeIdx: 139
/* 857 */     MCD::OPC_FilterValue, 47, 7, 0, // Skip to: 868
/* 861 */     MCD::OPC_CheckPredicateOrFail, 20, 
/* 863 */     MCD::OPC_Decode, 234, 14, 139, 1, // Opcode: LDC1_MM_D64, DecodeIdx: 139
/* 868 */     MCD::OPC_FilterValue, 52, 7, 0, // Skip to: 879
/* 872 */     MCD::OPC_CheckPredicateOrFail, 92, 
/* 874 */     MCD::OPC_Decode, 145, 15, 141, 1, // Opcode: LLD, DecodeIdx: 141
/* 879 */     MCD::OPC_FilterValue, 55, 7, 0, // Skip to: 890
/* 883 */     MCD::OPC_CheckPredicateOrFail, 91, 
/* 885 */     MCD::OPC_Decode, 229, 14, 141, 1, // Opcode: LD, DecodeIdx: 141
/* 890 */     MCD::OPC_FilterValue, 60, 7, 0, // Skip to: 901
/* 894 */     MCD::OPC_CheckPredicateOrFail, 95, 
/* 896 */     MCD::OPC_Decode, 181, 19, 141, 1, // Opcode: SCD, DecodeIdx: 141
/* 901 */     MCD::OPC_FilterValueOrFail, 63, 
/* 903 */     MCD::OPC_CheckPredicateOrFail, 91, 
/* 905 */     MCD::OPC_Decode, 188, 19, 141, 1, // Opcode: SD, DecodeIdx: 141
/* 910 */     MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableMipsDSP32[] = {
/* 0 */       MCD::OPC_ExtractField, 26, 6,  // Inst{31-26} ...
/* 3 */       MCD::OPC_FilterValue, 35, 7, 0, // Skip to: 14
/* 7 */       MCD::OPC_CheckPredicateOrFail, 97, 
/* 9 */       MCD::OPC_Decode, 171, 15, 141, 1, // Opcode: LWDSP, DecodeIdx: 141
/* 14 */      MCD::OPC_FilterValueOrFail, 43, 
/* 16 */      MCD::OPC_CheckPredicateOrFail, 97, 
/* 18 */      MCD::OPC_Decode, 208, 21, 141, 1, // Opcode: SWDSP, DecodeIdx: 141
/* 23 */      MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableMipsFP6432[] = {
/* 0 */       MCD::OPC_ExtractField, 26, 6,  // Inst{31-26} ...
/* 3 */       MCD::OPC_FilterValue, 17, 26, 4, // Skip to: 1057
/* 7 */       MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 10 */      MCD::OPC_FilterValue, 0, 83, 0, // Skip to: 97
/* 14 */      MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 17 */      MCD::OPC_FilterValue, 0, 11, 0, // Skip to: 32
/* 21 */      MCD::OPC_CheckPredicateOrFail, 98, 
/* 23 */      MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 27 */      MCD::OPC_Decode, 150, 16, 133, 3, // Opcode: MFC1_D64, DecodeIdx: 389
/* 32 */      MCD::OPC_FilterValue, 3, 11, 0, // Skip to: 47
/* 36 */      MCD::OPC_CheckPredicateOrFail, 99, 
/* 38 */      MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 42 */      MCD::OPC_Decode, 160, 16, 133, 3, // Opcode: MFHC1_D64, DecodeIdx: 389
/* 47 */      MCD::OPC_FilterValue, 4, 11, 0, // Skip to: 62
/* 51 */      MCD::OPC_CheckPredicateOrFail, 98, 
/* 53 */      MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 57 */      MCD::OPC_Decode, 165, 17, 134, 3, // Opcode: MTC1_D64, DecodeIdx: 390
/* 62 */      MCD::OPC_FilterValue, 7, 11, 0, // Skip to: 77
/* 66 */      MCD::OPC_CheckPredicateOrFail, 99, 
/* 68 */      MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 72 */      MCD::OPC_Decode, 176, 17, 135, 3, // Opcode: MTHC1_D64, DecodeIdx: 391
/* 77 */      MCD::OPC_FilterValue, 17, 7, 0, // Skip to: 88
/* 81 */      MCD::OPC_CheckPredicateOrFail, 98, 
/* 83 */      MCD::OPC_Decode, 209, 12, 230, 2, // Opcode: FADD_D64, DecodeIdx: 358
/* 88 */      MCD::OPC_FilterValueOrFail, 22, 
/* 90 */      MCD::OPC_CheckPredicateOrFail, 100, 
/* 92 */      MCD::OPC_Decode, 211, 12, 230, 2, // Opcode: FADD_PS64, DecodeIdx: 358
/* 97 */      MCD::OPC_FilterValue, 1, 23, 0, // Skip to: 124
/* 101 */     MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 104 */     MCD::OPC_FilterValue, 17, 7, 0, // Skip to: 115
/* 108 */     MCD::OPC_CheckPredicateOrFail, 98, 
/* 110 */     MCD::OPC_Decode, 226, 13, 230, 2, // Opcode: FSUB_D64, DecodeIdx: 358
/* 115 */     MCD::OPC_FilterValueOrFail, 22, 
/* 117 */     MCD::OPC_CheckPredicateOrFail, 100, 
/* 119 */     MCD::OPC_Decode, 228, 13, 230, 2, // Opcode: FSUB_PS64, DecodeIdx: 358
/* 124 */     MCD::OPC_FilterValue, 2, 23, 0, // Skip to: 151
/* 128 */     MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 131 */     MCD::OPC_FilterValue, 17, 7, 0, // Skip to: 142
/* 135 */     MCD::OPC_CheckPredicateOrFail, 98, 
/* 137 */     MCD::OPC_Decode, 182, 13, 230, 2, // Opcode: FMUL_D64, DecodeIdx: 358
/* 142 */     MCD::OPC_FilterValueOrFail, 22, 
/* 144 */     MCD::OPC_CheckPredicateOrFail, 100, 
/* 146 */     MCD::OPC_Decode, 184, 13, 230, 2, // Opcode: FMUL_PS64, DecodeIdx: 358
/* 151 */     MCD::OPC_FilterValue, 3, 11, 0, // Skip to: 166
/* 155 */     MCD::OPC_CheckPredicateOrFail, 98, 
/* 157 */     MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 161 */     MCD::OPC_Decode, 248, 12, 230, 2, // Opcode: FDIV_D64, DecodeIdx: 358
/* 166 */     MCD::OPC_FilterValue, 4, 12, 0, // Skip to: 182
/* 170 */     MCD::OPC_CheckPredicateOrFail, 101, 
/* 172 */     MCD::OPC_CheckFieldOrFail, 16, 10, 160, 4, 
/* 177 */     MCD::OPC_Decode, 218, 13, 230, 1, // Opcode: FSQRT_D64, DecodeIdx: 230
/* 182 */     MCD::OPC_FilterValue, 5, 12, 0, // Skip to: 198
/* 186 */     MCD::OPC_CheckPredicateOrFail, 98, 
/* 188 */     MCD::OPC_CheckFieldOrFail, 16, 10, 160, 4, 
/* 193 */     MCD::OPC_Decode, 202, 12, 230, 1, // Opcode: FABS_D64, DecodeIdx: 230
/* 198 */     MCD::OPC_FilterValue, 6, 12, 0, // Skip to: 214
/* 202 */     MCD::OPC_CheckPredicateOrFail, 98, 
/* 204 */     MCD::OPC_CheckFieldOrFail, 16, 10, 160, 4, 
/* 209 */     MCD::OPC_Decode, 171, 13, 230, 1, // Opcode: FMOV_D64, DecodeIdx: 230
/* 214 */     MCD::OPC_FilterValue, 7, 12, 0, // Skip to: 230
/* 218 */     MCD::OPC_CheckPredicateOrFail, 98, 
/* 220 */     MCD::OPC_CheckFieldOrFail, 16, 10, 160, 4, 
/* 225 */     MCD::OPC_Decode, 191, 13, 230, 1, // Opcode: FNEG_D64, DecodeIdx: 230
/* 230 */     MCD::OPC_FilterValue, 8, 25, 0, // Skip to: 259
/* 234 */     MCD::OPC_ExtractField, 16, 10,  // Inst{25-16} ...
/* 237 */     MCD::OPC_FilterValue, 128, 4, 7, 0, // Skip to: 249
/* 242 */     MCD::OPC_CheckPredicateOrFail, 101, 
/* 244 */     MCD::OPC_Decode, 143, 19, 223, 1, // Opcode: ROUND_L_S, DecodeIdx: 223
/* 249 */     MCD::OPC_FilterValueOrFail, 160, 4, 
/* 252 */     MCD::OPC_CheckPredicateOrFail, 102, 
/* 254 */     MCD::OPC_Decode, 141, 19, 230, 1, // Opcode: ROUND_L_D64, DecodeIdx: 230
/* 259 */     MCD::OPC_FilterValue, 9, 25, 0, // Skip to: 288
/* 263 */     MCD::OPC_ExtractField, 16, 10,  // Inst{25-16} ...
/* 266 */     MCD::OPC_FilterValue, 128, 4, 7, 0, // Skip to: 278
/* 271 */     MCD::OPC_CheckPredicateOrFail, 101, 
/* 273 */     MCD::OPC_Decode, 182, 22, 223, 1, // Opcode: TRUNC_L_S, DecodeIdx: 223
/* 278 */     MCD::OPC_FilterValueOrFail, 160, 4, 
/* 281 */     MCD::OPC_CheckPredicateOrFail, 102, 
/* 283 */     MCD::OPC_Decode, 180, 22, 230, 1, // Opcode: TRUNC_L_D64, DecodeIdx: 230
/* 288 */     MCD::OPC_FilterValue, 10, 25, 0, // Skip to: 317
/* 292 */     MCD::OPC_ExtractField, 16, 10,  // Inst{25-16} ...
/* 295 */     MCD::OPC_FilterValue, 128, 4, 7, 0, // Skip to: 307
/* 300 */     MCD::OPC_CheckPredicateOrFail, 101, 
/* 302 */     MCD::OPC_Decode, 219, 8, 223, 1, // Opcode: CEIL_L_S, DecodeIdx: 223
/* 307 */     MCD::OPC_FilterValueOrFail, 160, 4, 
/* 310 */     MCD::OPC_CheckPredicateOrFail, 102, 
/* 312 */     MCD::OPC_Decode, 217, 8, 230, 1, // Opcode: CEIL_L_D64, DecodeIdx: 230
/* 317 */     MCD::OPC_FilterValue, 11, 25, 0, // Skip to: 346
/* 321 */     MCD::OPC_ExtractField, 16, 10,  // Inst{25-16} ...
/* 324 */     MCD::OPC_FilterValue, 128, 4, 7, 0, // Skip to: 336
/* 329 */     MCD::OPC_CheckPredicateOrFail, 101, 
/* 331 */     MCD::OPC_Decode, 150, 13, 223, 1, // Opcode: FLOOR_L_S, DecodeIdx: 223
/* 336 */     MCD::OPC_FilterValueOrFail, 160, 4, 
/* 339 */     MCD::OPC_CheckPredicateOrFail, 102, 
/* 341 */     MCD::OPC_Decode, 148, 13, 230, 1, // Opcode: FLOOR_L_D64, DecodeIdx: 230
/* 346 */     MCD::OPC_FilterValue, 12, 12, 0, // Skip to: 362
/* 350 */     MCD::OPC_CheckPredicateOrFail, 101, 
/* 352 */     MCD::OPC_CheckFieldOrFail, 16, 10, 160, 4, 
/* 357 */     MCD::OPC_Decode, 146, 19, 136, 3, // Opcode: ROUND_W_D64, DecodeIdx: 392
/* 362 */     MCD::OPC_FilterValue, 13, 12, 0, // Skip to: 378
/* 366 */     MCD::OPC_CheckPredicateOrFail, 101, 
/* 368 */     MCD::OPC_CheckFieldOrFail, 16, 10, 160, 4, 
/* 373 */     MCD::OPC_Decode, 185, 22, 136, 3, // Opcode: TRUNC_W_D64, DecodeIdx: 392
/* 378 */     MCD::OPC_FilterValue, 14, 12, 0, // Skip to: 394
/* 382 */     MCD::OPC_CheckPredicateOrFail, 101, 
/* 384 */     MCD::OPC_CheckFieldOrFail, 16, 10, 160, 4, 
/* 389 */     MCD::OPC_Decode, 222, 8, 136, 3, // Opcode: CEIL_W_D64, DecodeIdx: 392
/* 394 */     MCD::OPC_FilterValue, 15, 12, 0, // Skip to: 410
/* 398 */     MCD::OPC_CheckPredicateOrFail, 101, 
/* 400 */     MCD::OPC_CheckFieldOrFail, 16, 10, 160, 4, 
/* 405 */     MCD::OPC_Decode, 153, 13, 136, 3, // Opcode: FLOOR_W_D64, DecodeIdx: 392
/* 410 */     MCD::OPC_FilterValue, 17, 31, 0, // Skip to: 445
/* 414 */     MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 417 */     MCD::OPC_FilterValue, 0, 11, 0, // Skip to: 432
/* 421 */     MCD::OPC_CheckPredicateOrFail, 103, 
/* 423 */     MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 427 */     MCD::OPC_Decode, 227, 16, 137, 3, // Opcode: MOVF_D64, DecodeIdx: 393
/* 432 */     MCD::OPC_FilterValueOrFail, 1, 
/* 434 */     MCD::OPC_CheckPredicateOrFail, 103, 
/* 436 */     MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 440 */     MCD::OPC_Decode, 247, 16, 137, 3, // Opcode: MOVT_D64, DecodeIdx: 393
/* 445 */     MCD::OPC_FilterValue, 18, 11, 0, // Skip to: 460
/* 449 */     MCD::OPC_CheckPredicateOrFail, 103, 
/* 451 */     MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 455 */     MCD::OPC_Decode, 131, 17, 138, 3, // Opcode: MOVZ_I_D64, DecodeIdx: 394
/* 460 */     MCD::OPC_FilterValue, 19, 11, 0, // Skip to: 475
/* 464 */     MCD::OPC_CheckPredicateOrFail, 103, 
/* 466 */     MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 470 */     MCD::OPC_Decode, 239, 16, 138, 3, // Opcode: MOVN_I_D64, DecodeIdx: 394
/* 475 */     MCD::OPC_FilterValue, 21, 12, 0, // Skip to: 491
/* 479 */     MCD::OPC_CheckPredicateOrFail, 104, 
/* 481 */     MCD::OPC_CheckFieldOrFail, 16, 10, 160, 4, 
/* 486 */     MCD::OPC_Decode, 249, 18, 230, 1, // Opcode: RECIP_D64, DecodeIdx: 230
/* 491 */     MCD::OPC_FilterValue, 22, 12, 0, // Skip to: 507
/* 495 */     MCD::OPC_CheckPredicateOrFail, 104, 
/* 497 */     MCD::OPC_CheckFieldOrFail, 16, 10, 160, 4, 
/* 502 */     MCD::OPC_Decode, 154, 19, 230, 1, // Opcode: RSQRT_D64, DecodeIdx: 230
/* 507 */     MCD::OPC_FilterValue, 24, 11, 0, // Skip to: 522
/* 511 */     MCD::OPC_CheckPredicateOrFail, 105, 
/* 513 */     MCD::OPC_CheckFieldOrFail, 21, 5, 22, 
/* 517 */     MCD::OPC_Decode, 161, 6, 230, 2, // Opcode: ADDR_PS64, DecodeIdx: 358
/* 522 */     MCD::OPC_FilterValue, 26, 11, 0, // Skip to: 537
/* 526 */     MCD::OPC_CheckPredicateOrFail, 105, 
/* 528 */     MCD::OPC_CheckFieldOrFail, 21, 5, 22, 
/* 532 */     MCD::OPC_Decode, 221, 17, 230, 2, // Opcode: MULR_PS64, DecodeIdx: 358
/* 537 */     MCD::OPC_FilterValue, 32, 37, 0, // Skip to: 578
/* 541 */     MCD::OPC_ExtractField, 16, 10,  // Inst{25-16} ...
/* 544 */     MCD::OPC_FilterValue, 160, 4, 7, 0, // Skip to: 556
/* 549 */     MCD::OPC_CheckPredicateOrFail, 98, 
/* 551 */     MCD::OPC_Decode, 160, 10, 136, 3, // Opcode: CVT_S_D64, DecodeIdx: 392
/* 556 */     MCD::OPC_FilterValue, 160, 5, 7, 0, // Skip to: 568
/* 561 */     MCD::OPC_CheckPredicateOrFail, 106, 
/* 563 */     MCD::OPC_Decode, 162, 10, 136, 3, // Opcode: CVT_S_L, DecodeIdx: 392
/* 568 */     MCD::OPC_FilterValueOrFail, 192, 5, 
/* 571 */     MCD::OPC_CheckPredicateOrFail, 100, 
/* 573 */     MCD::OPC_Decode, 165, 10, 136, 3, // Opcode: CVT_S_PU64, DecodeIdx: 392
/* 578 */     MCD::OPC_FilterValue, 33, 37, 0, // Skip to: 619
/* 582 */     MCD::OPC_ExtractField, 16, 10,  // Inst{25-16} ...
/* 585 */     MCD::OPC_FilterValue, 128, 4, 7, 0, // Skip to: 597
/* 590 */     MCD::OPC_CheckPredicateOrFail, 98, 
/* 592 */     MCD::OPC_Decode, 144, 10, 223, 1, // Opcode: CVT_D64_S, DecodeIdx: 223
/* 597 */     MCD::OPC_FilterValue, 128, 5, 7, 0, // Skip to: 609
/* 602 */     MCD::OPC_CheckPredicateOrFail, 98, 
/* 604 */     MCD::OPC_Decode, 146, 10, 223, 1, // Opcode: CVT_D64_W, DecodeIdx: 223
/* 609 */     MCD::OPC_FilterValueOrFail, 160, 5, 
/* 612 */     MCD::OPC_CheckPredicateOrFail, 106, 
/* 614 */     MCD::OPC_Decode, 143, 10, 230, 1, // Opcode: CVT_D64_L, DecodeIdx: 230
/* 619 */     MCD::OPC_FilterValue, 36, 25, 0, // Skip to: 648
/* 623 */     MCD::OPC_ExtractField, 16, 10,  // Inst{25-16} ...
/* 626 */     MCD::OPC_FilterValue, 160, 4, 7, 0, // Skip to: 638
/* 631 */     MCD::OPC_CheckPredicateOrFail, 98, 
/* 633 */     MCD::OPC_Decode, 171, 10, 136, 3, // Opcode: CVT_W_D64, DecodeIdx: 392
/* 638 */     MCD::OPC_FilterValueOrFail, 192, 5, 
/* 641 */     MCD::OPC_CheckPredicateOrFail, 105, 
/* 643 */     MCD::OPC_Decode, 157, 10, 230, 1, // Opcode: CVT_PW_PS64, DecodeIdx: 230
/* 648 */     MCD::OPC_FilterValue, 38, 27, 0, // Skip to: 679
/* 652 */     MCD::OPC_ExtractField, 21, 5,  // Inst{25-21} ...
/* 655 */     MCD::OPC_FilterValue, 16, 7, 0, // Skip to: 666
/* 659 */     MCD::OPC_CheckPredicateOrFail, 100, 
/* 661 */     MCD::OPC_Decode, 156, 10, 139, 3, // Opcode: CVT_PS_S64, DecodeIdx: 395
/* 666 */     MCD::OPC_FilterValueOrFail, 20, 
/* 668 */     MCD::OPC_CheckPredicateOrFail, 105, 
/* 670 */     MCD::OPC_CheckFieldOrFail, 16, 5, 0, 
/* 674 */     MCD::OPC_Decode, 155, 10, 230, 1, // Opcode: CVT_PS_PW64, DecodeIdx: 230
/* 679 */     MCD::OPC_FilterValue, 40, 12, 0, // Skip to: 695
/* 683 */     MCD::OPC_CheckPredicateOrFail, 100, 
/* 685 */     MCD::OPC_CheckFieldOrFail, 16, 10, 192, 5, 
/* 690 */     MCD::OPC_Decode, 164, 10, 136, 3, // Opcode: CVT_S_PL64, DecodeIdx: 392
/* 695 */     MCD::OPC_FilterValue, 44, 11, 0, // Skip to: 710
/* 699 */     MCD::OPC_CheckPredicateOrFail, 100, 
/* 701 */     MCD::OPC_CheckFieldOrFail, 21, 5, 22, 
/* 705 */     MCD::OPC_Decode, 190, 18, 230, 2, // Opcode: PLL_PS64, DecodeIdx: 358
/* 710 */     MCD::OPC_FilterValue, 45, 11, 0, // Skip to: 725
/* 714 */     MCD::OPC_CheckPredicateOrFail, 100, 
/* 716 */     MCD::OPC_CheckFieldOrFail, 21, 5, 22, 
/* 720 */     MCD::OPC_Decode, 191, 18, 230, 2, // Opcode: PLU_PS64, DecodeIdx: 358
/* 725 */     MCD::OPC_FilterValue, 46, 11, 0, // Skip to: 740
/* 729 */     MCD::OPC_CheckPredicateOrFail, 100, 
/* 731 */     MCD::OPC_CheckFieldOrFail, 21, 5, 22, 
/* 735 */     MCD::OPC_Decode, 236, 18, 230, 2, // Opcode: PUL_PS64, DecodeIdx: 358
/* 740 */     MCD::OPC_FilterValue, 47, 11, 0, // Skip to: 755
/* 744 */     MCD::OPC_CheckPredicateOrFail, 100, 
/* 746 */     MCD::OPC_CheckFieldOrFail, 21, 5, 22, 
/* 750 */     MCD::OPC_Decode, 237, 18, 230, 2, // Opcode: PUU_PS64, DecodeIdx: 358
/* 755 */     MCD::OPC_FilterValue, 48, 15, 0, // Skip to: 774
/* 759 */     MCD::OPC_CheckPredicateOrFail, 107, 
/* 761 */     MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 765 */     MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 769 */     MCD::OPC_Decode, 184, 10, 140, 3, // Opcode: C_F_D64, DecodeIdx: 396
/* 774 */     MCD::OPC_FilterValue, 49, 15, 0, // Skip to: 793
/* 778 */     MCD::OPC_CheckPredicateOrFail, 107, 
/* 780 */     MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 784 */     MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 788 */     MCD::OPC_Decode, 140, 11, 140, 3, // Opcode: C_UN_D64, DecodeIdx: 396
/* 793 */     MCD::OPC_FilterValue, 50, 15, 0, // Skip to: 812
/* 797 */     MCD::OPC_CheckPredicateOrFail, 107, 
/* 799 */     MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 803 */     MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 807 */     MCD::OPC_Decode, 178, 10, 140, 3, // Opcode: C_EQ_D64, DecodeIdx: 396
/* 812 */     MCD::OPC_FilterValue, 51, 15, 0, // Skip to: 831
/* 816 */     MCD::OPC_CheckPredicateOrFail, 107, 
/* 818 */     MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 822 */     MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 826 */     MCD::OPC_Decode, 250, 10, 140, 3, // Opcode: C_UEQ_D64, DecodeIdx: 396
/* 831 */     MCD::OPC_FilterValue, 52, 15, 0, // Skip to: 850
/* 835 */     MCD::OPC_CheckPredicateOrFail, 107, 
/* 837 */     MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 841 */     MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 845 */     MCD::OPC_Decode, 232, 10, 140, 3, // Opcode: C_OLT_D64, DecodeIdx: 396
/* 850 */     MCD::OPC_FilterValue, 53, 15, 0, // Skip to: 869
/* 854 */     MCD::OPC_CheckPredicateOrFail, 107, 
/* 856 */     MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 860 */     MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 864 */     MCD::OPC_Decode, 134, 11, 140, 3, // Opcode: C_ULT_D64, DecodeIdx: 396
/* 869 */     MCD::OPC_FilterValue, 54, 15, 0, // Skip to: 888
/* 873 */     MCD::OPC_CheckPredicateOrFail, 107, 
/* 875 */     MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 879 */     MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 883 */     MCD::OPC_Decode, 226, 10, 140, 3, // Opcode: C_OLE_D64, DecodeIdx: 396
/* 888 */     MCD::OPC_FilterValue, 55, 15, 0, // Skip to: 907
/* 892 */     MCD::OPC_CheckPredicateOrFail, 107, 
/* 894 */     MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 898 */     MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 902 */     MCD::OPC_Decode, 128, 11, 140, 3, // Opcode: C_ULE_D64, DecodeIdx: 396
/* 907 */     MCD::OPC_FilterValue, 56, 15, 0, // Skip to: 926
/* 911 */     MCD::OPC_CheckPredicateOrFail, 107, 
/* 913 */     MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 917 */     MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 921 */     MCD::OPC_Decode, 244, 10, 140, 3, // Opcode: C_SF_D64, DecodeIdx: 396
/* 926 */     MCD::OPC_FilterValue, 57, 15, 0, // Skip to: 945
/* 930 */     MCD::OPC_CheckPredicateOrFail, 107, 
/* 932 */     MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 936 */     MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 940 */     MCD::OPC_Decode, 208, 10, 140, 3, // Opcode: C_NGLE_D64, DecodeIdx: 396
/* 945 */     MCD::OPC_FilterValue, 58, 15, 0, // Skip to: 964
/* 949 */     MCD::OPC_CheckPredicateOrFail, 107, 
/* 951 */     MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 955 */     MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 959 */     MCD::OPC_Decode, 238, 10, 140, 3, // Opcode: C_SEQ_D64, DecodeIdx: 396
/* 964 */     MCD::OPC_FilterValue, 59, 15, 0, // Skip to: 983
/* 968 */     MCD::OPC_CheckPredicateOrFail, 107, 
/* 970 */     MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 974 */     MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 978 */     MCD::OPC_Decode, 214, 10, 140, 3, // Opcode: C_NGL_D64, DecodeIdx: 396
/* 983 */     MCD::OPC_FilterValue, 60, 15, 0, // Skip to: 1002
/* 987 */     MCD::OPC_CheckPredicateOrFail, 107, 
/* 989 */     MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 993 */     MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 997 */     MCD::OPC_Decode, 196, 10, 140, 3, // Opcode: C_LT_D64, DecodeIdx: 396
/* 1002 */    MCD::OPC_FilterValue, 61, 15, 0, // Skip to: 1021
/* 1006 */    MCD::OPC_CheckPredicateOrFail, 107, 
/* 1008 */    MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 1012 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 1016 */    MCD::OPC_Decode, 202, 10, 140, 3, // Opcode: C_NGE_D64, DecodeIdx: 396
/* 1021 */    MCD::OPC_FilterValue, 62, 15, 0, // Skip to: 1040
/* 1025 */    MCD::OPC_CheckPredicateOrFail, 107, 
/* 1027 */    MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 1031 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 1035 */    MCD::OPC_Decode, 190, 10, 140, 3, // Opcode: C_LE_D64, DecodeIdx: 396
/* 1040 */    MCD::OPC_FilterValueOrFail, 63, 
/* 1042 */    MCD::OPC_CheckPredicateOrFail, 107, 
/* 1044 */    MCD::OPC_CheckFieldOrFail, 21, 5, 17, 
/* 1048 */    MCD::OPC_CheckFieldOrFail, 6, 2, 0, 
/* 1052 */    MCD::OPC_Decode, 220, 10, 140, 3, // Opcode: C_NGT_D64, DecodeIdx: 396
/* 1057 */    MCD::OPC_FilterValue, 19, 105, 0, // Skip to: 1166
/* 1061 */    MCD::OPC_ExtractField, 0, 6,  // Inst{5-0} ...
/* 1064 */    MCD::OPC_FilterValue, 1, 11, 0, // Skip to: 1079
/* 1068 */    MCD::OPC_CheckPredicateOrFail, 108, 
/* 1070 */    MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 1074 */    MCD::OPC_Decode, 247, 14, 141, 3, // Opcode: LDXC164, DecodeIdx: 397
/* 1079 */    MCD::OPC_FilterValue, 5, 11, 0, // Skip to: 1094
/* 1083 */    MCD::OPC_CheckPredicateOrFail, 109, 
/* 1085 */    MCD::OPC_CheckFieldOrFail, 11, 5, 0, 
/* 1089 */    MCD::OPC_Decode, 157, 15, 141, 3, // Opcode: LUXC164, DecodeIdx: 397
/* 1094 */    MCD::OPC_FilterValue, 9, 11, 0, // Skip to: 1109
/* 1098 */    MCD::OPC_CheckPredicateOrFail, 108, 
/* 1100 */    MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 1104 */    MCD::OPC_Decode, 209, 19, 142, 3, // Opcode: SDXC164, DecodeIdx: 398
/* 1109 */    MCD::OPC_FilterValue, 13, 11, 0, // Skip to: 1124
/* 1113 */    MCD::OPC_CheckPredicateOrFail, 109, 
/* 1115 */    MCD::OPC_CheckFieldOrFail, 6, 5, 0, 
/* 1119 */    MCD::OPC_Decode, 196, 21, 142, 3, // Opcode: SUXC164, DecodeIdx: 398
/* 1124 */    MCD::OPC_FilterValue, 33, 7, 0, // Skip to: 1135
/* 1128 */    MCD::OPC_CheckPredicateOrFail, 110, 
/* 1130 */    MCD::OPC_Decode, 231, 15, 143, 3, // Opcode: MADD_D64, DecodeIdx: 399
/* 1135 */    MCD::OPC_FilterValue, 41, 7, 0, // Skip to: 1146
/* 1139 */    MCD::OPC_CheckPredicateOrFail, 110, 
/* 1141 */    MCD::OPC_Decode, 154, 17, 143, 3, // Opcode: MSUB_D64, DecodeIdx: 399
/* 1146 */    MCD::OPC_FilterValue, 49, 7, 0, // Skip to: 1157
/* 1150 */    MCD::OPC_CheckPredicateOrFail, 111, 
/* 1152 */    MCD::OPC_Decode, 138, 18, 143, 3, // Opcode: NMADD_D64, DecodeIdx: 399
/* 1157 */    MCD::OPC_FilterValueOrFail, 57, 
/* 1159 */    MCD::OPC_CheckPredicateOrFail, 111, 
/* 1161 */    MCD::OPC_Decode, 143, 18, 143, 3, // Opcode: NMSUB_D64, DecodeIdx: 399
/* 1166 */    MCD::OPC_FilterValue, 53, 7, 0, // Skip to: 1177
/* 1170 */    MCD::OPC_CheckPredicateOrFail, 101, 
/* 1172 */    MCD::OPC_Decode, 231, 14, 219, 2, // Opcode: LDC164, DecodeIdx: 347
/* 1177 */    MCD::OPC_FilterValueOrFail, 61, 
/* 1179 */    MCD::OPC_CheckPredicateOrFail, 101, 
/* 1181 */    MCD::OPC_Decode, 196, 19, 219, 2, // Opcode: SDC164, DecodeIdx: 347
/* 1186 */    MCD::OPC_Fail,
  0
};

static bool checkDecoderPredicate(unsigned Idx, const FeatureBitset &Bits) {
  switch (Idx) {
  default: llvm_unreachable("Invalid index!");
  case 0:
    return (Bits[Mips::FeatureMips16]);
  case 1:
    return (!Bits[Mips::FeatureMips16] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureCnMips] && !Bits[Mips::FeatureMicroMips]);
  case 2:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips2] && !Bits[Mips::FeatureCnMips] && !Bits[Mips::FeatureMicroMips]);
  case 3:
    return (Bits[Mips::FeatureCnMips]);
  case 4:
    return (Bits[Mips::FeatureMips64] && Bits[Mips::FeatureCnMips] && !Bits[Mips::FeatureMicroMips]);
  case 5:
    return (Bits[Mips::FeatureCnMipsP]);
  case 6:
    return (Bits[Mips::FeatureMicroMips] && !Bits[Mips::FeatureMips32r6]);
  case 7:
    return (Bits[Mips::FeatureMicroMips]);
  case 8:
    return (Bits[Mips::FeatureMicroMips] && Bits[Mips::FeatureDSP]);
  case 9:
    return (Bits[Mips::FeatureMicroMips] && Bits[Mips::FeatureDSPR2]);
  case 10:
    return (Bits[Mips::FeatureMicroMips] && Bits[Mips::FeatureMips32r5] && Bits[Mips::FeatureVirt]);
  case 11:
    return (Bits[Mips::FeatureMicroMips] && Bits[Mips::FeatureDSPR3]);
  case 12:
    return (Bits[Mips::FeatureMicroMips] && !Bits[Mips::FeatureMips32r6] && Bits[Mips::FeatureDSP]);
  case 13:
    return (Bits[Mips::FeatureMicroMips] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureSoftFloat]);
  case 14:
    return (Bits[Mips::FeatureMicroMips] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureNoMadd4]);
  case 15:
    return (Bits[Mips::FeatureMicroMips] && Bits[Mips::FeatureFP64Bit] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureSoftFloat]);
  case 16:
    return (Bits[Mips::FeatureMicroMips] && !Bits[Mips::FeatureFP64Bit] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureNoMadd4]);
  case 17:
    return (Bits[Mips::FeatureMicroMips] && !Bits[Mips::FeatureFP64Bit] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureSoftFloat]);
  case 18:
    return (Bits[Mips::FeatureMicroMips] && !Bits[Mips::FeatureFP64Bit] && !Bits[Mips::FeatureSoftFloat]);
  case 19:
    return (Bits[Mips::FeatureMicroMips] && !Bits[Mips::FeatureSoftFloat]);
  case 20:
    return (Bits[Mips::FeatureMicroMips] && Bits[Mips::FeatureFP64Bit] && !Bits[Mips::FeatureSoftFloat]);
  case 21:
    return (Bits[Mips::FeatureMicroMips] && Bits[Mips::FeatureEVA]);
  case 22:
    return (Bits[Mips::FeatureMicroMips] && !Bits[Mips::FeatureMips32r6] && Bits[Mips::FeatureEVA]);
  case 23:
    return (Bits[Mips::FeatureMicroMips] && Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureSoftFloat]);
  case 24:
    return (Bits[Mips::FeatureMicroMips] && Bits[Mips::FeatureMips32r6]);
  case 25:
    return (Bits[Mips::FeatureMicroMips] && Bits[Mips::FeatureMips32r6] && Bits[Mips::FeatureGINV]);
  case 26:
    return (Bits[Mips::FeatureMicroMips] && Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureSoftFloat]);
  case 27:
    return (!Bits[Mips::FeatureMips16] && !Bits[Mips::FeatureMicroMips]);
  case 28:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips32r2] && !Bits[Mips::FeatureMicroMips]);
  case 29:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips4_32] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 30:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMSA]);
  case 31:
    return (!Bits[Mips::FeatureMips16] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureMicroMips]);
  case 32:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips32r2] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6]);
  case 33:
    return (!Bits[Mips::FeatureMips16] && !Bits[Mips::FeatureMicroMips] && !Bits[Mips::FeatureUseIndirectJumpsHazard]);
  case 34:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips32]);
  case 35:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips4_32] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureMicroMips]);
  case 36:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips2] && !Bits[Mips::FeatureMicroMips]);
  case 37:
    return (Bits[Mips::FeatureDSP]);
  case 38:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMSA] && Bits[Mips::FeatureMips64]);
  case 39:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips2] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureMicroMips]);
  case 40:
    return (Bits[Mips::FeatureDSP] && !Bits[Mips::FeatureMicroMips]);
  case 41:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips32r5] && Bits[Mips::FeatureVirt] && !Bits[Mips::FeatureMicroMips]);
  case 42:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMT] && !Bits[Mips::FeatureMicroMips]);
  case 43:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips3_32] && !Bits[Mips::FeatureMicroMips]);
  case 44:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips32r2] && Bits[Mips::FeatureEVA] && !Bits[Mips::FeatureMicroMips]);
  case 45:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips32r5] && !Bits[Mips::FeatureMicroMips]);
  case 46:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips32] && !Bits[Mips::FeatureMicroMips]);
  case 47:
    return (!Bits[Mips::FeatureMips16] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 48:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips3] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 49:
    return (!Bits[Mips::FeatureMips16] && !Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips32r2] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 50:
    return (!Bits[Mips::FeatureMips16] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 51:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips2] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 52:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips2] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 53:
    return (!Bits[Mips::FeatureMips16] && !Bits[Mips::FeatureSoftFloat]);
  case 54:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips4_32r2] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 55:
    return (!Bits[Mips::FeatureMips16] && !Bits[Mips::FeatureFP64Bit] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 56:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips3_32r2] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 57:
    return (!Bits[Mips::FeatureMips16] && !Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips2] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 58:
    return (!Bits[Mips::FeatureMips16] && !Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips4_32] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 59:
    return (!Bits[Mips::FeatureMips16] && !Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips4_32r2] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 60:
    return (!Bits[Mips::FeatureMips16] && !Bits[Mips::FeatureFP64Bit] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 61:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips4_32r2] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureSoftFloat]);
  case 62:
    return (!Bits[Mips::FeatureMips16] && !Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips4_32r2] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 63:
    return (!Bits[Mips::FeatureMips16] && !Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips5_32r2] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 64:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips4_32r2] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips] && !Bits[Mips::FeatureNoMadd4]);
  case 65:
    return (!Bits[Mips::FeatureMips16] && !Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips4_32r2] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips] && !Bits[Mips::FeatureNoMadd4]);
  case 66:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips4_32r2] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureNoMadd4] && !Bits[Mips::FeatureMicroMips]);
  case 67:
    return (!Bits[Mips::FeatureMips16] && !Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips4_32r2] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureNoMadd4] && !Bits[Mips::FeatureMicroMips]);
  case 68:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips32] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureMicroMips]);
  case 69:
    return (Bits[Mips::FeatureDSPR2]);
  case 70:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips32r2] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && Bits[Mips::FeatureEVA] && !Bits[Mips::FeatureMicroMips]);
  case 71:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips3_32] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureMicroMips]);
  case 72:
    return (!Bits[Mips::FeatureMips16] && !Bits[Mips::FeaturePTR64Bit] && Bits[Mips::FeatureMips2] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureMicroMips]);
  case 73:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeaturePTR64Bit] && !Bits[Mips::FeatureMicroMips]);
  case 74:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeaturePTR64Bit] && Bits[Mips::FeatureMips2] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureMicroMips]);
  case 75:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips32r6]);
  case 76:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMicroMips]);
  case 77:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureMicroMips]);
  case 78:
    return (!Bits[Mips::FeatureMips16] && !Bits[Mips::FeatureGP64Bit] && Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMicroMips]);
  case 79:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 80:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips32r6] && Bits[Mips::FeatureCRC] && !Bits[Mips::FeatureMicroMips]);
  case 81:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips64r6] && Bits[Mips::FeatureCRC] && !Bits[Mips::FeatureMicroMips]);
  case 82:
    return (!Bits[Mips::FeatureMips16] && !Bits[Mips::FeaturePTR64Bit] && Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMicroMips]);
  case 83:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips32r6] && Bits[Mips::FeatureGINV] && !Bits[Mips::FeatureMicroMips]);
  case 84:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips64r6]);
  case 85:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureGP64Bit] && Bits[Mips::FeatureMips64r6]);
  case 86:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureGP64Bit] && Bits[Mips::FeatureMips32r6]);
  case 87:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeaturePTR64Bit] && Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureMicroMips]);
  case 88:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips64] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureMicroMips]);
  case 89:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeaturePTR64Bit]);
  case 90:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips64r2] && !Bits[Mips::FeatureMicroMips]);
  case 91:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips3] && !Bits[Mips::FeatureMicroMips]);
  case 92:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips3] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureMicroMips]);
  case 93:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureGP64Bit] && Bits[Mips::FeatureMips3]);
  case 94:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips64r5] && Bits[Mips::FeatureVirt]);
  case 95:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureMips3] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6]);
  case 96:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureGP64Bit] && Bits[Mips::FeatureMips64] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureMicroMips]);
  case 97:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureDSP]);
  case 98:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureFP64Bit] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 99:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips32r2] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 100:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips32r2] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 101:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips2] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 102:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips3_32] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 103:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips4_32] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 104:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips4_32r2] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 105:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips32r2] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureSoftFloat] && Bits[Mips::FeatureMips3D]);
  case 106:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips3_32r2] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 107:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureFP64Bit] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 108:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips4_32r2] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureSoftFloat]);
  case 109:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips5_32r2] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips]);
  case 110:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips4_32r2] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureMicroMips] && !Bits[Mips::FeatureNoMadd4]);
  case 111:
    return (!Bits[Mips::FeatureMips16] && Bits[Mips::FeatureFP64Bit] && Bits[Mips::FeatureMips4_32r2] && !Bits[Mips::FeatureMips32r6] && !Bits[Mips::FeatureMips64r6] && !Bits[Mips::FeatureSoftFloat] && !Bits[Mips::FeatureNoMadd4] && !Bits[Mips::FeatureMicroMips]);
  }
}

// Handling 400 cases.
template <typename InsnType>
static DecodeStatus decodeToMCInst(unsigned Idx, DecodeStatus S, InsnType insn, MCInst &MI, uint64_t Address, const MCDisassembler *Decoder, bool &DecodeComplete) {
  DecodeComplete = true;
  using TmpType = std::conditional_t<std::is_integral<InsnType>::value, InsnType, uint64_t>;
  TmpType tmp;
  switch (Idx) {
  default: llvm_unreachable("Invalid index!");
  case 0:
    tmp = fieldFromInstruction(insn, 0, 11);
    if (!Check(S, DecodeBranchTarget(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 1:
    tmp = fieldFromInstruction(insn, 8, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 8);
    if (!Check(S, DecodeBranchTarget(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 2:
    tmp = fieldFromInstruction(insn, 8, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 8);
    if (!Check(S, DecodeSImmWithOffsetAndScale<16>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 3:
    tmp = fieldFromInstruction(insn, 8, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 8);
    if (!Check(S, DecodeSImmWithOffsetAndScale<16>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 4:
    tmp = fieldFromInstruction(insn, 0, 8);
    if (!Check(S, DecodeSImmWithOffsetAndScale<16>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 5:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 3, 2), 3, 2);
    insertBits(tmp, fieldFromInstruction(insn, 5, 3), 0, 3);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 6:
    tmp = fieldFromInstruction(insn, 4, 4);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 7:
    tmp = fieldFromInstruction(insn, 8, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 8:
    tmp = fieldFromInstruction(insn, 2, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 9:
    tmp = fieldFromInstruction(insn, 8, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 10:
    return S;
  case 11:
    tmp = fieldFromInstruction(insn, 8, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 12:
    tmp = fieldFromInstruction(insn, 8, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 13:
    tmp = fieldFromInstruction(insn, 8, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 14:
    tmp = fieldFromInstruction(insn, 8, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 5), 0, 5);
    insertBits(tmp, fieldFromInstruction(insn, 16, 5), 11, 5);
    insertBits(tmp, fieldFromInstruction(insn, 21, 6), 5, 6);
    if (!Check(S, DecodeSImmWithOffsetAndScale<16>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 15:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 5), 0, 5);
    insertBits(tmp, fieldFromInstruction(insn, 16, 5), 11, 5);
    insertBits(tmp, fieldFromInstruction(insn, 21, 6), 5, 6);
    if (!Check(S, DecodeBranchTarget(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 16:
    tmp = fieldFromInstruction(insn, 8, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 5), 0, 5);
    insertBits(tmp, fieldFromInstruction(insn, 16, 5), 11, 5);
    insertBits(tmp, fieldFromInstruction(insn, 21, 6), 5, 6);
    if (!Check(S, DecodeBranchTarget(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 17:
    tmp = fieldFromInstruction(insn, 8, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 21, 1), 5, 1);
    insertBits(tmp, fieldFromInstruction(insn, 22, 5), 0, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 18:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 5), 0, 5);
    insertBits(tmp, fieldFromInstruction(insn, 16, 5), 11, 5);
    insertBits(tmp, fieldFromInstruction(insn, 21, 6), 5, 6);
    if (!Check(S, DecodeSImmWithOffsetAndScale<16>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 19:
    if (!Check(S, DecodeFIXMEInstruction(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 20:
    tmp = fieldFromInstruction(insn, 8, 3);
    if (!Check(S, DecodeCPU16RegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 5), 0, 5);
    insertBits(tmp, fieldFromInstruction(insn, 16, 5), 11, 5);
    insertBits(tmp, fieldFromInstruction(insn, 21, 6), 5, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 21:
    if (!Check(S, DecodeFMem3(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 22:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 23:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 24:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 25:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 26:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 27:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 10);
    if (!Check(S, DecodeSImmWithOffsetAndScale<10>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 28:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 11, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 29:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeBranchTarget(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 30:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 31:
    tmp = fieldFromInstruction(insn, 7, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 1, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 4, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 32:
    if (!Check(S, DecodeMemMMImm4(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 33:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 34:
    tmp = fieldFromInstruction(insn, 7, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 4, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 1, 3);
    if (!Check(S, DecodePOOL16BEncodedField(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 35:
    tmp = fieldFromInstruction(insn, 7, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 4, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 4);
    if (!Check(S, DecodeANDI16Imm(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 36:
    tmp = fieldFromInstruction(insn, 3, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 37:
    tmp = fieldFromInstruction(insn, 3, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 3, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 38:
    if (!Check(S, DecodeMemMMReglistImm4Lsl2(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 39:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 40:
    tmp = fieldFromInstruction(insn, 0, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 41:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeUImmWithOffsetAndScale<5, 0, 4>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 42:
    if (!Check(S, DecodeMemMMSPImm5Lsl2(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 43:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 1, 4);
    if (!Check(S, DecodeSImmWithOffsetAndScale<4>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 44:
    tmp = fieldFromInstruction(insn, 1, 9);
    if (!Check(S, DecodeSimm9SP(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 45:
    if (!Check(S, DecodeMemMMGPImm7Lsl2(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 46:
    tmp = fieldFromInstruction(insn, 7, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 4, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 1, 3);
    if (!Check(S, DecodeAddiur2Simm7(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 47:
    tmp = fieldFromInstruction(insn, 7, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 1, 6);
    if (!Check(S, DecodeUImmWithOffsetAndScale<6, 0, 4>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 48:
    if (!Check(S, DecodeMovePOperands(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 49:
    tmp = fieldFromInstruction(insn, 7, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 7);
    if (!Check(S, DecodeBranchTarget7MM(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 50:
    tmp = fieldFromInstruction(insn, 0, 10);
    if (!Check(S, DecodeBranchTarget10MM(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 51:
    tmp = fieldFromInstruction(insn, 7, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 7);
    if (!Check(S, DecodeLi16Imm(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 52:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 53:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 54:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 55:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 56:
    tmp = fieldFromInstruction(insn, 16, 10);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 6, 10);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 57:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeInsSize(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 58:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 59:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 60:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 61:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 62:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 63:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 64:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 65:
    tmp = fieldFromInstruction(insn, 14, 2);
    if (!Check(S, DecodeACC64DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 6);
    if (!Check(S, DecodeSImmWithOffsetAndScale<6>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 2);
    if (!Check(S, DecodeACC64DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 66:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeUImmWithOffset<5, 1>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 67:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 68:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeCOP0RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 69:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeCOP0RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 70:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 12, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 71:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 12, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 72:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 2);
    if (!Check(S, DecodeACC64DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 73:
    tmp = fieldFromInstruction(insn, 14, 2);
    if (!Check(S, DecodeHI32DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 74:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 13, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 75:
    tmp = fieldFromInstruction(insn, 14, 2);
    if (!Check(S, DecodeLO32DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 76:
    tmp = fieldFromInstruction(insn, 14, 2);
    if (!Check(S, DecodeACC64DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 2);
    if (!Check(S, DecodeACC64DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 77:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 78:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 2);
    if (!Check(S, DecodeACC64DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 79:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 80:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 81:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 82:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 83:
    tmp = fieldFromInstruction(insn, 14, 2);
    if (!Check(S, DecodeACC64DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 2);
    if (!Check(S, DecodeACC64DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 84:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 85:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeHWRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 86:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 87:
    tmp = fieldFromInstruction(insn, 16, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 88:
    tmp = fieldFromInstruction(insn, 16, 10);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 89:
    tmp = fieldFromInstruction(insn, 14, 2);
    if (!Check(S, DecodeACC64DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 90:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeCOP2RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 91:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeCOP2RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 92:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 93:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 13, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 94:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 7);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 95:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 14, 2);
    if (!Check(S, DecodeACC64DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 96:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 10);
    if (!Check(S, DecodeSImmWithOffsetAndScale<10>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 97:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeSImmWithOffsetAndScale<16>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 98:
    if (!Check(S, DecodeMemMMImm16(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 99:
    if (!Check(S, DecodeMemMMImm12(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 100:
    if (!Check(S, DecodeCacheOpMM(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 101:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeBranchTargetMM(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 102:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeSImmWithOffsetAndScale<16>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 103:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 104:
    if (!Check(S, DecodeSyncI_MM(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 105:
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeBranchTarget1SImm16(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 106:
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeBranchTargetMM(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 107:
    tmp = fieldFromInstruction(insn, 18, 3);
    if (!Check(S, DecodeFCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeBranchTargetMM(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 108:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 109:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 110:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 111:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 112:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 113:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 13, 3);
    if (!Check(S, DecodeFCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 114:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 115:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 13, 3);
    if (!Check(S, DecodeFCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 116:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 117:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 118:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 119:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 120:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 121:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 122:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 123:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 13, 3);
    if (!Check(S, DecodeFCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 124:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 125:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 126:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 127:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeCCRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 128:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 129:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 130:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeCCRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 131:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 132:
    tmp = fieldFromInstruction(insn, 13, 3);
    if (!Check(S, DecodeFCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 133:
    tmp = fieldFromInstruction(insn, 13, 3);
    if (!Check(S, DecodeFCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 134:
    if (!Check(S, DecodeMemMMImm9(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 135:
    if (!Check(S, DecodePrefeOpMM(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 136:
    if (!Check(S, DecodeJumpTargetMM(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 137:
    tmp = fieldFromInstruction(insn, 23, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 23);
    if (!Check(S, DecodeSimm23Lsl2(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 138:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeBranchTargetMM(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 139:
    if (!Check(S, DecodeFMemMMR2(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 140:
    if (!Check(S, DecodeJumpTargetXMM(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 141:
    if (!Check(S, DecodeMem(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 142:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 143:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 144:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 145:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 146:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 147:
    tmp = fieldFromInstruction(insn, 1, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 7, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 4, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 148:
    tmp = fieldFromInstruction(insn, 7, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 4, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 149:
    tmp = fieldFromInstruction(insn, 7, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 4, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 7, 3);
    if (!Check(S, DecodeGPRMM16RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 150:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 151:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeUImmWithOffsetAndScale<5, 0, 4>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 152:
    tmp = fieldFromInstruction(insn, 6, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 153:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeHWRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 154:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 9, 2);
    if (!Check(S, DecodeUImmWithOffset<2, 1>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 155:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 9, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 156:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 9, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 157:
    tmp = fieldFromInstruction(insn, 6, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 158:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 159:
    if (!Check(S, DecodeLoadByte15(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 160:
    if (!Check(S, DecodeFMemCop2MMR6(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 161:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeBranchTargetMM(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 162:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeCOP2RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeBranchTargetMM(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 163:
    if (!Check(S, DecodeSynciR6(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 164:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 165:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGRCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 166:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGRCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 167:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 168:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 169:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGRCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 170:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 171:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 172:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 173:
    if (!Check(S, DecodePOP35GroupBranchMMR6(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 174:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 19);
    if (!Check(S, DecodeSimm19Lsl2(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 175:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeSImmWithOffsetAndScale<16>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 176:
    if (!Check(S, DecodePOP37GroupBranchMMR6(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 177:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 21);
    if (!Check(S, DecodeBranchTarget21MM(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 178:
    tmp = fieldFromInstruction(insn, 0, 26);
    if (!Check(S, DecodeBranchTarget26MM(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 179:
    if (!Check(S, DecodeBlezGroupBranchMMR6(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 180:
    if (!Check(S, DecodePOP65GroupBranchMMR6(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 181:
    if (!Check(S, DecodeBgtzGroupBranchMMR6(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 182:
    if (!Check(S, DecodePOP75GroupBranchMMR6(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 183:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 184:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 3);
    if (!Check(S, DecodeFCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 185:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 2);
    if (!Check(S, DecodeUImmWithOffset<2, 1>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 186:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 187:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 188:
    tmp = fieldFromInstruction(insn, 6, 20);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 189:
    tmp = fieldFromInstruction(insn, 6, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 190:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 191:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 2);
    if (!Check(S, DecodeACC64DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 192:
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeHI32DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 193:
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeLO32DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 194:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 2);
    if (!Check(S, DecodeUImmWithOffset<2, 1>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 195:
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeACC64DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 196:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 10);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 197:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeBranchTarget(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 198:
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeBranchTarget(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 199:
    if (!Check(S, DecodeSyncI(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 200:
    if (!Check(S, DecodeJumpTarget(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 201:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeBranchTarget(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 202:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeSImmWithOffsetAndScale<16>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 203:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 204:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeCOP0RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 205:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeCOP0RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 206:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 0, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 4, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 207:
    tmp = fieldFromInstruction(insn, 11, 10);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 208:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 209:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 210:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeCCRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 211:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 212:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 213:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 214:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeCCRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 215:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 216:
    tmp = fieldFromInstruction(insn, 18, 3);
    if (!Check(S, DecodeFCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeBranchTarget(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 217:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeBranchTarget(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 218:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 219:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 220:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 3);
    if (!Check(S, DecodeFCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 221:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 222:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 223:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 224:
    tmp = fieldFromInstruction(insn, 8, 3);
    if (!Check(S, DecodeFCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 225:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 226:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 227:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 228:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 3);
    if (!Check(S, DecodeFCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 229:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 230:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 231:
    tmp = fieldFromInstruction(insn, 8, 3);
    if (!Check(S, DecodeFCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 232:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeBranchTarget(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 233:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeBranchTarget(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 234:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeBranchTarget(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 235:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeCOP2RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 236:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeCOP2RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 237:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 238:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 239:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 240:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 241:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 242:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeAFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 243:
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeACC64DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeACC64DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 244:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 11, 5), 0, 5);
    insertBits(tmp, fieldFromInstruction(insn, 16, 5), 0, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 245:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 246:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 247:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 248:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 249:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 250:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 251:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 252:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 253:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 10);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 254:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 10);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 255:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 10);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 256:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 10);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 257:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 258:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 259:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 260:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 261:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 262:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 263:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 264:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 265:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 266:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 267:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 268:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 269:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 270:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 271:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 272:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 273:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 274:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 275:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 276:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 277:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 278:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 279:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 280:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 281:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 282:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 283:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 284:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 285:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 286:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 287:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 288:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 289:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 290:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSACtrlRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 291:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 292:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 293:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 294:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 295:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSACtrlRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 296:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 297:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 298:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 299:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 300:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 301:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 302:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 303:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 304:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 305:
    if (!Check(S, DecodeINSVE_DF(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 306:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 307:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 308:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128BRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 309:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 310:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 311:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 312:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 313:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 314:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 315:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128HRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 316:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeMSA128DRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeMSA128WRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 317:
    if (!Check(S, DecodeMSA128Mem(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 318:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeUImmWithOffset<5, 1>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 319:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeInsSize(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 320:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 321:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 322:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 323:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 324:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 325:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 326:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 327:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 328:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 329:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 10);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 330:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 331:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 332:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 333:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 334:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeDSPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 335:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 336:
    if (!Check(S, DecodeMemEVA(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 337:
    if (!Check(S, DecodeCacheeOp_CacheOpR6(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 338:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 339:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeACC64DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 340:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeACC64DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 341:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 10);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 342:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 10);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 343:
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeACC64DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 20, 6);
    if (!Check(S, DecodeSImmWithOffsetAndScale<6>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeACC64DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 344:
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeACC64DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 2);
    if (!Check(S, DecodeACC64DSPRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 345:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeHWRegsRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 346:
    if (!Check(S, DecodeCacheOp(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 347:
    if (!Check(S, DecodeFMem(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 348:
    if (!Check(S, DecodeFMem2(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 349:
    if (!Check(S, DecodeDAHIDATI(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 350:
    tmp = fieldFromInstruction(insn, 0, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 351:
    if (!Check(S, DecodeBlezGroupBranch(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 352:
    if (!Check(S, DecodeBgtzGroupBranch(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 353:
    if (!Check(S, DecodeAddiGroupBranch(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 354:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeBranchTarget(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 355:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGRCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 356:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 357:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 358:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 359:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGRCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 360:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGRCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 361:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeCOP2RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeBranchTarget(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 362:
    if (!Check(S, DecodeFMemCop2R6(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 363:
    if (!Check(S, DecodeBlezlGroupBranch(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 364:
    if (!Check(S, DecodeBgtzlGroupBranch(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 365:
    if (!Check(S, DecodeDaddiGroupBranch(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 366:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 367:
    if (!Check(S, DecodeCRC(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 368:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 369:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 370:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 371:
    if (!Check(S, DecodeSpecial3LlSc(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 372:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 8, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 373:
    tmp = fieldFromInstruction(insn, 0, 26);
    if (!Check(S, DecodeBranchTarget26(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 374:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 21);
    if (!Check(S, DecodeBranchTarget21(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 375:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 18);
    if (!Check(S, DecodeSimm18Lsl3(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 376:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 21);
    if (!Check(S, DecodeBranchTarget21(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 377:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 378:
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 379:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 380:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeCOP0RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 381:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeCOP0RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 382:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeCOP2RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 383:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeCOP2RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 384:
    tmp = fieldFromInstruction(insn, 13, 3);
    if (!Check(S, DecodeFCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 385:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    if (!Check(S, DecodeSImmWithOffsetAndScale<16>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 386:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 11, 5), 0, 5);
    insertBits(tmp, fieldFromInstruction(insn, 16, 5), 0, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeGPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 387:
    if (!Check(S, DecodeDEXT(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 388:
    if (!Check(S, DecodeDINS(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 389:
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 390:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 391:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 392:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 393:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 3);
    if (!Check(S, DecodeFCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 394:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 395:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 396:
    tmp = fieldFromInstruction(insn, 8, 3);
    if (!Check(S, DecodeFCCRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 397:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 398:
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodePtrRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 399:
    tmp = fieldFromInstruction(insn, 6, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 21, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 11, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    if (!Check(S, DecodeFGR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  }
}

static unsigned decodeNumToSkip(const uint8_t *&Ptr) {
  unsigned NumToSkip = *Ptr++;
  NumToSkip |= (*Ptr++) << 8;
  return NumToSkip;
}

template <typename InsnType>
static DecodeStatus decodeInstruction(const uint8_t DecodeTable[], MCInst &MI,
                                      InsnType insn, uint64_t Address,
                                      const MCDisassembler *DisAsm,
                                      const MCSubtargetInfo &STI) {
  const FeatureBitset &Bits = STI.getFeatureBits();

  const uint8_t *Ptr = DecodeTable;
  uint64_t CurFieldValue = 0;
  DecodeStatus S = MCDisassembler::Success;
  while (true) {
    ptrdiff_t Loc = Ptr - DecodeTable;
    const uint8_t DecoderOp = *Ptr++;
    switch (DecoderOp) {
    default:
      errs() << Loc << ": Unexpected decode table opcode: "
             << (int)DecoderOp << '\n';
      return MCDisassembler::Fail;
    case MCD::OPC_ExtractField: {
      // Decode the start value.
      unsigned Start = decodeULEB128AndIncUnsafe(Ptr);
      unsigned Len = *Ptr++;
      CurFieldValue = fieldFromInstruction(insn, Start, Len);
      LLVM_DEBUG(dbgs() << Loc << ": OPC_ExtractField(" << Start << ", "
                   << Len << "): " << CurFieldValue << "\n");
      break;
    }
    case MCD::OPC_FilterValue:
    case MCD::OPC_FilterValueOrFail: {
      bool IsFail = DecoderOp == MCD::OPC_FilterValueOrFail;
      // Decode the field value.
      uint64_t Val = decodeULEB128AndIncUnsafe(Ptr);
      bool Failed = Val != CurFieldValue;
      unsigned NumToSkip = IsFail ? 0 : decodeNumToSkip(Ptr);

      // Note: Print NumToSkip even for OPC_FilterValueOrFail to simplify debug
      // prints.
      LLVM_DEBUG({
        StringRef OpName = IsFail ? "OPC_FilterValueOrFail" : "OPC_FilterValue";
        dbgs() << Loc << ": " << OpName << '(' << Val << ", " << NumToSkip
                << ") " << (Failed ? "FAIL:" : "PASS:")
                << " continuing at " << (Ptr - DecodeTable) << '\n';
      });

      // Perform the filter operation.
      if (Failed) {
        if (IsFail)
          return MCDisassembler::Fail;
        Ptr += NumToSkip;
      }
      break;
    }
    case MCD::OPC_CheckField:
    case MCD::OPC_CheckFieldOrFail: {
      bool IsFail = DecoderOp == MCD::OPC_CheckFieldOrFail;
      // Decode the start value.
      unsigned Start = decodeULEB128AndIncUnsafe(Ptr);
      unsigned Len = *Ptr;
      uint64_t FieldValue = fieldFromInstruction(insn, Start, Len);
      // Decode the field value.
      unsigned PtrLen = 0;
      uint64_t ExpectedValue = decodeULEB128(++Ptr, &PtrLen);
      Ptr += PtrLen;
      bool Failed = ExpectedValue != FieldValue;
      unsigned NumToSkip = IsFail ? 0 : decodeNumToSkip(Ptr);

      LLVM_DEBUG({
        StringRef OpName = IsFail ? "OPC_CheckFieldOrFail" : "OPC_CheckField";
        dbgs() << Loc << ": " << OpName << '(' << Start << ", " << Len << ", "
                << ExpectedValue << ", " << NumToSkip << "): FieldValue = "
                << FieldValue << ", ExpectedValue = " << ExpectedValue << ": "
                << (Failed ? "FAIL\n" : "PASS\n");
      });

      // If the actual and expected values don't match, skip or fail.
      if (Failed) {
        if (IsFail)
          return MCDisassembler::Fail;
        Ptr += NumToSkip;
      }
      break;
    }
    case MCD::OPC_CheckPredicate:
    case MCD::OPC_CheckPredicateOrFail: {
      bool IsFail = DecoderOp == MCD::OPC_CheckPredicateOrFail;
      // Decode the Predicate Index value.
      unsigned PIdx = decodeULEB128AndIncUnsafe(Ptr);
      unsigned NumToSkip = IsFail ? 0 : decodeNumToSkip(Ptr);
      // Check the predicate.
      bool Failed = !checkDecoderPredicate(PIdx, Bits);

      LLVM_DEBUG({
        StringRef OpName = IsFail ? "OPC_CheckPredicateOrFail" : "OPC_CheckPredicate";
        dbgs() << Loc << ": " << OpName << '(' << PIdx << ", " << NumToSkip
               << "): " << (Failed ? "FAIL\n" : "PASS\n");
      });

      if (Failed) {
        if (IsFail)
          return MCDisassembler::Fail;
        Ptr += NumToSkip;
      }
      break;
    }
    case MCD::OPC_Decode: {
      // Decode the Opcode value.
      unsigned Opc = decodeULEB128AndIncUnsafe(Ptr);
      unsigned DecodeIdx = decodeULEB128AndIncUnsafe(Ptr);

      MI.clear();
      MI.setOpcode(Opc);
      bool DecodeComplete;
      S = decodeToMCInst(DecodeIdx, S, insn, MI, Address, DisAsm, DecodeComplete);
      assert(DecodeComplete);

      LLVM_DEBUG(dbgs() << Loc << ": OPC_Decode: opcode " << Opc
                   << ", using decoder " << DecodeIdx << ": "
                   << (S != MCDisassembler::Fail ? "PASS\n" : "FAIL\n"));
      return S;
    }
    case MCD::OPC_Fail: {
      LLVM_DEBUG(dbgs() << Loc << ": OPC_Fail\n");
      return MCDisassembler::Fail;
    }
    }
  }
  llvm_unreachable("bogosity detected in disassembler state machine!");
}


} // namespace
