; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes="default<O3>" -S < %s  | FileCheck %s --check-prefixes=ALL,O3
; RUN: opt -passes='default<O2>' -S < %s  | FileCheck %s --check-prefixes=ALL,O2
; RUN: opt -passes='default<O1>' -S < %s  | FileCheck %s --check-prefixes=ALL,O1

; All these tests should optimize to a single comparison
; of the original argument with null. There should be no loops.

%struct.node = type { ptr, i32 }

define dso_local zeroext i1 @is_not_empty_variant1(ptr %p) {
; ALL-LABEL: @is_not_empty_variant1(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[TOBOOL_NOT3_I:%.*]] = icmp ne ptr [[P:%.*]], null
; ALL-NEXT:    ret i1 [[TOBOOL_NOT3_I]]
;
entry:
  %p.addr = alloca ptr, align 8
  store ptr %p, ptr %p.addr, align 8
  %0 = load ptr, ptr %p.addr, align 8
  %call = call i32 @count_nodes_variant1(ptr %0)
  %cmp = icmp sgt i32 %call, 0
  ret i1 %cmp
}

define internal i32 @count_nodes_variant1(ptr %p) {
entry:
  %p.addr = alloca ptr, align 8
  %size = alloca i32, align 4
  store ptr %p, ptr %p.addr, align 8
  store i32 0, ptr %size, align 4
  br label %while.cond

while.cond:
  %0 = load ptr, ptr %p.addr, align 8
  %tobool = icmp ne ptr %0, null
  br i1 %tobool, label %while.body, label %while.end

while.body:
  %1 = load ptr, ptr %p.addr, align 8
  %2 = load ptr, ptr %1, align 8
  store ptr %2, ptr %p.addr, align 8
  %3 = load i32, ptr %size, align 4
  %inc = add nsw i32 %3, 1
  store i32 %inc, ptr %size, align 4
  br label %while.cond, !llvm.loop !0

while.end:
  %4 = load i32, ptr %size, align 4
  ret i32 %4
}

define dso_local zeroext i1 @is_not_empty_variant2(ptr %p) {
; ALL-LABEL: @is_not_empty_variant2(
; ALL-NEXT:  entry:
; ALL-NEXT:    [[TOBOOL_NOT4_I:%.*]] = icmp ne ptr [[P:%.*]], null
; ALL-NEXT:    ret i1 [[TOBOOL_NOT4_I]]
;
entry:
  %p.addr = alloca ptr, align 8
  store ptr %p, ptr %p.addr, align 8
  %0 = load ptr, ptr %p.addr, align 8
  %call = call i64 @count_nodes_variant2(ptr %0)
  %cmp = icmp ugt i64 %call, 0
  ret i1 %cmp
}

define internal i64 @count_nodes_variant2(ptr %p) {
entry:
  %p.addr = alloca ptr, align 8
  %size = alloca i64, align 8
  store ptr %p, ptr %p.addr, align 8
  store i64 0, ptr %size, align 8
  br label %while.cond

while.cond:
  %0 = load ptr, ptr %p.addr, align 8
  %tobool = icmp ne ptr %0, null
  br i1 %tobool, label %while.body, label %while.end

while.body:
  %1 = load ptr, ptr %p.addr, align 8
  %2 = load ptr, ptr %1, align 8
  store ptr %2, ptr %p.addr, align 8
  %3 = load i64, ptr %size, align 8
  %inc = add i64 %3, 1
  store i64 %inc, ptr %size, align 8
  %4 = load i64, ptr %size, align 8
  %cmp = icmp ne i64 %4, 0
  call void @_ZL6assumeb(i1 zeroext %cmp)
  br label %while.cond, !llvm.loop !2

while.end:
  %5 = load i64, ptr %size, align 8
  ret i64 %5
}

define dso_local zeroext i1 @is_not_empty_variant3(ptr %p) {
; O3-LABEL: @is_not_empty_variant3(
; O3-NEXT:  entry:
; O3-NEXT:    [[TOBOOL_NOT4_I:%.*]] = icmp ne ptr [[P:%.*]], null
; O3-NEXT:    ret i1 [[TOBOOL_NOT4_I]]
;
; O2-LABEL: @is_not_empty_variant3(
; O2-NEXT:  entry:
; O2-NEXT:    [[TOBOOL_NOT4_I:%.*]] = icmp ne ptr [[P:%.*]], null
; O2-NEXT:    ret i1 [[TOBOOL_NOT4_I]]
;
; O1-LABEL: @is_not_empty_variant3(
; O1-NEXT:  entry:
; O1-NEXT:    [[TOBOOL_NOT4_I:%.*]] = icmp eq ptr [[P:%.*]], null
; O1-NEXT:    br i1 [[TOBOOL_NOT4_I]], label [[COUNT_NODES_VARIANT3_EXIT:%.*]], label [[WHILE_BODY_I:%.*]]
; O1:       while.body.i:
; O1-NEXT:    [[SIZE_06_I:%.*]] = phi i64 [ [[INC_I:%.*]], [[WHILE_BODY_I]] ], [ 0, [[ENTRY:%.*]] ]
; O1-NEXT:    [[P_ADDR_05_I:%.*]] = phi ptr [ [[TMP0:%.*]], [[WHILE_BODY_I]] ], [ [[P]], [[ENTRY]] ]
; O1-NEXT:    [[CMP_I:%.*]] = icmp ne i64 [[SIZE_06_I]], -1
; O1-NEXT:    call void @llvm.assume(i1 [[CMP_I]])
; O1-NEXT:    [[TMP0]] = load ptr, ptr [[P_ADDR_05_I]], align 8
; O1-NEXT:    [[INC_I]] = add i64 [[SIZE_06_I]], 1
; O1-NEXT:    [[TOBOOL_NOT_I:%.*]] = icmp eq ptr [[TMP0]], null
; O1-NEXT:    br i1 [[TOBOOL_NOT_I]], label [[COUNT_NODES_VARIANT3_EXIT_LOOPEXIT:%.*]], label [[WHILE_BODY_I]], !llvm.loop [[LOOP0:![0-9]+]]
; O1:       count_nodes_variant3.exit.loopexit:
; O1-NEXT:    [[PHI_CMP:%.*]] = icmp ne i64 [[INC_I]], 0
; O1-NEXT:    br label [[COUNT_NODES_VARIANT3_EXIT]]
; O1:       count_nodes_variant3.exit:
; O1-NEXT:    [[SIZE_0_LCSSA_I:%.*]] = phi i1 [ false, [[ENTRY]] ], [ [[PHI_CMP]], [[COUNT_NODES_VARIANT3_EXIT_LOOPEXIT]] ]
; O1-NEXT:    ret i1 [[SIZE_0_LCSSA_I]]
;
entry:
  %p.addr = alloca ptr, align 8
  store ptr %p, ptr %p.addr, align 8
  %0 = load ptr, ptr %p.addr, align 8
  %call = call i64 @count_nodes_variant3(ptr %0)
  %cmp = icmp ugt i64 %call, 0
  ret i1 %cmp
}

define internal i64 @count_nodes_variant3(ptr %p) {
entry:
  %p.addr = alloca ptr, align 8
  %size = alloca i64, align 8
  store ptr %p, ptr %p.addr, align 8
  store i64 0, ptr %size, align 8
  br label %while.cond

while.cond:
  %0 = load ptr, ptr %p.addr, align 8
  %tobool = icmp ne ptr %0, null
  br i1 %tobool, label %while.body, label %while.end

while.body:
  %1 = load i64, ptr %size, align 8
  %cmp = icmp ne i64 %1, -1
  call void @_ZL6assumeb(i1 zeroext %cmp)
  %2 = load ptr, ptr %p.addr, align 8
  %3 = load ptr, ptr %2, align 8
  store ptr %3, ptr %p.addr, align 8
  %4 = load i64, ptr %size, align 8
  %inc = add i64 %4, 1
  store i64 %inc, ptr %size, align 8
  br label %while.cond, !llvm.loop !3

while.end:
  %5 = load i64, ptr %size, align 8
  ret i64 %5
}

define internal void @_ZL6assumeb(i1 zeroext %expression) {
entry:
  %expression.addr = alloca i8, align 1
  %frombool = zext i1 %expression to i8
  store i8 %frombool, ptr %expression.addr, align 1
  %0 = load i8, ptr %expression.addr, align 1
  %tobool = trunc i8 %0 to i1
  call void @llvm.assume(i1 %tobool)
  ret void
}

declare void @llvm.assume(i1 noundef)

!0 = distinct !{!0, !1}
!1 = !{!"llvm.loop.mustprogress"}
!2 = distinct !{!2, !1}
!3 = distinct !{!3, !1}
