; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --prefix-filecheck-ir-name _ --version 5
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=infer-address-spaces %s | FileCheck %s

; Trivial optimization of generic addressing

define float @load_global_from_flat(ptr %generic_scalar) #0 {
; CHECK-LABEL: define float @load_global_from_flat(
; CHECK-SAME: ptr [[GENERIC_SCALAR:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[_TMP0:%.*]] = addrspacecast ptr [[GENERIC_SCALAR]] to ptr addrspace(1)
; CHECK-NEXT:    [[_TMP1:%.*]] = load float, ptr addrspace(1) [[_TMP0]], align 4
; CHECK-NEXT:    ret float [[_TMP1]]
;
  %tmp0 = addrspacecast ptr %generic_scalar to ptr addrspace(1)
  %tmp1 = load float, ptr addrspace(1) %tmp0
  ret float %tmp1
}

define float @load_constant_from_flat(ptr %generic_scalar) #0 {
; CHECK-LABEL: define float @load_constant_from_flat(
; CHECK-SAME: ptr [[GENERIC_SCALAR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[_TMP0:%.*]] = addrspacecast ptr [[GENERIC_SCALAR]] to ptr addrspace(4)
; CHECK-NEXT:    [[_TMP1:%.*]] = load float, ptr addrspace(4) [[_TMP0]], align 4
; CHECK-NEXT:    ret float [[_TMP1]]
;
  %tmp0 = addrspacecast ptr %generic_scalar to ptr addrspace(4)
  %tmp1 = load float, ptr addrspace(4) %tmp0
  ret float %tmp1
}

define float @load_group_from_flat(ptr %generic_scalar) #0 {
; CHECK-LABEL: define float @load_group_from_flat(
; CHECK-SAME: ptr [[GENERIC_SCALAR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[_TMP0:%.*]] = addrspacecast ptr [[GENERIC_SCALAR]] to ptr addrspace(3)
; CHECK-NEXT:    [[_TMP1:%.*]] = load float, ptr addrspace(3) [[_TMP0]], align 4
; CHECK-NEXT:    ret float [[_TMP1]]
;
  %tmp0 = addrspacecast ptr %generic_scalar to ptr addrspace(3)
  %tmp1 = load float, ptr addrspace(3) %tmp0
  ret float %tmp1
}

define float @load_private_from_flat(ptr %generic_scalar) #0 {
; CHECK-LABEL: define float @load_private_from_flat(
; CHECK-SAME: ptr [[GENERIC_SCALAR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[_TMP0:%.*]] = addrspacecast ptr [[GENERIC_SCALAR]] to ptr addrspace(5)
; CHECK-NEXT:    [[_TMP1:%.*]] = load float, ptr addrspace(5) [[_TMP0]], align 4
; CHECK-NEXT:    ret float [[_TMP1]]
;
  %tmp0 = addrspacecast ptr %generic_scalar to ptr addrspace(5)
  %tmp1 = load float, ptr addrspace(5) %tmp0
  ret float %tmp1
}

define amdgpu_kernel void @store_global_from_flat(ptr %generic_scalar) #0 {
; CHECK-LABEL: define amdgpu_kernel void @store_global_from_flat(
; CHECK-SAME: ptr [[GENERIC_SCALAR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[_TMP0:%.*]] = addrspacecast ptr [[GENERIC_SCALAR]] to ptr addrspace(1)
; CHECK-NEXT:    store float 0.000000e+00, ptr addrspace(1) [[_TMP0]], align 4
; CHECK-NEXT:    ret void
;
  %tmp0 = addrspacecast ptr %generic_scalar to ptr addrspace(1)
  store float 0.0, ptr addrspace(1) %tmp0
  ret void
}

define amdgpu_kernel void @store_group_from_flat(ptr %generic_scalar) #0 {
; CHECK-LABEL: define amdgpu_kernel void @store_group_from_flat(
; CHECK-SAME: ptr [[GENERIC_SCALAR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = addrspacecast ptr [[GENERIC_SCALAR]] to ptr addrspace(1)
; CHECK-NEXT:    [[TMP2:%.*]] = addrspacecast ptr addrspace(1) [[TMP1]] to ptr
; CHECK-NEXT:    [[_TMP0:%.*]] = addrspacecast ptr [[TMP2]] to ptr addrspace(3)
; CHECK-NEXT:    store float 0.000000e+00, ptr addrspace(3) [[_TMP0]], align 4
; CHECK-NEXT:    ret void
;
  %tmp0 = addrspacecast ptr %generic_scalar to ptr addrspace(3)
  store float 0.0, ptr addrspace(3) %tmp0
  ret void
}

define amdgpu_kernel void @store_private_from_flat(ptr %generic_scalar) #0 {
; CHECK-LABEL: define amdgpu_kernel void @store_private_from_flat(
; CHECK-SAME: ptr [[GENERIC_SCALAR:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = addrspacecast ptr [[GENERIC_SCALAR]] to ptr addrspace(1)
; CHECK-NEXT:    [[TMP2:%.*]] = addrspacecast ptr addrspace(1) [[TMP1]] to ptr
; CHECK-NEXT:    [[_TMP0:%.*]] = addrspacecast ptr [[TMP2]] to ptr addrspace(5)
; CHECK-NEXT:    store float 0.000000e+00, ptr addrspace(5) [[_TMP0]], align 4
; CHECK-NEXT:    ret void
;
  %tmp0 = addrspacecast ptr %generic_scalar to ptr addrspace(5)
  store float 0.0, ptr addrspace(5) %tmp0
  ret void
}

; optimized to global load/store.
define amdgpu_kernel void @load_store_global(ptr addrspace(1) nocapture %input, ptr addrspace(1) nocapture %output) #0 {
; CHECK-LABEL: define amdgpu_kernel void @load_store_global(
; CHECK-SAME: ptr addrspace(1) captures(none) [[INPUT:%.*]], ptr addrspace(1) captures(none) [[OUTPUT:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[VAL:%.*]] = load i32, ptr addrspace(1) [[INPUT]], align 4
; CHECK-NEXT:    store i32 [[VAL]], ptr addrspace(1) [[OUTPUT]], align 4
; CHECK-NEXT:    ret void
;
  %tmp0 = addrspacecast ptr addrspace(1) %input to ptr
  %tmp1 = addrspacecast ptr addrspace(1) %output to ptr
  %val = load i32, ptr %tmp0, align 4
  store i32 %val, ptr %tmp1, align 4
  ret void
}

; Optimized to group load/store.
define amdgpu_kernel void @load_store_group(ptr addrspace(3) nocapture %input, ptr addrspace(3) nocapture %output) #0 {
; CHECK-LABEL: define amdgpu_kernel void @load_store_group(
; CHECK-SAME: ptr addrspace(3) captures(none) [[INPUT:%.*]], ptr addrspace(3) captures(none) [[OUTPUT:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[VAL:%.*]] = load i32, ptr addrspace(3) [[INPUT]], align 4
; CHECK-NEXT:    store i32 [[VAL]], ptr addrspace(3) [[OUTPUT]], align 4
; CHECK-NEXT:    ret void
;
  %tmp0 = addrspacecast ptr addrspace(3) %input to ptr
  %tmp1 = addrspacecast ptr addrspace(3) %output to ptr
  %val = load i32, ptr %tmp0, align 4
  store i32 %val, ptr %tmp1, align 4
  ret void
}

; Optimized to private load/store.
define amdgpu_kernel void @load_store_private(ptr addrspace(5) nocapture %input, ptr addrspace(5) nocapture %output) #0 {
; CHECK-LABEL: define amdgpu_kernel void @load_store_private(
; CHECK-SAME: ptr addrspace(5) captures(none) [[INPUT:%.*]], ptr addrspace(5) captures(none) [[OUTPUT:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[VAL:%.*]] = load i32, ptr addrspace(5) [[INPUT]], align 4
; CHECK-NEXT:    store i32 [[VAL]], ptr addrspace(5) [[OUTPUT]], align 4
; CHECK-NEXT:    ret void
;
  %tmp0 = addrspacecast ptr addrspace(5) %input to ptr
  %tmp1 = addrspacecast ptr addrspace(5) %output to ptr
  %val = load i32, ptr %tmp0, align 4
  store i32 %val, ptr %tmp1, align 4
  ret void
}

; No optimization. flat load/store.
define amdgpu_kernel void @load_store_flat(ptr nocapture %input, ptr nocapture %output) #0 {
; CHECK-LABEL: define amdgpu_kernel void @load_store_flat(
; CHECK-SAME: ptr captures(none) [[INPUT:%.*]], ptr captures(none) [[OUTPUT:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = addrspacecast ptr [[INPUT]] to ptr addrspace(1)
; CHECK-NEXT:    [[TMP2:%.*]] = addrspacecast ptr [[OUTPUT]] to ptr addrspace(1)
; CHECK-NEXT:    [[VAL:%.*]] = load i32, ptr addrspace(1) [[TMP1]], align 4
; CHECK-NEXT:    store i32 [[VAL]], ptr addrspace(1) [[TMP2]], align 4
; CHECK-NEXT:    ret void
;
  %val = load i32, ptr %input, align 4
  store i32 %val, ptr %output, align 4
  ret void
}

define amdgpu_kernel void @store_addrspacecast_ptr_value(ptr addrspace(1) nocapture %input, ptr addrspace(1) nocapture %output) #0 {
; CHECK-LABEL: define amdgpu_kernel void @store_addrspacecast_ptr_value(
; CHECK-SAME: ptr addrspace(1) captures(none) [[INPUT:%.*]], ptr addrspace(1) captures(none) [[OUTPUT:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[CAST:%.*]] = addrspacecast ptr addrspace(1) [[INPUT]] to ptr
; CHECK-NEXT:    store ptr [[CAST]], ptr addrspace(1) [[OUTPUT]], align 4
; CHECK-NEXT:    ret void
;
  %cast = addrspacecast ptr addrspace(1) %input to ptr
  store ptr %cast, ptr addrspace(1) %output, align 4
  ret void
}

define i32 @atomicrmw_add_global_to_flat(ptr addrspace(1) %global.ptr, i32 %y) #0 {
; CHECK-LABEL: define i32 @atomicrmw_add_global_to_flat(
; CHECK-SAME: ptr addrspace(1) [[GLOBAL_PTR:%.*]], i32 [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[RET:%.*]] = atomicrmw add ptr addrspace(1) [[GLOBAL_PTR]], i32 [[Y]] seq_cst, align 4
; CHECK-NEXT:    ret i32 [[RET]]
;
  %cast = addrspacecast ptr addrspace(1) %global.ptr to ptr
  %ret = atomicrmw add ptr %cast, i32 %y seq_cst
  ret i32 %ret
}

define i32 @atomicrmw_add_group_to_flat(ptr addrspace(3) %group.ptr, i32 %y) #0 {
; CHECK-LABEL: define i32 @atomicrmw_add_group_to_flat(
; CHECK-SAME: ptr addrspace(3) [[GROUP_PTR:%.*]], i32 [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[RET:%.*]] = atomicrmw add ptr addrspace(3) [[GROUP_PTR]], i32 [[Y]] seq_cst, align 4
; CHECK-NEXT:    ret i32 [[RET]]
;
  %cast = addrspacecast ptr addrspace(3) %group.ptr to ptr
  %ret = atomicrmw add ptr %cast, i32 %y seq_cst
  ret i32 %ret
}

define { i32, i1 } @cmpxchg_global_to_flat(ptr addrspace(1) %global.ptr, i32 %cmp, i32 %val) #0 {
; CHECK-LABEL: define { i32, i1 } @cmpxchg_global_to_flat(
; CHECK-SAME: ptr addrspace(1) [[GLOBAL_PTR:%.*]], i32 [[CMP:%.*]], i32 [[VAL:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[RET:%.*]] = cmpxchg ptr addrspace(1) [[GLOBAL_PTR]], i32 [[CMP]], i32 [[VAL]] seq_cst monotonic, align 4
; CHECK-NEXT:    ret { i32, i1 } [[RET]]
;
  %cast = addrspacecast ptr addrspace(1) %global.ptr to ptr
  %ret = cmpxchg ptr %cast, i32 %cmp, i32 %val seq_cst monotonic
  ret { i32, i1 } %ret
}

define { i32, i1 } @cmpxchg_group_to_flat(ptr addrspace(3) %group.ptr, i32 %cmp, i32 %val) #0 {
; CHECK-LABEL: define { i32, i1 } @cmpxchg_group_to_flat(
; CHECK-SAME: ptr addrspace(3) [[GROUP_PTR:%.*]], i32 [[CMP:%.*]], i32 [[VAL:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[RET:%.*]] = cmpxchg ptr addrspace(3) [[GROUP_PTR]], i32 [[CMP]], i32 [[VAL]] seq_cst monotonic, align 4
; CHECK-NEXT:    ret { i32, i1 } [[RET]]
;
  %cast = addrspacecast ptr addrspace(3) %group.ptr to ptr
  %ret = cmpxchg ptr %cast, i32 %cmp, i32 %val seq_cst monotonic
  ret { i32, i1 } %ret
}

; Not pointer operand
define { ptr, i1 } @cmpxchg_group_to_flat_wrong_operand(ptr addrspace(3) %cas.ptr, ptr addrspace(3) %cmp.ptr, ptr %val) #0 {
; CHECK-LABEL: define { ptr, i1 } @cmpxchg_group_to_flat_wrong_operand(
; CHECK-SAME: ptr addrspace(3) [[CAS_PTR:%.*]], ptr addrspace(3) [[CMP_PTR:%.*]], ptr [[VAL:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[CAST_CMP:%.*]] = addrspacecast ptr addrspace(3) [[CMP_PTR]] to ptr
; CHECK-NEXT:    [[RET:%.*]] = cmpxchg ptr addrspace(3) [[CAS_PTR]], ptr [[CAST_CMP]], ptr [[VAL]] seq_cst monotonic, align 8
; CHECK-NEXT:    ret { ptr, i1 } [[RET]]
;
  %cast.cmp = addrspacecast ptr addrspace(3) %cmp.ptr to ptr
  %ret = cmpxchg ptr addrspace(3) %cas.ptr, ptr %cast.cmp, ptr %val seq_cst monotonic
  ret { ptr, i1 } %ret
}

; Null pointer in local addr space
define void @local_nullptr(ptr addrspace(1) nocapture %results, ptr addrspace(3) %a) {
; CHECK-LABEL: define void @local_nullptr(
; CHECK-SAME: ptr addrspace(1) captures(none) [[RESULTS:%.*]], ptr addrspace(3) [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp ne ptr addrspace(3) [[A]], addrspacecast (ptr addrspace(5) null to ptr addrspace(3))
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[TOBOOL]] to i32
; CHECK-NEXT:    store i32 [[CONV]], ptr addrspace(1) [[RESULTS]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %tobool = icmp ne ptr addrspace(3) %a, addrspacecast (ptr addrspace(5) null to ptr addrspace(3))
  %conv = zext i1 %tobool to i32
  store i32 %conv, ptr addrspace(1) %results, align 4
  ret void
}

define i32 @atomicrmw_add_global_to_flat_preserve_amdgpu_md(ptr addrspace(1) %global.ptr, i32 %y) #0 {
; CHECK-LABEL: define i32 @atomicrmw_add_global_to_flat_preserve_amdgpu_md(
; CHECK-SAME: ptr addrspace(1) [[GLOBAL_PTR:%.*]], i32 [[Y:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[RET:%.*]] = atomicrmw add ptr addrspace(1) [[GLOBAL_PTR]], i32 [[Y]] seq_cst, align 4, !amdgpu.no.fine.grained.memory [[META0:![0-9]+]], !amdgpu.no.remote.memory [[META0]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %cast = addrspacecast ptr addrspace(1) %global.ptr to ptr
  %ret = atomicrmw add ptr %cast, i32 %y seq_cst, align 4, !amdgpu.no.fine.grained.memory !0, !amdgpu.no.remote.memory !0
  ret i32 %ret
}

; Make sure there's no assert
define ptr @try_infer_getelementptr_constant_null() {
; CHECK-LABEL: define ptr @try_infer_getelementptr_constant_null() {
; CHECK-NEXT:    [[CE:%.*]] = getelementptr i8, ptr getelementptr inbounds (i8, ptr null, i64 8), i64 0
; CHECK-NEXT:    ret ptr [[CE]]
;
  %ce = getelementptr i8, ptr getelementptr inbounds (i8, ptr null, i64 8), i64 0
  ret ptr %ce
}

attributes #0 = { nounwind }

!0 = !{}
;.
; CHECK: [[META0]] = !{}
;.
