; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -mtriple=i686-linux-gnu -fast-isel | FileCheck %s --check-prefixes=FAST-X86
; RUN: llc < %s -mtriple=i686-linux-gnu -global-isel=0 -fast-isel=0 | FileCheck %s --check-prefixes=SDAG-X86
; RUN: llc < %s -mtriple=i686-linux-gnu -global-isel -global-isel-abort=1 | FileCheck %s --check-prefixes=GISEL-X86
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -fast-isel | FileCheck %s --check-prefixes=FAST-X64
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -global-isel=0 -fast-isel=0 | FileCheck %s --check-prefixes=SDAG-X64
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -global-isel -global-isel-abort=1 | FileCheck %s --check-prefixes=GISEL-X64

define float @test_powi_f32_i32(float %Val, i32 %x) nounwind {
; FAST-X86-LABEL: test_powi_f32_i32:
; FAST-X86:       # %bb.0:
; FAST-X86-NEXT:    subl $12, %esp
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    flds {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fstps (%esp)
; FAST-X86-NEXT:    calll __powisf2
; FAST-X86-NEXT:    addl $12, %esp
; FAST-X86-NEXT:    retl
;
; SDAG-X86-LABEL: test_powi_f32_i32:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    subl $12, %esp
; SDAG-X86-NEXT:    flds {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fstps (%esp)
; SDAG-X86-NEXT:    calll __powisf2
; SDAG-X86-NEXT:    addl $12, %esp
; SDAG-X86-NEXT:    retl
;
; GISEL-X86-LABEL: test_powi_f32_i32:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    subl $12, %esp
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    movl %eax, (%esp)
; GISEL-X86-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    calll __powisf2
; GISEL-X86-NEXT:    addl $12, %esp
; GISEL-X86-NEXT:    retl
;
; FAST-X64-LABEL: test_powi_f32_i32:
; FAST-X64:       # %bb.0:
; FAST-X64-NEXT:    pushq %rax
; FAST-X64-NEXT:    callq __powisf2@PLT
; FAST-X64-NEXT:    popq %rax
; FAST-X64-NEXT:    retq
;
; SDAG-X64-LABEL: test_powi_f32_i32:
; SDAG-X64:       # %bb.0:
; SDAG-X64-NEXT:    jmp __powisf2@PLT # TAILCALL
;
; GISEL-X64-LABEL: test_powi_f32_i32:
; GISEL-X64:       # %bb.0:
; GISEL-X64-NEXT:    pushq %rax
; GISEL-X64-NEXT:    callq __powisf2
; GISEL-X64-NEXT:    popq %rax
; GISEL-X64-NEXT:    retq
  %res = call float @llvm.powi.f32.i32(float %Val, i32 %x)
  ret float %res
}

define double @test_powi_f64_i32(double %Val, i32 %x) nounwind {
; FAST-X86-LABEL: test_powi_f64_i32:
; FAST-X86:       # %bb.0:
; FAST-X86-NEXT:    subl $12, %esp
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fstpl (%esp)
; FAST-X86-NEXT:    calll __powidf2
; FAST-X86-NEXT:    addl $12, %esp
; FAST-X86-NEXT:    retl
;
; SDAG-X86-LABEL: test_powi_f64_i32:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    subl $12, %esp
; SDAG-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fstpl (%esp)
; SDAG-X86-NEXT:    calll __powidf2
; SDAG-X86-NEXT:    addl $12, %esp
; SDAG-X86-NEXT:    retl
;
; GISEL-X86-LABEL: test_powi_f64_i32:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    pushl %esi
; GISEL-X86-NEXT:    subl $24, %esp
; GISEL-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    movl 4(%eax), %eax
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GISEL-X86-NEXT:    xorl %esi, %esi
; GISEL-X86-NEXT:    addl %esp, %esi
; GISEL-X86-NEXT:    movl %ecx, (%esp)
; GISEL-X86-NEXT:    movl %eax, 4(%esi)
; GISEL-X86-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    calll __powidf2
; GISEL-X86-NEXT:    addl $24, %esp
; GISEL-X86-NEXT:    popl %esi
; GISEL-X86-NEXT:    retl
;
; FAST-X64-LABEL: test_powi_f64_i32:
; FAST-X64:       # %bb.0:
; FAST-X64-NEXT:    pushq %rax
; FAST-X64-NEXT:    callq __powidf2@PLT
; FAST-X64-NEXT:    popq %rax
; FAST-X64-NEXT:    retq
;
; SDAG-X64-LABEL: test_powi_f64_i32:
; SDAG-X64:       # %bb.0:
; SDAG-X64-NEXT:    jmp __powidf2@PLT # TAILCALL
;
; GISEL-X64-LABEL: test_powi_f64_i32:
; GISEL-X64:       # %bb.0:
; GISEL-X64-NEXT:    pushq %rax
; GISEL-X64-NEXT:    callq __powidf2
; GISEL-X64-NEXT:    popq %rax
; GISEL-X64-NEXT:    retq
  %res = call double @llvm.powi.f64.i32(double %Val, i32 %x)
  ret double %res
}

define x86_fp80 @test_powi_f80_i32(x86_fp80 %Val, i32 %x) nounwind {
; FAST-X86-LABEL: test_powi_f80_i32:
; FAST-X86:       # %bb.0:
; FAST-X86-NEXT:    subl $28, %esp
; FAST-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FAST-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fstpt (%esp)
; FAST-X86-NEXT:    calll __powixf2
; FAST-X86-NEXT:    addl $28, %esp
; FAST-X86-NEXT:    retl
;
; SDAG-X86-LABEL: test_powi_f80_i32:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    subl $28, %esp
; SDAG-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fstpt (%esp)
; SDAG-X86-NEXT:    calll __powixf2
; SDAG-X86-NEXT:    addl $28, %esp
; SDAG-X86-NEXT:    retl
;
; GISEL-X86-LABEL: test_powi_f80_i32:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    subl $28, %esp
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    fstpt (%esp)
; GISEL-X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    calll __powixf2
; GISEL-X86-NEXT:    addl $28, %esp
; GISEL-X86-NEXT:    retl
;
; FAST-X64-LABEL: test_powi_f80_i32:
; FAST-X64:       # %bb.0:
; FAST-X64-NEXT:    subq $24, %rsp
; FAST-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; FAST-X64-NEXT:    fstpt (%rsp)
; FAST-X64-NEXT:    callq __powixf2@PLT
; FAST-X64-NEXT:    addq $24, %rsp
; FAST-X64-NEXT:    retq
;
; SDAG-X64-LABEL: test_powi_f80_i32:
; SDAG-X64:       # %bb.0:
; SDAG-X64-NEXT:    subq $24, %rsp
; SDAG-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    fstpt (%rsp)
; SDAG-X64-NEXT:    callq __powixf2@PLT
; SDAG-X64-NEXT:    addq $24, %rsp
; SDAG-X64-NEXT:    retq
;
; GISEL-X64-LABEL: test_powi_f80_i32:
; GISEL-X64:       # %bb.0:
; GISEL-X64-NEXT:    subq $24, %rsp
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fstpt (%rsp)
; GISEL-X64-NEXT:    callq __powixf2
; GISEL-X64-NEXT:    addq $24, %rsp
; GISEL-X64-NEXT:    retq
  %res = call x86_fp80 @llvm.powi.f80.i32(x86_fp80 %Val, i32 %x)
  ret x86_fp80 %res
}
