; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s -check-prefix=X64
; RUN: llc < %s -mtriple=x86_64-uefi | FileCheck %s -check-prefix=X64
; RUN: llc < %s -mtriple=i686-unknown-unknown   | FileCheck %s -check-prefix=X86

; tailcc will turn all of these musttail calls into tail calls.

declare dso_local tailcc i32 @tailcallee(i32 %a1, i32 %a2)

define dso_local tailcc i32 @tailcaller(i32 %in1, i32 %in2) nounwind {
; X64-LABEL: tailcaller:
; X64:       # %bb.0: # %entry
; X64-NEXT:    jmp tailcallee # TAILCALL
;
; X86-LABEL: tailcaller:
; X86:       # %bb.0: # %entry
; X86-NEXT:    jmp tailcallee # TAILCALL
entry:
  %tmp11 = musttail call tailcc i32 @tailcallee(i32 %in1, i32 %in2)
  ret i32 %tmp11
}

declare dso_local tailcc ptr @alias_callee()

define tailcc noalias ptr @noalias_caller() nounwind {
; X64-LABEL: noalias_caller:
; X64:       # %bb.0:
; X64-NEXT:    jmp alias_callee # TAILCALL
;
; X86-LABEL: noalias_caller:
; X86:       # %bb.0:
; X86-NEXT:    jmp alias_callee # TAILCALL
  %p = musttail call tailcc ptr @alias_callee()
  ret ptr %p
}

declare dso_local tailcc noalias ptr @noalias_callee()

define dso_local tailcc ptr @alias_caller() nounwind {
; X64-LABEL: alias_caller:
; X64:       # %bb.0:
; X64-NEXT:    jmp noalias_callee # TAILCALL
;
; X86-LABEL: alias_caller:
; X86:       # %bb.0:
; X86-NEXT:    jmp noalias_callee # TAILCALL
  %p = musttail call tailcc noalias ptr @noalias_callee()
  ret ptr %p
}

define dso_local tailcc void @void_test(i32, i32, i32, i32) {
; X64-LABEL: void_test:
; X64:       # %bb.0: # %entry
; X64-NEXT:    jmp void_test # TAILCALL
;
; X86-LABEL: void_test:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %esi, -8
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    popl %esi
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    jmp void_test # TAILCALL
  entry:
   musttail call tailcc void @void_test( i32 %0, i32 %1, i32 %2, i32 %3)
   ret void
}

define dso_local tailcc i1 @i1test(i32, i32, i32, i32) {
; X64-LABEL: i1test:
; X64:       # %bb.0: # %entry
; X64-NEXT:    jmp i1test # TAILCALL
;
; X86-LABEL: i1test:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %esi
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %esi, -8
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; X86-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; X86-NEXT:    popl %esi
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    jmp i1test # TAILCALL
  entry:
  %4 = musttail call tailcc i1 @i1test( i32 %0, i32 %1, i32 %2, i32 %3)
  ret i1 %4
}
