; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=i686-unknown-unknown | FileCheck %s --check-prefix=X86
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s --check-prefix=X64

define i1 @and_ord(float %a, float %b) {
; X86-LABEL: and_ord:
; X86:       # %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setnp %al
; X86-NEXT:    retl
;
; X64-LABEL: and_ord:
; X64:       # %bb.0:
; X64-NEXT:    xorps %xmm2, %xmm2
; X64-NEXT:    cmpordss %xmm2, %xmm1
; X64-NEXT:    cmpordss %xmm2, %xmm0
; X64-NEXT:    andps %xmm1, %xmm0
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %c = fcmp ord float %a, 0.0
  %d = fcmp ord float %b, 0.0
  %e = and i1 %c, %d
  ret i1 %e
}

define i1 @or_uno(float %a, float %b) {
; X86-LABEL: or_uno:
; X86:       # %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setp %al
; X86-NEXT:    retl
;
; X64-LABEL: or_uno:
; X64:       # %bb.0:
; X64-NEXT:    xorps %xmm2, %xmm2
; X64-NEXT:    cmpunordss %xmm2, %xmm1
; X64-NEXT:    cmpunordss %xmm2, %xmm0
; X64-NEXT:    orps %xmm1, %xmm0
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %c = fcmp uno float %a, 0.0
  %d = fcmp uno float %b, 0.0
  %e = or i1 %c, %d
  ret i1 %e
}

define <4 x i1> @and_ord_vec(<4 x float> %a, <4 x float> %b) {
; X86-LABEL: and_ord_vec:
; X86:       # %bb.0:
; X86-NEXT:    pushl %eax
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fstps (%esp) # 4-byte Folded Spill
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    fucompp
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    fucompp
; X86-NEXT:    setnp %dh
; X86-NEXT:    shlb $2, %dh
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    flds (%esp) # 4-byte Folded Reload
; X86-NEXT:    fxch %st(1)
; X86-NEXT:    fucompp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    setnp %dl
; X86-NEXT:    shlb $3, %dl
; X86-NEXT:    orb %dh, %dl
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setnp %dh
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setnp %al
; X86-NEXT:    addb %al, %al
; X86-NEXT:    orb %dh, %al
; X86-NEXT:    orb %dl, %al
; X86-NEXT:    movb %al, (%ecx)
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    popl %ecx
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    retl $4
;
; X64-LABEL: and_ord_vec:
; X64:       # %bb.0:
; X64-NEXT:    cmpordps %xmm1, %xmm0
; X64-NEXT:    retq
  %c = fcmp ord <4 x float> %a, %a
  %d = fcmp ord <4 x float> %b, %b
  %e = and <4 x i1> %c, %d
  ret <4 x i1> %e
}

define <4 x i1> @or_uno_vec(<4 x float> %a, <4 x float> %b) {
; X86-LABEL: or_uno_vec:
; X86:       # %bb.0:
; X86-NEXT:    pushl %eax
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fstps (%esp) # 4-byte Folded Spill
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    fucompp
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    fucompp
; X86-NEXT:    setp %dh
; X86-NEXT:    shlb $2, %dh
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    flds (%esp) # 4-byte Folded Reload
; X86-NEXT:    fxch %st(1)
; X86-NEXT:    fucompp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    setp %dl
; X86-NEXT:    shlb $3, %dl
; X86-NEXT:    orb %dh, %dl
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setp %dh
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    # kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setp %al
; X86-NEXT:    addb %al, %al
; X86-NEXT:    orb %dh, %al
; X86-NEXT:    orb %dl, %al
; X86-NEXT:    movb %al, (%ecx)
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    popl %ecx
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    retl $4
;
; X64-LABEL: or_uno_vec:
; X64:       # %bb.0:
; X64-NEXT:    cmpunordps %xmm1, %xmm0
; X64-NEXT:    retq
  %c = fcmp uno <4 x float> %a, %a
  %d = fcmp uno <4 x float> %b, %b
  %e = or <4 x i1> %c, %d
  ret <4 x i1> %e
}
