; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+amx-int8 -mattr=+avx512f -verify-machineinstrs | FileCheck %s
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+amx-int8 -mattr=+avx512f,+egpr --show-mc-encoding -verify-machineinstrs | FileCheck %s --check-prefix=EGPR

@buf = dso_local global [3072 x i8] zeroinitializer, align 64

define dso_local void @test_api(i16 signext %0, i16 signext %1) nounwind {
; CHECK-LABEL: test_api:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    pushq %r15
; CHECK-NEXT:    pushq %r14
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    subq $2120, %rsp # imm = 0x848
; CHECK-NEXT:    movl %esi, %ebx
; CHECK-NEXT:    movl %edi, %ebp
; CHECK-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    vmovups %zmm0, (%rsp)
; CHECK-NEXT:    movb $1, (%rsp)
; CHECK-NEXT:    movw $8, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movb $8, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movw $8, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movb $8, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movw $8, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movw %bx, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movb %bpl, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movw %bx, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movb %bpl, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movb %bpl, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movw %bx, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movb %bpl, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movw %bx, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movb %bpl, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    ldtilecfg (%rsp)
; CHECK-NEXT:    movl $32, %r14d
; CHECK-NEXT:    movl $buf+2048, %r15d
; CHECK-NEXT:    tileloadd (%r15,%r14), %tmm5
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    testb %al, %al
; CHECK-NEXT:    jne .LBB0_2
; CHECK-NEXT:  # %bb.1: # %if.true
; CHECK-NEXT:    movl $buf, %eax
; CHECK-NEXT:    movw $8, %cx
; CHECK-NEXT:    tileloadd (%rax,%r14), %tmm0
; CHECK-NEXT:    movl $buf+1024, %eax
; CHECK-NEXT:    tileloadd (%rax,%r14), %tmm1
; CHECK-NEXT:    movabsq $64, %rax
; CHECK-NEXT:    tilestored %tmm5, 1088(%rsp,%rax) # 1024-byte Folded Spill
; CHECK-NEXT:    tdpbssd %tmm1, %tmm0, %tmm5
; CHECK-NEXT:    tilestored %tmm5, 64(%rsp,%rax) # 1024-byte Folded Spill
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    callq foo
; CHECK-NEXT:    ldtilecfg (%rsp)
; CHECK-NEXT:    movabsq $64, %rax
; CHECK-NEXT:    tileloadd 64(%rsp,%rax), %tmm6 # 1024-byte Folded Reload
; CHECK-NEXT:    jmp .LBB0_3
; CHECK-NEXT:  .LBB0_2: # %if.false
; CHECK-NEXT:    movl $buf, %eax
; CHECK-NEXT:    movw $8, %cx
; CHECK-NEXT:    tileloadd (%rax,%r14), %tmm2
; CHECK-NEXT:    movl $buf+1024, %eax
; CHECK-NEXT:    tileloadd (%rax,%r14), %tmm3
; CHECK-NEXT:    movabsq $64, %rax
; CHECK-NEXT:    tilestored %tmm5, 1088(%rsp,%rax) # 1024-byte Folded Spill
; CHECK-NEXT:    tdpbssd %tmm3, %tmm2, %tmm5
; CHECK-NEXT:    tilestored %tmm5, 64(%rsp,%rax) # 1024-byte Folded Spill
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    callq foo
; CHECK-NEXT:    ldtilecfg (%rsp)
; CHECK-NEXT:    movabsq $64, %rax
; CHECK-NEXT:    tileloadd 64(%rsp,%rax), %tmm6 # 1024-byte Folded Reload
; CHECK-NEXT:    tilestored %tmm6, (%r15,%r14)
; CHECK-NEXT:  .LBB0_3: # %exit
; CHECK-NEXT:    movl $buf, %eax
; CHECK-NEXT:    movl $32, %ecx
; CHECK-NEXT:    movw $8, %dx
; CHECK-NEXT:    tileloadd (%rax,%rcx), %tmm4
; CHECK-NEXT:    movabsq $64, %rax
; CHECK-NEXT:    tileloadd 1088(%rsp,%rax), %tmm5 # 1024-byte Folded Reload
; CHECK-NEXT:    tdpbssd %tmm4, %tmm6, %tmm5
; CHECK-NEXT:    movl $buf+2048, %eax
; CHECK-NEXT:    tilestored %tmm5, (%rax,%rcx)
; CHECK-NEXT:    addq $2120, %rsp # imm = 0x848
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %r14
; CHECK-NEXT:    popq %r15
; CHECK-NEXT:    popq %rbp
; CHECK-NEXT:    tilerelease
; CHECK-NEXT:    retq
;
; EGPR-LABEL: test_api:
; EGPR:       # %bb.0:
; EGPR-NEXT:    pushq %rbp # encoding: [0x55]
; EGPR-NEXT:    pushq %r15 # encoding: [0x41,0x57]
; EGPR-NEXT:    pushq %r14 # encoding: [0x41,0x56]
; EGPR-NEXT:    pushq %rbx # encoding: [0x53]
; EGPR-NEXT:    subq $2120, %rsp # encoding: [0x48,0x81,0xec,0x48,0x08,0x00,0x00]
; EGPR-NEXT:    # imm = 0x848
; EGPR-NEXT:    movl %esi, %ebx # encoding: [0x89,0xf3]
; EGPR-NEXT:    movl %edi, %ebp # encoding: [0x89,0xfd]
; EGPR-NEXT:    vxorps %xmm0, %xmm0, %xmm0 # encoding: [0xc5,0xf8,0x57,0xc0]
; EGPR-NEXT:    vmovups %zmm0, (%rsp) # encoding: [0x62,0xf1,0x7c,0x48,0x11,0x04,0x24]
; EGPR-NEXT:    movb $1, (%rsp) # encoding: [0xc6,0x04,0x24,0x01]
; EGPR-NEXT:    movw $8, {{[0-9]+}}(%rsp) # encoding: [0x66,0xc7,0x44,0x24,0x10,0x08,0x00]
; EGPR-NEXT:    movb $8, {{[0-9]+}}(%rsp) # encoding: [0xc6,0x44,0x24,0x31,0x08]
; EGPR-NEXT:    movw $8, {{[0-9]+}}(%rsp) # encoding: [0x66,0xc7,0x44,0x24,0x14,0x08,0x00]
; EGPR-NEXT:    movb $8, {{[0-9]+}}(%rsp) # encoding: [0xc6,0x44,0x24,0x33,0x08]
; EGPR-NEXT:    movw $8, {{[0-9]+}}(%rsp) # encoding: [0x66,0xc7,0x44,0x24,0x18,0x08,0x00]
; EGPR-NEXT:    movw %bx, {{[0-9]+}}(%rsp) # encoding: [0x66,0x89,0x5c,0x24,0x1c]
; EGPR-NEXT:    movb %bpl, {{[0-9]+}}(%rsp) # encoding: [0x40,0x88,0x6c,0x24,0x36]
; EGPR-NEXT:    movw %bx, {{[0-9]+}}(%rsp) # encoding: [0x66,0x89,0x5c,0x24,0x1a]
; EGPR-NEXT:    movb %bpl, {{[0-9]+}}(%rsp) # encoding: [0x40,0x88,0x6c,0x24,0x35]
; EGPR-NEXT:    movb %bpl, {{[0-9]+}}(%rsp) # encoding: [0x40,0x88,0x6c,0x24,0x34]
; EGPR-NEXT:    movw %bx, {{[0-9]+}}(%rsp) # encoding: [0x66,0x89,0x5c,0x24,0x16]
; EGPR-NEXT:    movb %bpl, {{[0-9]+}}(%rsp) # encoding: [0x40,0x88,0x6c,0x24,0x32]
; EGPR-NEXT:    movw %bx, {{[0-9]+}}(%rsp) # encoding: [0x66,0x89,0x5c,0x24,0x12]
; EGPR-NEXT:    movb %bpl, {{[0-9]+}}(%rsp) # encoding: [0x40,0x88,0x6c,0x24,0x30]
; EGPR-NEXT:    ldtilecfg (%rsp) # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x78,0x49,0x04,0x24]
; EGPR-NEXT:    movl $32, %r14d # encoding: [0x41,0xbe,0x20,0x00,0x00,0x00]
; EGPR-NEXT:    movl $buf+2048, %r15d # encoding: [0x41,0xbf,A,A,A,A]
; EGPR-NEXT:    # fixup A - offset: 2, value: buf+2048, kind: FK_Data_4
; EGPR-NEXT:    tileloadd (%r15,%r14), %tmm5 # EVEX TO VEX Compression encoding: [0xc4,0x82,0x7b,0x4b,0x2c,0x37]
; EGPR-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; EGPR-NEXT:    testb %al, %al # encoding: [0x84,0xc0]
; EGPR-NEXT:    jne .LBB0_2 # encoding: [0x75,A]
; EGPR-NEXT:    # fixup A - offset: 1, value: .LBB0_2, kind: FK_PCRel_1
; EGPR-NEXT:  # %bb.1: # %if.true
; EGPR-NEXT:    movl $buf, %eax # encoding: [0xb8,A,A,A,A]
; EGPR-NEXT:    # fixup A - offset: 1, value: buf, kind: FK_Data_4
; EGPR-NEXT:    movw $8, %cx # encoding: [0x66,0xb9,0x08,0x00]
; EGPR-NEXT:    tileloadd (%rax,%r14), %tmm0 # EVEX TO VEX Compression encoding: [0xc4,0xa2,0x7b,0x4b,0x04,0x30]
; EGPR-NEXT:    movl $buf+1024, %eax # encoding: [0xb8,A,A,A,A]
; EGPR-NEXT:    # fixup A - offset: 1, value: buf+1024, kind: FK_Data_4
; EGPR-NEXT:    tileloadd (%rax,%r14), %tmm1 # EVEX TO VEX Compression encoding: [0xc4,0xa2,0x7b,0x4b,0x0c,0x30]
; EGPR-NEXT:    movabsq $64, %rax # encoding: [0x48,0xb8,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00]
; EGPR-NEXT:    tilestored %tmm5, 1088(%rsp,%rax) # 1024-byte Folded Spill
; EGPR-NEXT:    # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x7a,0x4b,0xac,0x04,0x40,0x04,0x00,0x00]
; EGPR-NEXT:    tdpbssd %tmm1, %tmm0, %tmm5 # encoding: [0xc4,0xe2,0x73,0x5e,0xe8]
; EGPR-NEXT:    tilestored %tmm5, 64(%rsp,%rax) # 1024-byte Folded Spill
; EGPR-NEXT:    # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x7a,0x4b,0x6c,0x04,0x40]
; EGPR-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; EGPR-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; EGPR-NEXT:    callq foo # encoding: [0xe8,A,A,A,A]
; EGPR-NEXT:    # fixup A - offset: 1, value: foo, kind: reloc_branch_4byte_pcrel
; EGPR-NEXT:    ldtilecfg (%rsp) # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x78,0x49,0x04,0x24]
; EGPR-NEXT:    movabsq $64, %rax # encoding: [0x48,0xb8,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00]
; EGPR-NEXT:    tileloadd 64(%rsp,%rax), %tmm6 # 1024-byte Folded Reload
; EGPR-NEXT:    # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x7b,0x4b,0x74,0x04,0x40]
; EGPR-NEXT:    jmp .LBB0_3 # encoding: [0xeb,A]
; EGPR-NEXT:    # fixup A - offset: 1, value: .LBB0_3, kind: FK_PCRel_1
; EGPR-NEXT:  .LBB0_2: # %if.false
; EGPR-NEXT:    movl $buf, %eax # encoding: [0xb8,A,A,A,A]
; EGPR-NEXT:    # fixup A - offset: 1, value: buf, kind: FK_Data_4
; EGPR-NEXT:    movw $8, %cx # encoding: [0x66,0xb9,0x08,0x00]
; EGPR-NEXT:    tileloadd (%rax,%r14), %tmm2 # EVEX TO VEX Compression encoding: [0xc4,0xa2,0x7b,0x4b,0x14,0x30]
; EGPR-NEXT:    movl $buf+1024, %eax # encoding: [0xb8,A,A,A,A]
; EGPR-NEXT:    # fixup A - offset: 1, value: buf+1024, kind: FK_Data_4
; EGPR-NEXT:    tileloadd (%rax,%r14), %tmm3 # EVEX TO VEX Compression encoding: [0xc4,0xa2,0x7b,0x4b,0x1c,0x30]
; EGPR-NEXT:    movabsq $64, %rax # encoding: [0x48,0xb8,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00]
; EGPR-NEXT:    tilestored %tmm5, 1088(%rsp,%rax) # 1024-byte Folded Spill
; EGPR-NEXT:    # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x7a,0x4b,0xac,0x04,0x40,0x04,0x00,0x00]
; EGPR-NEXT:    tdpbssd %tmm3, %tmm2, %tmm5 # encoding: [0xc4,0xe2,0x63,0x5e,0xea]
; EGPR-NEXT:    tilestored %tmm5, 64(%rsp,%rax) # 1024-byte Folded Spill
; EGPR-NEXT:    # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x7a,0x4b,0x6c,0x04,0x40]
; EGPR-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; EGPR-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; EGPR-NEXT:    callq foo # encoding: [0xe8,A,A,A,A]
; EGPR-NEXT:    # fixup A - offset: 1, value: foo, kind: reloc_branch_4byte_pcrel
; EGPR-NEXT:    ldtilecfg (%rsp) # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x78,0x49,0x04,0x24]
; EGPR-NEXT:    movabsq $64, %rax # encoding: [0x48,0xb8,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00]
; EGPR-NEXT:    tileloadd 64(%rsp,%rax), %tmm6 # 1024-byte Folded Reload
; EGPR-NEXT:    # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x7b,0x4b,0x74,0x04,0x40]
; EGPR-NEXT:    tilestored %tmm6, (%r15,%r14) # EVEX TO VEX Compression encoding: [0xc4,0x82,0x7a,0x4b,0x34,0x37]
; EGPR-NEXT:  .LBB0_3: # %exit
; EGPR-NEXT:    movl $buf, %eax # encoding: [0xb8,A,A,A,A]
; EGPR-NEXT:    # fixup A - offset: 1, value: buf, kind: FK_Data_4
; EGPR-NEXT:    movl $32, %ecx # encoding: [0xb9,0x20,0x00,0x00,0x00]
; EGPR-NEXT:    movw $8, %dx # encoding: [0x66,0xba,0x08,0x00]
; EGPR-NEXT:    tileloadd (%rax,%rcx), %tmm4 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x7b,0x4b,0x24,0x08]
; EGPR-NEXT:    movabsq $64, %rax # encoding: [0x48,0xb8,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00]
; EGPR-NEXT:    tileloadd 1088(%rsp,%rax), %tmm5 # 1024-byte Folded Reload
; EGPR-NEXT:    # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x7b,0x4b,0xac,0x04,0x40,0x04,0x00,0x00]
; EGPR-NEXT:    tdpbssd %tmm4, %tmm6, %tmm5 # encoding: [0xc4,0xe2,0x5b,0x5e,0xee]
; EGPR-NEXT:    movl $buf+2048, %eax # encoding: [0xb8,A,A,A,A]
; EGPR-NEXT:    # fixup A - offset: 1, value: buf+2048, kind: FK_Data_4
; EGPR-NEXT:    tilestored %tmm5, (%rax,%rcx) # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x7a,0x4b,0x2c,0x08]
; EGPR-NEXT:    addq $2120, %rsp # encoding: [0x48,0x81,0xc4,0x48,0x08,0x00,0x00]
; EGPR-NEXT:    # imm = 0x848
; EGPR-NEXT:    popq %rbx # encoding: [0x5b]
; EGPR-NEXT:    popq %r14 # encoding: [0x41,0x5e]
; EGPR-NEXT:    popq %r15 # encoding: [0x41,0x5f]
; EGPR-NEXT:    popq %rbp # encoding: [0x5d]
; EGPR-NEXT:    tilerelease # encoding: [0xc4,0xe2,0x78,0x49,0xc0]
; EGPR-NEXT:    retq # encoding: [0xc3]
  %c = tail call x86_amx @llvm.x86.tileloadd64.internal(i16 %0, i16 %1, ptr getelementptr inbounds ([3072 x i8], ptr @buf, i64 0, i64 2048), i64 32)
  br i1 undef, label %if.true, label %if.false
if.true:
  %a1 = tail call x86_amx @llvm.x86.tileloadd64.internal(i16 %0, i16 8, ptr @buf, i64 32)
  %b1 = tail call x86_amx @llvm.x86.tileloadd64.internal(i16 8, i16 %1, ptr getelementptr inbounds ([3072 x i8], ptr @buf, i64 0, i64 1024), i64 32)
  %d1 = tail call x86_amx @llvm.x86.tdpbssd.internal(i16 %0, i16 %1, i16 8, x86_amx %c, x86_amx %a1, x86_amx %b1)
  tail call void (...) @foo()
  br label %exit
if.false:
  %a2 = tail call x86_amx @llvm.x86.tileloadd64.internal(i16 %0, i16 8, ptr @buf, i64 32)
  %b2 = tail call x86_amx @llvm.x86.tileloadd64.internal(i16 8, i16 %1, ptr getelementptr inbounds ([3072 x i8], ptr @buf, i64 0, i64 1024), i64 32)
  %d2 = tail call x86_amx @llvm.x86.tdpbssd.internal(i16 %0, i16 %1, i16 8, x86_amx %c, x86_amx %a2, x86_amx %b2)
  tail call void (...) @foo()
  tail call void @llvm.x86.tilestored64.internal(i16 %0, i16 %1, ptr getelementptr inbounds ([3072 x i8], ptr @buf, i64 0, i64 2048), i64 32, x86_amx %d2)
  br label %exit
exit:
  %d = phi x86_amx [ %d1, %if.true ], [ %d2, %if.false ]
  %a = tail call x86_amx @llvm.x86.tileloadd64.internal(i16 %0, i16 8, ptr @buf, i64 32)
  %res = tail call x86_amx @llvm.x86.tdpbssd.internal(i16 %0, i16 %1, i16 8, x86_amx %c, x86_amx %d, x86_amx %a)
  tail call void @llvm.x86.tilestored64.internal(i16 %0, i16 %1, ptr getelementptr inbounds ([3072 x i8], ptr @buf, i64 0, i64 2048), i64 32, x86_amx %res)
  ret void
}

define dso_local void @test3(ptr%buf) nounwind {
; CHECK-LABEL: test3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushq %rbp
; CHECK-NEXT:    pushq %r15
; CHECK-NEXT:    pushq %r14
; CHECK-NEXT:    pushq %rbx
; CHECK-NEXT:    subq $72, %rsp
; CHECK-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    vmovups %zmm0, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movb $1, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movb $8, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movw $8, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movb $8, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movw $8, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movb $8, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movw $8, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    ldtilecfg {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movw $8, %bp
; CHECK-NEXT:    tilezero %tmm0
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    testb %al, %al
; CHECK-NEXT:    jne .LBB1_3
; CHECK-NEXT:  # %bb.1: # %loop.header.preheader
; CHECK-NEXT:    movq %rdi, %rbx
; CHECK-NEXT:    movl $32, %r14d
; CHECK-NEXT:    xorl %r15d, %r15d
; CHECK-NEXT:    .p2align 4
; CHECK-NEXT:  .LBB1_2: # %loop.header
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    tilestored %tmm0, (%rbx,%r14)
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    tilezero %tmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    callq foo
; CHECK-NEXT:    ldtilecfg {{[0-9]+}}(%rsp)
; CHECK-NEXT:    tilezero %tmm0
; CHECK-NEXT:    tileloadd (%rbx,%r14), %tmm1
; CHECK-NEXT:    tileloadd (%rbx,%r14), %tmm2
; CHECK-NEXT:    tdpbssd %tmm2, %tmm1, %tmm0
; CHECK-NEXT:    tilestored %tmm0, (%rbx,%r14)
; CHECK-NEXT:    tilezero %tmm0
; CHECK-NEXT:    incl %r15d
; CHECK-NEXT:    cmpw $100, %r15w
; CHECK-NEXT:    jl .LBB1_2
; CHECK-NEXT:  .LBB1_3: # %exit
; CHECK-NEXT:    addq $72, %rsp
; CHECK-NEXT:    popq %rbx
; CHECK-NEXT:    popq %r14
; CHECK-NEXT:    popq %r15
; CHECK-NEXT:    popq %rbp
; CHECK-NEXT:    tilerelease
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retq
;
; EGPR-LABEL: test3:
; EGPR:       # %bb.0: # %entry
; EGPR-NEXT:    pushq %rbp # encoding: [0x55]
; EGPR-NEXT:    pushq %r15 # encoding: [0x41,0x57]
; EGPR-NEXT:    pushq %r14 # encoding: [0x41,0x56]
; EGPR-NEXT:    pushq %rbx # encoding: [0x53]
; EGPR-NEXT:    subq $72, %rsp # encoding: [0x48,0x83,0xec,0x48]
; EGPR-NEXT:    vxorps %xmm0, %xmm0, %xmm0 # encoding: [0xc5,0xf8,0x57,0xc0]
; EGPR-NEXT:    vmovups %zmm0, {{[0-9]+}}(%rsp) # encoding: [0x62,0xf1,0x7c,0x48,0x11,0x84,0x24,0x08,0x00,0x00,0x00]
; EGPR-NEXT:    movb $1, {{[0-9]+}}(%rsp) # encoding: [0xc6,0x44,0x24,0x08,0x01]
; EGPR-NEXT:    movb $8, {{[0-9]+}}(%rsp) # encoding: [0xc6,0x44,0x24,0x38,0x08]
; EGPR-NEXT:    movw $8, {{[0-9]+}}(%rsp) # encoding: [0x66,0xc7,0x44,0x24,0x18,0x08,0x00]
; EGPR-NEXT:    movb $8, {{[0-9]+}}(%rsp) # encoding: [0xc6,0x44,0x24,0x39,0x08]
; EGPR-NEXT:    movw $8, {{[0-9]+}}(%rsp) # encoding: [0x66,0xc7,0x44,0x24,0x1a,0x08,0x00]
; EGPR-NEXT:    movb $8, {{[0-9]+}}(%rsp) # encoding: [0xc6,0x44,0x24,0x3a,0x08]
; EGPR-NEXT:    movw $8, {{[0-9]+}}(%rsp) # encoding: [0x66,0xc7,0x44,0x24,0x1c,0x08,0x00]
; EGPR-NEXT:    ldtilecfg {{[0-9]+}}(%rsp) # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x78,0x49,0x44,0x24,0x08]
; EGPR-NEXT:    movw $8, %bp # encoding: [0x66,0xbd,0x08,0x00]
; EGPR-NEXT:    tilezero %tmm0 # encoding: [0xc4,0xe2,0x7b,0x49,0xc0]
; EGPR-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; EGPR-NEXT:    testb %al, %al # encoding: [0x84,0xc0]
; EGPR-NEXT:    jne .LBB1_3 # encoding: [0x75,A]
; EGPR-NEXT:    # fixup A - offset: 1, value: .LBB1_3, kind: FK_PCRel_1
; EGPR-NEXT:  # %bb.1: # %loop.header.preheader
; EGPR-NEXT:    movq %rdi, %rbx # encoding: [0x48,0x89,0xfb]
; EGPR-NEXT:    movl $32, %r14d # encoding: [0x41,0xbe,0x20,0x00,0x00,0x00]
; EGPR-NEXT:    xorl %r15d, %r15d # encoding: [0x45,0x31,0xff]
; EGPR-NEXT:    .p2align 4
; EGPR-NEXT:  .LBB1_2: # %loop.header
; EGPR-NEXT:    # =>This Inner Loop Header: Depth=1
; EGPR-NEXT:    tilestored %tmm0, (%rbx,%r14) # EVEX TO VEX Compression encoding: [0xc4,0xa2,0x7a,0x4b,0x04,0x33]
; EGPR-NEXT:    xorl %eax, %eax # encoding: [0x31,0xc0]
; EGPR-NEXT:    tilezero %tmm0 # encoding: [0xc4,0xe2,0x7b,0x49,0xc0]
; EGPR-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; EGPR-NEXT:    callq foo # encoding: [0xe8,A,A,A,A]
; EGPR-NEXT:    # fixup A - offset: 1, value: foo, kind: reloc_branch_4byte_pcrel
; EGPR-NEXT:    ldtilecfg {{[0-9]+}}(%rsp) # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x78,0x49,0x44,0x24,0x08]
; EGPR-NEXT:    tilezero %tmm0 # encoding: [0xc4,0xe2,0x7b,0x49,0xc0]
; EGPR-NEXT:    tileloadd (%rbx,%r14), %tmm1 # EVEX TO VEX Compression encoding: [0xc4,0xa2,0x7b,0x4b,0x0c,0x33]
; EGPR-NEXT:    tileloadd (%rbx,%r14), %tmm2 # EVEX TO VEX Compression encoding: [0xc4,0xa2,0x7b,0x4b,0x14,0x33]
; EGPR-NEXT:    tdpbssd %tmm2, %tmm1, %tmm0 # encoding: [0xc4,0xe2,0x6b,0x5e,0xc1]
; EGPR-NEXT:    tilestored %tmm0, (%rbx,%r14) # EVEX TO VEX Compression encoding: [0xc4,0xa2,0x7a,0x4b,0x04,0x33]
; EGPR-NEXT:    tilezero %tmm0 # encoding: [0xc4,0xe2,0x7b,0x49,0xc0]
; EGPR-NEXT:    incl %r15d # encoding: [0x41,0xff,0xc7]
; EGPR-NEXT:    cmpw $100, %r15w # encoding: [0x66,0x41,0x83,0xff,0x64]
; EGPR-NEXT:    jl .LBB1_2 # encoding: [0x7c,A]
; EGPR-NEXT:    # fixup A - offset: 1, value: .LBB1_2, kind: FK_PCRel_1
; EGPR-NEXT:  .LBB1_3: # %exit
; EGPR-NEXT:    addq $72, %rsp # encoding: [0x48,0x83,0xc4,0x48]
; EGPR-NEXT:    popq %rbx # encoding: [0x5b]
; EGPR-NEXT:    popq %r14 # encoding: [0x41,0x5e]
; EGPR-NEXT:    popq %r15 # encoding: [0x41,0x5f]
; EGPR-NEXT:    popq %rbp # encoding: [0x5d]
; EGPR-NEXT:    tilerelease # encoding: [0xc4,0xe2,0x78,0x49,0xc0]
; EGPR-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; EGPR-NEXT:    retq # encoding: [0xc3]
entry:
  %t5 = tail call x86_amx @llvm.x86.tilezero.internal(i16 8, i16 8)
  br i1 undef, label %loop.header, label %exit

loop.header:
  %ivphi = phi i16 [0, %entry], [%iv, %loop.latch]
  call void @llvm.x86.tilestored64.internal(i16 8, i16 8, ptr %buf, i64 32, x86_amx %t5)
  call void (...) @foo()
  br label %loop.body

loop.body:
  %t1 = tail call x86_amx @llvm.x86.tilezero.internal(i16 8, i16 8)
  %t2 = tail call x86_amx @llvm.x86.tileloadd64.internal(i16 8, i16 8, ptr %buf, i64 32)
  %t3 = tail call x86_amx @llvm.x86.tileloadd64.internal(i16 8, i16 8, ptr %buf, i64 32)
  %t4 = tail call x86_amx @llvm.x86.tdpbssd.internal(i16 8, i16 8, i16 8, x86_amx %t1, x86_amx %t2, x86_amx %t3)
  tail call void @llvm.x86.tilestored64.internal(i16 8, i16 8, ptr %buf, i64 32, x86_amx %t4)
  br label %loop.latch

loop.latch:
  %iv = add i16 %ivphi, 1
  %c = icmp slt i16 %iv, 100
  br i1 %c, label %loop.header, label %exit

exit:
  ret void
}

declare dso_local void @foo(...) nounwind

declare x86_amx @llvm.x86.tilezero.internal(i16, i16)
declare x86_amx @llvm.x86.tileloadd64.internal(i16, i16, ptr, i64)
declare x86_amx @llvm.x86.tdpbssd.internal(i16, i16, i16, x86_amx, x86_amx, x86_amx)
declare void @llvm.x86.tilestored64.internal(i16, i16, ptr, i64, x86_amx)
