; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; Test the handling of incoming vector arguments.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s

; This routine has 10 vector arguments, which fill up %v24-%v31 and
; the two double-wide stack slots at 160 and 176.
define <4 x i32> @foo(<4 x i32> %v1, <4 x i32> %v2, <4 x i32> %v3, <4 x i32> %v4,
; CHECK-LABEL: foo:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 176(%r15), 3
; CHECK-NEXT:    vsf %v24, %v26, %v0
; CHECK-NEXT:    br %r14
                      <4 x i32> %v5, <4 x i32> %v6, <4 x i32> %v7, <4 x i32> %v8,
                      <4 x i32> %v9, <4 x i32> %v10) {
  %y = sub <4 x i32> %v2, %v10
  ret <4 x i32> %y
}

; This routine has 10 vector arguments, which fill up %v24-%v31 and
; the two single-wide stack slots at 160 and 168.
define <4 x i8> @bar(<4 x i8> %v1, <4 x i8> %v2, <4 x i8> %v3, <4 x i8> %v4,
; CHECK-LABEL: bar:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vlrepg %v0, 168(%r15)
; CHECK-NEXT:    vsb %v24, %v26, %v0
; CHECK-NEXT:    br %r14
                     <4 x i8> %v5, <4 x i8> %v6, <4 x i8> %v7, <4 x i8> %v8,
                     <4 x i8> %v9, <4 x i8> %v10) {
  %y = sub <4 x i8> %v2, %v10
  ret <4 x i8> %y
}

