; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; Test the three-operand form of 32-bit subtraction.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z196 | FileCheck %s

declare i32 @foo(i32, i32, i32)

; Check SLRK.
define i32 @f1(i32 %dummy, i32 %a, i32 %b, ptr %flag) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slrk %r2, %r3, %r4
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    afi %r0, -536870912
; CHECK-NEXT:    srl %r0, 31
; CHECK-NEXT:    st %r0, 0(%r5)
; CHECK-NEXT:    br %r14
  %t = call {i32, i1} @llvm.usub.with.overflow.i32(i32 %a, i32 %b)
  %val = extractvalue {i32, i1} %t, 0
  %obit = extractvalue {i32, i1} %t, 1
  %ext = zext i1 %obit to i32
  store i32 %ext, ptr %flag
  ret i32 %val
}

; Check using the overflow result for a branch.
define i32 @f2(i32 %dummy, i32 %a, i32 %b) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slrk %r2, %r3, %r4
; CHECK-NEXT:    bnler %r14
; CHECK-NEXT:  .LBB1_1: # %call
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    jg foo@PLT
  %t = call {i32, i1} @llvm.usub.with.overflow.i32(i32 %a, i32 %b)
  %val = extractvalue {i32, i1} %t, 0
  %obit = extractvalue {i32, i1} %t, 1
  br i1 %obit, label %call, label %exit

call:
  %res = tail call i32 @foo(i32 0, i32 %a, i32 %b)
  ret i32 %res

exit:
  ret i32 %val
}

; ... and the same with the inverted direction.
define i32 @f3(i32 %dummy, i32 %a, i32 %b) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slrk %r2, %r3, %r4
; CHECK-NEXT:    bler %r14
; CHECK-NEXT:  .LBB2_1: # %call
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    jg foo@PLT
  %t = call {i32, i1} @llvm.usub.with.overflow.i32(i32 %a, i32 %b)
  %val = extractvalue {i32, i1} %t, 0
  %obit = extractvalue {i32, i1} %t, 1
  br i1 %obit, label %exit, label %call

call:
  %res = tail call i32 @foo(i32 0, i32 %a, i32 %b)
  ret i32 %res

exit:
  ret i32 %val
}

; Check that we can still use SLR in obvious cases.
define i32 @f4(i32 %a, i32 %b, ptr %flag) {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slr %r2, %r3
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    afi %r0, -536870912
; CHECK-NEXT:    srl %r0, 31
; CHECK-NEXT:    st %r0, 0(%r4)
; CHECK-NEXT:    br %r14
  %t = call {i32, i1} @llvm.usub.with.overflow.i32(i32 %a, i32 %b)
  %val = extractvalue {i32, i1} %t, 0
  %obit = extractvalue {i32, i1} %t, 1
  %ext = zext i1 %obit to i32
  store i32 %ext, ptr %flag
  ret i32 %val
}

declare {i32, i1} @llvm.usub.with.overflow.i32(i32, i32) nounwind readnone

