; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=sparc < %s | FileCheck %s -check-prefix=SOFT-FLOAT-32
; RUN: llc -mtriple=sparc64 < %s | FileCheck %s -check-prefix=SOFT-FLOAT-64

define float @fmuladd_intrinsic_f32(float %a, float %b, float %c) #0 {
; SOFT-FLOAT-32-LABEL: fmuladd_intrinsic_f32:
; SOFT-FLOAT-32:         .cfi_startproc
; SOFT-FLOAT-32-NEXT:  ! %bb.0:
; SOFT-FLOAT-32-NEXT:    save %sp, -96, %sp
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_register %fp
; SOFT-FLOAT-32-NEXT:    .cfi_window_save
; SOFT-FLOAT-32-NEXT:    .cfi_register %o7, %i7
; SOFT-FLOAT-32-NEXT:    mov %i1, %o1
; SOFT-FLOAT-32-NEXT:    call __mulsf3
; SOFT-FLOAT-32-NEXT:    mov %i0, %o0
; SOFT-FLOAT-32-NEXT:    call __addsf3
; SOFT-FLOAT-32-NEXT:    mov %i2, %o1
; SOFT-FLOAT-32-NEXT:    ret
; SOFT-FLOAT-32-NEXT:    restore %g0, %o0, %o0
;
; SOFT-FLOAT-64-LABEL: fmuladd_intrinsic_f32:
; SOFT-FLOAT-64:         .cfi_startproc
; SOFT-FLOAT-64-NEXT:  ! %bb.0:
; SOFT-FLOAT-64-NEXT:    save %sp, -176, %sp
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_register %fp
; SOFT-FLOAT-64-NEXT:    .cfi_window_save
; SOFT-FLOAT-64-NEXT:    .cfi_register %o7, %i7
; SOFT-FLOAT-64-NEXT:    srl %i0, 0, %o0
; SOFT-FLOAT-64-NEXT:    call __mulsf3
; SOFT-FLOAT-64-NEXT:    srl %i1, 0, %o1
; SOFT-FLOAT-64-NEXT:    call __addsf3
; SOFT-FLOAT-64-NEXT:    srl %i2, 0, %o1
; SOFT-FLOAT-64-NEXT:    ret
; SOFT-FLOAT-64-NEXT:    restore %g0, %o0, %o0
  %result = call float @llvm.fmuladd.f32(float %a, float %b, float %c)
  ret float %result
}

define double @fmuladd_intrinsic_f64(double %a, double %b, double %c) #0 {
; SOFT-FLOAT-32-LABEL: fmuladd_intrinsic_f64:
; SOFT-FLOAT-32:         .cfi_startproc
; SOFT-FLOAT-32-NEXT:  ! %bb.0:
; SOFT-FLOAT-32-NEXT:    save %sp, -96, %sp
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_register %fp
; SOFT-FLOAT-32-NEXT:    .cfi_window_save
; SOFT-FLOAT-32-NEXT:    .cfi_register %o7, %i7
; SOFT-FLOAT-32-NEXT:    mov %i3, %o3
; SOFT-FLOAT-32-NEXT:    mov %i2, %o2
; SOFT-FLOAT-32-NEXT:    mov %i1, %o1
; SOFT-FLOAT-32-NEXT:    call __muldf3
; SOFT-FLOAT-32-NEXT:    mov %i0, %o0
; SOFT-FLOAT-32-NEXT:    mov %i4, %o2
; SOFT-FLOAT-32-NEXT:    call __adddf3
; SOFT-FLOAT-32-NEXT:    mov %i5, %o3
; SOFT-FLOAT-32-NEXT:    mov %o0, %i0
; SOFT-FLOAT-32-NEXT:    ret
; SOFT-FLOAT-32-NEXT:    restore %g0, %o1, %o1
;
; SOFT-FLOAT-64-LABEL: fmuladd_intrinsic_f64:
; SOFT-FLOAT-64:         .cfi_startproc
; SOFT-FLOAT-64-NEXT:  ! %bb.0:
; SOFT-FLOAT-64-NEXT:    save %sp, -176, %sp
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_register %fp
; SOFT-FLOAT-64-NEXT:    .cfi_window_save
; SOFT-FLOAT-64-NEXT:    .cfi_register %o7, %i7
; SOFT-FLOAT-64-NEXT:    mov %i1, %o1
; SOFT-FLOAT-64-NEXT:    call __muldf3
; SOFT-FLOAT-64-NEXT:    mov %i0, %o0
; SOFT-FLOAT-64-NEXT:    call __adddf3
; SOFT-FLOAT-64-NEXT:    mov %i2, %o1
; SOFT-FLOAT-64-NEXT:    ret
; SOFT-FLOAT-64-NEXT:    restore %g0, %o0, %o0
  %result = call double @llvm.fmuladd.f64(double %a, double %b, double %c)
  ret double %result
}

define float @fmuladd_contract_f32(float %a, float %b, float %c) #0 {
; SOFT-FLOAT-32-LABEL: fmuladd_contract_f32:
; SOFT-FLOAT-32:         .cfi_startproc
; SOFT-FLOAT-32-NEXT:  ! %bb.0:
; SOFT-FLOAT-32-NEXT:    save %sp, -96, %sp
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_register %fp
; SOFT-FLOAT-32-NEXT:    .cfi_window_save
; SOFT-FLOAT-32-NEXT:    .cfi_register %o7, %i7
; SOFT-FLOAT-32-NEXT:    mov %i1, %o1
; SOFT-FLOAT-32-NEXT:    call __mulsf3
; SOFT-FLOAT-32-NEXT:    mov %i0, %o0
; SOFT-FLOAT-32-NEXT:    call __addsf3
; SOFT-FLOAT-32-NEXT:    mov %i2, %o1
; SOFT-FLOAT-32-NEXT:    ret
; SOFT-FLOAT-32-NEXT:    restore %g0, %o0, %o0
;
; SOFT-FLOAT-64-LABEL: fmuladd_contract_f32:
; SOFT-FLOAT-64:         .cfi_startproc
; SOFT-FLOAT-64-NEXT:  ! %bb.0:
; SOFT-FLOAT-64-NEXT:    save %sp, -176, %sp
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_register %fp
; SOFT-FLOAT-64-NEXT:    .cfi_window_save
; SOFT-FLOAT-64-NEXT:    .cfi_register %o7, %i7
; SOFT-FLOAT-64-NEXT:    srl %i0, 0, %o0
; SOFT-FLOAT-64-NEXT:    call __mulsf3
; SOFT-FLOAT-64-NEXT:    srl %i1, 0, %o1
; SOFT-FLOAT-64-NEXT:    call __addsf3
; SOFT-FLOAT-64-NEXT:    srl %i2, 0, %o1
; SOFT-FLOAT-64-NEXT:    ret
; SOFT-FLOAT-64-NEXT:    restore %g0, %o0, %o0
  %product = fmul contract float %a, %b
  %result = fadd contract float %product, %c
  ret float %result
}

define double @fmuladd_contract_f64(double %a, double %b, double %c) #0 {
; SOFT-FLOAT-32-LABEL: fmuladd_contract_f64:
; SOFT-FLOAT-32:         .cfi_startproc
; SOFT-FLOAT-32-NEXT:  ! %bb.0:
; SOFT-FLOAT-32-NEXT:    save %sp, -96, %sp
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_register %fp
; SOFT-FLOAT-32-NEXT:    .cfi_window_save
; SOFT-FLOAT-32-NEXT:    .cfi_register %o7, %i7
; SOFT-FLOAT-32-NEXT:    mov %i3, %o3
; SOFT-FLOAT-32-NEXT:    mov %i2, %o2
; SOFT-FLOAT-32-NEXT:    mov %i1, %o1
; SOFT-FLOAT-32-NEXT:    call __muldf3
; SOFT-FLOAT-32-NEXT:    mov %i0, %o0
; SOFT-FLOAT-32-NEXT:    mov %i4, %o2
; SOFT-FLOAT-32-NEXT:    call __adddf3
; SOFT-FLOAT-32-NEXT:    mov %i5, %o3
; SOFT-FLOAT-32-NEXT:    mov %o0, %i0
; SOFT-FLOAT-32-NEXT:    ret
; SOFT-FLOAT-32-NEXT:    restore %g0, %o1, %o1
;
; SOFT-FLOAT-64-LABEL: fmuladd_contract_f64:
; SOFT-FLOAT-64:         .cfi_startproc
; SOFT-FLOAT-64-NEXT:  ! %bb.0:
; SOFT-FLOAT-64-NEXT:    save %sp, -176, %sp
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_register %fp
; SOFT-FLOAT-64-NEXT:    .cfi_window_save
; SOFT-FLOAT-64-NEXT:    .cfi_register %o7, %i7
; SOFT-FLOAT-64-NEXT:    mov %i1, %o1
; SOFT-FLOAT-64-NEXT:    call __muldf3
; SOFT-FLOAT-64-NEXT:    mov %i0, %o0
; SOFT-FLOAT-64-NEXT:    call __adddf3
; SOFT-FLOAT-64-NEXT:    mov %i2, %o1
; SOFT-FLOAT-64-NEXT:    ret
; SOFT-FLOAT-64-NEXT:    restore %g0, %o0, %o0
  %product = fmul contract double %a, %b
  %result = fadd contract double %product, %c
  ret double %result
}

define <4 x float> @fmuladd_contract_v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %c) #0 {
; SOFT-FLOAT-32-LABEL: fmuladd_contract_v4f32:
; SOFT-FLOAT-32:         .cfi_startproc
; SOFT-FLOAT-32-NEXT:  ! %bb.0:
; SOFT-FLOAT-32-NEXT:    save %sp, -96, %sp
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_register %fp
; SOFT-FLOAT-32-NEXT:    .cfi_window_save
; SOFT-FLOAT-32-NEXT:    .cfi_register %o7, %i7
; SOFT-FLOAT-32-NEXT:    ld [%fp+100], %l0
; SOFT-FLOAT-32-NEXT:    ld [%fp+104], %l1
; SOFT-FLOAT-32-NEXT:    ld [%fp+108], %l2
; SOFT-FLOAT-32-NEXT:    ld [%fp+112], %l3
; SOFT-FLOAT-32-NEXT:    ld [%fp+96], %l4
; SOFT-FLOAT-32-NEXT:    ld [%fp+92], %l5
; SOFT-FLOAT-32-NEXT:    mov %i4, %o1
; SOFT-FLOAT-32-NEXT:    call __mulsf3
; SOFT-FLOAT-32-NEXT:    mov %i0, %o0
; SOFT-FLOAT-32-NEXT:    mov %o0, %i0
; SOFT-FLOAT-32-NEXT:    mov %i1, %o0
; SOFT-FLOAT-32-NEXT:    call __mulsf3
; SOFT-FLOAT-32-NEXT:    mov %i5, %o1
; SOFT-FLOAT-32-NEXT:    mov %o0, %i1
; SOFT-FLOAT-32-NEXT:    mov %i2, %o0
; SOFT-FLOAT-32-NEXT:    call __mulsf3
; SOFT-FLOAT-32-NEXT:    mov %l5, %o1
; SOFT-FLOAT-32-NEXT:    mov %o0, %i2
; SOFT-FLOAT-32-NEXT:    mov %i3, %o0
; SOFT-FLOAT-32-NEXT:    call __mulsf3
; SOFT-FLOAT-32-NEXT:    mov %l4, %o1
; SOFT-FLOAT-32-NEXT:    call __addsf3
; SOFT-FLOAT-32-NEXT:    mov %l3, %o1
; SOFT-FLOAT-32-NEXT:    mov %o0, %i3
; SOFT-FLOAT-32-NEXT:    mov %i2, %o0
; SOFT-FLOAT-32-NEXT:    call __addsf3
; SOFT-FLOAT-32-NEXT:    mov %l2, %o1
; SOFT-FLOAT-32-NEXT:    mov %o0, %i4
; SOFT-FLOAT-32-NEXT:    mov %i1, %o0
; SOFT-FLOAT-32-NEXT:    call __addsf3
; SOFT-FLOAT-32-NEXT:    mov %l1, %o1
; SOFT-FLOAT-32-NEXT:    mov %o0, %i1
; SOFT-FLOAT-32-NEXT:    mov %i0, %o0
; SOFT-FLOAT-32-NEXT:    call __addsf3
; SOFT-FLOAT-32-NEXT:    mov %l0, %o1
; SOFT-FLOAT-32-NEXT:    ! kill: def $o0 killed $o0 def $o0_o1
; SOFT-FLOAT-32-NEXT:    mov %o0, %i0
; SOFT-FLOAT-32-NEXT:    ret
; SOFT-FLOAT-32-NEXT:    restore %g0, %i4, %o2
;
; SOFT-FLOAT-64-LABEL: fmuladd_contract_v4f32:
; SOFT-FLOAT-64:         .cfi_startproc
; SOFT-FLOAT-64-NEXT:  ! %bb.0:
; SOFT-FLOAT-64-NEXT:    save %sp, -176, %sp
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_register %fp
; SOFT-FLOAT-64-NEXT:    .cfi_window_save
; SOFT-FLOAT-64-NEXT:    .cfi_register %o7, %i7
; SOFT-FLOAT-64-NEXT:    ld [%fp+2267], %l0
; SOFT-FLOAT-64-NEXT:    ld [%fp+2259], %l1
; SOFT-FLOAT-64-NEXT:    ld [%fp+2251], %l2
; SOFT-FLOAT-64-NEXT:    ld [%fp+2243], %l3
; SOFT-FLOAT-64-NEXT:    ld [%fp+2227], %l4
; SOFT-FLOAT-64-NEXT:    ld [%fp+2235], %o1
; SOFT-FLOAT-64-NEXT:    call __mulsf3
; SOFT-FLOAT-64-NEXT:    srl %i3, 0, %o0
; SOFT-FLOAT-64-NEXT:    mov %o0, %i3
; SOFT-FLOAT-64-NEXT:    srl %i2, 0, %o0
; SOFT-FLOAT-64-NEXT:    call __mulsf3
; SOFT-FLOAT-64-NEXT:    mov %l4, %o1
; SOFT-FLOAT-64-NEXT:    mov %o0, %i2
; SOFT-FLOAT-64-NEXT:    srl %i1, 0, %o0
; SOFT-FLOAT-64-NEXT:    call __mulsf3
; SOFT-FLOAT-64-NEXT:    srl %i5, 0, %o1
; SOFT-FLOAT-64-NEXT:    mov %o0, %i1
; SOFT-FLOAT-64-NEXT:    srl %i0, 0, %o0
; SOFT-FLOAT-64-NEXT:    call __mulsf3
; SOFT-FLOAT-64-NEXT:    srl %i4, 0, %o1
; SOFT-FLOAT-64-NEXT:    call __addsf3
; SOFT-FLOAT-64-NEXT:    mov %l3, %o1
; SOFT-FLOAT-64-NEXT:    mov %o0, %i0
; SOFT-FLOAT-64-NEXT:    mov %i1, %o0
; SOFT-FLOAT-64-NEXT:    call __addsf3
; SOFT-FLOAT-64-NEXT:    mov %l2, %o1
; SOFT-FLOAT-64-NEXT:    mov %o0, %i1
; SOFT-FLOAT-64-NEXT:    mov %i2, %o0
; SOFT-FLOAT-64-NEXT:    call __addsf3
; SOFT-FLOAT-64-NEXT:    mov %l1, %o1
; SOFT-FLOAT-64-NEXT:    mov %o0, %i2
; SOFT-FLOAT-64-NEXT:    mov %i3, %o0
; SOFT-FLOAT-64-NEXT:    call __addsf3
; SOFT-FLOAT-64-NEXT:    mov %l0, %o1
; SOFT-FLOAT-64-NEXT:    ret
; SOFT-FLOAT-64-NEXT:    restore %g0, %o0, %o3
  %product = fmul contract <4 x float> %a, %b
  %result = fadd contract <4 x float> %product, %c
  ret <4 x float> %result
}

define <4 x double> @fmuladd_contract_v4f64(<4 x double> %a, <4 x double> %b, <4 x double> %c) #0 {
; SOFT-FLOAT-32-LABEL: fmuladd_contract_v4f64:
; SOFT-FLOAT-32:         .cfi_startproc
; SOFT-FLOAT-32-NEXT:  ! %bb.0:
; SOFT-FLOAT-32-NEXT:    save %sp, -128, %sp
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_register %fp
; SOFT-FLOAT-32-NEXT:    .cfi_window_save
; SOFT-FLOAT-32-NEXT:    .cfi_register %o7, %i7
; SOFT-FLOAT-32-NEXT:    ld [%fp+64], %l6
; SOFT-FLOAT-32-NEXT:    ld [%fp+156], %g2
; SOFT-FLOAT-32-NEXT:    st %g2, [%fp+-4] ! 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    ld [%fp+160], %g2
; SOFT-FLOAT-32-NEXT:    st %g2, [%fp+-8] ! 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    ld [%fp+148], %g2
; SOFT-FLOAT-32-NEXT:    st %g2, [%fp+-12] ! 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    ld [%fp+152], %g2
; SOFT-FLOAT-32-NEXT:    st %g2, [%fp+-16] ! 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    ld [%fp+140], %g2
; SOFT-FLOAT-32-NEXT:    st %g2, [%fp+-20] ! 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    ld [%fp+144], %g2
; SOFT-FLOAT-32-NEXT:    st %g2, [%fp+-24] ! 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    ld [%fp+132], %g2
; SOFT-FLOAT-32-NEXT:    st %g2, [%fp+-28] ! 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    ld [%fp+136], %l7
; SOFT-FLOAT-32-NEXT:    ld [%fp+100], %l0
; SOFT-FLOAT-32-NEXT:    ld [%fp+104], %l1
; SOFT-FLOAT-32-NEXT:    ld [%fp+108], %l2
; SOFT-FLOAT-32-NEXT:    ld [%fp+112], %l3
; SOFT-FLOAT-32-NEXT:    ld [%fp+116], %l4
; SOFT-FLOAT-32-NEXT:    ld [%fp+120], %l5
; SOFT-FLOAT-32-NEXT:    ld [%fp+92], %o0
; SOFT-FLOAT-32-NEXT:    ld [%fp+96], %o1
; SOFT-FLOAT-32-NEXT:    ld [%fp+124], %o2
; SOFT-FLOAT-32-NEXT:    call __muldf3
; SOFT-FLOAT-32-NEXT:    ld [%fp+128], %o3
; SOFT-FLOAT-32-NEXT:    st %o0, [%fp+-32] ! 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    st %o1, [%fp+-36] ! 4-byte Folded Spill
; SOFT-FLOAT-32-NEXT:    mov %i4, %o0
; SOFT-FLOAT-32-NEXT:    mov %i5, %o1
; SOFT-FLOAT-32-NEXT:    mov %l4, %o2
; SOFT-FLOAT-32-NEXT:    call __muldf3
; SOFT-FLOAT-32-NEXT:    mov %l5, %o3
; SOFT-FLOAT-32-NEXT:    mov %o0, %l4
; SOFT-FLOAT-32-NEXT:    mov %o1, %l5
; SOFT-FLOAT-32-NEXT:    mov %i2, %o0
; SOFT-FLOAT-32-NEXT:    mov %i3, %o1
; SOFT-FLOAT-32-NEXT:    mov %l2, %o2
; SOFT-FLOAT-32-NEXT:    call __muldf3
; SOFT-FLOAT-32-NEXT:    mov %l3, %o3
; SOFT-FLOAT-32-NEXT:    mov %o0, %i4
; SOFT-FLOAT-32-NEXT:    mov %o1, %i5
; SOFT-FLOAT-32-NEXT:    mov %i0, %o0
; SOFT-FLOAT-32-NEXT:    mov %i1, %o1
; SOFT-FLOAT-32-NEXT:    mov %l0, %o2
; SOFT-FLOAT-32-NEXT:    call __muldf3
; SOFT-FLOAT-32-NEXT:    mov %l1, %o3
; SOFT-FLOAT-32-NEXT:    ld [%fp+-28], %o2 ! 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    call __adddf3
; SOFT-FLOAT-32-NEXT:    mov %l7, %o3
; SOFT-FLOAT-32-NEXT:    mov %o0, %i2
; SOFT-FLOAT-32-NEXT:    mov %o1, %i3
; SOFT-FLOAT-32-NEXT:    mov %i4, %o0
; SOFT-FLOAT-32-NEXT:    mov %i5, %o1
; SOFT-FLOAT-32-NEXT:    ld [%fp+-20], %o2 ! 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    call __adddf3
; SOFT-FLOAT-32-NEXT:    ld [%fp+-24], %o3
; SOFT-FLOAT-32-NEXT:    mov %o0, %i4
; SOFT-FLOAT-32-NEXT:    mov %o1, %i5
; SOFT-FLOAT-32-NEXT:    mov %l4, %o0
; SOFT-FLOAT-32-NEXT:    mov %l5, %o1
; SOFT-FLOAT-32-NEXT:    ld [%fp+-12], %o2 ! 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    call __adddf3
; SOFT-FLOAT-32-NEXT:    ld [%fp+-16], %o3
; SOFT-FLOAT-32-NEXT:    mov %o0, %i0
; SOFT-FLOAT-32-NEXT:    mov %o1, %i1
; SOFT-FLOAT-32-NEXT:    ld [%fp+-32], %o0 ! 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    ld [%fp+-36], %o1 ! 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    ld [%fp+-4], %o2 ! 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    call __adddf3
; SOFT-FLOAT-32-NEXT:    ld [%fp+-8], %o3
; SOFT-FLOAT-32-NEXT:    ! kill: def $o0 killed $o0 killed $o0_o1 def $o0_o1
; SOFT-FLOAT-32-NEXT:    ! kill: def $o1 killed $o1 killed $o0_o1 def $o0_o1
; SOFT-FLOAT-32-NEXT:    std %o0, [%l6+24]
; SOFT-FLOAT-32-NEXT:    std %i0, [%l6+16]
; SOFT-FLOAT-32-NEXT:    std %i4, [%l6+8]
; SOFT-FLOAT-32-NEXT:    std %i2, [%l6]
; SOFT-FLOAT-32-NEXT:    ret
; SOFT-FLOAT-32-NEXT:    restore
;
; SOFT-FLOAT-64-LABEL: fmuladd_contract_v4f64:
; SOFT-FLOAT-64:         .cfi_startproc
; SOFT-FLOAT-64-NEXT:  ! %bb.0:
; SOFT-FLOAT-64-NEXT:    save %sp, -176, %sp
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_register %fp
; SOFT-FLOAT-64-NEXT:    .cfi_window_save
; SOFT-FLOAT-64-NEXT:    .cfi_register %o7, %i7
; SOFT-FLOAT-64-NEXT:    ldx [%fp+2263], %l0
; SOFT-FLOAT-64-NEXT:    ldx [%fp+2255], %l1
; SOFT-FLOAT-64-NEXT:    ldx [%fp+2247], %l2
; SOFT-FLOAT-64-NEXT:    ldx [%fp+2239], %l3
; SOFT-FLOAT-64-NEXT:    ldx [%fp+2223], %l4
; SOFT-FLOAT-64-NEXT:    ldx [%fp+2231], %o1
; SOFT-FLOAT-64-NEXT:    call __muldf3
; SOFT-FLOAT-64-NEXT:    mov %i3, %o0
; SOFT-FLOAT-64-NEXT:    mov %o0, %i3
; SOFT-FLOAT-64-NEXT:    mov %i2, %o0
; SOFT-FLOAT-64-NEXT:    call __muldf3
; SOFT-FLOAT-64-NEXT:    mov %l4, %o1
; SOFT-FLOAT-64-NEXT:    mov %o0, %i2
; SOFT-FLOAT-64-NEXT:    mov %i1, %o0
; SOFT-FLOAT-64-NEXT:    call __muldf3
; SOFT-FLOAT-64-NEXT:    mov %i5, %o1
; SOFT-FLOAT-64-NEXT:    mov %o0, %i1
; SOFT-FLOAT-64-NEXT:    mov %i0, %o0
; SOFT-FLOAT-64-NEXT:    call __muldf3
; SOFT-FLOAT-64-NEXT:    mov %i4, %o1
; SOFT-FLOAT-64-NEXT:    call __adddf3
; SOFT-FLOAT-64-NEXT:    mov %l3, %o1
; SOFT-FLOAT-64-NEXT:    mov %o0, %i0
; SOFT-FLOAT-64-NEXT:    mov %i1, %o0
; SOFT-FLOAT-64-NEXT:    call __adddf3
; SOFT-FLOAT-64-NEXT:    mov %l2, %o1
; SOFT-FLOAT-64-NEXT:    mov %o0, %i1
; SOFT-FLOAT-64-NEXT:    mov %i2, %o0
; SOFT-FLOAT-64-NEXT:    call __adddf3
; SOFT-FLOAT-64-NEXT:    mov %l1, %o1
; SOFT-FLOAT-64-NEXT:    mov %o0, %i2
; SOFT-FLOAT-64-NEXT:    mov %i3, %o0
; SOFT-FLOAT-64-NEXT:    call __adddf3
; SOFT-FLOAT-64-NEXT:    mov %l0, %o1
; SOFT-FLOAT-64-NEXT:    ret
; SOFT-FLOAT-64-NEXT:    restore %g0, %o0, %o3
  %product = fmul contract <4 x double> %a, %b
  %result = fadd contract <4 x double> %product, %c
  ret <4 x double> %result
}

attributes #0 = { "use-soft-float"="true" }

declare float @llvm.fmuladd.f32(float %a, float %b, float %c)
declare double @llvm.fmuladd.f64(double %a, double %b, double %c)
