; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-linux-gnu < %s \
; RUN: | FileCheck --check-prefix=CHECK-LE %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-linux-gnu -mattr=+vsx < %s \
; RUN: | FileCheck --check-prefix=CHECK-BE %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-ibm-aix-xcoff -mattr=+vsx \
; RUN: -vec-extabi < %s | FileCheck --check-prefix=CHECK-BE %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-linux-gnu -mcpu=pwr9 < %s \
; RUN: | FileCheck --check-prefix=CHECK-P9LE %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-linux-gnu -mcpu=pwr9 < %s \
; RUN: | FileCheck --check-prefix=CHECK-P9BE %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-ibm-aix-xcoff -mcpu=pwr9 \
; RUN: -vec-extabi < %s | FileCheck --check-prefix=CHECK-BE %s

define double @splat_swap(<2 x double> %x, <2 x double> %y) nounwind  {
; CHECK-LE-LABEL: splat_swap:
; CHECK-LE:       # %bb.0:
; CHECK-LE-NEXT:    xvadddp 0, 34, 35
; CHECK-LE-NEXT:    xvrdpic 0, 0
; CHECK-LE-NEXT:    xxswapd 1, 0
; CHECK-LE-NEXT:    xssubdp 1, 1, 0
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: splat_swap:
; CHECK-BE:       # %bb.0:
; CHECK-BE-NEXT:    xvadddp 0, 34, 35
; CHECK-BE-NEXT:    xvrdpic 0, 0
; CHECK-BE-NEXT:    xxswapd 1, 0
; CHECK-BE-NEXT:    xssubdp 1, 0, 1
; CHECK-BE-NEXT:    blr
;
; CHECK-P9LE-LABEL: splat_swap:
; CHECK-P9LE:       # %bb.0:
; CHECK-P9LE-NEXT:    xvadddp 0, 34, 35
; CHECK-P9LE-NEXT:    xvrdpic 0, 0
; CHECK-P9LE-NEXT:    xxswapd 1, 0
; CHECK-P9LE-NEXT:    xssubdp 1, 1, 0
; CHECK-P9LE-NEXT:    blr
;
; CHECK-P9BE-LABEL: splat_swap:
; CHECK-P9BE:       # %bb.0:
; CHECK-P9BE-NEXT:    xvadddp 0, 34, 35
; CHECK-P9BE-NEXT:    xvrdpic 0, 0
; CHECK-P9BE-NEXT:    xxswapd 1, 0
; CHECK-P9BE-NEXT:    xssubdp 1, 0, 1
; CHECK-P9BE-NEXT:    blr
  %added = fadd <2 x double> %x, %y
  %call = tail call <2 x double> @llvm.rint.v2f64(<2 x double> %added) nounwind readnone
  %res1 = extractelement <2 x double> %call, i32 0
  %res2 = extractelement <2 x double> %call, i32 1
  %ret = fsub double %res1, %res2
  ret double %ret
}

declare <2 x double> @llvm.rint.v2f64(<2 x double>)

