; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc  -verify-machineinstrs -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:      -mtriple powerpc64-ibm-aix-xcoff -mattr=-aix-small-local-exec-tls \
; RUN:      < %s | FileCheck %s --check-prefixes=COMMONCM,SMALLCM64
; RUN: llc  -verify-machineinstrs -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:      -mtriple powerpc64-ibm-aix-xcoff --code-model=large \
; RUN:      -mattr=-aix-small-local-exec-tls < %s | \
; RUN:      FileCheck %s --check-prefixes=COMMONCM,LARGECM64

; Test that the 'aix-small-tls' global variable attribute generates the
; optimized small-local-exec TLS sequence. Global variables without this
; attribute should still generate a TOC-based local-exec access sequence.

declare nonnull ptr @llvm.threadlocal.address.p0(ptr nonnull)

@a = thread_local(localexec) global [87 x i8] zeroinitializer, align 1 #0
@a_noattr = thread_local(localexec) global [87 x i8] zeroinitializer, align 1
@b = thread_local(localexec) global [87 x i16] zeroinitializer, align 2 #0
@b_noattr = thread_local(localexec) global [87 x i16] zeroinitializer, align 2
@c = thread_local(localexec) global [87 x i32] zeroinitializer, align 4 #0
@c_noattr = thread_local(localexec) global [87 x i32] zeroinitializer, align 4
@d = thread_local(localexec) global [87 x i64] zeroinitializer, align 8 #0
@d_noattr = thread_local(localexec) global [87 x i64] zeroinitializer, align 8 #0

@e = thread_local(localexec) global [87 x double] zeroinitializer, align 8 #0
@e_noattr = thread_local(localexec) global [87 x double] zeroinitializer, align 8
@f = thread_local(localexec) global [87 x float] zeroinitializer, align 4 #0
@f_noattr = thread_local(localexec) global [87 x float] zeroinitializer, align 4

define nonnull ptr @AddrTest1() {
; COMMONCM-LABEL: AddrTest1:
; COMMONCM:       # %bb.0: # %entry
; COMMONCM-NEXT:    addi r3, r13, a[TL]@le+1
; COMMONCM-NEXT:    blr
entry:
  %tls0 = tail call align 1 ptr @llvm.threadlocal.address.p0(ptr align 1 @a)
  %arrayidx = getelementptr inbounds [87 x i8], ptr %tls0, i64 0, i64 1
  ret ptr %arrayidx
}

define nonnull ptr @AddrTest1_NoAttr() {
; SMALLCM64-LABEL: AddrTest1_NoAttr:
; SMALLCM64:       # %bb.0: # %entry
; SMALLCM64-NEXT:    ld r3, L..C0(r2) # target-flags(ppc-tprel) @a_noattr
; SMALLCM64-NEXT:    add r3, r13, r3
; SMALLCM64-NEXT:    addi r3, r3, 1
; SMALLCM64-NEXT:    blr
;
; LARGECM64-LABEL: AddrTest1_NoAttr:
; LARGECM64:       # %bb.0: # %entry
; LARGECM64-NEXT:    addis r3, L..C0@u(r2)
; LARGECM64-NEXT:    ld r3, L..C0@l(r3)
; LARGECM64-NEXT:    add r3, r13, r3
; LARGECM64-NEXT:    addi r3, r3, 1
; LARGECM64-NEXT:    blr
entry:
  %tls0 = tail call align 1 ptr @llvm.threadlocal.address.p0(ptr align 1 @a_noattr)
  %arrayidx = getelementptr inbounds [87 x i8], ptr %tls0, i64 0, i64 1
  ret ptr %arrayidx
}

define nonnull ptr @AddrTest2() {
; COMMONCM-LABEL: AddrTest2:
; COMMONCM:       # %bb.0: # %entry
; COMMONCM-NEXT:    addi r3, r13, b[TL]@le+4
; COMMONCM-NEXT:    blr
entry:
  %tls0 = tail call align 2 ptr @llvm.threadlocal.address.p0(ptr align 2 @b)
  %arrayidx = getelementptr inbounds [87 x i16], ptr %tls0, i64 0, i64 2
  ret ptr %arrayidx
}

define nonnull ptr @AddrTest2_NoAttr() {
; SMALLCM64-LABEL: AddrTest2_NoAttr:
; SMALLCM64:       # %bb.0: # %entry
; SMALLCM64-NEXT:    ld r3, L..C1(r2) # target-flags(ppc-tprel) @b_noattr
; SMALLCM64-NEXT:    add r3, r13, r3
; SMALLCM64-NEXT:    addi r3, r3, 4
; SMALLCM64-NEXT:    blr
;
; LARGECM64-LABEL: AddrTest2_NoAttr:
; LARGECM64:       # %bb.0: # %entry
; LARGECM64-NEXT:    addis r3, L..C1@u(r2)
; LARGECM64-NEXT:    ld r3, L..C1@l(r3)
; LARGECM64-NEXT:    add r3, r13, r3
; LARGECM64-NEXT:    addi r3, r3, 4
; LARGECM64-NEXT:    blr
entry:
  %tls0 = tail call align 2 ptr @llvm.threadlocal.address.p0(ptr align 2 @b_noattr)
  %arrayidx = getelementptr inbounds [87 x i16], ptr %tls0, i64 0, i64 2
  ret ptr %arrayidx
}

define nonnull ptr @AddrTest3() {
; COMMONCM-LABEL: AddrTest3:
; COMMONCM:       # %bb.0: # %entry
; COMMONCM-NEXT:    addi r3, r13, c[TL]@le+12
; COMMONCM-NEXT:    blr
entry:
  %tls0 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @c)
  %arrayidx = getelementptr inbounds [87 x i32], ptr %tls0, i64 0, i64 3
  ret ptr %arrayidx
}

define nonnull ptr @AddrTest3_NoAttr() {
; SMALLCM64-LABEL: AddrTest3_NoAttr:
; SMALLCM64:       # %bb.0: # %entry
; SMALLCM64-NEXT:    ld r3, L..C2(r2) # target-flags(ppc-tprel) @c_noattr
; SMALLCM64-NEXT:    add r3, r13, r3
; SMALLCM64-NEXT:    addi r3, r3, 12
; SMALLCM64-NEXT:    blr
;
; LARGECM64-LABEL: AddrTest3_NoAttr:
; LARGECM64:       # %bb.0: # %entry
; LARGECM64-NEXT:    addis r3, L..C2@u(r2)
; LARGECM64-NEXT:    ld r3, L..C2@l(r3)
; LARGECM64-NEXT:    add r3, r13, r3
; LARGECM64-NEXT:    addi r3, r3, 12
; LARGECM64-NEXT:    blr
entry:
  %tls0 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @c_noattr)
  %arrayidx = getelementptr inbounds [87 x i32], ptr %tls0, i64 0, i64 3
  ret ptr %arrayidx
}

define nonnull ptr @AddrTest4() {
; COMMONCM-LABEL: AddrTest4:
; COMMONCM:       # %bb.0: # %entry
; COMMONCM-NEXT:    addi r3, r13, c[TL]@le+56
; COMMONCM-NEXT:    blr
entry:
  %tls0 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @c)
  %arrayidx = getelementptr inbounds [87 x i64], ptr %tls0, i64 0, i64 7
  ret ptr %arrayidx
}

define nonnull ptr @AddrTest4_NoAttr() {
; SMALLCM64-LABEL: AddrTest4_NoAttr:
; SMALLCM64:       # %bb.0: # %entry
; SMALLCM64-NEXT:    ld r3, L..C2(r2) # target-flags(ppc-tprel) @c_noattr
; SMALLCM64-NEXT:    add r3, r13, r3
; SMALLCM64-NEXT:    addi r3, r3, 56
; SMALLCM64-NEXT:    blr
;
; LARGECM64-LABEL: AddrTest4_NoAttr:
; LARGECM64:       # %bb.0: # %entry
; LARGECM64-NEXT:    addis r3, L..C2@u(r2)
; LARGECM64-NEXT:    ld r3, L..C2@l(r3)
; LARGECM64-NEXT:    add r3, r13, r3
; LARGECM64-NEXT:    addi r3, r3, 56
; LARGECM64-NEXT:    blr
entry:
  %tls0 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @c_noattr)
  %arrayidx = getelementptr inbounds [87 x i64], ptr %tls0, i64 0, i64 7
  ret ptr %arrayidx
}

define nonnull ptr @AddrTest5() {
; COMMONCM-LABEL: AddrTest5:
; COMMONCM:       # %bb.0: # %entry
; COMMONCM-NEXT:    addi r3, r13, e[TL]@le+48
; COMMONCM-NEXT:    blr
entry:
  %tls0 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @e)
  %arrayidx = getelementptr inbounds [87 x double], ptr %tls0, i64 0, i64 6
  ret ptr %arrayidx
}

define nonnull ptr @AddrTest5_NoAttr() {
; SMALLCM64-LABEL: AddrTest5_NoAttr:
; SMALLCM64:       # %bb.0: # %entry
; SMALLCM64-NEXT:    ld r3, L..C3(r2) # target-flags(ppc-tprel) @e_noattr
; SMALLCM64-NEXT:    add r3, r13, r3
; SMALLCM64-NEXT:    addi r3, r3, 48
; SMALLCM64-NEXT:    blr
;
; LARGECM64-LABEL: AddrTest5_NoAttr:
; LARGECM64:       # %bb.0: # %entry
; LARGECM64-NEXT:    addis r3, L..C3@u(r2)
; LARGECM64-NEXT:    ld r3, L..C3@l(r3)
; LARGECM64-NEXT:    add r3, r13, r3
; LARGECM64-NEXT:    addi r3, r3, 48
; LARGECM64-NEXT:    blr
entry:
  %tls0 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @e_noattr)
  %arrayidx = getelementptr inbounds [87 x double], ptr %tls0, i64 0, i64 6
  ret ptr %arrayidx
}

define nonnull ptr @AddrTest6() {
; COMMONCM-LABEL: AddrTest6:
; COMMONCM:       # %bb.0: # %entry
; COMMONCM-NEXT:    addi r3, r13, f[TL]@le+16
; COMMONCM-NEXT:    blr
entry:
  %tls0 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @f)
  %arrayidx = getelementptr inbounds [87 x float], ptr %tls0, i64 0, i64 4
  ret ptr %arrayidx
}

define nonnull ptr @AddrTest6_NoAttr() {
; SMALLCM64-LABEL: AddrTest6_NoAttr:
; SMALLCM64:       # %bb.0: # %entry
; SMALLCM64-NEXT:    ld r3, L..C4(r2) # target-flags(ppc-tprel) @f_noattr
; SMALLCM64-NEXT:    add r3, r13, r3
; SMALLCM64-NEXT:    addi r3, r3, 16
; SMALLCM64-NEXT:    blr
;
; LARGECM64-LABEL: AddrTest6_NoAttr:
; LARGECM64:       # %bb.0: # %entry
; LARGECM64-NEXT:    addis r3, L..C4@u(r2)
; LARGECM64-NEXT:    ld r3, L..C4@l(r3)
; LARGECM64-NEXT:    add r3, r13, r3
; LARGECM64-NEXT:    addi r3, r3, 16
; LARGECM64-NEXT:    blr
entry:
  %tls0 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @f_noattr)
  %arrayidx = getelementptr inbounds [87 x float], ptr %tls0, i64 0, i64 4
  ret ptr %arrayidx
}

attributes #0 = { "aix-small-tls" }
