; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mcpu=sm_20 | FileCheck %s
; RUN: %if ptxas %{ llc < %s -mcpu=sm_20 | %ptxas-verify %}

target triple = "nvptx64-unknown-cuda"

define fp128 @identity(fp128 %x) {
; CHECK-LABEL: identity(
; CHECK:       {
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.v2.b64 {%rd1, %rd2}, [identity_param_0];
; CHECK-NEXT:    st.param.v2.b64 [func_retval0], {%rd1, %rd2};
; CHECK-NEXT:    ret;
  ret fp128 %x
}

define void @load_store(ptr %in, ptr %out) {
; CHECK-LABEL: load_store(
; CHECK:       {
; CHECK-NEXT:    .reg .b64 %rd<5>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [load_store_param_0];
; CHECK-NEXT:    ld.v2.b64 {%rd2, %rd3}, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd4, [load_store_param_1];
; CHECK-NEXT:    st.v2.b64 [%rd4], {%rd2, %rd3};
; CHECK-NEXT:    ret;
  %val = load fp128, ptr %in
  store fp128 %val, ptr %out
  ret void
}

define void @call(fp128 %x) {
; CHECK-LABEL: call(
; CHECK:       {
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.v2.b64 {%rd1, %rd2}, [call_param_0];
; CHECK-NEXT:    { // callseq 0, 0
; CHECK-NEXT:    .param .align 16 .b8 param0[16];
; CHECK-NEXT:    st.param.v2.b64 [param0], {%rd1, %rd2};
; CHECK-NEXT:    call.uni call, (param0);
; CHECK-NEXT:    } // callseq 0
; CHECK-NEXT:    ret;
  call void @call(fp128 %x)
  ret void
}
