; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx802 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX802-SDAG %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX1010-SDAG %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx1100 -verify-machineinstrs -amdgpu-enable-vopd=0 < %s | FileCheck -check-prefixes=GFX1100-SDAG %s

; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx802 -verify-machineinstrs -global-isel -global-isel-abort=2 < %s | FileCheck -check-prefixes=GFX802-GISEL %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx1010 -verify-machineinstrs -global-isel -global-isel-abort=2 < %s | FileCheck -check-prefixes=GFX1010-GISEL %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx1100 -verify-machineinstrs -amdgpu-enable-vopd=0 -global-isel -global-isel-abort=2 < %s | FileCheck -check-prefixes=GFX1100-GISEL %s

declare i32 @llvm.amdgcn.writelane(i32, i32, i32) #0
declare i64 @llvm.amdgcn.writelane.i64(i64, i32, i64) #0
declare double @llvm.amdgcn.writelane.f64(double, i32, double) #0

define amdgpu_kernel void @test_writelane_sreg_i32(ptr addrspace(1) %out, i32 %src0, i32 %src1) #1 {
; GFX802-SDAG-LABEL: test_writelane_sreg_i32:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-SDAG-NEXT:    s_add_i32 s12, s12, s17
; GFX802-SDAG-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-SDAG-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s3
; GFX802-SDAG-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v2, s3
; GFX802-SDAG-NEXT:    v_writelane_b32 v2, s2, m0
; GFX802-SDAG-NEXT:    flat_store_dword v[0:1], v2
; GFX802-SDAG-NEXT:    s_endpgm
;
; GFX1010-SDAG-LABEL: test_writelane_sreg_i32:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX1010-SDAG-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1010-SDAG-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX1010-SDAG-NEXT:    s_endpgm
;
; GFX1100-SDAG-LABEL: test_writelane_sreg_i32:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    s_load_b32 s4, s[0:1], 0x0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX1100-SDAG-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1100-SDAG-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1100-SDAG-NEXT:    s_endpgm
;
; GFX802-GISEL-LABEL: test_writelane_sreg_i32:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-GISEL-NEXT:    s_add_i32 s12, s12, s17
; GFX802-GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s3
; GFX802-GISEL-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v2, s3
; GFX802-GISEL-NEXT:    v_writelane_b32 v2, s2, m0
; GFX802-GISEL-NEXT:    flat_store_dword v[0:1], v2
; GFX802-GISEL-NEXT:    s_endpgm
;
; GFX1010-GISEL-LABEL: test_writelane_sreg_i32:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX1010-GISEL-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1010-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX1010-GISEL-NEXT:    s_endpgm
;
; GFX1100-GISEL-LABEL: test_writelane_sreg_i32:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    s_load_b32 s4, s[0:1], 0x0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX1100-GISEL-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1100-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1100-GISEL-NEXT:    s_endpgm
  %oldval = load i32, ptr addrspace(1) %out
  %writelane = call i32 @llvm.amdgcn.writelane.i32(i32 %src0, i32 %src1, i32 %oldval)
  store i32 %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_writelane_sreg_i64(ptr addrspace(1) %out, i64 %src0, i32 %src1) #1 {
; GFX802-SDAG-LABEL: test_writelane_sreg_i64:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-SDAG-NEXT:    s_load_dword s6, s[8:9], 0x10
; GFX802-SDAG-NEXT:    s_add_i32 s12, s12, s17
; GFX802-SDAG-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-SDAG-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s6
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v3, s1
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v2, s0
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, s5
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX802-SDAG-NEXT:    v_writelane_b32 v1, s3, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v0, s2, m0
; GFX802-SDAG-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX802-SDAG-NEXT:    s_endpgm
;
; GFX1010-SDAG-LABEL: test_writelane_sreg_i64:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_clause 0x1
; GFX1010-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-SDAG-NEXT:    s_load_dword s6, s[8:9], 0x10
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v1, s5
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX1010-SDAG-NEXT:    v_writelane_b32 v1, s3, s6
; GFX1010-SDAG-NEXT:    v_writelane_b32 v0, s2, s6
; GFX1010-SDAG-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-SDAG-NEXT:    s_endpgm
;
; GFX1100-SDAG-LABEL: test_writelane_sreg_i64:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_clause 0x1
; GFX1100-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-SDAG-NEXT:    s_load_b32 s6, s[4:5], 0x10
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v1, s5
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX1100-SDAG-NEXT:    v_writelane_b32 v1, s3, s6
; GFX1100-SDAG-NEXT:    v_writelane_b32 v0, s2, s6
; GFX1100-SDAG-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX1100-SDAG-NEXT:    s_endpgm
;
; GFX802-GISEL-LABEL: test_writelane_sreg_i64:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-GISEL-NEXT:    s_load_dword s6, s[8:9], 0x10
; GFX802-GISEL-NEXT:    s_add_i32 s12, s12, s17
; GFX802-GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s6
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX802-GISEL-NEXT:    v_writelane_b32 v0, s2, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v1, s3, m0
; GFX802-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX802-GISEL-NEXT:    s_endpgm
;
; GFX1010-GISEL-LABEL: test_writelane_sreg_i64:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_clause 0x1
; GFX1010-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-GISEL-NEXT:    s_load_dword s6, s[8:9], 0x10
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v0, s2, s6
; GFX1010-GISEL-NEXT:    v_writelane_b32 v1, s3, s6
; GFX1010-GISEL-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-GISEL-NEXT:    s_endpgm
;
; GFX1100-GISEL-LABEL: test_writelane_sreg_i64:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_clause 0x1
; GFX1100-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-GISEL-NEXT:    s_load_b32 s6, s[4:5], 0x10
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX1100-GISEL-NEXT:    v_writelane_b32 v0, s2, s6
; GFX1100-GISEL-NEXT:    v_writelane_b32 v1, s3, s6
; GFX1100-GISEL-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX1100-GISEL-NEXT:    s_endpgm
  %oldval = load i64, ptr addrspace(1) %out
  %writelane = call i64 @llvm.amdgcn.writelane.i64(i64 %src0, i32 %src1, i64 %oldval)
  store i64 %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_writelane_sreg_f64(ptr addrspace(1) %out, double %src0, i32 %src1) #1 {
; GFX802-SDAG-LABEL: test_writelane_sreg_f64:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-SDAG-NEXT:    s_load_dword s6, s[8:9], 0x10
; GFX802-SDAG-NEXT:    s_add_i32 s12, s12, s17
; GFX802-SDAG-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-SDAG-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s6
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v3, s1
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v2, s0
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, s5
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX802-SDAG-NEXT:    v_writelane_b32 v1, s3, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v0, s2, m0
; GFX802-SDAG-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX802-SDAG-NEXT:    s_endpgm
;
; GFX1010-SDAG-LABEL: test_writelane_sreg_f64:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_clause 0x1
; GFX1010-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-SDAG-NEXT:    s_load_dword s6, s[8:9], 0x10
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v1, s5
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX1010-SDAG-NEXT:    v_writelane_b32 v1, s3, s6
; GFX1010-SDAG-NEXT:    v_writelane_b32 v0, s2, s6
; GFX1010-SDAG-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-SDAG-NEXT:    s_endpgm
;
; GFX1100-SDAG-LABEL: test_writelane_sreg_f64:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_clause 0x1
; GFX1100-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-SDAG-NEXT:    s_load_b32 s6, s[4:5], 0x10
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v1, s5
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX1100-SDAG-NEXT:    v_writelane_b32 v1, s3, s6
; GFX1100-SDAG-NEXT:    v_writelane_b32 v0, s2, s6
; GFX1100-SDAG-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX1100-SDAG-NEXT:    s_endpgm
;
; GFX802-GISEL-LABEL: test_writelane_sreg_f64:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-GISEL-NEXT:    s_load_dword s6, s[8:9], 0x10
; GFX802-GISEL-NEXT:    s_add_i32 s12, s12, s17
; GFX802-GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s6
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX802-GISEL-NEXT:    v_writelane_b32 v0, s2, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v1, s3, m0
; GFX802-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX802-GISEL-NEXT:    s_endpgm
;
; GFX1010-GISEL-LABEL: test_writelane_sreg_f64:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_clause 0x1
; GFX1010-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-GISEL-NEXT:    s_load_dword s6, s[8:9], 0x10
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v0, s2, s6
; GFX1010-GISEL-NEXT:    v_writelane_b32 v1, s3, s6
; GFX1010-GISEL-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-GISEL-NEXT:    s_endpgm
;
; GFX1100-GISEL-LABEL: test_writelane_sreg_f64:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_clause 0x1
; GFX1100-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-GISEL-NEXT:    s_load_b32 s6, s[4:5], 0x10
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX1100-GISEL-NEXT:    v_writelane_b32 v0, s2, s6
; GFX1100-GISEL-NEXT:    v_writelane_b32 v1, s3, s6
; GFX1100-GISEL-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX1100-GISEL-NEXT:    s_endpgm
  %oldval = load double, ptr addrspace(1) %out
  %writelane = call double @llvm.amdgcn.writelane.f64(double %src0, i32 %src1, double %oldval)
  store double %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_writelane_imm_sreg_i32(ptr addrspace(1) %out, i32 %src1) #1 {
; GFX802-SDAG-LABEL: test_writelane_imm_sreg_i32:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX802-SDAG-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX802-SDAG-NEXT:    s_add_i32 s12, s12, s17
; GFX802-SDAG-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-SDAG-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v2, s3
; GFX802-SDAG-NEXT:    v_writelane_b32 v2, 32, s2
; GFX802-SDAG-NEXT:    flat_store_dword v[0:1], v2
; GFX802-SDAG-NEXT:    s_endpgm
;
; GFX1010-SDAG-LABEL: test_writelane_imm_sreg_i32:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_clause 0x1
; GFX1010-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX1010-SDAG-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v0, s3
; GFX1010-SDAG-NEXT:    v_writelane_b32 v0, 32, s2
; GFX1010-SDAG-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX1010-SDAG-NEXT:    s_endpgm
;
; GFX1100-SDAG-LABEL: test_writelane_imm_sreg_i32:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_clause 0x1
; GFX1100-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX1100-SDAG-NEXT:    s_load_b32 s2, s[4:5], 0x8
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    s_load_b32 s3, s[0:1], 0x0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v0, s3
; GFX1100-SDAG-NEXT:    v_writelane_b32 v0, 32, s2
; GFX1100-SDAG-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1100-SDAG-NEXT:    s_endpgm
;
; GFX802-GISEL-LABEL: test_writelane_imm_sreg_i32:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX802-GISEL-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX802-GISEL-NEXT:    s_add_i32 s12, s12, s17
; GFX802-GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v2, s3
; GFX802-GISEL-NEXT:    v_writelane_b32 v2, 32, s2
; GFX802-GISEL-NEXT:    flat_store_dword v[0:1], v2
; GFX802-GISEL-NEXT:    s_endpgm
;
; GFX1010-GISEL-LABEL: test_writelane_imm_sreg_i32:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_clause 0x1
; GFX1010-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX1010-GISEL-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v0, s3
; GFX1010-GISEL-NEXT:    v_writelane_b32 v0, 32, s2
; GFX1010-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX1010-GISEL-NEXT:    s_endpgm
;
; GFX1100-GISEL-LABEL: test_writelane_imm_sreg_i32:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_clause 0x1
; GFX1100-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX1100-GISEL-NEXT:    s_load_b32 s2, s[4:5], 0x8
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    s_load_b32 s3, s[0:1], 0x0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v0, s3
; GFX1100-GISEL-NEXT:    v_writelane_b32 v0, 32, s2
; GFX1100-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1100-GISEL-NEXT:    s_endpgm
  %oldval = load i32, ptr addrspace(1) %out
  %writelane = call i32 @llvm.amdgcn.writelane.i32(i32 32, i32 %src1, i32 %oldval)
  store i32 %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_writelane_imm_sreg_i64(ptr addrspace(1) %out, i32 %src1) #1 {
; GFX802-SDAG-LABEL: test_writelane_imm_sreg_i64:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX802-SDAG-NEXT:    s_load_dword s4, s[8:9], 0x8
; GFX802-SDAG-NEXT:    s_add_i32 s12, s12, s17
; GFX802-SDAG-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-SDAG-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v3, s1
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v2, s0
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v0, s2
; GFX802-SDAG-NEXT:    v_writelane_b32 v1, 0, s4
; GFX802-SDAG-NEXT:    v_writelane_b32 v0, 32, s4
; GFX802-SDAG-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX802-SDAG-NEXT:    s_endpgm
;
; GFX1010-SDAG-LABEL: test_writelane_imm_sreg_i64:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_clause 0x1
; GFX1010-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX1010-SDAG-NEXT:    s_load_dword s4, s[8:9], 0x8
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v0, s2
; GFX1010-SDAG-NEXT:    v_writelane_b32 v1, 0, s4
; GFX1010-SDAG-NEXT:    v_writelane_b32 v0, 32, s4
; GFX1010-SDAG-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-SDAG-NEXT:    s_endpgm
;
; GFX1100-SDAG-LABEL: test_writelane_imm_sreg_i64:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_clause 0x1
; GFX1100-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX1100-SDAG-NEXT:    s_load_b32 s4, s[4:5], 0x8
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    s_load_b64 s[2:3], s[0:1], 0x0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v0, s2
; GFX1100-SDAG-NEXT:    v_writelane_b32 v1, 0, s4
; GFX1100-SDAG-NEXT:    v_writelane_b32 v0, 32, s4
; GFX1100-SDAG-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX1100-SDAG-NEXT:    s_endpgm
;
; GFX802-GISEL-LABEL: test_writelane_imm_sreg_i64:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX802-GISEL-NEXT:    s_load_dword s4, s[8:9], 0x8
; GFX802-GISEL-NEXT:    s_add_i32 s12, s12, s17
; GFX802-GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; GFX802-GISEL-NEXT:    v_writelane_b32 v0, 32, s4
; GFX802-GISEL-NEXT:    v_writelane_b32 v1, 0, s4
; GFX802-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX802-GISEL-NEXT:    s_endpgm
;
; GFX1010-GISEL-LABEL: test_writelane_imm_sreg_i64:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_clause 0x1
; GFX1010-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX1010-GISEL-NEXT:    s_load_dword s4, s[8:9], 0x8
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; GFX1010-GISEL-NEXT:    v_writelane_b32 v0, 32, s4
; GFX1010-GISEL-NEXT:    v_writelane_b32 v1, 0, s4
; GFX1010-GISEL-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-GISEL-NEXT:    s_endpgm
;
; GFX1100-GISEL-LABEL: test_writelane_imm_sreg_i64:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_clause 0x1
; GFX1100-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX1100-GISEL-NEXT:    s_load_b32 s4, s[4:5], 0x8
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    s_load_b64 s[2:3], s[0:1], 0x0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; GFX1100-GISEL-NEXT:    v_writelane_b32 v0, 32, s4
; GFX1100-GISEL-NEXT:    v_writelane_b32 v1, 0, s4
; GFX1100-GISEL-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX1100-GISEL-NEXT:    s_endpgm
  %oldval = load i64, ptr addrspace(1) %out
  %writelane = call i64 @llvm.amdgcn.writelane.i64(i64 32, i32 %src1, i64 %oldval)
  store i64 %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_writelane_imm_sreg_f64(ptr addrspace(1) %out, i32 %src1) #1 {
; GFX802-SDAG-LABEL: test_writelane_imm_sreg_f64:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX802-SDAG-NEXT:    s_load_dword s4, s[8:9], 0x8
; GFX802-SDAG-NEXT:    s_add_i32 s12, s12, s17
; GFX802-SDAG-NEXT:    s_mov_b32 s5, 0x40400000
; GFX802-SDAG-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s4
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v3, s1
; GFX802-SDAG-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v2, s0
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v0, s2
; GFX802-SDAG-NEXT:    v_writelane_b32 v1, s5, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v0, 0, s4
; GFX802-SDAG-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX802-SDAG-NEXT:    s_endpgm
;
; GFX1010-SDAG-LABEL: test_writelane_imm_sreg_f64:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_clause 0x1
; GFX1010-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX1010-SDAG-NEXT:    s_load_dword s4, s[8:9], 0x8
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v0, s2
; GFX1010-SDAG-NEXT:    s_mov_b32 s2, 0x40400000
; GFX1010-SDAG-NEXT:    v_writelane_b32 v1, s2, s4
; GFX1010-SDAG-NEXT:    v_writelane_b32 v0, 0, s4
; GFX1010-SDAG-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-SDAG-NEXT:    s_endpgm
;
; GFX1100-SDAG-LABEL: test_writelane_imm_sreg_f64:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_clause 0x1
; GFX1100-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX1100-SDAG-NEXT:    s_load_b32 s4, s[4:5], 0x8
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    s_load_b64 s[2:3], s[0:1], 0x0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v0, s2
; GFX1100-SDAG-NEXT:    s_mov_b32 s2, 0x40400000
; GFX1100-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v1, s2, s4
; GFX1100-SDAG-NEXT:    v_writelane_b32 v0, 0, s4
; GFX1100-SDAG-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX1100-SDAG-NEXT:    s_endpgm
;
; GFX802-GISEL-LABEL: test_writelane_imm_sreg_f64:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX802-GISEL-NEXT:    s_load_dword s4, s[8:9], 0x8
; GFX802-GISEL-NEXT:    s_add_i32 s12, s12, s17
; GFX802-GISEL-NEXT:    s_mov_b32 s5, 0x40400000
; GFX802-GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s4
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; GFX802-GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; GFX802-GISEL-NEXT:    v_writelane_b32 v0, 0, s4
; GFX802-GISEL-NEXT:    v_writelane_b32 v1, s5, m0
; GFX802-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX802-GISEL-NEXT:    s_endpgm
;
; GFX1010-GISEL-LABEL: test_writelane_imm_sreg_f64:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_clause 0x1
; GFX1010-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX1010-GISEL-NEXT:    s_load_dword s4, s[8:9], 0x8
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; GFX1010-GISEL-NEXT:    s_mov_b32 s2, 0x40400000
; GFX1010-GISEL-NEXT:    v_writelane_b32 v0, 0, s4
; GFX1010-GISEL-NEXT:    v_writelane_b32 v1, s2, s4
; GFX1010-GISEL-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-GISEL-NEXT:    s_endpgm
;
; GFX1100-GISEL-LABEL: test_writelane_imm_sreg_f64:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_clause 0x1
; GFX1100-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX1100-GISEL-NEXT:    s_load_b32 s4, s[4:5], 0x8
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    s_load_b64 s[2:3], s[0:1], 0x0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; GFX1100-GISEL-NEXT:    s_mov_b32 s2, 0x40400000
; GFX1100-GISEL-NEXT:    v_writelane_b32 v0, 0, s4
; GFX1100-GISEL-NEXT:    v_writelane_b32 v1, s2, s4
; GFX1100-GISEL-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX1100-GISEL-NEXT:    s_endpgm
  %oldval = load double, ptr addrspace(1) %out
  %writelane = call double @llvm.amdgcn.writelane.f64(double 32.0, i32 %src1, double %oldval)
  store double %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_writelane_vreg_lane_i32(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GFX802-SDAG-LABEL: test_writelane_vreg_lane_i32:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX802-SDAG-NEXT:    s_add_i32 s12, s12, s17
; GFX802-SDAG-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-SDAG-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; GFX802-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; GFX802-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX802-SDAG-NEXT:    v_add_u32_e32 v0, vcc, 4, v0
; GFX802-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX802-SDAG-NEXT:    flat_load_dword v0, v[0:1]
; GFX802-SDAG-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v2, s2
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s2, v0
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX802-SDAG-NEXT:    s_nop 2
; GFX802-SDAG-NEXT:    v_writelane_b32 v2, 12, s2
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX802-SDAG-NEXT:    flat_store_dword v[0:1], v2
; GFX802-SDAG-NEXT:    s_endpgm
;
; GFX1010-SDAG-LABEL: test_writelane_vreg_lane_i32:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    global_load_dword v0, v0, s[2:3] offset:4
; GFX1010-SDAG-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1010-SDAG-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v1, s2
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; GFX1010-SDAG-NEXT:    v_writelane_b32 v1, 12, s2
; GFX1010-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX1010-SDAG-NEXT:    s_endpgm
;
; GFX1100-SDAG-LABEL: test_writelane_vreg_lane_i32:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1100-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1100-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    global_load_b32 v0, v0, s[2:3] offset:4
; GFX1100-SDAG-NEXT:    s_load_b32 s2, s[0:1], 0x0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v1, s2
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; GFX1100-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v1, 12, s2
; GFX1100-SDAG-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX1100-SDAG-NEXT:    s_endpgm
;
; GFX802-GISEL-LABEL: test_writelane_vreg_lane_i32:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX802-GISEL-NEXT:    s_add_i32 s12, s12, s17
; GFX802-GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; GFX802-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX802-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX802-GISEL-NEXT:    v_add_u32_e32 v0, vcc, 4, v0
; GFX802-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX802-GISEL-NEXT:    flat_load_dword v0, v[0:1]
; GFX802-GISEL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v2, s2
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s2, v0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX802-GISEL-NEXT:    s_nop 2
; GFX802-GISEL-NEXT:    v_writelane_b32 v2, 12, s2
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX802-GISEL-NEXT:    flat_store_dword v[0:1], v2
; GFX802-GISEL-NEXT:    s_endpgm
;
; GFX1010-GISEL-LABEL: test_writelane_vreg_lane_i32:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    global_load_dword v0, v0, s[2:3] offset:4
; GFX1010-GISEL-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1010-GISEL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v1, s2
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX1010-GISEL-NEXT:    v_writelane_b32 v1, 12, s2
; GFX1010-GISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX1010-GISEL-NEXT:    s_endpgm
;
; GFX1100-GISEL-LABEL: test_writelane_vreg_lane_i32:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1100-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1100-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    global_load_b32 v0, v0, s[2:3] offset:4
; GFX1100-GISEL-NEXT:    s_load_b32 s2, s[0:1], 0x0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v1, s2
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX1100-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v1, 12, s2
; GFX1100-GISEL-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX1100-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.in = getelementptr <2 x i32>, ptr addrspace(1) %in, i32 %tid
  %args = load <2 x i32>, ptr addrspace(1) %gep.in
  %oldval = load i32, ptr addrspace(1) %out
  %lane = extractelement <2 x i32> %args, i32 1
  %writelane = call i32 @llvm.amdgcn.writelane.i32(i32 12, i32 %lane, i32 %oldval)
  store i32 %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_writelane_vreg_lane_i64(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GFX802-SDAG-LABEL: test_writelane_vreg_lane_i64:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX802-SDAG-NEXT:    s_add_i32 s12, s12, s17
; GFX802-SDAG-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-SDAG-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; GFX802-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; GFX802-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX802-SDAG-NEXT:    v_add_u32_e32 v0, vcc, 8, v0
; GFX802-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX802-SDAG-NEXT:    flat_load_dword v2, v[0:1]
; GFX802-SDAG-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v0, s2
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s2, v2
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v3, s1
; GFX802-SDAG-NEXT:    s_nop 2
; GFX802-SDAG-NEXT:    v_writelane_b32 v1, 0, s2
; GFX802-SDAG-NEXT:    v_writelane_b32 v0, 12, s2
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v2, s0
; GFX802-SDAG-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX802-SDAG-NEXT:    s_endpgm
;
; GFX1010-SDAG-LABEL: test_writelane_vreg_lane_i64:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    global_load_dword v0, v0, s[2:3] offset:8
; GFX1010-SDAG-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1010-SDAG-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v0, s2
; GFX1010-SDAG-NEXT:    v_writelane_b32 v1, 0, s3
; GFX1010-SDAG-NEXT:    v_writelane_b32 v0, 12, s3
; GFX1010-SDAG-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-SDAG-NEXT:    s_endpgm
;
; GFX1100-SDAG-LABEL: test_writelane_vreg_lane_i64:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1100-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    global_load_b32 v0, v0, s[2:3] offset:8
; GFX1100-SDAG-NEXT:    s_load_b64 s[2:3], s[0:1], 0x0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v0, s2
; GFX1100-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v1, 0, s3
; GFX1100-SDAG-NEXT:    v_writelane_b32 v0, 12, s3
; GFX1100-SDAG-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX1100-SDAG-NEXT:    s_endpgm
;
; GFX802-GISEL-LABEL: test_writelane_vreg_lane_i64:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 4, v0
; GFX802-GISEL-NEXT:    s_add_i32 s12, s12, s17
; GFX802-GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; GFX802-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX802-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX802-GISEL-NEXT:    v_add_u32_e32 v0, vcc, 8, v0
; GFX802-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX802-GISEL-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX802-GISEL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v4, s1
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v3, s0
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, s2
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v2, s3
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s2, v0
; GFX802-GISEL-NEXT:    s_nop 3
; GFX802-GISEL-NEXT:    v_writelane_b32 v1, 12, s2
; GFX802-GISEL-NEXT:    v_writelane_b32 v2, 0, s2
; GFX802-GISEL-NEXT:    flat_store_dwordx2 v[3:4], v[1:2]
; GFX802-GISEL-NEXT:    s_endpgm
;
; GFX1010-GISEL-LABEL: test_writelane_vreg_lane_i64:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    global_load_dwordx2 v[0:1], v0, s[2:3] offset:8
; GFX1010-GISEL-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1010-GISEL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v1, s2
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v2, s3
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX1010-GISEL-NEXT:    v_writelane_b32 v1, 12, s2
; GFX1010-GISEL-NEXT:    v_writelane_b32 v2, 0, s2
; GFX1010-GISEL-NEXT:    global_store_dwordx2 v0, v[1:2], s[0:1]
; GFX1010-GISEL-NEXT:    s_endpgm
;
; GFX1100-GISEL-LABEL: test_writelane_vreg_lane_i64:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1100-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1100-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    global_load_b64 v[0:1], v0, s[2:3] offset:8
; GFX1100-GISEL-NEXT:    s_load_b64 s[2:3], s[0:1], 0x0
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v1, s2
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v2, s3
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX1100-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v1, 12, s2
; GFX1100-GISEL-NEXT:    v_writelane_b32 v2, 0, s2
; GFX1100-GISEL-NEXT:    global_store_b64 v0, v[1:2], s[0:1]
; GFX1100-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.in = getelementptr <2 x i64>, ptr addrspace(1) %in, i32 %tid
  %args = load <2 x i64>, ptr addrspace(1) %gep.in
  %oldval = load i64, ptr addrspace(1) %out
  %lane = extractelement <2 x i64> %args, i32 1
  %lane32 = trunc i64 %lane to i32
  %writelane = call i64 @llvm.amdgcn.writelane.i64(i64 12, i32 %lane32, i64 %oldval)
  store i64 %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_writelane_vreg_lane_f64(ptr addrspace(1) %out, ptr addrspace(1) %in) #1 {
; GFX802-SDAG-LABEL: test_writelane_vreg_lane_f64:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX802-SDAG-NEXT:    s_add_i32 s12, s12, s17
; GFX802-SDAG-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-SDAG-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; GFX802-SDAG-NEXT:    v_add_u32_e32 v0, vcc, s2, v0
; GFX802-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX802-SDAG-NEXT:    v_add_u32_e32 v0, vcc, 8, v0
; GFX802-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX802-SDAG-NEXT:    flat_load_dword v2, v[0:1]
; GFX802-SDAG-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX802-SDAG-NEXT:    s_mov_b32 s4, 0x40280000
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v0, s2
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s2, v2
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s2
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v3, s1
; GFX802-SDAG-NEXT:    s_nop 1
; GFX802-SDAG-NEXT:    v_writelane_b32 v0, 0, s2
; GFX802-SDAG-NEXT:    v_writelane_b32 v1, s4, m0
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v2, s0
; GFX802-SDAG-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX802-SDAG-NEXT:    s_endpgm
;
; GFX1010-SDAG-LABEL: test_writelane_vreg_lane_f64:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    global_load_dword v0, v0, s[2:3] offset:8
; GFX1010-SDAG-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1010-SDAG-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v0, s2
; GFX1010-SDAG-NEXT:    s_mov_b32 s2, 0x40280000
; GFX1010-SDAG-NEXT:    v_writelane_b32 v1, s2, s3
; GFX1010-SDAG-NEXT:    v_writelane_b32 v0, 0, s3
; GFX1010-SDAG-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-SDAG-NEXT:    s_endpgm
;
; GFX1100-SDAG-LABEL: test_writelane_vreg_lane_f64:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-SDAG-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1100-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    global_load_b32 v0, v0, s[2:3] offset:8
; GFX1100-SDAG-NEXT:    s_load_b64 s[2:3], s[0:1], 0x0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s3, v0
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v0, s2
; GFX1100-SDAG-NEXT:    s_mov_b32 s2, 0x40280000
; GFX1100-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v1, s2, s3
; GFX1100-SDAG-NEXT:    v_writelane_b32 v0, 0, s3
; GFX1100-SDAG-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX1100-SDAG-NEXT:    s_endpgm
;
; GFX802-GISEL-LABEL: test_writelane_vreg_lane_f64:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-GISEL-NEXT:    v_lshlrev_b32_e32 v2, 4, v0
; GFX802-GISEL-NEXT:    s_add_i32 s12, s12, s17
; GFX802-GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; GFX802-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX802-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX802-GISEL-NEXT:    v_add_u32_e32 v0, vcc, 8, v0
; GFX802-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX802-GISEL-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GFX802-GISEL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX802-GISEL-NEXT:    s_mov_b32 s4, 0x40280000
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v4, s1
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v3, s0
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, s2
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v2, s3
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s2, v0
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s2
; GFX802-GISEL-NEXT:    s_nop 2
; GFX802-GISEL-NEXT:    v_writelane_b32 v1, 0, s2
; GFX802-GISEL-NEXT:    v_writelane_b32 v2, s4, m0
; GFX802-GISEL-NEXT:    flat_store_dwordx2 v[3:4], v[1:2]
; GFX802-GISEL-NEXT:    s_endpgm
;
; GFX1010-GISEL-LABEL: test_writelane_vreg_lane_f64:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    global_load_dwordx2 v[0:1], v0, s[2:3] offset:8
; GFX1010-GISEL-NEXT:    s_waitcnt_depctr 0xffe3
; GFX1010-GISEL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v1, s2
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v2, s3
; GFX1010-GISEL-NEXT:    s_mov_b32 s3, 0x40280000
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX1010-GISEL-NEXT:    v_writelane_b32 v1, 0, s2
; GFX1010-GISEL-NEXT:    v_writelane_b32 v2, s3, s2
; GFX1010-GISEL-NEXT:    global_store_dwordx2 v0, v[1:2], s[0:1]
; GFX1010-GISEL-NEXT:    s_endpgm
;
; GFX1100-GISEL-LABEL: test_writelane_vreg_lane_f64:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-GISEL-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX1100-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1100-GISEL-NEXT:    v_lshlrev_b32_e32 v0, 4, v0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    global_load_b64 v[0:1], v0, s[2:3] offset:8
; GFX1100-GISEL-NEXT:    s_load_b64 s[2:3], s[0:1], 0x0
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v1, s2
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v2, s3
; GFX1100-GISEL-NEXT:    s_mov_b32 s3, 0x40280000
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s2, v0
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX1100-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v1, 0, s2
; GFX1100-GISEL-NEXT:    v_writelane_b32 v2, s3, s2
; GFX1100-GISEL-NEXT:    global_store_b64 v0, v[1:2], s[0:1]
; GFX1100-GISEL-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep.in = getelementptr <2 x double>, ptr addrspace(1) %in, i32 %tid
  %args = load <2 x double>, ptr addrspace(1) %gep.in
  %oldval = load double, ptr addrspace(1) %out
  %lane = extractelement <2 x double> %args, i32 1
  %lane_cast = bitcast double %lane to i64
  %lane32 = trunc i64 %lane_cast to i32
  %writelane = call double @llvm.amdgcn.writelane.f64(double 12.0, i32 %lane32, double %oldval)
  store double %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_writelane_m0_sreg_i32(ptr addrspace(1) %out, i32 %src1) #1 {
; GFX802-SDAG-LABEL: test_writelane_m0_sreg_i32:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX802-SDAG-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX802-SDAG-NEXT:    ;;#ASMSTART
; GFX802-SDAG-NEXT:    s_mov_b32 m0, -1
; GFX802-SDAG-NEXT:    ;;#ASMEND
; GFX802-SDAG-NEXT:    s_add_i32 s12, s12, s17
; GFX802-SDAG-NEXT:    s_mov_b32 s4, m0
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s2
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX802-SDAG-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-SDAG-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v2, s3
; GFX802-SDAG-NEXT:    v_writelane_b32 v2, s4, m0
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX802-SDAG-NEXT:    flat_store_dword v[0:1], v2
; GFX802-SDAG-NEXT:    s_endpgm
;
; GFX1010-SDAG-LABEL: test_writelane_m0_sreg_i32:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_clause 0x1
; GFX1010-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX1010-SDAG-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; GFX1010-SDAG-NEXT:    ;;#ASMSTART
; GFX1010-SDAG-NEXT:    s_mov_b32 m0, -1
; GFX1010-SDAG-NEXT:    ;;#ASMEND
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v0, s3
; GFX1010-SDAG-NEXT:    v_writelane_b32 v0, m0, s2
; GFX1010-SDAG-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX1010-SDAG-NEXT:    s_endpgm
;
; GFX1100-SDAG-LABEL: test_writelane_m0_sreg_i32:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_clause 0x1
; GFX1100-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX1100-SDAG-NEXT:    s_load_b32 s2, s[4:5], 0x8
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; GFX1100-SDAG-NEXT:    ;;#ASMSTART
; GFX1100-SDAG-NEXT:    s_mov_b32 m0, -1
; GFX1100-SDAG-NEXT:    ;;#ASMEND
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    s_load_b32 s3, s[0:1], 0x0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v0, s3
; GFX1100-SDAG-NEXT:    v_writelane_b32 v0, m0, s2
; GFX1100-SDAG-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1100-SDAG-NEXT:    s_endpgm
;
; GFX802-GISEL-LABEL: test_writelane_m0_sreg_i32:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX802-GISEL-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX802-GISEL-NEXT:    ;;#ASMSTART
; GFX802-GISEL-NEXT:    s_mov_b32 m0, -1
; GFX802-GISEL-NEXT:    ;;#ASMEND
; GFX802-GISEL-NEXT:    s_add_i32 s12, s12, s17
; GFX802-GISEL-NEXT:    s_mov_b32 s4, m0
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s2
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX802-GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v2, s3
; GFX802-GISEL-NEXT:    v_writelane_b32 v2, s4, m0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX802-GISEL-NEXT:    flat_store_dword v[0:1], v2
; GFX802-GISEL-NEXT:    s_endpgm
;
; GFX1010-GISEL-LABEL: test_writelane_m0_sreg_i32:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_clause 0x1
; GFX1010-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX1010-GISEL-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX1010-GISEL-NEXT:    ;;#ASMSTART
; GFX1010-GISEL-NEXT:    s_mov_b32 m0, -1
; GFX1010-GISEL-NEXT:    ;;#ASMEND
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v0, s3
; GFX1010-GISEL-NEXT:    v_writelane_b32 v0, m0, s2
; GFX1010-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX1010-GISEL-NEXT:    s_endpgm
;
; GFX1100-GISEL-LABEL: test_writelane_m0_sreg_i32:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_clause 0x1
; GFX1100-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX1100-GISEL-NEXT:    s_load_b32 s2, s[4:5], 0x8
; GFX1100-GISEL-NEXT:    ;;#ASMSTART
; GFX1100-GISEL-NEXT:    s_mov_b32 m0, -1
; GFX1100-GISEL-NEXT:    ;;#ASMEND
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    s_load_b32 s3, s[0:1], 0x0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v0, s3
; GFX1100-GISEL-NEXT:    v_writelane_b32 v0, m0, s2
; GFX1100-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1100-GISEL-NEXT:    s_endpgm
  %oldval = load i32, ptr addrspace(1) %out
  %m0 = call i32 asm "s_mov_b32 m0, -1", "={m0}"()
  %writelane = call i32 @llvm.amdgcn.writelane.i32(i32 %m0, i32 %src1, i32 %oldval)
  store i32 %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_writelane_imm_i32(ptr addrspace(1) %out, i32 %src0) #1 {
; GFX802-SDAG-LABEL: test_writelane_imm_i32:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX802-SDAG-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX802-SDAG-NEXT:    s_add_i32 s12, s12, s17
; GFX802-SDAG-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-SDAG-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v2, s3
; GFX802-SDAG-NEXT:    v_writelane_b32 v2, s2, 32
; GFX802-SDAG-NEXT:    flat_store_dword v[0:1], v2
; GFX802-SDAG-NEXT:    s_endpgm
;
; GFX1010-SDAG-LABEL: test_writelane_imm_i32:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_clause 0x1
; GFX1010-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX1010-SDAG-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v0, s3
; GFX1010-SDAG-NEXT:    v_writelane_b32 v0, s2, 32
; GFX1010-SDAG-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX1010-SDAG-NEXT:    s_endpgm
;
; GFX1100-SDAG-LABEL: test_writelane_imm_i32:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_clause 0x1
; GFX1100-SDAG-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX1100-SDAG-NEXT:    s_load_b32 s2, s[4:5], 0x8
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    s_load_b32 s3, s[0:1], 0x0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v0, s3
; GFX1100-SDAG-NEXT:    v_writelane_b32 v0, s2, 32
; GFX1100-SDAG-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1100-SDAG-NEXT:    s_endpgm
;
; GFX802-GISEL-LABEL: test_writelane_imm_i32:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX802-GISEL-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX802-GISEL-NEXT:    s_add_i32 s12, s12, s17
; GFX802-GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v2, s3
; GFX802-GISEL-NEXT:    v_writelane_b32 v2, s2, 32
; GFX802-GISEL-NEXT:    flat_store_dword v[0:1], v2
; GFX802-GISEL-NEXT:    s_endpgm
;
; GFX1010-GISEL-LABEL: test_writelane_imm_i32:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_clause 0x1
; GFX1010-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX1010-GISEL-NEXT:    s_load_dword s2, s[8:9], 0x8
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    s_load_dword s3, s[0:1], 0x0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v0, s3
; GFX1010-GISEL-NEXT:    v_writelane_b32 v0, s2, 32
; GFX1010-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX1010-GISEL-NEXT:    s_endpgm
;
; GFX1100-GISEL-LABEL: test_writelane_imm_i32:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_clause 0x1
; GFX1100-GISEL-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX1100-GISEL-NEXT:    s_load_b32 s2, s[4:5], 0x8
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    s_load_b32 s3, s[0:1], 0x0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v0, s3
; GFX1100-GISEL-NEXT:    v_writelane_b32 v0, s2, 32
; GFX1100-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1100-GISEL-NEXT:    s_endpgm
  %oldval = load i32, ptr addrspace(1) %out
  %writelane = call i32 @llvm.amdgcn.writelane.i32(i32 %src0, i32 32, i32 %oldval) #0
  store i32 %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_writelane_imm_i64(ptr addrspace(1) %out, i64 %src0) #1 {
; GFX802-SDAG-LABEL: test_writelane_imm_i64:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-SDAG-NEXT:    s_add_i32 s12, s12, s17
; GFX802-SDAG-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-SDAG-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v3, s1
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v2, s0
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, s5
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX802-SDAG-NEXT:    v_writelane_b32 v1, s3, 32
; GFX802-SDAG-NEXT:    v_writelane_b32 v0, s2, 32
; GFX802-SDAG-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX802-SDAG-NEXT:    s_endpgm
;
; GFX1010-SDAG-LABEL: test_writelane_imm_i64:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v1, s5
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX1010-SDAG-NEXT:    v_writelane_b32 v1, s3, 32
; GFX1010-SDAG-NEXT:    v_writelane_b32 v0, s2, 32
; GFX1010-SDAG-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-SDAG-NEXT:    s_endpgm
;
; GFX1100-SDAG-LABEL: test_writelane_imm_i64:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v1, s5
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX1100-SDAG-NEXT:    v_writelane_b32 v1, s3, 32
; GFX1100-SDAG-NEXT:    v_writelane_b32 v0, s2, 32
; GFX1100-SDAG-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX1100-SDAG-NEXT:    s_endpgm
;
; GFX802-GISEL-LABEL: test_writelane_imm_i64:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-GISEL-NEXT:    s_add_i32 s12, s12, s17
; GFX802-GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX802-GISEL-NEXT:    v_writelane_b32 v0, s2, 32
; GFX802-GISEL-NEXT:    v_writelane_b32 v1, s3, 32
; GFX802-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX802-GISEL-NEXT:    s_endpgm
;
; GFX1010-GISEL-LABEL: test_writelane_imm_i64:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v0, s2, 32
; GFX1010-GISEL-NEXT:    v_writelane_b32 v1, s3, 32
; GFX1010-GISEL-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-GISEL-NEXT:    s_endpgm
;
; GFX1100-GISEL-LABEL: test_writelane_imm_i64:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX1100-GISEL-NEXT:    v_writelane_b32 v0, s2, 32
; GFX1100-GISEL-NEXT:    v_writelane_b32 v1, s3, 32
; GFX1100-GISEL-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX1100-GISEL-NEXT:    s_endpgm
  %oldval = load i64, ptr addrspace(1) %out
  %writelane = call i64 @llvm.amdgcn.writelane.i64(i64 %src0, i32 32, i64 %oldval) #0
  store i64 %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_writelane_imm_f64(ptr addrspace(1) %out, double %src0) #1 {
; GFX802-SDAG-LABEL: test_writelane_imm_f64:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-SDAG-NEXT:    s_add_i32 s12, s12, s17
; GFX802-SDAG-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-SDAG-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v3, s1
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v2, s0
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, s5
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX802-SDAG-NEXT:    v_writelane_b32 v1, s3, 32
; GFX802-SDAG-NEXT:    v_writelane_b32 v0, s2, 32
; GFX802-SDAG-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX802-SDAG-NEXT:    s_endpgm
;
; GFX1010-SDAG-LABEL: test_writelane_imm_f64:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v1, s5
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX1010-SDAG-NEXT:    v_writelane_b32 v1, s3, 32
; GFX1010-SDAG-NEXT:    v_writelane_b32 v0, s2, 32
; GFX1010-SDAG-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-SDAG-NEXT:    s_endpgm
;
; GFX1100-SDAG-LABEL: test_writelane_imm_f64:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v1, s5
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX1100-SDAG-NEXT:    v_writelane_b32 v1, s3, 32
; GFX1100-SDAG-NEXT:    v_writelane_b32 v0, s2, 32
; GFX1100-SDAG-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX1100-SDAG-NEXT:    s_endpgm
;
; GFX802-GISEL-LABEL: test_writelane_imm_f64:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-GISEL-NEXT:    s_add_i32 s12, s12, s17
; GFX802-GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX802-GISEL-NEXT:    v_writelane_b32 v0, s2, 32
; GFX802-GISEL-NEXT:    v_writelane_b32 v1, s3, 32
; GFX802-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX802-GISEL-NEXT:    s_endpgm
;
; GFX1010-GISEL-LABEL: test_writelane_imm_f64:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v0, s2, 32
; GFX1010-GISEL-NEXT:    v_writelane_b32 v1, s3, 32
; GFX1010-GISEL-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-GISEL-NEXT:    s_endpgm
;
; GFX1100-GISEL-LABEL: test_writelane_imm_f64:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX1100-GISEL-NEXT:    v_writelane_b32 v0, s2, 32
; GFX1100-GISEL-NEXT:    v_writelane_b32 v1, s3, 32
; GFX1100-GISEL-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX1100-GISEL-NEXT:    s_endpgm
  %oldval = load double, ptr addrspace(1) %out
  %writelane = call double @llvm.amdgcn.writelane.f64(double %src0, i32 32, double %oldval) #0
  store double %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_writelane_sreg_oldval_i32(i32 %oldval, ptr addrspace(1) %out, i32 %src0, i32 %src1) #1 {
; GFX802-SDAG-LABEL: test_writelane_sreg_oldval_i32:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_load_dword s4, s[8:9], 0x0
; GFX802-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x8
; GFX802-SDAG-NEXT:    s_add_i32 s12, s12, s17
; GFX802-SDAG-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-SDAG-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v2, s4
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s3
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX802-SDAG-NEXT:    v_writelane_b32 v2, s2, m0
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX802-SDAG-NEXT:    flat_store_dword v[0:1], v2
; GFX802-SDAG-NEXT:    s_endpgm
;
; GFX1010-SDAG-LABEL: test_writelane_sreg_oldval_i32:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_clause 0x1
; GFX1010-SDAG-NEXT:    s_load_dword s4, s[8:9], 0x0
; GFX1010-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x8
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v0, s4
; GFX1010-SDAG-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1010-SDAG-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX1010-SDAG-NEXT:    s_endpgm
;
; GFX1100-SDAG-LABEL: test_writelane_sreg_oldval_i32:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_clause 0x1
; GFX1100-SDAG-NEXT:    s_load_b32 s6, s[4:5], 0x0
; GFX1100-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x8
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v0, s6
; GFX1100-SDAG-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1100-SDAG-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1100-SDAG-NEXT:    s_endpgm
;
; GFX802-GISEL-LABEL: test_writelane_sreg_oldval_i32:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_load_dword s4, s[8:9], 0x0
; GFX802-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x8
; GFX802-GISEL-NEXT:    s_add_i32 s12, s12, s17
; GFX802-GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v2, s4
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s3
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX802-GISEL-NEXT:    v_writelane_b32 v2, s2, m0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX802-GISEL-NEXT:    flat_store_dword v[0:1], v2
; GFX802-GISEL-NEXT:    s_endpgm
;
; GFX1010-GISEL-LABEL: test_writelane_sreg_oldval_i32:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_clause 0x1
; GFX1010-GISEL-NEXT:    s_load_dword s4, s[8:9], 0x0
; GFX1010-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x8
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX1010-GISEL-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1010-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX1010-GISEL-NEXT:    s_endpgm
;
; GFX1100-GISEL-LABEL: test_writelane_sreg_oldval_i32:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_clause 0x1
; GFX1100-GISEL-NEXT:    s_load_b32 s6, s[4:5], 0x0
; GFX1100-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x8
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v0, s6
; GFX1100-GISEL-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1100-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1100-GISEL-NEXT:    s_endpgm
  %writelane = call i32 @llvm.amdgcn.writelane.i32(i32 %src0, i32 %src1, i32 %oldval)
  store i32 %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_writelane_sreg_oldval_i64(i64 %oldval, ptr addrspace(1) %out, i64 %src0, i32 %src1) #1 {
; GFX802-SDAG-LABEL: test_writelane_sreg_oldval_i64:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-SDAG-NEXT:    s_load_dword s6, s[8:9], 0x18
; GFX802-SDAG-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; GFX802-SDAG-NEXT:    s_add_i32 s12, s12, s17
; GFX802-SDAG-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v3, s1
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s6
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v2, s0
; GFX802-SDAG-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v0, s2
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; GFX802-SDAG-NEXT:    v_writelane_b32 v3, s5, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v2, s4, m0
; GFX802-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX802-SDAG-NEXT:    s_endpgm
;
; GFX1010-SDAG-LABEL: test_writelane_sreg_oldval_i64:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_clause 0x2
; GFX1010-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-SDAG-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; GFX1010-SDAG-NEXT:    s_load_dword s6, s[8:9], 0x18
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX1010-SDAG-NEXT:    v_writelane_b32 v1, s5, s6
; GFX1010-SDAG-NEXT:    v_writelane_b32 v0, s4, s6
; GFX1010-SDAG-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX1010-SDAG-NEXT:    s_endpgm
;
; GFX1100-SDAG-LABEL: test_writelane_sreg_oldval_i64:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_clause 0x2
; GFX1100-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-SDAG-NEXT:    s_load_b64 s[6:7], s[4:5], 0x10
; GFX1100-SDAG-NEXT:    s_load_b32 s4, s[4:5], 0x18
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX1100-SDAG-NEXT:    v_writelane_b32 v1, s7, s4
; GFX1100-SDAG-NEXT:    v_writelane_b32 v0, s6, s4
; GFX1100-SDAG-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX1100-SDAG-NEXT:    s_endpgm
;
; GFX802-GISEL-LABEL: test_writelane_sreg_oldval_i64:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-GISEL-NEXT:    s_load_dword s6, s[8:9], 0x18
; GFX802-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; GFX802-GISEL-NEXT:    s_add_i32 s12, s12, s17
; GFX802-GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s6
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v2, s2
; GFX802-GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-GISEL-NEXT:    v_writelane_b32 v0, s4, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v1, s5, m0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v3, s3
; GFX802-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX802-GISEL-NEXT:    s_endpgm
;
; GFX1010-GISEL-LABEL: test_writelane_sreg_oldval_i64:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_clause 0x2
; GFX1010-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; GFX1010-GISEL-NEXT:    s_load_dword s6, s[8:9], 0x18
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX1010-GISEL-NEXT:    v_writelane_b32 v0, s4, s6
; GFX1010-GISEL-NEXT:    v_writelane_b32 v1, s5, s6
; GFX1010-GISEL-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX1010-GISEL-NEXT:    s_endpgm
;
; GFX1100-GISEL-LABEL: test_writelane_sreg_oldval_i64:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_clause 0x2
; GFX1100-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-GISEL-NEXT:    s_load_b64 s[6:7], s[4:5], 0x10
; GFX1100-GISEL-NEXT:    s_load_b32 s4, s[4:5], 0x18
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v0, s6, s4
; GFX1100-GISEL-NEXT:    v_writelane_b32 v1, s7, s4
; GFX1100-GISEL-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX1100-GISEL-NEXT:    s_endpgm
  %writelane = call i64 @llvm.amdgcn.writelane.i64(i64 %src0, i32 %src1, i64 %oldval)
  store i64 %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_writelane_sreg_oldval_f64(double %oldval, ptr addrspace(1) %out, double %src0, i32 %src1) #1 {
; GFX802-SDAG-LABEL: test_writelane_sreg_oldval_f64:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-SDAG-NEXT:    s_load_dword s6, s[8:9], 0x18
; GFX802-SDAG-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; GFX802-SDAG-NEXT:    s_add_i32 s12, s12, s17
; GFX802-SDAG-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v3, s1
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s6
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v2, s0
; GFX802-SDAG-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v0, s2
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, s3
; GFX802-SDAG-NEXT:    v_writelane_b32 v3, s5, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v2, s4, m0
; GFX802-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GFX802-SDAG-NEXT:    s_endpgm
;
; GFX1010-SDAG-LABEL: test_writelane_sreg_oldval_f64:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_clause 0x2
; GFX1010-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-SDAG-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; GFX1010-SDAG-NEXT:    s_load_dword s6, s[8:9], 0x18
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX1010-SDAG-NEXT:    v_writelane_b32 v1, s5, s6
; GFX1010-SDAG-NEXT:    v_writelane_b32 v0, s4, s6
; GFX1010-SDAG-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX1010-SDAG-NEXT:    s_endpgm
;
; GFX1100-SDAG-LABEL: test_writelane_sreg_oldval_f64:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_clause 0x2
; GFX1100-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-SDAG-NEXT:    s_load_b64 s[6:7], s[4:5], 0x10
; GFX1100-SDAG-NEXT:    s_load_b32 s4, s[4:5], 0x18
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX1100-SDAG-NEXT:    v_writelane_b32 v1, s7, s4
; GFX1100-SDAG-NEXT:    v_writelane_b32 v0, s6, s4
; GFX1100-SDAG-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX1100-SDAG-NEXT:    s_endpgm
;
; GFX802-GISEL-LABEL: test_writelane_sreg_oldval_f64:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-GISEL-NEXT:    s_load_dword s6, s[8:9], 0x18
; GFX802-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; GFX802-GISEL-NEXT:    s_add_i32 s12, s12, s17
; GFX802-GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s6
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v2, s2
; GFX802-GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-GISEL-NEXT:    v_writelane_b32 v0, s4, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v1, s5, m0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v3, s3
; GFX802-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX802-GISEL-NEXT:    s_endpgm
;
; GFX1010-GISEL-LABEL: test_writelane_sreg_oldval_f64:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_clause 0x2
; GFX1010-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; GFX1010-GISEL-NEXT:    s_load_dword s6, s[8:9], 0x18
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX1010-GISEL-NEXT:    v_writelane_b32 v0, s4, s6
; GFX1010-GISEL-NEXT:    v_writelane_b32 v1, s5, s6
; GFX1010-GISEL-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX1010-GISEL-NEXT:    s_endpgm
;
; GFX1100-GISEL-LABEL: test_writelane_sreg_oldval_f64:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_clause 0x2
; GFX1100-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-GISEL-NEXT:    s_load_b64 s[6:7], s[4:5], 0x10
; GFX1100-GISEL-NEXT:    s_load_b32 s4, s[4:5], 0x18
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v0, s6, s4
; GFX1100-GISEL-NEXT:    v_writelane_b32 v1, s7, s4
; GFX1100-GISEL-NEXT:    global_store_b64 v2, v[0:1], s[2:3]
; GFX1100-GISEL-NEXT:    s_endpgm
  %writelane = call double @llvm.amdgcn.writelane.f64(double %src0, i32 %src1, double %oldval)
  store double %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_writelane_imm_oldval_i32(ptr addrspace(1) %out, i32 %src0, i32 %src1) #1 {
; GFX802-SDAG-LABEL: test_writelane_imm_oldval_i32:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-SDAG-NEXT:    s_add_i32 s12, s12, s17
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v2, 42
; GFX802-SDAG-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-SDAG-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s3
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v0, s0
; GFX802-SDAG-NEXT:    v_writelane_b32 v2, s2, m0
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, s1
; GFX802-SDAG-NEXT:    flat_store_dword v[0:1], v2
; GFX802-SDAG-NEXT:    s_endpgm
;
; GFX1010-SDAG-LABEL: test_writelane_imm_oldval_i32:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v0, 42
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1010-SDAG-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX1010-SDAG-NEXT:    s_endpgm
;
; GFX1100-SDAG-LABEL: test_writelane_imm_oldval_i32:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v0, 42
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1100-SDAG-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1100-SDAG-NEXT:    s_endpgm
;
; GFX802-GISEL-LABEL: test_writelane_imm_oldval_i32:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-GISEL-NEXT:    s_add_i32 s12, s12, s17
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v2, 42
; GFX802-GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s3
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GFX802-GISEL-NEXT:    v_writelane_b32 v2, s2, m0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; GFX802-GISEL-NEXT:    flat_store_dword v[0:1], v2
; GFX802-GISEL-NEXT:    s_endpgm
;
; GFX1010-GISEL-LABEL: test_writelane_imm_oldval_i32:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v0, 42
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1010-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GFX1010-GISEL-NEXT:    s_endpgm
;
; GFX1100-GISEL-LABEL: test_writelane_imm_oldval_i32:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v0, 42
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v0, s2, s3
; GFX1100-GISEL-NEXT:    global_store_b32 v1, v0, s[0:1]
; GFX1100-GISEL-NEXT:    s_endpgm
  %writelane = call i32 @llvm.amdgcn.writelane.i32(i32 %src0, i32 %src1, i32 42)
  store i32 %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_writelane_imm_oldval_i64(ptr addrspace(1) %out, i64 %src0, i32 %src1) #1 {
; GFX802-SDAG-LABEL: test_writelane_imm_oldval_i64:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-SDAG-NEXT:    s_load_dword s4, s[8:9], 0x10
; GFX802-SDAG-NEXT:    s_add_i32 s12, s12, s17
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v0, 42
; GFX802-SDAG-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s4
; GFX802-SDAG-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v2, s0
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v3, s1
; GFX802-SDAG-NEXT:    v_writelane_b32 v1, s3, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v0, s2, m0
; GFX802-SDAG-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX802-SDAG-NEXT:    s_endpgm
;
; GFX1010-SDAG-LABEL: test_writelane_imm_oldval_i64:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_clause 0x1
; GFX1010-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-SDAG-NEXT:    s_load_dword s4, s[8:9], 0x10
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v0, 42
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v1, s3, s4
; GFX1010-SDAG-NEXT:    v_writelane_b32 v0, s2, s4
; GFX1010-SDAG-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-SDAG-NEXT:    s_endpgm
;
; GFX1100-SDAG-LABEL: test_writelane_imm_oldval_i64:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_clause 0x1
; GFX1100-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-SDAG-NEXT:    s_load_b32 s4, s[4:5], 0x10
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v1, 0
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v0, 42
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v1, s3, s4
; GFX1100-SDAG-NEXT:    v_writelane_b32 v0, s2, s4
; GFX1100-SDAG-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX1100-SDAG-NEXT:    s_endpgm
;
; GFX802-GISEL-LABEL: test_writelane_imm_oldval_i64:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_load_dword s4, s[8:9], 0x10
; GFX802-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-GISEL-NEXT:    s_add_i32 s12, s12, s17
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v0, 42
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s4
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; GFX802-GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-GISEL-NEXT:    v_writelane_b32 v0, s2, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v1, s3, m0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; GFX802-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX802-GISEL-NEXT:    s_endpgm
;
; GFX1010-GISEL-LABEL: test_writelane_imm_oldval_i64:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_clause 0x1
; GFX1010-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-GISEL-NEXT:    s_load_dword s4, s[8:9], 0x10
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v0, 42
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v0, s2, s4
; GFX1010-GISEL-NEXT:    v_writelane_b32 v1, s3, s4
; GFX1010-GISEL-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-GISEL-NEXT:    s_endpgm
;
; GFX1100-GISEL-LABEL: test_writelane_imm_oldval_i64:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_clause 0x1
; GFX1100-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-GISEL-NEXT:    s_load_b32 s4, s[4:5], 0x10
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v0, 42
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v0, s2, s4
; GFX1100-GISEL-NEXT:    v_writelane_b32 v1, s3, s4
; GFX1100-GISEL-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX1100-GISEL-NEXT:    s_endpgm
  %writelane = call i64 @llvm.amdgcn.writelane.i64(i64 %src0, i32 %src1, i64 42)
  store i64 %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @test_writelane_imm_oldval_f64(ptr addrspace(1) %out, double %src0, i32 %src1) #1 {
; GFX802-SDAG-LABEL: test_writelane_imm_oldval_f64:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-SDAG-NEXT:    s_load_dword s4, s[8:9], 0x10
; GFX802-SDAG-NEXT:    s_add_i32 s12, s12, s17
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v1, 0x40450000
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; GFX802-SDAG-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s4
; GFX802-SDAG-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v2, s0
; GFX802-SDAG-NEXT:    v_mov_b32_e32 v3, s1
; GFX802-SDAG-NEXT:    v_writelane_b32 v1, s3, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v0, s2, m0
; GFX802-SDAG-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX802-SDAG-NEXT:    s_endpgm
;
; GFX1010-SDAG-LABEL: test_writelane_imm_oldval_f64:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_clause 0x1
; GFX1010-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-SDAG-NEXT:    s_load_dword s4, s[8:9], 0x10
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v1, 0x40450000
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; GFX1010-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v1, s3, s4
; GFX1010-SDAG-NEXT:    v_writelane_b32 v0, s2, s4
; GFX1010-SDAG-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-SDAG-NEXT:    s_endpgm
;
; GFX1100-SDAG-LABEL: test_writelane_imm_oldval_f64:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_clause 0x1
; GFX1100-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-SDAG-NEXT:    s_load_b32 s4, s[4:5], 0x10
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v1, 0x40450000
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; GFX1100-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v1, s3, s4
; GFX1100-SDAG-NEXT:    v_writelane_b32 v0, s2, s4
; GFX1100-SDAG-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX1100-SDAG-NEXT:    s_endpgm
;
; GFX802-GISEL-LABEL: test_writelane_imm_oldval_f64:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_load_dword s4, s[8:9], 0x10
; GFX802-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX802-GISEL-NEXT:    s_add_i32 s12, s12, s17
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v1, 0x40450000
; GFX802-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s4
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v3, s1
; GFX802-GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX802-GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX802-GISEL-NEXT:    v_writelane_b32 v0, s2, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v1, s3, m0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v2, s0
; GFX802-GISEL-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX802-GISEL-NEXT:    s_endpgm
;
; GFX1010-GISEL-LABEL: test_writelane_imm_oldval_f64:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_clause 0x1
; GFX1010-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX1010-GISEL-NEXT:    s_load_dword s4, s[8:9], 0x10
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v1, 0x40450000
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX1010-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v0, s2, s4
; GFX1010-GISEL-NEXT:    v_writelane_b32 v1, s3, s4
; GFX1010-GISEL-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX1010-GISEL-NEXT:    s_endpgm
;
; GFX1100-GISEL-LABEL: test_writelane_imm_oldval_f64:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_clause 0x1
; GFX1100-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX1100-GISEL-NEXT:    s_load_b32 s4, s[4:5], 0x10
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v1, 0x40450000
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v2, 0
; GFX1100-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v0, s2, s4
; GFX1100-GISEL-NEXT:    v_writelane_b32 v1, s3, s4
; GFX1100-GISEL-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX1100-GISEL-NEXT:    s_endpgm
  %writelane = call double @llvm.amdgcn.writelane.f64(double %src0, i32 %src1, double 42.0)
  store double %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define void @test_writelane_half(ptr addrspace(1) %out, half %src, i32 %src1) {
; GFX802-SDAG-LABEL: test_writelane_half:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-SDAG-NEXT:    flat_load_ushort v4, v[0:1]
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s4, v3
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s5, v2
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s4
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    v_writelane_b32 v4, s5, m0
; GFX802-SDAG-NEXT:    flat_store_short v[0:1], v4
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-SDAG-LABEL: test_writelane_half:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-SDAG-NEXT:    global_load_ushort v4, v[0:1], off
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s4, v2
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s5, v3
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v4, s4, s5
; GFX1010-SDAG-NEXT:    global_store_short v[0:1], v4, off
; GFX1010-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-SDAG-LABEL: test_writelane_half:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-SDAG-NEXT:    global_load_u16 v4, v[0:1], off
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s0, v2
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s1, v3
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v4, s0, s1
; GFX1100-SDAG-NEXT:    global_store_b16 v[0:1], v4, off
; GFX1100-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX802-GISEL-LABEL: test_writelane_half:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-GISEL-NEXT:    flat_load_ushort v4, v[0:1]
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s5, v3
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s5
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    v_writelane_b32 v4, s4, m0
; GFX802-GISEL-NEXT:    flat_store_short v[0:1], v4
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-GISEL-LABEL: test_writelane_half:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-GISEL-NEXT:    global_load_ushort v4, v[0:1], off
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s5, v3
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v4, s4, s5
; GFX1010-GISEL-NEXT:    global_store_short v[0:1], v4, off
; GFX1010-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-GISEL-LABEL: test_writelane_half:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-GISEL-NEXT:    global_load_u16 v4, v[0:1], off
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s0, v2
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s1, v3
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v4, s0, s1
; GFX1100-GISEL-NEXT:    global_store_b16 v[0:1], v4, off
; GFX1100-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %oldval = load half, ptr addrspace(1) %out
  %writelane = call half @llvm.amdgcn.writelane.f16(half %src, i32 %src1, half %oldval)
  store half %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define void @test_writelane_float(ptr addrspace(1) %out, float %src, i32 %src1) {
; GFX802-SDAG-LABEL: test_writelane_float:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-SDAG-NEXT:    flat_load_dword v4, v[0:1]
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s4, v3
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s5, v2
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s4
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    v_writelane_b32 v4, s5, m0
; GFX802-SDAG-NEXT:    flat_store_dword v[0:1], v4
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-SDAG-LABEL: test_writelane_float:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-SDAG-NEXT:    global_load_dword v4, v[0:1], off
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s4, v2
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s5, v3
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v4, s4, s5
; GFX1010-SDAG-NEXT:    global_store_dword v[0:1], v4, off
; GFX1010-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-SDAG-LABEL: test_writelane_float:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-SDAG-NEXT:    global_load_b32 v4, v[0:1], off
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s0, v2
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s1, v3
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v4, s0, s1
; GFX1100-SDAG-NEXT:    global_store_b32 v[0:1], v4, off
; GFX1100-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX802-GISEL-LABEL: test_writelane_float:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-GISEL-NEXT:    flat_load_dword v4, v[0:1]
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s5, v3
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s5
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    v_writelane_b32 v4, s4, m0
; GFX802-GISEL-NEXT:    flat_store_dword v[0:1], v4
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-GISEL-LABEL: test_writelane_float:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-GISEL-NEXT:    global_load_dword v4, v[0:1], off
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s5, v3
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v4, s4, s5
; GFX1010-GISEL-NEXT:    global_store_dword v[0:1], v4, off
; GFX1010-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-GISEL-LABEL: test_writelane_float:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-GISEL-NEXT:    global_load_b32 v4, v[0:1], off
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s0, v2
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s1, v3
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v4, s0, s1
; GFX1100-GISEL-NEXT:    global_store_b32 v[0:1], v4, off
; GFX1100-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %oldval = load float, ptr addrspace(1) %out
  %writelane = call float @llvm.amdgcn.writelane.f32(float %src, i32 %src1, float %oldval)
  store float %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define void @test_writelane_bfloat(ptr addrspace(1) %out, bfloat %src, i32 %src1) {
; GFX802-SDAG-LABEL: test_writelane_bfloat:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-SDAG-NEXT:    flat_load_ushort v4, v[0:1]
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s4, v3
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s5, v2
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s4
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    v_writelane_b32 v4, s5, m0
; GFX802-SDAG-NEXT:    flat_store_short v[0:1], v4
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-SDAG-LABEL: test_writelane_bfloat:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-SDAG-NEXT:    global_load_ushort v4, v[0:1], off
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s4, v2
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s5, v3
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v4, s4, s5
; GFX1010-SDAG-NEXT:    global_store_short v[0:1], v4, off
; GFX1010-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-SDAG-LABEL: test_writelane_bfloat:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-SDAG-NEXT:    global_load_u16 v4, v[0:1], off
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s0, v2
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s1, v3
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v4, s0, s1
; GFX1100-SDAG-NEXT:    global_store_b16 v[0:1], v4, off
; GFX1100-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX802-GISEL-LABEL: test_writelane_bfloat:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-GISEL-NEXT:    flat_load_ushort v4, v[0:1]
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s4, v3
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s5, v2
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s4
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    v_writelane_b32 v4, s5, m0
; GFX802-GISEL-NEXT:    flat_store_short v[0:1], v4
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-GISEL-LABEL: test_writelane_bfloat:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-GISEL-NEXT:    global_load_ushort v4, v[0:1], off
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s5, v3
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v4, s4, s5
; GFX1010-GISEL-NEXT:    global_store_short v[0:1], v4, off
; GFX1010-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-GISEL-LABEL: test_writelane_bfloat:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-GISEL-NEXT:    global_load_u16 v4, v[0:1], off
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s0, v2
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s1, v3
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v4, s0, s1
; GFX1100-GISEL-NEXT:    global_store_b16 v[0:1], v4, off
; GFX1100-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %oldval = load bfloat, ptr addrspace(1) %out
  %writelane = call bfloat @llvm.amdgcn.writelane.bf16(bfloat %src, i32 %src1, bfloat %oldval)
  store bfloat %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define void @test_writelane_i16(ptr addrspace(1) %out, i16 %src, i32 %src1) {
; GFX802-SDAG-LABEL: test_writelane_i16:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-SDAG-NEXT:    flat_load_ushort v4, v[0:1]
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s4, v3
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s5, v2
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s4
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    v_writelane_b32 v4, s5, m0
; GFX802-SDAG-NEXT:    flat_store_short v[0:1], v4
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-SDAG-LABEL: test_writelane_i16:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-SDAG-NEXT:    global_load_ushort v4, v[0:1], off
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s4, v2
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s5, v3
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v4, s4, s5
; GFX1010-SDAG-NEXT:    global_store_short v[0:1], v4, off
; GFX1010-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-SDAG-LABEL: test_writelane_i16:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-SDAG-NEXT:    global_load_u16 v4, v[0:1], off
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s0, v2
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s1, v3
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v4, s0, s1
; GFX1100-SDAG-NEXT:    global_store_b16 v[0:1], v4, off
; GFX1100-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX802-GISEL-LABEL: test_writelane_i16:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-GISEL-NEXT:    flat_load_ushort v4, v[0:1]
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s5, v3
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s5
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    v_writelane_b32 v4, s4, m0
; GFX802-GISEL-NEXT:    flat_store_short v[0:1], v4
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-GISEL-LABEL: test_writelane_i16:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-GISEL-NEXT:    global_load_ushort v4, v[0:1], off
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s5, v3
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v4, s4, s5
; GFX1010-GISEL-NEXT:    global_store_short v[0:1], v4, off
; GFX1010-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-GISEL-LABEL: test_writelane_i16:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-GISEL-NEXT:    global_load_u16 v4, v[0:1], off
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s0, v2
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s1, v3
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v4, s0, s1
; GFX1100-GISEL-NEXT:    global_store_b16 v[0:1], v4, off
; GFX1100-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %oldval = load i16, ptr addrspace(1) %out
  %writelane = call i16 @llvm.amdgcn.writelane.i16(i16 %src, i32 %src1, i16 %oldval)
  store i16 %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define void @test_writelane_v2f16(ptr addrspace(1) %out, <2 x half> %src, i32 %src1) {
; GFX802-SDAG-LABEL: test_writelane_v2f16:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-SDAG-NEXT:    flat_load_dword v4, v[0:1]
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s4, v3
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s5, v2
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s4
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    v_writelane_b32 v4, s5, m0
; GFX802-SDAG-NEXT:    flat_store_dword v[0:1], v4
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-SDAG-LABEL: test_writelane_v2f16:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-SDAG-NEXT:    global_load_dword v4, v[0:1], off
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s4, v2
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s5, v3
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v4, s4, s5
; GFX1010-SDAG-NEXT:    global_store_dword v[0:1], v4, off
; GFX1010-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-SDAG-LABEL: test_writelane_v2f16:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-SDAG-NEXT:    global_load_b32 v4, v[0:1], off
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s0, v2
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s1, v3
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v4, s0, s1
; GFX1100-SDAG-NEXT:    global_store_b32 v[0:1], v4, off
; GFX1100-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX802-GISEL-LABEL: test_writelane_v2f16:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-GISEL-NEXT:    flat_load_dword v4, v[0:1]
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s5, v3
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s5
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    v_writelane_b32 v4, s4, m0
; GFX802-GISEL-NEXT:    flat_store_dword v[0:1], v4
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-GISEL-LABEL: test_writelane_v2f16:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-GISEL-NEXT:    global_load_dword v4, v[0:1], off
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s5, v3
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v4, s4, s5
; GFX1010-GISEL-NEXT:    global_store_dword v[0:1], v4, off
; GFX1010-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-GISEL-LABEL: test_writelane_v2f16:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-GISEL-NEXT:    global_load_b32 v4, v[0:1], off
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s0, v2
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s1, v3
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v4, s0, s1
; GFX1100-GISEL-NEXT:    global_store_b32 v[0:1], v4, off
; GFX1100-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %oldval = load <2 x half>, ptr addrspace(1) %out
  %writelane = call <2 x half> @llvm.amdgcn.writelane.v2f16(<2 x half> %src, i32 %src1, <2 x half> %oldval)
  store <2 x half> %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define void @test_readlane_v2f32(ptr addrspace(1) %out, <2 x float> %src, i32 %src1) {
; GFX802-SDAG-LABEL: test_readlane_v2f32:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-SDAG-NEXT:    flat_load_dwordx2 v[5:6], v[0:1]
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s4, v4
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s5, v3
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s6, v2
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s4
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    v_writelane_b32 v6, s5, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v5, s6, m0
; GFX802-SDAG-NEXT:    flat_store_dwordx2 v[0:1], v[5:6]
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-SDAG-LABEL: test_readlane_v2f32:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-SDAG-NEXT:    global_load_dwordx2 v[5:6], v[0:1], off
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s4, v3
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s5, v4
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s6, v2
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v6, s4, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v5, s6, s5
; GFX1010-SDAG-NEXT:    global_store_dwordx2 v[0:1], v[5:6], off
; GFX1010-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-SDAG-LABEL: test_readlane_v2f32:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-SDAG-NEXT:    global_load_b64 v[5:6], v[0:1], off
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s0, v3
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s1, v4
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s2, v2
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v6, s0, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v5, s2, s1
; GFX1100-SDAG-NEXT:    global_store_b64 v[0:1], v[5:6], off
; GFX1100-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX802-GISEL-LABEL: test_readlane_v2f32:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-GISEL-NEXT:    flat_load_dwordx2 v[5:6], v[0:1]
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s5, v4
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s6, v3
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s5
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    v_writelane_b32 v5, s4, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v6, s6, m0
; GFX802-GISEL-NEXT:    flat_store_dwordx2 v[0:1], v[5:6]
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-GISEL-LABEL: test_readlane_v2f32:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-GISEL-NEXT:    global_load_dwordx2 v[5:6], v[0:1], off
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s5, v4
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s6, v3
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v5, s4, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v6, s6, s5
; GFX1010-GISEL-NEXT:    global_store_dwordx2 v[0:1], v[5:6], off
; GFX1010-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-GISEL-LABEL: test_readlane_v2f32:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-GISEL-NEXT:    global_load_b64 v[5:6], v[0:1], off
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s0, v2
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s1, v4
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v5, s0, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v6, s2, s1
; GFX1100-GISEL-NEXT:    global_store_b64 v[0:1], v[5:6], off
; GFX1100-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %oldval = load <2 x float>, ptr addrspace(1) %out
  %writelane = call <2 x float> @llvm.amdgcn.writelane.v2f32(<2 x float> %src, i32 %src1, <2 x float> %oldval)
  store <2 x float> %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define void @test_writelane_v7i32(ptr addrspace(1) %out, <7 x i32> %src, i32 %src1) {
; GFX802-SDAG-LABEL: test_writelane_v7i32:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_add_u32_e32 v17, vcc, 16, v0
; GFX802-SDAG-NEXT:    flat_load_dwordx4 v[10:13], v[0:1]
; GFX802-SDAG-NEXT:    v_addc_u32_e32 v18, vcc, 0, v1, vcc
; GFX802-SDAG-NEXT:    flat_load_dwordx3 v[14:16], v[17:18]
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s4, v9
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s8, v5
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s9, v4
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s10, v3
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s11, v2
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s4
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s5, v8
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s6, v7
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s7, v6
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(1)
; GFX802-SDAG-NEXT:    v_writelane_b32 v13, s8, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v12, s9, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v11, s10, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v10, s11, m0
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    v_writelane_b32 v16, s5, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v15, s6, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v14, s7, m0
; GFX802-SDAG-NEXT:    flat_store_dwordx4 v[0:1], v[10:13]
; GFX802-SDAG-NEXT:    flat_store_dwordx3 v[17:18], v[14:16]
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-SDAG-LABEL: test_writelane_v7i32:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-SDAG-NEXT:    s_clause 0x1
; GFX1010-SDAG-NEXT:    global_load_dwordx3 v[14:16], v[0:1], off offset:16
; GFX1010-SDAG-NEXT:    global_load_dwordx4 v[10:13], v[0:1], off
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s5, v9
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s8, v5
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s9, v4
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s10, v3
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s11, v2
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s4, v8
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s6, v7
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s7, v6
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(1)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v16, s4, s5
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v13, s8, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v12, s9, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v11, s10, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v10, s11, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v15, s6, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v14, s7, s5
; GFX1010-SDAG-NEXT:    global_store_dwordx4 v[0:1], v[10:13], off
; GFX1010-SDAG-NEXT:    global_store_dwordx3 v[0:1], v[14:16], off offset:16
; GFX1010-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-SDAG-LABEL: test_writelane_v7i32:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-SDAG-NEXT:    s_clause 0x1
; GFX1100-SDAG-NEXT:    global_load_b96 v[14:16], v[0:1], off offset:16
; GFX1100-SDAG-NEXT:    global_load_b128 v[10:13], v[0:1], off
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s1, v9
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s4, v5
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s5, v4
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s6, v3
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s7, v2
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s0, v8
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s2, v7
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s3, v6
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(1)
; GFX1100-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v16, s0, s1
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v13, s4, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v12, s5, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v11, s6, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v10, s7, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v15, s2, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v14, s3, s1
; GFX1100-SDAG-NEXT:    s_clause 0x1
; GFX1100-SDAG-NEXT:    global_store_b128 v[0:1], v[10:13], off
; GFX1100-SDAG-NEXT:    global_store_b96 v[0:1], v[14:16], off offset:16
; GFX1100-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX802-GISEL-LABEL: test_writelane_v7i32:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_add_u32_e32 v18, vcc, 16, v0
; GFX802-GISEL-NEXT:    flat_load_dwordx4 v[10:13], v[0:1]
; GFX802-GISEL-NEXT:    v_addc_u32_e32 v19, vcc, 0, v1, vcc
; GFX802-GISEL-NEXT:    flat_load_dwordx4 v[14:17], v[18:19]
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s5, v9
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s6, v3
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s7, v4
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s8, v5
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s5
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s9, v6
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s10, v7
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s11, v8
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(1)
; GFX802-GISEL-NEXT:    v_writelane_b32 v10, s4, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v11, s6, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v12, s7, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v13, s8, m0
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    v_writelane_b32 v14, s9, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v15, s10, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v16, s11, m0
; GFX802-GISEL-NEXT:    flat_store_dwordx4 v[0:1], v[10:13]
; GFX802-GISEL-NEXT:    flat_store_dwordx3 v[18:19], v[14:16]
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-GISEL-LABEL: test_writelane_v7i32:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-GISEL-NEXT:    s_clause 0x1
; GFX1010-GISEL-NEXT:    global_load_dwordx4 v[10:13], v[0:1], off
; GFX1010-GISEL-NEXT:    global_load_dwordx4 v[14:17], v[0:1], off offset:16
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s5, v9
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s6, v3
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s7, v4
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s8, v5
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s9, v6
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s10, v7
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s11, v8
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(1)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v10, s4, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v11, s6, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v12, s7, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v13, s8, s5
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v14, s9, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v15, s10, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v16, s11, s5
; GFX1010-GISEL-NEXT:    global_store_dwordx4 v[0:1], v[10:13], off
; GFX1010-GISEL-NEXT:    global_store_dwordx3 v[0:1], v[14:16], off offset:16
; GFX1010-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-GISEL-LABEL: test_writelane_v7i32:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-GISEL-NEXT:    s_clause 0x1
; GFX1100-GISEL-NEXT:    global_load_b128 v[10:13], v[0:1], off
; GFX1100-GISEL-NEXT:    global_load_b128 v[14:17], v[0:1], off offset:16
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s0, v2
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s1, v9
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s4, v5
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s5, v6
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s6, v7
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s7, v8
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(1)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v10, s0, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v11, s2, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v12, s3, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v13, s4, s1
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v14, s5, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v15, s6, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v16, s7, s1
; GFX1100-GISEL-NEXT:    s_clause 0x1
; GFX1100-GISEL-NEXT:    global_store_b128 v[0:1], v[10:13], off
; GFX1100-GISEL-NEXT:    global_store_b96 v[0:1], v[14:16], off offset:16
; GFX1100-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %oldval = load <7 x i32>, ptr addrspace(1) %out
  %writelane = call <7 x i32> @llvm.amdgcn.writelane.v7i32(<7 x i32> %src, i32 %src1, <7 x i32> %oldval)
  store <7 x i32> %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define void @test_writelane_v8i16(ptr addrspace(1) %out, <8 x i16> %src, i32 %src1) {
; GFX802-SDAG-LABEL: test_writelane_v8i16:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-SDAG-NEXT:    flat_load_dwordx4 v[7:10], v[0:1]
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s4, v6
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s5, v5
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s6, v4
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s7, v3
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s8, v2
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s4
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    v_writelane_b32 v10, s5, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v9, s6, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v8, s7, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v7, s8, m0
; GFX802-SDAG-NEXT:    flat_store_dwordx4 v[0:1], v[7:10]
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-SDAG-LABEL: test_writelane_v8i16:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-SDAG-NEXT:    global_load_dwordx4 v[7:10], v[0:1], off
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s4, v5
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s5, v6
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s6, v4
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s7, v3
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s8, v2
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v10, s4, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v9, s6, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v8, s7, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v7, s8, s5
; GFX1010-SDAG-NEXT:    global_store_dwordx4 v[0:1], v[7:10], off
; GFX1010-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-SDAG-LABEL: test_writelane_v8i16:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-SDAG-NEXT:    global_load_b128 v[7:10], v[0:1], off
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s0, v5
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s1, v6
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s2, v4
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s4, v2
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v10, s0, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v9, s2, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v8, s3, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v7, s4, s1
; GFX1100-SDAG-NEXT:    global_store_b128 v[0:1], v[7:10], off
; GFX1100-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX802-GISEL-LABEL: test_writelane_v8i16:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-GISEL-NEXT:    flat_load_dwordx4 v[7:10], v[0:1]
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s5, v6
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s6, v3
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s7, v4
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s8, v5
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s5
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    v_writelane_b32 v7, s4, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v8, s6, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v9, s7, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v10, s8, m0
; GFX802-GISEL-NEXT:    flat_store_dwordx4 v[0:1], v[7:10]
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-GISEL-LABEL: test_writelane_v8i16:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-GISEL-NEXT:    global_load_dwordx4 v[7:10], v[0:1], off
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s5, v6
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s6, v3
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s7, v4
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s8, v5
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v7, s4, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v8, s6, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v9, s7, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v10, s8, s5
; GFX1010-GISEL-NEXT:    global_store_dwordx4 v[0:1], v[7:10], off
; GFX1010-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-GISEL-LABEL: test_writelane_v8i16:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-GISEL-NEXT:    global_load_b128 v[7:10], v[0:1], off
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s0, v2
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s1, v6
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s4, v5
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v7, s0, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v8, s2, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v9, s3, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v10, s4, s1
; GFX1100-GISEL-NEXT:    global_store_b128 v[0:1], v[7:10], off
; GFX1100-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %oldval = load <8 x i16>, ptr addrspace(1) %out
  %writelane = call <8 x i16> @llvm.amdgcn.writelane.v8i16(<8 x i16> %src, i32 %src1, <8 x i16> %oldval)
  store <8 x i16> %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define void @test_writelane_v2i64(ptr addrspace(1) %out, <2 x i64> %src, i32 %src1) {
; GFX802-SDAG-LABEL: test_writelane_v2i64:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-SDAG-NEXT:    flat_load_dwordx4 v[7:10], v[0:1]
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s4, v6
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s5, v5
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s6, v4
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s7, v3
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s8, v2
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s4
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    v_writelane_b32 v10, s5, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v9, s6, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v8, s7, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v7, s8, m0
; GFX802-SDAG-NEXT:    flat_store_dwordx4 v[0:1], v[7:10]
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-SDAG-LABEL: test_writelane_v2i64:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-SDAG-NEXT:    global_load_dwordx4 v[7:10], v[0:1], off
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s4, v5
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s5, v6
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s6, v4
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s7, v3
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s8, v2
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v10, s4, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v9, s6, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v8, s7, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v7, s8, s5
; GFX1010-SDAG-NEXT:    global_store_dwordx4 v[0:1], v[7:10], off
; GFX1010-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-SDAG-LABEL: test_writelane_v2i64:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-SDAG-NEXT:    global_load_b128 v[7:10], v[0:1], off
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s0, v5
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s1, v6
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s2, v4
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s3, v3
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s4, v2
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v10, s0, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v9, s2, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v8, s3, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v7, s4, s1
; GFX1100-SDAG-NEXT:    global_store_b128 v[0:1], v[7:10], off
; GFX1100-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX802-GISEL-LABEL: test_writelane_v2i64:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-GISEL-NEXT:    flat_load_dwordx4 v[7:10], v[0:1]
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s5, v6
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s6, v3
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s7, v4
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s8, v5
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s5
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    v_writelane_b32 v7, s4, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v8, s6, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v9, s7, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v10, s8, m0
; GFX802-GISEL-NEXT:    flat_store_dwordx4 v[0:1], v[7:10]
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-GISEL-LABEL: test_writelane_v2i64:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-GISEL-NEXT:    global_load_dwordx4 v[7:10], v[0:1], off
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s5, v6
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s6, v3
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s7, v4
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s8, v5
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v7, s4, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v8, s6, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v9, s7, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v10, s8, s5
; GFX1010-GISEL-NEXT:    global_store_dwordx4 v[0:1], v[7:10], off
; GFX1010-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-GISEL-LABEL: test_writelane_v2i64:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-GISEL-NEXT:    global_load_b128 v[7:10], v[0:1], off
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s0, v2
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s1, v6
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s4, v5
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v7, s0, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v8, s2, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v9, s3, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v10, s4, s1
; GFX1100-GISEL-NEXT:    global_store_b128 v[0:1], v[7:10], off
; GFX1100-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %oldval = load <2 x i64>, ptr addrspace(1) %out
  %writelane = call <2 x i64> @llvm.amdgcn.writelane.v2i64(<2 x i64> %src, i32 %src1, <2 x i64> %oldval)
  store <2 x i64> %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define void @test_writelane_v3i64(ptr addrspace(1) %out, <3 x i64> %src, i32 %src1) {
; GFX802-SDAG-LABEL: test_writelane_v3i64:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_add_u32_e32 v13, vcc, 16, v0
; GFX802-SDAG-NEXT:    flat_load_dwordx4 v[9:12], v[0:1]
; GFX802-SDAG-NEXT:    v_addc_u32_e32 v14, vcc, 0, v1, vcc
; GFX802-SDAG-NEXT:    flat_load_dwordx2 v[15:16], v[13:14]
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s4, v8
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s7, v5
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s8, v4
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s9, v3
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s10, v2
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s4
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s5, v7
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s6, v6
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(1)
; GFX802-SDAG-NEXT:    v_writelane_b32 v12, s7, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v11, s8, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v10, s9, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v9, s10, m0
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    v_writelane_b32 v16, s5, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v15, s6, m0
; GFX802-SDAG-NEXT:    flat_store_dwordx4 v[0:1], v[9:12]
; GFX802-SDAG-NEXT:    flat_store_dwordx2 v[13:14], v[15:16]
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-SDAG-LABEL: test_writelane_v3i64:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-SDAG-NEXT:    s_clause 0x1
; GFX1010-SDAG-NEXT:    global_load_dwordx2 v[13:14], v[0:1], off offset:16
; GFX1010-SDAG-NEXT:    global_load_dwordx4 v[9:12], v[0:1], off
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s5, v8
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s7, v5
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s8, v4
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s9, v3
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s10, v2
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s6, v6
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(1)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v14, s4, s5
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v12, s7, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v11, s8, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v10, s9, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v9, s10, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v13, s6, s5
; GFX1010-SDAG-NEXT:    global_store_dwordx4 v[0:1], v[9:12], off
; GFX1010-SDAG-NEXT:    global_store_dwordx2 v[0:1], v[13:14], off offset:16
; GFX1010-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-SDAG-LABEL: test_writelane_v3i64:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-SDAG-NEXT:    s_clause 0x1
; GFX1100-SDAG-NEXT:    global_load_b64 v[13:14], v[0:1], off offset:16
; GFX1100-SDAG-NEXT:    global_load_b128 v[9:12], v[0:1], off
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s1, v8
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s3, v5
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s4, v4
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s5, v3
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s6, v2
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s0, v7
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s2, v6
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(1)
; GFX1100-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v14, s0, s1
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v12, s3, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v11, s4, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v10, s5, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v9, s6, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v13, s2, s1
; GFX1100-SDAG-NEXT:    s_clause 0x1
; GFX1100-SDAG-NEXT:    global_store_b128 v[0:1], v[9:12], off
; GFX1100-SDAG-NEXT:    global_store_b64 v[0:1], v[13:14], off offset:16
; GFX1100-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX802-GISEL-LABEL: test_writelane_v3i64:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_add_u32_e32 v17, vcc, 16, v0
; GFX802-GISEL-NEXT:    v_addc_u32_e32 v18, vcc, 0, v1, vcc
; GFX802-GISEL-NEXT:    flat_load_dwordx4 v[9:12], v[0:1]
; GFX802-GISEL-NEXT:    flat_load_dwordx4 v[13:16], v[17:18]
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s5, v8
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s6, v3
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s7, v4
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s8, v5
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s9, v6
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s10, v7
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s5
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(1)
; GFX802-GISEL-NEXT:    v_writelane_b32 v9, s4, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v10, s6, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v11, s7, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v12, s8, m0
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    v_writelane_b32 v13, s9, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v14, s10, m0
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v2, v13
; GFX802-GISEL-NEXT:    v_mov_b32_e32 v3, v14
; GFX802-GISEL-NEXT:    flat_store_dwordx4 v[0:1], v[9:12]
; GFX802-GISEL-NEXT:    flat_store_dwordx2 v[17:18], v[2:3]
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-GISEL-LABEL: test_writelane_v3i64:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-GISEL-NEXT:    s_clause 0x1
; GFX1010-GISEL-NEXT:    global_load_dwordx4 v[9:12], v[0:1], off
; GFX1010-GISEL-NEXT:    global_load_dwordx4 v[13:16], v[0:1], off offset:16
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s5, v8
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s7, v6
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s8, v7
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s6, v3
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s9, v4
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s10, v5
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(1)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v9, s4, s5
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v13, s7, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v14, s8, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v10, s6, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v11, s9, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v12, s10, s5
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v2, v13
; GFX1010-GISEL-NEXT:    v_mov_b32_e32 v3, v14
; GFX1010-GISEL-NEXT:    global_store_dwordx4 v[0:1], v[9:12], off
; GFX1010-GISEL-NEXT:    global_store_dwordx2 v[0:1], v[2:3], off offset:16
; GFX1010-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-GISEL-LABEL: test_writelane_v3i64:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-GISEL-NEXT:    s_clause 0x1
; GFX1100-GISEL-NEXT:    global_load_b128 v[9:12], v[0:1], off
; GFX1100-GISEL-NEXT:    global_load_b128 v[13:16], v[0:1], off offset:16
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s1, v8
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s3, v6
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s4, v7
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s0, v2
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s5, v4
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s6, v5
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(1)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v9, s0, s1
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v13, s3, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v14, s4, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v10, s2, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v11, s5, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v12, s6, s1
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v2, v13
; GFX1100-GISEL-NEXT:    v_mov_b32_e32 v3, v14
; GFX1100-GISEL-NEXT:    s_clause 0x1
; GFX1100-GISEL-NEXT:    global_store_b128 v[0:1], v[9:12], off
; GFX1100-GISEL-NEXT:    global_store_b64 v[0:1], v[2:3], off offset:16
; GFX1100-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %oldval = load <3 x i64>, ptr addrspace(1) %out
  %writelane = call <3 x i64> @llvm.amdgcn.writelane.v2i64(<3 x i64> %src, i32 %src1, <3 x i64> %oldval)
  store <3 x i64> %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define void @test_writelane_v4f64(ptr addrspace(1) %out, <4 x double> %src, i32 %src1) {
; GFX802-SDAG-LABEL: test_writelane_v4f64:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_add_u32_e32 v19, vcc, 16, v0
; GFX802-SDAG-NEXT:    flat_load_dwordx4 v[11:14], v[0:1]
; GFX802-SDAG-NEXT:    v_addc_u32_e32 v20, vcc, 0, v1, vcc
; GFX802-SDAG-NEXT:    flat_load_dwordx4 v[15:18], v[19:20]
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s4, v10
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s9, v5
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s10, v4
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s11, v3
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s12, v2
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s4
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s5, v9
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s6, v8
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s7, v7
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s8, v6
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(1)
; GFX802-SDAG-NEXT:    v_writelane_b32 v14, s9, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v13, s10, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v12, s11, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v11, s12, m0
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    v_writelane_b32 v18, s5, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v17, s6, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v16, s7, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v15, s8, m0
; GFX802-SDAG-NEXT:    flat_store_dwordx4 v[0:1], v[11:14]
; GFX802-SDAG-NEXT:    flat_store_dwordx4 v[19:20], v[15:18]
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-SDAG-LABEL: test_writelane_v4f64:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-SDAG-NEXT:    s_clause 0x1
; GFX1010-SDAG-NEXT:    global_load_dwordx4 v[11:14], v[0:1], off offset:16
; GFX1010-SDAG-NEXT:    global_load_dwordx4 v[15:18], v[0:1], off
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s5, v10
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s9, v5
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s10, v4
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s11, v3
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s12, v2
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s4, v9
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s6, v8
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s7, v7
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s8, v6
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(1)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v14, s4, s5
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v18, s9, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v17, s10, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v16, s11, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v15, s12, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v13, s6, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v12, s7, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v11, s8, s5
; GFX1010-SDAG-NEXT:    global_store_dwordx4 v[0:1], v[15:18], off
; GFX1010-SDAG-NEXT:    global_store_dwordx4 v[0:1], v[11:14], off offset:16
; GFX1010-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-SDAG-LABEL: test_writelane_v4f64:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-SDAG-NEXT:    s_clause 0x1
; GFX1100-SDAG-NEXT:    global_load_b128 v[11:14], v[0:1], off offset:16
; GFX1100-SDAG-NEXT:    global_load_b128 v[15:18], v[0:1], off
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s1, v10
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s5, v5
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s6, v4
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s7, v3
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s8, v2
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s0, v9
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s2, v8
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s3, v7
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s4, v6
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(1)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v14, s0, s1
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v18, s5, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v17, s6, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v16, s7, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v15, s8, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v13, s2, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v12, s3, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v11, s4, s1
; GFX1100-SDAG-NEXT:    s_clause 0x1
; GFX1100-SDAG-NEXT:    global_store_b128 v[0:1], v[15:18], off
; GFX1100-SDAG-NEXT:    global_store_b128 v[0:1], v[11:14], off offset:16
; GFX1100-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX802-GISEL-LABEL: test_writelane_v4f64:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_add_u32_e32 v19, vcc, 16, v0
; GFX802-GISEL-NEXT:    flat_load_dwordx4 v[11:14], v[0:1]
; GFX802-GISEL-NEXT:    v_addc_u32_e32 v20, vcc, 0, v1, vcc
; GFX802-GISEL-NEXT:    flat_load_dwordx4 v[15:18], v[19:20]
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s5, v10
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s6, v3
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s7, v4
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s8, v5
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s5
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s9, v6
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s10, v7
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s11, v8
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s12, v9
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(1)
; GFX802-GISEL-NEXT:    v_writelane_b32 v11, s4, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v12, s6, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v13, s7, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v14, s8, m0
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    v_writelane_b32 v15, s9, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v16, s10, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v17, s11, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v18, s12, m0
; GFX802-GISEL-NEXT:    flat_store_dwordx4 v[0:1], v[11:14]
; GFX802-GISEL-NEXT:    flat_store_dwordx4 v[19:20], v[15:18]
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-GISEL-LABEL: test_writelane_v4f64:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-GISEL-NEXT:    s_clause 0x1
; GFX1010-GISEL-NEXT:    global_load_dwordx4 v[11:14], v[0:1], off
; GFX1010-GISEL-NEXT:    global_load_dwordx4 v[15:18], v[0:1], off offset:16
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s5, v10
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s6, v3
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s7, v4
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s8, v5
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s9, v6
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s10, v7
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s11, v8
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s12, v9
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(1)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v11, s4, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v12, s6, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v13, s7, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v14, s8, s5
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v15, s9, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v16, s10, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v17, s11, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v18, s12, s5
; GFX1010-GISEL-NEXT:    global_store_dwordx4 v[0:1], v[11:14], off
; GFX1010-GISEL-NEXT:    global_store_dwordx4 v[0:1], v[15:18], off offset:16
; GFX1010-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-GISEL-LABEL: test_writelane_v4f64:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-GISEL-NEXT:    s_clause 0x1
; GFX1100-GISEL-NEXT:    global_load_b128 v[11:14], v[0:1], off
; GFX1100-GISEL-NEXT:    global_load_b128 v[15:18], v[0:1], off offset:16
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s0, v2
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s1, v10
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s4, v5
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s5, v6
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s6, v7
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s7, v8
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s8, v9
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(1)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v11, s0, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v12, s2, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v13, s3, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v14, s4, s1
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v15, s5, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v16, s6, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v17, s7, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v18, s8, s1
; GFX1100-GISEL-NEXT:    s_clause 0x1
; GFX1100-GISEL-NEXT:    global_store_b128 v[0:1], v[11:14], off
; GFX1100-GISEL-NEXT:    global_store_b128 v[0:1], v[15:18], off offset:16
; GFX1100-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %oldval = load <4 x double>, ptr addrspace(1) %out
  %writelane = call <4 x double> @llvm.amdgcn.writelane.v4f64(<4 x double> %src, i32 %src1, <4 x double> %oldval)
  store <4 x double> %writelane, ptr addrspace(1) %out, align 4
  ret void
}

define void @test_writelane_v8f64(ptr addrspace(1) %out, <8 x double> %src, i32 %src1) {
; GFX802-SDAG-LABEL: test_writelane_v8f64:
; GFX802-SDAG:       ; %bb.0:
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s4, v18
; GFX802-SDAG-NEXT:    flat_load_dwordx4 v[18:21], v[0:1]
; GFX802-SDAG-NEXT:    v_add_u32_e32 v22, vcc, 16, v0
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s5, v5
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s6, v4
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s7, v3
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s8, v2
; GFX802-SDAG-NEXT:    v_addc_u32_e32 v23, vcc, 0, v1, vcc
; GFX802-SDAG-NEXT:    s_mov_b32 m0, s4
; GFX802-SDAG-NEXT:    flat_load_dwordx4 v[2:5], v[22:23]
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s4, v9
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s10, v15
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s11, v14
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s12, v13
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s13, v12
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s14, v11
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s15, v10
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s9, v16
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(1)
; GFX802-SDAG-NEXT:    v_writelane_b32 v21, s5, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v20, s6, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v19, s7, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v18, s8, m0
; GFX802-SDAG-NEXT:    flat_store_dwordx4 v[0:1], v[18:21]
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s5, v8
; GFX802-SDAG-NEXT:    v_add_u32_e32 v18, vcc, 32, v0
; GFX802-SDAG-NEXT:    v_addc_u32_e32 v19, vcc, 0, v1, vcc
; GFX802-SDAG-NEXT:    v_add_u32_e32 v0, vcc, 48, v0
; GFX802-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s6, v7
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s7, v6
; GFX802-SDAG-NEXT:    flat_load_dwordx4 v[6:9], v[0:1]
; GFX802-SDAG-NEXT:    flat_load_dwordx4 v[12:15], v[18:19]
; GFX802-SDAG-NEXT:    v_readfirstlane_b32 s8, v17
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(3)
; GFX802-SDAG-NEXT:    v_writelane_b32 v5, s4, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v4, s5, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v3, s6, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v2, s7, m0
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(1)
; GFX802-SDAG-NEXT:    v_writelane_b32 v9, s8, m0
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    v_writelane_b32 v15, s12, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v14, s13, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v13, s14, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v12, s15, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v8, s9, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v7, s10, m0
; GFX802-SDAG-NEXT:    v_writelane_b32 v6, s11, m0
; GFX802-SDAG-NEXT:    flat_store_dwordx4 v[18:19], v[12:15]
; GFX802-SDAG-NEXT:    flat_store_dwordx4 v[0:1], v[6:9]
; GFX802-SDAG-NEXT:    flat_store_dwordx4 v[22:23], v[2:5]
; GFX802-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX802-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-SDAG-LABEL: test_writelane_v8f64:
; GFX1010-SDAG:       ; %bb.0:
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-SDAG-NEXT:    s_clause 0x3
; GFX1010-SDAG-NEXT:    global_load_dwordx4 v[19:22], v[0:1], off offset:16
; GFX1010-SDAG-NEXT:    global_load_dwordx4 v[23:26], v[0:1], off
; GFX1010-SDAG-NEXT:    global_load_dwordx4 v[27:30], v[0:1], off offset:48
; GFX1010-SDAG-NEXT:    global_load_dwordx4 v[31:34], v[0:1], off offset:32
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s5, v18
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s17, v13
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s18, v12
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s19, v11
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s20, v10
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s13, v17
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s14, v16
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s15, v15
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s16, v14
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s9, v5
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s10, v4
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s11, v3
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s12, v2
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s4, v9
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s6, v8
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s7, v7
; GFX1010-SDAG-NEXT:    v_readfirstlane_b32 s8, v6
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(3)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v22, s4, s5
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(2)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v26, s9, s5
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(1)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v30, s13, s5
; GFX1010-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-SDAG-NEXT:    v_writelane_b32 v34, s17, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v33, s18, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v32, s19, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v31, s20, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v29, s14, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v28, s15, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v27, s16, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v25, s10, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v24, s11, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v23, s12, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v21, s6, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v20, s7, s5
; GFX1010-SDAG-NEXT:    v_writelane_b32 v19, s8, s5
; GFX1010-SDAG-NEXT:    global_store_dwordx4 v[0:1], v[31:34], off offset:32
; GFX1010-SDAG-NEXT:    global_store_dwordx4 v[0:1], v[27:30], off offset:48
; GFX1010-SDAG-NEXT:    global_store_dwordx4 v[0:1], v[23:26], off
; GFX1010-SDAG-NEXT:    global_store_dwordx4 v[0:1], v[19:22], off offset:16
; GFX1010-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-SDAG-LABEL: test_writelane_v8f64:
; GFX1100-SDAG:       ; %bb.0:
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-SDAG-NEXT:    s_clause 0x3
; GFX1100-SDAG-NEXT:    global_load_b128 v[19:22], v[0:1], off offset:16
; GFX1100-SDAG-NEXT:    global_load_b128 v[23:26], v[0:1], off
; GFX1100-SDAG-NEXT:    global_load_b128 v[27:30], v[0:1], off offset:48
; GFX1100-SDAG-NEXT:    global_load_b128 v[31:34], v[0:1], off offset:32
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s1, v18
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s13, v13
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s14, v12
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s15, v11
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s16, v10
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s9, v17
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s10, v16
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s11, v15
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s12, v14
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s5, v5
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s6, v4
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s7, v3
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s8, v2
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s0, v9
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s2, v8
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s3, v7
; GFX1100-SDAG-NEXT:    v_readfirstlane_b32 s4, v6
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(3)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v22, s0, s1
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(2)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v26, s5, s1
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(1)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v30, s9, s1
; GFX1100-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-SDAG-NEXT:    v_writelane_b32 v34, s13, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v33, s14, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v32, s15, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v31, s16, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v29, s10, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v28, s11, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v27, s12, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v25, s6, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v24, s7, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v23, s8, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v21, s2, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v20, s3, s1
; GFX1100-SDAG-NEXT:    v_writelane_b32 v19, s4, s1
; GFX1100-SDAG-NEXT:    s_clause 0x3
; GFX1100-SDAG-NEXT:    global_store_b128 v[0:1], v[31:34], off offset:32
; GFX1100-SDAG-NEXT:    global_store_b128 v[0:1], v[27:30], off offset:48
; GFX1100-SDAG-NEXT:    global_store_b128 v[0:1], v[23:26], off
; GFX1100-SDAG-NEXT:    global_store_b128 v[0:1], v[19:22], off offset:16
; GFX1100-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX802-GISEL-LABEL: test_writelane_v8f64:
; GFX802-GISEL:       ; %bb.0:
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s5, v18
; GFX802-GISEL-NEXT:    flat_load_dwordx4 v[18:21], v[0:1]
; GFX802-GISEL-NEXT:    v_add_u32_e32 v22, vcc, 16, v0
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s6, v3
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s7, v4
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s8, v5
; GFX802-GISEL-NEXT:    v_addc_u32_e32 v23, vcc, 0, v1, vcc
; GFX802-GISEL-NEXT:    s_mov_b32 m0, s5
; GFX802-GISEL-NEXT:    flat_load_dwordx4 v[2:5], v[22:23]
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s5, v7
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s9, v11
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s10, v12
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s11, v13
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s12, v14
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s13, v15
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s14, v16
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s15, v17
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(1)
; GFX802-GISEL-NEXT:    v_writelane_b32 v18, s4, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v19, s6, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v20, s7, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v21, s8, m0
; GFX802-GISEL-NEXT:    flat_store_dwordx4 v[0:1], v[18:21]
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s4, v6
; GFX802-GISEL-NEXT:    v_add_u32_e32 v18, vcc, 32, v0
; GFX802-GISEL-NEXT:    v_addc_u32_e32 v19, vcc, 0, v1, vcc
; GFX802-GISEL-NEXT:    v_add_u32_e32 v0, vcc, 48, v0
; GFX802-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s6, v8
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s7, v9
; GFX802-GISEL-NEXT:    v_readfirstlane_b32 s8, v10
; GFX802-GISEL-NEXT:    flat_load_dwordx4 v[6:9], v[18:19]
; GFX802-GISEL-NEXT:    flat_load_dwordx4 v[10:13], v[0:1]
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(3)
; GFX802-GISEL-NEXT:    v_writelane_b32 v2, s4, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v3, s5, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v4, s6, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v5, s7, m0
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(1)
; GFX802-GISEL-NEXT:    v_writelane_b32 v6, s8, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v7, s9, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v8, s10, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v9, s11, m0
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    v_writelane_b32 v10, s12, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v11, s13, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v12, s14, m0
; GFX802-GISEL-NEXT:    v_writelane_b32 v13, s15, m0
; GFX802-GISEL-NEXT:    flat_store_dwordx4 v[22:23], v[2:5]
; GFX802-GISEL-NEXT:    flat_store_dwordx4 v[18:19], v[6:9]
; GFX802-GISEL-NEXT:    flat_store_dwordx4 v[0:1], v[10:13]
; GFX802-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX802-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1010-GISEL-LABEL: test_writelane_v8f64:
; GFX1010-GISEL:       ; %bb.0:
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1010-GISEL-NEXT:    s_clause 0x3
; GFX1010-GISEL-NEXT:    global_load_dwordx4 v[19:22], v[0:1], off
; GFX1010-GISEL-NEXT:    global_load_dwordx4 v[23:26], v[0:1], off offset:16
; GFX1010-GISEL-NEXT:    global_load_dwordx4 v[27:30], v[0:1], off offset:32
; GFX1010-GISEL-NEXT:    global_load_dwordx4 v[31:34], v[0:1], off offset:48
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s4, v2
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s5, v18
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s6, v3
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s7, v4
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s8, v5
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s9, v6
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s10, v7
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s11, v8
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s12, v9
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s13, v10
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s14, v11
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s15, v12
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s16, v13
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s17, v14
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s18, v15
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s19, v16
; GFX1010-GISEL-NEXT:    v_readfirstlane_b32 s20, v17
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(3)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v19, s4, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v20, s6, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v21, s7, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v22, s8, s5
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(2)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v23, s9, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v24, s10, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v25, s11, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v26, s12, s5
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(1)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v27, s13, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v28, s14, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v29, s15, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v30, s16, s5
; GFX1010-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1010-GISEL-NEXT:    v_writelane_b32 v31, s17, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v32, s18, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v33, s19, s5
; GFX1010-GISEL-NEXT:    v_writelane_b32 v34, s20, s5
; GFX1010-GISEL-NEXT:    global_store_dwordx4 v[0:1], v[19:22], off
; GFX1010-GISEL-NEXT:    global_store_dwordx4 v[0:1], v[23:26], off offset:16
; GFX1010-GISEL-NEXT:    global_store_dwordx4 v[0:1], v[27:30], off offset:32
; GFX1010-GISEL-NEXT:    global_store_dwordx4 v[0:1], v[31:34], off offset:48
; GFX1010-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX1100-GISEL-LABEL: test_writelane_v8f64:
; GFX1100-GISEL:       ; %bb.0:
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX1100-GISEL-NEXT:    s_clause 0x3
; GFX1100-GISEL-NEXT:    global_load_b128 v[19:22], v[0:1], off
; GFX1100-GISEL-NEXT:    global_load_b128 v[23:26], v[0:1], off offset:16
; GFX1100-GISEL-NEXT:    global_load_b128 v[27:30], v[0:1], off offset:32
; GFX1100-GISEL-NEXT:    global_load_b128 v[31:34], v[0:1], off offset:48
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s0, v2
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s1, v18
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s2, v3
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s3, v4
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s4, v5
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s5, v6
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s6, v7
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s7, v8
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s8, v9
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s9, v10
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s10, v11
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s11, v12
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s12, v13
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s13, v14
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s14, v15
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s15, v16
; GFX1100-GISEL-NEXT:    v_readfirstlane_b32 s16, v17
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(3)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v19, s0, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v20, s2, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v21, s3, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v22, s4, s1
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(2)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v23, s5, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v24, s6, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v25, s7, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v26, s8, s1
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(1)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v27, s9, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v28, s10, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v29, s11, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v30, s12, s1
; GFX1100-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX1100-GISEL-NEXT:    v_writelane_b32 v31, s13, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v32, s14, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v33, s15, s1
; GFX1100-GISEL-NEXT:    v_writelane_b32 v34, s16, s1
; GFX1100-GISEL-NEXT:    s_clause 0x3
; GFX1100-GISEL-NEXT:    global_store_b128 v[0:1], v[19:22], off
; GFX1100-GISEL-NEXT:    global_store_b128 v[0:1], v[23:26], off offset:16
; GFX1100-GISEL-NEXT:    global_store_b128 v[0:1], v[27:30], off offset:32
; GFX1100-GISEL-NEXT:    global_store_b128 v[0:1], v[31:34], off offset:48
; GFX1100-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %oldval = load <8 x double>, ptr addrspace(1) %out
  %writelane = call <8 x double> @llvm.amdgcn.writelane.v8f64(<8 x double> %src, i32 %src1, <8 x double> %oldval)
  store <8 x double> %writelane, ptr addrspace(1) %out, align 4
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x() #2

attributes #0 = { nounwind readnone convergent }
attributes #1 = { nounwind }
attributes #2 = { nounwind readnone }
